/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.knopflerfish.framework.BundleCapabilityImpl;

public class Capabilities {
    private HashMap<String, ArrayList<BundleCapabilityImpl>> namespaceCapabilties = new HashMap();

    List<BundleCapabilityImpl> getCapabilities(String namespace) {
        return this.namespaceCapabilties.get(namespace);
    }

    void addCapabilities(Map<String, List<BundleCapabilityImpl>> capabilities) {
        for (Map.Entry<String, List<BundleCapabilityImpl>> e : capabilities.entrySet()) {
            String ns = e.getKey();
            ArrayList<BundleCapabilityImpl> bcl = this.namespaceCapabilties.get(ns);
            if (bcl == null) {
                bcl = new ArrayList();
                this.namespaceCapabilties.put(ns, bcl);
            }
            bcl.addAll((Collection<BundleCapabilityImpl>)e.getValue());
        }
    }

    void removeCapabilities(Map<String, List<BundleCapabilityImpl>> capabilities) {
        for (Map.Entry<String, List<BundleCapabilityImpl>> e : capabilities.entrySet()) {
            String ns = e.getKey();
            ArrayList<BundleCapabilityImpl> bcl = this.namespaceCapabilties.get(ns);
            if (bcl != null) {
                int before = bcl.size();
                bcl.removeAll((Collection)e.getValue());
                if (bcl.isEmpty()) {
                    this.namespaceCapabilties.remove(ns);
                }
                if (before == bcl.size() + e.getValue().size()) continue;
                throw new RuntimeException("Internal error, tried to remove unknown capabilities");
            }
            throw new RuntimeException("Internal error, tried to remove unknown name space with capabilities");
        }
    }

    Collection<ArrayList<BundleCapabilityImpl>> getAll() {
        return this.namespaceCapabilties.values();
    }
}

