/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider.sources.process;

import org.gradle.api.Action;
import org.gradle.api.internal.provider.sources.process.ExecSpecFactory;
import org.gradle.api.internal.provider.sources.process.ProcessOutputValueSource;
import org.gradle.api.internal.provider.sources.process.ProviderCompatibleBaseExecSpec;
import org.gradle.api.internal.provider.sources.process.ProviderCompatibleExecSpec;
import org.gradle.api.internal.provider.sources.process.ProviderCompatibleJavaExecSpec;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;

@ServiceScope(value={Scope.Build.class})
public class ProcessOutputProviderFactory {
    private final Instantiator instantiator;
    private final ExecSpecFactory execSpecFactory;

    public ProcessOutputProviderFactory(Instantiator instantiator, ExecSpecFactory execSpecFactory) {
        this.instantiator = instantiator;
        this.execSpecFactory = execSpecFactory;
    }

    public void configureParametersForExec(ProcessOutputValueSource.Parameters parameters, Action<? super ExecSpec> action) {
        this.configureParameters(parameters, (ProviderCompatibleExecSpec)this.instantiator.newInstance(ProviderCompatibleExecSpec.class, new Object[]{this.execSpecFactory.newExecSpec()}), action);
    }

    public void configureParametersForJavaExec(ProcessOutputValueSource.Parameters parameters, Action<? super JavaExecSpec> action) {
        this.configureParameters(parameters, (ProviderCompatibleJavaExecSpec)this.instantiator.newInstance(ProviderCompatibleJavaExecSpec.class, new Object[]{this.execSpecFactory.newJavaExecSpec()}), action);
    }

    private <T extends ProviderCompatibleBaseExecSpec> void configureParameters(ProcessOutputValueSource.Parameters parameters, T spec, Action<? super T> action) {
        action.execute(spec);
        spec.copyToParameters(parameters);
    }
}

