/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicLabelUI;
import org.jsampler.view.InstrumentsDbTreeModel;
import org.jsampler.view.fantasia.FantasiaInstrumentsDbTree;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.ToolbarButton;
import org.jsampler.view.fantasia.basic.FantasiaPainter;
import org.jsampler.view.std.JSDbInstrumentChooser;
import org.jsampler.view.std.JSInstrumentChooser;
import org.jsampler.view.std.JSInstrumentsDbTree;

public class FantasiaUtils {
    private FantasiaUtils() {
    }

    public static JComboBox createEnhancedComboBox() {
        return new JComboBox();
    }

    public static JSInstrumentChooser createInstrumentChooser(Frame frame) {
        return new InstrumentChooser(frame);
    }

    public static JLabel createScreenLabel(String string) {
        return new ScreenLabel(string);
    }

    public static JButton createScreenButton(String string) {
        return new ScreenButton(string);
    }

    public static JToolBar createSubToolBar() {
        return new ToolBar();
    }

    public static JPanel createBottomSubPane() {
        return new BottomSubPane();
    }

    private static class BottomSubPane
    extends JPanel {
        BottomSubPane() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = this.getSize().getHeight();
            double d2 = this.getSize().getWidth();
            FantasiaPainter.paintGradient(graphics2D, 0.0, 0.0, d2 - 1.0, d - 1.0);
            FantasiaPainter.RoundCorners roundCorners = new FantasiaPainter.RoundCorners(false, true, true, false);
            FantasiaPainter.paintOuterBorder(graphics2D, 0.0, 0.0, d2 - 1.0, d - 1.0, roundCorners);
            FantasiaPainter.paintInnerBorder(graphics2D, 4.0, 4.0, d2 - 5.0, d - 5.0, true);
        }
    }

    private static class ToolBar
    extends JToolBar {
        ToolBar() {
            this.setFloatable(false);
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(77, 29));
            this.setMinimumSize(this.getPreferredSize());
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            double d = this.getSize().getHeight();
            double d2 = this.getSize().getWidth();
            FantasiaPainter.paintGradient((Graphics2D)graphics, 0.0, 0.0, d2 - 1.0, d - 1.0);
            FantasiaPainter.RoundCorners roundCorners = new FantasiaPainter.RoundCorners(true, false, false, true);
            FantasiaPainter.paintOuterBorder((Graphics2D)graphics, 0.0, 0.0, d2 - 1.0, d - 1.0, roundCorners);
        }
    }

    private static class ScreenButton
    extends JButton {
        protected ScreenButton(String string) {
            super(string);
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setFont(Res.fontScreen);
            this.setForeground(new Color(16753408));
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paintComponent(graphics2D);
        }

        @Override
        public void updateUI() {
            this.setUI(new BasicButtonUI());
        }
    }

    private static class ScreenLabel
    extends JLabel {
        ScreenLabel() {
            this("");
        }

        ScreenLabel(String string) {
            super(string);
            this.setFont(Res.fontScreen);
            this.setForeground(new Color(16753408));
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paintComponent(graphics2D);
        }

        @Override
        public void updateUI() {
            this.setUI(new BasicLabelUI());
        }
    }

    private static class DbInstrumentChooser
    extends JSDbInstrumentChooser {
        DbInstrumentChooser(Dialog dialog) {
            super(dialog);
        }

        @Override
        protected JButton createToolbarButton(Action action) {
            return new ToolbarButton(action);
        }

        @Override
        protected JSInstrumentsDbTree createInstrumentsDbTree(InstrumentsDbTreeModel instrumentsDbTreeModel) {
            return new FantasiaInstrumentsDbTree(instrumentsDbTreeModel);
        }
    }

    private static class InstrumentChooser
    extends JSInstrumentChooser {
        InstrumentChooser(Frame frame) {
            super(frame);
        }

        protected JComboBox createComboBox() {
            return FantasiaUtils.createEnhancedComboBox();
        }

        @Override
        protected JSDbInstrumentChooser createDbInstrumentChooser(Dialog dialog) {
            return new DbInstrumentChooser(dialog);
        }
    }
}

