/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.rest.basic.auth.extension;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(PropertyFileLoginModule.class);
    private static final String FILE_OPTIONS = "file";
    private static final Map<String, Properties> CREDENTIAL_PROPERTIES = new ConcurrentHashMap<String, Properties>();
    private CallbackHandler callbackHandler;
    private String fileName;
    private boolean authenticated;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandler;
        this.fileName = (String)options.get(FILE_OPTIONS);
        if (Utils.isBlank((String)this.fileName)) {
            throw new ConfigException("Property Credentials file must be specified");
        }
        if (!CREDENTIAL_PROPERTIES.containsKey(this.fileName)) {
            log.trace("Opening credential properties file '{}'", (Object)this.fileName);
            Properties credentialProperties = new Properties();
            try {
                try (InputStream inputStream = Files.newInputStream(Paths.get(this.fileName, new String[0]), new OpenOption[0]);){
                    log.trace("Parsing credential properties file '{}'", (Object)this.fileName);
                    credentialProperties.load(inputStream);
                }
                CREDENTIAL_PROPERTIES.putIfAbsent(this.fileName, credentialProperties);
                if (!credentialProperties.isEmpty()) return;
                log.warn("Credential properties file '{}' is empty; all requests will be permitted", (Object)this.fileName);
                return;
            }
            catch (IOException e) {
                log.error("Error loading credentials file ", (Throwable)e);
                throw new ConfigException("Error loading Property Credentials file");
            }
        }
        log.trace("Credential properties file '{}' has already been opened and parsed; will read from cached, in-memory store", (Object)this.fileName);
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = this.configureCallbacks();
        try {
            log.trace("Authenticating user; invoking JAAS login callbacks");
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.warn("Authentication failed while invoking JAAS login callbacks", (Throwable)e);
            throw new LoginException(e.getMessage());
        }
        String username = ((NameCallback)callbacks[0]).getName();
        char[] passwordChars = ((PasswordCallback)callbacks[1]).getPassword();
        String password = passwordChars != null ? new String(passwordChars) : null;
        Properties credentialProperties = CREDENTIAL_PROPERTIES.get(this.fileName);
        if (credentialProperties.isEmpty()) {
            log.trace("Not validating credentials for user '{}' as credential properties file '{}' is empty", (Object)username, (Object)this.fileName);
            this.authenticated = true;
        } else if (username == null) {
            log.trace("No credentials were provided or the provided credentials were malformed");
            this.authenticated = false;
        } else if (password != null && password.equals(credentialProperties.get(username))) {
            log.trace("Credentials provided for user '{}' match those present in the credential properties file '{}'", (Object)username, (Object)this.fileName);
            this.authenticated = true;
        } else if (!credentialProperties.containsKey(username)) {
            log.trace("User '{}' is not present in the credential properties file '{}'", (Object)username, (Object)this.fileName);
            this.authenticated = false;
        } else {
            log.trace("Credentials provided for user '{}' do not match those present in the credential properties file '{}'", (Object)username, (Object)this.fileName);
            this.authenticated = false;
        }
        return this.authenticated;
    }

    @Override
    public boolean commit() {
        return this.authenticated;
    }

    @Override
    public boolean abort() {
        return true;
    }

    @Override
    public boolean logout() {
        return true;
    }

    private Callback[] configureCallbacks() {
        Callback[] callbacks = new Callback[]{new NameCallback("Enter user name"), new PasswordCallback("Enter password", false)};
        return callbacks;
    }
}

