/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured.assertion;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Base64;
import java.util.Optional;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CachedFile;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.AssertionCreator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.AssertionJwtTemplate;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.AssertionUtils;
import org.apache.kafka.common.utils.Utils;

public class DefaultAssertionCreator
implements AssertionCreator {
    private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private final String algorithm;
    private final CachedFile<PrivateKey> privateKeyFile;

    public DefaultAssertionCreator(String algorithm, File privateKeyFile, Optional<String> passphrase) {
        this.algorithm = algorithm;
        this.privateKeyFile = new CachedFile<PrivateKey>(privateKeyFile, new PrivateKeyTransformer(passphrase), CachedFile.RefreshPolicy.lastModifiedPolicy());
    }

    @Override
    public String create(AssertionJwtTemplate template) throws GeneralSecurityException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        String header = BASE64_ENCODER.encodeToString(Utils.utf8(mapper.writeValueAsString(template.header())));
        String payload = BASE64_ENCODER.encodeToString(Utils.utf8(mapper.writeValueAsString(template.payload())));
        String content = header + "." + payload;
        PrivateKey privateKey = this.privateKeyFile.transformed();
        String signedContent = AssertionUtils.sign(this.algorithm, privateKey, content);
        return content + "." + signedContent;
    }

    private static class PrivateKeyTransformer
    implements CachedFile.Transformer<PrivateKey> {
        private final Optional<String> passphrase;

        public PrivateKeyTransformer(Optional<String> passphrase) {
            this.passphrase = passphrase;
        }

        @Override
        public PrivateKey transform(File file, String contents) {
            try {
                contents = contents.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("\n", "");
                return AssertionUtils.privateKey(contents.getBytes(StandardCharsets.UTF_8), this.passphrase);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new JwtRetrieverException("An error occurred generating the OAuth assertion private key from " + file.getPath(), e);
            }
        }
    }
}

