/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share.metrics;

import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetricsShard;
import org.apache.kafka.timeline.SnapshotRegistry;

public class ShareCoordinatorMetricsShard
implements CoordinatorMetricsShard {
    private final SnapshotRegistry snapshotRegistry;
    private final Map<String, Sensor> globalSensors;
    private final TopicPartition topicPartition;

    public ShareCoordinatorMetricsShard(SnapshotRegistry snapshotRegistry, Map<String, Sensor> globalSensors, TopicPartition topicPartition) {
        this.snapshotRegistry = snapshotRegistry;
        this.globalSensors = globalSensors;
        this.topicPartition = topicPartition;
    }

    public void record(String sensorName) {
        if (this.globalSensors.containsKey(sensorName)) {
            this.globalSensors.get(sensorName).record();
        }
    }

    public void record(String sensorName, double val) {
        if (this.globalSensors.containsKey(sensorName)) {
            this.globalSensors.get(sensorName).record(val);
        }
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public void commitUpTo(long offset) {
    }
}

