/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.internal;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.util.function.Supplier;
import org.hibernate.annotations.TenantId;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.internal.MutableClassDetailsRegistry;
import org.hibernate.models.internal.jdk.JdkClassDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.RegistryPrimer;

public class ModelsHelper {
    public static void preFillRegistries(RegistryPrimer.Contributions contributions, ModelsContext buildingContext) {
        OrmAnnotationHelper.forEachOrmAnnotation(arg_0 -> ((RegistryPrimer.Contributions)contributions).registerAnnotation(arg_0));
        ModelsHelper.registerPrimitive(Boolean.TYPE, buildingContext);
        ModelsHelper.registerPrimitive(Byte.TYPE, buildingContext);
        ModelsHelper.registerPrimitive(Short.TYPE, buildingContext);
        ModelsHelper.registerPrimitive(Integer.TYPE, buildingContext);
        ModelsHelper.registerPrimitive(Long.TYPE, buildingContext);
        ModelsHelper.registerPrimitive(Double.TYPE, buildingContext);
        ModelsHelper.registerPrimitive(Float.TYPE, buildingContext);
        ModelsHelper.registerPrimitive(Character.TYPE, buildingContext);
        ModelsHelper.registerPrimitive(Blob.class, buildingContext);
        ModelsHelper.registerPrimitive(Clob.class, buildingContext);
        ModelsHelper.registerPrimitive(NClob.class, buildingContext);
        buildingContext.getAnnotationDescriptorRegistry().getDescriptor(TenantId.class);
    }

    private static void registerPrimitive(Class<?> theClass, ModelsContext buildingContext) {
        MutableClassDetailsRegistry classDetailsRegistry = (MutableClassDetailsRegistry)buildingContext.getClassDetailsRegistry().as(MutableClassDetailsRegistry.class);
        classDetailsRegistry.addClassDetails((ClassDetails)new JdkClassDetails(theClass, buildingContext));
    }

    public static ClassDetails resolveClassDetails(String className, ClassDetailsRegistry classDetailsRegistry, Supplier<ClassDetails> classDetailsSupplier) {
        ClassDetails classDetails = classDetailsRegistry.findClassDetails(className);
        if (classDetails != null) {
            return classDetails;
        }
        classDetails = classDetailsSupplier.get();
        ((MutableClassDetailsRegistry)classDetailsRegistry.as(MutableClassDetailsRegistry.class)).addClassDetails(className, classDetails);
        return classDetails;
    }
}

