/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticatorFactory;
import org.keycloak.authentication.authenticators.conditional.ConditionalSubFlowExecutedAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class ConditionalSubFlowExecutedAuthenticatorFactory
implements ConditionalAuthenticatorFactory {
    public static final String PROVIDER_ID = "conditional-sub-flow-executed";
    public static final String FLOW_TO_CHECK = "flow_to_check";
    public static final String CHECK_RESULT = "check_result";
    public static final String CHECK_RESULT_EXECUTED = "executed";
    public static final String CHECK_RESULT_NOT_EXECUTED = "not-executed";

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Condition - sub-flow executed";
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Condition to evaluate if a sub-flow was executed successfully during the authentication process";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name(FLOW_TO_CHECK).type("String").label("Flow name").helpText("The sub-flow name to check if it was executed.").required(true).add().property().name(CHECK_RESULT).type("List").label("Check result").helpText("When the condition evaluates to true.\nIf 'executed' returns true when the configured sub-flow was executed with output success, false otherwise.\nIf 'not-executed' returns false when the sub-flow was executed with output success, true otherwise.\n").required(true).options(List.of(CHECK_RESULT_EXECUTED, CHECK_RESULT_NOT_EXECUTED)).defaultValue((Object)CHECK_RESULT_EXECUTED).add().build();
    }

    @Override
    public ConditionalAuthenticator getSingleton() {
        return ConditionalSubFlowExecutedAuthenticator.SINGLETON;
    }
}

