/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonException;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.parsson.api.BufferPool;

final class JsonContext {
    private static final int DEFAULT_MAX_BIGINTEGER_SCALE = 100000;
    private static final int DEFAULT_MAX_BIGDECIMAL_LEN = 1100;
    private static final int DEFAULT_MAX_DEPTH = 1000;
    static final String PROPERTY_BUFFER_POOL = BufferPool.class.getName();
    private final Map<String, ?> config;
    private final int bigIntegerScaleLimit;
    private final int bigDecimalLengthLimit;
    private final int depthLimit;
    private final boolean prettyPrinting;
    private final boolean rejectDuplicateKeys;
    private final BufferPool bufferPool;

    JsonContext(Map<String, ?> config, BufferPool defaultPool) {
        this.bigIntegerScaleLimit = JsonContext.getIntConfig("org.eclipse.parsson.maxBigIntegerScale", config, 100000);
        this.bigDecimalLengthLimit = JsonContext.getIntConfig("org.eclipse.parsson.maxBigDecimalLength", config, 1100);
        this.depthLimit = JsonContext.getIntConfig("org.eclipse.parsson.maxDepth", config, 1000);
        this.prettyPrinting = JsonContext.getBooleanConfig("jakarta.json.stream.JsonGenerator.prettyPrinting", config);
        this.rejectDuplicateKeys = JsonContext.getBooleanConfig("org.eclipse.parsson.rejectDuplicateKeys", config);
        this.bufferPool = JsonContext.getBufferPool(config, defaultPool);
        this.config = config != null ? Collections.unmodifiableMap(config) : null;
    }

    JsonContext(Map<String, ?> config, BufferPool defaultPool, String ... properties) {
        this.bigIntegerScaleLimit = JsonContext.getIntConfig("org.eclipse.parsson.maxBigIntegerScale", config, 100000);
        this.bigDecimalLengthLimit = JsonContext.getIntConfig("org.eclipse.parsson.maxBigDecimalLength", config, 1100);
        this.depthLimit = JsonContext.getIntConfig("org.eclipse.parsson.maxDepth", config, 1000);
        this.prettyPrinting = JsonContext.getBooleanConfig("jakarta.json.stream.JsonGenerator.prettyPrinting", config);
        this.rejectDuplicateKeys = JsonContext.getBooleanConfig("org.eclipse.parsson.rejectDuplicateKeys", config);
        this.bufferPool = JsonContext.getBufferPool(config, defaultPool);
        this.config = config != null ? Collections.unmodifiableMap(JsonContext.copyPropertiesMap(this, config, properties)) : null;
    }

    Map<String, ?> config() {
        return this.config;
    }

    Object config(String propertyName) {
        return this.config != null ? this.config.get(propertyName) : null;
    }

    int bigIntegerScaleLimit() {
        return this.bigIntegerScaleLimit;
    }

    int bigDecimalLengthLimit() {
        return this.bigDecimalLengthLimit;
    }

    int depthLimit() {
        return this.depthLimit;
    }

    boolean prettyPrinting() {
        return this.prettyPrinting;
    }

    boolean rejectDuplicateKeys() {
        return this.rejectDuplicateKeys;
    }

    BufferPool bufferPool() {
        return this.bufferPool;
    }

    private static BufferPool getBufferPool(Map<String, ?> config, BufferPool defaultrPool) {
        BufferPool pool = config != null ? (BufferPool)config.get(PROPERTY_BUFFER_POOL) : null;
        return pool != null ? pool : defaultrPool;
    }

    private static int getIntConfig(String propertyName, Map<String, ?> config, int defaultValue) throws JsonException {
        Integer intConfig;
        Integer n = intConfig = config != null ? JsonContext.getIntProperty(propertyName, config) : null;
        if (intConfig != null) {
            return intConfig;
        }
        intConfig = JsonContext.getIntSystemProperty(propertyName);
        return intConfig != null ? intConfig : defaultValue;
    }

    private static boolean getBooleanConfig(String propertyName, Map<String, ?> config) throws JsonException {
        Boolean booleanConfig;
        Boolean bl = booleanConfig = config != null ? JsonContext.getBooleanProperty(propertyName, config) : null;
        if (booleanConfig != null) {
            return booleanConfig;
        }
        return JsonContext.getBooleanSystemProperty(propertyName);
    }

    private static Integer getIntProperty(String propertyName, Map<String, ?> config) throws JsonException {
        Object property = config.get(propertyName);
        if (property == null) {
            return null;
        }
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return JsonContext.propertyStringToInt(propertyName, (String)property);
        }
        throw new JsonException(String.format("Could not convert %s property of type %s to Integer", propertyName, property.getClass().getName()));
    }

    private static Boolean getBooleanProperty(String propertyName, Map<String, ?> config) throws JsonException {
        return config.containsKey(propertyName) ? Boolean.valueOf(true) : null;
    }

    private static Integer getIntSystemProperty(String propertyName) throws JsonException {
        String systemProperty = JsonContext.getSystemProperty(propertyName);
        if (systemProperty == null) {
            return null;
        }
        return JsonContext.propertyStringToInt(propertyName, systemProperty);
    }

    private static boolean getBooleanSystemProperty(String propertyName) throws JsonException {
        return JsonContext.getSystemProperty(propertyName) != null;
    }

    private static String getSystemProperty(String propertyName) throws JsonException {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> System.getProperty(propertyName));
        }
        return System.getProperty(propertyName);
    }

    private static int propertyStringToInt(String propertyName, String propertyValue) throws JsonException {
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException ex) {
            throw new JsonException(String.format("Value of %s property is not a number", propertyName), (Throwable)ex);
        }
    }

    private static Map<String, ?> copyPropertiesMap(JsonContext instance, Map<String, ?> config, String ... properties) {
        Objects.requireNonNull(config, "Map of provider specific properties is null");
        if (properties == null || properties.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> newConfig = new HashMap<String, Boolean>(properties.length);
        String[] stringArray = properties;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String propertyName;
            switch (propertyName = stringArray[i]) {
                case "jakarta.json.stream.JsonGenerator.prettyPrinting": {
                    if (!instance.prettyPrinting) continue block8;
                    newConfig.put("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
                    continue block8;
                }
                case "org.eclipse.parsson.rejectDuplicateKeys": {
                    if (instance.rejectDuplicateKeys) {
                        newConfig.put("org.eclipse.parsson.rejectDuplicateKeys", true);
                    }
                }
                default: {
                    if (!config.containsKey(propertyName)) continue block8;
                    newConfig.put(propertyName, (Boolean)config.get(propertyName));
                }
            }
        }
        return newConfig;
    }
}

