/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions.expression;

import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.workflow.WorkflowInvalidStateException;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionLexer;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionParser;
import org.keycloak.models.workflow.conditions.expression.ErrorListener;

public class EvaluatorUtils {
    public static BooleanConditionParser.EvaluatorContext createEvaluatorContext(String expression) {
        CodePointCharStream charStream = CharStreams.fromString((String)expression);
        BooleanConditionLexer lexer = new BooleanConditionLexer((CharStream)charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        BooleanConditionParser parser = new BooleanConditionParser((TokenStream)tokens);
        ErrorListener errorListener = new ErrorListener();
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        BooleanConditionParser.EvaluatorContext context = parser.evaluator();
        if (errorListener.hasErrors()) {
            String lineSeparator = System.lineSeparator();
            String errorDetails = errorListener.getErrorMessages().stream().map(error -> "- " + error).collect(Collectors.joining(lineSeparator));
            throw new WorkflowInvalidStateException(String.format("Invalid expression: %s%sError details:%s%s", expression, lineSeparator, lineSeparator, errorDetails));
        }
        return context;
    }

    public static BooleanConditionParser.EvaluatorContext createEvaluatorContext(ComponentModel workflowModel, String expression) {
        BooleanConditionParser.EvaluatorContext context = (BooleanConditionParser.EvaluatorContext)((Object)workflowModel.getNote(expression));
        if (context == null) {
            context = EvaluatorUtils.createEvaluatorContext(expression);
            workflowModel.setNote(expression, (Object)context);
        }
        return context;
    }
}

