/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.Label;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.creator.SwitchCreator;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Goto;
import io.quarkus.gizmo2.impl.SwitchCreatorImpl;
import io.quarkus.gizmo2.impl.TryFinally;
import java.util.Objects;

class GotoCase
extends Goto {
    private final SwitchCreator switch_;
    private final Const case_;

    public GotoCase(SwitchCreator switch_, Const case_) {
        this.switch_ = switch_;
        this.case_ = case_;
    }

    @Override
    Label target(BlockCreatorImpl from) {
        TryFinally tryFinally = from.tryFinally();
        SwitchCreatorImpl sci = (SwitchCreatorImpl)this.switch_;
        if (tryFinally != null) {
            return tryFinally.cleanup(new GotoCaseKey(sci, this.case_));
        }
        return GotoCase.findBlock(sci, this.case_).startLabel();
    }

    private static BlockCreatorImpl findBlock(SwitchCreatorImpl<?> sci, Const case_) {
        SwitchCreatorImpl.CaseCreatorImpl matched = sci.findCase(case_);
        if (matched == null) {
            return sci.default_;
        }
        return matched.body;
    }

    static class GotoCaseKey
    extends TryFinally.CleanupKey {
        private final SwitchCreatorImpl<?> switch_;
        private final Const case_;

        GotoCaseKey(SwitchCreatorImpl<?> switch_, Const case_) {
            this.switch_ = switch_;
            this.case_ = case_;
        }

        @Override
        void terminate(BlockCreatorImpl bci, Expr input) {
            bci.gotoCase(this.switch_, this.case_);
        }

        public boolean equals(Object obj) {
            GotoCaseKey rk;
            return obj instanceof GotoCaseKey && this.equals(rk = (GotoCaseKey)obj);
        }

        public boolean equals(GotoCaseKey other) {
            return this == other || other != null && this.switch_ == other.switch_ && this.case_.equals(other.case_);
        }

        public int hashCode() {
            return Objects.hash(GotoCaseKey.class, this.switch_, this.case_);
        }
    }
}

