/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.cache.infinispan.DefaultLazyLoader;
import org.keycloak.models.cache.infinispan.LazyLoader;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

abstract class AbstractCachedClientScope<D extends ClientScopeModel>
extends AbstractRevisioned
implements InRealm {
    private final LazyLoader<D, Map<String, ProtocolMapperModel>> mappersById = new DefaultLazyLoader<ClientScopeModel, Map>(scope -> scope.getProtocolMappersStream().collect(Collectors.toMap(ProtocolMapperModel::getId, ProtocolMapperModel::new)), Collections::emptyMap);
    private final LazyLoader<D, Map<String, String>> mappersByName = new DefaultLazyLoader<ClientScopeModel, Map>(scope -> scope.getProtocolMappersStream().collect(Collectors.toMap(mapper -> mapper.getProtocol() + "." + mapper.getName(), ProtocolMapperModel::getId)), Collections::emptyMap);
    private final LazyLoader<D, Map<String, List<String>>> mappersByType = new DefaultLazyLoader<ClientScopeModel, Map>(scope -> scope.getProtocolMappersStream().collect(Collectors.groupingBy(ProtocolMapperModel::getProtocolMapper, Collectors.mapping(ProtocolMapperModel::getId, Collectors.toList()))), Collections::emptyMap);

    public AbstractCachedClientScope(Long revision, ClientScopeModel model) {
        super(revision, model.getId());
    }

    public Stream<ProtocolMapperModel> getProtocolMappers(KeycloakSession session, Supplier<D> model) {
        return this.mappersById.get(session, model).values().stream();
    }

    public ProtocolMapperModel getProtocolMapperById(KeycloakSession session, Supplier<D> model, String id) {
        if (id == null) {
            return null;
        }
        return this.mappersById.get(session, model).get(id);
    }

    public List<ProtocolMapperModel> getProtocolMapperByType(KeycloakSession session, Supplier<D> model, String type) {
        return this.mappersByType.get(session, model).getOrDefault(type, List.of()).stream().map(id -> this.getProtocolMapperById(session, model, (String)id)).collect(Collectors.toList());
    }

    public ProtocolMapperModel getProtocolMapperByName(KeycloakSession session, Supplier<D> model, String protocol, String name) {
        String id = this.mappersByName.get(session, model).get(protocol + "." + name);
        return this.getProtocolMapperById(session, model, id);
    }
}

