/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.search.Query;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.search.aggregations.AggregationCollectorManager;
import org.opensearch.search.aggregations.AggregationInitializationException;
import org.opensearch.search.aggregations.AggregationProcessor;
import org.opensearch.search.aggregations.BucketCollectorProcessor;
import org.opensearch.search.aggregations.GlobalAggCollectorManager;
import org.opensearch.search.aggregations.NonGlobalAggCollectorManager;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.profile.query.InternalProfileCollectorManager;
import org.opensearch.search.query.QueryPhaseExecutionException;
import org.opensearch.search.query.ReduceableSearchResult;

public class ConcurrentAggregationProcessor
implements AggregationProcessor {
    private final BucketCollectorProcessor bucketCollectorProcessor = new BucketCollectorProcessor();

    @Override
    public void preProcess(SearchContext context) {
        try {
            if (context.aggregations() != null) {
                context.setBucketCollectorProcessor(this.bucketCollectorProcessor);
                if (context.aggregations().factories().hasNonGlobalAggregator()) {
                    context.queryCollectorManagers().put(NonGlobalAggCollectorManager.class, new NonGlobalAggCollectorManager(context));
                }
                if (context.aggregations().factories().hasGlobalAggregator()) {
                    context.queryCollectorManagers().put(GlobalAggCollectorManager.class, new GlobalAggCollectorManager(context));
                }
            }
        }
        catch (IOException ex) {
            throw new AggregationInitializationException("Could not initialize aggregators", ex);
        }
    }

    @Override
    public void postProcess(SearchContext context) {
        if (context.aggregations() == null) {
            context.queryResult().aggregations(null);
            return;
        }
        InternalProfileCollectorManager globalCollectorManager = context.queryCollectorManagers().get(GlobalAggCollectorManager.class);
        try {
            if (globalCollectorManager != null) {
                Query query = context.buildFilteredQuery(Queries.newMatchAllQuery());
                if (context.getProfilers() != null) {
                    globalCollectorManager = new InternalProfileCollectorManager(globalCollectorManager, ((AggregationCollectorManager)((Object)globalCollectorManager)).getCollectorReason(), Collections.emptyList());
                    context.getProfilers().addQueryProfiler().setCollector(globalCollectorManager);
                }
                ReduceableSearchResult result = (ReduceableSearchResult)context.searcher().search(query, globalCollectorManager);
                result.reduce(context.queryResult());
            }
        }
        catch (Exception e) {
            throw new QueryPhaseExecutionException(context.shardTarget(), "Failed to execute global aggregators", e);
        }
        context.aggregations(null);
        context.queryCollectorManagers().remove(NonGlobalAggCollectorManager.class);
        context.queryCollectorManagers().remove(GlobalAggCollectorManager.class);
    }
}

