/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.kll;

public class KllFloatsSketchIterator {
    private final float[] items_;
    private final int[] levels_;
    private final int numLevels_;
    private int level_;
    private int i_;
    private long weight_;
    private boolean isInitialized_;

    KllFloatsSketchIterator(float[] items, int[] levels, int numLevels) {
        this.items_ = items;
        this.levels_ = levels;
        this.numLevels_ = numLevels;
        this.isInitialized_ = false;
    }

    public boolean next() {
        if (!this.isInitialized_) {
            this.level_ = 0;
            this.i_ = this.levels_[this.level_];
            this.weight_ = 1L;
            this.isInitialized_ = true;
        } else {
            ++this.i_;
        }
        if (this.i_ < this.levels_[this.level_ + 1]) {
            return true;
        }
        do {
            ++this.level_;
            if (this.level_ == this.numLevels_) {
                return false;
            }
            this.weight_ *= 2L;
        } while (this.levels_[this.level_] == this.levels_[this.level_ + 1]);
        this.i_ = this.levels_[this.level_];
        return true;
    }

    public float getValue() {
        return this.items_[this.i_];
    }

    public long getWeight() {
        return this.weight_;
    }
}

