\name{HMinimaImageFilter}
\alias{HMinimaImageFilter}
\title{HMinimaImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Suppress local minima whose depth below the baseline is less than h.
HMinimaImageFilter}
\details{
HMinimaImageFilter suppresses local minima that are less than h intensity units below
the (local) background. This has the effect of smoothing over the
"low" parts of the noise in the image without smoothing over large
changes in intensity (region boundaries). See the HMaximaImageFilter to suppress the local maxima whose height is less than h intensity
units above the (local) background.
If original image is subtracted from the output of HMinimaImageFilter , the significant "valleys" in the image can be identified. This is
what the HConcaveImageFilter provides.
This filter uses the GrayscaleGeodesicErodeImageFilter . It provides its own input as the "mask" input to the geodesic
dilation. The "marker" image for the geodesic dilation is the input
image plus the height parameter h.
Geodesic morphology and the H-Minima algorithm is described in Chapter
6 of Pierre Soille's book "Morphological Image Analysis: Principles
and Applications", Second Edition, Springer, 2003.
See:
GrayscaleGeodesicDilateImageFilter , HMinimaImageFilter , HConvexImageFilter
MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter
HMinima for the procedural interface
itk::HMinimaImageFilter for the Doxygen on the original ITK class.
HMinimaImageFilter}
%C++ includes: sitkHMinimaImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{double GetHeight() const:}{
Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ HMinimaImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{Self SetHeight(double Height):}{
Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~HMinimaImageFilter():}{
Destructor
}
}
}
