import ts from 'typescript';
export type ComponentPartInfo = Array<{
    name: string;
    type: string;
    doc?: string;
}>;
export interface ComponentInfoProvider {
    getEvents(): ComponentPartInfo;
    getSlotLets(slot?: string): ComponentPartInfo;
    getProps(): ComponentPartInfo;
}
export declare class JsOrTsComponentInfoProvider implements ComponentInfoProvider {
    private readonly typeChecker;
    private readonly classType;
    private readonly useSvelte5PlusPropsParameter;
    private constructor();
    getEvents(): ComponentPartInfo;
    getSlotLets(slot?: string): ComponentPartInfo;
    getProps(): ComponentPartInfo;
    private getType;
    private mapPropertiesOfType;
    /**
     * The result of this shouldn't be cached as it could lead to memory leaks. The type checker
     * could become old and then multiple versions of it could exist.
     */
    static create(lang: ts.LanguageService, def: ts.DefinitionInfo, isSvelte5Plus: boolean): ComponentInfoProvider | null;
}
