/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.catalina.filters.FilterBase;
import org.apache.catalina.util.RateLimiter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class RateLimitFilter
extends FilterBase {
    public static final int DEFAULT_BUCKET_DURATION = 60;
    public static final int DEFAULT_BUCKET_REQUESTS = 300;
    public static final boolean DEFAULT_ENFORCE = true;
    public static final boolean DEFAULT_EXPOSE_HEADERS = false;
    public static final String HEADER_RATE_LIMIT_POLICY = "RateLimit-Policy";
    public static final String HEADER_RATE_LIMIT = "RateLimit";
    public static final int DEFAULT_STATUS_CODE = 429;
    public static final String DEFAULT_STATUS_MESSAGE = "Too many requests";
    public static final String RATE_LIMIT_ATTRIBUTE_COUNT = "org.apache.catalina.filters.RateLimitFilter.Count";
    transient RateLimiter rateLimiter;
    private String rateLimitClassName = "org.apache.catalina.util.FastRateLimiter";
    private int bucketRequests = 300;
    private int bucketDuration = 60;
    private boolean enforce = true;
    private int statusCode = 429;
    private String statusMessage = "Too many requests";
    private String filterName;
    private boolean exposeHeaders = false;
    private String policyName = null;
    private final transient Log log = LogFactory.getLog(RateLimitFilter.class);
    private static final StringManager sm = StringManager.getManager(RateLimitFilter.class);

    public void setBucketDuration(int n) {
        this.bucketDuration = n;
    }

    public void setBucketRequests(int n) {
        this.bucketRequests = n;
    }

    public void setEnforce(boolean bl) {
        this.enforce = bl;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    public void setStatusMessage(String string) {
        this.statusMessage = string;
    }

    public void setRateLimitClassName(String string) {
        this.rateLimitClassName = string;
    }

    public void setExposeHeaders(boolean bl) {
        this.exposeHeaders = bl;
    }

    public void setPolicyName(String string) {
        this.policyName = string;
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String string;
        super.init(filterConfig);
        try {
            this.rateLimiter = (RateLimiter)Class.forName(this.rateLimitClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ServletException((Throwable)reflectiveOperationException);
        }
        this.rateLimiter.setDuration(this.bucketDuration);
        this.rateLimiter.setRequests(this.bucketRequests);
        this.rateLimiter.setFilterConfig(filterConfig);
        if (this.policyName != null && !(string = this.policyName.trim()).isEmpty()) {
            this.rateLimiter.setPolicyName(string);
        }
        this.filterName = filterConfig.getFilterName();
        this.log.info((Object)sm.getString("rateLimitFilter.initialized", new Object[]{this.filterName, this.bucketRequests, this.bucketDuration, this.rateLimiter.getRequests(), this.rateLimiter.getDuration(), (!this.enforce ? "Not " : "") + "enforcing"}));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String string = servletRequest.getRemoteAddr();
        int n = this.rateLimiter.increment(string);
        servletRequest.setAttribute(RATE_LIMIT_ATTRIBUTE_COUNT, (Object)n);
        if (this.exposeHeaders) {
            ((HttpServletResponse)servletResponse).addHeader(HEADER_RATE_LIMIT_POLICY, this.rateLimiter.getPolicy());
            if (this.enforce) {
                ((HttpServletResponse)servletResponse).addHeader(HEADER_RATE_LIMIT, this.rateLimiter.getQuota(n));
            }
        }
        if (n > this.rateLimiter.getRequests()) {
            this.log.warn((Object)sm.getString("rateLimitFilter.maxRequestsExceeded", new Object[]{this.filterName, n, string, this.rateLimiter.getRequests(), this.rateLimiter.getDuration()}));
            if (this.enforce) {
                ((HttpServletResponse)servletResponse).sendError(this.statusCode, this.statusMessage);
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        this.rateLimiter.destroy();
        super.destroy();
    }

    @Override
    protected Log getLogger() {
        return this.log;
    }
}

