#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Codemancer
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250906.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='codemancer'
GAME_NAME='Codemancer'

ARCHIVE_BASE_0_NAME='Codemancer.msi'
ARCHIVE_BASE_0_MD5='727dfcf3640ce064f455a023c1c50e1e'
ARCHIVE_BASE_0_SIZE='120000'
ARCHIVE_BASE_0_VERSION='1.0.2-itch.2020.03.17'
ARCHIVE_BASE_0_URL='https://importantlittlegames.itch.io/codemancer-ch-1'

CONTENT_PATH_DEFAULT='appdir:.'
CONTENT_GAME_BIN_FILES='
adobe air
codemancer chapter 1.exe'
CONTENT_GAME_DATA_FILES='
assets
meta-inf
mimetype
icon.ico
*.swf'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/CodemancerChapter1'

APP_MAIN_EXE='codemancer chapter 1.exe'
APP_MAIN_ICON='icon.ico'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
