# extract the content of an archive using tar
# USAGE: archive_extraction_using_tar $archive $destination_directory $log_file
archive_extraction_using_tar() {
	local archive destination_directory log_file
	archive="$1"
	destination_directory="$2"
	log_file="$3"

	local archive_path
	archive_path=$(archive_path "$archive")

	local extractor_options
	extractor_options=$(archive_extractor_options "$archive")
	## Set default options based on archive type.
	if [ -z "$extractor_options" ]; then
		local archive_type
		archive_type=$(archive_type "$archive")
		case "$archive_type" in
			('tar.bz2')
				extractor_options='--bzip2'
			;;
			('tar.gz')
				extractor_options='--gzip'
			;;
			('tar.xz')
				extractor_options='--xz'
			;;
		esac
	fi
	if ! {
		printf 'tar --verbose %s --extract --file "%s" --directory "%s"\n' "$extractor_options" "$archive_path" "$destination_directory"
		tar --verbose $extractor_options --extract --file "$archive_path" --directory "$destination_directory" 2>&1
	} >> "$log_file"
	then
		error_archive_extraction_failure "$archive"
		return 1
	fi
}

