/*
 * Copyright 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.libcore;

import android.perftests.utils.BenchmarkState;
import android.perftests.utils.PerfStatusReporter;
import android.test.suitebuilder.annotation.LargeTest;

import androidx.test.runner.AndroidJUnit4;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * This file is script-generated by ImtConflictPerfTestGen.py. It measures the performance impact of
 * conflicts in interface method tables. Run `python ImtConflictPerfTestGen.py >
 * ImtConflictPerfTest.java` to regenerate.
 *
 * <p>Each interface has 64 methods, which is the current size of an IMT. C0 implements one
 * interface, C1 implements two, C2 implements three, and so on. The intent is that C0 has no
 * conflicts in its IMT, C1 has depth-2 conflicts in its IMT, C2 has depth-3 conflicts, etc. This is
 * currently guaranteed by the fact that we hash interface methods by taking their method index
 * modulo 64. (Note that a "conflict depth" of 1 means no conflict at all.)
 */
@RunWith(AndroidJUnit4.class)
@LargeTest
public class ImtConflictPerfTest {
    @Rule public PerfStatusReporter mPerfStatusReporter = new PerfStatusReporter();

    @Before
    public void setup() {
        C0 c0 = new C0();
        callF0(c0);
        C1 c1 = new C1();
        callF0(c1);
        callF19(c1);
        C2 c2 = new C2();
        callF0(c2);
        callF19(c2);
        callF38(c2);
        C3 c3 = new C3();
        callF0(c3);
        callF19(c3);
        callF38(c3);
        callF57(c3);
        C4 c4 = new C4();
        callF0(c4);
        callF19(c4);
        callF38(c4);
        callF57(c4);
        callF76(c4);
        C5 c5 = new C5();
        callF0(c5);
        callF19(c5);
        callF38(c5);
        callF57(c5);
        callF76(c5);
        callF95(c5);
        C6 c6 = new C6();
        callF0(c6);
        callF19(c6);
        callF38(c6);
        callF57(c6);
        callF76(c6);
        callF95(c6);
        callF114(c6);
        C7 c7 = new C7();
        callF0(c7);
        callF19(c7);
        callF38(c7);
        callF57(c7);
        callF76(c7);
        callF95(c7);
        callF114(c7);
        callF133(c7);
        C8 c8 = new C8();
        callF0(c8);
        callF19(c8);
        callF38(c8);
        callF57(c8);
        callF76(c8);
        callF95(c8);
        callF114(c8);
        callF133(c8);
        callF152(c8);
        C9 c9 = new C9();
        callF0(c9);
        callF19(c9);
        callF38(c9);
        callF57(c9);
        callF76(c9);
        callF95(c9);
        callF114(c9);
        callF133(c9);
        callF152(c9);
        callF171(c9);
        C10 c10 = new C10();
        callF0(c10);
        callF19(c10);
        callF38(c10);
        callF57(c10);
        callF76(c10);
        callF95(c10);
        callF114(c10);
        callF133(c10);
        callF152(c10);
        callF171(c10);
        callF190(c10);
        C11 c11 = new C11();
        callF0(c11);
        callF19(c11);
        callF38(c11);
        callF57(c11);
        callF76(c11);
        callF95(c11);
        callF114(c11);
        callF133(c11);
        callF152(c11);
        callF171(c11);
        callF190(c11);
        callF209(c11);
        C12 c12 = new C12();
        callF0(c12);
        callF19(c12);
        callF38(c12);
        callF57(c12);
        callF76(c12);
        callF95(c12);
        callF114(c12);
        callF133(c12);
        callF152(c12);
        callF171(c12);
        callF190(c12);
        callF209(c12);
        callF228(c12);
        C13 c13 = new C13();
        callF0(c13);
        callF19(c13);
        callF38(c13);
        callF57(c13);
        callF76(c13);
        callF95(c13);
        callF114(c13);
        callF133(c13);
        callF152(c13);
        callF171(c13);
        callF190(c13);
        callF209(c13);
        callF228(c13);
        callF247(c13);
        C14 c14 = new C14();
        callF0(c14);
        callF19(c14);
        callF38(c14);
        callF57(c14);
        callF76(c14);
        callF95(c14);
        callF114(c14);
        callF133(c14);
        callF152(c14);
        callF171(c14);
        callF190(c14);
        callF209(c14);
        callF228(c14);
        callF247(c14);
        callF266(c14);
        C15 c15 = new C15();
        callF0(c15);
        callF19(c15);
        callF38(c15);
        callF57(c15);
        callF76(c15);
        callF95(c15);
        callF114(c15);
        callF133(c15);
        callF152(c15);
        callF171(c15);
        callF190(c15);
        callF209(c15);
        callF228(c15);
        callF247(c15);
        callF266(c15);
        callF285(c15);
        C16 c16 = new C16();
        callF0(c16);
        callF19(c16);
        callF38(c16);
        callF57(c16);
        callF76(c16);
        callF95(c16);
        callF114(c16);
        callF133(c16);
        callF152(c16);
        callF171(c16);
        callF190(c16);
        callF209(c16);
        callF228(c16);
        callF247(c16);
        callF266(c16);
        callF285(c16);
        callF304(c16);
        C17 c17 = new C17();
        callF0(c17);
        callF19(c17);
        callF38(c17);
        callF57(c17);
        callF76(c17);
        callF95(c17);
        callF114(c17);
        callF133(c17);
        callF152(c17);
        callF171(c17);
        callF190(c17);
        callF209(c17);
        callF228(c17);
        callF247(c17);
        callF266(c17);
        callF285(c17);
        callF304(c17);
        callF323(c17);
        C18 c18 = new C18();
        callF0(c18);
        callF19(c18);
        callF38(c18);
        callF57(c18);
        callF76(c18);
        callF95(c18);
        callF114(c18);
        callF133(c18);
        callF152(c18);
        callF171(c18);
        callF190(c18);
        callF209(c18);
        callF228(c18);
        callF247(c18);
        callF266(c18);
        callF285(c18);
        callF304(c18);
        callF323(c18);
        callF342(c18);
        C19 c19 = new C19();
        callF0(c19);
        callF19(c19);
        callF38(c19);
        callF57(c19);
        callF76(c19);
        callF95(c19);
        callF114(c19);
        callF133(c19);
        callF152(c19);
        callF171(c19);
        callF190(c19);
        callF209(c19);
        callF228(c19);
        callF247(c19);
        callF266(c19);
        callF285(c19);
        callF304(c19);
        callF323(c19);
        callF342(c19);
        callF361(c19);
    }

    @Test
    public void timeConflictDepth01() {
        C0 c0 = new C0();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
        }
    }

    @Test
    public void timeConflictDepth02() {
        C1 c1 = new C1();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c1);
            callF19(c1);
            callF0(c1);
            callF19(c1);
            callF0(c1);
            callF19(c1);
            callF0(c1);
            callF19(c1);
            callF0(c1);
            callF19(c1);
            callF0(c1);
            callF19(c1);
            callF0(c1);
            callF19(c1);
            callF0(c1);
            callF19(c1);
            callF0(c1);
            callF19(c1);
            callF0(c1);
            callF19(c1);
        }
    }

    @Test
    public void timeConflictDepth03() {
        C2 c2 = new C2();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c2);
            callF19(c2);
            callF38(c2);
            callF0(c2);
            callF19(c2);
            callF38(c2);
            callF0(c2);
            callF19(c2);
            callF38(c2);
            callF0(c2);
            callF19(c2);
            callF38(c2);
            callF0(c2);
            callF19(c2);
            callF38(c2);
            callF0(c2);
            callF19(c2);
            callF38(c2);
            callF0(c2);
            callF19(c2);
        }
    }

    @Test
    public void timeConflictDepth04() {
        C3 c3 = new C3();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c3);
            callF19(c3);
            callF38(c3);
            callF57(c3);
            callF0(c3);
            callF19(c3);
            callF38(c3);
            callF57(c3);
            callF0(c3);
            callF19(c3);
            callF38(c3);
            callF57(c3);
            callF0(c3);
            callF19(c3);
            callF38(c3);
            callF57(c3);
            callF0(c3);
            callF19(c3);
            callF38(c3);
            callF57(c3);
        }
    }

    @Test
    public void timeConflictDepth05() {
        C4 c4 = new C4();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c4);
            callF19(c4);
            callF38(c4);
            callF57(c4);
            callF76(c4);
            callF0(c4);
            callF19(c4);
            callF38(c4);
            callF57(c4);
            callF76(c4);
            callF0(c4);
            callF19(c4);
            callF38(c4);
            callF57(c4);
            callF76(c4);
            callF0(c4);
            callF19(c4);
            callF38(c4);
            callF57(c4);
            callF76(c4);
        }
    }

    @Test
    public void timeConflictDepth06() {
        C5 c5 = new C5();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c5);
            callF19(c5);
            callF38(c5);
            callF57(c5);
            callF76(c5);
            callF95(c5);
            callF0(c5);
            callF19(c5);
            callF38(c5);
            callF57(c5);
            callF76(c5);
            callF95(c5);
            callF0(c5);
            callF19(c5);
            callF38(c5);
            callF57(c5);
            callF76(c5);
            callF95(c5);
            callF0(c5);
            callF19(c5);
        }
    }

    @Test
    public void timeConflictDepth07() {
        C6 c6 = new C6();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c6);
            callF19(c6);
            callF38(c6);
            callF57(c6);
            callF76(c6);
            callF95(c6);
            callF114(c6);
            callF0(c6);
            callF19(c6);
            callF38(c6);
            callF57(c6);
            callF76(c6);
            callF95(c6);
            callF114(c6);
            callF0(c6);
            callF19(c6);
            callF38(c6);
            callF57(c6);
            callF76(c6);
            callF95(c6);
        }
    }

    @Test
    public void timeConflictDepth08() {
        C7 c7 = new C7();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c7);
            callF19(c7);
            callF38(c7);
            callF57(c7);
            callF76(c7);
            callF95(c7);
            callF114(c7);
            callF133(c7);
            callF0(c7);
            callF19(c7);
            callF38(c7);
            callF57(c7);
            callF76(c7);
            callF95(c7);
            callF114(c7);
            callF133(c7);
            callF0(c7);
            callF19(c7);
            callF38(c7);
            callF57(c7);
        }
    }

    @Test
    public void timeConflictDepth09() {
        C8 c8 = new C8();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c8);
            callF19(c8);
            callF38(c8);
            callF57(c8);
            callF76(c8);
            callF95(c8);
            callF114(c8);
            callF133(c8);
            callF152(c8);
            callF0(c8);
            callF19(c8);
            callF38(c8);
            callF57(c8);
            callF76(c8);
            callF95(c8);
            callF114(c8);
            callF133(c8);
            callF152(c8);
            callF0(c8);
            callF19(c8);
        }
    }

    @Test
    public void timeConflictDepth10() {
        C9 c9 = new C9();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c9);
            callF19(c9);
            callF38(c9);
            callF57(c9);
            callF76(c9);
            callF95(c9);
            callF114(c9);
            callF133(c9);
            callF152(c9);
            callF171(c9);
            callF0(c9);
            callF19(c9);
            callF38(c9);
            callF57(c9);
            callF76(c9);
            callF95(c9);
            callF114(c9);
            callF133(c9);
            callF152(c9);
            callF171(c9);
        }
    }

    @Test
    public void timeConflictDepth11() {
        C10 c10 = new C10();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c10);
            callF19(c10);
            callF38(c10);
            callF57(c10);
            callF76(c10);
            callF95(c10);
            callF114(c10);
            callF133(c10);
            callF152(c10);
            callF171(c10);
            callF190(c10);
            callF0(c10);
            callF19(c10);
            callF38(c10);
            callF57(c10);
            callF76(c10);
            callF95(c10);
            callF114(c10);
            callF133(c10);
            callF152(c10);
        }
    }

    @Test
    public void timeConflictDepth12() {
        C11 c11 = new C11();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c11);
            callF19(c11);
            callF38(c11);
            callF57(c11);
            callF76(c11);
            callF95(c11);
            callF114(c11);
            callF133(c11);
            callF152(c11);
            callF171(c11);
            callF190(c11);
            callF209(c11);
            callF0(c11);
            callF19(c11);
            callF38(c11);
            callF57(c11);
            callF76(c11);
            callF95(c11);
            callF114(c11);
            callF133(c11);
        }
    }

    @Test
    public void timeConflictDepth13() {
        C12 c12 = new C12();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c12);
            callF19(c12);
            callF38(c12);
            callF57(c12);
            callF76(c12);
            callF95(c12);
            callF114(c12);
            callF133(c12);
            callF152(c12);
            callF171(c12);
            callF190(c12);
            callF209(c12);
            callF228(c12);
            callF0(c12);
            callF19(c12);
            callF38(c12);
            callF57(c12);
            callF76(c12);
            callF95(c12);
            callF114(c12);
        }
    }

    @Test
    public void timeConflictDepth14() {
        C13 c13 = new C13();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c13);
            callF19(c13);
            callF38(c13);
            callF57(c13);
            callF76(c13);
            callF95(c13);
            callF114(c13);
            callF133(c13);
            callF152(c13);
            callF171(c13);
            callF190(c13);
            callF209(c13);
            callF228(c13);
            callF247(c13);
            callF0(c13);
            callF19(c13);
            callF38(c13);
            callF57(c13);
            callF76(c13);
            callF95(c13);
        }
    }

    @Test
    public void timeConflictDepth15() {
        C14 c14 = new C14();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c14);
            callF19(c14);
            callF38(c14);
            callF57(c14);
            callF76(c14);
            callF95(c14);
            callF114(c14);
            callF133(c14);
            callF152(c14);
            callF171(c14);
            callF190(c14);
            callF209(c14);
            callF228(c14);
            callF247(c14);
            callF266(c14);
            callF0(c14);
            callF19(c14);
            callF38(c14);
            callF57(c14);
            callF76(c14);
        }
    }

    @Test
    public void timeConflictDepth16() {
        C15 c15 = new C15();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c15);
            callF19(c15);
            callF38(c15);
            callF57(c15);
            callF76(c15);
            callF95(c15);
            callF114(c15);
            callF133(c15);
            callF152(c15);
            callF171(c15);
            callF190(c15);
            callF209(c15);
            callF228(c15);
            callF247(c15);
            callF266(c15);
            callF285(c15);
            callF0(c15);
            callF19(c15);
            callF38(c15);
            callF57(c15);
        }
    }

    @Test
    public void timeConflictDepth17() {
        C16 c16 = new C16();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c16);
            callF19(c16);
            callF38(c16);
            callF57(c16);
            callF76(c16);
            callF95(c16);
            callF114(c16);
            callF133(c16);
            callF152(c16);
            callF171(c16);
            callF190(c16);
            callF209(c16);
            callF228(c16);
            callF247(c16);
            callF266(c16);
            callF285(c16);
            callF304(c16);
            callF0(c16);
            callF19(c16);
            callF38(c16);
        }
    }

    @Test
    public void timeConflictDepth18() {
        C17 c17 = new C17();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c17);
            callF19(c17);
            callF38(c17);
            callF57(c17);
            callF76(c17);
            callF95(c17);
            callF114(c17);
            callF133(c17);
            callF152(c17);
            callF171(c17);
            callF190(c17);
            callF209(c17);
            callF228(c17);
            callF247(c17);
            callF266(c17);
            callF285(c17);
            callF304(c17);
            callF323(c17);
            callF0(c17);
            callF19(c17);
        }
    }

    @Test
    public void timeConflictDepth19() {
        C18 c18 = new C18();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c18);
            callF19(c18);
            callF38(c18);
            callF57(c18);
            callF76(c18);
            callF95(c18);
            callF114(c18);
            callF133(c18);
            callF152(c18);
            callF171(c18);
            callF190(c18);
            callF209(c18);
            callF228(c18);
            callF247(c18);
            callF266(c18);
            callF285(c18);
            callF304(c18);
            callF323(c18);
            callF342(c18);
            callF0(c18);
        }
    }

    @Test
    public void timeConflictDepth20() {
        C19 c19 = new C19();
        BenchmarkState state = mPerfStatusReporter.getBenchmarkState();
        while (state.keepRunning()) {
            callF0(c19);
            callF19(c19);
            callF38(c19);
            callF57(c19);
            callF76(c19);
            callF95(c19);
            callF114(c19);
            callF133(c19);
            callF152(c19);
            callF171(c19);
            callF190(c19);
            callF209(c19);
            callF228(c19);
            callF247(c19);
            callF266(c19);
            callF285(c19);
            callF304(c19);
            callF323(c19);
            callF342(c19);
            callF361(c19);
        }
    }

    public void callF0(I0 i) {
        i.f0();
    }

    public void callF19(I1 i) {
        i.f19();
    }

    public void callF38(I2 i) {
        i.f38();
    }

    public void callF57(I3 i) {
        i.f57();
    }

    public void callF76(I4 i) {
        i.f76();
    }

    public void callF95(I5 i) {
        i.f95();
    }

    public void callF114(I6 i) {
        i.f114();
    }

    public void callF133(I7 i) {
        i.f133();
    }

    public void callF152(I8 i) {
        i.f152();
    }

    public void callF171(I9 i) {
        i.f171();
    }

    public void callF190(I10 i) {
        i.f190();
    }

    public void callF209(I11 i) {
        i.f209();
    }

    public void callF228(I12 i) {
        i.f228();
    }

    public void callF247(I13 i) {
        i.f247();
    }

    public void callF266(I14 i) {
        i.f266();
    }

    public void callF285(I15 i) {
        i.f285();
    }

    public void callF304(I16 i) {
        i.f304();
    }

    public void callF323(I17 i) {
        i.f323();
    }

    public void callF342(I18 i) {
        i.f342();
    }

    public void callF361(I19 i) {
        i.f361();
    }

    static class C0 implements I0 {}

    static class C1 implements I0, I1 {}

    static class C2 implements I0, I1, I2 {}

    static class C3 implements I0, I1, I2, I3 {}

    static class C4 implements I0, I1, I2, I3, I4 {}

    static class C5 implements I0, I1, I2, I3, I4, I5 {}

    static class C6 implements I0, I1, I2, I3, I4, I5, I6 {}

    static class C7 implements I0, I1, I2, I3, I4, I5, I6, I7 {}

    static class C8 implements I0, I1, I2, I3, I4, I5, I6, I7, I8 {}

    static class C9 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9 {}

    static class C10 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10 {}

    static class C11 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11 {}

    static class C12 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12 {}

    static class C13 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13 {}

    static class C14 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14 {}

    static class C15
            implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15 {}

    static class C16
            implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16 {}

    static class C17
            implements I0,
                    I1,
                    I2,
                    I3,
                    I4,
                    I5,
                    I6,
                    I7,
                    I8,
                    I9,
                    I10,
                    I11,
                    I12,
                    I13,
                    I14,
                    I15,
                    I16,
                    I17 {}

    static class C18
            implements I0,
                    I1,
                    I2,
                    I3,
                    I4,
                    I5,
                    I6,
                    I7,
                    I8,
                    I9,
                    I10,
                    I11,
                    I12,
                    I13,
                    I14,
                    I15,
                    I16,
                    I17,
                    I18 {}

    static class C19
            implements I0,
                    I1,
                    I2,
                    I3,
                    I4,
                    I5,
                    I6,
                    I7,
                    I8,
                    I9,
                    I10,
                    I11,
                    I12,
                    I13,
                    I14,
                    I15,
                    I16,
                    I17,
                    I18,
                    I19 {}

    interface I0 {
        default void f0() {}

        default void f1() {}

        default void f2() {}

        default void f3() {}

        default void f4() {}

        default void f5() {}

        default void f6() {}

        default void f7() {}

        default void f8() {}

        default void f9() {}

        default void f10() {}

        default void f11() {}

        default void f12() {}

        default void f13() {}

        default void f14() {}

        default void f15() {}

        default void f16() {}

        default void f17() {}

        default void f18() {}
    }

    interface I1 {
        default void f19() {}

        default void f20() {}

        default void f21() {}

        default void f22() {}

        default void f23() {}

        default void f24() {}

        default void f25() {}

        default void f26() {}

        default void f27() {}

        default void f28() {}

        default void f29() {}

        default void f30() {}

        default void f31() {}

        default void f32() {}

        default void f33() {}

        default void f34() {}

        default void f35() {}

        default void f36() {}

        default void f37() {}
    }

    interface I2 {
        default void f38() {}

        default void f39() {}

        default void f40() {}

        default void f41() {}

        default void f42() {}

        default void f43() {}

        default void f44() {}

        default void f45() {}

        default void f46() {}

        default void f47() {}

        default void f48() {}

        default void f49() {}

        default void f50() {}

        default void f51() {}

        default void f52() {}

        default void f53() {}

        default void f54() {}

        default void f55() {}

        default void f56() {}
    }

    interface I3 {
        default void f57() {}

        default void f58() {}

        default void f59() {}

        default void f60() {}

        default void f61() {}

        default void f62() {}

        default void f63() {}

        default void f64() {}

        default void f65() {}

        default void f66() {}

        default void f67() {}

        default void f68() {}

        default void f69() {}

        default void f70() {}

        default void f71() {}

        default void f72() {}

        default void f73() {}

        default void f74() {}

        default void f75() {}
    }

    interface I4 {
        default void f76() {}

        default void f77() {}

        default void f78() {}

        default void f79() {}

        default void f80() {}

        default void f81() {}

        default void f82() {}

        default void f83() {}

        default void f84() {}

        default void f85() {}

        default void f86() {}

        default void f87() {}

        default void f88() {}

        default void f89() {}

        default void f90() {}

        default void f91() {}

        default void f92() {}

        default void f93() {}

        default void f94() {}
    }

    interface I5 {
        default void f95() {}

        default void f96() {}

        default void f97() {}

        default void f98() {}

        default void f99() {}

        default void f100() {}

        default void f101() {}

        default void f102() {}

        default void f103() {}

        default void f104() {}

        default void f105() {}

        default void f106() {}

        default void f107() {}

        default void f108() {}

        default void f109() {}

        default void f110() {}

        default void f111() {}

        default void f112() {}

        default void f113() {}
    }

    interface I6 {
        default void f114() {}

        default void f115() {}

        default void f116() {}

        default void f117() {}

        default void f118() {}

        default void f119() {}

        default void f120() {}

        default void f121() {}

        default void f122() {}

        default void f123() {}

        default void f124() {}

        default void f125() {}

        default void f126() {}

        default void f127() {}

        default void f128() {}

        default void f129() {}

        default void f130() {}

        default void f131() {}

        default void f132() {}
    }

    interface I7 {
        default void f133() {}

        default void f134() {}

        default void f135() {}

        default void f136() {}

        default void f137() {}

        default void f138() {}

        default void f139() {}

        default void f140() {}

        default void f141() {}

        default void f142() {}

        default void f143() {}

        default void f144() {}

        default void f145() {}

        default void f146() {}

        default void f147() {}

        default void f148() {}

        default void f149() {}

        default void f150() {}

        default void f151() {}
    }

    interface I8 {
        default void f152() {}

        default void f153() {}

        default void f154() {}

        default void f155() {}

        default void f156() {}

        default void f157() {}

        default void f158() {}

        default void f159() {}

        default void f160() {}

        default void f161() {}

        default void f162() {}

        default void f163() {}

        default void f164() {}

        default void f165() {}

        default void f166() {}

        default void f167() {}

        default void f168() {}

        default void f169() {}

        default void f170() {}
    }

    interface I9 {
        default void f171() {}

        default void f172() {}

        default void f173() {}

        default void f174() {}

        default void f175() {}

        default void f176() {}

        default void f177() {}

        default void f178() {}

        default void f179() {}

        default void f180() {}

        default void f181() {}

        default void f182() {}

        default void f183() {}

        default void f184() {}

        default void f185() {}

        default void f186() {}

        default void f187() {}

        default void f188() {}

        default void f189() {}
    }

    interface I10 {
        default void f190() {}

        default void f191() {}

        default void f192() {}

        default void f193() {}

        default void f194() {}

        default void f195() {}

        default void f196() {}

        default void f197() {}

        default void f198() {}

        default void f199() {}

        default void f200() {}

        default void f201() {}

        default void f202() {}

        default void f203() {}

        default void f204() {}

        default void f205() {}

        default void f206() {}

        default void f207() {}

        default void f208() {}
    }

    interface I11 {
        default void f209() {}

        default void f210() {}

        default void f211() {}

        default void f212() {}

        default void f213() {}

        default void f214() {}

        default void f215() {}

        default void f216() {}

        default void f217() {}

        default void f218() {}

        default void f219() {}

        default void f220() {}

        default void f221() {}

        default void f222() {}

        default void f223() {}

        default void f224() {}

        default void f225() {}

        default void f226() {}

        default void f227() {}
    }

    interface I12 {
        default void f228() {}

        default void f229() {}

        default void f230() {}

        default void f231() {}

        default void f232() {}

        default void f233() {}

        default void f234() {}

        default void f235() {}

        default void f236() {}

        default void f237() {}

        default void f238() {}

        default void f239() {}

        default void f240() {}

        default void f241() {}

        default void f242() {}

        default void f243() {}

        default void f244() {}

        default void f245() {}

        default void f246() {}
    }

    interface I13 {
        default void f247() {}

        default void f248() {}

        default void f249() {}

        default void f250() {}

        default void f251() {}

        default void f252() {}

        default void f253() {}

        default void f254() {}

        default void f255() {}

        default void f256() {}

        default void f257() {}

        default void f258() {}

        default void f259() {}

        default void f260() {}

        default void f261() {}

        default void f262() {}

        default void f263() {}

        default void f264() {}

        default void f265() {}
    }

    interface I14 {
        default void f266() {}

        default void f267() {}

        default void f268() {}

        default void f269() {}

        default void f270() {}

        default void f271() {}

        default void f272() {}

        default void f273() {}

        default void f274() {}

        default void f275() {}

        default void f276() {}

        default void f277() {}

        default void f278() {}

        default void f279() {}

        default void f280() {}

        default void f281() {}

        default void f282() {}

        default void f283() {}

        default void f284() {}
    }

    interface I15 {
        default void f285() {}

        default void f286() {}

        default void f287() {}

        default void f288() {}

        default void f289() {}

        default void f290() {}

        default void f291() {}

        default void f292() {}

        default void f293() {}

        default void f294() {}

        default void f295() {}

        default void f296() {}

        default void f297() {}

        default void f298() {}

        default void f299() {}

        default void f300() {}

        default void f301() {}

        default void f302() {}

        default void f303() {}
    }

    interface I16 {
        default void f304() {}

        default void f305() {}

        default void f306() {}

        default void f307() {}

        default void f308() {}

        default void f309() {}

        default void f310() {}

        default void f311() {}

        default void f312() {}

        default void f313() {}

        default void f314() {}

        default void f315() {}

        default void f316() {}

        default void f317() {}

        default void f318() {}

        default void f319() {}

        default void f320() {}

        default void f321() {}

        default void f322() {}
    }

    interface I17 {
        default void f323() {}

        default void f324() {}

        default void f325() {}

        default void f326() {}

        default void f327() {}

        default void f328() {}

        default void f329() {}

        default void f330() {}

        default void f331() {}

        default void f332() {}

        default void f333() {}

        default void f334() {}

        default void f335() {}

        default void f336() {}

        default void f337() {}

        default void f338() {}

        default void f339() {}

        default void f340() {}

        default void f341() {}
    }

    interface I18 {
        default void f342() {}

        default void f343() {}

        default void f344() {}

        default void f345() {}

        default void f346() {}

        default void f347() {}

        default void f348() {}

        default void f349() {}

        default void f350() {}

        default void f351() {}

        default void f352() {}

        default void f353() {}

        default void f354() {}

        default void f355() {}

        default void f356() {}

        default void f357() {}

        default void f358() {}

        default void f359() {}

        default void f360() {}
    }

    interface I19 {
        default void f361() {}

        default void f362() {}

        default void f363() {}

        default void f364() {}

        default void f365() {}

        default void f366() {}

        default void f367() {}

        default void f368() {}

        default void f369() {}

        default void f370() {}

        default void f371() {}

        default void f372() {}

        default void f373() {}

        default void f374() {}

        default void f375() {}

        default void f376() {}

        default void f377() {}

        default void f378() {}

        default void f379() {}
    }
}
