/**
 * Copyright (c) 2015-2023 Governikus GmbH & Co. KG, Germany
 */

#include "SecureMessagingTypes.h"

using namespace governikus;


namespace governikus
{

ASN1_ITEM_TEMPLATE(SM_ENCRYPTED_DATA) =
			ASN1_EX_TEMPLATE_TYPE(ASN1_TFLG_IMPTAG | ASN1_TFLG_CONTEXT, 0x07, SM_ENCRYPTED_DATA, ASN1_OCTET_STRING)
ASN1_ITEM_TEMPLATE_END(SM_ENCRYPTED_DATA)
IMPLEMENT_ASN1_FUNCTIONS(SM_ENCRYPTED_DATA)
IMPLEMENT_ASN1_OBJECT(SM_ENCRYPTED_DATA)


ASN1_ITEM_TEMPLATE(SM_PROTECTED_LE) =
			ASN1_EX_TEMPLATE_TYPE(ASN1_TFLG_IMPTAG | ASN1_TFLG_CONTEXT, 0x17, SM_PROTECTED_LE, ASN1_OCTET_STRING)
ASN1_ITEM_TEMPLATE_END(SM_PROTECTED_LE)
IMPLEMENT_ASN1_FUNCTIONS(SM_PROTECTED_LE)
IMPLEMENT_ASN1_OBJECT(SM_PROTECTED_LE)


ASN1_ITEM_TEMPLATE(SM_PROCESSING_STATUS) =
			ASN1_EX_TEMPLATE_TYPE(ASN1_TFLG_IMPTAG | ASN1_TFLG_CONTEXT, 0x19, SM_PROCESSING_STATUS, ASN1_OCTET_STRING)
ASN1_ITEM_TEMPLATE_END(SM_PROCESSING_STATUS)
IMPLEMENT_ASN1_FUNCTIONS(SM_PROCESSING_STATUS)
IMPLEMENT_ASN1_OBJECT(SM_PROCESSING_STATUS)


ASN1_ITEM_TEMPLATE(SM_CHECKSUM) =
			ASN1_EX_TEMPLATE_TYPE(ASN1_TFLG_IMPTAG | ASN1_TFLG_CONTEXT, 0x0E, SM_CHECKSUM, ASN1_OCTET_STRING)
ASN1_ITEM_TEMPLATE_END(SM_CHECKSUM)
IMPLEMENT_ASN1_FUNCTIONS(SM_CHECKSUM)
IMPLEMENT_ASN1_OBJECT(SM_CHECKSUM)


}  // namespace governikus
