/* Copyright © Charliecloud contributors.

   Filesystem-related things; note that this includes path manipulation that
   works purely at the string level, i.e. does not interact with any actual
   storage. */

#define _GNU_SOURCE
#pragma once

#include <stdbool.h>
#include <stdio.h>
#include <sys/stat.h>

#include "misc.h"


/** Disallowed library functions **/

#define getcwd FN_BLOCKED
#define getdelim FN_BLOCKED
#define realpath FN_BLOCKED
#define dirname FN_BLOCKED

/** Function prototypes **/

char **dir_glob(const char *path, const char *glob);
int dir_glob_count(const char *path, const char *glob);
char *dirname_ch(const char *path);
char *getcwd_ch(void);
char *getdelim_ch(FILE *fp, char delim);
void mkdirs(const char *base, const char *path, char **denylist,
            const char *scratch);
char *path_absolve(const char *path, const char *cwd, bool cwd_parent_p);
bool path_exists(const char *path, struct stat *statbuf, bool follow_symlink);
char *path_join(const char *a, const char *b);
unsigned long path_mount_flags(const char *path);
void path_split(const char *path, char **dir, char **base);
bool path_subdir_p(const char *base, const char *path);
char *path_tidy(const char *path);
char *realpath_ch(const char *path);