struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 1173,
		.content =
			"processor\t: 0\n"
			"model name\t: ARMv7 Processor rev 0 (v7l)\n"
			"BogoMIPS\t: 38.40\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 evtstrm \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 0\n"
			"\n"
			"processor\t: 1\n"
			"model name\t: ARMv7 Processor rev 0 (v7l)\n"
			"BogoMIPS\t: 38.40\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 evtstrm \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 0\n"
			"\n"
			"processor\t: 2\n"
			"model name\t: ARMv7 Processor rev 0 (v7l)\n"
			"BogoMIPS\t: 38.40\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 evtstrm \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 0\n"
			"\n"
			"processor\t: 3\n"
			"model name\t: ARMv7 Processor rev 0 (v7l)\n"
			"BogoMIPS\t: 38.40\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 evtstrm \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 0\n"
			"\n"
			"Hardware\t: Qualcomm Technologies, Inc MSM8916\n"
			"Revision\t: 0005\n"
			"Serial\t\t: 0000023100006111\n"
			"Processor\t: ARMv7 Processor rev 0 (v7l)\n",
	},
	{
		.path = "/system/build.prop",
		.size = 8851,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=MMB29M\n"
			"ro.build.display.id=MMB29M.J500MUBU1BQA1\n"
			"ro.build.version.incremental=J500MUBU1BQA1\n"
			"ro.build.version.sdk=23\n"
			"ro.build.version.preview_sdk=0\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=6.0.1\n"
			"ro.build.version.security_patch=2017-01-01\n"
			"ro.build.version.base_os=\n"
			"ro.build.date=Tue Jan  3 01:45:41 KST 2017\n"
			"ro.build.date.utc=1483375541\n"
			"ro.build.type=user\n"
			"ro.build.user=dpi\n"
			"ro.build.host=SWHE8817\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=j5lteub-user\n"
			"ro.product.model=SM-J500M\n"
			"ro.product.brand=samsung\n"
			"ro.product.name=j5lteub\n"
			"ro.product.device=j5lte\n"
			"ro.product.board=MSM8916\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=armeabi-v7a\n"
			"ro.product.cpu.abi2=armeabi\n"
			"ro.product.cpu.abilist=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=\n"
			"ro.product.manufacturer=samsung\n"
			"ro.product.locale=en-GB\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=msm8916\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=j5lte\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=j5lteub-user 6.0.1 MMB29M J500MUBU1BQA1 release-keys\n"
			"ro.build.fingerprint=samsung/j5lteub/j5lte:6.0.1/MMB29M/J500MUBU1BQA1:user/release-keys\n"
			"ro.build.characteristics=default\n"
			"# Samsung Specific Properties\n"
			"ro.build.PDA=J500MUBU1BQA1\n"
			"ro.build.hidden_ver=J500MUBU1BQA1\n"
			"ro.config.rm_preload_enabled=0\n"
			"ro.build.changelist=10283451\n"
			"ro.product_ship=true\n"
			"ro.build.official.release=true\n"
			"ro.chipname=MSM8916\n"
			"# end build properties\n"
			"\n"
			"#\n"
			"# HWUI_BUILD_PROPERTIES\n"
			"#\n"
			"ro.hwui.texture_cache_size=24\n"
			"ro.hwui.layer_cache_size=16\n"
			"ro.hwui.path_cache_size=4\n"
			"ro.hwui.texture_cache_flushrate=0.4\n"
			"ro.hwui.shape_cache_size=1\n"
			"ro.hwui.gradient_cache_size=0.5\n"
			"ro.hwui.drop_shadow_cache_size=2\n"
			"ro.hwui.r_buffer_cache_size=2\n"
			"ro.hwui.text_small_cache_width=1024\n"
			"ro.hwui.text_small_cache_height=512\n"
			"ro.hwui.text_large_cache_width=2048\n"
			"ro.hwui.text_large_cache_height=1024\n"
			"#\n"
			"# from device/samsung/j5lte/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for msm8916\n"
			"#\n"
			"\n"
			"# Evolution RIL (8xxx)\n"
			"#\n"
			"# Integrate the Kineto VOWIFI changes\n"
			"rild.libpath=/system/lib/libsec-ril.so\n"
			"#rild.libpath=/system/lib/librilswitch.so\n"
			"rilswitch.vendorlibpath=/system/lib/libsec-ril.so\n"
			"rilswitch.cfilibpath=/system/lib/libcfiril.so\n"
			"# End of kineto change\n"
			"#\n"
			"rild.libargs=-d /dev/smd0\n"
			"persist.rild.nitz_plmn=\n"
			"persist.rild.nitz_long_ons_0=\n"
			"persist.rild.nitz_long_ons_1=\n"
			"persist.rild.nitz_long_ons_2=\n"
			"persist.rild.nitz_long_ons_3=\n"
			"persist.rild.nitz_short_ons_0=\n"
			"persist.rild.nitz_short_ons_1=\n"
			"persist.rild.nitz_short_ons_2=\n"
			"persist.rild.nitz_short_ons_3=\n"
			"ril.subscription.types=NV,RUIM\n"
			"DEVICE_PROVISIONED=1\n"
			"\n"
			"debug.sf.hw=1\n"
			"debug.egl.hw=1\n"
			"persist.hwc.mdpcomp.enable=true\n"
			"debug.mdpcomp.logs=0\n"
			"dalvik.vm.heapsize=36m\n"
			"dev.pm.dyn_samplingrate=1\n"
			"persist.demo.hdmirotationlock=false\n"
			"debug.enable.sglscale=1\n"
			"\n"
			"#ro.hdmi.enable=true\n"
			"#tunnel.decode=true\n"
			"#tunnel.audiovideo.decode=true\n"
			"#lpa.decode=false\n"
			"#lpa.use-stagefright=true\n"
			"#persist.speaker.prot.enable=false\n"
			"\n"
			"#\n"
			"# system props for the cne module\n"
			"#\n"
			"persist.cne.feature=0\n"
			"persist.cne.dpm=0\n"
			"persist.dpm.feature=0\n"
			"\n"
			"#\n"
			"# system props for the dpm module\n"
			"#\n"
			"persist.dpm.feature=3\n"
			"\n"
			"#system props for the MM modules\n"
			"media.stagefright.enable-player=true\n"
			"media.stagefright.enable-http=true\n"
			"media.stagefright.enable-aac=true\n"
			"media.stagefright.enable-qcp=true\n"
			"media.stagefright.enable-fma2dp=true\n"
			"media.stagefright.enable-scan=true\n"
			"media.msm8939hw=0\n"
			"media.msm8929hw=0\n"
			"mm.enable.smoothstreaming=true\n"
			"mmp.enable.3g2=true\n"
			"media.aac_51_output_enabled=true\n"
			"\n"
			"#codecs:(PARSER_)AAC AC3 AMR_NB AMR_WB ASF AVI DTS FLV 3GP 3G2 MKV MP2PS MP2TS MP3 OGG QCP WAV FLAC DIVX DIVXHD\n"
			"mm.enable.qcom_parser=3407871\n"
			"\n"
			"# Default to AwesomePlayer\n"
			"media.stagefright.use-awesome=false\n"
			"\n"
			"#\n"
			"# system props for the data modules\n"
			"#\n"
			"ro.use_data_netmgrd=false\n"
			"persist.data.netmgrd.qos.enable=false\n"
			"\n"
			"#system props for time-services\n"
			"persist.timed.enable=true\n"
			"\n"
			"#\n"
			"# system prop for opengles version\n"
			"# 196608 is decimal for 0x30000 to report version 3\n"
			"# This setting will be added automatically on runtime based on chipset.\n"
			"# Do not enable this setting.\n"
			"ro.opengles.version=196608\n"
			"\n"
			"# System property for cabl\n"
			"ro.qualcomm.cabl=2\n"
			"\n"
			"#\n"
			"# System props for bluetooh\n"
			"# System prop to turn on hfp client\n"
			"bluetooth.hfp.client=1\n"
			"\n"
			"#Simulate sdcard on /data/media\n"
			"#\n"
			"persist.fuse_sdcard=true\n"
			"\n"
			"#\n"
			"#snapdragon value add features\n"
			"#\n"
			"ro.qc.sdk.audio.ssr=false\n"
			"##fluencetype can be \"fluence\" or \"fluencepro\" or \"none\"\n"
			"ro.qc.sdk.audio.fluencetype=none\n"
			"persist.audio.fluence.voicecall=true\n"
			"persist.audio.fluence.voicerec=false\n"
			"persist.audio.fluence.speaker=true\n"
			"#Set for msm8916\n"
			"tunnel.audio.encode = false\n"
			"#Buffer size in kbytes for compress offload playback\n"
			"audio.offload.buffer.size.kb=64\n"
			"#Minimum duration for offload playback in secs\n"
			"audio.offload.min.duration.secs=30\n"
			"#Enable offload audio video playback by default\n"
			"audio.offload.video=true\n"
			"#enable voice path for PCM VoIP by default\n"
			"use.voice.path.for.pcm.voip=true\n"
			"#\n"
			"#System property for FM transmitter\n"
			"#\n"
			"ro.fm.transmitter=false\n"
			"#enable dsp gapless mode by default\n"
			"audio.offload.gapless.enabled=true\n"
			"\n"
			"#Audio voice concurrency related flags\n"
			"voice.playback.conc.disabled=true\n"
			"voice.record.conc.disabled=true\n"
			"voice.voip.conc.disabled=true\n"
			"\n"
			"# set lcd density\n"
			"ro.sf.lcd_density=320\n"
			"\n"
			"\n"
			"#Set read only default composition for USB\n"
			"ro.sys.usb.default.config=diag,serial_smd,rmnet_bam,adb\n"
			"\n"
			"# set max background services\n"
			"ro.config.max_starting_bg=8\n"
			"\n"
			"#property to enable user to access Google WFD settings\n"
			"persist.debug.wfd.enable=1\n"
			"#propery to enable VDS WFD solution\n"
			"persist.hwc.enable_vds=1\n"
			"\n"
			"#selects CoreSight configuration to enable\n"
			"persist.debug.coresight.config=stm-events\n"
			"\n"
			"#property to enable narrow search range for video encoding\n"
			"vidc.enc.narrow.searchrange=1\n"
			"\n"
			"#property to enable DS2 dap\n"
			"audio.dolby.ds2.enabled=true\n"
			"\n"
			"#HWUI properties\n"
			"ro.hwui.text_large_cache_height=2048\n"
			"#Trim properties\n"
			"ro.sys.fw.use_trim_settings=true\n"
			"ro.sys.fw.empty_app_percent=50\n"
			"ro.sys.fw.trim_empty_percent=100\n"
			"ro.sys.fw.trim_cache_percent=100\n"
			"ro.sys.fw.trim_enable_memory=1073741824\n"
			"\n"
			"#Factory Reset Protection\n"
			"#ro.frp.pst=/dev/block/bootdevice/by-name/config\n"
			"\n"
			"# system property for PIP support\n"
			"persist.camera.pip.support=0\n"
			"\n"
			"#Enable B service adj transition by default\n"
			"ro.sys.fw.bservice_enable=true\n"
			"ro.sys.fw.bservice_limit=5\n"
			"ro.sys.fw.bservice_age=5000\n"
			"\n"
			"#Optimal dex2oat threads for faster app installation\n"
			"ro.sys.fw.dex2oat_thread_count=4\n"
			"\n"
			"#min/max cpu in core control\n"
			"ro.core_ctl_min_cpu=2\n"
			"ro.core_ctl_max_cpu=4\n"
			"\n"
			"# VoLTE/IMS\n"
			"persist.radio.jbims=1\n"
			"\n"
			"# System property for storage_preload\n"
			"persist.sys.storage_preload=1\n"
			"\n"
			"# SAMP_SPCM\n"
			"sys.config.samp_spcm_enable=true\n"
			"sys.config.spcm_db_enable=true\n"
			"sys.config.spcm_db_launcher=true\n"
			"sys.config.spcm_preload_enable=true\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.astcenc.astcsupport=1\n"
			"ro.mct.compressiontype=ETC1\n"
			"ro.config.tima=1\n"
			"ro.config.timaversion=3.0\n"
			"ro.config.dmverity=true\n"
			"ro.config.kap=true\n"
			"ro.use_data_netmgrd=false\n"
			"persist.radio.sib16_support=0\n"
			"ro.telephony.default_network=9\n"
			"keyguard.no_require_sim=true\n"
			"ro.carrier=unknown\n"
			"ro.com.google.clientidbase=android-samsung\n"
			"ro.error.receiver.default=com.samsung.receiver.error\n"
			"ro.security.icd.flagmode=single\n"
			"security.ASKS.policy_version=000000\n"
			"ro.vendor.extension_library=libqti-perfd-client.so\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"dalvik.vm.heapstartsize=8m\n"
			"dalvik.vm.heapgrowthlimit=128m\n"
			"dalvik.vm.heapsize=512m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=2m\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"security.mdpp.mass=skmm\n"
			"ro.security.vpnpp.ver=1.4\n"
			"ro.security.vpnpp.release=7.0\n"
			"ro.hdcp2.rx=tz\n"
			"media.enable-commonsource=true\n"
			"ro.secwvk=144\n"
			"ro.sec.fle.encryption=true\n"
			"ro.build.scafe.version=2016A\n"
			"ro.build.scafe.size=short\n"
			"ro.build.scafe.shot=single\n"
			"ro.build.scafe.cream=white\n"
			"ro.frp.pst=/dev/block/persistent\n"
			"ro.config.dha_cached_min=3\n"
			"ro.config.dha_cached_max=6\n"
			"ro.config.dha_empty_min=6\n"
			"ro.config.dha_empty_max=20\n"
			"ro.config.dha_empty_init=20\n"
			"ro.config.dha_th_rate=2.0\n"
			"ro.config.dha_lmk_scale=1.0\n"
			"ro.config.dha_pwhitelist_enable=1\n"
			"ro.config.ringtone=Over_the_Horizon.ogg\n"
			"ro.config.notification_sound=Skyline.ogg\n"
			"ro.config.alarm_alert=Morning_Flower.ogg\n"
			"ro.config.media_sound=Media_preview_Touch_the_light.ogg\n"
			"ro.config.ringtone_2=Basic_Bell.ogg\n"
			"ro.config.notification_sound_2=S_Charming_Bell.ogg\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=6.0_r10\n"
			"ro.build.selinux=1\n"
			"persist.sys.dalvik.vm.lib.2=libart\n"
			"dalvik.vm.isa.arm.variant=cortex-a53\n"
			"dalvik.vm.isa.arm.features=default\n"
			"ro.config.knox=v30\n"
			"ro.config.iccc_version=1.0\n"
			"ro.kernel.qemu=0\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"persist.gps.qc_nlp_in_use=1\n"
			"persist.loc.nlp_name=com.qualcomm.location\n"
			"ro.gps.agps_provider=1\n"
			"ro.build.version.sdl=2301\n"
			"ro.expect.recovery_id=0xbb1fabe069470980fa763c4466ee8185f2c98951000000000000000000000000\n"
			"\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 184,
		.content =
			"freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\t\n"
			"200000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			"400000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			"533333\t\t0\t\t0\t\t0\t\t0\t\t\n"
			"800000\t\t6\t\t0\t\t0\t\t0\t\t\n"
			"998400\t\t1\t\t0\t\t0\t\t0\t\t\n"
			"1094400\t\t13\t\t0\t\t0\t\t0\t\t\n"
			"1190400\t\t3342\t\t0\t\t0\t\t0\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/current_in_state",
		.size = 0,
		.content = "",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 52,
		.content = "200000 400000 533333 800000 998400 1094400 1190400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 45,
		.content = "interactive userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "800000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 69,
		.content =
			"200000 0\n"
			"400000 0\n"
			"533333 0\n"
			"800000 6\n"
			"998400 3\n"
			"1094400 23\n"
			"1190400 3421\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 3,
		.content = "14\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 52,
		.content = "200000 400000 533333 800000 998400 1094400 1190400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 45,
		.content = "interactive userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "800000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 71,
		.content =
			"200000 0\n"
			"400000 0\n"
			"533333 0\n"
			"800000 18\n"
			"998400 20\n"
			"1094400 26\n"
			"1190400 3555\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 3,
		.content = "23\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 52,
		.content = "200000 400000 533333 800000 998400 1094400 1190400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 45,
		.content = "interactive userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "800000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "800000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 72,
		.content =
			"200000 0\n"
			"400000 0\n"
			"533333 0\n"
			"800000 112\n"
			"998400 37\n"
			"1094400 32\n"
			"1190400 3596\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 3,
		.content = "32\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 52,
		.content = "200000 400000 533333 800000 998400 1094400 1190400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 45,
		.content = "interactive userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "800000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "800000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 72,
		.content =
			"200000 0\n"
			"400000 0\n"
			"533333 0\n"
			"800000 190\n"
			"998400 84\n"
			"1094400 38\n"
			"1190400 3621\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 3,
		.content = "47\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 2,
		.content = "8\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{ NULL },
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "DEVICE_PROVISIONED",
		.value = "1",
	},
	{
		.key = "audio.dolby.ds2.enabled",
		.value = "true",
	},
	{
		.key = "audio.offload.buffer.size.kb",
		.value = "64",
	},
	{
		.key = "audio.offload.gapless.enabled",
		.value = "true",
	},
	{
		.key = "audio.offload.min.duration.secs",
		.value = "30",
	},
	{
		.key = "audio.offload.video",
		.value = "true",
	},
	{
		.key = "audioflinger.bootsnd",
		.value = "0",
	},
	{
		.key = "bluetooth.hfp.client",
		.value = "1",
	},
	{
		.key = "boot.sfbootcomplete",
		.value = "0",
	},
	{
		.key = "camera2.portability.force_api",
		.value = "1",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "128m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "2m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm.variant",
		.value = "cortex-a53",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.egl.hw",
		.value = "1",
	},
	{
		.key = "debug.enable.sglscale",
		.value = "1",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.mdpcomp.logs",
		.value = "0",
	},
	{
		.key = "debug.sf.hw",
		.value = "1",
	},
	{
		.key = "debug.sf.layerdump",
		.value = "0",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "dev.kies.deviceowner",
		.value = "0",
	},
	{
		.key = "dev.kies.drivedisplay",
		.value = "0",
	},
	{
		.key = "dev.kies.drivedisplay.trust",
		.value = "1",
	},
	{
		.key = "dev.kies.sommode",
		.value = "TRUE",
	},
	{
		.key = "dev.kiessupport",
		.value = "TRUE",
	},
	{
		.key = "dev.pm.dyn_samplingrate",
		.value = "1",
	},
	{
		.key = "dev.ssrm.appsync3p",
		.value = "true",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1,1",
	},
	{
		.key = "gsm.current.vsid",
		.value = "0",
	},
	{
		.key = "gsm.current.vsid2",
		.value = "1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown,Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "us",
	},
	{
		.key = "gsm.operator.ispsroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "310260",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = ",",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT,ABSENT",
	},
	{
		.key = "gsm.version.baseband",
		.value = "J500MUBU1BPL2",
	},
	{
		.key = "gsm.version.baseband1",
		.value = "J500MUBU1BPL2",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "Samsung RIL v3.0",
	},
	{
		.key = "init.svc.BCS-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.DR-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.RIDL",
		.value = "stopped",
	},
	{
		.key = "init.svc.SMD-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.TvoutService_C",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.at_distributor",
		.value = "running",
	},
	{
		.key = "init.svc.audiod",
		.value = "running",
	},
	{
		.key = "init.svc.auditd",
		.value = "running",
	},
	{
		.key = "init.svc.bms-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootchecker",
		.value = "running",
	},
	{
		.key = "init.svc.ccm",
		.value = "running",
	},
	{
		.key = "init.svc.compact_memory",
		.value = "stopped",
	},
	{
		.key = "init.svc.config_bluetooth",
		.value = "stopped",
	},
	{
		.key = "init.svc.cs_service",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.diag_uart_log",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.edmaudit",
		.value = "running",
	},
	{
		.key = "init.svc.epmlogd",
		.value = "stopped",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.gatekeeperd",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.icd",
		.value = "stopped",
	},
	{
		.key = "init.svc.imsd",
		.value = "running",
	},
	{
		.key = "init.svc.imsqmidaemon",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.insthk",
		.value = "stopped",
	},
	{
		.key = "init.svc.ipsec-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.irsc_util",
		.value = "stopped",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.loc_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.macloader",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mobex-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netmgrd",
		.value = "stopped",
	},
	{
		.key = "init.svc.otp",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.perfd",
		.value = "running",
	},
	{
		.key = "init.svc.powersnd",
		.value = "stopped",
	},
	{
		.key = "init.svc.prepare_param",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcamerasvr",
		.value = "running",
	},
	{
		.key = "init.svc.qcom-c_core-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-c_main-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-debug",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-post-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-usb-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qmuxd",
		.value = "running",
	},
	{
		.key = "init.svc.qseecomd",
		.value = "running",
	},
	{
		.key = "init.svc.qti-testscripts",
		.value = "stopped",
	},
	{
		.key = "init.svc.rfs_access",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon1",
		.value = "running",
	},
	{
		.key = "init.svc.rmt_storage",
		.value = "running",
	},
	{
		.key = "init.svc.run-mobicore",
		.value = "running",
	},
	{
		.key = "init.svc.scs",
		.value = "stopped",
	},
	{
		.key = "init.svc.sdp_cryptod",
		.value = "running",
	},
	{
		.key = "init.svc.sec-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.start_netmgrd",
		.value = "stopped",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.swapon",
		.value = "stopped",
	},
	{
		.key = "init.svc.tbaseLoader",
		.value = "stopped",
	},
	{
		.key = "init.svc.tftp_server",
		.value = "running",
	},
	{
		.key = "init.svc.thermal-engine",
		.value = "running",
	},
	{
		.key = "init.svc.time_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.wcnss-service",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "installd.sdcard_manipulate_done",
		.value = "0",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "logd.auditd",
		.value = "false",
	},
	{
		.key = "media.aac_51_output_enabled",
		.value = "true",
	},
	{
		.key = "media.enable-commonsource",
		.value = "true",
	},
	{
		.key = "media.msm8929hw",
		.value = "0",
	},
	{
		.key = "media.msm8939hw",
		.value = "0",
	},
	{
		.key = "media.stagefright.enable-aac",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-fma2dp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-http",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-player",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-qcp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-scan",
		.value = "true",
	},
	{
		.key = "media.stagefright.use-awesome",
		.value = "false",
	},
	{
		.key = "mm.enable.qcom_parser",
		.value = "3407871",
	},
	{
		.key = "mm.enable.smoothstreaming",
		.value = "true",
	},
	{
		.key = "mmp.enable.3g2",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.qtaguid_enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-5951834d6d5e446b",
	},
	{
		.key = "net.knox.shareddevice.version",
		.value = "2.6.0",
	},
	{
		.key = "net.knoxscep.version",
		.value = "2.0.1",
	},
	{
		.key = "net.knoxsso.version",
		.value = "2.5.0",
	},
	{
		.key = "net.knoxvpn.version",
		.value = "2.3.0",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.smart_switch.disabled",
		.value = "1",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,524288,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,524288,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "2097152,4194304,8388608,262144,524288,1048576",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,2097152,4525824,524288,1048576,4525824",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "net.tcp.delack.default",
		.value = "1",
	},
	{
		.key = "net.tcp.delack.wifi",
		.value = "20",
	},
	{
		.key = "net.tcp.usercfg.default",
		.value = "0",
	},
	{
		.key = "net.tcp.usercfg.wifi",
		.value = "1",
	},
	{
		.key = "persist.audio.allsoundmute",
		.value = "0",
	},
	{
		.key = "persist.audio.cpufreq",
		.value = "350000",
	},
	{
		.key = "persist.audio.finemediavolume",
		.value = "1",
	},
	{
		.key = "persist.audio.fluence.speaker",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicecall",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicerec",
		.value = "false",
	},
	{
		.key = "persist.audio.globaleffect",
		.value = "1",
	},
	{
		.key = "persist.audio.headsetsysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.hphonesysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.mpseek",
		.value = "0",
	},
	{
		.key = "persist.audio.mysound",
		.value = "1",
	},
	{
		.key = "persist.audio.ringermode",
		.value = "2",
	},
	{
		.key = "persist.audio.sales_code",
		.value = "TTT",
	},
	{
		.key = "persist.audio.soundalivefxsec",
		.value = "1",
	},
	{
		.key = "persist.audio.stereospeaker",
		.value = "0",
	},
	{
		.key = "persist.audio.sysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.uhqa",
		.value = "0",
	},
	{
		.key = "persist.audio.voipcpufreq",
		.value = "350000",
	},
	{
		.key = "persist.camera.incall",
		.value = "false",
	},
	{
		.key = "persist.camera.pip.support",
		.value = "0",
	},
	{
		.key = "persist.cne.dpm",
		.value = "0",
	},
	{
		.key = "persist.cne.feature",
		.value = "0",
	},
	{
		.key = "persist.data.netmgrd.qos.enable",
		.value = "false",
	},
	{
		.key = "persist.debug.coresight.config",
		.value = "stm-events",
	},
	{
		.key = "persist.debug.wfd.enable",
		.value = "1",
	},
	{
		.key = "persist.demo.hdmirotationlock",
		.value = "false",
	},
	{
		.key = "persist.dpm.feature",
		.value = "3",
	},
	{
		.key = "persist.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "persist.gps.qc_nlp_in_use",
		.value = "1",
	},
	{
		.key = "persist.hwc.enable_vds",
		.value = "1",
	},
	{
		.key = "persist.hwc.mdpcomp.enable",
		.value = "true",
	},
	{
		.key = "persist.loc.nlp_name",
		.value = "com.qualcomm.location",
	},
	{
		.key = "persist.radio.add_power_save",
		.value = "1",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.calldefault.simid",
		.value = "0",
	},
	{
		.key = "persist.radio.dataprefer.slotId",
		.value = "0",
	},
	{
		.key = "persist.radio.defdataSIMchange",
		.value = "true",
	},
	{
		.key = "persist.radio.initphone-type",
		.value = "1",
	},
	{
		.key = "persist.radio.jbims",
		.value = "1",
	},
	{
		.key = "persist.radio.lte_vrte_ltd",
		.value = "1",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "dsds",
	},
	{
		.key = "persist.radio.multisim.stackid",
		.value = "0,1",
	},
	{
		.key = "persist.radio.plmnname",
		.value = ",",
	},
	{
		.key = "persist.radio.process_sups_ind",
		.value = "1",
	},
	{
		.key = "persist.radio.sib16_support",
		.value = "0",
	},
	{
		.key = "persist.radio.sim.onoff",
		.value = "1,1",
	},
	{
		.key = "persist.radio.ss.voiceclass_1",
		.value = "false",
	},
	{
		.key = "persist.radio.ss.voiceclass_2",
		.value = "false",
	},
	{
		.key = "persist.ril.dfm.srlte",
		.value = "false",
	},
	{
		.key = "persist.ril.ims.eutranParam",
		.value = "0",
	},
	{
		.key = "persist.ril.ims.pdnFailCause",
		.value = "0",
	},
	{
		.key = "persist.ril.ims.utranParam",
		.value = "0",
	},
	{
		.key = "persist.ril.modem.board",
		.value = "MSM8916",
	},
	{
		.key = "persist.ril.radiocapa.tdscdma",
		.value = "false",
	},
	{
		.key = "persist.ril.xcap.pdnFailCause",
		.value = "0",
	},
	{
		.key = "persist.rild.nitz_long_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_3",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_plmn",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_3",
		.value = "",
	},
	{
		.key = "persist.security.ams.enforcing",
		.value = "3",
	},
	{
		.key = "persist.security.tlc.ccm",
		.value = "0",
	},
	{
		.key = "persist.security.tlc.otp",
		.value = "0",
	},
	{
		.key = "persist.service.bdroid.version",
		.value = "4.1",
	},
	{
		.key = "persist.soc_camera.flicker",
		.value = "60hz",
	},
	{
		.key = "persist.sys.SUWRebootReason",
		.value = "",
	},
	{
		.key = "persist.sys.ccm.date",
		.value = "Tue Jan  3 01:45:41 KST 2017",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.drs.date",
		.value = "Tue Jan  3 01:45:41 KST 2017",
	},
	{
		.key = "persist.sys.kap.date",
		.value = "Tue Jan  3 01:45:41 KST 2017",
	},
	{
		.key = "persist.sys.locale",
		.value = "en-US",
	},
	{
		.key = "persist.sys.localedefault",
		.value = "en-US",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.sb.setting.enabled",
		.value = "false",
	},
	{
		.key = "persist.sys.setupwizard",
		.value = "FINISH",
	},
	{
		.key = "persist.sys.sm_mode",
		.value = "1",
	},
	{
		.key = "persist.sys.storage_preload",
		.value = "2",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/Los_Angeles",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.usb.config.extra",
		.value = "none",
	},
	{
		.key = "persist.tcp.delack.enable",
		.value = "true",
	},
	{
		.key = "persist.timed.enable",
		.value = "true",
	},
	{
		.key = "ril.ICC_TYPE",
		.value = "0,0",
	},
	{
		.key = "ril.RildInit",
		.value = "1,1",
	},
	{
		.key = "ril.airplane.mode",
		.value = "0",
	},
	{
		.key = "ril.atd_status",
		.value = "1_0_0",
	},
	{
		.key = "ril.backoffstate",
		.value = "1024",
	},
	{
		.key = "ril.cs_svc",
		.value = "1",
	},
	{
		.key = "ril.debug_modemfactory",
		.value = "CSC Feature State: IMS OFF, EPDG OFF",
	},
	{
		.key = "ril.deviceOffRes",
		.value = "0",
	},
	{
		.key = "ril.ecclist0",
		.value = "",
	},
	{
		.key = "ril.ecclist00",
		.value = "112,911,999,000,110,118,119",
	},
	{
		.key = "ril.ecclist10",
		.value = "112,911,999,000,08,110,118,119",
	},
	{
		.key = "ril.ecclist_net0",
		.value = "",
	},
	{
		.key = "ril.ecclist_net1",
		.value = "",
	},
	{
		.key = "ril.hasisim",
		.value = "0,0",
	},
	{
		.key = "ril.hw_ver",
		.value = "MP 0.400",
	},
	{
		.key = "ril.ims.ecsupport",
		.value = "0",
	},
	{
		.key = "ril.initPB",
		.value = "0",
	},
	{
		.key = "ril.initPB2",
		.value = "0",
	},
	{
		.key = "ril.modem.board",
		.value = "MSM8916",
	},
	{
		.key = "ril.official_cscver",
		.value = "J500MUUB1BPL1",
	},
	{
		.key = "ril.product_code",
		.value = "SM-J500MZKETTT",
	},
	{
		.key = "ril.radiostate",
		.value = "10",
	},
	{
		.key = "ril.rfcal_date",
		.value = "2017.03.02",
	},
	{
		.key = "ril.rildreset",
		.value = "768",
	},
	{
		.key = "ril.serialnumber",
		.value = "RV8H80VV94F",
	},
	{
		.key = "ril.servicestate",
		.value = "2",
	},
	{
		.key = "ril.ss.routing",
		.value = "0",
	},
	{
		.key = "ril.subinfo",
		.value = "0:2147483643,1:2147483644",
	},
	{
		.key = "ril.subscription.types",
		.value = "NV,RUIM",
	},
	{
		.key = "ril.sw_ver",
		.value = "J500MUBU1BPL2",
	},
	{
		.key = "ril.timezoneID",
		.value = "",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/smd0",
	},
	{
		.key = "rild.libpath",
		.value = "/system/lib/libsec-ril.so",
	},
	{
		.key = "rild.libpath2",
		.value = "/system/lib/libsec-ril-dsds.so",
	},
	{
		.key = "rilswitch.cfilibpath",
		.value = "/system/lib/libcfiril.so",
	},
	{
		.key = "rilswitch.vendorlibpath",
		.value = "/system/lib/libsec-ril.so",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.astcenc.astcsupport",
		.value = "1",
	},
	{
		.key = "ro.baseband",
		.value = "msm",
	},
	{
		.key = "ro.bluetooth.dun",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.hfp.ver",
		.value = "1.7",
	},
	{
		.key = "ro.bluetooth.sap",
		.value = "true",
	},
	{
		.key = "ro.board.platform",
		.value = "msm8916",
	},
	{
		.key = "ro.boot.baseband",
		.value = "msm",
	},
	{
		.key = "ro.boot.boot_recovery",
		.value = "0",
	},
	{
		.key = "ro.boot.bootdevice",
		.value = "7824900.sdhci",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "J500MUBU1BQA1",
	},
	{
		.key = "ro.boot.cp_debug_level",
		.value = "0x55FF",
	},
	{
		.key = "ro.boot.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.boot.emmc",
		.value = "true",
	},
	{
		.key = "ro.boot.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.boot.revision",
		.value = "5",
	},
	{
		.key = "ro.boot.sec_atd.tty",
		.value = "/dev/ttyHSL0",
	},
	{
		.key = "ro.boot.security_mode",
		.value = "1526595584",
	},
	{
		.key = "ro.boot.serialno",
		.value = "02316111",
	},
	{
		.key = "ro.boot.warranty_bit",
		.value = "0",
	},
	{
		.key = "ro.boot_recovery",
		.value = "0",
	},
	{
		.key = "ro.bootimage.build.date",
		.value = "Tue Jan 3 01:45:45 KST 2017",
	},
	{
		.key = "ro.bootimage.build.date.utc",
		.value = "1483375545",
	},
	{
		.key = "ro.bootimage.build.fingerprint",
		.value = "samsung/j5lteub/j5lte:6.0.1/MMB29M/J500MUBU1BQA1:user/test-keys",
	},
	{
		.key = "ro.bootloader",
		.value = "J500MUBU1BQA1",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/efs/bluetooth/bt_addr",
	},
	{
		.key = "ro.build.PDA",
		.value = "J500MUBU1BQA1",
	},
	{
		.key = "ro.build.changelist",
		.value = "10283451",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date",
		.value = "Tue Jan  3 01:45:41 KST 2017",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1483375541",
	},
	{
		.key = "ro.build.description",
		.value = "j5lteub-user 6.0.1 MMB29M J500MUBU1BQA1 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "MMB29M.J500MUBU1BQA1",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "samsung/j5lteub/j5lte:6.0.1/MMB29M/J500MUBU1BQA1:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "j5lteub-user",
	},
	{
		.key = "ro.build.hidden_ver",
		.value = "J500MUBU1BQA1",
	},
	{
		.key = "ro.build.host",
		.value = "SWHE8817",
	},
	{
		.key = "ro.build.id",
		.value = "MMB29M",
	},
	{
		.key = "ro.build.official.release",
		.value = "true",
	},
	{
		.key = "ro.build.product",
		.value = "j5lte",
	},
	{
		.key = "ro.build.scafe.cream",
		.value = "white",
	},
	{
		.key = "ro.build.scafe.shot",
		.value = "single",
	},
	{
		.key = "ro.build.scafe.size",
		.value = "short",
	},
	{
		.key = "ro.build.scafe.version",
		.value = "2016A",
	},
	{
		.key = "ro.build.selinux",
		.value = "1",
	},
	{
		.key = "ro.build.selinux.enforce",
		.value = "1",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "dpi",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "J500MUBU1BQA1",
	},
	{
		.key = "ro.build.version.preview_sdk",
		.value = "0",
	},
	{
		.key = "ro.build.version.release",
		.value = "6.0.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "23",
	},
	{
		.key = "ro.build.version.sdl",
		.value = "2301",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2017-01-01",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.chipname",
		.value = "MSM8916",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "6.0_r10",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Morning_Flower.ogg",
	},
	{
		.key = "ro.config.dha_cached_max",
		.value = "6",
	},
	{
		.key = "ro.config.dha_cached_min",
		.value = "3",
	},
	{
		.key = "ro.config.dha_empty_init",
		.value = "20",
	},
	{
		.key = "ro.config.dha_empty_max",
		.value = "20",
	},
	{
		.key = "ro.config.dha_empty_min",
		.value = "6",
	},
	{
		.key = "ro.config.dha_lmk_scale",
		.value = "1.0",
	},
	{
		.key = "ro.config.dha_pwhitelist_enable",
		.value = "1",
	},
	{
		.key = "ro.config.dha_th_rate",
		.value = "2.0",
	},
	{
		.key = "ro.config.dmverity",
		.value = "true",
	},
	{
		.key = "ro.config.iccc_version",
		.value = "1.0",
	},
	{
		.key = "ro.config.kap",
		.value = "true",
	},
	{
		.key = "ro.config.knox",
		.value = "v30",
	},
	{
		.key = "ro.config.max_starting_bg",
		.value = "8",
	},
	{
		.key = "ro.config.media_sound",
		.value = "Media_preview_Touch_the_light.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Skyline.ogg",
	},
	{
		.key = "ro.config.notification_sound_2",
		.value = "S_Charming_Bell.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Over_the_Horizon.ogg",
	},
	{
		.key = "ro.config.ringtone_2",
		.value = "Basic_Bell.ogg",
	},
	{
		.key = "ro.config.rm_preload_enabled",
		.value = "0",
	},
	{
		.key = "ro.config.tima",
		.value = "1",
	},
	{
		.key = "ro.config.timaversion",
		.value = "3.0",
	},
	{
		.key = "ro.core_ctl_max_cpu",
		.value = "4",
	},
	{
		.key = "ro.core_ctl_min_cpu",
		.value = "2",
	},
	{
		.key = "ro.cp_debug_level",
		.value = "0x55FF",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.csc.country_code",
		.value = "TRINIDAD AND TOBAGO",
	},
	{
		.key = "ro.csc.countryiso_code",
		.value = "TT",
	},
	{
		.key = "ro.csc.sales_code",
		.value = "TTT",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.emmc",
		.value = "true",
	},
	{
		.key = "ro.emmc_checksum",
		.value = "unknown",
	},
	{
		.key = "ro.error.receiver.default",
		.value = "com.samsung.receiver.error",
	},
	{
		.key = "ro.expect.recovery_id",
		.value = "0xbb1fabe069470980fa763c4466ee8185f2c98951000000000000000000000000",
	},
	{
		.key = "ro.fm.transmitter",
		.value = "false",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/persistent",
	},
	{
		.key = "ro.gps.agps_provider",
		.value = "1",
	},
	{
		.key = "ro.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.hdcp2.rx",
		.value = "tz",
	},
	{
		.key = "ro.hwui.drop_shadow_cache_size",
		.value = "2",
	},
	{
		.key = "ro.hwui.gradient_cache_size",
		.value = "0.5",
	},
	{
		.key = "ro.hwui.layer_cache_size",
		.value = "16",
	},
	{
		.key = "ro.hwui.path_cache_size",
		.value = "4",
	},
	{
		.key = "ro.hwui.r_buffer_cache_size",
		.value = "2",
	},
	{
		.key = "ro.hwui.shape_cache_size",
		.value = "1",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_large_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_small_cache_height",
		.value = "512",
	},
	{
		.key = "ro.hwui.text_small_cache_width",
		.value = "1024",
	},
	{
		.key = "ro.hwui.texture_cache_flushrate",
		.value = "0.4",
	},
	{
		.key = "ro.hwui.texture_cache_size",
		.value = "24",
	},
	{
		.key = "ro.kernel.qemu",
		.value = "0",
	},
	{
		.key = "ro.mct.compressiontype",
		.value = "ETC1",
	},
	{
		.key = "ro.min_freq_0",
		.value = "800000",
	},
	{
		.key = "ro.multisim.simslotcount",
		.value = "2",
	},
	{
		.key = "ro.nvdata_backup",
		.value = "unknown",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.product.board",
		.value = "MSM8916",
	},
	{
		.key = "ro.product.brand",
		.value = "samsung",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "",
	},
	{
		.key = "ro.product.device",
		.value = "j5lte",
	},
	{
		.key = "ro.product.locale",
		.value = "en-GB",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "samsung",
	},
	{
		.key = "ro.product.model",
		.value = "SM-J500M",
	},
	{
		.key = "ro.product.name",
		.value = "j5lteub",
	},
	{
		.key = "ro.product_ship",
		.value = "true",
	},
	{
		.key = "ro.qc.sdk.audio.fluencetype",
		.value = "none",
	},
	{
		.key = "ro.qc.sdk.audio.ssr",
		.value = "false",
	},
	{
		.key = "ro.qualcomm.bluetooth.ftp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hfp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hsp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.map",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.nap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.opp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.pbap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bt.hci_transport",
		.value = "smd",
	},
	{
		.key = "ro.qualcomm.cabl",
		.value = "2",
	},
	{
		.key = "ro.revision",
		.value = "5",
	},
	{
		.key = "ro.ril.svdo",
		.value = "false",
	},
	{
		.key = "ro.ril.svlte1x",
		.value = "false",
	},
	{
		.key = "ro.sec.fle.encryption",
		.value = "true",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.security.icd.flagmode",
		.value = "single",
	},
	{
		.key = "ro.security.reactive.version",
		.value = "2.0.11",
	},
	{
		.key = "ro.security.vpnpp.release",
		.value = "7.0",
	},
	{
		.key = "ro.security.vpnpp.ver",
		.value = "1.4",
	},
	{
		.key = "ro.security_mode",
		.value = "1526595584",
	},
	{
		.key = "ro.secwvk",
		.value = "144",
	},
	{
		.key = "ro.serialno",
		.value = "02316111",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "320",
	},
	{
		.key = "ro.sys.fw.bservice_age",
		.value = "5000",
	},
	{
		.key = "ro.sys.fw.bservice_enable",
		.value = "true",
	},
	{
		.key = "ro.sys.fw.bservice_limit",
		.value = "5",
	},
	{
		.key = "ro.sys.fw.dex2oat_thread_count",
		.value = "4",
	},
	{
		.key = "ro.sys.fw.empty_app_percent",
		.value = "50",
	},
	{
		.key = "ro.sys.fw.trim_cache_percent",
		.value = "100",
	},
	{
		.key = "ro.sys.fw.trim_empty_percent",
		.value = "100",
	},
	{
		.key = "ro.sys.fw.trim_enable_memory",
		.value = "1073741824",
	},
	{
		.key = "ro.sys.fw.use_trim_settings",
		.value = "true",
	},
	{
		.key = "ro.sys.usb.default.config",
		.value = "diag,serial_smd,rmnet_bam,adb",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "9",
	},
	{
		.key = "ro.use_data_netmgrd",
		.value = "false",
	},
	{
		.key = "ro.vendor.extension_library",
		.value = "libqti-perfd-client.so",
	},
	{
		.key = "ro.warranty_bit",
		.value = "0",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote32",
	},
	{
		.key = "rw.km_fips_status",
		.value = "ready",
	},
	{
		.key = "security.ASKS.policy_version",
		.value = "161011",
	},
	{
		.key = "security.mdpp.mass",
		.value = "skmm",
	},
	{
		.key = "security.semdaemonfinish",
		.value = "0",
	},
	{
		.key = "selinux.policy_version",
		.value = "SEPF_SECMOBILE_6.0.1_0033",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "0",
	},
	{
		.key = "service.camera.rec.running",
		.value = "0",
	},
	{
		.key = "service.camera.running",
		.value = "0",
	},
	{
		.key = "service.media.powersnd",
		.value = "1",
	},
	{
		.key = "storage.mmc.size",
		.value = "15758000128",
	},
	{
		.key = "storage.preload.complete",
		.value = "1",
	},
	{
		.key = "storage.support.sdcard",
		.value = "1",
	},
	{
		.key = "storage.support.usb",
		.value = "1",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.config.samp_spcm_enable",
		.value = "true",
	},
	{
		.key = "sys.config.spcm_db_enable",
		.value = "true",
	},
	{
		.key = "sys.config.spcm_db_launcher",
		.value = "true",
	},
	{
		.key = "sys.config.spcm_preload_enable",
		.value = "true",
	},
	{
		.key = "sys.dockstate",
		.value = "0",
	},
	{
		.key = "sys.enterprise.billing.version",
		.value = "1.2.0",
	},
	{
		.key = "sys.enterprise.otp.version",
		.value = "2.6.0",
	},
	{
		.key = "sys.ims.QMI_DAEMON_STATUS",
		.value = "1",
	},
	{
		.key = "sys.keyguard.connected",
		.value = "true",
	},
	{
		.key = "sys.keymaster.loaded",
		.value = "true",
	},
	{
		.key = "sys.knox.exists",
		.value = "0",
	},
	{
		.key = "sys.knox.store",
		.value = "0",
	},
	{
		.key = "sys.listeners.registered",
		.value = "true",
	},
	{
		.key = "sys.mobicore.loaded",
		.value = "true",
	},
	{
		.key = "sys.mobicoredaemon.enable",
		.value = "true",
	},
	{
		.key = "sys.nfc.support",
		.value = "0",
	},
	{
		.key = "sys.oem_unlock_allowed",
		.value = "0",
	},
	{
		.key = "sys.qseecomd.enable",
		.value = "true",
	},
	{
		.key = "sys.settings_global_version",
		.value = "2",
	},
	{
		.key = "sys.settings_system_version",
		.value = "3",
	},
	{
		.key = "sys.skip_lockscreen",
		.value = "0",
	},
	{
		.key = "sys.sysctl.compact_memory",
		.value = "0",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "10800",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.configfs",
		.value = "0",
	},
	{
		.key = "sys.usb.ffs.ready",
		.value = "1",
	},
	{
		.key = "sys.usb.rps_mask",
		.value = "0",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "system.camera.CC.disable",
		.value = "0",
	},
	{
		.key = "telephony.lteOnCdmaDevice",
		.value = "0",
	},
	{
		.key = "tunnel.audio.encode",
		.value = "false",
	},
	{
		.key = "use.voice.path.for.pcm.voip",
		.value = "true",
	},
	{
		.key = "vidc.enc.narrow.searchrange",
		.value = "1",
	},
	{
		.key = "voice.playback.conc.disabled",
		.value = "true",
	},
	{
		.key = "voice.record.conc.disabled",
		.value = "true",
	},
	{
		.key = "voice.voip.conc.disabled",
		.value = "true",
	},
	{
		.key = "vold.has_adoptable",
		.value = "0",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.ath",
		.value = "0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{
		.key = "wlan.p2p.chkintent",
		.value = "8",
	},
	{ NULL },
};
#endif /* __ANDROID__ */
