/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Conservation {
    SequenceI[] sequences;
    int start;
    int end;
    Vector seqNums;
    int maxLength = 0;
    boolean seqNumsChanged = false;
    Hashtable[] total;
    boolean canonicaliseAa = true;
    public Vector quality;
    public Double[] qualityRange = new Double[2];
    String consString = "";
    Sequence consSequence;
    Hashtable propHash;
    int threshold;
    String name = "";
    int[][] cons2;

    public Conservation(String name, Hashtable propHash, int threshold, Vector sequences, int start, int end) {
        this.name = name;
        this.propHash = propHash;
        this.threshold = threshold;
        this.start = start;
        this.end = end;
        this.maxLength = end - start + 1;
        int sSize = sequences.size();
        SequenceI[] sarray = new SequenceI[sSize];
        this.sequences = sarray;
        for (int s = 0; s < sSize; ++s) {
            sarray[s] = (SequenceI)sequences.elementAt(s);
            if (sarray[s].getLength() <= this.maxLength) continue;
            this.maxLength = sarray[s].getLength();
        }
    }

    private void calcSeqNum(int i) {
        String sq = null;
        int[] sqnum = null;
        int sSize = this.sequences.length;
        if (i > -1 && i < sSize) {
            sq = this.sequences[i].getSequenceAsString();
            if (this.seqNums.size() <= i) {
                this.seqNums.addElement(new int[sq.length() + 1]);
            }
            if (sq.hashCode() != ((int[])this.seqNums.elementAt(i))[0]) {
                this.seqNumsChanged = true;
                int len = sq.length();
                if (this.maxLength < len) {
                    this.maxLength = len;
                }
                sqnum = new int[len + 1];
                sqnum[0] = sq.hashCode();
                for (int j = 1; j <= len; ++j) {
                    sqnum[j] = ResidueProperties.aaIndex[sq.charAt(j - 1)];
                }
                this.seqNums.setElementAt(sqnum, i);
            } else {
                System.out.println("SEQUENCE HAS BEEN DELETED!!!");
            }
        } else {
            System.err.println("ERROR: calcSeqNum called with out of range sequence index for Alignment\n");
        }
    }

    public void calculate() {
        int jSize = this.sequences.length;
        String res = null;
        this.total = new Hashtable[this.maxLength];
        for (int i = this.start; i <= this.end; ++i) {
            int[] values = new int[255];
            for (int j = 0; j < jSize; ++j) {
                if (this.sequences[j].getLength() > i) {
                    int c = this.sequences[j].getCharAt(i);
                    if (this.canonicaliseAa) {
                        c = (char)ResidueProperties.aaIndex[this.sequences[j].getCharAt(i)];
                        c = c > 20 ? 45 : (int)ResidueProperties.aa[c].charAt(0);
                    } else {
                        if (c == 46 || c == 32) {
                            c = 45;
                        }
                        if (!this.canonicaliseAa && 97 <= c && c <= 122) {
                            c = (char)(c - 32);
                        }
                    }
                    int n = c;
                    values[n] = values[n] + 1;
                    continue;
                }
                values[45] = values[45] + 1;
            }
            int thresh = this.threshold * jSize / 100;
            Hashtable resultHash = new Hashtable();
            for (char v = '-'; v < 'Z'; v = (char)(v + '\u0001')) {
                if (values[v] <= thresh) continue;
                res = String.valueOf(v);
                Enumeration enumeration2 = this.propHash.keys();
                while (enumeration2.hasMoreElements()) {
                    String type = (String)enumeration2.nextElement();
                    Hashtable ht = (Hashtable)this.propHash.get(type);
                    if (!resultHash.containsKey(type)) {
                        if (ht.containsKey(res)) {
                            resultHash.put(type, ht.get(res));
                            continue;
                        }
                        resultHash.put(type, ht.get("-"));
                        continue;
                    }
                    if (((Integer)resultHash.get(type)).equals((Integer)ht.get(res))) continue;
                    resultHash.put(type, new Integer(-1));
                }
            }
            this.total[i - this.start] = resultHash;
        }
    }

    public int[] countConsNGaps(int j) {
        int count = 0;
        int cons = 0;
        int nres = 0;
        int[] r = new int[2];
        char f = '$';
        int iSize = this.sequences.length;
        for (int i = 0; i < iSize; ++i) {
            if (j >= this.sequences[i].getLength()) {
                ++count;
                continue;
            }
            char c = this.sequences[i].getCharAt(j);
            if (Comparison.isGap(c)) {
                ++count;
                continue;
            }
            if (++nres == 1) {
                f = c;
                ++cons;
                continue;
            }
            if (f != c) continue;
            ++cons;
        }
        r[0] = nres == cons ? 1 : 0;
        r[1] = count;
        return r;
    }

    public void verdict(boolean consflag, float percentageGaps) {
        int i;
        StringBuffer consString = new StringBuffer();
        for (i = 0; i < this.start; ++i) {
            consString.append('-');
        }
        for (i = this.start; i <= this.end; ++i) {
            int[] gapcons = this.countConsNGaps(i);
            int totGaps = gapcons[1];
            float pgaps = (float)totGaps * 100.0f / (float)this.sequences.length;
            if (percentageGaps > pgaps) {
                Hashtable resultHash = this.total[i - this.start];
                int count = 0;
                Enumeration enumeration = resultHash.keys();
                while (enumeration.hasMoreElements()) {
                    String type = (String)enumeration.nextElement();
                    Integer result = (Integer)resultHash.get(type);
                    if (consflag) {
                        if (result != 1) continue;
                        ++count;
                        continue;
                    }
                    if (result == -1) continue;
                    ++count;
                }
                if (count < 10) {
                    consString.append(count);
                    continue;
                }
                consString.append(gapcons[0] == 1 ? "*" : "+");
                continue;
            }
            consString.append('-');
        }
        this.consSequence = new Sequence(this.name, consString.toString(), this.start, this.end);
    }

    public Sequence getConsSequence() {
        return this.consSequence;
    }

    public void findQuality() {
        this.findQuality(0, this.maxLength - 1);
    }

    private void percentIdentity2() {
        this.seqNums = new Vector();
        int i = 0;
        int iSize = this.sequences.length;
        for (i = 0; i < iSize; ++i) {
            this.calcSeqNum(i);
        }
        if (this.cons2 == null || this.seqNumsChanged) {
            this.cons2 = new int[this.maxLength][24];
            for (int j = 0; j < 24; ++j) {
                for (i = 0; i < this.maxLength; ++i) {
                    this.cons2[i][j] = 0;
                }
            }
            for (int j = 0; j < this.sequences.length; ++j) {
                int[] sqnum = (int[])this.seqNums.elementAt(j);
                for (i = 1; i < sqnum.length; ++i) {
                    int[] nArray = this.cons2[i - 1];
                    int n = sqnum[i];
                    nArray[n] = nArray[n] + 1;
                }
                for (i = sqnum.length - 1; i < this.maxLength; ++i) {
                    int[] nArray = this.cons2[i];
                    nArray[23] = nArray[23] + 1;
                }
            }
        }
    }

    public void findQuality(int start, int end) {
        int j;
        this.quality = new Vector();
        double max = -10000.0;
        int[][] BLOSUM62 = ResidueProperties.getBLOSUM62();
        this.percentIdentity2();
        int size = this.seqNums.size();
        int[] lengths = new int[size];
        for (int l = 0; l < size; ++l) {
            lengths[l] = ((int[])this.seqNums.elementAt(l)).length - 1;
        }
        for (j = start; j <= end; ++j) {
            double bigtot = 0.0;
            double[] x = new double[24];
            int ii = 0;
            while (ii < 24) {
                x[ii] = 0.0;
                for (int i2 = 0; i2 < 24; ++i2) {
                    int n = ii;
                    x[n] = x[n] + ((double)this.cons2[j][i2] * (double)BLOSUM62[ii][i2] + 4.0);
                }
                int n = ii++;
                x[n] = x[n] / (double)size;
            }
            for (int k = 0; k < size; ++k) {
                double tot = 0.0;
                double[] xx = new double[24];
                int seqNum = j < lengths[k] ? ((int[])this.seqNums.elementAt(k))[j + 1] : 23;
                for (int i = 0; i < 23; ++i) {
                    double sr = 0.0;
                    sr = (double)BLOSUM62[i][seqNum] + 4.0;
                    xx[i] = x[i] - sr;
                    tot += xx[i] * xx[i];
                }
                bigtot += Math.sqrt(tot);
            }
            if (max < bigtot) {
                max = bigtot;
            }
            this.quality.addElement(new Double(bigtot));
        }
        double newmax = -10000.0;
        for (j = start; j <= end; ++j) {
            double tmp = (Double)this.quality.elementAt(j);
            tmp = (max - tmp) * (double)(size - this.cons2[j][23]) / (double)size;
            this.quality.setElementAt(new Double(tmp), j);
            if (!(tmp > newmax)) continue;
            newmax = tmp;
        }
        this.qualityRange[0] = new Double(0.0);
        this.qualityRange[1] = new Double(newmax);
    }
}

