//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhdinsight

import "time"

// AaddsResourceDetails - The Azure active directory domain service resource details.
type AaddsResourceDetails struct {
	// The Azure active directory domain service name.
	DomainName *string `json:"domainName,omitempty"`

	// This indicates whether initial sync complete or not.
	InitialSyncComplete *bool `json:"initialSyncComplete,omitempty"`

	// This indicates whether enable ldaps or not.
	LdapsEnabled *bool `json:"ldapsEnabled,omitempty"`

	// The base 64 format string of public ldap certificate.
	LdapsPublicCertificateInBase64 *string `json:"ldapsPublicCertificateInBase64,omitempty"`

	// The resource id of azure active directory domain service.
	ResourceID *string `json:"resourceId,omitempty"`

	// The subnet resource id.
	SubnetID *string `json:"subnetId,omitempty"`

	// The tenant id of azure active directory domain service .
	TenantID *string `json:"tenantId,omitempty"`
}

// Application - The HDInsight cluster application
type Application struct {
	// The ETag for the application
	Etag *string `json:"etag,omitempty"`

	// The properties of the application.
	Properties *ApplicationProperties `json:"properties,omitempty"`

	// The tags for the application.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGetEndpoint - Gets the application SSH endpoint
type ApplicationGetEndpoint struct {
	// The destination port to connect to.
	DestinationPort *int32 `json:"destinationPort,omitempty"`

	// The location of the endpoint.
	Location *string `json:"location,omitempty"`

	// The private ip address of the endpoint.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// The public port to connect to.
	PublicPort *int32 `json:"publicPort,omitempty"`
}

// ApplicationGetHTTPSEndpoint - Gets the application HTTP endpoints.
type ApplicationGetHTTPSEndpoint struct {
	// The list of access modes for the application.
	AccessModes []*string `json:"accessModes,omitempty"`

	// The destination port to connect to.
	DestinationPort *int32 `json:"destinationPort,omitempty"`

	// The value indicates whether to disable GatewayAuth.
	DisableGatewayAuth *bool `json:"disableGatewayAuth,omitempty"`

	// The private ip address of the endpoint.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// The subdomain suffix of the application.
	SubDomainSuffix *string `json:"subDomainSuffix,omitempty"`

	// READ-ONLY; The location of the endpoint.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The public port to connect to.
	PublicPort *int32 `json:"publicPort,omitempty" azure:"ro"`
}

// ApplicationListResult - Result of the request to list cluster Applications. It contains a list of operations and a URL
// link to get the next set of results.
type ApplicationListResult struct {
	// The list of HDInsight applications installed on HDInsight cluster.
	Value []*Application `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ApplicationProperties - The HDInsight cluster application GET response.
type ApplicationProperties struct {
	// The application type.
	ApplicationType *string `json:"applicationType,omitempty"`

	// The list of roles in the cluster.
	ComputeProfile *ComputeProfile `json:"computeProfile,omitempty"`

	// The list of errors.
	Errors []*Errors `json:"errors,omitempty"`

	// The list of application HTTPS endpoints.
	HTTPSEndpoints []*ApplicationGetHTTPSEndpoint `json:"httpsEndpoints,omitempty"`

	// The list of install script actions.
	InstallScriptActions []*RuntimeScriptAction `json:"installScriptActions,omitempty"`

	// The private link configurations.
	PrivateLinkConfigurations []*PrivateLinkConfiguration `json:"privateLinkConfigurations,omitempty"`

	// The list of application SSH endpoints.
	SSHEndpoints []*ApplicationGetEndpoint `json:"sshEndpoints,omitempty"`

	// The list of uninstall script actions.
	UninstallScriptActions []*RuntimeScriptAction `json:"uninstallScriptActions,omitempty"`

	// READ-ONLY; The application state.
	ApplicationState *string `json:"applicationState,omitempty" azure:"ro"`

	// READ-ONLY; The application create date time.
	CreatedDate *string `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The marketplace identifier.
	MarketplaceIdentifier *string `json:"marketplaceIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the application.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationsClientBeginCreateOptions contains the optional parameters for the ApplicationsClient.BeginCreate method.
type ApplicationsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationsClientBeginDeleteOptions contains the optional parameters for the ApplicationsClient.BeginDelete method.
type ApplicationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationsClientGetAzureAsyncOperationStatusOptions contains the optional parameters for the ApplicationsClient.GetAzureAsyncOperationStatus
// method.
type ApplicationsClientGetAzureAsyncOperationStatusOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientGetOptions contains the optional parameters for the ApplicationsClient.Get method.
type ApplicationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientListByClusterOptions contains the optional parameters for the ApplicationsClient.ListByCluster method.
type ApplicationsClientListByClusterOptions struct {
	// placeholder for future optional parameters
}

// AsyncOperationResult - The azure async operation response.
type AsyncOperationResult struct {
	// The operation error information.
	Error *Errors `json:"error,omitempty"`

	// The async operation state.
	Status *AsyncOperationState `json:"status,omitempty"`
}

// Autoscale - The autoscale request parameters
type Autoscale struct {
	// Parameters for load-based autoscale
	Capacity *AutoscaleCapacity `json:"capacity,omitempty"`

	// Parameters for schedule-based autoscale
	Recurrence *AutoscaleRecurrence `json:"recurrence,omitempty"`
}

// AutoscaleCapacity - The load-based autoscale request parameters
type AutoscaleCapacity struct {
	// The maximum instance count of the cluster
	MaxInstanceCount *int32 `json:"maxInstanceCount,omitempty"`

	// The minimum instance count of the cluster
	MinInstanceCount *int32 `json:"minInstanceCount,omitempty"`
}

// AutoscaleConfigurationUpdateParameter - The autoscale configuration update parameter.
type AutoscaleConfigurationUpdateParameter struct {
	// The autoscale configuration.
	Autoscale *Autoscale `json:"autoscale,omitempty"`
}

// AutoscaleRecurrence - Schedule-based autoscale request parameters
type AutoscaleRecurrence struct {
	// Array of schedule-based autoscale rules
	Schedule []*AutoscaleSchedule `json:"schedule,omitempty"`

	// The time zone for the autoscale schedule times
	TimeZone *string `json:"timeZone,omitempty"`
}

// AutoscaleSchedule - Parameters for a schedule-based autoscale rule, consisting of an array of days + a time and capacity
type AutoscaleSchedule struct {
	// Days of the week for a schedule-based autoscale rule
	Days []*DaysOfWeek `json:"days,omitempty"`

	// Time and capacity for a schedule-based autoscale rule
	TimeAndCapacity *AutoscaleTimeAndCapacity `json:"timeAndCapacity,omitempty"`
}

// AutoscaleTimeAndCapacity - Time and capacity request parameters
type AutoscaleTimeAndCapacity struct {
	// The maximum instance count of the cluster
	MaxInstanceCount *int32 `json:"maxInstanceCount,omitempty"`

	// The minimum instance count of the cluster
	MinInstanceCount *int32 `json:"minInstanceCount,omitempty"`

	// 24-hour time in the form xx:xx
	Time *string `json:"time,omitempty"`
}

// AzureMonitorRequest - The azure monitor parameters.
type AzureMonitorRequest struct {
	// The Log Analytics workspace key.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// The selected configurations.
	SelectedConfigurations *AzureMonitorSelectedConfigurations `json:"selectedConfigurations,omitempty"`

	// The Log Analytics workspace ID.
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// AzureMonitorResponse - The azure monitor status response.
type AzureMonitorResponse struct {
	// The status of the monitor on the HDInsight cluster.
	ClusterMonitoringEnabled *bool `json:"clusterMonitoringEnabled,omitempty"`

	// The selected configurations.
	SelectedConfigurations *AzureMonitorSelectedConfigurations `json:"selectedConfigurations,omitempty"`

	// The workspace ID of the monitor on the HDInsight cluster.
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// AzureMonitorSelectedConfigurations - The selected configurations for azure monitor.
type AzureMonitorSelectedConfigurations struct {
	// The configuration version.
	ConfigurationVersion *string `json:"configurationVersion,omitempty"`

	// The global configurations of selected configurations.
	GlobalConfigurations map[string]*string `json:"globalConfigurations,omitempty"`

	// The table list.
	TableList []*AzureMonitorTableConfiguration `json:"tableList,omitempty"`
}

// AzureMonitorTableConfiguration - The table configuration for the Log Analytics integration.
type AzureMonitorTableConfiguration struct {
	// The name.
	Name *string `json:"name,omitempty"`
}

// BillingMeters - The billing meters.
type BillingMeters struct {
	// The HDInsight meter guid.
	Meter *string `json:"meter,omitempty"`

	// The virtual machine sizes.
	MeterParameter *string `json:"meterParameter,omitempty"`

	// The unit of meter, VMHours or CoreHours.
	Unit *string `json:"unit,omitempty"`
}

// BillingResources - The billing resources.
type BillingResources struct {
	// The billing meter information.
	BillingMeters []*BillingMeters `json:"billingMeters,omitempty"`

	// The managed disk billing information.
	DiskBillingMeters []*DiskBillingMeters `json:"diskBillingMeters,omitempty"`

	// The region or location.
	Region *string `json:"region,omitempty"`
}

// BillingResponseListResult - The response for the operation to get regional billingSpecs for a subscription.
type BillingResponseListResult struct {
	// The billing and managed disk billing resources for a region.
	BillingResources []*BillingResources `json:"billingResources,omitempty"`

	// The virtual machine filtering mode. Effectively this can enabling or disabling the virtual machine sizes in a particular
	// set.
	VMSizeFilters []*VMSizeCompatibilityFilterV2 `json:"vmSizeFilters,omitempty"`

	// The virtual machine sizes to include or exclude.
	VMSizes []*string `json:"vmSizes,omitempty"`

	// The vm sizes which enable encryption at host.
	VMSizesWithEncryptionAtHost []*string `json:"vmSizesWithEncryptionAtHost,omitempty"`

	// READ-ONLY; The vm size properties.
	VMSizeProperties []*VMSizeProperty `json:"vmSizeProperties,omitempty" azure:"ro"`
}

// CapabilitiesResult - The Get Capabilities operation response.
type CapabilitiesResult struct {
	// The capability features.
	Features []*string `json:"features,omitempty"`

	// The virtual machine size compatibility features.
	Regions map[string]*RegionsCapability `json:"regions,omitempty"`

	// The version capability.
	Versions map[string]*VersionsCapability `json:"versions,omitempty"`

	// READ-ONLY; The quota capability.
	Quota *QuotaCapability `json:"quota,omitempty" azure:"ro"`
}

// ClientGroupInfo - The information of AAD security group.
type ClientGroupInfo struct {
	// The AAD security group id.
	GroupID *string `json:"groupId,omitempty"`

	// The AAD security group name.
	GroupName *string `json:"groupName,omitempty"`
}

// Cluster - The HDInsight cluster.
type Cluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The ETag for the resource
	Etag *string `json:"etag,omitempty"`

	// The identity of the cluster, if configured.
	Identity *ClusterIdentity `json:"identity,omitempty"`

	// The properties of the cluster.
	Properties *ClusterGetProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// The availability zones.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClusterConfigurations - The configuration object for the specified cluster.
type ClusterConfigurations struct {
	// The configuration object for the specified configuration for the specified cluster.
	Configurations map[string]map[string]*string `json:"configurations,omitempty"`
}

// ClusterCreateParametersExtended - The CreateCluster request parameters.
type ClusterCreateParametersExtended struct {
	// The identity of the cluster, if configured.
	Identity *ClusterIdentity `json:"identity,omitempty"`

	// The location of the cluster.
	Location *string `json:"location,omitempty"`

	// The cluster create parameters.
	Properties *ClusterCreateProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// The availability zones.
	Zones []*string `json:"zones,omitempty"`
}

// ClusterCreateProperties - The cluster create parameters.
type ClusterCreateProperties struct {
	// The cluster definition.
	ClusterDefinition *ClusterDefinition `json:"clusterDefinition,omitempty"`

	// The version of the cluster.
	ClusterVersion *string `json:"clusterVersion,omitempty"`

	// The compute isolation properties.
	ComputeIsolationProperties *ComputeIsolationProperties `json:"computeIsolationProperties,omitempty"`

	// The compute profile.
	ComputeProfile *ComputeProfile `json:"computeProfile,omitempty"`

	// The disk encryption properties.
	DiskEncryptionProperties *DiskEncryptionProperties `json:"diskEncryptionProperties,omitempty"`

	// The encryption-in-transit properties.
	EncryptionInTransitProperties *EncryptionInTransitProperties `json:"encryptionInTransitProperties,omitempty"`

	// The cluster kafka rest proxy configuration.
	KafkaRestProperties *KafkaRestProperties `json:"kafkaRestProperties,omitempty"`

	// The minimal supported tls version.
	MinSupportedTLSVersion *string `json:"minSupportedTlsVersion,omitempty"`

	// The network properties.
	NetworkProperties *NetworkProperties `json:"networkProperties,omitempty"`

	// The type of operating system.
	OSType *OSType `json:"osType,omitempty"`

	// The private link configurations.
	PrivateLinkConfigurations []*PrivateLinkConfiguration `json:"privateLinkConfigurations,omitempty"`

	// The security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`

	// The storage profile.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// The cluster tier.
	Tier *Tier `json:"tier,omitempty"`
}

// ClusterCreateRequestValidationParameters - The cluster create request specification.
type ClusterCreateRequestValidationParameters struct {
	// This indicates whether fetch Aadds resource or not.
	FetchAaddsResource *bool `json:"fetchAaddsResource,omitempty"`

	// The identity of the cluster, if configured.
	Identity *ClusterIdentity `json:"identity,omitempty"`

	// The location of the cluster.
	Location *string `json:"location,omitempty"`

	// The cluster name.
	Name *string `json:"name,omitempty"`

	// The cluster create parameters.
	Properties *ClusterCreateProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// The tenant id.
	TenantID *string `json:"tenantId,omitempty"`

	// The resource type.
	Type *string `json:"type,omitempty"`

	// The availability zones.
	Zones []*string `json:"zones,omitempty"`
}

// ClusterCreateValidationResult - The response of cluster create request validation.
type ClusterCreateValidationResult struct {
	// The Azure active directory domain service resource details.
	AaddsResourcesDetails []*AaddsResourceDetails `json:"aaddsResourcesDetails,omitempty"`

	// The estimated creation duration.
	EstimatedCreationDuration *string `json:"estimatedCreationDuration,omitempty"`

	// The validation errors.
	ValidationErrors []*ValidationErrorInfo `json:"validationErrors,omitempty"`

	// The validation warnings.
	ValidationWarnings []*ValidationErrorInfo `json:"validationWarnings,omitempty"`
}

// ClusterDefinition - The cluster definition.
type ClusterDefinition struct {
	// The link to the blueprint.
	Blueprint *string `json:"blueprint,omitempty"`

	// The versions of different services in the cluster.
	ComponentVersion map[string]*string `json:"componentVersion,omitempty"`

	// The cluster configurations.
	Configurations interface{} `json:"configurations,omitempty"`

	// The type of cluster.
	Kind *string `json:"kind,omitempty"`
}

// ClusterDiskEncryptionParameters - The Disk Encryption Cluster request parameters.
type ClusterDiskEncryptionParameters struct {
	// Key name that is used for enabling disk encryption.
	KeyName *string `json:"keyName,omitempty"`

	// Specific key version that is used for enabling disk encryption.
	KeyVersion *string `json:"keyVersion,omitempty"`

	// Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
	VaultURI *string `json:"vaultUri,omitempty"`
}

// ClusterGetProperties - The properties of cluster.
type ClusterGetProperties struct {
	// REQUIRED; The cluster definition.
	ClusterDefinition *ClusterDefinition `json:"clusterDefinition,omitempty"`

	// The hdp version of the cluster.
	ClusterHdpVersion *string `json:"clusterHdpVersion,omitempty"`

	// The cluster id.
	ClusterID *string `json:"clusterId,omitempty"`

	// The state of the cluster.
	ClusterState *string `json:"clusterState,omitempty"`

	// The version of the cluster.
	ClusterVersion *string `json:"clusterVersion,omitempty"`

	// The compute isolation properties.
	ComputeIsolationProperties *ComputeIsolationProperties `json:"computeIsolationProperties,omitempty"`

	// The compute profile.
	ComputeProfile *ComputeProfile `json:"computeProfile,omitempty"`

	// The list of connectivity endpoints.
	ConnectivityEndpoints []*ConnectivityEndpoint `json:"connectivityEndpoints,omitempty"`

	// The date on which the cluster was created.
	CreatedDate *string `json:"createdDate,omitempty"`

	// The disk encryption properties.
	DiskEncryptionProperties *DiskEncryptionProperties `json:"diskEncryptionProperties,omitempty"`

	// The encryption-in-transit properties.
	EncryptionInTransitProperties *EncryptionInTransitProperties `json:"encryptionInTransitProperties,omitempty"`

	// The list of errors.
	Errors []*Errors `json:"errors,omitempty"`

	// The excluded services config.
	ExcludedServicesConfig *ExcludedServicesConfig `json:"excludedServicesConfig,omitempty"`

	// The cluster kafka rest proxy configuration.
	KafkaRestProperties *KafkaRestProperties `json:"kafkaRestProperties,omitempty"`

	// The minimal supported tls version.
	MinSupportedTLSVersion *string `json:"minSupportedTlsVersion,omitempty"`

	// The network properties.
	NetworkProperties *NetworkProperties `json:"networkProperties,omitempty"`

	// The type of operating system.
	OSType *OSType `json:"osType,omitempty"`

	// The private link configurations.
	PrivateLinkConfigurations []*PrivateLinkConfiguration `json:"privateLinkConfigurations,omitempty"`

	// The provisioning state, which only appears in the response.
	ProvisioningState *HDInsightClusterProvisioningState `json:"provisioningState,omitempty"`

	// The quota information.
	QuotaInfo *QuotaInfo `json:"quotaInfo,omitempty"`

	// The security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`

	// The storage profile.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// The cluster tier.
	Tier *Tier `json:"tier,omitempty"`

	// READ-ONLY; The list of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`
}

// ClusterIdentity - Identity for the cluster.
type ClusterIdentity struct {
	// The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created
	// identity and a set of user assigned identities.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of cluster identity. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id associated with the cluster. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ClusterListPersistedScriptActionsResult - The ListPersistedScriptActions operation response.
type ClusterListPersistedScriptActionsResult struct {
	// The list of Persisted Script Actions.
	Value []*RuntimeScriptAction `json:"value,omitempty"`

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ClusterListResult - The List Cluster operation response.
type ClusterListResult struct {
	// The list of Clusters.
	Value []*Cluster `json:"value,omitempty"`

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ClusterMonitoringRequest - The cluster monitor parameters.
type ClusterMonitoringRequest struct {
	// The cluster monitor workspace key.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// The cluster monitor workspace ID.
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// ClusterMonitoringResponse - The cluster monitoring status response.
type ClusterMonitoringResponse struct {
	// The status of the monitor on the HDInsight cluster.
	ClusterMonitoringEnabled *bool `json:"clusterMonitoringEnabled,omitempty"`

	// The workspace ID of the monitor on the HDInsight cluster.
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// ClusterPatchParameters - The PatchCluster request parameters
type ClusterPatchParameters struct {
	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ClusterResizeParameters - The Resize Cluster request parameters.
type ClusterResizeParameters struct {
	// The target instance count for the operation.
	TargetInstanceCount *int32 `json:"targetInstanceCount,omitempty"`
}

// ClustersClientBeginCreateOptions contains the optional parameters for the ClustersClient.BeginCreate method.
type ClustersClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginDeleteOptions contains the optional parameters for the ClustersClient.BeginDelete method.
type ClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginExecuteScriptActionsOptions contains the optional parameters for the ClustersClient.BeginExecuteScriptActions
// method.
type ClustersClientBeginExecuteScriptActionsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginResizeOptions contains the optional parameters for the ClustersClient.BeginResize method.
type ClustersClientBeginResizeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginRotateDiskEncryptionKeyOptions contains the optional parameters for the ClustersClient.BeginRotateDiskEncryptionKey
// method.
type ClustersClientBeginRotateDiskEncryptionKeyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginUpdateAutoScaleConfigurationOptions contains the optional parameters for the ClustersClient.BeginUpdateAutoScaleConfiguration
// method.
type ClustersClientBeginUpdateAutoScaleConfigurationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginUpdateGatewaySettingsOptions contains the optional parameters for the ClustersClient.BeginUpdateGatewaySettings
// method.
type ClustersClientBeginUpdateGatewaySettingsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginUpdateIdentityCertificateOptions contains the optional parameters for the ClustersClient.BeginUpdateIdentityCertificate
// method.
type ClustersClientBeginUpdateIdentityCertificateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientGetAzureAsyncOperationStatusOptions contains the optional parameters for the ClustersClient.GetAzureAsyncOperationStatus
// method.
type ClustersClientGetAzureAsyncOperationStatusOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientGetGatewaySettingsOptions contains the optional parameters for the ClustersClient.GetGatewaySettings method.
type ClustersClientGetGatewaySettingsOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientGetOptions contains the optional parameters for the ClustersClient.Get method.
type ClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListByResourceGroupOptions contains the optional parameters for the ClustersClient.ListByResourceGroup method.
type ClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListOptions contains the optional parameters for the ClustersClient.List method.
type ClustersClientListOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientUpdateOptions contains the optional parameters for the ClustersClient.Update method.
type ClustersClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ComputeIsolationProperties - The compute isolation properties.
type ComputeIsolationProperties struct {
	// The flag indicates whether enable compute isolation or not.
	EnableComputeIsolation *bool `json:"enableComputeIsolation,omitempty"`

	// The host sku.
	HostSKU *string `json:"hostSku,omitempty"`
}

// ComputeProfile - Describes the compute profile.
type ComputeProfile struct {
	// The list of roles in the cluster.
	Roles []*Role `json:"roles,omitempty"`
}

// ConfigurationsClientBeginUpdateOptions contains the optional parameters for the ConfigurationsClient.BeginUpdate method.
type ConfigurationsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConfigurationsClientGetOptions contains the optional parameters for the ConfigurationsClient.Get method.
type ConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationsClientListOptions contains the optional parameters for the ConfigurationsClient.List method.
type ConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ConnectivityEndpoint - The connectivity properties
type ConnectivityEndpoint struct {
	// The location of the endpoint.
	Location *string `json:"location,omitempty"`

	// The name of the endpoint.
	Name *string `json:"name,omitempty"`

	// The port to connect to.
	Port *int32 `json:"port,omitempty"`

	// The private ip address of the endpoint.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// The protocol of the endpoint.
	Protocol *string `json:"protocol,omitempty"`
}

// DataDisksGroups - The data disks groups for the role.
type DataDisksGroups struct {
	// The number of disks per node.
	DisksPerNode *int32 `json:"disksPerNode,omitempty"`

	// READ-ONLY; ReadOnly. The DiskSize in GB. Do not set this value.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty" azure:"ro"`

	// READ-ONLY; ReadOnly. The storage account type. Do not set this value.
	StorageAccountType *string `json:"storageAccountType,omitempty" azure:"ro"`
}

// Dimension - The definition of Dimension.
type Dimension struct {
	// The display name of the dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// The display name of the dimension.
	InternalName *string `json:"internalName,omitempty"`

	// The name of the dimension.
	Name *string `json:"name,omitempty"`

	// The flag indicates whether the metric will be exported for shoebox or not.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// DiskBillingMeters - The disk billing meters.
type DiskBillingMeters struct {
	// The managed disk meter guid.
	DiskRpMeter *string `json:"diskRpMeter,omitempty"`

	// The managed disk billing sku, P30 or S30.
	SKU *string `json:"sku,omitempty"`

	// The managed disk billing tier, Standard or Premium.
	Tier *Tier `json:"tier,omitempty"`
}

// DiskEncryptionProperties - The disk encryption properties
type DiskEncryptionProperties struct {
	// Algorithm identifier for encryption, default RSA-OAEP.
	EncryptionAlgorithm *JSONWebKeyEncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`

	// Indicates whether or not resource disk encryption is enabled.
	EncryptionAtHost *bool `json:"encryptionAtHost,omitempty"`

	// Key name that is used for enabling disk encryption.
	KeyName *string `json:"keyName,omitempty"`

	// Specific key version that is used for enabling disk encryption.
	KeyVersion *string `json:"keyVersion,omitempty"`

	// Resource ID of Managed Identity that is used to access the key vault.
	MsiResourceID *string `json:"msiResourceId,omitempty"`

	// Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
	VaultURI *string `json:"vaultUri,omitempty"`
}

// EncryptionInTransitProperties - The encryption-in-transit properties.
type EncryptionInTransitProperties struct {
	// Indicates whether or not inter cluster node communication is encrypted in transit.
	IsEncryptionInTransitEnabled *bool `json:"isEncryptionInTransitEnabled,omitempty"`
}

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// Error code
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// Errors - The error message associated with the cluster creation.
type Errors struct {
	// The error code.
	Code *string `json:"code,omitempty"`

	// The error message.
	Message *string `json:"message,omitempty"`
}

// ExcludedServicesConfig - The configuration that services will be excluded when creating cluster.
type ExcludedServicesConfig struct {
	// The config id of excluded services.
	ExcludedServicesConfigID *string `json:"excludedServicesConfigId,omitempty"`

	// The list of excluded services.
	ExcludedServicesList *string `json:"excludedServicesList,omitempty"`
}

// ExecuteScriptActionParameters - The parameters for the script actions to execute on a running cluster.
type ExecuteScriptActionParameters struct {
	// REQUIRED; Gets or sets if the scripts needs to be persisted.
	PersistOnSuccess *bool `json:"persistOnSuccess,omitempty"`

	// The list of run time script actions.
	ScriptActions []*RuntimeScriptAction `json:"scriptActions,omitempty"`
}

// Extension - Cluster monitoring extensions.
type Extension struct {
	// The certificate for the cluster monitoring extensions.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// The workspace ID for the cluster monitoring extension.
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// ExtensionsClientBeginCreateOptions contains the optional parameters for the ExtensionsClient.BeginCreate method.
type ExtensionsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExtensionsClientBeginDeleteOptions contains the optional parameters for the ExtensionsClient.BeginDelete method.
type ExtensionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExtensionsClientBeginDisableAzureMonitorOptions contains the optional parameters for the ExtensionsClient.BeginDisableAzureMonitor
// method.
type ExtensionsClientBeginDisableAzureMonitorOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExtensionsClientBeginDisableMonitoringOptions contains the optional parameters for the ExtensionsClient.BeginDisableMonitoring
// method.
type ExtensionsClientBeginDisableMonitoringOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExtensionsClientBeginEnableAzureMonitorOptions contains the optional parameters for the ExtensionsClient.BeginEnableAzureMonitor
// method.
type ExtensionsClientBeginEnableAzureMonitorOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExtensionsClientBeginEnableMonitoringOptions contains the optional parameters for the ExtensionsClient.BeginEnableMonitoring
// method.
type ExtensionsClientBeginEnableMonitoringOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExtensionsClientGetAzureAsyncOperationStatusOptions contains the optional parameters for the ExtensionsClient.GetAzureAsyncOperationStatus
// method.
type ExtensionsClientGetAzureAsyncOperationStatusOptions struct {
	// placeholder for future optional parameters
}

// ExtensionsClientGetAzureMonitorStatusOptions contains the optional parameters for the ExtensionsClient.GetAzureMonitorStatus
// method.
type ExtensionsClientGetAzureMonitorStatusOptions struct {
	// placeholder for future optional parameters
}

// ExtensionsClientGetMonitoringStatusOptions contains the optional parameters for the ExtensionsClient.GetMonitoringStatus
// method.
type ExtensionsClientGetMonitoringStatusOptions struct {
	// placeholder for future optional parameters
}

// ExtensionsClientGetOptions contains the optional parameters for the ExtensionsClient.Get method.
type ExtensionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// GatewaySettings - Gateway settings.
type GatewaySettings struct {
	// READ-ONLY; Indicates whether or not the gateway settings based authorization is enabled.
	IsCredentialEnabled *string `json:"restAuthCredential.isEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The gateway settings user password.
	Password *string `json:"restAuthCredential.password,omitempty" azure:"ro"`

	// READ-ONLY; The gateway settings user name.
	UserName *string `json:"restAuthCredential.username,omitempty" azure:"ro"`
}

// HardwareProfile - The hardware profile.
type HardwareProfile struct {
	// The size of the VM
	VMSize *string `json:"vmSize,omitempty"`
}

// HostInfo - The cluster host information.
type HostInfo struct {
	// The effective disk encryption key URL used by the host
	EffectiveDiskEncryptionKeyURL *string `json:"effectiveDiskEncryptionKeyUrl,omitempty"`

	// The Fully Qualified Domain Name of host
	Fqdn *string `json:"fqdn,omitempty"`

	// The host name
	Name *string `json:"name,omitempty"`
}

// IPConfiguration - The ip configurations for the private link service.
type IPConfiguration struct {
	// REQUIRED; The name of private link IP configuration.
	Name *string `json:"name,omitempty"`

	// The private link ip configuration properties.
	Properties *IPConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; The private link IP configuration id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The type of the private link IP configuration.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IPConfigurationProperties - The private link ip configuration properties.
type IPConfigurationProperties struct {
	// Indicates whether this IP configuration is primary for the corresponding NIC.
	Primary *bool `json:"primary,omitempty"`

	// The IP address.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// The method that private IP address is allocated.
	PrivateIPAllocationMethod *PrivateIPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// The subnet resource id.
	Subnet *ResourceID `json:"subnet,omitempty"`

	// READ-ONLY; The private link configuration provisioning state, which only appears in the response.
	ProvisioningState *PrivateLinkConfigurationProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// KafkaRestProperties - The kafka rest proxy configuration which contains AAD security group information.
type KafkaRestProperties struct {
	// The information of AAD security group.
	ClientGroupInfo *ClientGroupInfo `json:"clientGroupInfo,omitempty"`

	// The configurations that need to be overriden.
	ConfigurationOverride map[string]*string `json:"configurationOverride,omitempty"`
}

// LinuxOperatingSystemProfile - The ssh username, password, and ssh public key.
type LinuxOperatingSystemProfile struct {
	// The password.
	Password *string `json:"password,omitempty"`

	// The SSH profile.
	SSHProfile *SSHProfile `json:"sshProfile,omitempty"`

	// The username.
	Username *string `json:"username,omitempty"`
}

// LocalizedName - The details about the localizable name of a type of usage.
type LocalizedName struct {
	// The localized name of the used resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// The name of the used resource.
	Value *string `json:"value,omitempty"`
}

// LocationsClientCheckNameAvailabilityOptions contains the optional parameters for the LocationsClient.CheckNameAvailability
// method.
type LocationsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// LocationsClientGetAzureAsyncOperationStatusOptions contains the optional parameters for the LocationsClient.GetAzureAsyncOperationStatus
// method.
type LocationsClientGetAzureAsyncOperationStatusOptions struct {
	// placeholder for future optional parameters
}

// LocationsClientGetCapabilitiesOptions contains the optional parameters for the LocationsClient.GetCapabilities method.
type LocationsClientGetCapabilitiesOptions struct {
	// placeholder for future optional parameters
}

// LocationsClientListBillingSpecsOptions contains the optional parameters for the LocationsClient.ListBillingSpecs method.
type LocationsClientListBillingSpecsOptions struct {
	// placeholder for future optional parameters
}

// LocationsClientListUsagesOptions contains the optional parameters for the LocationsClient.ListUsages method.
type LocationsClientListUsagesOptions struct {
	// placeholder for future optional parameters
}

// LocationsClientValidateClusterCreateRequestOptions contains the optional parameters for the LocationsClient.ValidateClusterCreateRequest
// method.
type LocationsClientValidateClusterCreateRequestOptions struct {
	// placeholder for future optional parameters
}

// MetricSpecifications - The details of metric specifications.
type MetricSpecifications struct {
	// The aggregation type of the metric specification.
	AggregationType *string `json:"aggregationType,omitempty"`

	// The category of the metric.
	Category *string `json:"category,omitempty"`

	// The override name of delegate metric.
	DelegateMetricNameOverride *string `json:"delegateMetricNameOverride,omitempty"`

	// The dimensions of the metric specification.
	Dimensions []*Dimension `json:"dimensions,omitempty"`

	// The display description of the metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// The display name of the metric specification.
	DisplayName *string `json:"displayName,omitempty"`

	// The flag indicates whether enable regional mdm account or not.
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty"`

	// The flag indicates whether filling gap with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// The flag indicates whether the metric is internal or not.
	IsInternal *bool `json:"isInternal,omitempty"`

	// The metric filter pattern.
	MetricFilterPattern *string `json:"metricFilterPattern,omitempty"`

	// The name of the metric specification.
	Name *string `json:"name,omitempty"`

	// The override name of resource id dimension name.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`

	// The source mdm account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`

	// The source mdm namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`

	// The supported aggregation types of the metric specification.
	SupportedAggregationTypes []*string `json:"supportedAggregationTypes,omitempty"`

	// The supported time grain types of the metric specification.
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty"`

	// The unit of the metric specification.
	Unit *string `json:"unit,omitempty"`
}

// NameAvailabilityCheckRequestParameters - The request spec of checking name availability.
type NameAvailabilityCheckRequestParameters struct {
	// The resource name.
	Name *string `json:"name,omitempty"`

	// The resource type
	Type *string `json:"type,omitempty"`
}

// NameAvailabilityCheckResult - The response spec of checking name availability.
type NameAvailabilityCheckResult struct {
	// This indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// READ-ONLY; The related message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The reason of the result.
	Reason *string `json:"reason,omitempty" azure:"ro"`
}

// NetworkProperties - The network properties.
type NetworkProperties struct {
	// Indicates whether or not private link is enabled.
	PrivateLink *PrivateLink `json:"privateLink,omitempty"`

	// The direction for the resource provider connection.
	ResourceProviderConnection *ResourceProviderConnection `json:"resourceProviderConnection,omitempty"`
}

// Operation - The HDInsight REST API operation.
type Operation struct {
	// The display of operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// The operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// The operation properties.
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Localized friendly description for the operation
	Description *string `json:"description,omitempty"`

	// The operation type: read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// The service provider: Microsoft.HDInsight
	Provider *string `json:"provider,omitempty"`

	// The resource on which the operation is performed: Cluster, Applications, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list HDInsight operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// The URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of HDInsight operations supported by the HDInsight resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationProperties - The details of operation.
type OperationProperties struct {
	// The specification of the service.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OsProfile - The Linux operation systems profile.
type OsProfile struct {
	// The Linux OS profile.
	LinuxOperatingSystemProfile *LinuxOperatingSystemProfile `json:"linuxOperatingSystemProfile,omitempty"`
}

// PrivateEndpoint - The private endpoint.
type PrivateEndpoint struct {
	// The private endpoint id.
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection - The private endpoint connection.
type PrivateEndpointConnection struct {
	// REQUIRED; The private endpoint connection properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - The list private endpoint connections response.
type PrivateEndpointConnectionListResult struct {
	// The list of private endpoint connections.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProperties - The private endpoint connection properties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; The private link service connection state.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; The link identifier.
	LinkIdentifier *string `json:"linkIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; The private endpoint of the private endpoint connection
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByClusterOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByCluster
// method.
type PrivateEndpointConnectionsClientListByClusterOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkConfiguration - The private link configuration.
type PrivateLinkConfiguration struct {
	// REQUIRED; The name of private link configuration.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The private link configuration properties.
	Properties *PrivateLinkConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; The private link configuration id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The type of the private link configuration.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkConfigurationProperties - The private link configuration properties.
type PrivateLinkConfigurationProperties struct {
	// REQUIRED; The HDInsight private linkable sub-resource name to apply the private link configuration to. For example, 'headnode',
	// 'gateway', 'edgenode'.
	GroupID *string `json:"groupId,omitempty"`

	// REQUIRED; The IP configurations for the private link service.
	IPConfigurations []*IPConfiguration `json:"ipConfigurations,omitempty"`

	// READ-ONLY; The private link configuration provisioning state, which only appears in the response.
	ProvisioningState *PrivateLinkConfigurationProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListByClusterOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByCluster
// method.
type PrivateLinkResourcesClientListByClusterOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - The private link service connection state.
type PrivateLinkServiceConnectionState struct {
	// REQUIRED; The concrete private link service connection.
	Status *PrivateLinkServiceConnectionStatus `json:"status,omitempty"`

	// Whether there is further actions.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The optional description of the status.
	Description *string `json:"description,omitempty"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QuotaCapability - The regional quota capability.
type QuotaCapability struct {
	// The number of cores used in the subscription.
	CoresUsed *int64 `json:"coresUsed,omitempty"`

	// The number of cores that the subscription allowed.
	MaxCoresAllowed *int64 `json:"maxCoresAllowed,omitempty"`

	// The list of region quota capabilities.
	RegionalQuotas []*RegionalQuotaCapability `json:"regionalQuotas,omitempty"`
}

// QuotaInfo - The quota properties for the cluster.
type QuotaInfo struct {
	// The cores used by the cluster.
	CoresUsed *int32 `json:"coresUsed,omitempty"`
}

// RegionalQuotaCapability - The regional quota capacity.
type RegionalQuotaCapability struct {
	// The number of cores available in the region.
	CoresAvailable *int64 `json:"coresAvailable,omitempty"`

	// The number of cores used in the region.
	CoresUsed *int64 `json:"coresUsed,omitempty"`

	// The region name.
	RegionName *string `json:"regionName,omitempty"`
}

// RegionsCapability - The regions capability.
type RegionsCapability struct {
	// The list of region capabilities.
	Available []*string `json:"available,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceID - The azure resource id.
type ResourceID struct {
	// The azure resource id.
	ID *string `json:"id,omitempty"`
}

// Role - Describes a role on the cluster.
type Role struct {
	// The autoscale configurations.
	AutoscaleConfiguration *Autoscale `json:"autoscale,omitempty"`

	// The data disks groups for the role.
	DataDisksGroups []*DataDisksGroups `json:"dataDisksGroups,omitempty"`

	// Indicates whether encrypt the data disks.
	EncryptDataDisks *bool `json:"encryptDataDisks,omitempty"`

	// The hardware profile.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`

	// The minimum instance count of the cluster.
	MinInstanceCount *int32 `json:"minInstanceCount,omitempty"`

	// The name of the role.
	Name *string `json:"name,omitempty"`

	// The operating system profile.
	OSProfile *OsProfile `json:"osProfile,omitempty"`

	// The list of script actions on the role.
	ScriptActions []*ScriptAction `json:"scriptActions,omitempty"`

	// The instance count of the cluster.
	TargetInstanceCount *int32 `json:"targetInstanceCount,omitempty"`

	// The name of the virtual machine group.
	VMGroupName *string `json:"VMGroupName,omitempty"`

	// The virtual network profile.
	VirtualNetworkProfile *VirtualNetworkProfile `json:"virtualNetworkProfile,omitempty"`
}

// RuntimeScriptAction - Describes a script action on a running cluster.
type RuntimeScriptAction struct {
	// REQUIRED; The name of the script action.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The list of roles where script will be executed.
	Roles []*string `json:"roles,omitempty"`

	// REQUIRED; The URI to the script.
	URI *string `json:"uri,omitempty"`

	// The parameters for the script
	Parameters *string `json:"parameters,omitempty"`

	// READ-ONLY; The application name of the script action, if any.
	ApplicationName *string `json:"applicationName,omitempty" azure:"ro"`
}

// RuntimeScriptActionDetail - The execution details of a script action.
type RuntimeScriptActionDetail struct {
	// REQUIRED; The name of the script action.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The list of roles where script will be executed.
	Roles []*string `json:"roles,omitempty"`

	// REQUIRED; The URI to the script.
	URI *string `json:"uri,omitempty"`

	// The parameters for the script
	Parameters *string `json:"parameters,omitempty"`

	// READ-ONLY; The application name of the script action, if any.
	ApplicationName *string `json:"applicationName,omitempty" azure:"ro"`

	// READ-ONLY; The script action execution debug information.
	DebugInformation *string `json:"debugInformation,omitempty" azure:"ro"`

	// READ-ONLY; The end time of script action execution.
	EndTime *string `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The summary of script action execution result.
	ExecutionSummary []*ScriptActionExecutionSummary `json:"executionSummary,omitempty" azure:"ro"`

	// READ-ONLY; The reason why the script action was executed.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The execution id of the script action.
	ScriptExecutionID *int64 `json:"scriptExecutionId,omitempty" azure:"ro"`

	// READ-ONLY; The start time of script action execution.
	StartTime *string `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The current execution status of the script action.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// SSHProfile - The list of SSH public keys.
type SSHProfile struct {
	// The list of SSH public keys.
	PublicKeys []*SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey - The SSH public key for the cluster nodes.
type SSHPublicKey struct {
	// The certificate for SSH.
	CertificateData *string `json:"certificateData,omitempty"`
}

// ScriptAction - Describes a script action on role on the cluster.
type ScriptAction struct {
	// REQUIRED; The name of the script action.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The parameters for the script provided.
	Parameters *string `json:"parameters,omitempty"`

	// REQUIRED; The URI to the script.
	URI *string `json:"uri,omitempty"`
}

// ScriptActionExecutionHistoryList - The list script execution history response.
type ScriptActionExecutionHistoryList struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of persisted script action details for the cluster.
	Value []*RuntimeScriptActionDetail `json:"value,omitempty" azure:"ro"`
}

// ScriptActionExecutionSummary - The execution summary of a script action.
type ScriptActionExecutionSummary struct {
	// READ-ONLY; The instance count for a given script action execution status.
	InstanceCount *int32 `json:"instanceCount,omitempty" azure:"ro"`

	// READ-ONLY; The status of script action execution.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// ScriptActionPersistedGetResponseSpec - The persisted script action for cluster.
type ScriptActionPersistedGetResponseSpec struct {
	// The application name for the script action.
	ApplicationName *string `json:"applicationName,omitempty"`

	// The name of script action.
	Name *string `json:"name,omitempty"`

	// The parameters for the script provided.
	Parameters *string `json:"parameters,omitempty"`

	// The list of roles where script will be executed.
	Roles []*string `json:"roles,omitempty"`

	// The URI to the script.
	URI *string `json:"uri,omitempty"`
}

// ScriptActionsClientDeleteOptions contains the optional parameters for the ScriptActionsClient.Delete method.
type ScriptActionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ScriptActionsClientGetExecutionAsyncOperationStatusOptions contains the optional parameters for the ScriptActionsClient.GetExecutionAsyncOperationStatus
// method.
type ScriptActionsClientGetExecutionAsyncOperationStatusOptions struct {
	// placeholder for future optional parameters
}

// ScriptActionsClientGetExecutionDetailOptions contains the optional parameters for the ScriptActionsClient.GetExecutionDetail
// method.
type ScriptActionsClientGetExecutionDetailOptions struct {
	// placeholder for future optional parameters
}

// ScriptActionsClientListByClusterOptions contains the optional parameters for the ScriptActionsClient.ListByCluster method.
type ScriptActionsClientListByClusterOptions struct {
	// placeholder for future optional parameters
}

// ScriptActionsList - The persisted script action for the cluster.
type ScriptActionsList struct {
	// The list of persisted script action details for the cluster.
	Value []*RuntimeScriptActionDetail `json:"value,omitempty"`

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ScriptExecutionHistoryClientListByClusterOptions contains the optional parameters for the ScriptExecutionHistoryClient.ListByCluster
// method.
type ScriptExecutionHistoryClientListByClusterOptions struct {
	// placeholder for future optional parameters
}

// ScriptExecutionHistoryClientPromoteOptions contains the optional parameters for the ScriptExecutionHistoryClient.Promote
// method.
type ScriptExecutionHistoryClientPromoteOptions struct {
	// placeholder for future optional parameters
}

// SecurityProfile - The security profile which contains Ssh public key for the HDInsight cluster.
type SecurityProfile struct {
	// The resource ID of the user's Azure Active Directory Domain Service.
	AaddsResourceID *string `json:"aaddsResourceId,omitempty"`

	// Optional. The Distinguished Names for cluster user groups
	ClusterUsersGroupDNs []*string `json:"clusterUsersGroupDNs,omitempty"`

	// The directory type.
	DirectoryType *DirectoryType `json:"directoryType,omitempty"`

	// The organization's active directory domain.
	Domain *string `json:"domain,omitempty"`

	// The domain admin password.
	DomainUserPassword *string `json:"domainUserPassword,omitempty"`

	// The domain user account that will have admin privileges on the cluster.
	DomainUsername *string `json:"domainUsername,omitempty"`

	// The LDAPS protocol URLs to communicate with the Active Directory.
	LdapsUrls []*string `json:"ldapsUrls,omitempty"`

	// User assigned identity that has permissions to read and create cluster-related artifacts in the user's AADDS.
	MsiResourceID *string `json:"msiResourceId,omitempty"`

	// The organizational unit within the Active Directory to place the cluster and service accounts.
	OrganizationalUnitDN *string `json:"organizationalUnitDN,omitempty"`
}

// ServiceSpecification - The specification of the service.
type ServiceSpecification struct {
	// The metric specifications.
	MetricSpecifications []*MetricSpecifications `json:"metricSpecifications,omitempty"`
}

// StorageAccount - The storage Account.
type StorageAccount struct {
	// The container in the storage account, only to be specified for WASB storage accounts.
	Container *string `json:"container,omitempty"`

	// The filesystem, only to be specified for Azure Data Lake Storage Gen 2.
	FileSystem *string `json:"fileSystem,omitempty"`

	// The file share name.
	Fileshare *string `json:"fileshare,omitempty"`

	// Whether or not the storage account is the default storage account.
	IsDefault *bool `json:"isDefault,omitempty"`

	// The storage account access key.
	Key *string `json:"key,omitempty"`

	// The managed identity (MSI) that is allowed to access the storage account, only to be specified for Azure Data Lake Storage
	// Gen 2.
	MsiResourceID *string `json:"msiResourceId,omitempty"`

	// The name of the storage account.
	Name *string `json:"name,omitempty"`

	// The resource ID of storage account, only to be specified for Azure Data Lake Storage Gen 2.
	ResourceID *string `json:"resourceId,omitempty"`

	// The shared access signature key.
	Saskey *string `json:"saskey,omitempty"`
}

// StorageProfile - The storage profile.
type StorageProfile struct {
	// The list of storage accounts in the cluster.
	Storageaccounts []*StorageAccount `json:"storageaccounts,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpdateClusterIdentityCertificateParameters - The update cluster identity certificate request parameters.
type UpdateClusterIdentityCertificateParameters struct {
	// The application id.
	ApplicationID *string `json:"applicationId,omitempty"`

	// The certificate in base64 encoded format.
	Certificate *string `json:"certificate,omitempty"`

	// The password of the certificate.
	CertificatePassword *string `json:"certificatePassword,omitempty"`
}

// UpdateGatewaySettingsParameters - The update gateway settings request parameters.
type UpdateGatewaySettingsParameters struct {
	// Indicates whether or not the gateway settings based authorization is enabled.
	IsCredentialEnabled *bool `json:"restAuthCredential.isEnabled,omitempty"`

	// The gateway settings user password.
	Password *string `json:"restAuthCredential.password,omitempty"`

	// The gateway settings user name.
	UserName *string `json:"restAuthCredential.username,omitempty"`
}

// Usage - The details about the usage of a particular limited resource.
type Usage struct {
	// The current usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`

	// The maximum allowed usage.
	Limit *int64 `json:"limit,omitempty"`

	// The type of measurement for usage.
	Unit *string `json:"unit,omitempty"`

	// READ-ONLY; The details about the localizable name of the used resource.
	Name *LocalizedName `json:"name,omitempty" azure:"ro"`
}

// UsagesListResult - The response for the operation to get regional usages for a subscription.
type UsagesListResult struct {
	// The list of usages.
	Value []*Usage `json:"value,omitempty"`
}

// UserAssignedIdentity - The User Assigned Identity
type UserAssignedIdentity struct {
	// The tenant id of user assigned identity.
	TenantID *string `json:"tenantId,omitempty"`

	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// VMSizeCompatibilityFilterV2 - This class represent a single filter object that defines a multidimensional set. The dimensions
// of this set are Regions, ClusterFlavors, NodeTypes and ClusterVersions. The constraint should be defined
// based on the following: FilterMode (Exclude vs Include), VMSizes (the vm sizes in affect of exclusion/inclusion) and the
// ordering of the Filters. Later filters override previous settings if
// conflicted.
type VMSizeCompatibilityFilterV2 struct {
	// The list of cluster flavors under the effect of the filter.
	ClusterFlavors []*string `json:"clusterFlavors,omitempty"`

	// The list of cluster versions affected in Major.Minor format.
	ClusterVersions []*string `json:"clusterVersions,omitempty"`

	// Whether support compute isolation. 'true' means only for ComputeIsolationEnabled, 'false' means only for regular cluster.
	ComputeIsolationSupported *string `json:"computeIsolationSupported,omitempty"`

	// Whether apply for ESP cluster. 'true' means only for ESP, 'false' means only for non-ESP, null or empty string or others
	// mean for both.
	EspApplied *string `json:"espApplied,omitempty"`

	// The filtering mode. Effectively this can enabling or disabling the VM sizes in a particular set.
	FilterMode *FilterMode `json:"filterMode,omitempty"`

	// The list of node types affected by the filter.
	NodeTypes []*string `json:"nodeTypes,omitempty"`

	// The OSType affected, Windows or Linux.
	OSType []*OSType `json:"osType,omitempty"`

	// The list of regions under the effect of the filter.
	Regions []*string `json:"regions,omitempty"`

	// The list of virtual machine sizes to include or exclude.
	VMSizes []*string `json:"vmSizes,omitempty"`
}

// VMSizeProperty - The vm size property
type VMSizeProperty struct {
	// The number of cores that the vm size has.
	Cores *int32 `json:"cores,omitempty"`

	// The data disk storage tier of the vm size.
	DataDiskStorageTier *string `json:"dataDiskStorageTier,omitempty"`

	// The label of the vm size.
	Label *string `json:"label,omitempty"`

	// The max data disk count of the vm size.
	MaxDataDiskCount *int64 `json:"maxDataDiskCount,omitempty"`

	// The memory whose unit is MB of the vm size.
	MemoryInMb *int64 `json:"memoryInMb,omitempty"`

	// The vm size name.
	Name *string `json:"name,omitempty"`

	// This indicates this vm size is supported by virtual machines or not
	SupportedByVirtualMachines *bool `json:"supportedByVirtualMachines,omitempty"`

	// The indicates this vm size is supported by web worker roles or not
	SupportedByWebWorkerRoles *bool `json:"supportedByWebWorkerRoles,omitempty"`

	// The virtual machine resource disk size whose unit is MB of the vm size.
	VirtualMachineResourceDiskSizeInMb *int64 `json:"virtualMachineResourceDiskSizeInMb,omitempty"`

	// The web worker resource disk size whose unit is MB of the vm size.
	WebWorkerResourceDiskSizeInMb *int64 `json:"webWorkerResourceDiskSizeInMb,omitempty"`
}

// ValidationErrorInfo - The validation error information.
type ValidationErrorInfo struct {
	// The error code.
	Code *string `json:"code,omitempty"`

	// The error resource.
	ErrorResource *string `json:"errorResource,omitempty"`

	// The error message.
	Message *string `json:"message,omitempty"`

	// The message arguments
	MessageArguments []*string `json:"messageArguments,omitempty"`
}

// VersionSpec - The version properties.
type VersionSpec struct {
	// The component version property.
	ComponentVersions map[string]*string `json:"componentVersions,omitempty"`

	// The display name
	DisplayName *string `json:"displayName,omitempty"`

	// The friendly name
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Whether or not the version is the default version.
	IsDefault *bool `json:"isDefault,omitempty"`
}

// VersionsCapability - The version capability.
type VersionsCapability struct {
	// The list of version capabilities.
	Available []*VersionSpec `json:"available,omitempty"`
}

// VirtualMachinesClientBeginRestartHostsOptions contains the optional parameters for the VirtualMachinesClient.BeginRestartHosts
// method.
type VirtualMachinesClientBeginRestartHostsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientGetAsyncOperationStatusOptions contains the optional parameters for the VirtualMachinesClient.GetAsyncOperationStatus
// method.
type VirtualMachinesClientGetAsyncOperationStatusOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListHostsOptions contains the optional parameters for the VirtualMachinesClient.ListHosts method.
type VirtualMachinesClientListHostsOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkProfile - The virtual network properties.
type VirtualNetworkProfile struct {
	// The ID of the virtual network.
	ID *string `json:"id,omitempty"`

	// The name of the subnet.
	Subnet *string `json:"subnet,omitempty"`
}
