//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtemplatespecs

import "time"

// AzureResourceBase - Common properties for all Azure resources.
type AzureResourceBase struct {
	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClientCreateOrUpdateOptions contains the optional parameters for the Client.CreateOrUpdate method.
type ClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ClientDeleteOptions contains the optional parameters for the Client.Delete method.
type ClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ClientGetBuiltInOptions contains the optional parameters for the Client.GetBuiltIn method.
type ClientGetBuiltInOptions struct {
	// Allows for expansion of additional Template Spec details in the response. Optional.
	Expand *TemplateSpecExpandKind
}

// ClientGetOptions contains the optional parameters for the Client.Get method.
type ClientGetOptions struct {
	// Allows for expansion of additional Template Spec details in the response. Optional.
	Expand *TemplateSpecExpandKind
}

// ClientListBuiltInsOptions contains the optional parameters for the Client.ListBuiltIns method.
type ClientListBuiltInsOptions struct {
	// Allows for expansion of additional Template Spec details in the response. Optional.
	Expand *TemplateSpecExpandKind
}

// ClientListByResourceGroupOptions contains the optional parameters for the Client.ListByResourceGroup method.
type ClientListByResourceGroupOptions struct {
	// Allows for expansion of additional Template Spec details in the response. Optional.
	Expand *TemplateSpecExpandKind
}

// ClientListBySubscriptionOptions contains the optional parameters for the Client.ListBySubscription method.
type ClientListBySubscriptionOptions struct {
	// Allows for expansion of additional Template Spec details in the response. Optional.
	Expand *TemplateSpecExpandKind
}

// ClientUpdateOptions contains the optional parameters for the Client.Update method.
type ClientUpdateOptions struct {
	// Template Spec resource with the tags to be updated.
	TemplateSpec *TemplateSpecUpdateModel
}

// Error - Template Specs error response.
type Error struct {
	// Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows
	// the OData error response format.)
	Error *ErrorResponse `json:"error,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.)
type ErrorResponse struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorResponse `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// LinkedTemplateArtifact - Represents a Template Spec artifact containing an embedded Azure Resource Manager template for
// use as a linked template.
type LinkedTemplateArtifact struct {
	// REQUIRED; A filesystem safe relative path of the artifact.
	Path *string `json:"path,omitempty"`

	// REQUIRED; The Azure Resource Manager template.
	Template interface{} `json:"template,omitempty"`
}

// ListResult - List of Template Specs.
type ListResult struct {
	// An array of Template Specs.
	Value []*TemplateSpec `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TemplateSpec - Template Spec object.
type TemplateSpec struct {
	// REQUIRED; The location of the Template Spec. It cannot be changed after Template Spec creation. It must be one of the supported
	// Azure locations.
	Location *string `json:"location,omitempty"`

	// Template Spec properties.
	Properties *TemplateSpecProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TemplateSpecProperties - Template Spec properties.
type TemplateSpecProperties struct {
	// Template Spec description.
	Description *string `json:"description,omitempty"`

	// Template Spec display name.
	DisplayName *string `json:"displayName,omitempty"`

	// The Template Spec metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
	Metadata interface{} `json:"metadata,omitempty"`

	// READ-ONLY; High-level information about the versions within this Template Spec. The keys are the version names. Only populated
	// if the $expand query parameter is set to 'versions'.
	Versions map[string]*TemplateSpecVersionInfo `json:"versions,omitempty" azure:"ro"`
}

// TemplateSpecUpdateModel - Template Spec properties to be updated (only tags are currently supported).
type TemplateSpecUpdateModel struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TemplateSpecVersion - Template Spec Version object.
type TemplateSpecVersion struct {
	// REQUIRED; The location of the Template Spec Version. It must match the location of the parent Template Spec.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Template Spec Version properties.
	Properties *TemplateSpecVersionProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TemplateSpecVersionInfo - High-level information about a Template Spec version.
type TemplateSpecVersionInfo struct {
	// READ-ONLY; Template Spec version description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp of when the version was created.
	TimeCreated *time.Time `json:"timeCreated,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp of when the version was last modified.
	TimeModified *time.Time `json:"timeModified,omitempty" azure:"ro"`
}

// TemplateSpecVersionProperties - Template Spec Version properties.
type TemplateSpecVersionProperties struct {
	// Template Spec version description.
	Description *string `json:"description,omitempty"`

	// An array of linked template artifacts.
	LinkedTemplates []*LinkedTemplateArtifact `json:"linkedTemplates,omitempty"`

	// The main Azure Resource Manager template content.
	MainTemplate interface{} `json:"mainTemplate,omitempty"`

	// The version metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
	Metadata interface{} `json:"metadata,omitempty"`

	// The Azure Resource Manager template UI definition content.
	UIFormDefinition interface{} `json:"uiFormDefinition,omitempty"`
}

// TemplateSpecVersionUpdateModel - Template Spec Version properties to be updated (only tags are currently supported).
type TemplateSpecVersionUpdateModel struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TemplateSpecVersionsClientCreateOrUpdateOptions contains the optional parameters for the TemplateSpecVersionsClient.CreateOrUpdate
// method.
type TemplateSpecVersionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// TemplateSpecVersionsClientDeleteOptions contains the optional parameters for the TemplateSpecVersionsClient.Delete method.
type TemplateSpecVersionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// TemplateSpecVersionsClientGetBuiltInOptions contains the optional parameters for the TemplateSpecVersionsClient.GetBuiltIn
// method.
type TemplateSpecVersionsClientGetBuiltInOptions struct {
	// placeholder for future optional parameters
}

// TemplateSpecVersionsClientGetOptions contains the optional parameters for the TemplateSpecVersionsClient.Get method.
type TemplateSpecVersionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TemplateSpecVersionsClientListBuiltInsOptions contains the optional parameters for the TemplateSpecVersionsClient.ListBuiltIns
// method.
type TemplateSpecVersionsClientListBuiltInsOptions struct {
	// placeholder for future optional parameters
}

// TemplateSpecVersionsClientListOptions contains the optional parameters for the TemplateSpecVersionsClient.List method.
type TemplateSpecVersionsClientListOptions struct {
	// placeholder for future optional parameters
}

// TemplateSpecVersionsClientUpdateOptions contains the optional parameters for the TemplateSpecVersionsClient.Update method.
type TemplateSpecVersionsClientUpdateOptions struct {
	// Template Spec Version resource with the tags to be updated.
	TemplateSpecVersionUpdateModel *TemplateSpecVersionUpdateModel
}

// TemplateSpecVersionsListResult - List of Template Specs versions
type TemplateSpecVersionsListResult struct {
	// An array of Template Spec versions.
	Value []*TemplateSpecVersion `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}
