//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecuritydevops

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AzureDevOpsOrgClient contains the methods for the AzureDevOpsOrg group.
// Don't use this type directly, use NewAzureDevOpsOrgClient() instead.
type AzureDevOpsOrgClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewAzureDevOpsOrgClient creates a new instance of AzureDevOpsOrgClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewAzureDevOpsOrgClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AzureDevOpsOrgClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &AzureDevOpsOrgClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Creates or updates an Azure DevOps Org.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-09-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// azureDevOpsConnectorName - Name of the AzureDevOps Connector.
// azureDevOpsOrgName - Name of the AzureDevOps Org.
// azureDevOpsOrg - Azure DevOps Org resource payload.
// options - AzureDevOpsOrgClientBeginCreateOrUpdateOptions contains the optional parameters for the AzureDevOpsOrgClient.BeginCreateOrUpdate
// method.
func (client *AzureDevOpsOrgClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, azureDevOpsOrgName string, azureDevOpsOrg AzureDevOpsOrg, options *AzureDevOpsOrgClientBeginCreateOrUpdateOptions) (*runtime.Poller[AzureDevOpsOrgClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, azureDevOpsConnectorName, azureDevOpsOrgName, azureDevOpsOrg, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[AzureDevOpsOrgClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[AzureDevOpsOrgClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Creates or updates an Azure DevOps Org.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-09-01-preview
func (client *AzureDevOpsOrgClient) createOrUpdate(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, azureDevOpsOrgName string, azureDevOpsOrg AzureDevOpsOrg, options *AzureDevOpsOrgClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, azureDevOpsConnectorName, azureDevOpsOrgName, azureDevOpsOrg, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *AzureDevOpsOrgClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, azureDevOpsOrgName string, azureDevOpsOrg AzureDevOpsOrg, options *AzureDevOpsOrgClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureDevOpsConnectorName == "" {
		return nil, errors.New("parameter azureDevOpsConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureDevOpsConnectorName}", url.PathEscape(azureDevOpsConnectorName))
	if azureDevOpsOrgName == "" {
		return nil, errors.New("parameter azureDevOpsOrgName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureDevOpsOrgName}", url.PathEscape(azureDevOpsOrgName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, azureDevOpsOrg)
}

// Get - Returns a monitored AzureDevOps Org resource for a given ID.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-09-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// azureDevOpsConnectorName - Name of the AzureDevOps Connector.
// azureDevOpsOrgName - Name of the AzureDevOps Org.
// options - AzureDevOpsOrgClientGetOptions contains the optional parameters for the AzureDevOpsOrgClient.Get method.
func (client *AzureDevOpsOrgClient) Get(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, azureDevOpsOrgName string, options *AzureDevOpsOrgClientGetOptions) (AzureDevOpsOrgClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, azureDevOpsConnectorName, azureDevOpsOrgName, options)
	if err != nil {
		return AzureDevOpsOrgClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureDevOpsOrgClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AzureDevOpsOrgClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *AzureDevOpsOrgClient) getCreateRequest(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, azureDevOpsOrgName string, options *AzureDevOpsOrgClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureDevOpsConnectorName == "" {
		return nil, errors.New("parameter azureDevOpsConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureDevOpsConnectorName}", url.PathEscape(azureDevOpsConnectorName))
	if azureDevOpsOrgName == "" {
		return nil, errors.New("parameter azureDevOpsOrgName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureDevOpsOrgName}", url.PathEscape(azureDevOpsOrgName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AzureDevOpsOrgClient) getHandleResponse(resp *http.Response) (AzureDevOpsOrgClientGetResponse, error) {
	result := AzureDevOpsOrgClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureDevOpsOrg); err != nil {
		return AzureDevOpsOrgClientGetResponse{}, err
	}
	return result, nil
}

// resourceGroupName - The name of the resource group. The name is case insensitive.
// azureDevOpsConnectorName - Name of the AzureDevOps Connector.
// options - AzureDevOpsOrgClientListOptions contains the optional parameters for the AzureDevOpsOrgClient.List method.
func (client *AzureDevOpsOrgClient) NewListPager(resourceGroupName string, azureDevOpsConnectorName string, options *AzureDevOpsOrgClientListOptions) *runtime.Pager[AzureDevOpsOrgClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureDevOpsOrgClientListResponse]{
		More: func(page AzureDevOpsOrgClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureDevOpsOrgClientListResponse) (AzureDevOpsOrgClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, resourceGroupName, azureDevOpsConnectorName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return AzureDevOpsOrgClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AzureDevOpsOrgClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AzureDevOpsOrgClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *AzureDevOpsOrgClient) listCreateRequest(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, options *AzureDevOpsOrgClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureDevOpsConnectorName == "" {
		return nil, errors.New("parameter azureDevOpsConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureDevOpsConnectorName}", url.PathEscape(azureDevOpsConnectorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *AzureDevOpsOrgClient) listHandleResponse(resp *http.Response) (AzureDevOpsOrgClientListResponse, error) {
	result := AzureDevOpsOrgClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureDevOpsOrgListResponse); err != nil {
		return AzureDevOpsOrgClientListResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Update monitored AzureDevOps Org details.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-09-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// azureDevOpsConnectorName - Name of the AzureDevOps Connector.
// azureDevOpsOrgName - Name of the AzureDevOps Org.
// azureDevOpsOrg - Azure DevOps Org resource payload.
// options - AzureDevOpsOrgClientBeginUpdateOptions contains the optional parameters for the AzureDevOpsOrgClient.BeginUpdate
// method.
func (client *AzureDevOpsOrgClient) BeginUpdate(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, azureDevOpsOrgName string, azureDevOpsOrg AzureDevOpsOrg, options *AzureDevOpsOrgClientBeginUpdateOptions) (*runtime.Poller[AzureDevOpsOrgClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, azureDevOpsConnectorName, azureDevOpsOrgName, azureDevOpsOrg, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[AzureDevOpsOrgClientUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[AzureDevOpsOrgClientUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Update - Update monitored AzureDevOps Org details.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-09-01-preview
func (client *AzureDevOpsOrgClient) update(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, azureDevOpsOrgName string, azureDevOpsOrg AzureDevOpsOrg, options *AzureDevOpsOrgClientBeginUpdateOptions) (*http.Response, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, azureDevOpsConnectorName, azureDevOpsOrgName, azureDevOpsOrg, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateCreateRequest creates the Update request.
func (client *AzureDevOpsOrgClient) updateCreateRequest(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, azureDevOpsOrgName string, azureDevOpsOrg AzureDevOpsOrg, options *AzureDevOpsOrgClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureDevOpsConnectorName == "" {
		return nil, errors.New("parameter azureDevOpsConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureDevOpsConnectorName}", url.PathEscape(azureDevOpsConnectorName))
	if azureDevOpsOrgName == "" {
		return nil, errors.New("parameter azureDevOpsOrgName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureDevOpsOrgName}", url.PathEscape(azureDevOpsOrgName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, azureDevOpsOrg)
}
