// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates or updates the auth policy. The policy string in JSON must not contain
// newlines or blank lines.
//
// For more information, see [Auth policies] in the Amazon VPC Lattice User Guide.
//
// [Auth policies]: https://docs.aws.amazon.com/vpc-lattice/latest/ug/auth-policies.html
func (c *Client) PutAuthPolicy(ctx context.Context, params *PutAuthPolicyInput, optFns ...func(*Options)) (*PutAuthPolicyOutput, error) {
	if params == nil {
		params = &PutAuthPolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutAuthPolicy", params, optFns, c.addOperationPutAuthPolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutAuthPolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutAuthPolicyInput struct {

	// The auth policy. The policy string in JSON must not contain newlines or blank
	// lines.
	//
	// This member is required.
	Policy *string

	// The ID or Amazon Resource Name (ARN) of the service network or service for
	// which the policy is created.
	//
	// This member is required.
	ResourceIdentifier *string

	noSmithyDocumentSerde
}

type PutAuthPolicyOutput struct {

	// The auth policy. The policy string in JSON must not contain newlines or blank
	// lines.
	Policy *string

	// The state of the auth policy. The auth policy is only active when the auth type
	// is set to AWS_IAM . If you provide a policy, then authentication and
	// authorization decisions are made based on this policy and the client's IAM
	// policy. If the Auth type is NONE , then, any auth policy that you provide
	// remains inactive. For more information, see [Create a service network]in the Amazon VPC Lattice User
	// Guide.
	//
	// [Create a service network]: https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network
	State types.AuthPolicyState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutAuthPolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutAuthPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutAuthPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutAuthPolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPutAuthPolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutAuthPolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutAuthPolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutAuthPolicy",
	}
}
