// Code generated by smithy-go-codegen DO NOT EDIT.

package organizations

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/organizations/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAcceptHandshake struct {
}

func (*validateOpAcceptHandshake) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAcceptHandshake) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AcceptHandshakeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAcceptHandshakeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAttachPolicy struct {
}

func (*validateOpAttachPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAttachPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AttachPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAttachPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCancelHandshake struct {
}

func (*validateOpCancelHandshake) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelHandshake) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelHandshakeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelHandshakeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCloseAccount struct {
}

func (*validateOpCloseAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCloseAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CloseAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCloseAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateAccount struct {
}

func (*validateOpCreateAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateGovCloudAccount struct {
}

func (*validateOpCreateGovCloudAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateGovCloudAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateGovCloudAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateGovCloudAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateOrganizationalUnit struct {
}

func (*validateOpCreateOrganizationalUnit) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateOrganizationalUnit) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateOrganizationalUnitInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateOrganizationalUnitInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreatePolicy struct {
}

func (*validateOpCreatePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeclineHandshake struct {
}

func (*validateOpDeclineHandshake) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeclineHandshake) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeclineHandshakeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeclineHandshakeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteOrganizationalUnit struct {
}

func (*validateOpDeleteOrganizationalUnit) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteOrganizationalUnit) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteOrganizationalUnitInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteOrganizationalUnitInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeletePolicy struct {
}

func (*validateOpDeletePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeletePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeletePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeletePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeregisterDelegatedAdministrator struct {
}

func (*validateOpDeregisterDelegatedAdministrator) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeregisterDelegatedAdministrator) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeregisterDelegatedAdministratorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeregisterDelegatedAdministratorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeAccount struct {
}

func (*validateOpDescribeAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeCreateAccountStatus struct {
}

func (*validateOpDescribeCreateAccountStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeCreateAccountStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeCreateAccountStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeCreateAccountStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeEffectivePolicy struct {
}

func (*validateOpDescribeEffectivePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeEffectivePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeEffectivePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeEffectivePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeHandshake struct {
}

func (*validateOpDescribeHandshake) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeHandshake) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeHandshakeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeHandshakeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeOrganizationalUnit struct {
}

func (*validateOpDescribeOrganizationalUnit) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeOrganizationalUnit) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeOrganizationalUnitInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeOrganizationalUnitInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribePolicy struct {
}

func (*validateOpDescribePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDetachPolicy struct {
}

func (*validateOpDetachPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDetachPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DetachPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDetachPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisableAWSServiceAccess struct {
}

func (*validateOpDisableAWSServiceAccess) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisableAWSServiceAccess) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisableAWSServiceAccessInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisableAWSServiceAccessInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisablePolicyType struct {
}

func (*validateOpDisablePolicyType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisablePolicyType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisablePolicyTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisablePolicyTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnableAWSServiceAccess struct {
}

func (*validateOpEnableAWSServiceAccess) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnableAWSServiceAccess) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnableAWSServiceAccessInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnableAWSServiceAccessInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnablePolicyType struct {
}

func (*validateOpEnablePolicyType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnablePolicyType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnablePolicyTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnablePolicyTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInviteAccountToOrganization struct {
}

func (*validateOpInviteAccountToOrganization) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInviteAccountToOrganization) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InviteAccountToOrganizationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInviteAccountToOrganizationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAccountsForParent struct {
}

func (*validateOpListAccountsForParent) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAccountsForParent) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAccountsForParentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAccountsForParentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListChildren struct {
}

func (*validateOpListChildren) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListChildren) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListChildrenInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListChildrenInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListDelegatedServicesForAccount struct {
}

func (*validateOpListDelegatedServicesForAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListDelegatedServicesForAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListDelegatedServicesForAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListDelegatedServicesForAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListOrganizationalUnitsForParent struct {
}

func (*validateOpListOrganizationalUnitsForParent) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListOrganizationalUnitsForParent) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListOrganizationalUnitsForParentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListOrganizationalUnitsForParentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListParents struct {
}

func (*validateOpListParents) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListParents) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListParentsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListParentsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListPoliciesForTarget struct {
}

func (*validateOpListPoliciesForTarget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListPoliciesForTarget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPoliciesForTargetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPoliciesForTargetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListPolicies struct {
}

func (*validateOpListPolicies) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListPolicies) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPoliciesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPoliciesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTargetsForPolicy struct {
}

func (*validateOpListTargetsForPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTargetsForPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTargetsForPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTargetsForPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpMoveAccount struct {
}

func (*validateOpMoveAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpMoveAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*MoveAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpMoveAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRegisterDelegatedAdministrator struct {
}

func (*validateOpRegisterDelegatedAdministrator) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRegisterDelegatedAdministrator) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RegisterDelegatedAdministratorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRegisterDelegatedAdministratorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRemoveAccountFromOrganization struct {
}

func (*validateOpRemoveAccountFromOrganization) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRemoveAccountFromOrganization) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RemoveAccountFromOrganizationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRemoveAccountFromOrganizationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateOrganizationalUnit struct {
}

func (*validateOpUpdateOrganizationalUnit) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateOrganizationalUnit) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateOrganizationalUnitInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateOrganizationalUnitInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePolicy struct {
}

func (*validateOpUpdatePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAcceptHandshakeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAcceptHandshake{}, middleware.After)
}

func addOpAttachPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAttachPolicy{}, middleware.After)
}

func addOpCancelHandshakeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelHandshake{}, middleware.After)
}

func addOpCloseAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCloseAccount{}, middleware.After)
}

func addOpCreateAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAccount{}, middleware.After)
}

func addOpCreateGovCloudAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateGovCloudAccount{}, middleware.After)
}

func addOpCreateOrganizationalUnitValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateOrganizationalUnit{}, middleware.After)
}

func addOpCreatePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePolicy{}, middleware.After)
}

func addOpDeclineHandshakeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeclineHandshake{}, middleware.After)
}

func addOpDeleteOrganizationalUnitValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteOrganizationalUnit{}, middleware.After)
}

func addOpDeletePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeletePolicy{}, middleware.After)
}

func addOpDeregisterDelegatedAdministratorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeregisterDelegatedAdministrator{}, middleware.After)
}

func addOpDescribeAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeAccount{}, middleware.After)
}

func addOpDescribeCreateAccountStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeCreateAccountStatus{}, middleware.After)
}

func addOpDescribeEffectivePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeEffectivePolicy{}, middleware.After)
}

func addOpDescribeHandshakeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeHandshake{}, middleware.After)
}

func addOpDescribeOrganizationalUnitValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeOrganizationalUnit{}, middleware.After)
}

func addOpDescribePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribePolicy{}, middleware.After)
}

func addOpDetachPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDetachPolicy{}, middleware.After)
}

func addOpDisableAWSServiceAccessValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisableAWSServiceAccess{}, middleware.After)
}

func addOpDisablePolicyTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisablePolicyType{}, middleware.After)
}

func addOpEnableAWSServiceAccessValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnableAWSServiceAccess{}, middleware.After)
}

func addOpEnablePolicyTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnablePolicyType{}, middleware.After)
}

func addOpInviteAccountToOrganizationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInviteAccountToOrganization{}, middleware.After)
}

func addOpListAccountsForParentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAccountsForParent{}, middleware.After)
}

func addOpListChildrenValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListChildren{}, middleware.After)
}

func addOpListDelegatedServicesForAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListDelegatedServicesForAccount{}, middleware.After)
}

func addOpListOrganizationalUnitsForParentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListOrganizationalUnitsForParent{}, middleware.After)
}

func addOpListParentsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListParents{}, middleware.After)
}

func addOpListPoliciesForTargetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListPoliciesForTarget{}, middleware.After)
}

func addOpListPoliciesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListPolicies{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpListTargetsForPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTargetsForPolicy{}, middleware.After)
}

func addOpMoveAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpMoveAccount{}, middleware.After)
}

func addOpRegisterDelegatedAdministratorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRegisterDelegatedAdministrator{}, middleware.After)
}

func addOpRemoveAccountFromOrganizationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRemoveAccountFromOrganization{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateOrganizationalUnitValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateOrganizationalUnit{}, middleware.After)
}

func addOpUpdatePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePolicy{}, middleware.After)
}

func validateHandshakeParty(v *types.HandshakeParty) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HandshakeParty"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTags(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tags"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAcceptHandshakeInput(v *AcceptHandshakeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AcceptHandshakeInput"}
	if v.HandshakeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HandshakeId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAttachPolicyInput(v *AttachPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AttachPolicyInput"}
	if v.PolicyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyId"))
	}
	if v.TargetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelHandshakeInput(v *CancelHandshakeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelHandshakeInput"}
	if v.HandshakeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HandshakeId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCloseAccountInput(v *CloseAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CloseAccountInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAccountInput(v *CreateAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAccountInput"}
	if v.Email == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Email"))
	}
	if v.AccountName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountName"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateGovCloudAccountInput(v *CreateGovCloudAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateGovCloudAccountInput"}
	if v.Email == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Email"))
	}
	if v.AccountName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountName"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateOrganizationalUnitInput(v *CreateOrganizationalUnitInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateOrganizationalUnitInput"}
	if v.ParentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ParentId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePolicyInput(v *CreatePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePolicyInput"}
	if v.Content == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Content"))
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeclineHandshakeInput(v *DeclineHandshakeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeclineHandshakeInput"}
	if v.HandshakeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HandshakeId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteOrganizationalUnitInput(v *DeleteOrganizationalUnitInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteOrganizationalUnitInput"}
	if v.OrganizationalUnitId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OrganizationalUnitId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeletePolicyInput(v *DeletePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeletePolicyInput"}
	if v.PolicyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeregisterDelegatedAdministratorInput(v *DeregisterDelegatedAdministratorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeregisterDelegatedAdministratorInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.ServicePrincipal == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServicePrincipal"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeAccountInput(v *DescribeAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeAccountInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeCreateAccountStatusInput(v *DescribeCreateAccountStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeCreateAccountStatusInput"}
	if v.CreateAccountRequestId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CreateAccountRequestId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeEffectivePolicyInput(v *DescribeEffectivePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeEffectivePolicyInput"}
	if len(v.PolicyType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeHandshakeInput(v *DescribeHandshakeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeHandshakeInput"}
	if v.HandshakeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HandshakeId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeOrganizationalUnitInput(v *DescribeOrganizationalUnitInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeOrganizationalUnitInput"}
	if v.OrganizationalUnitId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OrganizationalUnitId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribePolicyInput(v *DescribePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribePolicyInput"}
	if v.PolicyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDetachPolicyInput(v *DetachPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DetachPolicyInput"}
	if v.PolicyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyId"))
	}
	if v.TargetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisableAWSServiceAccessInput(v *DisableAWSServiceAccessInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisableAWSServiceAccessInput"}
	if v.ServicePrincipal == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServicePrincipal"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisablePolicyTypeInput(v *DisablePolicyTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisablePolicyTypeInput"}
	if v.RootId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RootId"))
	}
	if len(v.PolicyType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnableAWSServiceAccessInput(v *EnableAWSServiceAccessInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnableAWSServiceAccessInput"}
	if v.ServicePrincipal == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServicePrincipal"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnablePolicyTypeInput(v *EnablePolicyTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnablePolicyTypeInput"}
	if v.RootId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RootId"))
	}
	if len(v.PolicyType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInviteAccountToOrganizationInput(v *InviteAccountToOrganizationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InviteAccountToOrganizationInput"}
	if v.Target == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Target"))
	} else if v.Target != nil {
		if err := validateHandshakeParty(v.Target); err != nil {
			invalidParams.AddNested("Target", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAccountsForParentInput(v *ListAccountsForParentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAccountsForParentInput"}
	if v.ParentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ParentId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListChildrenInput(v *ListChildrenInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListChildrenInput"}
	if v.ParentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ParentId"))
	}
	if len(v.ChildType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ChildType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListDelegatedServicesForAccountInput(v *ListDelegatedServicesForAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListDelegatedServicesForAccountInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListOrganizationalUnitsForParentInput(v *ListOrganizationalUnitsForParentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOrganizationalUnitsForParentInput"}
	if v.ParentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ParentId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListParentsInput(v *ListParentsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListParentsInput"}
	if v.ChildId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChildId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPoliciesForTargetInput(v *ListPoliciesForTargetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPoliciesForTargetInput"}
	if v.TargetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetId"))
	}
	if len(v.Filter) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Filter"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPoliciesInput(v *ListPoliciesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPoliciesInput"}
	if len(v.Filter) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Filter"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTargetsForPolicyInput(v *ListTargetsForPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTargetsForPolicyInput"}
	if v.PolicyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpMoveAccountInput(v *MoveAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MoveAccountInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.SourceParentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceParentId"))
	}
	if v.DestinationParentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationParentId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRegisterDelegatedAdministratorInput(v *RegisterDelegatedAdministratorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RegisterDelegatedAdministratorInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.ServicePrincipal == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServicePrincipal"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRemoveAccountFromOrganizationInput(v *RemoveAccountFromOrganizationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RemoveAccountFromOrganizationInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceId"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceId"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateOrganizationalUnitInput(v *UpdateOrganizationalUnitInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateOrganizationalUnitInput"}
	if v.OrganizationalUnitId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OrganizationalUnitId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePolicyInput(v *UpdatePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePolicyInput"}
	if v.PolicyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
