// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/devicefarm"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To create a new device pool
// The following example creates a new device pool named MyDevicePool inside an existing
// project.
func ExampleDeviceFarm_CreateDevicePool_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.CreateDevicePoolInput{
		Description: aws.String("My Android devices"),
		Name:        aws.String("MyDevicePool"),
		ProjectArn:  aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.CreateDevicePool(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a new project
// The following example creates a new project named MyProject.
func ExampleDeviceFarm_CreateProject_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.CreateProjectInput{
		Name: aws.String("MyProject"),
	}

	result, err := svc.CreateProject(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			case devicefarm.ErrCodeTagOperationException:
				fmt.Println(devicefarm.ErrCodeTagOperationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a remote access session
// The following example creates a remote access session named MySession.
func ExampleDeviceFarm_CreateRemoteAccessSession_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.CreateRemoteAccessSessionInput{
		Configuration: &devicefarm.CreateRemoteAccessSessionConfiguration{
			BillingMethod: aws.String("METERED"),
		},
		DeviceArn:  aws.String("arn:aws:devicefarm:us-west-2::device:123EXAMPLE"),
		Name:       aws.String("MySession"),
		ProjectArn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.CreateRemoteAccessSession(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a new test package upload
// The following example creates a new Appium Python test package upload inside an existing
// project.
func ExampleDeviceFarm_CreateUpload_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.CreateUploadInput{
		Name:       aws.String("MyAppiumPythonUpload"),
		ProjectArn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		Type:       aws.String("APPIUM_PYTHON_TEST_PACKAGE"),
	}

	result, err := svc.CreateUpload(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a device pool
// The following example deletes a specific device pool.
func ExampleDeviceFarm_DeleteDevicePool_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.DeleteDevicePoolInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2::devicepool:123-456-EXAMPLE-GUID"),
	}

	result, err := svc.DeleteDevicePool(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a project
// The following example deletes a specific project.
func ExampleDeviceFarm_DeleteProject_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.DeleteProjectInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.DeleteProject(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a specific remote access session
// The following example deletes a specific remote access session.
func ExampleDeviceFarm_DeleteRemoteAccessSession_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.DeleteRemoteAccessSessionInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:session:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.DeleteRemoteAccessSession(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a run
// The following example deletes a specific test run.
func ExampleDeviceFarm_DeleteRun_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.DeleteRunInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:run:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.DeleteRun(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a specific upload
// The following example deletes a specific upload.
func ExampleDeviceFarm_DeleteUpload_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.DeleteUploadInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:upload:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.DeleteUpload(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about account settings
// The following example returns information about your Device Farm account settings.
func ExampleDeviceFarm_GetAccountSettings_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.GetAccountSettingsInput{}

	result, err := svc.GetAccountSettings(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a device
// The following example returns information about a specific device.
func ExampleDeviceFarm_GetDevice_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.GetDeviceInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2::device:123EXAMPLE"),
	}

	result, err := svc.GetDevice(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a device pool
// The following example returns information about a specific device pool, given a project
// ARN.
func ExampleDeviceFarm_GetDevicePool_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.GetDevicePoolInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.GetDevicePool(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about the compatibility of a device pool
// The following example returns information about the compatibility of a specific device
// pool, given its ARN.
func ExampleDeviceFarm_GetDevicePoolCompatibility_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.GetDevicePoolCompatibilityInput{
		AppArn:        aws.String("arn:aws:devicefarm:us-west-2::app:123-456-EXAMPLE-GUID"),
		DevicePoolArn: aws.String("arn:aws:devicefarm:us-west-2::devicepool:123-456-EXAMPLE-GUID"),
		TestType:      aws.String("APPIUM_PYTHON"),
	}

	result, err := svc.GetDevicePoolCompatibility(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a job
// The following example returns information about a specific job.
func ExampleDeviceFarm_GetJob_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.GetJobInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2::job:123-456-EXAMPLE-GUID"),
	}

	result, err := svc.GetJob(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get status information about device offerings
// The following example returns information about Device Farm offerings available to
// your account.
func ExampleDeviceFarm_GetOfferingStatus_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.GetOfferingStatusInput{
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE="),
	}

	result, err := svc.GetOfferingStatus(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeNotEligibleException:
				fmt.Println(devicefarm.ErrCodeNotEligibleException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a project
// The following example gets information about a specific project.
func ExampleDeviceFarm_GetProject_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.GetProjectInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:5e01a8c7-c861-4c0a-b1d5-12345EXAMPLE"),
	}

	result, err := svc.GetProject(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a remote access session
// The following example gets a specific remote access session.
func ExampleDeviceFarm_GetRemoteAccessSession_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.GetRemoteAccessSessionInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:session:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.GetRemoteAccessSession(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a test run
// The following example gets information about a specific test run.
func ExampleDeviceFarm_GetRun_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.GetRunInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:run:5e01a8c7-c861-4c0a-b1d5-5ec6e6c6dd23/0fcac17b-6122-44d7-ae5a-12345EXAMPLE"),
	}

	result, err := svc.GetRun(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a test suite
// The following example gets information about a specific test suite.
func ExampleDeviceFarm_GetSuite_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.GetSuiteInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:suite:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.GetSuite(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a specific test
// The following example gets information about a specific test.
func ExampleDeviceFarm_GetTest_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.GetTestInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:test:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.GetTest(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a specific upload
// The following example gets information about a specific upload.
func ExampleDeviceFarm_GetUpload_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.GetUploadInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:upload:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.GetUpload(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To install to a remote access session
// The following example installs a specific app to a device in a specific remote access
// session.
func ExampleDeviceFarm_InstallToRemoteAccessSession_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.InstallToRemoteAccessSessionInput{
		AppArn:                 aws.String("arn:aws:devicefarm:us-west-2:123456789101:app:EXAMPLE-GUID-123-456"),
		RemoteAccessSessionArn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:session:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.InstallToRemoteAccessSession(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list artifacts for a resource
// The following example lists screenshot artifacts for a specific run.
func ExampleDeviceFarm_ListArtifacts_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListArtifactsInput{
		Arn:  aws.String("arn:aws:devicefarm:us-west-2:123456789101:run:EXAMPLE-GUID-123-456"),
		Type: aws.String("SCREENSHOT"),
	}

	result, err := svc.ListArtifacts(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about device pools
// The following example returns information about the private device pools in a specific
// project.
func ExampleDeviceFarm_ListDevicePools_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListDevicePoolsInput{
		Arn:  aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		Type: aws.String("PRIVATE"),
	}

	result, err := svc.ListDevicePools(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about devices
// The following example returns information about the available devices in a specific
// project.
func ExampleDeviceFarm_ListDevices_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListDevicesInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.ListDevices(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about jobs
// The following example returns information about jobs in a specific project.
func ExampleDeviceFarm_ListJobs_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListJobsInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.ListJobs(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about device offering transactions
// The following example returns information about Device Farm offering transactions.
func ExampleDeviceFarm_ListOfferingTransactions_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListOfferingTransactionsInput{
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE="),
	}

	result, err := svc.ListOfferingTransactions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeNotEligibleException:
				fmt.Println(devicefarm.ErrCodeNotEligibleException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about device offerings
// The following example returns information about available device offerings.
func ExampleDeviceFarm_ListOfferings_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListOfferingsInput{
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE="),
	}

	result, err := svc.ListOfferings(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeNotEligibleException:
				fmt.Println(devicefarm.ErrCodeNotEligibleException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a Device Farm project
// The following example returns information about the specified project in Device Farm.
func ExampleDeviceFarm_ListProjects_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListProjectsInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:7ad300ed-8183-41a7-bf94-12345EXAMPLE"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	result, err := svc.ListProjects(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a remote access session
// The following example returns information about a specific Device Farm remote access
// session.
func ExampleDeviceFarm_ListRemoteAccessSessions_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListRemoteAccessSessionsInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:session:EXAMPLE-GUID-123-456"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE="),
	}

	result, err := svc.ListRemoteAccessSessions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a test run
// The following example returns information about a specific test run.
func ExampleDeviceFarm_ListRuns_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListRunsInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:run:5e01a8c7-c861-4c0a-b1d5-5ec6e6c6dd23/0fcac17b-6122-44d7-ae5a-12345EXAMPLE"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	result, err := svc.ListRuns(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about samples
// The following example returns information about samples, given a specific Device
// Farm project.
func ExampleDeviceFarm_ListSamples_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListSamplesInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	result, err := svc.ListSamples(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about suites
// The following example returns information about suites, given a specific Device Farm
// job.
func ExampleDeviceFarm_ListSuites_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListSuitesInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:job:EXAMPLE-GUID-123-456"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	result, err := svc.ListSuites(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about tests
// The following example returns information about tests, given a specific Device Farm
// project.
func ExampleDeviceFarm_ListTests_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListTestsInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	result, err := svc.ListTests(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about unique problems
// The following example returns information about unique problems, given a specific
// Device Farm project.
func ExampleDeviceFarm_ListUniqueProblems_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListUniqueProblemsInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	result, err := svc.ListUniqueProblems(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about uploads
// The following example returns information about uploads, given a specific Device
// Farm project.
func ExampleDeviceFarm_ListUploads_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ListUploadsInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	result, err := svc.ListUploads(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To purchase a device slot offering
// The following example purchases a specific device slot offering.
func ExampleDeviceFarm_PurchaseOffering_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.PurchaseOfferingInput{
		OfferingId: aws.String("D68B3C05-1BA6-4360-BC69-12345EXAMPLE"),
		Quantity:   aws.Int64(1),
	}

	result, err := svc.PurchaseOffering(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeNotEligibleException:
				fmt.Println(devicefarm.ErrCodeNotEligibleException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To renew a device slot offering
// The following example renews a specific device slot offering.
func ExampleDeviceFarm_RenewOffering_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.RenewOfferingInput{
		OfferingId: aws.String("D68B3C05-1BA6-4360-BC69-12345EXAMPLE"),
		Quantity:   aws.Int64(1),
	}

	result, err := svc.RenewOffering(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeNotEligibleException:
				fmt.Println(devicefarm.ErrCodeNotEligibleException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To schedule a test run
// The following example schedules a test run named MyRun.
func ExampleDeviceFarm_ScheduleRun_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.ScheduleRunInput{
		DevicePoolArn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:pool:EXAMPLE-GUID-123-456"),
		Name:          aws.String("MyRun"),
		ProjectArn:    aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		Test: &devicefarm.ScheduleRunTest{
			TestPackageArn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:test:EXAMPLE-GUID-123-456"),
			Type:           aws.String("APPIUM_JAVA_JUNIT"),
		},
	}

	result, err := svc.ScheduleRun(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeIdempotencyException:
				fmt.Println(devicefarm.ErrCodeIdempotencyException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To stop a test run
// The following example stops a specific test run.
func ExampleDeviceFarm_StopRun_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.StopRunInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:run:EXAMPLE-GUID-123-456"),
	}

	result, err := svc.StopRun(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a device pool
// The following example updates the specified device pool with a new name and description.
// It also enables remote access of devices in the device pool.
func ExampleDeviceFarm_UpdateDevicePool_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.UpdateDevicePoolInput{
		Arn:         aws.String("arn:aws:devicefarm:us-west-2::devicepool:082d10e5-d7d7-48a5-ba5c-12345EXAMPLE"),
		Description: aws.String("NewDescription"),
		Name:        aws.String("NewName"),
		Rules: []*devicefarm.Rule{
			{
				Attribute: aws.String("REMOTE_ACCESS_ENABLED"),
				Operator:  aws.String("EQUALS"),
				Value:     aws.String("True"),
			},
		},
	}

	result, err := svc.UpdateDevicePool(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a device pool
// The following example updates the specified project with a new name.
func ExampleDeviceFarm_UpdateProject_shared00() {
	svc := devicefarm.New(session.New())
	input := &devicefarm.UpdateProjectInput{
		Arn:  aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:8f75187d-101e-4625-accc-12345EXAMPLE"),
		Name: aws.String("NewName"),
	}

	result, err := svc.UpdateProject(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
