//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// TagServer is a fake server for instances of the armapimanagement.TagClient type.
type TagServer struct {
	// AssignToAPI is the fake for method TagClient.AssignToAPI
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	AssignToAPI func(ctx context.Context, resourceGroupName string, serviceName string, apiID string, tagID string, options *armapimanagement.TagClientAssignToAPIOptions) (resp azfake.Responder[armapimanagement.TagClientAssignToAPIResponse], errResp azfake.ErrorResponder)

	// AssignToOperation is the fake for method TagClient.AssignToOperation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	AssignToOperation func(ctx context.Context, resourceGroupName string, serviceName string, apiID string, operationID string, tagID string, options *armapimanagement.TagClientAssignToOperationOptions) (resp azfake.Responder[armapimanagement.TagClientAssignToOperationResponse], errResp azfake.ErrorResponder)

	// AssignToProduct is the fake for method TagClient.AssignToProduct
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	AssignToProduct func(ctx context.Context, resourceGroupName string, serviceName string, productID string, tagID string, options *armapimanagement.TagClientAssignToProductOptions) (resp azfake.Responder[armapimanagement.TagClientAssignToProductResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdate is the fake for method TagClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, serviceName string, tagID string, parameters armapimanagement.TagCreateUpdateParameters, options *armapimanagement.TagClientCreateOrUpdateOptions) (resp azfake.Responder[armapimanagement.TagClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method TagClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, serviceName string, tagID string, ifMatch string, options *armapimanagement.TagClientDeleteOptions) (resp azfake.Responder[armapimanagement.TagClientDeleteResponse], errResp azfake.ErrorResponder)

	// DetachFromAPI is the fake for method TagClient.DetachFromAPI
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DetachFromAPI func(ctx context.Context, resourceGroupName string, serviceName string, apiID string, tagID string, options *armapimanagement.TagClientDetachFromAPIOptions) (resp azfake.Responder[armapimanagement.TagClientDetachFromAPIResponse], errResp azfake.ErrorResponder)

	// DetachFromOperation is the fake for method TagClient.DetachFromOperation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DetachFromOperation func(ctx context.Context, resourceGroupName string, serviceName string, apiID string, operationID string, tagID string, options *armapimanagement.TagClientDetachFromOperationOptions) (resp azfake.Responder[armapimanagement.TagClientDetachFromOperationResponse], errResp azfake.ErrorResponder)

	// DetachFromProduct is the fake for method TagClient.DetachFromProduct
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DetachFromProduct func(ctx context.Context, resourceGroupName string, serviceName string, productID string, tagID string, options *armapimanagement.TagClientDetachFromProductOptions) (resp azfake.Responder[armapimanagement.TagClientDetachFromProductResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method TagClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serviceName string, tagID string, options *armapimanagement.TagClientGetOptions) (resp azfake.Responder[armapimanagement.TagClientGetResponse], errResp azfake.ErrorResponder)

	// GetByAPI is the fake for method TagClient.GetByAPI
	// HTTP status codes to indicate success: http.StatusOK
	GetByAPI func(ctx context.Context, resourceGroupName string, serviceName string, apiID string, tagID string, options *armapimanagement.TagClientGetByAPIOptions) (resp azfake.Responder[armapimanagement.TagClientGetByAPIResponse], errResp azfake.ErrorResponder)

	// GetByOperation is the fake for method TagClient.GetByOperation
	// HTTP status codes to indicate success: http.StatusOK
	GetByOperation func(ctx context.Context, resourceGroupName string, serviceName string, apiID string, operationID string, tagID string, options *armapimanagement.TagClientGetByOperationOptions) (resp azfake.Responder[armapimanagement.TagClientGetByOperationResponse], errResp azfake.ErrorResponder)

	// GetByProduct is the fake for method TagClient.GetByProduct
	// HTTP status codes to indicate success: http.StatusOK
	GetByProduct func(ctx context.Context, resourceGroupName string, serviceName string, productID string, tagID string, options *armapimanagement.TagClientGetByProductOptions) (resp azfake.Responder[armapimanagement.TagClientGetByProductResponse], errResp azfake.ErrorResponder)

	// GetEntityState is the fake for method TagClient.GetEntityState
	// HTTP status codes to indicate success: http.StatusOK
	GetEntityState func(ctx context.Context, resourceGroupName string, serviceName string, tagID string, options *armapimanagement.TagClientGetEntityStateOptions) (resp azfake.Responder[armapimanagement.TagClientGetEntityStateResponse], errResp azfake.ErrorResponder)

	// GetEntityStateByAPI is the fake for method TagClient.GetEntityStateByAPI
	// HTTP status codes to indicate success: http.StatusOK
	GetEntityStateByAPI func(ctx context.Context, resourceGroupName string, serviceName string, apiID string, tagID string, options *armapimanagement.TagClientGetEntityStateByAPIOptions) (resp azfake.Responder[armapimanagement.TagClientGetEntityStateByAPIResponse], errResp azfake.ErrorResponder)

	// GetEntityStateByOperation is the fake for method TagClient.GetEntityStateByOperation
	// HTTP status codes to indicate success: http.StatusOK
	GetEntityStateByOperation func(ctx context.Context, resourceGroupName string, serviceName string, apiID string, operationID string, tagID string, options *armapimanagement.TagClientGetEntityStateByOperationOptions) (resp azfake.Responder[armapimanagement.TagClientGetEntityStateByOperationResponse], errResp azfake.ErrorResponder)

	// GetEntityStateByProduct is the fake for method TagClient.GetEntityStateByProduct
	// HTTP status codes to indicate success: http.StatusOK
	GetEntityStateByProduct func(ctx context.Context, resourceGroupName string, serviceName string, productID string, tagID string, options *armapimanagement.TagClientGetEntityStateByProductOptions) (resp azfake.Responder[armapimanagement.TagClientGetEntityStateByProductResponse], errResp azfake.ErrorResponder)

	// NewListByAPIPager is the fake for method TagClient.NewListByAPIPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByAPIPager func(resourceGroupName string, serviceName string, apiID string, options *armapimanagement.TagClientListByAPIOptions) (resp azfake.PagerResponder[armapimanagement.TagClientListByAPIResponse])

	// NewListByOperationPager is the fake for method TagClient.NewListByOperationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByOperationPager func(resourceGroupName string, serviceName string, apiID string, operationID string, options *armapimanagement.TagClientListByOperationOptions) (resp azfake.PagerResponder[armapimanagement.TagClientListByOperationResponse])

	// NewListByProductPager is the fake for method TagClient.NewListByProductPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByProductPager func(resourceGroupName string, serviceName string, productID string, options *armapimanagement.TagClientListByProductOptions) (resp azfake.PagerResponder[armapimanagement.TagClientListByProductResponse])

	// NewListByServicePager is the fake for method TagClient.NewListByServicePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByServicePager func(resourceGroupName string, serviceName string, options *armapimanagement.TagClientListByServiceOptions) (resp azfake.PagerResponder[armapimanagement.TagClientListByServiceResponse])

	// Update is the fake for method TagClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, serviceName string, tagID string, ifMatch string, parameters armapimanagement.TagCreateUpdateParameters, options *armapimanagement.TagClientUpdateOptions) (resp azfake.Responder[armapimanagement.TagClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewTagServerTransport creates a new instance of TagServerTransport with the provided implementation.
// The returned TagServerTransport instance is connected to an instance of armapimanagement.TagClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTagServerTransport(srv *TagServer) *TagServerTransport {
	return &TagServerTransport{
		srv:                     srv,
		newListByAPIPager:       newTracker[azfake.PagerResponder[armapimanagement.TagClientListByAPIResponse]](),
		newListByOperationPager: newTracker[azfake.PagerResponder[armapimanagement.TagClientListByOperationResponse]](),
		newListByProductPager:   newTracker[azfake.PagerResponder[armapimanagement.TagClientListByProductResponse]](),
		newListByServicePager:   newTracker[azfake.PagerResponder[armapimanagement.TagClientListByServiceResponse]](),
	}
}

// TagServerTransport connects instances of armapimanagement.TagClient to instances of TagServer.
// Don't use this type directly, use NewTagServerTransport instead.
type TagServerTransport struct {
	srv                     *TagServer
	newListByAPIPager       *tracker[azfake.PagerResponder[armapimanagement.TagClientListByAPIResponse]]
	newListByOperationPager *tracker[azfake.PagerResponder[armapimanagement.TagClientListByOperationResponse]]
	newListByProductPager   *tracker[azfake.PagerResponder[armapimanagement.TagClientListByProductResponse]]
	newListByServicePager   *tracker[azfake.PagerResponder[armapimanagement.TagClientListByServiceResponse]]
}

// Do implements the policy.Transporter interface for TagServerTransport.
func (t *TagServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TagClient.AssignToAPI":
		resp, err = t.dispatchAssignToAPI(req)
	case "TagClient.AssignToOperation":
		resp, err = t.dispatchAssignToOperation(req)
	case "TagClient.AssignToProduct":
		resp, err = t.dispatchAssignToProduct(req)
	case "TagClient.CreateOrUpdate":
		resp, err = t.dispatchCreateOrUpdate(req)
	case "TagClient.Delete":
		resp, err = t.dispatchDelete(req)
	case "TagClient.DetachFromAPI":
		resp, err = t.dispatchDetachFromAPI(req)
	case "TagClient.DetachFromOperation":
		resp, err = t.dispatchDetachFromOperation(req)
	case "TagClient.DetachFromProduct":
		resp, err = t.dispatchDetachFromProduct(req)
	case "TagClient.Get":
		resp, err = t.dispatchGet(req)
	case "TagClient.GetByAPI":
		resp, err = t.dispatchGetByAPI(req)
	case "TagClient.GetByOperation":
		resp, err = t.dispatchGetByOperation(req)
	case "TagClient.GetByProduct":
		resp, err = t.dispatchGetByProduct(req)
	case "TagClient.GetEntityState":
		resp, err = t.dispatchGetEntityState(req)
	case "TagClient.GetEntityStateByAPI":
		resp, err = t.dispatchGetEntityStateByAPI(req)
	case "TagClient.GetEntityStateByOperation":
		resp, err = t.dispatchGetEntityStateByOperation(req)
	case "TagClient.GetEntityStateByProduct":
		resp, err = t.dispatchGetEntityStateByProduct(req)
	case "TagClient.NewListByAPIPager":
		resp, err = t.dispatchNewListByAPIPager(req)
	case "TagClient.NewListByOperationPager":
		resp, err = t.dispatchNewListByOperationPager(req)
	case "TagClient.NewListByProductPager":
		resp, err = t.dispatchNewListByProductPager(req)
	case "TagClient.NewListByServicePager":
		resp, err = t.dispatchNewListByServicePager(req)
	case "TagClient.Update":
		resp, err = t.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TagServerTransport) dispatchAssignToAPI(req *http.Request) (*http.Response, error) {
	if t.srv.AssignToAPI == nil {
		return nil, &nonRetriableError{errors.New("fake for method AssignToAPI not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apis/(?P<apiId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	apiIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiId")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.AssignToAPI(req.Context(), resourceGroupNameParam, serviceNameParam, apiIDParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TagContract, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchAssignToOperation(req *http.Request) (*http.Response, error) {
	if t.srv.AssignToOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method AssignToOperation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apis/(?P<apiId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	apiIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiId")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.AssignToOperation(req.Context(), resourceGroupNameParam, serviceNameParam, apiIDParam, operationIDParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TagContract, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchAssignToProduct(req *http.Request) (*http.Response, error) {
	if t.srv.AssignToProduct == nil {
		return nil, &nonRetriableError{errors.New("fake for method AssignToProduct not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products/(?P<productId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	productIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("productId")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.AssignToProduct(req.Context(), resourceGroupNameParam, serviceNameParam, productIDParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TagContract, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if t.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armapimanagement.TagCreateUpdateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	var options *armapimanagement.TagClientCreateOrUpdateOptions
	if ifMatchParam != nil {
		options = &armapimanagement.TagClientCreateOrUpdateOptions{
			IfMatch: ifMatchParam,
		}
	}
	respr, errRespr := t.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, serviceNameParam, tagIDParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TagContract, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if t.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Delete(req.Context(), resourceGroupNameParam, serviceNameParam, tagIDParam, getHeaderValue(req.Header, "If-Match"), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchDetachFromAPI(req *http.Request) (*http.Response, error) {
	if t.srv.DetachFromAPI == nil {
		return nil, &nonRetriableError{errors.New("fake for method DetachFromAPI not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apis/(?P<apiId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	apiIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiId")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.DetachFromAPI(req.Context(), resourceGroupNameParam, serviceNameParam, apiIDParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchDetachFromOperation(req *http.Request) (*http.Response, error) {
	if t.srv.DetachFromOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method DetachFromOperation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apis/(?P<apiId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	apiIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiId")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.DetachFromOperation(req.Context(), resourceGroupNameParam, serviceNameParam, apiIDParam, operationIDParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchDetachFromProduct(req *http.Request) (*http.Response, error) {
	if t.srv.DetachFromProduct == nil {
		return nil, &nonRetriableError{errors.New("fake for method DetachFromProduct not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products/(?P<productId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	productIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("productId")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.DetachFromProduct(req.Context(), resourceGroupNameParam, serviceNameParam, productIDParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), resourceGroupNameParam, serviceNameParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TagContract, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchGetByAPI(req *http.Request) (*http.Response, error) {
	if t.srv.GetByAPI == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByAPI not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apis/(?P<apiId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	apiIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiId")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetByAPI(req.Context(), resourceGroupNameParam, serviceNameParam, apiIDParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TagContract, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchGetByOperation(req *http.Request) (*http.Response, error) {
	if t.srv.GetByOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByOperation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apis/(?P<apiId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	apiIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiId")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetByOperation(req.Context(), resourceGroupNameParam, serviceNameParam, apiIDParam, operationIDParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TagContract, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchGetByProduct(req *http.Request) (*http.Response, error) {
	if t.srv.GetByProduct == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByProduct not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products/(?P<productId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	productIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("productId")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetByProduct(req.Context(), resourceGroupNameParam, serviceNameParam, productIDParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TagContract, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchGetEntityState(req *http.Request) (*http.Response, error) {
	if t.srv.GetEntityState == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetEntityState not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetEntityState(req.Context(), resourceGroupNameParam, serviceNameParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchGetEntityStateByAPI(req *http.Request) (*http.Response, error) {
	if t.srv.GetEntityStateByAPI == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetEntityStateByAPI not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apis/(?P<apiId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	apiIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiId")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetEntityStateByAPI(req.Context(), resourceGroupNameParam, serviceNameParam, apiIDParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchGetEntityStateByOperation(req *http.Request) (*http.Response, error) {
	if t.srv.GetEntityStateByOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetEntityStateByOperation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apis/(?P<apiId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	apiIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiId")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetEntityStateByOperation(req.Context(), resourceGroupNameParam, serviceNameParam, apiIDParam, operationIDParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchGetEntityStateByProduct(req *http.Request) (*http.Response, error) {
	if t.srv.GetEntityStateByProduct == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetEntityStateByProduct not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products/(?P<productId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	productIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("productId")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetEntityStateByProduct(req.Context(), resourceGroupNameParam, serviceNameParam, productIDParam, tagIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchNewListByAPIPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByAPIPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByAPIPager not implemented")}
	}
	newListByAPIPager := t.newListByAPIPager.get(req)
	if newListByAPIPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apis/(?P<apiId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		apiIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armapimanagement.TagClientListByAPIOptions
		if filterParam != nil || topParam != nil || skipParam != nil {
			options = &armapimanagement.TagClientListByAPIOptions{
				Filter: filterParam,
				Top:    topParam,
				Skip:   skipParam,
			}
		}
		resp := t.srv.NewListByAPIPager(resourceGroupNameParam, serviceNameParam, apiIDParam, options)
		newListByAPIPager = &resp
		t.newListByAPIPager.add(req, newListByAPIPager)
		server.PagerResponderInjectNextLinks(newListByAPIPager, req, func(page *armapimanagement.TagClientListByAPIResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByAPIPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByAPIPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByAPIPager) {
		t.newListByAPIPager.remove(req)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchNewListByOperationPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByOperationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByOperationPager not implemented")}
	}
	newListByOperationPager := t.newListByOperationPager.get(req)
	if newListByOperationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apis/(?P<apiId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		apiIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiId")])
		if err != nil {
			return nil, err
		}
		operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armapimanagement.TagClientListByOperationOptions
		if filterParam != nil || topParam != nil || skipParam != nil {
			options = &armapimanagement.TagClientListByOperationOptions{
				Filter: filterParam,
				Top:    topParam,
				Skip:   skipParam,
			}
		}
		resp := t.srv.NewListByOperationPager(resourceGroupNameParam, serviceNameParam, apiIDParam, operationIDParam, options)
		newListByOperationPager = &resp
		t.newListByOperationPager.add(req, newListByOperationPager)
		server.PagerResponderInjectNextLinks(newListByOperationPager, req, func(page *armapimanagement.TagClientListByOperationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByOperationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByOperationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByOperationPager) {
		t.newListByOperationPager.remove(req)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchNewListByProductPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByProductPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByProductPager not implemented")}
	}
	newListByProductPager := t.newListByProductPager.get(req)
	if newListByProductPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products/(?P<productId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		productIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("productId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armapimanagement.TagClientListByProductOptions
		if filterParam != nil || topParam != nil || skipParam != nil {
			options = &armapimanagement.TagClientListByProductOptions{
				Filter: filterParam,
				Top:    topParam,
				Skip:   skipParam,
			}
		}
		resp := t.srv.NewListByProductPager(resourceGroupNameParam, serviceNameParam, productIDParam, options)
		newListByProductPager = &resp
		t.newListByProductPager.add(req, newListByProductPager)
		server.PagerResponderInjectNextLinks(newListByProductPager, req, func(page *armapimanagement.TagClientListByProductResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByProductPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByProductPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByProductPager) {
		t.newListByProductPager.remove(req)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchNewListByServicePager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByServicePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByServicePager not implemented")}
	}
	newListByServicePager := t.newListByServicePager.get(req)
	if newListByServicePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		scopeUnescaped, err := url.QueryUnescape(qp.Get("scope"))
		if err != nil {
			return nil, err
		}
		scopeParam := getOptional(scopeUnescaped)
		var options *armapimanagement.TagClientListByServiceOptions
		if filterParam != nil || topParam != nil || skipParam != nil || scopeParam != nil {
			options = &armapimanagement.TagClientListByServiceOptions{
				Filter: filterParam,
				Top:    topParam,
				Skip:   skipParam,
				Scope:  scopeParam,
			}
		}
		resp := t.srv.NewListByServicePager(resourceGroupNameParam, serviceNameParam, options)
		newListByServicePager = &resp
		t.newListByServicePager.add(req, newListByServicePager)
		server.PagerResponderInjectNextLinks(newListByServicePager, req, func(page *armapimanagement.TagClientListByServiceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByServicePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByServicePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByServicePager) {
		t.newListByServicePager.remove(req)
	}
	return resp, nil
}

func (t *TagServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if t.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tags/(?P<tagId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armapimanagement.TagCreateUpdateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	tagIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("tagId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Update(req.Context(), resourceGroupNameParam, serviceNameParam, tagIDParam, getHeaderValue(req.Header, "If-Match"), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TagContract, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}
