//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// EnvironmentsServer is a fake server for instances of the armappservice.EnvironmentsClient type.
type EnvironmentsServer struct {
	// BeginApproveOrRejectPrivateEndpointConnection is the fake for method EnvironmentsClient.BeginApproveOrRejectPrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginApproveOrRejectPrivateEndpointConnection func(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper armappservice.PrivateLinkConnectionApprovalRequestResource, options *armappservice.EnvironmentsClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (resp azfake.PollerResponder[armappservice.EnvironmentsClientApproveOrRejectPrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// BeginChangeVnet is the fake for method EnvironmentsClient.BeginChangeVnet
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginChangeVnet func(ctx context.Context, resourceGroupName string, name string, vnetInfo armappservice.VirtualNetworkProfile, options *armappservice.EnvironmentsClientBeginChangeVnetOptions) (resp azfake.PollerResponder[azfake.PagerResponder[armappservice.EnvironmentsClientChangeVnetResponse]], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method EnvironmentsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope armappservice.EnvironmentResource, options *armappservice.EnvironmentsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armappservice.EnvironmentsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateMultiRolePool is the fake for method EnvironmentsClient.BeginCreateOrUpdateMultiRolePool
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdateMultiRolePool func(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope armappservice.WorkerPoolResource, options *armappservice.EnvironmentsClientBeginCreateOrUpdateMultiRolePoolOptions) (resp azfake.PollerResponder[armappservice.EnvironmentsClientCreateOrUpdateMultiRolePoolResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateWorkerPool is the fake for method EnvironmentsClient.BeginCreateOrUpdateWorkerPool
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdateWorkerPool func(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope armappservice.WorkerPoolResource, options *armappservice.EnvironmentsClientBeginCreateOrUpdateWorkerPoolOptions) (resp azfake.PollerResponder[armappservice.EnvironmentsClientCreateOrUpdateWorkerPoolResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method EnvironmentsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientBeginDeleteOptions) (resp azfake.PollerResponder[armappservice.EnvironmentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteAseCustomDNSSuffixConfiguration is the fake for method EnvironmentsClient.DeleteAseCustomDNSSuffixConfiguration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteAseCustomDNSSuffixConfiguration func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationOptions) (resp azfake.Responder[armappservice.EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse], errResp azfake.ErrorResponder)

	// BeginDeletePrivateEndpointConnection is the fake for method EnvironmentsClient.BeginDeletePrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeletePrivateEndpointConnection func(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *armappservice.EnvironmentsClientBeginDeletePrivateEndpointConnectionOptions) (resp azfake.PollerResponder[armappservice.EnvironmentsClientDeletePrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method EnvironmentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientGetOptions) (resp azfake.Responder[armappservice.EnvironmentsClientGetResponse], errResp azfake.ErrorResponder)

	// GetAseCustomDNSSuffixConfiguration is the fake for method EnvironmentsClient.GetAseCustomDNSSuffixConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	GetAseCustomDNSSuffixConfiguration func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientGetAseCustomDNSSuffixConfigurationOptions) (resp azfake.Responder[armappservice.EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse], errResp azfake.ErrorResponder)

	// GetAseV3NetworkingConfiguration is the fake for method EnvironmentsClient.GetAseV3NetworkingConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	GetAseV3NetworkingConfiguration func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientGetAseV3NetworkingConfigurationOptions) (resp azfake.Responder[armappservice.EnvironmentsClientGetAseV3NetworkingConfigurationResponse], errResp azfake.ErrorResponder)

	// GetDiagnosticsItem is the fake for method EnvironmentsClient.GetDiagnosticsItem
	// HTTP status codes to indicate success: http.StatusOK
	GetDiagnosticsItem func(ctx context.Context, resourceGroupName string, name string, diagnosticsName string, options *armappservice.EnvironmentsClientGetDiagnosticsItemOptions) (resp azfake.Responder[armappservice.EnvironmentsClientGetDiagnosticsItemResponse], errResp azfake.ErrorResponder)

	// NewGetInboundNetworkDependenciesEndpointsPager is the fake for method EnvironmentsClient.NewGetInboundNetworkDependenciesEndpointsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetInboundNetworkDependenciesEndpointsPager func(resourceGroupName string, name string, options *armappservice.EnvironmentsClientGetInboundNetworkDependenciesEndpointsOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse])

	// GetMultiRolePool is the fake for method EnvironmentsClient.GetMultiRolePool
	// HTTP status codes to indicate success: http.StatusOK
	GetMultiRolePool func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientGetMultiRolePoolOptions) (resp azfake.Responder[armappservice.EnvironmentsClientGetMultiRolePoolResponse], errResp azfake.ErrorResponder)

	// NewGetOutboundNetworkDependenciesEndpointsPager is the fake for method EnvironmentsClient.NewGetOutboundNetworkDependenciesEndpointsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetOutboundNetworkDependenciesEndpointsPager func(resourceGroupName string, name string, options *armappservice.EnvironmentsClientGetOutboundNetworkDependenciesEndpointsOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse])

	// GetPrivateEndpointConnection is the fake for method EnvironmentsClient.GetPrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateEndpointConnection func(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *armappservice.EnvironmentsClientGetPrivateEndpointConnectionOptions) (resp azfake.Responder[armappservice.EnvironmentsClientGetPrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// NewGetPrivateEndpointConnectionListPager is the fake for method EnvironmentsClient.NewGetPrivateEndpointConnectionListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetPrivateEndpointConnectionListPager func(resourceGroupName string, name string, options *armappservice.EnvironmentsClientGetPrivateEndpointConnectionListOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientGetPrivateEndpointConnectionListResponse])

	// GetPrivateLinkResources is the fake for method EnvironmentsClient.GetPrivateLinkResources
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateLinkResources func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientGetPrivateLinkResourcesOptions) (resp azfake.Responder[armappservice.EnvironmentsClientGetPrivateLinkResourcesResponse], errResp azfake.ErrorResponder)

	// GetVipInfo is the fake for method EnvironmentsClient.GetVipInfo
	// HTTP status codes to indicate success: http.StatusOK
	GetVipInfo func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientGetVipInfoOptions) (resp azfake.Responder[armappservice.EnvironmentsClientGetVipInfoResponse], errResp azfake.ErrorResponder)

	// GetWorkerPool is the fake for method EnvironmentsClient.GetWorkerPool
	// HTTP status codes to indicate success: http.StatusOK
	GetWorkerPool func(ctx context.Context, resourceGroupName string, name string, workerPoolName string, options *armappservice.EnvironmentsClientGetWorkerPoolOptions) (resp azfake.Responder[armappservice.EnvironmentsClientGetWorkerPoolResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method EnvironmentsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armappservice.EnvironmentsClientListOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListResponse])

	// NewListAppServicePlansPager is the fake for method EnvironmentsClient.NewListAppServicePlansPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAppServicePlansPager func(resourceGroupName string, name string, options *armappservice.EnvironmentsClientListAppServicePlansOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListAppServicePlansResponse])

	// NewListByResourceGroupPager is the fake for method EnvironmentsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armappservice.EnvironmentsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListByResourceGroupResponse])

	// NewListCapacitiesPager is the fake for method EnvironmentsClient.NewListCapacitiesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListCapacitiesPager func(resourceGroupName string, name string, options *armappservice.EnvironmentsClientListCapacitiesOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListCapacitiesResponse])

	// ListDiagnostics is the fake for method EnvironmentsClient.ListDiagnostics
	// HTTP status codes to indicate success: http.StatusOK
	ListDiagnostics func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientListDiagnosticsOptions) (resp azfake.Responder[armappservice.EnvironmentsClientListDiagnosticsResponse], errResp azfake.ErrorResponder)

	// NewListMultiRoleMetricDefinitionsPager is the fake for method EnvironmentsClient.NewListMultiRoleMetricDefinitionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMultiRoleMetricDefinitionsPager func(resourceGroupName string, name string, options *armappservice.EnvironmentsClientListMultiRoleMetricDefinitionsOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRoleMetricDefinitionsResponse])

	// NewListMultiRolePoolInstanceMetricDefinitionsPager is the fake for method EnvironmentsClient.NewListMultiRolePoolInstanceMetricDefinitionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMultiRolePoolInstanceMetricDefinitionsPager func(resourceGroupName string, name string, instance string, options *armappservice.EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse])

	// NewListMultiRolePoolSKUsPager is the fake for method EnvironmentsClient.NewListMultiRolePoolSKUsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMultiRolePoolSKUsPager func(resourceGroupName string, name string, options *armappservice.EnvironmentsClientListMultiRolePoolSKUsOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRolePoolSKUsResponse])

	// NewListMultiRolePoolsPager is the fake for method EnvironmentsClient.NewListMultiRolePoolsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMultiRolePoolsPager func(resourceGroupName string, name string, options *armappservice.EnvironmentsClientListMultiRolePoolsOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRolePoolsResponse])

	// NewListMultiRoleUsagesPager is the fake for method EnvironmentsClient.NewListMultiRoleUsagesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMultiRoleUsagesPager func(resourceGroupName string, name string, options *armappservice.EnvironmentsClientListMultiRoleUsagesOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRoleUsagesResponse])

	// ListOperations is the fake for method EnvironmentsClient.ListOperations
	// HTTP status codes to indicate success: http.StatusOK
	ListOperations func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientListOperationsOptions) (resp azfake.Responder[armappservice.EnvironmentsClientListOperationsResponse], errResp azfake.ErrorResponder)

	// NewListUsagesPager is the fake for method EnvironmentsClient.NewListUsagesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListUsagesPager func(resourceGroupName string, name string, options *armappservice.EnvironmentsClientListUsagesOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListUsagesResponse])

	// NewListWebAppsPager is the fake for method EnvironmentsClient.NewListWebAppsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListWebAppsPager func(resourceGroupName string, name string, options *armappservice.EnvironmentsClientListWebAppsOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListWebAppsResponse])

	// NewListWebWorkerMetricDefinitionsPager is the fake for method EnvironmentsClient.NewListWebWorkerMetricDefinitionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListWebWorkerMetricDefinitionsPager func(resourceGroupName string, name string, workerPoolName string, options *armappservice.EnvironmentsClientListWebWorkerMetricDefinitionsOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListWebWorkerMetricDefinitionsResponse])

	// NewListWebWorkerUsagesPager is the fake for method EnvironmentsClient.NewListWebWorkerUsagesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListWebWorkerUsagesPager func(resourceGroupName string, name string, workerPoolName string, options *armappservice.EnvironmentsClientListWebWorkerUsagesOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListWebWorkerUsagesResponse])

	// NewListWorkerPoolInstanceMetricDefinitionsPager is the fake for method EnvironmentsClient.NewListWorkerPoolInstanceMetricDefinitionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListWorkerPoolInstanceMetricDefinitionsPager func(resourceGroupName string, name string, workerPoolName string, instance string, options *armappservice.EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse])

	// NewListWorkerPoolSKUsPager is the fake for method EnvironmentsClient.NewListWorkerPoolSKUsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListWorkerPoolSKUsPager func(resourceGroupName string, name string, workerPoolName string, options *armappservice.EnvironmentsClientListWorkerPoolSKUsOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListWorkerPoolSKUsResponse])

	// NewListWorkerPoolsPager is the fake for method EnvironmentsClient.NewListWorkerPoolsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListWorkerPoolsPager func(resourceGroupName string, name string, options *armappservice.EnvironmentsClientListWorkerPoolsOptions) (resp azfake.PagerResponder[armappservice.EnvironmentsClientListWorkerPoolsResponse])

	// Reboot is the fake for method EnvironmentsClient.Reboot
	// HTTP status codes to indicate success: http.StatusAccepted
	Reboot func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientRebootOptions) (resp azfake.Responder[armappservice.EnvironmentsClientRebootResponse], errResp azfake.ErrorResponder)

	// BeginResume is the fake for method EnvironmentsClient.BeginResume
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResume func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientBeginResumeOptions) (resp azfake.PollerResponder[azfake.PagerResponder[armappservice.EnvironmentsClientResumeResponse]], errResp azfake.ErrorResponder)

	// BeginSuspend is the fake for method EnvironmentsClient.BeginSuspend
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSuspend func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientBeginSuspendOptions) (resp azfake.PollerResponder[azfake.PagerResponder[armappservice.EnvironmentsClientSuspendResponse]], errResp azfake.ErrorResponder)

	// TestUpgradeAvailableNotification is the fake for method EnvironmentsClient.TestUpgradeAvailableNotification
	// HTTP status codes to indicate success: http.StatusOK
	TestUpgradeAvailableNotification func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientTestUpgradeAvailableNotificationOptions) (resp azfake.Responder[armappservice.EnvironmentsClientTestUpgradeAvailableNotificationResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method EnvironmentsClient.Update
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	Update func(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope armappservice.EnvironmentPatchResource, options *armappservice.EnvironmentsClientUpdateOptions) (resp azfake.Responder[armappservice.EnvironmentsClientUpdateResponse], errResp azfake.ErrorResponder)

	// UpdateAseCustomDNSSuffixConfiguration is the fake for method EnvironmentsClient.UpdateAseCustomDNSSuffixConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	UpdateAseCustomDNSSuffixConfiguration func(ctx context.Context, resourceGroupName string, name string, customDNSSuffixConfiguration armappservice.CustomDNSSuffixConfiguration, options *armappservice.EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationOptions) (resp azfake.Responder[armappservice.EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse], errResp azfake.ErrorResponder)

	// UpdateAseNetworkingConfiguration is the fake for method EnvironmentsClient.UpdateAseNetworkingConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	UpdateAseNetworkingConfiguration func(ctx context.Context, resourceGroupName string, name string, aseNetworkingConfiguration armappservice.AseV3NetworkingConfiguration, options *armappservice.EnvironmentsClientUpdateAseNetworkingConfigurationOptions) (resp azfake.Responder[armappservice.EnvironmentsClientUpdateAseNetworkingConfigurationResponse], errResp azfake.ErrorResponder)

	// UpdateMultiRolePool is the fake for method EnvironmentsClient.UpdateMultiRolePool
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	UpdateMultiRolePool func(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope armappservice.WorkerPoolResource, options *armappservice.EnvironmentsClientUpdateMultiRolePoolOptions) (resp azfake.Responder[armappservice.EnvironmentsClientUpdateMultiRolePoolResponse], errResp azfake.ErrorResponder)

	// UpdateWorkerPool is the fake for method EnvironmentsClient.UpdateWorkerPool
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	UpdateWorkerPool func(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope armappservice.WorkerPoolResource, options *armappservice.EnvironmentsClientUpdateWorkerPoolOptions) (resp azfake.Responder[armappservice.EnvironmentsClientUpdateWorkerPoolResponse], errResp azfake.ErrorResponder)

	// BeginUpgrade is the fake for method EnvironmentsClient.BeginUpgrade
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginUpgrade func(ctx context.Context, resourceGroupName string, name string, options *armappservice.EnvironmentsClientBeginUpgradeOptions) (resp azfake.PollerResponder[armappservice.EnvironmentsClientUpgradeResponse], errResp azfake.ErrorResponder)
}

// NewEnvironmentsServerTransport creates a new instance of EnvironmentsServerTransport with the provided implementation.
// The returned EnvironmentsServerTransport instance is connected to an instance of armappservice.EnvironmentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEnvironmentsServerTransport(srv *EnvironmentsServer) *EnvironmentsServerTransport {
	return &EnvironmentsServerTransport{
		srv: srv,
		beginApproveOrRejectPrivateEndpointConnection: newTracker[azfake.PollerResponder[armappservice.EnvironmentsClientApproveOrRejectPrivateEndpointConnectionResponse]](),
		beginChangeVnet:                                    newTracker[azfake.PollerResponder[azfake.PagerResponder[armappservice.EnvironmentsClientChangeVnetResponse]]](),
		beginCreateOrUpdate:                                newTracker[azfake.PollerResponder[armappservice.EnvironmentsClientCreateOrUpdateResponse]](),
		beginCreateOrUpdateMultiRolePool:                   newTracker[azfake.PollerResponder[armappservice.EnvironmentsClientCreateOrUpdateMultiRolePoolResponse]](),
		beginCreateOrUpdateWorkerPool:                      newTracker[azfake.PollerResponder[armappservice.EnvironmentsClientCreateOrUpdateWorkerPoolResponse]](),
		beginDelete:                                        newTracker[azfake.PollerResponder[armappservice.EnvironmentsClientDeleteResponse]](),
		beginDeletePrivateEndpointConnection:               newTracker[azfake.PollerResponder[armappservice.EnvironmentsClientDeletePrivateEndpointConnectionResponse]](),
		newGetInboundNetworkDependenciesEndpointsPager:     newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse]](),
		newGetOutboundNetworkDependenciesEndpointsPager:    newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse]](),
		newGetPrivateEndpointConnectionListPager:           newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientGetPrivateEndpointConnectionListResponse]](),
		newListPager:                                       newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListResponse]](),
		newListAppServicePlansPager:                        newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListAppServicePlansResponse]](),
		newListByResourceGroupPager:                        newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListByResourceGroupResponse]](),
		newListCapacitiesPager:                             newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListCapacitiesResponse]](),
		newListMultiRoleMetricDefinitionsPager:             newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRoleMetricDefinitionsResponse]](),
		newListMultiRolePoolInstanceMetricDefinitionsPager: newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse]](),
		newListMultiRolePoolSKUsPager:                      newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRolePoolSKUsResponse]](),
		newListMultiRolePoolsPager:                         newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRolePoolsResponse]](),
		newListMultiRoleUsagesPager:                        newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRoleUsagesResponse]](),
		newListUsagesPager:                                 newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListUsagesResponse]](),
		newListWebAppsPager:                                newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListWebAppsResponse]](),
		newListWebWorkerMetricDefinitionsPager:             newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListWebWorkerMetricDefinitionsResponse]](),
		newListWebWorkerUsagesPager:                        newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListWebWorkerUsagesResponse]](),
		newListWorkerPoolInstanceMetricDefinitionsPager:    newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse]](),
		newListWorkerPoolSKUsPager:                         newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListWorkerPoolSKUsResponse]](),
		newListWorkerPoolsPager:                            newTracker[azfake.PagerResponder[armappservice.EnvironmentsClientListWorkerPoolsResponse]](),
		beginResume:                                        newTracker[azfake.PollerResponder[azfake.PagerResponder[armappservice.EnvironmentsClientResumeResponse]]](),
		beginSuspend:                                       newTracker[azfake.PollerResponder[azfake.PagerResponder[armappservice.EnvironmentsClientSuspendResponse]]](),
		beginUpgrade:                                       newTracker[azfake.PollerResponder[armappservice.EnvironmentsClientUpgradeResponse]](),
	}
}

// EnvironmentsServerTransport connects instances of armappservice.EnvironmentsClient to instances of EnvironmentsServer.
// Don't use this type directly, use NewEnvironmentsServerTransport instead.
type EnvironmentsServerTransport struct {
	srv                                                *EnvironmentsServer
	beginApproveOrRejectPrivateEndpointConnection      *tracker[azfake.PollerResponder[armappservice.EnvironmentsClientApproveOrRejectPrivateEndpointConnectionResponse]]
	beginChangeVnet                                    *tracker[azfake.PollerResponder[azfake.PagerResponder[armappservice.EnvironmentsClientChangeVnetResponse]]]
	beginCreateOrUpdate                                *tracker[azfake.PollerResponder[armappservice.EnvironmentsClientCreateOrUpdateResponse]]
	beginCreateOrUpdateMultiRolePool                   *tracker[azfake.PollerResponder[armappservice.EnvironmentsClientCreateOrUpdateMultiRolePoolResponse]]
	beginCreateOrUpdateWorkerPool                      *tracker[azfake.PollerResponder[armappservice.EnvironmentsClientCreateOrUpdateWorkerPoolResponse]]
	beginDelete                                        *tracker[azfake.PollerResponder[armappservice.EnvironmentsClientDeleteResponse]]
	beginDeletePrivateEndpointConnection               *tracker[azfake.PollerResponder[armappservice.EnvironmentsClientDeletePrivateEndpointConnectionResponse]]
	newGetInboundNetworkDependenciesEndpointsPager     *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse]]
	newGetOutboundNetworkDependenciesEndpointsPager    *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse]]
	newGetPrivateEndpointConnectionListPager           *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientGetPrivateEndpointConnectionListResponse]]
	newListPager                                       *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListResponse]]
	newListAppServicePlansPager                        *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListAppServicePlansResponse]]
	newListByResourceGroupPager                        *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListByResourceGroupResponse]]
	newListCapacitiesPager                             *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListCapacitiesResponse]]
	newListMultiRoleMetricDefinitionsPager             *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRoleMetricDefinitionsResponse]]
	newListMultiRolePoolInstanceMetricDefinitionsPager *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse]]
	newListMultiRolePoolSKUsPager                      *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRolePoolSKUsResponse]]
	newListMultiRolePoolsPager                         *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRolePoolsResponse]]
	newListMultiRoleUsagesPager                        *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListMultiRoleUsagesResponse]]
	newListUsagesPager                                 *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListUsagesResponse]]
	newListWebAppsPager                                *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListWebAppsResponse]]
	newListWebWorkerMetricDefinitionsPager             *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListWebWorkerMetricDefinitionsResponse]]
	newListWebWorkerUsagesPager                        *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListWebWorkerUsagesResponse]]
	newListWorkerPoolInstanceMetricDefinitionsPager    *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse]]
	newListWorkerPoolSKUsPager                         *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListWorkerPoolSKUsResponse]]
	newListWorkerPoolsPager                            *tracker[azfake.PagerResponder[armappservice.EnvironmentsClientListWorkerPoolsResponse]]
	beginResume                                        *tracker[azfake.PollerResponder[azfake.PagerResponder[armappservice.EnvironmentsClientResumeResponse]]]
	beginSuspend                                       *tracker[azfake.PollerResponder[azfake.PagerResponder[armappservice.EnvironmentsClientSuspendResponse]]]
	beginUpgrade                                       *tracker[azfake.PollerResponder[armappservice.EnvironmentsClientUpgradeResponse]]
}

// Do implements the policy.Transporter interface for EnvironmentsServerTransport.
func (e *EnvironmentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EnvironmentsClient.BeginApproveOrRejectPrivateEndpointConnection":
		resp, err = e.dispatchBeginApproveOrRejectPrivateEndpointConnection(req)
	case "EnvironmentsClient.BeginChangeVnet":
		resp, err = e.dispatchBeginChangeVnet(req)
	case "EnvironmentsClient.BeginCreateOrUpdate":
		resp, err = e.dispatchBeginCreateOrUpdate(req)
	case "EnvironmentsClient.BeginCreateOrUpdateMultiRolePool":
		resp, err = e.dispatchBeginCreateOrUpdateMultiRolePool(req)
	case "EnvironmentsClient.BeginCreateOrUpdateWorkerPool":
		resp, err = e.dispatchBeginCreateOrUpdateWorkerPool(req)
	case "EnvironmentsClient.BeginDelete":
		resp, err = e.dispatchBeginDelete(req)
	case "EnvironmentsClient.DeleteAseCustomDNSSuffixConfiguration":
		resp, err = e.dispatchDeleteAseCustomDNSSuffixConfiguration(req)
	case "EnvironmentsClient.BeginDeletePrivateEndpointConnection":
		resp, err = e.dispatchBeginDeletePrivateEndpointConnection(req)
	case "EnvironmentsClient.Get":
		resp, err = e.dispatchGet(req)
	case "EnvironmentsClient.GetAseCustomDNSSuffixConfiguration":
		resp, err = e.dispatchGetAseCustomDNSSuffixConfiguration(req)
	case "EnvironmentsClient.GetAseV3NetworkingConfiguration":
		resp, err = e.dispatchGetAseV3NetworkingConfiguration(req)
	case "EnvironmentsClient.GetDiagnosticsItem":
		resp, err = e.dispatchGetDiagnosticsItem(req)
	case "EnvironmentsClient.NewGetInboundNetworkDependenciesEndpointsPager":
		resp, err = e.dispatchNewGetInboundNetworkDependenciesEndpointsPager(req)
	case "EnvironmentsClient.GetMultiRolePool":
		resp, err = e.dispatchGetMultiRolePool(req)
	case "EnvironmentsClient.NewGetOutboundNetworkDependenciesEndpointsPager":
		resp, err = e.dispatchNewGetOutboundNetworkDependenciesEndpointsPager(req)
	case "EnvironmentsClient.GetPrivateEndpointConnection":
		resp, err = e.dispatchGetPrivateEndpointConnection(req)
	case "EnvironmentsClient.NewGetPrivateEndpointConnectionListPager":
		resp, err = e.dispatchNewGetPrivateEndpointConnectionListPager(req)
	case "EnvironmentsClient.GetPrivateLinkResources":
		resp, err = e.dispatchGetPrivateLinkResources(req)
	case "EnvironmentsClient.GetVipInfo":
		resp, err = e.dispatchGetVipInfo(req)
	case "EnvironmentsClient.GetWorkerPool":
		resp, err = e.dispatchGetWorkerPool(req)
	case "EnvironmentsClient.NewListPager":
		resp, err = e.dispatchNewListPager(req)
	case "EnvironmentsClient.NewListAppServicePlansPager":
		resp, err = e.dispatchNewListAppServicePlansPager(req)
	case "EnvironmentsClient.NewListByResourceGroupPager":
		resp, err = e.dispatchNewListByResourceGroupPager(req)
	case "EnvironmentsClient.NewListCapacitiesPager":
		resp, err = e.dispatchNewListCapacitiesPager(req)
	case "EnvironmentsClient.ListDiagnostics":
		resp, err = e.dispatchListDiagnostics(req)
	case "EnvironmentsClient.NewListMultiRoleMetricDefinitionsPager":
		resp, err = e.dispatchNewListMultiRoleMetricDefinitionsPager(req)
	case "EnvironmentsClient.NewListMultiRolePoolInstanceMetricDefinitionsPager":
		resp, err = e.dispatchNewListMultiRolePoolInstanceMetricDefinitionsPager(req)
	case "EnvironmentsClient.NewListMultiRolePoolSKUsPager":
		resp, err = e.dispatchNewListMultiRolePoolSKUsPager(req)
	case "EnvironmentsClient.NewListMultiRolePoolsPager":
		resp, err = e.dispatchNewListMultiRolePoolsPager(req)
	case "EnvironmentsClient.NewListMultiRoleUsagesPager":
		resp, err = e.dispatchNewListMultiRoleUsagesPager(req)
	case "EnvironmentsClient.ListOperations":
		resp, err = e.dispatchListOperations(req)
	case "EnvironmentsClient.NewListUsagesPager":
		resp, err = e.dispatchNewListUsagesPager(req)
	case "EnvironmentsClient.NewListWebAppsPager":
		resp, err = e.dispatchNewListWebAppsPager(req)
	case "EnvironmentsClient.NewListWebWorkerMetricDefinitionsPager":
		resp, err = e.dispatchNewListWebWorkerMetricDefinitionsPager(req)
	case "EnvironmentsClient.NewListWebWorkerUsagesPager":
		resp, err = e.dispatchNewListWebWorkerUsagesPager(req)
	case "EnvironmentsClient.NewListWorkerPoolInstanceMetricDefinitionsPager":
		resp, err = e.dispatchNewListWorkerPoolInstanceMetricDefinitionsPager(req)
	case "EnvironmentsClient.NewListWorkerPoolSKUsPager":
		resp, err = e.dispatchNewListWorkerPoolSKUsPager(req)
	case "EnvironmentsClient.NewListWorkerPoolsPager":
		resp, err = e.dispatchNewListWorkerPoolsPager(req)
	case "EnvironmentsClient.Reboot":
		resp, err = e.dispatchReboot(req)
	case "EnvironmentsClient.BeginResume":
		resp, err = e.dispatchBeginResume(req)
	case "EnvironmentsClient.BeginSuspend":
		resp, err = e.dispatchBeginSuspend(req)
	case "EnvironmentsClient.TestUpgradeAvailableNotification":
		resp, err = e.dispatchTestUpgradeAvailableNotification(req)
	case "EnvironmentsClient.Update":
		resp, err = e.dispatchUpdate(req)
	case "EnvironmentsClient.UpdateAseCustomDNSSuffixConfiguration":
		resp, err = e.dispatchUpdateAseCustomDNSSuffixConfiguration(req)
	case "EnvironmentsClient.UpdateAseNetworkingConfiguration":
		resp, err = e.dispatchUpdateAseNetworkingConfiguration(req)
	case "EnvironmentsClient.UpdateMultiRolePool":
		resp, err = e.dispatchUpdateMultiRolePool(req)
	case "EnvironmentsClient.UpdateWorkerPool":
		resp, err = e.dispatchUpdateWorkerPool(req)
	case "EnvironmentsClient.BeginUpgrade":
		resp, err = e.dispatchBeginUpgrade(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchBeginApproveOrRejectPrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if e.srv.BeginApproveOrRejectPrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginApproveOrRejectPrivateEndpointConnection not implemented")}
	}
	beginApproveOrRejectPrivateEndpointConnection := e.beginApproveOrRejectPrivateEndpointConnection.get(req)
	if beginApproveOrRejectPrivateEndpointConnection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.PrivateLinkConnectionApprovalRequestResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginApproveOrRejectPrivateEndpointConnection(req.Context(), resourceGroupNameParam, nameParam, privateEndpointConnectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginApproveOrRejectPrivateEndpointConnection = &respr
		e.beginApproveOrRejectPrivateEndpointConnection.add(req, beginApproveOrRejectPrivateEndpointConnection)
	}

	resp, err := server.PollerResponderNext(beginApproveOrRejectPrivateEndpointConnection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginApproveOrRejectPrivateEndpointConnection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginApproveOrRejectPrivateEndpointConnection) {
		e.beginApproveOrRejectPrivateEndpointConnection.remove(req)
	}

	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchBeginChangeVnet(req *http.Request) (*http.Response, error) {
	if e.srv.BeginChangeVnet == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginChangeVnet not implemented")}
	}
	beginChangeVnet := e.beginChangeVnet.get(req)
	if beginChangeVnet == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/changeVirtualNetwork`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.VirtualNetworkProfile](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginChangeVnet(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginChangeVnet = &respr
		e.beginChangeVnet.add(req, beginChangeVnet)
	}

	resp, err := server.PollerResponderNext(beginChangeVnet, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginChangeVnet.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginChangeVnet) {
		e.beginChangeVnet.remove(req)
	}

	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := e.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.EnvironmentResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		e.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		e.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		e.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchBeginCreateOrUpdateMultiRolePool(req *http.Request) (*http.Response, error) {
	if e.srv.BeginCreateOrUpdateMultiRolePool == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateMultiRolePool not implemented")}
	}
	beginCreateOrUpdateMultiRolePool := e.beginCreateOrUpdateMultiRolePool.get(req)
	if beginCreateOrUpdateMultiRolePool == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/multiRolePools/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.WorkerPoolResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginCreateOrUpdateMultiRolePool(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateMultiRolePool = &respr
		e.beginCreateOrUpdateMultiRolePool.add(req, beginCreateOrUpdateMultiRolePool)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateMultiRolePool, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginCreateOrUpdateMultiRolePool.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateMultiRolePool) {
		e.beginCreateOrUpdateMultiRolePool.remove(req)
	}

	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchBeginCreateOrUpdateWorkerPool(req *http.Request) (*http.Response, error) {
	if e.srv.BeginCreateOrUpdateWorkerPool == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateWorkerPool not implemented")}
	}
	beginCreateOrUpdateWorkerPool := e.beginCreateOrUpdateWorkerPool.get(req)
	if beginCreateOrUpdateWorkerPool == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workerPools/(?P<workerPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.WorkerPoolResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		workerPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workerPoolName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginCreateOrUpdateWorkerPool(req.Context(), resourceGroupNameParam, nameParam, workerPoolNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateWorkerPool = &respr
		e.beginCreateOrUpdateWorkerPool.add(req, beginCreateOrUpdateWorkerPool)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateWorkerPool, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginCreateOrUpdateWorkerPool.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateWorkerPool) {
		e.beginCreateOrUpdateWorkerPool.remove(req)
	}

	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if e.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := e.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		forceDeleteUnescaped, err := url.QueryUnescape(qp.Get("forceDelete"))
		if err != nil {
			return nil, err
		}
		forceDeleteParam, err := parseOptional(forceDeleteUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armappservice.EnvironmentsClientBeginDeleteOptions
		if forceDeleteParam != nil {
			options = &armappservice.EnvironmentsClientBeginDeleteOptions{
				ForceDelete: forceDeleteParam,
			}
		}
		respr, errRespr := e.srv.BeginDelete(req.Context(), resourceGroupNameParam, nameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		e.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		e.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		e.beginDelete.remove(req)
	}

	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchDeleteAseCustomDNSSuffixConfiguration(req *http.Request) (*http.Response, error) {
	if e.srv.DeleteAseCustomDNSSuffixConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteAseCustomDNSSuffixConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/configurations/customdnssuffix`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.DeleteAseCustomDNSSuffixConfiguration(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Interface, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchBeginDeletePrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if e.srv.BeginDeletePrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeletePrivateEndpointConnection not implemented")}
	}
	beginDeletePrivateEndpointConnection := e.beginDeletePrivateEndpointConnection.get(req)
	if beginDeletePrivateEndpointConnection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginDeletePrivateEndpointConnection(req.Context(), resourceGroupNameParam, nameParam, privateEndpointConnectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeletePrivateEndpointConnection = &respr
		e.beginDeletePrivateEndpointConnection.add(req, beginDeletePrivateEndpointConnection)
	}

	resp, err := server.PollerResponderNext(beginDeletePrivateEndpointConnection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		e.beginDeletePrivateEndpointConnection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeletePrivateEndpointConnection) {
		e.beginDeletePrivateEndpointConnection.remove(req)
	}

	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EnvironmentResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchGetAseCustomDNSSuffixConfiguration(req *http.Request) (*http.Response, error) {
	if e.srv.GetAseCustomDNSSuffixConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAseCustomDNSSuffixConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/configurations/customdnssuffix`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetAseCustomDNSSuffixConfiguration(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomDNSSuffixConfiguration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchGetAseV3NetworkingConfiguration(req *http.Request) (*http.Response, error) {
	if e.srv.GetAseV3NetworkingConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAseV3NetworkingConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/configurations/networking`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetAseV3NetworkingConfiguration(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AseV3NetworkingConfiguration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchGetDiagnosticsItem(req *http.Request) (*http.Response, error) {
	if e.srv.GetDiagnosticsItem == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDiagnosticsItem not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics/(?P<diagnosticsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	diagnosticsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticsName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetDiagnosticsItem(req.Context(), resourceGroupNameParam, nameParam, diagnosticsNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HostingEnvironmentDiagnostics, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewGetInboundNetworkDependenciesEndpointsPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewGetInboundNetworkDependenciesEndpointsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetInboundNetworkDependenciesEndpointsPager not implemented")}
	}
	newGetInboundNetworkDependenciesEndpointsPager := e.newGetInboundNetworkDependenciesEndpointsPager.get(req)
	if newGetInboundNetworkDependenciesEndpointsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inboundNetworkDependenciesEndpoints`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewGetInboundNetworkDependenciesEndpointsPager(resourceGroupNameParam, nameParam, nil)
		newGetInboundNetworkDependenciesEndpointsPager = &resp
		e.newGetInboundNetworkDependenciesEndpointsPager.add(req, newGetInboundNetworkDependenciesEndpointsPager)
		server.PagerResponderInjectNextLinks(newGetInboundNetworkDependenciesEndpointsPager, req, func(page *armappservice.EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetInboundNetworkDependenciesEndpointsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newGetInboundNetworkDependenciesEndpointsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetInboundNetworkDependenciesEndpointsPager) {
		e.newGetInboundNetworkDependenciesEndpointsPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchGetMultiRolePool(req *http.Request) (*http.Response, error) {
	if e.srv.GetMultiRolePool == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMultiRolePool not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/multiRolePools/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetMultiRolePool(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkerPoolResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewGetOutboundNetworkDependenciesEndpointsPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewGetOutboundNetworkDependenciesEndpointsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetOutboundNetworkDependenciesEndpointsPager not implemented")}
	}
	newGetOutboundNetworkDependenciesEndpointsPager := e.newGetOutboundNetworkDependenciesEndpointsPager.get(req)
	if newGetOutboundNetworkDependenciesEndpointsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outboundNetworkDependenciesEndpoints`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewGetOutboundNetworkDependenciesEndpointsPager(resourceGroupNameParam, nameParam, nil)
		newGetOutboundNetworkDependenciesEndpointsPager = &resp
		e.newGetOutboundNetworkDependenciesEndpointsPager.add(req, newGetOutboundNetworkDependenciesEndpointsPager)
		server.PagerResponderInjectNextLinks(newGetOutboundNetworkDependenciesEndpointsPager, req, func(page *armappservice.EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetOutboundNetworkDependenciesEndpointsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newGetOutboundNetworkDependenciesEndpointsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetOutboundNetworkDependenciesEndpointsPager) {
		e.newGetOutboundNetworkDependenciesEndpointsPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchGetPrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if e.srv.GetPrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateEndpointConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetPrivateEndpointConnection(req.Context(), resourceGroupNameParam, nameParam, privateEndpointConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RemotePrivateEndpointConnectionARMResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewGetPrivateEndpointConnectionListPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewGetPrivateEndpointConnectionListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetPrivateEndpointConnectionListPager not implemented")}
	}
	newGetPrivateEndpointConnectionListPager := e.newGetPrivateEndpointConnectionListPager.get(req)
	if newGetPrivateEndpointConnectionListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewGetPrivateEndpointConnectionListPager(resourceGroupNameParam, nameParam, nil)
		newGetPrivateEndpointConnectionListPager = &resp
		e.newGetPrivateEndpointConnectionListPager.add(req, newGetPrivateEndpointConnectionListPager)
		server.PagerResponderInjectNextLinks(newGetPrivateEndpointConnectionListPager, req, func(page *armappservice.EnvironmentsClientGetPrivateEndpointConnectionListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetPrivateEndpointConnectionListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newGetPrivateEndpointConnectionListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetPrivateEndpointConnectionListPager) {
		e.newGetPrivateEndpointConnectionListPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchGetPrivateLinkResources(req *http.Request) (*http.Response, error) {
	if e.srv.GetPrivateLinkResources == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateLinkResources not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetPrivateLinkResources(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateLinkResourcesWrapper, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchGetVipInfo(req *http.Request) (*http.Response, error) {
	if e.srv.GetVipInfo == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVipInfo not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacities/virtualip`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetVipInfo(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AddressResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchGetWorkerPool(req *http.Request) (*http.Response, error) {
	if e.srv.GetWorkerPool == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetWorkerPool not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workerPools/(?P<workerPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	workerPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workerPoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetWorkerPool(req.Context(), resourceGroupNameParam, nameParam, workerPoolNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkerPoolResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := e.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := e.srv.NewListPager(nil)
		newListPager = &resp
		e.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappservice.EnvironmentsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		e.newListPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListAppServicePlansPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListAppServicePlansPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAppServicePlansPager not implemented")}
	}
	newListAppServicePlansPager := e.newListAppServicePlansPager.get(req)
	if newListAppServicePlansPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverfarms`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListAppServicePlansPager(resourceGroupNameParam, nameParam, nil)
		newListAppServicePlansPager = &resp
		e.newListAppServicePlansPager.add(req, newListAppServicePlansPager)
		server.PagerResponderInjectNextLinks(newListAppServicePlansPager, req, func(page *armappservice.EnvironmentsClientListAppServicePlansResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAppServicePlansPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListAppServicePlansPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAppServicePlansPager) {
		e.newListAppServicePlansPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := e.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		e.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armappservice.EnvironmentsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		e.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListCapacitiesPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListCapacitiesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListCapacitiesPager not implemented")}
	}
	newListCapacitiesPager := e.newListCapacitiesPager.get(req)
	if newListCapacitiesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacities/compute`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListCapacitiesPager(resourceGroupNameParam, nameParam, nil)
		newListCapacitiesPager = &resp
		e.newListCapacitiesPager.add(req, newListCapacitiesPager)
		server.PagerResponderInjectNextLinks(newListCapacitiesPager, req, func(page *armappservice.EnvironmentsClientListCapacitiesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListCapacitiesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListCapacitiesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListCapacitiesPager) {
		e.newListCapacitiesPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchListDiagnostics(req *http.Request) (*http.Response, error) {
	if e.srv.ListDiagnostics == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListDiagnostics not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnostics`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.ListDiagnostics(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HostingEnvironmentDiagnosticsArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListMultiRoleMetricDefinitionsPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListMultiRoleMetricDefinitionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMultiRoleMetricDefinitionsPager not implemented")}
	}
	newListMultiRoleMetricDefinitionsPager := e.newListMultiRoleMetricDefinitionsPager.get(req)
	if newListMultiRoleMetricDefinitionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/multiRolePools/default/metricdefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListMultiRoleMetricDefinitionsPager(resourceGroupNameParam, nameParam, nil)
		newListMultiRoleMetricDefinitionsPager = &resp
		e.newListMultiRoleMetricDefinitionsPager.add(req, newListMultiRoleMetricDefinitionsPager)
		server.PagerResponderInjectNextLinks(newListMultiRoleMetricDefinitionsPager, req, func(page *armappservice.EnvironmentsClientListMultiRoleMetricDefinitionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMultiRoleMetricDefinitionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListMultiRoleMetricDefinitionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMultiRoleMetricDefinitionsPager) {
		e.newListMultiRoleMetricDefinitionsPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListMultiRolePoolInstanceMetricDefinitionsPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListMultiRolePoolInstanceMetricDefinitionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMultiRolePoolInstanceMetricDefinitionsPager not implemented")}
	}
	newListMultiRolePoolInstanceMetricDefinitionsPager := e.newListMultiRolePoolInstanceMetricDefinitionsPager.get(req)
	if newListMultiRolePoolInstanceMetricDefinitionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/multiRolePools/default/instances/(?P<instance>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metricdefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		instanceParam, err := url.PathUnescape(matches[regex.SubexpIndex("instance")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListMultiRolePoolInstanceMetricDefinitionsPager(resourceGroupNameParam, nameParam, instanceParam, nil)
		newListMultiRolePoolInstanceMetricDefinitionsPager = &resp
		e.newListMultiRolePoolInstanceMetricDefinitionsPager.add(req, newListMultiRolePoolInstanceMetricDefinitionsPager)
		server.PagerResponderInjectNextLinks(newListMultiRolePoolInstanceMetricDefinitionsPager, req, func(page *armappservice.EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMultiRolePoolInstanceMetricDefinitionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListMultiRolePoolInstanceMetricDefinitionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMultiRolePoolInstanceMetricDefinitionsPager) {
		e.newListMultiRolePoolInstanceMetricDefinitionsPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListMultiRolePoolSKUsPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListMultiRolePoolSKUsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMultiRolePoolSKUsPager not implemented")}
	}
	newListMultiRolePoolSKUsPager := e.newListMultiRolePoolSKUsPager.get(req)
	if newListMultiRolePoolSKUsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/multiRolePools/default/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListMultiRolePoolSKUsPager(resourceGroupNameParam, nameParam, nil)
		newListMultiRolePoolSKUsPager = &resp
		e.newListMultiRolePoolSKUsPager.add(req, newListMultiRolePoolSKUsPager)
		server.PagerResponderInjectNextLinks(newListMultiRolePoolSKUsPager, req, func(page *armappservice.EnvironmentsClientListMultiRolePoolSKUsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMultiRolePoolSKUsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListMultiRolePoolSKUsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMultiRolePoolSKUsPager) {
		e.newListMultiRolePoolSKUsPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListMultiRolePoolsPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListMultiRolePoolsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMultiRolePoolsPager not implemented")}
	}
	newListMultiRolePoolsPager := e.newListMultiRolePoolsPager.get(req)
	if newListMultiRolePoolsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/multiRolePools`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListMultiRolePoolsPager(resourceGroupNameParam, nameParam, nil)
		newListMultiRolePoolsPager = &resp
		e.newListMultiRolePoolsPager.add(req, newListMultiRolePoolsPager)
		server.PagerResponderInjectNextLinks(newListMultiRolePoolsPager, req, func(page *armappservice.EnvironmentsClientListMultiRolePoolsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMultiRolePoolsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListMultiRolePoolsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMultiRolePoolsPager) {
		e.newListMultiRolePoolsPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListMultiRoleUsagesPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListMultiRoleUsagesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMultiRoleUsagesPager not implemented")}
	}
	newListMultiRoleUsagesPager := e.newListMultiRoleUsagesPager.get(req)
	if newListMultiRoleUsagesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/multiRolePools/default/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListMultiRoleUsagesPager(resourceGroupNameParam, nameParam, nil)
		newListMultiRoleUsagesPager = &resp
		e.newListMultiRoleUsagesPager.add(req, newListMultiRoleUsagesPager)
		server.PagerResponderInjectNextLinks(newListMultiRoleUsagesPager, req, func(page *armappservice.EnvironmentsClientListMultiRoleUsagesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMultiRoleUsagesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListMultiRoleUsagesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMultiRoleUsagesPager) {
		e.newListMultiRoleUsagesPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchListOperations(req *http.Request) (*http.Response, error) {
	if e.srv.ListOperations == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListOperations not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operations`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.ListOperations(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OperationArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListUsagesPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListUsagesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListUsagesPager not implemented")}
	}
	newListUsagesPager := e.newListUsagesPager.get(req)
	if newListUsagesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armappservice.EnvironmentsClientListUsagesOptions
		if filterParam != nil {
			options = &armappservice.EnvironmentsClientListUsagesOptions{
				Filter: filterParam,
			}
		}
		resp := e.srv.NewListUsagesPager(resourceGroupNameParam, nameParam, options)
		newListUsagesPager = &resp
		e.newListUsagesPager.add(req, newListUsagesPager)
		server.PagerResponderInjectNextLinks(newListUsagesPager, req, func(page *armappservice.EnvironmentsClientListUsagesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListUsagesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListUsagesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListUsagesPager) {
		e.newListUsagesPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListWebAppsPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListWebAppsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListWebAppsPager not implemented")}
	}
	newListWebAppsPager := e.newListWebAppsPager.get(req)
	if newListWebAppsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sites`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		propertiesToIncludeUnescaped, err := url.QueryUnescape(qp.Get("propertiesToInclude"))
		if err != nil {
			return nil, err
		}
		propertiesToIncludeParam := getOptional(propertiesToIncludeUnescaped)
		var options *armappservice.EnvironmentsClientListWebAppsOptions
		if propertiesToIncludeParam != nil {
			options = &armappservice.EnvironmentsClientListWebAppsOptions{
				PropertiesToInclude: propertiesToIncludeParam,
			}
		}
		resp := e.srv.NewListWebAppsPager(resourceGroupNameParam, nameParam, options)
		newListWebAppsPager = &resp
		e.newListWebAppsPager.add(req, newListWebAppsPager)
		server.PagerResponderInjectNextLinks(newListWebAppsPager, req, func(page *armappservice.EnvironmentsClientListWebAppsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListWebAppsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListWebAppsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListWebAppsPager) {
		e.newListWebAppsPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListWebWorkerMetricDefinitionsPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListWebWorkerMetricDefinitionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListWebWorkerMetricDefinitionsPager not implemented")}
	}
	newListWebWorkerMetricDefinitionsPager := e.newListWebWorkerMetricDefinitionsPager.get(req)
	if newListWebWorkerMetricDefinitionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workerPools/(?P<workerPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metricdefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		workerPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workerPoolName")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListWebWorkerMetricDefinitionsPager(resourceGroupNameParam, nameParam, workerPoolNameParam, nil)
		newListWebWorkerMetricDefinitionsPager = &resp
		e.newListWebWorkerMetricDefinitionsPager.add(req, newListWebWorkerMetricDefinitionsPager)
		server.PagerResponderInjectNextLinks(newListWebWorkerMetricDefinitionsPager, req, func(page *armappservice.EnvironmentsClientListWebWorkerMetricDefinitionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListWebWorkerMetricDefinitionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListWebWorkerMetricDefinitionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListWebWorkerMetricDefinitionsPager) {
		e.newListWebWorkerMetricDefinitionsPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListWebWorkerUsagesPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListWebWorkerUsagesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListWebWorkerUsagesPager not implemented")}
	}
	newListWebWorkerUsagesPager := e.newListWebWorkerUsagesPager.get(req)
	if newListWebWorkerUsagesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workerPools/(?P<workerPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		workerPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workerPoolName")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListWebWorkerUsagesPager(resourceGroupNameParam, nameParam, workerPoolNameParam, nil)
		newListWebWorkerUsagesPager = &resp
		e.newListWebWorkerUsagesPager.add(req, newListWebWorkerUsagesPager)
		server.PagerResponderInjectNextLinks(newListWebWorkerUsagesPager, req, func(page *armappservice.EnvironmentsClientListWebWorkerUsagesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListWebWorkerUsagesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListWebWorkerUsagesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListWebWorkerUsagesPager) {
		e.newListWebWorkerUsagesPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListWorkerPoolInstanceMetricDefinitionsPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListWorkerPoolInstanceMetricDefinitionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListWorkerPoolInstanceMetricDefinitionsPager not implemented")}
	}
	newListWorkerPoolInstanceMetricDefinitionsPager := e.newListWorkerPoolInstanceMetricDefinitionsPager.get(req)
	if newListWorkerPoolInstanceMetricDefinitionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workerPools/(?P<workerPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<instance>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metricdefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		workerPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workerPoolName")])
		if err != nil {
			return nil, err
		}
		instanceParam, err := url.PathUnescape(matches[regex.SubexpIndex("instance")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListWorkerPoolInstanceMetricDefinitionsPager(resourceGroupNameParam, nameParam, workerPoolNameParam, instanceParam, nil)
		newListWorkerPoolInstanceMetricDefinitionsPager = &resp
		e.newListWorkerPoolInstanceMetricDefinitionsPager.add(req, newListWorkerPoolInstanceMetricDefinitionsPager)
		server.PagerResponderInjectNextLinks(newListWorkerPoolInstanceMetricDefinitionsPager, req, func(page *armappservice.EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListWorkerPoolInstanceMetricDefinitionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListWorkerPoolInstanceMetricDefinitionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListWorkerPoolInstanceMetricDefinitionsPager) {
		e.newListWorkerPoolInstanceMetricDefinitionsPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListWorkerPoolSKUsPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListWorkerPoolSKUsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListWorkerPoolSKUsPager not implemented")}
	}
	newListWorkerPoolSKUsPager := e.newListWorkerPoolSKUsPager.get(req)
	if newListWorkerPoolSKUsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workerPools/(?P<workerPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		workerPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workerPoolName")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListWorkerPoolSKUsPager(resourceGroupNameParam, nameParam, workerPoolNameParam, nil)
		newListWorkerPoolSKUsPager = &resp
		e.newListWorkerPoolSKUsPager.add(req, newListWorkerPoolSKUsPager)
		server.PagerResponderInjectNextLinks(newListWorkerPoolSKUsPager, req, func(page *armappservice.EnvironmentsClientListWorkerPoolSKUsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListWorkerPoolSKUsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListWorkerPoolSKUsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListWorkerPoolSKUsPager) {
		e.newListWorkerPoolSKUsPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchNewListWorkerPoolsPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListWorkerPoolsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListWorkerPoolsPager not implemented")}
	}
	newListWorkerPoolsPager := e.newListWorkerPoolsPager.get(req)
	if newListWorkerPoolsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workerPools`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListWorkerPoolsPager(resourceGroupNameParam, nameParam, nil)
		newListWorkerPoolsPager = &resp
		e.newListWorkerPoolsPager.add(req, newListWorkerPoolsPager)
		server.PagerResponderInjectNextLinks(newListWorkerPoolsPager, req, func(page *armappservice.EnvironmentsClientListWorkerPoolsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListWorkerPoolsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListWorkerPoolsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListWorkerPoolsPager) {
		e.newListWorkerPoolsPager.remove(req)
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchReboot(req *http.Request) (*http.Response, error) {
	if e.srv.Reboot == nil {
		return nil, &nonRetriableError{errors.New("fake for method Reboot not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reboot`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Reboot(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchBeginResume(req *http.Request) (*http.Response, error) {
	if e.srv.BeginResume == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResume not implemented")}
	}
	beginResume := e.beginResume.get(req)
	if beginResume == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resume`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginResume(req.Context(), resourceGroupNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResume = &respr
		e.beginResume.add(req, beginResume)
	}

	resp, err := server.PollerResponderNext(beginResume, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginResume.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResume) {
		e.beginResume.remove(req)
	}

	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchBeginSuspend(req *http.Request) (*http.Response, error) {
	if e.srv.BeginSuspend == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSuspend not implemented")}
	}
	beginSuspend := e.beginSuspend.get(req)
	if beginSuspend == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/suspend`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginSuspend(req.Context(), resourceGroupNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSuspend = &respr
		e.beginSuspend.add(req, beginSuspend)
	}

	resp, err := server.PollerResponderNext(beginSuspend, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginSuspend.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSuspend) {
		e.beginSuspend.remove(req)
	}

	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchTestUpgradeAvailableNotification(req *http.Request) (*http.Response, error) {
	if e.srv.TestUpgradeAvailableNotification == nil {
		return nil, &nonRetriableError{errors.New("fake for method TestUpgradeAvailableNotification not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testUpgradeAvailableNotification`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.TestUpgradeAvailableNotification(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.EnvironmentPatchResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Update(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EnvironmentResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchUpdateAseCustomDNSSuffixConfiguration(req *http.Request) (*http.Response, error) {
	if e.srv.UpdateAseCustomDNSSuffixConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateAseCustomDNSSuffixConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/configurations/customdnssuffix`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.CustomDNSSuffixConfiguration](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.UpdateAseCustomDNSSuffixConfiguration(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomDNSSuffixConfiguration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchUpdateAseNetworkingConfiguration(req *http.Request) (*http.Response, error) {
	if e.srv.UpdateAseNetworkingConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateAseNetworkingConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/configurations/networking`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.AseV3NetworkingConfiguration](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.UpdateAseNetworkingConfiguration(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AseV3NetworkingConfiguration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchUpdateMultiRolePool(req *http.Request) (*http.Response, error) {
	if e.srv.UpdateMultiRolePool == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateMultiRolePool not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/multiRolePools/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.WorkerPoolResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.UpdateMultiRolePool(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkerPoolResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchUpdateWorkerPool(req *http.Request) (*http.Response, error) {
	if e.srv.UpdateWorkerPool == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateWorkerPool not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workerPools/(?P<workerPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.WorkerPoolResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	workerPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workerPoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.UpdateWorkerPool(req.Context(), resourceGroupNameParam, nameParam, workerPoolNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkerPoolResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnvironmentsServerTransport) dispatchBeginUpgrade(req *http.Request) (*http.Response, error) {
	if e.srv.BeginUpgrade == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpgrade not implemented")}
	}
	beginUpgrade := e.beginUpgrade.get(req)
	if beginUpgrade == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/upgrade`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginUpgrade(req.Context(), resourceGroupNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpgrade = &respr
		e.beginUpgrade.add(req, beginUpgrade)
	}

	resp, err := server.PollerResponderNext(beginUpgrade, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		e.beginUpgrade.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpgrade) {
		e.beginUpgrade.remove(req)
	}

	return resp, nil
}
