//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/azurestackhci/armazurestackhci/v2"
	"net/http"
	"net/url"
	"regexp"
)

// HybridIdentityMetadataServer is a fake server for instances of the armazurestackhci.HybridIdentityMetadataClient type.
type HybridIdentityMetadataServer struct {
	// Get is the fake for method HybridIdentityMetadataClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceURI string, options *armazurestackhci.HybridIdentityMetadataClientGetOptions) (resp azfake.Responder[armazurestackhci.HybridIdentityMetadataClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method HybridIdentityMetadataClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceURI string, options *armazurestackhci.HybridIdentityMetadataClientListOptions) (resp azfake.PagerResponder[armazurestackhci.HybridIdentityMetadataClientListResponse])
}

// NewHybridIdentityMetadataServerTransport creates a new instance of HybridIdentityMetadataServerTransport with the provided implementation.
// The returned HybridIdentityMetadataServerTransport instance is connected to an instance of armazurestackhci.HybridIdentityMetadataClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewHybridIdentityMetadataServerTransport(srv *HybridIdentityMetadataServer) *HybridIdentityMetadataServerTransport {
	return &HybridIdentityMetadataServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armazurestackhci.HybridIdentityMetadataClientListResponse]](),
	}
}

// HybridIdentityMetadataServerTransport connects instances of armazurestackhci.HybridIdentityMetadataClient to instances of HybridIdentityMetadataServer.
// Don't use this type directly, use NewHybridIdentityMetadataServerTransport instead.
type HybridIdentityMetadataServerTransport struct {
	srv          *HybridIdentityMetadataServer
	newListPager *tracker[azfake.PagerResponder[armazurestackhci.HybridIdentityMetadataClientListResponse]]
}

// Do implements the policy.Transporter interface for HybridIdentityMetadataServerTransport.
func (h *HybridIdentityMetadataServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "HybridIdentityMetadataClient.Get":
		resp, err = h.dispatchGet(req)
	case "HybridIdentityMetadataClient.NewListPager":
		resp, err = h.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (h *HybridIdentityMetadataServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if h.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureStackHCI/virtualMachineInstances/default/hybridIdentityMetadata/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Get(req.Context(), resourceURIParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridIdentityMetadata, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (h *HybridIdentityMetadataServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if h.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := h.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureStackHCI/virtualMachineInstances/default/hybridIdentityMetadata`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		resp := h.srv.NewListPager(resourceURIParam, nil)
		newListPager = &resp
		h.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armazurestackhci.HybridIdentityMetadataClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		h.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		h.newListPager.remove(req)
	}
	return resp, nil
}
