//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatafactory

import "time"

// AccessPolicyResponse - Get Data Plane read only token response definition.
type AccessPolicyResponse struct {
	// Data Plane read only access token.
	AccessToken *string

	// Data Plane service base URL.
	DataPlaneURL *string

	// The user access policy.
	Policy *UserAccessPolicy
}

// Activity - A pipeline activity.
type Activity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type Activity.
func (a *Activity) GetActivity() *Activity { return a }

// ActivityDependency - Activity dependency information.
type ActivityDependency struct {
	// REQUIRED; Activity name.
	Activity *string

	// REQUIRED; Match-Condition for the dependency.
	DependencyConditions []*DependencyCondition

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
}

// ActivityPolicy - Execution policy for an activity.
type ActivityPolicy struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
	Retry any

	// Interval between each retry attempt (in seconds). The default is 30 sec.
	RetryIntervalInSeconds *int32

	// When set to true, Input from activity is considered as secure and will not be logged to monitoring.
	SecureInput *bool

	// When set to true, Output from activity is considered as secure and will not be logged to monitoring.
	SecureOutput *bool

	// Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	Timeout any
}

// ActivityRun - Information about an activity run in a pipeline.
type ActivityRun struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The name of the activity.
	ActivityName *string

	// READ-ONLY; The end time of the activity run in 'ISO 8601' format.
	ActivityRunEnd *time.Time

	// READ-ONLY; The id of the activity run.
	ActivityRunID *string

	// READ-ONLY; The start time of the activity run in 'ISO 8601' format.
	ActivityRunStart *time.Time

	// READ-ONLY; The type of the activity.
	ActivityType *string

	// READ-ONLY; The duration of the activity run.
	DurationInMs *int32

	// READ-ONLY; The error if any from the activity run.
	Error any

	// READ-ONLY; The input for the activity.
	Input any

	// READ-ONLY; The name of the compute linked service.
	LinkedServiceName *string

	// READ-ONLY; The output for the activity.
	Output any

	// READ-ONLY; The name of the pipeline.
	PipelineName *string

	// READ-ONLY; The id of the pipeline run.
	PipelineRunID *string

	// READ-ONLY; The status of the activity run.
	Status *string
}

// ActivityRunsQueryResponse - A list activity runs.
type ActivityRunsQueryResponse struct {
	// REQUIRED; List of activity runs.
	Value []*ActivityRun

	// The continuation token for getting the next page of results, if any remaining results exist, null otherwise.
	ContinuationToken *string
}

// AddDataFlowToDebugSessionResponse - Response body structure for starting data flow debug session.
type AddDataFlowToDebugSessionResponse struct {
	// The ID of data flow debug job version.
	JobVersion *string
}

// AmazonMWSLinkedService - Amazon Marketplace Web Service linked service.
type AmazonMWSLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Amazon Marketplace Web Service linked service properties.
	TypeProperties *AmazonMWSLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AmazonMWSLinkedService.
func (a *AmazonMWSLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AmazonMWSLinkedServiceTypeProperties - Amazon Marketplace Web Service linked service properties.
type AmazonMWSLinkedServiceTypeProperties struct {
	// REQUIRED; The access key id used to access data.
	AccessKeyID any

	// REQUIRED; The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
	Endpoint any

	// REQUIRED; The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate
	// them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
	MarketplaceID any

	// REQUIRED; The Amazon seller ID.
	SellerID any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Amazon MWS authentication token.
	MwsAuthToken SecretBaseClassification

	// The secret key used to access data.
	SecretKey SecretBaseClassification

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification any
}

// AmazonMWSObjectDataset - Amazon Marketplace Web Service dataset.
type AmazonMWSObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AmazonMWSObjectDataset.
func (a *AmazonMWSObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AmazonMWSSource - A copy activity Amazon Marketplace Web Service source.
type AmazonMWSSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type AmazonMWSSource.
func (a *AmazonMWSSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AmazonMWSSource.
func (a *AmazonMWSSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        a.AdditionalColumns,
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		QueryTimeout:             a.QueryTimeout,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AmazonRdsForLinkedServiceTypeProperties - AmazonRdsForOracle database linked service properties.
type AmazonRdsForLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Password SecretBaseClassification
}

// AmazonRdsForOracleLinkedService - AmazonRdsForOracle database.
type AmazonRdsForOracleLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; AmazonRdsForOracle database linked service properties.
	TypeProperties *AmazonRdsForLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AmazonRdsForOracleLinkedService.
func (a *AmazonRdsForOracleLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AmazonRdsForOraclePartitionSettings - The settings that will be leveraged for AmazonRdsForOracle source partitioning.
type AmazonRdsForOraclePartitionSettings struct {
	// The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression
	// with resultType string).
	PartitionColumnName any

	// The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionLowerBound any

	// Names of the physical partitions of AmazonRdsForOracle table.
	PartitionNames any

	// The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionUpperBound any
}

// AmazonRdsForOracleSource - A copy activity AmazonRdsForOracle source.
type AmazonRdsForOracleSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// AmazonRdsForOracle reader query. Type: string (or Expression with resultType string).
	OracleReaderQuery any

	// The partition mechanism that will be used for AmazonRdsForOracle read in parallel. Type: string (or Expression with resultType
	// string).
	PartitionOption any

	// The settings that will be leveraged for AmazonRdsForOracle source partitioning.
	PartitionSettings *AmazonRdsForOraclePartitionSettings

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type AmazonRdsForOracleSource.
func (a *AmazonRdsForOracleSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AmazonRdsForOracleTableDataset - The AmazonRdsForOracle database dataset.
type AmazonRdsForOracleTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// AmazonRdsForOracle dataset properties.
	TypeProperties *AmazonRdsForOracleTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AmazonRdsForOracleTableDataset.
func (a *AmazonRdsForOracleTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AmazonRdsForOracleTableDatasetTypeProperties - AmazonRdsForOracle dataset properties.
type AmazonRdsForOracleTableDatasetTypeProperties struct {
	// The schema name of the AmazonRdsForOracle database. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the AmazonRdsForOracle database. Type: string (or Expression with resultType string).
	Table any
}

// AmazonRdsForSQLServerLinkedService - Amazon RDS for SQL Server linked service.
type AmazonRdsForSQLServerLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Amazon RDS for SQL Server linked service properties.
	TypeProperties *AmazonRdsForSQLServerLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AmazonRdsForSQLServerLinkedService.
func (a *AmazonRdsForSQLServerLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AmazonRdsForSQLServerLinkedServiceTypeProperties - Amazon Rds for SQL Server linked service properties.
type AmazonRdsForSQLServerLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// Sql always encrypted properties.
	AlwaysEncryptedSettings *SQLAlwaysEncryptedProperties

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The on-premises Windows authentication password.
	Password SecretBaseClassification

	// The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
	UserName any
}

// AmazonRdsForSQLServerSource - A copy activity Amazon RDS for SQL Server source.
type AmazonRdsForSQLServerSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot.
	// The default value is ReadCommitted. Type: string (or
	// Expression with resultType string).
	IsolationLevel any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "DynamicRange".
	PartitionOption any

	// The settings that will be leveraged for Sql source partitioning.
	PartitionSettings *SQLPartitionSettings

	// Which additional types to produce.
	ProduceAdditionalTypes any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// SQL reader query. Type: string (or Expression with resultType string).
	SQLReaderQuery any

	// Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string
	// (or Expression with resultType string).
	SQLReaderStoredProcedureName any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
	StoredProcedureParameters any
}

// GetCopySource implements the CopySourceClassification interface for type AmazonRdsForSQLServerSource.
func (a *AmazonRdsForSQLServerSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AmazonRdsForSQLServerSource.
func (a *AmazonRdsForSQLServerSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        a.AdditionalColumns,
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		QueryTimeout:             a.QueryTimeout,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AmazonRdsForSQLServerTableDataset - The Amazon RDS for SQL Server dataset.
type AmazonRdsForSQLServerTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// The Amazon RDS for SQL Server dataset properties.
	TypeProperties *AmazonRdsForSQLServerTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AmazonRdsForSQLServerTableDataset.
func (a *AmazonRdsForSQLServerTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AmazonRdsForSQLServerTableDatasetTypeProperties - The Amazon RDS for SQL Server dataset properties.
type AmazonRdsForSQLServerTableDatasetTypeProperties struct {
	// The schema name of the SQL Server dataset. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the SQL Server dataset. Type: string (or Expression with resultType string).
	Table any
}

// AmazonRedshiftLinkedService - Linked service for Amazon Redshift.
type AmazonRedshiftLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Amazon Redshift linked service properties.
	TypeProperties *AmazonRedshiftLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AmazonRedshiftLinkedService.
func (a *AmazonRedshiftLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AmazonRedshiftLinkedServiceTypeProperties - Amazon Redshift linked service properties.
type AmazonRedshiftLinkedServiceTypeProperties struct {
	// REQUIRED; The database name of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Database any

	// REQUIRED; The name of the Amazon Redshift server. Type: string (or Expression with resultType string).
	Server any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The password of the Amazon Redshift source.
	Password SecretBaseClassification

	// The TCP port number that the Amazon Redshift server uses to listen for client connections. The default value is 5439. Type:
	// integer (or Expression with resultType integer).
	Port any

	// The username of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Username any
}

// AmazonRedshiftSource - A copy activity source for Amazon Redshift Source.
type AmazonRedshiftSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data
	// from Amazon Redshift source will be unloaded into S3 first and then copied into
	// the targeted sink from the interim S3.
	RedshiftUnloadSettings *RedshiftUnloadSettings

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type AmazonRedshiftSource.
func (a *AmazonRedshiftSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AmazonRedshiftSource.
func (a *AmazonRedshiftSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        a.AdditionalColumns,
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		QueryTimeout:             a.QueryTimeout,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AmazonRedshiftTableDataset - The Amazon Redshift table dataset.
type AmazonRedshiftTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Amazon Redshift table dataset properties.
	TypeProperties *AmazonRedshiftTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AmazonRedshiftTableDataset.
func (a *AmazonRedshiftTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AmazonRedshiftTableDatasetTypeProperties - Amazon Redshift table dataset properties.
type AmazonRedshiftTableDatasetTypeProperties struct {
	// The Amazon Redshift schema name. Type: string (or Expression with resultType string).
	Schema any

	// The Amazon Redshift table name. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// AmazonS3CompatibleLinkedService - Linked service for Amazon S3 Compatible.
type AmazonS3CompatibleLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Amazon S3 Compatible linked service properties.
	TypeProperties *AmazonS3CompatibleLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AmazonS3CompatibleLinkedService.
func (a *AmazonS3CompatibleLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AmazonS3CompatibleLinkedServiceTypeProperties - Amazon S3 Compatible linked service properties.
type AmazonS3CompatibleLinkedServiceTypeProperties struct {
	// The access key identifier of the Amazon S3 Compatible Identity and Access Management (IAM) user. Type: string (or Expression
	// with resultType string).
	AccessKeyID any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// If true, use S3 path-style access instead of virtual hosted-style access. Default value is false. Type: boolean (or Expression
	// with resultType boolean).
	ForcePathStyle any

	// The secret access key of the Amazon S3 Compatible Identity and Access Management (IAM) user.
	SecretAccessKey SecretBaseClassification

	// This value specifies the endpoint to access with the Amazon S3 Compatible Connector. This is an optional property; change
	// it only if you want to try a different service endpoint or want to switch
	// between https and http. Type: string (or Expression with resultType string).
	ServiceURL any
}

// AmazonS3CompatibleLocation - The location of Amazon S3 Compatible dataset.
type AmazonS3CompatibleLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the bucketName of Amazon S3 Compatible. Type: string (or Expression with resultType string)
	BucketName any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any

	// Specify the version of Amazon S3 Compatible. Type: string (or Expression with resultType string).
	Version any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type AmazonS3CompatibleLocation.
func (a *AmazonS3CompatibleLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: a.AdditionalProperties,
		FileName:             a.FileName,
		FolderPath:           a.FolderPath,
		Type:                 a.Type,
	}
}

// AmazonS3CompatibleReadSettings - Amazon S3 Compatible read settings.
type AmazonS3CompatibleReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// The prefix filter for the S3 Compatible object name. Type: string (or Expression with resultType string).
	Prefix any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Amazon S3 Compatible wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// Amazon S3 Compatible wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type AmazonS3CompatibleReadSettings.
func (a *AmazonS3CompatibleReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		Type:                     a.Type,
	}
}

// AmazonS3Dataset - A single Amazon Simple Storage Service (S3) object or a set of S3 objects.
type AmazonS3Dataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; Amazon S3 dataset properties.
	TypeProperties *AmazonS3DatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type AmazonS3Dataset.
func (a *AmazonS3Dataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AmazonS3DatasetTypeProperties - Amazon S3 dataset properties.
type AmazonS3DatasetTypeProperties struct {
	// REQUIRED; The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
	BucketName any

	// The data compression method used for the Amazon S3 object.
	Compression *DatasetCompression

	// The format of files.
	Format DatasetStorageFormatClassification

	// The key of the Amazon S3 object. Type: string (or Expression with resultType string).
	Key any

	// The end of S3 object's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of S3 object's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
	Prefix any

	// The version for the S3 object. Type: string (or Expression with resultType string).
	Version any
}

// AmazonS3LinkedService - Linked service for Amazon S3.
type AmazonS3LinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Amazon S3 linked service properties.
	TypeProperties *AmazonS3LinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AmazonS3LinkedService.
func (a *AmazonS3LinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AmazonS3LinkedServiceTypeProperties - Amazon S3 linked service properties.
type AmazonS3LinkedServiceTypeProperties struct {
	// The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with
	// resultType string).
	AccessKeyID any

	// The authentication type of S3. Allowed value: AccessKey (default) or TemporarySecurityCredentials. Type: string (or Expression
	// with resultType string).
	AuthenticationType any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
	SecretAccessKey SecretBaseClassification

	// This value specifies the endpoint to access with the S3 Connector. This is an optional property; change it only if you
	// want to try a different service endpoint or want to switch between https and
	// http. Type: string (or Expression with resultType string).
	ServiceURL any

	// The session token for the S3 temporary security credential.
	SessionToken SecretBaseClassification
}

// AmazonS3Location - The location of amazon S3 dataset.
type AmazonS3Location struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the bucketName of amazon S3. Type: string (or Expression with resultType string)
	BucketName any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any

	// Specify the version of amazon S3. Type: string (or Expression with resultType string).
	Version any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type AmazonS3Location.
func (a *AmazonS3Location) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: a.AdditionalProperties,
		FileName:             a.FileName,
		FolderPath:           a.FolderPath,
		Type:                 a.Type,
	}
}

// AmazonS3ReadSettings - Amazon S3 read settings.
type AmazonS3ReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
	Prefix any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// AmazonS3 wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// AmazonS3 wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type AmazonS3ReadSettings.
func (a *AmazonS3ReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		Type:                     a.Type,
	}
}

// AppFiguresLinkedService - Linked service for AppFigures.
type AppFiguresLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; AppFigures linked service properties.
	TypeProperties *AppFiguresLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AppFiguresLinkedService.
func (a *AppFiguresLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AppFiguresLinkedServiceTypeProperties - AppFigures linked service type properties.
type AppFiguresLinkedServiceTypeProperties struct {
	// REQUIRED; The client key for the AppFigures source.
	ClientKey SecretBaseClassification

	// REQUIRED; The password of the AppFigures source.
	Password SecretBaseClassification

	// REQUIRED; The username of the Appfigures source. Type: string (or Expression with resultType string).
	UserName any
}

// AppendVariableActivity - Append value for a Variable of type Array.
type AppendVariableActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Append Variable activity properties.
	TypeProperties *AppendVariableActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type AppendVariableActivity.
func (a *AppendVariableActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: a.AdditionalProperties,
		DependsOn:            a.DependsOn,
		Description:          a.Description,
		Name:                 a.Name,
		OnInactiveMarkAs:     a.OnInactiveMarkAs,
		State:                a.State,
		Type:                 a.Type,
		UserProperties:       a.UserProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type AppendVariableActivity.
func (a *AppendVariableActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		AdditionalProperties: a.AdditionalProperties,
		DependsOn:            a.DependsOn,
		Description:          a.Description,
		Name:                 a.Name,
		OnInactiveMarkAs:     a.OnInactiveMarkAs,
		State:                a.State,
		Type:                 a.Type,
		UserProperties:       a.UserProperties,
	}
}

// AppendVariableActivityTypeProperties - AppendVariable activity properties.
type AppendVariableActivityTypeProperties struct {
	// Value to be appended. Type: could be a static value matching type of the variable item or Expression with resultType matching
	// type of the variable item
	Value any

	// Name of the variable whose value needs to be appended to.
	VariableName *string
}

// ArmIDWrapper - A wrapper for an ARM resource id
type ArmIDWrapper struct {
	// READ-ONLY
	ID *string
}

// AsanaLinkedService - Linked service for Asana.
type AsanaLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Asana linked service properties.
	TypeProperties *AsanaLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AsanaLinkedService.
func (a *AsanaLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AsanaLinkedServiceTypeProperties - Asana linked service type properties.
type AsanaLinkedServiceTypeProperties struct {
	// REQUIRED; The api token for the Asana source.
	APIToken SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string
}

// AvroDataset - Avro dataset.
type AvroDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Avro dataset properties.
	TypeProperties *AvroDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AvroDataset.
func (a *AvroDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AvroDatasetTypeProperties - Avro dataset properties.
type AvroDatasetTypeProperties struct {
	// REQUIRED; The location of the avro storage.
	Location DatasetLocationClassification

	// The data avroCompressionCodec. Type: string (or Expression with resultType string).
	AvroCompressionCodec any
	AvroCompressionLevel *int32
}

// AvroFormat - The data stored in Avro format.
type AvroFormat struct {
	// REQUIRED; Type of dataset storage format.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Deserializer. Type: string (or Expression with resultType string).
	Deserializer any

	// Serializer. Type: string (or Expression with resultType string).
	Serializer any
}

// GetDatasetStorageFormat implements the DatasetStorageFormatClassification interface for type AvroFormat.
func (a *AvroFormat) GetDatasetStorageFormat() *DatasetStorageFormat {
	return &DatasetStorageFormat{
		AdditionalProperties: a.AdditionalProperties,
		Deserializer:         a.Deserializer,
		Serializer:           a.Serializer,
		Type:                 a.Type,
	}
}

// AvroSink - A copy activity Avro sink.
type AvroSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Avro format settings.
	FormatSettings *AvroWriteSettings

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Avro store settings.
	StoreSettings StoreWriteSettingsClassification

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type AvroSink.
func (a *AvroSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
	}
}

// AvroSource - A copy activity Avro source.
type AvroSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Avro store settings.
	StoreSettings StoreReadSettingsClassification
}

// GetCopySource implements the CopySourceClassification interface for type AvroSource.
func (a *AvroSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AvroWriteSettings - Avro write settings.
type AvroWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specifies the file name pattern _. when copy from non-file based store without partitionOptions. Type: string (or Expression
	// with resultType string).
	FileNamePrefix any

	// Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with
	// resultType integer).
	MaxRowsPerFile any

	// Top level record name in write result, which is required in AVRO spec.
	RecordName *string

	// Record namespace in the write result.
	RecordNamespace *string
}

// GetFormatWriteSettings implements the FormatWriteSettingsClassification interface for type AvroWriteSettings.
func (a *AvroWriteSettings) GetFormatWriteSettings() *FormatWriteSettings {
	return &FormatWriteSettings{
		AdditionalProperties: a.AdditionalProperties,
		Type:                 a.Type,
	}
}

// AzPowerShellSetup - The express custom setup of installing Azure PowerShell.
type AzPowerShellSetup struct {
	// REQUIRED; The type of custom setup.
	Type *string

	// REQUIRED; Install Azure PowerShell type properties.
	TypeProperties *AzPowerShellSetupTypeProperties
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type AzPowerShellSetup.
func (a *AzPowerShellSetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: a.Type,
	}
}

// AzPowerShellSetupTypeProperties - Installation of Azure PowerShell type properties.
type AzPowerShellSetupTypeProperties struct {
	// REQUIRED; The required version of Azure PowerShell to install.
	Version *string
}

// AzureBatchLinkedService - Azure Batch linked service.
type AzureBatchLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Batch linked service properties.
	TypeProperties *AzureBatchLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureBatchLinkedService.
func (a *AzureBatchLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureBatchLinkedServiceTypeProperties - Azure Batch linked service properties.
type AzureBatchLinkedServiceTypeProperties struct {
	// REQUIRED; The Azure Batch account name. Type: string (or Expression with resultType string).
	AccountName any

	// REQUIRED; The Azure Batch URI. Type: string (or Expression with resultType string).
	BatchURI any

	// REQUIRED; The Azure Storage linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; The Azure Batch pool name. Type: string (or Expression with resultType string).
	PoolName any

	// The Azure Batch account access key.
	AccessKey SecretBaseClassification

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string
}

// AzureBlobDataset - The Azure Blob storage.
type AzureBlobDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Azure Blob dataset properties.
	TypeProperties *AzureBlobDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AzureBlobDataset.
func (a *AzureBlobDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzureBlobDatasetTypeProperties - Azure Blob dataset properties.
type AzureBlobDatasetTypeProperties struct {
	// The data compression method used for the blob storage.
	Compression *DatasetCompression

	// The name of the Azure Blob. Type: string (or Expression with resultType string).
	FileName any

	// The path of the Azure Blob storage. Type: string (or Expression with resultType string).
	FolderPath any

	// The format of the Azure Blob storage.
	Format DatasetStorageFormatClassification

	// The end of Azure Blob's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of Azure Blob's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// The root of blob path. Type: string (or Expression with resultType string).
	TableRootLocation any
}

// AzureBlobFSDataset - The Azure Data Lake Storage Gen2 storage.
type AzureBlobFSDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Azure Data Lake Storage Gen2 dataset properties.
	TypeProperties *AzureBlobFSDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AzureBlobFSDataset.
func (a *AzureBlobFSDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzureBlobFSDatasetTypeProperties - Azure Data Lake Storage Gen2 dataset properties.
type AzureBlobFSDatasetTypeProperties struct {
	// The data compression method used for the blob storage.
	Compression *DatasetCompression

	// The name of the Azure Data Lake Storage Gen2. Type: string (or Expression with resultType string).
	FileName any

	// The path of the Azure Data Lake Storage Gen2 storage. Type: string (or Expression with resultType string).
	FolderPath any

	// The format of the Azure Data Lake Storage Gen2 storage.
	Format DatasetStorageFormatClassification
}

// AzureBlobFSLinkedService - Azure Data Lake Storage Gen2 linked service.
type AzureBlobFSLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Data Lake Storage Gen2 linked service properties.
	TypeProperties *AzureBlobFSLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureBlobFSLinkedService.
func (a *AzureBlobFSLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureBlobFSLinkedServiceTypeProperties - Azure Data Lake Storage Gen2 linked service properties.
type AzureBlobFSLinkedServiceTypeProperties struct {
	// Account key for the Azure Data Lake Storage Gen2 service. Type: string (or Expression with resultType string).
	AccountKey any

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of sasToken in sas uri.
	SasToken SecretBaseClassification

	// SAS URI of the Azure Data Lake Storage Gen2 service. Type: string, SecureString or AzureKeyVaultSecretReference.
	SasURI any

	// The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
	// servicePrincipalCredential can be SecureString or
	// AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can
	// only be AzureKeyVaultSecretReference.
	ServicePrincipalCredential SecretBaseClassification

	// The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret,
	// 'ServicePrincipalCert' for certificate. Type: string (or Expression with
	// resultType string).
	ServicePrincipalCredentialType any

	// The ID of the application used to authenticate against the Azure Data Lake Storage Gen2 account. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID any

	// The Key of the application used to authenticate against the Azure Data Lake Storage Gen2 account.
	ServicePrincipalKey SecretBaseClassification

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant any

	// Endpoint for the Azure Data Lake Storage Gen2 service. Type: string (or Expression with resultType string).
	URL any
}

// AzureBlobFSLocation - The location of azure blobFS dataset.
type AzureBlobFSLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the fileSystem of azure blobFS. Type: string (or Expression with resultType string).
	FileSystem any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type AzureBlobFSLocation.
func (a *AzureBlobFSLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: a.AdditionalProperties,
		FileName:             a.FileName,
		FolderPath:           a.FolderPath,
		Type:                 a.Type,
	}
}

// AzureBlobFSReadSettings - Azure blobFS read settings.
type AzureBlobFSReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Azure blobFS wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// Azure blobFS wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type AzureBlobFSReadSettings.
func (a *AzureBlobFSReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		Type:                     a.Type,
	}
}

// AzureBlobFSSink - A copy activity Azure Data Lake Storage Gen2 sink.
type AzureBlobFSSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The type of copy behavior for copy sink. Type: string (or Expression with resultType string).
	CopyBehavior any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
	Metadata []*MetadataItem

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type AzureBlobFSSink.
func (a *AzureBlobFSSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
	}
}

// AzureBlobFSSource - A copy activity Azure BlobFS source.
type AzureBlobFSSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
	SkipHeaderLineCount any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Treat empty as null. Type: boolean (or Expression with resultType boolean).
	TreatEmptyAsNull any
}

// GetCopySource implements the CopySourceClassification interface for type AzureBlobFSSource.
func (a *AzureBlobFSSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AzureBlobFSWriteSettings - Azure blobFS write settings.
type AzureBlobFSWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
	BlockSizeInMB any

	// The type of copy behavior for copy sink.
	CopyBehavior any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any
}

// GetStoreWriteSettings implements the StoreWriteSettingsClassification interface for type AzureBlobFSWriteSettings.
func (a *AzureBlobFSWriteSettings) GetStoreWriteSettings() *StoreWriteSettings {
	return &StoreWriteSettings{
		AdditionalProperties:     a.AdditionalProperties,
		CopyBehavior:             a.CopyBehavior,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		Type:                     a.Type,
	}
}

// AzureBlobStorageLinkedService - The azure blob storage linked service.
type AzureBlobStorageLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Blob Storage linked service properties.
	TypeProperties *AzureBlobStorageLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureBlobStorageLinkedService.
func (a *AzureBlobStorageLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureBlobStorageLinkedServiceTypeProperties - Azure Blob Storage linked service properties.
type AzureBlobStorageLinkedServiceTypeProperties struct {
	// The Azure key vault secret reference of accountKey in connection string.
	AccountKey *AzureKeyVaultSecretReference

	// Specify the kind of your storage account. Allowed values are: Storage (general purpose v1), StorageV2 (general purpose
	// v2), BlobStorage, or BlockBlobStorage. Type: string (or Expression with
	// resultType string).
	AccountKind any

	// The type used for authentication. Type: string.
	AuthenticationType *AzureStorageAuthenticationType

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType any

	// The connection string. It is mutually exclusive with sasUri, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// Container uri of the Azure Blob Storage resource only support for anonymous access. Type: string (or Expression with resultType
	// string).
	ContainerURI any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of sasToken in sas uri.
	SasToken *AzureKeyVaultSecretReference

	// SAS URI of the Azure Blob Storage resource. It is mutually exclusive with connectionString, serviceEndpoint property. Type:
	// string, SecureString or AzureKeyVaultSecretReference.
	SasURI any

	// Blob service endpoint of the Azure Blob Storage resource. It is mutually exclusive with connectionString, sasUri property.
	ServiceEndpoint any

	// The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with
	// resultType string).
	ServicePrincipalID any

	// The key of the service principal used to authenticate against Azure SQL Data Warehouse.
	ServicePrincipalKey SecretBaseClassification

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant any
}

// AzureBlobStorageLocation - The location of azure blob dataset.
type AzureBlobStorageLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the container of azure blob. Type: string (or Expression with resultType string).
	Container any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type AzureBlobStorageLocation.
func (a *AzureBlobStorageLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: a.AdditionalProperties,
		FileName:             a.FileName,
		FolderPath:           a.FolderPath,
		Type:                 a.Type,
	}
}

// AzureBlobStorageReadSettings - Azure blob read settings.
type AzureBlobStorageReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// The prefix filter for the Azure Blob name. Type: string (or Expression with resultType string).
	Prefix any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Azure blob wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// Azure blob wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type AzureBlobStorageReadSettings.
func (a *AzureBlobStorageReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		Type:                     a.Type,
	}
}

// AzureBlobStorageWriteSettings - Azure blob write settings.
type AzureBlobStorageWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
	BlockSizeInMB any

	// The type of copy behavior for copy sink.
	CopyBehavior any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any
}

// GetStoreWriteSettings implements the StoreWriteSettingsClassification interface for type AzureBlobStorageWriteSettings.
func (a *AzureBlobStorageWriteSettings) GetStoreWriteSettings() *StoreWriteSettings {
	return &StoreWriteSettings{
		AdditionalProperties:     a.AdditionalProperties,
		CopyBehavior:             a.CopyBehavior,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		Type:                     a.Type,
	}
}

// AzureDataExplorerCommandActivity - Azure Data Explorer command activity.
type AzureDataExplorerCommandActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Azure Data Explorer command activity properties.
	TypeProperties *AzureDataExplorerCommandActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type AzureDataExplorerCommandActivity.
func (a *AzureDataExplorerCommandActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: a.AdditionalProperties,
		DependsOn:            a.DependsOn,
		Description:          a.Description,
		Name:                 a.Name,
		OnInactiveMarkAs:     a.OnInactiveMarkAs,
		State:                a.State,
		Type:                 a.Type,
		UserProperties:       a.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type AzureDataExplorerCommandActivity.
func (a *AzureDataExplorerCommandActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: a.AdditionalProperties,
		DependsOn:            a.DependsOn,
		Description:          a.Description,
		LinkedServiceName:    a.LinkedServiceName,
		Name:                 a.Name,
		OnInactiveMarkAs:     a.OnInactiveMarkAs,
		Policy:               a.Policy,
		State:                a.State,
		Type:                 a.Type,
		UserProperties:       a.UserProperties,
	}
}

// AzureDataExplorerCommandActivityTypeProperties - Azure Data Explorer command activity properties.
type AzureDataExplorerCommandActivityTypeProperties struct {
	// REQUIRED; A control command, according to the Azure Data Explorer command syntax. Type: string (or Expression with resultType
	// string).
	Command any

	// Control command timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..)
	CommandTimeout any
}

// AzureDataExplorerDatasetTypeProperties - Azure Data Explorer (Kusto) dataset properties.
type AzureDataExplorerDatasetTypeProperties struct {
	// The table name of the Azure Data Explorer database. Type: string (or Expression with resultType string).
	Table any
}

// AzureDataExplorerLinkedService - Azure Data Explorer (Kusto) linked service.
type AzureDataExplorerLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Data Explorer (Kusto) linked service properties.
	TypeProperties *AzureDataExplorerLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureDataExplorerLinkedService.
func (a *AzureDataExplorerLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureDataExplorerLinkedServiceTypeProperties - Azure Data Explorer (Kusto) linked service properties.
type AzureDataExplorerLinkedServiceTypeProperties struct {
	// REQUIRED; Database name for connection. Type: string (or Expression with resultType string).
	Database any

	// REQUIRED; The endpoint of Azure Data Explorer (the engine's endpoint). URL will be in the format https://..kusto.windows.net.
	// Type: string (or Expression with resultType string)
	Endpoint any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The ID of the service principal used to authenticate against Azure Data Explorer. Type: string (or Expression with resultType
	// string).
	ServicePrincipalID any

	// The key of the service principal used to authenticate against Kusto.
	ServicePrincipalKey SecretBaseClassification

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant any
}

// AzureDataExplorerSink - A copy activity Azure Data Explorer sink.
type AzureDataExplorerSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// If set to true, any aggregation will be skipped. Default is false. Type: boolean.
	FlushImmediately any

	// An explicit column mapping description provided in a json format. Type: string.
	IngestionMappingAsJSON any

	// A name of a pre-created csv mapping that was defined on the target Kusto table. Type: string.
	IngestionMappingName any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type AzureDataExplorerSink.
func (a *AzureDataExplorerSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
	}
}

// AzureDataExplorerSource - A copy activity Azure Data Explorer (Kusto) source.
type AzureDataExplorerSource struct {
	// REQUIRED; Database query. Should be a Kusto Query Language (KQL) query. Type: string (or Expression with resultType string).
	Query any

	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The name of the Boolean option that controls whether truncation is applied to result-sets that go beyond a certain row-count
	// limit.
	NoTruncation any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type AzureDataExplorerSource.
func (a *AzureDataExplorerSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AzureDataExplorerTableDataset - The Azure Data Explorer (Kusto) dataset.
type AzureDataExplorerTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; Azure Data Explorer (Kusto) dataset properties.
	TypeProperties *AzureDataExplorerDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type AzureDataExplorerTableDataset.
func (a *AzureDataExplorerTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzureDataLakeAnalyticsLinkedService - Azure Data Lake Analytics linked service.
type AzureDataLakeAnalyticsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Data Lake Analytics linked service properties.
	TypeProperties *AzureDataLakeAnalyticsLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureDataLakeAnalyticsLinkedService.
func (a *AzureDataLakeAnalyticsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureDataLakeAnalyticsLinkedServiceTypeProperties - Azure Data Lake Analytics linked service properties.
type AzureDataLakeAnalyticsLinkedServiceTypeProperties struct {
	// REQUIRED; The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
	AccountName any

	// REQUIRED; The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType
	// string).
	Tenant any

	// Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
	DataLakeAnalyticsURI any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with
	// resultType string).
	ResourceGroupName any

	// The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID any

	// The Key of the application used to authenticate against the Azure Data Lake Analytics account.
	ServicePrincipalKey SecretBaseClassification

	// Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with
	// resultType string).
	SubscriptionID any
}

// AzureDataLakeStoreDataset - Azure Data Lake Store dataset.
type AzureDataLakeStoreDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Azure Data Lake Store dataset properties.
	TypeProperties *AzureDataLakeStoreDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AzureDataLakeStoreDataset.
func (a *AzureDataLakeStoreDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzureDataLakeStoreDatasetTypeProperties - Azure Data Lake Store dataset properties.
type AzureDataLakeStoreDatasetTypeProperties struct {
	// The data compression method used for the item(s) in the Azure Data Lake Store.
	Compression *DatasetCompression

	// The name of the file in the Azure Data Lake Store. Type: string (or Expression with resultType string).
	FileName any

	// Path to the folder in the Azure Data Lake Store. Type: string (or Expression with resultType string).
	FolderPath any

	// The format of the Data Lake Store.
	Format DatasetStorageFormatClassification
}

// AzureDataLakeStoreLinkedService - Azure Data Lake Store linked service.
type AzureDataLakeStoreLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Data Lake Store linked service properties.
	TypeProperties *AzureDataLakeStoreLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureDataLakeStoreLinkedService.
func (a *AzureDataLakeStoreLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureDataLakeStoreLinkedServiceTypeProperties - Azure Data Lake Store linked service properties.
type AzureDataLakeStoreLinkedServiceTypeProperties struct {
	// REQUIRED; Data Lake Store service URI. Type: string (or Expression with resultType string).
	DataLakeStoreURI any

	// Data Lake Store account name. Type: string (or Expression with resultType string).
	AccountName any

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Data Lake Store account resource group name (if different from Data Factory account). Type: string (or Expression with
	// resultType string).
	ResourceGroupName any

	// The ID of the application used to authenticate against the Azure Data Lake Store account. Type: string (or Expression with
	// resultType string).
	ServicePrincipalID any

	// The Key of the application used to authenticate against the Azure Data Lake Store account.
	ServicePrincipalKey SecretBaseClassification

	// Data Lake Store account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType
	// string).
	SubscriptionID any

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant any
}

// AzureDataLakeStoreLocation - The location of azure data lake store dataset.
type AzureDataLakeStoreLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type AzureDataLakeStoreLocation.
func (a *AzureDataLakeStoreLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: a.AdditionalProperties,
		FileName:             a.FileName,
		FolderPath:           a.FolderPath,
		Type:                 a.Type,
	}
}

// AzureDataLakeStoreReadSettings - Azure data lake store read settings.
type AzureDataLakeStoreReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// Lists files after the value (exclusive) based on file/folder names’ lexicographical order. Applies under the folderPath
	// in data set, and filter files/sub-folders under the folderPath. Type: string (or
	// Expression with resultType string).
	ListAfter any

	// Lists files before the value (inclusive) based on file/folder names’ lexicographical order. Applies under the folderPath
	// in data set, and filter files/sub-folders under the folderPath. Type: string
	// (or Expression with resultType string).
	ListBefore any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// ADLS wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// ADLS wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type AzureDataLakeStoreReadSettings.
func (a *AzureDataLakeStoreReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		Type:                     a.Type,
	}
}

// AzureDataLakeStoreSink - A copy activity Azure Data Lake Store sink.
type AzureDataLakeStoreSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The type of copy behavior for copy sink. Type: string (or Expression with resultType string).
	CopyBehavior any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Single File Parallel.
	EnableAdlsSingleFileParallel any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type AzureDataLakeStoreSink.
func (a *AzureDataLakeStoreSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
	}
}

// AzureDataLakeStoreSource - A copy activity Azure Data Lake source.
type AzureDataLakeStoreSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type AzureDataLakeStoreSource.
func (a *AzureDataLakeStoreSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AzureDataLakeStoreWriteSettings - Azure data lake store write settings.
type AzureDataLakeStoreWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The type of copy behavior for copy sink.
	CopyBehavior any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies the expiry time of the written files. The time is applied to the UTC time zone in the format of "2018-12-01T05:00:00Z".
	// Default value is NULL. Type: string (or Expression with resultType
	// string).
	ExpiryDateTime any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any
}

// GetStoreWriteSettings implements the StoreWriteSettingsClassification interface for type AzureDataLakeStoreWriteSettings.
func (a *AzureDataLakeStoreWriteSettings) GetStoreWriteSettings() *StoreWriteSettings {
	return &StoreWriteSettings{
		AdditionalProperties:     a.AdditionalProperties,
		CopyBehavior:             a.CopyBehavior,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		Type:                     a.Type,
	}
}

// AzureDatabricksDeltaLakeDataset - Azure Databricks Delta Lake dataset.
type AzureDatabricksDeltaLakeDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *AzureDatabricksDeltaLakeDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AzureDatabricksDeltaLakeDataset.
func (a *AzureDatabricksDeltaLakeDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzureDatabricksDeltaLakeDatasetTypeProperties - Azure Databricks Delta Lake Dataset Properties
type AzureDatabricksDeltaLakeDatasetTypeProperties struct {
	// The database name of delta table. Type: string (or Expression with resultType string).
	Database any

	// The name of delta table. Type: string (or Expression with resultType string).
	Table any
}

// AzureDatabricksDeltaLakeExportCommand - Azure Databricks Delta Lake export command settings.
type AzureDatabricksDeltaLakeExportCommand struct {
	// REQUIRED; The export setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the date format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
	DateFormat any

	// Specify the timestamp format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType
	// string).
	TimestampFormat any
}

// GetExportSettings implements the ExportSettingsClassification interface for type AzureDatabricksDeltaLakeExportCommand.
func (a *AzureDatabricksDeltaLakeExportCommand) GetExportSettings() *ExportSettings {
	return &ExportSettings{
		AdditionalProperties: a.AdditionalProperties,
		Type:                 a.Type,
	}
}

// AzureDatabricksDeltaLakeImportCommand - Azure Databricks Delta Lake import command settings.
type AzureDatabricksDeltaLakeImportCommand struct {
	// REQUIRED; The import setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the date format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
	DateFormat any

	// Specify the timestamp format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
	TimestampFormat any
}

// GetImportSettings implements the ImportSettingsClassification interface for type AzureDatabricksDeltaLakeImportCommand.
func (a *AzureDatabricksDeltaLakeImportCommand) GetImportSettings() *ImportSettings {
	return &ImportSettings{
		AdditionalProperties: a.AdditionalProperties,
		Type:                 a.Type,
	}
}

// AzureDatabricksDeltaLakeLinkedService - Azure Databricks Delta Lake linked service.
type AzureDatabricksDeltaLakeLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Databricks Delta Lake linked service properties.
	TypeProperties *AzureDatabricksDetltaLakeLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureDatabricksDeltaLakeLinkedService.
func (a *AzureDatabricksDeltaLakeLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureDatabricksDeltaLakeSink - A copy activity Azure Databricks Delta Lake sink.
type AzureDatabricksDeltaLakeSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Azure Databricks Delta Lake import settings.
	ImportSettings *AzureDatabricksDeltaLakeImportCommand

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type AzureDatabricksDeltaLakeSink.
func (a *AzureDatabricksDeltaLakeSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
	}
}

// AzureDatabricksDeltaLakeSource - A copy activity Azure Databricks Delta Lake source.
type AzureDatabricksDeltaLakeSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Azure Databricks Delta Lake export settings.
	ExportSettings *AzureDatabricksDeltaLakeExportCommand

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Azure Databricks Delta Lake Sql query. Type: string (or Expression with resultType string).
	Query any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type AzureDatabricksDeltaLakeSource.
func (a *AzureDatabricksDeltaLakeSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AzureDatabricksDetltaLakeLinkedServiceTypeProperties - Azure Databricks Delta Lake linked service properties.
type AzureDatabricksDetltaLakeLinkedServiceTypeProperties struct {
	// REQUIRED; .azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType
	// string).
	Domain any

	// Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string,
	// SecureString or AzureKeyVaultSecretReference.
	AccessToken SecretBaseClassification

	// The id of an existing interactive cluster that will be used for all runs of this job. Type: string (or Expression with
	// resultType string).
	ClusterID any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
	WorkspaceResourceID any
}

// AzureDatabricksLinkedService - Azure Databricks linked service.
type AzureDatabricksLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Databricks linked service properties.
	TypeProperties *AzureDatabricksLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureDatabricksLinkedService.
func (a *AzureDatabricksLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureDatabricksLinkedServiceTypeProperties - Azure Databricks linked service properties.
type AzureDatabricksLinkedServiceTypeProperties struct {
	// REQUIRED; .azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType
	// string).
	Domain any

	// Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string
	// (or Expression with resultType string).
	AccessToken SecretBaseClassification

	// Required to specify MSI, if using Workspace resource id for databricks REST API. Type: string (or Expression with resultType
	// string).
	Authentication any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The id of an existing interactive cluster that will be used for all runs of this activity. Type: string (or Expression
	// with resultType string).
	ExistingClusterID any

	// The id of an existing instance pool that will be used for all runs of this activity. Type: string (or Expression with resultType
	// string).
	InstancePoolID any

	// Additional tags for cluster resources. This property is ignored in instance pool configurations.
	NewClusterCustomTags map[string]any

	// The driver node type for the new job cluster. This property is ignored in instance pool configurations. Type: string (or
	// Expression with resultType string).
	NewClusterDriverNodeType any

	// Enable the elastic disk on the new cluster. This property is now ignored, and takes the default elastic disk behavior in
	// Databricks (elastic disks are always enabled). Type: boolean (or Expression
	// with resultType boolean).
	NewClusterEnableElasticDisk any

	// User-defined initialization scripts for the new cluster. Type: array of strings (or Expression with resultType array of
	// strings).
	NewClusterInitScripts any

	// Specify a location to deliver Spark driver, worker, and event logs. Type: string (or Expression with resultType string).
	NewClusterLogDestination any

	// The node type of the new job cluster. This property is required if newClusterVersion is specified and instancePoolId is
	// not specified. If instancePoolId is specified, this property is ignored. Type:
	// string (or Expression with resultType string).
	NewClusterNodeType any

	// If not using an existing interactive cluster, this specifies the number of worker nodes to use for the new job cluster
	// or instance pool. For new job clusters, this a string-formatted Int32, like '1'
	// means numOfWorker is 1 or '1:10' means auto-scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted
	// Int32, and can only specify a fixed number of worker nodes, such as '2'.
	// Required if newClusterVersion is specified. Type: string (or Expression with resultType string).
	NewClusterNumOfWorker any

	// A set of optional, user-specified Spark configuration key-value pairs.
	NewClusterSparkConf map[string]any

	// A set of optional, user-specified Spark environment variables key-value pairs.
	NewClusterSparkEnvVars map[string]any

	// If not using an existing interactive cluster, this specifies the Spark version of a new job cluster or instance pool nodes
	// created for each run of this activity. Required if instancePoolId is
	// specified. Type: string (or Expression with resultType string).
	NewClusterVersion any

	// The policy id for limiting the ability to configure clusters based on a user defined set of rules. Type: string (or Expression
	// with resultType string).
	PolicyID any

	// Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
	WorkspaceResourceID any
}

// AzureFileStorageLinkedService - Azure File Storage linked service.
type AzureFileStorageLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure File Storage linked service properties.
	TypeProperties *AzureFileStorageLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureFileStorageLinkedService.
func (a *AzureFileStorageLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureFileStorageLinkedServiceTypeProperties - Azure File Storage linked service properties.
type AzureFileStorageLinkedServiceTypeProperties struct {
	// The Azure key vault secret reference of accountKey in connection string.
	AccountKey *AzureKeyVaultSecretReference

	// The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The azure file share name. It is required when auth with accountKey/sasToken. Type: string (or Expression with resultType
	// string).
	FileShare any

	// Host name of the server. Type: string (or Expression with resultType string).
	Host any

	// Password to logon the server.
	Password SecretBaseClassification

	// The Azure key vault secret reference of sasToken in sas uri.
	SasToken *AzureKeyVaultSecretReference

	// SAS URI of the Azure File resource. It is mutually exclusive with connectionString property. Type: string, SecureString
	// or AzureKeyVaultSecretReference.
	SasURI any

	// The azure file share snapshot version. Type: string (or Expression with resultType string).
	Snapshot any

	// User ID to logon the server. Type: string (or Expression with resultType string).
	UserID any
}

// AzureFileStorageLocation - The location of file server dataset.
type AzureFileStorageLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type AzureFileStorageLocation.
func (a *AzureFileStorageLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: a.AdditionalProperties,
		FileName:             a.FileName,
		FolderPath:           a.FolderPath,
		Type:                 a.Type,
	}
}

// AzureFileStorageReadSettings - Azure File Storage read settings.
type AzureFileStorageReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// The prefix filter for the Azure File name starting from root path. Type: string (or Expression with resultType string).
	Prefix any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Azure File Storage wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// Azure File Storage wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type AzureFileStorageReadSettings.
func (a *AzureFileStorageReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		Type:                     a.Type,
	}
}

// AzureFileStorageWriteSettings - Azure File Storage write settings.
type AzureFileStorageWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The type of copy behavior for copy sink.
	CopyBehavior any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any
}

// GetStoreWriteSettings implements the StoreWriteSettingsClassification interface for type AzureFileStorageWriteSettings.
func (a *AzureFileStorageWriteSettings) GetStoreWriteSettings() *StoreWriteSettings {
	return &StoreWriteSettings{
		AdditionalProperties:     a.AdditionalProperties,
		CopyBehavior:             a.CopyBehavior,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		Type:                     a.Type,
	}
}

// AzureFunctionActivity - Azure Function activity.
type AzureFunctionActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Azure Function activity properties.
	TypeProperties *AzureFunctionActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type AzureFunctionActivity.
func (a *AzureFunctionActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: a.AdditionalProperties,
		DependsOn:            a.DependsOn,
		Description:          a.Description,
		Name:                 a.Name,
		OnInactiveMarkAs:     a.OnInactiveMarkAs,
		State:                a.State,
		Type:                 a.Type,
		UserProperties:       a.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type AzureFunctionActivity.
func (a *AzureFunctionActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: a.AdditionalProperties,
		DependsOn:            a.DependsOn,
		Description:          a.Description,
		LinkedServiceName:    a.LinkedServiceName,
		Name:                 a.Name,
		OnInactiveMarkAs:     a.OnInactiveMarkAs,
		Policy:               a.Policy,
		State:                a.State,
		Type:                 a.Type,
		UserProperties:       a.UserProperties,
	}
}

// AzureFunctionActivityTypeProperties - Azure Function activity type properties.
type AzureFunctionActivityTypeProperties struct {
	// REQUIRED; Name of the Function that the Azure Function Activity will call. Type: string (or Expression with resultType
	// string)
	FunctionName any

	// REQUIRED; Rest API method for target endpoint.
	Method *AzureFunctionActivityMethod

	// Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type:
	// string (or Expression with resultType string).
	Body any

	// Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers"
	// : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type:
	// string (or Expression with resultType string).
	Headers any
}

// AzureFunctionLinkedService - Azure Function linked service.
type AzureFunctionLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Function linked service properties.
	TypeProperties *AzureFunctionLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureFunctionLinkedService.
func (a *AzureFunctionLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureFunctionLinkedServiceTypeProperties - Azure Function linked service properties.
type AzureFunctionLinkedServiceTypeProperties struct {
	// REQUIRED; The endpoint of the Azure Function App. URL will be in the format https://.azurewebsites.net.
	FunctionAppURL any

	// Type of authentication (Required to specify MSI) used to connect to AzureFunction. Type: string (or Expression with resultType
	// string).
	Authentication any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Function or Host key for Azure Function App.
	FunctionKey SecretBaseClassification

	// Allowed token audiences for azure function.
	ResourceID any
}

// AzureKeyVaultLinkedService - Azure Key Vault linked service.
type AzureKeyVaultLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Key Vault linked service properties.
	TypeProperties *AzureKeyVaultLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureKeyVaultLinkedService.
func (a *AzureKeyVaultLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureKeyVaultLinkedServiceTypeProperties - Azure Key Vault linked service properties.
type AzureKeyVaultLinkedServiceTypeProperties struct {
	// REQUIRED; The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type: string (or Expression with resultType
	// string).
	BaseURL any

	// The credential reference containing authentication information.
	Credential *CredentialReference
}

// AzureKeyVaultSecretReference - Azure Key Vault secret reference.
type AzureKeyVaultSecretReference struct {
	// REQUIRED; The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
	SecretName any

	// REQUIRED; The Azure Key Vault linked service reference.
	Store *LinkedServiceReference

	// REQUIRED; Type of the secret.
	Type *string

	// The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression
	// with resultType string).
	SecretVersion any
}

// GetSecretBase implements the SecretBaseClassification interface for type AzureKeyVaultSecretReference.
func (a *AzureKeyVaultSecretReference) GetSecretBase() *SecretBase {
	return &SecretBase{
		Type: a.Type,
	}
}

// AzureMLBatchExecutionActivity - Azure ML Batch Execution activity.
type AzureMLBatchExecutionActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Azure ML Batch Execution activity properties.
	TypeProperties *AzureMLBatchExecutionActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type AzureMLBatchExecutionActivity.
func (a *AzureMLBatchExecutionActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: a.AdditionalProperties,
		DependsOn:            a.DependsOn,
		Description:          a.Description,
		Name:                 a.Name,
		OnInactiveMarkAs:     a.OnInactiveMarkAs,
		State:                a.State,
		Type:                 a.Type,
		UserProperties:       a.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type AzureMLBatchExecutionActivity.
func (a *AzureMLBatchExecutionActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: a.AdditionalProperties,
		DependsOn:            a.DependsOn,
		Description:          a.Description,
		LinkedServiceName:    a.LinkedServiceName,
		Name:                 a.Name,
		OnInactiveMarkAs:     a.OnInactiveMarkAs,
		Policy:               a.Policy,
		State:                a.State,
		Type:                 a.Type,
		UserProperties:       a.UserProperties,
	}
}

// AzureMLBatchExecutionActivityTypeProperties - Azure ML Batch Execution activity properties.
type AzureMLBatchExecutionActivityTypeProperties struct {
	// Key,Value pairs to be passed to the Azure ML Batch Execution Service endpoint. Keys must match the names of web service
	// parameters defined in the published Azure ML web service. Values will be passed
	// in the GlobalParameters property of the Azure ML batch execution request.
	GlobalParameters map[string]any

	// Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Inputs to AzureMLWebServiceFile objects specifying
	// the input Blob locations.. This information will be passed in the
	// WebServiceInputs property of the Azure ML batch execution request.
	WebServiceInputs map[string]*AzureMLWebServiceFile

	// Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Outputs to AzureMLWebServiceFile objects specifying
	// the output Blob locations. This information will be passed in the
	// WebServiceOutputs property of the Azure ML batch execution request.
	WebServiceOutputs map[string]*AzureMLWebServiceFile
}

// AzureMLExecutePipelineActivity - Azure ML Execute Pipeline activity.
type AzureMLExecutePipelineActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Azure ML Execute Pipeline activity properties.
	TypeProperties *AzureMLExecutePipelineActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type AzureMLExecutePipelineActivity.
func (a *AzureMLExecutePipelineActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: a.AdditionalProperties,
		DependsOn:            a.DependsOn,
		Description:          a.Description,
		Name:                 a.Name,
		OnInactiveMarkAs:     a.OnInactiveMarkAs,
		State:                a.State,
		Type:                 a.Type,
		UserProperties:       a.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type AzureMLExecutePipelineActivity.
func (a *AzureMLExecutePipelineActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: a.AdditionalProperties,
		DependsOn:            a.DependsOn,
		Description:          a.Description,
		LinkedServiceName:    a.LinkedServiceName,
		Name:                 a.Name,
		OnInactiveMarkAs:     a.OnInactiveMarkAs,
		Policy:               a.Policy,
		State:                a.State,
		Type:                 a.Type,
		UserProperties:       a.UserProperties,
	}
}

// AzureMLExecutePipelineActivityTypeProperties - Azure ML Execute Pipeline activity properties.
type AzureMLExecutePipelineActivityTypeProperties struct {
	// Whether to continue execution of other steps in the PipelineRun if a step fails. This information will be passed in the
	// continueOnStepFailure property of the published pipeline execution request.
	// Type: boolean (or Expression with resultType boolean).
	ContinueOnStepFailure any

	// Dictionary used for changing data path assignments without retraining. Values will be passed in the dataPathAssignments
	// property of the published pipeline execution request. Type: object with key
	// value pairs (or Expression with resultType object).
	DataPathAssignments any

	// Run history experiment name of the pipeline run. This information will be passed in the ExperimentName property of the
	// published pipeline execution request. Type: string (or Expression with resultType
	// string).
	ExperimentName any

	// The parent Azure ML Service pipeline run id. This information will be passed in the ParentRunId property of the published
	// pipeline execution request. Type: string (or Expression with resultType
	// string).
	MlParentRunID any

	// ID of the published Azure ML pipeline endpoint. Type: string (or Expression with resultType string).
	MlPipelineEndpointID any

	// ID of the published Azure ML pipeline. Type: string (or Expression with resultType string).
	MlPipelineID any

	// Key,Value pairs to be passed to the published Azure ML pipeline endpoint. Keys must match the names of pipeline parameters
	// defined in the published pipeline. Values will be passed in the
	// ParameterAssignments property of the published pipeline execution request. Type: object with key value pairs (or Expression
	// with resultType object).
	MlPipelineParameters any

	// Version of the published Azure ML pipeline endpoint. Type: string (or Expression with resultType string).
	Version any
}

// AzureMLLinkedService - Azure ML Studio Web Service linked service.
type AzureMLLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure ML Studio Web Service linked service properties.
	TypeProperties *AzureMLLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureMLLinkedService.
func (a *AzureMLLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureMLLinkedServiceTypeProperties - Azure ML Studio Web Service linked service properties.
type AzureMLLinkedServiceTypeProperties struct {
	// REQUIRED; The API key for accessing the Azure ML model endpoint.
	APIKey SecretBaseClassification

	// REQUIRED; The Batch Execution REST URL for an Azure ML Studio Web Service endpoint. Type: string (or Expression with resultType
	// string).
	MlEndpoint any

	// Type of authentication (Required to specify MSI) used to connect to AzureML. Type: string (or Expression with resultType
	// string).
	Authentication any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The ID of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML Studio
	// web service. Type: string (or Expression with resultType string).
	ServicePrincipalID any

	// The key of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML Studio
	// web service.
	ServicePrincipalKey SecretBaseClassification

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant any

	// The Update Resource REST URL for an Azure ML Studio Web Service endpoint. Type: string (or Expression with resultType string).
	UpdateResourceEndpoint any
}

// AzureMLServiceLinkedService - Azure ML Service linked service.
type AzureMLServiceLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure ML Service linked service properties.
	TypeProperties *AzureMLServiceLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureMLServiceLinkedService.
func (a *AzureMLServiceLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureMLServiceLinkedServiceTypeProperties - Azure ML Service linked service properties.
type AzureMLServiceLinkedServiceTypeProperties struct {
	// REQUIRED; Azure ML Service workspace name. Type: string (or Expression with resultType string).
	MlWorkspaceName any

	// REQUIRED; Azure ML Service workspace resource group name. Type: string (or Expression with resultType string).
	ResourceGroupName any

	// REQUIRED; Azure ML Service workspace subscription ID. Type: string (or Expression with resultType string).
	SubscriptionID any

	// Type of authentication (Required to specify MSI) used to connect to AzureML. Type: string (or Expression with resultType
	// string).
	Authentication any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The ID of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline. Type:
	// string (or Expression with resultType string).
	ServicePrincipalID any

	// The key of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline.
	ServicePrincipalKey SecretBaseClassification

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant any
}

// AzureMLUpdateResourceActivity - Azure ML Update Resource management activity.
type AzureMLUpdateResourceActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Azure ML Update Resource management activity properties.
	TypeProperties *AzureMLUpdateResourceActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type AzureMLUpdateResourceActivity.
func (a *AzureMLUpdateResourceActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: a.AdditionalProperties,
		DependsOn:            a.DependsOn,
		Description:          a.Description,
		Name:                 a.Name,
		OnInactiveMarkAs:     a.OnInactiveMarkAs,
		State:                a.State,
		Type:                 a.Type,
		UserProperties:       a.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type AzureMLUpdateResourceActivity.
func (a *AzureMLUpdateResourceActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: a.AdditionalProperties,
		DependsOn:            a.DependsOn,
		Description:          a.Description,
		LinkedServiceName:    a.LinkedServiceName,
		Name:                 a.Name,
		OnInactiveMarkAs:     a.OnInactiveMarkAs,
		Policy:               a.Policy,
		State:                a.State,
		Type:                 a.Type,
		UserProperties:       a.UserProperties,
	}
}

// AzureMLUpdateResourceActivityTypeProperties - Azure ML Update Resource activity properties.
type AzureMLUpdateResourceActivityTypeProperties struct {
	// REQUIRED; The relative file path in trainedModelLinkedService to represent the .ilearner file that will be uploaded by
	// the update operation. Type: string (or Expression with resultType string).
	TrainedModelFilePath any

	// REQUIRED; Name of Azure Storage linked service holding the .ilearner file that will be uploaded by the update operation.
	TrainedModelLinkedServiceName *LinkedServiceReference

	// REQUIRED; Name of the Trained Model module in the Web Service experiment to be updated. Type: string (or Expression with
	// resultType string).
	TrainedModelName any
}

// AzureMLWebServiceFile - Azure ML WebService Input/Output file
type AzureMLWebServiceFile struct {
	// REQUIRED; The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type:
	// string (or Expression with resultType string).
	FilePath any

	// REQUIRED; Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
	LinkedServiceName *LinkedServiceReference
}

// AzureMariaDBLinkedService - Azure Database for MariaDB linked service.
type AzureMariaDBLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Database for MariaDB linked service properties.
	TypeProperties *AzureMariaDBLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureMariaDBLinkedService.
func (a *AzureMariaDBLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureMariaDBLinkedServiceTypeProperties - Azure Database for MariaDB linked service properties.
type AzureMariaDBLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Pwd *AzureKeyVaultSecretReference
}

// AzureMariaDBSource - A copy activity Azure MariaDB source.
type AzureMariaDBSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type AzureMariaDBSource.
func (a *AzureMariaDBSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AzureMariaDBSource.
func (a *AzureMariaDBSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        a.AdditionalColumns,
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		QueryTimeout:             a.QueryTimeout,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AzureMariaDBTableDataset - Azure Database for MariaDB dataset.
type AzureMariaDBTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AzureMariaDBTableDataset.
func (a *AzureMariaDBTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzureMySQLLinkedService - Azure MySQL database linked service.
type AzureMySQLLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure MySQL database linked service properties.
	TypeProperties *AzureMySQLLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureMySQLLinkedService.
func (a *AzureMySQLLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureMySQLLinkedServiceTypeProperties - Azure MySQL database linked service properties.
type AzureMySQLLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference
}

// AzureMySQLSink - A copy activity Azure MySql sink.
type AzureMySQLSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to execute before starting the copy. Type: string (or Expression with resultType string).
	PreCopyScript any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type AzureMySQLSink.
func (a *AzureMySQLSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
	}
}

// AzureMySQLSource - A copy activity Azure MySQL source.
type AzureMySQLSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type AzureMySQLSource.
func (a *AzureMySQLSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AzureMySQLSource.
func (a *AzureMySQLSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        a.AdditionalColumns,
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		QueryTimeout:             a.QueryTimeout,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AzureMySQLTableDataset - The Azure MySQL database dataset.
type AzureMySQLTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; Azure MySQL database dataset properties.
	TypeProperties *AzureMySQLTableDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type AzureMySQLTableDataset.
func (a *AzureMySQLTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzureMySQLTableDatasetTypeProperties - Azure MySQL database dataset properties.
type AzureMySQLTableDatasetTypeProperties struct {
	// The name of Azure MySQL database table. Type: string (or Expression with resultType string).
	Table any

	// The Azure MySQL database table name. Type: string (or Expression with resultType string).
	TableName any
}

// AzurePostgreSQLLinkedService - Azure PostgreSQL linked service.
type AzurePostgreSQLLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure PostgreSQL linked service properties.
	TypeProperties *AzurePostgreSQLLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzurePostgreSQLLinkedService.
func (a *AzurePostgreSQLLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzurePostgreSQLLinkedServiceTypeProperties - Azure PostgreSQL linked service properties.
type AzurePostgreSQLLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference
}

// AzurePostgreSQLSink - A copy activity Azure PostgreSQL sink.
type AzurePostgreSQLSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to execute before starting the copy. Type: string (or Expression with resultType string).
	PreCopyScript any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type AzurePostgreSQLSink.
func (a *AzurePostgreSQLSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
	}
}

// AzurePostgreSQLSource - A copy activity Azure PostgreSQL source.
type AzurePostgreSQLSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type AzurePostgreSQLSource.
func (a *AzurePostgreSQLSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AzurePostgreSQLSource.
func (a *AzurePostgreSQLSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        a.AdditionalColumns,
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		QueryTimeout:             a.QueryTimeout,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AzurePostgreSQLTableDataset - Azure PostgreSQL dataset.
type AzurePostgreSQLTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *AzurePostgreSQLTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AzurePostgreSQLTableDataset.
func (a *AzurePostgreSQLTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzurePostgreSQLTableDatasetTypeProperties - Azure PostgreSQL dataset properties.
type AzurePostgreSQLTableDatasetTypeProperties struct {
	// The schema name of the Azure PostgreSQL database. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the Azure PostgreSQL database. Type: string (or Expression with resultType string).
	Table any

	// The table name of the Azure PostgreSQL database which includes both schema and table. Type: string (or Expression with
	// resultType string).
	TableName any
}

// AzureQueueSink - A copy activity Azure Queue sink.
type AzureQueueSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type AzureQueueSink.
func (a *AzureQueueSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
	}
}

// AzureSQLDWLinkedService - Azure SQL Data Warehouse linked service.
type AzureSQLDWLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure SQL Data Warehouse linked service properties.
	TypeProperties *AzureSQLDWLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureSQLDWLinkedService.
func (a *AzureSQLDWLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureSQLDWLinkedServiceTypeProperties - Azure SQL Data Warehouse linked service properties.
type AzureSQLDWLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString
	// or AzureKeyVaultSecretReference.
	ConnectionString any

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference

	// The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with
	// resultType string).
	ServicePrincipalID any

	// The key of the service principal used to authenticate against Azure SQL Data Warehouse.
	ServicePrincipalKey SecretBaseClassification

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant any
}

// AzureSQLDWTableDataset - The Azure SQL Data Warehouse dataset.
type AzureSQLDWTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Azure SQL Data Warehouse dataset properties.
	TypeProperties *AzureSQLDWTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AzureSQLDWTableDataset.
func (a *AzureSQLDWTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzureSQLDWTableDatasetTypeProperties - Azure SQL Data Warehouse dataset properties.
type AzureSQLDWTableDatasetTypeProperties struct {
	// The schema name of the Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// AzureSQLDatabaseLinkedService - Microsoft Azure SQL Database linked service.
type AzureSQLDatabaseLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure SQL Database linked service properties.
	TypeProperties *AzureSQLDatabaseLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureSQLDatabaseLinkedService.
func (a *AzureSQLDatabaseLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureSQLDatabaseLinkedServiceTypeProperties - Azure SQL Database linked service properties.
type AzureSQLDatabaseLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// Sql always encrypted properties.
	AlwaysEncryptedSettings *SQLAlwaysEncryptedProperties

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference

	// The ID of the service principal used to authenticate against Azure SQL Database. Type: string (or Expression with resultType
	// string).
	ServicePrincipalID any

	// The key of the service principal used to authenticate against Azure SQL Database.
	ServicePrincipalKey SecretBaseClassification

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant any
}

// AzureSQLMILinkedService - Azure SQL Managed Instance linked service.
type AzureSQLMILinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure SQL Managed Instance linked service properties.
	TypeProperties *AzureSQLMILinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureSQLMILinkedService.
func (a *AzureSQLMILinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureSQLMILinkedServiceTypeProperties - Azure SQL Managed Instance linked service properties.
type AzureSQLMILinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// Sql always encrypted properties.
	AlwaysEncryptedSettings *SQLAlwaysEncryptedProperties

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference

	// The ID of the service principal used to authenticate against Azure SQL Managed Instance. Type: string (or Expression with
	// resultType string).
	ServicePrincipalID any

	// The key of the service principal used to authenticate against Azure SQL Managed Instance.
	ServicePrincipalKey SecretBaseClassification

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant any
}

// AzureSQLMITableDataset - The Azure SQL Managed Instance dataset.
type AzureSQLMITableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Azure SQL Managed Instance dataset properties.
	TypeProperties *AzureSQLMITableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AzureSQLMITableDataset.
func (a *AzureSQLMITableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzureSQLMITableDatasetTypeProperties - Azure SQL Managed Instance dataset properties.
type AzureSQLMITableDatasetTypeProperties struct {
	// The schema name of the Azure SQL Managed Instance. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the Azure SQL Managed Instance dataset. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// AzureSQLSink - A copy activity Azure SQL sink.
type AzureSQLSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript any

	// SQL writer stored procedure name. Type: string (or Expression with resultType string).
	SQLWriterStoredProcedureName any

	// SQL writer table type. Type: string (or Expression with resultType string).
	SQLWriterTableType any

	// Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
	SQLWriterUseTableLock any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// SQL stored procedure parameters.
	StoredProcedureParameters any

	// The stored procedure parameter name of the table type. Type: string (or Expression with resultType string).
	StoredProcedureTableTypeParameterName any

	// The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression
	// with resultType string).
	TableOption any

	// SQL upsert settings.
	UpsertSettings *SQLUpsertSettings

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// Write behavior when copying data into Azure SQL. Type: SqlWriteBehaviorEnum (or Expression with resultType SqlWriteBehaviorEnum)
	WriteBehavior any
}

// GetCopySink implements the CopySinkClassification interface for type AzureSQLSink.
func (a *AzureSQLSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
	}
}

// AzureSQLSource - A copy activity Azure SQL source.
type AzureSQLSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot.
	// The default value is ReadCommitted. Type: string (or
	// Expression with resultType string).
	IsolationLevel any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "DynamicRange".
	PartitionOption any

	// The settings that will be leveraged for Sql source partitioning.
	PartitionSettings *SQLPartitionSettings

	// Which additional types to produce.
	ProduceAdditionalTypes any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// SQL reader query. Type: string (or Expression with resultType string).
	SQLReaderQuery any

	// Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string
	// (or Expression with resultType string).
	SQLReaderStoredProcedureName any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
	StoredProcedureParameters any
}

// GetCopySource implements the CopySourceClassification interface for type AzureSQLSource.
func (a *AzureSQLSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AzureSQLSource.
func (a *AzureSQLSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        a.AdditionalColumns,
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		QueryTimeout:             a.QueryTimeout,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AzureSQLTableDataset - The Azure SQL Server database dataset.
type AzureSQLTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Azure SQL dataset properties.
	TypeProperties *AzureSQLTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type AzureSQLTableDataset.
func (a *AzureSQLTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzureSQLTableDatasetTypeProperties - Azure SQL dataset properties.
type AzureSQLTableDatasetTypeProperties struct {
	// The schema name of the Azure SQL database. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the Azure SQL database. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// AzureSearchIndexDataset - The Azure Search Index.
type AzureSearchIndexDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; Properties specific to this dataset type.
	TypeProperties *AzureSearchIndexDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type AzureSearchIndexDataset.
func (a *AzureSearchIndexDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzureSearchIndexDatasetTypeProperties - Properties specific to this dataset type.
type AzureSearchIndexDatasetTypeProperties struct {
	// REQUIRED; The name of the Azure Search Index. Type: string (or Expression with resultType string).
	IndexName any
}

// AzureSearchIndexSink - A copy activity Azure Search Index sink.
type AzureSearchIndexSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// Specify the write behavior when upserting documents into Azure Search Index.
	WriteBehavior *AzureSearchIndexWriteBehaviorType
}

// GetCopySink implements the CopySinkClassification interface for type AzureSearchIndexSink.
func (a *AzureSearchIndexSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
	}
}

// AzureSearchLinkedService - Linked service for Windows Azure Search Service.
type AzureSearchLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Windows Azure Search Service linked service properties.
	TypeProperties *AzureSearchLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureSearchLinkedService.
func (a *AzureSearchLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureSearchLinkedServiceTypeProperties - Windows Azure Search Service linked service properties.
type AzureSearchLinkedServiceTypeProperties struct {
	// REQUIRED; URL for Azure Search service. Type: string (or Expression with resultType string).
	URL any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Admin Key for Azure Search service
	Key SecretBaseClassification
}

// AzureStorageLinkedService - The storage account linked service.
type AzureStorageLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Storage linked service properties.
	TypeProperties *AzureStorageLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureStorageLinkedService.
func (a *AzureStorageLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureStorageLinkedServiceTypeProperties - Azure Storage linked service properties.
type AzureStorageLinkedServiceTypeProperties struct {
	// The Azure key vault secret reference of accountKey in connection string.
	AccountKey *AzureKeyVaultSecretReference

	// The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of sasToken in sas uri.
	SasToken *AzureKeyVaultSecretReference

	// SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property. Type: string, SecureString
	// or AzureKeyVaultSecretReference.
	SasURI any
}

// AzureSynapseArtifactsLinkedService - Azure Synapse Analytics (Artifacts) linked service.
type AzureSynapseArtifactsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Synapse Analytics (Artifacts) linked service properties.
	TypeProperties *AzureSynapseArtifactsLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureSynapseArtifactsLinkedService.
func (a *AzureSynapseArtifactsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// AzureSynapseArtifactsLinkedServiceTypeProperties - Azure Synapse Analytics (Artifacts) linked service properties.
type AzureSynapseArtifactsLinkedServiceTypeProperties struct {
	// REQUIRED; https://.dev.azuresynapse.net, Azure Synapse Analytics workspace URL. Type: string (or Expression with resultType
	// string).
	Endpoint any

	// Required to specify MSI, if using system assigned managed identity as authentication method. Type: string (or Expression
	// with resultType string).
	Authentication any

	// The resource ID of the Synapse workspace. The format should be: /subscriptions/{subscriptionID}/resourceGroups/{resourceGroup}/providers/Microsoft.Synapse/workspaces/{workspaceName}.
	// Type: string (or
	// Expression with resultType string).
	WorkspaceResourceID any
}

// AzureTableDataset - The Azure Table storage dataset.
type AzureTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; Azure Table dataset properties.
	TypeProperties *AzureTableDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type AzureTableDataset.
func (a *AzureTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		Description:          a.Description,
		Folder:               a.Folder,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Schema:               a.Schema,
		Structure:            a.Structure,
		Type:                 a.Type,
	}
}

// AzureTableDatasetTypeProperties - Azure Table dataset properties.
type AzureTableDatasetTypeProperties struct {
	// REQUIRED; The table name of the Azure Table storage. Type: string (or Expression with resultType string).
	TableName any
}

// AzureTableSink - A copy activity Azure Table sink.
type AzureTableSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Azure Table default partition key value. Type: string (or Expression with resultType string).
	AzureTableDefaultPartitionKeyValue any

	// Azure Table insert type. Type: string (or Expression with resultType string).
	AzureTableInsertType any

	// Azure Table partition key name. Type: string (or Expression with resultType string).
	AzureTablePartitionKeyName any

	// Azure Table row key name. Type: string (or Expression with resultType string).
	AzureTableRowKeyName any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type AzureTableSink.
func (a *AzureTableSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
	}
}

// AzureTableSource - A copy activity Azure Table source.
type AzureTableSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Azure Table source ignore table not found. Type: boolean (or Expression with resultType boolean).
	AzureTableSourceIgnoreTableNotFound any

	// Azure Table source query. Type: string (or Expression with resultType string).
	AzureTableSourceQuery any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type AzureTableSource.
func (a *AzureTableSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AzureTableSource.
func (a *AzureTableSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        a.AdditionalColumns,
		AdditionalProperties:     a.AdditionalProperties,
		DisableMetricsCollection: a.DisableMetricsCollection,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		QueryTimeout:             a.QueryTimeout,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		Type:                     a.Type,
	}
}

// AzureTableStorageLinkedService - The azure table storage linked service.
type AzureTableStorageLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Azure Table Storage linked service properties.
	TypeProperties *AzureStorageLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureTableStorageLinkedService.
func (a *AzureTableStorageLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: a.AdditionalProperties,
		Annotations:          a.Annotations,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Type:                 a.Type,
	}
}

// BigDataPoolParametrizationReference - Big data pool reference type.
type BigDataPoolParametrizationReference struct {
	// REQUIRED; Reference big data pool name. Type: string (or Expression with resultType string).
	ReferenceName any

	// REQUIRED; Big data pool reference type.
	Type *BigDataPoolReferenceType
}

// BinaryDataset - Binary dataset.
type BinaryDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Binary dataset properties.
	TypeProperties *BinaryDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type BinaryDataset.
func (b *BinaryDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: b.AdditionalProperties,
		Annotations:          b.Annotations,
		Description:          b.Description,
		Folder:               b.Folder,
		LinkedServiceName:    b.LinkedServiceName,
		Parameters:           b.Parameters,
		Schema:               b.Schema,
		Structure:            b.Structure,
		Type:                 b.Type,
	}
}

// BinaryDatasetTypeProperties - Binary dataset properties.
type BinaryDatasetTypeProperties struct {
	// REQUIRED; The location of the Binary storage.
	Location DatasetLocationClassification

	// The data compression method used for the binary dataset.
	Compression *DatasetCompression
}

// BinaryReadSettings - Binary read settings.
type BinaryReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Compression settings.
	CompressionProperties CompressionReadSettingsClassification
}

// GetFormatReadSettings implements the FormatReadSettingsClassification interface for type BinaryReadSettings.
func (b *BinaryReadSettings) GetFormatReadSettings() *FormatReadSettings {
	return &FormatReadSettings{
		AdditionalProperties: b.AdditionalProperties,
		Type:                 b.Type,
	}
}

// BinarySink - A copy activity Binary sink.
type BinarySink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Binary store settings.
	StoreSettings StoreWriteSettingsClassification

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type BinarySink.
func (b *BinarySink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     b.AdditionalProperties,
		DisableMetricsCollection: b.DisableMetricsCollection,
		MaxConcurrentConnections: b.MaxConcurrentConnections,
		SinkRetryCount:           b.SinkRetryCount,
		SinkRetryWait:            b.SinkRetryWait,
		Type:                     b.Type,
		WriteBatchSize:           b.WriteBatchSize,
		WriteBatchTimeout:        b.WriteBatchTimeout,
	}
}

// BinarySource - A copy activity Binary source.
type BinarySource struct {
	// REQUIRED; Copy source type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Binary format settings.
	FormatSettings *BinaryReadSettings

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Binary store settings.
	StoreSettings StoreReadSettingsClassification
}

// GetCopySource implements the CopySourceClassification interface for type BinarySource.
func (b *BinarySource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     b.AdditionalProperties,
		DisableMetricsCollection: b.DisableMetricsCollection,
		MaxConcurrentConnections: b.MaxConcurrentConnections,
		SourceRetryCount:         b.SourceRetryCount,
		SourceRetryWait:          b.SourceRetryWait,
		Type:                     b.Type,
	}
}

// BlobEventsTrigger - Trigger that runs every time a Blob event occurs.
type BlobEventsTrigger struct {
	// REQUIRED; Trigger type.
	Type *string

	// REQUIRED; Blob Events Trigger properties.
	TypeProperties *BlobEventsTriggerTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the trigger.
	Annotations []any

	// Trigger description.
	Description *string

	// Pipelines that need to be started.
	Pipelines []*TriggerPipelineReference

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState
}

// GetMultiplePipelineTrigger implements the MultiplePipelineTriggerClassification interface for type BlobEventsTrigger.
func (b *BlobEventsTrigger) GetMultiplePipelineTrigger() *MultiplePipelineTrigger {
	return &MultiplePipelineTrigger{
		AdditionalProperties: b.AdditionalProperties,
		Annotations:          b.Annotations,
		Description:          b.Description,
		Pipelines:            b.Pipelines,
		RuntimeState:         b.RuntimeState,
		Type:                 b.Type,
	}
}

// GetTrigger implements the TriggerClassification interface for type BlobEventsTrigger.
func (b *BlobEventsTrigger) GetTrigger() *Trigger {
	return &Trigger{
		AdditionalProperties: b.AdditionalProperties,
		Annotations:          b.Annotations,
		Description:          b.Description,
		RuntimeState:         b.RuntimeState,
		Type:                 b.Type,
	}
}

// BlobEventsTriggerTypeProperties - Blob Events Trigger properties.
type BlobEventsTriggerTypeProperties struct {
	// REQUIRED; The type of events that cause this trigger to fire.
	Events []*BlobEventTypes

	// REQUIRED; The ARM resource ID of the Storage Account.
	Scope *string

	// The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only
	// fire the trigger for blobs in the december folder under the records container.
	// At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
	BlobPathBeginsWith *string

	// The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire
	// the trigger for blobs named boxes in a december folder. At least one of these
	// must be provided: blobPathBeginsWith, blobPathEndsWith.
	BlobPathEndsWith *string

	// If set to true, blobs with zero bytes will be ignored.
	IgnoreEmptyBlobs *bool
}

// BlobSink - A copy activity Azure Blob sink.
type BlobSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Blob writer add header. Type: boolean (or Expression with resultType boolean).
	BlobWriterAddHeader any

	// Blob writer date time format. Type: string (or Expression with resultType string).
	BlobWriterDateTimeFormat any

	// Blob writer overwrite files. Type: boolean (or Expression with resultType boolean).
	BlobWriterOverwriteFiles any

	// The type of copy behavior for copy sink.
	CopyBehavior any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
	Metadata []*MetadataItem

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type BlobSink.
func (b *BlobSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     b.AdditionalProperties,
		DisableMetricsCollection: b.DisableMetricsCollection,
		MaxConcurrentConnections: b.MaxConcurrentConnections,
		SinkRetryCount:           b.SinkRetryCount,
		SinkRetryWait:            b.SinkRetryWait,
		Type:                     b.Type,
		WriteBatchSize:           b.WriteBatchSize,
		WriteBatchTimeout:        b.WriteBatchTimeout,
	}
}

// BlobSource - A copy activity Azure Blob source.
type BlobSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
	SkipHeaderLineCount any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Treat empty as null. Type: boolean (or Expression with resultType boolean).
	TreatEmptyAsNull any
}

// GetCopySource implements the CopySourceClassification interface for type BlobSource.
func (b *BlobSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     b.AdditionalProperties,
		DisableMetricsCollection: b.DisableMetricsCollection,
		MaxConcurrentConnections: b.MaxConcurrentConnections,
		SourceRetryCount:         b.SourceRetryCount,
		SourceRetryWait:          b.SourceRetryWait,
		Type:                     b.Type,
	}
}

// BlobTrigger - Trigger that runs every time the selected Blob container changes.
type BlobTrigger struct {
	// REQUIRED; Trigger type.
	Type *string

	// REQUIRED; Blob Trigger properties.
	TypeProperties *BlobTriggerTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the trigger.
	Annotations []any

	// Trigger description.
	Description *string

	// Pipelines that need to be started.
	Pipelines []*TriggerPipelineReference

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState
}

// GetMultiplePipelineTrigger implements the MultiplePipelineTriggerClassification interface for type BlobTrigger.
func (b *BlobTrigger) GetMultiplePipelineTrigger() *MultiplePipelineTrigger {
	return &MultiplePipelineTrigger{
		AdditionalProperties: b.AdditionalProperties,
		Annotations:          b.Annotations,
		Description:          b.Description,
		Pipelines:            b.Pipelines,
		RuntimeState:         b.RuntimeState,
		Type:                 b.Type,
	}
}

// GetTrigger implements the TriggerClassification interface for type BlobTrigger.
func (b *BlobTrigger) GetTrigger() *Trigger {
	return &Trigger{
		AdditionalProperties: b.AdditionalProperties,
		Annotations:          b.Annotations,
		Description:          b.Description,
		RuntimeState:         b.RuntimeState,
		Type:                 b.Type,
	}
}

// BlobTriggerTypeProperties - Blob Trigger properties.
type BlobTriggerTypeProperties struct {
	// REQUIRED; The path of the container/folder that will trigger the pipeline.
	FolderPath *string

	// REQUIRED; The Azure Storage linked service reference.
	LinkedService *LinkedServiceReference

	// REQUIRED; The max number of parallel files to handle when it is triggered.
	MaxConcurrency *int32
}

// CMKIdentityDefinition - Managed Identity used for CMK.
type CMKIdentityDefinition struct {
	// The resource id of the user assigned identity to authenticate to customer's key vault.
	UserAssignedIdentity *string
}

// CassandraLinkedService - Linked service for Cassandra data source.
type CassandraLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Cassandra linked service properties.
	TypeProperties *CassandraLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type CassandraLinkedService.
func (c *CassandraLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Type:                 c.Type,
	}
}

// CassandraLinkedServiceTypeProperties - Cassandra linked service properties.
type CassandraLinkedServiceTypeProperties struct {
	// REQUIRED; Host name for connection. Type: string (or Expression with resultType string).
	Host any

	// AuthenticationType to be used for connection. Type: string (or Expression with resultType string).
	AuthenticationType any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Password for authentication.
	Password SecretBaseClassification

	// The port for the connection. Type: integer (or Expression with resultType integer).
	Port any

	// Username for authentication. Type: string (or Expression with resultType string).
	Username any
}

// CassandraSource - A copy activity source for a Cassandra database.
type CassandraSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The consistency level specifies how many Cassandra servers must respond to a read request before returning data to the
	// client application. Cassandra checks the specified number of Cassandra servers
	// for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'.
	// It is case-insensitive.
	ConsistencyLevel *CassandraSourceReadConsistencyLevels

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Should be a SQL-92 query expression or Cassandra Query Language (CQL) command. Type: string (or Expression
	// with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type CassandraSource.
func (c *CassandraSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     c.AdditionalProperties,
		DisableMetricsCollection: c.DisableMetricsCollection,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		Type:                     c.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type CassandraSource.
func (c *CassandraSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        c.AdditionalColumns,
		AdditionalProperties:     c.AdditionalProperties,
		DisableMetricsCollection: c.DisableMetricsCollection,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		QueryTimeout:             c.QueryTimeout,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		Type:                     c.Type,
	}
}

// CassandraTableDataset - The Cassandra database dataset.
type CassandraTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Cassandra dataset properties.
	TypeProperties *CassandraTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type CassandraTableDataset.
func (c *CassandraTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		Description:          c.Description,
		Folder:               c.Folder,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Schema:               c.Schema,
		Structure:            c.Structure,
		Type:                 c.Type,
	}
}

// CassandraTableDatasetTypeProperties - Cassandra dataset properties.
type CassandraTableDatasetTypeProperties struct {
	// The keyspace of the Cassandra database. Type: string (or Expression with resultType string).
	Keyspace any

	// The table name of the Cassandra database. Type: string (or Expression with resultType string).
	TableName any
}

// ChainingTrigger - Trigger that allows the referenced pipeline to depend on other pipeline runs based on runDimension Name/Value
// pairs. Upstream pipelines should declare the same runDimension Name and their runs should
// have the values for those runDimensions. The referenced pipeline run would be triggered if the values for the runDimension
// match for all upstream pipeline runs.
type ChainingTrigger struct {
	// REQUIRED; Pipeline for which runs are created when all upstream pipelines complete successfully.
	Pipeline *TriggerPipelineReference

	// REQUIRED; Trigger type.
	Type *string

	// REQUIRED; Chaining Trigger properties.
	TypeProperties *ChainingTriggerTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the trigger.
	Annotations []any

	// Trigger description.
	Description *string

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState
}

// GetTrigger implements the TriggerClassification interface for type ChainingTrigger.
func (c *ChainingTrigger) GetTrigger() *Trigger {
	return &Trigger{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		Description:          c.Description,
		RuntimeState:         c.RuntimeState,
		Type:                 c.Type,
	}
}

// ChainingTriggerTypeProperties - Chaining Trigger properties.
type ChainingTriggerTypeProperties struct {
	// REQUIRED; Upstream Pipelines.
	DependsOn []*PipelineReference

	// REQUIRED; Run Dimension property that needs to be emitted by upstream pipelines.
	RunDimension *string
}

// ChangeDataCapture - A Azure Data Factory object which automatically detects data changes at the source and then sends the
// updated data to the destination.
type ChangeDataCapture struct {
	// REQUIRED; CDC policy
	Policy *MapperPolicy

	// REQUIRED; List of sources connections that can be used as sources in the CDC.
	SourceConnectionsInfo []*MapperSourceConnectionsInfo

	// REQUIRED; List of target connections that can be used as sources in the CDC.
	TargetConnectionsInfo []*MapperTargetConnectionsInfo

	// A boolean to determine if the vnet configuration needs to be overwritten.
	AllowVNetOverride *bool

	// The description of the change data capture.
	Description *string

	// The folder that this CDC is in. If not specified, CDC will appear at the root level.
	Folder *ChangeDataCaptureFolder

	// Status of the CDC as to if it is running or stopped.
	Status *string
}

// ChangeDataCaptureFolder - The folder that this CDC is in. If not specified, CDC will appear at the root level.
type ChangeDataCaptureFolder struct {
	// The name of the folder that this CDC is in.
	Name *string
}

// ChangeDataCaptureListResponse - A list of change data capture resources.
type ChangeDataCaptureListResponse struct {
	// REQUIRED; Lists all resources of type change data capture.
	Value []*ChangeDataCaptureResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// ChangeDataCaptureResource - Change data capture resource type.
type ChangeDataCaptureResource struct {
	// REQUIRED; Properties of the change data capture.
	Properties *ChangeDataCapture

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// CmdkeySetup - The custom setup of running cmdkey commands.
type CmdkeySetup struct {
	// REQUIRED; The type of custom setup.
	Type *string

	// REQUIRED; Cmdkey command custom setup type properties.
	TypeProperties *CmdkeySetupTypeProperties
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type CmdkeySetup.
func (c *CmdkeySetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: c.Type,
	}
}

// CmdkeySetupTypeProperties - Cmdkey command custom setup type properties.
type CmdkeySetupTypeProperties struct {
	// REQUIRED; The password of data source access.
	Password SecretBaseClassification

	// REQUIRED; The server name of data source access.
	TargetName any

	// REQUIRED; The user name of data source access.
	UserName any
}

// CommonDataServiceForAppsEntityDataset - The Common Data Service for Apps entity dataset.
type CommonDataServiceForAppsEntityDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Common Data Service for Apps entity dataset properties.
	TypeProperties *CommonDataServiceForAppsEntityDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type CommonDataServiceForAppsEntityDataset.
func (c *CommonDataServiceForAppsEntityDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		Description:          c.Description,
		Folder:               c.Folder,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Schema:               c.Schema,
		Structure:            c.Structure,
		Type:                 c.Type,
	}
}

// CommonDataServiceForAppsEntityDatasetTypeProperties - Common Data Service for Apps entity dataset properties.
type CommonDataServiceForAppsEntityDatasetTypeProperties struct {
	// The logical name of the entity. Type: string (or Expression with resultType string).
	EntityName any
}

// CommonDataServiceForAppsLinkedService - Common Data Service for Apps linked service.
type CommonDataServiceForAppsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Common Data Service for Apps linked service properties.
	TypeProperties *CommonDataServiceForAppsLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type CommonDataServiceForAppsLinkedService.
func (c *CommonDataServiceForAppsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Type:                 c.Type,
	}
}

// CommonDataServiceForAppsLinkedServiceTypeProperties - Common Data Service for Apps linked service properties.
type CommonDataServiceForAppsLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication type to connect to Common Data Service for Apps server. 'Office365' for online scenario, 'Ifd'
	// for on-premises with Ifd scenario. 'AADServicePrincipal' for Server-To-Server
	// authentication in online scenario. Type: string (or Expression with resultType string).
	AuthenticationType any

	// REQUIRED; The deployment type of the Common Data Service for Apps instance. 'Online' for Common Data Service for Apps Online
	// and 'OnPremisesWithIfd' for Common Data Service for Apps on-premises with Ifd. Type:
	// string (or Expression with resultType string).
	DeploymentType any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The host name of the on-premises Common Data Service for Apps server. The property is required for on-prem and not allowed
	// for online. Type: string (or Expression with resultType string).
	HostName any

	// The organization name of the Common Data Service for Apps instance. The property is required for on-prem and required for
	// online when there are more than one Common Data Service for Apps instances
	// associated with the user. Type: string (or Expression with resultType string).
	OrganizationName any

	// Password to access the Common Data Service for Apps instance.
	Password SecretBaseClassification

	// The port of on-premises Common Data Service for Apps server. The property is required for on-prem and not allowed for online.
	// Default is 443. Type: integer (or Expression with resultType integer),
	// minimum: 0.
	Port any

	// The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
	// servicePrincipalCredential can be SecureString or
	// AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can
	// only be AzureKeyVaultSecretReference.
	ServicePrincipalCredential SecretBaseClassification

	// The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret,
	// 'ServicePrincipalCert' for certificate. Type: string (or Expression with
	// resultType string).
	ServicePrincipalCredentialType any

	// The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID any

	// The URL to the Microsoft Common Data Service for Apps server. The property is required for on-line and not allowed for
	// on-prem. Type: string (or Expression with resultType string).
	ServiceURI any

	// User name to access the Common Data Service for Apps instance. Type: string (or Expression with resultType string).
	Username any
}

// CommonDataServiceForAppsSink - A copy activity Common Data Service for Apps sink.
type CommonDataServiceForAppsSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// REQUIRED; The write behavior for the operation.
	WriteBehavior *DynamicsSinkWriteBehavior

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The logical name of the alternate key which will be used when upserting records. Type: string (or Expression with resultType
	// string).
	AlternateKeyName any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The flag indicating whether to ignore null values from input dataset (except key fields) during write operation. Default
	// is false. Type: boolean (or Expression with resultType boolean).
	IgnoreNullValues any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type CommonDataServiceForAppsSink.
func (c *CommonDataServiceForAppsSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     c.AdditionalProperties,
		DisableMetricsCollection: c.DisableMetricsCollection,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		SinkRetryCount:           c.SinkRetryCount,
		SinkRetryWait:            c.SinkRetryWait,
		Type:                     c.Type,
		WriteBatchSize:           c.WriteBatchSize,
		WriteBatchTimeout:        c.WriteBatchTimeout,
	}
}

// CommonDataServiceForAppsSource - A copy activity Common Data Service for Apps source.
type CommonDataServiceForAppsSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// FetchXML is a proprietary query language that is used in Microsoft Common Data Service for Apps (online & on-premises).
	// Type: string (or Expression with resultType string).
	Query any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type CommonDataServiceForAppsSource.
func (c *CommonDataServiceForAppsSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     c.AdditionalProperties,
		DisableMetricsCollection: c.DisableMetricsCollection,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		Type:                     c.Type,
	}
}

// ComponentSetup - The custom setup of installing 3rd party components.
type ComponentSetup struct {
	// REQUIRED; The type of custom setup.
	Type *string

	// REQUIRED; Install 3rd party component type properties.
	TypeProperties *LicensedComponentSetupTypeProperties
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type ComponentSetup.
func (c *ComponentSetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: c.Type,
	}
}

// CompressionReadSettings - Compression read settings.
type CompressionReadSettings struct {
	// REQUIRED; The Compression setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
}

// GetCompressionReadSettings implements the CompressionReadSettingsClassification interface for type CompressionReadSettings.
func (c *CompressionReadSettings) GetCompressionReadSettings() *CompressionReadSettings { return c }

// ConcurLinkedService - Concur Service linked service.
type ConcurLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Concur Service linked service properties.
	TypeProperties *ConcurLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type ConcurLinkedService.
func (c *ConcurLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Type:                 c.Type,
	}
}

// ConcurLinkedServiceTypeProperties - Concur Service linked service properties.
type ConcurLinkedServiceTypeProperties struct {
	// REQUIRED; Application client_id supplied by Concur App Management.
	ClientID any

	// REQUIRED; The user name that you use to access Concur Service.
	Username any

	// Properties used to connect to Concur. It is mutually exclusive with any other properties in the linked service. Type: object.
	ConnectionProperties any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The password corresponding to the user name that you provided in the username field.
	Password SecretBaseClassification

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification any
}

// ConcurObjectDataset - Concur Service dataset.
type ConcurObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type ConcurObjectDataset.
func (c *ConcurObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		Description:          c.Description,
		Folder:               c.Folder,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Schema:               c.Schema,
		Structure:            c.Structure,
		Type:                 c.Type,
	}
}

// ConcurSource - A copy activity Concur Service source.
type ConcurSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type ConcurSource.
func (c *ConcurSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     c.AdditionalProperties,
		DisableMetricsCollection: c.DisableMetricsCollection,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		Type:                     c.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type ConcurSource.
func (c *ConcurSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        c.AdditionalColumns,
		AdditionalProperties:     c.AdditionalProperties,
		DisableMetricsCollection: c.DisableMetricsCollection,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		QueryTimeout:             c.QueryTimeout,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		Type:                     c.Type,
	}
}

// ConnectionStateProperties - The connection state of a managed private endpoint
type ConnectionStateProperties struct {
	// READ-ONLY; The actions required on the managed private endpoint
	ActionsRequired *string

	// READ-ONLY; The managed private endpoint description
	Description *string

	// READ-ONLY; The approval status
	Status *string
}

// ControlActivity - Base class for all control activities like IfCondition, ForEach , Until.
type ControlActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type ControlActivity.
func (c *ControlActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: c.AdditionalProperties,
		DependsOn:            c.DependsOn,
		Description:          c.Description,
		Name:                 c.Name,
		OnInactiveMarkAs:     c.OnInactiveMarkAs,
		State:                c.State,
		Type:                 c.Type,
		UserProperties:       c.UserProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type ControlActivity.
func (c *ControlActivity) GetControlActivity() *ControlActivity { return c }

// CopyActivity - Copy activity.
type CopyActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Copy activity properties.
	TypeProperties *CopyActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// List of inputs for the activity.
	Inputs []*DatasetReference

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// List of outputs for the activity.
	Outputs []*DatasetReference

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type CopyActivity.
func (c *CopyActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: c.AdditionalProperties,
		DependsOn:            c.DependsOn,
		Description:          c.Description,
		Name:                 c.Name,
		OnInactiveMarkAs:     c.OnInactiveMarkAs,
		State:                c.State,
		Type:                 c.Type,
		UserProperties:       c.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type CopyActivity.
func (c *CopyActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: c.AdditionalProperties,
		DependsOn:            c.DependsOn,
		Description:          c.Description,
		LinkedServiceName:    c.LinkedServiceName,
		Name:                 c.Name,
		OnInactiveMarkAs:     c.OnInactiveMarkAs,
		Policy:               c.Policy,
		State:                c.State,
		Type:                 c.Type,
		UserProperties:       c.UserProperties,
	}
}

// CopyActivityLogSettings - Settings for copy activity log.
type CopyActivityLogSettings struct {
	// Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean).
	EnableReliableLogging any

	// Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string).
	LogLevel any
}

// CopyActivityTypeProperties - Copy activity properties.
type CopyActivityTypeProperties struct {
	// REQUIRED; Copy activity sink.
	Sink CopySinkClassification

	// REQUIRED; Copy activity source.
	Source CopySourceClassification

	// Maximum number of data integration units that can be used to perform this data movement. Type: integer (or Expression with
	// resultType integer), minimum: 0.
	DataIntegrationUnits any

	// Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean).
	EnableSkipIncompatibleRow any

	// Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType
	// boolean).
	EnableStaging any

	// Log settings customer needs provide when enabling log.
	LogSettings *LogSettings

	// (Deprecated. Please use LogSettings) Log storage settings customer need to provide when enabling session log.
	LogStorageSettings *LogStorageSettings

	// Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or
	// Expression with resultType integer), minimum: 0.
	ParallelCopies any

	// Preserve rules.
	Preserve []any

	// Preserve Rules.
	PreserveRules []any

	// Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
	RedirectIncompatibleRowSettings *RedirectIncompatibleRowSettings

	// Specify the fault tolerance for data consistency.
	SkipErrorFile *SkipErrorFile

	// Specifies interim staging settings when EnableStaging is true.
	StagingSettings *StagingSettings

	// Copy activity translator. If not specified, tabular translator is used.
	Translator any

	// Whether to enable Data Consistency validation. Type: boolean (or Expression with resultType boolean).
	ValidateDataConsistency any
}

// CopyComputeScaleProperties - CopyComputeScale properties for managed integration runtime.
type CopyComputeScaleProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// DIU number setting reserved for copy activity execution. Supported values are multiples of 4 in range 4-256.
	DataIntegrationUnit *int32

	// Time to live (in minutes) setting of integration runtime which will execute copy activity.
	TimeToLive *int32
}

// CopySink - A copy activity sink.
type CopySink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type CopySink.
func (c *CopySink) GetCopySink() *CopySink { return c }

// CopySource - A copy activity source.
type CopySource struct {
	// REQUIRED; Copy source type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type CopySource.
func (c *CopySource) GetCopySource() *CopySource { return c }

// CosmosDbLinkedService - Microsoft Azure Cosmos Database (CosmosDB) linked service.
type CosmosDbLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; CosmosDB linked service properties.
	TypeProperties *CosmosDbLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type CosmosDbLinkedService.
func (c *CosmosDbLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Type:                 c.Type,
	}
}

// CosmosDbLinkedServiceTypeProperties - CosmosDB linked service properties.
type CosmosDbLinkedServiceTypeProperties struct {
	// The endpoint of the Azure CosmosDB account. Type: string (or Expression with resultType string)
	AccountEndpoint any

	// The account key of the Azure CosmosDB account. Type: SecureString or AzureKeyVaultSecretReference.
	AccountKey SecretBaseClassification

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType any

	// The connection mode used to access CosmosDB account. Type: string.
	ConnectionMode *CosmosDbConnectionMode

	// The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The name of the database. Type: string (or Expression with resultType string)
	Database any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
	// servicePrincipalCredential can be SecureString or
	// AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can
	// only be AzureKeyVaultSecretReference.
	ServicePrincipalCredential SecretBaseClassification

	// The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret,
	// 'ServicePrincipalCert' for certificate. Type: string.
	ServicePrincipalCredentialType any

	// The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID any

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant any
}

// CosmosDbMongoDbAPICollectionDataset - The CosmosDB (MongoDB API) database dataset.
type CosmosDbMongoDbAPICollectionDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; CosmosDB (MongoDB API) database dataset properties.
	TypeProperties *CosmosDbMongoDbAPICollectionDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type CosmosDbMongoDbAPICollectionDataset.
func (c *CosmosDbMongoDbAPICollectionDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		Description:          c.Description,
		Folder:               c.Folder,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Schema:               c.Schema,
		Structure:            c.Structure,
		Type:                 c.Type,
	}
}

// CosmosDbMongoDbAPICollectionDatasetTypeProperties - CosmosDB (MongoDB API) database dataset properties.
type CosmosDbMongoDbAPICollectionDatasetTypeProperties struct {
	// REQUIRED; The collection name of the CosmosDB (MongoDB API) database. Type: string (or Expression with resultType string).
	Collection any
}

// CosmosDbMongoDbAPILinkedService - Linked service for CosmosDB (MongoDB API) data source.
type CosmosDbMongoDbAPILinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; CosmosDB (MongoDB API) linked service properties.
	TypeProperties *CosmosDbMongoDbAPILinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type CosmosDbMongoDbAPILinkedService.
func (c *CosmosDbMongoDbAPILinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Type:                 c.Type,
	}
}

// CosmosDbMongoDbAPILinkedServiceTypeProperties - CosmosDB (MongoDB API) linked service properties.
type CosmosDbMongoDbAPILinkedServiceTypeProperties struct {
	// REQUIRED; The CosmosDB (MongoDB API) connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type:
	// string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// REQUIRED; The name of the CosmosDB (MongoDB API) database that you want to access. Type: string (or Expression with resultType
	// string).
	Database any

	// Whether the CosmosDB (MongoDB API) server version is higher than 3.2. The default value is false. Type: boolean (or Expression
	// with resultType boolean).
	IsServerVersionAbove32 any
}

// CosmosDbMongoDbAPISink - A copy activity sink for a CosmosDB (MongoDB API) database.
type CosmosDbMongoDbAPISink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// Specifies whether the document with same key to be overwritten (upsert) rather than throw exception (insert). The default
	// value is "insert". Type: string (or Expression with resultType string). Type:
	// string (or Expression with resultType string).
	WriteBehavior any
}

// GetCopySink implements the CopySinkClassification interface for type CosmosDbMongoDbAPISink.
func (c *CosmosDbMongoDbAPISink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     c.AdditionalProperties,
		DisableMetricsCollection: c.DisableMetricsCollection,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		SinkRetryCount:           c.SinkRetryCount,
		SinkRetryWait:            c.SinkRetryWait,
		Type:                     c.Type,
		WriteBatchSize:           c.WriteBatchSize,
		WriteBatchTimeout:        c.WriteBatchTimeout,
	}
}

// CosmosDbMongoDbAPISource - A copy activity source for a CosmosDB (MongoDB API) database.
type CosmosDbMongoDbAPISource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specifies the number of documents to return in each batch of the response from MongoDB instance. In most cases, modifying
	// the batch size will not affect the user or the application. This property's
	// main purpose is to avoid hit the limitation of response size. Type: integer (or Expression with resultType integer).
	BatchSize any

	// Cursor methods for Mongodb query.
	CursorMethods *MongoDbCursorMethodsProperties

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies selection filter using query operators. To return all documents in a collection, omit this parameter or pass
	// an empty document ({}). Type: string (or Expression with resultType string).
	Filter any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type CosmosDbMongoDbAPISource.
func (c *CosmosDbMongoDbAPISource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     c.AdditionalProperties,
		DisableMetricsCollection: c.DisableMetricsCollection,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		Type:                     c.Type,
	}
}

// CosmosDbSQLAPICollectionDataset - Microsoft Azure CosmosDB (SQL API) Collection dataset.
type CosmosDbSQLAPICollectionDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; CosmosDB (SQL API) Collection dataset properties.
	TypeProperties *CosmosDbSQLAPICollectionDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type CosmosDbSQLAPICollectionDataset.
func (c *CosmosDbSQLAPICollectionDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		Description:          c.Description,
		Folder:               c.Folder,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Schema:               c.Schema,
		Structure:            c.Structure,
		Type:                 c.Type,
	}
}

// CosmosDbSQLAPICollectionDatasetTypeProperties - CosmosDB (SQL API) Collection dataset properties.
type CosmosDbSQLAPICollectionDatasetTypeProperties struct {
	// REQUIRED; CosmosDB (SQL API) collection name. Type: string (or Expression with resultType string).
	CollectionName any
}

// CosmosDbSQLAPISink - A copy activity Azure CosmosDB (SQL API) Collection sink.
type CosmosDbSQLAPISink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// Describes how to write data to Azure Cosmos DB. Type: string (or Expression with resultType string). Allowed values: insert
	// and upsert.
	WriteBehavior any
}

// GetCopySink implements the CopySinkClassification interface for type CosmosDbSQLAPISink.
func (c *CosmosDbSQLAPISink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     c.AdditionalProperties,
		DisableMetricsCollection: c.DisableMetricsCollection,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		SinkRetryCount:           c.SinkRetryCount,
		SinkRetryWait:            c.SinkRetryWait,
		Type:                     c.Type,
		WriteBatchSize:           c.WriteBatchSize,
		WriteBatchTimeout:        c.WriteBatchTimeout,
	}
}

// CosmosDbSQLAPISource - A copy activity Azure CosmosDB (SQL API) Collection source.
type CosmosDbSQLAPISource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Whether detect primitive values as datetime values. Type: boolean (or Expression with resultType boolean).
	DetectDatetime any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Page size of the result. Type: integer (or Expression with resultType integer).
	PageSize any

	// Preferred regions. Type: array of strings (or Expression with resultType array of strings).
	PreferredRegions any

	// SQL API query. Type: string (or Expression with resultType string).
	Query any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type CosmosDbSQLAPISource.
func (c *CosmosDbSQLAPISource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     c.AdditionalProperties,
		DisableMetricsCollection: c.DisableMetricsCollection,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		Type:                     c.Type,
	}
}

// CouchbaseLinkedService - Couchbase server linked service.
type CouchbaseLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Couchbase server linked service properties.
	TypeProperties *CouchbaseLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type CouchbaseLinkedService.
func (c *CouchbaseLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Type:                 c.Type,
	}
}

// CouchbaseLinkedServiceTypeProperties - Couchbase server linked service properties.
type CouchbaseLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The Azure key vault secret reference of credString in connection string.
	CredString *AzureKeyVaultSecretReference

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string
}

// CouchbaseSource - A copy activity Couchbase server source.
type CouchbaseSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type CouchbaseSource.
func (c *CouchbaseSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     c.AdditionalProperties,
		DisableMetricsCollection: c.DisableMetricsCollection,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		Type:                     c.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type CouchbaseSource.
func (c *CouchbaseSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        c.AdditionalColumns,
		AdditionalProperties:     c.AdditionalProperties,
		DisableMetricsCollection: c.DisableMetricsCollection,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		QueryTimeout:             c.QueryTimeout,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		Type:                     c.Type,
	}
}

// CouchbaseTableDataset - Couchbase server dataset.
type CouchbaseTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type CouchbaseTableDataset.
func (c *CouchbaseTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		Description:          c.Description,
		Folder:               c.Folder,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Schema:               c.Schema,
		Structure:            c.Structure,
		Type:                 c.Type,
	}
}

// CreateDataFlowDebugSessionRequest - Request body structure for creating data flow debug session.
type CreateDataFlowDebugSessionRequest struct {
	// Compute type of the cluster. The value will be overwritten by the same setting in integration runtime if provided.
	ComputeType *string

	// Core count of the cluster. The value will be overwritten by the same setting in integration runtime if provided.
	CoreCount *int32

	// Set to use integration runtime setting for data flow debug session.
	IntegrationRuntime *IntegrationRuntimeDebugResource

	// Time to live setting of the cluster in minutes.
	TimeToLive *int32
}

// CreateDataFlowDebugSessionResponse - Response body structure for creating data flow debug session.
type CreateDataFlowDebugSessionResponse struct {
	// The ID of data flow debug session.
	SessionID *string

	// The state of the debug session.
	Status *string
}

// CreateLinkedIntegrationRuntimeRequest - The linked integration runtime information.
type CreateLinkedIntegrationRuntimeRequest struct {
	// The location of the data factory that the linked integration runtime belongs to.
	DataFactoryLocation *string

	// The name of the data factory that the linked integration runtime belongs to.
	DataFactoryName *string

	// The name of the linked integration runtime.
	Name *string

	// The ID of the subscription that the linked integration runtime belongs to.
	SubscriptionID *string
}

// CreateRunResponse - Response body with a run identifier.
type CreateRunResponse struct {
	// REQUIRED; Identifier of a run.
	RunID *string
}

// Credential - The Azure Data Factory nested object which contains the information and credential which can be used to connect
// with related store or compute resource.
type Credential struct {
	// REQUIRED; Type of credential.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Credential.
	Annotations []any

	// Credential description.
	Description *string
}

// GetCredential implements the CredentialClassification interface for type Credential.
func (c *Credential) GetCredential() *Credential { return c }

// CredentialListResponse - A list of credential resources.
type CredentialListResponse struct {
	// REQUIRED; List of credentials.
	Value []*ManagedIdentityCredentialResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// CredentialReference - Credential reference type.
type CredentialReference struct {
	// REQUIRED; Reference credential name.
	ReferenceName *string

	// REQUIRED; Credential reference type.
	Type *CredentialReferenceType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
}

// CustomActivity - Custom activity type.
type CustomActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Custom activity properties.
	TypeProperties *CustomActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type CustomActivity.
func (c *CustomActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: c.AdditionalProperties,
		DependsOn:            c.DependsOn,
		Description:          c.Description,
		Name:                 c.Name,
		OnInactiveMarkAs:     c.OnInactiveMarkAs,
		State:                c.State,
		Type:                 c.Type,
		UserProperties:       c.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type CustomActivity.
func (c *CustomActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: c.AdditionalProperties,
		DependsOn:            c.DependsOn,
		Description:          c.Description,
		LinkedServiceName:    c.LinkedServiceName,
		Name:                 c.Name,
		OnInactiveMarkAs:     c.OnInactiveMarkAs,
		Policy:               c.Policy,
		State:                c.State,
		Type:                 c.Type,
		UserProperties:       c.UserProperties,
	}
}

// CustomActivityReferenceObject - Reference objects for custom activity
type CustomActivityReferenceObject struct {
	// Dataset references.
	Datasets []*DatasetReference

	// Linked service references.
	LinkedServices []*LinkedServiceReference
}

// CustomActivityTypeProperties - Custom activity properties.
type CustomActivityTypeProperties struct {
	// REQUIRED; Command for custom activity Type: string (or Expression with resultType string).
	Command any

	// Elevation level and scope for the user, default is nonadmin task. Type: string (or Expression with resultType double).
	AutoUserSpecification any

	// User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity
	// has the full responsibility to consume and interpret the content defined.
	ExtendedProperties map[string]any

	// Folder path for resource files Type: string (or Expression with resultType string).
	FolderPath any

	// Reference objects
	ReferenceObjects *CustomActivityReferenceObject

	// Resource linked service reference.
	ResourceLinkedService *LinkedServiceReference

	// The retention time for the files submitted for custom activity. Type: double (or Expression with resultType double).
	RetentionTimeInDays any
}

// CustomDataSourceLinkedService - Custom linked service.
type CustomDataSourceLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Custom linked service properties.
	TypeProperties any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type CustomDataSourceLinkedService.
func (c *CustomDataSourceLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Type:                 c.Type,
	}
}

// CustomDataset - The custom dataset.
type CustomDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Custom dataset properties.
	TypeProperties any
}

// GetDataset implements the DatasetClassification interface for type CustomDataset.
func (c *CustomDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		Description:          c.Description,
		Folder:               c.Folder,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Schema:               c.Schema,
		Structure:            c.Structure,
		Type:                 c.Type,
	}
}

// CustomEventsTrigger - Trigger that runs every time a custom event is received.
type CustomEventsTrigger struct {
	// REQUIRED; Trigger type.
	Type *string

	// REQUIRED; Custom Events Trigger properties.
	TypeProperties *CustomEventsTriggerTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the trigger.
	Annotations []any

	// Trigger description.
	Description *string

	// Pipelines that need to be started.
	Pipelines []*TriggerPipelineReference

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState
}

// GetMultiplePipelineTrigger implements the MultiplePipelineTriggerClassification interface for type CustomEventsTrigger.
func (c *CustomEventsTrigger) GetMultiplePipelineTrigger() *MultiplePipelineTrigger {
	return &MultiplePipelineTrigger{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		Description:          c.Description,
		Pipelines:            c.Pipelines,
		RuntimeState:         c.RuntimeState,
		Type:                 c.Type,
	}
}

// GetTrigger implements the TriggerClassification interface for type CustomEventsTrigger.
func (c *CustomEventsTrigger) GetTrigger() *Trigger {
	return &Trigger{
		AdditionalProperties: c.AdditionalProperties,
		Annotations:          c.Annotations,
		Description:          c.Description,
		RuntimeState:         c.RuntimeState,
		Type:                 c.Type,
	}
}

// CustomEventsTriggerTypeProperties - Custom Events Trigger properties.
type CustomEventsTriggerTypeProperties struct {
	// REQUIRED; The list of event types that cause this trigger to fire.
	Events []any

	// REQUIRED; The ARM resource ID of the Azure Event Grid Topic.
	Scope *string

	// The event subject must begin with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith,
	// subjectEndsWith.
	SubjectBeginsWith *string

	// The event subject must end with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith,
	// subjectEndsWith.
	SubjectEndsWith *string
}

// CustomSetupBase - The base definition of the custom setup.
type CustomSetupBase struct {
	// REQUIRED; The type of custom setup.
	Type *string
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type CustomSetupBase.
func (c *CustomSetupBase) GetCustomSetupBase() *CustomSetupBase { return c }

// DWCopyCommandDefaultValue - Default value.
type DWCopyCommandDefaultValue struct {
	// Column name. Type: object (or Expression with resultType string).
	ColumnName any

	// The default value of the column. Type: object (or Expression with resultType string).
	DefaultValue any
}

// DWCopyCommandSettings - DW Copy Command settings.
type DWCopyCommandSettings struct {
	// Additional options directly passed to SQL DW in Copy Command. Type: key value pairs (value should be string type) (or Expression
	// with resultType object). Example: "additionalOptions": { "MAXERRORS":
	// "1000", "DATEFORMAT": "'ymd'" }
	AdditionalOptions map[string]*string

	// Specifies the default values for each target column in SQL DW. The default values in the property overwrite the DEFAULT
	// constraint set in the DB, and identity column cannot have a default value. Type:
	// array of objects (or Expression with resultType array of objects).
	DefaultValues []*DWCopyCommandDefaultValue
}

// DataFlow - Azure Data Factory nested object which contains a flow with data movements and transformations.
type DataFlow struct {
	// REQUIRED; Type of data flow.
	Type *string

	// List of tags that can be used for describing the data flow.
	Annotations []any

	// The description of the data flow.
	Description *string

	// The folder that this data flow is in. If not specified, Data flow will appear at the root level.
	Folder *DataFlowFolder
}

// GetDataFlow implements the DataFlowClassification interface for type DataFlow.
func (d *DataFlow) GetDataFlow() *DataFlow { return d }

// DataFlowDebugCommandPayload - Structure of command payload.
type DataFlowDebugCommandPayload struct {
	// REQUIRED; The stream name which is used for preview.
	StreamName *string

	// Array of column names.
	Columns []*string

	// The expression which is used for preview.
	Expression *string

	// Row limits for preview response.
	RowLimits *int32
}

// DataFlowDebugCommandRequest - Request body structure for data flow debug command.
type DataFlowDebugCommandRequest struct {
	// The command type.
	Command *DataFlowDebugCommandType

	// The command payload object.
	CommandPayload *DataFlowDebugCommandPayload

	// The ID of data flow debug session.
	SessionID *string
}

// DataFlowDebugCommandResponse - Response body structure of data flow result for data preview, statistics or expression preview.
type DataFlowDebugCommandResponse struct {
	// The result data of data preview, statistics or expression preview.
	Data *string

	// The run status of data preview, statistics or expression preview.
	Status *string
}

// DataFlowDebugPackage - Request body structure for starting data flow debug session.
type DataFlowDebugPackage struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Data flow instance.
	DataFlow *DataFlowDebugResource

	// List of Data flows
	DataFlows []*DataFlowDebugResource

	// List of datasets.
	Datasets []*DatasetDebugResource

	// Data flow debug settings.
	DebugSettings *DataFlowDebugPackageDebugSettings

	// List of linked services.
	LinkedServices []*LinkedServiceDebugResource

	// The ID of data flow debug session.
	SessionID *string

	// Staging info for debug session.
	Staging *DataFlowStagingInfo
}

// DataFlowDebugPackageDebugSettings - Data flow debug settings.
type DataFlowDebugPackageDebugSettings struct {
	// Parameters for dataset.
	DatasetParameters any

	// Data flow parameters.
	Parameters map[string]any

	// Source setting for data flow debug.
	SourceSettings []*DataFlowSourceSetting
}

// DataFlowDebugResource - Data flow debug resource.
type DataFlowDebugResource struct {
	// REQUIRED; Data flow properties.
	Properties DataFlowClassification

	// The resource name.
	Name *string
}

// DataFlowDebugSessionInfo - Data flow debug session info.
type DataFlowDebugSessionInfo struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Compute type of the cluster.
	ComputeType *string

	// Core count of the cluster.
	CoreCount *int32

	// The name of the data flow.
	DataFlowName *string

	// Attached integration runtime name of data flow debug session.
	IntegrationRuntimeName *string

	// Last activity time of data flow debug session.
	LastActivityTime *string

	// Node count of the cluster. (deprecated property)
	NodeCount *int32

	// The ID of data flow debug session.
	SessionID *string

	// Start time of data flow debug session.
	StartTime *string

	// Compute type of the cluster.
	TimeToLiveInMinutes *int32
}

// DataFlowFolder - The folder that this data flow is in. If not specified, Data flow will appear at the root level.
type DataFlowFolder struct {
	// The name of the folder that this data flow is in.
	Name *string
}

// DataFlowListResponse - A list of data flow resources.
type DataFlowListResponse struct {
	// REQUIRED; List of data flows.
	Value []*DataFlowResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// DataFlowReference - Data flow reference type.
type DataFlowReference struct {
	// REQUIRED; Reference data flow name.
	ReferenceName *string

	// REQUIRED; Data flow reference type.
	Type *DataFlowReferenceType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Reference data flow parameters from dataset.
	DatasetParameters any

	// Data flow parameters
	Parameters map[string]any
}

// DataFlowResource - Data flow resource type.
type DataFlowResource struct {
	// REQUIRED; Data flow properties.
	Properties DataFlowClassification

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// DataFlowSink - Transformation for data flow sink.
type DataFlowSink struct {
	// REQUIRED; Transformation name.
	Name *string

	// Dataset reference.
	Dataset *DatasetReference

	// Transformation description.
	Description *string

	// Flowlet Reference
	Flowlet *DataFlowReference

	// Linked service reference.
	LinkedService *LinkedServiceReference

	// Rejected data linked service reference.
	RejectedDataLinkedService *LinkedServiceReference

	// Schema linked service reference.
	SchemaLinkedService *LinkedServiceReference
}

// DataFlowSource - Transformation for data flow source.
type DataFlowSource struct {
	// REQUIRED; Transformation name.
	Name *string

	// Dataset reference.
	Dataset *DatasetReference

	// Transformation description.
	Description *string

	// Flowlet Reference
	Flowlet *DataFlowReference

	// Linked service reference.
	LinkedService *LinkedServiceReference

	// Schema linked service reference.
	SchemaLinkedService *LinkedServiceReference
}

// DataFlowSourceSetting - Definition of data flow source setting for debug.
type DataFlowSourceSetting struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Defines the row limit of data flow source in debug.
	RowLimit *int32

	// The data flow source name.
	SourceName *string
}

// DataFlowStagingInfo - Staging info for execute data flow activity.
type DataFlowStagingInfo struct {
	// Folder path for staging blob. Type: string (or Expression with resultType string)
	FolderPath any

	// Staging linked service reference.
	LinkedService *LinkedServiceReference
}

// DataLakeAnalyticsUSQLActivity - Data Lake Analytics U-SQL activity.
type DataLakeAnalyticsUSQLActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Data Lake Analytics U-SQL activity properties.
	TypeProperties *DataLakeAnalyticsUSQLActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type DataLakeAnalyticsUSQLActivity.
func (d *DataLakeAnalyticsUSQLActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: d.AdditionalProperties,
		DependsOn:            d.DependsOn,
		Description:          d.Description,
		Name:                 d.Name,
		OnInactiveMarkAs:     d.OnInactiveMarkAs,
		State:                d.State,
		Type:                 d.Type,
		UserProperties:       d.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type DataLakeAnalyticsUSQLActivity.
func (d *DataLakeAnalyticsUSQLActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: d.AdditionalProperties,
		DependsOn:            d.DependsOn,
		Description:          d.Description,
		LinkedServiceName:    d.LinkedServiceName,
		Name:                 d.Name,
		OnInactiveMarkAs:     d.OnInactiveMarkAs,
		Policy:               d.Policy,
		State:                d.State,
		Type:                 d.Type,
		UserProperties:       d.UserProperties,
	}
}

// DataLakeAnalyticsUSQLActivityTypeProperties - DataLakeAnalyticsU-SQL activity properties.
type DataLakeAnalyticsUSQLActivityTypeProperties struct {
	// REQUIRED; Script linked service reference.
	ScriptLinkedService *LinkedServiceReference

	// REQUIRED; Case-sensitive path to folder that contains the U-SQL script. Type: string (or Expression with resultType string).
	ScriptPath any

	// Compilation mode of U-SQL. Must be one of these values : Semantic, Full and SingleBox. Type: string (or Expression with
	// resultType string).
	CompilationMode any

	// The maximum number of nodes simultaneously used to run the job. Default value is 1. Type: integer (or Expression with resultType
	// integer), minimum: 1.
	DegreeOfParallelism any

	// Parameters for U-SQL job request.
	Parameters map[string]any

	// Determines which jobs out of all that are queued should be selected to run first. The lower the number, the higher the
	// priority. Default value is 1000. Type: integer (or Expression with resultType
	// integer), minimum: 1.
	Priority any

	// Runtime version of the U-SQL engine to use. Type: string (or Expression with resultType string).
	RuntimeVersion any
}

// DataMapperMapping - Source and target table mapping details.
type DataMapperMapping struct {
	// This holds the user provided attribute mapping information.
	AttributeMappingInfo *MapperAttributeMappings

	// The connection reference for the source connection.
	SourceConnectionReference *MapperConnectionReference

	// This holds the source denormalization information used while joining multiple sources.
	SourceDenormalizeInfo any

	// Name of the source table
	SourceEntityName *string

	// Name of the target table
	TargetEntityName *string
}

// DatabricksNotebookActivity - DatabricksNotebook activity.
type DatabricksNotebookActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Databricks Notebook activity properties.
	TypeProperties *DatabricksNotebookActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type DatabricksNotebookActivity.
func (d *DatabricksNotebookActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: d.AdditionalProperties,
		DependsOn:            d.DependsOn,
		Description:          d.Description,
		Name:                 d.Name,
		OnInactiveMarkAs:     d.OnInactiveMarkAs,
		State:                d.State,
		Type:                 d.Type,
		UserProperties:       d.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type DatabricksNotebookActivity.
func (d *DatabricksNotebookActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: d.AdditionalProperties,
		DependsOn:            d.DependsOn,
		Description:          d.Description,
		LinkedServiceName:    d.LinkedServiceName,
		Name:                 d.Name,
		OnInactiveMarkAs:     d.OnInactiveMarkAs,
		Policy:               d.Policy,
		State:                d.State,
		Type:                 d.Type,
		UserProperties:       d.UserProperties,
	}
}

// DatabricksNotebookActivityTypeProperties - Databricks Notebook activity properties.
type DatabricksNotebookActivityTypeProperties struct {
	// REQUIRED; The absolute path of the notebook to be run in the Databricks Workspace. This path must begin with a slash. Type:
	// string (or Expression with resultType string).
	NotebookPath any

	// Base parameters to be used for each run of this job.If the notebook takes a parameter that is not specified, the default
	// value from the notebook will be used.
	BaseParameters map[string]any

	// A list of libraries to be installed on the cluster that will execute the job.
	Libraries []map[string]any
}

// DatabricksSparkJarActivity - DatabricksSparkJar activity.
type DatabricksSparkJarActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Databricks SparkJar activity properties.
	TypeProperties *DatabricksSparkJarActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type DatabricksSparkJarActivity.
func (d *DatabricksSparkJarActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: d.AdditionalProperties,
		DependsOn:            d.DependsOn,
		Description:          d.Description,
		Name:                 d.Name,
		OnInactiveMarkAs:     d.OnInactiveMarkAs,
		State:                d.State,
		Type:                 d.Type,
		UserProperties:       d.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type DatabricksSparkJarActivity.
func (d *DatabricksSparkJarActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: d.AdditionalProperties,
		DependsOn:            d.DependsOn,
		Description:          d.Description,
		LinkedServiceName:    d.LinkedServiceName,
		Name:                 d.Name,
		OnInactiveMarkAs:     d.OnInactiveMarkAs,
		Policy:               d.Policy,
		State:                d.State,
		Type:                 d.Type,
		UserProperties:       d.UserProperties,
	}
}

// DatabricksSparkJarActivityTypeProperties - Databricks SparkJar activity properties.
type DatabricksSparkJarActivityTypeProperties struct {
	// REQUIRED; The full name of the class containing the main method to be executed. This class must be contained in a JAR provided
	// as a library. Type: string (or Expression with resultType string).
	MainClassName any

	// A list of libraries to be installed on the cluster that will execute the job.
	Libraries []map[string]any

	// Parameters that will be passed to the main method.
	Parameters []any
}

// DatabricksSparkPythonActivity - DatabricksSparkPython activity.
type DatabricksSparkPythonActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Databricks SparkPython activity properties.
	TypeProperties *DatabricksSparkPythonActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type DatabricksSparkPythonActivity.
func (d *DatabricksSparkPythonActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: d.AdditionalProperties,
		DependsOn:            d.DependsOn,
		Description:          d.Description,
		Name:                 d.Name,
		OnInactiveMarkAs:     d.OnInactiveMarkAs,
		State:                d.State,
		Type:                 d.Type,
		UserProperties:       d.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type DatabricksSparkPythonActivity.
func (d *DatabricksSparkPythonActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: d.AdditionalProperties,
		DependsOn:            d.DependsOn,
		Description:          d.Description,
		LinkedServiceName:    d.LinkedServiceName,
		Name:                 d.Name,
		OnInactiveMarkAs:     d.OnInactiveMarkAs,
		Policy:               d.Policy,
		State:                d.State,
		Type:                 d.Type,
		UserProperties:       d.UserProperties,
	}
}

// DatabricksSparkPythonActivityTypeProperties - Databricks SparkPython activity properties.
type DatabricksSparkPythonActivityTypeProperties struct {
	// REQUIRED; The URI of the Python file to be executed. DBFS paths are supported. Type: string (or Expression with resultType
	// string).
	PythonFile any

	// A list of libraries to be installed on the cluster that will execute the job.
	Libraries []map[string]any

	// Command line parameters that will be passed to the Python file.
	Parameters []any
}

// Dataset - The Azure Data Factory nested object which identifies data within different data stores, such as tables, files,
// folders, and documents.
type Dataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type Dataset.
func (d *Dataset) GetDataset() *Dataset { return d }

// DatasetCompression - The compression method used on a dataset.
type DatasetCompression struct {
	// REQUIRED; Type of dataset compression. Type: string (or Expression with resultType string).
	Type any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The dataset compression level. Type: string (or Expression with resultType string).
	Level any
}

// DatasetDebugResource - Dataset debug resource.
type DatasetDebugResource struct {
	// REQUIRED; Dataset properties.
	Properties DatasetClassification

	// The resource name.
	Name *string
}

// DatasetFolder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
type DatasetFolder struct {
	// The name of the folder that this Dataset is in.
	Name *string
}

// DatasetListResponse - A list of dataset resources.
type DatasetListResponse struct {
	// REQUIRED; List of datasets.
	Value []*DatasetResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// DatasetLocation - Dataset location.
type DatasetLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type DatasetLocation.
func (d *DatasetLocation) GetDatasetLocation() *DatasetLocation { return d }

// DatasetReference - Dataset reference type.
type DatasetReference struct {
	// REQUIRED; Reference dataset name.
	ReferenceName *string

	// REQUIRED; Dataset reference type.
	Type *DatasetReferenceType

	// Arguments for dataset.
	Parameters map[string]any
}

// DatasetResource - Dataset resource type.
type DatasetResource struct {
	// REQUIRED; Dataset properties.
	Properties DatasetClassification

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// DatasetStorageFormat - The format definition of a storage.
type DatasetStorageFormat struct {
	// REQUIRED; Type of dataset storage format.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Deserializer. Type: string (or Expression with resultType string).
	Deserializer any

	// Serializer. Type: string (or Expression with resultType string).
	Serializer any
}

// GetDatasetStorageFormat implements the DatasetStorageFormatClassification interface for type DatasetStorageFormat.
func (d *DatasetStorageFormat) GetDatasetStorageFormat() *DatasetStorageFormat { return d }

// DataworldLinkedService - Linked service for Dataworld.
type DataworldLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Dataworld linked service properties.
	TypeProperties *DataworldLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type DataworldLinkedService.
func (d *DataworldLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		ConnectVia:           d.ConnectVia,
		Description:          d.Description,
		Parameters:           d.Parameters,
		Type:                 d.Type,
	}
}

// DataworldLinkedServiceTypeProperties - Dataworld linked service type properties.
type DataworldLinkedServiceTypeProperties struct {
	// REQUIRED; The api token for the Dataworld source.
	APIToken SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string
}

// Db2LinkedService - Linked service for DB2 data source.
type Db2LinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; DB2 linked service properties.
	TypeProperties *Db2LinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type Db2LinkedService.
func (d *Db2LinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		ConnectVia:           d.ConnectVia,
		Description:          d.Description,
		Parameters:           d.Parameters,
		Type:                 d.Type,
	}
}

// Db2LinkedServiceTypeProperties - DB2 linked service properties.
type Db2LinkedServiceTypeProperties struct {
	// AuthenticationType to be used for connection. It is mutually exclusive with connectionString property.
	AuthenticationType *Db2AuthenticationType

	// Certificate Common Name when TLS is enabled. It is mutually exclusive with connectionString property. Type: string (or
	// Expression with resultType string).
	CertificateCommonName any

	// The connection string. It is mutually exclusive with server, database, authenticationType, userName, packageCollection
	// and certificateCommonName property. Type: string, SecureString or
	// AzureKeyVaultSecretReference.
	ConnectionString any

	// Database name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with
	// resultType string).
	Database any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// It is mutually exclusive with connectionString property. Type: string.
	EncryptedCredential *string

	// Under where packages are created when querying database. It is mutually exclusive with connectionString property. Type:
	// string (or Expression with resultType string).
	PackageCollection any

	// Password for authentication.
	Password SecretBaseClassification

	// Server name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType
	// string).
	Server any

	// Username for authentication. It is mutually exclusive with connectionString property. Type: string (or Expression with
	// resultType string).
	Username any
}

// Db2Source - A copy activity source for Db2 databases.
type Db2Source struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type Db2Source.
func (d *Db2Source) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		Type:                     d.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type Db2Source.
func (d *Db2Source) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        d.AdditionalColumns,
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		QueryTimeout:             d.QueryTimeout,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		Type:                     d.Type,
	}
}

// Db2TableDataset - The Db2 table dataset.
type Db2TableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Db2 table dataset properties.
	TypeProperties *Db2TableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type Db2TableDataset.
func (d *Db2TableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		Description:          d.Description,
		Folder:               d.Folder,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Schema:               d.Schema,
		Structure:            d.Structure,
		Type:                 d.Type,
	}
}

// Db2TableDatasetTypeProperties - Db2 table dataset properties.
type Db2TableDatasetTypeProperties struct {
	// The Db2 schema name. Type: string (or Expression with resultType string).
	Schema any

	// The Db2 table name. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// DeleteActivity - Delete activity.
type DeleteActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Delete activity properties.
	TypeProperties *DeleteActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type DeleteActivity.
func (d *DeleteActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: d.AdditionalProperties,
		DependsOn:            d.DependsOn,
		Description:          d.Description,
		Name:                 d.Name,
		OnInactiveMarkAs:     d.OnInactiveMarkAs,
		State:                d.State,
		Type:                 d.Type,
		UserProperties:       d.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type DeleteActivity.
func (d *DeleteActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: d.AdditionalProperties,
		DependsOn:            d.DependsOn,
		Description:          d.Description,
		LinkedServiceName:    d.LinkedServiceName,
		Name:                 d.Name,
		OnInactiveMarkAs:     d.OnInactiveMarkAs,
		Policy:               d.Policy,
		State:                d.State,
		Type:                 d.Type,
		UserProperties:       d.UserProperties,
	}
}

// DeleteActivityTypeProperties - Delete activity properties.
type DeleteActivityTypeProperties struct {
	// REQUIRED; Delete activity dataset reference.
	Dataset *DatasetReference

	// Whether to record detailed logs of delete-activity execution. Default value is false. Type: boolean (or Expression with
	// resultType boolean).
	EnableLogging any

	// Log storage settings customer need to provide when enableLogging is true.
	LogStorageSettings *LogStorageSettings

	// The max concurrent connections to connect data source at the same time.
	MaxConcurrentConnections *int32

	// If true, files or sub-folders under current folder path will be deleted recursively. Default is false. Type: boolean (or
	// Expression with resultType boolean).
	Recursive any

	// Delete activity store settings.
	StoreSettings StoreReadSettingsClassification
}

// DeleteDataFlowDebugSessionRequest - Request body structure for deleting data flow debug session.
type DeleteDataFlowDebugSessionRequest struct {
	// The ID of data flow debug session.
	SessionID *string
}

// DelimitedTextDataset - Delimited text dataset.
type DelimitedTextDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Delimited text dataset properties.
	TypeProperties *DelimitedTextDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type DelimitedTextDataset.
func (d *DelimitedTextDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		Description:          d.Description,
		Folder:               d.Folder,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Schema:               d.Schema,
		Structure:            d.Structure,
		Type:                 d.Type,
	}
}

// DelimitedTextDatasetTypeProperties - DelimitedText dataset properties.
type DelimitedTextDatasetTypeProperties struct {
	// REQUIRED; The location of the delimited text storage.
	Location DatasetLocationClassification

	// The column delimiter. Type: string (or Expression with resultType string).
	ColumnDelimiter any

	// The data compressionCodec. Type: string (or Expression with resultType string).
	CompressionCodec any

	// The data compression method used for DelimitedText.
	CompressionLevel any

	// The code page name of the preferred encoding. If miss, the default value is UTF-8, unless BOM denotes another Unicode encoding.
	// Refer to the name column of the table in the following link to set
	// supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType
	// string).
	EncodingName any

	// The escape character. Type: string (or Expression with resultType string).
	EscapeChar any

	// When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the
	// first row of data. The default value is false. Type: boolean (or Expression
	// with resultType boolean).
	FirstRowAsHeader any

	// The null value string. Type: string (or Expression with resultType string).
	NullValue any

	// The quote character. Type: string (or Expression with resultType string).
	QuoteChar any

	// The row delimiter. Type: string (or Expression with resultType string).
	RowDelimiter any
}

// DelimitedTextReadSettings - Delimited text read settings.
type DelimitedTextReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Compression settings.
	CompressionProperties CompressionReadSettingsClassification

	// Indicates the number of non-empty rows to skip when reading data from input files. Type: integer (or Expression with resultType
	// integer).
	SkipLineCount any
}

// GetFormatReadSettings implements the FormatReadSettingsClassification interface for type DelimitedTextReadSettings.
func (d *DelimitedTextReadSettings) GetFormatReadSettings() *FormatReadSettings {
	return &FormatReadSettings{
		AdditionalProperties: d.AdditionalProperties,
		Type:                 d.Type,
	}
}

// DelimitedTextSink - A copy activity DelimitedText sink.
type DelimitedTextSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// DelimitedText format settings.
	FormatSettings *DelimitedTextWriteSettings

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// DelimitedText store settings.
	StoreSettings StoreWriteSettingsClassification

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type DelimitedTextSink.
func (d *DelimitedTextSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		SinkRetryCount:           d.SinkRetryCount,
		SinkRetryWait:            d.SinkRetryWait,
		Type:                     d.Type,
		WriteBatchSize:           d.WriteBatchSize,
		WriteBatchTimeout:        d.WriteBatchTimeout,
	}
}

// DelimitedTextSource - A copy activity DelimitedText source.
type DelimitedTextSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// DelimitedText format settings.
	FormatSettings *DelimitedTextReadSettings

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// DelimitedText store settings.
	StoreSettings StoreReadSettingsClassification
}

// GetCopySource implements the CopySourceClassification interface for type DelimitedTextSource.
func (d *DelimitedTextSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		Type:                     d.Type,
	}
}

// DelimitedTextWriteSettings - Delimited text write settings.
type DelimitedTextWriteSettings struct {
	// REQUIRED; The file extension used to create the files. Type: string (or Expression with resultType string).
	FileExtension any

	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specifies the file name pattern _. when copy from non-file based store without partitionOptions. Type: string (or Expression
	// with resultType string).
	FileNamePrefix any

	// Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with
	// resultType integer).
	MaxRowsPerFile any

	// Indicates whether string values should always be enclosed with quotes. Type: boolean (or Expression with resultType boolean).
	QuoteAllText any
}

// GetFormatWriteSettings implements the FormatWriteSettingsClassification interface for type DelimitedTextWriteSettings.
func (d *DelimitedTextWriteSettings) GetFormatWriteSettings() *FormatWriteSettings {
	return &FormatWriteSettings{
		AdditionalProperties: d.AdditionalProperties,
		Type:                 d.Type,
	}
}

// DependencyReference - Referenced dependency.
type DependencyReference struct {
	// REQUIRED; The type of dependency reference.
	Type *string
}

// GetDependencyReference implements the DependencyReferenceClassification interface for type DependencyReference.
func (d *DependencyReference) GetDependencyReference() *DependencyReference { return d }

// DistcpSettings - Distcp settings.
type DistcpSettings struct {
	// REQUIRED; Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string).
	ResourceManagerEndpoint any

	// REQUIRED; Specifies an existing folder path which will be used to store temp Distcp command script. The script file is
	// generated by ADF and will be removed after Copy job finished. Type: string (or Expression
	// with resultType string).
	TempScriptPath any

	// Specifies the Distcp options. Type: string (or Expression with resultType string).
	DistcpOptions any
}

// DocumentDbCollectionDataset - Microsoft Azure Document Database Collection dataset.
type DocumentDbCollectionDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; DocumentDB Collection dataset properties.
	TypeProperties *DocumentDbCollectionDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type DocumentDbCollectionDataset.
func (d *DocumentDbCollectionDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		Description:          d.Description,
		Folder:               d.Folder,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Schema:               d.Schema,
		Structure:            d.Structure,
		Type:                 d.Type,
	}
}

// DocumentDbCollectionDatasetTypeProperties - DocumentDB Collection dataset properties.
type DocumentDbCollectionDatasetTypeProperties struct {
	// REQUIRED; Document Database collection name. Type: string (or Expression with resultType string).
	CollectionName any
}

// DocumentDbCollectionSink - A copy activity Document Database Collection sink.
type DocumentDbCollectionSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Nested properties separator. Default is . (dot). Type: string (or Expression with resultType string).
	NestingSeparator any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// Describes how to write data to Azure Cosmos DB. Type: string (or Expression with resultType string). Allowed values: insert
	// and upsert.
	WriteBehavior any
}

// GetCopySink implements the CopySinkClassification interface for type DocumentDbCollectionSink.
func (d *DocumentDbCollectionSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		SinkRetryCount:           d.SinkRetryCount,
		SinkRetryWait:            d.SinkRetryWait,
		Type:                     d.Type,
		WriteBatchSize:           d.WriteBatchSize,
		WriteBatchTimeout:        d.WriteBatchTimeout,
	}
}

// DocumentDbCollectionSource - A copy activity Document Database Collection source.
type DocumentDbCollectionSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Nested properties separator. Type: string (or Expression with resultType string).
	NestingSeparator any

	// Documents query. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type DocumentDbCollectionSource.
func (d *DocumentDbCollectionSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		Type:                     d.Type,
	}
}

// DrillDatasetTypeProperties - Drill Dataset Properties
type DrillDatasetTypeProperties struct {
	// The schema name of the Drill. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the Drill. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// DrillLinkedService - Drill server linked service.
type DrillLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Drill server linked service properties.
	TypeProperties *DrillLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type DrillLinkedService.
func (d *DrillLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		ConnectVia:           d.ConnectVia,
		Description:          d.Description,
		Parameters:           d.Parameters,
		Type:                 d.Type,
	}
}

// DrillLinkedServiceTypeProperties - Drill server linked service properties.
type DrillLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Pwd *AzureKeyVaultSecretReference
}

// DrillSource - A copy activity Drill server source.
type DrillSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type DrillSource.
func (d *DrillSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		Type:                     d.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type DrillSource.
func (d *DrillSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        d.AdditionalColumns,
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		QueryTimeout:             d.QueryTimeout,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		Type:                     d.Type,
	}
}

// DrillTableDataset - Drill server dataset.
type DrillTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *DrillDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type DrillTableDataset.
func (d *DrillTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		Description:          d.Description,
		Folder:               d.Folder,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Schema:               d.Schema,
		Structure:            d.Structure,
		Type:                 d.Type,
	}
}

// DynamicsAXLinkedService - Dynamics AX linked service.
type DynamicsAXLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Dynamics AX linked service properties.
	TypeProperties *DynamicsAXLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type DynamicsAXLinkedService.
func (d *DynamicsAXLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		ConnectVia:           d.ConnectVia,
		Description:          d.Description,
		Parameters:           d.Parameters,
		Type:                 d.Type,
	}
}

// DynamicsAXLinkedServiceTypeProperties - Dynamics AX linked service properties.
type DynamicsAXLinkedServiceTypeProperties struct {
	// REQUIRED; Specify the resource you are requesting authorization. Type: string (or Expression with resultType string).
	AADResourceID any

	// REQUIRED; Specify the application's client ID. Type: string (or Expression with resultType string).
	ServicePrincipalID any

	// REQUIRED; Specify the application's key. Mark this field as a SecureString to store it securely in Data Factory, or reference
	// a secret stored in Azure Key Vault. Type: string (or Expression with resultType
	// string).
	ServicePrincipalKey SecretBaseClassification

	// REQUIRED; Specify the tenant information (domain name or tenant ID) under which your application resides. Retrieve it by
	// hovering the mouse in the top-right corner of the Azure portal. Type: string (or
	// Expression with resultType string).
	Tenant any

	// REQUIRED; The Dynamics AX (or Dynamics 365 Finance and Operations) instance OData endpoint.
	URL any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string
}

// DynamicsAXResourceDataset - The path of the Dynamics AX OData entity.
type DynamicsAXResourceDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; Dynamics AX OData resource dataset properties.
	TypeProperties *DynamicsAXResourceDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type DynamicsAXResourceDataset.
func (d *DynamicsAXResourceDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		Description:          d.Description,
		Folder:               d.Folder,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Schema:               d.Schema,
		Structure:            d.Structure,
		Type:                 d.Type,
	}
}

// DynamicsAXResourceDatasetTypeProperties - Dynamics AX OData resource dataset properties.
type DynamicsAXResourceDatasetTypeProperties struct {
	// REQUIRED; The path of the Dynamics AX OData entity. Type: string (or Expression with resultType string).
	Path any
}

// DynamicsAXSource - A copy activity Dynamics AX source.
type DynamicsAXSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data.
	// Default value: 00:05:00. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type DynamicsAXSource.
func (d *DynamicsAXSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		Type:                     d.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type DynamicsAXSource.
func (d *DynamicsAXSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        d.AdditionalColumns,
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		QueryTimeout:             d.QueryTimeout,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		Type:                     d.Type,
	}
}

// DynamicsCrmEntityDataset - The Dynamics CRM entity dataset.
type DynamicsCrmEntityDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Dynamics CRM entity dataset properties.
	TypeProperties *DynamicsCrmEntityDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type DynamicsCrmEntityDataset.
func (d *DynamicsCrmEntityDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		Description:          d.Description,
		Folder:               d.Folder,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Schema:               d.Schema,
		Structure:            d.Structure,
		Type:                 d.Type,
	}
}

// DynamicsCrmEntityDatasetTypeProperties - Dynamics CRM entity dataset properties.
type DynamicsCrmEntityDatasetTypeProperties struct {
	// The logical name of the entity. Type: string (or Expression with resultType string).
	EntityName any
}

// DynamicsCrmLinkedService - Dynamics CRM linked service.
type DynamicsCrmLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Dynamics CRM linked service properties.
	TypeProperties *DynamicsCrmLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type DynamicsCrmLinkedService.
func (d *DynamicsCrmLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		ConnectVia:           d.ConnectVia,
		Description:          d.Description,
		Parameters:           d.Parameters,
		Type:                 d.Type,
	}
}

// DynamicsCrmLinkedServiceTypeProperties - Dynamics CRM linked service properties.
type DynamicsCrmLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication type to connect to Dynamics CRM server. 'Office365' for online scenario, 'Ifd' for on-premises
	// with Ifd scenario, 'AADServicePrincipal' for Server-To-Server authentication in online
	// scenario. Type: string (or Expression with resultType string).
	AuthenticationType any

	// REQUIRED; The deployment type of the Dynamics CRM instance. 'Online' for Dynamics CRM Online and 'OnPremisesWithIfd' for
	// Dynamics CRM on-premises with Ifd. Type: string (or Expression with resultType string).
	DeploymentType any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The host name of the on-premises Dynamics CRM server. The property is required for on-prem and not allowed for online.
	// Type: string (or Expression with resultType string).
	HostName any

	// The organization name of the Dynamics CRM instance. The property is required for on-prem and required for online when there
	// are more than one Dynamics CRM instances associated with the user. Type:
	// string (or Expression with resultType string).
	OrganizationName any

	// Password to access the Dynamics CRM instance.
	Password SecretBaseClassification

	// The port of on-premises Dynamics CRM server. The property is required for on-prem and not allowed for online. Default is
	// 443. Type: integer (or Expression with resultType integer), minimum: 0.
	Port any

	// The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
	// servicePrincipalCredential can be SecureString or
	// AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can
	// only be AzureKeyVaultSecretReference.
	ServicePrincipalCredential SecretBaseClassification

	// The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret,
	// 'ServicePrincipalCert' for certificate. Type: string (or Expression with
	// resultType string).
	ServicePrincipalCredentialType any

	// The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID any

	// The URL to the Microsoft Dynamics CRM server. The property is required for on-line and not allowed for on-prem. Type: string
	// (or Expression with resultType string).
	ServiceURI any

	// User name to access the Dynamics CRM instance. Type: string (or Expression with resultType string).
	Username any
}

// DynamicsCrmSink - A copy activity Dynamics CRM sink.
type DynamicsCrmSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// REQUIRED; The write behavior for the operation.
	WriteBehavior *DynamicsSinkWriteBehavior

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The logical name of the alternate key which will be used when upserting records. Type: string (or Expression with resultType
	// string).
	AlternateKeyName any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The flag indicating whether to ignore null values from input dataset (except key fields) during write operation. Default
	// is false. Type: boolean (or Expression with resultType boolean).
	IgnoreNullValues any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type DynamicsCrmSink.
func (d *DynamicsCrmSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		SinkRetryCount:           d.SinkRetryCount,
		SinkRetryWait:            d.SinkRetryWait,
		Type:                     d.Type,
		WriteBatchSize:           d.WriteBatchSize,
		WriteBatchTimeout:        d.WriteBatchTimeout,
	}
}

// DynamicsCrmSource - A copy activity Dynamics CRM source.
type DynamicsCrmSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// FetchXML is a proprietary query language that is used in Microsoft Dynamics CRM (online & on-premises). Type: string (or
	// Expression with resultType string).
	Query any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type DynamicsCrmSource.
func (d *DynamicsCrmSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		Type:                     d.Type,
	}
}

// DynamicsEntityDataset - The Dynamics entity dataset.
type DynamicsEntityDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Dynamics entity dataset properties.
	TypeProperties *DynamicsEntityDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type DynamicsEntityDataset.
func (d *DynamicsEntityDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		Description:          d.Description,
		Folder:               d.Folder,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Schema:               d.Schema,
		Structure:            d.Structure,
		Type:                 d.Type,
	}
}

// DynamicsEntityDatasetTypeProperties - Dynamics entity dataset properties.
type DynamicsEntityDatasetTypeProperties struct {
	// The logical name of the entity. Type: string (or Expression with resultType string).
	EntityName any
}

// DynamicsLinkedService - Dynamics linked service.
type DynamicsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Dynamics linked service properties.
	TypeProperties *DynamicsLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type DynamicsLinkedService.
func (d *DynamicsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: d.AdditionalProperties,
		Annotations:          d.Annotations,
		ConnectVia:           d.ConnectVia,
		Description:          d.Description,
		Parameters:           d.Parameters,
		Type:                 d.Type,
	}
}

// DynamicsLinkedServiceTypeProperties - Dynamics linked service properties.
type DynamicsLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication type to connect to Dynamics server. 'Office365' for online scenario, 'Ifd' for on-premises
	// with Ifd scenario, 'AADServicePrincipal' for Server-To-Server authentication in online
	// scenario. Type: string (or Expression with resultType string).
	AuthenticationType any

	// REQUIRED; The deployment type of the Dynamics instance. 'Online' for Dynamics Online and 'OnPremisesWithIfd' for Dynamics
	// on-premises with Ifd. Type: string (or Expression with resultType string).
	DeploymentType any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The host name of the on-premises Dynamics server. The property is required for on-prem and not allowed for online. Type:
	// string (or Expression with resultType string).
	HostName any

	// The organization name of the Dynamics instance. The property is required for on-prem and required for online when there
	// are more than one Dynamics instances associated with the user. Type: string (or
	// Expression with resultType string).
	OrganizationName any

	// Password to access the Dynamics instance.
	Password SecretBaseClassification

	// The port of on-premises Dynamics server. The property is required for on-prem and not allowed for online. Default is 443.
	// Type: integer (or Expression with resultType integer), minimum: 0.
	Port any

	// The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
	// servicePrincipalCredential can be SecureString or
	// AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can
	// only be AzureKeyVaultSecretReference.
	ServicePrincipalCredential SecretBaseClassification

	// The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret,
	// 'ServicePrincipalCert' for certificate. Type: string (or Expression with
	// resultType string).
	ServicePrincipalCredentialType any

	// The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID any

	// The URL to the Microsoft Dynamics server. The property is required for on-line and not allowed for on-prem. Type: string
	// (or Expression with resultType string).
	ServiceURI any

	// User name to access the Dynamics instance. Type: string (or Expression with resultType string).
	Username any
}

// DynamicsSink - A copy activity Dynamics sink.
type DynamicsSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// REQUIRED; The write behavior for the operation.
	WriteBehavior *DynamicsSinkWriteBehavior

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The logical name of the alternate key which will be used when upserting records. Type: string (or Expression with resultType
	// string).
	AlternateKeyName any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The flag indicating whether ignore null values from input dataset (except key fields) during write operation. Default is
	// false. Type: boolean (or Expression with resultType boolean).
	IgnoreNullValues any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type DynamicsSink.
func (d *DynamicsSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		SinkRetryCount:           d.SinkRetryCount,
		SinkRetryWait:            d.SinkRetryWait,
		Type:                     d.Type,
		WriteBatchSize:           d.WriteBatchSize,
		WriteBatchTimeout:        d.WriteBatchTimeout,
	}
}

// DynamicsSource - A copy activity Dynamics source.
type DynamicsSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// FetchXML is a proprietary query language that is used in Microsoft Dynamics (online & on-premises). Type: string (or Expression
	// with resultType string).
	Query any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type DynamicsSource.
func (d *DynamicsSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     d.AdditionalProperties,
		DisableMetricsCollection: d.DisableMetricsCollection,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		Type:                     d.Type,
	}
}

// EloquaLinkedService - Eloqua server linked service.
type EloquaLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Eloqua server linked service properties.
	TypeProperties *EloquaLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type EloquaLinkedService.
func (e *EloquaLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: e.AdditionalProperties,
		Annotations:          e.Annotations,
		ConnectVia:           e.ConnectVia,
		Description:          e.Description,
		Parameters:           e.Parameters,
		Type:                 e.Type,
	}
}

// EloquaLinkedServiceTypeProperties - Eloqua server linked service properties.
type EloquaLinkedServiceTypeProperties struct {
	// REQUIRED; The endpoint of the Eloqua server. (i.e. eloqua.example.com)
	Endpoint any

	// REQUIRED; The site name and user name of your Eloqua account in the form: sitename/username. (i.e. Eloqua/Alice)
	Username any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The password corresponding to the user name.
	Password SecretBaseClassification

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification any
}

// EloquaObjectDataset - Eloqua server dataset.
type EloquaObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type EloquaObjectDataset.
func (e *EloquaObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: e.AdditionalProperties,
		Annotations:          e.Annotations,
		Description:          e.Description,
		Folder:               e.Folder,
		LinkedServiceName:    e.LinkedServiceName,
		Parameters:           e.Parameters,
		Schema:               e.Schema,
		Structure:            e.Structure,
		Type:                 e.Type,
	}
}

// EloquaSource - A copy activity Eloqua server source.
type EloquaSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type EloquaSource.
func (e *EloquaSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     e.AdditionalProperties,
		DisableMetricsCollection: e.DisableMetricsCollection,
		MaxConcurrentConnections: e.MaxConcurrentConnections,
		SourceRetryCount:         e.SourceRetryCount,
		SourceRetryWait:          e.SourceRetryWait,
		Type:                     e.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type EloquaSource.
func (e *EloquaSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        e.AdditionalColumns,
		AdditionalProperties:     e.AdditionalProperties,
		DisableMetricsCollection: e.DisableMetricsCollection,
		MaxConcurrentConnections: e.MaxConcurrentConnections,
		QueryTimeout:             e.QueryTimeout,
		SourceRetryCount:         e.SourceRetryCount,
		SourceRetryWait:          e.SourceRetryWait,
		Type:                     e.Type,
	}
}

// EncryptionConfiguration - Definition of CMK for the factory.
type EncryptionConfiguration struct {
	// REQUIRED; The name of the key in Azure Key Vault to use as Customer Managed Key.
	KeyName *string

	// REQUIRED; The url of the Azure Key Vault used for CMK.
	VaultBaseURL *string

	// User assigned identity to use to authenticate to customer's key vault. If not provided Managed Service Identity will be
	// used.
	Identity *CMKIdentityDefinition

	// The version of the key used for CMK. If not provided, latest version will be used.
	KeyVersion *string
}

// EntityReference - The entity reference.
type EntityReference struct {
	// The name of this referenced entity.
	ReferenceName *string

	// The type of this referenced entity.
	Type *IntegrationRuntimeEntityReferenceType
}

// EnvironmentVariableSetup - The custom setup of setting environment variable.
type EnvironmentVariableSetup struct {
	// REQUIRED; The type of custom setup.
	Type *string

	// REQUIRED; Add environment variable type properties.
	TypeProperties *EnvironmentVariableSetupTypeProperties
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type EnvironmentVariableSetup.
func (e *EnvironmentVariableSetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: e.Type,
	}
}

// EnvironmentVariableSetupTypeProperties - Environment variable custom setup type properties.
type EnvironmentVariableSetupTypeProperties struct {
	// REQUIRED; The name of the environment variable.
	VariableName *string

	// REQUIRED; The value of the environment variable.
	VariableValue *string
}

// ExcelDataset - Excel dataset.
type ExcelDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Excel dataset properties.
	TypeProperties *ExcelDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type ExcelDataset.
func (e *ExcelDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: e.AdditionalProperties,
		Annotations:          e.Annotations,
		Description:          e.Description,
		Folder:               e.Folder,
		LinkedServiceName:    e.LinkedServiceName,
		Parameters:           e.Parameters,
		Schema:               e.Schema,
		Structure:            e.Structure,
		Type:                 e.Type,
	}
}

// ExcelDatasetTypeProperties - Excel dataset properties.
type ExcelDatasetTypeProperties struct {
	// REQUIRED; The location of the excel storage.
	Location DatasetLocationClassification

	// The data compression method used for the json dataset.
	Compression *DatasetCompression

	// When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the
	// first row of data. The default value is false. Type: boolean (or Expression
	// with resultType boolean).
	FirstRowAsHeader any

	// The null value string. Type: string (or Expression with resultType string).
	NullValue any

	// The partial data of one sheet. Type: string (or Expression with resultType string).
	Range any

	// The sheet index of excel file and default value is 0. Type: integer (or Expression with resultType integer)
	SheetIndex any

	// The sheet name of excel file. Type: string (or Expression with resultType string).
	SheetName any
}

// ExcelSource - A copy activity excel source.
type ExcelSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Excel store settings.
	StoreSettings StoreReadSettingsClassification
}

// GetCopySource implements the CopySourceClassification interface for type ExcelSource.
func (e *ExcelSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     e.AdditionalProperties,
		DisableMetricsCollection: e.DisableMetricsCollection,
		MaxConcurrentConnections: e.MaxConcurrentConnections,
		SourceRetryCount:         e.SourceRetryCount,
		SourceRetryWait:          e.SourceRetryWait,
		Type:                     e.Type,
	}
}

// ExecuteDataFlowActivity - Execute data flow activity.
type ExecuteDataFlowActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Execute data flow activity properties.
	TypeProperties *ExecuteDataFlowActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type ExecuteDataFlowActivity.
func (e *ExecuteDataFlowActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: e.AdditionalProperties,
		DependsOn:            e.DependsOn,
		Description:          e.Description,
		Name:                 e.Name,
		OnInactiveMarkAs:     e.OnInactiveMarkAs,
		State:                e.State,
		Type:                 e.Type,
		UserProperties:       e.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type ExecuteDataFlowActivity.
func (e *ExecuteDataFlowActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: e.AdditionalProperties,
		DependsOn:            e.DependsOn,
		Description:          e.Description,
		LinkedServiceName:    e.LinkedServiceName,
		Name:                 e.Name,
		OnInactiveMarkAs:     e.OnInactiveMarkAs,
		Policy:               e.Policy,
		State:                e.State,
		Type:                 e.Type,
		UserProperties:       e.UserProperties,
	}
}

// ExecuteDataFlowActivityTypeProperties - Execute data flow activity properties.
type ExecuteDataFlowActivityTypeProperties struct {
	// REQUIRED; Data flow reference.
	DataFlow *DataFlowReference

	// Compute properties for data flow activity.
	Compute *ExecuteDataFlowActivityTypePropertiesCompute

	// Continue on error setting used for data flow execution. Enables processing to continue if a sink fails. Type: boolean (or
	// Expression with resultType boolean)
	ContinueOnError any

	// The integration runtime reference.
	IntegrationRuntime *IntegrationRuntimeReference

	// Concurrent run setting used for data flow execution. Allows sinks with the same save order to be processed concurrently.
	// Type: boolean (or Expression with resultType boolean)
	RunConcurrently any

	// Specify number of parallel staging for sources applicable to the sink. Type: integer (or Expression with resultType integer)
	SourceStagingConcurrency any

	// Staging info for execute data flow activity.
	Staging *DataFlowStagingInfo

	// Trace level setting used for data flow monitoring output. Supported values are: 'coarse', 'fine', and 'none'. Type: string
	// (or Expression with resultType string)
	TraceLevel any
}

// ExecuteDataFlowActivityTypePropertiesCompute - Compute properties for data flow activity.
type ExecuteDataFlowActivityTypePropertiesCompute struct {
	// Compute type of the cluster which will execute data flow job. Possible values include: 'General', 'MemoryOptimized', 'ComputeOptimized'.
	// Type: string (or Expression with resultType string)
	ComputeType any

	// Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272. Type:
	// integer (or Expression with resultType integer)
	CoreCount any
}

// ExecutePipelineActivity - Execute pipeline activity.
type ExecutePipelineActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Execute pipeline activity properties.
	TypeProperties *ExecutePipelineActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Execute pipeline activity policy.
	Policy *ExecutePipelineActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type ExecutePipelineActivity.
func (e *ExecutePipelineActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: e.AdditionalProperties,
		DependsOn:            e.DependsOn,
		Description:          e.Description,
		Name:                 e.Name,
		OnInactiveMarkAs:     e.OnInactiveMarkAs,
		State:                e.State,
		Type:                 e.Type,
		UserProperties:       e.UserProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type ExecutePipelineActivity.
func (e *ExecutePipelineActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		AdditionalProperties: e.AdditionalProperties,
		DependsOn:            e.DependsOn,
		Description:          e.Description,
		Name:                 e.Name,
		OnInactiveMarkAs:     e.OnInactiveMarkAs,
		State:                e.State,
		Type:                 e.Type,
		UserProperties:       e.UserProperties,
	}
}

// ExecutePipelineActivityPolicy - Execution policy for an execute pipeline activity.
type ExecutePipelineActivityPolicy struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// When set to true, Input from activity is considered as secure and will not be logged to monitoring.
	SecureInput *bool
}

// ExecutePipelineActivityTypeProperties - Execute pipeline activity properties.
type ExecutePipelineActivityTypeProperties struct {
	// REQUIRED; Pipeline reference.
	Pipeline *PipelineReference

	// Pipeline parameters.
	Parameters map[string]any

	// Defines whether activity execution will wait for the dependent pipeline execution to finish. Default is false.
	WaitOnCompletion *bool
}

// ExecutePowerQueryActivityTypeProperties - Execute power query data flow activity properties.
type ExecutePowerQueryActivityTypeProperties struct {
	// REQUIRED; Data flow reference.
	DataFlow *DataFlowReference

	// Compute properties for data flow activity.
	Compute *ExecuteDataFlowActivityTypePropertiesCompute

	// Continue on error setting used for data flow execution. Enables processing to continue if a sink fails. Type: boolean (or
	// Expression with resultType boolean)
	ContinueOnError any

	// The integration runtime reference.
	IntegrationRuntime *IntegrationRuntimeReference

	// List of mapping for Power Query mashup query to sink dataset(s).
	Queries []*PowerQuerySinkMapping

	// Concurrent run setting used for data flow execution. Allows sinks with the same save order to be processed concurrently.
	// Type: boolean (or Expression with resultType boolean)
	RunConcurrently any

	// (Deprecated. Please use Queries). List of Power Query activity sinks mapped to a queryName.
	Sinks map[string]*PowerQuerySink

	// Specify number of parallel staging for sources applicable to the sink. Type: integer (or Expression with resultType integer)
	SourceStagingConcurrency any

	// Staging info for execute data flow activity.
	Staging *DataFlowStagingInfo

	// Trace level setting used for data flow monitoring output. Supported values are: 'coarse', 'fine', and 'none'. Type: string
	// (or Expression with resultType string)
	TraceLevel any
}

// ExecuteSSISPackageActivity - Execute SSIS package activity.
type ExecuteSSISPackageActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Execute SSIS package activity properties.
	TypeProperties *ExecuteSSISPackageActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type ExecuteSSISPackageActivity.
func (e *ExecuteSSISPackageActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: e.AdditionalProperties,
		DependsOn:            e.DependsOn,
		Description:          e.Description,
		Name:                 e.Name,
		OnInactiveMarkAs:     e.OnInactiveMarkAs,
		State:                e.State,
		Type:                 e.Type,
		UserProperties:       e.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type ExecuteSSISPackageActivity.
func (e *ExecuteSSISPackageActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: e.AdditionalProperties,
		DependsOn:            e.DependsOn,
		Description:          e.Description,
		LinkedServiceName:    e.LinkedServiceName,
		Name:                 e.Name,
		OnInactiveMarkAs:     e.OnInactiveMarkAs,
		Policy:               e.Policy,
		State:                e.State,
		Type:                 e.Type,
		UserProperties:       e.UserProperties,
	}
}

// ExecuteSSISPackageActivityTypeProperties - Execute SSIS package activity properties.
type ExecuteSSISPackageActivityTypeProperties struct {
	// REQUIRED; The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// REQUIRED; SSIS package location.
	PackageLocation *SSISPackageLocation

	// The environment path to execute the SSIS package. Type: string (or Expression with resultType string).
	EnvironmentPath any

	// The package execution credential.
	ExecutionCredential *SSISExecutionCredential

	// SSIS package execution log location.
	LogLocation *SSISLogLocation

	// The logging level of SSIS package execution. Type: string (or Expression with resultType string).
	LoggingLevel any

	// The package level connection managers to execute the SSIS package.
	PackageConnectionManagers map[string]map[string]*SSISExecutionParameter

	// The package level parameters to execute the SSIS package.
	PackageParameters map[string]*SSISExecutionParameter

	// The project level connection managers to execute the SSIS package.
	ProjectConnectionManagers map[string]map[string]*SSISExecutionParameter

	// The project level parameters to execute the SSIS package.
	ProjectParameters map[string]*SSISExecutionParameter

	// The property overrides to execute the SSIS package.
	PropertyOverrides map[string]*SSISPropertyOverride

	// Specifies the runtime to execute SSIS package. The value should be "x86" or "x64". Type: string (or Expression with resultType
	// string).
	Runtime any
}

// ExecuteWranglingDataflowActivity - Execute power query activity.
type ExecuteWranglingDataflowActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Execute power query activity properties.
	TypeProperties *ExecutePowerQueryActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type ExecuteWranglingDataflowActivity.
func (e *ExecuteWranglingDataflowActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: e.AdditionalProperties,
		DependsOn:            e.DependsOn,
		Description:          e.Description,
		Name:                 e.Name,
		OnInactiveMarkAs:     e.OnInactiveMarkAs,
		State:                e.State,
		Type:                 e.Type,
		UserProperties:       e.UserProperties,
	}
}

// ExecutionActivity - Base class for all execution activities.
type ExecutionActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type ExecutionActivity.
func (e *ExecutionActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: e.AdditionalProperties,
		DependsOn:            e.DependsOn,
		Description:          e.Description,
		Name:                 e.Name,
		OnInactiveMarkAs:     e.OnInactiveMarkAs,
		State:                e.State,
		Type:                 e.Type,
		UserProperties:       e.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type ExecutionActivity.
func (e *ExecutionActivity) GetExecutionActivity() *ExecutionActivity { return e }

// ExportSettings - Export command settings.
type ExportSettings struct {
	// REQUIRED; The export setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
}

// GetExportSettings implements the ExportSettingsClassification interface for type ExportSettings.
func (e *ExportSettings) GetExportSettings() *ExportSettings { return e }

// ExposureControlBatchRequest - A list of exposure control features.
type ExposureControlBatchRequest struct {
	// REQUIRED; List of exposure control features.
	ExposureControlRequests []*ExposureControlRequest
}

// ExposureControlBatchResponse - A list of exposure control feature values.
type ExposureControlBatchResponse struct {
	// REQUIRED; List of exposure control feature values.
	ExposureControlResponses []*ExposureControlResponse
}

// ExposureControlRequest - The exposure control request.
type ExposureControlRequest struct {
	// The feature name.
	FeatureName *string

	// The feature type.
	FeatureType *string
}

// ExposureControlResponse - The exposure control response.
type ExposureControlResponse struct {
	// READ-ONLY; The feature name.
	FeatureName *string

	// READ-ONLY; The feature value.
	Value *string
}

// Expression - Azure Data Factory expression definition.
type Expression struct {
	// REQUIRED; Expression type.
	Type *ExpressionType

	// REQUIRED; Expression value.
	Value *string
}

// Factory resource type.
type Factory struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Managed service identity of the factory.
	Identity *FactoryIdentity

	// The resource location.
	Location *string

	// Properties of the factory.
	Properties *FactoryProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; Etag identifies change in the resource.
	ETag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// FactoryGitHubConfiguration - Factory's GitHub repo information.
type FactoryGitHubConfiguration struct {
	// REQUIRED; Account name.
	AccountName *string

	// REQUIRED; Collaboration branch.
	CollaborationBranch *string

	// REQUIRED; Repository name.
	RepositoryName *string

	// REQUIRED; Root folder.
	RootFolder *string

	// REQUIRED; Type of repo configuration.
	Type *string

	// GitHub bring your own app client id.
	ClientID *string

	// GitHub bring your own app client secret information.
	ClientSecret *GitHubClientSecret

	// Disable manual publish operation in ADF studio to favor automated publish.
	DisablePublish *bool

	// GitHub Enterprise host name. For example: https://github.mydomain.com
	HostName *string

	// Last commit id.
	LastCommitID *string
}

// GetFactoryRepoConfiguration implements the FactoryRepoConfigurationClassification interface for type FactoryGitHubConfiguration.
func (f *FactoryGitHubConfiguration) GetFactoryRepoConfiguration() *FactoryRepoConfiguration {
	return &FactoryRepoConfiguration{
		AccountName:         f.AccountName,
		CollaborationBranch: f.CollaborationBranch,
		DisablePublish:      f.DisablePublish,
		LastCommitID:        f.LastCommitID,
		RepositoryName:      f.RepositoryName,
		RootFolder:          f.RootFolder,
		Type:                f.Type,
	}
}

// FactoryIdentity - Identity properties of the factory resource.
type FactoryIdentity struct {
	// REQUIRED; The identity type.
	Type *FactoryIdentityType

	// List of user assigned identities for the factory.
	UserAssignedIdentities map[string]any

	// READ-ONLY; The principal id of the identity.
	PrincipalID *string

	// READ-ONLY; The client tenant id of the identity.
	TenantID *string
}

// FactoryListResponse - A list of factory resources.
type FactoryListResponse struct {
	// REQUIRED; List of factories.
	Value []*Factory

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// FactoryProperties - Factory resource properties.
type FactoryProperties struct {
	// Properties to enable Customer Managed Key for the factory.
	Encryption *EncryptionConfiguration

	// List of parameters for factory.
	GlobalParameters map[string]*GlobalParameterSpecification

	// Whether or not public network access is allowed for the data factory.
	PublicNetworkAccess *PublicNetworkAccess

	// Purview information of the factory.
	PurviewConfiguration *PurviewConfiguration

	// Git repo information of the factory.
	RepoConfiguration FactoryRepoConfigurationClassification

	// READ-ONLY; Time the factory was created in ISO8601 format.
	CreateTime *time.Time

	// READ-ONLY; Factory provisioning state, example Succeeded.
	ProvisioningState *string

	// READ-ONLY; Version of the factory.
	Version *string
}

// FactoryRepoConfiguration - Factory's git repo information.
type FactoryRepoConfiguration struct {
	// REQUIRED; Account name.
	AccountName *string

	// REQUIRED; Collaboration branch.
	CollaborationBranch *string

	// REQUIRED; Repository name.
	RepositoryName *string

	// REQUIRED; Root folder.
	RootFolder *string

	// REQUIRED; Type of repo configuration.
	Type *string

	// Disable manual publish operation in ADF studio to favor automated publish.
	DisablePublish *bool

	// Last commit id.
	LastCommitID *string
}

// GetFactoryRepoConfiguration implements the FactoryRepoConfigurationClassification interface for type FactoryRepoConfiguration.
func (f *FactoryRepoConfiguration) GetFactoryRepoConfiguration() *FactoryRepoConfiguration { return f }

// FactoryRepoUpdate - Factory's git repo information.
type FactoryRepoUpdate struct {
	// The factory resource id.
	FactoryResourceID *string

	// Git repo information of the factory.
	RepoConfiguration FactoryRepoConfigurationClassification
}

// FactoryUpdateParameters - Parameters for updating a factory resource.
type FactoryUpdateParameters struct {
	// Managed service identity of the factory.
	Identity *FactoryIdentity

	// Properties of update the factory.
	Properties *FactoryUpdateProperties

	// The resource tags.
	Tags map[string]*string
}

// FactoryUpdateProperties - Factory update resource properties.
type FactoryUpdateProperties struct {
	// Whether or not public network access is allowed for the data factory.
	PublicNetworkAccess *PublicNetworkAccess
}

// FactoryVSTSConfiguration - Factory's VSTS repo information.
type FactoryVSTSConfiguration struct {
	// REQUIRED; Account name.
	AccountName *string

	// REQUIRED; Collaboration branch.
	CollaborationBranch *string

	// REQUIRED; VSTS project name.
	ProjectName *string

	// REQUIRED; Repository name.
	RepositoryName *string

	// REQUIRED; Root folder.
	RootFolder *string

	// REQUIRED; Type of repo configuration.
	Type *string

	// Disable manual publish operation in ADF studio to favor automated publish.
	DisablePublish *bool

	// Last commit id.
	LastCommitID *string

	// VSTS tenant id.
	TenantID *string
}

// GetFactoryRepoConfiguration implements the FactoryRepoConfigurationClassification interface for type FactoryVSTSConfiguration.
func (f *FactoryVSTSConfiguration) GetFactoryRepoConfiguration() *FactoryRepoConfiguration {
	return &FactoryRepoConfiguration{
		AccountName:         f.AccountName,
		CollaborationBranch: f.CollaborationBranch,
		DisablePublish:      f.DisablePublish,
		LastCommitID:        f.LastCommitID,
		RepositoryName:      f.RepositoryName,
		RootFolder:          f.RootFolder,
		Type:                f.Type,
	}
}

// FailActivity - This activity will fail within its own scope and output a custom error message and error code. The error
// message and code can provided either as a string literal or as an expression that can be
// evaluated to a string at runtime. The activity scope can be the whole pipeline or a control activity (e.g. foreach, switch,
// until), if the fail activity is contained in it.
type FailActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Fail activity properties.
	TypeProperties *FailActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type FailActivity.
func (f *FailActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: f.AdditionalProperties,
		DependsOn:            f.DependsOn,
		Description:          f.Description,
		Name:                 f.Name,
		OnInactiveMarkAs:     f.OnInactiveMarkAs,
		State:                f.State,
		Type:                 f.Type,
		UserProperties:       f.UserProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type FailActivity.
func (f *FailActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		AdditionalProperties: f.AdditionalProperties,
		DependsOn:            f.DependsOn,
		Description:          f.Description,
		Name:                 f.Name,
		OnInactiveMarkAs:     f.OnInactiveMarkAs,
		State:                f.State,
		Type:                 f.Type,
		UserProperties:       f.UserProperties,
	}
}

// FailActivityTypeProperties - Fail activity properties.
type FailActivityTypeProperties struct {
	// REQUIRED; The error code that categorizes the error type of the Fail activity. It can be dynamic content that's evaluated
	// to a non empty/blank string at runtime. Type: string (or Expression with resultType
	// string).
	ErrorCode any

	// REQUIRED; The error message that surfaced in the Fail activity. It can be dynamic content that's evaluated to a non empty/blank
	// string at runtime. Type: string (or Expression with resultType string).
	Message any
}

// FileServerLinkedService - File system linked service.
type FileServerLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; File system linked service properties.
	TypeProperties *FileServerLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type FileServerLinkedService.
func (f *FileServerLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: f.AdditionalProperties,
		Annotations:          f.Annotations,
		ConnectVia:           f.ConnectVia,
		Description:          f.Description,
		Parameters:           f.Parameters,
		Type:                 f.Type,
	}
}

// FileServerLinkedServiceTypeProperties - File system linked service properties.
type FileServerLinkedServiceTypeProperties struct {
	// REQUIRED; Host name of the server. Type: string (or Expression with resultType string).
	Host any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Password to logon the server.
	Password SecretBaseClassification

	// User ID to logon the server. Type: string (or Expression with resultType string).
	UserID any
}

// FileServerLocation - The location of file server dataset.
type FileServerLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type FileServerLocation.
func (f *FileServerLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: f.AdditionalProperties,
		FileName:             f.FileName,
		FolderPath:           f.FolderPath,
		Type:                 f.Type,
	}
}

// FileServerReadSettings - File server read settings.
type FileServerReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression
	// with resultType string).
	FileFilter any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// FileServer wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// FileServer wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type FileServerReadSettings.
func (f *FileServerReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     f.AdditionalProperties,
		DisableMetricsCollection: f.DisableMetricsCollection,
		MaxConcurrentConnections: f.MaxConcurrentConnections,
		Type:                     f.Type,
	}
}

// FileServerWriteSettings - File server write settings.
type FileServerWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The type of copy behavior for copy sink.
	CopyBehavior any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any
}

// GetStoreWriteSettings implements the StoreWriteSettingsClassification interface for type FileServerWriteSettings.
func (f *FileServerWriteSettings) GetStoreWriteSettings() *StoreWriteSettings {
	return &StoreWriteSettings{
		AdditionalProperties:     f.AdditionalProperties,
		CopyBehavior:             f.CopyBehavior,
		DisableMetricsCollection: f.DisableMetricsCollection,
		MaxConcurrentConnections: f.MaxConcurrentConnections,
		Type:                     f.Type,
	}
}

// FileShareDataset - An on-premises file system dataset.
type FileShareDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// On-premises file system dataset properties.
	TypeProperties *FileShareDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type FileShareDataset.
func (f *FileShareDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: f.AdditionalProperties,
		Annotations:          f.Annotations,
		Description:          f.Description,
		Folder:               f.Folder,
		LinkedServiceName:    f.LinkedServiceName,
		Parameters:           f.Parameters,
		Schema:               f.Schema,
		Structure:            f.Structure,
		Type:                 f.Type,
	}
}

// FileShareDatasetTypeProperties - On-premises file system dataset properties.
type FileShareDatasetTypeProperties struct {
	// The data compression method used for the file system.
	Compression *DatasetCompression

	// Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression
	// with resultType string).
	FileFilter any

	// The name of the on-premises file system. Type: string (or Expression with resultType string).
	FileName any

	// The path of the on-premises file system. Type: string (or Expression with resultType string).
	FolderPath any

	// The format of the files.
	Format DatasetStorageFormatClassification

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any
}

// FileSystemSink - A copy activity file system sink.
type FileSystemSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The type of copy behavior for copy sink.
	CopyBehavior any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type FileSystemSink.
func (f *FileSystemSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     f.AdditionalProperties,
		DisableMetricsCollection: f.DisableMetricsCollection,
		MaxConcurrentConnections: f.MaxConcurrentConnections,
		SinkRetryCount:           f.SinkRetryCount,
		SinkRetryWait:            f.SinkRetryWait,
		Type:                     f.Type,
		WriteBatchSize:           f.WriteBatchSize,
		WriteBatchTimeout:        f.WriteBatchTimeout,
	}
}

// FileSystemSource - A copy activity file system source.
type FileSystemSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type FileSystemSource.
func (f *FileSystemSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     f.AdditionalProperties,
		DisableMetricsCollection: f.DisableMetricsCollection,
		MaxConcurrentConnections: f.MaxConcurrentConnections,
		SourceRetryCount:         f.SourceRetryCount,
		SourceRetryWait:          f.SourceRetryWait,
		Type:                     f.Type,
	}
}

// FilterActivity - Filter and return results from input array based on the conditions.
type FilterActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Filter activity properties.
	TypeProperties *FilterActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type FilterActivity.
func (f *FilterActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: f.AdditionalProperties,
		DependsOn:            f.DependsOn,
		Description:          f.Description,
		Name:                 f.Name,
		OnInactiveMarkAs:     f.OnInactiveMarkAs,
		State:                f.State,
		Type:                 f.Type,
		UserProperties:       f.UserProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type FilterActivity.
func (f *FilterActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		AdditionalProperties: f.AdditionalProperties,
		DependsOn:            f.DependsOn,
		Description:          f.Description,
		Name:                 f.Name,
		OnInactiveMarkAs:     f.OnInactiveMarkAs,
		State:                f.State,
		Type:                 f.Type,
		UserProperties:       f.UserProperties,
	}
}

// FilterActivityTypeProperties - Filter activity properties.
type FilterActivityTypeProperties struct {
	// REQUIRED; Condition to be used for filtering the input.
	Condition *Expression

	// REQUIRED; Input array on which filter should be applied.
	Items *Expression
}

// Flowlet - Data flow flowlet
type Flowlet struct {
	// REQUIRED; Type of data flow.
	Type *string

	// List of tags that can be used for describing the data flow.
	Annotations []any

	// The description of the data flow.
	Description *string

	// The folder that this data flow is in. If not specified, Data flow will appear at the root level.
	Folder *DataFlowFolder

	// Flowlet type properties.
	TypeProperties *FlowletTypeProperties
}

// GetDataFlow implements the DataFlowClassification interface for type Flowlet.
func (f *Flowlet) GetDataFlow() *DataFlow {
	return &DataFlow{
		Annotations: f.Annotations,
		Description: f.Description,
		Folder:      f.Folder,
		Type:        f.Type,
	}
}

// FlowletTypeProperties - Flowlet type properties.
type FlowletTypeProperties struct {
	// Flowlet script.
	Script *string

	// Flowlet script lines.
	ScriptLines []*string

	// List of sinks in Flowlet.
	Sinks []*DataFlowSink

	// List of sources in Flowlet.
	Sources []*DataFlowSource

	// List of transformations in Flowlet.
	Transformations []*Transformation
}

// ForEachActivity - This activity is used for iterating over a collection and execute given activities.
type ForEachActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; ForEach activity properties.
	TypeProperties *ForEachActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type ForEachActivity.
func (f *ForEachActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: f.AdditionalProperties,
		DependsOn:            f.DependsOn,
		Description:          f.Description,
		Name:                 f.Name,
		OnInactiveMarkAs:     f.OnInactiveMarkAs,
		State:                f.State,
		Type:                 f.Type,
		UserProperties:       f.UserProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type ForEachActivity.
func (f *ForEachActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		AdditionalProperties: f.AdditionalProperties,
		DependsOn:            f.DependsOn,
		Description:          f.Description,
		Name:                 f.Name,
		OnInactiveMarkAs:     f.OnInactiveMarkAs,
		State:                f.State,
		Type:                 f.Type,
		UserProperties:       f.UserProperties,
	}
}

// ForEachActivityTypeProperties - ForEach activity properties.
type ForEachActivityTypeProperties struct {
	// REQUIRED; List of activities to execute .
	Activities []ActivityClassification

	// REQUIRED; Collection to iterate.
	Items *Expression

	// Batch count to be used for controlling the number of parallel execution (when isSequential is set to false).
	BatchCount *int32

	// Should the loop be executed in sequence or in parallel (max 50)
	IsSequential *bool
}

// FormatReadSettings - Format read settings.
type FormatReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
}

// GetFormatReadSettings implements the FormatReadSettingsClassification interface for type FormatReadSettings.
func (f *FormatReadSettings) GetFormatReadSettings() *FormatReadSettings { return f }

// FormatWriteSettings - Format write settings.
type FormatWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
}

// GetFormatWriteSettings implements the FormatWriteSettingsClassification interface for type FormatWriteSettings.
func (f *FormatWriteSettings) GetFormatWriteSettings() *FormatWriteSettings { return f }

// FtpReadSettings - Ftp read settings.
type FtpReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable parallel reading within each file. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableChunking any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Specify whether to use binary transfer mode for FTP stores. Type: boolean (or Expression with resultType boolean).
	UseBinaryTransfer any

	// Ftp wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// Ftp wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type FtpReadSettings.
func (f *FtpReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     f.AdditionalProperties,
		DisableMetricsCollection: f.DisableMetricsCollection,
		MaxConcurrentConnections: f.MaxConcurrentConnections,
		Type:                     f.Type,
	}
}

// FtpServerLinkedService - A FTP server Linked Service.
type FtpServerLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Properties specific to this linked service type.
	TypeProperties *FtpServerLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type FtpServerLinkedService.
func (f *FtpServerLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: f.AdditionalProperties,
		Annotations:          f.Annotations,
		ConnectVia:           f.ConnectVia,
		Description:          f.Description,
		Parameters:           f.Parameters,
		Type:                 f.Type,
	}
}

// FtpServerLinkedServiceTypeProperties - Properties specific to this linked service type.
type FtpServerLinkedServiceTypeProperties struct {
	// REQUIRED; Host name of the FTP server. Type: string (or Expression with resultType string).
	Host any

	// The authentication type to be used to connect to the FTP server.
	AuthenticationType *FtpAuthenticationType

	// If true, connect to the FTP server over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType
	// boolean).
	EnableSSL any

	// If true, validate the FTP server SSL certificate when connect over SSL/TLS channel. Default value is true. Type: boolean
	// (or Expression with resultType boolean).
	EnableServerCertificateValidation any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Password to logon the FTP server.
	Password SecretBaseClassification

	// The TCP port number that the FTP server uses to listen for client connections. Default value is 21. Type: integer (or Expression
	// with resultType integer), minimum: 0.
	Port any

	// Username to logon the FTP server. Type: string (or Expression with resultType string).
	UserName any
}

// FtpServerLocation - The location of ftp server dataset.
type FtpServerLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type FtpServerLocation.
func (f *FtpServerLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: f.AdditionalProperties,
		FileName:             f.FileName,
		FolderPath:           f.FolderPath,
		Type:                 f.Type,
	}
}

// GenericDatasetTypeProperties - Properties specific to this dataset type.
type GenericDatasetTypeProperties struct {
	// The table name. Type: string (or Expression with resultType string).
	TableName any
}

// GetMetadataActivity - Activity to get metadata of dataset
type GetMetadataActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; GetMetadata activity properties.
	TypeProperties *GetMetadataActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type GetMetadataActivity.
func (g *GetMetadataActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: g.AdditionalProperties,
		DependsOn:            g.DependsOn,
		Description:          g.Description,
		Name:                 g.Name,
		OnInactiveMarkAs:     g.OnInactiveMarkAs,
		State:                g.State,
		Type:                 g.Type,
		UserProperties:       g.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type GetMetadataActivity.
func (g *GetMetadataActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: g.AdditionalProperties,
		DependsOn:            g.DependsOn,
		Description:          g.Description,
		LinkedServiceName:    g.LinkedServiceName,
		Name:                 g.Name,
		OnInactiveMarkAs:     g.OnInactiveMarkAs,
		Policy:               g.Policy,
		State:                g.State,
		Type:                 g.Type,
		UserProperties:       g.UserProperties,
	}
}

// GetMetadataActivityTypeProperties - GetMetadata activity properties.
type GetMetadataActivityTypeProperties struct {
	// REQUIRED; GetMetadata activity dataset reference.
	Dataset *DatasetReference

	// Fields of metadata to get from dataset.
	FieldList []any

	// GetMetadata activity format settings.
	FormatSettings FormatReadSettingsClassification

	// GetMetadata activity store settings.
	StoreSettings StoreReadSettingsClassification
}

// GetSsisObjectMetadataRequest - The request payload of get SSIS object metadata.
type GetSsisObjectMetadataRequest struct {
	// Metadata path.
	MetadataPath *string
}

// GitHubAccessTokenRequest - Get GitHub access token request definition.
type GitHubAccessTokenRequest struct {
	// REQUIRED; GitHub access code.
	GitHubAccessCode *string

	// REQUIRED; GitHub access token base URL.
	GitHubAccessTokenBaseURL *string

	// GitHub application client ID.
	GitHubClientID *string

	// GitHub bring your own app client secret information.
	GitHubClientSecret *GitHubClientSecret
}

// GitHubAccessTokenResponse - Get GitHub access token response definition.
type GitHubAccessTokenResponse struct {
	// GitHub access token.
	GitHubAccessToken *string
}

// GitHubClientSecret - Client secret information for factory's bring your own app repository configuration.
type GitHubClientSecret struct {
	// Bring your own app client secret AKV URL.
	ByoaSecretAkvURL *string

	// Bring your own app client secret name in AKV.
	ByoaSecretName *string
}

// GlobalParameterListResponse - A list of Global parameters.
type GlobalParameterListResponse struct {
	// REQUIRED; List of global parameters.
	Value []*GlobalParameterResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// GlobalParameterResource - Global parameters resource type.
type GlobalParameterResource struct {
	// REQUIRED; Properties of the global parameter.
	Properties map[string]*GlobalParameterSpecification

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// GlobalParameterSpecification - Definition of a single parameter for an entity.
type GlobalParameterSpecification struct {
	// REQUIRED; Global Parameter type.
	Type *GlobalParameterType

	// REQUIRED; Value of parameter.
	Value any
}

// GoogleAdWordsLinkedService - Google AdWords service linked service.
type GoogleAdWordsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Google AdWords service linked service properties.
	TypeProperties *GoogleAdWordsLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type GoogleAdWordsLinkedService.
func (g *GoogleAdWordsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: g.AdditionalProperties,
		Annotations:          g.Annotations,
		ConnectVia:           g.ConnectVia,
		Description:          g.Description,
		Parameters:           g.Parameters,
		Type:                 g.Type,
	}
}

// GoogleAdWordsLinkedServiceTypeProperties - Google AdWords service linked service properties.
type GoogleAdWordsLinkedServiceTypeProperties struct {
	// The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
	AuthenticationType *GoogleAdWordsAuthenticationType

	// The Client customer ID of the AdWords account that you want to fetch report data for. Type: string (or Expression with
	// resultType string).
	ClientCustomerID any

	// The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType
	// string).
	ClientID any

	// The client secret of the google application used to acquire the refresh token.
	ClientSecret SecretBaseClassification

	// (Deprecated) Properties used to connect to GoogleAds. It is mutually exclusive with any other properties in the linked
	// service. Type: object.
	ConnectionProperties any

	// The developer token associated with the manager account that you use to grant access to the AdWords API.
	DeveloperToken SecretBaseClassification

	// The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR. Type: string
	// (or Expression with resultType string).
	Email any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Google Ads API major version such as v14. The supported major versions could be found on https://developers.google.com/google-ads/api/docs/release-notes.
	// Type: string (or Expression with
	// resultType string).
	GoogleAdsAPIVersion any

	// (Deprecated) The full path to the .p12 key file that is used to authenticate the service account email address and can
	// only be used on self-hosted IR. Type: string (or Expression with resultType
	// string).
	KeyFilePath any

	// The customer ID of the Google Ads Manager account through which you want to fetch report data of specific Customer. Type:
	// string (or Expression with resultType string).
	LoginCustomerID any

	// The private key that is used to authenticate the service account email address and can only be used on self-hosted IR.
	PrivateKey SecretBaseClassification

	// The refresh token obtained from Google for authorizing access to AdWords for UserAuthentication.
	RefreshToken SecretBaseClassification

	// Specifies whether to use the legacy data type mappings, which maps float, int32 and int64 from Google to string. Do not
	// set this to true unless you want to keep backward compatibility with legacy
	// driver's data type mappings. Type: boolean (or Expression with resultType boolean).
	SupportLegacyDataTypes any

	// (Deprecated) The full path of the .pem file containing trusted CA certificates for verifying the server when connecting
	// over SSL. This property can only be set when using SSL on self-hosted IR. The
	// default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType string).
	TrustedCertPath any

	// (Deprecated) Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default
	// value is false. Type: boolean (or Expression with resultType boolean).
	UseSystemTrustStore any
}

// GoogleAdWordsObjectDataset - Google AdWords service dataset.
type GoogleAdWordsObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type GoogleAdWordsObjectDataset.
func (g *GoogleAdWordsObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: g.AdditionalProperties,
		Annotations:          g.Annotations,
		Description:          g.Description,
		Folder:               g.Folder,
		LinkedServiceName:    g.LinkedServiceName,
		Parameters:           g.Parameters,
		Schema:               g.Schema,
		Structure:            g.Structure,
		Type:                 g.Type,
	}
}

// GoogleAdWordsSource - A copy activity Google AdWords service source.
type GoogleAdWordsSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type GoogleAdWordsSource.
func (g *GoogleAdWordsSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     g.AdditionalProperties,
		DisableMetricsCollection: g.DisableMetricsCollection,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		SourceRetryCount:         g.SourceRetryCount,
		SourceRetryWait:          g.SourceRetryWait,
		Type:                     g.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type GoogleAdWordsSource.
func (g *GoogleAdWordsSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        g.AdditionalColumns,
		AdditionalProperties:     g.AdditionalProperties,
		DisableMetricsCollection: g.DisableMetricsCollection,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		QueryTimeout:             g.QueryTimeout,
		SourceRetryCount:         g.SourceRetryCount,
		SourceRetryWait:          g.SourceRetryWait,
		Type:                     g.Type,
	}
}

// GoogleBigQueryDatasetTypeProperties - Google BigQuery Dataset Properties
type GoogleBigQueryDatasetTypeProperties struct {
	// The database name of the Google BigQuery. Type: string (or Expression with resultType string).
	Dataset any

	// The table name of the Google BigQuery. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using database + table properties instead.
	TableName any
}

// GoogleBigQueryLinkedService - Google BigQuery service linked service.
type GoogleBigQueryLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Google BigQuery service linked service properties.
	TypeProperties *GoogleBigQueryLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type GoogleBigQueryLinkedService.
func (g *GoogleBigQueryLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: g.AdditionalProperties,
		Annotations:          g.Annotations,
		ConnectVia:           g.ConnectVia,
		Description:          g.Description,
		Parameters:           g.Parameters,
		Type:                 g.Type,
	}
}

// GoogleBigQueryLinkedServiceTypeProperties - Google BigQuery service linked service properties.
type GoogleBigQueryLinkedServiceTypeProperties struct {
	// REQUIRED; The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted
	// IR.
	AuthenticationType *GoogleBigQueryAuthenticationType

	// REQUIRED; The default BigQuery project to query against. Type: string (or Expression with resultType string).
	Project any

	// A comma-separated list of public BigQuery projects to access. Type: string (or Expression with resultType string).
	AdditionalProjects any

	// The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType
	// string).
	ClientID any

	// The client secret of the google application used to acquire the refresh token.
	ClientSecret SecretBaseClassification

	// The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR. Type: string
	// (or Expression with resultType string).
	Email any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The full path to the .p12 key file that is used to authenticate the service account email address and can only be used
	// on self-hosted IR. Type: string (or Expression with resultType string).
	KeyFilePath any

	// The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
	RefreshToken SecretBaseClassification

	// Whether to request access to Google Drive. Allowing Google Drive access enables support for federated tables that combine
	// BigQuery data with data from Google Drive. The default value is false. Type:
	// string (or Expression with resultType string).
	RequestGoogleDriveScope any

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType string).
	TrustedCertPath any

	// Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is
	// false.Type: boolean (or Expression with resultType boolean).
	UseSystemTrustStore any
}

// GoogleBigQueryObjectDataset - Google BigQuery service dataset.
type GoogleBigQueryObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GoogleBigQueryDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type GoogleBigQueryObjectDataset.
func (g *GoogleBigQueryObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: g.AdditionalProperties,
		Annotations:          g.Annotations,
		Description:          g.Description,
		Folder:               g.Folder,
		LinkedServiceName:    g.LinkedServiceName,
		Parameters:           g.Parameters,
		Schema:               g.Schema,
		Structure:            g.Structure,
		Type:                 g.Type,
	}
}

// GoogleBigQuerySource - A copy activity Google BigQuery service source.
type GoogleBigQuerySource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type GoogleBigQuerySource.
func (g *GoogleBigQuerySource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     g.AdditionalProperties,
		DisableMetricsCollection: g.DisableMetricsCollection,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		SourceRetryCount:         g.SourceRetryCount,
		SourceRetryWait:          g.SourceRetryWait,
		Type:                     g.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type GoogleBigQuerySource.
func (g *GoogleBigQuerySource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        g.AdditionalColumns,
		AdditionalProperties:     g.AdditionalProperties,
		DisableMetricsCollection: g.DisableMetricsCollection,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		QueryTimeout:             g.QueryTimeout,
		SourceRetryCount:         g.SourceRetryCount,
		SourceRetryWait:          g.SourceRetryWait,
		Type:                     g.Type,
	}
}

// GoogleCloudStorageLinkedService - Linked service for Google Cloud Storage.
type GoogleCloudStorageLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Google Cloud Storage linked service properties.
	TypeProperties *GoogleCloudStorageLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type GoogleCloudStorageLinkedService.
func (g *GoogleCloudStorageLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: g.AdditionalProperties,
		Annotations:          g.Annotations,
		ConnectVia:           g.ConnectVia,
		Description:          g.Description,
		Parameters:           g.Parameters,
		Type:                 g.Type,
	}
}

// GoogleCloudStorageLinkedServiceTypeProperties - Google Cloud Storage linked service properties.
type GoogleCloudStorageLinkedServiceTypeProperties struct {
	// The access key identifier of the Google Cloud Storage Identity and Access Management (IAM) user. Type: string (or Expression
	// with resultType string).
	AccessKeyID any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The secret access key of the Google Cloud Storage Identity and Access Management (IAM) user.
	SecretAccessKey SecretBaseClassification

	// This value specifies the endpoint to access with the Google Cloud Storage Connector. This is an optional property; change
	// it only if you want to try a different service endpoint or want to switch
	// between https and http. Type: string (or Expression with resultType string).
	ServiceURL any
}

// GoogleCloudStorageLocation - The location of Google Cloud Storage dataset.
type GoogleCloudStorageLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the bucketName of Google Cloud Storage. Type: string (or Expression with resultType string)
	BucketName any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any

	// Specify the version of Google Cloud Storage. Type: string (or Expression with resultType string).
	Version any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type GoogleCloudStorageLocation.
func (g *GoogleCloudStorageLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: g.AdditionalProperties,
		FileName:             g.FileName,
		FolderPath:           g.FolderPath,
		Type:                 g.Type,
	}
}

// GoogleCloudStorageReadSettings - Google Cloud Storage read settings.
type GoogleCloudStorageReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// The prefix filter for the Google Cloud Storage object name. Type: string (or Expression with resultType string).
	Prefix any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Google Cloud Storage wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// Google Cloud Storage wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type GoogleCloudStorageReadSettings.
func (g *GoogleCloudStorageReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     g.AdditionalProperties,
		DisableMetricsCollection: g.DisableMetricsCollection,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		Type:                     g.Type,
	}
}

// GoogleSheetsLinkedService - Linked service for GoogleSheets.
type GoogleSheetsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; GoogleSheets linked service properties.
	TypeProperties *GoogleSheetsLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type GoogleSheetsLinkedService.
func (g *GoogleSheetsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: g.AdditionalProperties,
		Annotations:          g.Annotations,
		ConnectVia:           g.ConnectVia,
		Description:          g.Description,
		Parameters:           g.Parameters,
		Type:                 g.Type,
	}
}

// GoogleSheetsLinkedServiceTypeProperties - GoogleSheets linked service type properties.
type GoogleSheetsLinkedServiceTypeProperties struct {
	// REQUIRED; The api token for the GoogleSheets source.
	APIToken SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string
}

// GreenplumDatasetTypeProperties - Greenplum Dataset Properties
type GreenplumDatasetTypeProperties struct {
	// The schema name of Greenplum. Type: string (or Expression with resultType string).
	Schema any

	// The table name of Greenplum. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// GreenplumLinkedService - Greenplum Database linked service.
type GreenplumLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Greenplum Database linked service properties.
	TypeProperties *GreenplumLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type GreenplumLinkedService.
func (g *GreenplumLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: g.AdditionalProperties,
		Annotations:          g.Annotations,
		ConnectVia:           g.ConnectVia,
		Description:          g.Description,
		Parameters:           g.Parameters,
		Type:                 g.Type,
	}
}

// GreenplumLinkedServiceTypeProperties - Greenplum Database linked service properties.
type GreenplumLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Pwd *AzureKeyVaultSecretReference
}

// GreenplumSource - A copy activity Greenplum Database source.
type GreenplumSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type GreenplumSource.
func (g *GreenplumSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     g.AdditionalProperties,
		DisableMetricsCollection: g.DisableMetricsCollection,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		SourceRetryCount:         g.SourceRetryCount,
		SourceRetryWait:          g.SourceRetryWait,
		Type:                     g.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type GreenplumSource.
func (g *GreenplumSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        g.AdditionalColumns,
		AdditionalProperties:     g.AdditionalProperties,
		DisableMetricsCollection: g.DisableMetricsCollection,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		QueryTimeout:             g.QueryTimeout,
		SourceRetryCount:         g.SourceRetryCount,
		SourceRetryWait:          g.SourceRetryWait,
		Type:                     g.Type,
	}
}

// GreenplumTableDataset - Greenplum Database dataset.
type GreenplumTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GreenplumDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type GreenplumTableDataset.
func (g *GreenplumTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: g.AdditionalProperties,
		Annotations:          g.Annotations,
		Description:          g.Description,
		Folder:               g.Folder,
		LinkedServiceName:    g.LinkedServiceName,
		Parameters:           g.Parameters,
		Schema:               g.Schema,
		Structure:            g.Structure,
		Type:                 g.Type,
	}
}

// HBaseLinkedService - HBase server linked service.
type HBaseLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; HBase server linked service properties.
	TypeProperties *HBaseLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type HBaseLinkedService.
func (h *HBaseLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: h.AdditionalProperties,
		Annotations:          h.Annotations,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Type:                 h.Type,
	}
}

// HBaseLinkedServiceTypeProperties - HBase server linked service properties.
type HBaseLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication mechanism to use to connect to the HBase server.
	AuthenticationType *HBaseAuthenticationType

	// REQUIRED; The IP address or host name of the HBase server. (i.e. 192.168.222.160)
	Host any

	// Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over
	// SSL. The default value is false.
	AllowHostNameCNMismatch any

	// Specifies whether to allow self-signed certificates from the server. The default value is false.
	AllowSelfSignedServerCert any

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false.
	EnableSSL any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The partial URL corresponding to the HBase server. (i.e. /gateway/sandbox/hbase/version)
	HTTPPath any

	// The password corresponding to the user name.
	Password SecretBaseClassification

	// The TCP port that the HBase instance uses to listen for client connections. The default value is 9090.
	Port any

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR.
	TrustedCertPath any

	// The user name used to connect to the HBase instance.
	Username any
}

// HBaseObjectDataset - HBase server dataset.
type HBaseObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type HBaseObjectDataset.
func (h *HBaseObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: h.AdditionalProperties,
		Annotations:          h.Annotations,
		Description:          h.Description,
		Folder:               h.Folder,
		LinkedServiceName:    h.LinkedServiceName,
		Parameters:           h.Parameters,
		Schema:               h.Schema,
		Structure:            h.Structure,
		Type:                 h.Type,
	}
}

// HBaseSource - A copy activity HBase server source.
type HBaseSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type HBaseSource.
func (h *HBaseSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     h.AdditionalProperties,
		DisableMetricsCollection: h.DisableMetricsCollection,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		Type:                     h.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type HBaseSource.
func (h *HBaseSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        h.AdditionalColumns,
		AdditionalProperties:     h.AdditionalProperties,
		DisableMetricsCollection: h.DisableMetricsCollection,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		QueryTimeout:             h.QueryTimeout,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		Type:                     h.Type,
	}
}

// HDInsightHiveActivity - HDInsight Hive activity type.
type HDInsightHiveActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; HDInsight Hive activity properties.
	TypeProperties *HDInsightHiveActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type HDInsightHiveActivity.
func (h *HDInsightHiveActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: h.AdditionalProperties,
		DependsOn:            h.DependsOn,
		Description:          h.Description,
		Name:                 h.Name,
		OnInactiveMarkAs:     h.OnInactiveMarkAs,
		State:                h.State,
		Type:                 h.Type,
		UserProperties:       h.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type HDInsightHiveActivity.
func (h *HDInsightHiveActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: h.AdditionalProperties,
		DependsOn:            h.DependsOn,
		Description:          h.Description,
		LinkedServiceName:    h.LinkedServiceName,
		Name:                 h.Name,
		OnInactiveMarkAs:     h.OnInactiveMarkAs,
		Policy:               h.Policy,
		State:                h.State,
		Type:                 h.Type,
		UserProperties:       h.UserProperties,
	}
}

// HDInsightHiveActivityTypeProperties - HDInsight Hive activity properties.
type HDInsightHiveActivityTypeProperties struct {
	// User specified arguments to HDInsightActivity.
	Arguments []any

	// Allows user to specify defines for Hive job request.
	Defines map[string]any

	// Debug info option.
	GetDebugInfo *HDInsightActivityDebugInfoOption

	// Query timeout value (in minutes). Effective when the HDInsight cluster is with ESP (Enterprise Security Package)
	QueryTimeout *int32

	// Script linked service reference.
	ScriptLinkedService *LinkedServiceReference

	// Script path. Type: string (or Expression with resultType string).
	ScriptPath any

	// Storage linked service references.
	StorageLinkedServices []*LinkedServiceReference

	// User specified arguments under hivevar namespace.
	Variables map[string]any
}

// HDInsightLinkedService - HDInsight linked service.
type HDInsightLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; HDInsight linked service properties.
	TypeProperties *HDInsightLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type HDInsightLinkedService.
func (h *HDInsightLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: h.AdditionalProperties,
		Annotations:          h.Annotations,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Type:                 h.Type,
	}
}

// HDInsightLinkedServiceTypeProperties - HDInsight linked service properties.
type HDInsightLinkedServiceTypeProperties struct {
	// REQUIRED; HDInsight cluster URI. Type: string (or Expression with resultType string).
	ClusterURI any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2. Type: string (or Expression with resultType
	// string).
	FileSystem any

	// A reference to the Azure SQL linked service that points to the HCatalog database.
	HcatalogLinkedServiceName *LinkedServiceReference

	// Specify if the HDInsight is created with ESP (Enterprise Security Package). Type: Boolean.
	IsEspEnabled any

	// The Azure Storage linked service reference.
	LinkedServiceName *LinkedServiceReference

	// HDInsight cluster password.
	Password SecretBaseClassification

	// HDInsight cluster user name. Type: string (or Expression with resultType string).
	UserName any
}

// HDInsightMapReduceActivity - HDInsight MapReduce activity type.
type HDInsightMapReduceActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; HDInsight MapReduce activity properties.
	TypeProperties *HDInsightMapReduceActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type HDInsightMapReduceActivity.
func (h *HDInsightMapReduceActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: h.AdditionalProperties,
		DependsOn:            h.DependsOn,
		Description:          h.Description,
		Name:                 h.Name,
		OnInactiveMarkAs:     h.OnInactiveMarkAs,
		State:                h.State,
		Type:                 h.Type,
		UserProperties:       h.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type HDInsightMapReduceActivity.
func (h *HDInsightMapReduceActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: h.AdditionalProperties,
		DependsOn:            h.DependsOn,
		Description:          h.Description,
		LinkedServiceName:    h.LinkedServiceName,
		Name:                 h.Name,
		OnInactiveMarkAs:     h.OnInactiveMarkAs,
		Policy:               h.Policy,
		State:                h.State,
		Type:                 h.Type,
		UserProperties:       h.UserProperties,
	}
}

// HDInsightMapReduceActivityTypeProperties - HDInsight MapReduce activity properties.
type HDInsightMapReduceActivityTypeProperties struct {
	// REQUIRED; Class name. Type: string (or Expression with resultType string).
	ClassName any

	// REQUIRED; Jar path. Type: string (or Expression with resultType string).
	JarFilePath any

	// User specified arguments to HDInsightActivity.
	Arguments []any

	// Allows user to specify defines for the MapReduce job request.
	Defines map[string]any

	// Debug info option.
	GetDebugInfo *HDInsightActivityDebugInfoOption

	// Jar libs.
	JarLibs []any

	// Jar linked service reference.
	JarLinkedService *LinkedServiceReference

	// Storage linked service references.
	StorageLinkedServices []*LinkedServiceReference
}

// HDInsightOnDemandLinkedService - HDInsight ondemand linked service.
type HDInsightOnDemandLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; HDInsight ondemand linked service properties.
	TypeProperties *HDInsightOnDemandLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type HDInsightOnDemandLinkedService.
func (h *HDInsightOnDemandLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: h.AdditionalProperties,
		Annotations:          h.Annotations,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Type:                 h.Type,
	}
}

// HDInsightOnDemandLinkedServiceTypeProperties - HDInsight ondemand linked service properties.
type HDInsightOnDemandLinkedServiceTypeProperties struct {
	// REQUIRED; The resource group where the cluster belongs. Type: string (or Expression with resultType string).
	ClusterResourceGroup any

	// REQUIRED; Number of worker/data nodes in the cluster. Suggestion value: 4. Type: string (or Expression with resultType
	// string).
	ClusterSize any

	// REQUIRED; The customer’s subscription to host the cluster. Type: string (or Expression with resultType string).
	HostSubscriptionID any

	// REQUIRED; Azure Storage linked service to be used by the on-demand cluster for storing and processing data.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; The Tenant id/name to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant any

	// REQUIRED; The allowed idle time for the on-demand HDInsight cluster. Specifies how long the on-demand HDInsight cluster
	// stays alive after completion of an activity run if there are no other active jobs in the
	// cluster. The minimum value is 5 mins. Type: string (or Expression with resultType string).
	TimeToLive any

	// REQUIRED; Version of the HDInsight cluster. Type: string (or Expression with resultType string).
	Version any

	// Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them
	// on your behalf.
	AdditionalLinkedServiceNames []*LinkedServiceReference

	// The prefix of cluster name, postfix will be distinct with timestamp. Type: string (or Expression with resultType string).
	ClusterNamePrefix any

	// The password to access the cluster.
	ClusterPassword SecretBaseClassification

	// The password to SSH remotely connect cluster’s node (for Linux).
	ClusterSSHPassword SecretBaseClassification

	// The username to SSH remotely connect to cluster’s node (for Linux). Type: string (or Expression with resultType string).
	ClusterSSHUserName any

	// The cluster type. Type: string (or Expression with resultType string).
	ClusterType any

	// The username to access the cluster. Type: string (or Expression with resultType string).
	ClusterUserName any

	// Specifies the core configuration parameters (as in core-site.xml) for the HDInsight cluster to be created.
	CoreConfiguration any

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// Specifies the size of the data node for the HDInsight cluster.
	DataNodeSize any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Specifies the HBase configuration parameters (hbase-site.xml) for the HDInsight cluster.
	HBaseConfiguration any

	// The name of Azure SQL linked service that point to the HCatalog database. The on-demand HDInsight cluster is created by
	// using the Azure SQL database as the metastore.
	HcatalogLinkedServiceName *LinkedServiceReference

	// Specifies the HDFS configuration parameters (hdfs-site.xml) for the HDInsight cluster.
	HdfsConfiguration any

	// Specifies the size of the head node for the HDInsight cluster.
	HeadNodeSize any

	// Specifies the hive configuration parameters (hive-site.xml) for the HDInsight cluster.
	HiveConfiguration any

	// Specifies the MapReduce configuration parameters (mapred-site.xml) for the HDInsight cluster.
	MapReduceConfiguration any

	// Specifies the Oozie configuration parameters (oozie-site.xml) for the HDInsight cluster.
	OozieConfiguration any

	// Custom script actions to run on HDI ondemand cluster once it's up. Please refer to
	// https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
	ScriptActions []*ScriptAction

	// The service principal id for the hostSubscriptionId. Type: string (or Expression with resultType string).
	ServicePrincipalID any

	// The key for the service principal id.
	ServicePrincipalKey SecretBaseClassification

	// The version of spark if the cluster type is 'spark'. Type: string (or Expression with resultType string).
	SparkVersion any

	// Specifies the Storm configuration parameters (storm-site.xml) for the HDInsight cluster.
	StormConfiguration any

	// The ARM resource ID for the subnet in the vNet. If virtualNetworkId was specified, then this property is required. Type:
	// string (or Expression with resultType string).
	SubnetName any

	// The ARM resource ID for the vNet to which the cluster should be joined after creation. Type: string (or Expression with
	// resultType string).
	VirtualNetworkID any

	// Specifies the Yarn configuration parameters (yarn-site.xml) for the HDInsight cluster.
	YarnConfiguration any

	// Specifies the size of the Zoo Keeper node for the HDInsight cluster.
	ZookeeperNodeSize any
}

// HDInsightPigActivity - HDInsight Pig activity type.
type HDInsightPigActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; HDInsight Pig activity properties.
	TypeProperties *HDInsightPigActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type HDInsightPigActivity.
func (h *HDInsightPigActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: h.AdditionalProperties,
		DependsOn:            h.DependsOn,
		Description:          h.Description,
		Name:                 h.Name,
		OnInactiveMarkAs:     h.OnInactiveMarkAs,
		State:                h.State,
		Type:                 h.Type,
		UserProperties:       h.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type HDInsightPigActivity.
func (h *HDInsightPigActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: h.AdditionalProperties,
		DependsOn:            h.DependsOn,
		Description:          h.Description,
		LinkedServiceName:    h.LinkedServiceName,
		Name:                 h.Name,
		OnInactiveMarkAs:     h.OnInactiveMarkAs,
		Policy:               h.Policy,
		State:                h.State,
		Type:                 h.Type,
		UserProperties:       h.UserProperties,
	}
}

// HDInsightPigActivityTypeProperties - HDInsight Pig activity properties.
type HDInsightPigActivityTypeProperties struct {
	// User specified arguments to HDInsightActivity. Type: array (or Expression with resultType array).
	Arguments any

	// Allows user to specify defines for Pig job request.
	Defines map[string]any

	// Debug info option.
	GetDebugInfo *HDInsightActivityDebugInfoOption

	// Script linked service reference.
	ScriptLinkedService *LinkedServiceReference

	// Script path. Type: string (or Expression with resultType string).
	ScriptPath any

	// Storage linked service references.
	StorageLinkedServices []*LinkedServiceReference
}

// HDInsightSparkActivity - HDInsight Spark activity.
type HDInsightSparkActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; HDInsight spark activity properties.
	TypeProperties *HDInsightSparkActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type HDInsightSparkActivity.
func (h *HDInsightSparkActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: h.AdditionalProperties,
		DependsOn:            h.DependsOn,
		Description:          h.Description,
		Name:                 h.Name,
		OnInactiveMarkAs:     h.OnInactiveMarkAs,
		State:                h.State,
		Type:                 h.Type,
		UserProperties:       h.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type HDInsightSparkActivity.
func (h *HDInsightSparkActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: h.AdditionalProperties,
		DependsOn:            h.DependsOn,
		Description:          h.Description,
		LinkedServiceName:    h.LinkedServiceName,
		Name:                 h.Name,
		OnInactiveMarkAs:     h.OnInactiveMarkAs,
		Policy:               h.Policy,
		State:                h.State,
		Type:                 h.Type,
		UserProperties:       h.UserProperties,
	}
}

// HDInsightSparkActivityTypeProperties - HDInsight spark activity properties.
type HDInsightSparkActivityTypeProperties struct {
	// REQUIRED; The relative path to the root folder of the code/package to be executed. Type: string (or Expression with resultType
	// string).
	EntryFilePath any

	// REQUIRED; The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or Expression with resultType
	// string).
	RootPath any

	// The user-specified arguments to HDInsightSparkActivity.
	Arguments []any

	// The application's Java/Spark main class.
	ClassName *string

	// Debug info option.
	GetDebugInfo *HDInsightActivityDebugInfoOption

	// The user to impersonate that will execute the job. Type: string (or Expression with resultType string).
	ProxyUser any

	// Spark configuration property.
	SparkConfig map[string]any

	// The storage linked service for uploading the entry file and dependencies, and for receiving logs.
	SparkJobLinkedService *LinkedServiceReference
}

// HDInsightStreamingActivity - HDInsight streaming activity type.
type HDInsightStreamingActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; HDInsight streaming activity properties.
	TypeProperties *HDInsightStreamingActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type HDInsightStreamingActivity.
func (h *HDInsightStreamingActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: h.AdditionalProperties,
		DependsOn:            h.DependsOn,
		Description:          h.Description,
		Name:                 h.Name,
		OnInactiveMarkAs:     h.OnInactiveMarkAs,
		State:                h.State,
		Type:                 h.Type,
		UserProperties:       h.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type HDInsightStreamingActivity.
func (h *HDInsightStreamingActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: h.AdditionalProperties,
		DependsOn:            h.DependsOn,
		Description:          h.Description,
		LinkedServiceName:    h.LinkedServiceName,
		Name:                 h.Name,
		OnInactiveMarkAs:     h.OnInactiveMarkAs,
		Policy:               h.Policy,
		State:                h.State,
		Type:                 h.Type,
		UserProperties:       h.UserProperties,
	}
}

// HDInsightStreamingActivityTypeProperties - HDInsight streaming activity properties.
type HDInsightStreamingActivityTypeProperties struct {
	// REQUIRED; Paths to streaming job files. Can be directories.
	FilePaths []any

	// REQUIRED; Input blob path. Type: string (or Expression with resultType string).
	Input any

	// REQUIRED; Mapper executable name. Type: string (or Expression with resultType string).
	Mapper any

	// REQUIRED; Output blob path. Type: string (or Expression with resultType string).
	Output any

	// REQUIRED; Reducer executable name. Type: string (or Expression with resultType string).
	Reducer any

	// User specified arguments to HDInsightActivity.
	Arguments []any

	// Combiner executable name. Type: string (or Expression with resultType string).
	Combiner any

	// Command line environment values.
	CommandEnvironment []any

	// Allows user to specify defines for streaming job request.
	Defines map[string]any

	// Linked service reference where the files are located.
	FileLinkedService *LinkedServiceReference

	// Debug info option.
	GetDebugInfo *HDInsightActivityDebugInfoOption

	// Storage linked service references.
	StorageLinkedServices []*LinkedServiceReference
}

// HTTPDataset - A file in an HTTP web server.
type HTTPDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *HTTPDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type HTTPDataset.
func (h *HTTPDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: h.AdditionalProperties,
		Annotations:          h.Annotations,
		Description:          h.Description,
		Folder:               h.Folder,
		LinkedServiceName:    h.LinkedServiceName,
		Parameters:           h.Parameters,
		Schema:               h.Schema,
		Structure:            h.Structure,
		Type:                 h.Type,
	}
}

// HTTPDatasetTypeProperties - Properties specific to this dataset type.
type HTTPDatasetTypeProperties struct {
	// The headers for the HTTP Request. e.g. request-header-name-1:request-header-value-1 … request-header-name-n:request-header-value-n
	// Type: string (or Expression with resultType string).
	AdditionalHeaders any

	// The data compression method used on files.
	Compression *DatasetCompression

	// The format of files.
	Format DatasetStorageFormatClassification

	// The relative URL based on the URL in the HttpLinkedService refers to an HTTP file Type: string (or Expression with resultType
	// string).
	RelativeURL any

	// The body for the HTTP request. Type: string (or Expression with resultType string).
	RequestBody any

	// The HTTP method for the HTTP request. Type: string (or Expression with resultType string).
	RequestMethod any
}

// HTTPLinkedService - Linked service for an HTTP source.
type HTTPLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Properties specific to this linked service type.
	TypeProperties *HTTPLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type HTTPLinkedService.
func (h *HTTPLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: h.AdditionalProperties,
		Annotations:          h.Annotations,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Type:                 h.Type,
	}
}

// HTTPLinkedServiceTypeProperties - Properties specific to this linked service type.
type HTTPLinkedServiceTypeProperties struct {
	// REQUIRED; The base URL of the HTTP endpoint, e.g. https://www.microsoft.com. Type: string (or Expression with resultType
	// string).
	URL any

	// The additional HTTP headers in the request to RESTful API used for authorization. Type: object (or Expression with resultType
	// object).
	AuthHeaders any

	// The authentication type to be used to connect to the HTTP server.
	AuthenticationType *HTTPAuthenticationType

	// Thumbprint of certificate for ClientCertificate authentication. Only valid for on-premises copy. For on-premises copy with
	// ClientCertificate authentication, either CertThumbprint or
	// EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
	CertThumbprint any

	// Base64 encoded certificate data for ClientCertificate authentication. For on-premises copy with ClientCertificate authentication,
	// either CertThumbprint or EmbeddedCertData/Password should be
	// specified. Type: string (or Expression with resultType string).
	EmbeddedCertData any

	// If true, validate the HTTPS server SSL certificate. Default value is true. Type: boolean (or Expression with resultType
	// boolean).
	EnableServerCertificateValidation any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData authentication.
	Password SecretBaseClassification

	// User name for Basic, Digest, or Windows authentication. Type: string (or Expression with resultType string).
	UserName any
}

// HTTPReadSettings - Http read settings.
type HTTPReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
	AdditionalHeaders any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
	RequestBody any

	// The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
	RequestMethod any

	// Specifies the timeout for a HTTP client to get HTTP response from HTTP server. Type: string (or Expression with resultType
	// string).
	RequestTimeout any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type HTTPReadSettings.
func (h *HTTPReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     h.AdditionalProperties,
		DisableMetricsCollection: h.DisableMetricsCollection,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		Type:                     h.Type,
	}
}

// HTTPServerLocation - The location of http server.
type HTTPServerLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any

	// Specify the relativeUrl of http server. Type: string (or Expression with resultType string)
	RelativeURL any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type HTTPServerLocation.
func (h *HTTPServerLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: h.AdditionalProperties,
		FileName:             h.FileName,
		FolderPath:           h.FolderPath,
		Type:                 h.Type,
	}
}

// HTTPSource - A copy activity source for an HTTP file.
type HTTPSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies the timeout for a HTTP client to get HTTP response from HTTP server. The default value is equivalent to System.Net.HttpWebRequest.Timeout.
	// Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type HTTPSource.
func (h *HTTPSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     h.AdditionalProperties,
		DisableMetricsCollection: h.DisableMetricsCollection,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		Type:                     h.Type,
	}
}

// HdfsLinkedService - Hadoop Distributed File System (HDFS) linked service.
type HdfsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; HDFS linked service properties.
	TypeProperties *HdfsLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type HdfsLinkedService.
func (h *HdfsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: h.AdditionalProperties,
		Annotations:          h.Annotations,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Type:                 h.Type,
	}
}

// HdfsLinkedServiceTypeProperties - HDFS linked service properties.
type HdfsLinkedServiceTypeProperties struct {
	// REQUIRED; The URL of the HDFS service endpoint, e.g. http://myhostname:50070/webhdfs/v1 . Type: string (or Expression with
	// resultType string).
	URL any

	// Type of authentication used to connect to the HDFS. Possible values are: Anonymous and Windows. Type: string (or Expression
	// with resultType string).
	AuthenticationType any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Password for Windows authentication.
	Password SecretBaseClassification

	// User name for Windows authentication. Type: string (or Expression with resultType string).
	UserName any
}

// HdfsLocation - The location of HDFS.
type HdfsLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type HdfsLocation.
func (h *HdfsLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: h.AdditionalProperties,
		FileName:             h.FileName,
		FolderPath:           h.FolderPath,
		Type:                 h.Type,
	}
}

// HdfsReadSettings - HDFS read settings.
type HdfsReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies Distcp-related settings.
	DistcpSettings *DistcpSettings

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// HDFS wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// HDFS wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type HdfsReadSettings.
func (h *HdfsReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     h.AdditionalProperties,
		DisableMetricsCollection: h.DisableMetricsCollection,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		Type:                     h.Type,
	}
}

// HdfsSource - A copy activity HDFS source.
type HdfsSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies Distcp-related settings.
	DistcpSettings *DistcpSettings

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type HdfsSource.
func (h *HdfsSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     h.AdditionalProperties,
		DisableMetricsCollection: h.DisableMetricsCollection,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		Type:                     h.Type,
	}
}

// HiveDatasetTypeProperties - Hive Properties
type HiveDatasetTypeProperties struct {
	// The schema name of the Hive. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the Hive. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// HiveLinkedService - Hive Server linked service.
type HiveLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Hive Server linked service properties.
	TypeProperties *HiveLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type HiveLinkedService.
func (h *HiveLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: h.AdditionalProperties,
		Annotations:          h.Annotations,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Type:                 h.Type,
	}
}

// HiveLinkedServiceTypeProperties - Hive Server linked service properties.
type HiveLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication method used to access the Hive server.
	AuthenticationType *HiveAuthenticationType

	// REQUIRED; IP address or host name of the Hive server, separated by ';' for multiple hosts (only when serviceDiscoveryMode
	// is enable).
	Host any

	// Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over
	// SSL. The default value is false.
	AllowHostNameCNMismatch any

	// Specifies whether to allow self-signed certificates from the server. The default value is false.
	AllowSelfSignedServerCert any

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false.
	EnableSSL any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The partial URL corresponding to the Hive server.
	HTTPPath any

	// The password corresponding to the user name that you provided in the Username field
	Password SecretBaseClassification

	// The TCP port that the Hive server uses to listen for client connections.
	Port any

	// The type of Hive server.
	ServerType *HiveServerType

	// true to indicate using the ZooKeeper service, false not.
	ServiceDiscoveryMode any

	// The transport protocol to use in the Thrift layer.
	ThriftTransportProtocol *HiveThriftTransportProtocol

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR.
	TrustedCertPath any

	// Specifies whether the driver uses native HiveQL queries,or converts them into an equivalent form in HiveQL.
	UseNativeQuery any

	// Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is
	// false.
	UseSystemTrustStore any

	// The user name that you use to access Hive Server.
	Username any

	// The namespace on ZooKeeper under which Hive Server 2 nodes are added.
	ZooKeeperNameSpace any
}

// HiveObjectDataset - Hive Server dataset.
type HiveObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *HiveDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type HiveObjectDataset.
func (h *HiveObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: h.AdditionalProperties,
		Annotations:          h.Annotations,
		Description:          h.Description,
		Folder:               h.Folder,
		LinkedServiceName:    h.LinkedServiceName,
		Parameters:           h.Parameters,
		Schema:               h.Schema,
		Structure:            h.Structure,
		Type:                 h.Type,
	}
}

// HiveSource - A copy activity Hive Server source.
type HiveSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type HiveSource.
func (h *HiveSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     h.AdditionalProperties,
		DisableMetricsCollection: h.DisableMetricsCollection,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		Type:                     h.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type HiveSource.
func (h *HiveSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        h.AdditionalColumns,
		AdditionalProperties:     h.AdditionalProperties,
		DisableMetricsCollection: h.DisableMetricsCollection,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		QueryTimeout:             h.QueryTimeout,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		Type:                     h.Type,
	}
}

// HubspotLinkedService - Hubspot Service linked service.
type HubspotLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Hubspot Service linked service properties.
	TypeProperties *HubspotLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type HubspotLinkedService.
func (h *HubspotLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: h.AdditionalProperties,
		Annotations:          h.Annotations,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Type:                 h.Type,
	}
}

// HubspotLinkedServiceTypeProperties - Hubspot Service linked service properties.
type HubspotLinkedServiceTypeProperties struct {
	// REQUIRED; The client ID associated with your Hubspot application.
	ClientID any

	// The access token obtained when initially authenticating your OAuth integration.
	AccessToken SecretBaseClassification

	// The client secret associated with your Hubspot application.
	ClientSecret SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The refresh token obtained when initially authenticating your OAuth integration.
	RefreshToken SecretBaseClassification

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification any
}

// HubspotObjectDataset - Hubspot Service dataset.
type HubspotObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type HubspotObjectDataset.
func (h *HubspotObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: h.AdditionalProperties,
		Annotations:          h.Annotations,
		Description:          h.Description,
		Folder:               h.Folder,
		LinkedServiceName:    h.LinkedServiceName,
		Parameters:           h.Parameters,
		Schema:               h.Schema,
		Structure:            h.Structure,
		Type:                 h.Type,
	}
}

// HubspotSource - A copy activity Hubspot Service source.
type HubspotSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type HubspotSource.
func (h *HubspotSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     h.AdditionalProperties,
		DisableMetricsCollection: h.DisableMetricsCollection,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		Type:                     h.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type HubspotSource.
func (h *HubspotSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        h.AdditionalColumns,
		AdditionalProperties:     h.AdditionalProperties,
		DisableMetricsCollection: h.DisableMetricsCollection,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		QueryTimeout:             h.QueryTimeout,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		Type:                     h.Type,
	}
}

// IfConditionActivity - This activity evaluates a boolean expression and executes either the activities under the ifTrueActivities
// property or the ifFalseActivities property depending on the result of the expression.
type IfConditionActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; IfCondition activity properties.
	TypeProperties *IfConditionActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type IfConditionActivity.
func (i *IfConditionActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: i.AdditionalProperties,
		DependsOn:            i.DependsOn,
		Description:          i.Description,
		Name:                 i.Name,
		OnInactiveMarkAs:     i.OnInactiveMarkAs,
		State:                i.State,
		Type:                 i.Type,
		UserProperties:       i.UserProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type IfConditionActivity.
func (i *IfConditionActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		AdditionalProperties: i.AdditionalProperties,
		DependsOn:            i.DependsOn,
		Description:          i.Description,
		Name:                 i.Name,
		OnInactiveMarkAs:     i.OnInactiveMarkAs,
		State:                i.State,
		Type:                 i.Type,
		UserProperties:       i.UserProperties,
	}
}

// IfConditionActivityTypeProperties - IfCondition activity properties.
type IfConditionActivityTypeProperties struct {
	// REQUIRED; An expression that would evaluate to Boolean. This is used to determine the block of activities (ifTrueActivities
	// or ifFalseActivities) that will be executed.
	Expression *Expression

	// List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the
	// activity will exit without any action.
	IfFalseActivities []ActivityClassification

	// List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the
	// activity will exit without any action.
	IfTrueActivities []ActivityClassification
}

// ImpalaDatasetTypeProperties - Impala Dataset Properties
type ImpalaDatasetTypeProperties struct {
	// The schema name of the Impala. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the Impala. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// ImpalaLinkedService - Impala server linked service.
type ImpalaLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Impala server linked service properties.
	TypeProperties *ImpalaLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type ImpalaLinkedService.
func (i *ImpalaLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: i.AdditionalProperties,
		Annotations:          i.Annotations,
		ConnectVia:           i.ConnectVia,
		Description:          i.Description,
		Parameters:           i.Parameters,
		Type:                 i.Type,
	}
}

// ImpalaLinkedServiceTypeProperties - Impala server linked service properties.
type ImpalaLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication type to use.
	AuthenticationType *ImpalaAuthenticationType

	// REQUIRED; The IP address or host name of the Impala server. (i.e. 192.168.222.160)
	Host any

	// Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over
	// SSL. The default value is false.
	AllowHostNameCNMismatch any

	// Specifies whether to allow self-signed certificates from the server. The default value is false.
	AllowSelfSignedServerCert any

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false.
	EnableSSL any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The password corresponding to the user name when using UsernameAndPassword.
	Password SecretBaseClassification

	// The TCP port that the Impala server uses to listen for client connections. The default value is 21050.
	Port any

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR.
	TrustedCertPath any

	// Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is
	// false.
	UseSystemTrustStore any

	// The user name used to access the Impala server. The default value is anonymous when using SASLUsername.
	Username any
}

// ImpalaObjectDataset - Impala server dataset.
type ImpalaObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *ImpalaDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type ImpalaObjectDataset.
func (i *ImpalaObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: i.AdditionalProperties,
		Annotations:          i.Annotations,
		Description:          i.Description,
		Folder:               i.Folder,
		LinkedServiceName:    i.LinkedServiceName,
		Parameters:           i.Parameters,
		Schema:               i.Schema,
		Structure:            i.Structure,
		Type:                 i.Type,
	}
}

// ImpalaSource - A copy activity Impala server source.
type ImpalaSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type ImpalaSource.
func (i *ImpalaSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     i.AdditionalProperties,
		DisableMetricsCollection: i.DisableMetricsCollection,
		MaxConcurrentConnections: i.MaxConcurrentConnections,
		SourceRetryCount:         i.SourceRetryCount,
		SourceRetryWait:          i.SourceRetryWait,
		Type:                     i.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type ImpalaSource.
func (i *ImpalaSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        i.AdditionalColumns,
		AdditionalProperties:     i.AdditionalProperties,
		DisableMetricsCollection: i.DisableMetricsCollection,
		MaxConcurrentConnections: i.MaxConcurrentConnections,
		QueryTimeout:             i.QueryTimeout,
		SourceRetryCount:         i.SourceRetryCount,
		SourceRetryWait:          i.SourceRetryWait,
		Type:                     i.Type,
	}
}

// ImportSettings - Import command settings.
type ImportSettings struct {
	// REQUIRED; The import setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
}

// GetImportSettings implements the ImportSettingsClassification interface for type ImportSettings.
func (i *ImportSettings) GetImportSettings() *ImportSettings { return i }

// InformixLinkedService - Informix linked service.
type InformixLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Informix linked service properties.
	TypeProperties *InformixLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type InformixLinkedService.
func (i *InformixLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: i.AdditionalProperties,
		Annotations:          i.Annotations,
		ConnectVia:           i.ConnectVia,
		Description:          i.Description,
		Parameters:           i.Parameters,
		Type:                 i.Type,
	}
}

// InformixLinkedServiceTypeProperties - Informix linked service properties.
type InformixLinkedServiceTypeProperties struct {
	// REQUIRED; The non-access credential portion of the connection string as well as an optional encrypted credential. Type:
	// string, or SecureString, or AzureKeyVaultSecretReference, or Expression with resultType
	// string.
	ConnectionString any

	// Type of authentication used to connect to the Informix as ODBC data store. Possible values are: Anonymous and Basic. Type:
	// string (or Expression with resultType string).
	AuthenticationType any

	// The access credential portion of the connection string specified in driver-specific property-value format.
	Credential SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Password for Basic authentication.
	Password SecretBaseClassification

	// User name for Basic authentication. Type: string (or Expression with resultType string).
	UserName any
}

// InformixSink - A copy activity Informix sink.
type InformixSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to execute before starting the copy. Type: string (or Expression with resultType string).
	PreCopyScript any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type InformixSink.
func (i *InformixSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     i.AdditionalProperties,
		DisableMetricsCollection: i.DisableMetricsCollection,
		MaxConcurrentConnections: i.MaxConcurrentConnections,
		SinkRetryCount:           i.SinkRetryCount,
		SinkRetryWait:            i.SinkRetryWait,
		Type:                     i.Type,
		WriteBatchSize:           i.WriteBatchSize,
		WriteBatchTimeout:        i.WriteBatchTimeout,
	}
}

// InformixSource - A copy activity source for Informix.
type InformixSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type InformixSource.
func (i *InformixSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     i.AdditionalProperties,
		DisableMetricsCollection: i.DisableMetricsCollection,
		MaxConcurrentConnections: i.MaxConcurrentConnections,
		SourceRetryCount:         i.SourceRetryCount,
		SourceRetryWait:          i.SourceRetryWait,
		Type:                     i.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type InformixSource.
func (i *InformixSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        i.AdditionalColumns,
		AdditionalProperties:     i.AdditionalProperties,
		DisableMetricsCollection: i.DisableMetricsCollection,
		MaxConcurrentConnections: i.MaxConcurrentConnections,
		QueryTimeout:             i.QueryTimeout,
		SourceRetryCount:         i.SourceRetryCount,
		SourceRetryWait:          i.SourceRetryWait,
		Type:                     i.Type,
	}
}

// InformixTableDataset - The Informix table dataset.
type InformixTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Informix table dataset properties.
	TypeProperties *InformixTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type InformixTableDataset.
func (i *InformixTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: i.AdditionalProperties,
		Annotations:          i.Annotations,
		Description:          i.Description,
		Folder:               i.Folder,
		LinkedServiceName:    i.LinkedServiceName,
		Parameters:           i.Parameters,
		Schema:               i.Schema,
		Structure:            i.Structure,
		Type:                 i.Type,
	}
}

// InformixTableDatasetTypeProperties - Informix table dataset properties.
type InformixTableDatasetTypeProperties struct {
	// The Informix table name. Type: string (or Expression with resultType string).
	TableName any
}

// IntegrationRuntime - Azure Data Factory nested object which serves as a compute resource for activities.
type IntegrationRuntime struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Integration runtime description.
	Description *string
}

// GetIntegrationRuntime implements the IntegrationRuntimeClassification interface for type IntegrationRuntime.
func (i *IntegrationRuntime) GetIntegrationRuntime() *IntegrationRuntime { return i }

// IntegrationRuntimeAuthKeys - The integration runtime authentication keys.
type IntegrationRuntimeAuthKeys struct {
	// The primary integration runtime authentication key.
	AuthKey1 *string

	// The secondary integration runtime authentication key.
	AuthKey2 *string
}

// IntegrationRuntimeComputeProperties - The compute resource properties for managed integration runtime.
type IntegrationRuntimeComputeProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// CopyComputeScale properties for managed integration runtime.
	CopyComputeScaleProperties *CopyComputeScaleProperties

	// Data flow properties for managed integration runtime.
	DataFlowProperties *IntegrationRuntimeDataFlowProperties

	// The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
	Location *string

	// Maximum parallel executions count per node for managed integration runtime.
	MaxParallelExecutionsPerNode *int32

	// The node size requirement to managed integration runtime.
	NodeSize *string

	// The required number of nodes for managed integration runtime.
	NumberOfNodes *int32

	// PipelineExternalComputeScale properties for managed integration runtime.
	PipelineExternalComputeScaleProperties *PipelineExternalComputeScaleProperties

	// VNet properties for managed integration runtime.
	VNetProperties *IntegrationRuntimeVNetProperties
}

// IntegrationRuntimeConnectionInfo - Connection information for encrypting the on-premises data source credentials.
type IntegrationRuntimeConnectionInfo struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The on-premises integration runtime host URL.
	HostServiceURI *string

	// READ-ONLY; The integration runtime SSL certificate thumbprint. Click-Once application uses it to do server validation.
	IdentityCertThumbprint *string

	// READ-ONLY; Whether the identity certificate is expired.
	IsIdentityCertExprired *bool

	// READ-ONLY; The public key for encrypting a credential when transferring the credential to the integration runtime.
	PublicKey *string

	// READ-ONLY; The token generated in service. Callers use this token to authenticate to integration runtime.
	ServiceToken *string

	// READ-ONLY; The integration runtime version.
	Version *string
}

// IntegrationRuntimeCustomSetupScriptProperties - Custom setup script properties for a managed dedicated integration runtime.
type IntegrationRuntimeCustomSetupScriptProperties struct {
	// The URI of the Azure blob container that contains the custom setup script.
	BlobContainerURI *string

	// The SAS token of the Azure blob container.
	SasToken *SecureString
}

// IntegrationRuntimeCustomerVirtualNetwork - The definition and properties of virtual network to which Azure-SSIS integration
// runtime will join.
type IntegrationRuntimeCustomerVirtualNetwork struct {
	// The ID of subnet to which Azure-SSIS integration runtime will join.
	SubnetID *string
}

// IntegrationRuntimeDataFlowProperties - Data flow properties for managed integration runtime.
type IntegrationRuntimeDataFlowProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Cluster will not be recycled and it will be used in next data flow activity run until TTL (time to live) is reached if
	// this is set as false. Default is true.
	Cleanup *bool

	// Compute type of the cluster which will execute data flow job.
	ComputeType *DataFlowComputeType

	// Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
	CoreCount *int32

	// Custom properties are used to tune the data flow runtime performance.
	CustomProperties []*IntegrationRuntimeDataFlowPropertiesCustomPropertiesItem

	// Time to live (in minutes) setting of the cluster which will execute data flow job.
	TimeToLive *int32
}

type IntegrationRuntimeDataFlowPropertiesCustomPropertiesItem struct {
	// Name of custom property.
	Name *string

	// Value of custom property.
	Value *string
}

// IntegrationRuntimeDataProxyProperties - Data proxy properties for a managed dedicated integration runtime.
type IntegrationRuntimeDataProxyProperties struct {
	// The self-hosted integration runtime reference.
	ConnectVia *EntityReference

	// The path to contain the staged data in the Blob storage.
	Path *string

	// The staging linked service reference.
	StagingLinkedService *EntityReference
}

// IntegrationRuntimeDebugResource - Integration runtime debug resource.
type IntegrationRuntimeDebugResource struct {
	// REQUIRED; Integration runtime properties.
	Properties IntegrationRuntimeClassification

	// The resource name.
	Name *string
}

// IntegrationRuntimeListResponse - A list of integration runtime resources.
type IntegrationRuntimeListResponse struct {
	// REQUIRED; List of integration runtimes.
	Value []*IntegrationRuntimeResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// IntegrationRuntimeMonitoringData - Get monitoring data response.
type IntegrationRuntimeMonitoringData struct {
	// Integration runtime name.
	Name *string

	// Integration runtime node monitoring data.
	Nodes []*IntegrationRuntimeNodeMonitoringData
}

// IntegrationRuntimeNodeIPAddress - The IP address of self-hosted integration runtime node.
type IntegrationRuntimeNodeIPAddress struct {
	// READ-ONLY; The IP address of self-hosted integration runtime node.
	IPAddress *string
}

// IntegrationRuntimeNodeMonitoringData - Monitoring data for integration runtime node.
type IntegrationRuntimeNodeMonitoringData struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; Available memory (MB) on the integration runtime node.
	AvailableMemoryInMB *int32

	// READ-ONLY; CPU percentage on the integration runtime node.
	CPUUtilization *int32

	// READ-ONLY; Maximum concurrent jobs on the integration runtime node.
	ConcurrentJobsLimit *int32

	// READ-ONLY; The number of jobs currently running on the integration runtime node.
	ConcurrentJobsRunning *int32

	// READ-ONLY; The maximum concurrent jobs in this integration runtime.
	MaxConcurrentJobs *int32

	// READ-ONLY; Name of the integration runtime node.
	NodeName *string

	// READ-ONLY; Received bytes on the integration runtime node.
	ReceivedBytes *float32

	// READ-ONLY; Sent bytes on the integration runtime node.
	SentBytes *float32
}

// IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint - Azure-SSIS integration runtime outbound network dependency
// endpoints for one category.
type IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint struct {
	// The category of outbound network dependency.
	Category *string

	// The endpoints for outbound network dependency.
	Endpoints []*IntegrationRuntimeOutboundNetworkDependenciesEndpoint
}

// IntegrationRuntimeOutboundNetworkDependenciesEndpoint - The endpoint for Azure-SSIS integration runtime outbound network
// dependency.
type IntegrationRuntimeOutboundNetworkDependenciesEndpoint struct {
	// The domain name of endpoint.
	DomainName *string

	// The details of endpoint.
	EndpointDetails []*IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails
}

// IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails - The details of Azure-SSIS integration runtime outbound network
// dependency endpoint.
type IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails struct {
	// The port of endpoint.
	Port *int32
}

// IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse - Azure-SSIS integration runtime outbound network dependency
// endpoints.
type IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse struct {
	// The list of outbound network dependency endpoints.
	Value []*IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint
}

// IntegrationRuntimeReference - Integration runtime reference type.
type IntegrationRuntimeReference struct {
	// REQUIRED; Reference integration runtime name.
	ReferenceName *string

	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeReferenceType

	// Arguments for integration runtime.
	Parameters map[string]any
}

// IntegrationRuntimeRegenerateKeyParameters - Parameters to regenerate the authentication key.
type IntegrationRuntimeRegenerateKeyParameters struct {
	// The name of the authentication key to regenerate.
	KeyName *IntegrationRuntimeAuthKeyName
}

// IntegrationRuntimeResource - Integration runtime resource type.
type IntegrationRuntimeResource struct {
	// REQUIRED; Integration runtime properties.
	Properties IntegrationRuntimeClassification

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// IntegrationRuntimeSsisCatalogInfo - Catalog information for managed dedicated integration runtime.
type IntegrationRuntimeSsisCatalogInfo struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The password of the administrator user account of the catalog database.
	CatalogAdminPassword *SecureString

	// The administrator user name of catalog database.
	CatalogAdminUserName *string

	// The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
	CatalogPricingTier *IntegrationRuntimeSsisCatalogPricingTier

	// The catalog database server URL.
	CatalogServerEndpoint *string

	// The dual standby pair name of Azure-SSIS Integration Runtimes to support SSISDB failover.
	DualStandbyPairName *string
}

// IntegrationRuntimeSsisProperties - SSIS properties for managed integration runtime.
type IntegrationRuntimeSsisProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Catalog information for managed dedicated integration runtime.
	CatalogInfo *IntegrationRuntimeSsisCatalogInfo

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// Custom setup script properties for a managed dedicated integration runtime.
	CustomSetupScriptProperties *IntegrationRuntimeCustomSetupScriptProperties

	// Data proxy properties for a managed dedicated integration runtime.
	DataProxyProperties *IntegrationRuntimeDataProxyProperties

	// The edition for the SSIS Integration Runtime
	Edition *IntegrationRuntimeEdition

	// Custom setup without script properties for a SSIS integration runtime.
	ExpressCustomSetupProperties []CustomSetupBaseClassification

	// License type for bringing your own license scenario.
	LicenseType *IntegrationRuntimeLicenseType

	// Package stores for the SSIS Integration Runtime.
	PackageStores []*PackageStore
}

// IntegrationRuntimeStatus - Integration runtime status.
type IntegrationRuntimeStatus struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The data factory name which the integration runtime belong to.
	DataFactoryName *string

	// READ-ONLY; The state of integration runtime.
	State *IntegrationRuntimeState
}

// GetIntegrationRuntimeStatus implements the IntegrationRuntimeStatusClassification interface for type IntegrationRuntimeStatus.
func (i *IntegrationRuntimeStatus) GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus { return i }

// IntegrationRuntimeStatusResponse - Integration runtime status response.
type IntegrationRuntimeStatusResponse struct {
	// REQUIRED; Integration runtime properties.
	Properties IntegrationRuntimeStatusClassification

	// READ-ONLY; The integration runtime name.
	Name *string
}

// IntegrationRuntimeVNetProperties - VNet properties for managed integration runtime.
type IntegrationRuntimeVNetProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Resource IDs of the public IP addresses that this integration runtime will use.
	PublicIPs []*string

	// The name of the subnet this integration runtime will join.
	Subnet *string

	// The ID of subnet, to which this Azure-SSIS integration runtime will be joined.
	SubnetID *string

	// The ID of the VNet that this integration runtime will join.
	VNetID *string
}

// JSONDataset - Json dataset.
type JSONDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Json dataset properties.
	TypeProperties *JSONDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type JSONDataset.
func (j *JSONDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: j.AdditionalProperties,
		Annotations:          j.Annotations,
		Description:          j.Description,
		Folder:               j.Folder,
		LinkedServiceName:    j.LinkedServiceName,
		Parameters:           j.Parameters,
		Schema:               j.Schema,
		Structure:            j.Structure,
		Type:                 j.Type,
	}
}

// JSONDatasetTypeProperties - Json dataset properties.
type JSONDatasetTypeProperties struct {
	// REQUIRED; The location of the json data storage.
	Location DatasetLocationClassification

	// The data compression method used for the json dataset.
	Compression *DatasetCompression

	// The code page name of the preferred encoding. If not specified, the default value is UTF-8, unless BOM denotes another
	// Unicode encoding. Refer to the name column of the table in the following link to
	// set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType
	// string).
	EncodingName any
}

// JSONFormat - The data stored in JSON format.
type JSONFormat struct {
	// REQUIRED; Type of dataset storage format.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Deserializer. Type: string (or Expression with resultType string).
	Deserializer any

	// The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark
	// (BOM) denotes another Unicode encoding. The full list of supported values can be
	// found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078.
	// Type: string (or Expression with resultType string).
	EncodingName any

	// File pattern of JSON. To be more specific, the way of separating a collection of JSON objects. The default value is 'setOfObjects'.
	// It is case-sensitive.
	FilePattern any

	// The JSONPath of the JSON array element to be flattened. Example: "$.ArrayPath". Type: string (or Expression with resultType
	// string).
	JSONNodeReference any

	// The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields
	// under root object, start with "$"; for fields inside the array chosen by
	// jsonNodeReference property, start from the array element. Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}.
	// Type: object (or Expression with resultType object).
	JSONPathDefinition any

	// The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType
	// string).
	NestingSeparator any

	// Serializer. Type: string (or Expression with resultType string).
	Serializer any
}

// GetDatasetStorageFormat implements the DatasetStorageFormatClassification interface for type JSONFormat.
func (j *JSONFormat) GetDatasetStorageFormat() *DatasetStorageFormat {
	return &DatasetStorageFormat{
		AdditionalProperties: j.AdditionalProperties,
		Deserializer:         j.Deserializer,
		Serializer:           j.Serializer,
		Type:                 j.Type,
	}
}

// JSONReadSettings - Json read settings.
type JSONReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Compression settings.
	CompressionProperties CompressionReadSettingsClassification
}

// GetFormatReadSettings implements the FormatReadSettingsClassification interface for type JSONReadSettings.
func (j *JSONReadSettings) GetFormatReadSettings() *FormatReadSettings {
	return &FormatReadSettings{
		AdditionalProperties: j.AdditionalProperties,
		Type:                 j.Type,
	}
}

// JSONSink - A copy activity Json sink.
type JSONSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Json format settings.
	FormatSettings *JSONWriteSettings

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Json store settings.
	StoreSettings StoreWriteSettingsClassification

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type JSONSink.
func (j *JSONSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     j.AdditionalProperties,
		DisableMetricsCollection: j.DisableMetricsCollection,
		MaxConcurrentConnections: j.MaxConcurrentConnections,
		SinkRetryCount:           j.SinkRetryCount,
		SinkRetryWait:            j.SinkRetryWait,
		Type:                     j.Type,
		WriteBatchSize:           j.WriteBatchSize,
		WriteBatchTimeout:        j.WriteBatchTimeout,
	}
}

// JSONSource - A copy activity Json source.
type JSONSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Json format settings.
	FormatSettings *JSONReadSettings

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Json store settings.
	StoreSettings StoreReadSettingsClassification
}

// GetCopySource implements the CopySourceClassification interface for type JSONSource.
func (j *JSONSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     j.AdditionalProperties,
		DisableMetricsCollection: j.DisableMetricsCollection,
		MaxConcurrentConnections: j.MaxConcurrentConnections,
		SourceRetryCount:         j.SourceRetryCount,
		SourceRetryWait:          j.SourceRetryWait,
		Type:                     j.Type,
	}
}

// JSONWriteSettings - Json write settings.
type JSONWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// File pattern of JSON. This setting controls the way a collection of JSON objects will be treated. The default value is
	// 'setOfObjects'. It is case-sensitive.
	FilePattern any
}

// GetFormatWriteSettings implements the FormatWriteSettingsClassification interface for type JSONWriteSettings.
func (j *JSONWriteSettings) GetFormatWriteSettings() *FormatWriteSettings {
	return &FormatWriteSettings{
		AdditionalProperties: j.AdditionalProperties,
		Type:                 j.Type,
	}
}

// JiraLinkedService - Jira Service linked service.
type JiraLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Jira Service linked service properties.
	TypeProperties *JiraLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type JiraLinkedService.
func (j *JiraLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: j.AdditionalProperties,
		Annotations:          j.Annotations,
		ConnectVia:           j.ConnectVia,
		Description:          j.Description,
		Parameters:           j.Parameters,
		Type:                 j.Type,
	}
}

// JiraLinkedServiceTypeProperties - Jira Service linked service properties.
type JiraLinkedServiceTypeProperties struct {
	// REQUIRED; The IP address or host name of the Jira service. (e.g. jira.example.com)
	Host any

	// REQUIRED; The user name that you use to access Jira Service.
	Username any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The password corresponding to the user name that you provided in the username field.
	Password SecretBaseClassification

	// The TCP port that the Jira server uses to listen for client connections. The default value is 443 if connecting through
	// HTTPS, or 8080 if connecting through HTTP.
	Port any

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification any
}

// JiraObjectDataset - Jira Service dataset.
type JiraObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type JiraObjectDataset.
func (j *JiraObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: j.AdditionalProperties,
		Annotations:          j.Annotations,
		Description:          j.Description,
		Folder:               j.Folder,
		LinkedServiceName:    j.LinkedServiceName,
		Parameters:           j.Parameters,
		Schema:               j.Schema,
		Structure:            j.Structure,
		Type:                 j.Type,
	}
}

// JiraSource - A copy activity Jira Service source.
type JiraSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type JiraSource.
func (j *JiraSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     j.AdditionalProperties,
		DisableMetricsCollection: j.DisableMetricsCollection,
		MaxConcurrentConnections: j.MaxConcurrentConnections,
		SourceRetryCount:         j.SourceRetryCount,
		SourceRetryWait:          j.SourceRetryWait,
		Type:                     j.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type JiraSource.
func (j *JiraSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        j.AdditionalColumns,
		AdditionalProperties:     j.AdditionalProperties,
		DisableMetricsCollection: j.DisableMetricsCollection,
		MaxConcurrentConnections: j.MaxConcurrentConnections,
		QueryTimeout:             j.QueryTimeout,
		SourceRetryCount:         j.SourceRetryCount,
		SourceRetryWait:          j.SourceRetryWait,
		Type:                     j.Type,
	}
}

// LakeHouseLinkedService - Microsoft Fabric LakeHouse linked service.
type LakeHouseLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Microsoft Fabric LakeHouse linked service properties.
	TypeProperties *LakeHouseLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type LakeHouseLinkedService.
func (l *LakeHouseLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: l.AdditionalProperties,
		Annotations:          l.Annotations,
		ConnectVia:           l.ConnectVia,
		Description:          l.Description,
		Parameters:           l.Parameters,
		Type:                 l.Type,
	}
}

// LakeHouseLinkedServiceTypeProperties - Microsoft Fabric LakeHouse linked service properties.
type LakeHouseLinkedServiceTypeProperties struct {
	// The ID of Microsoft Fabric LakeHouse artifact. Type: string (or Expression with resultType string).
	ArtifactID any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
	// servicePrincipalCredential can be SecureString or
	// AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can
	// only be AzureKeyVaultSecretReference.
	ServicePrincipalCredential SecretBaseClassification

	// The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret,
	// 'ServicePrincipalCert' for certificate. Type: string (or Expression with
	// resultType string).
	ServicePrincipalCredentialType any

	// The ID of the application used to authenticate against Microsoft Fabric LakeHouse. Type: string (or Expression with resultType
	// string).
	ServicePrincipalID any

	// The Key of the application used to authenticate against Microsoft Fabric LakeHouse.
	ServicePrincipalKey SecretBaseClassification

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant any

	// The ID of Microsoft Fabric workspace. Type: string (or Expression with resultType string).
	WorkspaceID any
}

// LakeHouseLocation - The location of Microsoft Fabric LakeHouse Files dataset.
type LakeHouseLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type LakeHouseLocation.
func (l *LakeHouseLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: l.AdditionalProperties,
		FileName:             l.FileName,
		FolderPath:           l.FolderPath,
		Type:                 l.Type,
	}
}

// LakeHouseReadSettings - Microsoft Fabric LakeHouse Files read settings.
type LakeHouseReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Microsoft Fabric LakeHouse Files wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// Microsoft Fabric LakeHouse Files wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type LakeHouseReadSettings.
func (l *LakeHouseReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     l.AdditionalProperties,
		DisableMetricsCollection: l.DisableMetricsCollection,
		MaxConcurrentConnections: l.MaxConcurrentConnections,
		Type:                     l.Type,
	}
}

// LakeHouseTableDataset - Microsoft Fabric LakeHouse Table.
type LakeHouseTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Microsoft Fabric LakeHouse Table dataset properties.
	TypeProperties *LakeHouseTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type LakeHouseTableDataset.
func (l *LakeHouseTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: l.AdditionalProperties,
		Annotations:          l.Annotations,
		Description:          l.Description,
		Folder:               l.Folder,
		LinkedServiceName:    l.LinkedServiceName,
		Parameters:           l.Parameters,
		Schema:               l.Schema,
		Structure:            l.Structure,
		Type:                 l.Type,
	}
}

// LakeHouseTableDatasetTypeProperties - Microsoft Fabric LakeHouse Table dataset properties.
type LakeHouseTableDatasetTypeProperties struct {
	// The name of Microsoft Fabric LakeHouse Table. Type: string (or Expression with resultType string).
	Table any
}

// LakeHouseTableSink - A copy activity for Microsoft Fabric LakeHouse Table sink.
type LakeHouseTableSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Specify the partition column names from sink columns. Type: array of objects (or Expression with resultType array of objects).
	PartitionNameList any

	// Create partitions in folder structure based on one or multiple columns. Each distinct column value (pair) will be a new
	// partition. Possible values include: "None", "PartitionByKey".
	PartitionOption any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// The type of table action for LakeHouse Table sink. Possible values include: "None", "Append", "Overwrite".
	TableActionOption any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type LakeHouseTableSink.
func (l *LakeHouseTableSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     l.AdditionalProperties,
		DisableMetricsCollection: l.DisableMetricsCollection,
		MaxConcurrentConnections: l.MaxConcurrentConnections,
		SinkRetryCount:           l.SinkRetryCount,
		SinkRetryWait:            l.SinkRetryWait,
		Type:                     l.Type,
		WriteBatchSize:           l.WriteBatchSize,
		WriteBatchTimeout:        l.WriteBatchTimeout,
	}
}

// LakeHouseTableSource - A copy activity source for Microsoft Fabric LakeHouse Table.
type LakeHouseTableSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Query an older snapshot by timestamp. Type: string (or Expression with resultType string).
	TimestampAsOf any

	// Query an older snapshot by version. Type: integer (or Expression with resultType integer).
	VersionAsOf any
}

// GetCopySource implements the CopySourceClassification interface for type LakeHouseTableSource.
func (l *LakeHouseTableSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     l.AdditionalProperties,
		DisableMetricsCollection: l.DisableMetricsCollection,
		MaxConcurrentConnections: l.MaxConcurrentConnections,
		SourceRetryCount:         l.SourceRetryCount,
		SourceRetryWait:          l.SourceRetryWait,
		Type:                     l.Type,
	}
}

// LakeHouseWriteSettings - Microsoft Fabric LakeHouse Files write settings.
type LakeHouseWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The type of copy behavior for copy sink.
	CopyBehavior any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any
}

// GetStoreWriteSettings implements the StoreWriteSettingsClassification interface for type LakeHouseWriteSettings.
func (l *LakeHouseWriteSettings) GetStoreWriteSettings() *StoreWriteSettings {
	return &StoreWriteSettings{
		AdditionalProperties:     l.AdditionalProperties,
		CopyBehavior:             l.CopyBehavior,
		DisableMetricsCollection: l.DisableMetricsCollection,
		MaxConcurrentConnections: l.MaxConcurrentConnections,
		Type:                     l.Type,
	}
}

// LicensedComponentSetupTypeProperties - Installation of licensed component setup type properties.
type LicensedComponentSetupTypeProperties struct {
	// REQUIRED; The name of the 3rd party component.
	ComponentName *string

	// The license key to activate the component.
	LicenseKey SecretBaseClassification
}

// LinkedIntegrationRuntime - The linked integration runtime information.
type LinkedIntegrationRuntime struct {
	// READ-ONLY; The creating time of the linked integration runtime.
	CreateTime *time.Time

	// READ-ONLY; The location of the data factory for which the linked integration runtime belong to.
	DataFactoryLocation *string

	// READ-ONLY; The name of the data factory for which the linked integration runtime belong to.
	DataFactoryName *string

	// READ-ONLY; The name of the linked integration runtime.
	Name *string

	// READ-ONLY; The subscription ID for which the linked integration runtime belong to.
	SubscriptionID *string
}

// LinkedIntegrationRuntimeKeyAuthorization - The key authorization type integration runtime.
type LinkedIntegrationRuntimeKeyAuthorization struct {
	// REQUIRED; The authorization type for integration runtime sharing.
	AuthorizationType *string

	// REQUIRED; The key used for authorization.
	Key *SecureString
}

// GetLinkedIntegrationRuntimeType implements the LinkedIntegrationRuntimeTypeClassification interface for type LinkedIntegrationRuntimeKeyAuthorization.
func (l *LinkedIntegrationRuntimeKeyAuthorization) GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType {
	return &LinkedIntegrationRuntimeType{
		AuthorizationType: l.AuthorizationType,
	}
}

// LinkedIntegrationRuntimeRbacAuthorization - The role based access control (RBAC) authorization type integration runtime.
type LinkedIntegrationRuntimeRbacAuthorization struct {
	// REQUIRED; The authorization type for integration runtime sharing.
	AuthorizationType *string

	// REQUIRED; The resource identifier of the integration runtime to be shared.
	ResourceID *string

	// The credential reference containing authentication information.
	Credential *CredentialReference
}

// GetLinkedIntegrationRuntimeType implements the LinkedIntegrationRuntimeTypeClassification interface for type LinkedIntegrationRuntimeRbacAuthorization.
func (l *LinkedIntegrationRuntimeRbacAuthorization) GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType {
	return &LinkedIntegrationRuntimeType{
		AuthorizationType: l.AuthorizationType,
	}
}

// LinkedIntegrationRuntimeRequest - Data factory name for linked integration runtime request.
type LinkedIntegrationRuntimeRequest struct {
	// REQUIRED; The data factory name for linked integration runtime.
	LinkedFactoryName *string
}

// LinkedIntegrationRuntimeType - The base definition of a linked integration runtime.
type LinkedIntegrationRuntimeType struct {
	// REQUIRED; The authorization type for integration runtime sharing.
	AuthorizationType *string
}

// GetLinkedIntegrationRuntimeType implements the LinkedIntegrationRuntimeTypeClassification interface for type LinkedIntegrationRuntimeType.
func (l *LinkedIntegrationRuntimeType) GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType {
	return l
}

// LinkedService - The nested object which contains the information and credential which can be used to connect with related
// store or compute resource.
type LinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type LinkedService.
func (l *LinkedService) GetLinkedService() *LinkedService { return l }

// LinkedServiceDebugResource - Linked service debug resource.
type LinkedServiceDebugResource struct {
	// REQUIRED; Properties of linked service.
	Properties LinkedServiceClassification

	// The resource name.
	Name *string
}

// LinkedServiceListResponse - A list of linked service resources.
type LinkedServiceListResponse struct {
	// REQUIRED; List of linked services.
	Value []*LinkedServiceResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// LinkedServiceReference - Linked service reference type.
type LinkedServiceReference struct {
	// REQUIRED; Reference LinkedService name.
	ReferenceName *string

	// REQUIRED; Linked service reference type.
	Type *LinkedServiceReferenceType

	// Arguments for LinkedService.
	Parameters map[string]any
}

// LinkedServiceResource - Linked service resource type.
type LinkedServiceResource struct {
	// REQUIRED; Properties of linked service.
	Properties LinkedServiceClassification

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// LogLocationSettings - Log location settings.
type LogLocationSettings struct {
	// REQUIRED; Log storage linked service reference.
	LinkedServiceName *LinkedServiceReference

	// The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string).
	Path any
}

// LogSettings - Log settings.
type LogSettings struct {
	// REQUIRED; Log location settings customer needs to provide when enabling log.
	LogLocationSettings *LogLocationSettings

	// Specifies settings for copy activity log.
	CopyActivityLogSettings *CopyActivityLogSettings

	// Specifies whether to enable copy activity log. Type: boolean (or Expression with resultType boolean).
	EnableCopyActivityLog any
}

// LogStorageSettings - (Deprecated. Please use LogSettings) Log storage settings.
type LogStorageSettings struct {
	// REQUIRED; Log storage linked service reference.
	LinkedServiceName *LinkedServiceReference

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean).
	EnableReliableLogging any

	// Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string).
	LogLevel any

	// The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string).
	Path any
}

// LookupActivity - Lookup activity.
type LookupActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Lookup activity properties.
	TypeProperties *LookupActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type LookupActivity.
func (l *LookupActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: l.AdditionalProperties,
		DependsOn:            l.DependsOn,
		Description:          l.Description,
		Name:                 l.Name,
		OnInactiveMarkAs:     l.OnInactiveMarkAs,
		State:                l.State,
		Type:                 l.Type,
		UserProperties:       l.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type LookupActivity.
func (l *LookupActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: l.AdditionalProperties,
		DependsOn:            l.DependsOn,
		Description:          l.Description,
		LinkedServiceName:    l.LinkedServiceName,
		Name:                 l.Name,
		OnInactiveMarkAs:     l.OnInactiveMarkAs,
		Policy:               l.Policy,
		State:                l.State,
		Type:                 l.Type,
		UserProperties:       l.UserProperties,
	}
}

// LookupActivityTypeProperties - Lookup activity properties.
type LookupActivityTypeProperties struct {
	// REQUIRED; Lookup activity dataset reference.
	Dataset *DatasetReference

	// REQUIRED; Dataset-specific source properties, same as copy activity source.
	Source CopySourceClassification

	// Whether to return first row or all rows. Default value is true. Type: boolean (or Expression with resultType boolean).
	FirstRowOnly any
}

// MagentoLinkedService - Magento server linked service.
type MagentoLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Magento server linked service properties.
	TypeProperties *MagentoLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type MagentoLinkedService.
func (m *MagentoLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Type:                 m.Type,
	}
}

// MagentoLinkedServiceTypeProperties - Magento server linked service properties.
type MagentoLinkedServiceTypeProperties struct {
	// REQUIRED; The URL of the Magento instance. (i.e. 192.168.222.110/magento3)
	Host any

	// The access token from Magento.
	AccessToken SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification any
}

// MagentoObjectDataset - Magento server dataset.
type MagentoObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type MagentoObjectDataset.
func (m *MagentoObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		Description:          m.Description,
		Folder:               m.Folder,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Schema:               m.Schema,
		Structure:            m.Structure,
		Type:                 m.Type,
	}
}

// MagentoSource - A copy activity Magento server source.
type MagentoSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type MagentoSource.
func (m *MagentoSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		Type:                     m.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type MagentoSource.
func (m *MagentoSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        m.AdditionalColumns,
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		QueryTimeout:             m.QueryTimeout,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		Type:                     m.Type,
	}
}

// ManagedIdentityCredential - Managed identity credential.
type ManagedIdentityCredential struct {
	// REQUIRED; Type of credential.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Credential.
	Annotations []any

	// Credential description.
	Description *string

	// Managed identity credential properties.
	TypeProperties *ManagedIdentityTypeProperties
}

// GetCredential implements the CredentialClassification interface for type ManagedIdentityCredential.
func (m *ManagedIdentityCredential) GetCredential() *Credential {
	return &Credential{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		Description:          m.Description,
		Type:                 m.Type,
	}
}

// ManagedIdentityCredentialResource - Credential resource type.
type ManagedIdentityCredentialResource struct {
	// REQUIRED; Managed Identity Credential properties.
	Properties *ManagedIdentityCredential

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// ManagedIdentityTypeProperties - Managed identity type properties.
type ManagedIdentityTypeProperties struct {
	// The resource id of user assigned managed identity
	ResourceID *string
}

// ManagedIntegrationRuntime - Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
type ManagedIntegrationRuntime struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType

	// REQUIRED; Managed integration runtime properties.
	TypeProperties *ManagedIntegrationRuntimeTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Integration runtime description.
	Description *string

	// Managed Virtual Network reference.
	ManagedVirtualNetwork *ManagedVirtualNetworkReference

	// READ-ONLY; Integration runtime state, only valid for managed dedicated integration runtime.
	State *IntegrationRuntimeState
}

// GetIntegrationRuntime implements the IntegrationRuntimeClassification interface for type ManagedIntegrationRuntime.
func (m *ManagedIntegrationRuntime) GetIntegrationRuntime() *IntegrationRuntime {
	return &IntegrationRuntime{
		AdditionalProperties: m.AdditionalProperties,
		Description:          m.Description,
		Type:                 m.Type,
	}
}

// ManagedIntegrationRuntimeError - Error definition for managed integration runtime.
type ManagedIntegrationRuntimeError struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message.
	Message *string

	// READ-ONLY; Managed integration runtime error parameters.
	Parameters []*string

	// READ-ONLY; The time when the error occurred.
	Time *time.Time
}

// ManagedIntegrationRuntimeNode - Properties of integration runtime node.
type ManagedIntegrationRuntimeNode struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The errors that occurred on this integration runtime node.
	Errors []*ManagedIntegrationRuntimeError

	// READ-ONLY; The managed integration runtime node id.
	NodeID *string

	// READ-ONLY; The managed integration runtime node status.
	Status *ManagedIntegrationRuntimeNodeStatus
}

// ManagedIntegrationRuntimeOperationResult - Properties of managed integration runtime operation result.
type ManagedIntegrationRuntimeOperationResult struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The activity id for the operation request.
	ActivityID *string

	// READ-ONLY; The error code.
	ErrorCode *string

	// READ-ONLY; Managed integration runtime error parameters.
	Parameters []*string

	// READ-ONLY; The operation result.
	Result *string

	// READ-ONLY; The start time of the operation.
	StartTime *time.Time

	// READ-ONLY; The operation type. Could be start or stop.
	Type *string
}

// ManagedIntegrationRuntimeStatus - Managed integration runtime status.
type ManagedIntegrationRuntimeStatus struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType

	// REQUIRED; Managed integration runtime status type properties.
	TypeProperties *ManagedIntegrationRuntimeStatusTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The data factory name which the integration runtime belong to.
	DataFactoryName *string

	// READ-ONLY; The state of integration runtime.
	State *IntegrationRuntimeState
}

// GetIntegrationRuntimeStatus implements the IntegrationRuntimeStatusClassification interface for type ManagedIntegrationRuntimeStatus.
func (m *ManagedIntegrationRuntimeStatus) GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus {
	return &IntegrationRuntimeStatus{
		AdditionalProperties: m.AdditionalProperties,
		DataFactoryName:      m.DataFactoryName,
		State:                m.State,
		Type:                 m.Type,
	}
}

// ManagedIntegrationRuntimeStatusTypeProperties - Managed integration runtime status type properties.
type ManagedIntegrationRuntimeStatusTypeProperties struct {
	// READ-ONLY; The time at which the integration runtime was created, in ISO8601 format.
	CreateTime *time.Time

	// READ-ONLY; The last operation result that occurred on this integration runtime.
	LastOperation *ManagedIntegrationRuntimeOperationResult

	// READ-ONLY; The list of nodes for managed integration runtime.
	Nodes []*ManagedIntegrationRuntimeNode

	// READ-ONLY; The errors that occurred on this integration runtime.
	OtherErrors []*ManagedIntegrationRuntimeError
}

// ManagedIntegrationRuntimeTypeProperties - Managed integration runtime type properties.
type ManagedIntegrationRuntimeTypeProperties struct {
	// The compute resource for managed integration runtime.
	ComputeProperties *IntegrationRuntimeComputeProperties

	// The name of virtual network to which Azure-SSIS integration runtime will join
	CustomerVirtualNetwork *IntegrationRuntimeCustomerVirtualNetwork

	// SSIS properties for managed integration runtime.
	SsisProperties *IntegrationRuntimeSsisProperties
}

// ManagedPrivateEndpoint - Properties of a managed private endpoint
type ManagedPrivateEndpoint struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The managed private endpoint connection state
	ConnectionState *ConnectionStateProperties

	// Fully qualified domain names
	Fqdns []*string

	// The groupId to which the managed private endpoint is created
	GroupID *string

	// The ARM resource ID of the resource to which the managed private endpoint is created
	PrivateLinkResourceID *string

	// READ-ONLY; Denotes whether the managed private endpoint is reserved
	IsReserved *bool

	// READ-ONLY; The managed private endpoint provisioning state
	ProvisioningState *string
}

// ManagedPrivateEndpointListResponse - A list of managed private endpoint resources.
type ManagedPrivateEndpointListResponse struct {
	// REQUIRED; List of managed private endpoints.
	Value []*ManagedPrivateEndpointResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// ManagedPrivateEndpointResource - Managed private endpoint resource type.
type ManagedPrivateEndpointResource struct {
	// REQUIRED; Managed private endpoint properties.
	Properties *ManagedPrivateEndpoint

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// ManagedVirtualNetwork - A managed Virtual Network associated with the Azure Data Factory
type ManagedVirtualNetwork struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; Managed Virtual Network alias.
	Alias *string

	// READ-ONLY; Managed Virtual Network ID.
	VNetID *string
}

// ManagedVirtualNetworkListResponse - A list of managed Virtual Network resources.
type ManagedVirtualNetworkListResponse struct {
	// REQUIRED; List of managed Virtual Networks.
	Value []*ManagedVirtualNetworkResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// ManagedVirtualNetworkReference - Managed Virtual Network reference type.
type ManagedVirtualNetworkReference struct {
	// REQUIRED; Reference ManagedVirtualNetwork name.
	ReferenceName *string

	// REQUIRED; Managed Virtual Network reference type.
	Type *ManagedVirtualNetworkReferenceType
}

// ManagedVirtualNetworkResource - Managed Virtual Network resource type.
type ManagedVirtualNetworkResource struct {
	// REQUIRED; Managed Virtual Network properties.
	Properties *ManagedVirtualNetwork

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// MapperAttributeMapping - Source and target column mapping details.
type MapperAttributeMapping struct {
	// Reference of the source column used in the mapping. It is used for 'Direct' mapping type only.
	AttributeReference *MapperAttributeReference

	// List of references for source columns. It is used for 'Derived' and 'Aggregate' type mappings only.
	AttributeReferences []*MapperAttributeReference

	// Expression used for 'Aggregate' and 'Derived' type mapping.
	Expression *string

	// Name of the function used for 'Aggregate' and 'Derived' (except 'Advanced') type mapping.
	FunctionName *string

	// Name of the target column.
	Name *string

	// Type of the CDC attribute mapping. Note: 'Advanced' mapping type is also saved as 'Derived'.
	Type *MappingType
}

// MapperAttributeMappings - Attribute mapping details.
type MapperAttributeMappings struct {
	// List of attribute mappings.
	AttributeMappings []*MapperAttributeMapping
}

// MapperAttributeReference - Attribute reference details for the referred column.
type MapperAttributeReference struct {
	// Name of the table.
	Entity *string

	// The connection reference for the connection.
	EntityConnectionReference *MapperConnectionReference

	// Name of the column.
	Name *string
}

// MapperConnection - Source connection details.
type MapperConnection struct {
	// REQUIRED; Type of connection via linked service or dataset.
	Type *ConnectionType

	// List of name/value pairs for connection properties.
	CommonDslConnectorProperties []*MapperDslConnectorProperties

	// A boolean indicating whether linked service is of type inline dataset. Currently only inline datasets are supported.
	IsInlineDataset *bool

	// Linked service reference.
	LinkedService *LinkedServiceReference

	// Type of the linked service e.g.: AzureBlobFS.
	LinkedServiceType *string
}

// MapperConnectionReference - Source or target connection reference details.
type MapperConnectionReference struct {
	// Name of the connection
	ConnectionName *string

	// Type of connection via linked service or dataset.
	Type *ConnectionType
}

// MapperDslConnectorProperties - Connector properties of a CDC table in terms of name / value pairs.
type MapperDslConnectorProperties struct {
	// Name of the property.
	Name *string

	// Value of the property.
	Value any
}

// MapperPolicy - CDC Policy.
type MapperPolicy struct {
	// Mode of running the CDC: batch vs continuous.
	Mode *string

	// Defines the frequency and interval for running the CDC for batch mode.
	Recurrence *MapperPolicyRecurrence
}

// MapperPolicyRecurrence - CDC policy recurrence details.
type MapperPolicyRecurrence struct {
	// Frequency of period in terms of 'Hour', 'Minute' or 'Second'.
	Frequency *FrequencyType

	// Actual interval value as per chosen frequency.
	Interval *int32
}

// MapperSourceConnectionsInfo - A object which contains list of tables and connection details for a source connection.
type MapperSourceConnectionsInfo struct {
	// Source connection details.
	Connection *MapperConnection

	// List of source tables for a source connection.
	SourceEntities []*MapperTable
}

// MapperTable - CDC table details.
type MapperTable struct {
	// Name of the table.
	Name *string

	// Table properties.
	Properties *MapperTableProperties
}

// MapperTableProperties - Properties for a CDC table.
type MapperTableProperties struct {
	// List of name/value pairs for connection properties.
	DslConnectorProperties []*MapperDslConnectorProperties

	// List of columns for the source table.
	Schema []*MapperTableSchema
}

// MapperTableSchema - Schema of a CDC table in terms of column names and their corresponding data types.
type MapperTableSchema struct {
	// Data type of the column.
	DataType *string

	// Name of the column.
	Name *string
}

// MapperTargetConnectionsInfo - A object which contains list of tables and connection details for a target connection.
type MapperTargetConnectionsInfo struct {
	// Source connection details.
	Connection *MapperConnection

	// List of table mappings.
	DataMapperMappings []*DataMapperMapping

	// List of relationship info among the tables.
	Relationships []any

	// List of source tables for a target connection.
	TargetEntities []*MapperTable
}

// MappingDataFlow - Mapping data flow.
type MappingDataFlow struct {
	// REQUIRED; Type of data flow.
	Type *string

	// List of tags that can be used for describing the data flow.
	Annotations []any

	// The description of the data flow.
	Description *string

	// The folder that this data flow is in. If not specified, Data flow will appear at the root level.
	Folder *DataFlowFolder

	// Mapping data flow type properties.
	TypeProperties *MappingDataFlowTypeProperties
}

// GetDataFlow implements the DataFlowClassification interface for type MappingDataFlow.
func (m *MappingDataFlow) GetDataFlow() *DataFlow {
	return &DataFlow{
		Annotations: m.Annotations,
		Description: m.Description,
		Folder:      m.Folder,
		Type:        m.Type,
	}
}

// MappingDataFlowTypeProperties - Mapping data flow type properties.
type MappingDataFlowTypeProperties struct {
	// DataFlow script.
	Script *string

	// Data flow script lines.
	ScriptLines []*string

	// List of sinks in data flow.
	Sinks []*DataFlowSink

	// List of sources in data flow.
	Sources []*DataFlowSource

	// List of transformations in data flow.
	Transformations []*Transformation
}

// MariaDBLinkedService - MariaDB server linked service.
type MariaDBLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; MariaDB server linked service properties.
	TypeProperties *MariaDBLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type MariaDBLinkedService.
func (m *MariaDBLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Type:                 m.Type,
	}
}

// MariaDBLinkedServiceTypeProperties - MariaDB server linked service properties.
type MariaDBLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Pwd *AzureKeyVaultSecretReference
}

// MariaDBSource - A copy activity MariaDB server source.
type MariaDBSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type MariaDBSource.
func (m *MariaDBSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		Type:                     m.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type MariaDBSource.
func (m *MariaDBSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        m.AdditionalColumns,
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		QueryTimeout:             m.QueryTimeout,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		Type:                     m.Type,
	}
}

// MariaDBTableDataset - MariaDB server dataset.
type MariaDBTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type MariaDBTableDataset.
func (m *MariaDBTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		Description:          m.Description,
		Folder:               m.Folder,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Schema:               m.Schema,
		Structure:            m.Structure,
		Type:                 m.Type,
	}
}

// MarketoLinkedService - Marketo server linked service.
type MarketoLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Marketo server linked service properties.
	TypeProperties *MarketoLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type MarketoLinkedService.
func (m *MarketoLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Type:                 m.Type,
	}
}

// MarketoLinkedServiceTypeProperties - Marketo server linked service properties.
type MarketoLinkedServiceTypeProperties struct {
	// REQUIRED; The client Id of your Marketo service.
	ClientID any

	// REQUIRED; The endpoint of the Marketo server. (i.e. 123-ABC-321.mktorest.com)
	Endpoint any

	// The client secret of your Marketo service.
	ClientSecret SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification any
}

// MarketoObjectDataset - Marketo server dataset.
type MarketoObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type MarketoObjectDataset.
func (m *MarketoObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		Description:          m.Description,
		Folder:               m.Folder,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Schema:               m.Schema,
		Structure:            m.Structure,
		Type:                 m.Type,
	}
}

// MarketoSource - A copy activity Marketo server source.
type MarketoSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type MarketoSource.
func (m *MarketoSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		Type:                     m.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type MarketoSource.
func (m *MarketoSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        m.AdditionalColumns,
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		QueryTimeout:             m.QueryTimeout,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		Type:                     m.Type,
	}
}

// MetadataItem - Specify the name and value of custom metadata item.
type MetadataItem struct {
	// Metadata item key name. Type: string (or Expression with resultType string).
	Name any

	// Metadata item value. Type: string (or Expression with resultType string).
	Value any
}

// MicrosoftAccessLinkedService - Microsoft Access linked service.
type MicrosoftAccessLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Microsoft Access linked service properties.
	TypeProperties *MicrosoftAccessLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type MicrosoftAccessLinkedService.
func (m *MicrosoftAccessLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Type:                 m.Type,
	}
}

// MicrosoftAccessLinkedServiceTypeProperties - Microsoft Access linked service properties.
type MicrosoftAccessLinkedServiceTypeProperties struct {
	// REQUIRED; The non-access credential portion of the connection string as well as an optional encrypted credential. Type:
	// string, or SecureString, or AzureKeyVaultSecretReference, or Expression with resultType
	// string.
	ConnectionString any

	// Type of authentication used to connect to the Microsoft Access as ODBC data store. Possible values are: Anonymous and Basic.
	// Type: string (or Expression with resultType string).
	AuthenticationType any

	// The access credential portion of the connection string specified in driver-specific property-value format.
	Credential SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Password for Basic authentication.
	Password SecretBaseClassification

	// User name for Basic authentication. Type: string (or Expression with resultType string).
	UserName any
}

// MicrosoftAccessSink - A copy activity Microsoft Access sink.
type MicrosoftAccessSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to execute before starting the copy. Type: string (or Expression with resultType string).
	PreCopyScript any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type MicrosoftAccessSink.
func (m *MicrosoftAccessSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		SinkRetryCount:           m.SinkRetryCount,
		SinkRetryWait:            m.SinkRetryWait,
		Type:                     m.Type,
		WriteBatchSize:           m.WriteBatchSize,
		WriteBatchTimeout:        m.WriteBatchTimeout,
	}
}

// MicrosoftAccessSource - A copy activity source for Microsoft Access.
type MicrosoftAccessSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Type: string (or Expression with resultType string).
	Query any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type MicrosoftAccessSource.
func (m *MicrosoftAccessSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		Type:                     m.Type,
	}
}

// MicrosoftAccessTableDataset - The Microsoft Access table dataset.
type MicrosoftAccessTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Microsoft Access table dataset properties.
	TypeProperties *MicrosoftAccessTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type MicrosoftAccessTableDataset.
func (m *MicrosoftAccessTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		Description:          m.Description,
		Folder:               m.Folder,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Schema:               m.Schema,
		Structure:            m.Structure,
		Type:                 m.Type,
	}
}

// MicrosoftAccessTableDatasetTypeProperties - Microsoft Access table dataset properties.
type MicrosoftAccessTableDatasetTypeProperties struct {
	// The Microsoft Access table name. Type: string (or Expression with resultType string).
	TableName any
}

// MongoDbAtlasCollectionDataset - The MongoDB Atlas database dataset.
type MongoDbAtlasCollectionDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; MongoDB Atlas database dataset properties.
	TypeProperties *MongoDbAtlasCollectionDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type MongoDbAtlasCollectionDataset.
func (m *MongoDbAtlasCollectionDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		Description:          m.Description,
		Folder:               m.Folder,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Schema:               m.Schema,
		Structure:            m.Structure,
		Type:                 m.Type,
	}
}

// MongoDbAtlasCollectionDatasetTypeProperties - MongoDB Atlas database dataset properties.
type MongoDbAtlasCollectionDatasetTypeProperties struct {
	// REQUIRED; The collection name of the MongoDB Atlas database. Type: string (or Expression with resultType string).
	Collection any
}

// MongoDbAtlasLinkedService - Linked service for MongoDB Atlas data source.
type MongoDbAtlasLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; MongoDB Atlas linked service properties.
	TypeProperties *MongoDbAtlasLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type MongoDbAtlasLinkedService.
func (m *MongoDbAtlasLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Type:                 m.Type,
	}
}

// MongoDbAtlasLinkedServiceTypeProperties - MongoDB Atlas linked service properties.
type MongoDbAtlasLinkedServiceTypeProperties struct {
	// REQUIRED; The MongoDB Atlas connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string,
	// SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// REQUIRED; The name of the MongoDB Atlas database that you want to access. Type: string (or Expression with resultType string).
	Database any

	// The driver version that you want to choose. Allowed value are v1 and v2. Type: string (or Expression with resultType string).
	DriverVersion any
}

// MongoDbAtlasSink - A copy activity MongoDB Atlas sink.
type MongoDbAtlasSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// Specifies whether the document with same key to be overwritten (upsert) rather than throw exception (insert). The default
	// value is "insert". Type: string (or Expression with resultType string). Type:
	// string (or Expression with resultType string).
	WriteBehavior any
}

// GetCopySink implements the CopySinkClassification interface for type MongoDbAtlasSink.
func (m *MongoDbAtlasSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		SinkRetryCount:           m.SinkRetryCount,
		SinkRetryWait:            m.SinkRetryWait,
		Type:                     m.Type,
		WriteBatchSize:           m.WriteBatchSize,
		WriteBatchTimeout:        m.WriteBatchTimeout,
	}
}

// MongoDbAtlasSource - A copy activity source for a MongoDB Atlas database.
type MongoDbAtlasSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specifies the number of documents to return in each batch of the response from MongoDB Atlas instance. In most cases, modifying
	// the batch size will not affect the user or the application. This
	// property's main purpose is to avoid hit the limitation of response size. Type: integer (or Expression with resultType integer).
	BatchSize any

	// Cursor methods for Mongodb query
	CursorMethods *MongoDbCursorMethodsProperties

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies selection filter using query operators. To return all documents in a collection, omit this parameter or pass
	// an empty document ({}). Type: string (or Expression with resultType string).
	Filter any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type MongoDbAtlasSource.
func (m *MongoDbAtlasSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		Type:                     m.Type,
	}
}

// MongoDbCollectionDataset - The MongoDB database dataset.
type MongoDbCollectionDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; MongoDB database dataset properties.
	TypeProperties *MongoDbCollectionDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type MongoDbCollectionDataset.
func (m *MongoDbCollectionDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		Description:          m.Description,
		Folder:               m.Folder,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Schema:               m.Schema,
		Structure:            m.Structure,
		Type:                 m.Type,
	}
}

// MongoDbCollectionDatasetTypeProperties - MongoDB database dataset properties.
type MongoDbCollectionDatasetTypeProperties struct {
	// REQUIRED; The table name of the MongoDB database. Type: string (or Expression with resultType string).
	CollectionName any
}

// MongoDbCursorMethodsProperties - Cursor methods for Mongodb query
type MongoDbCursorMethodsProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specifies the maximum number of documents the server returns. limit() is analogous to the LIMIT statement in a SQL database.
	// Type: integer (or Expression with resultType integer).
	Limit any

	// Specifies the fields to return in the documents that match the query filter. To return all fields in the matching documents,
	// omit this parameter. Type: string (or Expression with resultType string).
	Project any

	// Specifies the how many documents skipped and where MongoDB begins returning results. This approach may be useful in implementing
	// paginated results. Type: integer (or Expression with resultType
	// integer).
	Skip any

	// Specifies the order in which the query returns matching documents. Type: string (or Expression with resultType string).
	// Type: string (or Expression with resultType string).
	Sort any
}

// MongoDbLinkedService - Linked service for MongoDb data source.
type MongoDbLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; MongoDB linked service properties.
	TypeProperties *MongoDbLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type MongoDbLinkedService.
func (m *MongoDbLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Type:                 m.Type,
	}
}

// MongoDbLinkedServiceTypeProperties - MongoDB linked service properties.
type MongoDbLinkedServiceTypeProperties struct {
	// REQUIRED; The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
	DatabaseName any

	// REQUIRED; The IP address or server name of the MongoDB server. Type: string (or Expression with resultType string).
	Server any

	// Specifies whether to allow self-signed certificates from the server. The default value is false. Type: boolean (or Expression
	// with resultType boolean).
	AllowSelfSignedServerCert any

	// Database to verify the username and password. Type: string (or Expression with resultType string).
	AuthSource any

	// The authentication type to be used to connect to the MongoDB database.
	AuthenticationType *MongoDbAuthenticationType

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false. Type: boolean (or
	// Expression with resultType boolean).
	EnableSSL any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Password for authentication.
	Password SecretBaseClassification

	// The TCP port number that the MongoDB server uses to listen for client connections. The default value is 27017. Type: integer
	// (or Expression with resultType integer), minimum: 0.
	Port any

	// Username for authentication. Type: string (or Expression with resultType string).
	Username any
}

// MongoDbSource - A copy activity source for a MongoDB database.
type MongoDbSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Should be a SQL-92 query expression. Type: string (or Expression with resultType string).
	Query any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type MongoDbSource.
func (m *MongoDbSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		Type:                     m.Type,
	}
}

// MongoDbV2CollectionDataset - The MongoDB database dataset.
type MongoDbV2CollectionDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; MongoDB database dataset properties.
	TypeProperties *MongoDbV2CollectionDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type MongoDbV2CollectionDataset.
func (m *MongoDbV2CollectionDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		Description:          m.Description,
		Folder:               m.Folder,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Schema:               m.Schema,
		Structure:            m.Structure,
		Type:                 m.Type,
	}
}

// MongoDbV2CollectionDatasetTypeProperties - MongoDB database dataset properties.
type MongoDbV2CollectionDatasetTypeProperties struct {
	// REQUIRED; The collection name of the MongoDB database. Type: string (or Expression with resultType string).
	Collection any
}

// MongoDbV2LinkedService - Linked service for MongoDB data source.
type MongoDbV2LinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; MongoDB linked service properties.
	TypeProperties *MongoDbV2LinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type MongoDbV2LinkedService.
func (m *MongoDbV2LinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Type:                 m.Type,
	}
}

// MongoDbV2LinkedServiceTypeProperties - MongoDB linked service properties.
type MongoDbV2LinkedServiceTypeProperties struct {
	// REQUIRED; The MongoDB connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString
	// or AzureKeyVaultSecretReference.
	ConnectionString any

	// REQUIRED; The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
	Database any
}

// MongoDbV2Sink - A copy activity MongoDB sink.
type MongoDbV2Sink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// Specifies whether the document with same key to be overwritten (upsert) rather than throw exception (insert). The default
	// value is "insert". Type: string (or Expression with resultType string). Type:
	// string (or Expression with resultType string).
	WriteBehavior any
}

// GetCopySink implements the CopySinkClassification interface for type MongoDbV2Sink.
func (m *MongoDbV2Sink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		SinkRetryCount:           m.SinkRetryCount,
		SinkRetryWait:            m.SinkRetryWait,
		Type:                     m.Type,
		WriteBatchSize:           m.WriteBatchSize,
		WriteBatchTimeout:        m.WriteBatchTimeout,
	}
}

// MongoDbV2Source - A copy activity source for a MongoDB database.
type MongoDbV2Source struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specifies the number of documents to return in each batch of the response from MongoDB instance. In most cases, modifying
	// the batch size will not affect the user or the application. This property's
	// main purpose is to avoid hit the limitation of response size. Type: integer (or Expression with resultType integer).
	BatchSize any

	// Cursor methods for Mongodb query
	CursorMethods *MongoDbCursorMethodsProperties

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies selection filter using query operators. To return all documents in a collection, omit this parameter or pass
	// an empty document ({}). Type: string (or Expression with resultType string).
	Filter any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type MongoDbV2Source.
func (m *MongoDbV2Source) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		Type:                     m.Type,
	}
}

// MultiplePipelineTrigger - Base class for all triggers that support one to many model for trigger to pipeline.
type MultiplePipelineTrigger struct {
	// REQUIRED; Trigger type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the trigger.
	Annotations []any

	// Trigger description.
	Description *string

	// Pipelines that need to be started.
	Pipelines []*TriggerPipelineReference

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState
}

// GetMultiplePipelineTrigger implements the MultiplePipelineTriggerClassification interface for type MultiplePipelineTrigger.
func (m *MultiplePipelineTrigger) GetMultiplePipelineTrigger() *MultiplePipelineTrigger { return m }

// GetTrigger implements the TriggerClassification interface for type MultiplePipelineTrigger.
func (m *MultiplePipelineTrigger) GetTrigger() *Trigger {
	return &Trigger{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		Description:          m.Description,
		RuntimeState:         m.RuntimeState,
		Type:                 m.Type,
	}
}

// MySQLLinkedService - Linked service for MySQL data source.
type MySQLLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; MySQL linked service properties.
	TypeProperties *MySQLLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type MySQLLinkedService.
func (m *MySQLLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Type:                 m.Type,
	}
}

// MySQLLinkedServiceTypeProperties - MySQL linked service properties.
type MySQLLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference
}

// MySQLSource - A copy activity source for MySQL databases.
type MySQLSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type MySQLSource.
func (m *MySQLSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		Type:                     m.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type MySQLSource.
func (m *MySQLSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        m.AdditionalColumns,
		AdditionalProperties:     m.AdditionalProperties,
		DisableMetricsCollection: m.DisableMetricsCollection,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		QueryTimeout:             m.QueryTimeout,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		Type:                     m.Type,
	}
}

// MySQLTableDataset - The MySQL table dataset.
type MySQLTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// MySQL table dataset properties.
	TypeProperties *MySQLTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type MySQLTableDataset.
func (m *MySQLTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: m.AdditionalProperties,
		Annotations:          m.Annotations,
		Description:          m.Description,
		Folder:               m.Folder,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Schema:               m.Schema,
		Structure:            m.Structure,
		Type:                 m.Type,
	}
}

// MySQLTableDatasetTypeProperties - MySql table dataset properties.
type MySQLTableDatasetTypeProperties struct {
	// The MySQL table name. Type: string (or Expression with resultType string).
	TableName any
}

// NetezzaLinkedService - Netezza linked service.
type NetezzaLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Netezza linked service properties.
	TypeProperties *NetezzaLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type NetezzaLinkedService.
func (n *NetezzaLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: n.AdditionalProperties,
		Annotations:          n.Annotations,
		ConnectVia:           n.ConnectVia,
		Description:          n.Description,
		Parameters:           n.Parameters,
		Type:                 n.Type,
	}
}

// NetezzaLinkedServiceTypeProperties - Netezza linked service properties.
type NetezzaLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Pwd *AzureKeyVaultSecretReference
}

// NetezzaPartitionSettings - The settings that will be leveraged for Netezza source partitioning.
type NetezzaPartitionSettings struct {
	// The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression
	// with resultType string).
	PartitionColumnName any

	// The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionLowerBound any

	// The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionUpperBound any
}

// NetezzaSource - A copy activity Netezza source.
type NetezzaSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The partition mechanism that will be used for Netezza read in parallel. Possible values include: "None", "DataSlice", "DynamicRange".
	PartitionOption any

	// The settings that will be leveraged for Netezza source partitioning.
	PartitionSettings *NetezzaPartitionSettings

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type NetezzaSource.
func (n *NetezzaSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     n.AdditionalProperties,
		DisableMetricsCollection: n.DisableMetricsCollection,
		MaxConcurrentConnections: n.MaxConcurrentConnections,
		SourceRetryCount:         n.SourceRetryCount,
		SourceRetryWait:          n.SourceRetryWait,
		Type:                     n.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type NetezzaSource.
func (n *NetezzaSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        n.AdditionalColumns,
		AdditionalProperties:     n.AdditionalProperties,
		DisableMetricsCollection: n.DisableMetricsCollection,
		MaxConcurrentConnections: n.MaxConcurrentConnections,
		QueryTimeout:             n.QueryTimeout,
		SourceRetryCount:         n.SourceRetryCount,
		SourceRetryWait:          n.SourceRetryWait,
		Type:                     n.Type,
	}
}

// NetezzaTableDataset - Netezza dataset.
type NetezzaTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *NetezzaTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type NetezzaTableDataset.
func (n *NetezzaTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: n.AdditionalProperties,
		Annotations:          n.Annotations,
		Description:          n.Description,
		Folder:               n.Folder,
		LinkedServiceName:    n.LinkedServiceName,
		Parameters:           n.Parameters,
		Schema:               n.Schema,
		Structure:            n.Structure,
		Type:                 n.Type,
	}
}

// NetezzaTableDatasetTypeProperties - Netezza dataset properties.
type NetezzaTableDatasetTypeProperties struct {
	// The schema name of the Netezza. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the Netezza. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// NotebookParameter - Notebook parameter.
type NotebookParameter struct {
	// Notebook parameter type.
	Type *NotebookParameterType

	// Notebook parameter value. Type: string (or Expression with resultType string).
	Value any
}

// ODataLinkedService - Open Data Protocol (OData) linked service.
type ODataLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; OData linked service properties.
	TypeProperties *ODataLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type ODataLinkedService.
func (o *ODataLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: o.AdditionalProperties,
		Annotations:          o.Annotations,
		ConnectVia:           o.ConnectVia,
		Description:          o.Description,
		Parameters:           o.Parameters,
		Type:                 o.Type,
	}
}

// ODataLinkedServiceTypeProperties - OData linked service properties.
type ODataLinkedServiceTypeProperties struct {
	// REQUIRED; The URL of the OData service endpoint. Type: string (or Expression with resultType string).
	URL any

	// Specify the resource you are requesting authorization to use Directory. Type: string (or Expression with resultType string).
	AADResourceID any

	// Specify the credential type (key or cert) is used for service principal.
	AADServicePrincipalCredentialType *ODataAADServicePrincipalCredentialType

	// The additional HTTP headers in the request to RESTful API used for authorization. Type: object (or Expression with resultType
	// object).
	AuthHeaders any

	// Type of authentication used to connect to the OData service.
	AuthenticationType *ODataAuthenticationType

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Password of the OData service.
	Password SecretBaseClassification

	// Specify the base64 encoded certificate of your application registered in Azure Active Directory. Type: string (or Expression
	// with resultType string).
	ServicePrincipalEmbeddedCert SecretBaseClassification

	// Specify the password of your certificate if your certificate has a password and you are using AadServicePrincipal authentication.
	// Type: string (or Expression with resultType string).
	ServicePrincipalEmbeddedCertPassword SecretBaseClassification

	// Specify the application id of your application registered in Azure Active Directory. Type: string (or Expression with resultType
	// string).
	ServicePrincipalID any

	// Specify the secret of your application registered in Azure Active Directory. Type: string (or Expression with resultType
	// string).
	ServicePrincipalKey SecretBaseClassification

	// Specify the tenant information (domain name or tenant ID) under which your application resides. Type: string (or Expression
	// with resultType string).
	Tenant any

	// User name of the OData service. Type: string (or Expression with resultType string).
	UserName any
}

// ODataResourceDataset - The Open Data Protocol (OData) resource dataset.
type ODataResourceDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// OData dataset properties.
	TypeProperties *ODataResourceDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type ODataResourceDataset.
func (o *ODataResourceDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: o.AdditionalProperties,
		Annotations:          o.Annotations,
		Description:          o.Description,
		Folder:               o.Folder,
		LinkedServiceName:    o.LinkedServiceName,
		Parameters:           o.Parameters,
		Schema:               o.Schema,
		Structure:            o.Structure,
		Type:                 o.Type,
	}
}

// ODataResourceDatasetTypeProperties - OData dataset properties.
type ODataResourceDatasetTypeProperties struct {
	// The OData resource path. Type: string (or Expression with resultType string).
	Path any
}

// ODataSource - A copy activity source for OData source.
type ODataSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data.
	// Default value: 00:05:00. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// OData query. For example, "$top=1". Type: string (or Expression with resultType string).
	Query any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type ODataSource.
func (o *ODataSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     o.AdditionalProperties,
		DisableMetricsCollection: o.DisableMetricsCollection,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		Type:                     o.Type,
	}
}

// OdbcLinkedService - Open Database Connectivity (ODBC) linked service.
type OdbcLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; ODBC linked service properties.
	TypeProperties *OdbcLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type OdbcLinkedService.
func (o *OdbcLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: o.AdditionalProperties,
		Annotations:          o.Annotations,
		ConnectVia:           o.ConnectVia,
		Description:          o.Description,
		Parameters:           o.Parameters,
		Type:                 o.Type,
	}
}

// OdbcLinkedServiceTypeProperties - ODBC linked service properties.
type OdbcLinkedServiceTypeProperties struct {
	// REQUIRED; The non-access credential portion of the connection string as well as an optional encrypted credential. Type:
	// string, or SecureString, or AzureKeyVaultSecretReference, or Expression with resultType
	// string.
	ConnectionString any

	// Type of authentication used to connect to the ODBC data store. Possible values are: Anonymous and Basic. Type: string (or
	// Expression with resultType string).
	AuthenticationType any

	// The access credential portion of the connection string specified in driver-specific property-value format.
	Credential SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Password for Basic authentication.
	Password SecretBaseClassification

	// User name for Basic authentication. Type: string (or Expression with resultType string).
	UserName any
}

// OdbcSink - A copy activity ODBC sink.
type OdbcSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to execute before starting the copy. Type: string (or Expression with resultType string).
	PreCopyScript any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type OdbcSink.
func (o *OdbcSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     o.AdditionalProperties,
		DisableMetricsCollection: o.DisableMetricsCollection,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		SinkRetryCount:           o.SinkRetryCount,
		SinkRetryWait:            o.SinkRetryWait,
		Type:                     o.Type,
		WriteBatchSize:           o.WriteBatchSize,
		WriteBatchTimeout:        o.WriteBatchTimeout,
	}
}

// OdbcSource - A copy activity source for ODBC databases.
type OdbcSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type OdbcSource.
func (o *OdbcSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     o.AdditionalProperties,
		DisableMetricsCollection: o.DisableMetricsCollection,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		Type:                     o.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type OdbcSource.
func (o *OdbcSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        o.AdditionalColumns,
		AdditionalProperties:     o.AdditionalProperties,
		DisableMetricsCollection: o.DisableMetricsCollection,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		QueryTimeout:             o.QueryTimeout,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		Type:                     o.Type,
	}
}

// OdbcTableDataset - The ODBC table dataset.
type OdbcTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// ODBC table dataset properties.
	TypeProperties *OdbcTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type OdbcTableDataset.
func (o *OdbcTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: o.AdditionalProperties,
		Annotations:          o.Annotations,
		Description:          o.Description,
		Folder:               o.Folder,
		LinkedServiceName:    o.LinkedServiceName,
		Parameters:           o.Parameters,
		Schema:               o.Schema,
		Structure:            o.Structure,
		Type:                 o.Type,
	}
}

// OdbcTableDatasetTypeProperties - ODBC table dataset properties.
type OdbcTableDatasetTypeProperties struct {
	// The ODBC table name. Type: string (or Expression with resultType string).
	TableName any
}

// Office365Dataset - The Office365 account.
type Office365Dataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; Office365 dataset properties.
	TypeProperties *Office365DatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type Office365Dataset.
func (o *Office365Dataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: o.AdditionalProperties,
		Annotations:          o.Annotations,
		Description:          o.Description,
		Folder:               o.Folder,
		LinkedServiceName:    o.LinkedServiceName,
		Parameters:           o.Parameters,
		Schema:               o.Schema,
		Structure:            o.Structure,
		Type:                 o.Type,
	}
}

// Office365DatasetTypeProperties - Office365 dataset properties.
type Office365DatasetTypeProperties struct {
	// REQUIRED; Name of the dataset to extract from Office 365. Type: string (or Expression with resultType string).
	TableName any

	// A predicate expression that can be used to filter the specific rows to extract from Office 365. Type: string (or Expression
	// with resultType string).
	Predicate any
}

// Office365LinkedService - Office365 linked service.
type Office365LinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Office365 linked service properties.
	TypeProperties *Office365LinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type Office365LinkedService.
func (o *Office365LinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: o.AdditionalProperties,
		Annotations:          o.Annotations,
		ConnectVia:           o.ConnectVia,
		Description:          o.Description,
		Parameters:           o.Parameters,
		Type:                 o.Type,
	}
}

// Office365LinkedServiceTypeProperties - Office365 linked service properties.
type Office365LinkedServiceTypeProperties struct {
	// REQUIRED; Azure tenant ID to which the Office 365 account belongs. Type: string (or Expression with resultType string).
	Office365TenantID any

	// REQUIRED; Specify the application's client ID. Type: string (or Expression with resultType string).
	ServicePrincipalID any

	// REQUIRED; Specify the application's key.
	ServicePrincipalKey SecretBaseClassification

	// REQUIRED; Specify the tenant information under which your Azure AD web application resides. Type: string (or Expression
	// with resultType string).
	ServicePrincipalTenantID any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string
}

// Office365Source - A copy activity source for an Office 365 service.
type Office365Source struct {
	// REQUIRED; Copy source type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The groups containing all the users. Type: array of strings (or Expression with resultType array of strings).
	AllowedGroups any

	// The Column to apply the and . Type: string (or Expression with resultType string).
	DateFilterColumn any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// End time of the requested range for this dataset. Type: string (or Expression with resultType string).
	EndTime any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The columns to be read out from the Office 365 table. Type: array of objects (or Expression with resultType array of objects).
	// itemType: OutputColumn. Example: [ { "name": "Id" }, { "name":
	// "CreatedDateTime" } ]
	OutputColumns any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Start time of the requested range for this dataset. Type: string (or Expression with resultType string).
	StartTime any

	// The user scope uri. Type: string (or Expression with resultType string).
	UserScopeFilterURI any
}

// GetCopySource implements the CopySourceClassification interface for type Office365Source.
func (o *Office365Source) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     o.AdditionalProperties,
		DisableMetricsCollection: o.DisableMetricsCollection,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		Type:                     o.Type,
	}
}

// Operation - Azure Data Factory API operation definition.
type Operation struct {
	// Metadata associated with the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string

	// The intended executor of the operation.
	Origin *string

	// Additional details about the operation.
	Properties *OperationProperties
}

// OperationDisplay - Metadata associated with the operation.
type OperationDisplay struct {
	// The description of the operation.
	Description *string

	// The type of operation: get, read, delete, etc.
	Operation *string

	// The name of the provider.
	Provider *string

	// The name of the resource type on which the operation is performed.
	Resource *string
}

// OperationListResponse - A list of operations that can be performed by the Data Factory service.
type OperationListResponse struct {
	// The link to the next page of results, if any remaining results exist.
	NextLink *string

	// List of Data Factory operations supported by the Data Factory resource provider.
	Value []*Operation
}

// OperationLogSpecification - Details about an operation related to logs.
type OperationLogSpecification struct {
	// Blobs created in the customer storage account, per hour.
	BlobDuration *string

	// Localized display name.
	DisplayName *string

	// The name of the log category.
	Name *string
}

// OperationMetricAvailability - Defines how often data for a metric becomes available.
type OperationMetricAvailability struct {
	// Blob created in the customer storage account, per hour.
	BlobDuration *string

	// The granularity for the metric.
	TimeGrain *string
}

// OperationMetricDimension - Defines the metric dimension.
type OperationMetricDimension struct {
	// The display name of the metric dimension.
	DisplayName *string

	// The name of the dimension for the metric.
	Name *string

	// Whether the dimension should be exported to Azure Monitor.
	ToBeExportedForShoebox *bool
}

// OperationMetricSpecification - Details about an operation related to metrics.
type OperationMetricSpecification struct {
	// The type of metric aggregation.
	AggregationType *string

	// Defines how often data for metrics becomes available.
	Availabilities []*OperationMetricAvailability

	// Defines the metric dimension.
	Dimensions []*OperationMetricDimension

	// The description of the metric.
	DisplayDescription *string

	// Localized display name of the metric.
	DisplayName *string

	// Whether or not the service is using regional MDM accounts.
	EnableRegionalMdmAccount *string

	// The name of the metric.
	Name *string

	// The name of the MDM account.
	SourceMdmAccount *string

	// The name of the MDM namespace.
	SourceMdmNamespace *string

	// The unit that the metric is measured in.
	Unit *string
}

// OperationProperties - Additional details about an operation.
type OperationProperties struct {
	// Details about a service operation.
	ServiceSpecification *OperationServiceSpecification
}

// OperationServiceSpecification - Details about a service operation.
type OperationServiceSpecification struct {
	// Details about operations related to logs.
	LogSpecifications []*OperationLogSpecification

	// Details about operations related to metrics.
	MetricSpecifications []*OperationMetricSpecification
}

// OracleCloudStorageLinkedService - Linked service for Oracle Cloud Storage.
type OracleCloudStorageLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Oracle Cloud Storage linked service properties.
	TypeProperties *OracleCloudStorageLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type OracleCloudStorageLinkedService.
func (o *OracleCloudStorageLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: o.AdditionalProperties,
		Annotations:          o.Annotations,
		ConnectVia:           o.ConnectVia,
		Description:          o.Description,
		Parameters:           o.Parameters,
		Type:                 o.Type,
	}
}

// OracleCloudStorageLinkedServiceTypeProperties - Oracle Cloud Storage linked service properties.
type OracleCloudStorageLinkedServiceTypeProperties struct {
	// The access key identifier of the Oracle Cloud Storage Identity and Access Management (IAM) user. Type: string (or Expression
	// with resultType string).
	AccessKeyID any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The secret access key of the Oracle Cloud Storage Identity and Access Management (IAM) user.
	SecretAccessKey SecretBaseClassification

	// This value specifies the endpoint to access with the Oracle Cloud Storage Connector. This is an optional property; change
	// it only if you want to try a different service endpoint or want to switch
	// between https and http. Type: string (or Expression with resultType string).
	ServiceURL any
}

// OracleCloudStorageLocation - The location of Oracle Cloud Storage dataset.
type OracleCloudStorageLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the bucketName of Oracle Cloud Storage. Type: string (or Expression with resultType string)
	BucketName any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any

	// Specify the version of Oracle Cloud Storage. Type: string (or Expression with resultType string).
	Version any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type OracleCloudStorageLocation.
func (o *OracleCloudStorageLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: o.AdditionalProperties,
		FileName:             o.FileName,
		FolderPath:           o.FolderPath,
		Type:                 o.Type,
	}
}

// OracleCloudStorageReadSettings - Oracle Cloud Storage read settings.
type OracleCloudStorageReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// The prefix filter for the Oracle Cloud Storage object name. Type: string (or Expression with resultType string).
	Prefix any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Oracle Cloud Storage wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// Oracle Cloud Storage wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type OracleCloudStorageReadSettings.
func (o *OracleCloudStorageReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     o.AdditionalProperties,
		DisableMetricsCollection: o.DisableMetricsCollection,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		Type:                     o.Type,
	}
}

// OracleLinkedService - Oracle database.
type OracleLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Oracle database linked service properties.
	TypeProperties *OracleLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type OracleLinkedService.
func (o *OracleLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: o.AdditionalProperties,
		Annotations:          o.Annotations,
		ConnectVia:           o.ConnectVia,
		Description:          o.Description,
		Parameters:           o.Parameters,
		Type:                 o.Type,
	}
}

// OracleLinkedServiceTypeProperties - Oracle database linked service properties.
type OracleLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference
}

// OraclePartitionSettings - The settings that will be leveraged for Oracle source partitioning.
type OraclePartitionSettings struct {
	// The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression
	// with resultType string).
	PartitionColumnName any

	// The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionLowerBound any

	// Names of the physical partitions of Oracle table.
	PartitionNames any

	// The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionUpperBound any
}

// OracleServiceCloudLinkedService - Oracle Service Cloud linked service.
type OracleServiceCloudLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Oracle Service Cloud linked service properties.
	TypeProperties *OracleServiceCloudLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type OracleServiceCloudLinkedService.
func (o *OracleServiceCloudLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: o.AdditionalProperties,
		Annotations:          o.Annotations,
		ConnectVia:           o.ConnectVia,
		Description:          o.Description,
		Parameters:           o.Parameters,
		Type:                 o.Type,
	}
}

// OracleServiceCloudLinkedServiceTypeProperties - Oracle Service Cloud linked service properties.
type OracleServiceCloudLinkedServiceTypeProperties struct {
	// REQUIRED; The URL of the Oracle Service Cloud instance.
	Host any

	// REQUIRED; The password corresponding to the user name that you provided in the username key.
	Password SecretBaseClassification

	// REQUIRED; The user name that you use to access Oracle Service Cloud server.
	Username any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. Type: boolean (or Expression
	// with resultType boolean).
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true. Type: boolean (or Expression with
	// resultType boolean).
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. Type: boolean
	// (or Expression with resultType boolean).
	UsePeerVerification any
}

// OracleServiceCloudObjectDataset - Oracle Service Cloud dataset.
type OracleServiceCloudObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type OracleServiceCloudObjectDataset.
func (o *OracleServiceCloudObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: o.AdditionalProperties,
		Annotations:          o.Annotations,
		Description:          o.Description,
		Folder:               o.Folder,
		LinkedServiceName:    o.LinkedServiceName,
		Parameters:           o.Parameters,
		Schema:               o.Schema,
		Structure:            o.Structure,
		Type:                 o.Type,
	}
}

// OracleServiceCloudSource - A copy activity Oracle Service Cloud source.
type OracleServiceCloudSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type OracleServiceCloudSource.
func (o *OracleServiceCloudSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     o.AdditionalProperties,
		DisableMetricsCollection: o.DisableMetricsCollection,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		Type:                     o.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type OracleServiceCloudSource.
func (o *OracleServiceCloudSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        o.AdditionalColumns,
		AdditionalProperties:     o.AdditionalProperties,
		DisableMetricsCollection: o.DisableMetricsCollection,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		QueryTimeout:             o.QueryTimeout,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		Type:                     o.Type,
	}
}

// OracleSink - A copy activity Oracle sink.
type OracleSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type OracleSink.
func (o *OracleSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     o.AdditionalProperties,
		DisableMetricsCollection: o.DisableMetricsCollection,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		SinkRetryCount:           o.SinkRetryCount,
		SinkRetryWait:            o.SinkRetryWait,
		Type:                     o.Type,
		WriteBatchSize:           o.WriteBatchSize,
		WriteBatchTimeout:        o.WriteBatchTimeout,
	}
}

// OracleSource - A copy activity Oracle source.
type OracleSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Oracle reader query. Type: string (or Expression with resultType string).
	OracleReaderQuery any

	// The partition mechanism that will be used for Oracle read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "DynamicRange".
	PartitionOption any

	// The settings that will be leveraged for Oracle source partitioning.
	PartitionSettings *OraclePartitionSettings

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type OracleSource.
func (o *OracleSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     o.AdditionalProperties,
		DisableMetricsCollection: o.DisableMetricsCollection,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		Type:                     o.Type,
	}
}

// OracleTableDataset - The on-premises Oracle database dataset.
type OracleTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// On-premises Oracle dataset properties.
	TypeProperties *OracleTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type OracleTableDataset.
func (o *OracleTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: o.AdditionalProperties,
		Annotations:          o.Annotations,
		Description:          o.Description,
		Folder:               o.Folder,
		LinkedServiceName:    o.LinkedServiceName,
		Parameters:           o.Parameters,
		Schema:               o.Schema,
		Structure:            o.Structure,
		Type:                 o.Type,
	}
}

// OracleTableDatasetTypeProperties - On-premises Oracle dataset properties.
type OracleTableDatasetTypeProperties struct {
	// The schema name of the on-premises Oracle database. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the on-premises Oracle database. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// OrcDataset - ORC dataset.
type OrcDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// ORC dataset properties.
	TypeProperties *OrcDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type OrcDataset.
func (o *OrcDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: o.AdditionalProperties,
		Annotations:          o.Annotations,
		Description:          o.Description,
		Folder:               o.Folder,
		LinkedServiceName:    o.LinkedServiceName,
		Parameters:           o.Parameters,
		Schema:               o.Schema,
		Structure:            o.Structure,
		Type:                 o.Type,
	}
}

// OrcDatasetTypeProperties - ORC dataset properties.
type OrcDatasetTypeProperties struct {
	// REQUIRED; The location of the ORC data storage.
	Location DatasetLocationClassification

	// The data orcCompressionCodec. Type: string (or Expression with resultType string).
	OrcCompressionCodec any
}

// OrcFormat - The data stored in Optimized Row Columnar (ORC) format.
type OrcFormat struct {
	// REQUIRED; Type of dataset storage format.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Deserializer. Type: string (or Expression with resultType string).
	Deserializer any

	// Serializer. Type: string (or Expression with resultType string).
	Serializer any
}

// GetDatasetStorageFormat implements the DatasetStorageFormatClassification interface for type OrcFormat.
func (o *OrcFormat) GetDatasetStorageFormat() *DatasetStorageFormat {
	return &DatasetStorageFormat{
		AdditionalProperties: o.AdditionalProperties,
		Deserializer:         o.Deserializer,
		Serializer:           o.Serializer,
		Type:                 o.Type,
	}
}

// OrcSink - A copy activity ORC sink.
type OrcSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// ORC format settings.
	FormatSettings *OrcWriteSettings

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// ORC store settings.
	StoreSettings StoreWriteSettingsClassification

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type OrcSink.
func (o *OrcSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     o.AdditionalProperties,
		DisableMetricsCollection: o.DisableMetricsCollection,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		SinkRetryCount:           o.SinkRetryCount,
		SinkRetryWait:            o.SinkRetryWait,
		Type:                     o.Type,
		WriteBatchSize:           o.WriteBatchSize,
		WriteBatchTimeout:        o.WriteBatchTimeout,
	}
}

// OrcSource - A copy activity ORC source.
type OrcSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// ORC store settings.
	StoreSettings StoreReadSettingsClassification
}

// GetCopySource implements the CopySourceClassification interface for type OrcSource.
func (o *OrcSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     o.AdditionalProperties,
		DisableMetricsCollection: o.DisableMetricsCollection,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		Type:                     o.Type,
	}
}

// OrcWriteSettings - Orc write settings.
type OrcWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specifies the file name pattern _. when copy from non-file based store without partitionOptions. Type: string (or Expression
	// with resultType string).
	FileNamePrefix any

	// Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with
	// resultType integer).
	MaxRowsPerFile any
}

// GetFormatWriteSettings implements the FormatWriteSettingsClassification interface for type OrcWriteSettings.
func (o *OrcWriteSettings) GetFormatWriteSettings() *FormatWriteSettings {
	return &FormatWriteSettings{
		AdditionalProperties: o.AdditionalProperties,
		Type:                 o.Type,
	}
}

// PackageStore - Package store for the SSIS integration runtime.
type PackageStore struct {
	// REQUIRED; The name of the package store
	Name *string

	// REQUIRED; The package store linked service reference.
	PackageStoreLinkedService *EntityReference
}

// ParameterSpecification - Definition of a single parameter for an entity.
type ParameterSpecification struct {
	// REQUIRED; Parameter type.
	Type *ParameterType

	// Default value of parameter.
	DefaultValue any
}

// ParquetDataset - Parquet dataset.
type ParquetDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Parquet dataset properties.
	TypeProperties *ParquetDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type ParquetDataset.
func (p *ParquetDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: p.AdditionalProperties,
		Annotations:          p.Annotations,
		Description:          p.Description,
		Folder:               p.Folder,
		LinkedServiceName:    p.LinkedServiceName,
		Parameters:           p.Parameters,
		Schema:               p.Schema,
		Structure:            p.Structure,
		Type:                 p.Type,
	}
}

// ParquetDatasetTypeProperties - Parquet dataset properties.
type ParquetDatasetTypeProperties struct {
	// REQUIRED; The location of the parquet storage.
	Location DatasetLocationClassification

	// The data compressionCodec. Type: string (or Expression with resultType string).
	CompressionCodec any
}

// ParquetFormat - The data stored in Parquet format.
type ParquetFormat struct {
	// REQUIRED; Type of dataset storage format.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Deserializer. Type: string (or Expression with resultType string).
	Deserializer any

	// Serializer. Type: string (or Expression with resultType string).
	Serializer any
}

// GetDatasetStorageFormat implements the DatasetStorageFormatClassification interface for type ParquetFormat.
func (p *ParquetFormat) GetDatasetStorageFormat() *DatasetStorageFormat {
	return &DatasetStorageFormat{
		AdditionalProperties: p.AdditionalProperties,
		Deserializer:         p.Deserializer,
		Serializer:           p.Serializer,
		Type:                 p.Type,
	}
}

// ParquetReadSettings - Parquet read settings.
type ParquetReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Compression settings.
	CompressionProperties CompressionReadSettingsClassification
}

// GetFormatReadSettings implements the FormatReadSettingsClassification interface for type ParquetReadSettings.
func (p *ParquetReadSettings) GetFormatReadSettings() *FormatReadSettings {
	return &FormatReadSettings{
		AdditionalProperties: p.AdditionalProperties,
		Type:                 p.Type,
	}
}

// ParquetSink - A copy activity Parquet sink.
type ParquetSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Parquet format settings.
	FormatSettings *ParquetWriteSettings

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Parquet store settings.
	StoreSettings StoreWriteSettingsClassification

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type ParquetSink.
func (p *ParquetSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     p.AdditionalProperties,
		DisableMetricsCollection: p.DisableMetricsCollection,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		SinkRetryCount:           p.SinkRetryCount,
		SinkRetryWait:            p.SinkRetryWait,
		Type:                     p.Type,
		WriteBatchSize:           p.WriteBatchSize,
		WriteBatchTimeout:        p.WriteBatchTimeout,
	}
}

// ParquetSource - A copy activity Parquet source.
type ParquetSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Parquet format settings.
	FormatSettings *ParquetReadSettings

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Parquet store settings.
	StoreSettings StoreReadSettingsClassification
}

// GetCopySource implements the CopySourceClassification interface for type ParquetSource.
func (p *ParquetSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     p.AdditionalProperties,
		DisableMetricsCollection: p.DisableMetricsCollection,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		Type:                     p.Type,
	}
}

// ParquetWriteSettings - Parquet write settings.
type ParquetWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specifies the file name pattern _. when copy from non-file based store without partitionOptions. Type: string (or Expression
	// with resultType string).
	FileNamePrefix any

	// Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with
	// resultType integer).
	MaxRowsPerFile any
}

// GetFormatWriteSettings implements the FormatWriteSettingsClassification interface for type ParquetWriteSettings.
func (p *ParquetWriteSettings) GetFormatWriteSettings() *FormatWriteSettings {
	return &FormatWriteSettings{
		AdditionalProperties: p.AdditionalProperties,
		Type:                 p.Type,
	}
}

// PaypalLinkedService - Paypal Service linked service.
type PaypalLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Paypal Service linked service properties.
	TypeProperties *PaypalLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type PaypalLinkedService.
func (p *PaypalLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: p.AdditionalProperties,
		Annotations:          p.Annotations,
		ConnectVia:           p.ConnectVia,
		Description:          p.Description,
		Parameters:           p.Parameters,
		Type:                 p.Type,
	}
}

// PaypalLinkedServiceTypeProperties - Paypal Service linked service properties.
type PaypalLinkedServiceTypeProperties struct {
	// REQUIRED; The client ID associated with your PayPal application.
	ClientID any

	// REQUIRED; The URL of the PayPal instance. (i.e. api.sandbox.paypal.com)
	Host any

	// The client secret associated with your PayPal application.
	ClientSecret SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification any
}

// PaypalObjectDataset - Paypal Service dataset.
type PaypalObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type PaypalObjectDataset.
func (p *PaypalObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: p.AdditionalProperties,
		Annotations:          p.Annotations,
		Description:          p.Description,
		Folder:               p.Folder,
		LinkedServiceName:    p.LinkedServiceName,
		Parameters:           p.Parameters,
		Schema:               p.Schema,
		Structure:            p.Structure,
		Type:                 p.Type,
	}
}

// PaypalSource - A copy activity Paypal Service source.
type PaypalSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type PaypalSource.
func (p *PaypalSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     p.AdditionalProperties,
		DisableMetricsCollection: p.DisableMetricsCollection,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		Type:                     p.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type PaypalSource.
func (p *PaypalSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        p.AdditionalColumns,
		AdditionalProperties:     p.AdditionalProperties,
		DisableMetricsCollection: p.DisableMetricsCollection,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		QueryTimeout:             p.QueryTimeout,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		Type:                     p.Type,
	}
}

// PhoenixDatasetTypeProperties - Phoenix Dataset Properties
type PhoenixDatasetTypeProperties struct {
	// The schema name of the Phoenix. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the Phoenix. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// PhoenixLinkedService - Phoenix server linked service.
type PhoenixLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Phoenix server linked service properties.
	TypeProperties *PhoenixLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type PhoenixLinkedService.
func (p *PhoenixLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: p.AdditionalProperties,
		Annotations:          p.Annotations,
		ConnectVia:           p.ConnectVia,
		Description:          p.Description,
		Parameters:           p.Parameters,
		Type:                 p.Type,
	}
}

// PhoenixLinkedServiceTypeProperties - Phoenix server linked service properties.
type PhoenixLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication mechanism used to connect to the Phoenix server.
	AuthenticationType *PhoenixAuthenticationType

	// REQUIRED; The IP address or host name of the Phoenix server. (i.e. 192.168.222.160)
	Host any

	// Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over
	// SSL. The default value is false.
	AllowHostNameCNMismatch any

	// Specifies whether to allow self-signed certificates from the server. The default value is false.
	AllowSelfSignedServerCert any

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false.
	EnableSSL any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The partial URL corresponding to the Phoenix server. (i.e. /gateway/sandbox/phoenix/version). The default value is hbasephoenix
	// if using WindowsAzureHDInsightService.
	HTTPPath any

	// The password corresponding to the user name.
	Password SecretBaseClassification

	// The TCP port that the Phoenix server uses to listen for client connections. The default value is 8765.
	Port any

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR.
	TrustedCertPath any

	// Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is
	// false.
	UseSystemTrustStore any

	// The user name used to connect to the Phoenix server.
	Username any
}

// PhoenixObjectDataset - Phoenix server dataset.
type PhoenixObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *PhoenixDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type PhoenixObjectDataset.
func (p *PhoenixObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: p.AdditionalProperties,
		Annotations:          p.Annotations,
		Description:          p.Description,
		Folder:               p.Folder,
		LinkedServiceName:    p.LinkedServiceName,
		Parameters:           p.Parameters,
		Schema:               p.Schema,
		Structure:            p.Structure,
		Type:                 p.Type,
	}
}

// PhoenixSource - A copy activity Phoenix server source.
type PhoenixSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type PhoenixSource.
func (p *PhoenixSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     p.AdditionalProperties,
		DisableMetricsCollection: p.DisableMetricsCollection,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		Type:                     p.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type PhoenixSource.
func (p *PhoenixSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        p.AdditionalColumns,
		AdditionalProperties:     p.AdditionalProperties,
		DisableMetricsCollection: p.DisableMetricsCollection,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		QueryTimeout:             p.QueryTimeout,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		Type:                     p.Type,
	}
}

// Pipeline - A data factory pipeline.
type Pipeline struct {
	// List of activities in pipeline.
	Activities []ActivityClassification

	// List of tags that can be used for describing the Pipeline.
	Annotations []any

	// The max number of concurrent runs for the pipeline.
	Concurrency *int32

	// The description of the pipeline.
	Description *string

	// The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
	Folder *PipelineFolder

	// List of parameters for pipeline.
	Parameters map[string]*ParameterSpecification

	// Pipeline Policy.
	Policy *PipelinePolicy

	// Dimensions emitted by Pipeline.
	RunDimensions map[string]any

	// List of variables for pipeline.
	Variables map[string]*VariableSpecification
}

// PipelineElapsedTimeMetricPolicy - Pipeline ElapsedTime Metric Policy.
type PipelineElapsedTimeMetricPolicy struct {
	// TimeSpan value, after which an Azure Monitoring Metric is fired.
	Duration any
}

// PipelineExternalComputeScaleProperties - PipelineExternalComputeScale properties for managed integration runtime.
type PipelineExternalComputeScaleProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Number of the the external nodes, which should be greater than 0 and less than 11.
	NumberOfExternalNodes *int32

	// Number of the pipeline nodes, which should be greater than 0 and less than 11.
	NumberOfPipelineNodes *int32

	// Time to live (in minutes) setting of integration runtime which will execute pipeline and external activity.
	TimeToLive *int32
}

// PipelineFolder - The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
type PipelineFolder struct {
	// The name of the folder that this Pipeline is in.
	Name *string
}

// PipelineListResponse - A list of pipeline resources.
type PipelineListResponse struct {
	// REQUIRED; List of pipelines.
	Value []*PipelineResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// PipelinePolicy - Pipeline Policy.
type PipelinePolicy struct {
	// Pipeline ElapsedTime Metric Policy.
	ElapsedTimeMetric *PipelineElapsedTimeMetricPolicy
}

// PipelineReference - Pipeline reference type.
type PipelineReference struct {
	// REQUIRED; Reference pipeline name.
	ReferenceName *string

	// REQUIRED; Pipeline reference type.
	Type *PipelineReferenceType

	// Reference name.
	Name *string
}

// PipelineResource - Pipeline resource type.
type PipelineResource struct {
	// REQUIRED; Properties of the pipeline.
	Properties *Pipeline

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// PipelineRun - Information about a pipeline run.
type PipelineRun struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The duration of a pipeline run.
	DurationInMs *int32

	// READ-ONLY; Entity that started the pipeline run.
	InvokedBy *PipelineRunInvokedBy

	// READ-ONLY; Indicates if the recovered pipeline run is the latest in its group.
	IsLatest *bool

	// READ-ONLY; The last updated timestamp for the pipeline run event in ISO8601 format.
	LastUpdated *time.Time

	// READ-ONLY; The message from a pipeline run.
	Message *string

	// READ-ONLY; The full or partial list of parameter name, value pair used in the pipeline run.
	Parameters map[string]*string

	// READ-ONLY; The pipeline name.
	PipelineName *string

	// READ-ONLY; Run dimensions emitted by Pipeline run.
	RunDimensions map[string]*string

	// READ-ONLY; The end time of a pipeline run in ISO8601 format.
	RunEnd *time.Time

	// READ-ONLY; Identifier that correlates all the recovery runs of a pipeline run.
	RunGroupID *string

	// READ-ONLY; Identifier of a run.
	RunID *string

	// READ-ONLY; The start time of a pipeline run in ISO8601 format.
	RunStart *time.Time

	// READ-ONLY; The status of a pipeline run. Possible values: Queued, InProgress, Succeeded, Failed, Canceling, Cancelled
	Status *string
}

// PipelineRunInvokedBy - Provides entity name and id that started the pipeline run.
type PipelineRunInvokedBy struct {
	// READ-ONLY; The ID of the entity that started the run.
	ID *string

	// READ-ONLY; The type of the entity that started the run.
	InvokedByType *string

	// READ-ONLY; Name of the entity that started the pipeline run.
	Name *string

	// READ-ONLY; The name of the pipeline that triggered the run, if any.
	PipelineName *string

	// READ-ONLY; The run id of the pipeline that triggered the run, if any.
	PipelineRunID *string
}

// PipelineRunsQueryResponse - A list pipeline runs.
type PipelineRunsQueryResponse struct {
	// REQUIRED; List of pipeline runs.
	Value []*PipelineRun

	// The continuation token for getting the next page of results, if any remaining results exist, null otherwise.
	ContinuationToken *string
}

// PolybaseSettings - PolyBase settings.
type PolybaseSettings struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Determines the number of rows to attempt to retrieve before the PolyBase recalculates the percentage of rejected rows.
	// Type: integer (or Expression with resultType integer), minimum: 0.
	RejectSampleValue any

	// Reject type.
	RejectType *PolybaseSettingsRejectType

	// Specifies the value or the percentage of rows that can be rejected before the query fails. Type: number (or Expression
	// with resultType number), minimum: 0.
	RejectValue any

	// Specifies how to handle missing values in delimited text files when PolyBase retrieves data from the text file. Type: boolean
	// (or Expression with resultType boolean).
	UseTypeDefault any
}

// PostgreSQLLinkedService - Linked service for PostgreSQL data source.
type PostgreSQLLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; PostgreSQL linked service properties.
	TypeProperties *PostgreSQLLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type PostgreSQLLinkedService.
func (p *PostgreSQLLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: p.AdditionalProperties,
		Annotations:          p.Annotations,
		ConnectVia:           p.ConnectVia,
		Description:          p.Description,
		Parameters:           p.Parameters,
		Type:                 p.Type,
	}
}

// PostgreSQLLinkedServiceTypeProperties - PostgreSQL linked service properties.
type PostgreSQLLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference
}

// PostgreSQLSource - A copy activity source for PostgreSQL databases.
type PostgreSQLSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type PostgreSQLSource.
func (p *PostgreSQLSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     p.AdditionalProperties,
		DisableMetricsCollection: p.DisableMetricsCollection,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		Type:                     p.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type PostgreSQLSource.
func (p *PostgreSQLSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        p.AdditionalColumns,
		AdditionalProperties:     p.AdditionalProperties,
		DisableMetricsCollection: p.DisableMetricsCollection,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		QueryTimeout:             p.QueryTimeout,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		Type:                     p.Type,
	}
}

// PostgreSQLTableDataset - The PostgreSQL table dataset.
type PostgreSQLTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// PostgreSQL table dataset properties.
	TypeProperties *PostgreSQLTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type PostgreSQLTableDataset.
func (p *PostgreSQLTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: p.AdditionalProperties,
		Annotations:          p.Annotations,
		Description:          p.Description,
		Folder:               p.Folder,
		LinkedServiceName:    p.LinkedServiceName,
		Parameters:           p.Parameters,
		Schema:               p.Schema,
		Structure:            p.Structure,
		Type:                 p.Type,
	}
}

// PostgreSQLTableDatasetTypeProperties - PostgreSQL table dataset properties.
type PostgreSQLTableDatasetTypeProperties struct {
	// The PostgreSQL schema name. Type: string (or Expression with resultType string).
	Schema any

	// The PostgreSQL table name. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// PowerQuerySink - Power query sink.
type PowerQuerySink struct {
	// REQUIRED; Transformation name.
	Name *string

	// Dataset reference.
	Dataset *DatasetReference

	// Transformation description.
	Description *string

	// Flowlet Reference
	Flowlet *DataFlowReference

	// Linked service reference.
	LinkedService *LinkedServiceReference

	// Rejected data linked service reference.
	RejectedDataLinkedService *LinkedServiceReference

	// Schema linked service reference.
	SchemaLinkedService *LinkedServiceReference

	// sink script.
	Script *string
}

// PowerQuerySinkMapping - Map Power Query mashup query to sink dataset(s).
type PowerQuerySinkMapping struct {
	// List of sinks mapped to Power Query mashup query.
	DataflowSinks []*PowerQuerySink

	// Name of the query in Power Query mashup document.
	QueryName *string
}

// PowerQuerySource - Power query source.
type PowerQuerySource struct {
	// REQUIRED; Transformation name.
	Name *string

	// Dataset reference.
	Dataset *DatasetReference

	// Transformation description.
	Description *string

	// Flowlet Reference
	Flowlet *DataFlowReference

	// Linked service reference.
	LinkedService *LinkedServiceReference

	// Schema linked service reference.
	SchemaLinkedService *LinkedServiceReference

	// source script.
	Script *string
}

// PowerQueryTypeProperties - Power Query data flow type properties.
type PowerQueryTypeProperties struct {
	// Locale of the Power query mashup document.
	DocumentLocale *string

	// Power query mashup script.
	Script *string

	// List of sources in Power Query.
	Sources []*PowerQuerySource
}

// PrestoDatasetTypeProperties - Presto Dataset Properties
type PrestoDatasetTypeProperties struct {
	// The schema name of the Presto. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the Presto. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// PrestoLinkedService - Presto server linked service.
type PrestoLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Presto server linked service properties.
	TypeProperties *PrestoLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type PrestoLinkedService.
func (p *PrestoLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: p.AdditionalProperties,
		Annotations:          p.Annotations,
		ConnectVia:           p.ConnectVia,
		Description:          p.Description,
		Parameters:           p.Parameters,
		Type:                 p.Type,
	}
}

// PrestoLinkedServiceTypeProperties - Presto server linked service properties.
type PrestoLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication mechanism used to connect to the Presto server.
	AuthenticationType *PrestoAuthenticationType

	// REQUIRED; The catalog context for all request against the server.
	Catalog any

	// REQUIRED; The IP address or host name of the Presto server. (i.e. 192.168.222.160)
	Host any

	// REQUIRED; The version of the Presto server. (i.e. 0.148-t)
	ServerVersion any

	// Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over
	// SSL. The default value is false.
	AllowHostNameCNMismatch any

	// Specifies whether to allow self-signed certificates from the server. The default value is false.
	AllowSelfSignedServerCert any

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false.
	EnableSSL any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The password corresponding to the user name.
	Password SecretBaseClassification

	// The TCP port that the Presto server uses to listen for client connections. The default value is 8080.
	Port any

	// The local time zone used by the connection. Valid values for this option are specified in the IANA Time Zone Database.
	// The default value is the system time zone.
	TimeZoneID any

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR.
	TrustedCertPath any

	// Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is
	// false.
	UseSystemTrustStore any

	// The user name used to connect to the Presto server.
	Username any
}

// PrestoObjectDataset - Presto server dataset.
type PrestoObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *PrestoDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type PrestoObjectDataset.
func (p *PrestoObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: p.AdditionalProperties,
		Annotations:          p.Annotations,
		Description:          p.Description,
		Folder:               p.Folder,
		LinkedServiceName:    p.LinkedServiceName,
		Parameters:           p.Parameters,
		Schema:               p.Schema,
		Structure:            p.Structure,
		Type:                 p.Type,
	}
}

// PrestoSource - A copy activity Presto server source.
type PrestoSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type PrestoSource.
func (p *PrestoSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     p.AdditionalProperties,
		DisableMetricsCollection: p.DisableMetricsCollection,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		Type:                     p.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type PrestoSource.
func (p *PrestoSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        p.AdditionalColumns,
		AdditionalProperties:     p.AdditionalProperties,
		DisableMetricsCollection: p.DisableMetricsCollection,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		QueryTimeout:             p.QueryTimeout,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		Type:                     p.Type,
	}
}

// PrivateEndpoint - Private endpoint which a connection belongs to.
type PrivateEndpoint struct {
	// The resource Id for private endpoint
	ID *string
}

// PrivateEndpointConnectionListResponse - A list of linked service resources.
type PrivateEndpointConnectionListResponse struct {
	// REQUIRED; List of Private Endpoint Connections.
	Value []*PrivateEndpointConnectionResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// PrivateEndpointConnectionResource - Private Endpoint Connection ARM resource.
type PrivateEndpointConnectionResource struct {
	// Core resource properties
	Properties *RemotePrivateEndpointConnection

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateLinkConnectionApprovalRequest - A request to approve or reject a private endpoint connection
type PrivateLinkConnectionApprovalRequest struct {
	// The resource of private endpoint.
	PrivateEndpoint *PrivateEndpoint

	// The state of a private link connection
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState
}

// PrivateLinkConnectionApprovalRequestResource - Private Endpoint Connection Approval ARM resource.
type PrivateLinkConnectionApprovalRequestResource struct {
	// Core resource properties
	Properties *PrivateLinkConnectionApprovalRequest

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateLinkConnectionState - The state of a private link connection
type PrivateLinkConnectionState struct {
	// ActionsRequired for a private link connection
	ActionsRequired *string

	// Description of a private link connection
	Description *string

	// Status of a private link connection
	Status *string
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Core resource properties
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateLinkResourceProperties - Properties of a private link resource
type PrivateLinkResourceProperties struct {
	// READ-ONLY; GroupId of a private link resource
	GroupID *string

	// READ-ONLY; RequiredMembers of a private link resource
	RequiredMembers []*string

	// READ-ONLY; RequiredZoneNames of a private link resource
	RequiredZoneNames []*string
}

// PrivateLinkResourcesWrapper - Wrapper for a collection of private link resources
type PrivateLinkResourcesWrapper struct {
	// REQUIRED
	Value []*PrivateLinkResource
}

// PurviewConfiguration - Purview configuration.
type PurviewConfiguration struct {
	// Purview resource id.
	PurviewResourceID *string
}

// QueryDataFlowDebugSessionsResponse - A list of active debug sessions.
type QueryDataFlowDebugSessionsResponse struct {
	// The link to the next page of results, if any remaining results exist.
	NextLink *string

	// Array with all active debug sessions.
	Value []*DataFlowDebugSessionInfo
}

// QuickBooksLinkedService - QuickBooks server linked service.
type QuickBooksLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; QuickBooks server linked service properties.
	TypeProperties *QuickBooksLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type QuickBooksLinkedService.
func (q *QuickBooksLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: q.AdditionalProperties,
		Annotations:          q.Annotations,
		ConnectVia:           q.ConnectVia,
		Description:          q.Description,
		Parameters:           q.Parameters,
		Type:                 q.Type,
	}
}

// QuickBooksLinkedServiceTypeProperties - QuickBooks server linked service properties.
type QuickBooksLinkedServiceTypeProperties struct {
	// The access token for OAuth 1.0 authentication.
	AccessToken SecretBaseClassification

	// The access token secret for OAuth 1.0 authentication.
	AccessTokenSecret SecretBaseClassification

	// The company ID of the QuickBooks company to authorize.
	CompanyID any

	// Properties used to connect to QuickBooks. It is mutually exclusive with any other properties in the linked service. Type:
	// object.
	ConnectionProperties any

	// The consumer key for OAuth 1.0 authentication.
	ConsumerKey any

	// The consumer secret for OAuth 1.0 authentication.
	ConsumerSecret SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The endpoint of the QuickBooks server. (i.e. quickbooks.api.intuit.com)
	Endpoint any

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints any
}

// QuickBooksObjectDataset - QuickBooks server dataset.
type QuickBooksObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type QuickBooksObjectDataset.
func (q *QuickBooksObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: q.AdditionalProperties,
		Annotations:          q.Annotations,
		Description:          q.Description,
		Folder:               q.Folder,
		LinkedServiceName:    q.LinkedServiceName,
		Parameters:           q.Parameters,
		Schema:               q.Schema,
		Structure:            q.Structure,
		Type:                 q.Type,
	}
}

// QuickBooksSource - A copy activity QuickBooks server source.
type QuickBooksSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type QuickBooksSource.
func (q *QuickBooksSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     q.AdditionalProperties,
		DisableMetricsCollection: q.DisableMetricsCollection,
		MaxConcurrentConnections: q.MaxConcurrentConnections,
		SourceRetryCount:         q.SourceRetryCount,
		SourceRetryWait:          q.SourceRetryWait,
		Type:                     q.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type QuickBooksSource.
func (q *QuickBooksSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        q.AdditionalColumns,
		AdditionalProperties:     q.AdditionalProperties,
		DisableMetricsCollection: q.DisableMetricsCollection,
		MaxConcurrentConnections: q.MaxConcurrentConnections,
		QueryTimeout:             q.QueryTimeout,
		SourceRetryCount:         q.SourceRetryCount,
		SourceRetryWait:          q.SourceRetryWait,
		Type:                     q.Type,
	}
}

// QuickbaseLinkedService - Linked service for Quickbase.
type QuickbaseLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Quickbase linked service properties.
	TypeProperties *QuickbaseLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type QuickbaseLinkedService.
func (q *QuickbaseLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: q.AdditionalProperties,
		Annotations:          q.Annotations,
		ConnectVia:           q.ConnectVia,
		Description:          q.Description,
		Parameters:           q.Parameters,
		Type:                 q.Type,
	}
}

// QuickbaseLinkedServiceTypeProperties - Quickbase linked service type properties.
type QuickbaseLinkedServiceTypeProperties struct {
	// REQUIRED; The url to connect Quickbase source. Type: string (or Expression with resultType string).
	URL any

	// REQUIRED; The user token for the Quickbase source.
	UserToken SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string
}

// RecurrenceSchedule - The recurrence schedule.
type RecurrenceSchedule struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The hours.
	Hours []*int32

	// The minutes.
	Minutes []*int32

	// The month days.
	MonthDays []*int32

	// The monthly occurrences.
	MonthlyOccurrences []*RecurrenceScheduleOccurrence

	// The days of the week.
	WeekDays []*DaysOfWeek
}

// RecurrenceScheduleOccurrence - The recurrence schedule occurrence.
type RecurrenceScheduleOccurrence struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The day of the week.
	Day *DayOfWeek

	// The occurrence.
	Occurrence *int32
}

// RedirectIncompatibleRowSettings - Redirect incompatible row settings
type RedirectIncompatibleRowSettings struct {
	// REQUIRED; Name of the Azure Storage, Storage SAS, or Azure Data Lake Store linked service used for redirecting incompatible
	// row. Must be specified if redirectIncompatibleRowSettings is specified. Type: string
	// (or Expression with resultType string).
	LinkedServiceName any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The path for storing the redirect incompatible row data. Type: string (or Expression with resultType string).
	Path any
}

// RedshiftUnloadSettings - The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with
// unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into
// the targeted sink from the interim S3.
type RedshiftUnloadSettings struct {
	// REQUIRED; The bucket of the interim Amazon S3 which will be used to store the unloaded data from Amazon Redshift source.
	// The bucket must be in the same region as the Amazon Redshift source. Type: string (or
	// Expression with resultType string).
	BucketName any

	// REQUIRED; The name of the Amazon S3 linked service which will be used for the unload operation when copying from the Amazon
	// Redshift source.
	S3LinkedServiceName *LinkedServiceReference
}

// RelationalSource - A copy activity source for various relational databases.
type RelationalSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Type: string (or Expression with resultType string).
	Query any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type RelationalSource.
func (r *RelationalSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     r.AdditionalProperties,
		DisableMetricsCollection: r.DisableMetricsCollection,
		MaxConcurrentConnections: r.MaxConcurrentConnections,
		SourceRetryCount:         r.SourceRetryCount,
		SourceRetryWait:          r.SourceRetryWait,
		Type:                     r.Type,
	}
}

// RelationalTableDataset - The relational table dataset.
type RelationalTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Relational table dataset properties.
	TypeProperties *RelationalTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type RelationalTableDataset.
func (r *RelationalTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: r.AdditionalProperties,
		Annotations:          r.Annotations,
		Description:          r.Description,
		Folder:               r.Folder,
		LinkedServiceName:    r.LinkedServiceName,
		Parameters:           r.Parameters,
		Schema:               r.Schema,
		Structure:            r.Structure,
		Type:                 r.Type,
	}
}

// RelationalTableDatasetTypeProperties - Relational table dataset properties.
type RelationalTableDatasetTypeProperties struct {
	// The relational table name. Type: string (or Expression with resultType string).
	TableName any
}

// RemotePrivateEndpointConnection - A remote private endpoint connection
type RemotePrivateEndpointConnection struct {
	// PrivateEndpoint of a remote private endpoint connection
	PrivateEndpoint *ArmIDWrapper

	// The state of a private link connection
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState

	// READ-ONLY
	ProvisioningState *string
}

// RerunTumblingWindowTrigger - Trigger that schedules pipeline reruns for all fixed time interval windows from a requested
// start time to requested end time.
type RerunTumblingWindowTrigger struct {
	// REQUIRED; Trigger type.
	Type *string

	// REQUIRED; Rerun Trigger properties.
	TypeProperties *RerunTumblingWindowTriggerTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the trigger.
	Annotations []any

	// Trigger description.
	Description *string

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState
}

// GetTrigger implements the TriggerClassification interface for type RerunTumblingWindowTrigger.
func (r *RerunTumblingWindowTrigger) GetTrigger() *Trigger {
	return &Trigger{
		AdditionalProperties: r.AdditionalProperties,
		Annotations:          r.Annotations,
		Description:          r.Description,
		RuntimeState:         r.RuntimeState,
		Type:                 r.Type,
	}
}

// RerunTumblingWindowTriggerTypeProperties - Rerun Trigger properties.
type RerunTumblingWindowTriggerTypeProperties struct {
	// REQUIRED; The parent trigger reference.
	ParentTrigger any

	// REQUIRED; The end time for the time period for which restatement is initiated. Only UTC time is currently supported.
	RequestedEndTime *time.Time

	// REQUIRED; The start time for the time period for which restatement is initiated. Only UTC time is currently supported.
	RequestedStartTime *time.Time

	// REQUIRED; The max number of parallel time windows (ready for execution) for which a rerun is triggered.
	RerunConcurrency *int32
}

// ResponsysLinkedService - Responsys linked service.
type ResponsysLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Responsys linked service properties.
	TypeProperties *ResponsysLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type ResponsysLinkedService.
func (r *ResponsysLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: r.AdditionalProperties,
		Annotations:          r.Annotations,
		ConnectVia:           r.ConnectVia,
		Description:          r.Description,
		Parameters:           r.Parameters,
		Type:                 r.Type,
	}
}

// ResponsysLinkedServiceTypeProperties - Responsys linked service properties.
type ResponsysLinkedServiceTypeProperties struct {
	// REQUIRED; The client ID associated with the Responsys application. Type: string (or Expression with resultType string).
	ClientID any

	// REQUIRED; The endpoint of the Responsys server.
	Endpoint any

	// The client secret associated with the Responsys application. Type: string (or Expression with resultType string).
	ClientSecret SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. Type: boolean (or Expression
	// with resultType boolean).
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true. Type: boolean (or Expression with
	// resultType boolean).
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. Type: boolean
	// (or Expression with resultType boolean).
	UsePeerVerification any
}

// ResponsysObjectDataset - Responsys dataset.
type ResponsysObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type ResponsysObjectDataset.
func (r *ResponsysObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: r.AdditionalProperties,
		Annotations:          r.Annotations,
		Description:          r.Description,
		Folder:               r.Folder,
		LinkedServiceName:    r.LinkedServiceName,
		Parameters:           r.Parameters,
		Schema:               r.Schema,
		Structure:            r.Structure,
		Type:                 r.Type,
	}
}

// ResponsysSource - A copy activity Responsys source.
type ResponsysSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type ResponsysSource.
func (r *ResponsysSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     r.AdditionalProperties,
		DisableMetricsCollection: r.DisableMetricsCollection,
		MaxConcurrentConnections: r.MaxConcurrentConnections,
		SourceRetryCount:         r.SourceRetryCount,
		SourceRetryWait:          r.SourceRetryWait,
		Type:                     r.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type ResponsysSource.
func (r *ResponsysSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        r.AdditionalColumns,
		AdditionalProperties:     r.AdditionalProperties,
		DisableMetricsCollection: r.DisableMetricsCollection,
		MaxConcurrentConnections: r.MaxConcurrentConnections,
		QueryTimeout:             r.QueryTimeout,
		SourceRetryCount:         r.SourceRetryCount,
		SourceRetryWait:          r.SourceRetryWait,
		Type:                     r.Type,
	}
}

// RestResourceDataset - A Rest service dataset.
type RestResourceDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *RestResourceDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type RestResourceDataset.
func (r *RestResourceDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: r.AdditionalProperties,
		Annotations:          r.Annotations,
		Description:          r.Description,
		Folder:               r.Folder,
		LinkedServiceName:    r.LinkedServiceName,
		Parameters:           r.Parameters,
		Schema:               r.Schema,
		Structure:            r.Structure,
		Type:                 r.Type,
	}
}

// RestResourceDatasetTypeProperties - Properties specific to this dataset type.
type RestResourceDatasetTypeProperties struct {
	// The additional HTTP headers in the request to the RESTful API.
	AdditionalHeaders map[string]any

	// The pagination rules to compose next page requests.
	PaginationRules map[string]any

	// The relative URL to the resource that the RESTful API provides. Type: string (or Expression with resultType string).
	RelativeURL any

	// The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
	RequestBody any

	// The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
	RequestMethod any
}

// RestServiceLinkedService - Rest Service linked service.
type RestServiceLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Rest Service linked service properties.
	TypeProperties *RestServiceLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type RestServiceLinkedService.
func (r *RestServiceLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: r.AdditionalProperties,
		Annotations:          r.Annotations,
		ConnectVia:           r.ConnectVia,
		Description:          r.Description,
		Parameters:           r.Parameters,
		Type:                 r.Type,
	}
}

// RestServiceLinkedServiceTypeProperties - Rest Service linked service properties.
type RestServiceLinkedServiceTypeProperties struct {
	// REQUIRED; Type of authentication used to connect to the REST service.
	AuthenticationType *RestServiceAuthenticationType

	// REQUIRED; The base URL of the REST service. Type: string (or Expression with resultType string).
	URL any

	// The resource you are requesting authorization to use. Type: string (or Expression with resultType string).
	AADResourceID any

	// The additional HTTP headers in the request to RESTful API used for authorization. Type: object (or Expression with resultType
	// object).
	AuthHeaders any

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType any

	// The client ID associated with your application. Type: string (or Expression with resultType string).
	ClientID any

	// The client secret associated with your application.
	ClientSecret SecretBaseClassification

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// Whether to validate server side SSL certificate when connecting to the endpoint.The default value is true. Type: boolean
	// (or Expression with resultType boolean).
	EnableServerCertificateValidation any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The password used in Basic authentication type.
	Password SecretBaseClassification

	// The target service or resource to which the access will be requested. Type: string (or Expression with resultType string).
	Resource any

	// The scope of the access required. It describes what kind of access will be requested. Type: string (or Expression with
	// resultType string).
	Scope any

	// The application's client ID used in AadServicePrincipal authentication type. Type: string (or Expression with resultType
	// string).
	ServicePrincipalID any

	// The application's key used in AadServicePrincipal authentication type.
	ServicePrincipalKey SecretBaseClassification

	// The tenant information (domain name or tenant ID) used in AadServicePrincipal authentication type under which your application
	// resides. Type: string (or Expression with resultType string).
	Tenant any

	// The token endpoint of the authorization server to acquire access token. Type: string (or Expression with resultType string).
	TokenEndpoint any

	// The user name used in Basic authentication type. Type: string (or Expression with resultType string).
	UserName any
}

// RestSink - A copy activity Rest service Sink.
type RestSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
	AdditionalHeaders any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Http Compression Type to Send data in compressed format with Optimal Compression Level, Default is None. And The Only Supported
	// option is Gzip.
	HTTPCompressionType any

	// The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data.
	// Default value: 00:01:40. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The time to await before sending next request, in milliseconds
	RequestInterval any

	// The HTTP method used to call the RESTful API. The default is POST. Type: string (or Expression with resultType string).
	RequestMethod any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type RestSink.
func (r *RestSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     r.AdditionalProperties,
		DisableMetricsCollection: r.DisableMetricsCollection,
		MaxConcurrentConnections: r.MaxConcurrentConnections,
		SinkRetryCount:           r.SinkRetryCount,
		SinkRetryWait:            r.SinkRetryWait,
		Type:                     r.Type,
		WriteBatchSize:           r.WriteBatchSize,
		WriteBatchTimeout:        r.WriteBatchTimeout,
	}
}

// RestSource - A copy activity Rest service source.
type RestSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
	AdditionalHeaders any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data.
	// Default value: 00:01:40. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The pagination rules to compose next page requests. Type: string (or Expression with resultType string).
	PaginationRules any

	// The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
	RequestBody any

	// The time to await before sending next page request.
	RequestInterval any

	// The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
	RequestMethod any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type RestSource.
func (r *RestSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     r.AdditionalProperties,
		DisableMetricsCollection: r.DisableMetricsCollection,
		MaxConcurrentConnections: r.MaxConcurrentConnections,
		SourceRetryCount:         r.SourceRetryCount,
		SourceRetryWait:          r.SourceRetryWait,
		Type:                     r.Type,
	}
}

// RetryPolicy - Execution policy for an activity.
type RetryPolicy struct {
	// Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
	Count any

	// Interval between retries in seconds. Default is 30.
	IntervalInSeconds *int32
}

// RunFilterParameters - Query parameters for listing runs.
type RunFilterParameters struct {
	// REQUIRED; The time at or after which the run event was updated in 'ISO 8601' format.
	LastUpdatedAfter *time.Time

	// REQUIRED; The time at or before which the run event was updated in 'ISO 8601' format.
	LastUpdatedBefore *time.Time

	// The continuation token for getting the next page of results. Null for first page.
	ContinuationToken *string

	// List of filters.
	Filters []*RunQueryFilter

	// List of OrderBy option.
	OrderBy []*RunQueryOrderBy
}

// RunQueryFilter - Query filter option for listing runs.
type RunQueryFilter struct {
	// REQUIRED; Parameter name to be used for filter. The allowed operands to query pipeline runs are PipelineName, RunStart,
	// RunEnd and Status; to query activity runs are ActivityName, ActivityRunStart,
	// ActivityRunEnd, ActivityType and Status, and to query trigger runs are TriggerName, TriggerRunTimestamp and Status.
	Operand *RunQueryFilterOperand

	// REQUIRED; Operator to be used for filter.
	Operator *RunQueryFilterOperator

	// REQUIRED; List of filter values.
	Values []*string
}

// RunQueryOrderBy - An object to provide order by options for listing runs.
type RunQueryOrderBy struct {
	// REQUIRED; Sorting order of the parameter.
	Order *RunQueryOrder

	// REQUIRED; Parameter name to be used for order by. The allowed parameters to order by for pipeline runs are PipelineName,
	// RunStart, RunEnd and Status; for activity runs are ActivityName, ActivityRunStart,
	// ActivityRunEnd and Status; for trigger runs are TriggerName, TriggerRunTimestamp and Status.
	OrderBy *RunQueryOrderByField
}

// SQLAlwaysEncryptedProperties - Sql always encrypted properties.
type SQLAlwaysEncryptedProperties struct {
	// REQUIRED; Sql always encrypted AKV authentication type. Type: string.
	AlwaysEncryptedAkvAuthType *SQLAlwaysEncryptedAkvAuthType

	// The credential reference containing authentication information.
	Credential *CredentialReference

	// The client ID of the application in Azure Active Directory used for Azure Key Vault authentication. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID any

	// The key of the service principal used to authenticate against Azure Key Vault.
	ServicePrincipalKey SecretBaseClassification
}

// SQLDWSink - A copy activity SQL Data Warehouse sink.
type SQLDWSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates to use Copy Command to copy data into SQL Data Warehouse. Type: boolean (or Expression with resultType boolean).
	AllowCopyCommand any

	// Indicates to use PolyBase to copy data into SQL Data Warehouse when applicable. Type: boolean (or Expression with resultType
	// boolean).
	AllowPolyBase any

	// Specifies Copy Command related settings when allowCopyCommand is true.
	CopyCommandSettings *DWCopyCommandSettings

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Specifies PolyBase-related settings when allowPolyBase is true.
	PolyBaseSettings *PolybaseSettings

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript any

	// Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
	SQLWriterUseTableLock any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression
	// with resultType string).
	TableOption any

	// SQL DW upsert settings.
	UpsertSettings *SQLDWUpsertSettings

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// Write behavior when copying data into azure SQL DW. Type: SqlDWWriteBehaviorEnum (or Expression with resultType SqlDWWriteBehaviorEnum)
	WriteBehavior any
}

// GetCopySink implements the CopySinkClassification interface for type SQLDWSink.
func (s *SQLDWSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SinkRetryCount:           s.SinkRetryCount,
		SinkRetryWait:            s.SinkRetryWait,
		Type:                     s.Type,
		WriteBatchSize:           s.WriteBatchSize,
		WriteBatchTimeout:        s.WriteBatchTimeout,
	}
}

// SQLDWSource - A copy activity SQL Data Warehouse source.
type SQLDWSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot.
	// The default value is ReadCommitted. Type: string (or
	// Expression with resultType string).
	IsolationLevel any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "DynamicRange".
	PartitionOption any

	// The settings that will be leveraged for Sql source partitioning.
	PartitionSettings *SQLPartitionSettings

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// SQL Data Warehouse reader query. Type: string (or Expression with resultType string).
	SQLReaderQuery any

	// Name of the stored procedure for a SQL Data Warehouse source. This cannot be used at the same time as SqlReaderQuery. Type:
	// string (or Expression with resultType string).
	SQLReaderStoredProcedureName any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}". Type: object
	// (or Expression with resultType object), itemType: StoredProcedureParameter.
	StoredProcedureParameters any
}

// GetCopySource implements the CopySourceClassification interface for type SQLDWSource.
func (s *SQLDWSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SQLDWSource.
func (s *SQLDWSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SQLDWUpsertSettings - Sql DW upsert option settings
type SQLDWUpsertSettings struct {
	// Schema name for interim table. Type: string (or Expression with resultType string).
	InterimSchemaName any

	// Key column names for unique row identification. Type: array of strings (or Expression with resultType array of strings).
	Keys any
}

// SQLMISink - A copy activity Azure SQL Managed Instance sink.
type SQLMISink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript any

	// SQL writer stored procedure name. Type: string (or Expression with resultType string).
	SQLWriterStoredProcedureName any

	// SQL writer table type. Type: string (or Expression with resultType string).
	SQLWriterTableType any

	// Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
	SQLWriterUseTableLock any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// SQL stored procedure parameters.
	StoredProcedureParameters any

	// The stored procedure parameter name of the table type. Type: string (or Expression with resultType string).
	StoredProcedureTableTypeParameterName any

	// The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression
	// with resultType string).
	TableOption any

	// SQL upsert settings.
	UpsertSettings *SQLUpsertSettings

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// White behavior when copying data into azure SQL MI. Type: SqlWriteBehaviorEnum (or Expression with resultType SqlWriteBehaviorEnum)
	WriteBehavior any
}

// GetCopySink implements the CopySinkClassification interface for type SQLMISink.
func (s *SQLMISink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SinkRetryCount:           s.SinkRetryCount,
		SinkRetryWait:            s.SinkRetryWait,
		Type:                     s.Type,
		WriteBatchSize:           s.WriteBatchSize,
		WriteBatchTimeout:        s.WriteBatchTimeout,
	}
}

// SQLMISource - A copy activity Azure SQL Managed Instance source.
type SQLMISource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot.
	// The default value is ReadCommitted. Type: string (or
	// Expression with resultType string).
	IsolationLevel any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "DynamicRange".
	PartitionOption any

	// The settings that will be leveraged for Sql source partitioning.
	PartitionSettings *SQLPartitionSettings

	// Which additional types to produce.
	ProduceAdditionalTypes any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// SQL reader query. Type: string (or Expression with resultType string).
	SQLReaderQuery any

	// Name of the stored procedure for a Azure SQL Managed Instance source. This cannot be used at the same time as SqlReaderQuery.
	// Type: string (or Expression with resultType string).
	SQLReaderStoredProcedureName any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
	StoredProcedureParameters any
}

// GetCopySource implements the CopySourceClassification interface for type SQLMISource.
func (s *SQLMISource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SQLMISource.
func (s *SQLMISource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SQLPartitionSettings - The settings that will be leveraged for Sql source partitioning.
type SQLPartitionSettings struct {
	// The name of the column in integer or datetime type that will be used for proceeding partitioning. If not specified, the
	// primary key of the table is auto-detected and used as the partition column.
	// Type: string (or Expression with resultType string).
	PartitionColumnName any

	// The minimum value of the partition column for partition range splitting. This value is used to decide the partition stride,
	// not for filtering the rows in table. All rows in the table or query result
	// will be partitioned and copied. Type: string (or Expression with resultType string).
	PartitionLowerBound any

	// The maximum value of the partition column for partition range splitting. This value is used to decide the partition stride,
	// not for filtering the rows in table. All rows in the table or query result
	// will be partitioned and copied. Type: string (or Expression with resultType string).
	PartitionUpperBound any
}

// SQLServerLinkedService - SQL Server linked service.
type SQLServerLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; SQL Server linked service properties.
	TypeProperties *SQLServerLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SQLServerLinkedService.
func (s *SQLServerLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SQLServerLinkedServiceTypeProperties - SQL Server linked service properties.
type SQLServerLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// Sql always encrypted properties.
	AlwaysEncryptedSettings *SQLAlwaysEncryptedProperties

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The on-premises Windows authentication password.
	Password SecretBaseClassification

	// The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
	UserName any
}

// SQLServerSink - A copy activity SQL server sink.
type SQLServerSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript any

	// SQL writer stored procedure name. Type: string (or Expression with resultType string).
	SQLWriterStoredProcedureName any

	// SQL writer table type. Type: string (or Expression with resultType string).
	SQLWriterTableType any

	// Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
	SQLWriterUseTableLock any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// SQL stored procedure parameters.
	StoredProcedureParameters any

	// The stored procedure parameter name of the table type. Type: string (or Expression with resultType string).
	StoredProcedureTableTypeParameterName any

	// The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression
	// with resultType string).
	TableOption any

	// SQL upsert settings.
	UpsertSettings *SQLUpsertSettings

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// Write behavior when copying data into sql server. Type: SqlWriteBehaviorEnum (or Expression with resultType SqlWriteBehaviorEnum)
	WriteBehavior any
}

// GetCopySink implements the CopySinkClassification interface for type SQLServerSink.
func (s *SQLServerSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SinkRetryCount:           s.SinkRetryCount,
		SinkRetryWait:            s.SinkRetryWait,
		Type:                     s.Type,
		WriteBatchSize:           s.WriteBatchSize,
		WriteBatchTimeout:        s.WriteBatchTimeout,
	}
}

// SQLServerSource - A copy activity SQL server source.
type SQLServerSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot.
	// The default value is ReadCommitted. Type: string (or
	// Expression with resultType string).
	IsolationLevel any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "DynamicRange".
	PartitionOption any

	// The settings that will be leveraged for Sql source partitioning.
	PartitionSettings *SQLPartitionSettings

	// Which additional types to produce.
	ProduceAdditionalTypes any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// SQL reader query. Type: string (or Expression with resultType string).
	SQLReaderQuery any

	// Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string
	// (or Expression with resultType string).
	SQLReaderStoredProcedureName any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
	StoredProcedureParameters any
}

// GetCopySource implements the CopySourceClassification interface for type SQLServerSource.
func (s *SQLServerSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SQLServerSource.
func (s *SQLServerSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SQLServerStoredProcedureActivity - SQL stored procedure activity type.
type SQLServerStoredProcedureActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; SQL stored procedure activity properties.
	TypeProperties *SQLServerStoredProcedureActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type SQLServerStoredProcedureActivity.
func (s *SQLServerStoredProcedureActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: s.AdditionalProperties,
		DependsOn:            s.DependsOn,
		Description:          s.Description,
		Name:                 s.Name,
		OnInactiveMarkAs:     s.OnInactiveMarkAs,
		State:                s.State,
		Type:                 s.Type,
		UserProperties:       s.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type SQLServerStoredProcedureActivity.
func (s *SQLServerStoredProcedureActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: s.AdditionalProperties,
		DependsOn:            s.DependsOn,
		Description:          s.Description,
		LinkedServiceName:    s.LinkedServiceName,
		Name:                 s.Name,
		OnInactiveMarkAs:     s.OnInactiveMarkAs,
		Policy:               s.Policy,
		State:                s.State,
		Type:                 s.Type,
		UserProperties:       s.UserProperties,
	}
}

// SQLServerStoredProcedureActivityTypeProperties - SQL stored procedure activity properties.
type SQLServerStoredProcedureActivityTypeProperties struct {
	// REQUIRED; Stored procedure name. Type: string (or Expression with resultType string).
	StoredProcedureName any

	// Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
	StoredProcedureParameters any
}

// SQLServerTableDataset - The on-premises SQL Server dataset.
type SQLServerTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// On-premises SQL Server dataset properties.
	TypeProperties *SQLServerTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type SQLServerTableDataset.
func (s *SQLServerTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SQLServerTableDatasetTypeProperties - On-premises SQL Server dataset properties.
type SQLServerTableDatasetTypeProperties struct {
	// The schema name of the SQL Server dataset. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the SQL Server dataset. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// SQLSink - A copy activity SQL sink.
type SQLSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript any

	// SQL writer stored procedure name. Type: string (or Expression with resultType string).
	SQLWriterStoredProcedureName any

	// SQL writer table type. Type: string (or Expression with resultType string).
	SQLWriterTableType any

	// Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
	SQLWriterUseTableLock any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// SQL stored procedure parameters.
	StoredProcedureParameters any

	// The stored procedure parameter name of the table type. Type: string (or Expression with resultType string).
	StoredProcedureTableTypeParameterName any

	// The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression
	// with resultType string).
	TableOption any

	// SQL upsert settings.
	UpsertSettings *SQLUpsertSettings

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// Write behavior when copying data into sql. Type: SqlWriteBehaviorEnum (or Expression with resultType SqlWriteBehaviorEnum)
	WriteBehavior any
}

// GetCopySink implements the CopySinkClassification interface for type SQLSink.
func (s *SQLSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SinkRetryCount:           s.SinkRetryCount,
		SinkRetryWait:            s.SinkRetryWait,
		Type:                     s.Type,
		WriteBatchSize:           s.WriteBatchSize,
		WriteBatchTimeout:        s.WriteBatchTimeout,
	}
}

// SQLSource - A copy activity SQL source.
type SQLSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot.
	// The default value is ReadCommitted. Type: string (or
	// Expression with resultType string).
	IsolationLevel any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "DynamicRange".
	PartitionOption any

	// The settings that will be leveraged for Sql source partitioning.
	PartitionSettings *SQLPartitionSettings

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// SQL reader query. Type: string (or Expression with resultType string).
	SQLReaderQuery any

	// Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string
	// (or Expression with resultType string).
	SQLReaderStoredProcedureName any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
	StoredProcedureParameters any
}

// GetCopySource implements the CopySourceClassification interface for type SQLSource.
func (s *SQLSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SQLSource.
func (s *SQLSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SQLUpsertSettings - Sql upsert option settings
type SQLUpsertSettings struct {
	// Schema name for interim table. Type: string (or Expression with resultType string).
	InterimSchemaName any

	// Key column names for unique row identification. Type: array of strings (or Expression with resultType array of strings).
	Keys any

	// Specifies whether to use temp db for upsert interim table. Type: boolean (or Expression with resultType boolean).
	UseTempDB any
}

// SSISAccessCredential - SSIS access credential.
type SSISAccessCredential struct {
	// REQUIRED; Domain for windows authentication. Type: string (or Expression with resultType string).
	Domain any

	// REQUIRED; Password for windows authentication.
	Password SecretBaseClassification

	// REQUIRED; UseName for windows authentication. Type: string (or Expression with resultType string).
	UserName any
}

// SSISChildPackage - SSIS embedded child package.
type SSISChildPackage struct {
	// REQUIRED; Content for embedded child package. Type: string (or Expression with resultType string).
	PackageContent any

	// REQUIRED; Path for embedded child package. Type: string (or Expression with resultType string).
	PackagePath any

	// Last modified date for embedded child package.
	PackageLastModifiedDate *string

	// Name for embedded child package.
	PackageName *string
}

// SSISExecutionCredential - SSIS package execution credential.
type SSISExecutionCredential struct {
	// REQUIRED; Domain for windows authentication. Type: string (or Expression with resultType string).
	Domain any

	// REQUIRED; Password for windows authentication.
	Password *SecureString

	// REQUIRED; UseName for windows authentication. Type: string (or Expression with resultType string).
	UserName any
}

// SSISExecutionParameter - SSIS execution parameter.
type SSISExecutionParameter struct {
	// REQUIRED; SSIS package execution parameter value. Type: string (or Expression with resultType string).
	Value any
}

// SSISLogLocation - SSIS package execution log location
type SSISLogLocation struct {
	// REQUIRED; The SSIS package execution log path. Type: string (or Expression with resultType string).
	LogPath any

	// REQUIRED; The type of SSIS log location.
	Type *SsisLogLocationType

	// REQUIRED; SSIS package execution log location properties.
	TypeProperties *SSISLogLocationTypeProperties
}

// SSISLogLocationTypeProperties - SSIS package execution log location properties.
type SSISLogLocationTypeProperties struct {
	// The package execution log access credential.
	AccessCredential *SSISAccessCredential

	// Specifies the interval to refresh log. The default interval is 5 minutes. Type: string (or Expression with resultType string),
	// pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	LogRefreshInterval any
}

// SSISPackageLocation - SSIS package location.
type SSISPackageLocation struct {
	// The SSIS package path. Type: string (or Expression with resultType string).
	PackagePath any

	// The type of SSIS package location.
	Type *SsisPackageLocationType

	// SSIS package location properties.
	TypeProperties *SSISPackageLocationTypeProperties
}

// SSISPackageLocationTypeProperties - SSIS package location properties.
type SSISPackageLocationTypeProperties struct {
	// The package access credential.
	AccessCredential *SSISAccessCredential

	// The embedded child package list.
	ChildPackages []*SSISChildPackage

	// The configuration file access credential.
	ConfigurationAccessCredential *SSISAccessCredential

	// The configuration file of the package execution. Type: string (or Expression with resultType string).
	ConfigurationPath any

	// The embedded package content. Type: string (or Expression with resultType string).
	PackageContent any

	// The embedded package last modified date.
	PackageLastModifiedDate *string

	// The package name.
	PackageName *string

	// Password of the package.
	PackagePassword SecretBaseClassification
}

// SSISPropertyOverride - SSIS property override.
type SSISPropertyOverride struct {
	// REQUIRED; SSIS package property override value. Type: string (or Expression with resultType string).
	Value any

	// Whether SSIS package property override value is sensitive data. Value will be encrypted in SSISDB if it is true
	IsSensitive *bool
}

// SalesforceLinkedService - Linked service for Salesforce.
type SalesforceLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Salesforce linked service properties.
	TypeProperties *SalesforceLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SalesforceLinkedService.
func (s *SalesforceLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SalesforceLinkedServiceTypeProperties - Salesforce linked service properties.
type SalesforceLinkedServiceTypeProperties struct {
	// The Salesforce API version used in ADF. Type: string (or Expression with resultType string).
	APIVersion any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The URL of Salesforce instance. Default is 'https://login.salesforce.com'. To copy data from sandbox, specify 'https://test.salesforce.com'.
	// To copy data from custom domain, specify, for example,
	// 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
	EnvironmentURL any

	// The password for Basic authentication of the Salesforce instance.
	Password SecretBaseClassification

	// The security token is optional to remotely access Salesforce instance.
	SecurityToken SecretBaseClassification

	// The username for Basic authentication of the Salesforce instance. Type: string (or Expression with resultType string).
	Username any
}

// SalesforceMarketingCloudLinkedService - Salesforce Marketing Cloud linked service.
type SalesforceMarketingCloudLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Salesforce Marketing Cloud linked service properties.
	TypeProperties *SalesforceMarketingCloudLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SalesforceMarketingCloudLinkedService.
func (s *SalesforceMarketingCloudLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SalesforceMarketingCloudLinkedServiceTypeProperties - Salesforce Marketing Cloud linked service properties.
type SalesforceMarketingCloudLinkedServiceTypeProperties struct {
	// The client ID associated with the Salesforce Marketing Cloud application. Type: string (or Expression with resultType string).
	ClientID any

	// The client secret associated with the Salesforce Marketing Cloud application. Type: string (or Expression with resultType
	// string).
	ClientSecret SecretBaseClassification

	// Properties used to connect to Salesforce Marketing Cloud. It is mutually exclusive with any other properties in the linked
	// service. Type: object.
	ConnectionProperties any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. Type: boolean (or Expression
	// with resultType boolean).
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true. Type: boolean (or Expression with
	// resultType boolean).
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. Type: boolean
	// (or Expression with resultType boolean).
	UsePeerVerification any
}

// SalesforceMarketingCloudObjectDataset - Salesforce Marketing Cloud dataset.
type SalesforceMarketingCloudObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type SalesforceMarketingCloudObjectDataset.
func (s *SalesforceMarketingCloudObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SalesforceMarketingCloudSource - A copy activity Salesforce Marketing Cloud source.
type SalesforceMarketingCloudSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type SalesforceMarketingCloudSource.
func (s *SalesforceMarketingCloudSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SalesforceMarketingCloudSource.
func (s *SalesforceMarketingCloudSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SalesforceObjectDataset - The Salesforce object dataset.
type SalesforceObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Salesforce object dataset properties.
	TypeProperties *SalesforceObjectDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type SalesforceObjectDataset.
func (s *SalesforceObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SalesforceObjectDatasetTypeProperties - Salesforce object dataset properties.
type SalesforceObjectDatasetTypeProperties struct {
	// The Salesforce object API name. Type: string (or Expression with resultType string).
	ObjectAPIName any
}

// SalesforceServiceCloudLinkedService - Linked service for Salesforce Service Cloud.
type SalesforceServiceCloudLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Salesforce Service Cloud linked service properties.
	TypeProperties *SalesforceServiceCloudLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SalesforceServiceCloudLinkedService.
func (s *SalesforceServiceCloudLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SalesforceServiceCloudLinkedServiceTypeProperties - Salesforce Service Cloud linked service properties.
type SalesforceServiceCloudLinkedServiceTypeProperties struct {
	// The Salesforce API version used in ADF. Type: string (or Expression with resultType string).
	APIVersion any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The URL of Salesforce Service Cloud instance. Default is 'https://login.salesforce.com'. To copy data from sandbox, specify
	// 'https://test.salesforce.com'. To copy data from custom domain, specify, for
	// example, 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
	EnvironmentURL any

	// Extended properties appended to the connection string. Type: string (or Expression with resultType string).
	ExtendedProperties any

	// The password for Basic authentication of the Salesforce instance.
	Password SecretBaseClassification

	// The security token is optional to remotely access Salesforce instance.
	SecurityToken SecretBaseClassification

	// The username for Basic authentication of the Salesforce instance. Type: string (or Expression with resultType string).
	Username any
}

// SalesforceServiceCloudObjectDataset - The Salesforce Service Cloud object dataset.
type SalesforceServiceCloudObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Salesforce Service Cloud object dataset properties.
	TypeProperties *SalesforceServiceCloudObjectDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type SalesforceServiceCloudObjectDataset.
func (s *SalesforceServiceCloudObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SalesforceServiceCloudObjectDatasetTypeProperties - Salesforce Service Cloud object dataset properties.
type SalesforceServiceCloudObjectDatasetTypeProperties struct {
	// The Salesforce Service Cloud object API name. Type: string (or Expression with resultType string).
	ObjectAPIName any
}

// SalesforceServiceCloudSink - A copy activity Salesforce Service Cloud sink.
type SalesforceServiceCloudSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with
	// resultType string).
	ExternalIDFieldName any

	// The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation.
	// Default value is false. If set it to true, it means ADF will leave the data in
	// the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert
	// operation, versus ADF will update the data in the destination object to NULL when
	// doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType
	// boolean).
	IgnoreNullValues any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// The write behavior for the operation. Default is Insert.
	WriteBehavior *SalesforceSinkWriteBehavior
}

// GetCopySink implements the CopySinkClassification interface for type SalesforceServiceCloudSink.
func (s *SalesforceServiceCloudSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SinkRetryCount:           s.SinkRetryCount,
		SinkRetryWait:            s.SinkRetryWait,
		Type:                     s.Type,
		WriteBatchSize:           s.WriteBatchSize,
		WriteBatchTimeout:        s.WriteBatchTimeout,
	}
}

// SalesforceServiceCloudSource - A copy activity Salesforce Service Cloud source.
type SalesforceServiceCloudSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Type: string (or Expression with resultType string).
	Query any

	// The read behavior for the operation. Default is Query. Allowed values: Query/QueryAll. Type: string (or Expression with
	// resultType string).
	ReadBehavior any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type SalesforceServiceCloudSource.
func (s *SalesforceServiceCloudSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SalesforceSink - A copy activity Salesforce sink.
type SalesforceSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with
	// resultType string).
	ExternalIDFieldName any

	// The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation.
	// Default value is false. If set it to true, it means ADF will leave the data in
	// the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert
	// operation, versus ADF will update the data in the destination object to NULL when
	// doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType
	// boolean).
	IgnoreNullValues any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// The write behavior for the operation. Default is Insert.
	WriteBehavior *SalesforceSinkWriteBehavior
}

// GetCopySink implements the CopySinkClassification interface for type SalesforceSink.
func (s *SalesforceSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SinkRetryCount:           s.SinkRetryCount,
		SinkRetryWait:            s.SinkRetryWait,
		Type:                     s.Type,
		WriteBatchSize:           s.WriteBatchSize,
		WriteBatchTimeout:        s.WriteBatchTimeout,
	}
}

// SalesforceSource - A copy activity Salesforce source.
type SalesforceSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Database query. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// The read behavior for the operation. Default is Query. Allowed values: Query/QueryAll. Type: string (or Expression with
	// resultType string).
	ReadBehavior any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type SalesforceSource.
func (s *SalesforceSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SalesforceSource.
func (s *SalesforceSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SapBWLinkedService - SAP Business Warehouse Linked Service.
type SapBWLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Properties specific to this linked service type.
	TypeProperties *SapBWLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SapBWLinkedService.
func (s *SapBWLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SapBWLinkedServiceTypeProperties - Properties specific to this linked service type.
type SapBWLinkedServiceTypeProperties struct {
	// REQUIRED; Client ID of the client on the BW system. (Usually a three-digit decimal number represented as a string) Type:
	// string (or Expression with resultType string).
	ClientID any

	// REQUIRED; Host name of the SAP BW instance. Type: string (or Expression with resultType string).
	Server any

	// REQUIRED; System number of the BW system. (Usually a two-digit decimal number represented as a string.) Type: string (or
	// Expression with resultType string).
	SystemNumber any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Password to access the SAP BW server.
	Password SecretBaseClassification

	// Username to access the SAP BW server. Type: string (or Expression with resultType string).
	UserName any
}

// SapBwCubeDataset - The SAP BW cube dataset.
type SapBwCubeDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type SapBwCubeDataset.
func (s *SapBwCubeDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SapBwSource - A copy activity source for SapBW server via MDX.
type SapBwSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// MDX query. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type SapBwSource.
func (s *SapBwSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SapBwSource.
func (s *SapBwSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SapCloudForCustomerLinkedService - Linked service for SAP Cloud for Customer.
type SapCloudForCustomerLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; SAP Cloud for Customer linked service properties.
	TypeProperties *SapCloudForCustomerLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SapCloudForCustomerLinkedService.
func (s *SapCloudForCustomerLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SapCloudForCustomerLinkedServiceTypeProperties - SAP Cloud for Customer linked service properties.
type SapCloudForCustomerLinkedServiceTypeProperties struct {
	// REQUIRED; The URL of SAP Cloud for Customer OData API. For example, '[https://[tenantname].crm.ondemand.com/sap/c4c/odata/v1]'.
	// Type: string (or Expression with resultType string).
	URL any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Either encryptedCredential or username/password must be provided. Type:
	// string.
	EncryptedCredential *string

	// The password for Basic authentication.
	Password SecretBaseClassification

	// The username for Basic authentication. Type: string (or Expression with resultType string).
	Username any
}

// SapCloudForCustomerResourceDataset - The path of the SAP Cloud for Customer OData entity.
type SapCloudForCustomerResourceDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; SAP Cloud For Customer OData resource dataset properties.
	TypeProperties *SapCloudForCustomerResourceDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type SapCloudForCustomerResourceDataset.
func (s *SapCloudForCustomerResourceDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SapCloudForCustomerResourceDatasetTypeProperties - Sap Cloud For Customer OData resource dataset properties.
type SapCloudForCustomerResourceDatasetTypeProperties struct {
	// REQUIRED; The path of the SAP Cloud for Customer OData entity. Type: string (or Expression with resultType string).
	Path any
}

// SapCloudForCustomerSink - A copy activity SAP Cloud for Customer sink.
type SapCloudForCustomerSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data.
	// Default value: 00:05:00. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout any

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any

	// The write behavior for the operation. Default is 'Insert'.
	WriteBehavior *SapCloudForCustomerSinkWriteBehavior
}

// GetCopySink implements the CopySinkClassification interface for type SapCloudForCustomerSink.
func (s *SapCloudForCustomerSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SinkRetryCount:           s.SinkRetryCount,
		SinkRetryWait:            s.SinkRetryWait,
		Type:                     s.Type,
		WriteBatchSize:           s.WriteBatchSize,
		WriteBatchTimeout:        s.WriteBatchTimeout,
	}
}

// SapCloudForCustomerSource - A copy activity source for SAP Cloud for Customer source.
type SapCloudForCustomerSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data.
	// Default value: 00:05:00. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// SAP Cloud for Customer OData query. For example, "$top=1". Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type SapCloudForCustomerSource.
func (s *SapCloudForCustomerSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SapCloudForCustomerSource.
func (s *SapCloudForCustomerSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SapEccLinkedService - Linked service for SAP ERP Central Component(SAP ECC).
type SapEccLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; SAP ECC linked service properties.
	TypeProperties *SapEccLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SapEccLinkedService.
func (s *SapEccLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SapEccLinkedServiceTypeProperties - SAP ECC linked service properties.
type SapEccLinkedServiceTypeProperties struct {
	// REQUIRED; The URL of SAP ECC OData API. For example, '[https://hostname:port/sap/opu/odata/sap/servicename/]'. Type: string
	// (or Expression with resultType string).
	URL any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Either encryptedCredential or username/password must be provided. Type:
	// string.
	EncryptedCredential *string

	// The password for Basic authentication.
	Password SecretBaseClassification

	// The username for Basic authentication. Type: string (or Expression with resultType string).
	Username any
}

// SapEccResourceDataset - The path of the SAP ECC OData entity.
type SapEccResourceDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; SAP ECC OData resource dataset properties.
	TypeProperties *SapEccResourceDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type SapEccResourceDataset.
func (s *SapEccResourceDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SapEccResourceDatasetTypeProperties - Sap ECC OData resource dataset properties.
type SapEccResourceDatasetTypeProperties struct {
	// REQUIRED; The path of the SAP ECC OData entity. Type: string (or Expression with resultType string).
	Path any
}

// SapEccSource - A copy activity source for SAP ECC source.
type SapEccSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data.
	// Default value: 00:05:00. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// SAP ECC OData query. For example, "$top=1". Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type SapEccSource.
func (s *SapEccSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SapEccSource.
func (s *SapEccSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SapHanaLinkedService - SAP HANA Linked Service.
type SapHanaLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Properties specific to this linked service type.
	TypeProperties *SapHanaLinkedServiceProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SapHanaLinkedService.
func (s *SapHanaLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SapHanaLinkedServiceProperties - Properties specific to this linked service type.
type SapHanaLinkedServiceProperties struct {
	// The authentication type to be used to connect to the SAP HANA server.
	AuthenticationType *SapHanaAuthenticationType

	// SAP HANA ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Password to access the SAP HANA server.
	Password SecretBaseClassification

	// Host name of the SAP HANA server. Type: string (or Expression with resultType string).
	Server any

	// Username to access the SAP HANA server. Type: string (or Expression with resultType string).
	UserName any
}

// SapHanaPartitionSettings - The settings that will be leveraged for SAP HANA source partitioning.
type SapHanaPartitionSettings struct {
	// The name of the column that will be used for proceeding range partitioning. Type: string (or Expression with resultType
	// string).
	PartitionColumnName any
}

// SapHanaSource - A copy activity source for SAP HANA source.
type SapHanaSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The packet size of data read from SAP HANA. Type: integer(or Expression with resultType integer).
	PacketSize any

	// The partition mechanism that will be used for SAP HANA read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "SapHanaDynamicRange".
	PartitionOption any

	// The settings that will be leveraged for SAP HANA source partitioning.
	PartitionSettings *SapHanaPartitionSettings

	// SAP HANA Sql query. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type SapHanaSource.
func (s *SapHanaSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SapHanaSource.
func (s *SapHanaSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SapHanaTableDataset - SAP HANA Table properties.
type SapHanaTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// SAP HANA Table properties.
	TypeProperties *SapHanaTableDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type SapHanaTableDataset.
func (s *SapHanaTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SapHanaTableDatasetTypeProperties - SAP HANA Table properties.
type SapHanaTableDatasetTypeProperties struct {
	// The schema name of SAP HANA. Type: string (or Expression with resultType string).
	Schema any

	// The table name of SAP HANA. Type: string (or Expression with resultType string).
	Table any
}

// SapOdpLinkedService - SAP ODP Linked Service.
type SapOdpLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Properties specific to SAP ODP linked service type.
	TypeProperties *SapOdpLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SapOdpLinkedService.
func (s *SapOdpLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SapOdpLinkedServiceTypeProperties - Properties specific to this linked service type.
type SapOdpLinkedServiceTypeProperties struct {
	// Client ID of the client on the SAP system where the table is located. (Usually a three-digit decimal number represented
	// as a string) Type: string (or Expression with resultType string).
	ClientID any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Language of the SAP system where the table is located. The default value is EN. Type: string (or Expression with resultType
	// string).
	Language any

	// The Logon Group for the SAP System. Type: string (or Expression with resultType string).
	LogonGroup any

	// The hostname of the SAP Message Server. Type: string (or Expression with resultType string).
	MessageServer any

	// The service name or port number of the Message Server. Type: string (or Expression with resultType string).
	MessageServerService any

	// Password to access the SAP server where the table is located.
	Password SecretBaseClassification

	// Host name of the SAP instance where the table is located. Type: string (or Expression with resultType string).
	Server any

	// External security product's library to access the SAP server where the table is located. Type: string (or Expression with
	// resultType string).
	SncLibraryPath any

	// SNC activation indicator to access the SAP server where the table is located. Must be either 0 (off) or 1 (on). Type: string
	// (or Expression with resultType string).
	SncMode any

	// Initiator's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string).
	SncMyName any

	// Communication partner's SNC name to access the SAP server where the table is located. Type: string (or Expression with
	// resultType string).
	SncPartnerName any

	// SNC Quality of Protection. Allowed value include: 1, 2, 3, 8, 9. Type: string (or Expression with resultType string).
	SncQop any

	// The subscriber name. Type: string (or Expression with resultType string).
	SubscriberName any

	// SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string).
	SystemID any

	// System number of the SAP system where the table is located. (Usually a two-digit decimal number represented as a string.)
	// Type: string (or Expression with resultType string).
	SystemNumber any

	// Username to access the SAP server where the table is located. Type: string (or Expression with resultType string).
	UserName any

	// SNC X509 certificate file path. Type: string (or Expression with resultType string).
	X509CertificatePath any
}

// SapOdpResourceDataset - SAP ODP Resource properties.
type SapOdpResourceDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; SAP ODP Resource properties.
	TypeProperties *SapOdpResourceDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type SapOdpResourceDataset.
func (s *SapOdpResourceDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SapOdpResourceDatasetTypeProperties - SAP ODP Resource properties.
type SapOdpResourceDatasetTypeProperties struct {
	// REQUIRED; The context of the SAP ODP Object. Type: string (or Expression with resultType string).
	Context any

	// REQUIRED; The name of the SAP ODP Object. Type: string (or Expression with resultType string).
	ObjectName any
}

// SapOdpSource - A copy activity source for SAP ODP source.
type SapOdpSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The extraction mode. Allowed value include: Full, Delta and Recovery. The default value is Full. Type: string (or Expression
	// with resultType string).
	ExtractionMode any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Specifies the columns to be selected from source data. Type: array of objects(projection) (or Expression with resultType
	// array of objects).
	Projection any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Specifies the selection conditions from source data. Type: array of objects(selection) (or Expression with resultType array
	// of objects).
	Selection any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any

	// The subscriber process to manage the delta process. Type: string (or Expression with resultType string).
	SubscriberProcess any
}

// GetCopySource implements the CopySourceClassification interface for type SapOdpSource.
func (s *SapOdpSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SapOdpSource.
func (s *SapOdpSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SapOpenHubLinkedService - SAP Business Warehouse Open Hub Destination Linked Service.
type SapOpenHubLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Properties specific to SAP Business Warehouse Open Hub Destination linked service type.
	TypeProperties *SapOpenHubLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SapOpenHubLinkedService.
func (s *SapOpenHubLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SapOpenHubLinkedServiceTypeProperties - Properties specific to SAP Business Warehouse Open Hub Destination linked service
// type.
type SapOpenHubLinkedServiceTypeProperties struct {
	// Client ID of the client on the BW system where the open hub destination is located. (Usually a three-digit decimal number
	// represented as a string) Type: string (or Expression with resultType string).
	ClientID any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Language of the BW system where the open hub destination is located. The default value is EN. Type: string (or Expression
	// with resultType string).
	Language any

	// The Logon Group for the SAP System. Type: string (or Expression with resultType string).
	LogonGroup any

	// The hostname of the SAP Message Server. Type: string (or Expression with resultType string).
	MessageServer any

	// The service name or port number of the Message Server. Type: string (or Expression with resultType string).
	MessageServerService any

	// Password to access the SAP BW server where the open hub destination is located.
	Password SecretBaseClassification

	// Host name of the SAP BW instance where the open hub destination is located. Type: string (or Expression with resultType
	// string).
	Server any

	// SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string).
	SystemID any

	// System number of the BW system where the open hub destination is located. (Usually a two-digit decimal number represented
	// as a string.) Type: string (or Expression with resultType string).
	SystemNumber any

	// Username to access the SAP BW server where the open hub destination is located. Type: string (or Expression with resultType
	// string).
	UserName any
}

// SapOpenHubSource - A copy activity source for SAP Business Warehouse Open Hub Destination source.
type SapOpenHubSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The ID of request for delta loading. Once it is set, only data with requestId larger than the value of this property will
	// be retrieved. The default value is 0. Type: integer (or Expression with
	// resultType integer ).
	BaseRequestID any

	// Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with
	// resultType string).
	CustomRFCReadTableFunctionModule any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Whether to exclude the records of the last request. The default value is true. Type: boolean (or Expression with resultType
	// boolean).
	ExcludeLastRequest any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type:
	// string (or Expression with resultType string).
	SapDataColumnDelimiter any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type SapOpenHubSource.
func (s *SapOpenHubSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SapOpenHubSource.
func (s *SapOpenHubSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SapOpenHubTableDataset - Sap Business Warehouse Open Hub Destination Table properties.
type SapOpenHubTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; Sap Business Warehouse Open Hub Destination Table properties.
	TypeProperties *SapOpenHubTableDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type SapOpenHubTableDataset.
func (s *SapOpenHubTableDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SapOpenHubTableDatasetTypeProperties - Sap Business Warehouse Open Hub Destination Table properties.
type SapOpenHubTableDatasetTypeProperties struct {
	// REQUIRED; The name of the Open Hub Destination with destination type as Database Table. Type: string (or Expression with
	// resultType string).
	OpenHubDestinationName any

	// The ID of request for delta loading. Once it is set, only data with requestId larger than the value of this property will
	// be retrieved. The default value is 0. Type: integer (or Expression with
	// resultType integer ).
	BaseRequestID any

	// Whether to exclude the records of the last request. The default value is true. Type: boolean (or Expression with resultType
	// boolean).
	ExcludeLastRequest any
}

// SapTableLinkedService - SAP Table Linked Service.
type SapTableLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Properties specific to this linked service type.
	TypeProperties *SapTableLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SapTableLinkedService.
func (s *SapTableLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SapTableLinkedServiceTypeProperties - Properties specific to this linked service type.
type SapTableLinkedServiceTypeProperties struct {
	// Client ID of the client on the SAP system where the table is located. (Usually a three-digit decimal number represented
	// as a string) Type: string (or Expression with resultType string).
	ClientID any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Language of the SAP system where the table is located. The default value is EN. Type: string (or Expression with resultType
	// string).
	Language any

	// The Logon Group for the SAP System. Type: string (or Expression with resultType string).
	LogonGroup any

	// The hostname of the SAP Message Server. Type: string (or Expression with resultType string).
	MessageServer any

	// The service name or port number of the Message Server. Type: string (or Expression with resultType string).
	MessageServerService any

	// Password to access the SAP server where the table is located.
	Password SecretBaseClassification

	// Host name of the SAP instance where the table is located. Type: string (or Expression with resultType string).
	Server any

	// External security product's library to access the SAP server where the table is located. Type: string (or Expression with
	// resultType string).
	SncLibraryPath any

	// SNC activation indicator to access the SAP server where the table is located. Must be either 0 (off) or 1 (on). Type: string
	// (or Expression with resultType string).
	SncMode any

	// Initiator's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string).
	SncMyName any

	// Communication partner's SNC name to access the SAP server where the table is located. Type: string (or Expression with
	// resultType string).
	SncPartnerName any

	// SNC Quality of Protection. Allowed value include: 1, 2, 3, 8, 9. Type: string (or Expression with resultType string).
	SncQop any

	// SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string).
	SystemID any

	// System number of the SAP system where the table is located. (Usually a two-digit decimal number represented as a string.)
	// Type: string (or Expression with resultType string).
	SystemNumber any

	// Username to access the SAP server where the table is located. Type: string (or Expression with resultType string).
	UserName any
}

// SapTablePartitionSettings - The settings that will be leveraged for SAP table source partitioning.
type SapTablePartitionSettings struct {
	// The maximum value of partitions the table will be split into. Type: integer (or Expression with resultType string).
	MaxPartitionsNumber any

	// The name of the column that will be used for proceeding range partitioning. Type: string (or Expression with resultType
	// string).
	PartitionColumnName any

	// The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionLowerBound any

	// The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionUpperBound any
}

// SapTableResourceDataset - SAP Table Resource properties.
type SapTableResourceDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; SAP Table Resource properties.
	TypeProperties *SapTableResourceDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type SapTableResourceDataset.
func (s *SapTableResourceDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SapTableResourceDatasetTypeProperties - SAP Table Resource properties.
type SapTableResourceDatasetTypeProperties struct {
	// REQUIRED; The name of the SAP Table. Type: string (or Expression with resultType string).
	TableName any
}

// SapTableSource - A copy activity source for SAP Table source.
type SapTableSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specifies the maximum number of rows that will be retrieved at a time when retrieving data from SAP Table. Type: integer
	// (or Expression with resultType integer).
	BatchSize any

	// Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with
	// resultType string).
	CustomRFCReadTableFunctionModule any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The partition mechanism that will be used for SAP table read in parallel. Possible values include: "None", "PartitionOnInt",
	// "PartitionOnCalendarYear", "PartitionOnCalendarMonth",
	// "PartitionOnCalendarDate", "PartitionOnTime".
	PartitionOption any

	// The settings that will be leveraged for SAP table source partitioning.
	PartitionSettings *SapTablePartitionSettings

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// The fields of the SAP table that will be retrieved. For example, column0, column1. Type: string (or Expression with resultType
	// string).
	RFCTableFields any

	// The options for the filtering of the SAP Table. For example, COLUMN0 EQ SOME VALUE. Type: string (or Expression with resultType
	// string).
	RFCTableOptions any

	// The number of rows to be retrieved. Type: integer(or Expression with resultType integer).
	RowCount any

	// The number of rows that will be skipped. Type: integer (or Expression with resultType integer).
	RowSkips any

	// The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type:
	// string (or Expression with resultType string).
	SapDataColumnDelimiter any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type SapTableSource.
func (s *SapTableSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SapTableSource.
func (s *SapTableSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// ScheduleTrigger - Trigger that creates pipeline runs periodically, on schedule.
type ScheduleTrigger struct {
	// REQUIRED; Trigger type.
	Type *string

	// REQUIRED; Schedule Trigger properties.
	TypeProperties *ScheduleTriggerTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the trigger.
	Annotations []any

	// Trigger description.
	Description *string

	// Pipelines that need to be started.
	Pipelines []*TriggerPipelineReference

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState
}

// GetMultiplePipelineTrigger implements the MultiplePipelineTriggerClassification interface for type ScheduleTrigger.
func (s *ScheduleTrigger) GetMultiplePipelineTrigger() *MultiplePipelineTrigger {
	return &MultiplePipelineTrigger{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Pipelines:            s.Pipelines,
		RuntimeState:         s.RuntimeState,
		Type:                 s.Type,
	}
}

// GetTrigger implements the TriggerClassification interface for type ScheduleTrigger.
func (s *ScheduleTrigger) GetTrigger() *Trigger {
	return &Trigger{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		RuntimeState:         s.RuntimeState,
		Type:                 s.Type,
	}
}

// ScheduleTriggerRecurrence - The workflow trigger recurrence.
type ScheduleTriggerRecurrence struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The end time.
	EndTime *time.Time

	// The frequency.
	Frequency *RecurrenceFrequency

	// The interval.
	Interval *int32

	// The recurrence schedule.
	Schedule *RecurrenceSchedule

	// The start time.
	StartTime *time.Time

	// The time zone.
	TimeZone *string
}

// ScheduleTriggerTypeProperties - Schedule Trigger properties.
type ScheduleTriggerTypeProperties struct {
	// REQUIRED; Recurrence schedule configuration.
	Recurrence *ScheduleTriggerRecurrence
}

// ScriptAction - Custom script action to run on HDI ondemand cluster once it's up.
type ScriptAction struct {
	// REQUIRED; The user provided name of the script action.
	Name *string

	// REQUIRED; The node types on which the script action should be executed.
	Roles any

	// REQUIRED; The URI for the script action.
	URI *string

	// The parameters for the script action.
	Parameters *string
}

// ScriptActivity - Script activity type.
type ScriptActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Script activity properties.
	TypeProperties *ScriptActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *ActivityPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type ScriptActivity.
func (s *ScriptActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: s.AdditionalProperties,
		DependsOn:            s.DependsOn,
		Description:          s.Description,
		Name:                 s.Name,
		OnInactiveMarkAs:     s.OnInactiveMarkAs,
		State:                s.State,
		Type:                 s.Type,
		UserProperties:       s.UserProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type ScriptActivity.
func (s *ScriptActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		AdditionalProperties: s.AdditionalProperties,
		DependsOn:            s.DependsOn,
		Description:          s.Description,
		LinkedServiceName:    s.LinkedServiceName,
		Name:                 s.Name,
		OnInactiveMarkAs:     s.OnInactiveMarkAs,
		Policy:               s.Policy,
		State:                s.State,
		Type:                 s.Type,
		UserProperties:       s.UserProperties,
	}
}

// ScriptActivityParameter - Parameters of a script block.
type ScriptActivityParameter struct {
	// The direction of the parameter.
	Direction *ScriptActivityParameterDirection

	// The name of the parameter. Type: string (or Expression with resultType string).
	Name any

	// The size of the output direction parameter.
	Size *int32

	// The type of the parameter.
	Type *ScriptActivityParameterType

	// The value of the parameter. Type: string (or Expression with resultType string).
	Value any
}

// ScriptActivityScriptBlock - Script block of scripts.
type ScriptActivityScriptBlock struct {
	// REQUIRED; The query text. Type: string (or Expression with resultType string).
	Text any

	// REQUIRED; The type of the query. Type: string.
	Type *ScriptType

	// Array of script parameters. Type: array.
	Parameters []*ScriptActivityParameter
}

// ScriptActivityTypeProperties - Script activity properties.
type ScriptActivityTypeProperties struct {
	// Log settings of script activity.
	LogSettings *ScriptActivityTypePropertiesLogSettings

	// ScriptBlock execution timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	ScriptBlockExecutionTimeout any

	// Array of script blocks. Type: array.
	Scripts []*ScriptActivityScriptBlock
}

// ScriptActivityTypePropertiesLogSettings - Log settings of script activity.
type ScriptActivityTypePropertiesLogSettings struct {
	// REQUIRED; The destination of logs. Type: string.
	LogDestination *ScriptActivityLogDestination

	// Log location settings customer needs to provide when enabling log.
	LogLocationSettings *LogLocationSettings
}

// SecretBase - The base definition of a secret type.
type SecretBase struct {
	// REQUIRED; Type of the secret.
	Type *string
}

// GetSecretBase implements the SecretBaseClassification interface for type SecretBase.
func (s *SecretBase) GetSecretBase() *SecretBase { return s }

// SecureInputOutputPolicy - Execution policy for an activity that supports secure input and output.
type SecureInputOutputPolicy struct {
	// When set to true, Input from activity is considered as secure and will not be logged to monitoring.
	SecureInput *bool

	// When set to true, Output from activity is considered as secure and will not be logged to monitoring.
	SecureOutput *bool
}

// SecureString - Azure Data Factory secure string definition. The string value will be masked with asterisks '*' during Get
// or List API calls.
type SecureString struct {
	// REQUIRED; Type of the secret.
	Type *string

	// REQUIRED; Value of secure string.
	Value *string
}

// GetSecretBase implements the SecretBaseClassification interface for type SecureString.
func (s *SecureString) GetSecretBase() *SecretBase {
	return &SecretBase{
		Type: s.Type,
	}
}

// SelfDependencyTumblingWindowTriggerReference - Self referenced tumbling window trigger dependency.
type SelfDependencyTumblingWindowTriggerReference struct {
	// REQUIRED; Timespan applied to the start time of a tumbling window when evaluating dependency.
	Offset *string

	// REQUIRED; The type of dependency reference.
	Type *string

	// The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used.
	Size *string
}

// GetDependencyReference implements the DependencyReferenceClassification interface for type SelfDependencyTumblingWindowTriggerReference.
func (s *SelfDependencyTumblingWindowTriggerReference) GetDependencyReference() *DependencyReference {
	return &DependencyReference{
		Type: s.Type,
	}
}

// SelfHostedIntegrationRuntime - Self-hosted integration runtime.
type SelfHostedIntegrationRuntime struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Integration runtime description.
	Description *string

	// When this property is not null, means this is a linked integration runtime. The property is used to access original integration
	// runtime.
	TypeProperties *SelfHostedIntegrationRuntimeTypeProperties
}

// GetIntegrationRuntime implements the IntegrationRuntimeClassification interface for type SelfHostedIntegrationRuntime.
func (s *SelfHostedIntegrationRuntime) GetIntegrationRuntime() *IntegrationRuntime {
	return &IntegrationRuntime{
		AdditionalProperties: s.AdditionalProperties,
		Description:          s.Description,
		Type:                 s.Type,
	}
}

// SelfHostedIntegrationRuntimeNode - Properties of Self-hosted integration runtime node.
type SelfHostedIntegrationRuntimeNode struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The integration runtime capabilities dictionary
	Capabilities map[string]*string

	// READ-ONLY; Maximum concurrent jobs on the integration runtime node.
	ConcurrentJobsLimit *int32

	// READ-ONLY; The time at which the integration runtime will expire in ISO8601 format.
	ExpiryTime *time.Time

	// READ-ONLY; URI for the host machine of the integration runtime.
	HostServiceURI *string

	// READ-ONLY; Indicates whether this node is the active dispatcher for integration runtime requests.
	IsActiveDispatcher *bool

	// READ-ONLY; The most recent time at which the integration runtime was connected in ISO8601 format.
	LastConnectTime *time.Time

	// READ-ONLY; The last time for the integration runtime node update end.
	LastEndUpdateTime *time.Time

	// READ-ONLY; The time the node last started up.
	LastStartTime *time.Time

	// READ-ONLY; The last time for the integration runtime node update start.
	LastStartUpdateTime *time.Time

	// READ-ONLY; The integration runtime node last stop time.
	LastStopTime *time.Time

	// READ-ONLY; The result of the last integration runtime node update.
	LastUpdateResult *IntegrationRuntimeUpdateResult

	// READ-ONLY; Machine name of the integration runtime node.
	MachineName *string

	// READ-ONLY; The maximum concurrent jobs in this integration runtime.
	MaxConcurrentJobs *int32

	// READ-ONLY; Name of the integration runtime node.
	NodeName *string

	// READ-ONLY; The time at which the integration runtime node was registered in ISO8601 format.
	RegisterTime *time.Time

	// READ-ONLY; Status of the integration runtime node.
	Status *SelfHostedIntegrationRuntimeNodeStatus

	// READ-ONLY; Version of the integration runtime node.
	Version *string

	// READ-ONLY; Status of the integration runtime node version.
	VersionStatus *string
}

// SelfHostedIntegrationRuntimeStatus - Self-hosted integration runtime status.
type SelfHostedIntegrationRuntimeStatus struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType

	// REQUIRED; Self-hosted integration runtime status type properties.
	TypeProperties *SelfHostedIntegrationRuntimeStatusTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The data factory name which the integration runtime belong to.
	DataFactoryName *string

	// READ-ONLY; The state of integration runtime.
	State *IntegrationRuntimeState
}

// GetIntegrationRuntimeStatus implements the IntegrationRuntimeStatusClassification interface for type SelfHostedIntegrationRuntimeStatus.
func (s *SelfHostedIntegrationRuntimeStatus) GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus {
	return &IntegrationRuntimeStatus{
		AdditionalProperties: s.AdditionalProperties,
		DataFactoryName:      s.DataFactoryName,
		State:                s.State,
		Type:                 s.Type,
	}
}

// SelfHostedIntegrationRuntimeStatusTypeProperties - Self-hosted integration runtime status type properties.
type SelfHostedIntegrationRuntimeStatusTypeProperties struct {
	// The list of linked integration runtimes that are created to share with this integration runtime.
	Links []*LinkedIntegrationRuntime

	// The list of nodes for this integration runtime.
	Nodes []*SelfHostedIntegrationRuntimeNode

	// READ-ONLY; Whether Self-hosted integration runtime auto update has been turned on.
	AutoUpdate *IntegrationRuntimeAutoUpdate

	// READ-ONLY; The estimated time when the self-hosted integration runtime will be updated.
	AutoUpdateETA *time.Time

	// READ-ONLY; Object with additional information about integration runtime capabilities.
	Capabilities map[string]*string

	// READ-ONLY; The time at which the integration runtime was created, in ISO8601 format.
	CreateTime *time.Time

	// READ-ONLY; It is used to set the encryption mode for node-node communication channel (when more than 2 self-hosted integration
	// runtime nodes exist).
	InternalChannelEncryption *IntegrationRuntimeInternalChannelEncryptionMode

	// READ-ONLY; The latest version on download center.
	LatestVersion *string

	// READ-ONLY; The local time zone offset in hours.
	LocalTimeZoneOffset *string

	// READ-ONLY; The version that the integration runtime is going to update to.
	PushedVersion *string

	// READ-ONLY; The date at which the integration runtime will be scheduled to update, in ISO8601 format.
	ScheduledUpdateDate *time.Time

	// READ-ONLY; An alternative option to ensure interactive authoring function when your self-hosted integration runtime is
	// unable to establish a connection with Azure Relay.
	SelfContainedInteractiveAuthoringEnabled *bool

	// READ-ONLY; The URLs for the services used in integration runtime backend service.
	ServiceUrls []*string

	// READ-ONLY; The task queue id of the integration runtime.
	TaskQueueID *string

	// READ-ONLY; The time in the date scheduled by service to update the integration runtime, e.g., PT03H is 3 hours
	UpdateDelayOffset *string

	// READ-ONLY; Version of the integration runtime.
	Version *string

	// READ-ONLY; Status of the integration runtime version.
	VersionStatus *string
}

// SelfHostedIntegrationRuntimeTypeProperties - The self-hosted integration runtime properties.
type SelfHostedIntegrationRuntimeTypeProperties struct {
	// The base definition of a linked integration runtime.
	LinkedInfo LinkedIntegrationRuntimeTypeClassification

	// An alternative option to ensure interactive authoring function when your self-hosted integration runtime is unable to establish
	// a connection with Azure Relay.
	SelfContainedInteractiveAuthoringEnabled *bool
}

// ServiceNowLinkedService - ServiceNow server linked service.
type ServiceNowLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; ServiceNow server linked service properties.
	TypeProperties *ServiceNowLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type ServiceNowLinkedService.
func (s *ServiceNowLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// ServiceNowLinkedServiceTypeProperties - ServiceNow server linked service properties.
type ServiceNowLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication type to use.
	AuthenticationType *ServiceNowAuthenticationType

	// REQUIRED; The endpoint of the ServiceNow server. (i.e. .service-now.com)
	Endpoint any

	// The client id for OAuth2 authentication.
	ClientID any

	// The client secret for OAuth2 authentication.
	ClientSecret SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The password corresponding to the user name for Basic and OAuth2 authentication.
	Password SecretBaseClassification

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification any

	// The user name used to connect to the ServiceNow server for Basic and OAuth2 authentication.
	Username any
}

// ServiceNowObjectDataset - ServiceNow server dataset.
type ServiceNowObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type ServiceNowObjectDataset.
func (s *ServiceNowObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// ServiceNowSource - A copy activity ServiceNow server source.
type ServiceNowSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type ServiceNowSource.
func (s *ServiceNowSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type ServiceNowSource.
func (s *ServiceNowSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// ServicePrincipalCredential - Service principal credential.
type ServicePrincipalCredential struct {
	// REQUIRED; Type of credential.
	Type *string

	// REQUIRED; Service Principal credential properties.
	TypeProperties *ServicePrincipalCredentialTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Credential.
	Annotations []any

	// Credential description.
	Description *string
}

// GetCredential implements the CredentialClassification interface for type ServicePrincipalCredential.
func (s *ServicePrincipalCredential) GetCredential() *Credential {
	return &Credential{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Type:                 s.Type,
	}
}

// ServicePrincipalCredentialTypeProperties - Service Principal credential type properties.
type ServicePrincipalCredentialTypeProperties struct {
	// The app ID of the service principal used to authenticate
	ServicePrincipalID any

	// The key of the service principal used to authenticate.
	ServicePrincipalKey *AzureKeyVaultSecretReference

	// The ID of the tenant to which the service principal belongs
	Tenant any
}

// SetVariableActivity - Set value for a Variable.
type SetVariableActivity struct {
	// REQUIRED; Activity name.
	Name *string

	// REQUIRED; Type of activity.
	Type *string

	// REQUIRED; Set Variable activity properties.
	TypeProperties *SetVariableActivityTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Activity depends on condition.
	DependsOn []*ActivityDependency

	// Activity description.
	Description *string

	// Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when
	// the activity is inactive, the status will be Succeeded by default.
	OnInactiveMarkAs *ActivityOnInactiveMarkAs

	// Activity policy.
	Policy *SecureInputOutputPolicy

	// Activity state. This is an optional property and if not provided, the state will be Active by default.
	State *ActivityState

	// Activity user properties.
	UserProperties []*UserProperty
}

// GetActivity implements the ActivityClassification interface for type SetVariableActivity.
func (s *SetVariableActivity) GetActivity() *Activity {
	return &Activity{
		AdditionalProperties: s.AdditionalProperties,
		DependsOn:            s.DependsOn,
		Description:          s.Description,
		Name:                 s.Name,
		OnInactiveMarkAs:     s.OnInactiveMarkAs,
		State:                s.State,
		Type:                 s.Type,
		UserProperties:       s.UserProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type SetVariableActivity.
func (s *SetVariableActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		AdditionalProperties: s.AdditionalProperties,
		DependsOn:            s.DependsOn,
		Description:          s.Description,
		Name:                 s.Name,
		OnInactiveMarkAs:     s.OnInactiveMarkAs,
		State:                s.State,
		Type:                 s.Type,
		UserProperties:       s.UserProperties,
	}
}

// SetVariableActivityTypeProperties - SetVariable activity properties.
type SetVariableActivityTypeProperties struct {
	// If set to true, it sets the pipeline run return value.
	SetSystemVariable *bool

	// Value to be set. Could be a static value or Expression.
	Value any

	// Name of the variable whose value needs to be set.
	VariableName *string
}

// SftpLocation - The location of SFTP dataset.
type SftpLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName any

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath any
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type SftpLocation.
func (s *SftpLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		AdditionalProperties: s.AdditionalProperties,
		FileName:             s.FileName,
		FolderPath:           s.FolderPath,
		Type:                 s.Type,
	}
}

// SftpReadSettings - Sftp read settings.
type SftpReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion any

	// If true, disable parallel reading within each file. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableChunking any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
	EnablePartitionDiscovery any

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd any

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart any

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath any

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive any

	// Sftp wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName any

	// Sftp wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath any
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type SftpReadSettings.
func (s *SftpReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		Type:                     s.Type,
	}
}

// SftpServerLinkedService - A linked service for an SSH File Transfer Protocol (SFTP) server.
type SftpServerLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Properties specific to this linked service type.
	TypeProperties *SftpServerLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SftpServerLinkedService.
func (s *SftpServerLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SftpServerLinkedServiceTypeProperties - Properties specific to this linked service type.
type SftpServerLinkedServiceTypeProperties struct {
	// REQUIRED; The SFTP server host name. Type: string (or Expression with resultType string).
	Host any

	// The authentication type to be used to connect to the FTP server.
	AuthenticationType *SftpAuthenticationType

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The host key finger-print of the SFTP server. When SkipHostKeyValidation is false, HostKeyFingerprint should be specified.
	// Type: string (or Expression with resultType string).
	HostKeyFingerprint any

	// The password to decrypt the SSH private key if the SSH private key is encrypted.
	PassPhrase SecretBaseClassification

	// Password to logon the SFTP server for Basic authentication.
	Password SecretBaseClassification

	// The TCP port number that the SFTP server uses to listen for client connections. Default value is 22. Type: integer (or
	// Expression with resultType integer), minimum: 0.
	Port any

	// Base64 encoded SSH private key content for SshPublicKey authentication. For on-premises copy with SshPublicKey authentication,
	// either PrivateKeyPath or PrivateKeyContent should be specified. SSH
	// private key should be OpenSSH format.
	PrivateKeyContent SecretBaseClassification

	// The SSH private key file path for SshPublicKey authentication. Only valid for on-premises copy. For on-premises copy with
	// SshPublicKey authentication, either PrivateKeyPath or PrivateKeyContent should
	// be specified. SSH private key should be OpenSSH format. Type: string (or Expression with resultType string).
	PrivateKeyPath any

	// If true, skip the SSH host key validation. Default value is false. Type: boolean (or Expression with resultType boolean).
	SkipHostKeyValidation any

	// The username used to log on to the SFTP server. Type: string (or Expression with resultType string).
	UserName any
}

// SftpWriteSettings - Sftp write settings.
type SftpWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The type of copy behavior for copy sink.
	CopyBehavior any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Specifies the timeout for writing each chunk to SFTP server. Default value: 01:00:00 (one hour). Type: string (or Expression
	// with resultType string).
	OperationTimeout any

	// Upload to temporary file(s) and rename. Disable this option if your SFTP server doesn't support rename operation. Type:
	// boolean (or Expression with resultType boolean).
	UseTempFileRename any
}

// GetStoreWriteSettings implements the StoreWriteSettingsClassification interface for type SftpWriteSettings.
func (s *SftpWriteSettings) GetStoreWriteSettings() *StoreWriteSettings {
	return &StoreWriteSettings{
		AdditionalProperties:     s.AdditionalProperties,
		CopyBehavior:             s.CopyBehavior,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		Type:                     s.Type,
	}
}

// SharePointOnlineListDatasetTypeProperties - Sharepoint online list dataset properties.
type SharePointOnlineListDatasetTypeProperties struct {
	// The name of the SharePoint Online list. Type: string (or Expression with resultType string).
	ListName any
}

// SharePointOnlineListLinkedService - SharePoint Online List linked service.
type SharePointOnlineListLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; SharePoint Online List linked service properties.
	TypeProperties *SharePointOnlineListLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SharePointOnlineListLinkedService.
func (s *SharePointOnlineListLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SharePointOnlineListLinkedServiceTypeProperties - SharePoint Online List linked service properties.
type SharePointOnlineListLinkedServiceTypeProperties struct {
	// REQUIRED; The application (client) ID of your application registered in Azure Active Directory. Make sure to grant SharePoint
	// site permission to this application. Type: string (or Expression with resultType
	// string).
	ServicePrincipalID any

	// REQUIRED; The client secret of your application registered in Azure Active Directory. Type: string (or Expression with
	// resultType string).
	ServicePrincipalKey SecretBaseClassification

	// REQUIRED; The URL of the SharePoint Online site. For example, https://contoso.sharepoint.com/sites/siteName. Type: string
	// (or Expression with resultType string).
	SiteURL any

	// REQUIRED; The tenant ID under which your application resides. You can find it from Azure portal Active Directory overview
	// page. Type: string (or Expression with resultType string).
	TenantID any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string
}

// SharePointOnlineListResourceDataset - The sharepoint online list resource dataset.
type SharePointOnlineListResourceDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Sharepoint online list dataset properties.
	TypeProperties *SharePointOnlineListDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type SharePointOnlineListResourceDataset.
func (s *SharePointOnlineListResourceDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SharePointOnlineListSource - A copy activity source for sharePoint online list source.
type SharePointOnlineListSource struct {
	// REQUIRED; Copy source type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The wait time to get a response from SharePoint Online. Default value is 5 minutes (00:05:00). Type: string (or Expression
	// with resultType string), pattern:
	// ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// The OData query to filter the data in SharePoint Online list. For example, "$top=1". Type: string (or Expression with resultType
	// string).
	Query any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type SharePointOnlineListSource.
func (s *SharePointOnlineListSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// ShopifyLinkedService - Shopify Service linked service.
type ShopifyLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Shopify Service linked service properties.
	TypeProperties *ShopifyLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type ShopifyLinkedService.
func (s *ShopifyLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// ShopifyLinkedServiceTypeProperties - Shopify Service linked service properties.
type ShopifyLinkedServiceTypeProperties struct {
	// REQUIRED; The endpoint of the Shopify server. (i.e. mystore.myshopify.com)
	Host any

	// The API access token that can be used to access Shopify’s data. The token won't expire if it is offline mode.
	AccessToken SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints any

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification any

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification any
}

// ShopifyObjectDataset - Shopify Service dataset.
type ShopifyObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties
}

// GetDataset implements the DatasetClassification interface for type ShopifyObjectDataset.
func (s *ShopifyObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// ShopifySource - A copy activity Shopify Service source.
type ShopifySource struct {
	// REQUIRED; Copy source type.
	Type *string

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query any

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type ShopifySource.
func (s *ShopifySource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type ShopifySource.
func (s *ShopifySource) GetTabularSource() *TabularSource {
	return &TabularSource{
		AdditionalColumns:        s.AdditionalColumns,
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		QueryTimeout:             s.QueryTimeout,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SkipErrorFile - Skip error file.
type SkipErrorFile struct {
	// Skip if source/sink file changed by other concurrent write. Default is false. Type: boolean (or Expression with resultType
	// boolean).
	DataInconsistency any

	// Skip if file is deleted by other client during copy. Default is true. Type: boolean (or Expression with resultType boolean).
	FileMissing any
}

// SmartsheetLinkedService - Linked service for Smartsheet.
type SmartsheetLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Smartsheet linked service properties.
	TypeProperties *SmartsheetLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SmartsheetLinkedService.
func (s *SmartsheetLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SmartsheetLinkedServiceTypeProperties - Smartsheet linked service type properties.
type SmartsheetLinkedServiceTypeProperties struct {
	// REQUIRED; The api token for the Smartsheet source.
	APIToken SecretBaseClassification

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string
}

// SnowflakeDataset - The snowflake dataset.
type SnowflakeDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference

	// REQUIRED; Type of dataset.
	Type *string

	// REQUIRED; Snowflake dataset properties.
	TypeProperties *SnowflakeDatasetTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the Dataset.
	Annotations []any

	// Dataset description.
	Description *string

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema any

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure any
}

// GetDataset implements the DatasetClassification interface for type SnowflakeDataset.
func (s *SnowflakeDataset) GetDataset() *Dataset {
	return &Dataset{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		Description:          s.Description,
		Folder:               s.Folder,
		LinkedServiceName:    s.LinkedServiceName,
		Parameters:           s.Parameters,
		Schema:               s.Schema,
		Structure:            s.Structure,
		Type:                 s.Type,
	}
}

// SnowflakeDatasetTypeProperties - Snowflake dataset properties.
type SnowflakeDatasetTypeProperties struct {
	// The schema name of the Snowflake database. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the Snowflake database. Type: string (or Expression with resultType string).
	Table any
}

// SnowflakeExportCopyCommand - Snowflake export command settings.
type SnowflakeExportCopyCommand struct {
	// REQUIRED; The export setting type.
	Type *string

	// Additional copy options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type)
	// (or Expression with resultType object). Example: "additionalCopyOptions": { "DATE
	// FORMAT": "MM/DD/YYYY", "TIMEFORMAT": "'HH24:MI:SS.FF'" }
	AdditionalCopyOptions map[string]any

	// Additional format options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type)
	// (or Expression with resultType object). Example: "additionalFormatOptions": {
	// "OVERWRITE": "TRUE", "MAXFILESIZE": "'FALSE'" }
	AdditionalFormatOptions map[string]any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
}

// GetExportSettings implements the ExportSettingsClassification interface for type SnowflakeExportCopyCommand.
func (s *SnowflakeExportCopyCommand) GetExportSettings() *ExportSettings {
	return &ExportSettings{
		AdditionalProperties: s.AdditionalProperties,
		Type:                 s.Type,
	}
}

// SnowflakeImportCopyCommand - Snowflake import command settings.
type SnowflakeImportCopyCommand struct {
	// REQUIRED; The import setting type.
	Type *string

	// Additional copy options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type)
	// (or Expression with resultType object). Example: "additionalCopyOptions": { "DATE
	// FORMAT": "MM/DD/YYYY", "TIMEFORMAT": "'HH24:MI:SS.FF'" }
	AdditionalCopyOptions map[string]any

	// Additional format options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type)
	// (or Expression with resultType object). Example: "additionalFormatOptions": {
	// "FORCE": "TRUE", "LOADUNCERTAINFILES": "'FALSE'" }
	AdditionalFormatOptions map[string]any

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
}

// GetImportSettings implements the ImportSettingsClassification interface for type SnowflakeImportCopyCommand.
func (s *SnowflakeImportCopyCommand) GetImportSettings() *ImportSettings {
	return &ImportSettings{
		AdditionalProperties: s.AdditionalProperties,
		Type:                 s.Type,
	}
}

// SnowflakeLinkedService - Snowflake linked service.
type SnowflakeLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Snowflake linked service properties.
	TypeProperties *SnowflakeLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SnowflakeLinkedService.
func (s *SnowflakeLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SnowflakeLinkedServiceTypeProperties - Snowflake linked service properties.
type SnowflakeLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string of snowflake. Type: string, SecureString.
	ConnectionString any

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string.
	EncryptedCredential *string

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference
}

// SnowflakeSink - A copy activity snowflake sink.
type SnowflakeSink struct {
	// REQUIRED; Copy sink type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// Snowflake import settings.
	ImportSettings *SnowflakeImportCopyCommand

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript any

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount any

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait any

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize any

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout any
}

// GetCopySink implements the CopySinkClassification interface for type SnowflakeSink.
func (s *SnowflakeSink) GetCopySink() *CopySink {
	return &CopySink{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SinkRetryCount:           s.SinkRetryCount,
		SinkRetryWait:            s.SinkRetryWait,
		Type:                     s.Type,
		WriteBatchSize:           s.WriteBatchSize,
		WriteBatchTimeout:        s.WriteBatchTimeout,
	}
}

// SnowflakeSource - A copy activity snowflake source.
type SnowflakeSource struct {
	// REQUIRED; Snowflake export settings.
	ExportSettings *SnowflakeExportCopyCommand

	// REQUIRED; Copy source type.
	Type *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection any

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections any

	// Snowflake Sql query. Type: string (or Expression with resultType string).
	Query any

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount any

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait any
}

// GetCopySource implements the CopySourceClassification interface for type SnowflakeSource.
func (s *SnowflakeSource) GetCopySource() *CopySource {
	return &CopySource{
		AdditionalProperties:     s.AdditionalProperties,
		DisableMetricsCollection: s.DisableMetricsCollection,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		Type:                     s.Type,
	}
}

// SparkConfigurationParametrizationReference - Spark configuration reference.
type SparkConfigurationParametrizationReference struct {
	// REQUIRED; Reference spark configuration name. Type: string (or Expression with resultType string).
	ReferenceName any

	// REQUIRED; Spark configuration reference type.
	Type *SparkConfigurationReferenceType
}

// SparkDatasetTypeProperties - Spark Properties
type SparkDatasetTypeProperties struct {
	// The schema name of the Spark. Type: string (or Expression with resultType string).
	Schema any

	// The table name of the Spark. Type: string (or Expression with resultType string).
	Table any

	// This property will be retired. Please consider using schema + table properties instead.
	TableName any
}

// SparkLinkedService - Spark Server linked service.
type SparkLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string

	// REQUIRED; Spark Server linked service properties.
	TypeProperties *SparkLinkedServiceTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// List of tags that can be used for describing the linked service.
	Annotations []any

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference

	// Linked service description.
	Description *string

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification
}

// GetLinkedService implements the LinkedServiceClassification interface for type SparkLinkedService.
func (s *SparkLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		AdditionalProperties: s.AdditionalProperties,
		Annotations:          s.Annotations,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Type:                 s.Type,
	}
}

// SparkLinkedServiceTypeProperties - Spark Server linked service properties.
type SparkLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication method used to access the Spark server.
	AuthenticationType *SparkAuthenticationType

	// REQUIRED; IP address or host name of the Spark server
	Host any

	// REQUIRED; The TCP port that the Spark server uses to listen for client connections.
	Port any

	// Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over
	// SSL. The default value is false.
	AllowHostNameCNMismatch any

	// Specifies whether to allow self-signed certificates from the server. The default value is false.
	AllowSelfSignedServerCert any

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false.
	EnableSSL any

	// The encrypted c