//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmariadb_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mariadb/armmariadb"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/mariadb/resource-manager/Microsoft.DBforMariaDB/stable/2018-06-01/examples/RecommendedActionSessionResult.json
func ExampleLocationBasedRecommendedActionSessionsResultClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmariadb.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewLocationBasedRecommendedActionSessionsResultClient().NewListPager("WestUS", "aaaabbbb-cccc-dddd-0000-111122223333", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RecommendationActionsResultList = armmariadb.RecommendationActionsResultList{
		// 	Value: []*armmariadb.RecommendationAction{
		// 		{
		// 			Name: to.Ptr("Index-1"),
		// 			Type: to.Ptr("Microsoft.DBforMariaDB/servers/advisors/recommendedActions"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testResourceGroupName/providers/Microsoft.Sql/servers/testServerName/advisors/Index/recommendedActions/Index-1"),
		// 			Properties: &armmariadb.RecommendationActionProperties{
		// 				ActionID: to.Ptr[int32](1),
		// 				AdvisorName: to.Ptr("Index"),
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-01T23:43:24.000Z"); return t}()),
		// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-08T23:43:24.000Z"); return t}()),
		// 				Reason: to.Ptr("Column `movies_genres`.`movie_id` appear in Join On clause(s)."),
		// 				RecommendationType: to.Ptr("Add"),
		// 				SessionID: to.Ptr("c63c2114-e2a4-4c7a-98c1-85577d1a5d50"),
		// 				Details: map[string]*string{
		// 					"engine": to.Ptr("InnoDB"),
		// 					"indexColumns": to.Ptr("`movies_genres`.`movie_id`"),
		// 					"indexName": to.Ptr("idx_movie_id"),
		// 					"indexType": to.Ptr("BTREE"),
		// 					"parentTableName": to.Ptr("movies_genres"),
		// 					"queryIds": to.Ptr("779"),
		// 					"schemaName": to.Ptr("movies"),
		// 					"script": to.Ptr("alter table `movies`.`movies_genres` add index `idx_movie_id` (`movie_id`)"),
		// 					"tableName": to.Ptr("movies_genres"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Index-2"),
		// 			Type: to.Ptr("Microsoft.DBforMariaDB/servers/advisors/recommendedActions"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testResourceGroupName/providers/Microsoft.Sql/servers/testServerName/advisors/Index/recommendedActions/Index-2"),
		// 			Properties: &armmariadb.RecommendationActionProperties{
		// 				ActionID: to.Ptr[int32](2),
		// 				AdvisorName: to.Ptr("Index"),
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-01T23:43:24.000Z"); return t}()),
		// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-08T23:43:24.000Z"); return t}()),
		// 				Reason: to.Ptr("Column `movies_genres`.`genre` appear in Group By clause(s)."),
		// 				RecommendationType: to.Ptr("Add"),
		// 				SessionID: to.Ptr("c63c2114-e2a4-4c7a-98c1-85577d1a5d50"),
		// 				Details: map[string]*string{
		// 					"engine": to.Ptr("InnoDB"),
		// 					"indexColumns": to.Ptr("`movies_genres`.`genre`"),
		// 					"indexName": to.Ptr("idx_genre"),
		// 					"indexType": to.Ptr("BTREE"),
		// 					"parentTableName": to.Ptr("movies_genres"),
		// 					"queryIds": to.Ptr("779"),
		// 					"schemaName": to.Ptr("movies"),
		// 					"script": to.Ptr("alter table `movies`.`movies_genres` add index `idx_genre` (`genre`)"),
		// 					"tableName": to.Ptr("movies_genres"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}
