//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resourcehealth/armresourcehealth"
	"net/http"
	"net/url"
	"regexp"
)

// ImpactedResourcesServer is a fake server for instances of the armresourcehealth.ImpactedResourcesClient type.
type ImpactedResourcesServer struct {
	// Get is the fake for method ImpactedResourcesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, eventTrackingID string, impactedResourceName string, options *armresourcehealth.ImpactedResourcesClientGetOptions) (resp azfake.Responder[armresourcehealth.ImpactedResourcesClientGetResponse], errResp azfake.ErrorResponder)

	// GetByTenantID is the fake for method ImpactedResourcesClient.GetByTenantID
	// HTTP status codes to indicate success: http.StatusOK
	GetByTenantID func(ctx context.Context, eventTrackingID string, impactedResourceName string, options *armresourcehealth.ImpactedResourcesClientGetByTenantIDOptions) (resp azfake.Responder[armresourcehealth.ImpactedResourcesClientGetByTenantIDResponse], errResp azfake.ErrorResponder)

	// NewListBySubscriptionIDAndEventIDPager is the fake for method ImpactedResourcesClient.NewListBySubscriptionIDAndEventIDPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionIDAndEventIDPager func(eventTrackingID string, options *armresourcehealth.ImpactedResourcesClientListBySubscriptionIDAndEventIDOptions) (resp azfake.PagerResponder[armresourcehealth.ImpactedResourcesClientListBySubscriptionIDAndEventIDResponse])

	// NewListByTenantIDAndEventIDPager is the fake for method ImpactedResourcesClient.NewListByTenantIDAndEventIDPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTenantIDAndEventIDPager func(eventTrackingID string, options *armresourcehealth.ImpactedResourcesClientListByTenantIDAndEventIDOptions) (resp azfake.PagerResponder[armresourcehealth.ImpactedResourcesClientListByTenantIDAndEventIDResponse])
}

// NewImpactedResourcesServerTransport creates a new instance of ImpactedResourcesServerTransport with the provided implementation.
// The returned ImpactedResourcesServerTransport instance is connected to an instance of armresourcehealth.ImpactedResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewImpactedResourcesServerTransport(srv *ImpactedResourcesServer) *ImpactedResourcesServerTransport {
	return &ImpactedResourcesServerTransport{
		srv:                                    srv,
		newListBySubscriptionIDAndEventIDPager: newTracker[azfake.PagerResponder[armresourcehealth.ImpactedResourcesClientListBySubscriptionIDAndEventIDResponse]](),
		newListByTenantIDAndEventIDPager:       newTracker[azfake.PagerResponder[armresourcehealth.ImpactedResourcesClientListByTenantIDAndEventIDResponse]](),
	}
}

// ImpactedResourcesServerTransport connects instances of armresourcehealth.ImpactedResourcesClient to instances of ImpactedResourcesServer.
// Don't use this type directly, use NewImpactedResourcesServerTransport instead.
type ImpactedResourcesServerTransport struct {
	srv                                    *ImpactedResourcesServer
	newListBySubscriptionIDAndEventIDPager *tracker[azfake.PagerResponder[armresourcehealth.ImpactedResourcesClientListBySubscriptionIDAndEventIDResponse]]
	newListByTenantIDAndEventIDPager       *tracker[azfake.PagerResponder[armresourcehealth.ImpactedResourcesClientListByTenantIDAndEventIDResponse]]
}

// Do implements the policy.Transporter interface for ImpactedResourcesServerTransport.
func (i *ImpactedResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ImpactedResourcesClient.Get":
		resp, err = i.dispatchGet(req)
	case "ImpactedResourcesClient.GetByTenantID":
		resp, err = i.dispatchGetByTenantID(req)
	case "ImpactedResourcesClient.NewListBySubscriptionIDAndEventIDPager":
		resp, err = i.dispatchNewListBySubscriptionIDAndEventIDPager(req)
	case "ImpactedResourcesClient.NewListByTenantIDAndEventIDPager":
		resp, err = i.dispatchNewListByTenantIDAndEventIDPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *ImpactedResourcesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ResourceHealth/events/(?P<eventTrackingId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/impactedResources/(?P<impactedResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	eventTrackingIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventTrackingId")])
	if err != nil {
		return nil, err
	}
	impactedResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("impactedResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), eventTrackingIDParam, impactedResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventImpactedResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *ImpactedResourcesServerTransport) dispatchGetByTenantID(req *http.Request) (*http.Response, error) {
	if i.srv.GetByTenantID == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByTenantID not implemented")}
	}
	const regexStr = `/providers/Microsoft\.ResourceHealth/events/(?P<eventTrackingId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/impactedResources/(?P<impactedResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	eventTrackingIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventTrackingId")])
	if err != nil {
		return nil, err
	}
	impactedResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("impactedResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.GetByTenantID(req.Context(), eventTrackingIDParam, impactedResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventImpactedResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *ImpactedResourcesServerTransport) dispatchNewListBySubscriptionIDAndEventIDPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListBySubscriptionIDAndEventIDPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionIDAndEventIDPager not implemented")}
	}
	newListBySubscriptionIDAndEventIDPager := i.newListBySubscriptionIDAndEventIDPager.get(req)
	if newListBySubscriptionIDAndEventIDPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ResourceHealth/events/(?P<eventTrackingId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/impactedResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		eventTrackingIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventTrackingId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armresourcehealth.ImpactedResourcesClientListBySubscriptionIDAndEventIDOptions
		if filterParam != nil {
			options = &armresourcehealth.ImpactedResourcesClientListBySubscriptionIDAndEventIDOptions{
				Filter: filterParam,
			}
		}
		resp := i.srv.NewListBySubscriptionIDAndEventIDPager(eventTrackingIDParam, options)
		newListBySubscriptionIDAndEventIDPager = &resp
		i.newListBySubscriptionIDAndEventIDPager.add(req, newListBySubscriptionIDAndEventIDPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionIDAndEventIDPager, req, func(page *armresourcehealth.ImpactedResourcesClientListBySubscriptionIDAndEventIDResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionIDAndEventIDPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListBySubscriptionIDAndEventIDPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionIDAndEventIDPager) {
		i.newListBySubscriptionIDAndEventIDPager.remove(req)
	}
	return resp, nil
}

func (i *ImpactedResourcesServerTransport) dispatchNewListByTenantIDAndEventIDPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByTenantIDAndEventIDPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTenantIDAndEventIDPager not implemented")}
	}
	newListByTenantIDAndEventIDPager := i.newListByTenantIDAndEventIDPager.get(req)
	if newListByTenantIDAndEventIDPager == nil {
		const regexStr = `/providers/Microsoft\.ResourceHealth/events/(?P<eventTrackingId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/impactedResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		eventTrackingIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventTrackingId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armresourcehealth.ImpactedResourcesClientListByTenantIDAndEventIDOptions
		if filterParam != nil {
			options = &armresourcehealth.ImpactedResourcesClientListByTenantIDAndEventIDOptions{
				Filter: filterParam,
			}
		}
		resp := i.srv.NewListByTenantIDAndEventIDPager(eventTrackingIDParam, options)
		newListByTenantIDAndEventIDPager = &resp
		i.newListByTenantIDAndEventIDPager.add(req, newListByTenantIDAndEventIDPager)
		server.PagerResponderInjectNextLinks(newListByTenantIDAndEventIDPager, req, func(page *armresourcehealth.ImpactedResourcesClientListByTenantIDAndEventIDResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTenantIDAndEventIDPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByTenantIDAndEventIDPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTenantIDAndEventIDPager) {
		i.newListByTenantIDAndEventIDPager.remove(req)
	}
	return resp, nil
}
