//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// RegulatoryComplianceAssessmentsServer is a fake server for instances of the armsecurity.RegulatoryComplianceAssessmentsClient type.
type RegulatoryComplianceAssessmentsServer struct {
	// Get is the fake for method RegulatoryComplianceAssessmentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, regulatoryComplianceStandardName string, regulatoryComplianceControlName string, regulatoryComplianceAssessmentName string, options *armsecurity.RegulatoryComplianceAssessmentsClientGetOptions) (resp azfake.Responder[armsecurity.RegulatoryComplianceAssessmentsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method RegulatoryComplianceAssessmentsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(regulatoryComplianceStandardName string, regulatoryComplianceControlName string, options *armsecurity.RegulatoryComplianceAssessmentsClientListOptions) (resp azfake.PagerResponder[armsecurity.RegulatoryComplianceAssessmentsClientListResponse])
}

// NewRegulatoryComplianceAssessmentsServerTransport creates a new instance of RegulatoryComplianceAssessmentsServerTransport with the provided implementation.
// The returned RegulatoryComplianceAssessmentsServerTransport instance is connected to an instance of armsecurity.RegulatoryComplianceAssessmentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRegulatoryComplianceAssessmentsServerTransport(srv *RegulatoryComplianceAssessmentsServer) *RegulatoryComplianceAssessmentsServerTransport {
	return &RegulatoryComplianceAssessmentsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armsecurity.RegulatoryComplianceAssessmentsClientListResponse]](),
	}
}

// RegulatoryComplianceAssessmentsServerTransport connects instances of armsecurity.RegulatoryComplianceAssessmentsClient to instances of RegulatoryComplianceAssessmentsServer.
// Don't use this type directly, use NewRegulatoryComplianceAssessmentsServerTransport instead.
type RegulatoryComplianceAssessmentsServerTransport struct {
	srv          *RegulatoryComplianceAssessmentsServer
	newListPager *tracker[azfake.PagerResponder[armsecurity.RegulatoryComplianceAssessmentsClientListResponse]]
}

// Do implements the policy.Transporter interface for RegulatoryComplianceAssessmentsServerTransport.
func (r *RegulatoryComplianceAssessmentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RegulatoryComplianceAssessmentsClient.Get":
		resp, err = r.dispatchGet(req)
	case "RegulatoryComplianceAssessmentsClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RegulatoryComplianceAssessmentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/regulatoryComplianceStandards/(?P<regulatoryComplianceStandardName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regulatoryComplianceControls/(?P<regulatoryComplianceControlName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regulatoryComplianceAssessments/(?P<regulatoryComplianceAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	regulatoryComplianceStandardNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("regulatoryComplianceStandardName")])
	if err != nil {
		return nil, err
	}
	regulatoryComplianceControlNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("regulatoryComplianceControlName")])
	if err != nil {
		return nil, err
	}
	regulatoryComplianceAssessmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("regulatoryComplianceAssessmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), regulatoryComplianceStandardNameParam, regulatoryComplianceControlNameParam, regulatoryComplianceAssessmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RegulatoryComplianceAssessment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RegulatoryComplianceAssessmentsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/regulatoryComplianceStandards/(?P<regulatoryComplianceStandardName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regulatoryComplianceControls/(?P<regulatoryComplianceControlName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regulatoryComplianceAssessments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		regulatoryComplianceStandardNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("regulatoryComplianceStandardName")])
		if err != nil {
			return nil, err
		}
		regulatoryComplianceControlNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("regulatoryComplianceControlName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armsecurity.RegulatoryComplianceAssessmentsClientListOptions
		if filterParam != nil {
			options = &armsecurity.RegulatoryComplianceAssessmentsClientListOptions{
				Filter: filterParam,
			}
		}
		resp := r.srv.NewListPager(regulatoryComplianceStandardNameParam, regulatoryComplianceControlNameParam, options)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.RegulatoryComplianceAssessmentsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}
