//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/securitydevops/armsecuritydevops"
	"net/http"
	"net/url"
	"regexp"
)

// GitHubOwnerServer is a fake server for instances of the armsecuritydevops.GitHubOwnerClient type.
type GitHubOwnerServer struct {
	// BeginCreateOrUpdate is the fake for method GitHubOwnerClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubOwner armsecuritydevops.GitHubOwner, options *armsecuritydevops.GitHubOwnerClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsecuritydevops.GitHubOwnerClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method GitHubOwnerClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, options *armsecuritydevops.GitHubOwnerClientGetOptions) (resp azfake.Responder[armsecuritydevops.GitHubOwnerClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method GitHubOwnerClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, gitHubConnectorName string, options *armsecuritydevops.GitHubOwnerClientListOptions) (resp azfake.PagerResponder[armsecuritydevops.GitHubOwnerClientListResponse])

	// BeginUpdate is the fake for method GitHubOwnerClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubOwner armsecuritydevops.GitHubOwner, options *armsecuritydevops.GitHubOwnerClientBeginUpdateOptions) (resp azfake.PollerResponder[armsecuritydevops.GitHubOwnerClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewGitHubOwnerServerTransport creates a new instance of GitHubOwnerServerTransport with the provided implementation.
// The returned GitHubOwnerServerTransport instance is connected to an instance of armsecuritydevops.GitHubOwnerClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewGitHubOwnerServerTransport(srv *GitHubOwnerServer) *GitHubOwnerServerTransport {
	return &GitHubOwnerServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armsecuritydevops.GitHubOwnerClientCreateOrUpdateResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armsecuritydevops.GitHubOwnerClientListResponse]](),
		beginUpdate:         newTracker[azfake.PollerResponder[armsecuritydevops.GitHubOwnerClientUpdateResponse]](),
	}
}

// GitHubOwnerServerTransport connects instances of armsecuritydevops.GitHubOwnerClient to instances of GitHubOwnerServer.
// Don't use this type directly, use NewGitHubOwnerServerTransport instead.
type GitHubOwnerServerTransport struct {
	srv                 *GitHubOwnerServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armsecuritydevops.GitHubOwnerClientCreateOrUpdateResponse]]
	newListPager        *tracker[azfake.PagerResponder[armsecuritydevops.GitHubOwnerClientListResponse]]
	beginUpdate         *tracker[azfake.PollerResponder[armsecuritydevops.GitHubOwnerClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for GitHubOwnerServerTransport.
func (g *GitHubOwnerServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "GitHubOwnerClient.BeginCreateOrUpdate":
		resp, err = g.dispatchBeginCreateOrUpdate(req)
	case "GitHubOwnerClient.Get":
		resp, err = g.dispatchGet(req)
	case "GitHubOwnerClient.NewListPager":
		resp, err = g.dispatchNewListPager(req)
	case "GitHubOwnerClient.BeginUpdate":
		resp, err = g.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (g *GitHubOwnerServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if g.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := g.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/gitHubConnectors/(?P<gitHubConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/owners/(?P<gitHubOwnerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsecuritydevops.GitHubOwner](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		gitHubConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubConnectorName")])
		if err != nil {
			return nil, err
		}
		gitHubOwnerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubOwnerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, gitHubConnectorNameParam, gitHubOwnerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		g.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		g.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		g.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (g *GitHubOwnerServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if g.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/gitHubConnectors/(?P<gitHubConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/owners/(?P<gitHubOwnerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	gitHubConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubConnectorName")])
	if err != nil {
		return nil, err
	}
	gitHubOwnerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubOwnerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.Get(req.Context(), resourceGroupNameParam, gitHubConnectorNameParam, gitHubOwnerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GitHubOwner, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GitHubOwnerServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if g.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := g.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/gitHubConnectors/(?P<gitHubConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/owners`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		gitHubConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubConnectorName")])
		if err != nil {
			return nil, err
		}
		resp := g.srv.NewListPager(resourceGroupNameParam, gitHubConnectorNameParam, nil)
		newListPager = &resp
		g.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecuritydevops.GitHubOwnerClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		g.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		g.newListPager.remove(req)
	}
	return resp, nil
}

func (g *GitHubOwnerServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if g.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := g.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/gitHubConnectors/(?P<gitHubConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/owners/(?P<gitHubOwnerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsecuritydevops.GitHubOwner](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		gitHubConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubConnectorName")])
		if err != nil {
			return nil, err
		}
		gitHubOwnerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubOwnerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginUpdate(req.Context(), resourceGroupNameParam, gitHubConnectorNameParam, gitHubOwnerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		g.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		g.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		g.beginUpdate.remove(req)
	}

	return resp, nil
}
