;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2014 Taylan Ulrich Bayirli/Kammer <taylanbayirli@gmail.com>
;;; Copyright © 2013-2022 Ludovic Courtès <ludo@gnu.org>
;;; Copyright © 2014, 2015, 2016, 2017, 2018 Mark H Weaver <mhw@netris.org>
;;; Copyright © 2014, 2015, 2016, 2017, 2018, 2019 Alex Kost <alezost@gmail.com>
;;; Copyright © 2015 Federico Beffa <beffa@fbengineering.ch>
;;; Copyright © 2015, 2016, 2017, 2018, 2019, 2020, 2021 Ricardo Wurmus <rekado@elephly.net>
;;; Copyright © 2016, 2017, 2018, 2019 Chris Marusich <cmmarusich@gmail.com>
;;; Copyright © 2015, 2016, 2018, 2020 Christine Lemmer-Webber <cwebber@dustycloud.org>
;;; Copyright © 2016 Adriano Peluso <catonano@gmail.com>
;;; Copyright © 2016, 2017, 2018, 2019, 2020, 2021 Efraim Flashner <efraim@flashner.co.il>
;;; Copyright © 2016 David Thompson <davet@gnu.org>
;;; Copyright © 2016 Matthew Jordan <matthewjordandevops@yandex.com>
;;; Copyright © 2016, 2017 Roel Janssen <roel@gnu.org>
;;; Copyright © 2016, 2017 Nikita <nikita@n0.is>
;;; Copyright © 2016, 2019 Alex Griffin <a@ajgrf.com>
;;; Copyright © 2016-2022 Nicolas Goaziou <mail@nicolasgoaziou.fr>
;;; Copyright © 2016, 2017, 2018 Alex Vong <alexvong1995@gmail.com>
;;; Copyright © 2016-2022 Arun Isaac <arunisaac@systemreboot.net>
;;; Copyright © 2017 Christopher Baines <mail@cbaines.net>
;;; Copyright © 2017, 2018, 2019, 2020, 2022 Mathieu Othacehe <m.othacehe@gmail.com>
;;; Copyright © 2017, 2018, 2019, 2020, 2021, 2022 Clément Lassieur <clement@lassieur.org>
;;; Copyright © 2017 Vasile Dumitrascu <va511e@yahoo.com>
;;; Copyright © 2017, 2018, 2022 Kyle Meyer <kyle@kyleam.com>
;;; Copyright © 2017 Kei Kebreau <kkebreau@posteo.net>
;;; Copyright © 2017 George Clemmer <myglc2@gmail.com>
;;; Copyright © 2017, 2018 Feng Shu <tumashu@163.com>
;;; Copyright © 2017, 2020 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
;;; Copyright © 2017, 2018, 2019, 2020 Oleg Pykhalov <go.wigust@gmail.com>
;;; Copyright © 2017 Mekeor Melire <mekeor.melire@gmail.com>
;;; Copyright © 2017 Peter Mikkelsen <petermikkelsen10@gmail.com>
;;; Copyright © 2017–2021 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2017 Mike Gerwitz <mtg@gnu.org>
;;; Copyright © 2017, 2018, 2019, 2020, 2021, 2022 Maxim Cournoyer <maxim.cournoyer@gmail.com>
;;; Copyright © 2018 Sohom Bhattacharjee <soham.bhattacharjee15@gmail.com>
;;; Copyright © 2018, 2019 Mathieu Lirzin <mthl@gnu.org>
;;; Copyright © 2018, 2019, 2020, 2021 Pierre Neidhardt <mail@ambrevar.xyz>
;;; Copyright © 2018, 2019, 2020 Tim Gesthuizen <tim.gesthuizen@yahoo.de>
;;; Copyright © 2018, 2019 Jack Hill <jackhill@jackhill.us>
;;; Copyright © 2018 Pierre-Antoine Rouby <pierre-antoine.rouby@inria.fr>
;;; Copyright © 2018 Alex Branham <alex.branham@gmail.com>
;;; Copyright © 2018 Thorsten Wilms <t_w_@freenet.de>
;;; Copyright © 2018, 2019, 2020, 2021 Pierre Langlois <pierre.langlois@gmx.com>
;;; Copyright © 2018, 2019, 2020, 2021 Brett Gilio <brettg@gnu.org>
;;; Copyright © 2019, 2020 Dimakakos Dimos <bendersteed@teknik.io>
;;; Copyright © 2019, 2020 Brian Leung <bkleung89@gmail.com>
;;; Copyright © 2019 mikadoZero <mikadozero@yandex.com>
;;; Copyright © 2019 Gabriel Hondet <gabrielhondet@gmail.com>
;;; Copyright © 2019, 2020, 2021 Joseph LaFreniere <joseph@lafreniere.xyz>
;;; Copyright © 2019 Todor Kondić <tk.code@protonmail.com>15669
;;; Copyright © 2019 Amar Singh <nly@disroot.org>
;;; Copyright © 2019, 2022 Baptiste Strazzulla <bstrazzull@hotmail.fr>
;;; Copyright © 2019 Giacomo Leidi <goodoldpaul@autistici.org>
;;; Copyright © 2019 Jens Mølgaard <jens@zete.tk>
;;; Copyright © 2019, 2020 Amin Bandali <bandali@gnu.org>
;;; Copyright © 2019 Jelle Licht <jlicht@fsfe.org>
;;; Copyright © 2019 Björn Höfling <bjoern.hoefling@bjoernhoefling.de>
;;; Copyright © 2019 Stephen Webber <montokapro@gmail.com>
;;; Copyright © 2019, 2021 Liliana Marie Prikler <liliana.prikler@gmail.com>
;;; Copyright © 2019 David Wilson <david@daviwil.com>
;;; Copyright © 2020 Paul Garlick <pgarlick@tourbillion-technology.com>
;;; Copyright © 2020 Robert Smith <robertsmith@posteo.net>
;;; Copyright © 2020 Evan Straw <evan.straw99@gmail.com>
;;; Copyright © 2020, 2021, 2022 Masaya Tojo <masaya@tojo.tokyo>
;;; Copyright © 2020, 2021 Martin Becze <mjbecze@riseup.net>
;;; Copyright © 2020, 2021, 2022 Michael Rohleder <mike@rohleder.de>
;;; Copyright © 2020 Brice Waegeneire <brice@waegenei.re>
;;; Copyright © 2020 6033fe7de85d <6033fe7de85d@airmail.cc>
;;; Copyright © 2020 John Soo <jsoo1@asu.edu>
;;; Copyright © 2020 Jérémy Korwin-Zmijowski <jeremy@korwin-zmijowski.fr>
;;; Copyright © 2020 Alberto Eleuterio Flores Guerrero <barbanegra+guix@posteo.mx>
;;; Copyright © 2020 Marius Bakke <mbakke@fastmail.com>
;;; Copyright © 2020, 2022 pinoaffe <pinoaffe@gmail.com>
;;; Copyright © 2020, 2021, 2022 Vinicius Monego <monego@posteo.net>
;;; Copyright © 2020 Ryan Desfosses <rdes@protonmail.com>
;;; Copyright © 2020 Marcin Karpezo <sirmacik@wioo.waw.pl>
;;; Copyright © 2020, 2022 Fredrik Salomonsson <plattfot@posteo.net>
;;; Copyright © 2020 Eric Bavier <bavier@posteo.net>
;;; Copyright © 2020, 2021 Morgan Smith <Morgan.J.Smith@outlook.com>
;;; Copyright © 2020 Peng Mei Yu <i@pengmeiyu.com>
;;; Copyright © 2020, 2021, 2022 Niklas Eklund <niklas.eklund@posteo.net>
;;; Copyright © 2020 Marco Grassi <marco.au.grassi98@protonmail.com>
;;; Copyright © 2020 Tomás Ortín Fernández <tomasortin@mailbox.org>
;;; Copyright © 2020, 2021 Zhu Zihao <all_but_last@163.com>
;;; Copyright © 2020 Adam Kandur <rndd@tuta.io>
;;; Copyright © 2020 Tim Howes <timhowes@lavabit.com>
;;; Copyright © 2020 Noah Landis <noahlandis@posteo.net>
;;; Copyright © 2020, 2021 Nicolò Balzarotti <nicolo@nixo.xyz>
;;; Copyright © 2020, 2022 André A. Gomes <andremegafone@gmail.com>
;;; Copyright © 2020 Jonathan Rostran <rostranjj@gmail.com>
;;; Copyright © 2020, 2021 Noah Evans <noah@nevans.me>
;;; Copyright © 2020 Brit Butler <brit@kingcons.io>
;;; Copyright © 2021, 2022 Aleksandr Vityazev <avityazev@posteo.org>
;;; Copyright © 2021 Yurii Kholodkov <urist.mckorobochka@gmail.com>
;;; Copyright © 2021 Alexey Abramov <levenson@mmer.org>
;;; Copyright © 2021 Xinglu Chen <public@yoctocell.xyz>
;;; Copyright © 2021, 2022 Stefan Reichör <stefan@xsteve.at>
;;; Copyright © 2021, 2022 Simon Tournier <zimon.toutoune@gmail.com>
;;; Copyright © 2021 Eugene Klimov <lipklim@mailbox.org>
;;; Copyright © 2021 Zheng Junjie <873216071@qq.com>
;;; Copyright © 2021 David Dashyan <mail@davie.li>
;;; Copyright © 2021 Dhruvin Gandhi <contact@dhruvin.dev>
;;; Copyright © 2021 Matthew James Kraai <kraai@ftbfs.org>
;;; Copyright © 2021 Noisytoot <noisytoot@disroot.org>
;;; Copyright © 2021 Simon South <simon@simonsouth.net>
;;; Copyright © 2021 la snesne <lasnesne@lagunposprasihopre.org>
;;; Copyright © 2021 Brian Kubisiak <brian@kubisiak.com>
;;; Copyright © 2021, 2022 Taiju HIGASHI <higashi@taiju.info>
;;; Copyright © 2022 Brandon Lucas <br@ndon.dk>
;;; Copyright © 2022 Jai Vetrivelan <jaivetrivelan@gmail.com>
;;; Copyright © 2022 jgart <jgart@dismail.de>
;;; Copyright © 2022 Dominic Martinez <dom@dominicm.dev>
;;; Copyright © 2022 Peter Polidoro <peter@polidoro.io>
;;; Copyright © 2022 Luis Felipe López Acevedo <luis.felipe.la@protonmail.com>
;;; Copyright © 2022 Thomas Albers Raviola <thomas@thomaslabs.org>
;;; Copyright © 2022 Haider Mirza <haider@haider.gq>
;;; Copyright © 2022 Jose G Perez Taveras <josegpt27@gmail.com>
;;; Copyright © 2022 Hilton Chain <hako@ultrarare.space>
;;; Copyright © 2022 Nicolas Graves <ngraves@ngraves.fr>
;;; Copyright © 2022 Thiago Jung Bauermann <bauermann@kolabnow.com>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (gnu packages emacs-xyz)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (guix packages)
  #:use-module (guix cvs-download)
  #:use-module (guix download)
  #:use-module (guix bzr-download)
  #:use-module (guix gexp)
  #:use-module (guix i18n)
  #:use-module (guix git-download)
  #:use-module (guix hg-download)
  #:use-module (guix build-system gnu)
  #:use-module (guix build-system cmake)
  #:use-module (guix build-system copy)
  #:use-module (guix build-system emacs)
  #:use-module (guix build-system glib-or-gtk)
  #:use-module (guix build-system perl)
  #:use-module (guix build-system trivial)
  #:use-module (gnu packages)
  #:use-module (gnu packages admin)
  #:use-module (gnu packages aspell)
  #:use-module (gnu packages audio)
  #:use-module (gnu packages bash)
  #:use-module (gnu packages chez)
  #:use-module (gnu packages cmake)
  #:use-module (gnu packages code)
  #:use-module (gnu packages cpp)
  #:use-module (gnu packages curl)
  #:use-module (gnu packages databases)
  #:use-module (gnu packages dictionaries)
  #:use-module (gnu packages djvu)
  #:use-module (gnu packages ebook)
  #:use-module (gnu packages emacs)
  #:use-module (gnu packages fonts)
  #:use-module (gnu packages freedesktop)
  #:use-module (gnu packages games)
  #:use-module (gnu packages gawk)
  #:use-module (gnu packages golang)
  #:use-module (gnu packages guile)
  #:use-module (gnu packages gtk)
  #:use-module (gnu packages gnome)
  #:use-module (gnu packages graphviz)
  #:use-module (gnu packages haskell-apps)
  #:use-module (gnu packages ibus)
  #:use-module (gnu packages java)
  #:use-module (gnu packages ncurses)
  #:use-module (gnu packages networking)
  #:use-module (gnu packages python)
  #:use-module (gnu packages python-xyz)
  #:use-module (gnu packages telephony)
  #:use-module (gnu packages terminals)
  #:use-module (gnu packages tex)
  #:use-module (gnu packages texinfo)
  #:use-module (gnu packages tcl)
  #:use-module (gnu packages tls)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages xorg)
  #:use-module (gnu packages lesstif)
  #:use-module (gnu packages llvm)
  #:use-module (gnu packages image)
  #:use-module (gnu packages linux)
  #:use-module (gnu packages libevent)
  #:use-module (gnu packages lisp-xyz)
  #:use-module (gnu packages lua)
  #:use-module (gnu packages music)
  #:use-module (gnu packages version-control)
  #:use-module (gnu packages imagemagick)
  #:use-module (gnu packages w3m)
  #:use-module (gnu packages web)
  #:use-module (gnu packages wget)
  #:use-module (gnu packages autotools)
  #:use-module (gnu packages base)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages node)
  #:use-module (gnu packages xml)
  #:use-module (gnu packages glib)
  #:use-module (gnu packages acl)
  #:use-module (gnu packages mail)
  #:use-module (gnu packages messaging)
  #:use-module (gnu packages package-management)
  #:use-module (gnu packages perl)
  #:use-module (gnu packages pdf)
  #:use-module (gnu packages racket)
  #:use-module (gnu packages ruby)
  #:use-module (gnu packages rust-apps)
  #:use-module (gnu packages scheme)
  #:use-module (gnu packages serialization)
  #:use-module (gnu packages speech)
  #:use-module (gnu packages xiph)
  #:use-module (gnu packages mp3)
  #:use-module (gnu packages gettext)
  #:use-module (gnu packages fribidi)
  #:use-module (gnu packages gd)
  #:use-module (gnu packages fontutils)
  #:use-module (gnu packages password-utils)
  #:use-module (gnu packages pulseaudio)
  #:use-module (gnu packages sphinx)
  #:use-module (gnu packages screen)
  #:use-module (gnu packages xdisorg)
  #:use-module (gnu packages shells)
  #:use-module (gnu packages shellutils)
  #:use-module (gnu packages sqlite)
  #:use-module (gnu packages ghostscript)
  #:use-module (gnu packages gnupg)
  #:use-module (gnu packages video)
  #:use-module (gnu packages haskell-xyz)
  #:use-module (gnu packages wordnet)
  #:use-module (gnu packages photo)
  #:use-module (gnu packages uml)
  #:use-module (gnu packages finance)
  #:use-module (gnu packages ocaml)
  #:use-module (gnu packages erlang)
  #:use-module (gnu packages statistics)
  #:use-module (gnu packages libcanberra)
  #:use-module (guix utils)
  #:use-module (srfi srfi-1)
  #:use-module (ice-9 match))

;;;
;;; Emacs hacking.
;;;

(define-public emacs-geiser
  (package
    (name "emacs-geiser")
    (version "0.28")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/emacs-geiser/geiser")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0dd20cq3nz4jjysaqx2aiqqaxvkfkbj2x4zm2mz3pd4rmydckj2y"))))
    (build-system emacs-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         ;; Move the source files to the top level, which is included in
         ;; the EMACSLOADPATH.
         (add-after 'unpack 'move-source-files
           (lambda _
             (let ((el-files (find-files "./elisp" ".*\\.el$")))
               (for-each (lambda (f)
                           (rename-file f (basename f)))
                         el-files))))
         (add-before 'install 'make-info
           (lambda _
             (with-directory-excursion "doc"
               (invoke "makeinfo" "--no-split"
                       "-o" "geiser.info" "geiser.texi")))))))
    (native-inputs
     (list texinfo))
    (home-page "https://www.nongnu.org/geiser/")
    (synopsis "Collection of Emacs modes for Scheme hacking")
    (description
     "Geiser is a collection of Emacs major and minor modes that conspire with
one or more Scheme implementations to keep the Lisp Machine Spirit alive.  The
continuously running Scheme interpreter takes the center of the stage in
Geiser.  A bundle of Elisp shims orchestrates the dialog between the Scheme
implementation, Emacs and, ultimately, the schemer, giving them access to live
metadata.

This package provides just the core of Geiser.  To effectively use it with your
favourite Scheme implementation, you also need the corresponding geiser package,
e.g. emacs-geiser-guile for Guile.")
    (license license:bsd-3)))

(define-public emacs-geiser-guile
  (package
    (name "emacs-geiser-guile")
    (version "0.28.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/emacs-geiser/guile")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13qxg1npm0pmnml5q268k5xk1clyqldp8v200ihrqwqlc3ga7f36"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons "^src/" %default-include)
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-geiser-guile-binary
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "geiser-guile.el"
                (("\\(t \"guile\")")
                 (format #f "(t ~s)"
                         (search-input-file inputs "bin/guile"))))))
          (add-after 'make-autoloads 'patch-autoloads
            (lambda _
              (substitute* (string-append (elpa-directory #$output)
                                          "/geiser-guile-autoloads.el")
                ;; Activating implementations fails when Geiser is not yet
                ;; loaded, so let's defer that until it is.
                (("\\(geiser-activate-implementation .*\\)" all)
                 (string-append
                  "(eval-after-load 'geiser-impl '" all ")"))))))))
    (inputs (list guile-3.0-latest))
    (propagated-inputs (list emacs-geiser))
    (home-page "https://www.nongnu.org/geiser/")
    (synopsis "Guile Scheme support for Geiser")
    (description
     "This package adds support for the Guile Scheme implementation to Geiser,
a generic Scheme interaction mode for the GNU Emacs editor.")
    (license license:bsd-3)))

(define-public emacs-ac-geiser
  (let ((commit "93818c936ee7e2f1ba1b315578bde363a7d43d05")
        (revision "0"))
    (package
      (name "emacs-ac-geiser")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (uri (git-reference
               (url "https://github.com/xiaohanyu/ac-geiser")
               (commit commit)))
         (method git-fetch)
         (sha256
          (base32 "00n2qa26yilaj837n1yp6lbqa4gf30nkkbvanl7m9ih7k48ssqmw"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-geiser emacs-auto-complete))
      (synopsis "Auto-complete backend for geiser")
      (description
       "This package provides an auto-complete source for Scheme projects
using geiser.")
      (license license:bsd-3)
      (home-page "https://github.com/xiaohanyu/ac-geiser"))))

(define-public emacs-geiser-gauche
  ;; The latest 0.14 release has an unbound variable (geiser-scheme-dir).
  (let ((commit "96fa06aaeef18cc1b3b519e83dbb7be09eeb0d07")
        (revision "0"))
    (package
      (name "emacs-geiser-gauche")
      (version (git-version "0.14" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/emacs-geiser/gauche.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1ppracwfl1snq0ifdlyxpdlv7fbn3pbxm1hd1ihgqivii5nbya9r"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:include '(cons "^geiser-gauche\\.scm$" %default-include)
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-geiser-gauche-binary
              (lambda* (#:key inputs #:allow-other-keys)
                (emacs-substitute-sexps "geiser-gauche.el"
                  ("geiser-custom--defcustom geiser-gauche-binary"
                   (search-input-file inputs "bin/gosh")))))
            (add-after 'make-autoloads 'patch-autoloads
              (lambda _
                (substitute* (string-append (elpa-directory #$output)
                                            "/geiser-gauche-autoloads.el")
                  ;; Activating implementations fails when Geiser is not yet
                  ;; loaded, so let's defer that until it is.
                  (("\\(geiser-activate-implementation .*\\)" all)
                   (string-append
                    "(eval-after-load 'geiser-impl '" all ")"))
                  (("\\(geiser-implementation-extension .*\\)" all)
                   (string-append
                    "(eval-after-load 'geiser-impl '" all ")"))))))))
      (inputs (list gauche))
      (propagated-inputs (list emacs-geiser))
      (home-page "https://gitlab.com/emacs-geiser/gauche")
      (synopsis "Gauche Scheme support for Geiser")
      (description
       "This package adds support for the Gauche Scheme implementation to Geiser,
a generic Scheme interaction mode for the GNU Emacs editor.")
      (license license:expat))))

(define-public emacs-geiser-racket
  (package
    (name "emacs-geiser-racket")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/emacs-geiser/racket")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "04gwd9qa0785zfr6m9a5443ilgvyz05l06cb1waicf83sgp8xl32"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons "^src/" %default-include)
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-geiser-racket-binary
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "geiser-racket.el"
                (("\\(t \"racket\")")
                 (format #f "(t ~s)"
                         (search-input-file inputs "bin/racket"))))))
          (add-after 'make-autoloads 'patch-autoloads
            (lambda _
              (substitute* (string-append (elpa-directory #$output)
                                          "/geiser-racket-autoloads.el")
                ;; Activating implementations fails when Geiser is not yet
                ;; loaded, so let's defer that until it is.
                (("\\(geiser-activate-implementation .*\\)" all)
                 (string-append
                  "(eval-after-load 'geiser-impl '" all ")"))
                (("\\(geiser-implementation-extension .*\\)" all)
                 (string-append
                  "(eval-after-load 'geiser-impl '" all ")"))))))))
    (inputs (list racket))
    (propagated-inputs (list emacs-geiser))
    (home-page "https://www.nongnu.org/geiser/")
    (synopsis "Racket support for Geiser")
    (description
     "This package adds support for the Racket implementation to Geiser,
a generic Scheme interaction mode for the GNU Emacs editor.")
    (license license:bsd-3)))

(define-public emacs-geiser-chez
  (package
    (name "emacs-geiser-chez")
    (version "0.17")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/emacs-geiser/chez")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "03fc9ahb0pmznkcnxzgpni4clj1zgky6vaqkc94nf8b8swniwkm9"))))
    (build-system emacs-build-system)
    (arguments
     '(#:include (cons "^src/" %default-include)
       #:phases
       (modify-phases %standard-phases
         (add-after 'make-autoloads 'patch-autoloads
           (lambda* (#:key outputs #:allow-other-keys)
             (substitute* (string-append
                           (elpa-directory (assoc-ref outputs "out"))
                           "/geiser-chez-autoloads.el")
               ;; Activating implementations fails when Geiser is not yet
               ;; loaded, so let's defer that until it is.
               ;; See <https://gitlab.com/emacs-geiser/chez/-/issues/7>.
               (("\\(geiser-activate-implementation .*\\)" all)
                (string-append
                 "(eval-after-load 'geiser-impl '" all ")"))
               (("\\(geiser-implementation-extension .*\\)" all)
                (string-append
                 "(eval-after-load 'geiser-impl '" all ")"))))))))
    (inputs
     (list (chez-scheme-for-system)))
    (propagated-inputs
     (list emacs-geiser))
    (home-page "https://nongnu.org/geiser/")
    (synopsis "Support for Chez Scheme in Geiser")
    (description
     "This package adds support for using Chez Scheme in Emacs with Geiser.")
    (license license:bsd-3)))

(define-public emacs-vc-hgcmd
  (package
    (name "emacs-vc-hgcmd")
    (version "1.14.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/muffinmad/emacs-vc-hgcmd")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nlaicza4ds325827ks5gb7zn0nc536k2chq8jwbq34ybvxi93wj"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/muffinmad/emacs-vc-hgcmd")
    (synopsis "Version control (VC) backend for the Mercurial command server")
    (description
     "This package provides an Emacs VC backend to work with Mercurial
repositories through the
@uref{https://www.mercurial-scm.org/wiki/CommandServer,Mercurial command
server}.  The main advantage compared to @code{vc-hg} is speed.")
    (license license:gpl3+)))

(define-public emacs-telephone-line
  (let ((commit "6f3455a365912e8f0c45a2240ea79507dee45ade")
        (revision "0"))
    (package
      (name "emacs-telephone-line")
      (version (git-version "0.5" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/dbordak/telephone-line")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1hnd6wnc52sc0ckriqnhaz64pyjk027y0dpcmh2zhpd27i8d4hmq"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/dbordak/telephone-line")
      (synopsis "Implementation of Powerline for Emacs")
      (description
       "Telephone Line is a new implementation of Powerline for Emacs with
optional baked-in Evil support, antialiased separators, and an easy
configuration language which makes it trivial to write your own themes.")
      (license license:gpl3+))))

(define-public emacs-inspector
  (let ((commit "0e89d28558f57db4519f154bb72ce617a8c6265d")
        (revision "0"))
    (package
      (name "emacs-inspector")
      (version (git-version "0.8" revision commit))
      (source
       (origin
         (uri (git-reference
               (url "https://github.com/mmontone/emacs-inspector")
               (commit commit)))
         (method git-fetch)
         (sha256
          (base32 "0n72sqn29b5sya686cicgp40mkk5x5821b7bw4zs6dcl82cyij5n"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #t
        #:test-command #~(list "emacs" "-Q" "--batch"
                               "-L" "."
                               "-l" "inspector-tests.el"
                               "-l" "tree-inspector-tests.el"
                               "-f" "ert-run-tests-batch-and-exit")
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'preserve-emacs-28-compatibility
              ;; XXX: `cl-constantly' function is defined in "cl-lib" starting
              ;; from Emacs 29+.  For now, replace it with its definition.
              (lambda _
                (substitute* "tree-inspector.el"
                  (("cl-constantly") "lambda (_)"))))
            (add-before 'check 'skip-failing-test
              (lambda _
                (substitute* "tree-inspector-tests.el"
                  (("\\(ert-deftest inspector-tests--inspect-struct-test.*" all)
                   (string-append all " (skip-unless nil)"))))))))
      (native-inputs (list emacs-ert-runner))
      (propagated-inputs (list emacs-treeview))
      (home-page "https://github.com/mmontone/emacs-inspector")
      (synopsis "Inspection tool for Emacs Lisp objects")
      (description
       "This package provides an introspection tool similar to those found in
Common Lisp or Smalltalk, but for Emacs Lisp.")
      (license license:gpl3+))))

(define-public emacs-terminal-here
  (package
    (name "emacs-terminal-here")
    (version "2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/davidshepherd7/terminal-here")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1iv1c2mbvhn00ha46c6f98j9syc71xhjpk8m5wa5p32sk4wcc9f4"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/davidshepherd7/terminal-here")
    (synopsis "Open external terminals from Emacs")
    (description
     "This package provides commands to open external terminal emulators from
Emacs, whose initial working directories are determined in relation to the
current buffer.")
    (license license:gpl3+)))

(define-public emacs-treeview
  (let ((commit "d9c10feddf3b959e7b33ce83103e1f0a61162723")
        (revision "0"))
    (package
      (name "emacs-treeview")
      (version (git-version "1.1.1" revision commit))
      (source
       (origin
         (uri (git-reference
               (url "https://github.com/tilmanrassy/emacs-treeview")
               (commit commit)))
         (method git-fetch)
         (sha256
          (base32 "14s0b6zbapsvgyxki59lglwb3s8wjsjwkgj5r66af9nj2bgz5ms9"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (home-page "https://github.com/tilmanrassy/emacs-treeview/")
      (synopsis "Emacs Lisp framework for tree navigation")
      (description
       "Abstract Emacs Lisp framework for tree navigation.")
      (license license:gpl3+))))

(define-public emacs-hgignore-mode
  ;; From 2021-03-14.
  ;; No releases available.
  (let ((commit "2c5aa4c238848f5b4f2955afcfb5f21ea513653b")
        (revision "0"))
    (package
      (name "emacs-hgignore-mode")
      ;; `Version:' header says 0.1.20150329
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/omajid/hgignore-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0jn9rzhrmmv4lf7rdapdjclk6623d1mir2lq3c46428skhzjlph7"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/omajid/hgignore-mode")
      (synopsis "Major mode for editing @file{hgignore} files")
      (description "This package provides a basic major mode for
editing @file{.hgignore} files used by the Mercurial version control
system.")
      (license license:gpl3+))))

(define-public emacs-platformio-mode
  (package
    (name "emacs-platformio-mode")
    (version "0.3.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ZachMassia/PlatformIO-Mode")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0ian50v9vaz7kqzn20bhqadq50h0l3zhjkmniinpz4q9klh7drh9"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-async emacs-projectile))
    (home-page "https://github.com/zachmassia/platformio-mode")
    (synopsis "Minor mode for building and uploading PlatformIO projects")
    (description "This package provices an Emacs minor mode for building and
uploading PlatformIO projects.")
    (license license:gpl3+)))

(define-public emacs-hyperbole
  (package
    (name "emacs-hyperbole")
    (version "8.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "hyperbole-" version ".tar"))
       (sha256
        (base32 "171x7jad62xd0n3xgs32dksyhn5abxj1kna0qgm65mm0v73hrv8d"))))
    (build-system emacs-build-system)
    (arguments
     (list #:include #~(cons* "DEMO"
                              "DEMO-ROLO.otl"
                              "HY-ABOUT"
                              "man/hkey-help.txt"
                              "\\.kotl$"
                              %default-include)
           #:phases
           #~(modify-phases %standard-phases
               ;; Fix build issues about missing "domainname" and
               ;; "hpmap:dir-user" parent dir, and missing require in
               ;; "hgnus.el" (void-function: var-append).
               (add-after 'unpack 'fix-build
                 (lambda* (#:key inputs #:allow-other-keys)
                   (substitute* "hypb.el"
                     (("/bin/domainname")
                      (search-input-file inputs "bin/dnsdomainname")))
                   (substitute* "hyperbole.el"
                     (("\\(hyperb:check-dir-user\\)") ""))
                   (substitute* "hgnus.el"
                     (("hmail ") "hmail hvar "))))
               (add-after 'install 'install-images
                 (lambda _
                   (let ((dir (string-append #$output "/share/info/im")))
                     (for-each (lambda (file)
                                 (install-file file dir))
                               (find-files "man/im" "\\.png$"))))))))
    (inputs
     (list inetutils))
    (home-page "https://www.gnu.org/software/hyperbole/")
    (synopsis "The Everyday Hypertextual Information Manager")
    (description
     "GNU Hyperbole, or just Hyperbole, is a programmable hypertextual
information management system.  It offers rapid views and interlinking of all
kinds of textual information, utilizing Emacs for editing.  In particular,
Hyperbole lets you quickly create and activate hyperlink buttons, build
outlines, manage all your contacts, your windows and frames, and search across
buffers, directory trees, or the web.")
    (license license:gpl3+)))

(define-public emacs-vlf
  (package
    (name "emacs-vlf")
    (version "1.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "vlf-" version ".tar"))
       (sha256
        (base32 "0hpri19z6b7dqmrj5ckp8sf0m0l72lkgahqzvfmwhgpgv2p81bny"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/m00natic/vlfi/")
    (synopsis "View large files in Emacs")
    (description
"Vlf is an Emacs minor mode that allows viewing, editing, searching and
comparing large files in batches.")
    (license license:gpl2+)))

(define-public emacs-hg-histedit
  ;; From 2021-03-02.
  ;; No releases available.
  (let ((commit "a05149483b9c5f7848ece0ba6028c900595a6a25")
        (revision "0"))
    (package
      (name "emacs-hg-histedit")
      (version (git-version "0.0.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jojojames/hg-histedit")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "04zps0d4s99f5a8ahrpyf8b6qw0c1y7rd1bsaq9nc6m4qblsvwc8"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-with-editor))
      (home-page "https://github.com/jojojames/hg-histedit")
      (synopsis "Emacs interface to @command{hg histedit}")
      (description "This package provides an Emacs interface to
@command{hg histedit} for editing the commit history.")
      (license license:gpl3+))))

(define-public emacs-package-build
  (package
    (name "emacs-package-build")
    (version "3.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/melpa/package-build")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "02ngllr9lilpjsgdpk4628kdp0nwdlrkxj78bvi4jlhnbk4chh1c"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/melpa/package-build")
    (synopsis "Tools for assembling an Emacs package archive")
    (description "This package provides tools for assembling an @acronym{ELPA,
Emacs package archive}.")
    (license license:gpl3+)))

(define-public emacs-paredit
  (package
    (name "emacs-paredit")
    (version "26")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://mumble.net/~campbell/git/paredit.git")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1hwl2jhv1fhsdrspfhprq77n763i4zsj350q024ajy0m2kaql6ws"))))
    (build-system emacs-build-system)
    (home-page "http://mumble.net/~campbell/emacs/paredit/")
    (synopsis "Emacs minor mode for editing parentheses")
    (description
     "ParEdit (paredit.el) is a minor mode for performing structured editing
of S-expression data.  The typical example of this would be Lisp or Scheme
source code.

ParEdit helps keep parentheses balanced and adds many keys for moving
S-expressions and moving around in S-expressions.  Its behavior can be jarring
for those who may want transient periods of unbalanced parentheses, such as
when typing parentheses directly or commenting out code line by line.")
    (license license:gpl3+)))

(define-public emacs-puni
  ;; No tagged release upstream
  (let ((commit "28836e98d5566172b1a94d7b38290d07b49201b2")
        (revision "1"))
    (package
      (name "emacs-puni")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/AmaiKinono/puni")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1z35nzsqcp8q9nnka0d5gpiidl07qfqmd2giwnd3b3v7h3v1kwpz"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-with-editor))
      (home-page "https://github.com/AmaiKinono/puni")
      (synopsis "Emacs minor mode for structured editing")
      (description
       "Puni is an Emacs minor mode for structured editing: soft deletion,
expression navigating and manipulating.  It supports many major modes
out of the box.")
      (license license:gpl3+))))

(define-public emacs-spaceline-all-the-icons
  (package
    (name "emacs-spaceline-all-the-icons")
    (version "1.4.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/domtronn/spaceline-all-the-icons.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "186v71d8n1iy73drayyf57pyzlz973q74mazkyvb8w3fj8bb3llm"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-all-the-icons
           emacs-memoize
           emacs-spaceline))
    (home-page "https://github.com/domtronn/spaceline-all-the-icons.el")
    (synopsis
     "Theme for @code{emacs-spaceline} using @code{emacs-all-the-icons}")
    (description
     "This package is a theme for @code{emacs-spaceline} that recreates most
of the segments available in that package using icons from
@code{emacs-all-the-icons}.  Icon fonts allow for more tailored and detailed
information in the mode line.")
    (license license:expat)))

(define-public emacs-spongebob
  (let ((commit "ae8ae6ba0dc57b7357ba87ff0609d27c4a0a5f51")
        (revision "0"))
     (package
      (name "emacs-spongebob")
      (version (git-version "0" revision commit))
       (source
        (origin
          (method git-fetch)
          (uri (git-reference
               (url "https://gitlab.com/dustyweb/spongebob.el")
                (commit commit)))
          (file-name (git-file-name name version))
          (sha256
          (base32 "1agqpp078ij2irn0kb8bgqk0nd47fi20yfd9szn8kbqypfqalvgc"))))
       (build-system emacs-build-system)
      (home-page "https://gitlab.com/dustyweb/gauche")
      (synopsis "Memetically mock a region of text")
      (description "This package transforms text using @code{studlify-region}
and inserts a SpongeBob SquarePants ASCII art figure in the current
buffer.")
      (license license:gpl3+))))

(define-public emacs-project
  (package
    (name "emacs-project")
    (version "0.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/project-" version ".tar"))
       (sha256
        (base32 "15x6nbvyy592fwn36syxi9719sknvrm4bwnpyc16z9jn2xm62q3p"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-xref))
    (home-page "https://elpa.gnu.org/packages/project.html")
    (synopsis "Operations on the current project")
    (description
     "This library contains generic infrastructure for dealing with projects,
some utility functions, and commands using that infrastructure.")
    (license license:gpl3+)))

(define-public git-modes
  (package
    (name "emacs-git-modes")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magit/git-modes")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0aqz65pcqc35h5z4s606f48iqn87h5v9nj3cp6n9yjxa2v7w5hfk"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/magit/git-modes")
    (synopsis "Emacs major modes for Git configuration files")
    (description
     "This package provides Emacs major modes for editing various Git
configuration files, such as @file{.gitattributes}, @file{.gitignore}, and
@file{.git/config}.")
    (license license:gpl3+)))

(define-public emacs-with-editor
  (package
    (name "emacs-with-editor")
    (version "3.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magit/with-editor")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1d98hagpm6h5vgx80qlh3zrfcb6z000rfc707w9zzmh634dkg3xx"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'enter-lisp-directory
            (lambda _
              (chdir "lisp")))
          (add-before 'install 'make-info
            (lambda _
              (with-directory-excursion "../docs"
                (invoke "makeinfo" "--no-split"
                        "-o" "with-editor.info" "with-editor.texi")
                (install-file "with-editor.info" "../lisp")))))))
    (native-inputs
     (list texinfo))
    (propagated-inputs
     (list emacs-async))
    (home-page "https://github.com/magit/with-editor")
    (synopsis "Emacs library for using Emacsclient as EDITOR")
    (description
     "This package provides an Emacs library to use the Emacsclient as
@code{$EDITOR} of child processes, making sure they know how to call home.
For remote processes a substitute is provided, which communicates with Emacs
on stdout instead of using a socket as the Emacsclient does.")
    (license license:gpl3+)))

(define-public emacs-libgit
  (let ((commit "0ef8b13aef011a98b7da756e4f1ce3bb18e4d55a")
        (revision "1"))
    (package
      (name "emacs-libgit")
      (version (git-version "20200515" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/magit/libegit2")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0pnjr3bg6y6354dfjjxfj0g51swzgl1fncpprah75x4k94rd369f"))
                (patches (search-patches
                          ;; Submitted for inclusion upstream (see:
                          ;; https://github.com/magit/libegit2/pull/96).
                          "emacs-libgit-use-system-libgit2.patch"))
                (snippet
                 #~(begin
                     ;; bundled, use the one shipped with emacs instead
                     (delete-file "src/emacs-module.h")))))
      ;; Use the cmake-build-system as it provides support for cross builds.
      (build-system cmake-build-system)
      (arguments
       `(#:configure-flags '("-DUSE_SYSTEM_LIBGIT2=x")
         ;; Add the emacs-build-system byte compilation and install phases.
         #:imported-modules (,@%cmake-build-system-modules
                             (guix build emacs-build-system)
                             (guix build emacs-utils))
         #:modules ((guix build cmake-build-system)
                    ((guix build emacs-build-system) #:prefix emacs:)
                    (guix build emacs-utils)
                    (guix build utils))
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-source
             (lambda _
               ;; Use Emacs 28 unibyte strings.
               ;; XXX: This now breaks if linked against Emacs <= 26, probably
               ;; also 27.
               (substitute* "src/egit-blob.c"
                 (("make_string") "make_unibyte_string"))))
           (add-after 'unpack 'set-libgit--module-file
             (lambda* (#:key outputs #:allow-other-keys)
               (let ((out (assoc-ref outputs "out")))
                 (make-file-writable "libgit.el")
                 (emacs-substitute-variables "libgit.el"
                   ("libgit--module-file"
                    (string-append (emacs:elpa-directory out) "/libegit2.so"))))))
           (add-before 'install 'prepare-for-install
             (lambda _
               (let ((s "../source"))
                 (copy-file "libegit2.so" (string-append s "/libegit2.so"))
                 (chdir s))))
           (replace 'install
             (lambda* (#:key outputs #:allow-other-keys)
               (let ((install (assoc-ref emacs:%standard-phases 'install)))
                 (install #:outputs outputs
                          #:include (cons "\\.so$"
                                          emacs:%default-include)))))
           (add-after 'unpack 'emacs-add-install-to-native-load-path
             (assoc-ref emacs:%standard-phases 'add-install-to-native-load-path))
           (add-after 'install 'make-autoloads
             (assoc-ref emacs:%standard-phases 'make-autoloads))
           (add-after 'make-autoloads 'enable-autoloads-compilation
             (assoc-ref emacs:%standard-phases 'enable-autoloads-compilation))
           (add-after 'enable-autoloads-compilation 'patch-el-files
             (assoc-ref emacs:%standard-phases 'patch-el-files))
           (add-after 'patch-el-files 'emacs-build
             (assoc-ref emacs:%standard-phases 'build))
           (add-after 'emacs-build 'validate-compiled-autoloads
             (assoc-ref emacs:%standard-phases 'validate-compiled-autoloads)))))
      (native-inputs
       (list pkg-config emacs-no-x git-minimal))
      (inputs
       (list libgit2))
      (home-page "https://github.com/magit/libegit2")
      (synopsis "Emacs bindings for libgit2")
      (description "This is an experimental module written in C providing
libgit2 bindings for Emacs, intended to boost the performance of Magit.")
      ;; The LICENSE file says GPL v2+, but libgit.el says GPL v3+.
      (license license:gpl3+))))

(define-public emacs-magit
  (let ((commit "36059e0b881cb1465cb5ad0099e55e00845a8222")
        (revision "0"))
    (package
      (name "emacs-magit")
      (version (git-version "3.3.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/magit/magit")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "12r5z7jbqh74rb9763smh4sblswzwi41wybzcvsy0zhw2r8lpmzv"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #t
        #:test-command #~(list "make" "test")
        #:exclude #~(cons* "magit-libgit.el"
                           "magit-libgit-pkg.el"
                           %default-exclude)
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'build-info-manual
              (lambda _
                (invoke "make" "info")
                ;; Copy info files to the lisp directory, which acts as
                ;; the root of the project for the emacs-build-system.
                (for-each (lambda (f)
                            (install-file f "lisp"))
                          (find-files "Documentation" "\\.info$"))))
            (add-after 'build-info-manual 'set-magit-version
              (lambda _
                (make-file-writable "lisp/magit.el")
                (emacs-substitute-variables "lisp/magit.el"
                  ("magit-version" #$version))))
            (add-after 'set-magit-version 'patch-exec-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (for-each make-file-writable
                          (list "lisp/magit-git.el" "lisp/magit-sequence.el"))
                (emacs-substitute-variables "lisp/magit-git.el"
                  ("magit-git-executable"
                   (search-input-file inputs "/bin/git")))
                (emacs-substitute-variables "lisp/magit-sequence.el"
                  ("magit-perl-executable"
                   (search-input-file inputs "/bin/perl")))))
            (add-before 'check 'configure-git
              (lambda _
                ;; Otherwise some tests fail with error "unable to auto-detect
                ;; email address".
                (setenv "HOME" (getcwd))
                (invoke "git" "config" "--global" "user.name" "toto")
                (invoke "git" "config" "--global" "user.email"
                        "toto@toto.com")))
            (replace 'expand-load-path
              (lambda args
                (with-directory-excursion "lisp"
                  (apply (assoc-ref %standard-phases 'expand-load-path) args))))
            (replace 'install
              (lambda args
                (with-directory-excursion "lisp"
                  (apply (assoc-ref %standard-phases 'install) args)))))))
      (native-inputs
       (list texinfo))
      (inputs
       (list git perl))
      (propagated-inputs
       (list emacs-dash emacs-with-editor emacs-compat))
      (home-page "https://magit.vc/")
      (synopsis "Emacs interface for the Git version control system")
      (description
       "With Magit, you can inspect and modify your Git repositories
with Emacs.  You can review and commit the changes you have made to
the tracked files, for example, and you can browse the history of past
changes.  There is support for cherry picking, reverting, merging,
rebasing, and other common Git operations.")
      (license license:gpl3+))))

(define-public emacs-magit-svn
  (package
    (name "emacs-magit-svn")
    (version "2.2.3")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/magit/magit-svn")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1v1y4fir1plz4kj0cvkcd29wibli4dw7vp4fmbxq4df76d8iy8yd"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-dash emacs-with-editor emacs-magit))
    (home-page "https://github.com/magit/magit-svn")
    (synopsis "Git-SVN extension to Magit")
    (description
     "This package is an extension to Magit, the Git Emacs mode, providing
support for Git-SVN.")
    (license license:gpl3+)))

(define-public emacs-magit-popup
  (package
    (name "emacs-magit-popup")
    (version "2.13.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magit/magit-popup")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0znp6gx6vpcsybg774ab06mdgxb7sfk3gki1yp2qhkanav13i6q1"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'install 'make-info
           (lambda _
             (invoke "make" "info"))))))
    (native-inputs
     (list texinfo))
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://github.com/magit/magit-popup")
    (synopsis "Define prefix-infix-suffix command combos")
    (description
     "This library implements a generic interface for toggling switches and
setting options and then invoking an Emacs command which does something with
these arguments.  The prototypical use is for the command to call an external
process, passing on the arguments as command line arguments.")
    (license license:gpl3+)))

(define-public emacs-magit-annex
  (package
    (name "emacs-magit-annex")
    (version "1.8.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magit/magit-annex")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1amr2c08mq1nnn6k66mgz4rzyni4np7gxm96g4qyla2cbfbachgk"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-magit))
    (home-page "https://github.com/magit/magit-annex/")
    (synopsis "Git-annex support for Magit")
    (description
     "Magit-annex adds a few git-annex operations to the Magit interface.")
    (license license:gpl3+)))

(define-public emacs-mct
  (package
    (name "emacs-mct")
    (version "0.5.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://gitlab.com/protesilaos/mct")
                    (commit version)))
              (sha256
               (base32 "0vmlss546z0x8y26cxb1iis926pwjfv466gwm0clb8jfqkvr0qmh"))
              (file-name (git-file-name name version))))
    (native-inputs (list texinfo))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'makeinfo
            (lambda _
              (invoke "emacs"
                      "--batch"
                      "--eval=(require 'ox-texinfo)"
                      "--eval=(find-file \"README.org\")"
                      "--eval=(org-texinfo-export-to-info)")
              (install-file "mct.info" (string-append #$output "/share/info")))))))
    (home-page "https://protesilaos.com/emacs/mct")
    (synopsis "Enhancement of the default Emacs minibuffer completion UI")
    (description "Minibuffer and Completions in Tandem, also known as MCT, or
mct.el, is an Emacs package that enhances the default minibuffer and
@samp{*Completions*} buffer so that they work together as part of a unified
framework.  The idea is to make the presentation and overall functionality be
consistent with other popular, vertically aligned completion UIs while
leveraging built-in functionality.")
    (license (list license:gpl3+
                   license:fdl1.3+)))) ; GFDLv1.3+ for the manual

(define-public emacs-minions
  (package
    (name "emacs-minions")
    (version "0.3.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tarsius/minions")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1bzxxs8mxaihpjkbxgynhsi39lbbnij28grdc3sk9sq09j9752vw"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://github.com/tarsius/minions")
    (synopsis "Minor-mode menu for the mode line")
    (description
     "This package implements a menu that lists enabled minor-modes, as well
as commonly but not currently enabled minor-modes.  It can be used to toggle
local and global minor-modes, to access mode-specific menus, and to get help
about modes.

This menu is intended as a replacement for the incomplete yet wide list of
enabled minor-modes that is displayed in the mode line by default.  To use the
menu like this, enable Minions mode.

Alternatively the menu can be bound globally, for example:
@code{(global-set-key [S-down-mouse-3] 'minions-minor-modes-menu)}.")
    (license license:gpl3+)))

(define-public emacs-nano-modeline
  ;; No tagged release upstream.  The commit below matches latest version
  ;; bump.
  (let ((commit "61f62aa4716eae4fa89961955323d146e9791fca"))
    (package
      (name "emacs-nano-modeline")
      (version "0.7.2")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/rougier/nano-modeline")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1zwf3mp0z4vc36lg057vspk7dr8chcvhivm1l8q7p3m9b6xw8ask"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/rougier/nano-modeline")
      (synopsis "Emacs minor mode controlling mode line")
      (description "Nano modeline is a minor mode for Emacs that modifies the
mode line as @samp{[ status | name (primary) secondary ]}.  It can be
displayed at the bottom or at the top.")
      (license license:gpl3+))))

(define-public emacs-moody
  (package
    (name "emacs-moody")
    (version "0.7.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tarsius/moody")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "09yyihx6cpa724z6cj2rqspajwj325ipgpmckklpgq6l4h5xnwy4"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tarsius/moody")
    (synopsis "Tabs and ribbons for Emacs mode-line")
    (description
     "@code{emacs-moody} provides utilities for displaying elements of
the mode line as tabs and ribbons.  It also provides replacements for a few
built-in elements.  The biggest difference to similar packages is that
this one is much simpler and much more consistent.  When using this package,
then only the color of the mode line changes when a window becomes in-/active.")
    (license license:gpl3+)))

(define-public emacs-theme-magic
  ;; No tagged release upstream, but the commit below correspond to the 0.2.3
  ;; release.
  (let ((commit "844c4311bd26ebafd4b6a1d72ddcc65d87f074e3")
        (revision "0"))
    (package
      (name "emacs-theme-magic")
      (version "0.2.3")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jcaw/theme-magic")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "10gkg7jh1s1484gm66a87zr7x8vmv00s7gfd0w2pj47nqf98g8hz"))))
      (build-system emacs-build-system)
      (arguments
       (list
        ;; Include Pywal interaction scripts.
        #:include #~(cons "^python/" %default-include)
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-exec-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* '("theme-magic.el" "python/wal_change_colors.py")
                  (("\"python\"")
                   (string-append "\""
                                  (search-input-file inputs "/bin/python3")
                                  "\""))
                  (("\"wal\"")
                   (string-append "\""
                                  (search-input-file inputs "/bin/wal")
                                  "\""))))))))
      (inputs
       (list python python-pywal))
      (home-page "https://github.com/jcaw/theme-magic")
      (synopsis "Generate and apply color palettes based on your Emacs theme")
      (description
       "This package provides a command to extract the colors from your Emacs
theme and apply them to the rest of Linux with Pywal.  Pywal only applies your
theme to the current session.")
      (license license:gpl3+))))

(define-public emacs-vscode-dark-plus
  (package
    (name "emacs-vscode-dark-plus")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ianyepan/vscode-dark-plus-emacs-theme")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vcaqvhdgr91pr7kqskbscs8awm8jp6dkh79h6w36i9ipmc4l4hl"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ianyepan/vscode-dark-plus-emacs-theme")
    (synopsis "Emacs port of the default VS Code Dark+ theme")
    (description
     "This theme aims to be as identical as possible to the default Dark+
color scheme used by Visual Studio Code.")
    (license license:gpl3+)))

(define-public emacs-theme-sorcery
  (let ((revision "0")
        (commit "5a1c4445b9e6e09589a299a9962a6973272a0c2f"))
    (package
      (name "emacs-theme-sorcery")
      (version "1.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mtreca/emacs-theme-sorcery")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1b858049n6nw4qf60fmszjrhl80x7ssh32f7glj722kwy7404kdh"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-autothemer))
      (home-page "https://github.com/mtreca/emacs-theme-sorcery")
      (synopsis "Dark and low-contrast Emacs theme")
      (description "Sorcery is a dark and low-contrast Emacs theme inspired by
Apprentice and Sourcerer.")
      (license license:gpl3+))))

(define-public emacs-suneater-theme
  (package
    (name "emacs-suneater-theme")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~plattfot/suneater-theme")
             (commit version)))
       (sha256
        (base32
         "0nlam8f8ly86y7p2dn10y9ixnm7bhmigsx7si4cjynh6aiyczyds"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (home-page "https://git.sr.ht/~plattfot/suneater-theme")
    (synopsis "Minimalistic dark theme for Emacs")
    (description
     "Suneater is a dark, minimalistic Emacs theme.  It was based on Sunburst
theme but now takes more inspiration from the Nano theme.")
    (license license:gpl3+)))

(define-public emacs-treepy
  (package
    (name "emacs-treepy")
    (version "0.1.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/volrath/treepy.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0pmrpij80m5kgcr8bw36r8wllgppasw08vn3ghwvis9srpaq75cn"))))
    (build-system emacs-build-system)
    (home-page
     "https://github.com/volrath/treepy.el")
    (synopsis "Tree traversal tools")
    (description
     "Generic tools for recursive and iterative tree traversal based on
clojure.walk and clojure.zip respectively.")
    (license license:gpl3+)))

(define-public emacs-typing
  (let ((commit "a2ef25dde2d8eb91bd9c0c6164cb5208208647fa")
        (revision "0"))
    (package
      (name "emacs-typing")
      (version (git-version "1.1.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/kensanata/typing")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1dbh0srbf54lgd60ia79y9cfnq3kxlgw01qzdjs9mk3nfazzpgnv"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/kensanata/typing/")
      (synopsis "Emacs game where you have to type fast")
      (description "The Typing of Emacs is a game for Emacs that
forces you to type words correctly as fast as possible, otherwise
you will die.  The game builds the list of words from the active buffer.")
      (license license:gpl2+))))

(define-public emacs-graphql
  (package
    (name "emacs-graphql")
    (version "0.1.1")
    (source (origin
              (modules '((guix build utils)))
              ;; Remove examples file with references to external packages as
              ;; they do not exist at compilation time.
              (snippet
               '(begin (delete-file "examples.el")))
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/vermiculus/graphql.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0sp0skc1rnhi39szfbq1i99pdgd3bhn4c15cff05iqhjy2d4hniw"))))
    (build-system emacs-build-system)
    (home-page
     "https://github.com/vermiculus/graphql.el")
    (synopsis "GraphQL utilities")
    (description
     "GraphQL.el provides a generally-applicable domain-specific language for
creating and executing GraphQL queries against your favorite web services.
GraphQL is a data query language and runtime designed and used to request and
deliver data to mobile and web apps.")
    (license license:gpl3+)))

(define-public emacs-graphql-mode
  ;; No tagged commit.  No "Version" keyword either.
  (let ((commit "9bed568ec86242dbe30bdbab324aa0eb2cd9bf08")
        (revision "1"))
    (package
      (name "emacs-graphql-mode")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/davazp/graphql-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0x9y7qq6y0zg8ncamzvk68ccmdyzh7xsj0xs0ykyl20d5wdpplj4"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/davazp/graphql-mode")
      (synopsis "Emacs mode to edit GraphQL schema and queries")
      (description
       "This package implements a major mode to edit GraphQL schemas and
query.  The basic functionality includes syntax highlight and indentation.
Additionally, it is able to send GraphQL queries to an end-point URL.

Files with the @file{.graphql} and @file{.gql} extensions are
automatically opened with this mode.")
      (license license:gpl3+))))

(define-public emacs-ghq
  (package
    (name "emacs-ghq")
    (version "0.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rcoedo/emacs-ghq")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0rh2k93c3a0vl073a3s3a3h6gkw454v1lyd7y8l3pd24vw9hc628"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list ghq))
    (home-page "https://github.com/rcoedo/emacs-ghq")
    (synopsis "Emacs interface for @code{ghq} tool")
    (description
     "This package provides a set of functions wrapping @code{ghq}, a tool for
organizing remote Go repository clones.")
    (license license:gpl3+)))

(define-public emacs-ghub
  (package
    (name "emacs-ghub")
    (version "3.5.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magit/ghub")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1pw1rjrvvanlcxv3rb64s2p646zfaipp7h7v8djlrrnlgy6mwbqd"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'make-info
            (lambda _
              (invoke "make" "info")))
          (add-after 'make-info 'enter-lisp-directory
            (lambda _
              (chdir "lisp")))
          (add-after 'expand-load-path 'add-el-dir-to-emacs-load-path
            (lambda _
              (setenv "EMACSLOADPATH"
                      (string-append (getcwd)
                                     "/lisp:"
                                     (getenv "EMACSLOADPATH")))))
          (add-after 'install 'install-info
            (lambda _
              (let ((info (string-append #$output "/share/info")))
                (install-file "../docs/ghub.info" info)))))))
    (native-inputs
     (list texinfo))
    (propagated-inputs
     (list emacs-dash emacs-let-alist emacs-treepy))
    (home-page "https://github.com/magit/ghub")
    (synopsis "Emacs client libraries for the APIs of various Git forges")
    (description
     "Ghub provides basic support for using the APIs of various Git forges from
Emacs packages.  It supports the REST APIs of Github, Github GraphQL, Gitlab,
Gitea, Gogs and Bitbucket.  It abstracts access to API resources using only a
handful of functions that are not resource-specific.")
    (license license:gpl3+)))

(define-public emacs-typit
  (package
    (name "emacs-typit")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mrkkrp/typit")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0djxmni5mfc9wzm0zg7fsd7138ic5qznbmqd5jyrk4mpf0li8nhy"))))
    (build-system emacs-build-system)
    (arguments
     '(#:include (cons "^dict/" %default-include)))
    (propagated-inputs
     (list emacs-f emacs-mmt))
    (home-page "https://github.com/mrkkrp/typit")
    (synopsis "Typing game for Emacs with two difficulties")
    (description "Emacs Typit is a typing game for Emacs.  Words that are
picked randomly from the most frequent words in language you're practicing,
until time is up.")
    (license license:gpl3+)))

(define-public emacs-scribble-mode
  (let ((commit "217945d54de5e4bb207033f2116baa28f5c5ecf2")
        (revision "2"))
    (package
      (name "emacs-scribble-mode")
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/emacs-pe/scribble-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1s5ccw1a5ack01wd94ywfcrar9j98agchwdh30q7iyxr0d2z4sii"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/emacs-pe/scribble-mode")
      (synopsis "Emacs mode for editing the Scribble documentation syntax")
      (description
       "This package provides basic syntax highlighting and editing support
for editing Racket's Scribble documentation syntax in Emacs.")
      (license license:gpl3+))))

(define-public emacs-shroud
  (package
    (name "emacs-shroud")
    (version "1.105")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.savannah.gnu.org/git/emacs-shroud.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0q2pb3w8s833fjhkzicciw2php4lsnismad1dnwgp2lcway757ra"))))
    (build-system gnu-build-system)
    (arguments
     `(#:modules ((guix build gnu-build-system)
                  ((guix build emacs-build-system) #:prefix emacs:)
                  (guix build utils))
       #:imported-modules (,@%gnu-build-system-modules
                           (guix build emacs-build-system)
                           (guix build emacs-utils))
       #:configure-flags (list (string-append "--with-lispdir="
                                              (emacs:elpa-directory %output)))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'expand-load-path
           (assoc-ref emacs:%standard-phases 'expand-load-path)))))
    (native-inputs
     (list autoconf automake texinfo perl emacs-minimal))
    (propagated-inputs
     (list emacs-bui
           emacs-dash
           emacs-f
           emacs-s
           gnupg
           shroud))
    (home-page "https://www.nongnu.org/emacs-shroud")
    (synopsis "Emacs interface to the Shroud password manager")
    (description
     "This package provides an Emacs interface to the Shroud password manager,
using the Buffers User Interface library.  You can view, copy, and edit secrets
from within Emacs.")
    (license license:gpl3+)))

(define-public emacs-solidity
  ;; This commit fixes a spacing issue and adds new keywords.
  (let ((commit "d166a86b83907e0cfd64c191e9dfce4b44a9843e")
        (revision "0"))
    (package
      (name "emacs-solidity")
      (version (git-version "0.1.10" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ethereum/emacs-solidity")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19hgvsrqch2vp49ag6m76bi5qxd20v95z0ib838rib9as15b17wq"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-company emacs-flycheck))
      (home-page "https://github.com/ethereum/emacs-solidity")
      (synopsis "Major mode for writing Solidity code")
      (description
       "This is a simple language mode for the Solidity language.  It is
a constant work in progress as the language itself also progresses.")
      (license license:gpl3+))))

(define-public emacs-unpackaged-el
  (let ((commit "746801a677ada6cd6fa076e423aa0953779f3fad")
        (revision "3"))
    (package
      (name "emacs-unpackaged-el")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alphapapa/unpackaged.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0jvb2ci0h0lj368qhbff3pzkxj3nhlligpbkjzi525k9rkjgm7l8"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash emacs-org emacs-s emacs-hydra emacs-use-package))
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'require-hydra
              (lambda _
                (substitute* "unpackaged.el"
                  ((";;; Code:") ";;; Code:\n(require 'hydra)")))))))
      (home-page "https://github.com/alphapapa/unpackaged.el")
      (synopsis "Useful snippets of Emacs Lisp code")
      (description "This package provides Emacs Lisp utilities for a variety
of tasks, including version control, task management, and regex-based
replacement.")
      (license license:gpl3+))))

(define-public emacs-haskell-mode
  (let ((revision "0")
        (commit "5a9f8072c7b9168f0a8409adf9d62a3e4ad4ea3d"))
    (package
      (name "emacs-haskell-mode")
      (version (git-version "17.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/haskell/haskell-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0np1wrwdq7b9hpqpl9liampacnkx6diphyk8h2sbz2mfn9qr7pxs"))))
      (propagated-inputs
       (list emacs-dash))
      (native-inputs
       (list emacs-minimal emacs-el-search emacs-stream texinfo))
      (build-system gnu-build-system)
      (arguments
       (list
        #:make-flags #~(list
                        (string-append "EMACS=" #$emacs-minimal "/bin/emacs"))
        #:modules `((ice-9 match)
                    (srfi srfi-26)
                    ((guix build emacs-build-system) #:prefix emacs:)
                    ,@%gnu-build-system-modules)
        #:imported-modules `(,@%gnu-build-system-modules
                             (guix build emacs-build-system)
                             (guix build emacs-utils))
        #:phases
        #~(modify-phases %standard-phases
            (delete 'configure)
            (add-before 'build 'pre-build
              (lambda* (#:key inputs #:allow-other-keys)
                (define (el-dir store-dir)
                  (match (find-files store-dir "\\.el$")
                    ((f1 f2 ...) (dirname f1))
                    (_ "")))

                (let ((sh (search-input-file inputs "/bin/sh")))
                  (define emacs-prefix? (cut string-prefix? "emacs-" <>))

                  (setenv "SHELL" "sh")
                  (setenv "EMACSLOADPATH"
                          (string-concatenate
                           (map (match-lambda
                                  (((? emacs-prefix? name) . dir)
                                   (string-append (el-dir dir) ":"))
                                  (_ ""))
                                inputs)))
                  (substitute* (find-files "." "\\.el") (("/bin/sh") sh)))))
            (add-before 'check 'delete-failing-tests
              ;; XXX: these tests require GHC executable, which would be a big
              ;; native input.
              (lambda _
                (with-directory-excursion "tests"
                  ;; File `haskell-indent-tests.el' fails with
                  ;; `haskell-indent-put-region-in-literate-2'
                  ;; on Emacs 27.1+
                  ;; XXX: https://github.com/haskell/haskell-mode/issues/1714
                  (for-each delete-file
                            '("haskell-indent-tests.el"
                              "haskell-customize-tests.el"
                              "inferior-haskell-tests.el"))

                  ;; requires many external tools (e.g. git, hasktags)
                  (substitute* "haskell-mode-tests.el"
                    (("\\(ert-deftest haskell-generate-tags.*" all)
                     (string-append all " (skip-unless nil)"))))))
            (replace 'install
              (lambda* (#:key outputs #:allow-other-keys)
                (let* ((out (assoc-ref outputs "out"))
                       (el-dir (emacs:elpa-directory out))
                       (doc (string-append
                             out "/share/doc/haskell-mode-" #$version))
                       (info (string-append out "/share/info")))
                  (define (copy-to-dir dir files)
                    (for-each (lambda (f)
                                (install-file f dir))
                              files))

                  (with-directory-excursion "doc"
                    (invoke "makeinfo" "haskell-mode.texi")
                    (install-file "haskell-mode.info" info))
                  (copy-to-dir doc '("CONTRIBUTING.md" "NEWS" "README.md"))
                  (copy-to-dir el-dir (find-files "." "\\.elc?"))))))))
      (home-page "https://github.com/haskell/haskell-mode")
      (synopsis "Haskell mode for Emacs")
      (description
       "This is an Emacs mode for editing, debugging and developing Haskell
programs.")
      (license license:gpl3+))))

(define-public emacs-dante
  (package
    (name "emacs-dante")
    (version "1.7")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/jyp/dante")
                    (commit version)))
              (sha256
               (base32
                "0q7hackvaplh1f645ngd76f2ls5mvg93xicr3rkxr07hd36yihag"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-company
           emacs-dash
           emacs-f
           emacs-flycheck
           emacs-haskell-mode
           emacs-lcr
           emacs-s))
    (home-page "https://github.com/jyp/dante")
    (synopsis "Minor mode for interactive Haskell")
    (description
     "This package provides a minor mode for Haskell development that
supports type hints, definition-jumping, completion, and more.")
    (license license:gpl3+)))

(define-public emacs-flycheck
  (package
    (name "emacs-flycheck")
    (version "32")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/flycheck/flycheck/")
             (commit version)))
       (sha256
        (base32 "0dx6wqxz1yfp4shas4yn6abqc8bz21ks3glcyzznm3xspjdaq21s"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (native-inputs
     (list emacs-shut-up))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'change-flycheck-version
            (lambda _
              (substitute* "flycheck.el"
                (("\\(pkg-info-version-info 'flycheck\\)")
                 (string-append "\"" #$version "\""))))))
      ;; TODO: many failing tests
      #:tests? #f
      #:test-command
      #~(list "emacs" "-Q" "--batch"
              "-L" "."
              "--load" "test/flycheck-test"
              "--load" "test/run.el"
              "-f" "flycheck-run-tests-main")))
    (home-page "https://www.flycheck.org")
    (synopsis "On-the-fly syntax checking")
    (description
     "This package provides on-the-fly syntax checking for GNU Emacs.  It is a
replacement for the older Flymake extension which is part of GNU Emacs, with
many improvements and additional features.

Flycheck provides fully-automatic, fail-safe, on-the-fly background syntax
checking for over 30 programming and markup languages with more than 70
different tools.  It highlights errors and warnings inline in the buffer, and
provides an optional IDE-like error list.")
    (license license:gpl3+)))                     ;+GFDLv1.3+ for the manual

(define-public emacs-flymake-collection
  (package
    (name "emacs-flymake-collection")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mohkale/flymake-collection")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1dxy1bljvd8rar0pivdrfahmgnnjlxm0mlks8mzw3l7k7b7jar6k"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'chdir
            (lambda _
              (chdir "src")))
          (add-after 'chdir 'move-checkers
            (lambda _
              ;; Move checkers to the top level, which is in the
              ;; EMACSLOADPATH.
              (for-each (lambda (f)
                          (rename-file f (basename f)))
                        (find-files "./checkers" ".*\\.el$")))))))
    (home-page "https://github.com/mohkale/flymake-collection/")
    (synopsis "Collection of checkers for Flymake")
    (description
     "This package provides a comprehensive list of diagnostic-functions for
use with Flymake, give users the tools to easily define new syntax checkers
and help selectively enable or disable diagnostic functions based on major
modes.")
    (license license:expat)))

(define-public emacs-flymake-flycheck
  (package
    (name "emacs-flymake-flycheck")
    (version "20210404.2128")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://melpa.org/packages/flymake-flycheck-"
                           version ".el"))
       (sha256
        (base32 "1m59ahd5gjlfwf328labwdlpcxh8ywywkwgfrlsy5jyxfc9ss4nv"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-flycheck))
    (home-page "https://github.com/purcell/flymake-flycheck")
    (synopsis "Use Flycheck checkers as Flymake backends")
    (description
     "This package provides support for running any Flycheck checker as a
Flymake diagnostic backend.  The effect is that Flymake will control when the
checker runs, and Flymake will receive its errors.")
    (license license:gpl3+)))

(define-public emacs-flymake-quickdef
  ;; This particular commit includes bug fixes on top of 1.0.0 release.
  (let ((version "1.0.0")
        (revision "0")
        (commit "150c5839768a3d32f988f9dc08052978a68f2ad7"))
    (package
      (name "emacs-flymake-quickdef")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/karlotness/flymake-quickdef")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19gfd539l97j8xbrq1fw83b54mxbcamlz9m896088d3p01zf8b0g"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/karlotness/flymake-quickdef")
      (synopsis "Quickly define a new Flymake backend")
      (description
       "This package mainly defines a macro which helps remove some of the
boilerplate code from defining new Flymake backend functions.")
      (license license:gpl3+))))

(define-public emacs-flymake-kondor
  (package
    (name "emacs-flymake-kondor")
    (version "0.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/turbo-cafe/flymake-kondor")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vcl1q07faqqmrryyia36hbgf78g3cs51pbi0bx41yzz779ribvk"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/turbo-cafe/flymake-kondor")
    (synopsis "Linter with clj-kondo")
    (description "This package adds Clojure syntax checker clj-kondo.")
    (license license:gpl3+)))

(define-public emacs-flymake-shellcheck
  ;; No tag, version grabbed from source .el file.
  (let ((commit "ac534e9ef15c82ac86ae65fe5004d29dbc8c92c7")
        (revision "1"))
    (package
      (name "emacs-flymake-shellcheck")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/federicotdn/flymake-shellcheck")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "04yfb4sy41spjzk9mhm4gy0h8vnjx09p2g6nm1yzgd9a5ph9sqgl"))))
      (build-system emacs-build-system)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'substitute-shellcheck-path
             (lambda* (#:key inputs #:allow-other-keys)
               (make-file-writable "flymake-shellcheck.el")
               (emacs-substitute-sexps "flymake-shellcheck.el"
                 ("defcustom flymake-shellcheck-path"
                  `(or (executable-find "shellcheck")
                       ,(string-append (assoc-ref inputs "shellcheck")
                                       "/bin/shellcheck")))))))))
      (inputs
       (list shellcheck))
      (home-page "https://github.com/federicotdn/flymake-shellcheck")
      (synopsis "Flymake backend for Bash/Sh powered by ShellCheck")
      (description
       "This package provides a backend for Flymake to use the
tool ShellCheck for static analyzing @command{bash} and @command{sh}
scripts.")
      (license license:gpl3+))))

(define-public emacs-a
  (package
    (name "emacs-a")
    (version "1.0.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/plexus/a.el")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32 "0zkv4xvw1jdsfxqqkxskl2l380gfs13n86hj4hhzrqf0sb6aymws"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/plexus/a.el/")
    (synopsis
     "Emacs library for dealing with association lists and hash tables")
    (description "@code{emacs-a} provides Emacs Lisp functions for dealing
with associative structures in a uniform and functional way.  These functions
can take association lists, hash tables, and in some cases vectors (where the
index is considered the key).")
    (license license:gpl3+)))

(define-public emacs-ace-jump-mode
  (package
    (name "emacs-ace-jump-mode")
    (version "2.0")
    (home-page "https://github.com/winterTTr/ace-jump-mode")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit (string-append "v" version))))
              (sha256
               (base32
                "1bwvzh056ls2v7y26a0s4j5mj582dmds04lx4x6iqihs04ss74bb"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (synopsis "Cursor location minor mode for fast navigation")
    (description "Ace-jump-mode is a fast/direct cursor location minor
mode.  It creates an N-Branch search tree internally and marks all
the possible position with predefined keys in within the whole Emacs
view.  This allows you to move to the character, word, or line almost
directly.")
    (license license:gpl3+)))

(define-public emacs-ahg
  ;; No tags; commit from 2021-04-12.
  (let ((commit "77bc2a628df006dcd2dc359ac12acdf8091a1356")
        (revision "0"))
    (package
      (name "emacs-ahg")
      (version (git-version "1.0.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://bitbucket.org/agriggio/ahg")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1wmvz9d40aznqh2y078v8k7n3l66m48vnf873vifi8rwg6158kqh"))))
      (build-system emacs-build-system)
      (home-page "https://bitbucket.org/agriggio/ahg")
      (synopsis "Emacs front-end for the Mercurial SCM")
      (description
       "This package provides a simple Emacs front-end for the Mercurial
Distributed @acronym{Source Control Management, SCM} system.")
      (license license:gpl3+))))

(define-public emacs-alarm-clock
  (package
    (name "emacs-alarm-clock")
    (version "1.0.3")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/wlemuel/alarm-clock")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "02gr5scf50js00xa1chvd0j7agr8bys5madzk96fwg0s4gfdmyqa"))))
    (build-system emacs-build-system)
    (arguments
     (list #:include #~(cons "alarm.mp3" %default-include)
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'configure
                 (lambda* (#:key inputs #:allow-other-keys)
                   (let ((mpg123 (search-input-file inputs "/bin/mpg123"))
                         (notify-send
                          (search-input-file inputs "/bin/notify-send")))
                     (substitute* "alarm-clock.el"
                       (("\"mpg123\"") (string-append "\"" mpg123 "\""))
                       (("notify-send") notify-send))))))))
    (inputs
     (list libnotify mpg123))
    (propagated-inputs
     (list emacs-f))
    (home-page "https://github.com/wlemuel/alarm-clock")
    (synopsis "Alarm clock for Emacs")
    (description "Alarm Clock provides an alarm clock for Emacs.")
    (license license:gpl3+)))

(define-public emacs-anaphora
  (package
    (name "emacs-anaphora")
    (version "1.0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rolandwalker/anaphora")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "11fgiy029sqz7nvdm7dcal95lacryz9zql0x5h05z48nrrcl4bib"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rolandwalker/anaphora/")
    (synopsis "Anaphoric expressions for Emacs Lisp")
    (description "@code{emacs-anaphora} implements anaphoric expressions for
Emacs Lisp.

Anaphoric expressions implicitly create one or more temporary variables which
can be referred to during the expression.  This technique can improve clarity
in certain cases.  It also enables recursion for anonymous functions.")
    (license license:public-domain)))

(define-public emacs-xah-fly-keys
  (package
    (name "emacs-xah-fly-keys")
    (version "17.13.20220526011611")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/xahlee/xah-fly-keys")
                    (commit "b1b1ea62c3f1a329376d9125592175cf2027ebc7")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1gv8d9zgmhzjg6zk2a7y76dz30a3l91xb1p15vldka95faz197wn"))))
    (build-system emacs-build-system)
    (home-page "http://xahlee.info/emacs/misc/ergoemacs_vi_mode.html")
    (synopsis "Modal keybinding system for Emacs, based on command frequency and
ergonomics")
    (description "xah-fly-keys.el is a modal editing mode for Emacs, like Vi,
but the design of key/command choice is based on command frequency statistics
and ease-of-key score.  Most frequently used commands have most easy keys.")
    (license license:gpl3)))

(define-public emacs-xr
  (package
    (name "emacs-xr")
    (version "1.23")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/xr-" version ".tar"))
       (sha256
        (base32 "1nz3fhd4qx8fxib78y41jvnzn27lf7mlvpkz565d5zc9q4mr300z"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/xr.html")
    (synopsis "Convert string regexp to rx notation")
    (description
     "This is an inverse companion to the @code{rx} package for translating
regexps in string form to the @code{rx} notation.  Its chief uses are:

@itemize
@item Migrating existing code to @code{rx} form, for better readability and
maintainability
@item Understanding complex regexp strings and finding errors in them
@end itemize

In addition to Emacs regexps, this package can also parse and troubleshoot
skip set strings, which are arguments to @code{skip-chars-forward} and
@code{skip-chars-backward}.")
    (license license:gpl3+)))

(define-public emacs-ample-regexps
  (let ((commit "153969ce547afe410b8986f01c9ed4087c9cd20b")
        (revision "2"))
    (package
      (name "emacs-ample-regexps")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/immerrr/ample-regexps.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0dkp7bcd7h2ds40wyszy11nmh7c2jxrwy04ayz7pbxh53ir7s2k0"))))
      (build-system emacs-build-system)
      (native-inputs
       (list emacs-ert-runner))
      (arguments
       `(#:tests? #t
         #:test-command '("ert-runner" "-l" "ample-regexps")))
      (home-page "https://github.com/immerrr/ample-regexps.el")
      (synopsis "Compose and reuse Emacs regexps")
      (description
       "This package allows common parts of regexps to be easily picked out
and reused.")
      (license license:gpl3+))))

(define-public emacs-airline-themes
  (package
    (name "emacs-airline-themes")
    (version "1.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/AnthonyDiGirolamo/airline-themes")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jx17g8a6pxkw4zlx3fwhqgxfzcf3019k8fklykamfrkharzsc2l"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-powerline))
    (home-page "https://github.com/AnthonyDiGirolamo/airline-themes")
    (synopsis "Vim-airline themes for Emacs Powerline")
    (description
     "This is a port of the themes in Vim-airline to Emacs Powerline.")
    (license license:expat)))

(define-public emacs-ample-theme
  (let ((commit "536966adf882446165a1f756830028faa792c7a9")
        (revision "1"))
    (package
      (name "emacs-ample-theme")
      (version (git-version "0.0.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jordonbiondo/ample-theme")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "07bpv8dag40qjnm5000pgzpazj4whfxf93x2vprz26sg3mjfx0nf"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/jordonbiondo/ample-theme")
      (synopsis "Theme for Emacs providing dark, light, and flat versions")
      (description "Ample themes is a collection of three themes sharing a
similar pallet with a light, dark and flat versions with a focus on being easy
on the eyes during night and day.  They only support GUI and 256 colour
terminals.")
      (license license:gpl3+))))

(define-public emacs-reformatter
  (package
    (name "emacs-reformatter")
    (version "0.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/reformatter.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1dfn7c3gpavpiwd73v2pasd8wd8b62dczhg9iv1cgh8vaqlsf92x"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/reformatter.el")
    (synopsis "Define commands which run reformatters on the current buffer")
    (description
     "This library lets elisp authors easily define an idiomatic command to
reformat the current buffer using a command-line program, together with an
optional minor mode which can apply this command automatically on save.")
    (license license:gpl3+)))

(define-public emacs-relative-buffers
  (let ((release "0.0.1")
        (revision "0")
        (commit "9762fe268e9ff150dcec2e2e45d862d82d5c4008"))
    (package
      (name "emacs-relative-buffers")
      (version (git-version release revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsattic/relative-buffers")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0fzhwbpyndwrmxip9zlcwkrr675l5pzwcygi45hv7w1hn39w0hxp"))
         (snippet
          '(begin
             ;; Delete the Cask test runners.
             (for-each delete-file '("Cask" "test/test-helper.el"))))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #t
        #:test-command #~(list "ert-runner")))
      (native-inputs
       (list emacs-ert-runner))
      (propagated-inputs
       (list emacs-dash emacs-f emacs-s))
      (home-page "https://github.com/emacsattic/relative-buffers")
      (synopsis "Minor mode to rename buffers by project structure")
      (description
       "This package provides a minor mode for renaming buffers according to
project structure.  For Python buffers, that will be the whole module name.
For temporary files and directories, that will be the relative path from the
project root.")
      (license license:gpl3+))))

(define-public emacs-relint
  (package
    (name "emacs-relint")
    (version "1.20")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "relint-" version ".tar"))
       (sha256
        (base32 "0r20dim2r4a4bv0fmgbnq3graa7hhlai55h9qyknapqbr2j1v1h7"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-xr))
    (home-page "https://github.com/mattiase/relint")
    (synopsis "Elisp regexp mistake finder")
    (description
     "Relint (regular expression lint) scans Elisp files for mistakes in
regexps, including deprecated syntax and bad practice.  It also checks the
regexp-like arguments to @code{skip-chars-forward} and
@code{skip-chars-backward}.")
    (license license:gpl3+)))

(define-public emacs-bug-hunter
  (let ((commit "b88d981afa9154b236c5a3a83b50d5889d46c6a7")
        (revision "1"))
    (package
      (name "emacs-bug-hunter")
      (version (git-version "1.3.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Malabarba/elisp-bug-hunter")
               (commit commit)))
         (file-name (git-file-name name commit))
         (sha256
          (base32
           "134fj493sdn93pyyac8rpz1fzahzmayvphsrmqp3wvgysmfqm38l"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/Malabarba/elisp-bug-hunter")
      (synopsis "Hunt down errors by bisecting elisp files")
      (description
       "The Bug Hunter is an Emacs library that finds the source of an error
or unexpected behavior inside an elisp configuration file (typically
@file{init.el} or @file{.emacs}).")
      (license license:gpl3+))))


;;;
;;; Web browsing.
;;;

(define-public emacs-w3m
  ;; Emacs-w3m follows a "rolling release" model.
  (package
    (name "emacs-w3m")
    (version "20220508.2259")
    (source (origin
              ;; "Officially" this is still on cvs.namazu.org, but that repo
              ;; seems to be unreachable.
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacs-w3m/emacs-w3m.git")
                    (commit "bbcebbe20ebfa807a3e4beaadf40ce6f4be213e7")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0y892n8jaxzyxi1fgyklc7zfh57ibp4yyywmif69dm28hykj6lmz"))))
    (build-system gnu-build-system)
    (native-inputs (list autoconf texinfo emacs-minimal))
    (inputs (list w3m imagemagick))
    (arguments
     (list
      #:modules '((guix build gnu-build-system)
                  ((guix build emacs-build-system) #:prefix emacs:)
                  (guix build utils)
                  (guix build emacs-utils))
      #:imported-modules `(,@%gnu-build-system-modules
                           (guix build emacs-build-system)
                           (guix build emacs-utils))
      #:configure-flags
      #~(list (string-append "--with-lispdir=" (emacs:elpa-directory #$output))
              (string-append "--with-icondir="
                             #$output "/share/images/emacs-w3m")
              ;; Leave .el files uncompressed, otherwise GC can't
              ;; identify run-time dependencies.  See
              ;; <http://lists.gnu.org/archive/html/guix-devel/2015-12/msg00208.html>
              "--without-compress-install")
      #:tests? #f                       ; no check target
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'autoconf
            (lambda _
              (invoke "autoconf")))
          (add-before 'configure 'support-emacs!
            (lambda _
              ;; For some reason 'AC_PATH_EMACS' thinks that 'Emacs 26' is
              ;; unsupported.
              (substitute* "configure"
                (("EMACS_FLAVOR=unsupported") "EMACS_FLAVOR=emacs"))))
          (add-before 'build 'patch-exec-paths
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (let ((out (assoc-ref outputs "out")))
                (make-file-writable "w3m.el")
                (emacs-substitute-variables "w3m.el"
                  ("w3m-command" (search-input-file inputs "/bin/w3m"))
                  ("w3m-touch-command" (search-input-file inputs "/bin/touch"))
                  ("w3m-icon-directory"
                   (string-append out "/share/images/emacs-w3m")))
                (make-file-writable "w3m-image.el")
                (emacs-substitute-variables "w3m-image.el"
                  ("w3m-imagick-convert-program"
                   (search-input-file inputs "/bin/convert"))
                  ("w3m-imagick-identify-program"
                   (search-input-file inputs "/bin/identify"))))))
          (replace 'install
            (lambda* (#:key outputs #:allow-other-keys)
              (invoke "make" "install" "install-icons")
              (with-directory-excursion
                  (emacs:elpa-directory (assoc-ref outputs "out"))
                (for-each delete-file '("ChangeLog" "ChangeLog.1"))
                (symlink "w3m-load.el" "w3m-autoloads.el")))))))
    (home-page "http://emacs-w3m.namazu.org/")
    (synopsis "Simple Web browser for Emacs based on w3m")
    (description
     "Emacs-w3m is an emacs interface for the w3m web browser.")
    (license license:gpl2+)))

(define-public emacs-wget
  (package
    (name "emacs-wget")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "mirror://debian/pool/main/w/wget-el/wget-el_"
                           version ".orig.tar.gz"))
       (sha256
        (base32 "10byvyv9dk0ib55gfqm7bcpxmx2qbih1jd03gmihrppr2mn52nff"))))
    (build-system emacs-build-system)
    (inputs (list wget))
    (native-inputs
     (list emacs-minimal))
    (arguments
     `(#:tests? #f                      ;no check target
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-exec-paths
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (emacs-substitute-variables "wget.el"
               ("wget-command" (search-input-file inputs "/bin/wget"))))))))
    (home-page "https://www.emacswiki.org/emacs/EmacsWget")
    (synopsis "Simple file downloader for Emacs based on wget")
    (description
     "Emacs-wget is an emacs interface for the wget file downloader.")
    (license license:gpl2+)))

(define-public emacs-eww-lnum
  (package
    (name "emacs-eww-lnum")
    (version "1.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/m00natic/eww-lnum")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0gs6bi3s2sszc6v2b26929azmn5513kvyin99n4d0ark1jdbjmv2"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/m00natic/eww-lnum")
    (synopsis "Conkeror-like functionality for Eww")
    (description "This is extension to the Emacs browser Eww that adds
Conkeror-like functionality.  In short, currently visible links, forms,
buttons are temporarily assigned numbers with which the former can be
immediately activated.  Also filtering can be applied so selection can be
incrementally confined in Isearch manner.")
    (license license:gpl3+)))



;;;
;;; Multimedia.
;;;

(define emacs-emms-print-metadata
  (package
    (name "emacs-emms-print-metadata")
    (version "12")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "emms-" version ".tar"))
       (sha256
        (base32 "048ijrpw6s4k7zr78fzc3ksjjri6mnyp6c47h5lp5nw5gvm4np7a"))))
    (build-system gnu-build-system)
    (arguments
     (list
      #:make-flags #~(list "emms-print-metadata")
      #:tests? #f                       ; No tests.
      #:phases
      #~(modify-phases %standard-phases
          (delete 'configure)
          (replace 'install
            (lambda _
              (install-file "src/emms-print-metadata"
                            (string-append #$output "/bin"))
              (install-file "emms-print-metadata.1"
                            (string-append #$output "/share/man/man1")))))))
    (inputs
     (list taglib))
    (home-page "https://www.gnu.org/software/emms/")
    (synopsis "The Emacs Multimedia System")
    (description
     "EMMS is the Emacs Multimedia System.  It is a small front-end which
can control one of the supported external players.  Thus, it supports
whatever formats are supported by your music player.  It also
supports tagging and playlist management, all behind a clean and
light user interface.")
    (license license:gpl3+)))

(define-public emacs-emms
  (package
    (inherit emacs-emms-print-metadata)
    (name "emacs-emms")
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-external-programs
           ;; Specify the absolute file names of the various programs
           ;; so that everything works out-of-the-box. (tinytag missing)
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((amixer (search-input-file inputs "/bin/amixer"))
                   (emms-print-metadata
                    (search-input-file inputs "/bin/emms-print-metadata"))
                   (exiftool (search-input-file inputs "/bin/exiftool"))
                   (metaflac (search-input-file inputs "/bin/metaflac"))
                   (mp3info (search-input-file inputs "/bin/mp3info"))
                   (mpg321 (search-input-file inputs "/bin/mpg321"))
                   (mid3v2 (search-input-file inputs "/bin/mid3v2"))
                   (ogg123 (search-input-file inputs "/bin/ogg123"))
                   (ogginfo (search-input-file inputs "/bin/ogginfo"))
                   (opusinfo (search-input-file inputs "/bin/opusinfo"))
                   (vorbiscomment (search-input-file inputs "/bin/vorbiscomment")))
               (emacs-substitute-variables "emms-player-mpg321-remote.el"
                 ("emms-player-mpg321-remote-command"
                  (string-append mpg321 "/bin/mpg321")))
               (substitute* "emms-player-simple.el"
                 (("\"ogg123\"") (string-append "\"" ogg123 "\"")))
               (substitute* "emms-player-simple.el"
                 (("\"mpg321\"") (string-append "\"" mpg321 "\"")))
               (emacs-substitute-variables "emms-info-ogginfo.el"
                 ("emms-info-ogginfo-program-name" ogginfo))
               (emacs-substitute-variables "emms-info-opusinfo.el"
                 ("emms-info-opusinfo-program-name" opusinfo))
               (emacs-substitute-variables "emms-info-libtag.el"
                 ("emms-info-libtag-program-name" emms-print-metadata))
               (emacs-substitute-variables "emms-info-mp3info.el"
                 ("emms-info-mp3info-program-name" mp3info))
               (emacs-substitute-variables "emms-info-metaflac.el"
                 ("emms-info-metaflac-program-name" metaflac))
               (emacs-substitute-variables "emms-source-file.el"
                 ("emms-source-file-gnu-find" (which "find")))
               (substitute* "emms-volume-amixer.el"
                 (("\"amixer\"") (string-append "\"" amixer "\"")))
               (substitute* "emms-tag-editor.el"
                 (("\"mid3v2\"") (string-append "\"" mid3v2 "\""))
                 (("\"vorbiscomment\"")
                  (string-append "\"" vorbiscomment "\"")))
               (substitute* "emms-info-exiftool.el"
                 (("\"exiftool\"") (string-append "\"" exiftool "\"")))))))))
    (inputs
     (list emacs-emms-print-metadata
           alsa-utils
           flac                         ;for metaflac
           vorbis-tools
           mpg321
           mp3info
           python-mutagen
           perl-image-exiftool
           opus-tools))))

(define-public emacs-emms-mode-line-cycle
  (package
    (name "emacs-emms-mode-line-cycle")
    (version "0.2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/momomo5717/emms-mode-line-cycle")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0q80f0plch6k4lhs8c9qm3mfycfbp3kn5sjrk9zxgxwnn901y9mp"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-emms))
    (home-page "https://github.com/momomo5717/emms-mode-line-cycle")
    (synopsis "Display the EMMS mode line as a ticker")
    (description
     "This is a minor mode for updating the EMMS mode-line string cyclically
within a specified width.  It is useful for displaying long track titles.")
    (license license:gpl3+)))

(define-public emacs-emprise
  (package
    (name "emacs-emprise")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~plattfot/emprise")
             (commit (string-append "v" version))))
       (sha256
        (base32
         "0yddvvpjdcgsiwv24jbddkgl5r1lxgz037akjln6z9acx9qrc8px"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (home-page "https://sr.ht/~plattfot/emprise")
    (synopsis "Control MPRIS supported media players from Emacs")
    (description "This package provides a set of commands to control media
players that supports the Media Player Remote Interfacing
Specification (MPRIS) protocol from Emacs.  It uses Emacs' Completing Read
framework as the user interface, which integrates well with Vertico or
Selectrum.")
    (license license:gpl3+)))

(define-public emacs-marginalia-emprise
  (package
    (name "emacs-marginalia-emprise")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~plattfot/marginalia-emprise")
             (commit (string-append "v" version))))
       (sha256
        (base32
         "1kbk3kgvv1k5zdysvpgcsbxiwn4la3vvnmv3sbzxq7q5v5cr4a54"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-emprise emacs-marginalia))
    (home-page "https://sr.ht/~plattfot/emprise/")
    (synopsis "Annotate Emprise with Marginalia")
    (description "This package provides an annotation function to show
playback status, artist name and title for Emprise using Marginalia.")
    (license license:gpl3+)))


;;;
;;; Miscellaneous.
;;;

(define-public emacs-ace-link
  (package
    (name "emacs-ace-link")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/abo-abo/ace-link")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "147dz79vg4ym5wg3d544bw2khdb2j3hr73rw4qfm64wf0q2dj0vk"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-avy))
    (home-page "https://github.com/abo-abo/ace-link")
    (synopsis "Quickly follow links in Emacs")
    (description
     "Currently, to jump to a link in a @code{Info-mode}, @code{help-mode},
@code{woman-mode}, @code{org-mode}, @code{eww-mode}, @code{compilation-mode},
@code{goto-address-mode} buffer, you can tab through the links to select the
one you want.  This is an O(N) operation, where the N is the amount of links.
This package turns this into an O(1) operation.  It does so by assigning a
letter to each link using avy.")
    (license license:gpl3+)))

(define-public emacs-app-launcher
  ;; XXX: Upstream did not tag any commit so far.  Base version is extracted
  ;; from Version keyword.
  (let ((commit "d5015e394b0a666a8c7c4d4bdf786266e773b145")
        (revision "0"))
    (package
      (name "emacs-app-launcher")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/SebastienWae/app-launcher")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0l97ajy27awydyd4gc6323wyhpm5vm2db6i0lp5gqaxi9fp7jivp"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/SebastienWae/app-launcher")
      (synopsis "Use Emacs standard completion to launch applications")
      (description "This package defines the @code{app-launcher-run-app}
command, which uses Emacs standard completion to select an application
installed on your machine and launch it.")
      (license license:gpl3+))))

(define-public emacs-alchemist
  (package
    (name "emacs-alchemist")
    (version "1.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://stable.melpa.org/packages/"
                           "alchemist-" version ".tar"))
       (sha256
        (base32 "0ygwf9d739zqc8dcckw0j0bqkipw7cmxbrx3l281x237a3d384yw"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-elixir-mode emacs-dash emacs-company emacs-pkg-info))
    (home-page "http://www.github.com/tonini/alchemist.el")
    (synopsis "Elixir tooling integration into Emacs")
    (description
     "This package brings you all the Elixir tooling and power inside your Emacs
editor.  It comes with commands to compile, execute and test your code, spawn
an interactive shell, and look up definitions and documentation as well as
code completion and project management support.")
    (license license:gpl3+)))

(define-public emacs-auto-sudoedit
  (package
    (name "emacs-auto-sudoedit")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ncaq/auto-sudoedit")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1rhdvrj2rjbvl7vkb0wcp6krqxcaigl7jk9z8yvhx6s4cm2qli6q"))))
    (propagated-inputs
     (list emacs-f))
    (build-system emacs-build-system)
    (home-page "https://github.com/ncaq/auto-sudoedit")
    (synopsis "Automatically re-open read-only files with sudo")
    (description
     "This package automatically reopens a file or directory with
@command{sudo} if it cannot write to it.")
    (license license:expat)))

(define-public emacs-read-only-cfg
  ;; XXX: Upstream has no tagged release.  Version is extracted from keyword
  ;; in main file.
  (let ((commit "c128c9412f768adf89ff5c4ad433cf0beab6656a")
        (revision "0"))
    (package
      (name "emacs-read-only-cfg")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pfchen/read-only-cfg")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "11zj4ysmacvz82j1siqlcp30i05my20lscls8wkdjl75g9d2b12l"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/pfchen/read-only-cfg")
      (synopsis "Make files read-only based on user configuration")
      (description
       "Read-only-cfg is an Emacs minor mode that can automatically make files
read-only based on user configuration.  User configuration may be prefix
directories or regex patterns.")
      (license license:gpl3+))))

(define-public emacs-bbdb
  (package
    (name "emacs-bbdb")
    (version "3.2.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "bbdb-" version ".tar"))
       (sha256
        (base32 "0bf20r5xhxln6z4qp8zrlln0303dkci2ydsr74pxcj08aqgk5xxf"))))
    (build-system emacs-build-system)
    (arguments
     ;; XXX: The following file cannot be byte-compiled, because et requires
     ;; `vm-autoloads', from the VM package, with is neither in Emacs nor
     ;; packaged in Guix.  So, don't bother for now.
     `(#:exclude '("bbdb-vm\\.el")))
    (home-page "http://elpa.gnu.org/packages/bbdb.html")
    (synopsis "Contact management utility for Emacs")
    (description
     "BBDB is the Insidious Big Brother Database for GNU Emacs.  It provides
an address book for email and snail mail addresses, phone numbers and the
like.  It can be linked with various Emacs mail clients (Message and Mail
mode, Rmail, Gnus, MH-E, and VM).  BBDB is fully customizable.")
    (license license:gpl3+)))

(define-public emacs-bbdb-vcard
  ;; No release since Dec 1, 2013.
  (let ((version "0.4.1") ;3d79fdb4200a64a043e203a3baac95c936095b52, not tagged
        (revision "88")
        (commit "113c66115ce68316e209f51ebce56de8dded3606"))
    (package
      (name "emacs-bbdb-vcard")
      (version (git-version version revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/tohojo/bbdb-vcard")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1sr5kd2gvw1b4hl147yb60cgx6j730vdnpyr09p7vmpw65hzwlwm"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-bbdb))
      (home-page "https://github.com/tohojo/bbdb-vcard")
      (synopsis
       "vCard Import and Export for The Insidious Big Brother Database (BBDB)")
      (description
       "@code{bbdb-vcard.el} imports and exports vCards (version 3.0) as
defined in RFC 2425 and RFC 2426 to/from The Insidious Big Brother Database
(BBDB).  Version 2.1 vCards are converted into version 3.0 on import.")
      (license license:gpl2+))))

(define-public emacs-beacon
  (package
    (name "emacs-beacon")
    (version "1.3.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Malabarba/beacon")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0mypzfasclq7bmw0i8hfyp8c1ycd3kdgd5h1faygzh9r0phh7ciy"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Malabarba/beacon")
    (synopsis "Emacs minor mode creating a light that follows your cursor around")
    (description
     "Beacon is an Emacs minor-mode.  Whenever the window scrolls a light will
shine on top of your cursor so you know where it is.")
    (license license:gpl3+)))

(define-public emacs-counsel-bbdb
  (package
    (name "emacs-counsel-bbdb")
    (version "0.0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/redguardtoo/counsel-bbdb")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jrj7hx6y518np3xcnarbj0c43lglcf9gww3fhfqp7lzxl9hvi8s"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-bbdb emacs-ivy))
    (home-page "https://github.com/redguardtoo/counsel-bbdb")
    (synopsis "Ivy interface for BBDB")
    (description "This Ivy extension enables the use of @code{ivy-mode} to input
email addresses from BBDB efficiently.  The main functions are:
@table @code
@item counsel-bbdb-complete-mail to input email addresses;
@item counsel-bbdb-reload' to reload contacts from BBDB database;
@item counsel-bbdb-expand-mail-alias to expand mail alias.
@end table
Since @code{counsel-bbdb} is based on @code{ivy-mode}, all Ivy key bindings
are supported.  For example, after @samp{C-u M-x counsel-bbdb-complete-mail},
you can press @samp{C-M-n} to input multiple email addresses.")
    (license license:gpl3+)))

(define-public emacs-bluetooth
  (package
    (name "emacs-bluetooth")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "bluetooth-" version ".tar"))
       (sha256
        (base32 "1p10kcim5wqnbj2kiqv6hgjkzznaa48qysnnf8ym90mylsczr70z"))))
    (build-system emacs-build-system)
    (inputs
     (list bluez dbus))
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://gitlab.com/rstocker/emacs-bluetooth")
    (synopsis "Manage Bluetooth devices using Emacs")
    (description
     "This package implements basic Bluetooth management functionality, such
as connecting and disconnecting devices, setting properties and aliases,
putting the adapter in discovery mode and controlling its power supply.  It
also includes a pairing agent.")
    (license license:gpl3+)))

(define-public emacs-aggressive-indent
  (package
    (name "emacs-aggressive-indent")
    (version "1.10.0")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/"
                                  "aggressive-indent-" version ".tar"))
              (sha256
               (base32
                "166jk1z0vw481lfi3gbg7f9vsgwfv8fiyxpkfphgvgcmf5phv4q1"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/aggressive-indent.html")
    (synopsis "Minor mode to aggressively keep your code always indented")
    (description
     "@code{aggressive-indent-mode} is a minor mode that keeps your code
always indented.  It reindents after every change, making it more reliable
than @code{electric-indent-mode}.")
    (license license:gpl2+)))

(define-public emacs-gcmh
  ;; No tagged release upstream, but the commit below correspond to the 0.2.1
  ;; release.
  (let ((commit "0089f9c3a6d4e9a310d0791cf6fa8f35642ecfd9"))
    (package
      (name "emacs-gcmh")
      (version "0.2.1")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/koral/gcmh")
               (commit commit)))
         (sha256
          (base32 "0yh1ap8phv3x44rp0yr6z884xqw2apanbx4c0acqglvj0gaaqx25"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (home-page "https://gitlab.com/koral/gcmh")
      (synopsis "Emacs Garbage Collector Magic Hack")
      (description
       "This package enforces a sneaky @dfn{garbage collector} (GC) strategy
to minimize GC interference with the activity.  During normal use a high GC
threshold is set.  When idling GC is immediately triggered and a low threshold
is set.")
      (license license:gpl3+))))

(define-public emacs-ctrlf
  (package
    (name "emacs-ctrlf")
    (version "1.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/raxod502/ctrlf")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "061id540spjycgy2xshj8kwgdngkjinznhx2qp5pmqzzx7z7rpfb"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/raxod502/ctrlf/")
    (synopsis "Single-buffer text search in Emacs")
    (description "CTRLF (pronounced @emph{control F}) is an intuitive and
efficient solution for single-buffer text search in Emacs, replacing packages
such as Isearch, Swiper, and helm-swoop.  It takes inspiration from the
widely-adopted and battle-tested @samp{Ctrl+F} interfaces in programs such as
web browsers, but follows the flow and keybindings of Isearch.")
    (license license:expat)))

(define-public emacs-dhall-mode
  ;; There is no proper release.  The base version is extracted from the
  ;; "Version" keyword in the main file.
  (let ((revision "1")
        (commit  "484bcf8f78f1183ef45c3b04a362bb73690c6b9b"))
    (package
      (name "emacs-dhall-mode")
      (version (git-version "0.1.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/psibi/dhall-mode")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1wggg8jlzg9rph4jhxp6yiri178rnasbv38838i973kjgqjxrl76"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-reformatter))
      (home-page "https://github.com/psibi/dhall-mode")
      (synopsis "Major mode for working with Dhall configuration language")
      (description
       "Dhall-mode provides an Emacs Major mode for working with the Dhall
configuration language. It features:

@itemize
@item Syntax highlighting
@item Multiline support for String
@item Basic indentation, commenting
@item Automatic formatting on save using dhall-format.
@item Error highlighting.
@end itemize")
      (license license:gpl3+))))

(define-public emacs-link-hint
  ;; Last release was in 2015.
  (let ((commit "83cd0489b16f013647d0507ef20905a0a91db433")
        (revision "4"))
    (package
      (name "emacs-link-hint")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/noctuid/link-hint.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0kwaia6i0asr7yqcw1anzq6lf93357cc1fphkvp0llbmxizmkzb3"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-avy))
      (home-page "https://github.com/noctuid/link-hint.el")
      (synopsis "Vimperator-style link-hinting in Emacs")
      (description "This package provides commands for visiting and acting on
links.")
      (license license:gpl3+))))

(define-public emacs-ag
  (package
    (name "emacs-ag")
    (version "0.48")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Wilfred/ag.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1p918y24vcn2pdliaymd210xp9fvhd4a1srqbv2lfiqrh59yjidx"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'substitute-ag-path
            (lambda* (#:key inputs #:allow-other-keys)
              (make-file-writable "ag.el")
              (emacs-substitute-variables "ag.el"
                ("ag-executable" (search-input-file inputs "/bin/ag")))))
          (add-before 'install 'make-info
            (lambda _
              (with-directory-excursion "docs"
                (invoke "make" "info"))))
          (add-after 'install 'install-info
            (lambda _
              (install-file "docs/_build/texinfo/agel.info"
                            (string-append #$output "/share/info")))))))
    (inputs (list the-silver-searcher))     ; 'ag' executable
    (native-inputs
     (list python-sphinx texinfo))
    (propagated-inputs
     (list emacs-dash emacs-s))
    (home-page "https://github.com/Wilfred/ag.el")
    (synopsis "Front-end for ag (the-silver-searcher) for Emacs")
    (description "This package provides the ability to use the silver
searcher, a code searching tool, sometimes abbreviated to @code{ag}.  Features
include version control system awareness, use of Perl compatible regular
expressions, editing the search results directly and searching file names
rather than the contents of files.")
    (license license:gpl3+)))

(define-public emacs-aio
  (package
    (name "emacs-aio")
    (version "1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/skeeto/emacs-aio")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1y7j10j74r3fy0rcb8g3cm9nlls34qb0pz9xkia7psp77syrlz54"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "--batch"
                        "-l" "aio-test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs
     (list emacs-elfeed emacs-skewer-mode))
    (home-page "https://github.com/skeeto/emacs-aio")
    (synopsis "Async/Await for Emacs Lisp")
    (description "@code{aio} is to Emacs Lisp as @code{asyncio} is to
Python. This package builds upon Emacs generators to provide functions that
pause while they wait on asynchronous events.  They do not block any thread
while paused.")
    (license license:unlicense)))

(define-public emacs-async
  (package
    (name "emacs-async")
    (home-page "https://github.com/jwiegley/emacs-async")
    (version "1.9.7")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "18pysi1pf6hbv6w0nq50j5xclvgd006iqqijh44wck9hxhdwyfr1"))))
    (build-system emacs-build-system)
    (synopsis "Asynchronous processing in Emacs")
    (description
     "This package provides the ability to call asynchronous functions and
processes.  For example, it can be used to run dired commands (for copying,
moving, etc.) asynchronously using @code{dired-async-mode}.  Also it is used
as a library for other Emacs packages.")
    (license license:gpl3+)))

(define-public emacs-auctex
  (package
    (name "emacs-auctex")
    (version "13.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "auctex-" version ".tar"))
       (sha256
        (base32 "0pdinnhkv7vqib01a6vxq1iixs7sw72r0sxzryv78c9hxn2k4552"))))
    (build-system emacs-build-system)
    ;; We use 'emacs' because AUCTeX requires dbus at compile time
    ;; ('emacs-minimal' does not provide dbus).
    (arguments
     `(#:emacs ,emacs
       #:include '("\\.el$" "^images/" "^latex/" "\\.info$")
       #:exclude '("^tests/" "^latex/README")
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure
           (lambda* (#:key inputs #:allow-other-keys)
             (emacs-substitute-variables "preview.el"
               ("preview-gs-command"
                (search-input-file inputs "/bin/gs")))
             (substitute* "preview.el"
               (("\"dvipng ")
                (let ((dvipng (search-input-file inputs "/bin/dvipng")))
                  (string-append "\"" dvipng " ")))
               (("\"dvips ")
                (let ((dvips (search-input-file inputs "/bin/dvips")))
                  (string-append "\"" dvips " ")))
               (("\"pdf2dsc ")
                (let ((pdf2dsc (search-input-file inputs "/bin/pdf2dsc")))
                  (string-append "\"" pdf2dsc " "))))))
         (add-after 'install 'install-doc
           (lambda* (#:key outputs #:allow-other-keys)
             (let* ((out (assoc-ref outputs "out"))
                    (etc-dir (string-append out "/share/" ,name "/"
                                            ,version "/etc")))
               (with-directory-excursion "doc"
                 (setenv "HOME" (getenv  "TMPDIR")) ; for mktextfm
                 (invoke "pdftex" "tex-ref")
                 (install-file "tex-ref.pdf"
                               (string-append etc-dir "/refcards")))))))))
    (native-inputs
     (list perl))
    (inputs
     (list ghostscript
           (texlive-updmap.cfg (list texlive-amsfonts))))
    (home-page "https://www.gnu.org/software/auctex/")
    (synopsis "Integrated environment for TeX")
    (description
     "AUCTeX is a comprehensive customizable integrated environment for
writing input files for TeX, LaTeX, ConTeXt, Texinfo, and docTeX using Emacs
or XEmacs.")
    (license license:gpl3+)))

(define-public emacs-autothemer
  (package
    (name "emacs-autothemer")
    (version "0.2.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sebastiansturm/autothemer")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0jxlfwcfqdjr3da2xzjnigmckarhjbn6b1i1x4pdzb5djjcz00qc"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://github.com/sebastiansturm/autothemer")
    (synopsis "Conveniently create Emacs themes")
    (description
     "Autothemer provides a thin layer on top of @code{deftheme} and
@code{custom-theme-set-faces} that creates a new custom color theme, based on
a set of simplified face specifications and a user-supplied color palette.")
    (license license:gpl3+)))

(define-public emacs-howm
  (package
    (name "emacs-howm")
    (version "1.4.8")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://howm.sourceforge.jp/a/"
                           "howm-" version ".tar.gz"))
       (sha256
        (base32 "0i5pfnvy130fzk8w62301vgsqf1y22chwhjgnm5hjxr9y0kw5ii4"))))
    (build-system gnu-build-system)
    (native-inputs
     (list emacs-minimal))
    (arguments
     `(#:configure-flags
       (list (string-append "--with-howmdir=" (emacs:elpa-directory %output)))
       #:modules ((guix build gnu-build-system)
                  ((guix build emacs-build-system) #:prefix emacs:)
                  (guix build utils))
       #:imported-modules (,@%gnu-build-system-modules
                           (guix build emacs-build-system)
                           (guix build emacs-utils))
       #:phases
       (modify-phases %standard-phases
         (add-after 'install 'make-autoloads
           (assoc-ref emacs:%standard-phases 'make-autoloads)))))
    (home-page "https://howm.osdn.jp/")
    (synopsis "Note-taking tool for Emacs")
    (description "Howm is a note-taking tool for Emacs.  Like
code@{emacs-wiki.el}, it facilitates using hyperlinks and doing full-text
searches.  Unlike code@{emacs-wiki.el}, it can be combined with any format.")
    (license license:gpl1+)))

(define-public emacs-bm
  (package
    (name "emacs-bm")
    (version "201905")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joodland/bm")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "180b3rc13asrmsdh7v405d54jkrininvaj52xhp71vw91ng51dkn"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/joodland/bm")
    (synopsis "Visual bookmarks for Emacs")
    (description "This package provides visible, buffer local bookmarks and
the ability to jump forward and backward to the next bookmark.")
    (license license:gpl2+)))

(define-public emacs-calfw
  (package
    (name "emacs-calfw")
    (version "1.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kiwanami/emacs-calfw")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0r42cagvmvvib76kd15nd9ix55ys6i549vxnls4z16s864695zpa"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-howm))
    (home-page "https://github.com/kiwanami/emacs-calfw/")
    (synopsis "Calendar framework for Emacs")
    (description
     "This package displays a calendar view with various schedule data in the
Emacs buffer.")
    (license license:gpl3+)))

(define-public emacs-caml
  (package
    (name "emacs-caml")
    (version "4.9")
    (source
      (origin
        (method url-fetch)
        (uri (string-append "https://elpa.nongnu.org/nongnu/caml-"
                            version ".tar"))
        (sha256
          (base32
            "00ldvz6r10vwwmk6f3az534p0340ywn7knsg2bmvbvh3q51vyl9i"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ocaml/caml-mode")
    (synopsis "Caml mode for GNU Emacs")
    (description
      "This package provides a major mode for editing OCaml code in Emacs.
Some of its major features include:

@itemize
@item syntax highlighting (font lock);
@item automatic indentation;
@item querying the type of expressions (using compiler generated annot files);
@item running an OCaml REPL within Emacs;
@item scanning of declarations and placing them in a menu.
@end itemize")
    (license license:gpl2+)))

(define-public emacs-caps-lock
  (package
    (name "emacs-caps-lock")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "caps-lock-" version ".el"))
       (sha256
        (base32 "1i4hwam81p4dr0bk8257fkiz4xmv6knkjxj7a00fa35kgx5blpva"))))
    (build-system emacs-build-system)
    (home-page "http://elpa.gnu.org/packages/caps-lock.html")
    (synopsis "Caps Lock as a minor mode")
    (description
     "This package provides a minor mode to emulate the behavior of a Caps
Lock key.")
    (license license:gpl3+)))

(define-public emacs-chronometrist
  (package
    (name "emacs-chronometrist")
    (version "0.10.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://tildegit.org/contrapunctus/chronometrist")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0qpkpkipmac24m3ng4ahsml3vi15qcvmid3g02pbpgbpc113zfpl"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'chdir-elisp
            ;; Elisp directory is not in root of the source.
            (lambda _
              (chdir "elisp")))
          (add-after 'install 'install-doc
            ;; Documentation consists of several Markdown files.
            (lambda _
              (let ((doc (string-append #$output
                                        "/share/doc/emacs-chronometrist-"
                                        #$version)))
                (with-directory-excursion "../doc"
                  (for-each (lambda (f) (install-file f doc))
                            (cons* "../UNLICENSE"
                                   "../WTFPL"
                                   (find-files "." "\\.md$"))))))))))
    (propagated-inputs
     (list emacs-alert emacs-dash emacs-s emacs-spark emacs-ts))
    (home-page "https://github.com/contrapunctus-1/chronometrist")
    (synopsis "Time tracker for Emacs")
    (description "Chronometrist is a time tracker in Emacs, largely modelled
after the Android application, @emph{A Time Tracker}.

Its features are:
@itemize
@item Simple and efficient to use,
@item Displays useful information about your time usage,
@item Support for both mouse and keyboard,
@item Human errors in tracking are easily fixed by editing a plain text file,
@item Hooks to let you perform arbitrary actions when starting/stopping tasks.
@end itemize")
    ;; Software is dual-licensed.
    (license (list license:unlicense license:wtfpl2))))

(define-public emacs-citeproc-el
  (package
    (name "emacs-citeproc-el")
    (version "0.9.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/andras-simonyi/citeproc-el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0rkwqn9pcimfcyq19wlrcij0kcjyhbwisla7vwbhjj8ang0bq9rm"))))
    (build-system emacs-build-system)
    (arguments
     `(#:emacs ,emacs))                 ;need libxml support
    (propagated-inputs
     (list emacs-dash
           emacs-f
           emacs-parsebib
           emacs-queue
           emacs-s
           emacs-string-inflection))
    (home-page "https://github.com/andras-simonyi/citeproc-el")
    (synopsis "Citation Style Language (CSL) processor for Emacs")
    (description
     "Citeproc-el is an Emacs Lisp library for rendering citations
and bibliographies in styles described in the Citation Style
Language (CSL), an XML-based, open format to describe the formatting
of bibliographic references.")
    (license license:gpl3+)))

(define-public emacs-corfu
  (package
    (name "emacs-corfu")
    (version "0.33")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/minad/corfu")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0c353k6f4i96gajfw1zvidhlwr2brnhhdr39503hpa5wnp69wak7"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; Move the extensions source files to the top level, which is included
         ;; in the EMACSLOADPATH.
         (add-after 'unpack 'move-source-files
           (lambda _
             (let ((el-files (find-files "./extensions" ".*\\.el$")))
               (for-each (lambda (f)
                           (rename-file f (basename f)))
                         el-files)))))))
    (home-page "https://github.com/minad/corfu")
    (synopsis "Completion overlay region function")
    (description
     "Corfu enhances the default completion in region function with a completion
overlay.  The current candidates are shown in a popup overlay below or above
the point.  Corfu can be considered the minimalistic
@code{completion-in-region} counterpart of the Vertico minibuffer UI.")
    (license license:gpl3+)))

(define-public emacs-corfu-doc
  (package
    (name "emacs-corfu-doc")
    (version "0.6.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/galeo/corfu-doc")
             (commit "f9566cf13f6730a45b2f3c12e491a3fa2097e5d5")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "098yf29yv1b11p7kvdc7n4ra7f5vcmf6nlvhl85jgwqrsdz1795b"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-corfu))
    (home-page "https://github.com/galeo/corfu-doc")
    (synopsis "Documentation popup for Corfu")
    (description
     "The @code{corfu-doc} package provides a way to display a documentation
popup for completion candidates when using @code{emacs-corfu}.  It can
be regarded as @code{emacs-company-quickhelp} for @code{emacs-corfu}.")
    (license license:gpl3+)))

(define-public emacs-cape
  (package
    (name "emacs-cape")
    (version "0.11")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/minad/cape")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0z6ixw7gsx1g7x2xpj5ilslrjrlp6x2ynzh731hs3yf3n281715b"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/minad/cape")
    (synopsis "Completion at point extensions for Emacs")
    (description
     "Cape provides some Completion At Point Extensions, which can be used in
combination with Corfu completion UI or the default completion UI.  The
completion backends used by @code{completion-at-point} are so called
@code{completion-at-point-functions} (Capfs).  In principle, the Capfs
provided by Cape can also be used by Company.")
    (license license:gpl3+)))

(define-public emacs-direnv
  (package
    (name "emacs-direnv")
    (version "2.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/wbolster/emacs-direnv")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0cf5npgksl9a03mnfdhfdhlf46gr9qz9adjxz3dbckq9b1vl0dfc"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-in-direnv
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((direnv (search-input-file inputs "/bin/direnv")))
               (substitute* "direnv.el"
                 (("\"direnv\"") (string-append "\"" direnv "\"")))))))))
    (inputs
     (list direnv))
    (propagated-inputs
     (list emacs-dash emacs-with-editor))
    (home-page "https://github.com/wbolster/emacs-direnv")
    (synopsis "Direnv integration for Emacs")
    (description
     "This package provides support for invoking direnv to get the environment
for the current file and updating the environment within Emacs to match.

Direnv can be invoked manually, and a global minor mode is included that will
update the environment when the active buffer changes.

Using emacs-direnv means that programs started from Emacs will use the
environment set through Direnv.")
    (license license:gpl3+)))

(define-public emacs-elf-mode
  (package
    (name "emacs-elf-mode")
    (version "0.1.0")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/abo-abo/elf-mode")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0cbvjbk2893ag1iy8ggixpirfiyhssm7fii96hb9jqdz874cdl0k"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/abo-abo/elf-mode")
    (synopsis "Show symbol list when opening a binary file in Emacs")
    (description "This Emacs package provides a command showing the symbols
that the binary uses instead of the actual binary contents.")
    (license license:gpl3+)))

(define-public emacs-org-fc
  (let ((commit "f64b5336485a42be91cfe77850c02a41575f5984")
        (revision "0"))
    (package
      (name "emacs-org-fc")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://git.sr.ht/~l3kn/org-fc")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1d0a3vr09zkplclypcgpfbfd6r0h0i3g3zsqb4pcz6x239d59gd5"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:include #~(cons* "\\.awk$" "\\.org$" %default-include)
        #:exclude #~(cons "^tests/" %default-exclude)
        #:tests? #t
        #:test-command #~(list "emacs" "--batch"
                               "-L" "."
                               "-L" "tests/"
                               "-l" "tests/org-fc-filter-test.el"
                               "-l" "tests/org-fc-indexer-test.el"
                               "-l" "tests/org-fc-review-data-test.el"
                               "-f" "ert-run-tests-batch-and-exit")
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'qualify-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (let ((find (search-input-file inputs "/bin/find"))
                      (gawk (search-input-file inputs "/bin/gawk"))
                      (xargs (search-input-file inputs "/bin/xargs")))
                  (substitute* "org-fc-awk.el"
                    (("\"find ") (string-append "\"" find " "))
                    (("\"gawk ") (string-append "\"" gawk " "))
                    (("\"xargs ") (string-append "\"" xargs " ")))))))))
      (inputs (list findutils gawk))
      (propagated-inputs (list emacs-hydra))
      (home-page "https://www.leonrische.me/fc/index.html")
      (synopsis "Spaced repetition system for Emacs Org mode")
      (description
       "Org-fc is a spaced-repetition system for Emacs' Org mode.
It allows you to mark headlines in a file as flashcards, turning pieces of
knowledge you want to learn into a question-answer test.  These cards are
reviewed at regular interval.  After each review, the next review interval is
calculated based on how well you remembered the contents of the card.")
      (license license:gpl3+))))

(define-public emacs-font-lock-studio
  (let ((commit "12c35967b31233e06946c70627aa3152dacfe261")
        (revision "1"))
    (package
      (name "emacs-font-lock-studio")
      (version (git-version "0.0.7" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Lindydancer/font-lock-studio")
               (commit "12c35967b31233e06946c70627aa3152dacfe261")))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0q0s6f5vi3sfifj7vq2nnsmgyyivp1sd3idk32858md5ri71qif0"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/Lindydancer/font-lock-studio")
      (synopsis "Interactive debugger for Font Lock keywords")
      (description
       "Font Lock Studio is an interactive debugger for Emacs syntax highlighting
rules, also called Font Lock keywords.  It can @emph{single-step} Font Lock
keywords -- matchers, highlights, and anchored rules, to see what happens when
a buffer is fontified.  Breakpoints can be set on or inside rules.  When
inside a rule, matches are visualized using a palette of background colors.
The explainer can describe a rule in plain-text English.  Finally, tight
integration with Edebug allows stepping into Lisp expressions that are part of
the Font Lock keywords.")
      (license license:gpl3+))))

(define-public emacs-form-feed
  (package
    (name "emacs-form-feed")
    (version "0.2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://depp.brause.cc/form-feed.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10mcj4x2fjq0ikq9adkd72k9zp6caqib628bmj8d67wwabvzj6mk"))))
    (build-system emacs-build-system)
    (home-page "https://depp.brause.cc/form-feed")
    (synopsis "Display ^L glyphs as horizontal lines")
    (description
     "This package provides a minor mode @code{form-feed-mode} to display page
delimiters which usually appear as ^L glyphs on a single line as horizontal
lines spanning the entire window.  The minor mode is suitable for inclusion
into mode hooks and is intended to be used that way.")
    (license license:gpl3+)))

(define-public emacs-ggtags
  (package
    (name "emacs-ggtags")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/ggtags-"
                           version ".tar"))
       (sha256
        (base32
         "0p79x9g94jynl83ndvqp9349vhgkzxzhnc517r8hn44iqxqf6ghg"))))
    (build-system emacs-build-system)
    (inputs
     (list global))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure
           (lambda* (#:key inputs #:allow-other-keys)
             (chmod "ggtags.el" #o644)
             (emacs-substitute-variables "ggtags.el"
               ("ggtags-executable-directory"
                (dirname (search-input-file inputs "bin/global")))))))))
    (home-page "https://github.com/leoliu/ggtags")
    (synopsis "Frontend to the GNU Global source code tagging system")
    (description "@code{ggtags} provides a frontend to the GNU Global source
code tagging system.

Features:

@itemize
@item Build on @code{compile.el} for asynchronicity and its large feature-set.
@item Automatically update Global's tag files when needed with tuning for
large source trees.
@item Intuitive navigation among multiple matches with mode-line display of
current match, total matches and exit status.
@item Read tag with completion.
@item Show definition at point.
@item Jump to #include files.
@item Support search history and saving a search to register/bookmark.
@item Query replace.
@item Manage Global's environment variables on a per-project basis.
@item Highlight (definition) tag at point.
@item Abbreviated display of file names.
@item Support all Global search backends: @code{grep}, @code{idutils}, etc.
@item Support exuberant ctags @url{http://ctags.sourceforge.net/} and
@code{pygments} backend.
@item Support all Global's output formats: @code{grep}, @code{ctags-x},
@code{cscope} etc.
@item Support projects on remote hosts (e.g. via @code{tramp}).
@item Support eldoc.
@item Search @code{GTAGSLIBPATH} for references and symbols.
@end itemize\n")
    (license license:gpl3+)))

(define-public emacs-go-mode
  ;; XXX: Upstream did not tag last release.  The commit below matches version
  ;; bump.
  (let ((commit "3273fcece5d9ab7edd4f15b2d6bce61f4e5a0666"))
    (package
      (name "emacs-go-mode")
      (version "1.6.0")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/dominikh/go-mode.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "00qzn136d8cl3szbi44xf3iiv75r6n1m7wwgldmzn4i5mpz8dbq7"))))
      (arguments
       (list
        #:tests? #t
        #:test-command #~(list "ert-runner")
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'fix-tests
              ;; Two tests fail because they (wrongly) assume we run them from
              ;; the "test" sub-directory.  Fix their expectations.
              (lambda _
                (let ((test-file "test/go-indentation-test.el"))
                  (make-file-writable test-file)
                  (substitute* test-file
                    (("testdata/indentation_tests/" all)
                     (string-append "test/" all)))))))))
      (build-system emacs-build-system)
      (native-inputs (list emacs-ert-runner))
      (home-page "https://github.com/dominikh/go-mode.el")
      (synopsis "Go mode for Emacs")
      (description
       "This package provides go-mode, an Emacs mode for working with software
written in the Go programming language.")
      (license license:bsd-3))))

(define-public emacs-google-maps
  ;; There has been no new release tag since 2013.
  (let ((commit "2eb16ff609f5a9f8d02c15238a111fbb7db6c146")
        (revision "1"))
    (package
      (name "emacs-google-maps")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jd/google-maps.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1bl0dnksbf14d0xcnvdy9qpvzc5c8jwkxpmfvgayj6djikxnw2md"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/jd/google-maps.el")
      (synopsis "Access Google Maps from Emacs")
      (description "The @code{google-maps} package displays Google Maps
directly inside Emacs.  It requires a Google Map Static API key to function.")
      (license license:gpl3+))))

(define-public emacs-graphviz-dot-mode
  (package
    (name "emacs-graphviz-dot-mode")
    (version "0.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ppareit/graphviz-dot-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1v1p85wk73nfsvv66qf90flgf9dqhmv15z1r7q4zmc4ifklqn08m"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'make-info
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion "texinfo"
                (substitute* "Makefile"
                  (("\\/usr\\/bin\\/gzip")
                   (search-input-file inputs "/bin/gzip")))
                (invoke "make"
                        "clean"
                        "info"
                        (string-append "TEXINFODIR="
                                       #$(this-package-native-input "texinfo")
                                       "/bin")))))
          (add-after 'install 'install-info
            (lambda _
              (let ((info (string-append #$output "/share/info")))
                (install-file "texinfo/graphviz-dot-mode.info.gz" info)))))))
    (native-inputs
     (list gzip texinfo))
    (propagated-inputs
     (list emacs-company))
    (home-page "http://ppareit.github.com/graphviz-dot-mode")
    (synopsis "Major mode for editing Graphviz DOT files")
    (description
     "This Emacs package helps you to create @file{.dot} or @file{.gv} files
using the DOT syntax, and use Graphviz to convert these files to diagrams.")
    (license license:gpl2+)))

(define-public emacs-imenu-list
  (let ((commit "b50222378412fbe321622a84cb2b036e084c697a")
        (revision "1")
        (version "0.9"))
    (package
      (name "emacs-imenu-list")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/bmag/imenu-list")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1936dd41fa05ndzf2bwhllvjz97iz0rflkazjipr7dvz5q072wj2"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/bmag/imenu-list")
      (synopsis
       "Automatically tracks the current buffer's imenu entries")
      (description
       "This Emacs minor mode creates an automatically updated buffer called
@code{*Ilist*} that is populated with the current buffer's imenu entries.
This buffer is typically shown as a sidebar (Emacs vertically splits the
window).")
      (license license:gpl3+))))

(define-public emacs-mmm-mode
  (package
    (name "emacs-mmm-mode")
    (version "0.5.9")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "mmm-mode-" version ".tar"))
       (sha256
        (base32 "12fss1ccb66xc87m5wpr3vg7bfrzz5m0q6s7pa0avvhsm2f8r2yh"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/mmm-mode")
    (synopsis "Allow multiple major modes in an Emacs buffer")
    (description
     "MMM Mode is a minor mode that allows multiple major modes to coexist in
a single buffer.")
    (license license:gpl3+)))

(define-public emacs-mmt
  (package
    (name "emacs-mmt")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mrkkrp/mmt")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13vbfc5597v0gd87qyhn10f93nb477vjpg3jlpphbax9fvkf4gav"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/mrkkrp/mmt")
    (synopsis "Classic tools to write Emacs Lisp macros")
    (description "Emacs MMT is a package that contains classic tools for Emacs
Lisp developers who want to write macros with convenience.")
    (license license:gpl3+)))

(define-public emacs-tablist
  (package
    (name "emacs-tablist")
    (version "1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/politza/tablist")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0pzsdg0rm59daw34ppss79cg05z9wnr8nkmdcc48nkd0p69ip2yy"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/politza/tablist")
    (synopsis "Extension for @code{tabulated-list-mode}")
    (description "Tablist is the Emacs package that provides several
additional features to @code{tabulated-list-mode}: it adds marks,
filters, new key bindings and faces.  It can be enabled by
@code{tablist-mode} or @code{tablist-minor-mode} commands.")
    (license license:gpl3+)))

(define-public emacs-djvu
  (package
    (name "emacs-djvu")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "djvu-" version ".tar"))
       (sha256
        (base32 "0i7xwgg2fxndy81lnng6fh9iknals8xvx4f1nmxq7c099bzwb57c"))))
    (build-system emacs-build-system)
    (inputs (list djview djvulibre))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'configure
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((file "djvu.el"))
                ;; Specify the absolute executable locations.
                (make-file-writable file)
                (substitute* file
                  (("\"djvused\"")
                   (string-append "\""
                                  (search-input-file inputs "/bin/djvused")
                                  "\""))
                  (("\"djvm\"")
                   (string-append "\""
                                  (search-input-file inputs "/bin/djvm")
                                  "\""))
                  (("\"ddjvu\"")
                   (string-append "\""
                                  (search-input-file inputs "/bin/ddjvu")
                                  "\"")))
                (emacs-substitute-variables file
                  ("djvu-djview-command"
                   (search-input-file inputs "/bin/djview")))))))))
    (home-page "http://elpa.gnu.org/packages/djvu.html")
    (synopsis "Edit and view Djvu files via djvused")
    (description
     "This package is a front end for the command-line program djvused from
DjVuLibre, see @url{http://djvu.sourceforge.net/}.")
    (license license:gpl3+)))

(define-public emacs-djvu3
  ;; Commit from 2021-06-03.
  (let ((commit "37b675be1d4d436cdd0c3b5d3f13e88b59a7bf18")
        (revision "0"))
    (package
      (name "emacs-djvu3")
      ;; `Version:' header says 1.0
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dalanicolai/djvu3")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0p0izjrgbayx5ybk1n6db5hbrjv9d4kpn57w4iyxdm3h96sp9cmr"))))
      (propagated-inputs
       (list emacs-djvu emacs-tablist))
      (build-system emacs-build-system)
      (home-page "https://github.com/dalanicolai/djvu3")
      (synopsis "Extend djvu.el to display annotations and more")
      (description "This package extends @code{emacs-djvu} with annotation
rendering features and a fast occur search feature using @code{svg.el}.

Other features include:

@itemize
@item clickable links
@item marker extension to @code{svg.el} for providing arrowheads (or other
types of markers)
@item a quite fancy keyboard annotation function
@item an @code{imenu} index function to enable imenu navigation
@item document restore function to open the document at the last location of
the previous session
@end itemize")
      (license license:gpl3+))))

(define-public emacs-pabbrev
  (package
    (name "emacs-pabbrev")
    (version "4.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "pabbrev-" version ".tar"))
       (sha256
        (base32 "0iydz8yz866krxv1qv32k88w4464xpymh0wxgrxv6nvniwvhvd0s"))))
    (build-system emacs-build-system)
    (home-page "http://elpa.gnu.org/packages/pabbrev.html")
    (synopsis "Predictive abbreviation expansion")
    (description
     "The code provides a abbreviation expansion for Emacs.  It is
fairly similar to Dabbrev expansion, which works based on the contents
of the current buffer (or other buffers).

Predictive abbreviation expansion works based on the previously
written text.  Unlike dynamic abbreviation, the text is analysed
during idle time, while Emacs is doing nothing else.")
    (license license:gpl3+)))

(define-public emacs-pdf-tools
  (package
    (name "emacs-pdf-tools")
    (version "0.91")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/vedang/pdf-tools")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "07ixspgn4s1jg66w7m2f3sh43giakz9srhp7rpw389z32g57i1rx"))))
    (build-system gnu-build-system)
    (arguments
     `(#:tests? #f                      ; there are no tests
       #:modules ((guix build gnu-build-system)
                  ((guix build emacs-build-system) #:prefix emacs:)
                  (guix build utils)
                  (guix build emacs-utils))
       #:imported-modules (,@%gnu-build-system-modules
                           (guix build emacs-build-system)
                           (guix build emacs-utils))
       #:phases
       (modify-phases %standard-phases
         ;; Build server side using 'gnu-build-system'.
         (add-after 'unpack 'enter-server-dir
           (lambda _ (chdir "server")))
         (add-after 'enter-server-dir 'autogen
           (lambda _
             (invoke "bash" "autogen.sh")))
         ;; Build emacs side using 'emacs-build-system'.
         (add-after 'compress-documentation 'enter-lisp-dir
           (lambda _ (chdir "../lisp")))
         (add-after 'enter-lisp-dir 'emacs-patch-variables
           (lambda* (#:key outputs #:allow-other-keys)
             (for-each make-file-writable (find-files "."))

             ;; Set path to epdfinfo program.
             (emacs-substitute-variables "pdf-info.el"
               ("pdf-info-epdfinfo-program"
                (string-append (assoc-ref outputs "out")
                               "/bin/epdfinfo")))
             ;; Set 'pdf-tools-handle-upgrades' to nil to avoid "auto
             ;; upgrading" that pdf-tools tries to perform.
             (emacs-substitute-variables "pdf-tools.el"
               ("pdf-tools-handle-upgrades" '()))))
         (add-after 'emacs-patch-variables 'emacs-expand-load-path
           (assoc-ref emacs:%standard-phases 'expand-load-path))
         (add-after 'emacs-expand-load-path 'emacs-add-install-to-native-load-path
           (assoc-ref emacs:%standard-phases 'add-install-to-native-load-path))
         (add-after 'emacs-add-install-to-native-load-path 'emacs-install
           (assoc-ref emacs:%standard-phases 'install))
         (add-after 'emacs-install 'emacs-build
           (assoc-ref emacs:%standard-phases 'build))
         (add-after 'emacs-install 'emacs-make-autoloads
           (assoc-ref emacs:%standard-phases 'make-autoloads)))))
    (native-inputs
     (list autoconf automake emacs-minimal pkg-config))
    (inputs
     (list cairo glib libpng poppler zlib))
    (propagated-inputs
     (list emacs-tablist))
    (home-page "https://github.com/politza/pdf-tools")
    (synopsis "Emacs support library for PDF files")
    (description
     "PDF Tools is, among other things, a replacement of DocView for PDF
files.  The key difference is that pages are not pre-rendered by
e.g. ghostscript and stored in the file-system, but rather created on-demand
and stored in memory.")
    (license license:gpl3+)))

(define-public emacs-saveplace-pdf-view
  (package
    (name "emacs-saveplace-pdf-view")
    (version "1.0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nicolaisingh/saveplace-pdf-view")
             (commit (string-append "saveplace-pdf-view-" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0i03qb6qc2agp9s5s7l08f1wl8anqndh6xshg1c3w357vd1whv7i"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/nicolaisingh/saveplace-pdf-view")
    (synopsis "Save place in pdf-view buffers for Emacs")
    (description
     "This package extends the built-in Save-Place mode by adding support for
PDF view (see @code{emacs-pdf-tools}).  This package will store the
place (e.g., the current page and zoom) of PDF buffers under PDFView mode or
DocView mode, and revisiting those PDF files later using the same mode will
restore the saved place.")
    (license license:gpl3+)))

(define-public emacs-pdfgrep
  ;; XXX: Upstream does not tag releases.  The commit below matches latest
  ;; version bump.
  (let ((commit "e250376d97fc5240e07d81108bbca9b5a9ab50f4"))
    (package
      (name "emacs-pdfgrep")
      (version "1.4")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jeremy-compostella/pdfgrep")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "17yqvvgkgxmcl8nc0mb9yaz884zcdnz7dwvfi4mxjzp1l05fvwjk"))))
      (build-system emacs-build-system)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'patch-pdfgrep-path
                   (lambda* (#:key inputs #:allow-other-keys)
                     (make-file-writable "pdfgrep.el")
                     (emacs-substitute-variables "pdfgrep.el"
                       ("pdfgrep-program"
                        (search-input-file inputs "bin/pdfgrep"))))))))
      (inputs (list pdfgrep))
      (home-page "https://github.com/jeremy-compostella/pdfgrep")
      (synopsis "Emacs module providing @code{grep} comparable facilities but
for PDF files")
      (description
       "pdfgrep is a GNU/Emacs module providing @code{grep} comparable
facilities but for PDF files.  Its usage is similar to the @code{grep}
function.  For example, using the @code{next-error} function gets you to the
next matching page.")
      (license license:gpl3+))))

(define-public emacs-dash
  (package
    (name "emacs-dash")
    (version "2.19.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/magnars/dash.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0z6f8y1m9amhg427iz1d4xcyr6n0kj5w7kmiz134p320ixsdnzd8"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #t
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'disable-byte-compile-error-on-warn
                 (lambda _
                   (substitute* "Makefile"
                     (("\\(setq byte-compile-error-on-warn t\\)")
                      "(setq byte-compile-error-on-warn nil)")))))))
    (home-page "https://github.com/magnars/dash.el")
    (synopsis "Modern list library for Emacs")
    (description "This package provides a modern list API library for Emacs.")
    (license license:gpl3+)))

(define-public emacs-bui
  (package
    (name "emacs-bui")
    (version "1.2.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://notabug.org/alezost/emacs-bui.git")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0sszdl4kvqbihdh8d7mybpp0d8yw2p3gyiipjcxz9xhvvmw3ww4x"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://notabug.org/alezost/emacs-bui")
    (synopsis "Buffer interface library for Emacs")
    (description
     "BUI (Buffer User Interface) is a library for making @code{list} and
@code{info} interfaces to display an arbitrary data of the same
type, for example: packages, buffers, files, etc.")
    (license license:gpl3+)))

(define-public emacs-guix
  (let ((commit "cf5b7a402ea503c3dcda85a86b9a6c6dd01896e0")
        (revision "6"))
    (package
      (name "emacs-guix")
      (version (git-version "0.5.2" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://git.savannah.gnu.org/git/guix/emacs-guix.git")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0wxiipgv91rlk9bhspx370rykywi52rxg5m1f7680vzs3ckc7nyd"))))
      (build-system gnu-build-system)
      (arguments
       (list
        #:modules '((guix build gnu-build-system)
                    ((guix build emacs-build-system) #:prefix emacs:)
                    (guix build utils))
        #:imported-modules `(,@%gnu-build-system-modules
                             (guix build emacs-build-system)
                             (guix build emacs-utils))
        #:configure-flags
        #~(list (string-append "--with-lispdir="
                               (emacs:elpa-directory #$output)))
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'expand-load-path
              (lambda _
                ((assoc-ref emacs:%standard-phases 'expand-load-path)
                 #:prepend-source? #f))))))
      (native-inputs
       (list autoconf automake emacs-minimal pkg-config texinfo))
      (inputs
       (list (lookup-package-input guix "guile")
             guix))
      (propagated-inputs
       (list emacs-bui
             emacs-dash
             emacs-edit-indirect
             emacs-geiser
             emacs-geiser-guile
             emacs-magit-popup
             guile-gcrypt))
      (home-page "https://guix.gnu.org")
      (synopsis "Emacs interface for GNU Guix")
      (description
       "Emacs-Guix provides a visual interface, tools and features for the GNU
Guix package manager.  Particularly, it allows you to do various package
management tasks from Emacs.  To begin with, run @code{M-x guix-about} or
@code{M-x guix-help} command.")
      (license license:gpl3+))))

(define-public emacs-build-farm
  (package
    (name "emacs-build-farm")
    (version "0.2.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://notabug.org/alezost/emacs-build-farm.git")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0i0bwbav5861j2y15j9nd5m9rdqg9q97zgcbld8pivr9nyxy63lz"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-bui emacs-magit-popup))
    (home-page "https://notabug.org/alezost/emacs-build-farm")
    (synopsis "Emacs interface for Hydra and Cuirass build farms")
    (description
     "This Emacs package provides an interface for Hydra and
Cuirass (build farms used by Nix and Guix).  It allows you to look at
various data related to the build farm projects, jobsets, builds and
evaluations.  The entry point is @code{M-x build-farm} command.")
    (license license:gpl3+)))

(define-public emacs-d-mode
  (package
    (name "emacs-d-mode")
    (version "2.0.12")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Emacs-D-Mode-Maintainers/Emacs-D-Mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mwd412d2kha8avkyhvvkh8r7an859xk18f7phgx7kj989pr3xkr"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-undercover))
    (home-page "https://github.com/Emacs-D-Mode-Maintainers/Emacs-D-Mode")
    (synopsis "Emacs major mode for editing D code")
    (description "This package provides an Emacs major mode for highlighting
code written in the D programming language.")
    (license license:gpl2+)))

(define-public emacs-extempore-mode
  ;; Use the latest commit at time of packaging.  There are no releases or tags.
  (let ((commit "09518ae6650d7be33a4633a4c0f31b7130d04c6e")
        (revision "1"))
    (package
      (name "emacs-extempore-mode")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/extemporelang/extempore-emacs-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0hfza9lzdsz94gxhmzyp9fwviscv19rmnjgd0q613faayn11sjsp"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/extemporelang/extempore-emacs-mode")
      (synopsis "Emacs major mode for Extempore source files")
      (description
       "This package provides a major mode for editing Extempore code.  It can
create an Extempore REPL, connect the current @code{extempore-mode} buffer to a
running Extempore process, and more.")
      (license license:bsd-2))))

(define-public emacs-kakoune
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file.
  (let ((commit "d73d14e69ea38076af50cc69f846808383ff539d")
        (revision "0"))
    (package
      (name "emacs-kakoune")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jmorag/kakoune.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0nk6jdy1y5mc3ryd0smiqghrk6iv34d5grc7f7migmshlbq0np92"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-expand-region emacs-multiple-cursors emacs-ryo-modal))
      (home-page "https://github.com/jmorag/kakoune.el")
      (synopsis "Emacs simple simulation, but not emulation, of Kakoune")
      (description "This package provides many, but not all of the editing
primitives in the Kakoune editor.  Unlike Evil mode for Vim, this is a very
shallow emulation, which seeks to do as little work as possible, leveraging
Emacs native editing commands and the work of other packages wherever
possible.")
      (license license:expat))))

(define-public emacs-kana
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file.
  (let ((commit "b239c3c3c6124b46ff720cca7b80ecbafd7fa489")
        (revision "0"))
    (package
      (name "emacs-kana")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/chenyanming/kana")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0vrrl1kniq4h111jvnapvx3wybvsl3alfaygw634mmryr3h7pwi8"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/chenyanming/kana")
      (synopsis "Learn Japanese Kana in Emacs")
      (description
       "This Emacs mode displays Hiragana and Katakana flashcards.  It can use
functionality from Emacs Kanji mode if it is installed.")
      (license license:gpl3+))))

(define-public emacs-kanji
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file.
  (let ((commit "5e9d5b72468ece11cfb81b729be6babf63ede425")
        (revision "0"))
    (package
      (name "emacs-kanji")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/wsgac/kanji-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1zh7klqaza840q5f44zzh1wrnd6sqa2k93z3dgx3yhhsxfd1dxvy"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/wsgac/kanji-mode")
      (synopsis "Emacs minor mode for displaying Japanese Kanji stroke order")
      (description
       "This minor mode displays the stroke order of the Kanji sign under
cursor in a transient buffer.  It has a built-in collection of SVG images
depicting stroke orders for all Kanji.  The collection is a slightly modified
and limited version of the images provided by the KanjiVG project.")
      (license license:gpl3+))))

(define-public emacs-kbd
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file.
  (let ((commit "a7f4c9b9770fa6a58895c5f121df82652bb1b737")
        (revision "0"))
    (package
      (name "emacs-kbd")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/slotThe/kbd-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0jv9yfsncgf96308c041hvps3jlc151xb0aipm0vasbma3x83ygm"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'enter-lisp-directory
              (lambda _ (chdir "lisp"))))))
      (home-page "https://github.com/slotThe/kbd-mode")
      (synopsis "Minor mode for syntax highlighting kmonad's @file{.kbd} files")
      (description
       "This minor mode provides syntax highlighting for Lisp-like DSL used in
kmonad's configuration files (@file{.kbd}).")
      (license license:gpl3+))))

(define-public emacs-keycast
  (package
    (name "emacs-keycast")
    (version "1.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tarsius/keycast")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "01z20lsnjk8pwdsl4vx5dqdc4603bmb7fxan7n8j1fgvkvi63yzl"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tarsius/keycast")
    (synopsis "Show current command and its key in the mode line")
    (description
     "This package provides Keycast mode.  Once enabled, that mode shows the
current command and its key or mouse binding in the mode line, and updates
them whenever another command is invoked.")
    (license license:gpl3+)))

(define-public emacs-keyfreq
  (package
    (name "emacs-keyfreq")
    (version "20160516.716")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "http://melpa.org/packages/keyfreq-"
                           version ".el"))
       (sha256
        (base32
         "008hd7d06qskc3mx0bbdgpgy2pwxr8185fzlyqf9qjg49y74p6g8"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/dacap/keyfreq")
    (synopsis "Track Emacs command frequencies")
    (description "@code{emacs-keyfeq} tracks and shows how many times you used
a command.")
    (license license:gpl3+)))

(define-public emacs-olivetti
  (package
    (name "emacs-olivetti")
    (version "2.0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rnkn/olivetti")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0wc0rki4zvzdxs126g5c8d92h1vfn9slfkdx831rr9d0jx93wc7s"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rnkn/olivetti")
    (synopsis "Emacs minor mode for a nice writing environment")
    (description "This package provides an Emacs minor mode that puts writing
in the center.")
    (license license:gpl3+)))

(define-public emacs-undo-tree
  (package
    (name "emacs-undo-tree")
    (version "0.8.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/tsc25/undo-tree")
             (commit "42aab056e37e033816b2d192f9121b89410b958e"))) ; no 0.8.2 tag
       (file-name (git-file-name name version))
       (sha256
        (base32 "1xvkxc078b4z5zqwndz6jcv4ga8yd2ci32v7l8pdvqjmz7fq7bfz"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-queue))
    (home-page "https://www.dr-qubit.org/undo-tree.html")
    (synopsis "Treat undo history as a tree")
    (description
     "Tree-like interface to Emacs undo system, providing
graphical tree presentation of all previous states of buffer that
allows easily move between them.")
    (license license:gpl3+)))

(define-public emacs-undo-fu
  ;; There are no tagged releases upstream on gitlab, instead we are using
  ;; the most recent commit.
  (let ((commit "c0806c1903c5a0e4c69b6615cdc3366470a9b8ca")
        (revision "0"))
    (package
      (name "emacs-undo-fu")
      (version (git-version "0.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/ideasman42/emacs-undo-fu")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1n594aakmcgyl7qbda86v4wsx8clm62ypiv3h559xz3x72h7mr3j"))))
      (build-system emacs-build-system)
      (home-page "https://gitlab.com/ideasman42/emacs-undo-fu")
      (synopsis "Simple, stable linear undo with redo for Emacs")
      (description
       "This is a light weight wrapper for Emacs built-in undo system,
adding convenient undo/redo without losing access to the full undo history,
allowing you to visit all previous states of the document if you need.")
      (license license:gpl3+))))

(define-public emacs-undo-fu-session
  ;; There are no tagged releases upstream on gitlab, instead we are using the
  ;; most recent commit.
  (let ((commit "56cdd3538a058c6916bdf2d9010c2179f2505829")
        (revision "0"))
    (package
      (name "emacs-undo-fu-session")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/ideasman42/emacs-undo-fu-session")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "04wq1alrzzlidcb4mjb5j7pg68pks1vgv7kvvmi6dzb3l602mb2a"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #t
        #:test-command #~(list "emacs" "--batch" "-l" "undo-fu-session.el"
                               "-l" "undo-fu-session-test.el")
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'set-home
              (lambda _
                (setenv "HOME" "/tmp"))))))
      (home-page "https://gitlab.com/ideasman42/emacs-undo-fu-session")
      (synopsis "Save & recover undo steps between Emacs sessions")
      (description "This package writes undo/redo information upon file save
which is restored where possible when the file is loaded again.")
      (license license:gpl3+))))

(define-public emacs-s
  (package
    (name "emacs-s")
    (version "1.13.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magnars/s.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "010i92kagqbfis46n1ffa28fgkdkjp55n13b6f4izar5r7ixm6wx"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("./run-tests.sh")))
    (home-page "https://github.com/magnars/s.el")
    (synopsis "Emacs string manipulation library")
    (description "This package provides an Emacs library for manipulating
strings.")
    (license license:gpl3+)))

(define-public emacs-inflections
  (package
    (name "emacs-inflections")
    (version "2.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/eschulte/jump.el")
             (commit version)))
       (file-name (git-file-name name version))
       (snippet #~(begin (delete-file "jump.el")))
       (sha256
        (base32 "03fh7i6blnbc0zbmp83fk095hr3q4fdvrvfxad74zghcbc2nk7b7"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/eschulte/jump.el")
    (synopsis "Convert english words between singular and plural")
    (description "This package provides an Emacs library for converting
english words between singular and plural.")
    (license license:gpl3+)))

(define-public emacs-blight
  (let ((commit "6bf9c6192d2bf979eebbfae1963401ef3ff4ef5d")
        (revision "0"))
    (package
      (name "emacs-blight")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/emacs-weirdware/blight")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1x7s1fcva5kkl9iyb5grd6crf38rrz3zb0c6wb85khi9far10vgq"))))
      (build-system emacs-build-system)
      (home-page "https://codeberg.org/emacs-weirdware/blight")
      (synopsis "Control display brightness")
      (description
       "Blight allows you to control display brightness from Emacs.  It
features object-oriented code using EIEIO, a base class implementing
a reasonable API which focuses on the @emph{set the back light to this
percentage} functionality, it includes a concrete implementation that uses
SysFS to control brightness.  Other systems (D-Bus, xbacklight, XELB using
XRandR) are easily supportable, giving the same experience across
environments.")
      (license license:gpl3+))))

(define-public emacs-symon
  (package
    (name "emacs-symon")
    (version "20160630")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/zk-phi/symon")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1q7di9s8k710nx98wnqnbkkhdimrn0jf6z4xkm4c78l6s5idjwlz"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/zk-phi/symon")
    (synopsis "Tiny graphical system monitor")
    (description
     "Tiny graphical system monitor for the Emacs minibuffer when idle.")
    (license license:gpl2+)))

(define-public emacs-lemon
  (let ((commit "37a6e6d6ef0900ca19c820a2dbc122c7fe6d86cf")
        (revision "0"))
    (package
      (name "emacs-lemon")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/emacs-weirdware/lemon")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0bc77vzi4p6mlzmhgybbldlpcsiiv4xqrd5lnc7wzvmxv8byhqpm"))))
      (build-system emacs-build-system)
      (native-inputs
       (list emacs-blight emacs-emms))
      (propagated-inputs
       (list emacs-s))
      (home-page "https://codeberg.org/emacs-weirdware/lemon")
      (synopsis "System monitors in the echo area")
      (description
       "Lemon is a tiny system monitor which displays system information in
the echo area when Emacs is has been idle for a few seconds.  This is a fork
of zk_phi’s Symon, which has been largely rewritten.  It works nicely with
EXWM.")
      (license license:gpl3+))))

(define-public emacs-sx
  (let ((version "20191229")
        (revision "0")
        (commit "e9d1093c97507a6d7b4f4710ef65200dae725e5f"))
    (package
      (name "emacs-sx")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/vermiculus/sx.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0m90ddwm8j0y6d1ppqhd2gil1107k202blw6mzm5bdambn4nfqkf"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-markdown-mode))
      (home-page "https://github.com/vermiculus/sx.el")
      (synopsis "Emacs StackExchange client")
      (description
       "Emacs StackExchange client.  Ask and answer questions on
Stack Overflow, Super User, and other StackExchange sites.")
      (license license:gpl3+))))

(define-public emacs-skempo
  (package
    (name "emacs-skempo")
    (version "0.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/xFA25E/skempo")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0xsr6819qaad0y8rhfrf555c9w7cmgbgkf1a2svgbp7rhhnywl0a"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/xFA25E/skempo")
    (synopsis "Enhancements for skeleton/tempo + abbrev")
    (description
     "Skempo is an attempt to improve Emacs built-in Skeleton and Tempo
templates.  It tries to make a unified syntax for template definitions.  It
also adds tags and marks support for Skeleton, and Abbrev support for Tempo.")
    (license license:gpl3+)))

(define-public emacs-toc-org
  (package
    (name "emacs-toc-org")
    (version "1.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/snosov1/toc-org")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "00a2al7ghrlabf65kfj1mk30p2pl37h6ppwlgghbgiy7rwlzkdbm"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/snosov1/toc-org")
    (synopsis "Table of Contents generator for Emacs Org mode")
    (description
     "This package generates a table of contents when saving in Org and
Markdown files.")
    (license license:gpl2+)))

(define-public emacs-toml-mode
  (let ((version "0.1.3")
        (revision "0")
        (commit "f6c61817b00f9c4a3cab1bae9c309e0fc45cdd06"))
    (package
      (name "emacs-toml-mode")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dryman/toml-mode.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "05b4ksay85c8y5ncax0qsvnmplwsfiw24z16a58gkarjz938hb57"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/dryman/toml-mode.el")
      (synopsis "Emacs major mode for editing TOML files")
      (description
       ;; XXX: Ideally we'd use @acronym for "TOML", but Guile's Texinfo
       ;; parser does not currently support @comma{}, making it impossible
       ;; to use commas in the @acronym arguments.
       "This package provides a major mode for editing files in @dfn{TOML}
(Tom's Obvious, Minimal Language) data format.")
      (license license:gpl3+))))

(define-public emacs-twittering-mode
  (package
    (name "emacs-twittering-mode")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "mirror://sourceforge/twmode"
                           "/twittering-mode-" version
                           "/twittering-mode-" version ".tar.xz"))
       (sha256
        (base32 "02imis1gxz90lah0b5n37j2hlsaw5igss11d85vpsm5d1bgw8j28"))))
    (build-system emacs-build-system)
    (home-page "http://twmode.sourceforge.net")
    (synopsis "Emacs major mode for Twitter")
    (description
     "Twittering mode is an Emacs major mode for Twitter.
You can check timelines, tweet, mark posts as favorites and so on with
Emacs.")
    (license license:gpl2+)))

(define-public emacs-f
  (package
    (name "emacs-f")
    (version "0.20.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/rejeep/f.el")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1a47xk3yp1rp17fqg7ldl3d3fb888h0fz3sysqfdz1bfdgs8a9bk"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-s emacs-dash))
    (home-page "https://github.com/rejeep/f.el")
    (synopsis "Emacs API for working with files and directories")
    (description "This package provides an Emacs library for working with
files and directories.")
    (license license:gpl3+)))

(define-public emacs-fountain-mode
  (package
    (name "emacs-fountain-mode")
    (version "3.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rnkn/fountain-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14cb4r23pn98sxzh0qwjwpvm7k7q9hhpks8avydccwssm69x1s1w"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rnkn/fountain-mode")
    (synopsis "Major mode for screenwriting in Fountain markup")
    (description "Fountain Mode is a scriptwriting program for GNU Emacs
using the Fountain plain text markup format.")
    (license license:gpl3+)))

(define-public emacs-fringe-helper
  (let ((commit "ef4a9c023bae18ec1ddd7265f1f2d6d2e775efdd")
        (revision "1"))
    (package
      (name "emacs-fringe-helper")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/nschum/fringe-helper.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0ra9rc53l1gvkqank8apasl3r7wz2yfjrcvmfk3wpxhh24ppxv9d"))))
      (build-system emacs-build-system)
      (arguments
       `(#:tests? #t
         #:test-command '("emacs" "--batch"
                          "-l" "tests.el"
                          "-f" "ert-run-tests-batch-and-exit")))
      (home-page "https://github.com/nschum/fringe-helper.el")
      (synopsis "Helper functions for fringe bitmaps")
      (description
       "This package allows fringe bitmaps to be defined with a visual string
representation.")
      (license license:gpl2+))))

(define-public emacs-git-gutter
  (let ((commit "ec28e85d237065cb3c28db4b66d129da6d309f9c")
        (revision "0"))
    (package
      (name "emacs-git-gutter")
      (version (git-version "0.92" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/syohex/emacs-git-gutter")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1fx3jp65ibcsv8akd8g4k701cs8yq0sg1bd2qszzfh6lvc4pblmi"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/syohex/emacs-git-gutter")
      (synopsis "See and manage hunks of text in a version control system")
      (description
       "This package is an Emacs minor mode for displaying and interacting with
hunks of text managed in a version control system.  Added modified and deleted
areas can be indicated with symbols on the edge of the buffer, and commands
can be used to move between and perform actions on these hunks.

Git, Mercurial, Subversion and Bazaar are supported, and many parts of the
display and behaviour is easily customisable.")
      (license license:gpl3+))))

(define-public emacs-git-gutter-fringe
  (let ((commit "648cb5b57faec55711803cdc9434e55a733c3eba")
        (revision "2"))
    (package
      (name "emacs-git-gutter-fringe")
      (version (git-version "0.23" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsorphanage/git-gutter-fringe")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "13bqq5r8ys2mmw1ffsm6hn6fji0vq3nx3slw98c9dgbvlprkaiip"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-git-gutter emacs-fringe-helper))
      (home-page "https://github.com/emacsorphanage/git-gutter-fringe")
      (synopsis "See and manage hunks of text in a version control system")
      (description
       "This package extends @code{git-gutter} to use the fringe area of a
window.")
      (license license:gpl3+))))

(define-public emacs-git-link
  (package
    (name "emacs-git-link")
    (version "0.8.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sshaw/git-link")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ifq9z4p0rbz2bpm6qz89xg5ycn5fflsyradzzxzsgyys0zc6szx"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #t
      #:test-command #~(list "make" "test")))
    (home-page "https://github.com/sshaw/git-link")
    (synopsis "Create links for files and commits in GitHub/GitLab/etc. repos")
    (description
     "@code{git-link} returns the URL for the current buffer's file location
at the current line number or active region.  @code{git-link-commit} returns
the URL for a commit.  URLs are added to the kill ring.")
    (license license:gpl3+)))

(define-public emacs-frowny
  (package
    (name "emacs-frowny")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/duckwork/frowny.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "01ss3js71as1jpqcf0x9hfvapiyyhj9ni4y1n6wvqsghv5dcaiy0"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/duckwork/frowny.el")
    (synopsis "Insert frownies in Emacs :(")
    (description "This package ships @code{frowny-mode}, which makes it so that
inserting a single @code{(} when after a @code{:} will not automatically close
the parenthesis, meaning that only @code{:(} is inserted.  Works with
@code{electric-pair-mode}, @code{paredit-mode}, and others.")
    (license license:public-domain)))

(define-public emacs-apache-mode
  (package
    (name "emacs-apache-mode")
    (version "2.2.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacs-php/apache-mode")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1grs2x51k8pa6sgfa82s5pwwdfv7zw46ccw0zvd2rvzbhpq21p2z"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacs-php/apache-mode")
    (synopsis
     "Syntax highlighting and indentation support for Apache config files")
    (description
     "This package provides @code{apache-mode}, an Emacs major mode for Apache
configuration files which provides syntax highlighting and indentation rules.
This mode supports Apache HTTP Server 2.4 and major modules.")
    (license license:gpl2+)))

(define-public emacs-apheleia
  (package
    (name "emacs-apheleia")
    (version "3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/raxod502/apheleia")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1145zh7nqadgz5r2llwjwgj2aciv08mn2cpp3zlf0rf3awg86yg7"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/raxod502/apheleia")
    (synopsis "Reformat buffer stably")
    (description
     "This package allows for a buffer to be reformatted without moving point,
so that running a formatting tool like @code{Prettier} or @code{Black} upon
saving won't move point back to the beginning of the buffer.")
    (license license:gpl3+)))

(define-public emacs-git-timemachine
  (package
    (name "emacs-git-timemachine")
    (version "4.11")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/pidu/git-timemachine.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1pz4l1xnq6s67w5yq9107vm8dg7rqf8n9dmbn90jys97c722g70n"))))
    (build-system emacs-build-system)
    (home-page "https://gitlab.com/pidu/git-timemachine")
    (synopsis "Step through historic versions of Git-controlled files")
    (description "This package enables you to step through historic versions
of files under Git version control from within Emacs.")
    (license license:gpl3+)))

(define-public emacs-minitest
  (package
    (name "emacs-minitest")
    (version "0.9.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/arthurnn/minitest-emacs")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0d8kg68yy5x1y3ivj43vzcakb3gii6bh8jm40g4sah5f53bbrs16"))))
    (build-system emacs-build-system)
    (arguments
     '(#:include (cons "^snippets\\/minitest-mode\\/" %default-include)
       #:exclude (delete "^[^/]*tests?\\.el$" %default-exclude)))
    (propagated-inputs
     (list emacs-dash emacs-f))
    (home-page "https://github.com/arthurnn/minitest-emacs")
    (synopsis "Emacs minitest mode")
    (description
     "The minitest mode provides commands to run the tests for the current
file or line, as well as rerunning the previous tests, or all the tests for a
project.

This package also includes relevant snippets for yasnippet.")
    (license license:expat)))

(define-public emacs-gdscript-mode
  (package
    (name "emacs-gdscript-mode")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/godotengine/emacs-gdscript-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "09q0himrz7a6xgz0jmcl85qc5xhk5fwi6d2vw1n8qaiavm96ksdy"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/godotengine/emacs-gdscript-mode")
    (synopsis "GDScript support and syntax highlighting in Emacs")
    (description
     "This package adds support for the GDScript programming language from the
Godot game engine in Emacs. It features all the essentials, e.g., syntax
highlighting, code folding, indentation, automatic pairing, auto-completion,
and code formatting.")
    (license license:gpl3+)))

(define-public emacs-el-mock
  (package
    (name "emacs-el-mock")
    (version "1.25.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rejeep/el-mock.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13mv1rhgkwiww2wh5w926jz7idppp492wir1vdl245c5x50dh4f7"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rejeep/el-mock.el")
    (synopsis "Tiny mock and stub framework in Emacs Lisp")
    (description
     "Emacs Lisp Mock is a library for mocking and stubbing using readable
syntax.  Most commonly Emacs Lisp Mock is used in conjunction with Emacs Lisp
Expectations, but it can be used in other contexts.")
    (license license:gpl3+)))

(define-public emacs-ecukes
  (package
    (name "emacs-ecukes")
    (version "0.6.18")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ecukes/ecukes")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "182qgddfv8nd89y1l55rs5vm5i61ayc8cxbplb8zx0alnid9xrw1"))))
    (build-system emacs-build-system)
    (arguments
     `(#:include (cons* "^feature/" "^reporters/" "^templates/" %default-include)))
    (propagated-inputs
     (list emacs-ansi
           emacs-commander
           emacs-dash
           emacs-espuds
           emacs-f
           emacs-s))
    (home-page "https://github.com/ecukes/ecukes")
    (synopsis "Cucumber for Emacs")
    (description
     "This package provides Ecukes, a Cucumber-inspired integration testing
tool for Emacs.  Ecukes is not a complete clone of Cucumber and is not
intended to be.")
    (license license:gpl3+)))

(define-public emacs-ef-themes
  (package
    (name "emacs-ef-themes")
    (version "0.9.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~protesilaos/ef-themes")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1h1xlcbcay8wlmhzv7b5h6vrvwdwkzc171aa0rfja2xds4ry9k0m"))))
    (build-system emacs-build-system)
    (home-page "https://git.sr.ht/~protesilaos/ef-themes")
    (synopsis "Colorful and legible themes")
    (description
     "The Ef themes are a collection of light and dark themes for GNU Emacs
whose goal is to provide colorful yet legible options for users who want
something with a bit more flair than the Modus themes.")
    (license license:gpl3+)))

(define-public emacs-espuds
  (package
    (name "emacs-espuds")
    (version "0.3.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ecukes/espuds")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16r4j27j9yfdiy841w9q5ykkc6n3wrm7hvfacagb32mydk821ijg"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-s emacs-dash emacs-f))
    (home-page "https://github.com/ecukes/espuds")
    (synopsis "Common step definitions for Ecukes")
    (description "Espuds is a collection of the most commonly used step
definitions for testing with the Ecukes framework.")
    (license license:gpl3+)))

(define-public emacs-spark
  (let ((version "20160503")  ; no proper tag, use date of commit
        (commit "0bf148c3ede3b31d56fd75f347cdd0b0eae60025")
        (revision "1"))
    (package
      (name "emacs-spark")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alvinfrancis/spark")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1ykqr86j17mi95s08d9fp02d7ych1331b04dcqxzxnmpkhwngyj1"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/alvinfrancis/spark")
      (synopsis "Sparkline generation library for Emacs Lisp")
      (description "@code{emacs-spark} is a sparkline generation library for
Emacs Lisp.  It generates a sparkline string given a list of numbers.  It is a
port of @code{cl-spark} to Emacs Lisp.")
      (license license:expat))))

(define-public emacs-spray
  (let ((version "0.0.2") (revision "0")
        (commit "74d9dcfa2e8b38f96a43de9ab0eb13364300cb46"))
    (package
      (name "emacs-spray")
      (version (git-version version revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://git.sr.ht/~iank/spray")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1avbfr32dvff26kgvd5vgan99nb5c6al9kv5xbmy2rcls17py7r2"))))
      (build-system emacs-build-system)
      (home-page "https://git.sr.ht/~iank/spray")
      (synopsis "Speed reading mode for Emacs")
      (description
       "For speed reading, or just more enjoyable reading.  Narrows
the buffer to show one word at a time.  Adjust speed / pause as needed.")
      (license license:gpl3+))))

(define-public emacs-es-mode
  (package
    (name "emacs-es-mode")
    (version "4.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dakrone/es-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1qhfnd5anp5qrmravv7ks5ix763xnki2f5jwcyj70qyxwr0l60cg"))))
    (build-system emacs-build-system)
    (propagated-inputs
     ;; The version of org in Emacs 24.5 is not sufficient, and causes tables
     ;; to be rendered incorrectly
     (list emacs-dash emacs-org emacs-spark))
    (home-page "https://github.com/dakrone/es-mode")
    (synopsis "Major mode for editing Elasticsearch queries")
    (description "@code{es-mode} includes highlighting, completion and
indentation support for Elasticsearch queries.  Also supported are
@code{es-mode} blocks in @code{org-mode}, for which the results of queries can
be processed through @code{jq}, or in the case of aggregations, can be
rendered in to a table.  In addition, there is an @code{es-command-center}
mode, which displays information about Elasticsearch clusters.")
    (license license:gpl3+)))

(define-public emacs-expand-region
  (let ((commit "c5c4362741deebb0985a8a29f9b8b0e25160764a")
        (revision "1"))
    (package
    (name "emacs-expand-region")
    (version (git-version "0.11.0" revision commit))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magnars/expand-region.el")
             (commit commit)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "17h58v5mnggbrwrp61cwkqx8hzazkdqyz9p6s1hl9g2hys7zkb00"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/magnars/expand-region.el")
    (synopsis "Increase selected region by semantic units")
    (description
     "Expand region increases the selected region by semantic units.  Just
keep pressing the key until it selects what you want.  There's also
@code{er/contract-region} if you expand too far.")
    (license license:gpl3+))))

(define-public emacs-explain-pause-mode
  (let ((commit "2356c8c3639cbeeb9751744dbe737267849b4b51")
        (revision "0"))
    (package
      (name "emacs-explain-pause-mode")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/lastquestion/explain-pause-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0frnfwqal9mrnrz6q4v7vcai26ahaw81894arff1yjw372pfgv7v"))))
      (build-system emacs-build-system)
      (native-inputs
       (list emacs-buttercup))
      (arguments
       '(#:tests? #t
         #:phases
         (modify-phases %standard-phases
           ;; This causes the byte-compilation before unit-tests to fail.
           (add-after 'unpack 'remove-error-on-warn
             (lambda _
               (substitute* "Makefile"
                 (("--eval '\\(setq byte-compile-error-on-warn t\\)'") "")))))
         ;; Don't run case-tests as they will fail to create sockets because
         ;; the path is too long
         #:test-command '("make" "byte-compile" "unit-tests")
         ;; Parallel testing will cause the tests to run before
         ;; byte-compilation is finished
         #:parallel-tests? #f))
      (home-page "https://github.com/lastquestion/explain-pause-mode")
      (synopsis "Top-like interface to determine why Emacs paused")
      (description
       "This package monitors Emacs function calls and records their execution
time.  This information can be reviewed to determine what is causing the user
interface to pause.")
      (license license:gpl3+))))

(define-public emacs-filladapt
  (package
    (name "emacs-filladapt")
    (version "2.12.2")
    (source
      (origin
        (method url-fetch)
        (uri (string-append
               "https://elpa.gnu.org/packages/filladapt-"
               version ".el"))
        (sha256
          (base32
            "1cxyxfdjg1dsmn1jrl6b7xy03xr42fb6vyggh27s4dk417ils6yg"))))
    (build-system emacs-build-system)
    (home-page "http://elpa.gnu.org/packages/filladapt.html")
    (synopsis "Adaptive fill for Emacs")
    (description
     "This package provides functions which enhance the default behavior of
Emacs' Auto Fill mode and the commands @code{fill-paragraph},
@code{lisp-fill-paragraph}, @code{fill-region-as-paragraph}, and
@code{fill-region}.

The chief improvement is that the beginning of a line to be
filled is examined and, based on information gathered, an
appropriate value for fill-prefix is constructed.  Also the
boundaries of the current paragraph are located.  This occurs
only if the fill prefix is not already non-nil.

The net result of this is that blurbs of text that are offset
from left margin by asterisks, dashes, and/or spaces, numbered
examples, included text from USENET news articles, etc. are
generally filled correctly with no fuss.")
    (license license:gpl3+)))

(define-public emacs-fill-column-indicator
  (package
    (name "emacs-fill-column-indicator")
    (version "1.90")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alpaker/Fill-Column-Indicator")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0snjznxdwwfdgccdcvrnk467416r244r2r5qcm2sga8l0ha9gw9z"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/FillColumnIndicator")
    (synopsis "Graphically indicate the fill column")
    (description
     "Fill-column-indicator graphically indicates the location of the fill
column by drawing a thin line down the length of the editing window.")
    (license license:gpl3+)))

(define-public emacs-grep-a-lot
  (package
    (name "emacs-grep-a-lot")
    (version "1.0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ZungBang/emacs-grep-a-lot")
             (commit "9f9f645b9e308a0d887b66864ff97d0fca1ba4ad")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1f8262mrlinzgnn4m49hbj1hm3c1mvzza24py4b37sasn49546lw"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ZungBang/emacs-grep-a-lot")
    (synopsis "Enables multiple grep buffers in Emacs")
    (description
     "This Emacs package allows managing multiple grep buffers.")
    (license license:gpl3+)))

(define-public emacs-fd
  (package
    (name "emacs-fd")
    (version "0.1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/yqrashawn/fd-dired")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1fas0fpvym2lyzybwm44gly9jz6a2fpp72yxnwfbqqjkfgk9910y"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/yqrashawn/fd-dired")
    (synopsis "Dired-mode interface for fd result")
    (description "This package provides a dired-mode interface for fd's
result.")
    (license license:gpl3+)))

(define-public emacs-ripgrep
  (package
    (name "emacs-ripgrep")
    (version "0.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nlamirault/ripgrep.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1a5rdpmvsgsjlc9sywism9pq7jd6n9qbcdsvpbfkq1npwhpifkbj"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; The repository contains both ripgrep and projectile-ripgrep
         ;; packages. The latter has been merged into projectile itself.
         (add-after 'unpack 'delete-projectile-ripgrep
           (lambda _
             (delete-file "projectile-ripgrep.el"))))))
    (propagated-inputs
     (list ripgrep))
    (home-page "https://github.com/nlamirault/ripgrep.el")
    (synopsis "Search using ripgrep from inside Emacs")
    (description "@code{ripgrep} is an Emacs search package based on the
@command{ripgrep} command line tool.")
    (license license:gpl2+)))

(define-public emacs-rg
  (package
    (name "emacs-rg")
    (version "2.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dajva/rg.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nxzplpk5cf6hhr2v85bmg68i6am96shi2zq7m83fs96bilhwsp5"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'remove-rg-path
            ;; Remove the path to ripgrep so that it works on remote systems.
            (lambda _
              (let ((file "rg.el"))
                (make-file-writable file)
                (emacs-substitute-sexps file
                  ("(defcustom rg-executable" "rg"))))))))
    (propagated-inputs
     (list emacs-s emacs-wgrep ripgrep))
    (home-page "https://rgel.readthedocs.io/en/latest/")
    (synopsis "Search tool based on @code{ripgrep}")
    (description
     "@code{rg} is an Emacs search package based on the @code{ripgrep} command
line tool.  It allows one to interactively search based on the editing context
then refine or modify the search results.")
    (license license:gpl3+)))

(define-public emacs-inf-ruby
  (package
    (name "emacs-inf-ruby")
    (version "2.5.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nonsequitur/inf-ruby")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0a1hhvfbl6mq8rjsi77fg9fh5a91hi5scjrg9rjqc5ffbql67y0v"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/nonsequitur/inf-ruby")
    (synopsis "Provides a REPL buffer connected to a Ruby subprocess in Emacs")
    (description
     "@code{inf-ruby} provides a Read Eval Print Loop (REPL) buffer, allowing
for easy interaction with a ruby subprocess.  Features include support for
detecting specific uses of Ruby, e.g. when using rails, and using a
appropriate console.")
    (license license:gpl3+)))

(define-public emacs-zig-mode
  (let ((commit "dbc648f5bca8f3b9ca2cc7827f326f5530115144")
        (revision "0"))
    (package
      (name "emacs-zig-mode")
      (version (git-version "0.0.8" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ziglang/zig-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0hwkkwhc5b2pzyqa2h0xw8wxijsrp1fk70fhyv8hx19shzlc4la3"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #t
        #:emacs emacs
        #:test-command #~(list "emacs" "--batch"
                               "-l" "zig-mode.el"
                               "-f" "ert-run-tests-batch-and-exit")))
      (home-page "https://github.com/ziglang/zig-mode/")
      (synopsis "Zig mode for Emacs")
      (description
       "This package provides syntax highlighting and automatic indentation
for the Zig programming language in Emacs.")
      (license license:gpl3+))))

(define-public emacs-znc
  (package
    (name "emacs-znc")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sshirokov/ZNC.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ran86ycnays9s23wk3iczqqgnpbyx0lijiarx65am3jc1yzg5ia"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/sshirokov/ZNC.el")
    (synopsis "Make ERC and ZNC get along better")
    (description
     "This is a thin wrapper around @code{erc} that enables one to use the ZNC
IRC bouncer with ERC.")
    (license license:expat)))

(define-public emacs-erc-status-sidebar
  (let ((commit "ea4189a1dbfe60117359c36e681ad7c389e2968c")
        (revision "1"))
    (package
      (name "emacs-erc-status-sidebar")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/drewbarbs/erc-status-sidebar")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1hwlhzgx03z8891sblz56zdp8zj0izh72kxykgcnz5rrkyc3vfi3"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/drewbarbs/erc-status-sidebar")
      (synopsis "Hexchat-like activity overview for ERC channels")
      (description
       "This package provides a Hexchat-like status bar for joined channels in
ERC, an Emacs client for IRC (Internet Relay Chat).  It relies on the
@code{erc-track} module, and displays all the same information
@code{erc-track} does in the mode line, but in an alternative format.")
      (license license:gpl3+))))

(define-public emacs-shut-up
  (package
    (name "emacs-shut-up")
    (version "0.3.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cask/shut-up")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1bnmrwrhra6cpc3jjgwwzrydj5ps7q2dlkh2ag4j7rkyv4dlk351"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/cask/shut-up")
    (synopsis "Silence Emacs")
    (description "This package silences most output of Emacs when running an
Emacs shell script.")
    (license license:expat)))

(define-public emacs-undercover
  (package
    (name "emacs-undercover")
    (version "0.8.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sviridov/undercover.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0qmvyy3xg5qi7ws8zcs934d6afsappr1a6pgfp796xpa9vdr4y6j"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-shut-up))
    (home-page "https://github.com/sviridov/undercover.el")
    (synopsis "Test coverage library for Emacs Lisp")
    (description
     "Undercover is a test coverage library for software written in Emacs
Lisp.")
    (license license:expat)))

(define-public emacs-paren-face
  (package
    (name "emacs-paren-face")
    (version "1.0.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tarsius/paren-face")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13d8psgd2j3vqmgwwf62gwyq7h6qlj8rrs31fxwjqmzzdblwqy1y"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tarsius/paren-face")
    (synopsis "Face for parentheses in Lisp modes")
    (description
     "This library defines a face named @code{parenthesis} used just for
parentheses.  The intended purpose of this face is to make parentheses less
visible in Lisp code by dimming them.  Lispers probably don't need to be
constantly made aware of the existence of the parentheses.  Dimming them might
be even more useful for people new to Lisp who have not yet learned to
subconsciously blend out the parentheses.")
    (license license:gpl3+)))

(define-public emacs-page-break-lines
  (package
    (name "emacs-page-break-lines")
    (version "0.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/page-break-lines")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0plfyzmh93x1r3zgfjyx23cc7vi1pcniipclzlms1iwfkl7zsqvp"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/page-break-lines")
    (synopsis "Display page breaks as tidy horizontal lines")
    (description
     "This library provides a global mode which displays form feed characters
as horizontal rules.")
    (license license:gpl3+)))

(define-public emacs-simple-httpd
  (package
    (name "emacs-simple-httpd")
    (version "1.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/skeeto/emacs-web-server")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0dpn92rg813c4pq7a1vzj3znyxzp2lmvxqz6pzcqi0l2xn5r3wvb"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/skeeto/emacs-web-server")
    (synopsis "HTTP server in pure Emacs Lisp")
    (description
     "This package provides a simple HTTP server written in Emacs Lisp to
serve files and directory listings.")
    (license license:unlicense)))

(define-public emacs-skewer-mode
  (package
    (name "emacs-skewer-mode")
    (version "1.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/skeeto/skewer-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ha7jl7776pk1bki5zj2q0jy66450mn8xr3aqjc0m9kj3gc9qxgw"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-simple-httpd emacs-js2-mode))
    (arguments '(#:include '("\\.el$" "\\.js$" "\\.html$")))
    (home-page "https://github.com/skeeto/skewer-mode")
    (synopsis "Live web development in Emacs")
    (description
     "Skewer-mode provides live interaction with JavaScript, CSS, and HTML in
a web browser.  Expressions are sent on-the-fly from an editing buffer to be
evaluated in the browser, just like Emacs does with an inferior Lisp process
in Lisp modes.")
    (license license:unlicense)))

(define-public emacs-litable
  (let ((commit "b0278f3f8dcff424bfbdfdefb545b1fbff33206f"))
    (package
      (name "emacs-litable")
      (version (git-version "0.1" "0" commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/Fuco1/litable")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0bny40hv9a024n01clxns351cs4j4ifhgcc7m4743xncqf612p7g"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash))
      (home-page "https://github.com/Fuco1/litable/")
      (synopsis "Dynamic evaluation replacement with Emacs")
      (description "This package provides dynamic evaluation in Emacs.")
      (license license:gpl3+))))

(define-public emacs-literate-elisp
  (package
    (name "emacs-literate-elisp")
    (version "0.8")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/jingtaozf/literate-elisp")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32 "0i9468rh61l4xq918fgwk6li93lpm6zbn0lkpxr7pbvkgrl5xsr6"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/jingtaozf/literate-elisp/tags")
    (synopsis "Load Emacs Lisp code blocks from Org files")
    (description
     "Literate-Elisp is an Emacs lisp library to provide an easy way to use
literal programming in Emacs lisp.  It extends the Emacs load mechanism so
Emacs can load Org files as Lisp source files directly.")
    (license license:gpl3+)))

(define-public emacs-literate-calc-mode
  (let ((commit "ba7d22140a165b0fdd900a8d04916115ca6ab8ff")
        (revision "2"))
    (package
      (name "emacs-literate-calc-mode")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sulami/literate-calc-mode.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1bdybw44pmhfpikdv1kg2sx88546xyncks5a4b2s0ak4p66r82k3"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-s))
      (home-page "https://github.com/sulami/literate-calc-mode.el")
      (synopsis "Literate programming for Emacs Calc")
      (description
       "This library provides literate programming for Calc.  There is both
a major and a minor mode.  The major mode does some basic syntax highlighting,
while the minor mode only evaluates all Calc statements while typing.  In
particular, the minor mode works quite well with Org or Markdown modes, or
other markup language major modes.")
      (license license:gpl3+))))

(define-public emacs-standard-dirs
  (package
    (name "emacs-standard-dirs")
    (version "2.0.0")
    (home-page "https://github.com/lafrenierejm/standard-dirs.el")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0r814qcrhvx4qlx4sdzwdmrhiryslqclx0bnpp0qcrbx6g8qfl25"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-f emacs-s))
    (synopsis "Platform-specific paths for config, cache, and other data")
    (description
     "This package provides platform-specific paths for reading and writing
configuration, cache, and other data.")
    (license license:gpl3+)))

(define-public emacs-string-inflection
  (package
    (name "emacs-string-inflection")
    (version "1.0.16")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/akicho8/string-inflection")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0wskrp3v5gi3b3s9471ijkdncnfd888qd50c72rv2p8846174paj"))))
    (build-system emacs-build-system)
    (native-inputs
     (list emacs-ert-runner))
    (arguments
     `(#:tests? #t
       #:test-command '("ert-runner")))
    (home-page "https://github.com/akicho8/string-inflection")
    (synopsis "Convert symbol names between different naming conventions")
    (description
     "This Emacs package provides convenient methods for manipulating the
naming style of a symbol.  It supports different naming conventions such as:

@enumerate
@item camel case
@item Pascal case
@item all upper case
@item lower case separated by underscore
@item etc...
@end enumerate\n")
    (license license:gpl2+)))

(define-public emacs-stripe-buffer
  (package
    (name "emacs-stripe-buffer")
    (version "0.2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sabof/stripe-buffer")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "035ym1c1vzg6hjsnd258z4dkrfc11lj4c0y4gpgybhk54dq3w9dk"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/sabof/stripe-buffer/")
    (synopsis "Add stripes to list buffers")
    (description
     "This Emacs package adds faces to add stripes to list buffers and org
tables.")
    (license license:gpl2+)))

(define-public emacs-org-beautify-theme
  ;; Latest release (0.4) is not tagged, use commit hash.
  (let ((commit "df6a1114fda313e1689363e196c8284fbe2a2738")
        (revision "0"))
    (package
      (name "emacs-org-beautify-theme")
      (version "0.4")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jonnay/org-beautify-theme")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1lkz7736swimad12khwbbqc4gxjydgr1k45p4mx03s25pv1w920y"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/jonnay/org-beautify-theme")
      (synopsis "Theme to make Org mode look more beautiful")
      (description
       "The theme adds padding between headings, increases the size of titles,
strike through completed TODO headings, changes Org blocks, changes Org check
boxes, and more.")
      (license license:gpl3+))))

(define-public emacs-org-books
  (package
    (name "emacs-org-books")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/lepisma/org-books")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1sgckvpjdaig9r2clcvs6ckgf2kx7amikkpq26y30jbnfnbskf0v"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash
           emacs-enlive
           emacs-helm
           emacs-helm-org
           emacs-org
           emacs-s))
    (home-page "https://github.com/lepisma/org-books")
    (synopsis "Reading list management with Org mode and Helm")
    (description
     "Org Books is a tool for managing reading lists in an Org mode file.")
    (license license:gpl3+)))

(define-public emacs-org-chef
  ;; Upstream does not tag version bumps.  Version is extracted from "Version"
  ;; keyword in main file.
  (let ((commit "87e9a6c4844ff32f47c8d1108ec0f087a3148a8e")
        (revision "0"))
    (package
      (name "emacs-org-chef")
      (version (git-version "0.1.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Chobbes/org-chef")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0xdfaf3shl3iij7nnshb5ryccqq70rpk0zm0d3fdwdbfa8rf7fkp"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-org))
      (home-page "https://github.com/Chobbes/org-chef")
      (synopsis "Cookbook and recipe management with Emacs Org mode")
      (description
       "Org Chef is a package for managing recipes in Org mode.  One of the
main features is that it can automatically extract recipes from websites like
allrecipes.com.")
      (license license:expat))))

(define-public emacs-org-inline-pdf
  (package
    (name "emacs-org-inline-pdf")
    (version "0.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/shg/org-inline-pdf.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1qc92xvgxmnwjixk8bxwbc1l1jj0qk9dg73jyaip6lk4g0wjk6xf"))))
    (build-system emacs-build-system)
    (inputs
     (list pdf2svg))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-exec-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((pdf2svg (assoc-ref inputs "pdf2svg")))
               (substitute* "org-inline-pdf.el"
                 (("\"pdf2svg\"") (string-append "\"" pdf2svg "/bin/pdf2svg\"")))))))))
    (home-page "https://github.com/shg/org-inline-pdf.el")
    (synopsis "Inline PDF previewing for Org")
    (description "This package provides a minor mode that enables
inline PDF preview in Org buffers by using pdf2svg.")
    (license license:gpl3+)))

(define-public emacs-org-rainbow-tags
  ;; Upstream didn't tag version.
  (let ((commit "c6040d228c5e8c5c6d33c7f81fc09d935ad1bcbd"))
    (package
      (name "emacs-org-rainbow-tags")
      (version "0.1-pre")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/KaratasFurkan/org-rainbow-tags")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "006nx01sby8k0fc9lf63ldf0sl94ihldyrvqr9r18fb1gpzvivl6"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/KaratasFurkan/org-rainbow-tags")
      (synopsis "Colorize Org tags automatically")
      (description
       "This package adds random colors to your Org tags.  In order to make
colors random but consistent between same tags, colors are generated from the
hash of the tag names.")
      (license license:gpl3+))))

(define-public emacs-org-rich-yank
  (package
    (name "emacs-org-rich-yank")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/unhammer/org-rich-yank")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0gxb0fnh5gxjmld0hnk5hli0cvdd8gjd27m30bk2b80kwldxlq1z"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/unhammer/org-rich-yank")
    (synopsis "Automatically surround source code pasted into Org with
@code{#+BEGIN_SRC} blocks")
    (description
     "This package provides a utility function for Org buffers that makes a
@code{_SRC} block with the appropriate language annotation for code that has
been copied from an Emacs major mode.")
    (license license:gpl2+)))

(define-public emacs-org-fancy-priorities
  (let ((commit "819bb993b71e7253cefef7047306ab4e0f9d0a86")
        (revision "1"))
    (package
      (name "emacs-org-fancy-priorities")
      (version (git-version "1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/harrybournis/org-fancy-priorities.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "13cyzlx0415i953prq6ch7r5iy23c1pz116bdxi5yqags4igh4wv"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/harrybournis/org-fancy-priorities")
      (synopsis "Display org priorities as custom strings")
      (description
       "This package provides a minor mode that displays Org priorities as
custom strings.  This mode does not change your files in any way, it only
displays the priority part of a heading as your preferred string value.")
      (license license:expat))))

(define-public emacs-org-fragtog
  (package
    (name "emacs-org-fragtog")
    (version "0.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/io12/org-fragtog")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1xag0pdphigk0ilrj2hacai3p6xgl27jji08aa1zlhq7p3rbay7m"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-org))
    (home-page "https://github.com/io12/org-fragtog")
    (synopsis "Toggle Org mode LaTeX fragments preview at cursor")
    (description
     "Org mode supports inline image previews of LaTeX fragments.  This
package automates this, so fragment previews are disabled for editing when
your cursor steps onto them, and re-enabled when the cursor leaves.")
    (license license:gpl3+)))

(define-public emacs-ob-erlang
  (let ((revision "1")
        (commit "a029c23902b4ad73b84f262a7fc5b98d87b63dfd"))
    (package
      (name "emacs-ob-erlang")
      (version (git-version "20210321" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/xfwduke/ob-erlang")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1dlb9qgmijff4giglwb358g5zzyjbnay0wkr5spks1bawvyxpiyl"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/xfwduke/ob-erlang/")
      (synopsis "Org-babel support for Erlang")
      (description "This package adds support for working with Erlang code
blocks with @code{org-babel} in @code{org-mode}.")
      (license license:gpl3+))))

(define-public emacs-ob-restclient
  (let ((commit "1b021ce1c67c97fa1aa4d2c0816edb7add129e48"))
    (package
      (name "emacs-ob-restclient")
      (version (git-version "0.02" "3" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alf/ob-restclient.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1bcjj01q5n9w2cch6brbz8pzwnwsmdlgaa4sf5s97b9frmqb2ffg"))))
      (propagated-inputs
       (list emacs-restclient))
      (build-system emacs-build-system)
      (home-page "https://github.com/alf/ob-restclient.el")
      (synopsis "Org-babel functionality for @code{restclient-mode}")
      (description
       "This package integrates @code{restclient-mode} with Org.")
      (license license:gpl3+))))

(define-public emacs-org-now
  (let ((commit "8f6b277a73f1c66e58ccb4b7f40d406851befc91"))
    (package
      (name "emacs-org-now")
      (version (git-version "0.1-pre" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alphapapa/org-now")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "117zzkryznznk6h4i1jqzdn888nl019xrgxm2gza0lndx8dxsg2c"))))
      (propagated-inputs
       (list emacs-dash))
      (build-system emacs-build-system)
      (home-page "https://github.com/alphapapa/org-now")
      (synopsis "Show current Org tasks in a sidebar")
      (description
       "This package provides commands to show Org headings in a sidebar
window while working on them.  After defining one heading as the \"now\"
heading, other headings can be refiled to it with one command, and back to
their original location with another.")
      (license license:gpl3+))))

(define-public emacs-orgmdb
  (package
    (name "emacs-orgmdb")
    (version "0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/isamert/orgmdb.el")
             (commit "66c13abdb84e0f0a31bae6cfda27478771d58d8e")))
       (sha256
        (base32
         "1hvxha0ih9jhvwj07l6jnpf2vzhgvb6ii73g49c8saxld61l0frf"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'configure
                 (lambda* (#:key inputs #:allow-other-keys)
                   (substitute* "orgmdb.el"
                     (("\"fd ")
                      (string-append "\""
                                     (search-input-file inputs "/bin/fd")
                                     " "))))))))
    (inputs
     (list fd))
    (propagated-inputs
     (list emacs-dash emacs-org emacs-s))
    (home-page "https://github.com/isamert/orgmdb.el")
    (synopsis "Emacs' Org mode watchlist manager and OMDb API client")
    (description "This package adds tools for managing your watchlist in Emacs'
Org mode and some functions for interacting with the OMDb API.")
    (license license:gpl3+)))

(define-public emacs-rich-minority
  (package
    (name "emacs-rich-minority")
    (version "1.0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Malabarba/rich-minority")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1kn7c9qr9ykj68iqffzzmjsr6aazwac8cxb7j960sjb282rq0yyj"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Malabarba/rich-minority")
    (synopsis "Clean-up and beautify the list of minor modes")
    (description
     "This Emacs package hides and/or highlights minor modes in the
mode-line.")
    (license license:gpl2+)))

(define-public emacs-robe
  (package
    (name "emacs-robe")
    (version "0.8.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dgutov/robe")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1xbj7wi389n6pxfvxrakvhylkdlqg8ll9ad2zmxggcchygwah6nl"))))
    (build-system emacs-build-system)
    (arguments
     '(#:include (cons "^lib\\/" %default-include)))
    (propagated-inputs
     (list emacs-inf-ruby))
    (home-page "https://github.com/dgutov/robe")
    (synopsis "Ruby code assistance tool for Emacs")
    (description
     "Robe can provide information on loaded classes and modules in Ruby code,
as well as where methods are defined.  This allows the user to jump to method
definitions, modules and classes, display method documentation and provide
method and constant name completion.")
    (license license:gpl3+)))

(define-public emacs-robot-mode
  (package
    (name "emacs-robot-mode")
    (version "0.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kopoli/robot-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10i4lwjf60ms3dj8s7k9c0vb24rhszskhciz9lijphcdh8k622hz"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/kopoli/robot-mode")
    (synopsis "Emacs mode for Robot Framework")
    (description
     "This major mode facilitates editing Robot Framework source files with
features such as syntax highlighting, comments, finding keywords, completing
keywords and smart indentation.")
    (license license:gpl3+)))

(define-public emacs-robot-log
  (package
    (name "emacs-robot-log")
    (version "0.1.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://git.sr.ht/~apteryx/emacs-robot-log")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1l9yxryrhvylh2x17cczd8v8978w1nv8173d4l9hv0cr26kp5b68"))))
    (build-system emacs-build-system)
    (native-inputs (list python-robotframework))
    (arguments (list #:tests? #t))
    (home-page "https://sr.ht/~apteryx/emacs-robot-log/")
    (synopsis "Emacs major mode for viewing RobotFramework debug log files")
    (description "@code{robot-log} is an Emacs major mode that allows more
easily viewing and navigating RobotFramework debug log files.  It provides
syntax highlighting and convenient shortcuts to move from one keyword to the
next, or locate errors.")
    (license license:gpl3+)))

(define-public emacs-robots-txt-mode
  (package
    (name "emacs-robots-txt-mode")
    (version "0.0.9")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacs-php/robots-txt-mode")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "07255pn80w4742sz2h9vbmfxxd8ps2kcn73p7m2bgy02kgbzw42b"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacs-php/robots-txt-mode")
    (synopsis "Syntax highlighting for @file{robots.txt} files")
    (description "This package provides an Emacs major mode for editing
@file{robots.txt} files.")
    (license license:gpl3+)))

(define-public emacs-roguel-ike
  (package
    (name "emacs-roguel-ike")
    (version "0.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/stevenremot/roguel-ike")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0rgv4y9aa5cc2ddz3y5z8d22xmr8kf5c60h0r3g8h91jmcw3rb4z"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-popup))
    (arguments
     (list
      #:include #~(cons* "^roguel-ike/" "^roguel-ike-lib/" %default-include)
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'set-test-environment
            (lambda _
              (setenv "HOME" "/tmp"))))))
    (home-page "https://github.com/stevenremot/roguel-ike.git")
    (synopsis "Coffee-break roguelike for Emacs")
    (description
     "Roguel-ike is an attempt to develop a coffee-break roguelike for
Emacs.  The complete game would allow the player to create various characters
and to make them fulfill challenges like arena fight and short dungeon
explorations.")
    (license license:gpl3+)))

(define-public emacs-rspec
  (let ((commit "66ea7cc9699d6edc6115daa024818adbd85efc20")
        (revision "1"))
    (package
      (name "emacs-rspec")
      (version (git-version "1.11" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pezra/rspec-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0b11s8r0pi7ah54km4yg4fqff8wkk409d25qnlwm1l94pdwjd1c8"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include (cons "^snippets\\/rspec-mode\\/" %default-include)
         #:tests? #t
         #:test-command '("make" "test")))
      (home-page "https://github.com/pezra/rspec-mode")
      (synopsis "Provides a rspec mode for working with RSpec")
      (description
       "The Emacs RSpec mode provides keybindings for Ruby source files, e.g. to
verify the spec associated with the current buffer, or entire project, as well
as moving between the spec files, and corresponding code files.

Also included are keybindings for spec files and Dired buffers, as well as
snippets for yasnippet.")
      (license license:gpl3+))))

(define-public emacs-mode-line-idle
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file.
  (let ((commit "02b1da6278e43cc9cc0356110cc6bfbb37eb8241")
	(revision "1"))
    (package
      (name "emacs-mode-line-idle")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (file-name (git-file-name name version))
         (uri (git-reference
               (url "https://gitlab.com/ideasman42/emacs-mode-line-idle")
               (commit commit)))
         (sha256
          (base32 "0ky330b2sfbzkbxbfp9b21hdywsjw26bllspglz08hrbni7jmry8"))))
      (build-system emacs-build-system)
      (home-page "https://gitlab.com/ideasman42/emacs-mode-line-idle")
      (synopsis "Simple delayed text evaluation for the mode-line")
      (description
       "Mode Line Idle provides a convenient way to defer text evaluation
which integrates into existing mode-line without requiring a minor mode or
configuration.")
      (license license:gpl3+))))

(define-public emacs-nyan-mode
  (package
    (name "emacs-nyan-mode")
    (version "1.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/TeMPOraL/nyan-mode/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0d0hdjliad8afz4br38gwidph9zhmm5s09y45n95kqlazq62jfsx"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons* "img/" "mus/" %default-include)
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-sources
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "nyan-mode.el"
                (("mplayer ")
                 (string-append (search-input-file inputs "bin/mplayer")
                                " "))))))))
    (inputs (list mplayer))
    (home-page "https://github.com/TeMPOraL/nyan-mode/")
    (synopsis "Nyan Cat as buffer position indicator")
    (description
     "Nyan mode is an analog indicator of your position in the buffer.  The cat
should go from left to right in your mode-line, as you move your point from 0%
to 100%.  You can click on the rainbow or the empty space to scroll backwards
and forwards and also animate it.")
    (license license:gpl3+)))

(define-public emacs-smart-mode-line
  (package
    (name "emacs-smart-mode-line")
    (version "2.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Malabarba/smart-mode-line")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1h5w5lrgrmhpaqwppg5msylh7z78mvwy9mm8xiiv8w4wxvncxxl2"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-rich-minority))
    (home-page "https://github.com/Malabarba/smart-mode-line")
    (synopsis "Color-coded smart mode-line")
    (description
     "Smart Mode Line is a mode-line theme for Emacs.  It aims to be easy to
read from small to large monitors by using colors, a prefix feature, and smart
truncation.")
    (license license:gpl2+)))

(define-public emacs-sqlite
  ;; XXX: There is no tagged commit.
  (let ((commit "dad42b8bbca4994be1871343dd18fd6528ee5797")
	(revision "0"))
    (package
      (name "emacs-sqlite")
      (build-system emacs-build-system)
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
	       (url "https://gitlab.com/cnngimenez/sqlite.el")
	       (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "06ln4vijl8kii3nzc5cscgsadx1fqgxksflijd3ain83bn8g4wrd"))))
      (home-page "https://gitlab.com/cnngimenez/sqlite.el")
      (synopsis "SQLite interface for Emacs Lisp")
      (description "Emacs SQLite is a simple SQLite interface for connecting
and retrieving information using the SQLite program through Elisp programming.
It is not intended as a user interface.")
      (license license:gpl3+))))

(define-public emacs-sqlite3-api
  (package
    (name "emacs-sqlite3-api")
    (version "0.16")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/pekingduck/emacs-sqlite3-api")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0yrfwb3yvhp1ib4izxh1ds68b3zw8gjkjhlk1kivarxnfjnjnly2"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? (not (%current-target-system))
      #:test-command #~(list "make" "test" "EMACS=emacs")
      #:modules '((guix build emacs-build-system)
                  (guix build emacs-utils)
                  (guix build utils))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-module-load
            (lambda _
              (make-file-writable "sqlite3.el")
              (emacs-substitute-sexps "sqlite3.el"
                ("(require 'sqlite3-api nil t)"
                 (string-append
                  "(module-load \"" #$output "/lib/sqlite3-api.so\")")))))
          (add-before 'check 'build-emacs-module
            (lambda _
              ;; Remove code that fetches constants from the SQLite website
              ;; and the call to generate a timestamp.
              (invoke "sed" "--in-place" "3,4d;24,28d;31d" "tools/gen-consts.sh")
              ;; Remove filter logic from the script that generates the constants.
              (invoke "sed" "--in-place" "7,11d;18,22d" "tools/gen-consts.py")
              ;; Generate the consts.c file.
              (invoke "make" "--directory=tools")
              ;; Remove the SQLITE_STATIC and SQLITE_TRANSIENT
              ;; constants. They cause a compilation warning and would have
              ;; been removed by the original script.
              (invoke "sed" "--in-place" "/ifdef SQLITE_STATIC/,+2d" "consts.c")
              (invoke "sed" "--in-place" "/ifdef SQLITE_TRANSIENT/,+2d" "consts.c")
              ;; Compile the shared object file.
              (invoke "make" #$(string-append "CC=" (cc-for-target)))
              ;; Move the shared object file into /lib.
              (install-file "sqlite3-api.so"
                            (string-append #$output "/lib")))))))
    (native-inputs (list python sed))
    (inputs (list sqlite))
    (home-page "https://github.com/pekingduck/emacs-sqlite3-api")
    (synopsis "Dynamic module for Emacs to access the SQLite C interface")
    (description "This package provides a dynamic module for Emacs that allows
direct access to the SQLite C interface.  It only exposes a subset of the full
SQLite C interface, but should satisfy most user's needs.")
    (license license:gpl3+)))

(define-public emacs-sr-speedbar
  (let ((commit "77a83fb50f763a465c021eca7343243f465b4a47")
        (revision "0"))
    (package
      (name "emacs-sr-speedbar")
      (version (git-version "20161025" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsorphanage/sr-speedbar")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0sd12555hk7z721y00kv3crdybvcn1i08wmd148z5imayzibj153"))))
      (build-system emacs-build-system)
      (home-page "https://www.emacswiki.org/emacs/SrSpeedbar")
      (synopsis "Same frame Emacs @code{speedbar}")
      (description
       "This Emacs package allows you to show @code{M-x speedbar} in the
same frame (in an extra window).  You can customize the initial width of
the speedbar window.")
      (license license:gpl3+))))

(define-public emacs-shell-switcher
  (package
    (name "emacs-shell-switcher")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/DamienCassou/shell-switcher")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ia7sdip4hl27avckv3qpqgm3k4ynvp3xxq1cy53bqfzzx0gcria"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/DamienCassou/shell-switcher")
    (synopsis "Provide fast switching between shell buffers")
    (description
     "This package provides commands to quickly switch between shell buffers.")
    (license license:gpl3+)))

(define-public emacs-shx
  (package
    (name "emacs-shx")
    (version "1.5.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/riscy/shx-for-emacs")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32 "1cb5w6p9gnfxgh8qp7yj2f5ibpk1b4b5af3ynldaaj6yfpa8hqzn"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command
       '("emacs" "--batch" "--quiet"
         "--script" "test/script.el")))
    (home-page "https://github.com/riscy/shx-for-emacs")
    (synopsis "Extras for the comint-mode shell")
    (description
     "This package extends @code{comint-mode}: it parses markup in the output
stream, enabling plots and graphics to be embedded, and adds command-line
functions which plug into Emacs (e.g. use @code{:e <filename>} to edit a
file).")
    (license license:gpl3+)))

(define-public emacs-names
  (let ((commit "d8baba5360e5253938a25d3e005455b6d2d86971")
        (version "20151201.0")
        (revision "8"))
    (package
      (name "emacs-names")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Malabarba/names")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "11wyha2q8y7bzqq3jrzix8n97ywvsibvddrahqcps1a1yqk4hzfz"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/Malabarba/names/")
      (synopsis "Namespace implementation for Emacs Lisp")
      (description
       "This package provides a macro that writes your namespaces for you.")
      (license license:gpl3+))))

(define-public emacs-nameless
  (package
    (name "emacs-nameless")
    (version "1.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Malabarba/Nameless")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "107q1rximjnag9r9vgwh0iv687i3rsscbdnjc46f8l16j6vi4n7d"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Malabarba/nameless")
    (synopsis "Hide package namespace in your Emacs-lisp code")
    (description
     "This package provides a @code{nameless-mode} minor mode in which the
package namespace prefix is ​​hidden by a colon.")
    (license license:gpl2+)))

(define-public emacs-evil-leader
  (package
    (name "emacs-evil-leader")
    (version "0.4.3")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/cofi/evil-leader")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1k2zinchs0jjllp8zkpggckyy63dkyi5yig3p46vh4w45jdzysk5"))))
    (inputs
     (list emacs-evil))
    (build-system emacs-build-system)
    (home-page "https://github.com/cofi/evil-leader")
    (synopsis "Implement <leader> feature from Vim")
    (description
     "Evil Leader provides the @code{<leader>} feature from Vim that provides
an easy way to bind keys under a configurable prefix key.")
    (license license:gpl3+)))

(define-public emacs-evil-tex
  (package
    (name "emacs-evil-tex")
    (version "1.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/iyefrat/evil-tex")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1wrx8ihimn1sx3vzzfppcwv0yfh3x95jrkxqvzj0ykckipm3zk0b"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'set-home
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list emacs-auctex emacs-evil))
    (home-page "https://github.com/iyefrat/evil-tex")
    (synopsis "Evil oriented additions for editing LaTeX")
    (description "This package is a toolbox for LaTeX editing with Evil.  It
provides many text objects fully utilizing @code{evil-surround}, some useful
movements, and keymaps for quickly entering environments or
@code{cdlatex}-like accents.")
    (license license:gpl3+)))

(define-public emacs-evil-textobj-syntax
  (let ((commit "2d9ba8c75c754b409aea7469f46a5cfa52a872f3")
        (version "0")
        (revision "1"))
    (package
      (name "emacs-evil-textobj-syntax")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/laishulu/evil-textobj-syntax/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "031p5i3274dazp7rz6m5y38shfgszm1clmkcf58qfqlvy978ammc"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil emacs-names))
      (home-page "https://github.com/laishulu/evil-textobj-syntax/")
      (synopsis "Text objects based on syntax highlighting")
      (description
       "This package provides text objects for @code{evil-mode} with
boundaries defined by syntax highlighting.")
      (license license:gpl3+))))

(define-public emacs-flycheck-flow
  (let ((commit "9e8e52cfc98af6a23fd906f9cb5d5d470d8cf82d")
        (version "1.1")
        (revision "1"))
    (package
      (name "emacs-flycheck-flow")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/lbolla/emacs-flycheck-flow")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "14qldlisbmxzammr500gyha2hiv2xgyzfc6mysqii06kbcqn1ik1"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-flycheck))
      (home-page "https://github.com/lbolla/emacs-flycheck-flow")
      (synopsis "Flow support for @code{flycheck-mode}")
      (description
       "This package allows @code{flycheck-mode} to provide syntax-checking
for Flow files.")
      (license license:gpl3+))))

(define-public emacs-flycheck-grammalecte
  (package
    (name "emacs-flycheck-grammalecte")
    (version "2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.umaneti.net/flycheck-grammalecte/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "040mb9djj4cxpjsjch9i30pi36a2z7grkhnsnfdi5qyh341p4pq0"))))
    (build-system emacs-build-system)
    (arguments
     `(#:include (cons "\\.py$" %default-include)
       #:exclude '("^test-profile.el$")
       #:emacs ,emacs                   ;need libxml support
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'specify-python-location
           ;; Hard-code python3 executable location in the library.
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((python3 (search-input-file inputs "/bin/python3")))
               (substitute* '("flycheck-grammalecte.el" "grammalecte.el")
                 (("\"python3") (string-append "\"" python3)))
               (substitute* '("conjugueur.py" "flycheck_grammalecte.py")
                 (("/usr/bin/env python3?") python3)))))
         (add-after 'unpack 'specify-grammalecte-location
           ;; Use our own Grammalecte.
           (lambda* (#:key inputs #:allow-other-keys)
             (make-file-writable "grammalecte.el")
             (emacs-substitute-variables "grammalecte.el"
               ("grammalecte-python-package-directory"
                (search-input-directory
                 inputs
                 (string-append "lib/python"
                                ,(version-major+minor (package-version python))
                                "/site-packages/grammalecte"))))))
         (add-after 'unpack 'do-not-phone-home
           ;; Do not check for Grammalecte updates, ever.
           (lambda _
             (make-file-writable "grammalecte.el")
             (emacs-substitute-variables "grammalecte.el"
               ("grammalecte-check-upstream-version-delay" 0)))))))
    (inputs
     (list grammalecte python))
    (propagated-inputs
     (list emacs-flycheck))
    (home-page "https://git.umaneti.net/flycheck-grammalecte/")
    (synopsis "Integrate Grammalecte with Flycheck")
    (description
     "Integrate the French grammar and typography checker Grammalecte with
Flycheck to automatically look for mistakes in your writings.  It also
provides an easy way to find synonyms and antonyms for a given word (to avoid
repetitions for example).")
    (license license:gpl3+)))

(define-public emacs-flycheck-guile
  (package
    (name "emacs-flycheck-guile")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/flatwhatson/flycheck-guile")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hkj3y7xlbbnwagmccav620r3qngpc909pj3n5b876r8gp6rm87p"))))
    (propagated-inputs
     (list emacs-flycheck emacs-geiser emacs-geiser-guile))
    (build-system emacs-build-system)
    (home-page "https://github.com/flatwhatson/flycheck-guile")
    (synopsis "GNU Guile support for Flycheck")
    (description
     "This package provides a Flycheck checker for GNU Guile using @code{guild
compile}.")
    (license license:gpl3+)))

(define-public emacs-flycheck-ledger
  (package
    (name "emacs-flycheck-ledger")
    (version "0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/flycheck-ledger")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1djrj3is0dzrl2703bw7bclf33dp4xqmy144q7xj5pvpb9v3kf50"))))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'configure
            (lambda _
              (let ((ledger #$(this-package-input "ledger")))
                ;; Specify the absolute executable location of ledger.
                (substitute* "flycheck-ledger.el"
                  (("\"ledger\"") (string-append "\"" ledger "\"")))))))))
    (inputs (list ledger))
    (propagated-inputs
     (list emacs-flycheck))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/flycheck-ledger")
    (synopsis "Ledger support for Flycheck")
    (description
     "This Flycheck checker uses the output of @code{ledger balance} on the
current file to find errors such as unbalanced transactions and syntax
errors.")
    (license license:gpl3+)))

(define-public emacs-flycheck-rust
  (package
    (name "emacs-flycheck-rust")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/flycheck/flycheck-rust")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fh6j5w2387nh2fwwjphkhq17cgj5m2q5k0fhidvgc2w65lzbr1r"))))
    (propagated-inputs
     (list emacs-dash emacs-flycheck emacs-let-alist))
    (build-system emacs-build-system)
    (home-page "https://github.com/flycheck/flycheck-rust")
    (synopsis "Rust/Cargo support for Flycheck")
    (description
     "This Flycheck extension configures Flycheck automatically for
the current Cargo project.")
    (license license:gpl3+)))

(define-public emacs-flycheck-package
  (package
    (name "emacs-flycheck-package")
    (version "0.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/flycheck-package")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "00py39n1383761wq6wp194pvyk94ydqdbxj9kl64g9jnipkp7849"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-flycheck emacs-package-lint))
    (home-page "https://github.com/purcell/flycheck-package")
    (synopsis "Flycheck checker for elisp package metadata")
    (description
     "This library provides a flycheck checker for the metadata in Emacs Lisp
files which are intended to be packages.")
    (license license:gpl3+)))

(define-public emacs-flymake-proselint
  (let ((commit "9c68ee881f18f554f0ab5bbf5bee1a4b753d792b"))
    (package
      (name "emacs-flymake-proselint")
      (version "0.3.0")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://git.sr.ht/~manuel-uberti/flymake-proselint")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1n8i17il2nfazw3d9kza2r7py61dgdr7kqmg0s1vhrk86qq39669"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-exec-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "flymake-proselint.el"
                  (("\"proselint\"")
                   (string-append
                    "\"" (search-input-file inputs "/bin/proselint") "\""))))))))
      (inputs
       (list python-proselint))
      (home-page "https://git.sr.ht/~manuel-uberti/flymake-proselint")
      (synopsis "Flymake backend for @code{proselint}")
      (description "This package adds support for @code{proselint} in Flymake.")
      (license license:gpl3+))))

(define-public emacs-elisp-demos
  (package
    (name "emacs-elisp-demos")
    (version "2020.02.19")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/xuchunyang/elisp-demos")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0mckgaz92v3y2vlkggx9kd51fd1mahylw39c42l51dyv8wscm7sc"))))
    (build-system emacs-build-system)
    (arguments
     `(#:include '("\\.el$" "\\.org$")
       #:tests? #t
       #:test-command '("make" "test")))
    (home-page "https://github.com/xuchunyang/elisp-demos/")
    (synopsis "Enhance @code{*Help*} buffers with additional examples")
    (description
     "This package injects example uses of Elisp functions into their
respective @code{*Help*} buffers.")
    (license license:gpl3+)))

(define-public emacs-docker-compose-mode
  (package
    (name "emacs-docker-compose-mode")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/meqif/docker-compose-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1fbcxwfvm33xcdj3cs26d9i1zyrryyjjkv7sc3mfxd45nq8d3ivj"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-f emacs-yaml-mode))
    (home-page "https://github.com/meqif/docker-compose-mode/")
    (synopsis "Major mode for editing @file{docker-compose} files")
    (description
     "This is a major mode for @file{docker-compose} files that provides
completion of relevant keywords.")
    (license license:expat)))

(define-public emacs-dvc
  (let ((revision "591")                ;no tags or official releases
        (guix-revision "1"))
    (package
      (name "emacs-dvc")
      (version (string-append "0.0.0-" guix-revision "." revision))
      (source
       (origin
         (method bzr-fetch)
         (uri (bzr-reference
               (url "lp:dvc")
               (revision revision)))
         (sha256
          (base32 "03pqn493w70wcpgaxvqnfgynxghw114l9pyiv3r414d84vzhan6h"))
         (file-name (string-append name "-" version "-checkout"))))
      (build-system gnu-build-system)
      (arguments
       (list
        #:modules `((guix build gnu-build-system)
                    ((guix build emacs-build-system) #:prefix emacs:)
                    (guix build utils))
        #:imported-modules `(,@%gnu-build-system-modules
                             (guix build emacs-build-system)
                             (guix build emacs-utils))
        #:configure-flags
        #~(list (string-append "--with-lispdir="
                               (emacs:elpa-directory #$output)))
        #:tests? #f                     ;no test suite
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'build 'set-home
              ;; Something in dvc-bookmarks.el attempts to write config files
              ;; in $HOME during the autoload generation.
              (lambda _ (setenv "HOME" (getenv "TMPDIR"))))
            (add-before 'build 'fix-texinfo
              ;; See https://bugs.launchpad.net/dvc/+bug/1264383.
              (lambda _
                (substitute* "texinfo/dvc-intro.texinfo"
                  (("@itemx update ``to''") "@item update ``to''")
                  (("@itemx brief") "@item brief")
                  (("@itemx full") "@item full")
                  (("@itemx drop") "@item drop")
                  (("@itemx left file") "@item left file")))))))
      (native-inputs
       (list autoconf automake emacs-minimal texinfo))
      (home-page "http://xsteve.at/prg/emacs_dvc/index.html")
      (synopsis "Emacs front-end for various distributed version control systems")
      (description "DVC is a legacy Emacs front-end for a number of
distributed version control systems.  It currently supports GNU Arch, GNU
Bazaar, git, Mercurial, and Monotone.  It also provides some integration with
Gnus, e.g., for applying patches received by email.")
      (license license:gpl2+))))

(define-public emacs-sudo-edit
  (package
    (name "emacs-sudo-edit")
    (version "0.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nflath/sudo-edit")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1hncxbg5lvywzkwvdmzvrz71midy4samjq2vvxxhz90z1y5l8l29"))))
    (build-system emacs-build-system)
    (native-inputs
     (list emacs-undercover))
    (arguments
     (list
      #:emacs emacs
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'fix-makefile
            (lambda _
              (substitute* "Makefile"
                (("\\$\\(CASK\\) exec ") "")))))
      #:tests? #t
      #:test-command #~(list "make" "test")))
    (home-page "https://github.com/nflath/sudo-edit/")
    (synopsis "Open files as another user")
    (description
     "This package allows editing files as another user, including the root
user.")
    (license license:gpl3+)))

(define-public emacs-subed
  (package
    (name "emacs-subed")
    (version "1.0.24")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.nongnu.org/nongnu/subed-"
                                  version ".tar"))
              (sha256
               (base32
                "1x9w858pgyhd7hlvn85h379f8sfvf8ly3a9596q4jkqbcp9riymq"))))
    (arguments
     (list
      #:tests? #t
      #:test-command #~(list "make" "test-only")))
    (native-inputs
     (list emacs-buttercup))
    (build-system emacs-build-system)
    (home-page "https://elpa.nongnu.org/nongnu/subed.html")
    (synopsis "Major mode for editing subtitles")
    (description
     "@code{subed} is an Emacs major mode for editing subtitles while playing
the corresponding video with @code{mpv}.  At the moment, the only supported
formats are SubRip (@file{.srt}), WebVTT (@file{.vtt}), and Advanced
SubStation Alpha (@file{.ass}).")
    (license license:gpl3+)))

(define-public emacs-miniedit
  (package
    (name "emacs-miniedit")
    (version "2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsmirror/miniedit")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1850z96gly0jnr50472idqz1drzqarr0n23bbasslrc501xkg0bq"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacsmirror/miniedit/")
    (synopsis "Enhanced editing for minibuffer fields")
    (description
     "This package provides a function that can be called from the
minibuffer to enable editing the minibuffer input in another buffer with
@code{text-mode} enabled.")
    (license license:gpl2+)))

(define-public emacs-ob-ipython
  (package
    (name "emacs-ob-ipython")
    (version "20180224")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (commit "7147455230841744fb5b95dcbe03320313a77124")
                    (url "https://github.com/gregsexton/ob-ipython")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1a10fc2jk37ni5sjjvf87s5nyaz2a6h2mlj5dxh4dhv5sd3bb85p"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-f))
    (home-page "http://www.gregsexton.org")
    (synopsis "Org-Babel functions for IPython evaluation")
    (description "This package adds support to Org-Babel for evaluating Python
source code using IPython.")
    (license license:gpl3+)))

(define-public emacs-ob-async
  (package
    (name "emacs-ob-async")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/astahlman/ob-async")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10x4hxrjm4pr6vg42a961h9ilqzyd0l0fv7fsbq9clxi439f1nd6"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-async emacs-dash))
    (home-page "https://github.com/astahlman/ob-async")
    (synopsis "Asynchronous src_block execution for org-babel")
    (description "@code{ob-async} enables asynchronous execution of org-babel
src blocks.")
    (license license:gpl3+)))

(define-public emacs-ol-notmuch
  (let ((commit "1a53d6c707514784cabf33d865b577bf77f45913")
        (revision "0"))
    (package
      (name "emacs-ol-notmuch")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://git.sr.ht/~tarsius/ol-notmuch")
               (commit commit)))
         (sha256
          (base32
           "16p7j51z8r047alwn2hkb6944f7ds29ckb97b4k8ia00vwch0d67"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-compat emacs-notmuch emacs-org))
      (home-page "https://git.sr.ht/~tarsius/ol-notmuch")
      (synopsis "Links to notmuch messages for Emacs' Org mode")
      (description
       "This package implements links to Notmuch messages and searches for
Emacs' Org mode.  A search is a query to be performed by Notmuch; it is the
equivalent to folders in other mail clients.  Similarly, mails are referred to
by a query, so both a link can refer to several mails.")
      (license license:gpl3+))))

(define-public emacs-debbugs
  (package
    (name "emacs-debbugs")
    (version "0.34")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/debbugs-"
                           version ".tar"))
       (sha256
        (base32 "06nxia4myhysiw12vsflgllrp9nyhmjnybrrcl1vyf4pw0fc6yrx"))))
    (build-system emacs-build-system)
    (arguments '(#:include '("\\.el$" "\\.wsdl$" "\\.info$")))
    (propagated-inputs
     (list emacs-soap-client))
    (home-page "https://elpa.gnu.org/packages/debbugs.html")
    (synopsis "Access the Debbugs bug tracker in Emacs")
    (description
     "This package lets you access the @uref{http://bugs.gnu.org,GNU Bug
Tracker} from within Emacs.

For instance, it defines the command @code{M-x debbugs-gnu} for listing bugs,
and the command @code{M-x debbugs-gnu-search} for bug searching.  If you
prefer the listing of bugs as TODO items of @code{org-mode}, you could use
@code{M-x debbugs-org} and related commands.

A minor mode @code{debbugs-browse-mode} let you browse URLs to the GNU Bug
Tracker as well as bug identifiers prepared for @code{bug-reference-mode}.")
    (license license:gpl3+)))

(define-public emacs-piem
  (package
    (name "emacs-piem")
    (version "0.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.kyleam.com/piem")
             (commit (string-append "v" version))))
       (file-name (string-append name "-" version "-checkout"))
       (sha256
        (base32 "0wr6n6wvznngjdp4c0pmdr4xz05dark0kxi5svzhzxsg3rdaql3z"))))
    (build-system emacs-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'configure
                 (lambda* (#:key inputs #:allow-other-keys)
                   (emacs-substitute-variables "piem-b4.el"
                     ("piem-b4-b4-executable"
                      (search-input-file inputs "/bin/b4"))))))))
    (inputs
     (list b4))
    (propagated-inputs
     (list emacs-elfeed
           emacs-notmuch
           emacs-transient))
    (home-page "https://docs.kyleam.com/piem")
    (synopsis "Glue for working with public-inbox archives")
    (description "This package provides a collection of Emacs libraries for
working with public-inbox archives.  As much of the hard work here is already
done by other Emacs libraries—things like mail clients, news readers, Git
interfaces, and even web browsers—piem is mostly about bridging some of these
parts for convenience.")
    (license license:gpl3+)))

(define-public emacs-ert-expectations
  (package
    (name "emacs-ert-expectations")
    (version "0.2")
    (source
     (origin
       (method url-fetch)
       (uri "https://www.emacswiki.org/emacs/download/ert-expectations.el")
       (sha256
        (base32
         "0cwy3ilsid90abzzjb7ha2blq9kmv3gfp3icwwfcz6qczgirq6g7"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/ert-expectations.el")
    (synopsis "Simple unit test framework for Emacs Lisp")
    (description "@code{emacs-ert-expectations} is a simple unit test
framework for Emacs Lisp to be used with @code{ert}.")
    (license license:gpl3+)))

(define-public emacs-deferred
  (package
    (name "emacs-deferred")
    (version "0.5.1")
    (home-page "https://github.com/kiwanami/emacs-deferred")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xy9zb6wwkgwhcxdnslqk52bq3z24chgk6prqi4ks0qcf2bwyh5h"))
       (patches
        (search-patches "emacs-deferred-fix-number-of-arguments.patch"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-shell
           ;; Setting the SHELL environment variable is required for the tests
           ;; to find sh.
           (lambda _
             (setenv "SHELL" (which "sh"))))
         (add-before 'check 'fix-makefile
           (lambda _
             (substitute* "Makefile"
               (("\\$\\(CASK\\) exec ") "")))))
       #:tests? #t
       #:test-command '("make" "test")))
    (native-inputs
     (list emacs-ert-expectations emacs-ert-runner emacs-undercover))
    (synopsis "Simple asynchronous functions for Emacs Lisp")
    (description
     "The @code{deferred.el} library provides support for asynchronous tasks.
The API is almost the same as that of
@uref{https://github.com/cho45/jsdeferred, JSDeferred}, a JavaScript library
for asynchronous tasks.")
    (license license:gpl3+)))

(define-public emacs-butler
  (package
    (name "emacs-butler")
    (version "0.2.6")
    (home-page "https://github.com/AshtonKem/Butler")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1wsk5isza8xqr84w6haal95ssifz6j2lrr5phbsdc90jb9hicbff"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-deferred))
    (synopsis "Emacs client for Jenkins")
    (description
     "Butler provides an interface to connect to Jenkins continuous
integration servers.  Users can specify a list of server in the
@code{butler-server-list} variable and then use @code{M-x butler-status} to
view the build status of those servers' build jobs, and possibly to trigger
build jobs.")
    (license license:gpl3+)))

(define-public emacs-zmq
  (package
    (name "emacs-zmq")
    (version "0.10.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nnicandro/emacs-zmq")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ngxm5mm0kqgvn8977ryrngamx0khzlw86d8vz5s0jhm2kgwnqp8"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #f ; no tests
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure
           (lambda _
             (invoke "make" "src/configure")
             (substitute* "src/configure"
               (("/bin/sh") (which "sh"))
               (("/usr/bin/file") (which "file")))
             (invoke "make")))
         (add-after 'install 'install-shared-object
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let* ((out (assoc-ref outputs "out"))
                    (site-lisp (string-append out "/share/emacs/site-lisp"))
                    (libdir (string-append site-lisp "/zmq-0.10.10")))
               (copy-file "emacs-zmq.so"
                          (string-append libdir "/emacs-zmq.so"))))))))
    (native-inputs
     (list autoconf automake libtool pkg-config))
    (inputs
     (list zeromq))
    (home-page "https://github.com/nnicandro/emacs-zmq")
    (synopsis "Emacs bindings to ØMQ")
    (description "This package provides Emacs bindings to ØMQ.")
    (license (list license:gpl2+     ;zmq.el
                   license:gpl3+)))) ;src/emacs-module.h

(define-public emacs-tup-mode
  (package
    (name "emacs-tup-mode")
    (version "1.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ejmr/tup-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0asd024n5v23wdsg1959sszq568wg3a1bp4jrk0cllfji1z0n78y"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ejmr/tup-mode")
    (synopsis "Major mode for editing ``tupfiles'' used by the Tup build system")
    (description
     "Tup mode provides syntax highlighting for all of the elements of
tupfiles, such as rule definitions, user-defined variables, macros, flags, bin
variables, and so on.  The mode also allows you to execute Tup commands.")
    (license license:gpl3+)))

(define-public emacs-compat
  (package
    (name "emacs-compat")
    (version "28.1.2.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://git.sr.ht/~pkal/compat")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1c1pr6zzvgfbsclp1fyx911d4qvihz8hw5mp7g0l0df2rlpypdzw"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-nadvice))
    (home-page "https://git.sr.ht/~pkal/compat")
    (synopsis "Emacs Lisp Compatibility Library")
    (description
     "To allow for the usage of Emacs functions and macros that are defined
in newer versions of Emacs, @code{compat.el} provides definitions that
are installed ONLY if necessary.  These reimplementations of functions
and macros are at least subsets of the actual implementations.  Be
sure to read the documentation string to make sure.

Not every function provided in newer versions of Emacs is provided
here.  Some depend on new features from the core, others cannot be
implemented to a meaningful degree.  The main audience for this
library are not regular users, but package maintainers.  Therefore
commands and user options are usually not implemented here.")
    (license license:gpl3+)))

(define-public emacs-company
  (package
    (name "emacs-company")
    (version "0.9.13")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "company-" version ".tar"))
       (sha256
        (base32 "1c9x9wlzzsn7vrsm57l2l44nqx455saa6wrm853szzg09qn8dlnw"))))
    (build-system emacs-build-system)
    (home-page "https://company-mode.github.io/")
    (synopsis "Modular text completion framework")
    (description
     "Company is a modular completion mechanism.  Modules for retrieving
completion candidates are called back-ends, modules for displaying them are
front-ends.  Company comes with many back-ends, e.g., @code{company-elisp}.
These are distributed in separate files and can be used individually.")
    (license license:gpl3+)))

(define-public emacs-company-box
  ;; There is no release yet.  Version is extracted from the main
  ;; file.
  (let ((version "0.0.1")
        (revision "0")
        (commit "be37a9a30dc112ab172af21af694e2cb04a74f85"))
    (package
      (name "emacs-company-box")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sebastiencs/company-box")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "13fgmdy51gqdwijqfvb784pirx4lgva0y7ysi0c3fcx8f82cdj59"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-company emacs-dash emacs-frame-local))
      (home-page "https://github.com/sebastiencs/company-box")
      (synopsis "Company front-end with icons")
      (description
       "Company box is a Company front-end.  It supports different
colors for different backends, associates icons to functions,
variables... and their backends, and displays candidate's
documentation.  It is not limited by the current window size or
buffer's text properties.

This package is not compatible with a TTY.")
      (license license:gpl3+))))

(define-public emacs-company-posframe
  (package
    (name "emacs-company-posframe")
    (version "0.5.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/tumashu/company-posframe")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "05ays6xkqbxcfplvx7wfc2slflmwc3aw7vkixvabk0ilvisndvgm"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-company emacs-posframe))
    (home-page "https://github.com/tumashu/company-posframe")
    (synopsis "Use a posframe for @code{emacs-company}'s candidate menu")
    (description
     "Allows @code{emacs-company} to use child frames for its candidate menus.

@code{emacs-company-posframe} is fast enough for daily use and supports CJK
languages.")
    (license license:gpl3+)))

(define-public emacs-irony-mode
  (package
    (name "emacs-irony-mode")
    (version "1.5.0")
    (home-page "https://github.com/Sarcasm/irony-mode")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url (string-append home-page ".git"))
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ilvfqn7hzrjjy2zrv08dbdnmgksdgsmrdcvx05s8704430ag0pb"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'configure
            (lambda _
              (chmod "irony.el" #o644)
              (emacs-substitute-variables "irony.el"
                ("irony-server-install-prefix" #$emacs-irony-mode-server)))))))
    (inputs (list emacs-irony-mode-server))
    (synopsis "C/C++/ObjC Code completion and syntax checks for Emacs")
    (description "Irony-mode provides Clang-assisted syntax checking and
completion for C, C++, and ObjC in GNU Emacs.  Using @code{libclang} it can
provide syntax checking and autocompletion on compiler level which is very
resistant against false positives.  It also integrates well with other
packages like @code{eldoc-mode} and especially @code{company-mode} as
described on the homepage.")
    (license license:gpl3+)))

(define-public emacs-irony-mode-server
  (package
    (inherit emacs-irony-mode)
    (name "emacs-irony-mode-server")
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'configure
           (lambda* (#:key outputs #:allow-other-keys)
             (let ((out (assoc-ref outputs "out")))
               (invoke "cmake"
                       "server"
                       (string-append "-DCMAKE_INSTALL_PREFIX=" out))))))))
    (inputs
     (list clang))
    (build-system cmake-build-system)
    (synopsis "Server for the Emacs @dfn{irony mode}")))

(define-public emacs-company-irony
  (package
    (name "emacs-company-irony")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Sarcasm/company-irony")
             (commit (string-append "v" version))))
       (sha256
        (base32 "1d3jw0d4zymznri86a5iixyxnw16jzkkrbhrh657ys73189c1c73"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (inputs
     (list emacs-company emacs-irony-mode))
    (synopsis "C++ completion backend for Company using Irony mode")
    (description "This backend for Company allows for C++ code completion
with Irony mode using Clang tooling.")
    (home-page "https://github.com/Sarcasm/company-irony")
    (license license:gpl3+)))

(define-public emacs-flycheck-irony
  (package
    (name "emacs-flycheck-irony")
    (version "0.1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/Sarcasm/flycheck-irony")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32 "0qa5a8wzvzxwqql92ibc9s43k8sj3vwn7skz9hfr8av0skkhx996"))))
    (build-system emacs-build-system)
    (inputs
     (list emacs-irony-mode emacs-flycheck emacs-company))
    (synopsis "Live syntax checking frontend for Flycheck using irony-mode")
    (description "This package provides a frontend for Flycheck that lets
irony-mode do the syntax checking.")
    (home-page "https://github.com/Sarcasm/flycheck-irony")
    (license license:gpl3+)))

(define-public emacs-irony-eldoc
  (package
    (name "emacs-irony-eldoc")
    (version (package-version emacs-irony-mode))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ikirill/irony-eldoc")
             (commit "0df5831eaae264a25422b061eb2792aadde8b3f2")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1l5qpr66v1l12fb50yh73grb2rr85xxmbj19mm33b5rdrq2bqmmd"))))
    (build-system emacs-build-system)
    (inputs
     (list emacs-irony-mode))
    (synopsis "Eldoc integration for irony-mode")
    (description "Irony-eldoc is an eldoc extension that shows documentation
for the current function or variable in the minibuffer.")
    (home-page "https://github.com/ikirill/irony-eldoc")
    (license license:gpl3+)))

(define-public emacs-company-quickhelp
  (package
    (name "emacs-company-quickhelp")
    (version "2.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/expez/company-quickhelp")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08ccsfvwdpzpj0gai3xrdb2bv1nl6myjkxsc5774pbvlq9nkfdvr"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-pos-tip emacs-company))
    (home-page "https://github.com/expez/company-quickhelp")
    (synopsis "Popup documentation for completion candidates")
    (description "@code{company-quickhelp} shows documentation for the
completion candidate when using the Company text completion framework.")
    (license license:gpl3+)))

(define-public emacs-math-symbol-lists
  (package
    (name "emacs-math-symbol-lists")
    (version "1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/vspinu/math-symbol-lists")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1r2i600356k8g0l53s4b5xc24flpka664i8f23zbj4h7gk1g2787"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/vspinu/math-symbol-lists")
    (synopsis "Lists of Unicode math symbols and @code{LaTeX} commands")
    (description "This is a storage package used by completion engines like
@code{company-math}.")
    (license license:gpl3+)))

(define-public emacs-company-coq
  (package
    (name "emacs-company-coq")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/cpitclaudel/company-coq")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0dxi4h8xqq5647k7h89s4pi8nwyj3brlhsckrv3p3b1g4dr6mk3b"))))
    (inputs
     (list emacs-company emacs-company-math emacs-dash emacs-yasnippet))
    (build-system emacs-build-system)
    (home-page "https://github.com/cpitclaudel/company-coq")
    (synopsis "Emacs extensions for Proof General's Coq mode")
    (description "This package includes a collection of Company mode backends
for Proof-General's Coq mode, and many useful extensions to Proof-General.  It
features:

@itemize
@item Prettification of operators, types, and subscripts,
@item Auto-completion,
@item Insertion of cases,
@item Fully explicit intros,
@item Outlines, code folding, and jumping to definition,
@item Help with errors,
@item and more.
@end itemize")
    (license license:gpl3+)))

(define-public emacs-company-math
  (package
    (name "emacs-company-math")
    (version "1.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/vspinu/company-math")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1y1fw926insgdl7ib9ynxjrxf3p6wfjkfxvf5vgdca7267cvcll1"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-math-symbol-lists emacs-company))
    (home-page "https://github.com/vspinu/company-math")
    (synopsis "Completion backends for math symbols and @code{LaTeX} tags")
    (description
     "This package provides a backend for use with Company mode allowing for
completion of common math symbols.")
    (license license:gpl3+)))

(define-public emacs-compdef
  (let ((commit "67104a38763cc819644f711248b170a43bce151b")
        (revision "2"))
    (package
      (name "emacs-compdef")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/jjzmajic/compdef.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1f6y6cr67gps9jp5hd20xszfd3k26v70g6z4g5db6wdkvlnc2wkg"))))
      (build-system emacs-build-system)
      (home-page "https://gitlab.com/jjzmajic/compdef")
      (synopsis "Set local completion backends")
      (description "This package provides a function to cleanly set local
completion backends according to mode, and integrates with
@code{use-package}.")
      (license license:gpl3+))))

(define-public emacs-icomplete-vertical
  (package
    (name "emacs-icomplete-vertical")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/oantolin/icomplete-vertical")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "02v190pb802vck7di39jyf5prvmfsgcxln8mgwsls2b4clx9da97"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/oantolin/icomplete-vertical")
    (synopsis "Display Icomplete candidates vertically")
    (description
     "This package defines a global minor mode to display Icomplete
completion candidates vertically.")
    (license license:gpl3+)))

(define-public emacs-handle
  (let ((commit "51c050bc1c6e5caf0eb47ecd985daea1db7241ab")
        (revision "2"))
    (package
      (name "emacs-handle")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/jjzmajic/handle.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "14f15qzfmwdslml4rv37zb5d1lsjf0jibriz636hb7q7knx1n4sg"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-parent-mode))
      (home-page "https://gitlab.com/jjzmajic/handle")
      (synopsis "Handle generic functions across related major modes")
      (description "This package provides generic functions that specialize on
major modes and intended purpose rather than on arguments.  Different
callables for tasks like expression evaluation, definition-jumping, and more
can now be grouped accordingly and tried in sequence until one of them
succeeds.")
      (license license:gpl3+))))

(define-public emacs-nswbuff
  (package
    (name "emacs-nswbuff")
    (version "1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joostkremers/nswbuff")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0bkx7mwy3zbb0ixawvn4cysxk3jjc7ahssvdprvw19ls9xx3wbsp"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/joostkremers/nswbuff")
    (synopsis "Quickly switch between buffers")
    (description "This package allows for navigating between buffers within
a customizable list.")
    (license license:gpl3+)))

(define-public emacs-phi-search
  (let ((commit "9a089b8271cb1cff9640848850298c9ec855286c")
        (revision "1"))
    (package
      (name "emacs-phi-search")
      (version (git-version "20160630" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/zk-phi/phi-search")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1gr5plcbrfdc4pglfj905s89hf8x0kc083h30wcnd81bnw9jwz1x"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/zk-phi/phi-search")
      (synopsis "Interactive search compatible with @code{multiple-cursors}")
      (description "This package can be used with @code{multiple-cursors} to
provide an incremental search that moves all fake cursors in sync.")
      (license license:gpl2+))))

(define-public emacs-phi-search-mc
  (let ((commit "7aa671910f766437089aec26c3aa7814222d1356")
        (revision "1"))
    (package
      (name "emacs-phi-search-mc")
      (version (git-version "2.2.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/knu/phi-search-mc.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0wr86ad0yl52im6b9z0b9pzmhcn39qg5m9878yfv1nbxliw40lcd"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-phi-search emacs-multiple-cursors))
      (home-page "https://github.com/knu/phi-search-mc.el")
      (synopsis "Extend @code{phi-search} with additional
@code{multiple-cursors} functionality")
      (description "This package provides further integration between
@code{multiple-cursors} and @code{phi-search}, a package that allows for
interactive searches to move multiple fake cursors.")
      (license license:bsd-2))))

(define-public emacs-multiple-cursors
  (package
    (name "emacs-multiple-cursors")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magnars/multiple-cursors.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ijgvzv5r44xqvz751fd5drbvrspapw6xwv47582w255j363r6ss"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/magnars/multiple-cursors.el")
    (synopsis "Multiple cursors for Emacs")
    (description
     "This package adds support to Emacs for editing text with multiple
simultaneous cursors.")
    (license license:gpl3+)))

(define-public emacs-multifiles
  ;; There is no tag and no "Version:" keyword.  Using the latest release
  ;; instead.
  (let ((commit "dddfe64b8e1c1cd1f9ccc1f03405477fc0d53897")
        (revision "1"))
    (package
      (name "emacs-multifiles")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/magnars/multifiles.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "065l04ylplng1vgykkbn2vnkcs3sn1k2cikx1ha2q8wmgx6bkvai"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash))
      (home-page "https://github.com/magnars/multifiles.el")
      (synopsis "Edit multiple files in a single Emacs buffer")
      (description
       "This package allows one to view and edit parts of multiple files in
one Emacs buffer.")
      (license license:gpl3+))))

(define-public emacs-mc-extras
  (let ((commit "053abc52181b8718559d7361a587bbb795faf164")
        (revision "1"))
    (package
      (name "emacs-mc-extras")
      (version (git-version "1.2.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/knu/mc-extras.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "16y48qrd20m20vypvys5jp4v4gc1qrqlkm75s1pk1r68i9zrw481"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-multiple-cursors))
      (home-page "https://github.com/knu/mc-extras.el")
      (synopsis "Extra functions for manipulating multiple cursors")
      (description
       "This package provides additional functions for
@code{multiple-cursors}, including functions for marking s-expressions,
comparing characters, removing cursors, and more.")
      (license license:bsd-2))))

(define-public emacs-typo
  (package
    (name "emacs-typo")
    (version "1.1")
    (home-page "https://github.com/jorgenschaefer/typoel")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1jhd4grch5iz12gyxwfbsgh4dmz5hj4bg4gnvphccg8dsnni05k2"))))
    (build-system emacs-build-system)
    (synopsis "Minor mode for typographic editing")
    (description
     "This package provides two Emacs modes, @code{typo-mode} and
@code{typo-global-mode}.  These modes automatically insert Unicode characters
for quotation marks, dashes, and ellipses.  For example, typing @kbd{\"}
automatically inserts a Unicode opening or closing quotation mark, depending
on context.")
    (license license:gpl3+)))

(define-public emacs-company-lsp
  (package
    (name "emacs-company-lsp")
    (version "2.1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/tigersoldier/company-lsp")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1hy1x2w0yp5brm7714d1hziz3rpkywb5jp3yj78ibmi9ifny9vri"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-lsp-mode emacs-company emacs-s emacs-dash))
    (native-inputs
     (list emacs-buttercup))
    (arguments
     `(#:tests? #t
       #:test-command '("buttercup" "-L" ".")))
    (home-page "https://github.com/tigersoldier/company-lsp")
    (synopsis "Completion for @code{lsp-mode}")
    (description
     "This package provides completion features that are not possible with
@code{lsp-mode} and @code{company-capf} alone, including support for trigger
characters and asynchronous fetching of completion candidates.")
    (license license:gpl3+)))

(define-public emacs-scala-mode
  (package
    (name "emacs-scala-mode")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hvesalai/emacs-scala-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1072lsin7dxadc0xyhy42wd0cw549axbbd4dy95wfmfcc1xbzjwv"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/hvesalai/emacs-scala-mode")
    (synopsis "Emacs major mode for Scala")
    (description
     "This package provides basic Emacs support for the Scala language,
including: local indenting of code, comments and multi-line strings, motion
commands and highlighting.")
    ;; There are no copyright headers in the source code.  The LICENSE file
    ;; indicates GPL3.
    (license license:gpl3)))

(define-public emacs-sbt-mode
  (package
    (name "emacs-sbt-mode")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hvesalai/emacs-sbt-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0lv9ridzk9x6rkf7lj21srnszypyq04vqg05vl10zhpz1yqlnbjd"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/hvesalai/emacs-sbt-mode")
    (synopsis "Basic functionality for interacting with sbt inside Emacs")
    (description
     "This mode provides basic functionality required for successfully
interacting with sbt inside Emacs.  The core functionality includes
interacting with the sbt shell and Scala console, compiling code and
navigation to errors.")
    (license license:gpl3+)))

(define-public emacs-scheme-complete
  ;; Upstream does not provide tags.  The commit below corresponds to the
  ;; exact version update.  Version is extracted from main file.
  (let ((commit "5c0a16684a3be7021d67067b2955f1c3e17a320a"))
    (package
      (name "emacs-scheme-complete")
      (version "0.9.9")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ashinn/scheme-complete")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1smxr5bkzbfrjx21vhrj1wagmqx5yd92i997dbgs16iaqbzzr7cz"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/ashinn/scheme-complete")
      (synopsis "Smart tab completion for Scheme in Emacs")
      (description
       "This file provides a single function, @code{scheme-smart-complete},
which you can use for intelligent, context-sensitive completion for any Scheme
implementation in Emacs.  To use it just load this file and bind that function
to a key in your preferred mode.")
      (license license:public-domain))))

(define-public emacs-scel
  (let ((version "20170629")
        (revision "1")
        (commit "aeea3ad4be9306d14c3a734a4ff54fee10ac135b"))
    (package
      (name "emacs-scel")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/supercollider/scel")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0jvmzs1lsjyndqshhii2y4mnr3wghai26i3p75453zrpxpg0zvvw"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:modules '((guix build emacs-build-system)
                    ((guix build cmake-build-system) #:prefix cmake:)
                    (guix build utils))
        #:imported-modules `(,@%emacs-build-system-modules
                             (guix build cmake-build-system))
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'configure
              (lambda* (#:key outputs #:allow-other-keys)
                (substitute* "el/CMakeLists.txt"
                  (("share/emacs/site-lisp/SuperCollider")
                   (elpa-directory #$output)))
                ((assoc-ref cmake:%standard-phases 'configure)
                 #:outputs outputs
                 #:configure-flags '("-DSC_EL_BYTECOMPILE=OFF"))))
            (add-after 'expand-load-path 'add-el-dir-to-emacs-load-path
              (lambda _
                (setenv "EMACSLOADPATH"
                        (string-append (getcwd)
                                       "/el:"
                                       (getenv "EMACSLOADPATH")))))
            (replace 'install (assoc-ref cmake:%standard-phases 'install)))))
      (inputs
       (list supercollider))
      (native-inputs
       (list cmake-minimal))
      (home-page "https://github.com/supercollider/scel")
      (synopsis "SuperCollider Emacs interface")
      (description "@code{emacs-scel} is an Emacs interface to SuperCollider.
SuperCollider is a platform for audio synthesis and algorithmic composition.")
      (license license:gpl2+))))

(define-public emacs-soothe-theme
  ;; There is no named branch.
  (let ((commit "0786fe70c6c1b4ddcfb932fdc6862b9611cfc09b")
	(revision "0"))
    (package
     (name "emacs-soothe-theme")
     (version (git-version "20141027.2233" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
	     (url "https://github.com/emacsfodder/emacs-soothe-theme")
	     (commit commit)))
       (file-name (git-file-name name version))
       (sha256
	(base32 "10gh1hvxq9gm29r6qzlnva7vjidd7n4kih4z2ihyvbvy9za20xqw"))))
     (build-system emacs-build-system)
     (home-page "https://github.com/emacsfodder/emacs-soothe-theme")
     (synopsis "Colorful, but muted theme for Emacs, dark background with light text")
     (description
      "Soothe theme is an amalgam of muted color tones and highlighted
backgrounds.  It has builtin support for Rainbow delimiters, Org mode,
Whitespace mode, ECB, Flyspell, Ido, Linum, highlight indentation, Show Paren
mode.")
     (license license:gpl3))))

(define-public emacs-company-auctex
  (let ((commit "48c42c58ce2f0e693301b0cb2d085055410c1b25")
        (revision "1"))
    (package
      (name "emacs-company-auctex")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alexeyr/company-auctex")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "10qn7frn5wcmrlci3v6iliqzj7r9dls87h9zp3xkgrgn4bqprfp8"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-before 'build 'set-home
             (lambda _ (setenv "HOME" "/tmp"))))))
      (propagated-inputs
       (list emacs-auctex emacs-company emacs-yasnippet))
      (home-page "https://github.com/alexeyr/company-auctex/")
      (synopsis "Completion for @code{AUCTeX}")
      (description
       "This package provides a group of backends permitting auto-completion
for @code{AUCTeX}.")
      (license license:gpl3+))))

(define-public emacs-mit-scheme-doc
  (package
    (name "emacs-mit-scheme-doc")
    (version "20140203")
    (source
     (origin
       (modules '((guix build utils)))
       (snippet
        ;; keep only file of interest
        '(begin
           (for-each delete-file '("dot-emacs.el" "Makefile"))
           (install-file "6.945-config/mit-scheme-doc.el" ".")
           (delete-file-recursively "6.945-config")))
       (file-name (string-append name "-" version ".tar.bz2"))
       (method url-fetch)
       (uri (string-append "http://groups.csail.mit.edu/mac/users/gjs/"
                           "6.945/dont-panic/emacs-basic-config.tar.bz2"))
       (sha256
        (base32
         "0dqidg2bd66pawqfarvwca93w5gqf9mikn1k2a2rmd9ymfjpziq1"))))
    (build-system emacs-build-system)
    (inputs (list mit-scheme))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure-doc
           (lambda* (#:key inputs #:allow-other-keys)
             (let* ((mit-scheme-dir (assoc-ref inputs "mit-scheme"))
                    (doc-dir (string-append mit-scheme-dir "/share/doc/"
                                            "mit-scheme-"
                                            ,(package-version mit-scheme))))
               (substitute* "mit-scheme-doc.el"
                 (("http://www\\.gnu\\.org/software/mit-scheme/documentation/mit-scheme-ref/")
                  (string-append "file:" doc-dir "/mit-scheme-ref/")))))))))
    (home-page "https://groups.csail.mit.edu/mac/users/gjs/6.945/dont-panic/")
    (synopsis "MIT-Scheme documentation lookup for Emacs")
    (description
     "This package provides a set of Emacs functions to search definitions of
identifiers in the MIT-Scheme documentation.")
    (license license:gpl2+)))

(define-public emacs-constants
  (package
    (name "emacs-constants")
    (version "2.6")
    (home-page "https://staff.fnwi.uva.nl/c.dominik/Tools/constants")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fedeinthemix/emacs-constants")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0f5sh6b45a8p9kancjp9jk44ws8ww6x50a0i6zgyyvr7dbvii1a0"))))
    (build-system emacs-build-system)
    (synopsis "Enter definition of constants into an Emacs buffer")
    (description
     "This package provides functions for inserting the definition of natural
constants and units into an Emacs buffer.")
    (license license:gpl2+)))

(define-public emacs-tagedit
  (package
    (name "emacs-tagedit")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magnars/tagedit")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0kq40g46s8kgiafrhdq99h79rz9h5fvgz59k7ralmf86bl4sdmdb"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-s emacs-dash))
    (home-page "https://github.com/magnars/tagedit")
    (synopsis "Some paredit-like features for html-mode")
    (description
     "This package provides a collection of paredit-like functions for editing
in @code{html-mode}.")
    (license license:gpl3+)))

(define-public emacs-slime
  (package
    (name "emacs-slime")
    (version "2.27")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/slime/slime")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1s5mbljlz22pb90gwbd380nighkz6gdxl77hc08gri7wwr5gy5n2"))))
    (build-system emacs-build-system)
    (native-inputs
     (list texinfo))
    (arguments
     `(#:include '("\\.el$" "\\.lisp$" "\\.asd$" "contrib")
       #:exclude '("^slime-tests.el" "^contrib/test/"
                   "^contrib/Makefile$" "^contrib/README.md$")
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'make-git-checkout-writable
           (lambda _
             (for-each make-file-writable (find-files "."))))
         (add-before 'install 'configure
           (lambda* _
             (emacs-substitute-variables "slime.el"
               ("inferior-lisp-program" "sbcl"))))
         (add-before 'install 'install-doc
           (lambda* (#:key outputs #:allow-other-keys)
             (let* ((out (assoc-ref outputs "out"))
                    (info-dir (string-append out "/share/info"))
                    (doc-dir (string-append out "/share/doc/"
                                            ,name "-" ,version))
                    (doc-files '("doc/slime-refcard.pdf"
                                 "README.md" "NEWS" "PROBLEMS"
                                 "CONTRIBUTING.md")))
               (with-directory-excursion "doc"
                 (substitute* "Makefile"
                   (("infodir=/usr/local/info")
                    (string-append "infodir=" info-dir)))
                 (invoke "make" "html/index.html")
                 (invoke "make" "slime.info")
                 (install-file "slime.info" info-dir)
                 (copy-recursively "html" (string-append doc-dir "/html")))
               (for-each (lambda (f)
                           (install-file f doc-dir)
                           (delete-file f))
                         doc-files)
               (delete-file-recursively "doc")))))))
    (home-page "https://github.com/slime/slime")
    (synopsis "Superior Lisp Interaction Mode for Emacs")
    (description
     "SLIME extends Emacs with support for interactive programming in
Common Lisp.  The features are centered around @command{slime-mode},
an Emacs minor mode that complements the standard @command{lisp-mode}.
While lisp-mode supports editing Lisp source files, @command{slime-mode}
adds support for interacting with a running Common Lisp process
for compilation, debugging, documentation lookup, and so on.")
    (license (list license:gpl2+ license:public-domain))))

(define-public emacs-popup
  (package
    (name "emacs-popup")
    (version "0.5.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/auto-complete/popup-el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13ww7hld5pa32myj9krr6prmc99s7hnpsw8mw9krpxffykkblj2f"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/auto-complete/popup-el")
    (synopsis "Visual Popup User Interface for Emacs")
    (description
     "Popup.el is a visual popup user interface library for Emacs.
This provides a basic API and common UI widgets such as popup tooltips
and popup menus.")
    (license license:gpl3+)))

(define-public emacs-popup-kill-ring
  (let ((commit "a45c9cf79c4e1207fdbdd662e161154ef224ad61")
        (revision "0"))
    (package
      (name "emacs-popup-kill-ring")
      (version (git-version "0.2.8" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/waymondo/popup-kill-ring")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0bpnsc4agy6mcnc79d9a6gi79jiiqrhf3a55pw0p4z16m86vwyqr"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-pos-tip emacs-popup))
      (home-page "https://github.com/waymondo/popup-kill-ring")
      (synopsis "Interactively insert item from kill-ring")
      (description "This Emacs package manages your Emacs kill-ring in an
autocomplete style popup menu.")
      (license license:gpl3+))))

(define-public emacs-popper
  ;; No tagged release upstream for version 0.45.  The commit below matches
  ;; version bump.
  (let ((commit "851d83882192ac9599ac5b053614a42d683b3fab"))
    (package
      (name "emacs-popper")
      (version "0.45")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/karthink/popper")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0pk5wzqlz7n6v8rb1957i3ql0wjx578l68a3rp2m9pxr7a8a03h4"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/karthink/popper")
      (synopsis "Emacs minor-mode to summon and dismiss buffers easily")
      (description
       "Popper is a minor-mode to tame the flood of ephemeral
windows Emacs produces, while still keeping them within arm’s reach.")
      (license license:gpl3+))))

(define-public emacs-python-black
  (package
    (name "emacs-python-black")
    (version "1.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/wbolster/emacs-python-black")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1x6b67cs7kn8711fxr3fq8y9wcpf9g71asf9wiqfrk2mrfzli6a3"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-reformatter python-black-macchiato))
    (arguments `(#:tests? #f))
    (home-page "https://github.com/wbolster/emacs-python-black")
    (synopsis "Reformat Python code via @code{python-black}")
    (description
     "This package makes it easy to reformat Python code using
@code{python-black} and @code{python-black-macchiato} for entire and partial
buffers, respectively.")
    (license license:bsd-3)))

(define-public emacs-py-isort
  (package
    (name "emacs-py-isort")
    (version "2016.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/paetzke/py-isort.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08i55gv392wc12x8v3dca0dmz8a8p9ljsqhyajsb6qv1k120wqhx"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #f))     ;tests fail with "emacs: standard input is not a tty"
    (propagated-inputs
     (list python-isort))
    (home-page "https://github.com/paetzke/py-isort.el")
    (synopsis "Sort the imports in Python buffers")
    (description
     "This package provides commands and a minor mode to sort Python imports
using @code{python-isort}.")
    (license license:gpl3+)))

(define-public emacs-python-environment
  (package
    (name "emacs-python-environment")
    (version "0.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tkf/emacs-python-environment/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0q6bib9nr6xiq6npzbngyfcjk87yyvwzq1zirr3z1h5wadm34lsk"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-deferred))
    (home-page "https://github.com/tkf/emacs-python-environment")
    (synopsis "Provides a @code{virtualenv} API in Emacs Lisp")
    (description
     "This package permits automated installation of tools written in Python.")
    (license license:gpl3+)))

(define-public emacs-jedi
  (package
    (name "emacs-jedi")
    (version "0.2.8")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/tkf/emacs-jedi/")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1bckxppfzd5gwn0aw4h86igb7igal9axqncq7j8zmflg7zppncf1"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:imported-modules `(,@%emacs-build-system-modules
                           (guix build python-build-system))
      #:modules '((guix build emacs-build-system)
                  ((guix build python-build-system) #:prefix python:)
                  (guix build emacs-utils)
                  (guix build utils))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'ensure-no-mtimes-pre-1980
            (assoc-ref python:%standard-phases
                       'ensure-no-mtimes-pre-1980))
          (add-after 'ensure-no-mtimes-pre-1980 'relax-python-requirements
            (lambda _
              ;; Argparse should only be required for Python < 3.2
              ;; (see: https://github.com/tkf/emacs-jedi/issues/365).
              (substitute* "setup.py"
                ((".*argparse.*") ""))))
          (add-after 'relax-python-requirements 'python:add-install-to-pythonpath
            (assoc-ref python:%standard-phases 'add-install-to-pythonpath))
          (add-after 'python:add-install-to-pythonpath 'python:install
            ;; This is needed to get the Python-built 'jediepcserver' command.
            (assoc-ref python:%standard-phases 'install))
          (add-after 'python:install 'python:wrap
            (assoc-ref python:%standard-phases 'wrap))
          (add-after 'python:wrap 'patch-jedi:server-command
            (lambda* (#:key outputs #:allow-other-keys)
              (emacs-substitute-variables "jedi-core.el"
                ("jedi:server-command"
                 (search-input-file outputs "bin/jediepcserver"))))))))
    (native-inputs (list emacs-mocker python-wrapper))
    (inputs (list python-wrapper python-epc python-jedi)) ;wrapped
    (propagated-inputs
     (list emacs-auto-complete emacs-python-environment emacs-epc))
    (home-page "https://github.com/tkf/emacs-jedi")
    (synopsis "Provides Python completion in Emacs")
    (description
     "This package provides completion in Python buffers and also helps find
the locations of docstrings, arguments, and functions.")
    (license license:gpl3+)))

(define-public emacs-company-jedi
  (package
    (name "emacs-company-jedi")
    (version "0.04")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/syohex/emacs-company-jedi")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1ihqapp4dv92794rsgyq0rmhwika60cmradqd4bn9b72ss6plxs1"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-jedi emacs-company))
    (home-page "https://github.com/syohex/emacs-company-jedi")
    (synopsis "Provides Python completion in @code{company-mode}")
    (description
     "This package provides a Company backend for Python.")
    (license license:gpl3+)))

(define-public emacs-elquery
  (package
    (name "emacs-elquery")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/AdamNiederer/elquery")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "035zjzmd7yfw0rsjpaklc2wwiqw6brkjadch9x8n8n2gjyxg05mn"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:emacs emacs-no-x
      #:tests? #t
      #:test-command #~(list "ert-runner")
      #:phases #~(modify-phases %standard-phases
                   (add-after 'unpack 'fix-native-compilation
                     (lambda _
                       (substitute* "elquery.el"
                         (("\\(1- \\(/ length \\(match-data\\)\\) 2\\)")
                          "(1- (/ (length (match-data)) 2))"))))
                   (add-before 'check 'disable-failing-tests
                     (lambda _
                       (substitute* "test/elquery-test.el"
                         (("\\(ert-deftest elquery--write-test .*" all)
                          (string-append all "(skip-unless nil)\n"))))))))
    (native-inputs
     (list emacs-ert-runner emacs-undercover))
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://github.com/AdamNiederer/elquery/")
    (synopsis "Read and manipulate HTML in Emacs")
    (description
     "Elquery is a library that lets you parse, query, set, and format HTML using
Emacs Lisp.  It implements most of the @code{querySelector} API, and can get
and set HTML attributes.")
    (license license:gpl3+)))

(define-public emacs-cov
  ;; XXX: Upstream made no release nor any tag so far.
  (let ((commit "cd3e1995c596cc227124db9537792d8329ffb696")
        (revision "0"))
    (package
      (name "emacs-cov")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/AdamNiederer/cov")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1gyc0si60czhgrkm7kink1p1zj1h5j5nzif4ivm5bg78l28skmpm"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:emacs emacs-no-x              ;for libxml
        #:tests? #t
        #:test-command #~(list "ert-runner")
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'disable-failing-tests
              (lambda _
                (substitute* "test/cov-test.el"
                  (("\\(ert-deftest cov--load-coverage-test-mtime-check .*" all)
                   (string-append all "(skip-unless nil)\n"))))))))
      (native-inputs
       (list emacs-ert-runner emacs-mocker emacs-undercover))
      (propagated-inputs
       (list emacs-elquery emacs-f emacs-s))
      (home-page "https://github.com/AdamNiederer/cov/")
      (synopsis "Emacs extension for displaying coverage data")
      (description
       "Cov shows code coverage data for your program in Emacs.  It supports
currently @code{gcov}, @code{lcov}, @code{coverage.py}, and @code{clover}
output, as well as the Coveralls format produced by Undercover.")
      (license license:gpl3+))))

(define-public emacs-puppet-mode
  (package
    (name "emacs-puppet-mode")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/voxpupuli/puppet-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0c5q8qmbligzjsn05di4wh6ggpd3944j4yqb78vzd441b8ssq70i"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/voxpupuli/puppet-mode")
    (synopsis "Emacs major mode for the Puppet configuration language")
    (description
     "This package provides support for the Puppet configuration language,
including syntax highlighting, indentation of expressions and statements,
linting of manifests and integration with Puppet Debugger.")
    ;; Also incorporates work covered by the Apache License, Version 2.0
    (license license:gpl3+)))

(define-public emacs-purescript-mode
  ;; Retrieved on 2021-05-18.
  (let ((revision "0")
        (commit "0acd1af446424ba855153161fe07a20f67dc0a89"))
    (package
      (name "emacs-purescript-mode")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/purescript-emacs/purescript-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0rxdsmx8826az4blhnnvqrx7bjky9hwph6gkyrh33sck26xhh3g5"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-before 'install 'make-info
             (lambda _
               (invoke "makeinfo" "--no-split"
                       "-o" "purescript-mode.info" "purescript-mode.texi"))))))
      (native-inputs
       (list texinfo))
      (home-page "https://github.com/purescript-emacs/purescript-mode")
      (synopsis "Emacs major mode and related tools for Purescript")
      (description "This package provides an Emacs major mode for writing Purescript.")
      (license license:gpl3+))))

(define-public emacs-new-purescript-mode
  (let ((commit "9f7bb73e26340fcd2ea1946dbad165f0406eb3e1")
        (revision "0"))
    (package
      (name "emacs-new-purescript-mode")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/justinwoo/new-purescript-mode")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0b3499df0gfz8yrdxz9dpgwal21h50sciigwz25ri1hwv1c1i7k0"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/justinwoo/new-purescript-mode/")
      (synopsis "Simple PureScript mode for cheap syntax highlighting")
      (description "New PureScript mode is a simple PureScript Emacs mode that
just provides syntax highlighting.")
      (license license:expat))))

(define-public emacs-god-mode
  (package
    (name "emacs-god-mode")
    (version "2.17.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/chrisdone/god-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1wsc04l5j5a9y5439qx85pcchxjnjgcgwbffw3l30q9zlblvc58b"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/chrisdone/god-mode")
    (synopsis "Minor mode for entering commands without modifier keys")
    (description
     "This package provides a global minor mode for entering Emacs commands
without modifier keys.  It's similar to Vim's separation of commands and
insertion mode.  When enabled all keys are implicitly prefixed with
@samp{C-} (among other helpful shortcuts).")
    (license license:gpl3+)))

(define-public emacs-jinja2-mode
  (package
    (name "emacs-jinja2-mode")
    (version "0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/paradoxxxzero/jinja2-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0l26wcy496k6xk7q5sf905xir0p73ziy6c44is77854lv3y0z381"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/paradoxxxzero/jinja2-mode")
    (synopsis "Major mode for jinja2")
    (description
     "Emacs major mode for jinja2 with: syntax highlighting,
sgml/html integration, and indentation (working with sgml).")
    (license license:gpl3+)))

(define-public emacs-company-cabal
  ;; The latest version is 0.3.0, but no release has been provided after 0.2.1.
  (let ((commit "62112a7259e24bd6c08885629a185afe512b7d3d")
        (revision "1"))
    (package
      (name "emacs-company-cabal")
      (version (git-version "0.3.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/iquiw/company-cabal/")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1gf45xwjzdm8i4q6c6khk4dbg1mmp2r0awz2sjr4dcr2dbd1n7mg"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-company))
      (arguments
       `(#:include (cons "^tools\\/" %default-include)))
      (home-page "https://github.com/iquiw/company-cabal/")
      (synopsis "Company completion for Haskell Cabal files")
      (description
       "This package allows for completion of field names, section names,
field values, and more within @code{haskell-cabal-mode}.")
      (license license:gpl3+))))

(define-public emacs-rfcview
  (package
    (name "emacs-rfcview")
    (version "0.13")
    (home-page "http://www.loveshack.ukfsn.org/emacs")
    (source (origin
              (method url-fetch)
              (uri "http://www.loveshack.ukfsn.org/emacs/rfcview.el")
              (sha256
               (base32
                "0ympj5rxig383zl2jf0pzdsa80nnq0dpvjiriq0ivfi98fj7kxbz"))))
    (build-system emacs-build-system)
    (synopsis "Prettify Request for Comments (RFC) documents")
    (description "The Internet Engineering Task Force (IETF) and the Internet
Society (ISOC) publish various Internet-related protocols and specifications
as \"Request for Comments\" (RFC) documents and Internet Standard (STD)
documents.  RFCs and STDs are published in a simple text form.  This package
provides an Emacs major mode, rfcview-mode, which makes it more pleasant to
read these documents in Emacs.  It prettifies the text and adds
hyperlinks/menus for easier navigation.  It also provides functions for
browsing the index of RFC documents and fetching them from remote servers or
local directories.")
    (license license:gpl3+)))

(define-public emacs-ffap-rfc-space
  (package
    (name "emacs-ffap-rfc-space")
    (version "12")
    (home-page "https://user42.tuxfamily.org/ffap-rfc-space/index.html")
    (source (origin
              (method url-fetch)
              (uri "http://download.tuxfamily.org/user42/ffap-rfc-space.el")
              (sha256
               (base32
                "1iv61dv57a73mdps7rn6zmgz7nqh14v0ninidyrasy45b1nv6gck"))))
    (build-system emacs-build-system)
    (synopsis "Make ffap recognize an RFC with a space before its number")
    (description "The Internet Engineering Task Force (IETF) and the
Internet Society (ISOC) publish various Internet-related protocols and
specifications as \"Request for Comments\" (RFC) documents.  The
built-in Emacs module \"ffap\" (Find File at Point) has the ability to
recognize names at point which look like \"RFC1234\" and \"RFC-1234\"
and load the appropriate RFC from a remote server.  However, it fails
to recognize a name like \"RFC 1234\".  This package enhances ffap so
that it correctly finds RFCs even when a space appears before the
number.")
    (license license:gpl3+)))

(define-public emacs-feature-mode
  (let ((version "20190801")
        (revision "1")
        (commit "11ae1671629bfedaa553c7b819676d64eb320992"))
    (package
      (name "emacs-feature-mode")
      (version (git-version version revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/michaelklishin/cucumber.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0yd4gkxz9xcbgibfgr8apsid3f83nmg5jgqk5nql0linj5gymc28"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include (cons* "^features\\/" "snippets\\/" "^support\\/"
                          %default-include)))
      (home-page "https://github.com/michaelklishin/cucumber.el/")
      (synopsis "Emacs mode for editing Gherkin plain text user stories")
      (description "Major mode for editing Gherkin (popularized by the
Cucumber tool) user stories.  Also known by the name @code{cucumber.el}.")
      (license license:gpl2+))))

(define-public emacs-org-bullets
  (package
    (name "emacs-org-bullets")
    (version "0.2.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sabof/org-bullets")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10nr4sjffnqbllv6gmak6pviyynrb7pi5nvrq331h5alm3xcpq0w"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/sabof/org-bullets")
    (synopsis "Show bullets in org-mode as UTF-8 characters")
    (description
     "This package provides an Emacs minor mode causing bullets in
@code{org-mode} to be rendered as UTF-8 characters.")
    (license license:gpl3+)))

(define-public emacs-org-appear
  (package
    (name "emacs-org-appear")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/awth13/org-appear")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1pdf16agcjfzpjvz8kv39abir35rip93nkawxcpjjh4ywsdsbnm6"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/awth13/org-appear")
    (synopsis "Make invisible parts of Org fragments appear visible")
    (description "This package enables automatic visibility toggling of
org-mode elements depending on cursor position.  Hidden fragment parts appear
when the cursor enters a fragment and disappear when it leaves.")
    (license license:expat)))

(define-public emacs-org-drill
  (package
    (name "emacs-org-drill")
    (version "2.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/phillord/org-drill")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13y302lyscdqrba1sfx60yf5ji2xi7fbsvjsjbw7hiz63kg6rccy"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-org emacs-persist))
    (home-page "https://gitlab.com/phillord/org-drill")
    (synopsis "Flash card memorization system using Org mode")
    (description
     "This package uses spaced repetition algorithms to conduct interactive
drill sessions to aid in memorization.  In these sessions you are shown flash
cards created in Org mode.")
    (license license:gpl3+)))

(define-public emacs-anki-editor
  ;; Last release was in 2018.
  (let ((commit "546774a453ef4617b1bcb0d1626e415c67cc88df")
        (revision "0")
        (version "0.3.3"))
    (package
      (name "emacs-anki-editor")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/louietan/anki-editor")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1if610hq5j8rbjh1caw5bwbgnsn231awwxqbpwvrh966kdxzl4qf"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash emacs-request))
      (home-page "https://github.com/louietan/anki-editor")
      (synopsis "Minor mode for making Anki cards with Org mode")
      (description
       "This package is for people who use Anki as a spaced repetition system
(SRS) but would like to make cards in Org mode.")
      (license license:gpl3+))))

(define-public emacs-org-mime
  (package
    (name "emacs-org-mime")
    (version "0.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/org-mime/org-mime")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1w5z9irzk918mj75z5m0j2h8mms8v27x50kp7r3b01wblf0jd2zc"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/org-mime/org-mime")
    (synopsis "Send HTML email using Org mode HTML export")
    (description
     "This program sends HTML email using Org-mode HTML export.
This approximates a WYSiWYG HTML mail editor from within Emacs, and can be
useful for sending tables, fontified source code, and inline images in
email.")
    (license license:gpl3+)))

(define-public emacs-org-msg
  ;; No git tags.  The commit below corresponds to the release of version 3.3.
  (let ((commit "89e746c0a864031eef940758230bc7263a6f2289"))
    (package
      (name "emacs-org-msg")
      (version "3.3")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jeremy-compostella/org-msg")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "15gd5zbxvdallyra9lmpb9i1r2mmwz0j0i0ra7j9imnbfiz3ln9r"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-htmlize))
      (home-page "https://github.com/jeremy-compostella/org-msg")
      (synopsis "Mix Org mode and Message mode to compose emails")
      (description
       "OrgMsg is a GNU Emacs global minor mode mixing up Org mode and your
Mail User Agent Mode (Message, mu4e, or Notmuch) to compose and reply to
emails in a Outlook HTML friendly style.")
      (license license:gpl3+))))

(define-public emacs-org-superstar
  (package
    (name "emacs-org-superstar")
    (version "1.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/integral-dw/org-superstar-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "12inin2p6pm6vbv3yc06fx343dsp0vp07fjb35w088akhikmqh2a"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-org))
    (home-page "https://github.com/integral-dw/org-superstar-mode")
    (synopsis "Prettify headings and plain lists in Org mode")
    (description "This package prettifies headings and plain lists in
Org mode.  It is a direct descendant of @code{org-bullets}, with most
of the code base completely rewritten.

Currently, this package prettifies Org heading lines by:
@itemize
@item replacing trailing bullets by UTF-8 bullets,
@item hiding leading stars, customizing their look or removing them from vision,
@item applying a custom face to the header bullet,
@item applying a custom face to the leading bullets,
@item using double-bullets for inline tasks,
@item (optional) using special bullets for TODO keywords.
@end itemize

It also prettifies Org plain list bullets by:
@itemize
@item replacing each bullet type (*, + and -) with UTF-8 bullets,
@item applying a custom face to item bullets.
@end itemize

Features degrade gracefully when viewed from terminal.")
    (license license:gpl3+)))

(define-public emacs-org-pandoc-import
  (package
    (name "emacs-org-pandoc-import")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tecosaur/org-pandoc-import/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "00z9bpm975mlyqlxbyib3j547br6kvcam04b70qkmq22vh8yf341"))))
    (build-system emacs-build-system)
    (arguments
     `(#:include
       (cons* "^filters\\/" "^preprocessors" %default-include)
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-exec-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((pandoc (assoc-ref inputs "pandoc")))
               (substitute* "org-pandoc-import.el"
                 (("\"pandoc\"") (string-append "\"" pandoc "/bin/pandoc\"")))))))))
    (inputs
     (list pandoc))
    (home-page "https://github.com/tecosaur/org-pandoc-import/")
    (synopsis "Read and edit non-Org file types in Org")
    (description
     "This package uses Pandoc to convert selected file types to Org.  It can
convert supported non-Org files to an Org file with Pandoc.

It can also intercept requests for non-Org files it knows it can convert,
convert the file to a temporary Org file, and open this file instead.  On
save, it exports back to the original non-Org file.")
    (license license:gpl3+)))

(define-public emacs-org-pomodoro
  ;; Last release version was from 2016.
  (let ((commit "aa07c11318f91219336197e62c47bc7a3d090479")
        (revision "1"))
    (package
      (name "emacs-org-pomodoro")
      (version (git-version "2.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/marcinkoziej/org-pomodoro")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0nbprh2nhnmb7ngp9ndr6zr37ashcsvpi5slv7a37x1dl7j6w1k4"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-alert))
      (arguments
       (list
        #:include #~(cons "^resources\\/" %default-include)
        #:tests? #t
        #:test-command
        #~(list "emacs" "--batch"
                "-l" "org-pomodoro-tests.el"
                "-f" "ert-run-tests-batch-and-exit")
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'make-tests-writable
              (lambda _
                (make-file-writable "org-pomodoro-tests.el")))
            (add-before 'check 'add-require
              (lambda _
                (emacs-batch-edit-file "org-pomodoro-tests.el"
                  `(progn (progn (goto-char (point-min))
                                 (re-search-forward "ert-deftest")
                                 (beginning-of-line)
                                 (forward-line -1)
                                 (insert "(require 'org-pomodoro)"))
                          (basic-save-buffer))))))))
      (home-page "https://github.com/marcinkoziej/org-pomodoro")
      (synopsis "Pomodoro technique for org-mode")
      (description "@code{emacs-org-pomodoro} adds very basic support for
Pomodoro technique in Emacs org-mode.

Run @code{M-x org-pomodoro} for the task at point or select one of the
last tasks that you clocked time for.  Each clocked-in pomodoro starts
a timer of 25 minutes and after each pomodoro a break timer of 5
minutes is started automatically.  Every 4 breaks a long break is
started with 20 minutes.  All values are customizable.")
      (license license:gpl3+))))

(define-public emacs-org-sidebar
  (package
    (name "emacs-org-sidebar")
    (version "0.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alphapapa/org-sidebar")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1r8kp954ciin4j7j7j8ihdkryf5x09s3ryl7bi9h2j6xqc1ij4wq"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-org-super-agenda emacs-org emacs-org-ql
           emacs-s))
    (home-page "https://github.com/alphapapa/org-sidebar")
    (synopsis "Helpful sidebar for Org buffers")
    (description "This package provides a sidebar for Org buffers.  At the
top is a chronological list of scheduled and deadlined tasks in the current
buffer (similar to the Org agenda ,but without all its features), and below
that is a list of all other non-done to-do items.  If the buffer is narrowed,
the sidebar only shows items in the narrowed portion; this allows seeing an
overview of tasks in a subtree.")
    (license license:gpl3+)))

(define-public emacs-org-trello
  (package
    (name "emacs-org-trello")
    (version "0.8.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/org-trello/org-trello")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "18y5zdjc7zh4jlwz6k1nl13i721rknqm0vp4mxfnmq0sc5a0qva0"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash
           emacs-deferred
           emacs-f
           emacs-helm
           emacs-request
           emacs-s))
    (home-page "https://org-trello.github.io")
    (synopsis "Emacs minor mode for interacting with Trello")
    (description "This package provides an Emacs minor mode to extend
@code{org-mode} with Trello abilities.  Trello is an online project
organizer.")
    (license license:gpl3+)))

(define-public emacs-org-tanglesync
  (let ((commit "d99181f173b4e55b4e835d99fcd415e62beb047f")
        (revision "2"))
    (package
      (name "emacs-org-tanglesync")
      (version (git-version "0.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mtekman/org-tanglesync.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0x94gy1bgfd1f3p9w2bfrqj11bwy9ql0cpi1gw6srpj7kykx0lml"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-org))
      (home-page "https://github.com/mtekman/org-tanglesync.el")
      (synopsis "Sync Org source blocks with tangled external files")
      (description "This package automatically pulls changes from source code
to their corresponding tangled blocks.")
      (license license:gpl3+))))

(define-public emacs-company-flow
  (let ((commit "76ef585c70d2a3206c2eadf24ba61e59124c3a16")
        (revision "1"))
    (package
      (name "emacs-company-flow")
      (version (git-version "0.1.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/aaronjensen/company-flow/")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0zs9cblnbkxa0dxw4lyllmybqizxcdx96gv8jlhx20nrjpi78piw"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-company emacs-dash))
      (home-page "https://github.com/aaronjensen/company-flow/")
      (synopsis "Flow backend for @code{company-mode}")
      (description
       "This package provides completion for JavaScript files utilizing Flow.")
      (license license:gpl3+))))

(define-public emacs-habitica
  (let ((commit "c45c602ddf9d6cbb0e3baf5cb3e1b7ef90f2759d")
        (revision "1"))
    (package
      (name "emacs-habitica")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/abrochard/emacs-habitica")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0wgnzn3z98bl28jgqi7xklw9fwx2wwgihj3mq0jb8ah4vn70d0j3"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/abrochard/emacs-habitica")
      (synopsis "Emacs interface for Habitica")
      (description "Emacs extension for @uref{https://habitica.com/, Habitica},
a RPG style habit tracker and todo list.")
      (license license:gpl3+))))

(define-public emacs-atom-one-dark-theme
  (let ((commit "1f1185bf667a38d3d0d180ce85fd4c131818aae2")
        (revision "0"))
    (package
     (name "emacs-atom-one-dark-theme")
     (version (git-version "0.4.0" revision commit))
     (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/jonathanchu/atom-one-dark-theme")
                    (commit commit)))
              (sha256
               (base32
                "1alma16hg3mfjly8a9s3mrswkjjx4lrpdnf43869hn2ibkn7zx9z"))
              (file-name (git-file-name name version))))
     (build-system emacs-build-system)
     (home-page "https://github.com/jonathanchu/atom-one-dark-theme")
     (synopsis "Atom One Dark color theme for Emacs")
     (description "An Emacs port of the Atom One Dark theme from Atom.io.")
     (license license:gpl3+))))

(define-public emacs-zenburn-theme
  (package
    (name "emacs-zenburn-theme")
    (version "2.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bbatsov/zenburn-emacs")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1991s1gz2i3jchf0yvcsjjb5flwn13ifbnnfkqqrxxvy2imfh18q"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/bbatsov/zenburn-emacs")
    (synopsis "Low contrast color theme for Emacs")
    (description
     "Zenburn theme is a port of the popular Vim Zenburn theme for Emacs.
It is built on top of the custom theme support in Emacs 24 or later.")
    (license license:gpl3+)))

(define-public emacs-moe-theme-el
  (package
    (name "emacs-moe-theme-el")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kuanyui/moe-theme.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14higsv6h0pka90gr25a3yxh95xn65l6qxb39mmdzkfdlnzsg664"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/kuanyui/moe-theme.el")
    (synopsis "Anime-inspired color themes")
    (description
     "This package provides vibrant color schemes with light and dark
variants.")
    (license license:gpl3+)))

(define-public emacs-solarized-theme
  (package
    (name "emacs-solarized-theme")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bbatsov/solarized-emacs/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "17z6cj8ids88xj2i6zs1s0mxs0fhn3gr7g5nhhy8s8khnzmyy2vj"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://github.com/bbatsov/solarized-emacs")
    (synopsis "Port of the Solarized theme for Emacs")
    (description
     "Solarized for Emacs is a port of the Solarized theme for Vim.  This
package provides a light and a dark variant.")
    (license license:gpl3+)))

(define-public emacs-color-theme-solarized
  ;; From 2017-10-24.  No releases available.
  (let ((commit "f3ca8902ea056fb8e46cb09f09c96294e31cd4ee")
        (revision "0"))
    (package
      (name "emacs-color-theme-solarized")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url
                       "https://github.com/sellout/emacs-color-theme-solarized")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "16d7adqi07lzzr0qipl1fbag9l8kiyr3xrqxi528pimcisbg85d3"))))
      (build-system emacs-build-system)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 ;; These are intended for old versions of Emacs and do not
                 ;; compile with emacs>=24.
                 (add-before 'install 'remove-color-theme
                   (lambda _
                     (delete-file "./color-theme-solarized.el")
                     (delete-file "./color-theme-solarized-pkg.el"))))))
      (home-page "https://github.com/sellout/emacs-color-theme-solarized")
      (synopsis "Solarized color scheme for Emacs")
      (description
       "This package provides Emacs highlighting using Ethan Schoonover’s
Solarized color scheme.")
      (license license:expat))))

(define-public emacs-poet-theme
  (let ((commit "16eb694f0755c04c4db98614d0eca1199fddad70")
        (revision "1"))
    (package
      (name "emacs-poet-theme")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/kunalb/poet")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0zm8jbviddyj7jnyssh77jx43jghbpjwr77n9s3cjp3bmadwkrv5"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/kunalb/poet/")
      (synopsis "Emacs theme for prose")
      (description
       "Emacs has very good support for multiple fonts in a single file.  Poet
uses this support to make it much more convenient to write prose within Emacs,
with particular attention paid to @code{org-mode} and @code{markdown-mode}.
Code blocks, tables, etc are formatted in monospace text with the appropriate
backgrounds.")
      (license license:expat))))

(define-public emacs-ahungry-theme
  (package
    (name "emacs-ahungry-theme")
    (version "1.10.0")
    (source
     (origin (method url-fetch)
             (uri (string-append "https://elpa.gnu.org/packages/ahungry-theme-"
                                 version ".tar"))
             (sha256
              (base32
               "14q5yw56n82qph09bk7wmj5b1snhh9w0nk5s1l7yn9ldg71xq6pm"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ahungry/color-theme-ahungry")
    (synopsis "Ahungry color theme for Emacs")
    (description "Ahungry theme for Emacs provides bright and bold colors.
If you load it from a terminal, you will be able to make use of the
transparent background.  If you load it from a GUI, it will default to a
dark background.")
    (license license:gpl3+)))

(define-public emacs-color-theme-modern
  ;; No release since October 2019
  (let ((commit "74ad69bbca6fcfff3c0960d888c7c9c1f9f3e2e8")
        (revision "1"))
    (package
      (name "emacs-color-theme-modern")
      (version (git-version "0.0.3" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/emacs-jp/replace-colorthemes.git")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "13ff4s372wsl5x13vh4vywhi6qcc54gybhp6rxl0r1l4wxidanwn"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/emacs-jp/replace-colorthemes")
      (synopsis "Emacs color themes implemented via built-in customization")
      (description "This package contains several themes that were originally
implemented with the venerable @code{color-themes} package, ported to Emacs'
built-in custom themes.")
      (license license:gpl3+))))

(define-public emacs-gruvbox-theme
  (package
    (name "emacs-gruvbox-theme")
    (version "1.30.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/greduan/emacs-theme-gruvbox")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0dgjf86i8179l1nsjyc20chysqmy8yhphpd5lzv2ypx79l4z3jka"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-autothemer))
    (home-page "https://github.com/greduan/emacs-theme-gruvbox")
    (synopsis "Gruvbox is a retro groove color scheme ported from Vim")
    (description
     "Gruvbox is heavily inspired by badwolf, jellybeans and solarized.

Designed as a bright theme with pastel 'retro groove' colors and light/dark
mode switching in the way of solarized.  The main focus when developing gruvbox
is to keep colors easily distinguishable, contrast enough and still pleasant
for the eyes.")
    (license license:expat))) ; MIT license

(define-public emacs-spacegray-theme
  (let ((commit "9826265c2bceb2ebc1c5e16a45021da0253ace97")
        (revision "0"))
    (package
      (name "emacs-spacegray-theme")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/bruce/emacs-spacegray-theme")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0aplwmm17ypbns5blc4rf5rr6dasj0zp5ibykpfl43fh4bd8z89n"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/bruce/emacs-spacegray-theme")
      (synopsis "Port of Sublime Text's Spacegray theme for Emacs")
      (description
       "@code{spacegray-theme} is an Emacs port of the Spacegray theme from
Sublime Text.  It features a dark blue/gray background and soft blue, green,
orange and red as accent colors.")
      (license license:expat)))) ; MIT license

(define-public emacs-org-cv
  ;; There are no tagged releases.
  (let ((commit "24bcd82348d441d95c2c80fb8ef8b5d6d4b80d95")
        (revision "0"))
    (package
      (name "emacs-org-cv")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/Titan-C/org-cv")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0zcnbxvlwi4d6vzsm3ag7z74qphdigmx303gppb9d614jnsfsdg2"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ox-hugo))
      (home-page "https://titan-c.gitlab.io/org-cv/")
      (synopsis "Collection of export backends for Org to generate a CV")
      (description
       "This project exports an Org file with reasonably structured items into
a LaTeX file, which compiles into a nice CV.  In the same spirit, the Org file
may export to Markdown so that it can be used for a web based CV.")
      (license license:gpl3+))))

(define-public emacs-ox-gfm
  (package
    (name "emacs-ox-gfm")
    (version "1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/larstvei/ox-gfm")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0drdypmgxk3238hmkqw9s3cw9wv94cyfqar5ar0bv0k69s92pxj8"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/larstvei/ox-gfm")
    (synopsis "Github Flavored Markdown Back-End for Org Export Engine")
    (description "This package is a small exporter based on the Markdown
exporter already existing in Org mode.  It supports the Github flavored
markdown features.")
    (license license:gpl3+)))

(define-public emacs-2048-game
  (package
    (name "emacs-2048-game")
    (version "20151026.1233")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://melpa.org/packages/2048-game-"
                           version ".el"))
       (sha256
        (base32
         "0gy2pvz79whpavp4jmz8h9krzn7brmvv3diixi1d4w51pcdvaldd"))))
    (build-system emacs-build-system)
    (home-page "https://hg.sr.ht/~zck/game-2048")
    (synopsis "Implementation of the game 2048 in Emacs Lisp")
    (description
     "This program is an implementation of 2048 for Emacs.
The goal of this game is to create a tile with value 2048.  The size of the
board and goal value can be customized.")
    (license license:gpl3+)))

(define-public emacs-chess
  (package
    (name "emacs-chess")
    (version "2.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "chess-" version ".tar"))
       (sha256
        (base32 "1a4iwjdh6k348df6qywjws9z9f862d62m0b2sz57z4xhywiyxpr7"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'install-pieces
            (lambda _
              (let ((pieces
                     (string-append #$output "/share/emacs/site-lisp/chess-"
                                    #$version "/pieces")))
                (mkdir-p pieces)
                (copy-recursively "pieces" pieces)))))))
    (home-page "https://elpa.gnu.org/packages/chess.html")
    (synopsis "Play chess in GNU Emacs")
    (description
     "Chess is an Emacs Lisp library and several clients on top of the
underlying library functionality for performing various activities related to
the game of chess.")
    (license license:gpl3+)))

(define-public emacs-4clojure
  ;; There is no release.  Base version is extracted from Version keyword in
  ;; the main file.
  (let ((commit "4eccf8c7d4341a36c269451838114b27836699f9")
        (revision "1"))
    (package
      (name "emacs-4clojure")
      (version (git-version "0.2.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsorphanage/4clojure")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19x653lzc1dxil4ix257hciidbdmbhaxhs6qhlkwi9ygjrlrgvnk"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-request))
      (home-page "https://github.com/emacsorphanage/4clojure/")
      (synopsis "Open and evaluate 4clojure questions in Emacs")
      (description "Emacs 4clojure interacts with
@url{http://www.4clojure.com, 4clojure} problems.  You can open a specific
question and move to the next or previous one.  You can also verify your
answers.")
      (license license:gpl3+))))

(define-public emacs-base16-theme
  (package
    (name "emacs-base16-theme")
    (version "3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/belak/base16-emacs")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0qp71j77zg8gippcn277s0j5a9n6dbwv3kdp2nya6li4b412vgba"))))
    (build-system emacs-build-system)
    (arguments
     (list #:include #~(cons "^build\\/.*\\.el$" %default-include)
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'install 'mv-themes
                 (lambda _
                   (use-modules (ice-9 regex))
                   (let ((theme-dir (string-append (elpa-directory #$output)
                                                   "/build")))
                     (for-each (lambda (theme)
                                 (rename-file
                                  theme
                                  (regexp-substitute #f
                                                     (string-match "build\\/"
                                                                   theme)
                                                     'pre 'post)))
                               (find-files theme-dir "\\.el$"))
                     (delete-file-recursively theme-dir)))))))
    (home-page "https://github.com/belak/base16-emacs")
    (synopsis "Base16 color themes for Emacs")
    (description
     "Base16 provides carefully chosen syntax highlighting and a default set
of sixteen colors suitable for a wide range of applications.  Base16 is not a
single theme but a set of guidelines with numerous implementations.")
    (license license:expat)))

(define-public emacs-solaire-mode
  (package
    (name "emacs-solaire-mode")
    (version "2.0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hlissner/emacs-solaire-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1lkm09wznal0grpz61ikc77mjrri1x1bi79qwyf1cah9s0wv3isq"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/hlissner/emacs-solaire-mode")
    (synopsis "Change background of file-visiting buffers in Emacs")
    (description
     "@code{solaire-mode} is inspired by editors which visually distinguish
code-editing windows from sidebars, popups, terminals, ecetera.  It changes the
background of file-visiting buffers (and certain aspects of the UI) to make
them easier to distinguish from other, less important buffers.")
    (license license:expat)))

(define-public emacs-embark
  (package
    (name "emacs-embark")
    (version "0.17")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/oantolin/embark")
             (commit version)))
       (sha256
        (base32 "1s0ssf4q9kg4c5w87h2ypyvrhi31mz3s6k4h7pxi9a47lkccq8n1"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-avy emacs-consult))
    (home-page "https://github.com/oantolin/embark")
    (synopsis "Emacs mini-buffer actions rooted in keymaps")
    (description
     "This package provides a sort of right-click contextual menu for Emacs
offering you relevant @emph{actions} to use on a @emph{target} determined by
the context.

In the minibuffer, the target is the current best completion candidate.  In
the @code{*Completions*} buffer the target is the completion at point.  In
a regular buffer, the target is the region if active, or else the file, symbol
or URL at point.

The type of actions offered depend on the type of the target.  For files you
get offered actions like deleting, copying, renaming, visiting in another
window, running a shell command on the file, etc.  For buffers the actions
include switching to or killing the buffer.  For package names the actions
include installing, removing or visiting the homepage.")
    (license license:gpl3+)))

(define-public emacs-prescient
  (package
    (name "emacs-prescient")
    (version "6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/raxod502/prescient.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0156sbs4b535mcwm44qjr8lx48svmjvdqh8c8hr6d0l709f27yq3"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-company emacs-ivy emacs-selectrum))
    (home-page "https://github.com/raxod502/prescient.el/")
    (synopsis "Emacs library for sorting and filtering candidates")
    (description
     "Prescient is a library for sorting and filtering, as well as extensions
for Ivy and Company that make use of the library.")
    (license license:expat)))

(define-public emacs-selectrum
  (package
    (name "emacs-selectrum")
    (version "3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/raxod502/selectrum")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "02jrki6vzyfyi1bbslki5pk2348flh9dz18jkc4y7p60bvbr52cb"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/raxod502/selectrum/")
    (synopsis "Incremental narrowing in Emacs")
    (description "Selectrum is a solution for incremental narrowing in
Emacs, replacing Helm, Ivy, and IDO.  Its design philosophy is based
on choosing the right abstractions and prioritizing consistency and
predictability over special-cased improvements for particular cases.
As such, Selectrum follows existing Emacs conventions where they exist
and are reasonable, and it declines to implement features which have
marginal benefit compared to the additional complexity of a new
interface.")
    (license license:expat)))

(define-public emacs-orderless
  (package
    (name "emacs-orderless")
    (version "0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/oantolin/orderless")
             (commit version)))
       (sha256
        (base32 "0m9nyz80j0qnn14drbgk8vn5yr7sv0z6yiz8w95ahcw2qwlgyjs7"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'install 'makeinfo
           (lambda* (#:key outputs #:allow-other-keys)
             (invoke "makeinfo" "orderless.texi")
             (install-file "orderless.info"
                           (string-append (assoc-ref outputs "out")
                                          "/share/info")))))))
    (native-inputs
     (list texinfo))
    (home-page "https://github.com/oantolin/orderless")
    (synopsis "Emacs completion style that matches multiple regexps in any order")
    (description "This package provides an orderless completion style that
divides the pattern into space-separated components, and matches candidates
that match all of the components in any order.  Each component can match in
any one of several ways: literally, as a regexp, as an initialism, in the flex
style, or as multiple word prefixes.")
    (license license:gpl3+)))

(define-public emacs-consult
  (package
    (name "emacs-consult")
    (version "0.20")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/minad/consult")
             (commit version)))
       (sha256
        (base32 "1rm53sqfl8hnb1l1fr0s8kxgp03prc2ggywqs5ssiqx87vhyn70w"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/minad/consult")
    (synopsis "Consulting completing-read")
    (description "This package provides various handy commands based on the
Emacs completion function completing-read, which allows quickly selecting from a
list of candidates.")
    (license license:gpl3+)))

(define-public emacs-consult-bibtex
  ;; XXX: Upstream contains a single commit, which matches the version below.
  (let ((commit "2f870d6eefb54a53216d90a82cff0ff97ba54725"))
    (package
      (name "emacs-consult-bibtex")
      (version "0.1")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/mohkale/consult-bibtex")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0jxjvpg3j8zk77sfhyy27fd1zbj2zz7xayavan3hhj4853q92kwq"))))
      (build-system emacs-build-system)
      (inputs (list emacs-consult emacs-embark emacs-org-roam-bibtex))
      (home-page "https://github.com/mohkale/consult-bibtex")
      (synopsis "Consulting-read interface for BibTeX completion")
      (description "This package provides a read interface for BibTeX
completion using Consult.")
      (license license:gpl3+))))

(define-public emacs-consult-dir
  (package
    (name "emacs-consult-dir")
    (version "0.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/karthink/consult-dir")
                    (commit (string-append "v" version))))
              (sha256
               (base32 "1cff4ssrn1mw2s5n090pdmwdirnfih8idg5f0ll2bi2djc4hq5kn"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-consult))
    (home-page "https://github.com/karthink/consult-dir")
    (synopsis "Insert paths into minibuffer prompts in Emacs")
    (description "Consult-dir allows you to easily insert directory
paths into the minibuffer prompt in Emacs.

When using the minibuffer, you can switch---with completion and filtering
provided by your completion setup---to any directory you’ve visited recently,
or to a project or bookmarked directory.  The minibuffer prompt will be
replaced with the directory you choose.")
    (license license:gpl3+)))

(define-public emacs-consult-notmuch
  (package
    (name "emacs-consult-notmuch")
    (version "0.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/jao/consult-notmuch")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "18r47cj89qli534irah3lwwzsnik5bcf61clnrkhafqv9y51m67z"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-consult emacs-notmuch))
    (home-page "https://codeberg.org/jao/consult-notmuch")
    (synopsis "Search and preview Notmuch emails using Consult")
    (description
     "This package provides two commands using Consult to query Notmuch emails
and present results either as single emails or full trees.")
    (license license:gpl3+)))

(define-public emacs-consult-org-roam
  (let* ((commit "9572c5bc194a583dc9e86ea7d2751959d86b5c78")
         (revision "0"))
    (package
      (name "emacs-consult-org-roam")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jgru/consult-org-roam")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0c2hjd2gw77h77487fzdqfybg0ricsvlnwwfxai9baawz37bcn7q"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-consult emacs-org-roam))
      (home-page "https://github.com/jgru/consult-org-roam")
      (synopsis "Consult integration for Org Roam")
      (description
       "This is a set of functions to use Org Roam with Consult.  This
packages replaces Org Roam's own completing read functions with equivalent
versions utilizing Consult's internal API.")
      (license license:gpl3+))))

(define-public emacs-consult-eglot
  (package
   (name "emacs-consult-eglot")
   (version "0.2.0")
   (source (origin
            (method git-fetch)
            (uri (git-reference
                  (url "https://github.com/mohkale/consult-eglot")
                  (commit (string-append "v" version))))
            (sha256
             (base32 "1qxk1npxbf8m3g9spikgdxcf6mzjx6cwy3f5vn6zz5ksh14xw3sd"))
            (file-name (git-file-name name version))))
   (build-system emacs-build-system)
   (propagated-inputs (list emacs-consult emacs-eglot))
   (home-page "https://github.com/mohkale/consult-eglot")
   (synopsis "Consulting-read interface for eglot")
   (description "This package acts as a parallel of consult-lsp for eglot and
provides a front-end interface for the workspace/symbols LSP procedure
call.")
   (license license:gpl3+)))

(define-public emacs-consult-yasnippet
  (let ((commit "ae0450889484f23dc4ec37518852a2c61b89f184")
        (revision "0"))
    (package
      (name "emacs-consult-yasnippet")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mohkale/consult-yasnippet")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "13hmmsnmh32vafws61sckzzy354rq0nslqpyzhw97iwvn0fpsa35"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-consult emacs-yasnippet))
      (home-page "https://github.com/mohkale/consult-yasnippet")
      (synopsis "Consulting-read interface for Yasnippet")
      (description
       "This package allows you to expand Yasnippet' snippets through
a completing-read interface.  It supports previewing the current snippet
expansion and overwriting the marked region with a new snippet completion.")
      (license license:gpl3+))))

(define-public emacs-marginalia
  (package
    (name "emacs-marginalia")
    (version "0.15")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/minad/marginalia")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ncdyczalvl677nim0iha003xway7rwxw8y35vcvkgsdk4vzv848"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/minad/marginalia")
    (synopsis "Marginalia in the minibuffer completions")
    (description
     "This package provides Marginalia mode which adds marginalia to the
minibuffer completions.  Marginalia are marks or annotations placed at the
margin of the page of a book or in this case helpful colorful annotations
placed at the margin of the minibuffer for your completion candidates.")
    (license license:gpl3+)))

(define-public emacs-smartparens
  (package
    (name "emacs-smartparens")
    (version "1.11.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Fuco1/smartparens")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0zij2f2rjjym98w68jkp10n1ckpfprlkk217c3fg16hz5nq4vnm6"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-markdown-mode))
    (home-page "https://github.com/Fuco1/smartparens")
    (synopsis "Paredit-like insertion, wrapping and navigation with user
defined pairs")
    (description
     "Smartparens is a minor mode for Emacs that deals with parens pairs
and tries to be smart about it.  It started as a unification effort to
combine functionality of several existing packages in a single,
compatible and extensible way to deal with parentheses, delimiters, tags
and the like.  Some of these packages include autopair, textmate,
wrap-region, electric-pair-mode, paredit and others.  With the basic
features found in other packages it also brings many improvements as
well as completely new features.")
    (license license:gpl3+)))

(define-public emacs-dumbparens
  ;; There are no releases.
  (let ((commit "18b668772f25e5f7b62c0a000b8169eaf7515057")
        (revision "0"))
    (package
      (name "emacs-dumbparens")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/raxod502/dumbparens")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0xv2yzjzq2450z007jppf86knnwzb2s3sxvqyk1yp6qs9mgrmnyp"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #t
        #:test-command #~(list "make" "test")))
      (home-page "https://github.com/raxod502/dumbparens/")
      (synopsis "Minor mode that provides improvements on Smartparens")
      (description
       "@code{emacs-dumbparens} is a minor mode for Emacs that deals with parens
pairs and doesn't try to be smart about it.")
      (license license:expat))))

(define-public emacs-highlight-symbol
  ;; We prefer a more recent commit that provides an option to squelch
  ;; echo-area alerts that can drown out useful information like eldoc
  ;; messages.
  (let ((commit "7a789c779648c55b16e43278e51be5898c121b3a")
        (version "1.3")
        (revision "1"))
    (package
      (name "emacs-highlight-symbol")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/nschum/highlight-symbol.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19cgyk0sh8nsmf3jbi92i8qsdx4l4yilfq5jj9zfdbj9p5gvwx96"))))
      (build-system emacs-build-system)
      (home-page "https://nschum.de/src/emacs/highlight-symbol/")
      (synopsis "Automatic and manual symbol highlighting for Emacs")
      (description
       "Use @code{highlight-symbol} to toggle highlighting of the symbol at
point throughout the current buffer.  Use @code{highlight-symbol-mode} to keep
the symbol at point highlighted.

The functions @code{highlight-symbol-next}, @code{highlight-symbol-prev},
@code{highlight-symbol-next-in-defun} and
@code{highlight-symbol-prev-in-defun} allow for cycling through the locations
of any symbol at point.  Use @code{highlight-symbol-nav-mode} to enable key
bindings @code{M-p} and @code{M-p} for navigation.  When
@code{highlight-symbol-on-navigation-p} is set, highlighting is triggered
regardless of @code{highlight-symbol-idle-delay}.

@code{highlight-symbol-query-replace} can be used to replace the symbol.")
      (license license:gpl2+))))

(define-public emacs-symbol-overlay
  (package
    (name "emacs-symbol-overlay")
    (version "4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/wolray/symbol-overlay")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10n0871xzycifyqp73xnbqmrgy60imlb26yhm3p6vfj3d84mg1b2"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/wolray/symbol-overlay")
    (synopsis "Highlight symbols and perform various search operations on them")
    (description
     "This package provides functions for highlighting and navigating
between symbols.")
    (license license:gpl3+)))

(define-public emacs-hl-todo
  (package
    (name "emacs-hl-todo")
    (version "3.4.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/tarsius/hl-todo")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "03i3dvg7scvbxx6z07916zqc7p8w5s9nxv4v2phr68046zjz05dw"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tarsius/hl-todo")
    (synopsis "Emacs mode to highlight TODO and similar keywords")
    (description
     "This package provides an Emacs mode to highlight TODO and similar
keywords in comments and strings.  This package also provides commands for
moving to the next or previous keyword and to invoke @code{occur} with a
regexp that matches all known keywords.")
    (license license:gpl3+)))

(define-public emacs-perspective
  (package
    (name "emacs-perspective")
    (version "2.18")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nex3/perspective-el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1r026cw6p2ss5wg8mxgzf6iv1lb9pdnqyf6yrqb914aibkrvp9b6"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "-Q" "-batch" "-L" "."
                        "-l" "test/test-perspective.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/nex3/perspective-el")
    (synopsis "Switch between named \"perspectives\"")
    (description
     "This package provides tagged workspaces in Emacs, similar to workspaces in
windows managers such as Awesome and XMonad.  @code{perspective.el} provides
multiple workspaces (or \"perspectives\") for each Emacs frame.  Each
perspective is composed of a window configuration and a set of buffers.
Switching to a perspective activates its window configuration, and when in a
perspective only its buffers are available by default.")
    ;; This package is released under the same license as Emacs (GPLv3+) or
    ;; the Expat license.
    (license license:gpl3+)))

(define-public emacs-persp-mode
  (package
    (name "emacs-persp-mode")
    (version "2.9.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Bad-ptr/persp-mode.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0b4y7a6j70s9lvr37riyy9k5kh3yvmx0m6nd9c0c8572ji4ij65g"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Bad-ptr/persp-mode.el")
    (synopsis "Switch between named \"perspectives\" shared among frames")
    (description
     "This package extends @code{perspective.el} to enable perspectives that
can be saved to and restored from a file.")
    (license license:gpl2+)))

(define-public emacs-eyebrowse
  ;; XXX: Upstream has no tagged release.  Version is extracted from keyword
  ;; in main file.
  (let ((commit "88c7b59aa7c5c93bc23812217213adfa238f977b")
        (revision "0"))
    (package
      (name "emacs-eyebrowse")
      (version (git-version "0.7.8" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://depp.brause.cc/eyebrowse.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "09s07mvg5bz3dm9sxgn40c7z6d6ry1sdjzsxwgmy825f3xm66avs"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://depp.brause.cc/eyebrowse/")
    (synopsis "Simple-minded way to manage window configs in Emacs")
    (description
     "Eyebrowse is a global minor mode for Emacs that allows you to manage
your window configurations in a simple manner, just like tiling window
managers like i3wm with their workspaces do.  It displays their current state
in the modeline by default.")
    (license license:gpl3+))))

(define-public emacs-test-simple
  (package
    (name "emacs-test-simple")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/test-simple-"
                           version ".el"))
       (sha256
        (base32
         "1yd61jc9ds95a5n09052kwc5gasy57g4lxr0jsff040brlyi9czz"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rocky/emacs-test-simple")
    (synopsis "Simple unit test framework for Emacs Lisp")
    (description
     "Test Simple is a simple unit test framework for Emacs Lisp.  It
alleviates the need for context macros, enclosing specifications or required
test tags.  It supports both interactive and non-interactive use.")
    (license license:gpl3+)))

(define-public emacs-load-relative
  (package
    (name "emacs-load-relative")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/load-relative-"
                           version ".el"))
       (sha256
        (base32 "1m37scr82lqqy954fchjxrmdh4lngrl4d1yzxhp3yfjhsydizhrj"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rocky/emacs-load-relative")
    (synopsis "Emacs Lisp relative file loading related functions")
    (description
     "Provides functions which facilitate writing multi-file Emacs packages
and running from the source tree without having to \"install\" code or fiddle
with @{load-path}.

The main function, @code{load-relative}, loads an Emacs Lisp file relative to
another (presumably currently running) Emacs Lisp file.")
    (license license:gpl3+)))

(define-public emacs-loc-changes
  (package
    (name "emacs-loc-changes")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/loc-changes-"
                           version ".el"))
       (sha256
        (base32
         "1x8fn8vqasayf1rb8a6nma9n6nbvkx60krmiahyb05vl5rrsw6r3"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rocky/emacs-loc-changes")
    (synopsis "Keeps track of positions even after buffer changes")
    (description
     "This Emacs package provides a mean to track important buffer positions
after buffer changes.")
    (license license:gpl3+)))

(define-public emacs-realgud
  (package
    (name "emacs-realgud")
    (version "1.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/realgud/realgud/")
             (commit version)))
       (sha256
        (base32
         "1d3s23jk0i34wpyxfajydgyyvsxnpbqrfl0mgydsq7zw2c75ylnq"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #t
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-realgud:run-process-void-error
            ;; See: https://github.com/realgud/realgud/issues/269.
            (lambda _
              (substitute* '("realgud/debugger/gdb/gdb.el"
                             "realgud/debugger/gub/gub.el")
                (("^\\(require 'load-relative\\).*" anchor)
                 (string-append anchor
                                "(require-relative-list \
'(\"../../common/run\") \"realgud:\")\n")))))
          (add-after 'expand-load-path 'fix-autogen-script
            (lambda _
              (substitute* "autogen.sh"
                (("./configure") "sh configure"))))
          (add-after 'fix-autogen-script 'autogen
            (lambda _
              (setenv "CONFIG_SHELL" "sh")
              (invoke "sh" "autogen.sh")))
          (add-after 'fix-autogen-script 'set-home
            (lambda _
              (setenv "HOME" (getenv "TMPDIR"))))
          (add-before 'patch-el-files 'remove-realgud-pkg.el
            (lambda _
              ;; FIXME: `patch-el-files' crashes on this file with error:
              ;; unable to locate "bashdb".
              (delete-file "./test/test-regexp-bashdb.el"))))
      #:include #~(cons* ".*\\.el$" %default-include)))
    (native-inputs
     (list autoconf automake emacs-test-simple))
    (propagated-inputs
     (list emacs-load-relative emacs-loc-changes))
    (home-page "https://github.com/realgud/realgud/")
    (synopsis
     "Modular front-end for interacting with external debuggers")
    (description
     "RealGUD is a modular, extensible GNU Emacs front-end for interacting
with external debuggers.  It integrates various debuggers such as gdb, pdb,
ipdb, jdb, lldb, bashdb, zshdb, etc. and allows visually steping through code in the
sources.  Unlike GUD, it also supports running multiple debug sessions in
parallel.")
    (license license:gpl3+)))

(define-public emacs-rmsbolt
  ;; There is no release tag. Version is extracted from main file.
  (let ((commit "ff496660cc52a6dd33d358ef0acc6d4bb70cc340")
        (revision "0")
        (version "0.1.2"))
    (package
      (name "emacs-rmsbolt")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/jgkamat/rmsbolt")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "05i0101238yy1da6z543nr9x5gpvgdxrrdn3sw5dibcn6z62ml3p"))))
      (build-system emacs-build-system)
      (home-page "https://gitlab.com/jgkamat/rmsbolt")
      (synopsis "Emacs viewer for compiler output")
      (description
       "RMSBolt is a package to provide assembly or bytecode output for
a source code input file.")
      (license license:agpl3+))))

(define-public emacs-request
  ;; We prefer a more recent commit that has support for auth-source,
  ;; and has some bug fixes for Emacs 28.
  (let ((commit "3336eaa97de923f74b90dda3e35985e122d40805")
        (revision "1"))
    (package
      (name "emacs-request")
      (version (git-version "0.3.2" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/tkf/emacs-request")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0jckwy5zhz95d6l3lz8b9b34pppcjjzy97fg1wn8mqzhf3h460ac"))))
      (build-system emacs-build-system)
      (arguments
       `(#:tests? #f))                  ; requires network access.
      (propagated-inputs
       (list emacs-deferred))
      (home-page "https://github.com/tkf/emacs-request")
      (synopsis "Package for speaking HTTP in Emacs Lisp")
      (description "This package provides a HTTP request library with multiple
backends.  It supports url.el which is shipped with Emacs and the curl command
line program.")
      (license license:gpl3+))))

(define-public emacs-rudel
  (package
    (name "emacs-rudel")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/rudel-"
                           version ".tar"))
       (sha256
        (base32 "03hcvpp6ykavidwn5x48gs986w1i5icvh7ks6p74pdaagpgw4jmk"))))
    (build-system emacs-build-system)
    (home-page "http://rudel.sourceforge.net/")
    (synopsis "Collaborative editing framework")
    (description
     "Rudel is a collaborative editing environment for GNU Emacs.  Its purpose
is to share buffers with other users in order to edit the contents of those
buffers collaboratively.  Rudel supports multiple backends to enable
communication with other collaborative editors using different protocols,
though currently Obby (for use with the Gobby editor) is the only
fully-functional one.")
    (license license:gpl3+)))

(define-public emacs-hydra
  (package
    (name "emacs-hydra")
    (version "0.15.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/abo-abo/hydra")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0fapvhmhgc9kppf3bvkgry0cd7gyilg7sfvlscfrfjxpx4xvwsfy"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("make" "test")))
    (home-page "https://github.com/abo-abo/hydra")
    (synopsis "Make Emacs bindings that stick around")
    (description
     "This package can be used to tie related commands into a family of short
bindings with a common prefix---a Hydra.  Once you summon the Hydra (through
the prefixed binding), all the heads can be called in succession with only a
short extension.  Any binding that isn't the Hydra's head vanquishes the
Hydra.  Note that the final binding, besides vanquishing the Hydra, will still
serve its original purpose, calling the command assigned to it.  This makes
the Hydra very seamless; it's like a minor mode that disables itself
automatically.")
    (license license:gpl3+)))

(define-public emacs-pretty-hydra
  (package
    (name "emacs-pretty-hydra")
    (version "0.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jerrypnz/major-mode-hydra.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "08a15knkdq35pzjq82imff016fbfdib5q4glg2xmdy2b5fnk7jqa"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-hydra emacs-s))
    (arguments
     `(#:exclude (cons "^major-mode-hydra\\.el" %default-exclude)))
    (home-page "https://github.com/jerrypnz/major-mode-hydra.el")
    (synopsis "Major mode keybindings managed by Hydra")
    (description
     "This package offers an hydra-based method of managing major
mode-specific key bindings.  It is intended for use as a library only; see
package @code{emacs-major-mode-hydra} for a user-friendly interface.")
    (license license:gpl3+)))

(define-public emacs-interleave
  (package
    (name "emacs-interleave")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/rudolfochrist/interleave")
         (commit (string-append "interleave-" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0l5b681mrpk12lx5c16m7kc13p29z6zismwg1llsjg7cdmrmsrcb"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rudolfochrist/interleave")
    (synopsis "Emacs minor mode to interleave notes and text books")
    (description
     "Interleave is a minor mode that presents a document viewer side
by side to an Org buffer with your notes relevant to the current page.")
    (license license:gpl3+)))

(define-public emacs-major-mode-hydra
  (package
    (inherit emacs-pretty-hydra)
    (name "emacs-major-mode-hydra")
    (propagated-inputs
     (list emacs-dash emacs-pretty-hydra))
    (arguments
     `(#:exclude (cons "^pretty-hydra\\.el" %default-exclude)))
    (synopsis "Create nice-looking hydras")
    (description
     "This package provides the macro @code{pretty-hydra-define} to define
hydras with one column per group of heads.")))

(define-public emacs-ivy
  (package
    (name "emacs-ivy")
    (version "0.13.4")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/ivy-" version ".tar"))
       (sha256
        (base32 "0qpza1c45mr8fcpnm32cck4v22fnzz1yb7kww05rzgq1k9iivx5v"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-hydra))
    (home-page "https://github.com/abo-abo/swiper")
    (synopsis "Incremental vertical completion for Emacs")
    (description
     "This package provides @code{ivy-read} as an alternative to
@code{completing-read} and similar functions.  No attempt is made to determine
the best candidate.  Instead, the user can navigate candidates with
@code{ivy-next-line} and @code{ivy-previous-line}.  The matching is done by
splitting the input text by spaces and re-building it into a regular
expression.")
    (license license:gpl3+)))

(define-public emacs-counsel
  (package
    (name "emacs-counsel")
    (version "0.13.4")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "counsel-" version ".tar"))
       (sha256
        (base32 "094zfapfn1l8wjf3djkipk0d9nks0g77sbk107pfsbr3skkzh031"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-swiper))
    (home-page "https://github.com/abo-abo/swiper")
    (synopsis "Various completion functions using Ivy")
    (description
     "Just call one of the interactive functions in a file to complete the
corresponding thing using Ivy.

The following completions are currently available:
@itemize
@item Symbol completion for Elisp, Common Lisp, Python, Clojure, C, C++.
@item Describe functions for Elisp: function, variable, library, command,
@item bindings, theme.
@item Navigation functions: imenu, ace-line, semantic, outline.
@item Git utilities: git-files, git-grep, git-log, git-stash, git-checkout.
@item Grep utilities: grep, ag, pt, recoll, ack, rg.
@item System utilities: process list, rhythmbox, linux-app.
@item Many more.
@end itemize")
    (license license:gpl3+)))

(define-public emacs-swiper
  (package
    (name "emacs-swiper")
    (version "0.13.4")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/swiper-" version ".tar"))
       (sha256
        (base32 "197pq2cvvskib87aky907wv2am55vilr7y5dabmmm07a8vr9py0v"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-ivy))
    (home-page "https://github.com/abo-abo/swiper")
    (synopsis "Isearch with an overview")
    (description
     "This package gives an overview of the current regex search candidates.
The search regex can be split into groups with a space.  Each group is
highlighted with a different face.

It can double as a quick `regex-builder', although only single lines will be
matched.")
    (license license:gpl3+)))

(define-public emacs-ivy-xref
  (let ((commit "1a35fc0f070388701b05b0a455cbe262e924d547")
        (revision "1"))
    (package
      (name "emacs-ivy-xref")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alexmurray/ivy-xref")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0d71nm9d9ajp5i6dnl8h1hw9jqp8gd1ajgninb1h13i80rplzl9k"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ivy))
      (home-page "https://github.com/alexmurray/ivy-xref")
      (synopsis "Ivy interface for @code{xref}")
      (description "This package provides an Ivy interface for selecting from
@code{xref} results.")
      (license license:gpl3))))

(define-public emacs-ivy-pass
  (let ((commit "5b523de1151f2109fdd6a8114d0af12eef83d3c5")
        (revision "1"))
    (package
      (name "emacs-ivy-pass")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ecraven/ivy-pass")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "18crb4zh2pjf0cmv3b913m9vfng27girjwfqc3mk7vqd1r5a49yk"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ivy emacs-password-store))
      (home-page "https://github.com/ecraven/ivy-pass")
      (synopsis "Ivy interface to the @code{pass} password store")
      (description
       "This package provides an Ivy interface for working with the password
store (@code{pass}) in Emacs.")
      (license license:gpl3))))

(define-public emacs-ivy-yasnippet
  (let ((commit "32580b4fd23ebf9ca7dde96704f7d53df6e253cd")
        (revision "2"))
    (package
      (name "emacs-ivy-yasnippet")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mkcms/ivy-yasnippet")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1wfg6mmd5gl1qgvayyzpxlkh9s7jgn20y8l1vh1zbj1czvv51xp8"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ivy emacs-yasnippet emacs-dash))
      (home-page "https://github.com/mkcms/ivy-yasnippet")
      (synopsis "Preview @code{yasnippets} with @code{ivy}")
      (description "This package allows you to select @code{yasnippet}
snippets using @code{ivy} completion.  When current selection changes in the
minibuffer, the snippet contents are temporarily expanded in the buffer.  To
use it, call @code{M-x ivy-yasnippet} (but make sure you have enabled
@code{yas-minor-mode} first).")
      (license license:gpl3+))))

;; The 0.1.6 release is incompatible with newer ivy versions, so we instead
;; pick a more recent snapshot of the repository, see
;; https://github.com/Yevgnen/ivy-rich/pull/80.
(define-public emacs-ivy-rich
  (let ((commit "600b8183ed0be8668dcc548cc2c8cb94b001363b")
        (revision "2"))
    (package
      (name "emacs-ivy-rich")
      (version (git-version "0.1.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Yevgnen/ivy-rich")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1dv6vr7fv32v5m04zdy02sdajpvrnpc4i3pbh2dwfv73ff8d8yxm"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ivy))
      (home-page "https://github.com/Yevgnen/ivy-rich")
      (synopsis "More friendly interface for @code{ivy}")
      (description
       "This package extends Ivy by showing more information in the minibuffer
for each candidate.  It adds columns showing buffer modes, file sizes,
docstrings, etc.  If @code{emacs-all-the-icons} is installed, it can show
icons as well.")
      (license license:gpl3+))))

(define-public emacs-avy
  (package
    (name "emacs-avy")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/abo-abo/avy")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "09qdni1s74i5pv8741szl5g4ynj8fxn0x65qmwa9rmfkbimnc0fs"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("make" "test")))
    (home-page "https://github.com/abo-abo/avy")
    (synopsis "Tree-based completion for Emacs")
    (description
     "This package provides a generic completion method based on building a
balanced decision tree with each candidate being a leaf.  To traverse the tree
from the root to a desired leaf, typically a sequence of @code{read-key} can
be used.

In order for @code{read-key} to make sense, the tree needs to be visualized
appropriately, with a character at each branch node.  So this completion
method works only for things that you can see on your screen, all at once,
such as the positions of characters, words, line beginnings, links, or
windows.")
    (license license:gpl3+)))

(define-public emacs-ace-window
  (package
    (name "emacs-ace-window")
    (version "0.10.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/abo-abo/ace-window")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0f3r40d5yxp2pm2j0nn86s29nqj8py0jxjbj50v4ci3hsd92d8jl"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-avy))
    (home-page "https://github.com/abo-abo/ace-window")
    (synopsis "Quickly switch windows in Emacs")
    (description
     "@code{ace-window} is meant to replace @code{other-window}.
In fact, when there are only two windows present, @code{other-window} is
called.  If there are more, each window will have its first character
highlighted.  Pressing that character will switch to that window.")
    (license license:gpl3+)))

(define-public emacs-windsize
  ;; There is no proper release.  The base version is extracted from the
  ;; "Version" keyword in the main file.
  (let ((revision "1")
        (commit "62c2846bbe95b0a73e996c75e4a644d05f57aaaa"))
    (package
      (name "emacs-windsize")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/grammati/windsize")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "13kfrmv3vmkfanxv9nym5v43hx5p7xkgqmx65zcxh4gcbaham1mi"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/grammati/windsize")
      (synopsis "Easy resizing of Emacs windows")
      (description
       "This package allows moving the borders of the active window
with the arrow keys.  It prefers to move the right or bottom border when
possible, and falls back to moving the left or top border otherwise.")
      (license license:gpl3+))))

(define-public emacs-window-purpose
  (package
    (name "emacs-window-purpose")
    (version "1.8.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bmag/emacs-purpose.git")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1cw513mh3gyl21qpmgwqjgpi8kwddmd4n69l4ax5a5pv3vvwrcx9"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-let-alist emacs-imenu-list))
    (arguments
     '(#:include
       '("^[^/]+.el$"
         "^[^/]+.el.in$"
         "^dir$"
         "^[^/]+.info$"
         "^[^/]+.texi$"
         "^[^/]+.texinfo$"
         "^doc/dir$"
         "^doc/[^/]+.info$"
         "^doc/[^/]+.texi$"
         "^doc/[^/]+.texinfo$"
         "^layouts$")
       #:exclude
       '("^.dir-locals.el$"
         "^test.el$"
         "^tests.el$"
         "^[^/]+-test.el$"
         "^[^/]+-tests.el$")))
    (home-page "https://github.com/bmag/emacs-purpose")
    (synopsis "Purpose-based window management for Emacs")
    (description "Purpose is a package that introduces the concept of a
\"purpose\" for windows and buffers, and then helps you maintain a robust
window layout easily.")
    (license license:gpl3+)))

(define-public emacs-iedit
  (package
    (name "emacs-iedit")
    (version "0.9.9.9.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/victorhge/iedit")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "02jdyrff88n69d4kadjaac38gwcv28lhiqqa93rlqzdvmgqsbwak"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/Iedit")
    (synopsis "Edit multiple regions in the same way simultaneously")
    (description
     "This package is an Emacs minor mode and allows you to edit one
occurrence of some text in a buffer (possibly narrowed) or region, and
simultaneously have other occurrences edited in the same way.

You can also use Iedit mode as a quick way to temporarily show only the buffer
lines that match the current text being edited.  This gives you the effect of
a temporary @code{keep-lines} or @code{occur}.")
    (license license:gpl3+)))

(define-public emacs-zoutline
  (package
    (name "emacs-zoutline")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/abo-abo/zoutline")
             (commit version)))
       (sha256
        (base32
         "1w0zh6vs7klgivq5r030a82mcfg1zwic4x3fimyiqyg5n8p67hyx"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (home-page "https://github.com/abo-abo/zoutline")
    (synopsis "Simple outline library")
    (description
     "This library provides helpers for outlines.  Outlines allow users to
navigate code in a tree-like fashion.")
    (license license:gpl3+)))

(define-public emacs-lispy
  ;; No release since May 2019 and tons of fixes have landed on master.
  ;; https://github.com/abo-abo/lispy/issues/513
  (let ((commit "df1b7e614fb0f73646755343e8892ddda310f427"))
    (package
      (name "emacs-lispy")
      (version (git-version "0.27.0" "3" commit))
      (home-page "https://github.com/abo-abo/lispy")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/abo-abo/lispy")
                      (commit commit)))
                (sha256
                 (base32
                  "02pmnn9cqslahnvllqzawp2j5icmb3wgkrk4qrfxjds68jg7pjj4"))
                (patches
                 (search-patches "emacs-lispy-fix-thread-last-test.patch"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ace-window emacs-hydra emacs-iedit emacs-swiper
             emacs-zoutline))
      (native-inputs
       (list which emacs-clojure-mode emacs-undercover))
      (arguments
       (list
        #:include #~(cons* "^lispy-clojure\\.clj$"
                           "^lispy-python\\.py$"
                           %default-include)
        #:phases
        ;; XXX: Some failing tests
        #~(modify-phases %standard-phases
            (add-before 'check 'make-test-writable
              (lambda _
                (make-file-writable "lispy-test.el")))
            (add-before 'check 'remove-failing-test
              (lambda _
                (emacs-batch-edit-file "lispy-test.el"
                  `(progn
                    (dolist (test '("lispy-eval-python-str" "lispy--clojure-dot-object"))
                            (goto-char (point-min))
                            (re-search-forward
                             (concat "ert-deftest " test))
                            (beginning-of-line)
                            (kill-sexp))
                    (basic-save-buffer))))))
        #:tests? #t
        ;; Set BEMACS to prevent the test suite from loading straight.el.
        #:test-command #~(list "make" "test" "BEMACS=emacs -batch")))
      (synopsis "Modal S-expression editing")
      (description
       "Due to the structure of Lisp syntax it's very rare for the programmer
to want to insert characters right before \"(\" or right after \")\".  Thus
unprefixed printable characters can be used to call commands when the point is
at one of these special locations.  Lispy provides unprefixed keybindings for
S-expression editing when point is at the beginning or end of an
S-expression.")
      (license license:gpl3+))))

(define-public emacs-lispyville
  (let ((commit "89316f01822b2135e52ca27fd308d207ef618052")
        (revision "3"))
    (package
      (name "emacs-lispyville")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/noctuid/lispyville")
      (source (origin
                (method git-fetch)
                (uri (git-reference (url home-page) (commit commit)))
                (sha256
                 (base32
                  "10k3hxxpx2v2k4dyad7j1bzmr1q7rzvv4y6c67pa9zcqyaw8m91v"))
                (file-name (git-file-name name version))))
      (propagated-inputs
       (list emacs-evil emacs-lispy))
      (build-system emacs-build-system)
      (synopsis "Minor mode for integrating Evil with lispy")
      (description
       "LispyVille's main purpose is to provide a Lisp editing environment
suited towards Evil users.  It can serve as a minimal layer on top of lispy
for better integration with Evil, but it does not require the use of lispy’s
keybinding style.  The provided commands allow for editing Lisp in normal
state and will work even without lispy being enabled.")
      (license license:gpl3+))))

(define-public emacs-function-args
  ;; The latest release is from August 21, 2017.
  (let ((commit "beba049751fed78666c87bd146a6f1cf149bb819")
        (revision "0"))
    (package
      (name "emacs-function-args")
      (version (git-version "0.6.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/abo-abo/function-args")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1vxrjy6k030hcbclblgcaaw7h6k17kl3n9zla08527525c0gma01"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-ivy))
      (home-page "https://github.com/abo-abo/function-args")
      (synopsis "C/C++ completion for GNU Emacs")
      (description
       "This package provides a way of showing an inline arguments hint for
the C/C++ function at point.")
      (license license:gpl3+))))

(define-public emacs-lpy
  ;; There is no proper release/tag.
  (let ((commit "fa95b11e1023704510cc7dd2897bf8bcc3027cbb")
        (revision "6"))
    (package
      (name "emacs-lpy")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/abo-abo/lpy")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1j92ll2afvcp891fxra3sawxg000cs3ra01wxksiil2dg5zpzzkn"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-function-args emacs-lispy emacs-zoutline))
      (home-page "https://github.com/abo-abo/lpy")
      (synopsis "Modal editing for Python")
      (description
       "This package provides a minor mode for Python that binds useful
commands to unprefixed keys, such as @code{j} or @code{e}, under certain
circumstances, and leaves the keys untouched outside of those situations,
allowing unprefixed keys to insert their respective characters as expected.")
      (license license:gpl3+))))

(define-public emacs-clojure-mode
  (package
    (name "emacs-clojure-mode")
    (version "5.15.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clojure-emacs/clojure-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "12m3yjhy4q0x3ri4xxb9raqg9lmw4hk4jgn436d9zvsk4fr3h1nd"))))
    (build-system emacs-build-system)
    (native-inputs
     (list emacs-buttercup emacs-dash emacs-paredit emacs-s))
    (arguments
     `(#:tests? #t
       #:test-command '("buttercup")))
    (home-page "https://github.com/clojure-emacs/clojure-mode")
    (synopsis "Major mode for Clojure code")
    (description
     "This Emacs package provides font-lock, indentation, navigation and basic
refactoring for the @uref{http://clojure.org, Clojure programming language}.
It is recommended to use @code{clojure-mode} with Paredit or Smartparens.")
    (license license:gpl3+)))

(define-public emacs-clj-refactor
  (package
    (name "emacs-clj-refactor")
    (version "3.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clojure-emacs/clj-refactor.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "15ya7hp5d2kwh1ig55d75vlghm1vsq99jh44i8q8v25vfmzjp7gp"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-yasnippet emacs-paredit emacs-multiple-cursors emacs-cider
           emacs-clojure-mode emacs-parseedn emacs-hydra emacs-inflections))
    (home-page "https://github.com/clojure-emacs/clj-refactor.el")
    (synopsis "Powerful refactoring functionality for Clojure projects")
    (description "This Emacs package complements the refactoring functionality
you'd find in clojure-mode and CIDER.")
    (license license:gpl3+)))

(define-public emacs-clojure-snippets
  ;; Use latest commit (2018) since latest tagged release is too old and is
  ;; missing important changes.
  (let ((version "1.0.1")
        (revision "0")
        (commit "6068dca90467a0f4ebc2cd39338a173d6f5ddc04"))
    (package
      (name "emacs-clojure-snippets")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mpenet/clojure-snippets")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0vvadcydpsz4b17dlm1jd4fbddzfqibh3mlzv3k4gvp67vv10cqy"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include (cons* "^.*\\/" %default-include)))
      (propagated-inputs
       (list emacs-yasnippet))
      (home-page "https://github.com/mpenet/clojure-snippets")
      (synopsis "Yasnippets for Clojure")
      (description
       "This package provides Yasnippets snippets for Clojure.")
      (license license:gpl3+))))

(define-public emacs-anakondo
  ;; This particular commit introduces bug fixes above latest release.
  (let ((version "0.2.1")
        (revision "0")
        (commit "c48518560815c49d8d78fb9069906d17e883385e"))
    (package
      (name "emacs-anakondo")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/didibus/anakondo")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1fzsqd150gpmrj8kz3zy9cd78x9vank7ra720mljhyf04z0h1mj6"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/didibus/anakondo")
      (synopsis "clj-kondo based Clojure[Script] editing facilities")
      (description
       "This package makes use of clj-kondo's analysis data to provide code
editing facilities related to Clojure, ClojureScript and cljc source.")
      (license license:expat))))

(define-public emacs-epl
  (package
    (name "emacs-epl")
    (version "0.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cask/epl")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0d3z5z90ln8ipk1yds1n1p8fj9yyh2kpspqjs7agl38indra3nb4"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/cask/epl")
    (synopsis "Emacs Package Library")
    (description
     "A package management library for Emacs, based on @code{package.el}.

The purpose of this library is to wrap all the quirks and hassle of
@code{package.el} into a sane API.")
    (license license:gpl3+)))

(define-public emacs-counsel-jq
  (package
    (name "emacs-counsel-jq")
    (version "1.1")
    (home-page "https://github.com/200ok-ch/counsel-jq")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit "aaf33fc2447096cd0d03b77395fe2a95c9fe1481")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10rz0qm8a4bl0m86kx19zq8lri047p4sxqyny08bgm9pbam0wvwn"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-swiper jq))
    (synopsis "Live preview @code{jq} queries using counsel")
    (description
     "This Emacs package provides the ability to live preview @code{jq}
queries using counsel.")
    (license license:gpl3+)))

(define-public emacs-counsel-notmuch
  ;; Upstream provides no release.  Extract version for main file.
  (let ((commit "a4a1562935e4180c42524c51609d1283e9be0688")
        (revision "0"))
    (package
      (name "emacs-counsel-notmuch")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fuxialexander/counsel-notmuch")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "01k1321d961kc2i660a5595bqk0d85f16snsxngsn5si6y83kqr7"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'locate-notmuch
             (lambda* (#:key inputs #:allow-other-keys)
               (make-file-writable "counsel-notmuch.el")
               (emacs-substitute-variables "counsel-notmuch.el"
                 ("counsel-notmuch-path"
                  (search-input-file inputs "/bin/notmuch"))))))))
      (inputs
       (list emacs-counsel notmuch emacs-s))
      (propagated-inputs
       (list emacs-notmuch))
      (home-page "https://github.com/fuxialexander/counsel-notmuch")
      (synopsis "Search emails in Notmuch asynchronously with Ivy")
      (description
       "This package can be used to search emails in Notmuch
asynchronously, with Counsel and Ivy.  Simply call
@code{counsel-notmuch} and input your Notmuch query.")
      (license license:gpl3+))))

(define-public emacs-counsel-projectile
  (package
    (name "emacs-counsel-projectile")
    (version "0.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ericdanan/counsel-projectile")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vp39r5njfzchkqv9g0w77whazp070anh9gmbkp3z4n3xxbik27f"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-counsel emacs-projectile))
    (home-page "https://github.com/ericdanan/counsel-projectile")
    (synopsis "Enhance Projectile with Ivy")
    (description
     "This package uses Ivy to provide additional actions for Projectile
commands and replacements for existing functions.")
    (license license:gpl3+)))

(define-public emacs-qml-mode
  (package
    (name "emacs-qml-mode")
    (version "0.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/coldnew/qml-mode")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1sncsvzjfgmhp4m8w5jd4y51k24n2jfpgvrkd64wlhhzbj3wb947"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/coldnew/qml-mode/")
    (synopsis "Qt Modeling Language (QML) mode for Emacs")
    (description "This package provides the @code{qml-mode} major Emacs mode
for editing source files written in the Qt Modeling Language (QML) user
interface markup language.  It provides syntax highlighting and basic
navigation commands.  @code{qml-mode} is derived from code{js-mode}, the Emacs
builtin JavaScript mode.")
    (license license:gpl2+)))

(define-public emacs-queue
  (package
    (name "emacs-queue")
    (version "0.2")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/queue-"
                                  version ".el"))
              (sha256
               (base32
                "0cx2848sqnnkkr4zisvqadzxngjyhmb36mh0q3if7q19yjjhmrkb"))))
    (build-system emacs-build-system)
    (home-page "https://www.dr-qubit.org/emacs_data-structures.html")
    (synopsis "Queue data structure for Emacs")
    (description
     "This Emacs library provides queue data structure.  These queues can be
used both as a first-in last-out (FILO) and as a first-in first-out (FIFO)
stack, i.e. elements can be added to the front or back of the queue, and can
be removed from the front.  This type of data structure is sometimes called an
\"output-restricted deque\".")
    (license license:gpl3+)))

(define-public emacs-quickrun
  (package
    (name "emacs-quickrun")
    (version "2.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/quickrun")
             (commit version)))
       (sha256
        (base32 "0a1n2v09h0n7d9p2izflqqang4ny0b46dlqvmxvkkik4bb6f4wcz"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacsorphanage/quickrun")
    (synopsis "Execute editing buffer and show its output quickly")
    (description
     "This package evaluates the content of a buffer, or region, and displays
the result.  Quickrun executes not only script languages (Perl, Ruby, Python
etc), but also compiling languages (C, C++, Go, Java etc) and markup
languages.")
    (license license:gpl3+)))

(define-public emacs-pkg-info
  (package
    (name "emacs-pkg-info")
    (version "0.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/lunaryorn/pkg-info.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0nk12dcppdyhav6m6yf7abpywyd7amxd4237zsfd32w4zxsx39k1"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-epl))
    (home-page "https://github.com/lunaryorn/pkg-info.el")
    (synopsis "Information about Emacs packages")
    (description
     "This library extracts information from the installed Emacs packages.")
    (license license:gpl3+)))

(define-public emacs-spinner
  (package
    (name "emacs-spinner")
    (version "1.7.4")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/spinner-"
                                  version ".tar"))
              (sha256
               (base32 "140kss25ijbwf8hzflbjz67ry76w2cyrh02axk95n6qcxv7jr7pv"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Malabarba/spinner.el")
    (synopsis "Emacs mode-line spinner for operations in progress")
    (description
     "This Emacs package adds spinners and progress-bars to the mode-line for
ongoing operations.")
    (license license:gpl3+)))

(define-public emacs-sparql-mode
  (package
    (name "emacs-sparql-mode")
    (version "4.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ljos/sparql-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hqp8r24wvzrkl630wbm0lynrcrnawv2yn2a3xgwqwwhwgva35rn"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-company))
    (home-page "https://github.com/ljos/sparql-mode")
    (synopsis "SPARQL mode for Emacs")
    (description
     "This package is a major mode for Emacs that provides syntax highlighting
for SPARQL.  It can also execute queries against a SPARQL HTTP endpoint, such
as Fuseki or DBPedia.")
    (license license:gpl3+)))

(define-public emacs-better-defaults
  (package
    (name "emacs-better-defaults")
    (version "0.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://git.sr.ht/~technomancy/better-defaults")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1rxznx2l0cdpiz8mad8s6q17m1fngpgb1cki7ch6yh18r3qz8ysr"))))
    (build-system emacs-build-system)
    (home-page "https://git.sr.ht/~technomancy/better-defaults")
    (synopsis "Better defaults for Emacs")
    (description
     "Better defaults attempts to address the most obvious deficiencies of the
Emacs default configuration in uncontroversial ways that nearly everyone can
agree upon.")
    (license license:gpl3+)))

(define-public emacs-undohist-el
  (package
    (name "emacs-undohist-el")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/m2ym/undohist-el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hmx2b20nrxg2lb8vplgrzdh8chgxwlbmjvbq5scddggd302sd56"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/m2ym/undohist-el")
    (synopsis "Save undo history between sessions")
    (description "This package allows persistent use of undo history for
individual file buffers.")
    (license license:gpl3+)))

(define-public emacs-eprime
  (let ((commit "17a481af26496be91c07139a9bfc05cfe722506f"))
    (package
      (name "emacs-eprime")
      (version (string-append "20140513-" (string-take commit 7)))
      (source (origin
                (method url-fetch)
                (uri (string-append "https://raw.githubusercontent.com"
                                    "/AndrewHynes/eprime-mode/"
                                    commit "/eprime-mode.el"))
                (file-name (string-append "eprime-" version ".el"))
                (sha256
                 (base32
                  "0v68lggkyq7kbcr9zyi573m2g2x251xy3jadlaw8kx02l8krwq8d"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/AndrewHynes/eprime-mode")
      (synopsis "E-prime checking mode for Emacs")
      (description "This package provides an E-prime checking mode for Emacs
that highlights non-conforming text.  The subset of the English language called
E-Prime forbids the use of the \"to be\" form to strengthen your writing.")
      (license license:gpl3+))))

(define-public emacs-julia-mode
    (package
      (name "emacs-julia-mode")
      (version "0.4")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/JuliaEditorSupport/julia-emacs")
               (commit version)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1w131jb9mhvyjxa0p93iwfhzidgbcs6b8i6jg79yisqb9wchik99"))))
      (build-system emacs-build-system)
      (arguments
       `(#:tests? #t
         #:test-command '("emacs" "--batch"
                          "-l" "julia-mode-tests.el"
                          "-f" "ert-run-tests-batch-and-exit")))
      (home-page "https://github.com/JuliaEditorSupport/julia-emacs")
      (synopsis "Major mode for Julia")
      (description "This Emacs package provides a mode for the Julia
programming language.")
      (license license:expat)))

(define-public emacs-julia-repl
  (package
    (name "emacs-julia-repl")
    (version "1.3.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/tpapp/julia-repl")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "11vpqqnxqj9nxh8kccj4y6h3f8lib6jxnsk6vxc2j2fqw6alnafm"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tpapp/julia-repl")
    (synopsis "Minor mode for interacting with a Julia REPL")
    (description "This package provides a minor mode for interacting with a
Julia REPL running inside Emacs.  The julia process is started in an ANSI
terminal (term), which allows text formatting and colors, and interaction with
the help system and the debugger.  It is recommended that you use this minor
mode with the package emacs-julia-mode.")
    (license license:expat)))

(define-public emacs-julia-snail
  (package
    (name "emacs-julia-snail")
    (version "1.1.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/gcv/julia-snail")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "04nh37izz04lxkvkxhsig8khbrrgdl4p6pkjsv5bxymnp84zwlw7"))))
    (build-system emacs-build-system)
    (arguments
     (list #:include #~(cons "^JuliaSnail\\.jl" %default-include)))
    (inputs
     (list emacs-dash emacs-s emacs-spinner emacs-xref))
    (propagated-inputs
     (list libvterm
           emacs-julia-mode             ;required by parser
           emacs-parsec                 ;required by parser
           emacs-vterm))
    (home-page "https://github.com/gcv/julia-snail")
    (synopsis "Development environment and REPL interaction package for Julia")
    (description "This package provides a development environment and REPL
interaction package for Julia in the spirit of Common Lisp’s SLIME and
Clojure’s CIDER.  It enables convenient and dynamic REPL-driven development.")
    (license license:gpl3)))

(define-public emacs-smex
  (package
    (name "emacs-smex")
    (version "3.0")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://raw.githubusercontent.com"
                                  "/nonsequitur/smex/" version "/smex.el"))
              (file-name (string-append "smex-" version ".el"))
              (sha256
               (base32
                "0ar310zx9k5y4i1vl2rawvi712xj9gx77160860jbs691p77cxqp"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/nonsequitur/smex/")
    (synopsis "M-x interface with Ido-style fuzzy matching")
    (description
     "Smex is a M-x enhancement for Emacs.  Built on top of Ido, it provides a
convenient interface to your recently and most frequently used commands.  And
to all the other commands, too.")
    (license license:gpl3+)))

(define-public emacs-js2-mode
  (package
    (name "emacs-js2-mode")
    (version "20220710")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mooz/js2-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0whvhmgpv6yxqiljd1l4a880i0dhp0z0jxqaad7jjvwij07vvla4"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("make" "test")))
    (home-page "https://github.com/mooz/js2-mode/")
    (synopsis "Improved JavaScript editing mode for Emacs")
    (description
     "Js2-mode provides a JavaScript major mode for Emacs that is more
advanced than the built-in javascript-mode.  Features include accurate syntax
highlighting using a recursive-descent parser, on-the-fly reporting of syntax
errors and strict-mode warnings, smart line-wrapping within comments and
strings, and code folding.")
    (license license:gpl3+)))

(define-public emacs-js-comint
  (package
    (name "emacs-js-comint")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://stable.melpa.org/packages/"
                           "js-comint-" version ".el"))
       (sha256
        (base32 "1qin0hclm3ly62nl5ddiim64bcd2k74b1yqsqqc61cf9k2q8k287"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/redguardtoo/js-comint")
    (synopsis "Interacting with a JavaScript interpreter")
    (description
     "This program is a comint mode for Emacs which allows you to run a
compatible JavaScript REPL, such as node, SpiderMonkey or Rhino.
It also defines a few functions for sending JavaScript input to this REPL from
an Emacs buffer.")
    (license license:gpl3+)))

(define-public emacs-nodejs-repl
  (package
    (name "emacs-nodejs-repl")
    (version "0.2.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/abicky/nodejs-repl.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0a5mmg3cmdi73giblp07ksl06xzl9nb2m3f96ny4r3rv0ar3v1bx"))))
    (build-system emacs-build-system)
    (inputs
     (list node))
    (native-inputs
     (list emacs-ert-expectations))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-shell
           ;; Setting the SHELL environment variable is required for the tests
           ;; to find sh.
           (lambda _
             (setenv "SHELL" (which "sh"))
             #t))
         (add-after 'unpack 'configure
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let ((node (assoc-ref inputs "node")))
               ;; Specify the absolute file names of the various
               ;; programs so that everything works out-of-the-box.
               (make-file-writable "nodejs-repl.el")
               (emacs-substitute-variables
                   "nodejs-repl.el"
                 ("nodejs-repl-command"
                  (string-append node "/bin/node")))))))
       #:tests? #t
       #:test-command '("emacs" "-Q" "--batch"
                        "-L" "."
                        "-l" "test/test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/abicky/nodejs-repl.el")
    (synopsis "Node.js REPL inside Emacs")
    (description
     "This program is derived from comint-mode and provides the following
features:

@itemize
@item TAB completion same as Node.js REPL
@item file name completion in string
@item incremental history search
@end itemize")
    (license license:gpl3+)))

(define-public emacs-typescript-mode
  (package
    (name "emacs-typescript-mode")
    (version "0.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ananthakumaran/typescript.el")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "186bpvqxx87kp3857mq0mzn1ddsvzmpijix810k6bdz8522x7zdw"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ananthakumaran/typescript.el")
    (synopsis "Emacs major mode for editing Typescript code")
    (description
     "This is based on Karl Landstrom's barebones @code{typescript-mode}.
This is much more robust and works with @code{cc-mode}'s comment
filling (mostly).  The modifications to the original @code{javascript.el} mode
mainly consisted in replacing \"javascript\" with \"typescript\"

The main features of this Typescript mode are syntactic highlighting (enabled
with @code{font-lock-mode} or @code{global-font-lock-mode}), automatic
indentation and filling of comments and C preprocessor fontification.")
    (license license:gpl3+)))

(define-public emacs-tide
  (package
    (name "emacs-tide")
    (version "4.5.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ananthakumaran/tide")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0zrapfxdarakp3kwp73c2ymjx51fsnfk6azi2y1wb2kgsdxl2yim"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-flycheck emacs-s emacs-typescript-mode))
    (home-page "https://github.com/ananthakumaran/tide")
    (synopsis "Typescript IDE for Emacs")
    (description
     "Tide is an Interactive Development Environment (IDE) for Emacs which
provides the following features:

@itemize
@item ElDoc
@item Auto complete
@item Flycheck
@item Jump to definition, Jump to type definition
@item Find occurrences
@item Rename symbol
@item Imenu
@item Compile On Save
@item Highlight Identifiers
@item Code Fixes
@item Code Refactor
@item Organize Imports
@end itemize")
    (license license:gpl3+)))

(define-public emacs-markdown-mode
  (package
    (name "emacs-markdown-mode")
    (version "2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jrblevin/markdown-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "02vw1zsbwa2hc3sxvbpvbldi5cf1xgd5b9l6fwg24d24j6b2af0j"))))
    (build-system emacs-build-system)
    (home-page "https://jblevins.org/projects/markdown-mode/")
    (synopsis "Emacs Major mode for Markdown files")
    (description
     "Markdown-mode is a major mode for editing Markdown-formatted text files
in Emacs.")
    (license license:gpl3+)))

(define-public emacs-evil-markdown
  (let ((commit "685d7fbb81bc02fa32779d2a127b99a0c8c7436b")
        (revision "2"))
    (package
      (name "emacs-evil-markdown")
      (version (git-version "0.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Somelauw/evil-markdown")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1z1sjn6dcqv8mmkh6nfcwhnql2z6xr9yx3hs77bfxj79pf3c466p"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-evil emacs-markdown-mode))
      (home-page "https://github.com/Somelauw/evil-markdown/")
      (synopsis "Evil keybindings for @code{markdown-mode}")
      (description
       "This package provides custom text objects and bindings for
@code{markdown-mode}.")
      (license license:gpl3+))))

(define-public emacs-edit-indirect
  (package
    (name "emacs-edit-indirect")
    (version "0.1.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Fanael/edit-indirect")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13v0fvzh3nv3bm4c3ld7pknw2g76cjkx81hsrmbrd1irlv4s4b00"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Fanael/edit-indirect")
    (synopsis "Edit regions in separate buffers")
    (description "This package allows you to edit regions in separate buffers,
like @code{org-edit-src-code} but for arbitrary regions.")
    (license license:bsd-2)))

(define-public emacs-projectile
  (package
    (name "emacs-projectile")
    (version "2.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bbatsov/projectile")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0ybd41iss8vd56qv6czpxqq7a99s4h7i3a2r4khy4rf5blj5zdqi"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #t
      #:test-command #~(list "buttercup" "-L" ".")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'fix-failing-test
            (lambda _
              (substitute* "test/projectile-test.el"
                (("user-emacs-directory") "\".\"")))))))
    (native-inputs
     (list emacs-buttercup))
    (propagated-inputs
     (list emacs-dash emacs-pkg-info))
    (home-page "https://github.com/bbatsov/projectile")
    (synopsis "Manage and navigate projects in Emacs easily")
    (description
     "This library provides easy project management and navigation.  The
concept of a project is pretty basic: just a folder containing special file.
Currently Git, Mercurial and Bazaar repositories are considered projects by
default.  If you want to mark a folder manually as a project just create an
empty @file{.projectile} file in it.")
    (license license:gpl3+)))

(define-public emacs-skeletor
  (let ((commit "47c5b761aee8452716c97a69949ac2f675affe13")
        (revision "1"))
    (package
      (name "emacs-skeletor")
      (version (git-version "1.6.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/chrisbarrett/skeletor.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "12bdgykfh4mwsqdazxjdvha62h3q3v33159ypy91f6x59y01fi0n"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-s emacs-f emacs-dash emacs-let-alist))
      (native-inputs
       (list emacs-ert-runner))
      (arguments
       `(#:include (cons "^project-skeletons\\/" %default-include)
         ;; XXX: one failing test involving initializing a git repo
         #:phases
         (modify-phases %standard-phases
           (add-before 'check 'make-test-writable
             (lambda _
               (make-file-writable "test/skeletor-test.el")
               #t))
           (add-before 'check 'remove-git-test
             (lambda _
               (emacs-batch-edit-file "test/skeletor-test.el"
                 `(progn
                   (progn
                    (goto-char (point-min))
                    (re-search-forward
                     "ert-deftest initialises-git-repo")
                    (beginning-of-line)
                    (kill-sexp))
                   (basic-save-buffer)))
               #t)))
         #:tests? #t
         #:test-command '("ert-runner")))
      (home-page "https://github.com/chrisbarrett/skeletor.el")
      (synopsis "Project skeletons for Emacs")
      (description "This package provides project templates and automates the
mundane parts of setting up a new project, such as version control, licenses,
and tooling.")
      (license license:gpl3+))))

(define-public emacs-elfeed
  (package
    (name "emacs-elfeed")
    (version "3.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/skeeto/elfeed")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ghdvfn4f9y69r59i1ga9b3ib1r8sbqg6q1v5rz3f9paagfavrd1"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("make" "test")))
    (home-page "https://github.com/skeeto/elfeed")
    (synopsis "Atom/RSS feed reader for Emacs")
    (description
     "Elfeed is an extensible web feed reader for Emacs, supporting both Atom
and RSS, with a user interface inspired by notmuch.")
    (license license:gpl3+)))

(define-public emacs-elfeed-org
  (let ((commit "77b6bbf222487809813de260447d31c4c59902c9"))
    (package
      (name "emacs-elfeed-org")
      (version (git-version "0.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/remyhonig/elfeed-org")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0a2ibka82xq1dhy2z7rd2y9zhcj8rna8357881yz49wf55ccgm53"))))
      (build-system emacs-build-system)
      (arguments
       `(#:tests? #t
         #:test-command '("ert-runner" "-L" "org-mode/lisp")
         #:phases
         (modify-phases %standard-phases
           (add-before 'check 'chmod
             (lambda _
               (chmod "test/fixture-mark-feed-ignore.org" #o644))))))
      (propagated-inputs
       (list emacs-elfeed emacs-org emacs-dash emacs-s))
      (native-inputs
       (list emacs-ert-runner emacs-xtest))
      (home-page "https://github.com/remyhonig/elfeed-org")
      (synopsis "Configure Elfeed with an Org-mode file")
      (description
       "@code{elfeed-org} lets you manage your Elfeed subscriptions
in Org-mode.  Maintaining tags for all RSS feeds is cumbersome using
the regular flat list, where there is no hierarchy and tag names are
duplicated a lot.  Org-mode makes the book keeping of tags and feeds
much easier.")
      (license license:gpl3+))))

(define-public emacs-elfeed-protocol
  (package
    (name "emacs-elfeed-protocol")
    (version "0.8.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fasheng/elfeed-protocol")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0k9rkghp9rg7aidmx7q0n4wpb9z5cwr7j8z167yzaqgf9s3y4jj2"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-elfeed))
    (home-page "https://github.com/fasheng/elfeed-protocol")
    (synopsis "Fever/NewsBlur/ownCloud/tt-RSS protocols for Elfeed")
    (description
     "Elfeed-protocol provides extra protocols to make self-hosting RSS
readers like Fever, NewsBlur, ownCloud News and Tiny TIny RSS work
with Elfeed.")
    (license license:gpl3+)))

(define-public emacs-elfeed-score
  (package
    (name "emacs-elfeed-score")
    (version "1.2.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sp1ff/elfeed-score")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0d1yh4wv81n5mnrzdi88z0vbs94m7j3q20r5fc1wk35r4hrl3xqw"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-elfeed))
    (home-page "https://github.com/sp1ff/elfeed-score")
    (synopsis "Gnus-style scoring for Elfeed")
    (description
     "Elfeed-score is an add-on for Elfeed, an RSS reader for Emacs.  It
brings Gnus-style scoring to your RSS feeds.  Elfeed, by default, displays
feed entries by date.  This package allows you to setup rules for assigning
numeric scores to entries, and sorting entries with higher scores ahead of
those with lower, regardless of date.  The idea is to prioritize content
important to you.")
    (license license:gpl3+)))

(define-public emacs-el-x
  (package
    (name "emacs-el-x")
    (version "0.3.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/sigma/el-x")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1i6j44ssxm1xdg0mf91nh1lnprwsaxsx8vsrf720nan7mfr283h5"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; Move the source files to the top level, which is included in
         ;; the EMACSLOADPATH.
         (add-after 'unpack 'move-source-files
           (lambda _
             (let ((el-files (find-files "./lisp" ".*\\.el$")))
               (for-each (lambda (f)
                           (rename-file f (basename f)))
                         el-files))
             #t)))))
    (home-page "https://github.com/sigma/el-x")
    (synopsis "Emacs Lisp extensions")
    (description "command@{emacs-el-x} defines the @code{dflet} macro to
provide the historic behavior of @code{flet}, as well as
@code{declare-function} stub for older Emacs.")
    (license license:gpl2+)))

(define-public emacs-epithet
  ;; No tags.
  (let ((commit "cc42338376c2c58da561214c554be8e8856f6a2b"))
    (package
      (name "emacs-epithet")
      (version "0.1")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/oantolin/epithet")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "06irgshgcgmm09nswrny8mam6l660ai71rgn0l3rmyp9li8n97j0"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/oantolin/epithet")
      (synopsis "Rename Emacs buffers with descriptive names")
      (description
       "This package provides a function---@code{epithet-rename-buffer}---to rename
the current buffer with a descriptive name. The name suggestion is governed by
the @code{epithet-suggesters} hook variable: each hook should return either a
name suggestion or @code{nil}, they are called in turn and the first non-nil
suggestion is taken.")
      (license license:gpl3+))))

(define-public emacs-eterm-256color
  (package
    (name "emacs-eterm-256color")
    (version "0.3.13")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/dieggsy/eterm-256color")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0ysxblc90kjcz84siprnyxwh94scflivqbxylzkvjm7hbx93rsh1"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-f emacs-xterm-color))
    (home-page "https://github.com/dieggsy/eterm-256color")
    (synopsis
     "Customizable 256 colors for Emacs @code{term} and @code{ansi-term}")
    (description "This package uses @code{emacs-xterm-color} to add
customizable 256 color support to @code{term} and @code{ansi-term}.")
    (license license:gpl3+)))

(define-public emacs-mocker
  (package
    (name "emacs-mocker")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sigma/mocker.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1dc514cqbfmg33sb3j90s5jmw6jnm3wzvs0zhw3maz13bp7w6z48"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("ert-runner")))
    (native-inputs
     (list emacs-ert-runner))
    (propagated-inputs
     (list emacs-el-x))
    (home-page "https://github.com/sigma/mocker.el")
    (synopsis "Mocking framework for Emacs Lisp")
    (description "Mocker.el is a framework for writing tests in Emacs Lisp.
It uses regular Lisp rather than a domain specific language (DSL), which
maximizes flexibility (at the expense of conciseness).")
    (license license:gpl2+)))

(define-public emacs-find-file-in-project
  (package
    (name "emacs-find-file-in-project")
    (version "6.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/technomancy/find-file-in-project")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0sq8fyq19jw1hm0m6hiqnvzzvx0c3xigfx7x6i40ib5hnfjlqs0a"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("ert-runner" "tests")))
    (native-inputs
     (list emacs-ert-runner))
    (home-page "https://github.com/technomancy/find-file-in-project")
    (synopsis "File/directory finder for Emacs")
    (description "@code{find-file-in-project} finds files or
directories quickly in the current project.  The project root is detected
automatically when Git, Subversion or Mercurial are used.  It also provides
functions to assist in reviewing changes on files.")
    (license license:gpl3+)))

(define-public emacs-pyvenv
  (package
    (name "emacs-pyvenv")
    (version "1.21")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jorgenschaefer/pyvenv")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "055sgk8zf4wb5nqsf3qasf5gg861zlb1831733f1qcrd2ij5gzxx"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; This phase incorrectly attempts to substitute "activate" and fails
         ;; doing so.
         (delete 'patch-el-files))
       #:tests? #t
       #:test-command '("ert-runner")))
    (native-inputs
     (list emacs-ert-runner emacs-mocker))
    (home-page "https://github.com/jorgenschaefer/pyvenv")
    (synopsis "Python virtual environment interface for Emacs")
    (description "pyvenv.el is a minor mode to support using Python virtual
environments (virtualenv) inside Emacs.")
    (license license:gpl3+)))

(define-public emacs-highlight-indent-guides
  (let ((version "0.8.5") ; from package metadata
        (revision "0")
        (commit "c2c9de4d01edfb89609c91d4d7f1d81312015a2c"))
    (package
      (name "emacs-highlight-indent-guides")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/DarthFennec/highlight-indent-guides")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "10chvqnmdmkx6i9sigqframr85ziyafiz44glwhvhjajfkv42ad2"))))
      (build-system emacs-build-system)
      (home-page
       "https://github.com/DarthFennec/highlight-indent-guides")
      (synopsis "Minor mode to highlight indentation")
      (description
       "This package provides a minor mode to highlight indentation levels via
font-lock.  Indent widths are dynamically discovered, which means this
correctly highlights in any mode, regardless of indent width, even in
languages with non-uniform indentation such as Haskell.  This mode works
properly around hard tabs and mixed indentation and behaves well in large
buffers.")
      (license license:expat))))

(define-public emacs-highlight-indentation
  ;; Last release version is from 2015.
  (let ((commit "d03803f2c06749c430443a3d24e039cbafc9c58f")
        (revision "1"))
    (package
      (name "emacs-highlight-indentation")
      (version (git-version "0.7.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/antonj/Highlight-Indentation-for-Emacs")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1jq0gf4kcx9hvrw40rnw5c2qynjpjw1vsjbi2i4lqjbsnfnxn4wz"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/antonj/Highlight-Indentation-for-Emacs/")
      (synopsis "Highlighting indentation for Emacs")
      (description "This package provides two minor modes to highlight
indentation guides in Emacs:

@enumerate
@item @code{highlight-indentation-mode}, which displays guidelines
  indentation (space indentation only).
@item @code{highlight-indentation-current-column-mode}, which displays
  guidelines for the current-point indentation (space indentation only).
@end enumerate")
      (license license:gpl2+))))

(define-public emacs-elpy
  ;; Using the latest commit fixes outstanding bugs such as the following:
  ;; https://github.com/jorgenschaefer/elpy/issues/1824
  ;; https://github.com/jorgenschaefer/elpy/pull/1951
  ;; https://github.com/jorgenschaefer/elpy/issues/1940.
  (let ((commit "1746e7009000b7635c0ea6f1559018143aa61642")
        (revision "1"))
    (package
      (name "emacs-elpy")
      (version (git-version "1.35.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jorgenschaefer/elpy")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "120xzzaa8jxls3lri6d53zq6gafnkc6d9mlg09an334kkmh8k2fc"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include (cons* "^elpy/[^/]+\\.py$" "^snippets\\/" %default-include)
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'disable-broken-tests
             ;; Some tests are known to have problems with Python 3.9; disable
             ;; them (see:
             ;; https://github.com/jorgenschaefer/elpy/issues/1856).
             ;; Aggressively remove the modules where failing tests were
             ;; discovered, as they are similar and fail in a nondeterministic
             ;; way.
             (lambda _
               (with-directory-excursion "test"
                 (for-each delete-file
                           (append (find-files "." "elpy-refactor")
                                   (find-files "." "elpy-multiedit")
                                   (find-files "." "elpy-pdb")
                                   (find-files "." "elpy-promise")))
                 ;; These test fail since upgrading Emacs from version 27 to
                 ;; 28.1 (see:
                 ;; https://github.com/jorgenschaefer/elpy/issues/1982).
                 (delete-file "elpy-project-find-git-root-test.el")
                 (substitute* "elpy-company-backend-test.el"
                   (("elpy-company-backend-should-add-shell-candidates.*" all)
                    (string-append all "  :expected-result :failed\n")))
                 (substitute* "elpy-eldoc-documentation-test.el"
                   (("elpy-eldoc-documentation-should-show-object-onelinedoc.*" all)
                    (string-append all "  :expected-result :failed\n")))
                 (substitute* "elpy-shell-send-file-test.el"
                   (("elpy-shell-send-file-should-accept-large-strings.*" all)
                    (string-append all "  :expected-result :failed\n")))
                 (substitute* "elpy-shell-echo-inputs-and-outputs-test.el"
                   (("elpy-shell-should-echo-outputs.*" all)
                    (string-append all "  :expected-result :failed\n"))))))
           ;; The default environment of the RPC uses Virtualenv to install
           ;; Python dependencies from PyPI.  We don't want/need this in Guix.
           (add-before 'check 'do-not-use-virtualenv
             (lambda _
               (setenv "ELPY_TEST_DONT_USE_VIRTUALENV" "1")
               (substitute* "elpy-rpc.el"
                 (("defcustom elpy-rpc-virtualenv-path 'default")
                  "defcustom elpy-rpc-virtualenv-path 'system"))))
           (add-before 'check 'build-doc
             (lambda _
               (with-directory-excursion "docs"
                 (invoke "make" "info" "man"))
               ;; Move .info file at the root so that it can installed by the
               ;; 'move-doc phase.
               (rename-file "docs/_build/texinfo/Elpy.info" "Elpy.info")))
           (add-after 'build-doc 'install-manpage
             (lambda* (#:key outputs #:allow-other-keys)
               (let* ((out  (assoc-ref outputs "out"))
                      (man1 (string-append out "/share/man/man1")))
                 (mkdir-p man1)
                 (copy-file "docs/_build/man/elpy.1"
                            (string-append man1 "/elpy.1"))))))
         #:tests? #t
         #:test-command '("ert-runner")))
      (propagated-inputs
       (list emacs-company
             emacs-find-file-in-project
             emacs-highlight-indentation
             emacs-yasnippet
             emacs-pyvenv
             emacs-s
             ;; The following are recommended Python dependencies that make
             ;; Elpy much more useful.  Installing these avoids Elpy prompting
             ;; to install them from PyPI using pip.
             python-autopep8
             python-black
             python-flake8
             python-jedi
             python-yapf))
      (native-inputs
       (list emacs-ert-runner
             emacs-f
             python-wrapper
             ;; For documentation.
             python-sphinx
             texinfo))
      (home-page "https://github.com/jorgenschaefer/elpy")
      (synopsis "Python development environment for Emacs")
      (description "Elpy brings powerful Python editing to Emacs.  It combines
and configures a number of other packages written in Emacs Lisp as well as
Python, together offering features such as navigation, documentation,
completion, interactive development and more.")
      (license license:gpl3+))))

(define-public emacs-rainbow-delimiters
  (package
    (name "emacs-rainbow-delimiters")
    (version "2.1.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/Fanael/rainbow-delimiters")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "179mzsd8nvlr0ym9zf9fgdngsgxj3kdgbjblynliirsyk05ssrwc"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Fanael/rainbow-delimiters")
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "-Q" "-batch"
                        "-l" "rainbow-delimiters-test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (synopsis "Highlight brackets according to their depth")
    (description
     "Rainbow-delimiters is a \"rainbow parentheses\"-like mode for Emacs which
highlights parentheses, brackets, and braces according to their depth.  Each
successive level is highlighted in a different color, making it easy to spot
matching delimiters, orient yourself in the code, and tell which statements
are at a given level.")
    (license license:gpl3+)))

(define-public emacs-rainbow-identifiers
  (package
    (name "emacs-rainbow-identifiers")
    (version "0.2.2")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://raw.githubusercontent.com/Fanael"
                                  "/rainbow-identifiers/" version
                                  "/rainbow-identifiers.el"))
              (file-name (string-append "rainbow-identifiers-" version ".el"))
              (sha256
               (base32
                "0325abxj47k0g1i8nqrq70w2wr6060ckhhf92krv1s072b3jzm31"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Fanael/rainbow-identifiers")
    (synopsis "Highlight identifiers in source code")
    (description
     "Rainbow identifiers mode is an Emacs minor mode providing highlighting of
identifiers based on their names.  Each identifier gets a color based on a hash
of its name.")
    (license license:bsd-2)))

(define-public emacs-rainbow-mode
  (package
    (name "emacs-rainbow-mode")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "rainbow-mode-" version ".tar"))
       (sha256
        (base32 "04v73cm1cap19vwc8lqsw0rmfr9v7r3swc4wgxnk9dnzxi9j2527"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/rainbow-mode.html")
    (synopsis "Colorize color names in buffers")
    (description
     "This minor mode sets background color to strings that match color
names, e.g., @samp{#0000ff} is displayed in white with a blue background.")
    (license license:gpl3+)))

(define-public emacs-ryo-modal
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file.
  (let ((commit "a10f564474cc8fa28a74b04e3b15375315223c44")
        (revision "0"))
    (package
      (name "emacs-ryo-modal")
      (version (git-version "0.45" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Kungsgeten/ryo-modal")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0ypm1rnyry6hb4znb8sgwfi0la6q46ihm8k99kisk0mkgz7im93d"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/Kungsgeten/ryo-modal")
      (synopsis "Emacs minor mode for defining modal editing environments")
      (description "RYO modal provides a convenient way of defining modal
keybindings in Emacs, and does not come with any predefined bindings.")
      (license license:expat))))

(define-public emacs-valign
  (package
    (name "emacs-valign")
    (version "3.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/casouri/valign")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "11ks6z532i7vxi6f9g32zhimvikhsqywa2bd5fnnj2ahfx3msa95"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/casouri/valign")
    (synopsis "Pixel-perfect visual alignment for Org and Markdown tables")
    (description
     "Valign provides visual alignment for Org mode, Markdown and Table.el
tables on GUI Emacs.  It can properly align tables containing variable-pitch
font, CJK characters and images.  Meanwhile, the text-based alignment
generated by Org mode (or Markdown mode) is left untouched.")
    (license license:gpl3+)))

(define-public emacs-visual-fill-column
  (package
    (name "emacs-visual-fill-column")
    (version "2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/joostkremers/visual-fill-column")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "168wiywaffhhn7j4nfbnq4lfxpxl0x17z9ckk3nwkpaz45d9a2q6"))))
    (build-system emacs-build-system)
    (home-page "https://codeberg.org/joostkremers/visual-fill-column")
    (synopsis "Fill-column for visual-line-mode")
    (description
     "@code{visual-fill-column-mode} is a small Emacs minor mode that mimics
the effect of @code{fill-column} in @code{visual-line-mode}.  Instead of
wrapping lines at the window edge, which is the standard behaviour of
@code{visual-line-mode}, it wraps lines at @code{fill-column}.  If
@code{fill-column} is too large for the window, the text is wrapped at the
window edge.")
    (license license:gpl3+)))

(define-public emacs-writeroom
  (package
    (name "emacs-writeroom")
    (version "3.11")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joostkremers/writeroom-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0y4jcja9kml1lq88r8b9myk39dgaggh7q7f3a43sj828hvzlccb7"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-visual-fill-column))
    (home-page "https://github.com/joostkremers/writeroom-mode")
    (synopsis "Distraction-free writing for Emacs")
    (description
     "This package defines a minor mode for distraction-free writing.  Some of
the default effects include entering fullscreen, deleting other windows of the
current frame, disabling the mode line, and adding margins to the buffer that
restrict the text width to 80 characters.")
    (license license:bsd-3)))

(define-public emacs-wucuo
  (package
    (name "emacs-wucuo")
    (version "0.2.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/redguardtoo/wucuo")
             (commit "89b99166768afb811c48a7db7c93c02d51a32b09")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "03a6jlbv9axrd9yr0xscq3ni7fipm20ppc51kxy0sn241rplv0pg"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("make" "test")
       #:phases (modify-phases %standard-phases
                  ;; Set HOME, otherwise tests fail on loading aspell dict.
                  (add-before 'check 'set-home
                    (lambda _ (setenv "HOME" (getcwd)))))))
    (native-inputs
     ;; For tests.
     (list aspell aspell-dict-en))
    (home-page "https://github.com/redguardtoo/wucuo")
    (synopsis "Fast spell checker for camel case code or plain text")
    (description
     "Wucuo provides a spell checker on top of either Aspell or Hunspell, and
relies on Flyspell internally.  It operates on the current region or buffer,
a file, or a complete directory.")
    (license license:gpl3+)))

(define-public emacs-ido-completing-read+
  (package
    (name "emacs-ido-completing-read+")
    (version "4.14")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://raw.githubusercontent.com"
                                  "/DarwinAwardWinner/ido-ubiquitous/v"
                                  version "/ido-completing-read+.el"))
              (file-name (string-append "ido-completing-read+-" version ".el"))
              (sha256
               (base32
                "1wn94nkfv6qyyj6clvms7m7ncqf09bgszv67may530y75kylivav"))))
    (build-system emacs-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'disable-native-comp
                 (lambda _
                   ;; Native compilation of this package may crash your system,
                   ;; see <https://bugs.gnu.org/57878>.
                   (for-each
                    (lambda (file)
                      (make-file-writable file)
                      (emacs-batch-disable-compilation file #:native? #t))
                    (find-files "." "\\.el$")))))))
    (propagated-inputs
     (list emacs-s))
    (home-page "https://github.com/DarwinAwardWinner/ido-ubiquitous")
    (synopsis "Replacement for completing-read using ido")
    (description
     "The ido-completing-read+ function is a wrapper for ido-completing-read.
Importantly, it detects edge cases that ordinary ido cannot handle and either
adjusts them so ido can handle them, or else simply falls back to the standard
Emacs completion function instead.")
    (license license:gpl3+)))

(define-public emacs-ido-ubiquitous
  (package
    (name "emacs-ido-ubiquitous")
    (version "4.13")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://raw.githubusercontent.com"
                                  "/DarwinAwardWinner/ido-ubiquitous/v"
                                  version "/ido-ubiquitous.el"))
              (file-name (string-append "ido-ubiquitous-" version ".el"))
              (sha256
               (base32
                "08iwvqknicqlffda7ixwgzw7q9g2g4j4nsxdw6544r85vaysi4cc"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-ido-completing-read+))
    (home-page "https://github.com/DarwinAwardWinner/ido-ubiquitous")
    (synopsis "Use ido (nearly) everywhere")
    (description
     "Ido-ubiquitous enables ido-style completion for almost every function
that uses the standard completion function completing-read.")
  (license license:gpl3+)))

(define-public emacs-yaml
  (package
    (name "emacs-yaml")
    (version "0.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/zkry/yaml.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0n0cf5y862ajyf2q0pnvbkhg57ggsri33x8y4q99s0a17ksk4qrm"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/zkry/yaml.el")
    (synopsis "YAML parser in Elisp")
    (description
     "@code{yaml.el} is a YAML parser written in Emacs Lisp without any
external dependencies.  It provides an interface similar to the Emacs JSON
parsing utility.")
    (license license:gpl3+)))

(define-public emacs-yaml-mode
  (package
    (name "emacs-yaml-mode")
    (version "0.0.15")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/yoshiki/yaml-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0gsa153yp8lmwrvcc3nzpw5lj037y7q2nm23k5k404r5as4k355l"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/yoshiki/yaml-mode")
    (synopsis "Major mode for editing YAML files")
    (description
     "Yaml mode is an Emacs major mode for editing files in the YAML data
serialization format.  As YAML and Python share the fact that indentation
determines structure, this mode provides indentation and indentation command
behavior very similar to that of Python mode.")
    (license license:gpl3+)))

(define-public emacs-gitlab-ci-mode
  (package
    (name "emacs-gitlab-ci-mode")
    (version "20190824.12.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://gitlab.com/joewreschnig/gitlab-ci-mode")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "16fb4r3vq8xkzl911v7gaky95w1agfxjlpaxpjmidwx48rbcar59"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-yaml-mode))
    (home-page "https://gitlab.com/joewreschnig/gitlab-ci-mode/")
    (synopsis "Emacs mode for editing GitLab CI files")
    (description
     "@code{gitlab-ci-mode} is an Emacs major mode for editing GitLab CI
files.  It provides syntax highlighting and completion for keywords and
special variables.  An interface to GitLab’s CI file linter is also provided
via @code{gitlab-ci-lint}.")
    (license license:gpl3+)))

(define-public emacs-gitlab-snip-helm
  (package
    (name "emacs-gitlab-snip-helm")
    (version "0.0.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://gitlab.com/sasanidas/gitlab-snip-helm.git")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1c5js19zyb1z61hapvbfcl5jhrjqij46cxldgqij6al0scw44dga"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-helm))
    (home-page "https://gitlab.com/sasanidas/gitlab-snip-helm/")
    (synopsis "GitLab snippet API interaction for Emacs")
    (description "This package provides GitLab snippet API interaction for
Emacs.")
    (license license:gpl3+)))

(define-public emacs-web-mode
  (package
    (name "emacs-web-mode")
    (version "17.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fxbois/web-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0sd2ysysn8x4iwz2fhnvh8knr3pdqgkvhkhsl948smmfl0dwj42f"))))
    (build-system emacs-build-system)
    (synopsis "Major mode for editing web templates")
    (description "Web mode is an Emacs major mode for editing web templates
aka HTML files embedding parts (CSS/JavaScript) and blocks (pre rendered by
client/server side engines).  Web mode is compatible with many template
engines: PHP, JSP, ASP, Django, Twig, Jinja, Mustache, ERB, FreeMarker,
Velocity, Cheetah, Smarty, CTemplate, Mustache, Blade, ErlyDTL, Go Template,
Dust.js, React/JSX, Angularjs, ejs, etc.")
    (home-page "https://web-mode.org/")
    (license license:gpl3+)))

(define-public emacs-templatel
  (package
    (name "emacs-templatel")
    (version "0.1.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clarete/templatel")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "03n7amd2mfr4jmc4s1ar5ckm86knr7qarxxlkdhbnw3svy5kbc57"))))
    (build-system emacs-build-system)
    (home-page "https://clarete.li/templatel")
    (synopsis "Jinja inspired template language for Emacs Lisp")
    (description
     "templatel is the modern templating language.  It provides variable
substitution and control flow through a clean and powerful language inspired
by Python's Jinja.")
    (license license:gpl3+)))

(define-public emacs-wgrep
  (package
    (name "emacs-wgrep")
    (version "2.3.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/mhayashi1120/Emacs-wgrep")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "00cwqzb94jlq4mwgv8z7r3mn0a6mhq95z6j189kacq9g4473zh8d"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/mhayashi1120/Emacs-wgrep")
    (synopsis "Edit a grep buffer and apply those changes to the files")
    (description
     "Emacs wgrep allows you to edit a grep buffer and apply those changes
to the file buffer.  Several backends are supported beside the classic grep:
ack, ag, helm and pt.")
    (license license:gpl3+)))

(define-public emacs-helm
  (package
    (name "emacs-helm")
    (version "3.9.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-helm/helm")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1i253ani2bl665biha0f071pncr2jh7x5yxp8rg2013sdf4nr74c"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-async emacs-popup))
    (home-page "https://emacs-helm.github.io/helm/")
    (synopsis
     "Incremental completion and selection narrowing framework for Emacs")
    (description
     "Helm is an incremental completion and selection narrowing framework for
Emacs.  It will help steer you in the right direction when you're looking for
stuff in Emacs (like buffers, files, etc).")
    (license license:gpl3+)))

(define-public emacs-helm-org
  (let ((commit "8457e1e46227bf87726e05c42cec5a4b51c2ef7b")
        (revision "3"))
    (package
      (name "emacs-helm-org")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-helm/helm-org")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0kcjhwwi492n9m2w894hvdavfvhj45zygy7bwvx103wvpay5h6h6"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-helm))
      (home-page "https://github.com/emacs-helm/helm-org")
      (synopsis "Helm interface to the Silver Searcher")
      (description
       "This package provides a frontend for grepping tools like ag and ack,
as well as features for editing search results.")
      (license license:gpl3+))))

(define-public emacs-helm-swoop
  (package
    (name "emacs-helm-swoop")
    (version "3.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/helm-swoop")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1qjay0fvryxa8n1ws6r1by512p2fylb2nj7ycm1497fcalb0d706"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm))
    (home-page "https://github.com/emacsorphanage/helm-swoop")
    (synopsis "Filter and jump to lines in an Emacs buffer using Helm")
    (description
     "This package builds on the Helm interface to provide several commands
for search-based navigation of buffers.")
    (license license:gpl2+)))

(define-public emacs-helm-ag
  (package
    (name "emacs-helm-ag")
    (version "0.64")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-helm-ag")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ml9yp3qaiwn7iixyxvsj3fxn7gw913qxisr47df57q4ka912law"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm))
    (home-page "https://github.com/syohex/emacs-helm-ag")
    (synopsis "Helm interface to the Silver Searcher")
    (description
     "This package provides a frontend for grepping tools like ag and ack,
as well as features for editing search results.")
    (license license:gpl3+)))

(define-public emacs-helm-projectile
  (package
    (name "emacs-helm-projectile")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bbatsov/helm-projectile")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "05gpg90gg03yalmv9fw1y9k21i2l617iipvs0p9n80aln8nrzs8g"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm emacs-projectile))
    (home-page "https://github.com/bbatsov/helm-projectile")
    (synopsis "Helm integration for Projectile")
    (description
     "This Emacs library provides a Helm interface for Projectile.")
    (license license:gpl3+)))

(define-public emacs-taskrunner
  (let ((commit "3afd4a546d42339543d3d4e51b175fc3e82b3358")
        (revision "1"))
    (package
      (name "emacs-taskrunner")
      (version (git-version "0.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-taskrunner/emacs-taskrunner")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1lkdvmjn3alhqxq2i64sdr977sbw3g0b2670d9bwyzi67qh0jxrv"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-async emacs-projectile))
      (home-page "https://github.com/emacs-taskrunner/emacs-taskrunner")
      (synopsis "Retrieve tasks from various build systems and task-runners")
      (description "This package parses Makefiles and build-system files for
multiple project types.")
      (license license:gpl3+))))

(define-public emacs-ivy-taskrunner
  (let ((commit "75d8d67cfe3c29663fe0f5508a887adf40ed5162")
        (revision "1"))
    (package
      (name "emacs-ivy-taskrunner")
      (version (git-version "0.9" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-taskrunner/ivy-taskrunner")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1wf4s4k0ap21f7g5w6128an8nsvbja7f5n889vcml5b6gjz058db"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ivy emacs-taskrunner emacs-projectile))
      (home-page "https://github.com/emacs-taskrunner/ivy-taskrunner")
      (synopsis "Retrieve build-system tasks using Ivy")
      (description "This package provides an Ivy interface for selecting
Makefile targets.")
      (license license:gpl3+))))

(define-public emacs-helm-taskrunner
  (let ((commit "1910dac19cbc7bd4fd08b0faf9affd455339fbea")
        (revision "1"))
    (package
      (name "emacs-helm-taskrunner")
      (version (git-version "0.9" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-taskrunner/helm-taskrunner")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "182lmr858fx6rdhp1fy7kv8dvrhzcnxzwfck1q22s6xs8x85d5q7"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-helm emacs-taskrunner emacs-projectile))
      (home-page "https://github.com/emacs-taskrunner/helm-taskrunner")
      (synopsis "Retrieve build-system tasks using Helm")
      (description "This package provides a Helm interface for selecting
Makefile targets.")
      (license license:gpl3+))))

(define-public emacs-helm-make
  (let ((commit "feae8df22bc4b20705ea08ac9adfc2b43bb348d0")
        (revision "1"))
    (package
      (name "emacs-helm-make")
      (version (string-append "0.1.0-" revision "." (string-take commit 7)))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/abo-abo/helm-make")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1y2v77mmd1bfkkz51cnk1l0dg3lvvxc39wlamnm7wjns66dbvlam"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-helm emacs-projectile))
      (home-page "https://github.com/abo-abo/helm-make")
      (synopsis "Select a Makefile target with helm")
      (description "@code{helm-make} or @code{helm-make-projectile} will give
you a @code{helm} selection of directory Makefile's targets.  Selecting a
target will call @code{compile} on it.")
      (license license:gpl3+))))

(define-public emacs-cider
  (package
    (name "emacs-cider")
    (version "1.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clojure-emacs/cider")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ih902n8p3pl1apprprkyrlnrp2dxli86y5k09zahy9mglfz2z5n"))))
    (build-system emacs-build-system)
    (arguments
     '(#:exclude                        ;don't exclude 'cider-test.el'
       '("^\\.dir-locals\\.el$" "^test/")
       #:phases
       ;; XXX: file "test/cider-tests.el" contains a bogus "/bin/command"
       ;; string, and `patch-el-files' phase chokes on it (even though the
       ;; file is excluded from installation).  Remove the phase altogether
       ;; since there is no "/bin/executable" to replace in the code base
       ;; anyway.
       (modify-phases %standard-phases
         (delete 'patch-el-files))))
    (propagated-inputs
     (list emacs-clojure-mode
           emacs-parseedn
           emacs-pkg-info
           emacs-queue
           emacs-sesman
           emacs-spinner))
    (home-page "https://cider.mx/")
    (synopsis "Clojure development environment for Emacs")
    (description
     "CIDER (Clojure Interactive Development Environment that Rocks) aims to
provide an interactive development experience similar to the one you'd get
when programming in Emacs Lisp, Common Lisp (with SLIME or Sly), Scheme (with
Geiser) and Smalltalk.

CIDER is the successor to the now deprecated combination of using SLIME +
swank-clojure for Clojure development.

There are plenty of differences between CIDER and SLIME, but the core ideas
are pretty much the same (and SLIME served as the principle inspiration for
CIDER).")
    (license license:gpl3+)))

(define-public emacs-sly
  ;; Update together with sbcl-slynk.
  (let ((commit "4513c382f07a2a2cedb3c046231b69eae2f5e6f0")
        (revision "6"))
    ;; Versions are not always tagged.  Besides, latest master contains
    ;; important fixes.
    (package
      (name "emacs-sly")
      (version (git-version "1.0.43" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/joaotavora/sly")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "10bzxhi5d7h18hqclxqy2z857d0sfbsnyxvrhmfkdi0h75zz7m4n"))))
      (build-system emacs-build-system)
      (native-inputs
       (list texinfo))
      (arguments
       `(#:include (cons* "^contrib\\/" "^lib\\/" "^slynk\\/" %default-include)
         #:phases
         ;; The package provides autoloads.
         (modify-phases %standard-phases
           (delete 'make-autoloads)
           (add-before 'install 'install-doc
             (lambda* (#:key outputs #:allow-other-keys)
               (let* ((out (assoc-ref outputs "out"))
                      (info-dir (string-append out "/share/info"))
                      (doc-dir (string-append out "/share/doc/"
                                              ,name "-" ,version))
                      (doc-files '( ;; "doc/sly-refcard.pdf" ; See sly-refcard.pdf below.
                                   "README.md" "NEWS.md" "PROBLEMS.md"
                                   "CONTRIBUTING.md")))
                 (with-directory-excursion "doc"
                   (substitute* "Makefile"
                     (("infodir=/usr/local/info")
                      (string-append "infodir=" info-dir))
                     ;; Don't rebuild contributors.texi since we are not in
                     ;; the git repo.
                     (("contributors.texi: Makefile texinfo-tabulate.awk")
                      "contributors.texi:"))
                   (invoke "make" "html/index.html")
                   (invoke "make" "sly.info")
                   ;; TODO: We need minimal texlive with "preprint" package
                   ;; (for fullpage.sty).  (invoke "make" "sly-refcard.pdf")
                   (install-file "sly.info" info-dir)
                   (copy-recursively "html" (string-append doc-dir "/html")))
                 (for-each (lambda (f)
                             (install-file f doc-dir)
                             (delete-file f))
                           doc-files)
                 (delete-file-recursively "doc")
                 #t))))))
      (home-page "https://github.com/joaotavora/sly")
      (synopsis "Sylvester the Cat's Common Lisp IDE")
      (description
       "SLY is Sylvester the Cat's Common Lisp IDE.  SLY is a fork of SLIME, and
contains the following improvements over it:

@enumerate
@item A full-featured REPL based on Emacs's @code{comint.el}.  Everything
can be copied to the REPL;
@item Stickers, or live code annotations that record values as code traverses them.
@item Flex-style completion out-of-the-box, using Emacs's completion API.
Company, Helm, and other supported natively, no plugin required;
@item An interactive Trace Dialog;
@item Multiple inspectors and multiple REPLs, with independent history.
@item Regexp-capable @code{M-x sly-apropos}.
@item Cleanly ASDF-loaded by default, including contribs, enabled out-of-the-box;
@item \"Presentations\" replaced by interactive backreferences, which
highlight the object and remain stable throughout the REPL session;
@end enumerate

SLY tracks SLIME's bugfixes and all its familiar features (debugger, inspector,
xref, etc.) are still available, but with better integration.")
      (license license:gpl3+))))

(define-public emacs-sly-quicklisp
  (let ((commit "01ebe3976a244309f2e277c09206831135a0b66c")
        (revision "1"))
    (package
      (name "emacs-sly-quicklisp")
      (version (git-version "0.0.0" revision commit))
      (home-page "https://github.com/joaotavora/sly-quicklisp")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1vfqmvayf35g6y3ljsm3rlzv5jm50qikhh4lv2zkkswj6gkkb1cv"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-sly))
      (arguments
       `(#:include (cons* "\\.lisp$" "\\.asd$" %default-include)
         #:phases
         ;; The package provides autoloads.
         (modify-phases %standard-phases
           (delete 'make-autoloads)
           (delete 'enable-autoloads-compilation))))
      (synopsis "Quicklisp support for SLY")
      (description
       "@command{sly-quicklisp} is an external contrib for SLY that provides a
sly-quickload command that prompts the user for a package to install.")
      (license license:gpl3+))))

(define-public emacs-sly-asdf
  (package
    (name "emacs-sly-asdf")
    (version "0.2.0")
    (home-page "https://github.com/mmgeorge/sly-asdf")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0gncp8xv33s4wx594bgd35vr1455bcggv1bg28qv75mhv41nzw97"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-sly emacs-popup))
    (arguments
     '(#:include (cons* "\\.lisp$" "\\.asd$" %default-include)))
    (synopsis "ASDF contrib for SLY")
    (description
     "@command{sly-asdf} is an external contrib for SLY that provides
additional support for working with ASDF projects.")
    (license license:gpl3+)))

(define-public emacs-sly-named-readtables
  (let ((commit "a5a42674ccffa97ccd5e4e9742beaf3ea719931f")
        (revision "1"))
    (package
      (name "emacs-sly-named-readtables")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/joaotavora/sly-named-readtables")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "16asd119rzqrlclps2q6yrkis8jy5an5xgzzqvb7jdyq39zxg54q"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-sly))
      (arguments
       '(#:include (cons* "\\.lisp$" "\\.asd$" %default-include)
         #:phases (modify-phases %standard-phases
                    ;; Byte compilation of the autoload file fails.
                    (delete 'enable-autoloads-compilation))))
      (synopsis "Named-readtables support for SLY")
      (description
       "@command{sly-named-readtables} is an external contrib for SLY that
enables different readtables to be active in different parts of the same
file.")
      (license license:gpl3+))))

(define-public emacs-sly-macrostep
  (let ((commit "5113e4e926cd752b1d0bcc1508b3ebad5def5fad")
        (revision "2"))
    (package
      (name "emacs-sly-macrostep")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/joaotavora/sly-macrostep")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1nxf28gn4f3n0wnv7nb5sgl36fz175y470zs9hig4kq8cp0yal0r"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-sly emacs-macrostep))
      (arguments
       '(#:include (cons* "\\.lisp$" "\\.asd$" %default-include)
         #:phases
         ;; The package provides autoloads.
         (modify-phases %standard-phases
           (delete 'make-autoloads)
           (delete 'enable-autoloads-compilation))))
      (synopsis "Expand Common Lisp macros inside source files with SLY")
      (description
       "@command{sly-macrostep} is a SLY contrib for expanding CL macros right
inside the source file.")
      (license license:gpl3+))))

(define-public emacs-sly-stepper
  (let ((commit "da84e3bba8466c2290c2dc7c27d7f4c48c27b39e"))
    (package
      (name "emacs-sly-stepper")
      (version (git-version "0.0.0" "2" commit))
      (home-page "https://github.com/joaotavora/sly-stepper")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "07p0k797fagn1qha191p6g2b55hsqqkcj59mh0ms9id0ildydil0"))
         (modules '((guix build utils)))
         (snippet
          '(begin
             (map delete-file (find-files "." ".*-autoloads\\.elc?$"))
             #t))))
      (build-system emacs-build-system)
      (inputs
       (list cl-agnostic-lizard))
      (propagated-inputs
       (list emacs-sly))
      (arguments
       `(#:include (cons* "\\.lisp$" "\\.asd$" %default-include)
         #:phases
         (modify-phases %standard-phases
           (add-after 'expand-load-path 'expand-sly-contrib
             (lambda* (#:key inputs #:allow-other-keys)
               (let* ((sly (assoc-ref inputs "emacs-sly"))
                      (contrib (find-files sly "^contrib$" #:directories? #t)))
                 (setenv "EMACSLOADPATH"
                         (string-append (string-join contrib ":")
                                        ":"
                                        (getenv "EMACSLOADPATH")))
                 #t)))
           (add-after 'install 'find-agnostic-lizard
             (lambda* (#:key inputs outputs #:allow-other-keys)
               (let* ((out (assoc-ref outputs "out"))
                      (file (string-append (elpa-directory out)
                                           "/slynk-stepper.lisp"))
                      (asd (string-append
                            (assoc-ref inputs "cl-agnostic-lizard")
                            "/share/common-lisp/systems/agnostic-lizard.asd")))
                 ;; agnostic-lizard is found at runtime.
                 (substitute* file
                   (("\\(require :asdf\\)")
                    (string-append
                     "(require :asdf)\n"
                     "     (funcall (read-from-string \"asdf:load-asd\")\n"
                     "              \"" asd "\")\n")))))))))
      (synopsis "Portable Common Lisp stepper interface for Emacs")
      (description
       "This package features a new, portable, visual stepping facility for
Common Lisp, realized as an extension to SLY.")
      (license license:gpl3+))))

(define-public emacs-sly-package-inferred
  (let ((commit "800e71e2be631422277e2ec77e6d6f6ea20e95ef")
        (revision "1"))
    (package
      (name "emacs-sly-package-inferred")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/40ants/sly-package-inferred")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1216idyp034nkqddhw4p53jkhhdxa6xnjjmsvijpf4rxqnfqvapg"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-sly))
      (arguments
       '(#:include (cons* "\\.lisp$" "\\.asd$" %default-include)
         #:phases
         ;; The package provides autoloads.
         (modify-phases %standard-phases
           (delete 'make-autoloads))))
      (synopsis "Improved package inferred systems support for SLY")
      (description
       "@command{sly-package-inferred} is an external contrib for SLY that
replaces its completion with a function which is better suited for systems
using package inferred style.")
      (license license:gpl3+))))

(define-public emacs-lua-mode
  (package
    (name "emacs-lua-mode")
    (version "20210802")
    (home-page "https://github.com/immerrr/lua-mode/")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0r3svhggdml2n256k3b0zmbjnw51p46gan6dg07bhavpfrqs5196"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("buttercup" "-l" "lua-mode.el")))
    (native-inputs
     (list emacs-buttercup-1.25 lua))
    (synopsis "Major mode for lua")
    (description
     "This Emacs package provides a mode for @uref{https://www.lua.org/,
Lua programming language}.")
    (license license:gpl2+)))

(define-public emacs-ebuild-mode
  (package
    (name "emacs-ebuild-mode")
    (version "1.60")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://dev.gentoo.org/~ulm/emacs/"
             "ebuild-mode-" version ".tar.xz"))
       (file-name (string-append name "-" version ".tar.xz"))
       (sha256
        (base32 "1n7knzssvz0yyhnn6m37lz8d9v2840skcbm0ipqjpqyzawnr3psw"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'install-doc
            (lambda _
              (invoke "make" "ebuild-mode.info")
              (install-file "ebuild-mode.info"
                            (string-append #$output "/share/info")))))))
    (native-inputs
     (list texinfo))
    (home-page "https://devmanual.gentoo.org")
    (synopsis "Major modes for Gentoo package files")
    (description
     "This Emacs package provides modes for ebuild, eclass, eblit, GLEP42
news items, openrc and runscripts.")
    (license license:gpl2+)))

(define-public emacs-ebuku
  ;; Upstream has no tagged release.
  (let ((revision "1")
        (commit "0c6cf404a49bd68800221446df186fffa0139325"))
    (package
      (name "emacs-ebuku")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/flexibeast/ebuku")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "09fkzmcvzdbdjaa167wiybj0kir7y12pcq2varjywshvq2l7niz4"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/flexibeast/ebuku")
      (synopsis "Emacs interface to the buku Web bookmark manager")
      (description
       "Ebuku provides a basic interface to the @code{buku} Web bookmark
manager.")
      (license license:gpl3+))))

(define-public emacs-evil
  ;; Commit message claims this is 1.15.0, but there's no tag for it, so we
  ;; use full git-version instead
  (let ((commit "008a6cdb12f15e748979a7d1c2f26c34c84dedbf")
        (revision "0"))
    (package
      (name "emacs-evil")
      (version (git-version "1.15.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-evil/evil")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1hxhw1rsm0wbrhz85gfabncanijpxd47g5yrdnl3bbm499z1gsvg"))))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-before 'check 'fix-test-helpers
             (lambda _
               (substitute* "evil-test-helpers.el"
                 (("\\(undo-tree-mode 1\\)") ""))
               #t))
           (add-before 'install 'make-info
             (lambda _
               (with-directory-excursion "doc/build/texinfo"
                   (invoke "makeinfo" "--no-split"
                           "-o" "evil.info" "evil.texi")))))))
      (build-system emacs-build-system)
      (native-inputs (list texinfo))
      (home-page "https://github.com/emacs-evil/evil")
      (synopsis "Extensible Vi layer for Emacs")
      (description
       "Evil is an extensible vi layer for Emacs.  It emulates the
main features of Vim, and provides facilities for writing custom
extensions.")
      (license license:gpl3+))))

(define-public emacs-evil-collection
  (package
    (name "emacs-evil-collection")
    (version "0.0.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-evil/evil-collection")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "159i3qvjnp7jiffwpr517nnxcy3w3g40302vyzxvz6mb6qay6f2c"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-evil emacs-annalist))
    (arguments
     `(#:include (cons* "^modes\\/" %default-include)))
    (home-page "https://github.com/emacs-evil/evil-collection")
    (synopsis "Collection of Evil bindings for many major and minor modes")
    (description "This is a collection of Evil bindings for the parts of
Emacs that Evil does not cover properly by default, such as @code{help-mode},
@code{M-x calendar}, Eshell and more.")
    (license license:gpl3+)))

(define-public emacs-evil-goggles
  (let ((commit "08a22058fd6a167f9f1b684c649008caef571459")
        (version "0.0.1")
        (revision "0"))
    (package
      (name "emacs-evil-goggles")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/edkolev/evil-goggles")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1p3vjrij63v9nrcyj3b5jsqzv9y7dgv9i1inx1q7x3s90vndavac"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-evil))
      (home-page "https://github.com/edkolev/evil-goggles")
      (synopsis "Displays visual hints when editing with evil")
      (description "Creates a visual pulse to indicate the region that is
being deleted, changed, yanked, or pasted when using evil commands")
      (license license:gpl3+))))

(define-public emacs-goggles
  (package
    (name "emacs-goggles")
    (version "0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/minad/goggles")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "15bqjmwfdqp2np6fln6xjyw59c5iddvzsyga0lvb8raa753cdh2k"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/minad/goggles")
    (synopsis "Pulse modified region")
    (description "Goggles highlights the modified region using pulse.
Currently the commands undo, yank, kill and delete are supported.")
    (license license:gpl3+)))

(define-public emacs-goto-chg
  (package
    (name "emacs-goto-chg")
    (version "1.7.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-evil/goto-chg")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0rgdzhan4n5bd78wvivacqkp0g7jvnwzgh0571p2m4yra09a36mv"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacs-evil/goto-chg")
    (synopsis "Go to the last change in the Emacs buffer")
    (description
     "This package provides @code{M-x goto-last-change} command that goes to
the point of the most recent edit in the current Emacs buffer.  When repeated,
go to the second most recent edit, etc.  Negative argument, @kbd{C-u -}, is
used for reverse direction.")
    (license license:gpl2+)))

(define-public emacs-evil-owl
  (let ((commit "24c5f43df375194386344e69bc720ea3986c9510")
        (revision "3"))
    (package
      (name "emacs-evil-owl")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mamapanda/evil-owl")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0bqzch14whlmrcasakah3psrzswvkzd7mmi8hx5s64kfp29wbdhi"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-evil))
      (arguments
       `(#:tests? #t
         #:test-command '("make" "test")))
      (home-page "https://github.com/mamapanda/evil-owl")
      (synopsis "Preview candidates when using Evil registers and marks")
      (description
       "This package supplements Evil's register- and mark-based commands with
a popup window for previewing candidates.")
      (license license:gpl3+))))

(define-public emacs-evil-paredit
  (let ((commit "e058fbdcf9dbf7ad6cc77f0172d7517ef233d55f"))
    (package
      (name "emacs-evil-paredit")
      (version "0.0.2")                 ; says 0.0.2 in evil-paredit.el
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/roman/evil-paredit")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0b08y4spapl4g2292j3l4cr84gjlvm3rpma3gqld4yb1sxd7v78p"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-evil emacs-paredit))
      (home-page "https://github.com/roman/evil-paredit")
      (synopsis "Evil extension to integrate nicely with Paredit")
      (description
       "This package helps you to not screw up your Paredit setup when using
Evil mode.  Whenever you try to use a modifier command like @kbd{d}, @kbd{c},
@kbd{y} to modify the Paredit buffer, it will stop you to do so in the case
you break the parity of parenthesis.")
      (license license:expat))))

(define-public emacs-evil-args
  (let ((commit "758ad5ae54ad34202064fec192c88151c08cb387")
        (revision "1"))
    (package
      (name "emacs-evil-args")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/wcsmith/evil-args")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0k35glgsirc3cph8v5hhjrqfh4ndwh8a28qbr03y3jl8s453xcj7"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (home-page "https://github.com/wcsmith/evil-args")
      (synopsis "Motions and text objects for delimited arguments in Evil")
      (description
       "This package provides motions and text objects for delimited
arguments, such as arguments separated by commas and semicolons.")
      (license license:expat))))

(define-public emacs-evil-escape
  (package
    (name "emacs-evil-escape")
    (version "3.16")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/emacsorphanage/evil-escape")
         (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1z30v59igndqzxg9gcx4bsbf5jkh11wp936il8azkrz3qdryaj4a"))))
    (propagated-inputs
     (list emacs-evil))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacsorphanage/evil-escape")
    (synopsis "Escape from insert state and everything else in Emacs")
    (description
     "Evil escape provides a customizable key sequence to escape from insert
state and everything else in Emacs.")
    (license license:gpl3+)))

(define-public emacs-evil-exchange
  (let ((commit "47691537815150715e64e6f6ec79be7746c96120")
        (version "0.41")
        (revision "1"))
    (package
      (name "emacs-evil-exchange")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Dewdrops/evil-exchange")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0bjpn4yqig17ddym6wqq5fm1b294q74hzcbj9a6gs97fqiwf88xa"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (native-inputs (list emacs-ert-runner))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-before 'check 'fix-makefile
             (lambda _
               (substitute* "Makefile"
                 (("cask exec ") ""))
               #t)))
         #:tests? #t
         #:test-command '("make" "test")))
      (home-page "https://github.com/Dewdrops/evil-exchange")
      (synopsis "Exchange text easily within Evil")
      (description
       "This package, a port of @code{vim-exchange}, provides an Evil operator
for exchanging text.")
      (license license:gpl3+))))

(define-public emacs-evil-replace-with-register
  (let ((commit "91cc7bf21a94703c441cc9212214075b226b7f67")
        (version "0.1")
        (revision "1"))
    (package
      (name "emacs-evil-replace-with-register")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Dewdrops/evil-ReplaceWithRegister")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "14rpn76qrf287s3y2agmddcxi27r226i53ixjvd694ss039g0r11"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (home-page "https://github.com/Dewdrops/evil-ReplaceWithRegister")
      (synopsis "Quickly replace text with the contents of a register")
      (description
       "This package provides an Evil operator for replacing text with the
contents of a register.")
      (license license:gpl3+))))

(define-public emacs-evil-indent-plus
  (let ((commit "0c7501e6efed661242c3a20e0a6c79a6455c2c40")
        (version "1.0.0")
        (revision "1"))
    (package
      (name "emacs-evil-indent-plus")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/TheBB/evil-indent-plus")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1g6r1ydscwjvmhh1zg4q3nap4avk8lb9msdqrh7dff6pla0r2qs6"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (home-page "https://github.com/TheBB/evil-indent-plus")
      (synopsis "Text objects based on indentation")
      (description
       "This package adds new text objects for @code{evil-mode} based on
blocks having the same or higher indentation, including or excluding
surrounding lines.")
      (license license:gpl2+))))

(define-public emacs-evil-text-object-python
  (let ((commit "9a064fe6475429145cbcc3b270fcc963b67adb15")
        (version "1.0.1")
        (revision "1"))
    (package
      (name "emacs-evil-text-object-python")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/wbolster/evil-text-object-python")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "074zpm6mmr1wfl6d5xdf8jk1fs4ccpbzf4ahhkwga9g71xiplszv"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (home-page "https://github.com/wbolster/evil-text-object-python")
      (synopsis "Text objects for Python")
      (description
       "This package provides @code{evil-mode} text objects for Python.")
      (license license:gpl3+))))

(define-public emacs-evil-lion
  (let ((commit "6b03593f5dd6e7c9ca02207f9a73615cf94c93ab")
        (revision "1"))
    (package
      (name "emacs-evil-lion")
      (version (git-version "0.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/edkolev/evil-lion")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1a162hynp0jcsn50c1w5a02mrw9w3q05c7lkqzqd25px3d0p772q"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (arguments
       `(#:tests? #t
         #:test-command '("make" "test")))
      (home-page "https://github.com/edkolev/evil-lion")
      (synopsis "Align operator for @code{evil-mode}")
      (description
       "This package, a port of @code{vim-lion}, provides an operator for
aligning text objects based on separators.")
      (license license:gpl3+))))

(define-public emacs-evil-expat
  (let ((commit "f4fcd0aa3edc359adb5c986b5dd9188d220d84e2")
        (revision "1"))
    (package
      (name "emacs-evil-expat")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/edkolev/evil-expat")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0872ix682hkdz0k8pn6sb54rqkx00rz5fxpd5j2snx406yagpaxz"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (arguments
       `(#:tests? #t
         #:test-command '("make" "test")))
      (home-page "https://github.com/edkolev/evil-expat")
      (synopsis "Extra @code{ex} commands for @code{evil-mode}")
      (description
       "This package provides additional commands for the @code{ex} command
line, including functions for version control with Git and for copying and
pasting into and from @code{tmux} paste buffers.")
      (license license:gpl3+))))

(define-public emacs-evil-nerd-commenter
  (package
    (name "emacs-evil-nerd-commenter")
    (version "3.5.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/redguardtoo/evil-nerd-commenter")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0xrbmz9mx4aclqgjyjaq7vj9xf4291rw4nxaz2nvqblv8yylqbr0"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-evil))
    (home-page "https://github.com/redguardtoo/evil-nerd-commenter")
    (synopsis "Comment and uncomment lines efficiently")
    (description
     "This package provides text objects and operators for comments within
@code{evil-mode}.")
    (license license:gpl3+)))

(define-public emacs-evil-visual-replace
  (package
    (name "emacs-evil-visual-replace")
    (version "0.0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/troyp/evil-visual-replace")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1gfyrq7xfzmzh3x8k5f08n027dlbwi0pkkxf9c39fkxp4jngibsz"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-evil))
    (home-page "https://github.com/troyp/evil-visual-replace")
    (synopsis "Replacement commands for @code{evil-mode} visual blocks")
    (description
     "This package provides versions of @code{query-replace} and
@code{replace-regexp} that work for @code{evil-mode} visual blocks.")
    (license license:gpl2+)))

(define-public emacs-evil-visualstar
  (let ((commit "06c053d8f7381f91c53311b1234872ca96ced752")
        (version "0.2.0")
        (revision "1"))
    (package
      (name "emacs-evil-visualstar")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/bling/evil-visualstar")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0mkbzw12fav945icibc2293m5haxqr3hzkyli2cf4ssk6yvn0x4c"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (home-page "https://github.com/bling/evil-visualstar")
      (synopsis "Instantly search using the visual selection")
      (description
       "This package provides @code{evil-mode} functions for using selected text
to search.")
      (license license:gpl3+))))

(define-public emacs-monky
  (package
    (name "emacs-monky")
    (version "0.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ananthakumaran/monky")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1fgn7al4zwz2k5wb5dy3byqg9lsrjk9fra341mxh5ma2pfwxjgps"))))
    (build-system emacs-build-system)
    (home-page "https://ananthakumaran.in/monky/index.html")
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "--batch"
                        "-l" "test/monky-unit-test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (synopsis "Interactive interface for the Mercurial version control system")
    (description
     "Monky provides an Emacs interface for Mercurial (Hg).  Using Monky, you
can selectively commit files, view the diffs, and other things.")
    (license license:gpl3+)))

(define-public emacs-monroe
  (package
    (name "emacs-monroe")
    (version "0.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sanel/monroe")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "101lfrykdbv37spkbw7zihhx26bc1lhjyxbanrcp9880bxj04jiy"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/sanel/monroe")
    (synopsis "Clojure nREPL client for Emacs")
    (description
     "Monroe is a nREPL client for Emacs, focused on simplicity and easy
distribution, primarily targeting Clojure users")
    (license license:gpl3+)))

(define-public emacs-orgalist
  (package
    (name "emacs-orgalist")
    (version "1.13")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "orgalist-" version ".el"))
       (sha256
        (base32 "1wkxc5kcy1g4lx6pd78pa8znncjyl9zyhsvz7wpp56qmhq4hlav3"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/orgalist.html")
    (synopsis "Manage Org-like lists in non-Org buffers")
    (description "Orgalist writes and manages Org mode's plain lists in
non-Org buffers.  More specifically, it supports the syntax of Org mode for
numbered, unnumbered, description items, checkboxes, and counter cookies.

The library also implements radio lists, i.e., lists written in Org syntax
later translated into the host format, e.g., LaTeX or HTML.")
    (license license:gpl3+)))

(define-public emacs-writegood-mode
  (package
    (name "emacs-writegood-mode")
    (version "2.2.0")
    (home-page "https://github.com/bnbeckwith/writegood-mode")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit (string-append "v" version))))
              (sha256
               (base32
                "1a3gmaaa344kigr209b6wnjiw9ikkmw1j5jda04h3g8f9817njyv"))
              (file-name (string-append name "-checkout"))))
    (build-system emacs-build-system)
    (synopsis "Polish up poor writing on the fly")
    (description
     "This minor mode tries to find and highlight problems with your writing
in English as you type.  It primarily detects \"weasel words\" and abuse of
passive voice.")
    (license license:gpl3+)))

(define-public emacs-neotree
  (package
    (name "emacs-neotree")
    (version "0.5.2")
    (home-page "https://github.com/jaypei/emacs-neotree")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                     (url home-page)
                     (commit version)))
              (sha256
               (base32
                "0hx72fq10772bbyqrj7mhhp02k26cccjxdadiqm1ykainhfmn1x0"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (synopsis "Folder tree view for Emacs")
    (description "This Emacs package provides a folder tree view.")
    (license license:gpl3+)))

(define-public emacs-org
  (package
    (name "emacs-org")
    (version "9.5.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.savannah.gnu.org/git/emacs/org-mode.git")
             (commit (string-append "release_" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0bswysz5laiya9pm689v4rpxjlfqg21azyh1jal9jq80iwjwi2p8"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("make" "test-dirty")
       #:phases
       (modify-phases %standard-phases
         (add-before 'check 'make
           (lambda _
             (invoke "make" (string-append "ORGVERSION=" ,version))))
         (replace 'install
           (lambda* (#:key outputs #:allow-other-keys)
             (substitute* "local.mk"
               (("^prefix.*")
                (string-append "prefix = " (assoc-ref outputs "out")))
               (("^lispdir.*")
                (string-append "lispdir = "
                               (elpa-directory (assoc-ref outputs "out")))))
             ;; The dependent targets for install perform cleanup that
             ;; partially undoes our make phase
             (substitute* "lisp/Makefile"
               (("^install:.*") "install:\n"))
             (invoke "make" "install")))
         (add-after 'unpack 'fix-tests
           (lambda* (#:key inputs #:allow-other-keys)
             ;; These files are modified during testing
             (with-directory-excursion "testing/examples"
               (for-each make-file-writable
                         '("babel.org"
                           "ob-awk-test.org"
                           "ob-sed-test.org"
                           "ob-shell-test.org"))
               ;; Specify where sh is
               (substitute* "babel.org"
                 (("/bin/sh" sh)
                  (string-append (assoc-ref inputs "bash") sh)))))))))
    (native-inputs
     (list texinfo))
    (home-page "https://orgmode.org/")
    (synopsis "Outline-based notes management and organizer")
    (description "Org is an Emacs mode for keeping notes, maintaining TODO
lists, and project planning with a fast and effective lightweight markup
language.  It also is an authoring system with unique support for literate
programming and reproducible research.")
    (license license:gpl3+)))

(define-public emacs-org-contrib
  (package
    (name "emacs-org-contrib")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~bzg/org-contrib")
             (commit (string-append "release_" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "06b1rpywj596nnnap6pj6fnmcq8fcc4i30zv7qsvs3ryxciw01fb"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'enter-source-directory
           (lambda _
             (chdir "lisp"))))))
    (native-inputs
     (list emacs-cider))
    (propagated-inputs
     (list emacs-org))
    (home-page "https://git.sr.ht/~bzg/org-contrib")
    (synopsis "Unmaintained add-ons for Org mode")
    (description
     "This package contains add-ons to Org.  Be warned that these libraries
receive little if no maintenance and there is no guaranty that they are
compatible with the Org stable version.")
    (license license:gpl3+)))

(define-public emacs-org-contacts
  ;; XXX: Upstream does not tag version bumps. Commit below matches latest
  ;; version bump.
  (let ((commit "217ba04c9d638067a6ccb0829cf1885f54c1d568"))
    (package
      (name "emacs-org-contacts")
      (version "1.1")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://repo.or.cz/org-contacts")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0f0vjdvx0hffj2xvyrya8yfl77djmzmpxdxsx58ym4lmdvwyb6x3"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-org))
      (home-page "https://repo.or.cz/org-contacts")
      (synopsis "Contacts management system for Org mode")
      (description "Manage your contacts from Org mode.  You can auto
complete email addresses, export contacts to a vCard file, put birthdays
in your Org Agenda, and more.")
      (license license:gpl3+))))

(define-public emacs-org-vcard
  (package
    (name "emacs-org-vcard")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/flexibeast/org-vcard")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14l3xqahqmnfl3sskqcr33xpcsic8dm9cr9wmbv5la3xv14n10k7"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/flexibeast/org-vcard")
    (synopsis "Org mode support for vCard export and import")
    (description
     "This package exports and imports vCard files from within GNU Emacs' Org
mode.")
    (license license:gpl3+)))

(define-public emacs-org-pretty-table
  ;; There is no release yet.
  (let ((commit "1331c600b83d95b28730b1bfcb48369ac1cf12ef")
        (revision "0"))
    (package
      (name "emacs-org-pretty-table")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Fuco1/org-pretty-table")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0yvqxh66y400n2n5ykmb1zrzd80bakffpwn6nmf37728x4cj8krh"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/Fuco1/org-pretty-table")
      (synopsis "Make tables in Org mode and OrgTbl mode prettier")
      (description
       "This package displays tables in Org mode and OrgTbl mode using Unicode
characters.")
      (license license:gpl3+))))

(define-public emacs-ob-sclang
  (let ((commit "cd3f3c847d8149cd4ce4a775942dac88ba92c772")
        (revision "1"))
    (package
      (name "emacs-ob-sclang")
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://repo.or.cz/ob-sclang")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0dr8va2v0262plqxd63yxymqiffkql9klci7wsp5i7xgpka8925q"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-org emacs-scel))
      (home-page "https://repo.or.cz/ob-sclang")
      (synopsis "Org Babel support for SuperCollider")
      (description "This package adds support for evaluating @code{sclang} Org
mode source blocks.")
      (license license:gpl3+))))

(define-public emacs-org-edna
  (package
    (name "emacs-org-edna")
    (version "1.1.2")
    (source (origin
              (method bzr-fetch)
              (uri (bzr-reference
                    (url "bzr://bzr.savannah.nongnu.org/org-edna-el")
                    (revision version)))
              (file-name (string-append name "-" version "-checkout"))
              (sha256
               (base32
                "01dblddgx0yid5hrgl4swbr4grhv057kfbdy122wihzqpsrgq86n"))))
    (build-system emacs-build-system)
    (home-page "https://savannah.nongnu.org/projects/org-edna-el/")
    (synopsis "Manage Org task dependencies")
    (description "This package provides an extensible means of specifying
conditions which must be fulfilled before a task can be completed and actions
to take once it is.  Org Edna runs when either the BLOCKER or TRIGGER
properties are set on a heading, and when it is changing from a TODO state to
a DONE state.")
    (license license:gpl3+)))

(define-public emacs-toodoo
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file, and commit below matches version bump.
  (package
    (name "emacs-toodoo")
    (version "0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ChanderG/toodoo.el")
             (commit "149a563863c2f728c5f903475dbce50547c51000")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "00q7aym0kl03j9m66pivgy0snxcjjg402049b2wdy18kgyypfvx8"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-evil))
    (home-page "https://github.com/ChanderG/toodoo.el")
    (synopsis "Magit-like interface for a Todo workflow built on top of Org")
    (description "This package provides a minor mode for fast and easy management of Todos
using Org mode and transients.")
    (license license:asl2.0)))

(define-public emacs-flx
  (package
    (name "emacs-flx")
    (version "0.6.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/lewang/flx")
              (commit (string-append "v" version))))
       (sha256
        (base32
         "0sjybrcnb2sl33swy3q664vqrparajcl0m455gciiih2j87hwadc"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (home-page "https://github.com/lewang/flx")
    (synopsis "Fuzzy matching for Emacs")
    (description
     "Flx provides fuzzy matching for emacs a la sublime text.
The sorting algorithm is a balance between word beginnings (abbreviation)
and contiguous matches (substring).  The longer the substring match,
the higher it scores. This maps well to how we think about matching.
Flx has support for ido (interactively do things) through flx-ido.")
    (license license:gpl3+)))

(define-public emacs-cyberpunk-theme
  (package
    (name "emacs-cyberpunk-theme")
    (version "1.22")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/n3mo/cyberpunk-theme.el/")
              (commit version)))
       (sha256
        (base32
         "06nff38pcy5rgz13svkajsg0jjk73qy4a8m7p9f76yxcywxlgxlc"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (home-page "https://github.com/n3mo/cyberpunk-theme.el")
    (synopsis "Cyberpunk theme for Emacs built-in color theme support")
    (description
     "Cyberpunk color theme for the Emacs 24+ built-in color theme support
known loosely as deftheme.  Many mode-specific customizations are included.")
    (license license:gpl3+)))

(define-public emacs-dart-mode
  (package
    (name "emacs-dart-mode")
    (version "1.0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bradyt/dart-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vql8m4nj0brmv58b6lkbhykik8n6j4i7d3nylcls78y7ihc2cz8"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-flycheck emacs-s))
    (home-page "https://github.com/bradyt/dart-mode")
    (synopsis "Emacs mode for the Dart programming language")
    (description
     "Dart mode is an Emacs major mode for editing Dart files.  It provides
basic syntax highlighting and indentation.")
    (license license:gpl3+)))

(define-public emacs-danneskjold-theme
  (let* ((commit "e4d1f2c76245fe9d0d07133a841e789d139df28d")
         (revision "2"))
    (package
      (name "emacs-danneskjold-theme")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rails-to-cosmos/danneskjold-theme")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1ii3cgf4hlclwaraisxksv98mmhajx517i60p1cgd7vapznn2b6v"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'delete-screenshots
             (lambda _
               (delete-file-recursively "screenshots"))))))
      (home-page "https://github.com/rails-to-cosmos/danneskjold-theme")
      (synopsis "High-contrast Emacs theme")
      (description
       "@code{danneskjold-theme} is a high-contrast theme for Emacs.")
      (license license:gpl3+))))

(define-public emacs-dream-theme
  (let* ((commit "107a11d74365046f28a1802a2bdb5e69e4a7488b")
         (revision "1"))
    (package
      (name "emacs-dream-theme")
      (version (string-append "0.0.0-" revision "." (string-take commit 7)))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/djcb/dream-theme")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0za18nfkq4xqm35k6006vsixcbmvmxqgma4iw5sw37h8vmcsdylk"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/djcb/dream-theme")
      (synopsis "High-contrast Emacs theme")
      (description
       "@code{dream-theme} is a dark, clean theme for Emacs.  It is inspired
by zenburn, sinburn and similar themes, but slowly diverging from them.")
      (license license:gpl3+))))

(define-public emacs-dracula-theme
  (package
    (name "emacs-dracula-theme")
    (version "1.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dracula/emacs")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "15y2djc5jljlvls1x9kp50m1kp0dcksmyixafsyimj66xpq9ngh0"))))
    (build-system emacs-build-system)
    (home-page "https://draculatheme.com/")
    (synopsis "Dark theme for Emacs")
    (description
     "Dracula is a dark color theme for many editors, shells and more.  This
package provides the Emacs theme.")
    (license license:expat)))

(define-public emacs-auto-complete
  (package
    (name "emacs-auto-complete")
    (version "1.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/auto-complete/auto-complete")
              (commit (string-append "v" version))))
       (sha256
        (base32
         "04i9b11iksg6acn885wl3qgi5xpsm3yszlqmd2x21yhprndlz7gb"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-popup))
    (home-page "https://github.com/auto-complete/auto-complete")
    (synopsis "Intelligent auto-completion extension for Emacs")
    (description
     "Auto-Complete is an intelligent auto-completion extension for Emacs.
It extends the standard Emacs completion interface and provides an environment
that allows users to concentrate more on their own work.  Its features are:
a visual interface, reduce overhead of completion by using statistic method,
extensibility.")
    (license license:gpl3+)))

(define-public emacs-autocrypt
  (let ((commit "5b55f8d37545e9c441788627c17e350d7edf4055")
        (revision "0"))
    (package
      (name "emacs-autocrypt")
      (version (git-version "0.4.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://git.sr.ht/~pkal/autocrypt")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0b06xnjkgwjpxl96mdi674pmvdaiwncifi1a30wxhl1dwr7kr084"))))
      (build-system emacs-build-system)
      (home-page "https://git.sr.ht/~pkal/autocrypt")
      (synopsis "Autocrypt implementation for Emacs")
      (description "@code{emacs-autocrypt} is an implementation of
Autocrypt (@url{https://autocrypt.org/}) for various Emacs MUAs.  Autocrypt is
a cryptographic protocol for email clients aiming to simplify key exchange and
encryption.

Run @code{M-x autocrypt-create-account} to initialize an autocrypt key, and
add @code{autocrypt-mode} to your MUA's hooks (@code{gnus-mode-hook},
@code{message-mode-hook}, ...) to activate its usage.")
      (license license:cc0))))

(define-public emacs-nginx-mode
  (package
    (name "emacs-nginx-mode")
    (version "1.1.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ajc/nginx-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "17dh5pr3gh6adrbqx588gimxbb2fr7iv2qrxv6r48w2727l344xs"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ajc/nginx-mode")
    (synopsis "Emacs major mode for editing nginx config files")
    (description "This package provides an Emacs major mode for
editing nginx config files.")
    (license license:gpl2+)))

(define-public emacs-stream
  (package
    (name "emacs-stream")
    (version "2.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "stream-" version ".tar"))
       (sha256
        (base32 "00c3n4gyxzv7vczqms0d62kl8zsmjfyxa92mwxn2snyx857a9jfw"))))
    (build-system emacs-build-system)
    (home-page "http://elpa.gnu.org/packages/stream.html")
    (synopsis "Implementation of streams for Emacs")
    (description "This library provides an implementation of streams for Emacs.
Streams are implemented as delayed evaluation of cons cells.")
    (license license:gpl3+)))

(define-public emacs-cl-print
  (let ((commit "1a70c553dfb04352afb5b8696fe0cef8acc8f991")
        (revision "1"))
    (package
      (name "emacs-cl-print")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsmirror/cl-print")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "164zbnsi5mssvcpy0158fm7fw5cmd1r5nkpn29fmd2b2scy3gm79"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/emacsmirror/cl-print")
      (synopsis "CL-style generic printing")
      (description "This package provides a generic function,
@code{cl-print-object}, to which the programmer can add any method they
please.")
      (license license:gpl3+))))

(define-public emacs-el-search
  (let ((commit "07bed84dd8ae9e4c6c648834224b1d33fdbd51e0")
        (revision "2"))
    (package
      (name "emacs-el-search")
      (version (git-version "1.12.6.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsmirror/el-search")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "10w1ldgijdhfsrazp0y3bm76jv5wvdn94k1yp0pmc2m1896b58ak"))))
      (build-system emacs-build-system)
      (inputs
       (list emacs-stream emacs-cl-print))
      (home-page "https://github.com/emacsmirror/el-search")
      (synopsis "Expression based interactive search for emacs-lisp-mode")
      (description "This package provides expression based interactive search
procedures for emacs-lisp-mode.")
      (license license:gpl3+))))

(define-public emacs-ht
  (package
    (name "emacs-ht")
    (version "2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Wilfred/ht.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0can9v336lgnq0q2ha3js0565jzp3dlwwqxhcbx5swk5kp148f07"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-dash))
    (native-inputs
     (list emacs-ert-runner))
    (arguments
     `(#:tests? #t
       #:test-command '("ert-runner")))
    (home-page "https://github.com/Wilfred/ht.el")
    (synopsis "Hash table library for Emacs")
    (description
     "This package simplifies the use of hash tables in elisp.  It also
provides functions to convert hash tables from and to alists and plists.")
    (license license:gpl3+)))

(define-public emacs-log4e
  (package
    (name "emacs-log4e")
    (version "0.3.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/aki2o/log4e")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0dbnks76v05allzkhx9zmyqpn6sk5376n8k2rbpnaw6gmz1ib2fv"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'remove-tests
           ;; Guile builder complains about null characters in some
           ;; strings of test files.  Remove "test" directory (it is not
           ;; needed anyway).
           (lambda _
             (delete-file-recursively "test"))))))
    (home-page "https://github.com/aki2o/log4e")
    (synopsis "Logging framework for elisp")
    (description
     "This package provides a logging framework for elisp.  It allows
you to deal with multiple log levels.")
    (license license:gpl3+)))

(define-public emacs-denote
  (package
    (name "emacs-denote")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~protesilaos/denote")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "05ckjx1a2cydp46pd8y36safhj95pqi6lm4vs0vr6q3a858bxf8b"))))
    (build-system emacs-build-system)
    (native-inputs (list texinfo))
    (home-page "https://protesilaos.com/emacs/denote/")
    (synopsis "Simple notes for Emacs")
    (description
"Denote is a simple note-taking tool for Emacs.  It is based on the idea that
notes should follow a predictable and descriptive file-naming scheme.  The
file name must offer a clear indication of what the note is about, without
reference to any other metadata.  Denote basically streamlines the creation of
such files while providing facilities to link between them.")
    (license license:gpl3+)))

(define-public emacs-logos
  ;; XXX: Upstream did not tag latest release.  Use the commit matching
  ;; version bump.
  (let ((commit "d8f18f74591ffcac6466409ac7cd29f90838b2fe"))
    (package
      (name "emacs-logos")
      (version "1.0.1")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://git.sr.ht/~protesilaos/logos")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0g3jxzwv99wkxlb36j2nyjibayvwjpy7qc2mz9lfd2945q6apj3z"))))
      (native-inputs (list texinfo))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'install 'makeinfo
              (lambda* (#:key outputs #:allow-other-keys)
                (invoke "emacs"
                        "--batch"
                        "--eval=(require 'ox-texinfo)"
                        "--eval=(find-file \"README.org\")"
                        "--eval=(org-texinfo-export-to-info)")
                (install-file "logos.info" (string-append #$output "/share/info")))))))
      (home-page "https://protesilaos.com/emacs/logos")
      (synopsis "Simple focus mode for Emacs")
      (description "This package provides a simple focus mode which can be
applied to any buffer for reading, writing, or even doing a presentation.  The
buffer can be divided in pages using the @code{page-delimiter}, outline
structure, or any other pattern.")
      (license (list license:gpl3+
                     license:fdl1.3+))))) ; GFDLv1.3+ for the manual

(define-public emacs-tmr
  (package
    (name "emacs-tmr")
    (version "0.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~protesilaos/tmr")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vz9zfqap221baiy41wpxph33g6h2plnanzgpjs0wk8dz1fpwfky"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-paths
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((ffplay (search-input-file inputs "/bin/ffplay")))
                (substitute* "tmr.el"
                  (("\"ffplay ")
                   (string-append "\"" ffplay " "))))
              (emacs-substitute-variables "tmr.el"
                ("tmr-sound-file"
                 (search-input-file
                  inputs
                  "share/sounds/freedesktop/stereo/alarm-clock-elapsed.oga")))))
          (add-after 'install 'makeinfo
            (lambda _
              (invoke "emacs"
                      "--batch"
                      "--eval=(require 'ox-texinfo)"
                      "--eval=(find-file \"README.org\")"
                      "--eval=(org-texinfo-export-to-info)")
              (install-file "tmr.info"
                            (string-append #$output "/share/info")))))))
    (native-inputs (list texinfo))
    (inputs (list ffmpeg sound-theme-freedesktop))
    (home-page "https://protesilaos.com/emacs/tmr/")
    (synopsis "Set timers using a convenient notation")
    (description
     "TMR is an Emacs package that provides facilities for setting timers
using a convenient notation.")
    (license (list license:gpl3+
                   license:fdl1.3+)))) ;GFDLv1.3+ for the manual

(define-public emacs-gn-mode
  (package
    (name "emacs-gn-mode")
    (version "0.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/lashtear/gn-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0dz5kgzbgsssr38z2kg6m915cvfys42ag1k42bsra3la2pixywfx"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/lashtear/gn-mode")
    (synopsis "Emacs major mode for editing GN (ninja generator) config files")
    (description
     "GN mode is a major mode for editing @acronym{GN,Ninja Generator} config
files in Emacs.  Files of this type (e.g., @file{BUILD.gn} or @file{*.gni})
are common in Chromium-derived projects.")
    (license license:bsd-3)))

(define-public emacs-drag-stuff
  (package
    (name "emacs-drag-stuff")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rejeep/drag-stuff")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jrr59iazih3imkl9ja1lbni9v3xv6b8gmqs015g2mxhlql35jka"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rejeep/drag-stuff")
    (synopsis "Drag stuff around in Emacs")
    (description
"Drag Stuff is a minor mode for Emacs that makes it possible to drag
stuff (words, region, lines) around in Emacs.")
    (license license:gpl3+)))

(define-public emacs-bazel
  ;; From 2021-11-21.
  ;; No releases available.
  (let ((commit "cdb2643dba39fe2bd64ba3b190b94d1ef1d83b18")
        (revision "0"))
    (package
      (name "emacs-bazel")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/bazelbuild/emacs-bazel-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32 "0ln06dprnivx9zxm6n23ppyx7x4kbn0f85pxwvkq32aq7wnqz82m"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/bazelbuild/emacs-bazel-mode")
      (synopsis "Bazel support for Emacs")
      (description
       "This package provides support for the Bazel build system.  See
@uref{https://bazel.build/} for background on Bazel.")
      (license license:asl2.0))))

(define-public emacs-clue
  ;; There are no releases so far.
  (let ((commit "41895da52cf76f964d97cb8204406ab9828c4839")
        (revision "0"))
    (package
      (name "emacs-clue")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/AmaiKinono/clue")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32 "08xpdpac82v5vwqqqgbh5imakl4pys6bpfacfk05pk88lw925ql8"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/AmaiKinono/clue/")
      (synopsis "Connecting clues while reading code")
      (description
       "Clue is a tool for helping you take notes while reading code.

Code reading is all about finding connections between different locations in
a project.  With Clue, you can take notes about these connections in plain
text (or your favorite markup language), and insert links to take you to these
locations.")
      (license license:gpl3+))))

(define-public emacs-gntp
  (package
    (name "emacs-gntp")
    (version "0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tekai/gntp.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nvyjjjydrimpxy4cpg90si7sr8lmldbhlcm2mx8npklp9pn5y3a"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tekai/gntp.el")
    (synopsis "Growl Notification Protocol for Emacs")
    (description
     "This package implements the Growl Notification Protocol GNTP
described at @uref{http://www.growlforwindows.com/gfw/help/gntp.aspx}.
It is incomplete as it only lets you send but not receive
notifications.")
    (license license:bsd-3)))

(define-public emacs-alert
  (package
    (name "emacs-alert")
    (version "1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jwiegley/alert")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0lc0p5cl4hfrzw1z2ghb11k1lvljn5m08jw5fmgwgxv667kwh49r"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-gntp emacs-log4e))
    (home-page "https://github.com/jwiegley/alert")
    (synopsis "Growl-style notification system for Emacs")
    (description
     "Alert is a Growl-workalike for Emacs which uses a common notification
interface and multiple, selectable \"styles\", whose use is fully
customizable by the user.")
    (license license:gpl2+)))

(define-public emacs-zones
  (package
    (name "emacs-zones")
    (version "2019.7.13")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "zones-" version ".el"))
       (sha256
        (base32 "0qp1ba2pkqx9d35g7z8hf8qs2k455krf2a92l4rka3ipsbnmq5k1"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/Zones")
    (synopsis "Define and act on multiple zones of buffer text")
    (description
     "Library @file{zones.el} lets you easily define and subsequently act on
multiple zones of buffer text.  You can think of this as enlarging the notion
of region.  In effect, it can remove the requirement of target text being
a contiguous sequence of characters.  A set of buffer zones is, in effect,
a (typically) noncontiguous set of text.")
    (license license:gpl3+)))

(define-public emacs-mu4e-alert
  (package
    (name "emacs-mu4e-alert")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/iqbalansari/mu4e-alert")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nvsfbfsma59ilf7c3vjngnmx3aapwvvvaafdy5szm5r6lkicqvg"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-alert emacs-s emacs-ht mu))
    (home-page "https://github.com/iqbalansari/mu4e-alert")
    (synopsis "Desktop notification for mu4e")
    (description
     "This package provides desktop notifications for mu4e.
Additionally it can display the number of unread emails in the
mode-line.")
    (license license:gpl3+)))

(define-public emacs-mu4e-jump-to-list
  (let ((commit "358bba003543b49ffa266e503e54aebd0ebe614b")
        (revision "1"))
    (package
      (name "emacs-mu4e-jump-to-list")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/wavexx/mu4e-jump-to-list.el.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "00y9nap61q1z2cdql4k9g7fgi2gdgd9iy5s5lzrd9a4agbx6r7sv"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list mu))
      (home-page "https://gitlab.com/wavexx/mu4e-jump-to-list.el")
      (synopsis "Select and view mailing lists in mu4e")
      (description
        "@code{mu4e-jump-to-list} allows you to select and view mailing lists
automatically using existing List-ID headers in your mu database.  Just press
\"l\" in the headers view and any mailing list you've subscribed to will be
automatically discovered and presented in recency order.")
      (license license:gpl3+))))

(define-public emacs-url-scgi
  (package
    (name "emacs-url-scgi")
    (version "0.8")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/"
                                  "url-scgi-" version ".tar"))
              (sha256
               (base32
                "1837vyamwk5mp2nf3k477hyr5pq1xy6p7br7kl6h2k8jmxqy3mlj"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/skangas/url-scgi/")
    (synopsis "SCGI support for url.el")
    (description
     "This library add support for SCGI URLs to Emacs.  It is based on url.el,
which is shipped with Emacs.")
    (license license:gpl3+)))

(define-public emacs-mentor
  (package
    (name "emacs-mentor")
    (version "0.5")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.nongnu.org/nongnu/mentor-"
                           version ".tar"))
       (sha256
        (base32
         "1kkzm881fxhc5hb83x0j12lv22b72nzw45qrypbl1jf2siispz9l"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-async emacs-url-scgi emacs-xml-rpc))
    (home-page "https://elpa.nongnu.org/nongnu/mentor.html")
    (synopsis "Emacs front-end for the rTorrent bittorrent client")
    (description
     "Mentor is a GNU Emacs frontend for the rTorrent bittorrent client.

By default, it will start and run rTorrent from within Emacs but can also be
configured to use an external rTorrent instance over XML-RPC.

This project aims to provide a feature complete and customizable interface,
that will feel familiar to Emacs users.  Key bindings are chosen to be as
close to the vanilla rTorrent curses interface as possible.")
    (license license:gpl3+)))

(define-public emacs-message-view-patch
  (let ((commit "40bc2e554fc1d0b6f0c403192c0a3ceaa019a78d")
        (revision "2"))
    (package
      (name "emacs-message-view-patch")
      (version (git-version "0.2.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/seanfarley/message-view-patch")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0cmkiggrl42sjx31dwnzac32bs3q2ksmamkq1pjjl8fwshp4g8sv"))))
      (build-system emacs-build-system)
      (inputs (list emacs-magit))
      (home-page "https://github.com/seanfarley/message-view-patch")
      (synopsis "Colorize patch-like emails in mu4e or gnus")
      (description
       "Extension for mu4e or gnus to colorize patch-like emails with diff-mode.
This is based on Frank Terbeck's @code{gnus-article-treat-patch.el} but has
been adapted to also work with mu4e.")
      (license license:gpl3+))))

(define-public emacs-mu4e-patch
  (deprecated-package "emacs-mu4e-patch" emacs-message-view-patch))

(define-public emacs-pretty-mode
  (package
    (name "emacs-pretty-mode")
    (version "2.0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/akatov/pretty-mode/")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "013fig9i4fyx16krp2vfv953p3rwdzr38zs6i50af4pqz4vrcfvh"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/akatov/pretty-mode")
    (synopsis "Redisplay parts of the buffer as Unicode symbols")
    (description
     "Emacs minor mode for redisplaying parts of the buffer as pretty symbols.")
    (license license:gpl3+)))

(define-public emacs-tempel
  (package
    (name "emacs-tempel")
    (version "0.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/minad/tempel")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1za73zszj373r8pxf89cwwfrwsf8dy6nxciw11adcccrm92xwdsz"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/minad/tempel")
    (synopsis "Simple templates for Emacs")
    (description
     "Tempel is a tiny template package for Emacs, which uses the syntax of
the Emacs Tempo library.  You may also write your templates in Lisp.")
    (license license:gpl3+)))

(define-public emacs-yasnippet
  (package
    (name "emacs-yasnippet")
    (version "0.14.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joaotavora/yasnippet")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0via9dzw8m5lzymg1h78xkwjssh39zr3g6ccyamlf1rjzjsyxknv"))
       (patches
        (search-patches "emacs-yasnippet-fix-tests.patch"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "--batch"
                        "-l" "yasnippet-tests.el"
                        "-f" "ert-run-tests-batch-and-exit")
       #:phases
       (modify-phases %standard-phases
         ;; Set HOME, otherwise test-rebindings fails.
         (add-before 'check 'set-home
           (lambda _
             (setenv "HOME" (getcwd))
             #t)))))
    (home-page "https://github.com/joaotavora/yasnippet")
    (synopsis "Yet another snippet extension for Emacs")
    (description "YASnippet is a template system for Emacs.  It allows you to
type an abbreviation and automatically expand it into function templates.")
    (license license:gpl3+)))

(define-public emacs-yasnippet-snippets
  (package
    (name "emacs-yasnippet-snippets")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/AndreaCrotti/yasnippet-snippets")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0m78jxhjyf4212ig2ncxr6bhhd6yx4c3nc8x4ylamzq21x4fl21r"))))
    (build-system emacs-build-system)
    (arguments
     `(#:include (cons* "^snippets\\/" %default-include)))
    (propagated-inputs
     (list emacs-yasnippet))
    (home-page "https://github.com/AndreaCrotti/yasnippet-snippets")
    (synopsis "Collection of YASnippet snippets for many languages")
    (description "This package provides an extensive collection of YASnippet
snippets.  When this package is installed, the extra snippets it provides are
automatically made available to YASnippet.")
    (license license:gpl3+)))

(define-public emacs-doom-snippets
  ;; Use the latest commit, as there are no tagged releases.  Version is
  ;; extracted from main file.
  (let ((release "1.1.0")
        (revision "0")
        (commit "bc613f448eed1bd363e61c41691a61e9fd139534"))
    (package
      (name "emacs-doom-snippets")
      (version (git-version release revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hlissner/doom-snippets")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0n4b2pr0gpn8vb2n1rckdq4jk9sj995a62yxk6z2ygw5ad7pkj8f"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include (cons* "^.*\\/" %default-include)))
      (propagated-inputs
       (list emacs-yasnippet))
      (home-page "https://github.com/hlissner/doom-snippets")
      (synopsis "Doom Emacs' snippet library")
      (description
       "This package provides Yasnippets snippets for Doom Emacs.  It also
exposes a small API to assist in writing your own snippets.")
      (license license:expat))))

(define-public emacs-helm-c-yasnippet
  (let ((commit "65ca732b510bfc31636708aebcfe4d2d845b59b0")
        (revision "1"))
    (package
      (name "emacs-helm-c-yasnippet")
      (version (string-append "0.6.7" "-" revision "."
                              (string-take commit 7)))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/emacs-jp/helm-c-yasnippet")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1cbafjqlzxbg19xfdqsinsh7afq58gkf44rsg1qxfgm8g6zhr7f8"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-helm emacs-yasnippet))
      (home-page "https://github.com/emacs-jp/helm-c-yasnippet")
      (synopsis "Helm integration for Yasnippet")
      (description "This Emacs library provides Helm interface for
Yasnippet.")
      (license license:gpl2+))))

(define-public emacs-helm-system-packages
  (package
    (name "emacs-helm-system-packages")
    (version "1.10.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacs-helm/helm-system-packages")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "13a8jpj4wwm0yjv8hnsizgjf8wi3r2ap87lyvw7g4c7snp2dydwa"))))
    (build-system emacs-build-system)
    (inputs
     (list recutils))
    (propagated-inputs
     (list emacs-helm))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let ((recutils (assoc-ref inputs "recutils")))
               ;; Specify the absolute file names of the various
               ;; programs so that everything works out-of-the-box.
               (substitute* "helm-system-packages-guix.el"
                 (("recsel") (string-append recutils "/bin/recsel")))))))))
    (home-page "https://github.com/emacs-helm/helm-system-packages")
    (synopsis "Helm System Packages is an interface to your package manager")
    (description "List all available packages in Helm (with installed
packages displayed in their own respective face).  Fuzzy-search, mark and
execute the desired action over any selections of packages: Install,
uninstall, display packages details (in Org Mode) or insert details at point,
find files owned by packages...  And much more, including performing all the
above over the network.")
    (license license:gpl3+)))

(define-public emacs-helm-org-rifle
  (package
    (name "emacs-helm-org-rifle")
    (version "1.7.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alphapapa/helm-org-rifle")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0pm6va26kadjvbai4qsnjc2bk379w2nk6h3b5f0c2yv3q5na0p49"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-f emacs-helm emacs-org emacs-s))
    (home-page "https://github.com/alphapapa/helm-org-rifle")
    (synopsis "Rifle through Org files")
    (description "This package searches both headings and contents of entries
in Org buffers and displays matching entries.")
    (license license:gpl3+)))

(define-public emacs-dired-git-info
  ;; Upstream has no proper release.  The base version is extracted from the
  ;; "Version" keyword in the main file.
  (let ((commit "91d57e3a4c5104c66a3abc18e281ee55e8979176")
        (revision "0"))
    (package
      (name "emacs-dired-git-info")
      (version (git-version "0.3.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/clemera/dired-git-info")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1dr4iv95s4barxxj56znqkl9z0lg5jw731jmjr01s6vn8ar69gik"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/clemera/dired-git-info/")
      (synopsis "Show git info in Emacs Dired")
      (description "This Emacs package provides a minor mode which shows git
information inside the Dired buffer.")
      (license license:gpl3+))))

(define-public emacs-dired-toggle-sudo
  (let ((commit "13bbe52c54893f5aa3e56228450ffdd0c9e1d169")
        (revision "0"))
    (package
      (name "emacs-dired-toggle-sudo")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/renard/dired-toggle-sudo")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1fw1pb1z6krqd1pfxxhr6rrfr9ckkcb0zsjzbjk0i2i1q5cg6car"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/renard/dired-toggle-sudo")
      (synopsis "Browse directory with @code{sudo} privileges")
      (description "This package allows for the use of @code{dired} with
@code{sudo} privileges.")
      (license license:wtfpl2))))

(define-public emacs-diredfl
  (package
    (name "emacs-diredfl")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/purcell/diredfl")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1zb2lz7rp58zqvpniqcsmqabi7nqg2d8bfd0hgmq68bn2hd25b5z"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/diredfl/")
    (synopsis "Extra Emacs font lock rules for a more colourful Dired")
    (description "This library enables additional font locking in Dired mode.
This is adapted from the extra font lock rules provided by Drew Adams' Dired+
package.")
    (license license:gpl3+)))

(define-public emacs-memoize
  (package
    (name "emacs-memoize")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/skeeto/emacs-memoize")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "04qgnlg4x6va7x364dhj1wbjmz8p5iq2vk36mn9198k2vxmijwzk"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "--batch"
                        "-l" "memoize-test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/skeeto/emacs-memoize")
    (synopsis "Emacs lisp memoization library")
    (description "@code{emacs-memoize} is an Emacs library for
memoizing functions.")
    (license license:unlicense)))

(define-public emacs-linum-relative
  (package
    (name "emacs-linum-relative")
    (version "0.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/coldnew/linum-relative")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0b3n1gk2w1p72x0zfdz9l70winq2fnjpjrgq0awxx730xk7ypp5n"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/coldnew/linum-relative")
    (synopsis "Relative line numbering for Emacs")
    (description "@code{emacs-linum-relative} displays the relative line
number on the left margin in Emacs.")
    (license license:gpl2+)))

(define-public emacs-lin
  (package
    (name "emacs-lin")
    (version "1.0.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://git.sr.ht/~protesilaos/lin")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0bbxm2ndp6hcpdiv34dl9smgx5l0m4pdzm7csp283f6q9kwwdf3v"))))
    (native-inputs (list texinfo))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'makeinfo
            (lambda _
              (invoke "emacs"
                      "--batch"
                      "--eval=(require 'ox-texinfo)"
                      "--eval=(find-file \"README.org\")"
                      "--eval=(org-texinfo-export-to-info)")
              (install-file "lin.info" (string-append #$output "/share/info")))))))
    (home-page "https://protesilaos.com/emacs/lin")
    (synopsis "Make @command{hl-line-mode} more suitable for selection UIs")
    (description "Lin is a stylistic enhancement for Emacs’ built-in
@command{hl-line-mode}.  It remaps the hl-line face (or equivalent)
buffer-locally to a style that is optimal for major modes where line selection
is the primary mode of interaction.")
    (license (list license:gpl3+
                   license:fdl1.3+)))) ; GFDLv1.3+ for the manual

(define-public emacs-idle-highlight
  (package
    (name "emacs-idle-highlight")
    (version "1.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nonsequitur/idle-highlight-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0x4w1ksrw7dicl84zpf4d4scg672dyan9g95jkn6zvri0lr8xciv"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/IdleHighlight")
    (synopsis "Highlights all occurrences of the word the point is on")
    (description
     "This Emacs package provides @code{idle-highlight-mode} that sets
 an idle timer to highlight all occurrences in the buffer of the word under
 the point.")
    (license license:gpl3+)))

(define-public emacs-ox-twbs
  (package
    (name "emacs-ox-twbs")
    (version "1.1.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/marsmining/ox-twbs")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0nffy7ivs8fw0dj3s66hbsby0riz5wrv7xzm8g9mrfvhki938pqa"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/marsmining/ox-twbs")
    (synopsis "Export org-mode docs as HTML compatible with Twitter Bootstrap")
    (description
     "This Emacs package outputs your org-mode docs with a simple, clean and
modern look.  It implements a new HTML back-end for exporting org-mode docs as
HTML compatible with Twitter Bootstrap.  By default, HTML is exported with
jQuery and Bootstrap resources included via osscdn.")
    (license license:gpl3+)))

(define-public emacs-highlight-sexp
  (package
    (name "emacs-highlight-sexp")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/daimrod/highlight-sexp")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "12cyk2q5g6p4ac2hykw1cag7dp1prjjnck5f7nalwwaklmy62y79"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/daimrod/highlight-sexp")
    (synopsis "Minor mode that highlights the s-exp at the current position")
    (description
     "This Emacs package highlights the s-exp at the current position.")
    (license license:gpl3+)))

(define-public emacs-highlight-stages
  (let ((commit "29cbc5b78261916da042ddb107420083da49b271")
        (revision "1"))
    (package
      (name "emacs-highlight-stages")
      (version (string-append "1.1.0" "-" revision "." (string-take commit 7)))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/zk-phi/highlight-stages")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0r6nbcrr0dqpgm8dir8ahzjy7rw4nrac48byamzrq96r7ajlxlv0"))
         (patches
          (search-patches "emacs-highlight-stages-add-gexp.patch"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/wigust/highlight-stages")
      (synopsis "Minor mode that highlights (quasi-quoted) expressions")
      (description "@code{highlight-stages} provides an Emacs minor mode that
highlights quasi-quoted expressions.")
      (license license:gpl3+))))

(define-public emacspeak
  (package
    (name "emacspeak")
    (version "53.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://github.com/tvraman/emacspeak/releases/download/"
             version "/emacspeak-" version ".tar.bz2"))
       (sha256
        (base32 "0lasj4ggsh93ingf46n16wxfx5zzxvr1igikbmdqlz3i99j331gs"))))
    (build-system gnu-build-system)
    (arguments
     (list
      #:make-flags #~(list (string-append "prefix=" #$output))
      #:phases
      #~(modify-phases %standard-phases
          (replace 'configure
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (setenv "SHELL" (which "sh"))
              ;; Ensure the tclespeak.so binary is found in the correct location
              ;; by adding the path to the Tclx library to the Tcl $auto_path
              ;; variable.
              (with-fluids ((%default-port-encoding "ISO-8859-1"))
                (substitute* "servers/espeak"
                  (("package require Tclx")
                   (string-append "set auto_path [linsert $auto_path 0 "
                                  #$tclx
                                  "/lib]\n"
                                  "package require Tclx"))))
              ;; Configure Emacspeak according to etc/install.org.
              (invoke "make" "config")))
          (add-after 'build 'build-espeak
            (lambda _
              (invoke "make" "espeak")))
          (replace 'install
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (let* ((out (assoc-ref outputs "out"))
                     (bin (string-append out "/bin"))
                     (lisp (string-append out "/share/emacs/site-lisp/emacspeak"))
                     (info (string-append out "/share/info"))
                     (emacs (search-input-file inputs "/bin/emacs")))
                ;; According to etc/install.org, the Emacspeak directory should
                ;; be copied to its installation destination.
                (for-each
                 (lambda (file)
                   (copy-recursively file (string-append lisp "/" file)))
                 '("etc" "info" "js" "lisp" "media" "servers" "sounds"
                   "stumpwm" "xsl"))
                ;; Make sure emacspeak is loaded from the correct directory.
                (substitute* "run"
                  (("\\./lisp/emacspeak-setup.el")
                   (string-append lisp "/lisp/emacspeak-setup.el")))
                ;; Install the convenient startup script.
                (mkdir-p bin)
                (copy-file "run" (string-append bin "/emacspeak"))))))
      #:tests? #f))                     ; no check target
    (inputs
     (list emacs espeak-ng perl tcl tclx))
    (home-page "http://emacspeak.sourceforge.net")
    (synopsis "Audio desktop interface for Emacs")
    (description
     "Emacspeak is a speech interface that allows visually impaired users to
interact independently and efficiently with the computer.  Audio
formatting---a technique pioneered by AsTeR---and full support for W3C's Aural
CSS (ACSS) allows Emacspeak to produce rich aural presentations of electronic
information.  By seamlessly blending all aspects of the Internet such as
Web-surfing and messaging, Emacspeak speech-enables local and remote
information via a consistent and well-integrated user interface.")
    (license license:gpl2+)))

(define-public emacs-adaptive-wrap
  (package
    (name "emacs-adaptive-wrap")
    (version "0.8")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "adaptive-wrap-" version ".tar"))
       (sha256
        (base32 "1gs1pqzywvvw4prj63vpj8abh8h14pjky11xfl23pgpk9l3ldrb0"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/adaptive-wrap.html")
    (synopsis "Smart line-wrapping with wrap-prefix")
    (description
     "This Emacs package provides the @code{adaptive-wrap-prefix-mode}
minor mode which sets the wrap-prefix property on the fly so that
single-long-line paragraphs get word-wrapped in a way similar to what
you'd get with @kbd{M-q} using @code{adaptive-fill-mode}, but without
actually changing the buffer's text.")
    (license license:gpl3+)))

(define-public emacs-diff-hl
  ;;; XXX: Latest release is not tagged.  Use commit matching version bump.
  (let ((commit "37b00f3bad841e131d69442a89cbebc3041d996b"))
    (package
      (name "emacs-diff-hl")
      (version "1.9.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dgutov/diff-hl")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0s3fcwk6c99n2q25bf0a33lphr9mcrxmvr5wz8qsj86jfbyi1is1"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/dgutov/diff-hl")
      (synopsis
       "Highlight uncommitted changes using VC")
      (description
       "@code{diff-hl-mode} highlights uncommitted changes on the side of the
window (using the fringe, by default), allows you to jump between
the hunks and revert them selectively.")
      (license license:gpl3+))))

(define-public emacs-diminish
  ;; XXX: Upstream did not tag last release.
  (let ((commit "fd486ef76e4c1d8211ae337a43b8bba106d4bca7")
        (revision "1"))
    (package
      (name "emacs-diminish")
      (version (git-version "0.46" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/myrjola/diminish.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1vlgn7swwfzy6yr880698h3qsmfcqprcb1jvffkzmbvhvf458szf"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/myrjola/diminish.el")
      (synopsis "Diminish minor modes with no modeline display")
      (description "@code{emacs-diminish} implements hiding or
abbreviation of the mode line displays (lighters) of minor modes.")
      (license license:gpl3+))))

(define-public emacs-use-package
  ;; XXX: Upstream did not tag latest release.  Using commit matching exact
  ;; version bump.
  (let ((commit "942617d26e11d80d879ff23d2a8b477bd074a734"))
    (package
      (name "emacs-use-package")
      (version "2.4.4")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jwiegley/use-package")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1zpf9xv65jg813k90x8g9k4lja896nqfh48pjinicmz1rn0rf51a"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #t
        #:test-command #~(list "emacs" "--batch"
                               "-l" "use-package-tests.el"
                               "-f" "ert-run-tests-batch-and-exit")
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'install 'install-manual
              (lambda _
                (let ((info-dir (string-append #$output "/share/info")))
                  (install-file "use-package.info" info-dir))))
            (add-before 'install-manual 'build-manual
              (lambda _
                (invoke "makeinfo" "use-package.texi"))))))
      (native-inputs
       (list texinfo))
      (propagated-inputs
       (list emacs-diminish))
      (home-page "https://github.com/jwiegley/use-package")
      (synopsis "Declaration for simplifying your .emacs")
      (description "The use-package macro allows you to isolate package
configuration in your @file{.emacs} file in a way that is both
performance-oriented and tidy.")
      (license license:gpl2+))))

(define-public emacs-leaf
  (package
    (name "emacs-leaf")
    (version "4.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "leaf-" version ".tar"))
       (sha256
        (base32 "1rdbrf84ijapiqhq72gy8r5xgk54sf0jy31pgd3w4rl1wywh5cas"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/conao3/leaf.el")
    (synopsis "Simplify your init.el configuration, extended use-package")
    (description
     "This package provides macros that allows you to declaratively configure
settings typical of an Elisp package with various keywords.  The syntax is
similar, but not identical to use-package -- overall, leaf aims at a cleaner
and more predictable implementation.")
    (license license:agpl3+)))

(define-public emacs-strace-mode
  (let* ((commit "6a69b4b06db6797af56f33eda5cb28af94e59f11")
         (revision "1"))
    (package
      (name "emacs-strace-mode")
      (version (string-append "0.0.2-" revision "." (string-take commit 7)))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/pkmoore/strace-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1lbk2kzdznf2bkfazizfbimaxxzfzv00lrz1ran9dc2zqbc0bj9f"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/pkmoore/strace-mode")
      (synopsis "Emacs major mode to highlight strace outputs")
      (description "@code{emacs-strace-mode} provides an Emacs major mode
 highlighting strace outputs.")
      (license license:gpl3+))))

(define-public emacs-default-encrypt
  (package
    (name "emacs-default-encrypt")
    (version "4.4")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://informationelle-selbstbestimmung-im-internet.de"
             "/emacs/jl-encrypt" version "/jl-encrypt.el"))
       (file-name (string-append "jl-encrypt-" version ".el"))
       (sha256
        (base32
         "0w9ggz075j1zwg7d0rv9k8238g600p7czfnnsnawswi7yps2xk78"))))
    (build-system emacs-build-system)
    (home-page
     "https://informationelle-selbstbestimmung-im-internet.de/Emacs.html")
    (synopsis "Automatically encrypt or sign Gnus messages in Emacs")
    (description
     "DefaultEncrypt is designed to be used with Gnus in Emacs.  It
automatically encrypts messages that you send (e.g., email) when public keys
for all recipients are available, and it protects you from accidentally
sending un-encrypted messages.  It can also be configured to automatically
sign messages that you send.  For details and instructions on how to use
DefaultEncrypt, please refer to the home page or read the comments in the
source file, @file{jl-encrypt.el}.")
    (license license:gpl3+)))

(define-public emacs-extend-smime
  (package
    (name "emacs-extend-smime")
    (version "3.3")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://informationelle-selbstbestimmung-im-internet.de"
             "/emacs/jl-smime" version "/jl-smime.el"))
       (file-name (string-append "jl-smime-" version ".el"))
       (sha256
        (base32
         "1iv8s2wjmv3v5qfwlcy9hvvrmxxvp3f8m1krlr789q7bbh35jynh"))))
    (build-system emacs-build-system)
    (home-page
     "https://informationelle-selbstbestimmung-im-internet.de/Emacs.html")
    (synopsis "Improved S/MIME support for Gnus in Emacs")
    (propagated-inputs
     (list emacs-default-encrypt))
    (description
     ;; TRANSLATORS: ExtendSMIME, DefaultEncrypt, and emacs-default-encrypt
     ;; should not be translated.  The name "emacs-default-encrypt" refers to
     ;; the Guix package that provides DefaultEncrypt.
     "ExtendSMIME is designed to be used with Gnus in Emacs.  It enhances
DefaultEncrypt (emacs-default-encrypt) to support S/MIME (Secure/Multipurpose
Internet Mail Extensions) via LDAP (Lightweight Directory Access Protocol).
Before a message (e.g., email) is sent, ExtendSMIME searches for missing
certificates via LDAP and imports them into @code{gpgsm}.  When certificates
for all recipients are available, DefaultEncrypt automatically encrypts the
message.  For details and instructions on how to use ExtendSMIME, please refer
to the home page or read the comments in the source file,
@file{jl-smime.el}.")
    (license license:gpl3+)))

(define-public emacs-htmlize
  (package
    (name "emacs-htmlize")
    (version "1.56")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hniksic/emacs-htmlize")
             (commit (string-append "release/" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14m8si49br62lgx7asdyp9jysq0v6midrfk32sxy521ydqmqr3c1"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/hniksic/emacs-htmlize")
    (synopsis "Convert buffer text and decorations to HTML")
    (description "@code{emacs-htmlize} converts the buffer text and
the associated decorations to HTML.  Output to CSS, inline CSS and
fonts is supported.")
    (license license:gpl2+)))

(define-public emacs-xmlgen
  (package
    (name "emacs-xmlgen")
    (version "0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/philjackson/xmlgen")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "096i29v0badx0a6339h9ckdz78zj59gbjdp7vj7vhkq9d830392s"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "--batch"
                        "-l" "xmlgen-test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/philjackson/xmlgen")
    (synopsis "S-expression to XML domain specific language (DSL) in
Emacs Lisp")
    (description "@code{emacs-xmlgen} provides S-expression to XML
conversion for Emacs Lisp.")
    (license license:gpl2+)))

(define-public emacs-cdlatex
  (package
    (name "emacs-cdlatex")
    (version "4.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cdominik/cdlatex")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jj9vmhc4s3ych08bjm1c2xwi81z1p20rj7bvxrgvb5aga2ghi9d"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-auctex))
    (home-page "https://github.com/cdominik/cdlatex")
    (synopsis "Fast Emacs input methods for LaTeX environments and
math")
    (description "CDLaTeX is an Emacs minor mode supporting fast
insertion of environment templates and math in LaTeX.  Similar
commands are also offered as part of the AUCTeX package, but it is not
the same - CDLaTeX focuses on speediness for inserting LaTeX
constructs.")
    (license license:gpl3+)))

(define-public emacs-cnfonts
  (package
    (name "emacs-cnfonts")
    (version "0.9.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tumashu/cnfonts")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "11d44lf0m0kbzq1mvyqkl4aprys0xqaarp08nij57xnynin1rynx"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tumashu/cnfonts")
    (synopsis "Emacs Chinese fonts setup tool")
    (description "cnfonts is a Chinese fonts setup tool, allowing for easy
configuration of Chinese fonts.")
    (license license:gpl2+)))

(define-public emacs-boon
  (package
    (name "emacs-boon")
    (version "1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jyp/boon")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "18il2licf8pgfcrpx2bk55gpf8f537kb9cxqz83jldkhiyry74il"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-expand-region emacs-multiple-cursors
           emacs-powerline emacs-spaceline))
    (home-page "https://github.com/jyp/boon")
    (synopsis "Ergonomic command mode for Emacs")
    (description "Boon is a complete package for modal editing with a focus on
ergonomics and modularity.  Spacial allocation of keys comes first, mnemonics
second.  Most common operations are mapped to the home row, common editing
commands are bound to keys reachable with the left hand and movement keys are
reached with the right hand.")
    (license license:gpl3+)))

(define-public emacs-cc-mode
  (package
   (name "emacs-cc-mode")
   (version "5.35")
   (source
    (origin
     (method hg-fetch)
     (uri (hg-reference
           (url "http://hg.code.sf.net/p/cc-mode/cc-mode")
           (changeset
            (string-append "Release_"
                           (string-replace-substring version "." "_")))))
     (file-name (hg-file-name name version))
     (sha256
      (base32 "03cvl61baccx57zd62nz2wy4hvij5hl2syg7byaxgrs4c7grr414"))))
   (build-system emacs-build-system)
   (arguments
    '(#:tests? #t
      #:test-command '("make" "test")
      #:phases
      (modify-phases %standard-phases
        (add-before 'install 'make-info
          (lambda _
            (invoke "make" "info"))))))
   (native-inputs
    (list texinfo))
   (home-page "http://cc-mode.sourceforge.net/")
   (synopsis "Framework for creating major modes for C-style languages")
   (description
    "CC Mode is an Emacs and XEmacs mode for editing C and other languages with
similar syntax; currently C++, Objective-C, Java, CORBA's IDL, Pike, and AWK.")
   (license license:gpl3+)))

(define-public emacs-csharp-mode
  (package
    (name "emacs-csharp-mode")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/josteink/csharp-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0wfd4jdjsq8qp6pavf25y87dxvlnsqapfi4c4m3xj24baalr2dpq"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/josteink/csharp-mode")
    (synopsis "Major mode for C# code")
    (description
     "This is a C# editing mode for Emacs, based on CC mode.  It handles
syntax coloring, indentation, insertion of matched pairs of curly braces and
documentation generation.  In addition, it provides menu-based navigation
using Imenu, and Compilation mode support for MSBuild, devenv and xbuild.")
    (license license:gpl3+)))

(define-public emacs-vala-mode
  ;; Upstream has no tagged release.
  (let ((commit "d696a8177e94c81ea557ad364a3b3dcc3abbc50f")
        (revision "0"))
    (package
      (name "emacs-vala-mode")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rrthomas/vala-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0g5pdq757z9d8rk489n5ilhqipdc4i4sfkjwwrxyvgjlapjc04c0"))))
      (build-system emacs-build-system)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'disable-multiline-support
             (lambda* (#:key inputs #:allow-other-keys)
               (make-file-writable "vala-mode.el")
               (emacs-batch-edit-file "vala-mode.el"
                 '(progn
                   (require 'thingatpt) ;; beginning-of-thing, end-of-thing
                   (goto-char (point-min))
                   (save-excursion
                    (re-search-forward ";; Support multiline strings")
                    (goto-char (match-beginning 0))
                    (kill-sexp)
                    (insert ";; FIXME: Support multiline strings
(c-lang-defconst c-multiline-string-start-char vala nil)"))
                   (save-excursion
                    (re-search-forward "(defcustom vala-multiline-strings")
                    (goto-char (match-beginning 0))
                    (insert ";; FIXME: Support multiline strings\n")
                    (comment-region (beginning-of-thing 'sexp)
                                    (end-of-thing 'sexp)))
                   (basic-save-buffer))))))))
      (home-page "https://github.com/rrthomas/vala-mode")
      (synopsis "Vala mode for Emacs")
      (description
       "This package provides a major mode for editing .vala and .vapi files
in Emacs.")
      (license license:gpl2+))))

(define-public emacs-php-mode
  (package
    (name "emacs-php-mode")
    (version "1.24.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ejmr/php-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13lkzvamr86409whr8as4721gx9xrlfkmxvv941775mryliqk6j6"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'enter-source-directory
           (lambda _
             (chdir "lisp"))))))
    (propagated-inputs (list emacs-projectile))
    (home-page "https://github.com/ejmr/php-mode")
    (synopsis "Major mode for editing PHP code")
    (description
     "PHP mode is a major mode for editing PHP source code.  It's an extension
of C mode; thus it inherits all C mode's navigation functionality.  But it
colors according to the PHP grammar and indents according to the PEAR coding
guidelines.  It also includes a couple handy IDE-type features such as
documentation search and a source and class browser.")
    (license license:gpl3+)))

(define-public emacs-pos-tip
  (package
    (name "emacs-pos-tip")
    (version "0.4.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pitkali/pos-tip")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0w8bnspnk871qndp18hs0wk4x9x31xr9rwbvf5dc8mcbnj29ch33"))))
    (build-system emacs-build-system)
    ;; The following functions and variables needed by emacs-pos-tip are
    ;; not included in emacs-minimal:
    ;; x-display-pixel-width, x-display-pixel-height, x-show-tip
    (arguments `(#:emacs ,emacs))
    (home-page "https://github.com/pitkali/pos-tip")
    (synopsis "Show tooltip at point")
    (description "The standard library tooltip.el provides a function for
displaying a tooltip at the mouse position.  However, locating a tooltip at an
arbitrary buffer position in a window is not easy.  Pos-tip provides such a
function to be used by other frontend programs.")
    (license license:gpl2+)))

(define-public emacs-pyim-basedict
  ;; XXX: The commit below points to the lastest (un-tagged) release.
  (let ((commit "d61af27686f7a39e6c138b7261a686e7ea7a0ef7"))
    (package
      (name "emacs-pyim-basedict")
      (version "0.5.4")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tumashu/pyim-basedict")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0fzyh8qmicq2vy9j1ca708ir67dpxp1cwjaw0sw469p24cvj12yy"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-pyim))
      (home-page "https://github.com/tumashu/pyim-basedict")
      (synopsis "Input method dictionary of pyim")
      (description "Pyim-basedict is the default pinyin input method dictionary,
containing words from the Rime project.")
      (license license:gpl2+))))

(define-public emacs-pyim
  (package
    (name "emacs-pyim")
    (version "5.2.8")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/pyim-" version ".tar"))
       (sha256
        (base32 "1klarzr5lfga09ysq3c7gkgmzl6r08gpl4519x5damxd82x4r3y2"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-async emacs-popup emacs-posframe emacs-xr))
    (home-page "https://github.com/tumashu/pyim")
    (synopsis "Chinese input method")
    (description
     "This package provides a Chinese input method which supports quanpin,
shuangpin, wubi and cangjie.")
    (license license:gpl2+)))

(define-public emacs-pinyinlib
  (package
    (name "emacs-pinyinlib")
    (version "0.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cute-jumper/pinyinlib.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1nwj4c3y0kdlkf3jqd2dnibaiazrq6qcj533xk2qw4wmx072yij0"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/cute-jumper/pinyinlib.el")
    (synopsis "Convert first letter of Pinyin to Chinese characters")
    (description
     "This Emacs library provides functionality for converting the first
letter of Pinyin to Simplified/Traditional Chinese characters.")
    (license license:gpl3+)))

(define-public emacs-reverse-im
  (package
    (name "emacs-reverse-im")
    (version "0.0.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/a13/reverse-im.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1h4gpyqir0kqf6a7ni8dbqwd4mr33imay0fmprrpfpfqxj0lj7c1"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/a13/reverse-im.el")
    (synopsis "Reverse mapping for non-default system layouts")
    (description
     "Reverse IM provides a minor mode that toggles translations for all input
methods from a given list.")
    (license license:gpl3+)))

(define-public emacs-mini-frame
  (let ((commit "60838f3cab438dcbda8eaa15ab3e5d1af88910e9")
        (revision "0"))
    (package
      (name "emacs-mini-frame")
      (version (git-version "1.19" revision commit))
      (source
       (origin
         (uri (git-reference
               (url "https://github.com/muffinmad/emacs-mini-frame.git")
               (commit commit)))
         (method git-fetch)
         (sha256
          (base32 "0q01iymz657bg3mcmq7vcl8r0ypsa1pqj1p6gxs7ywx1d33lan4d"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (home-page "https://github.com/muffinmad/emacs-mini-frame")
      (synopsis "Show minibuffer in child frame")
      (description
       "@dfn{mini-frame-mode} adds an advice around @code{read-from-minibuffer}
to show the minibuffer as a child frame on top of the current frame.
@code{find-file} and similar functions associated mini-buffers may appear at
the center of the screen and not at the bottom.")
      (license license:gpl3+))))

(define-public emacs-posframe
  (package
    (name "emacs-posframe")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "posframe-" version ".tar"))
       (sha256
        (base32 "06xk6z3b5mqgcskjiwkl9viccvzriflr8y51aclyfdamh5qb6kqb"))))
    (build-system emacs-build-system)
    ;; emacs-minimal does not include the function font-info.
    (arguments
     `(#:emacs ,emacs))
    (home-page "https://github.com/tumashu/posframe")
    (synopsis "Pop a posframe (a child frame) at point")
    (description
     "Posframe can pop a posframe at point.  A posframe is a child frame
displayed within its root window's buffer.  Posframe is fast and works well
with CJK languages.")
    (license license:gpl3+)))

(define-public emacs-el2org
  (package
    (name "emacs-el2org")
    (version "0.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tumashu/el2org")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mzddqny6wpg1fv99xrvlv7rxmaifvmy5bvj4in4pldhm4cx4q1b"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tumashu/el2org")
    (synopsis "Convert Emacs-lisp file to org file")
    (description "El2org is a simple tool, which can convert Emacs-lisp file
to org file, you can use this tool to write orgify commentary.")
    (license license:gpl2+)))

(define-public emacs-muse
  (package
    (name "emacs-muse")
    (version "3.20.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "muse-" version ".tar"))
       (sha256
        (base32 "0g2ff6x45x2k5dnkp31sk3bjj92jyhhnar7l5hzn8vp22l0rv8wn"))))
    (build-system emacs-build-system)
    (home-page "https://www.gnu.org/software/emacs-muse")
    (synopsis "Authoring and publishing environment for Emacs")
    (description
     "Emacs Muse (also known as Muse) is an authoring and publishing
environment for Emacs.  It simplifies the process of writing documents and
publishing them to various output formats such as HTML, LaTeX, or PDF.")
    (license license:gpl3+)))

(define-public emacs-mustache
  (package
    (name "emacs-mustache")
    (version "0.23")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Wilfred/mustache.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1n2ymd92qpvsby6ms0l3kjhdzzc47rri2aiscc6bs07hm4mjpr9q"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-ht emacs-s))
    (home-page "https://github.com/Wilfred/mustache.el")
    (synopsis "Mustache templating library for Emacs")
    (description "Mustache templating library for Emacs, mustache is
a simple web template system, which is described as a logic-less system
because it lacks any explicit control flow statements, both looping and
conditional evaluation can be achieved using section tags processing lists
and lambdas.")
    (license license:gpl3+)))

(define-public emacs-org2web
  (package
    (name "emacs-org2web")
    (version "0.9.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tumashu/org2web")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0wsvfn409a2ivbich8b8zqza78sprirg4bl7igx536ydqclmi0n7"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-el2org emacs-ht emacs-mustache
           emacs-simple-httpd))
    (home-page "https://github.com/tumashu/org2web")
    (synopsis "Static site generator based on org-mode")
    (description "Org2web is a static site generator based on org-mode,
which code derived from Kelvin H's org-page.")
    (license license:gpl2+)))

(define-public emacs-meow
  (package
    (name "emacs-meow")
    (version "1.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/meow-edit/meow")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "11iz95lm25vpdc3plpm3h1zlmfmfz08xlman8iqk5fa13636v7hj"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/meow-edit/meow")
    (synopsis "Yet another modal editing on Emacs")
    (description "Meow is yet another modal editing mode for Emacs.  It aims
to blend modal editing into Emacs with minimum interface with its original
key-bindings, avoiding most if not all the hassle introduced by key-binding
conflicts.")
    (license license:gpl3+)))

(define-public emacs-xelb
  (package
    (name "emacs-xelb")
    (version "0.18")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/xelb-"
                                  version ".tar"))
              (sha256
               (base32
                "1fp5mzl63sh0h3ws4l5p4qgvi7ny8a3fj6k4dhqa98xgw2bx03v7"))))
    (build-system emacs-build-system)
    ;; The following functions and variables needed by emacs-xelb are
    ;; not included in emacs-minimal:
    ;; x-display-screens, x-keysym-table, x-alt-keysym, x-meta-keysym
    ;; x-hyper-keysym, x-super-keysym, libxml-parse-xml-region
    ;; x-display-pixel-width, x-display-pixel-height
    (arguments
     `(#:emacs ,emacs
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'regenerate-el-files
           (lambda* (#:key inputs #:allow-other-keys)
             (invoke "make"
                     (string-append "PROTO_PATH="
                                    (assoc-ref inputs "xcb-proto")
                                    "/share/xcb")
                     (string-append "EMACS_BIN="
                                    (assoc-ref inputs "emacs")
                                    "/bin/emacs -Q")))))))
    (native-inputs (list xcb-proto))
    (home-page "https://github.com/ch11ng/xelb")
    (synopsis "X protocol Emacs Lisp binding")
    (description "@code{emacs-xelb} is a pure Emacs Lisp implementation of the
X11 protocol based on the XML description files from the XCB project.  It
features an object-oriented API and permits a certain degree of concurrency.
It should enable you to implement low-level X11 applications.")
    (license license:gpl3+)))

(define-public emacs-exwm
  (package
    (name "emacs-exwm")
    (version "0.27")
    (synopsis "Emacs X window manager")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "exwm-" version ".tar"))
       (sha256
        (base32 "094k33clmxhnab0wniyrs48sdz28kna2g6fmkhsd7n20nmhhc4sn"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-xelb))
    (inputs
     (list xhost dbus))
    ;; The following functions and variables needed by emacs-exwm are
    ;; not included in emacs-minimal:
    ;; scroll-bar-mode, fringe-mode
    ;; x-display-pixel-width, x-display-pixel-height
    (arguments
     `(#:emacs ,emacs
       #:phases
       (modify-phases %standard-phases
         (add-after 'build 'install-xsession
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let* ((out (assoc-ref outputs "out"))
                    (xsessions (string-append out "/share/xsessions"))
                    (bin (string-append out "/bin"))
                    (exwm-executable (string-append bin "/exwm")))
               ;; Add a .desktop file to xsessions
               (mkdir-p xsessions)
               (mkdir-p bin)
               (make-desktop-entry-file
                (string-append xsessions "/exwm.desktop")
                #:name ,name
                #:comment ,synopsis
                #:exec exwm-executable
                #:try-exec exwm-executable)
               ;; Add a shell wrapper to bin
               (with-output-to-file exwm-executable
                 (lambda _
                   (format #t "#!~a ~@
                     ~a +SI:localuser:$USER ~@
                     exec ~a --exit-with-session ~a \"$@\" --eval '~s' ~%"
                           (search-input-file inputs "/bin/sh")
                           (search-input-file inputs "/bin/xhost")
                           (search-input-file inputs "/bin/dbus-launch")
                           (search-input-file inputs "/bin/emacs")
                           '(cond
                             ((file-exists-p "~/.exwm")
                              (load-file "~/.exwm"))
                             ((not (featurep 'exwm))
                              (require 'exwm)
                              (require 'exwm-config)
                              (exwm-config-default)
                              (message (concat "exwm configuration not found. "
                                               "Falling back to default configuration...")))))))
               (chmod exwm-executable #o555)
               #t))))))
    (home-page "https://github.com/ch11ng/exwm")
    (description
     "EXWM is a full-featured tiling X window manager for Emacs built on top
of XELB.")
    (license license:gpl3+)))

(define-public emacs-xelb-no-x-toolkit
  (package
    (inherit emacs-xelb)
    (name "emacs-xelb-no-x-toolkit")
    (arguments
     (substitute-keyword-arguments (package-arguments emacs-xelb)
       ((#:emacs emacs) `,emacs-no-x-toolkit)))))

(define-public emacs-exwm-no-x-toolkit
  (package
    (inherit emacs-exwm)
    (name "emacs-exwm-no-x-toolkit")
    (synopsis "Emacs X window manager (without an X toolkit)")
    (propagated-inputs
     (list emacs-xelb-no-x-toolkit))
    (arguments
     (substitute-keyword-arguments (package-arguments emacs-exwm)
       ((#:emacs emacs) `,emacs-no-x-toolkit)))))

(define-public emacs-switch-window
  (package
    (name "emacs-switch-window")
    (version "1.6.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dimitri/switch-window")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0rci96asgamr6qp6nkyr5vwrnslswjxcjd96yccy4aivh0g66yfg"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/dimitri/switch-window")
    (synopsis "Emacs window switch tool")
    (description "Switch-window is an emacs window switch tool, which
offer a visual way to choose a window to switch to, delete, split or
other operations.")
    (license license:wtfpl2)))

(define-public emacs-exwm-x
  (package
    (name "emacs-exwm-x")
    (version "2.0.2")
    (synopsis "Derivative window manager based on EXWM")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tumashu/exwm-x")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0h248mma7kky30jr9bbhmp95wchl2cx5p6kh0gxmzpbc247dn2cc"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-counsel emacs-exwm emacs-switch-window emacs-use-package))
    (inputs
     (list xhost dbus))
    ;; Need emacs instead of emacs-minimal,
    ;; for emacs's bin path will be inserted into bin/exwm-x file.
    (arguments
     `(#:emacs ,emacs
       #:phases
       (modify-phases %standard-phases
         (add-after 'build 'install-xsession
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let* ((out (assoc-ref outputs "out"))
                    (xsessions (string-append out "/share/xsessions"))
                    (bin (string-append out "/bin"))
                    (exwm-executable (string-append bin "/exwm-x")))
               ;; Add a .desktop file to xsessions
               (mkdir-p xsessions)
               (mkdir-p bin)
               (with-output-to-file
                   (string-append xsessions "/exwm-x.desktop")
                 (lambda _
                   (format #t "[Desktop Entry]~@
                     Name=~a~@
                     Comment=~a~@
                     Exec=~a~@
                     TryExec=~@*~a~@
                     Type=Application~%" ,name ,synopsis exwm-executable)))
               ;; Add a shell wrapper to bin
               (with-output-to-file exwm-executable
                 (lambda _
                   (format #t "#!~a ~@
                     ~a +SI:localuser:$USER ~@
                     exec ~a --exit-with-session ~a \"$@\" --eval '~s' ~%"
                           (search-input-file inputs "/bin/sh")
                           (search-input-file inputs "/bin/xhost")
                           (search-input-file inputs "/bin/dbus-launch")
                           (search-input-file inputs "/bin/emacs")
                           '(require 'exwmx-loader))))
               (chmod exwm-executable #o555)
               #t))))))
    (home-page "https://github.com/tumashu/exwm-x")
    (description "EXWM-X is a derivative window manager based on EXWM, with focus
on mouse-control.")
    (license license:gpl3+)))

(define-public emacs-gnugo
  (package
    (name "emacs-gnugo")
    (version "3.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/gnugo-"
                           version ".tar"))
       (sha256
        (base32
         "138gzdyi8scqimvs49da66j8f5a43bhgpasn1bxzdj2zffwlwp6g"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure
           (lambda* (#:key inputs #:allow-other-keys)
             (emacs-substitute-variables "gnugo.el"
               ("gnugo-xpms" "#'gnugo-imgen-create-xpms" (as-display))
               ("gnugo-program" (search-input-file inputs "/bin/gnugo"))))))))
    (inputs (list gnugo))
    (propagated-inputs
     (list emacs-ascii-art-to-unicode emacs-xpm))
    (home-page "https://elpa.gnu.org/packages/gnugo.html")
    (synopsis "Emacs major mode for playing GNU Go")
    (description "This package provides an Emacs based interface for GNU Go,
which can be started via @samp{M-x gnugo}.  It has a graphical mode where the
board and stones are drawn using XPM images and supports the use of a mouse.
You can switch to the graphical mode by running @samp{M-x
gnugo-image-display-mode}.")
    (license license:gpl3+)))

(define-public emacs-gnuplot
  (package
    (name "emacs-gnuplot")
    (version "0.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/gnuplot-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "09y177sq24gs7wwjihw59g0m4n1rv2ws9890ynxjxawv823r0fxm"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacsorphanage/gnuplot-mode")
    (synopsis "Emacs major mode for interacting with Gnuplot")
    (description
     "Emacs Gnuplot is an Emacs major mode for interacting with Gnuplot.")
    (license license:gpl2+)))

(define-public emacs-transpose-frame
  (package
    (name "emacs-transpose-frame")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/transpose-frame")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0m9jmfwwhgkwxbq3y000ymx7parbgqr7gq3yjm2wh1ll747gv51y"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/TransposeFrame")
    (synopsis "Transpose window arrangement in current frame")
    (description "@code{emacs-transpose-frame} provides some interactive
functions which allows users to transpose windows arrangement in currently
selected frame.")
    (license license:bsd-2)))

(define-public emacs-transpose-mark
  ;; XXX: Upstream made no release so far, and did not add a Version keyword.
  (let ((commit "667327602004794de97214cf336ac61650ef75b7")
        (revision "0"))
    (package
      (name "emacs-transpose-mark")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/kwrooijen/transpose-mark")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "03wc50vn1kmrgnzzhs06pwpap2p2rx84wwzxw0hawsg1f1l35m2x"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/kwrooijen/transpose-mark")
      (synopsis "Library for transposing lines and regions")
      (description "Transpose mark provides some commands that makes
transposing lines and regions easier.  You can mark a line and transpose it
with a line at point, or mark a region and transpose it with another region
a point.  The plugin provides visual feedback for marked regions.")
      (license license:gpl3+))))

(define-public emacs-key-chord
  (package
    (name "emacs-key-chord")
    (version "0.6")
    (source
     (origin
       (method url-fetch)
       (uri "https://www.emacswiki.org/emacs/download/key-chord.el")
       (file-name (string-append "key-chord-" version ".el"))
       (sha256
        (base32
         "03m44pqggfrd53nh9dvpdjgm0rvca34qxmd30hr33hzprzjambxg"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/key-chord.el")
    (synopsis "Map pairs of simultaneously pressed keys to Emacs commands")
    (description "@code{emacs-key-chord} provides @code{key-chord-mode}, a
mode for binding key chords to commands.  A key chord is defined as two keys
pressed simultaneously or a single key quickly pressed twice.")
    (license license:gpl2+)))

(define-public emacs-evil-surround
  (package
    (name "emacs-evil-surround")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-evil/evil-surround")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gfgmr4909m36gknprcam6q4rkcqfbi6w43ky7x6jnlmgb6mxggg"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-evil))
    (arguments
     `(#:tests? #t
       #:test-command '("make" "test")))
    (home-page "https://github.com/emacs-evil/evil-surround")
    (synopsis "Easily modify surrounding parentheses and quotes")
    (description "@code{emacs-evil-surround} allows easy deletion, change and
addition of surrounding pairs, such as parentheses and quotes, in evil mode.")
    (license license:gpl3+)))

(define-public emacs-evil-commentary
  (package
    (name "emacs-evil-commentary")
    (version "2.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/linktohack/evil-commentary")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1l8zi9wlg1f7ffm8gh92qwk3q7h6cdl8b8zkd9hcda53mq6klpjr"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-evil))
    (home-page "https://github.com/linktohack/evil-commentary")
    (synopsis "Comment out code in evil mode")
    (description "@code{emacs-evil-commentary} adds keybindings to easily
comment out lines of code in evil mode.  It provides @code{gcc} to comment out
lines, and @code{gc} to comment out the target of a motion.")
    (license license:gpl3+)))

;; Tests for emacs-ansi have a circular dependency with ert-runner, and
;; therefore cannot be run
(define-public emacs-ansi
  (let ((commit "2367fba7b3b2340364a30cd6de7f3eb6bb9898a3")
        (revision "2"))
    (package
      (name "emacs-ansi")
      (version (git-version "0.4.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rejeep/ansi.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1n7h6l4icm6lks3zpvd83j1fzrnspw19rmz7c96vy7pdh1y4v3p3"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/rejeep/ansi.el")
      (synopsis "Convert strings to ANSI")
      (description "@code{emacs-ansi} defines functions that turns simple
strings to ANSI strings.  Turning a string into an ANSI string can be to add
color to a text, add color in the background of a text or adding a style, such
as bold, underscore or italic.")
      (license license:gpl3+))))

;; Tests for emacs-commander have a circular dependency with ert-runner, and
;; therefore cannot be run
(define-public emacs-commander
  (package
    (name "emacs-commander")
    (version "0.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rejeep/commander.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1j6hhyzww7wfwk6bllbb5mk4hw4qs8hsgfbfdifsam9c6i4spm45"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-f emacs-s))
    (home-page "https://github.com/rejeep/commander.el")
    (synopsis "Emacs command line parser")
    (description "@code{emacs-commander} provides command line parsing for
Emacs.")
    (license license:gpl3+)))

(define-public emacs-eglot
  (package
    (name "emacs-eglot")
    (version "1.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joaotavora/eglot")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "030837yak24ymjawsfr1hgyfdjy3k30ld1ca0cgnrxhgxc7p8hwv"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #t
      #:test-command #~(list "emacs" "--batch"
                             "-l" "eglot.el"
                             "-l" "eglot-tests.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs
     (list emacs-eldoc emacs-jsonrpc emacs-project))
    (home-page "https://github.com/joaotavora/eglot")
    (synopsis "Client for Language Server Protocol (LSP) servers")
    (description
     "Emacs Polyglot, or Eglot, is an Emacs @acronym{Language Server Protocol,
LSP} client that stays out of the way.  It guesses the LSP program to start
for the current file, using the major mode as a hint.  It prompts you to enter
one if it fails.")
    (license license:gpl3+)))

(define-public emacs-jarchive
  (package
    (name "emacs-jarchive")
    (version "0.8.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://git.sr.ht/~dannyfreeman/jarchive")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1fi3y5kmy7ginyqg12q797bma638xmam7lrk74x6yhx84xgzb4fq"))))
    (build-system emacs-build-system)
    (home-page "https://sr.ht/~dannyfreeman/jarchive")
    (synopsis "Jarchive teaches Emacs how to navigate to files inside JARs")
    (description "Jarchive makes Emacs handle Java and LSP URIs pointing to
 source inside JARs.")
    (license license:gpl3+)))

(define-public emacs-eldoc
  (package
    (name "emacs-eldoc")
    (version "1.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://elpa.gnu.org/packages/eldoc-" version ".tar"))
       (sha256
        (base32 "0c05dzrs7vrhibj46jpz625482ah6xywji7way6wcvwc711y74fz"))))
    (build-system emacs-build-system)
    (home-page "http://elpa.gnu.org/packages/eldoc.html")
    (synopsis "Show function arglist or variable docstring in echo area")
    (description
     "This program was inspired by the behavior of the ``mouse documentation
window'' on many Lisp Machine systems; as you type a function's symbol name as
part of a sexp, it will print the argument list for that function.  Behavior
is not identical; for example, you need not actually type the function name,
you need only move point around in a sexp that calls it.  Also, if point is
over a documented variable, it will print the one-line documentation for that
variable instead, to remind you of that variable's meaning.")
    (license license:gpl3+)))

;; Tests for ert-runner have a circular dependency with ecukes, and therefore
;; cannot be run
(define-public emacs-ert-runner
  (package
    (name "emacs-ert-runner")
    (version "0.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
	     (url "https://github.com/rejeep/ert-runner.el")
	     (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
	(base32
	 "08gygn9fjank5gpi4v6ynrkn0jbknxbwsn7md4p9ndygdbmnkf98"))))
    (build-system emacs-build-system)
    (inputs
     (list emacs-ansi
           emacs-commander
           emacs-dash
           emacs-f
           emacs-s
           emacs-shut-up))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
	 (add-after 'install 'install-executable
	   (lambda* (#:key inputs outputs #:allow-other-keys)
	     (let ((out (assoc-ref outputs "out"))
		   (source-directory (string-append
				      (getenv "TMPDIR") "/source")))
	       (substitute* "bin/ert-runner"
		 (("ERT_RUNNER=\"\\$\\(dirname \\$\\(dirname \\$0\\)\\)")
		  (string-append "ERT_RUNNER=\"" (elpa-directory out))))
	       (install-file "bin/ert-runner" (string-append out "/bin"))
	       (wrap-program (string-append out "/bin/ert-runner")
		 (list "EMACSLOADPATH" ":" 'prefix
		       ;; Do not capture the transient source directory in
		       ;; the wrapper.
		       (delete source-directory
			       (string-split (getenv "EMACSLOADPATH") #\:))))
	       #t))))
       #:include (cons* "^reporters/.*\\.el$" %default-include)))
    (home-page "https://github.com/rejeep/ert-runner.el")
    (synopsis "Opinionated Ert testing workflow")
    (description "@code{ert-runner} is a tool for Emacs projects tested
using ERT.  It assumes a certain test structure setup and can therefore make
running tests easier.")
    (license license:gpl3+)))

(define-public emacs-xtest
  (package
    (name "emacs-xtest")
    (version "1.1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/promethial/xtest")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1wqx6hlqcmqiljydih5fx89dw06g8w728pyn4iqsap8jwgjngb09"))))
    (arguments
     `(#:exclude '()))
    (build-system emacs-build-system)
    (home-page "https://github.com/promethial/xtest/")
    (synopsis "Simple testing with Emacs")
    (description "This package provides a simple testing library for Emacs.")
    (license license:gpl3+)))

(define-public emacs-org-transclusion
  (package
    (name "emacs-org-transclusion")
    (version "1.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nobiot/org-transclusion")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0pjk6686ss50s9ws014if9mnixsf9m53z1d7bvkbx09lq3jqa7ry"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #true
      #:test-command #~(list "emacs" "--batch"
                             "-l" "org-transclusion.el"
                             "-l" "test/unit-tests.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (native-inputs
     (list emacs-ert-runner))
    (home-page "https://nobiot.github.io/org-transclusion/")
    (synopsis "Enable transclusion with Org Mode")
    (description "Org-transclusion lets you insert a copy of text content via
a file link or ID link within an Org file.  It lets you have the same content
present in different buffers at the same time without copy-and-pasting it.
Edit the source of the content, and you can refresh the transcluded copies to
the up-to-date state.  Org-transclusion keeps your files clear of the
transcluded copies, leaving only the links to the original content.")
    (license license:gpl3+)))

(define-public emacs-disable-mouse
  (package
    (name "emacs-disable-mouse")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/disable-mouse")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0l6mai68ns3qw3rlvjvzsnqwdy7bxqiy0vdwflq0l1plxb1vazyc"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/disable-mouse")
    (synopsis "Disable mouse commands globally")
    (description
     "Provides @code{disable-mouse-mode} and @code{global-disable-mouse-mode},
pair of minor modes which suppress all mouse events by intercepting them and
running a customisable handler command (@code{ignore} by default).")
    (license license:gpl3+)))

(define-public emacs-json-reformat
  (package
    (name "emacs-json-reformat")
    (version "0.0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/gongo/json-reformat")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gaifz1brh7yh1wk1c02gddwis4ab6bggv27gy7gcd2s861f8bkx"))
       (patches (search-patches "emacs-json-reformat-fix-tests.patch"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("ert-runner")
       #:phases
       (modify-phases %standard-phases
         (add-before 'check 'make-tests-writable
           (lambda _
             (for-each make-file-writable (find-files "test"))))
         (add-before 'check 'delete-json-objects-order-test
           (lambda _
             (emacs-batch-edit-file "test/json-reformat-test.el"
               `(progn (progn (goto-char (point-min))
                              (re-search-forward
                               "ert-deftest json-reformat-test:json-reformat-region")
                              (beginning-of-line)
                              (kill-sexp))
                       (basic-save-buffer)))))
         (add-before 'check 'delete-json-reformat-region-occur-error-test
           (lambda _
             (emacs-batch-edit-file "test/json-reformat-test.el"
               `(progn (goto-char (point-min))
                       (re-search-forward
                        "ert-deftest json-reformat-test:json-reformat-region-occur-error")
                       (beginning-of-line)
                       (kill-sexp)
                       (basic-save-buffer))))))))
    (native-inputs
     (list emacs-dash emacs-ert-runner emacs-shut-up))
    (propagated-inputs
     (list emacs-undercover))
    (home-page "https://github.com/gongo/json-reformat")
    (synopsis "Reformatting tool for JSON")
    (description "@code{json-reformat} provides a reformatting tool for
@url{http://json.org/, JSON}.")
    (license license:gpl3+)))

(define-public emacs-json-snatcher
  (package
    (name "emacs-json-snatcher")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Sterlingg/json-snatcher")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "05zsgnk7grgw9jzwl80h5sxfpifxlr37b4mkbvx7mjq4z14xc2jw"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/sterlingg/json-snatcher")
    (synopsis "Grabs the path to JSON values in a JSON file")
    (description "@code{emacs-json-snatcher} grabs the path to JSON values in
a @url{http://json.org/, JSON} file.")
    (license license:gpl3+)))

(define-public emacs-json-mode
  (package
    (name "emacs-json-mode")
    (version "1.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joshwnj/json-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0r0k56q58kb133l9x9nbisz9p2kbphfgw1l4g2xp0pjqsc9wvq8z"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-json-snatcher))
    (home-page "https://github.com/joshwnj/json-mode")
    (synopsis "Major mode for editing JSON files")
    (description "@code{json-mode} extends the builtin js-mode syntax
highlighting.")
    (license license:gpl3+)))

(define-public emacs-jsonrpc
  ;; Commit refers to a commit in the Emacs repository, as jsonrpc.el was
  ;; upstreamed.  By convention, it should refer to a commit in which
  ;; jsonrpc.el was actually touched.
  (let ((commit "50654cf0b1bf6210fc8f46d8e7ae13bbeeccecb5")
        (revision "0"))                 ; Currently a version bump
    (package
      (name "emacs-jsonrpc")
      (version (git-version "1.0.15" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://git.savannah.gnu.org/git/emacs.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0srwb171dxha1nfzppk6x9v4bdj3lk74pksqnhalw8jw9c67b72y"))))
      (build-system emacs-build-system)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (replace 'unpack
                   (lambda* (#:key source #:allow-other-keys)
                     (mkdir "source")
                     (chdir "source")
                     (copy-file (string-append source "/lisp/jsonrpc.el")
                                "jsonrpc.el"))))))
      (home-page "http://elpa.gnu.org/packages/jsonrpc.html")
      (synopsis "JSON-RPC library")
      (description
       "This library implements the JSONRPC 2.0 specification as
described in @url{http://www.jsonrpc.org/}.  As the name suggests,
JSONRPC is a generic Remote Procedure Call protocol designed around
JSON objects.")
      (license license:gpl3+))))

(define-public emacs-jsonnet-mode
  (package
    (name "emacs-jsonnet-mode")
    (version "0.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tminor/jsonnet-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "14nxfa91yg2243v4d5kvynp2645x3811ispmhmpgil3x9qbl9jg9"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://github.com/tminor/jsonnet-mode")
    (synopsis "Major mode for editing jsonnet files")
    (description "This package provides syntax highlighting, indenting,
formatting, and utility methods for jsonnet files.")
    (license license:gpl3+)))

(define-public emacs-restclient
  (let ((commit "1fb570643b08ba66eb70831b6f874f52546917f1")
        (version "0")
        (revision "4"))               ;Guix package revision,
                                        ;upstream doesn't have official releases
    (package
      (name "emacs-restclient")
      (version (git-version version revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/pashky/restclient.el")
                      (commit commit)))
                (sha256
                 (base32
                  "0npij1p1yw4p1f1yrx6bl8q18nav5p2xvbp7qhzhn7lb2fdn5jqv"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-helm emacs-jq-mode))
      (home-page "https://github.com/pashky/restclient.el")
      (synopsis "Explore and test HTTP REST webservices")
      (description
       "This tool allows for testing and exploration of HTTP REST Web services
from within Emacs.  Restclient runs queries from a plan-text query sheet,
displays results pretty-printed in XML or JSON with @code{restclient-mode}")
      (license license:public-domain))))

(define-public emacs-jq-mode
  (package
    (name "emacs-jq-mode")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ljos/jq-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xk0if5i9cz4w06lx8v1vdm112pn1ybqgfw048sx15yyvfzgril1"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ljos/jq-mode")
    (synopsis "Major mode for editing jq queries")
    (description
     "Jq mode is an Emacs major mode for editing jq-scripts.")
    (license license:gpl3+)))

(define-public emacs-whitespace-cleanup-mode
  (let ((commit "72427144b054b0238a86e1348c45d986b8830d9d")
        (revision "1"))
    (package
      (name "emacs-whitespace-cleanup-mode")
      (version (git-version "0.10" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/purcell/whitespace-cleanup-mode")
                      (commit commit)))
                (sha256
                 (base32
                  "1zlk534jbwrsabcg3kqlzk4h4hwya60lh6q2n1v4yn4rpf5ghsag"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (home-page "https://github.com/purcell/whitespace-cleanup-mode")
      (synopsis "Intelligently call @code{whitespace-cleanup} on save")
      (description
       "This package provides a minor mode that calls
@code{whitespace-cleanup} before saving the current buffer only if the
whitespace in the buffer was initially clean.")
      (license license:gpl3+))))

(define-public emacs-eimp
  (let ((version "1.4.0")
        (commit "2e7536fe6d8f7faf1bad7a8ae37faba0162c3b4f")
        (revision "1"))
    (package
      (name "emacs-eimp")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/nicferrier/eimp")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "154d57yafxbcf39r89n5j43c86rp2fki3lw3gwy7ww2g6qkclcra"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'configure
             (lambda* (#:key inputs #:allow-other-keys)
               (let ((imagemagick (assoc-ref inputs "imagemagick")))
                 ;; eimp.el is read-only in git.
                 (chmod "eimp.el" #o644)
                 (emacs-substitute-variables "eimp.el"
                   ("eimp-mogrify-program"
                    (string-append imagemagick "/bin/mogrify"))))
               #t)))))
      (inputs
       (list imagemagick))
      (home-page "https://github.com/nicferrier/eimp")
      (synopsis "Interactive image manipulation utility for Emacs")
      (description "@code{emacs-eimp} allows interactive image manipulation
from within Emacs.  It uses the code@{mogrify} utility from ImageMagick to do
the actual transformations.")
      (license license:gpl2+))))

(define-public emacs-dired-hacks
  (let ((commit "d1a2bda6aa8f890cb367297ed93aee6d3b5ba388")
        (revision "3"))
    (package
      (name "emacs-dired-hacks")
      (version (git-version "0.0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/Fuco1/dired-hacks")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "12m81a9kjhs4cyq3lym0vp5nx6z3sfnypyzrnia76x6rjvixjf6y"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash emacs-eimp emacs-f emacs-s))
      (home-page "https://github.com/Fuco1/dired-hacks")
      (synopsis
       "Collection of useful dired additions")
      (description
       "This package provides the following collection of Emacs dired mode
additions:

@itemize
@item dired-avfs
@item dired-columns
@item dired-filter
@item dired-hacks-utils
@item dired-images
@item dired-list
@item dired-narrow
@item dired-open
@item dired-rainbow
@item dired-ranger
@item dired-subtree
@item dired-tagsistant
@end itemize\n")
      (license license:gpl3+))))

(define-public emacs-dired-sidebar
  (package
    (name "emacs-dired-sidebar")
    (home-page "https://github.com/jojojames/dired-sidebar")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "090dqaqyjmkzrz4szjpk1iip0bdvb0frp4l79393f8ki8w7c16c1"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dired-hacks))
    (synopsis "Sidebar for Emacs using Dired")
    (description
     "This package provides a sidebar for Emacs similar to @code{NeoTree}
or @code{treemacs}, but leveraging @code{Dired} to do the job of display.")
    (license license:gpl3+)))

(define-public emacs-dirvish
  (package
    (name "emacs-dirvish")
    (version "2.0.53")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/alexluigit/dirvish")
                    (commit "c535e2147171be5506f4ff34e862bacbfb3de768")))
              (sha256
               (base32
                "1nmp5ci4dvcpih6phfhk66s98lf8b49qd35ymy29kqkf5v4cnwga"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-transient))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; Move the extensions source files to the top level, which
          ;; is included in the EMACSLOADPATH.
          (add-after 'unpack 'move-source-files
            (lambda _
              (let ((el-files (find-files "./extensions" ".*\\.el$")))
                (for-each (lambda (f)
                            (rename-file f (basename f)))
                          el-files)))))))
    (home-page "https://github.com/alexluigit/dirvish")
    (synopsis "Improved version of the Emacs package Dired")
    (description
     "Dirvish is an improved version of the Emacs inbuilt package Dired.  It
not only gives Dired an appealing and highly customizable user interface, but
also comes together with almost all possible parts required for full usability
as a modern file manager.")
    (license license:gpl3+)))

(define-public emacs-which-key
  (package
    (name "emacs-which-key")
    (version "3.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/justbur/emacs-which-key")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ph5mrzz3r7x4dmy93v6affl4jznvic97a30mrs3kvhwyr2v4mby"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "--batch"
                        "-l" "which-key-tests.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/justbur/emacs-which-key")
    (synopsis "Display available key bindings in popup")
    (description
     "@code{emacs-which-key} is a minor mode for Emacs that displays the key
bindings following your currently entered incomplete command (a prefix) in a
popup.  For example, after enabling the minor mode if you enter C-x and wait
for the default of 1 second, the minibuffer will expand with all of the
available key bindings that follow C-x (or as many as space allows given your
settings).")
    (license license:gpl3+)))

(define-public emacs-free-keys
  (package
    (name "emacs-free-keys")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/Fuco1/free-keys")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xgifa7s9n882f9ymyyz9gc11xfbj3vfpnxiq1fqfm5hmwx9pwbc"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Fuco1/free-keys")
    (synopsis "Show free keybindings for modkeys or prefixes in Emacs.")
    (description
     "Free-keys shows available key bindings in the current Emacs buffer.")
    (license license:gpl3+)))

(define-public emacs-hercules
  (package
    (name "emacs-hercules")
    (version "0.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/jjzmajic/hercules.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1rp37rhkj8jm07dwr74vc68dhrbvyvrxjdavpb0h073ps9vl9dsc"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-which-key))
    (home-page "https://gitlab.com/jjzmajic/hercules.el")
    (synopsis "Call a chain of related commands without repeated prefix keys")
    (description
     "This package provides sticky-key-like functionality to obviate the need
for repeated prefix-key sequences, and can reuse existing keymaps.  The list
of commands is displayed in a handy popup.")
    (license license:gpl3+)))

(define-public emacs-ws-butler
  (package
    (name "emacs-ws-butler")
    (version "0.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/lewang/ws-butler")
             (commit "323b651dd70ee40a25accc940b8f80c3a3185205")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1a4b0lsmwq84qfx51c5xy4fryhb1ysld4fhgw2vr37izf53379sb"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("ert-runner" "tests")))
    (native-inputs
     (list emacs-ert-runner))
    (home-page "https://github.com/lewang/ws-butler")
    (synopsis "Trim spaces from end of lines")
    (description
     "This Emacs package automatically and unobtrusively trims whitespace
characters from end of lines.")
    (license license:gpl3+)))

(define-public emacs-opencl-mode
  ;; Upstream never makes any formal releases, there is only v1.0.
  ;; Use the latest commit instead.
  (let ((commit "15091eff92c33ee0d1ece40eb99299ef79fee92d")
        (revision "1"))
    (package
      (name "emacs-opencl-mode")
      (version (git-version "1.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/salmanebah/opencl-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32 "1zn6rr48w0ai0sn51zzyp546va6flfgf9lm12vfrdb6kkiiiq403"))))
      (build-system emacs-build-system)
      (synopsis "Emacs major mode for editing OpenCL kernels")
      (description "This Emacs package provides the @code{opencl-mode} major
mode for editing OpenCL kernels.  It supports syntax highlighting and online
access to the OpenCL documentation through the @code{opencl-lookup} function.")
      (home-page "https://github.com/salmanebah/opencl-mode")
      (license license:gpl3+))))

(define-public emacs-openwith
  ;; There is no release tag. Version is extracted from main file.
  (let ((version "20120531")
        (revision "0")
        (commit "5fe01dee520d24c839ad5ee18822667457d9f352"))
    (package
      (name "emacs-openwith")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/garberw/openwith")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1scbawhlzmj5nhix779rlqf462g37q84vpq205qhg4qyscvfx6bi"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/garberw/openwith")
      (synopsis "Open external applications for files with Emacs")
      (description
       "This package enables you to associate file name patterns with external
applications that are automatically invoked when you use commands like
@code{find-file}.  For example, you can have it open @code{png} files with
@code{feh} and @code{mp4} files with @code{mpv}.  This is especially useful
when browsing files with Dired.")
      (license license:gpl2+))))

(define-public emacs-org-edit-latex
  (package
    (name "emacs-org-edit-latex")
    (version "0.8.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/et2010/org-edit-latex")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1w0lyz71dq8x28ira4hig1b70bqn1dr53w3k5dgch9szcf6xa86y"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'set-home
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list emacs-auctex emacs-org))
    (home-page "https://github.com/et2010/org-edit-latex")
    (synopsis "Edit a LaTeX fragment just like editing a source block")
    (description
     "Org Edit LaTeX is an extension for Org mode.  It lets you edit a LaTeX
fragment in a dedicated buffer just like editing a source block.")
    (license license:gpl3+)))

(define-public emacs-emamux
  (package
    (name "emacs-emamux")
    (version "0.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-emamux")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "19y69qw79miim9cz5ji54gwspjkcp9g2c1xr5s7jj2fiabnxax6b"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/syohex/emacs-emamux")
    (synopsis "Manipulate Tmux from Emacs")
    (description
     "@code{emacs-emamux} lets Emacs interact with the @code{tmux} terminal
multiplexer.")
    (license license:gpl3+)))

(define-public emacs-plz
  (package
    (name "emacs-plz")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alphapapa/plz.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0p0xd532xa8icysyxwqk481lr9xanmp68gf97fd9n2936gp12chv"))))
    (build-system emacs-build-system)
    (inputs (list curl))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'substitute-curl-path
            (lambda* (#:key inputs #:allow-other-keys)
              (emacs-substitute-variables "plz.el"
                ("plz-curl-program" (search-input-file inputs "/bin/curl"))))))))
    (home-page "https://github.com/alphapapa/plz.el")
    (synopsis "HTTP library for Emacs")
    (description
     "This package provides HTTP library for Emacs.  It uses Curl as a backend,
which avoids some of the issues with using Emacs’s built-in Url library.")
    (license license:gpl3+)))

(define-public emacs-ement
  (package
    (name "emacs-ement")
    (version "0.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alphapapa/ement.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1411w5i2wsw748yszi9w99mlnwf1v31bmkg8brmybl9zmc0q4gxr"))))
    (build-system emacs-build-system)
    (arguments
     `(#:emacs ,emacs))               ;need libxml support
    (propagated-inputs
     (list emacs-plz
           emacs-svg-lib
           emacs-taxy
           emacs-taxy-magit-section
           emacs-ts))
    (home-page "https://github.com/alphapapa/ement.el")
    (synopsis "Matrix client for Emacs")
    (description "Ement.el is a Matrix client for Emacs.")
    (license license:gpl3+)))

(define-public emacs-rpm-spec-mode
  (let ((commit "c1c38050c48ea330c7cea632b8785d66daeefb2b")
        (revision "0"))
    (package
      (name "emacs-rpm-spec-mode")
      (version (git-version "0.16" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/stigbjorlykke/rpm-spec-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0427kcvf2ljhzwxskn3jzk0ncrl3f9zcz2sm83d9pmhh5jax2gch"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'adjust-for-emacs-28
              (lambda _
                ;; Since Emacs 28, define-obsolete-variable-alias require a
                ;; 3rd argument to specify when the deprecation was
                ;; introduced.
                ;; The rpm-spec-mode.el file is encoded in ISO-8859-1 (iso-latin-1).
                (with-fluids ((%default-port-encoding "ISO-8859-1"))
                  (substitute* "rpm-spec-mode.el"
                    (("'rpm-spec-completion-ignore-case" all)
                     (string-append all " \"0.12\""))
                    (("'rpm-spec-nobuild" all)
                     (string-append all " \"0.12\""))
                    (("'rpm-spec-initialize-sections" all)
                     (string-append all " \"0.12\""))
                    (("'rpm-spec-insert-changelog-version" all)
                     (string-append all " \"0.12\"")))))))))
      (home-page "https://github.com/stigbjorlykke/rpm-spec-mode")
      (synopsis "Emacs major mode for editing RPM spec files")
      (description "@code{emacs-rpm-spec-mode} provides an Emacs major mode for
editing RPM spec files.")
      (license license:gpl2+))))

(define-public emacs-lcr
  (package
    (name "emacs-lcr")
    (version "1.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jyp/lcr")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hhn0gqkwki0dfk6j759hmbj1ijn4bs550jh3kgy9jfmnb7cd81l"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://github.com/jyp/lcr")
    (synopsis "Lightweight coroutines in Emacs Lisp")
    (description "This package provides macros that can translate code into
equivalent continuation-passing code, as well as miscellaneous utility
functions written in continuation-passing style.")
    (license license:gpl3+)))

(define-public emacs-attrap
  (package
    (name "emacs-attrap")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jyp/attrap")
             (commit version)))
       (sha256
        (base32 "0wqc7bqx9rvk8r7fd3x84h8p01v97s6w2jf29nnjb59xakwp22i7"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-f emacs-flycheck emacs-s))
    (home-page "https://github.com/jyp/attrap")
    (synopsis "Fix coding error at point")
    (description "This package provides a command to fix the Flycheck error
at point.")
    (license license:gpl3+)))

(define-public emacs-git-messenger
  (package
    (name "emacs-git-messenger")
    (version "0.18")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-git-messenger")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "04fnby2nblk8l70gv09asxkmnn53fh1pdfs77ix44npp99fyw8ix"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-popup))
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "--batch" "-l" "test/test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/syohex/emacs-git-messenger")
    (synopsis "Popup commit message at current line")
    (description "@code{emacs-git-messenger} provides
@code{git-messenger:popup-message}, a function that when called, will popup
the last git commit message for the current line.  This uses git-blame
internally.")
    (license license:gpl3+)))

(define-public emacs-gitpatch
  (package
    (name "emacs-gitpatch")
    (version "0.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tumashu/gitpatch")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1drf4fvmak7brf16axkh4nfz8pg44i7pjhfjz3dbkycbpp8y5vig"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tumashu/gitpatch")
    (synopsis "Mail git patch from Emacs")
    (description "@code{emacs-gitpatch} lets users easily send git patches,
created by @code{git format-patch}, from @code{magit}, @code{dired} and
@code{ibuffer} buffers.")
    (license license:gpl3+)))

(define-public emacs-git-email
  ;; Use latest commit since latest tagged release is missing important
  ;; changes.
  (let ((commit "b5ebade3a48dc0ce0c85699f25800808233c73be")
        (revision "0"))
    (package
      (name "emacs-git-email")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://git.sr.ht/~yoctocell/git-email")
               (commit commit)))
         (patches
          (search-patches "emacs-git-email-missing-parens.patch"))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1lk1yds7idgawnair8l3s72rgjmh80qmy4kl5wrnqvpmjrmdgvnx"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           ;; piem is not yet packaged in Guix.
           (add-after 'unpack 'remove-piem
             (lambda _
               (delete-file "git-email-piem.el")))
           (add-before 'install 'makeinfo
             (lambda _
               (invoke "makeinfo" "doc/git-email.texi"))))))
      (native-inputs
       (list texinfo))
      (propagated-inputs
       (list mu emacs-magit emacs-notmuch))
      (license license:gpl3+)
      (home-page "https://sr.ht/~yoctocell/git-email")
      (synopsis "Format and send Git patches in Emacs")
      (description "This package provides utilities for formatting and
sending Git patches via Email, without leaving Emacs."))))

(define-public emacs-erc-hl-nicks
  (package
    (name "emacs-erc-hl-nicks")
    (version "1.3.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/leathekd/erc-hl-nicks")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0k57scxa8rm859fqsm8srhps7rlq06jzazhjbwnadzrh8i5fyvra"))))
    (build-system emacs-build-system)
    (synopsis "Nickname highlighting for Emacs ERC")
    (description "@code{erc-hl-nicks} highlights nicknames in ERC, an IRC
client for Emacs.  The main features are:
@itemize
@item Auto-colorizes nicknames without having to specify colors
@item Ignores certain characters that IRC clients add to nicknames to avoid
duplicates (nickname, nickname’, nickname\", etc.)
@item Attempts to produce colors with a sufficient amount of contrast between
the nick color and the background color
@end itemize\n")
    (home-page "https://github.com/leathekd/erc-hl-nicks")
    (license license:gpl3+)))

(define-public emacs-engine-mode
  (package
    (name "emacs-engine-mode")
    (version "2.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hrs/engine-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1xka8i4cdvp5r2v2mkli1zz17x1sdsnmszbhqav2rf94v656d91i"))))
    (build-system emacs-build-system)
    (synopsis "Minor mode for defining and querying search engines")
    (description "@code{engine-mode} is a global minor mode for Emacs.  It
enables you to easily define search engines, bind them to keybindings, and
query them from the comfort of your editor.")
    (home-page "https://github.com/hrs/engine-mode")
    (license license:gpl3+)))

(define-public emacs-engrave-faces
  (package
    (name "emacs-engrave-faces")
    (version "0.3.1")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/engrave-faces-"
                                  version ".tar"))
              (sha256
               (base32
                "1q4sjl2rvcfwcirm32nmi53258ln71yhh1dgszlxwknm38a14v3i"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tecosaur/engrave-faces")
    (synopsis "Convert font-lock faces to other formats")
    (description "There are some great packages for exporting buffers to
particular formats, but each one seems to reinvent the core mechanism of
processing the font-lock in a buffer such that it can be exported to
a particular format.

This package aims to produce a versatile generic core which can process
a fontified buffer and pass the data to any number of backends which can deal
with specific output formats.")
    (license license:gpl3+)))

(define-public emacs-inheritenv
  (package
    (name "emacs-inheritenv")
    (version "0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/inheritenv")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ygzf70vfb7qwpsllcq5i3brprsnx3sxy2zng02mzwrr5jkx4ypc"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/inheritenv/releases")
    (synopsis "Emacs temp buffers inherit buffer-local environment variables")
    (description
     "Inheritenv provides tools to execute processes inheriting the calling
buffer's environment.")
    (license license:gpl3+)))

(define-public emacs-enlive
  (package
    (name "emacs-enlive")
    (version "0.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/zweifisch/enlive")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "08j6b79vy8ry4ad1abk3hvxjbb4ylrhkvrbrnq1gcikl4h1p2v63"))))
    (build-system emacs-build-system)
    (home-page "http://github.com/zweifisch/enlive")
    (synopsis "Query HTML document with CSS selectors in Emacs")
    (description
     "Enlive is an Emacs library that allows the user to query HTML documents
from within Elisp using a DSL similar to CSS selectors.")
    (license license:gpl3+)))

(define-public emacs-envrc
  (package
    (name "emacs-envrc")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/envrc")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0nqqx4qlw75lmbn0v927sg3xyjkk86ihw1q3rdbbn59va41grds4"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-inheritenv))
    (home-page "https://github.com/purcell/envrc")
    (synopsis "Support for Direnv which operates buffer-locally")
    (description
     "This is library which uses Direnv to set environment variables on
a per-buffer basis.  This means that when you work across multiple projects
which have @file{.envrc} files, all processes launched from the buffers ``in''
those projects will be executed with the environment variables specified in
those files.  This allows different versions of linters and other tools to be
used in each project if desired.")
    (license license:gpl3+)))

(define-public emacs-prop-menu
  (package
    (name "emacs-prop-menu")
    (version "0.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/david-christiansen/prop-menu-el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "18ap2liz5r5a8ja2zz9182fnfm47jnsbyblpq859zks356k37iwc"))))
    (build-system emacs-build-system)
    (home-page
     "https://github.com/david-christiansen/prop-menu-el")
    (synopsis
     "Create and display a context menu based on text and overlay properties")
    (description
     "This is a library for computing context menus based on text
properties and overlays.  The intended use is to have tools that
annotate source code and others that use these annotations, without
requiring a direct coupling between them, but maintaining
discoverability.

Major modes that wish to use this library should first define an
appropriate value for @code{prop-menu-item-functions}.  Then, they should
bind @code{prop-menu-by-completing-read} to an appropriate
key.  Optionally, a mouse pop-up can be added by binding
@code{prop-menu-show-menu} to a mouse event.")
    (license license:gpl3+)))

(define-public emacs-idris-mode
  (let ((commit "9bc7697406f719258d93835df3c1761efbfecaa7")
        (revision "1"))
    (package
      (name "emacs-idris-mode")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/idris-hackers/idris-mode")
               (commit commit)))
         (file-name (git-file-name name commit))
         (sha256
          (base32
           "1d1f7kx0fw632js7qd1sra5wbpwyamcqs5wpzhyynmr5ybb0vyl7"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-prop-menu))
      (home-page
       "https://github.com/idris-hackers/idris-mode")
      (synopsis "Major mode for editing Idris code")
      (description
       "This is an Emacs mode for editing Idris code.  It is compatible with
the latest versions of Idris 1.")
      (license license:gpl3+))))

(define-public emacs-browse-at-remote
  (package
    (name "emacs-browse-at-remote")
    (version "0.14.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rmuslimov/browse-at-remote")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0bx4ns0jb0sqrjk1nsspvl3mhz3n12925azf7brlwb1vcgnji09v"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("ert-runner")))
    (native-inputs
     (list emacs-ert-runner))
    (propagated-inputs
     (list emacs-f emacs-s))
    (home-page "https://github.com/rmuslimov/browse-at-remote")
    (synopsis "Open github/gitlab/bitbucket/stash page from Emacs")
    (description
     "This Emacs package allows you to open a target page on
github/gitlab (or bitbucket) by calling @code{browse-at-remote} command.
It supports dired buffers and opens them in tree mode at destination.")
    (license license:gpl3+)))

(define-public emacs-tiny
  (let ((commit "fd8a6b0b0c564d8242259e20e557ee6041f40908")
        (revision "1"))
    (package
      (name "emacs-tiny")
      (version (git-version "0.2.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/abo-abo/tiny")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1498j392ap2mk4zmsm2id16pfgvj78r428da9vw7hdrzzibai2cx"))))
      (build-system emacs-build-system)
      (arguments
       `(#:tests? #t
         #:test-command '("make" "test")))
      (home-page "https://github.com/abo-abo/tiny")
      (synopsis "Quickly generate linear ranges in Emacs")
      (description
       "The main command of the @code{tiny} extension for Emacs is @code{tiny-expand}.
It is meant to quickly generate linear ranges, e.g. 5, 6, 7, 8.  Some elisp
proficiency is an advantage, since you can transform your numeric range with
an elisp expression.")
      (license license:gpl3+))))

(define-public emacs-taxy
  (package
    (name "emacs-taxy")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://elpa.gnu.org/packages/taxy-" version ".tar"))
       (sha256
        (base32
         "05czw8fkifb25rwl99dmncr1g0rjfx1bqijl7igqs9j6h9ia2xvg"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-magit))
    (home-page "https://github.com/alphapapa/taxy.el")
    (synopsis "Programmable taxonomical grouping for arbitrary objects")
    (description
     "Taxy provides a programmable way to classify arbitrary objects into
a hierarchical taxonomy.  Allows you to automatically put things in nested
groups.")
    (license license:gpl3+)))

(define-public emacs-taxy-magit-section
  (package
    (name "emacs-taxy-magit-section")
    (version "0.12.1")
    (source (origin
              (method url-fetch)
              (uri (string-append
                    "https://elpa.gnu.org/packages/taxy-magit-section-" version
                    ".tar"))
              (sha256
               (base32
                "0bs00y8pl51dji23zx5w64h6la0y109q0jv2q1nggizk6q5bsxmg"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-magit emacs-taxy))
    (home-page "https://github.com/alphapapa/taxy.el")
    (synopsis "View Taxy structs in a Magit Section buffer")
    (description
     "This library provides a way to view @code{taxy} structs in a column-based,
@code{magit-section} buffer.  Columns are defined using simple top-level
forms, and new columns may be easily defined by users in their
configurations.")
    (license license:gpl3+)))

(define-public emacs-emojify
  (package
    (name "emacs-emojify")
    (version "1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/iqbalansari/emacs-emojify")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1fqnj5x7ivjkm5y927dqqnm85q5hzczlb0hrfpjalrhasa6ijsrm"))))
    (build-system emacs-build-system)
    (arguments
     `(#:include (cons "^data/" %default-include)))
    (propagated-inputs
     (list emacs-ht))
    (home-page "https://github.com/iqbalansari/emacs-emojify")
    (synopsis "Display emojis in Emacs")
    (description "This package displays emojis in Emacs similar to how Github,
Slack, and other websites do.  It can display plain ASCII like @code{:)} as
well as Github-style emojis like @code{:smile:}.  It provides a minor mode
@code{emojify-mode} to enable the display of emojis in a buffer.")
    (license license:gpl3+)))

(define-public emacs-make-it-so
  (let ((commit "b73dfb640588123c9eece230ad72b37604f5c126")
        (revision "2"))
    (package
      (name "emacs-make-it-so")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/abo-abo/make-it-so")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0p6xhyinzzkrwzbpxqfm8hlii0ikvmmylya240bwsa77w0g1k6xq"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include (cons "^recipes/" %default-include)))
      (propagated-inputs
       (list emacs-ivy))
      (home-page "https://github.com/abo-abo/make-it-so")
      (synopsis "Transform files with Makefile recipes")
      (description "This package provides an interface for selecting from
different conversion recipes, often including tools like @code{ffmpeg} or
@code{convert}.  The conversion command need only be written once, and
subsequent invocations can be readily customized.  Several recipes are
included by default, and more can be readily added.")
      (license license:gpl3+))))

(define-public emacs-unidecode
  (let ((commit "5502ada9287b4012eabb879f12f5b0a9df52c5b7")
        (revision "1"))
    (package
      (name "emacs-unidecode")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sindikat/unidecode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "03x3nakbhmakwm977mwrf8jifvjnfwzpjv6wrwpizbqjnkgfchmn"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include (cons* "^tools/" "^data/" %default-include)
         #:tests? #t
         #:test-command '("emacs" "--batch"
                          "-l" "unidecode-test.el"
                          "-f" "ert-run-tests-batch-and-exit")
         #:phases
         (modify-phases %standard-phases
           (add-before 'check 'make-tests-writable
             (lambda _
               (make-file-writable "unidecode-test.el")
               #t))
           (add-before 'check 'add-require
             (lambda _
               (emacs-batch-edit-file "unidecode-test.el"
                 `(progn (progn (goto-char (point-min))
                                (re-search-forward
                                 "ert-deftest")
                                (forward-line -1)
                                (insert "(require 'unidecode)"))
                         (basic-save-buffer)))
               #t)))))
      (home-page "https://github.com/sindikat/unidecode")
      (synopsis "Transliterate Unicode text to ASCII")
      (description "This package provides functions for converting Unicode to ASCII.")
      (license license:gpl2+))))

(define-public emacs-pubmed
  (package
    (name "emacs-pubmed")
    (version "0.6.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/fvdbeek/emacs-pubmed")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "05j4nhn2bgacc54pvmkhwgdsmzxzkcfn49a12k43wckrrf3izbqf"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-deferred emacs-esxml emacs-s emacs-unidecode))
    (home-page "https://gitlab.com/fvdbeek/emacs-pubmed")
    (synopsis "Interface to PubMed")
    (description "This package provides an Emacs interface to the PubMed
database of references on life sciences.")
    (license license:gpl3+)))

(define-public emacs-websocket
  (package
    (name "emacs-websocket")
    (version "1.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "websocket-" version ".tar"))
       (sha256
        (base32 "1x664zswas0fpml7zaj59zy97avrm49zb80zd69rlkqzz1m45psc"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/websocket.html")
    (synopsis "Emacs WebSocket client and server")
    (description
     "This is an Elisp library for WebSocket clients to talk to WebSocket
servers, and for WebSocket servers to accept connections from WebSocket
clients.  This library is designed to be used by other library writers, to
write applications that use WebSockets, and is not useful by itself.")
    (license license:gpl3+)))

(define-public emacs-oauth2
  (package
    (name "emacs-oauth2")
    (version "0.16")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "oauth2-" version ".tar"))
       (sha256
        (base32 "1rzly2nwjywrfgcmp8zidbmjl2ahyd8l8507lb1mxm4xqryvf316"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/oauth2.html")
    (synopsis "OAuth 2.0 authorization protocol implementation")
    (description
     "This package provides an Elisp implementation of the OAuth 2.0 draft.
The main entry point is @code{oauth2-auth-and-store} which will return a token
structure.  This token structure can be then used with
@code{oauth2-url-retrieve-synchronously} or @code{oauth2-url-retrieve} to
retrieve any data that need OAuth authentication to be accessed.  If the token
needs to be refreshed, the code handles it automatically and stores the new
value of the access token.")
    (license license:gpl3+)))

(define-public emacs-auth-source-xoauth2
  (package
    (name "emacs-auth-source-xoauth2")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ccrusius/auth-source-xoauth2")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0nl859csl8xcd6ybpjj15ph8l8fxwkwf45kbylss68alkyf1rl3v"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ccrusius/auth-source-xoauth2")
    (synopsis "XOAuth2 authentication capabilities for Emacs auth-source")
    (description
     "This package adds XOAuth2 authentication capabilities to Emacs
auth-source.  This integration requires some preliminary work on the users’
part, which includes creating tokens.")
    (license license:asl2.0)))

(define-public emacs-circe
  (package
    (name "emacs-circe")
    (version "2.12")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jorgenschaefer/circe")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0lrxd4hanaxj85nafsc0wss677slmyaks3qb7a95mj7vic3ib937"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("buttercup" "-L" ".")
       #:emacs ,emacs                 ;requires gnutls
       #:phases
       (modify-phases %standard-phases
         ;; The HOME environment variable should be set to an existing
         ;; directory for the tests to succeed.
         (add-before 'check 'set-home
           (lambda _
             (setenv "HOME" "/tmp")))
         (add-before 'check 'remove-failing-tests
           (lambda _
             (make-file-writable "tests/test-circe.el")
             (emacs-batch-edit-file "tests/test-circe.el"
               `(progn
                 (dolist (test
                          '("should have circe-server-buffer set in the mode hook"
                            "should complete nicks with colon at the beginning of the input"
                            "should complete nicks without colon later in the input"))
                         (goto-char (point-min))
                         (search-forward (format "(it %S" test))
                         (beginning-of-line)
                         (kill-sexp))
                 (basic-save-buffer))))))))
    (native-inputs
     (list emacs-buttercup))
    ;; In order to securely connect to an IRC server using TLS, Circe requires
    ;; the GnuTLS binary.
    (propagated-inputs
     (list gnutls))
    (home-page "https://github.com/jorgenschaefer/circe")
    (synopsis "Client for IRC in Emacs")
    (description "Circe is a Client for IRC in Emacs.  It integrates well with
the rest of the editor, using standard Emacs key bindings and indicating
activity in channels in the status bar so it stays out of your way unless you
want to use it.")
    (license license:gpl3+)))

(define-public emacs-tracking
  (package
    (inherit emacs-circe)
    (name "emacs-tracking")
    (arguments
     ;; "tracking.el" is a library extracted from Circe package.  It requires
     ;; "shorten.el".
     `(#:include '("^shorten.el$" "^tracking.el$")
       ,@(package-arguments emacs-circe)))
    (home-page "https://github.com/jorgenschaefer/circe/wiki/Tracking")
    (synopsis "Buffer tracking library")
    (description "@code{tracking.el} provides a way for different modes to
notify the user that a buffer needs attention.  The user then can cycle
through them using @key{C-c C-SPC}.")
    (license license:gpl3+)))

(define-public emacs-slack
  (let ((commit "ff46d88726482211e3ac3d0b9c95dd4fdffe11c2")
        (revision "10"))
    (package
      (name "emacs-slack")
      (version (git-version "0.0.2" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/yuya373/emacs-slack")
                      (commit commit)))
                (file-name (git-file-name name commit))
                (sha256
                 (base32
                  "15g4dmy4iqqpk8ivhkpsngzllbw0nc5d2sc9j36sdnhwkajzhidj"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           ;; HOME needs to exist for source compilation.
           (add-before 'build 'set-HOME
             (lambda _ (setenv "HOME" "/tmp") #t)))))
      (propagated-inputs
       (list emacs-alert
             emacs-emojify
             emacs-helm
             emacs-request
             emacs-websocket
             emacs-oauth2
             emacs-circe))
      (home-page "https://github.com/yuya373/emacs-slack")
      (synopsis "Slack client for Emacs")
      (description "This package provides an Emacs client for the Slack
messaging service.")
      (license license:gpl3+))))

(define-public emacs-helm-slack
  (let ((commit "465f6220f3f5bee4d95492991fca1290c89534eb")
        (revision "1"))
    (package
      (name "emacs-helm-slack")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/yuya373/helm-slack")
                      (commit commit)))
                (file-name (git-file-name name commit))
                (sha256
                 (base32
                  "0p1s1kl8v68qjprqkf034cz911qzbqxbscqgpn0c3mbm3yfx81f7"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           ;; HOME needs to exist for source compilation.
           (add-before 'build 'set-HOME
             (lambda _ (setenv "HOME" "/tmp") #t)))))
      (propagated-inputs (list emacs-slack))
      (home-page "https://github.com/yuya373/helm-slack")
      (synopsis "Helm extension for emacs-slack")
      (description "This package provides an helm extension for emacs-slack
Slack client.")
      (license license:gpl3+))))

(define-public emacs-bash-completion
  ;; Need to use a newer commit than the latest version in order to support
  ;; completion interfaces that alters the candidate list provided by the
  ;; package
  (let ((commit "c5eaeed156ab906190c662d491269230967104b1")
        (revision "0"))
    (package
      (name "emacs-bash-completion")
      (version (git-version "3.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/szermatt/emacs-bash-completion")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0r221iirqsbz13s76r68i496izbirrvcw8ql3wsh205zmxa3jqg1"))))
      (inputs (list bash))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'make-git-checkout-writable
              (λ _
                (for-each make-file-writable (find-files "."))))
            (add-before 'install 'configure
              (lambda* (#:key inputs #:allow-other-keys)
                (emacs-substitute-variables "bash-completion.el"
                  ("bash-completion-prog"
                   (search-input-file inputs "/bin/bash"))))))))
      (home-page "https://github.com/szermatt/emacs-bash-completion")
      (synopsis "Bash completion for the shell buffer")
      (description
       "@code{bash-completion} defines dynamic completion hooks for shell-mode
  and shell-command prompts that are based on Bash completion.")
      (license license:gpl2+))))

(define-public emacs-easy-kill
  (package
    (name "emacs-easy-kill")
    (version "0.9.5")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/easy-kill-"
                                  version ".tar"))
              (sha256
               (base32
                "0h8rzd23sgkj3vxnyhis9iyq8n3xqp9x1mvxlm61s6wwj9j398j6"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/leoliu/easy-kill")
    (synopsis "Kill and mark things easily in Emacs")
    (description
     "This package provides commands @code{easy-kill} and @code{easy-mark} to
let users kill or mark things easily.")
    (license license:gpl3+)))

(define-public emacs-csv-mode
  (package
    (name "emacs-csv-mode")
    (version "1.21")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "csv-mode-" version ".tar"))
       (sha256
        (base32 "11f01lyz6i133njigg53r890cic8y13kz7dswc8mj7m60a316dmv"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/csv-mode.html")
    (synopsis "Major mode for editing comma/char separated values")
    (description
     "This Emacs package implements CSV mode, a major mode for editing records
in a generalized CSV (character-separated values) format.")
    (license license:gpl3+)))

(define-public emacs-transmission
  (package
    (name "emacs-transmission")
    (version "0.12.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/holomorph/transmission")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16bn8y2sd7kzihp8bxh4vyay16y91q3yc0gcd0bzywcx3hijqlfc"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/holomorph/transmission")
    (synopsis "Emacs interface to a Transmission session")
    (description "This package provides an Emacs interface to interact with a
running session of the Transmission Bittorrent client.

Features:

@itemize
@item List, add, start/stop, verify, remove torrents.
@item Set speed limits, ratio limits, bandwidth priorities, trackers.
@item Navigate to the corresponding file list, torrent info, peer info
contexts.
@item Toggle downloading and set priorities for individual files.
@end itemize\n")
    (license license:gpl3+)))

(define-public emacs-polymode
  (package
    (name "emacs-polymode")
    (version "0.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/polymode/polymode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "18ssl2h861dm2jkd3df6wkfr48p8zk337dbvpq5522kia7fq1lbn"))
       (patches
        ;; XXX: Cherry-picked from upstream, remove when bumping to 0.2.3.
        (search-patches "emacs-polymode-fix-lexical-variable-error.patch"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/polymode/polymode")
    (synopsis "Framework for multiple Emacs modes based on indirect buffers")
    (description
     "Polymode is an Emacs package that offers generic support for multiple
major modes inside a single Emacs buffer.  It is lightweight, object oriented
and highly extensible.  Creating a new polymode typically takes only a few
lines of code.  Polymode also provides extensible facilities for external
literate programming tools for exporting, weaving and tangling.")
    (license license:gpl3+)))

(define-public emacs-polymode-ansible
  (package
    (name "emacs-polymode-ansible")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/mavit/poly-ansible")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0f0yq6gmkp194nxk90ipprglf1xkmxrgz1rkgrhfslvxq4q2l81h"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-ansible-doc emacs-jinja2-mode emacs-polymode
           emacs-yaml-mode))
    (properties '((upstream-name . "poly-ansible")))
    (home-page "https://gitlab.com/mavit/poly-ansible/")
    (synopsis "Polymode for Ansible - Jinja2 in YAML")
    (description
     "Edit YAML files for Ansible containing embedded Jinja2 templating.")
    (license license:gpl3+)))

(define-public emacs-polymode-markdown
  (package
    (name "emacs-polymode-markdown")
    (version "0.2.2")
    (home-page "https://github.com/polymode/poly-markdown")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1q4qq0ql08hxkdrd2aal03560k612my7bvnfpfij3g432hn0p7v6"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-markdown-mode emacs-polymode))
    (properties '((upstream-name . "poly-markdown")))
    (synopsis "Polymode for Markdown mode")
    (description
     "This package allows editing source code blocks embedded in Markdown
files using the major mode corresponding to each block.")
    (license license:gpl3+)))

(define-public emacs-poly-noweb
  (package
    (name "emacs-poly-noweb")
    (version "0.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/polymode/poly-noweb")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jl5h4nf10xd2gdlsxi6h2n3z5zh26ffcixn68xfp5q4zl34zk8p"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-polymode))
    (home-page "https://github.com/polymode/poly-noweb")
    (synopsis "Polymode for noweb")
    (description
     "This package provides @code{poly-noweb-mode}, a polymode for noweb
files.")
    (license license:gpl3+)))

(define-public emacs-powershell
  ;; Tagged branch 0.1 is outdated (2015).
  (let ((revision "0")
        (commit "d1b3f95669343399f199f291ef76c09a0ede5e60"))
    (package
      (name "emacs-powershell")
      (build-system emacs-build-system)
      (version (git-version "0.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
	       (url "https://github.com/jschaf/powershell.el")
	       (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1cxhzaaig88zhylyycvb3849r85j1ijqklnh9zbqsfl2zhpb0g5c"))))
      (home-page "https://github.com/jschaf/powershell.el")
      (synopsis "Emacs mode for editing PowerShell scripts")
      (description
       "Powershell is an Emacs major mode for editing and running
Microsoft PowerShell files.")
      (license license:gpl3+))))

(define-public emacs-polymode-org
  (package
    (name "emacs-polymode-org")
    (version "0.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/polymode/poly-org")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1srnwcsn2bh8gqzxixkhffk7gbnk66kd4dgvxbnps5nxqc6v0qhc"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-polymode))
    (properties '((upstream-name . "poly-org")))
    (home-page "https://github.com/polymode/poly-org")
    (synopsis "Polymode definitions for Org mode buffers")
    (description
     "This package provides definitions for Polymode to support Org buffers.
It edits source blocks in an Org buffer using the native modes of the blocks'
languages while remaining inside the primary Org buffer.")
    (license license:gpl3+)))

(define-public eless
  (package
    (name "eless")
    (version "0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kaushalmodi/eless")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "01gpzg35v972ik4bimcyhqabjca6sjj41kw2i15xj1k33p4sjqpf"))))
    (build-system copy-build-system)
    (inputs
     (list bash emacs))
    (arguments
     `(#:install-plan
       '(("eless" "bin/")
         ("docs/eless.info" "share/info/")
         ("eless.org" ,(string-append "share/doc/eless-" version "/")))))
    (home-page "https://github.com/kaushalmodi/eless")
    (synopsis "Use Emacs as a paginator")
    (description "@code{eless} provides a combination of Bash script
and a minimal Emacs view-mode.

Features:

@itemize
@item Independent of a user’s Emacs config.
@item Customizable via the @code{(locate-user-emacs-file \"elesscfg\")} config.
@item Not require an Emacs server to be already running.
@item Syntax highlighting.
@item Org-mode file rendering.
@item @code{man} page viewer.
@item Info viewer.
@item Dired, wdired, (batch edit symbolic links).
@item Colored diffs, git diff, git log, ls with auto ANSI detection.
@item Filter log files lines matching a regexp.
@item Auto-revert log files similar to @code{tail -f}.
@item Quickly change frame and font sizes.
@end itemize\n")
    (license license:expat)))

(define-public emacs-evil-matchit
  (package
    (name "emacs-evil-matchit")
    (version "3.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/redguardtoo/evil-matchit")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0a55hhqi14g0hy80cfi5anxs44rcdxm1jkkyl561b4d4g823bpbi"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-evil))
    (home-page "https://github.com/redguardtoo/evil-matchit")
    (synopsis "Vim matchit ported into Emacs")
    (description
     "@code{evil-matchit} is a minor mode for jumping between matching tags in
evil mode using @kbd{%}.  It is a port of @code{matchit} for Vim.")
    (license license:gpl3+)))

(define-public emacs-evil-smartparens
  (package
    (name "emacs-evil-smartparens")
    (version "0.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/expez/evil-smartparens")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1di4qz5fbrlwbg16c2j0m7y8zqfxw027qd7zqmc3rwk9znbhg7wl"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-evil emacs-smartparens))
    (home-page "https://github.com/expez/evil-smartparens")
    (synopsis "Emacs Evil integration for Smartparens")
    (description "@code{emacs-evil-smartparens} is an Emacs minor mode which
makes Evil play nice with Smartparens.  Evil is an Emacs minor mode that
emulates Vim features and provides Vim-like key bindings.")
    (license license:gpl3+)))

(define-public emacs-evil-quickscope
  (package
    (name "emacs-evil-quickscope")
    (version "0.1.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/blorbx/evil-quickscope")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ja9ggj70wf0nmma4xnc1zdzg2crq9h1cv3cj7cgwjmllflgkfq7"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-evil))
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "--batch"
                        "-l" "evil-quickscope-tests.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/blorbx/evil-quickscope")
    (synopsis "Target highlighting for emacs evil-mode f,F,t and T commands")
    (description "@code{emacs-evil-quickscope} highlights targets for Evil
mode’s f,F,t,T keys, allowing for quick navigation within a line.  It is a
port of quick-scope for Vim.  Evil is an Emacs minor mode that emulates Vim
features and provides Vim-like key bindings.")
    (license license:gpl3+)))

(define-public emacs-bongo
  (package
    (name "emacs-bongo")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dbrock/bongo")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nszph9mn98flyhn1jq3y6mdh6jymjkvj5ng36ql016dj92apvhv"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/dbrock/bongo")
    (synopsis "Media player for Emacs")
    (description
     "This package provides a flexible media player for Emacs.  @code{Bongo}
supports multiple backends such as @code{vlc}, @code{mpg123},
@code{ogg123}, @code{speexdec}, @code{timidity}, @code{mikmod} and
@code{afplay}.")
    (license license:gpl2+)))

(define-public emacs-groovy-modes
  (package
    (name "emacs-groovy-modes")
    (version "2.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/Groovy-Emacs-Modes\
/groovy-emacs-modes")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1jpfyqnqd8nj0g8xbiw4ar2qzxx3pvhwibr6hdzhyy9mmc4yzdgk"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("ert-runner")))
    (native-inputs
     (list emacs-ert-runner emacs-undercover emacs-shut-up emacs-f))
    (propagated-inputs
     (list emacs-dash emacs-s))
    (home-page "https://github.com/Groovy-Emacs-Modes/groovy-emacs-modes")
    (synopsis "Groovy related modes for Emacs")
    (description "This package provides @code{groovy-mode} for syntax
highlighting in Groovy source files, REPL integration with run-groovy and
Grails project navigation with the grails mode.")
    (license license:gpl3+)))

(define-public emacs-jenkinsfile-mode
  (let ((commit "65bf3925852c35c6bd499978f08f83c1193f4347")
        (revision "1"))
    (package
      (name "emacs-jenkinsfile-mode")
      (version (git-version "0.0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/john2x/jenkinsfile-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0w38g88yykslg71xr99ff4vx1ffgy90b7xqvvdflr189gwk3avx1"))))
      (propagated-inputs
       (list emacs-groovy-modes))
      (build-system emacs-build-system)
      (home-page "https://github.com/john2x/jenkinsfile-mode/")
      (synopsis "Emacs major-mode for editing Jenkinsfile")
      (description "This package provides a @code{jenkinsfile-mode} derived
from @code{groovy-mode} for editing Jenkins declarative pipeline files.")
      (license license:gpl3+))))

(define-public emacs-kotlin-mode
  (let ((commit "0e4bafb31d1fc2a0a420a521c2723d5526646c0b")
        (revision "1"))
    (package
      (name "emacs-kotlin-mode")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Emacs-Kotlin-Mode-Maintainers/kotlin-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "09inpgwmnnqaakyn4r4xs8kax8b89dw94kvl521x6d43h9zl5i70"))))
      (build-system emacs-build-system)
      (arguments
       `(#:tests? #t
         #:test-command '("ert-runner" "-L" "." "-L" "test")))
      (native-inputs (list emacs-ert-runner))
      (home-page "https://github.com/Emacs-Kotlin-Mode-Maintainers/kotlin-mode")
      (synopsis "Major major-mode for editing Kotlin files")
      (description
       "This package provides a @code{kotlin-mode} for editing Kotlin files.")
      (license license:gpl3+))))

(define-public emacs-org-tree-slide
  (let ((commit "d6529bc2df727d09014e0e56abf4f15a8e8fc20f")
        (revision "0"))
    (package
      (name "emacs-org-tree-slide")
      (version (git-version "2.8.18" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/takaxp/org-tree-slide")
                      (commit commit)))
                (sha256
                 (base32
                  "1br32mpwarmrn158y2pkkmfl2ssv8q8spzknkg2avr16fil0j1pz"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (home-page "https://github.com/takaxp/org-tree-slide")
      (synopsis "Presentation tool for Org mode")
      (description
       "Org Tree Slide is a minor mode for using an Org document in
presentations by progressively revealing individual subtrees of the
document.")
      (license license:gpl3+))))

(define-public emacs-scratch-el
  (package
    (name "emacs-scratch-el")
    (version "1.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/emacs-weirdware/scratch")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "174d8ancnkgb7q62196kd6nrfib6rnwxw4visgbk1c6yd1w8kray"))))
    (build-system emacs-build-system)
    (native-inputs
     (list texinfo))
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'install 'install-doc
           (lambda* (#:key outputs #:allow-other-keys)
             (unless (invoke "makeinfo" "scratch.texi")
               (error "makeinfo failed"))
             (install-file "scratch.info"
                           (string-append (assoc-ref outputs "out")
                                          "/share/info"))
             #t)))))
    (home-page "https://codeberg.org/emacs-weirdware/scratch")
    (synopsis "Create scratch buffers with the same mode as current buffer")
    (description "Scratch is an extension to Emacs that enables one to create
scratch buffers that are in the same mode as the current buffer.  This is
notably useful when working on code in some language; you may grab code into a
scratch buffer, and, by virtue of this extension, do so using the Emacs
formatting rules for that language.")
    (license license:bsd-2)))

(define-public emacs-kv
  (package
    (name "emacs-kv")
    (version "0.0.19")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nicferrier/emacs-kv")
             (commit "721148475bce38a70e0b678ba8aa923652e8900e")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0r0lz2s6gvy04fwnafai668jsf4546h4k6zd6isx5wpk0n33pj5m"))
       (patches
        (search-patches "emacs-kv-fix-tests.patch"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "--batch" "-l" "kv-tests.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/nicferrier/emacs-kv")
    (synopsis "Key/Value data structures library for Emacs Lisp")
    (description "@code{emacs-kv} is a collection of tools for dealing with
key/value data structures such as plists, alists and hash-tables in Emacs
Lisp.")
    (license license:gpl3+)))

(define-public emacs-esxml
  (package
    (name "emacs-esxml")
    (version "0.3.7")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/tali713/esxml")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1xzxmgsg0j72sf1vjh9gjswz3c29js0kqhm7r3jrqrh3a5agdnml"))))
    (build-system emacs-build-system)
    (arguments
     `(#:emacs ,emacs                   ;need libxml
       ;; XXX: Only the two following files are meant to be packaged.
       ;; Byte-compiling the others Elisp files leads to build errors anyway.
       #:include (list "esxml.el" "esxml-query.el")))
    (propagated-inputs
     (list emacs-kv))
    (home-page "https://github.com/tali713/esxml/")
    (synopsis "SXML for EmacsLisp")
    (description "This is XML/XHTML done with S-Expressions in EmacsLisp.
Simply, this is the easiest way to write HTML or XML in Lisp.  This library
uses the native form of XML representation as used by many libraries already
included within Emacs.  See @code{esxml-to-xml} for a concise description of
the format.")
    (license license:gpl3+)))

(define-public emacs-nov-el
  (package
    (name "emacs-nov-el")
    (version "0.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://depp.brause.cc/nov.el.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "10507fdfx02wb3j7g34w4ii8rgnjbmriq63ir6x1agf38s3i9p52"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:emacs emacs                    ;need libxml
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'embed-path-to-unzip
            (lambda _
              (substitute* "nov.el"
                (("\\(executable-find \"unzip\"\\)")
                 (string-append "\"" (which "unzip") "\""))))))))
    (propagated-inputs
     (list emacs-dash emacs-esxml))
    (inputs
     (list unzip))
    (home-page "https://depp.brause.cc/nov.el/")
    (synopsis "Major mode for reading EPUBs in Emacs")
    (description "@code{nov.el} provides a major mode for reading EPUB
documents.

Features:

@itemize
@item Basic navigation (jump to TOC, previous/next chapter)
@item Remembering and restoring the last read position
@item Jump to next chapter when scrolling beyond end
@item Renders EPUB2 (@code{.ncx}) and EPUB3 (@code{<nav>}) TOCs
@item Hyperlinks to internal and external targets
@item Supports textual and image documents
@item View source of document files
@item Metadata display
@item Image rescaling
@end itemize
")
    (license license:gpl3+)))

(define-public epipe
  (package
    (name "epipe")
    (version "0.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cute-jumper/epipe")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0lkisi1s7sn12nx8zh58qmsxwnk1rjwryj18wcbr148xqz3swg57"))))
    (build-system trivial-build-system)
    (arguments
     `(#:modules
       ((guix build utils))
       #:builder
       (begin
         (use-modules (guix build utils))
         ;; Extract source.
         (copy-recursively (assoc-ref %build-inputs "source") "source")
         (chdir "source")
         ;; Patch shebangs.
         (substitute* "epipe"
           (("/usr/bin/env bash")
            (search-input-file %build-inputs "/bin/bash")))
         (patch-shebang "epipe.pl"
                        (list (string-append (assoc-ref %build-inputs "perl")
                                             "/bin")))
         ;; Install.
         (for-each (lambda (file)
                     (install-file file (string-append %output "/bin")))
                   '("epipe" "epipe.pl")))))
    (inputs
     (list bash perl))
    (home-page "https://github.com/cute-jumper/epipe")
    (synopsis "Pipe to the @code{emacsclient}")
    (description "@code{epipe} provides an utility to use your editor in
the pipeline, featuring the support for running @code{emacsclient}.")
    (license license:gpl3+)))

(define-public emacs-jupyter
  (package
    (name "emacs-jupyter")
    (version "0.8.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nnicandro/emacs-jupyter")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1sr007wsl2y6wqpzkmv3inbpwhvgdcb2nmqzgfg7w1awapi2r13p"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-company ;optional
           emacs-markdown-mode ;optional
           emacs-simple-httpd
           emacs-websocket
           emacs-zmq))
    (home-page "https://github.com/nnicandro/emacs-jupyter")
    (synopsis "Emacs interface to communicate with Jupyter kernels")
    (description "This package provides an Emacs interface to communicate with
Jupyter kernels.  It provides REPL and @code{org-mode} source code block
frontends to Jupyter kernels and kernel interactions integrated with Emacs'
built-in features.")
    (license license:gpl3+)))

(define-public emacs-hcl-mode
  (package
    (name "emacs-hcl-mode")
    (version "0.03")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-hcl-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0jqrgq15jz6pvx38pnwkizzfiih0d3nxqphyrc92nqpcyimg8b6g"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/syohex/emacs-hcl-mode")
    (synopsis "Major mode for the Hashicorp Configuration Language")
    (description
     "@code{emacs-hcl-mode} provides an Emacs major mode for working with
@acronym{HCL, Hashicorp Configuration Language}.  It provides syntax
highlighting and indentation support.")
    (license license:gpl3+)))

(define-public emacs-terraform-mode
  (package
    (name "emacs-terraform-mode")
    (version "0.06")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-terraform-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "05hn8kskx9lcgn7bzgam99c629zlryir2pickwrqndacjrqpdykx"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-hcl-mode))
    (home-page "https://github.com/syohex/emacs-terraform-mode")
    (synopsis "Major mode for Terraform")
    (description
     "@code{emacs-terraform-mode} provides a major mode for working with
@uref{https://www.terraform.io/, Terraform} configuration files.  Most of the
functionality is inherited from @code{hcl-mode}.")
    (license license:gpl3+)))

(define-public emacs-exec-path-from-shell
  (package
    (name "emacs-exec-path-from-shell")
    (version "1.12")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/exec-path-from-shell")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1ga8bpxngd3ph2hdiik92c612ki71qxw818i6rgx6f6a5r0sbf3p"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/exec-path-from-shell")
    (synopsis "Get environment variables such as @env{PATH} from the shell")
    (description
     "This library allows the user to set Emacs @code{exec-path} and @env{PATH}
from the shell's @env{PATH}, so that @code{shell-command}, @code{compile} and
the like work as expected on systems on which Emacs is not guaranteed to
inherit a login shell's environment variables.  It also allows other
environment variables to be retrieved from the shell, so that Emacs will see
the same values you get in a terminal.")
    (license license:gpl3+)))

(define-public emacs-frog-menu
  (package
    (name "emacs-frog-menu")
    (version "0.2.11")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "frog-menu-" version ".el"))
       (sha256
        (base32 "06iw11z61fd0g4w3562k3smcmzaq3nivvvc6gzm8y8k5pcrqzdff"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-avy emacs-posframe))
    (home-page "https://github.com/clemera/frog-menu")
    (synopsis "Quickly pick items from ad hoc menus")
    (description
     "This package provides a popup offering a preview of a list of candidates
on which user-defined dispatch actions can act.")
    (license license:gpl3+)))

(define-public emacs-frog-jump-buffer
  (let ((commit "2d7b342785ae27d45f5d252272df6eb773c78e20")
        (revision "1"))
    (package
      (name "emacs-frog-jump-buffer")
      (version (git-version "0.1.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/waymondo/frog-jump-buffer")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1z00by8hiss1r2lwmzrl8pnz6jykia2849dqqm4l3z5rf6lwvc0f"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash emacs-frog-menu emacs-avy))
      (home-page "https://github.com/waymondo/frog-jump-buffer")
      (synopsis "Jump to any Emacs buffer with minimal keystrokes")
      (description
       "This package provides a preview window of buffers that can be switched
to with quicklink-style selections.")
      (license license:gpl3+))))

(define-public emacs-deft
  (package
    (name "emacs-deft")
    (version "0.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jrblevin/deft")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0z7cilgiz6krvl5h2z72hkch43qxmypb0k6p5vxn5lx1p6v0mrf2"))))
    (build-system emacs-build-system)
    (home-page "https://jblevins.org/projects/deft/")
    (synopsis "Quickly browse, filter, and edit plain text notes")
    (description
     "Deft is an Emacs mode for quickly browsing, filtering, and editing
directories of plain text notes, inspired by Notational Velocity.")
    (license license:bsd-3)))

(define-public emacs-anzu
  (package
    (name "emacs-anzu")
    (version "0.64")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-anzu")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jfn5nm6r68wa0gn2k2zy6sdq6c8shw8x04ylzzm5cw7zm60jw0n"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/syohex/emacs-anzu")
    (synopsis "Show number of matches in mode-line while searching")
    (description
     "Anzu provides a minor mode which displays \"current match/total
matches\" in the mode line in various search modes.  This is an Emacs port of
Anzu.zim.")
    (license license:gpl3+)))

(define-public emacs-ascii-art-to-unicode
  (package
    (name "emacs-ascii-art-to-unicode")
    (version "1.13")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/ascii-art-to-unicode-"
                           version ".el"))
       (sha256
        (base32 "1c0jva3amhl9c5xc5yzdpi58c8m1djym4ccj31z6wmakq7npy07p"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/ascii-art-to-unicode.html")
    (synopsis "ASCII to Unicode art converter for Emacs")
    (description "This Emacs package provides the commands @command{aa2u} and
@command{aa2u-rectangle}.  Both of these commands can be used to convert
simple ASCII art line drawings to Unicode; the former works on the active
region of the buffer, while the latter works on rectangular selections.")
    (license license:gpl3+)))

(define-public emacs-emmet-mode
  (let ((commit "1acb821e0142136344ccf40c1e5fb664d7db2e70")
        (revision "1"))
    (package
      (name "emacs-emmet-mode")
      (version (git-version "1.0.8" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/smihica/emmet-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1p25h191bm0h5b3w5apg7wks51k7pb7h4dlww4jbl9ri4d33fzcl"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/smihica/emmet-mode")
      (synopsis "Unofficial Emmet's support for Emacs")
      (description
       "Unfold CSS-selector-like expressions to markup.  It is intended to be
used with SGML-like languages: XML, HTML, XHTML, XSL, etc.")
      (license license:gpl3+))))

(define-public emacs-ergoemacs-mode
  (package
    (name "emacs-ergoemacs-mode")
    (version "5.22.2.23")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ergoemacs/ergoemacs-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1ipwzl0l26g5qvc1sgmz2ra5vn1j3hl0mnkgzpa3j4p8gsmxdiqr"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-undo-tree))
    (home-page "https://ergoemacs.github.io/")
    (synopsis "Emacs mode based on common modern interface and ergonomics")
    (description
     "This package provides an efficient Emacs keybinding set based on
statistics of command frequency, and supports common shortcuts for open,
close, copy, cut, paste, undo, redo.")
    (license license:gpl3+)))

(define-public emacs-password-store
  (let ((commit "918992c19231b33b3d4a3288a7288a620e608cb4")
        (revision "1"))
    (package
      (name "emacs-password-store")
      ;; The emacs package version does not match the password-store version,
      ;; even though it is part of the same repository.  When updating, look
      ;; at the version declared in password-store.el.
      (version (git-version "2.1.4" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "git://git.zx2c4.com/password-store")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0ni62f4pq96g0i0q66bch1dl9k4zqwhg7xaf746k3gbbqxcdh3vi"))))
      (build-system emacs-build-system)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'extract-el-file
                   (lambda _
                     (copy-file "contrib/emacs/password-store.el"
                                "password-store.el")
                     (delete-file-recursively "contrib")
                     (delete-file-recursively "man")
                     (delete-file-recursively "src")
                     (delete-file-recursively "tests")))
                 (add-after 'extract-el-file 'patch-executables
                   (lambda* (#:key inputs #:allow-other-keys)
                     (emacs-substitute-variables "password-store.el"
                       ("password-store-executable"
                        (search-input-file inputs "/bin/pass"))))))))
      (inputs
       (list password-store))
      (propagated-inputs
       (list emacs-auth-source-pass emacs-s emacs-with-editor))
      (home-page "https://git.zx2c4.com/password-store/tree/contrib/emacs")
      (synopsis "Password store (pass) support for Emacs")
      (description
       "This package provides functions for working with pass (\"the
standard Unix password manager\").")
      (license license:gpl3+))))

(define-public emacs-password-store-otp
  (package
    (name "emacs-password-store-otp")
    (version "0.1.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/volrath/password-store-otp.el")
             (commit version)))
       (sha256
        (base32 "0gb48blvnn6ci2wl45z81p41ny7vbgl610hqy6b2hyr2171qjd60"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-password-store emacs-s))
    (home-page "https://github.com/volrath/password-store-otp.el")
    (synopsis
     "Interact with the @code{pass-otp} extension for @code{pass} from Emacs")
    (description "This package provides Emacs functions to interact with the
@code{pass-otp} extension for @code{pass}.  It includes functions to import
OTP URIs from screenshots of QR codes, and to export them back to QR codes if
needed.")
    (license license:gpl3+)))

(define-public emacs-auth-source-pass
  (let ((commit "847a1f54ed48856b4dfaaa184583ef2c84173edf")
        (revision "2"))
    (package
      (name "emacs-auth-source-pass")
      (version (git-version "5.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/DamienCassou/auth-password-store")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0g48z5w6n3c54zqfpx65dfyl9jqbl15idvbb1hhw2pd9f9r8fykk"))))
      (build-system emacs-build-system)
      (arguments
       `(#:tests? #t
         #:test-command '("emacs" "--batch"
                          "-L" "."
                          "-l" "test/auth-source-pass-tests.el"
                          "-f" "ert-run-tests-batch-and-exit")))
      (home-page "https://github.com/DamienCassou/auth-password-store")
      (synopsis "Integrate @code{auth-source} with @code{password-store}")
      (description "This package helps Emacs integrate with the Unix
@code{password-store} application.")
      (license license:gpl3+))))

(define-public emacs-pass
  (package
    (name "emacs-pass")
    (version "2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/NicolasPetton/pass")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0jc8j421mlflspg24jvrqc2n3y5n3cpk3hjy560il8g36xi1049p"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-password-store emacs-f))
    (home-page "https://github.com/NicolasPetton/pass")
    (synopsis "Major mode for @file{password-store.el}")
    (description "This is a major mode for managing password-store (pass)
keychains.  The keychain entries are displayed in a directory-like structure
and can be consulted and modified.")
    (license license:gpl3+)))

(define-public emacs-psc-ide
  ;; There is no proper release.  The base version is extracted from the
  ;; "Version" keyword in the main file.
  (let ((commit "ce97d719458ea099b40c02f05b6609601c727e66")
        (revision "2"))
    (package
      (name "emacs-psc-ide")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/purescript-emacs/psc-ide-emacs")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0xfw93pdf744h2yswc53qwyawfzkc31rv8dmha3irq7k1nklhq6y"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-company emacs-dash emacs-flycheck emacs-let-alist
             emacs-s))
      (home-page "https://github.com/purescript-emacs/psc-ide-emacs")
      (synopsis "Emacs integration for PureScript's psc-ide tool")
      (description
       "This package provices Emacs integration for @code{psc-ide}, an IDE
protocol for PureScript programming language.  It features:

@itemize
@item Completions
@item Type at point
@item Go to definition
@item Automatic imports
@item Case split
@item Build system integration, and
@item Flycheck support
@end itemize")
      (license license:gpl3+))))

(define-public emacs-evil-anzu
  (package
    (name "emacs-evil-anzu")
    (version "0.03")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-evil-anzu")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0lw7fg4gqwj30r0l6k2ni36sxqkf65zf0d0z3rxnpwbxlf8dlkrr"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-evil emacs-anzu))
    (home-page "https://github.com/syohex/emacs-evil-anzu")
    (synopsis "Anzu for evil-mode")
    (description "@code{anzu} provides a minor mode that displays the current
match and total match information in the mode-line in various search modes.")
    (license license:gpl3+)))

(define-public emacs-pg
  (package
    (name "emacs-pg")
    (version "0.19")
    (source (origin
              (method git-fetch)
              (uri (git-reference (url "https://github.com/emarsden/pg-el")
                                  (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "13fkkpimhxh91hmsp551wzrdcic5ws7wj7vjwnh8l83hsrxmxz0y"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emarsden/pg-el")
    (synopsis "Emacs Lisp interface for PostgreSQL")
    (description
     "This module lets you access the PostgreSQL object-relational DBMS from
Emacs, using its socket-level frontend/backend protocol.  The module is
capable of automatic type coercions from a range of SQL types to the
equivalent Emacs Lisp type.  This is a low level API, and won't be useful to
end users.")
    (license license:gpl2+)))

(define-public emacs-finalize
  (package
  (name "emacs-finalize")
  (version "2.0.0")
  (source
    (origin
      (method git-fetch)
      (uri (git-reference
            (url "https://github.com/skeeto/elisp-finalize")
            (commit version)))
      (file-name (git-file-name name version))
      (sha256
        (base32 "1gvlm4i62af5jscwz0jccc8ra0grprxpg2rlq91d5nn8dn5lpy79"))))
  (build-system emacs-build-system)
  (home-page "https://github.com/skeeto/elisp-finalize")
  (synopsis "Finalizers for Emacs Lisp")
  (description
    "This package runs a callback (a finalizer)
after its registered lisp object has been garbage collected.  This allows
extra resources, such as buffers and processes, to be cleaned up after the
object has been freed.")
  (license license:unlicense)))

(define-public emacs-emacsql
  (package
    (name "emacs-emacsql")
    (version "3.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/skeeto/emacsql")
             (commit (string-append version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1xpmji2qgr9r38cdhws65x9s9jy7fk93q8g1j2fm7j8kcfjh9x3g"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:modules '((guix build emacs-build-system)
                  (guix build utils)
                  (guix build emacs-utils)
                  (srfi srfi-26))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'patch-elisp-shell-shebangs
            (lambda _
              (substitute* (find-files "." "\\.el")
                (("/bin/sh") (which "sh")))))
          (add-after 'patch-elisp-shell-shebangs 'setenv-shell
            (lambda _
              (setenv "SHELL" "sh")))
          (add-after 'setenv-shell 'build-emacsql-sqlite
            (lambda _
              (invoke "make" "binary" (string-append "CC=" #$(cc-for-target)))))
          (add-after 'build-emacsql-sqlite 'install-emacsql-sqlite
            ;; This build phase installs emacs-emacsql binary.
            (lambda _
              (install-file "sqlite/emacsql-sqlite"
                            (string-append #$output "/bin"))))
          (add-after 'install-emacsql-sqlite 'patch-emacsql-sqlite.el
            ;; This build phase removes interactive prompts
            ;; and makes sure Emacs look for binaries in the right places.
            (lambda _
              (emacs-substitute-variables "emacsql-sqlite.el"
                ("emacsql-sqlite-executable"
                 (string-append #$output "/bin/emacsql-sqlite"))
                ;; Make sure Emacs looks for ‘GCC’ binary in the right place.
                ("emacsql-sqlite-c-compilers"
                 `(list ,(which "gcc")))))))))
    (inputs
     (list emacs-minimal `(,mariadb "dev") `(,mariadb "lib") postgresql))
    (propagated-inputs
     (list emacs-finalize emacs-pg))
    (home-page "https://github.com/skeeto/emacsql")
    (synopsis "Emacs high-level SQL database front-end")
    (description "Any readable Lisp value can be stored as a value in EmacSQL,
including numbers, strings, symbols, lists, vectors, and closures.  EmacSQL
has no concept of @code{TEXT} values; it's all just Lisp objects.  The Lisp
object @code{nil} corresponds 1:1 with @code{NULL} in the database.")
    (license license:gpl3+)))

(define-public emacs-emacsql-sqlite3
  (package
    (name "emacs-emacsql-sqlite3")
    (version "1.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cireu/emacsql-sqlite3")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jzvvsvi8jm2ws3y49nmpmwd3zlvf8j83rl2vwizd1aplwwdnmd6"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "-Q" "--batch" "-L" "."
                        "--load" "emacsql-sqlite3-test.el"
                        "-f" "ert-run-tests-batch-and-exit")
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'embed-path-to-sqlite3
           (lambda _
             (substitute* "emacsql-sqlite3.el"
               (("\\(executable-find \"sqlite3\"\\)")
                (string-append "\"" (which "sqlite3") "\""))))))))
    (native-inputs
     (list emacs-ert-runner))
    (inputs
     (list sqlite))
    (propagated-inputs
     (list emacs-emacsql))
    (home-page "https://github.com/cireu/emacsql-sqlite3")
    (synopsis "EmacSQL backend for SQLite")
    (description "This is yet another EmacSQL backend for SQLite which uses
official @command{sqlite3} executable to access SQL database.")
    (license license:gpl3+)))

(define-public emacs-closql
  (package
    (name "emacs-closql")
    (version "1.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacscollective/closql")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1s9riibws28xjn2bjn9qz3m2gvcmrn18b7g5y6am4sy7rgkx3nwx"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-emacsql))
    (home-page "https://github.com/emacscollective/closql")
    (synopsis "Store EIEIO objects using EmacSQL")
    (description
     "This package stores uniform EIEIO objects in an EmacSQL
database.  SQLite is used as backend.  This library imposes some restrictions
on what kind of objects can be stored; it isn't intended to store arbitrary
objects.  All objects have to share a common superclass and subclasses cannot
add any additional instance slots.")
    (license license:gpl3)))

(define-public emacs-epkg
  (package
    (name "emacs-epkg")
    (version "3.3.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacscollective/epkg")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0d09ddlhvgp8rpybqmzvzpzdp1hjaq97wp2br4g90lpx2vclkgn7"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'install 'make-info
           ;; Documentation is located in "docs/".
           (lambda* (#:key outputs #:allow-other-keys)
             (with-directory-excursion "docs"
               (invoke "makeinfo" "-o" "epkg.info" "epkg.texi")
               (let ((info (string-append (assoc-ref outputs "out")
                                          "/share/info")))
                 (install-file "epkg.info" info)))))
         (add-after 'make-info 'move-to-lisp-directory
           ;; Source code is located in "lisp/".
           (lambda _
             (chdir "lisp")))
         (add-after 'expand-load-path 'add-el-dir-to-emacs-load-path
           (lambda _
             (setenv "EMACSLOADPATH"
                     (string-append (getcwd)
                                    "/lisp:"
                                    (getenv "EMACSLOADPATH"))))))))
    (native-inputs
     (list texinfo))
    (propagated-inputs
     (list emacs-closql emacs-dash))
    (home-page "https://emacsmirror.net")
    (synopsis "Browse the Emacsmirror package database")
    (description "This package provides access to a local copy of the
Emacsmirror package database.  It provides low-level functions for querying
the database and a @file{package.el} user interface for browsing the database.
Epkg itself is not a package manager.")
    (license license:gpl3+)))

(define-public emacs-elisp-slime-nav
  (package
    (name "emacs-elisp-slime-nav")
    (version "0.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/elisp-slime-nav")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08k4zlawjkb0ldn4lgrhih8nzln398x7dwzpipqfyrmp0xziywma"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/elisp-slime-nav")
    (synopsis "Make @code{M-.} and @code{M-,} work for elisp like they do in SLIME")
    (description
     "This package provides SLIME's convenient @code{M-.}and @code{M-,} navigation
in @code{emacs-lisp-mode}, together with an elisp equivalent of
@code{slime-describe-symbol}.")
    (license license:gpl3+)))

(define-public emacs-dedicated
  (package
    (name "emacs-dedicated")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/dedicated")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0pba9s0h37sxyqh733vi6k5raa4cs7aradipf3826inw36jcw414"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacsorphanage/dedicated")
    (synopsis "Emacs minor mode for toggling a windows's \"dedicated\" flag")
    (description
     "This simple Emacs minor mode allows you to toggle a window's
\"dedicated\" flag.  When a window is \"dedicated\", Emacs will not select
files into that window.  This can be quite handy since many commands will use
another window to show results (compilation mode, starting info, and so on).
A dedicated window won't be used for such a purpose.  For details, please read
the source file.")
    (license license:gpl2+)))

(define-public emacs-nnreddit
  (let ((commit "9843f99d01fd8f1eea2fc685965a7c7f4eeb187a")
        (revision "1"))
    (package
      (name "emacs-nnreddit")
      (version (string-append "0.0.1-" revision "."
                              (string-take commit 7)))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/paul-issartel/nnreddit")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0j4h3bnga640250jdq8bwyja49r41ssrsjd6lba4gzzllqk02nbn"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/paul-issartel/nnreddit")
      (synopsis "Reddit backend for the Gnus newsreader")
      (description "@url{https://www.reddit.com} backend for the Gnus
newsreader.")
      (license license:gpl3+))))

(define-public emacs-makey
  (package
    (name "emacs-makey")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mickeynp/makey")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1rr7vpm3xxzcaam3m8xni3ajy8ycyljix07n2jzczayri9sd8csy"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/mickeynp/makey")
    (synopsis "Emacs interactive command-line mode")
    (description
     "This package provides an Emacs interactive command-line mode.")
    (license license:gpl3+)))

(define-public emacs-outorg
  (let ((commit "78b0695121fb974bc4e971eb4ef7f8afd6d89d64"))
    (package
      (name "emacs-outorg")
      (version (git-version "2.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alphapapa/outorg")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "03aclh4m3f7rb821gr9pwvnqkkl91px3qxdcarpf3ypa1x4fxvlj"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/alphapapa/outorg")
      (synopsis "Org-style comment editing")
      (description "Outorg is for editing comment-sections of source-code
files in temporary Org-mode buffers.  It turns conventional
literate-programming upside-down in that the default mode is the
programming-mode, and special action has to be taken to switch to the
text-mode (i.e. Org-mode).")
      (license license:gpl3+))))

(define-public emacs-outshine
  (package
    (name "emacs-outshine")
    (version "3.0.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/alphapapa/outshine")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1lh9f5dgdbwfyzxk6nsg1xwdjs8gc6p9mbyyhp6f8fnk3h0y88cg"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-outorg))
    (home-page "https://github.com/alphapapa/outshine")
    (synopsis "Emacs outline with outshine")
    (description "Outshine attempts to bring the look and feel of
@code{org-mode} to an Emacs outside of the Org major-mode.  It is an extension
of @code{outline-minor-mode} (@code{org-mode} itself derives from
outline-mode), so there is no such thing like an outshine mode, only
@code{outline-minor-mode} with outshine extensions loaded.")
    (license license:gpl3+)))

(define-public emacs-frecency
  (let ((commit "31ef9ff4af1a4fed3dcc24ea74037feea8795c87")
        (version "0.1-pre")
        (revision "1"))
    (package
      (name "emacs-frecency")
      (version (git-version version revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/alphapapa/frecency.el")
                      (commit commit)))
                (sha256
                 (base32
                  "051aihjdg3x22svaxhwylpi8i6s2x9j8syvsj1jgilgjjdy15l6j"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-a emacs-dash))
      (home-page "https://github.com/alphapapa/frecency.el")
      (synopsis "Sort items by frequency and recency of access")
      (description "This package provides a way of sorting items via
a heuristic based on frequency and recency.")
      (license license:gpl3+))))

(define-public emacs-org-recent-headings
  (let ((commit "97418d581ea030f0718794e50b005e9bae44582e")
        (revision "0"))
    (package
      (name "emacs-org-recent-headings")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alphapapa/org-recent-headings")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1y11rlnhi36lzhc1cagninv6hlcwbvj88xfr0g0xzpbzy7hys021"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash emacs-frecency emacs-helm emacs-org emacs-s))
      (home-page "https://github.com/alphapapa/org-recent-headings")
      (synopsis "Navigate to recently used Org headings and lists")
      (description
       "This package maintains a list of recently used Org headings,
as well as functions for navigating between these headings.")
      (license license:gpl3+))))

(define-public emacs-org-super-agenda
  (package
    (name "emacs-org-super-agenda")
    (version "1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alphapapa/org-super-agenda")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10l9h2n09cql4ih7nc0ma3ghdsq9l5v9xlj1lg7kq67icdwjlsvy"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #f                  ;FIXNE: Tests try to read "~/org/test.org"
       #:test-command '("test/run" "--debug")
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'prepare-for-tests.el
           (lambda _
             (make-file-writable "test/test.el")
             (emacs-substitute-variables "test/test.el"
               ("org-super-agenda-test-results-file"
                (string-append (getcwd) "/test/results.el")))
             ;; The following tests fail (see:
             ;; https://github.com/alphapapa/org-super-agenda/issues/183).
             (substitute* "test/test.el"
               ((".*org-super-agenda-test--:auto-(map|tags).*" all)
                (string-append all "  (skip-unless nil)\n"))))))))
    (native-inputs
     (list emacs-f util-linux))
    (propagated-inputs
     (list emacs-dash emacs-ht emacs-org emacs-s emacs-ts))
    (home-page "https://github.com/alphapapa/org-super-agenda")
    (synopsis "Supercharged Org agenda")
    (description "This package allows items in the Org agenda to be grouped
into sections while preserving the structure imposed by any timestamps.")
    (license license:gpl3+)))

(define-public emacs-elegant-agenda-mode
  (let ((commit "c72f42e0f551c3dd81e68262f07a96c0ec90a589")
        (revision "1"))
    (package
      (name "emacs-elegant-agenda-mode")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/justinbarclay/elegant-agenda-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0f8qk3vd41ffbkfqw5nks3bld0qpjrlnk9sb46wcbsyfnrs2v082"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/justinbarclay/elegant-agenda-mode")
      (synopsis "Elegant theme for your org-agenda")
      (description
       "The elegant-agenda-mode package uses fonts and typography to give your
org-agenda some breathing room and elegance.  This package was inspired by the
work Nicolas Rougier.")
      (license license:gpl3+))))

(define-public emacs-org-make-toc
  (package
    (name "emacs-org-make-toc")
    (version "0.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/alphapapa/org-make-toc")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "180ji6nnj6qj0rs1rdp1zlcrfsqf7ikb44ym8icbp5d6al2s4hnr"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-org emacs-dash emacs-s))
    (home-page "https://github.com/alphapapa/org-make-toc")
    (synopsis "Maintain a table of contents for an Org file")
    (description "This package facilitates the creation and maintenance of
tables of contents.")
    (license license:gpl3+)))

(define-public emacs-ts
  ;; XXX: Upstream did not tag last release.  Use commit matching version
  ;; bump.
  (let ((commit "552936017cfdec89f7fc20c254ae6b37c3f22c5b"))
    (package
      (name "emacs-ts")
      (version "0.3")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alphapapa/ts.el")
               (commit commit)))
         (sha256
          (base32 "18lif159zndl19ddz9rfq12l90770858yasfns21ryl1yrq3aifr"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (arguments
       ;; XXX: Three tests are failing because of a timezone-related issue
       ;; with how they're written.  On my machine, all the failing test
       ;; results are 18000 seconds (5 hours) off.

       ;; The ts-parse-org function accepts a string without any timezone
       ;; info, not assumed to be in Unix time, and converts it to a so-called
       ;; ts struct.  The ts-unix function (accessor) accepts a ts struct,
       ;; then seems to assume the struct's corresponding time is in terms of
       ;; the user's current time zone, before returning a Unix time in
       ;; seconds.

       ;; The failing tests all have similar problems, but nothing else about
       ;; the library seems particularly off.
       (list
        #:tests? #t
        #:test-command #~(list "emacs" "--batch"
                               "-l" "test/test.el"
                               "-f" "ert-run-tests-batch-and-exit")
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'make-tests-writable
              (lambda _
                (make-file-writable "test/test.el")))
            (add-before 'check 'delete-failing-tests
              (lambda _
                (emacs-batch-edit-file "test/test.el"
                  `(progn
                    (goto-char (point-min))
                    (dolist (test-regexp
                             '("ert-deftest ts-fill"
                               "ert-deftest ts-format"
                               "ert-deftest ts-parse-org\\_>"
                               "ert-deftest ts-parse-org-element"))
                            (re-search-forward test-regexp)
                            (beginning-of-line)
                            (kill-sexp)
                            (goto-char (point-min)))
                    (basic-save-buffer))))))))
      (propagated-inputs
       (list emacs-dash emacs-s))
      (home-page "https://github.com/alphapapa/ts.el")
      (synopsis "Timestamp and date/time library")
      (description "This package facilitates manipulating dates, times, and
timestamps by providing a @code{ts} struct.")
      (license license:gpl3+))))

(define-public emacs-circadian
  (package
    (name "emacs-circadian")
    (version "0.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/guidoschmidt/circadian.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0wpsykmai3idz0bgfl07hwl9nr4x9sgprvqgw8jln4dz2wf5gdic"))))
    (arguments
     (list
      #:tests? #t
      #:test-command #~(list "ert-runner")))
    (build-system emacs-build-system)
    (native-inputs
     (list emacs-el-mock emacs-ert-runner))
    (home-page "https://github.com/guidoschmidt/circadian.el")
    (synopsis "Theme-switching for Emacs based on daytime")
    (description "Circadian may reduce eye strain by automatically switching
between light and dark themes based on daytime.  It is inspired by color
temperature shifting tools and brightness adaption software.")
    ;; The LICENSE file is expat, but the sole ".el" file is explicitly GPL3+.
    (license (list license:gpl3+
                   license:expat))))

(define-public emacs-peg
  (package
    (name "emacs-peg")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/peg-" version ".tar"))
       (sha256
        (base32 "0skr5dz9k34r409hisnj37n1b7n62l3md0glnfx578xkbmxlpcxl"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/peg.html")
    (synopsis "Parsing Expression Grammars in Elisp")
    (description "This package provides a macro that parses the current buffer
according to a parsing expression grammar.")
    (license license:gpl3+)))

(define-public emacs-eldev
  (package
    (name "emacs-eldev")
    (version "1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/doublep/eldev")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "112jv9rz6brglffwsablnhafhhnfnq89k9vh8xzbbi6i4xz2l1ak"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #t
      #:test-command #~(list "./bin/eldev" "-p" "-dtTC" "test")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'prepare-for-tests
            (lambda _
              (setenv "ELDEV_LOCAL" (getcwd))
              (make-file-writable "test/project-i/project-i-autoloads.el")))
          (add-after 'unpack 'skip-failing-tests
            ;; FIXME: 2 tests are failing.  Skip them for now.
            (lambda _
              (delete-file "test/upgrade-self.el")))
          (add-after 'install 'install-eldev-executable
            ;; This constructs the eldev executable from templates and
            ;; installs it in the specified directory.
            (lambda _
              (let ((bin (string-append #$output "/bin"))
                    (site-lisp (elpa-directory #$output)))
                (mkdir-p bin)
                (setenv "HOME" (getcwd))
                (invoke "./install.sh" bin)
                (substitute* (string-append bin "/eldev")
                  ;; Point ELDEV_LOCAL to the installation directory so that
                  ;; eldev doesn't try to bootstrap itself from MELPA when
                  ;; invoked.
                  (("export ELDEV_EMACS.*" all)
                   (string-append "export ELDEV_LOCAL=" site-lisp "\n" all)))))))))
    (native-inputs
     (list texinfo))                    ;for tests
    (home-page "https://github.com/doublep/eldev/")
    (synopsis "Emacs-based build tool for Elisp")
    (description "Eldev (Elisp Development Tool) is an Emacs-based build tool,
targeted solely at Elisp projects.  It is an alternative to Cask.  Unlike
Cask, Eldev itself is fully written in Elisp and its configuration files are
also Elisp programs.  For those familiar with the Java world, Cask can be seen
as a parallel to Maven — it uses project description, while Eldev is sort of a
parallel to Gradle — its configuration is a program on its own.")
    (license license:gpl3+)))

(define-public emacs-with-simulated-input
  (package
    (name "emacs-with-simulated-input")
    (version "3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/DarwinAwardWinner/with-simulated-input")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0n8h84whsh0aph8xhn9plprix9f6bysgvarz2anz7kwns19js6s4"))))
    (build-system emacs-build-system)
    (arguments
     ;; The test suite fails with error: "Spies can only be created in
     ;; ‘before-each’".
     `(#:tests? #f
       #:test-command '("buttercup" "-L" ".")))
    (native-inputs
     (list emacs-buttercup emacs-undercover))
    (propagated-inputs
     (list emacs-s))
    (home-page "https://github.com/DarwinAwardWinner/with-simulated-input")
    (synopsis "Non-interactive testing Emacs library")
    (description "This package provides an Emacs Lisp macro,
@code{with-simulated-input}, which evaluates one or more forms while
simulating a sequence of input events for those forms to read.  The result is
the same as if a user had evaluated the forms and then manually typed in the
same input.  This macro is useful for non-interactive testing of normally
interactive commands and functions, such as @code{completing-read}.")
    (license license:gpl3+)))

(define-public emacs-org-ql
  (package
    (name "emacs-org-ql")
    (version "0.6.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/alphapapa/org-ql")
                    (commit version)))
              (sha256
               (base32
                "0iamqv5j43ngj1xdqr36rkgk9lqpk9bg8y531jsldnvwzrp3srpf"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash
           emacs-f
           emacs-helm
           emacs-helm-org
           emacs-org
           emacs-org-super-agenda
           emacs-ov
           emacs-peg
           emacs-ts
           emacs-s))
    (native-inputs
     (list emacs-buttercup emacs-with-simulated-input))
    (arguments
     `(#:tests? #t
       #:test-command '("buttercup" "-L" ".")))
    (home-page "https://github.com/alphapapa/org-ql/")
    (synopsis "Query language for Org buffers")
    (description "This package provides a Lispy query language for Org
files, allowing for actions to be performed based on search criteria.")
    (license license:gpl3+)))

(define-public emacs-bing-dict
  (package
    (name "emacs-bing-dict")
    (version "0.2.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/cute-jumper/bing-dict.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1kn8kmljn0pj0hz7dj7r7nxw43xd6acndaqq92d02mla12hiqayz"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/cute-jumper/bing-dict.el")
    (synopsis "Minimalist Bing dictionary interface in Emacs")
    (description
     "This package provides a minimalist Emacs extension to search
@uref{http://www.bing.com/dict}.  It supports English to Chinese, and
Chinese to English.")
    (license license:gpl3+)))

(define-public emacs-org-auto-tangle
  (package
    (name "emacs-org-auto-tangle")
    (version "0.6.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/yilkalargaw/org-auto-tangle")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1kn1jsbv97ps280lcdx19d6hs7pvz7q9ng67xlb1kwjb680pa7rl"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-async))
    (home-page "https://github.com/yilkalargaw/org-auto-tangle")
    (synopsis "Automatically tangle code blocks on save")
    (description
     "@code{org-auto-tangle} allows you to automatically tangle code blocks
whenever saving an @code{org-mode} file.")
    (license license:bsd-2)))

(define-public emacs-org-auto-expand
  (let ((commit "4938d5f6460e2f8f051ba9ac000b291bfa43ef62")
        (revision "1"))
    (package
      (name "emacs-org-auto-expand")
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/alphapapa/org-auto-expand")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1my0c6xmkh37lwi6l472lz9d86lf20h6xcllzlxm1lxa24rhva6v"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-org emacs-dash))
      (home-page "https://github.com/alphapapa/org-auto-expand")
      (synopsis "Automatically expand certain Org headings")
      (description "This package allows a customizable set of headings in Org
files to be expanded upon opening them.")
      (license license:gpl3+))))

(define-public emacs-parsebib
  (package
    (name "emacs-parsebib")
    (version "4.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joostkremers/parsebib")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0vcl2wvxwpr62c9ym0fm3qaxzhjcrpk4r6r0zaqhkvlf8qr3rg8y"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/joostkremers/parsebib")
    (synopsis "Library for parsing @file{.bib} files")
    (description
     "This package provides an Emacs library for parsing @file{.bib} files.")
    (license license:gpl3+)))

(define-public emacs-ebib
  (package
    (name "emacs-ebib")
    (version "2.39.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joostkremers/ebib")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1azgsjf5j8k6llq74brykidcb2mnq6fghk8jyq7qad5afh7n0mrc"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-biblio emacs-ivy emacs-parsebib))
    (home-page "https://joostkremers.github.io/ebib/")
    (synopsis "BibTeX database manager for Emacs")
    (description
     "Ebib is a BibTeX database manager that runs in GNU Emacs.
With Ebib you can create, sort and manage your @file{.bib} database files, all
within Emacs.  It supports searching, multi-line field values and
@samp{@@String} and @samp{@@Preamble} definitions.  Ebib integrates
with (La)TeX mode, Org mode and other Emacs editing modes.")
    ;; The Ebib source files are released under a BSD license with
    ;; the exception of org-ebib.el, which is released under the GNU
    ;; GPL.
    (license (list license:bsd-3
                   license:gpl3+))))

(define-public emacs-biblio
  (package
    (name "emacs-biblio")
    (version "0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cpitclaudel/biblio.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gxjind6r235az59dr8liv03d8994mqb8a7m28j3c12q7p70aziz"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-let-alist))
    (home-page "https://github.com/cpitclaudel/biblio.el")
    (synopsis "Browse and import bibliographic references")
    (description "This package provides an extensible Emacs package for
browsing and fetching references.

@file{biblio.el} makes it easy to browse and gather bibliographic references
and publications from various sources, by keywords or by DOI.  References are
automatically fetched from well-curated sources, and formatted as BibTeX.")
    (license license:gpl3+)))

(define-public emacs-citar
  (package
    (name "emacs-citar")
    (version "1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/bdarcus/citar")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1n69lkp7298gasm9hlbx9nhgp9ggh8w8ffyvi1rmbj96lcnpsyi9"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-before 'build 'set-home
                    (lambda _
                      (setenv "HOME" "/tmp"))))))
    (propagated-inputs (list emacs-auctex
                             emacs-citeproc-el
                             emacs-embark
                             emacs-org
                             emacs-parsebib
                             emacs-s))
    (home-page "https://github.com/bdarcus/citar")
    (synopsis "Emacs package to quickly find and act on bibliographic entries")
    (description
     "This package provides a completing-read front-end to browse and
act on BibTeX, BibLaTeX, and CSL JSON bibliographic data, and LaTeX,
markdown, and Org cite editing support.

When used with Vertico (or Selectrum), Embark, and Marginalia, it
provides similar functionality to helm-bibtex and ivy-bibtex: quick
filtering and selecting of bibliographic entries from the minibuffer,
and the option to run different commands against them.

With Embark, it also makes available at-point actions in Org
citations.")
    (license license:gpl3+)))

(define-public emacs-citar-org-roam
  (package
    (name "emacs-citar-org-roam")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-citar/citar-org-roam")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ldfs7g7ixnrwj23draiph4vy6xq7qgw18vhi7vbw6wvkh9fcv9r"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-org-roam emacs-citar))
    (home-page "https://github.com/emacs-citar/citar-org-roam")
    (synopsis "Emacs package to provide tighter Citar and Org-Roam integration")
    (description "\
Out-of-box, Citar provides default support for file-per-note bibliographic
notes that are compatible with Org-Roam v2.  This package integrates directly
with the Org-Roam database, and provides the following additional features to
Citar note support:
@itemize
@item multiple references per note
@item multiple reference notes per file
@item ability to query note citations by reference
@item ``live'' updating of Citar UI for presence of notes
@end itemize")
    (license license:gpl3)))

(define-public emacs-helm-bibtex
  (let ((commit "aa775340ba691d2322948bfdc6a88158568a1399")
        (revision "3"))
    (package
      (name "emacs-helm-bibtex")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tmalsburg/helm-bibtex")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1d3mc17ga09m41i06khghlvixr6gsiacifnhdbrfnp0w5592aprk"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-helm
             emacs-parsebib
             emacs-s
             emacs-dash
             emacs-f
             emacs-biblio
             emacs-ivy))
      (home-page "https://github.com/tmalsburg/helm-bibtex")
      (synopsis "Bibliography manager based on Helm")
      (description "This package provides bibliography manager for Emacs,
based on Helm and the bibtex-completion backend.

Key features:

@itemize
@item Quick access to your bibliography from within Emacs
@item Powerful search capabilities
@item Provides instant search results as you type
@item Tightly integrated with LaTeX authoring, emails, Org mode, etc.
@item Open the PDFs, URLs, or DOIs associated with an entry
@item Insert LaTeX cite commands, Ebib links, or Pandoc citations,
BibTeX entries, or plain text references at point, attach PDFs to emails
@item Support for note taking
@item Quick access to online bibliographic databases such as Pubmed,
arXiv, Google Scholar, Library of Congress, etc.
@item Imports BibTeX entries from CrossRef and other sources.
@end itemize\n")
      (license license:gpl3+))))

(define-public emacs-ewmctrl
  (package
    (name "emacs-ewmctrl")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/flexibeast/ewmctrl")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0ilwvx0qryv3v6xf0gxqwnfm6pf96gxap8h9g3f6z6lk9ff4n1wi"))))
    (build-system emacs-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-ewmctrl
           ;; This build phase makes sure ‘ewmctrl’ looks
           ;; for ‘wmctrl’ in the right place.
           (lambda _
             (let ((file "ewmctrl.el"))
               (chmod file #o644)
               (emacs-substitute-sexps file
                 ("(defcustom ewmctrl-wmctrl-path" (which "wmctrl")))))))))
    (inputs
     (list wmctrl))
    (home-page "https://github.com/flexibeast/ewmctrl")
    (synopsis "Emacs interface to @code{wmctrl}")
    (description "@code{ewmctrl} provides an Emacs interface to
@code{wmctrl} command-line window-management program.")
    (license license:gpl3+)))

(define-public emacs-erc-image
  (let ((commit "82fb3871f02e24b1e880770b9a3d187aab43d0f0")
        (revision "3"))
    (package
      (name "emacs-erc-image")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/kidd/erc-image.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1q8mkf612fb4fjp8h4kbr107wn083iqfdgv8f80pcmil8y33dw9i"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases (modify-phases %standard-phases
                    ;; The package autoloader fails to provide
                    ;; the image module when handled by Guix.
                    ;; Disable this phase, and let the package
                    ;; handle the `eval-after-load' procedure.
                    (delete 'make-autoloads))))
      (home-page "https://github.com/kidd/erc-image.el")
      (synopsis "Show inlined images (png/jpg/gif/svg) in ERC buffers")
      (description "This plugin subscribes to hooks @code{erc-insert-modify-hook}
and @code{erc-send-modify-hook} to download and show images.")
      (license license:gpl3+))))

(define-public emacs-helm-gtags
  (package
    (name "emacs-helm-gtags")
    (version "1.5.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-helm-gtags")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1kc1jzk10nfd2v20g8dwnb6a944afrwdwnkzl06w4ba8k4yim7gi"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm))
    (home-page "https://github.com/syohex/emacs-helm-gtags")
    (synopsis "Emacs Helm interface to GNU Global")
    (description
     "@code{emacs-helm-gtags} provides a Emacs Helm interface to GNU Global.")
    (license license:gpl3+)))

(define-public emacs-list-utils
  ;; Use a git snapshot until upstream fixes the build with emacs 28.1.
  ;; See <http://issues.guix.gnu.org/55558>.
  (let ((commit "0dec8c02962d2591766739e37c5714ba21133093") (revision "1"))
    (package
      (name "emacs-list-utils")
      (version (git-version "0.4.6" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/rolandwalker/list-utils")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "11nm8649a131bn2kwj4fxkiijdx2d4f1byx7a985zlb3bzdwnaw8"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/rolandwalker/list-utils")
      (synopsis "List-manipulation utility functions")
      (description
       "This package provides a list manipulation library for Emacs.")
      (license license:gpl3+))))

(define-public emacs-parsec
  (package
    (name "emacs-parsec")
    (version "0.1.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cute-jumper/parsec.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1g1s8s45g3kkbi3h7w0pmadmzdswb64mkdvdpg2lihg341kx37gm"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/cute-jumper/parsec.el")
    (synopsis "Parser combinator library for Emacs Lisp")
    (description
     "Parsec is a parser combinator library for Emacs Lisp, similar to
Haskell's Parsec library.  It contains most of the parser combinators in
Text.Parsec.Combinator, and more combinators can be added if necessary!  Most
of the parser combinators have the same behavior as their Haskell
counterparts.  Parsec also comes with a simple error handling mechanism so
that it can display an error message showing how the parser fails.")
    (license license:gpl3+)))

(define-public emacs-move-text
  (package
    (name "emacs-move-text")
    (version "2.0.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsfodder/move-text")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0pxvipjp9xvr9zwiwij943jgpy7fk8pxphbdj0vrg8ar5avlqiam"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacsfodder/move-text")
    (synopsis "Move current line or region with M-up or M-down")
    (description "This package provide functions to move the current line
using @kbd{M-up} or @kbd{M-down} if a region is marked, it will move the
region instead.")
    (license license:gpl3+)))

(define-public emacs-validate
  (package
    (name "emacs-validate")
    (version "1.0.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                     (url "https://github.com/Malabarba/validate.el")
                     (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1l12ibx6cw4mgicgjpw71fb4fr4sd0k54lvbpq7ngc29br3j6i4v"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Malabarba/validate.el")
    (synopsis "Emacs library for scheme validation")
    (description "This Emacs library provides two functions that perform
schema validation.")
    (license license:gpl3+)))

(define-public emacs-rainbow-blocks
  (let ((commit "dd435d7bb34ff6f162a5f315df308b90b7e9f842"))
    (package
      (name "emacs-rainbow-blocks")
      (version (git-version "1.0.0" "1" commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/istib/rainbow-blocks")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "06yfb3i7wzvqrhkb61zib9xvpb5i00s4frizkzff66im05k0n795"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/istib/rainbow-blocks")
      (synopsis "Highlight sexp blocks")
      (description "Rainbow-blocks is an Emacs mode that highlights blocks
made of parentheses, brackets, and braces according to their depth.  Each
successive level is highlighted in a different color.  This makes it easy to
orient yourself in the code, and tell which statements are at a given level.")
      (license license:gpl3+))))

(define-public emacs-tree-mode
  (let ((commit "b06078826d5875d74b0e7b7ac47b0d0917610534")
        (revision "1"))
    (package
      (name "emacs-tree-mode")
      (version (string-append "0.0.1" "-" revision "."
                              (string-take commit 7)))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsorphanage/tree-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "13bbdhdmqg4x9yghanhr8fsbsxbnypzxdxgicz31sjjm675kpnix"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/emacsorphanage/tree-mode")
      (synopsis "Emacs mode to manage tree widgets")
      (description
       "This package provides an Emacs library to manage tree widgets.")
      (license license:gpl3+))))

(define-public emacs-md4rd
  (package
    (name "emacs-md4rd")
    (version "0.3.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ahungry/md4rd")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1n6g6k4adzkkn1g7z4j27s35xy12c1fg2r08gv345ddr3wplq4ri"))))
    (propagated-inputs
     (list emacs-dash emacs-request emacs-s emacs-tree-mode))
    (build-system emacs-build-system)
    (home-page "https://github.com/ahungry/md4rd")
    (synopsis "Emacs Mode for Reddit")
    (description
     "This package allows reading Reddit from within Emacs interactively.")
    (license license:gpl3+)))

(define-public emacs-pulseaudio-control
  (let ((commit "a931533140547510decdc368f39b2d2b97ca725f")
        (revision "4"))
    (package
      (name "emacs-pulseaudio-control")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/flexibeast/pulseaudio-control")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1jvjn9jszjjapi167an49jxcvr88cvgjwykglhp4b8lwhbjfqw76"))))
      (build-system emacs-build-system)
      (arguments
       '(#:phases (modify-phases %standard-phases
                    (add-after 'unpack 'patch-file-name
                      (lambda* (#:key inputs #:allow-other-keys)
                        (let ((pulseaudio (assoc-ref inputs "pulseaudio")))
                          (chmod "pulseaudio-control.el" #o600)
                          (emacs-substitute-variables "pulseaudio-control.el"
                            ("pulseaudio-control-pactl-path"
                             (string-append pulseaudio "/bin/pactl")))
                          #t))))))
      (inputs (list pulseaudio))
      (home-page "https://github.com/flexibeast/pulseaudio-control")
      (synopsis "Control @code{pulseaudio} from Emacs")
      (description
       "This package allows controlling @code{pulseaudio} from Emacs.")
      (license license:gpl3+))))

(define-public emacs-pulsar
  (package
    (name "emacs-pulsar")
    (version "0.5.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://git.sr.ht/~protesilaos/pulsar")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0wwj9civyidfcv0k859w0i2aqb75dypy7aihk3cnv1nv2q4m61j5"))))
    (native-inputs (list texinfo))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'makeinfo
            (lambda _
              (invoke "emacs"
                      "--batch"
                      "--eval=(require 'ox-texinfo)"
                      "--eval=(find-file \"README.org\")"
                      "--eval=(org-texinfo-export-to-info)")
              (install-file "pulsar.info" (string-append #$output "/share/info")))))))
    (home-page "https://protesilaos.com/emacs/pulsar")
    (synopsis "Pulse highlight line on demand or after running select functions")
    (description "This package temporarily highlights the current line after a
given function is invoked.")
    (license (list license:gpl3+
                   license:fdl1.3+)))) ; GFDLv1.3+ for the manual

(define-public emacs-datetime
  (package
    (name "emacs-datetime")
    (version "0.7.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/doublep/datetime")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10nf3y4abwkwvi4g11mdwi0dydy4kzfyv21y06dsxm1hc1gmq7zx"))))
    (build-system emacs-build-system)
    (arguments
     `(#:include (cons "^[^/]*\\.extmap$" %default-include)))
    (inputs
     (list emacs-extmap))
    (home-page "https://github.com/doublep/datetime/")
    (synopsis "Library to work with dates in Emacs")
    (description "Parsing, formatting, matching and recoding
timestamps and date-time format strings library for Emacs.")
    (license license:gpl3+)))

(define-public emacs-org-mind-map
  ;; XXX: Upstream does not provide any tag.  The commit below corresponds to
  ;; an exact version bump from the main file.
  (let ((commit "477701b15cb0c8ed7f021ca76a4cb1a7d9ad6aa5"))
    (package
      (name "emacs-org-mind-map")
      (version "0.4")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/theodorewiles/org-mind-map")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "08sj43py6aid4vpqgsm0v5n94mcmcil0047qjk033492glz6q55c"))))
      (propagated-inputs
       (list emacs-dash))
      (build-system emacs-build-system)
      (home-page "https://github.com/theodorewiles/org-mind-map")
      (synopsis "Create Graphviz directed graphs from Org files")
      (description
       "This package creates Graphviz directed graphs from Org files.")
      (license license:gpl3+))))

(define-public emacs-npm-mode
  (package
    (name "emacs-npm-mode")
    (version "0.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mojochao/npm-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1mh6nbffciw4yhv049kdhh796ysj1x21ndm3fwymhskb3dy0w1ss"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/mojochao/npm-mode")
    (synopsis "Minor mode for working with @code{npm} projects")
    (description
     "@code{npm-mode} provides a minor mode to work with @code{npm} projects.")
    (license license:gpl3+)))

(define-public emacs-itail
  ;; XXX: Upstream provides no tags.  The commit below corresponds to an exact
  ;; version bump from main file.
  (let ((commit "6e43c20da03be3b9c6ece93b7dc3495975ec1888"))
    (package
      (name "emacs-itail")
      (version "0.0.8")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/re5et/itail")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "044nzxh1hq41faxw3lix0wy78vfz304pjcaa5a11dqfz7q3gx5cv"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/re5et/itail")
      (synopsis "Interactive @code{tail} Emacs mode")
      (description "@code{itail} provides interactive @code{tail} mode that
allows you to filter the tail with Unix pipes and highlight the contents of
the tailed file.  It works locally or on remote files using Tramp.")
      (license license:gpl3+))))

(define-public emacs-loop
  (package
    (name "emacs-loop")
    (version "1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Wilfred/loop.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gs95xnmnn8aa4794k7h8mw1sz1nfdh9v0caqj6yvnsdnwy74n5x"))))
    (build-system emacs-build-system)
    (native-inputs
     (list emacs-ert-runner emacs-undercover))
    (arguments
     `(#:tests? #t
       #:test-command '("ert-runner")))
    (home-page "https://github.com/Wilfred/loop.el")
    (synopsis "Imperative loop structures for Emacs")
    (description "Loop structures familiar to users of other languages.  This
library adds a selection of popular loop structures as well as break and
continue.")
    (license license:gpl3+)))

(define-public emacs-elisp-refs
  (package
    (name "emacs-elisp-refs")
    (version "1.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Wilfred/elisp-refs")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "03p95kwvwb3apb3lhhdlaxs952x7sdlxa2qc1c77cjwrm5xzdg9z"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash
           emacs-f
           emacs-list-utils
           emacs-loop
           emacs-s
           emacs-shut-up))
    (native-inputs
     (list emacs-ert-runner emacs-undercover))
    (arguments
     (list
      #:tests? #t
      #:test-command #~(list "ert-runner")))
    (home-page "https://github.com/Wilfred/elisp-refs")
    (synopsis "Find callers of elisp functions or macros")
    (description "@code{elisp-refs} finds references to functions, macros or
variables.  Unlike a dumb text search, it actually parses the code, so it's
never confused by comments or @code{foo-bar} matching @code{foo}.")
    (license license:gpl3+)))

(define-public emacs-crdt
  ;; XXX: Upstream does not always tag new releases.  The commit below
  ;; corresponds exactly to latest version bump.
  (let ((commit "e6d42f42c5dedb73560048f4bf6263c63ffa21bb")
        (version "0.3.5"))
    (package
      (name "emacs-crdt")
      (version version)
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://code.librehq.com/qhong/crdt.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "16dpg0d8p4fqjl2nir290iim9bb7f87rwnxs16lx67dasvbfawph"))))
      (build-system emacs-build-system)
      (home-page "https://code.librehq.com/qhong/crdt.el")
      (synopsis "Real-time collaborative editing environment")
      (description
       "@code{crdt.el} is a real-time collaborative editing environment for
Emacs using Conflict-free Replicated Data Types.  With it, you can share
multiple buffer in one session, and see other users’ cursor and region.  It
also synchronizes Org mode folding status.  It should work with all of Org
mode.")
      (license license:gpl3+))))

(define-public emacs-crux
  (package
    (name "emacs-crux")
    (version "0.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bbatsov/crux")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1h28chpyq61k72qh749r5kqq1y70wx3xw9c3zyfzmy750wlw6nyj"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/bbatsov/crux")
    (synopsis "Collection of useful functions for Emacs")
    (description
     "@code{crux} provides a collection of useful functions for Emacs.")
    (license license:gpl3+)))

(define-public emacs-edit-server
  (package
    (name "emacs-edit-server")
    (version "1.16")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/stsquad/emacs_chrome")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0m7gj224sqxjjw5sxky92fnrxg9jy4nf33kwf0aqxnfhqlgh545k"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'chdir-elisp
           ;; Elisp directory is not in root of the source.
           (lambda _
             (chdir "servers"))))))
    (propagated-inputs (list emacs-ert-async))
    (home-page "https://github.com/stsquad/emacs_chrome")
    (synopsis "Server that responds to edit requests from Chromium")
    (description
     "This package provides an edit server to respond to requests from Emacs.")
    (license license:gpl3+)))

(define-public emacs-m-buffer-el
  (package
    (name "emacs-m-buffer-el")
    (version "0.15")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/phillord/m-buffer-el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1sx76i59razwccvn6x7rx5a124bfyjw9fcbxf4gj7nsg33qiq809"))))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "emacs" "--batch" "-L" "."
                        "-l" "test/m-buffer-test.el"
                        "-l" "test/m-buffer-at-test.el"
                        "-f" "ert-run-tests-batch-and-exit")))))))
    (build-system emacs-build-system)
    (home-page "https://github.com/phillord/m-buffer-el")
    (synopsis "List oriented buffer operations for Emacs")
    (description "@code{m-buffer} provides a set of list-orientated functions
for operating over the contents of Emacs buffers.")
    (license license:gpl3+)))

(define-public emacs-let-alist
  (package
    (name "emacs-let-alist")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://elpa.gnu.org/packages/let-alist-" version ".el"))
       (sha256
        (base32 "0szj7vnjzz4zci5fvz7xqgcpi4pzdyyf4qi2s8xar2hi7v3yaawr"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/let-alist.html")
    (synopsis "Easily let-bind values of an assoc-list by their names")
    (description "This package offers a single macro, @code{let-alist}.  This
macro takes a first argument (whose value must be an alist) and a body.")
    (license license:gpl3+)))

(define-public emacs-esup
  (let ((commit "0de8af8233d9ce1b67f05a50f25c481c4f1118d8")
        (revision "1"))
    (package
      (name "emacs-esup")
      (version (git-version "0.7.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jschaf/esup")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "01khb3xyj0ylwib6ryzzvqmkh5wvzxiq2n3l0s3h9zv7wx849bzv"))))
      (build-system emacs-build-system)
      (native-inputs
       (list emacs-noflet emacs-undercover emacs-buttercup))
      (propagated-inputs
       (list emacs-dash))
      (arguments
     `(#:tests? #t
       #:test-command '("buttercup" "-L" ".")))
      (home-page "https://github.com/jschaf/esup")
      (synopsis "Emacs start up profiler")
      (description "Benchmark Emacs Startup time without ever leaving
your Emacs.")
      (license license:gpl2+))))

(define-public emacs-restart-emacs
  (let ((commit "9aa90d3df9e08bc420e1c9845ee3ff568e911bd9")
        (revision "1"))
    (package
      (name "emacs-restart-emacs")
      (version (git-version "0.1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/iqbalansari/restart-emacs")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "02x1a85k7r95z8091zgjiaj9nf0zvx1jy4xvl3hr12qbnrx1wfav"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/iqbalansari/restart-emacs")
      (synopsis "Restart Emacs from within Emacs")
      (description "This package provides a simple command to restart Emacs from
within Emacs.")
      (license license:gpl3+))))

(define-public emacs-svg-lib
  ;; XXX: Upstream does not tag releases.  The commit hash below corresponds
  ;; to the version bump.
  (let ((commit "0486c9453449771bc3f5872f70bc5cb23580d0f4"))
    (package
      (name "emacs-svg-lib")
      (version "0.2.5")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rougier/svg-lib")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "059vd4k7bvskkriwaiz4n2yafc3inndrr018hqfpic4k02cbwzpv"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/rougier/svg-lib")
      (synopsis "Emacs SVG library for creating tags, icons and bars")
      (description
       "This is a small Emacs library to create and display various
SVG objects, namely tags, progress bars, progress pies and icons.
Each object is guaranteed to fit nicely in a text buffer ensuring
width is an integer multiple of character width.")
      (license license:gpl3+))))

(define-public emacs-svg-tag-mode
  ;; XXX: Upstream does not tag releases.  The commit hash below corresponds
  ;; to the version bump.
  (let ((commit "3b07983614bee0195534e7a8a6dcfab757da4f0b"))
    (package
      (name "emacs-svg-tag-mode")
      (version "0.3.2")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rougier/svg-tag-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0nc0y2dn67gy9cly3yamskfd9dd028xbask8gjxql934bq0ads2i"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-svg-lib))
      (home-page "https://github.com/rougier/svg-tag-mode")
      (synopsis "Replace keywords with SVG tags")
      (description "This package provides a minor mode that replaces keywords
or expressions with SVG rounded box labels that are fully customizable.")
      (license license:gpl3+))))

(define-public emacs-kind-icon
  (package
    (name "emacs-kind-icon")
    (version "0.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/kind-icon-"
                           version ".tar"))
       (sha256
        (base32 "0phssrcpmcidzlwy1577f3f02qwjs6hpavb416302y0n8kkhwvli"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-svg-lib))
    (home-page "https://github.com/jdtsmith/kind-icon")
    (synopsis "Completion kind icons in Emacs")
    (description "Kind-icon mode adds a colorful icon or text prefix based on
@code{:company-kind} for compatible completion UIs.  The ``kind'' prefix is
typically used for differentiating completion candidates such as variables or
functions.")
    (license license:gpl3+)))

(define-public emacs-svg-icon
  (let ((commit "ebc2b8d0f6c680fd575a90e683cc7b832acd1eb7")
        (revision "1"))
    (package
      (name "emacs-svg-icon")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rougier/emacs-svg-icon")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1qzqfa8xyw1nkb89kbvw9qcgdwr8g017n8gf3yzwn816qhkfkjrj"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/rougier/emacs-svg-icon")
      (synopsis "Emacs library to create SVG icons on the fly")
      (description "This library allows creating SVG icons by parsing remote
collections whose license are compatibles with Emacs.  The default size of an
icon is exactly 2x1 characters such that it can be inserted inside a text
without disturbing alignment.")
      (license (list license:gpl3+)))))

(define-public emacs-sourcemap
  (package
    (name "emacs-sourcemap")
    (version "0.03")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-sourcemap")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "115g2mfpbfywp8xnag4gsb50klfvplqfh928a5mabb5s8v4a3582"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/syohex/emacs-sourcemap")
    (synopsis "Sourcemap parser")
    (description "Sourcemap parser")
    (license license:gpl3+)))

(define-public emacs-macrostep
  (let ((commit "424e3734a1ee526a1bd7b5c3cd1d3ef19d184267"))
    (package
      (name "emacs-macrostep")
      (version (git-version "0.9" "1" commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/joddie/macrostep")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1fm40mxdn289cyzgw992223dgrjmwxn4q8svyyxfaxjrpb38jhjz"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #t
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'remove-test
              ;; Fails because of requirement ‘/bin/sh’.
              (lambda _
                (let ((file "macrostep-test.el"))
                  (make-file-writable file)
                  (emacs-batch-edit-file file
                    `(progn (progn (goto-char (point-min))
                                   (re-search-forward
                                    "(ert-deftest macrostep-expand-c-macros")
                                   (beginning-of-line)
                                   (kill-sexp))
                            (basic-save-buffer))))))
            (replace 'check
              (lambda* (#:key tests? #:allow-other-keys)
                (when tests?
                  (invoke "emacs" "--batch" "-L" "."
                          "-l" "macrostep-test.el"
                          "-f" "ert-run-tests-batch-and-exit")))))))
      (home-page "https://github.com/joddie/macrostep")
      (synopsis "Interactive macro-expander for Emacs")
      (description "@code{macrostep} is an Emacs minor mode for interactively
stepping through the expansion of macros in Emacs Lisp source code.  It lets
you see exactly what happens at each step of the expansion process by
pretty-printing the expanded forms inline in the source buffer, which is
temporarily read-only while macro expansions are visible.  You can expand and
collapse macro forms one step at a time, and evaluate or instrument the
expansions for debugging with Edebug as normal.")
      (license license:gpl3+))))

(define-public emacs-macrostep-geiser
  ;; XXX: Upstream does not tag commits (yet).  The commit below matches the
  ;; version bump.
  (let ((commit "7927651b188cac07113bce5b2cd0de12b2b082f7"))
    (package
      (name "emacs-macrostep-geiser")
      (version "0.2.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/nbfalcon/macrostep-geiser")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1gz2kypyrb4k76dn4j02c8s6a3dqb1la5jcrdcifv8saa8lvqyli"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-geiser emacs-macrostep))
      (home-page "https://github.com/nbfalcon/macrostep-geiser")
      (synopsis "Macrostep for Geiser and Cider")
      (description
       "This plug-in implements a Macrostep back-end powered by Geiser.")
      (license license:gpl3+))))

(define-public emacs-parent-mode
  (package
    (name "emacs-parent-mode")
    (version "2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Fanael/parent-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0i5bc7lyyrx6swqlrp9l5x72yzwi53qn6ldrfs99gh08b3yvsnni"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Fanael/parent-mode")
    (synopsis "Get major mode's parent modes")
    (description "Get major mode's parent modes")
    (license license:gpl3+)))

(define-public emacs-lacarte
  (package
    (name "emacs-lacarte")
    (version "0.1")
    (source (origin
              (method url-fetch)
              (uri "https://www.emacswiki.org/emacs/download/lacarte.el")
              (sha256
               (base32
                "1sbmk37ljq5j7dsw5c37sbxvlfgdqswh7bi4dknyjzfxlq50f4am"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/lacarte.el")
    (synopsis "Execute menu items as commands, with completion")
    (description "Execute menu items as commands, with completion.")
    (license license:gpl3)))

(define-public emacs-latex-preview-pane
  (let ((commit "5297668a89996b50b2b62f99cba01cc544dbed2e")
        (revision "0"))
    (package
      (name "emacs-latex-preview-pane")
      (version (git-version "20151021" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jsinglet/latex-preview-pane")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1m4f5p53275k8i9p0y105kkrp9nx1bwn6726my9s5dwnjhr5dnp2"))))
      (build-system emacs-build-system)
      (arguments
       (list
        ;; The welcome and error message templates are in .txt format.
        #:include #~(cons "\\.txt$" %default-include)))
      (home-page "https://github.com/jsinglet/latex-preview-pane")
      (synopsis "Preview pane to ease LaTeX editing in Emacs")
      (description "@code{latex-preview-pane} is a minor mode for previewing
LaTeX files directly in Emacs.  It supports PDF previews, with either
@command{pdflatex} or @command{xelatex}, and highlights errors in the LaTeX
buffer.")
      (license license:gpl3+))))

(define-public emacs-isearch-prop
  (let ((commit "4a2765f835dd115d472142da05215c4c748809f4")
        (revision "2"))
    (package
      (name "emacs-isearch-prop")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsmirror/isearch-prop")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "06gdk5m84q6pxwng8rjxny1zkll8f3m2x6lw4xyib2dvg7iaslh3"))))
      (build-system emacs-build-system)
      (home-page "https://www.emacswiki.org/emacs/isearch-prop.el")
      (synopsis "Extensions to @code{isearch.el}")
      (description "The Emacs library @code{isearch-prop.el} lets you search within
  contexts.  You can limit incremental search to a set of zones of
  buffer text, search contexts that in effect constitute a multi-region.
  These zones can be defined in various ways, including some ways
  provided specially by this library.")
      (license license:gpl3+))))

(define-public emacs-company-lua
  (let ((commit "29f6819de4d691e5fd0b62893a9f4fbc1c6fcb52")
        (revision "2"))
    (package
      (name "emacs-company-lua")
      (version (git-version "0.1" "2" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ptrv/company-lua")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0ny2dcc7c585p7v3j6q0rpkbj1qmf2ismy8a5020jpr585xvz0hh"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-company emacs-s emacs-f emacs-lua-mode))
      (arguments
       `(#:include (cons* "^lua\\/" %default-include)))
      (home-page "https://github.com/ptrv/company-lua")
      (synopsis "Company backend for Lua")
      (description
       "This package provides Company backend for Lua programming language.")
      (license license:gpl3+))))

(define-public emacs-beginend
  (package
    (name "emacs-beginend")
    (version "2.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/DamienCassou/beginend")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "17r8v1sjvgcmprywny9fdg54x4pssp8p7a9ivv5mrygkqjz1vykk"))))
    ;; TODO: Run tests.
    (build-system emacs-build-system)
    (inputs
     (list emacs-undercover)) ; For tests.
    (home-page "https://github.com/DamienCassou/beginend")
    (synopsis "Redefine @code{M-<} and @code{M->} for Emacs modes")
    (description "@code{beginend} redefines @code{M-<} and @code{M->}
keybindings for Emacs modes so that point moves to meaningful
locations.  Redefined keys are still accessible by pressing the same
key again.")
    (license license:gpl3+)))

(define-public emacs-mbsync
  (let ((commit "b62491c0e0d89eb9c66261a16d7ac81231c9c453")
        (revision "4"))
    (package
      (name "emacs-mbsync")
      (version (git-version "0.1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dimitri/mbsync-el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1zlih37mkqjn2czl12zn7lgxxljvrwhqqpbksj9c91zn0f0rm3mz"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/dimitri/mbsync-el")
      (synopsis "Interface to mbsync for Emacs")
      (description "This package calls @code{mbsync} from
within Emacs.")
      (license license:gpl3+))))

(define-public emacs-ibuffer-projectile
  (package
    (name "emacs-ibuffer-projectile")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/ibuffer-projectile")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "18cqxnwzzbkcj9jcaw89b210432yzhrl1dwsv48p0jbhfnr17k41"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-projectile))
    (home-page "https://github.com/purcell/ibuffer-projectile")
    (synopsis "Group ibuffer's list by projectile root")
    (description "Adds functionality to Emacs @code{ibuffer} for
grouping buffers by their projectile root directory.")
    (license license:gpl3+)))

(define-public emacs-ibuffer-vc
  (package
    (name "emacs-ibuffer-vc")
    (version "0.11")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/ibuffer-vc")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1mgn7b786j4hwq1ks012hxxgvrfn5rz90adi2j190gmjz60rc5g5"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/ibuffer-vc")
    (synopsis "Group Ibuffer's list by revision control system indications")
    (description
     "Ibuffer-VC adds functionality to Ibuffer for grouping buffers by their
parent revision control system root directory, and for displaying, or sorting,
by the status of listed files.")
    (license license:gpl3+)))

(define-public emacs-elm-mode
  (package
    (name "emacs-elm-mode")
    (version "0.22.0")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/jcollard/elm-mode")
         (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gnr61ibzcznfqy5f8capmbz75rcfikwy106rjdmp45qz2jwp4di"))))
    (propagated-inputs
     (list emacs-dash emacs-f emacs-reformatter emacs-s))
    (build-system emacs-build-system)
    (home-page "https://github.com/jcollard/elm-mode")
    (synopsis "Emacs major mode for editing Elm source code")
    (description
     "This package provides a major mode for editing Elm source code, and
working with common core and third-party Elm tools.  Its features are:

@itemize
@item Syntax highlighting
@item Intelligent indentation
@item Integration with elm-make
@item Integration with elm-repl
@item Integration with elm-reactor
@item Integration with elm-package
@item Integration with elm-oracle
@item Integration with elm-format
@item Integration with elm-test
@end itemize")
    (license license:gpl3+)))

(define-public emacs-helm-mode-manager
  (package
    (name "emacs-helm-mode-manager")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/istib/helm-mode-manager")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1srx5f0s9x7zan7ayqd6scxfhcvr3nkd4yzs96hphd87rb18apzk"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm))
    (home-page "https://github.com/istib/helm-mode-manager/")
    (synopsis "Switch and toggle Emacs major and minor modes using Helm")
    (description "This package provides a Helm interface for toggling Emacs
major or minor mode.

@itemize
@item @code{helm-switch-major-mode} list of all major modes
@item @code{helm-enable-minor-mode} list of all inactive minor modes
@item @code{helm-disable-minor-mode} list of all ACTIVE minor modes
@end itemize\n

Hitting @code{RET} enables the mode, @code{C-z} shows the mode
documentation.")
    (license license:gpl3+)))

(define-public emacs-hy-mode
  (package
    (name "emacs-hy-mode")
    (version "1.0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hylang/hy-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0gihxlmfminadaqdr8d2zccd7wwygl3m0gfzxsk5izi7f8hl4w7f"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-s))
    (home-page "https://github.com/hylang/hy-mode")
    (synopsis "Major mode for Hylang")
    (description "This package provides a major mode for Hylang.")
    (license license:gpl3+)))

(define-public emacs-web-beautify
  (package
    (name "emacs-web-beautify")
    (version "0.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/yasuyk/web-beautify")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0vms7zz3ym53wf1zdrkbf2ky2xjr1v134ngsd0jr8azyi8siw84d"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/yasuyk/web-beautify")
    (synopsis "Format HTML, CSS and JavaScript, JSON")
    (description "This package provides an Emacs functions to format HTML,
CSS, JavaScript, JSON.")
    (license license:gpl3+)))

(define-public emacs-helm-shell-history
  (let ((commit "110d3c35c52fe4b89b29e79ea4c8626bce7266a1"))
    (package
      (name "emacs-helm-shell-history")
      (version (git-version "0.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/yuutayamada/helm-shell-history")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "18fkjcz69g4dyaxhf9j8svr5x6dhsdnglddwisis8hdn504scpfj"))))
      (build-system emacs-build-system)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-before 'check 'patch-helm-shell-history-file
             (lambda _
               (let ((file "helm-shell-history.el"))
                 (chmod file #o644)
                 (emacs-substitute-sexps file
                   ("(defvar helm-shell-history-file"
                    `(expand-file-name "~/.bash_history"))))
               #t)))))
      (propagated-inputs
       (list emacs-helm))
      (home-page "https://github.com/yuutayamada/helm-shell-history")
      (synopsis "Find shell history with Emacs Helm")
      (description "This package provides an Emacs Helm interface to search
throw a shell history.")
      (license license:gpl3+))))

(define-public emacs-discover-my-major
  (package
    (name "emacs-discover-my-major")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://framagit.org/steckerhalter/discover-my-major.git/")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1wlqyl03hhnflbyay3qlvdzqzvv5rbybcjpfddggda7ias9h0pr4"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-makey))
    (home-page "https://framagit.org/steckerhalter/discover-my-major/")
    (synopsis "Discover key bindings for the current Emacs major mode")
    (description "This package discovers key bindings and
their meaning for the current Emacs major-mode.")
    (license license:gpl3+)))

(define-public emacs-org-ref
  (package
    (name "emacs-org-ref")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jkitchin/org-ref")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xd1qp8dfy8n8b2n3rsdzm8vrfl7dii142kw330s8jp3pavww1f6"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash
           emacs-f
           emacs-helm
           emacs-helm-bibtex
           emacs-htmlize
           emacs-hydra
           emacs-ivy
           emacs-key-chord
           emacs-pdf-tools
           emacs-s))
    (home-page "https://github.com/jkitchin/org-ref")
    (synopsis "Citations, cross-references and bibliographies in Org mode")
    (description
     "Org Ref is an Emacs library that provides rich support for citations,
labels and cross-references in Org mode.

The basic idea of Org Ref is that it defines a convenient interface to insert
citations from a reference database (e.g., from BibTeX files), and a set of
functional Org links for citations, cross-references and labels that export
properly to LaTeX, and that provide clickable functionality to the user.  Org
Ref interfaces with Helm BibTeX to facilitate citation entry, and it can also
use RefTeX.

It also provides a fairly large number of utilities for finding bad citations,
extracting BibTeX entries from citations in an Org file, and functions to
create and modify BibTeX entries from a variety of sources, most notably from
a DOI.

Org Ref is especially suitable for Org documents destined for LaTeX export and
scientific publication.  Org Ref is also useful for research documents and
notes.")
    (license license:gpl3+)))

(define-public emacs-org-reveal
  (let ((commit "fe9148b670d144124d9697fcf5d0528f19025104"))
    (package
      (name "emacs-org-reveal")
      (version (git-version "20210902" "1" commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/yjwen/org-reveal")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "034gkbc03z9jzj7ad34mmqgmvj4f14ap7iixh3zx4wp2ipw5xb7c"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/yjwen/org-reveal")
      (synopsis "Org and Reveal.js powered HTML presentation tool")
      (description "Org-Reveal is a @command{org-mode} extension that allows
to create beautiful presentations (slides) with 3D effects from simple but
powerful Org contents.")
      (license license:gpl3+))))

(define-public emacs-org-re-reveal
  (package
    (name "emacs-org-re-reveal")
    (version "3.16.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/oer/org-re-reveal")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jzr7xlzinhfb0197anbkrr5zrs13f7kyznr5q3zyxdndhg6a53n"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-htmlize emacs-org))
    (home-page "https://gitlab.com/oer/org-re-reveal")
    (synopsis "Build HTML presentations with reveal.js from Org source files")
    (description "This project started as fork of org-reveal.  It provides an
export back-end for HTML presentations with reveal.js from Org mode source
files.")
    (license license:gpl3+)))

(define-public emacs-add-hooks
  (package
    (name "emacs-add-hooks")
    (version "3.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nickmccurdy/add-hooks")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jv9fpcsm572zg0j1mbpbfkqgdlqapy89xhhj19pswkhjns1y2wl"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/nickmccurdy/add-hooks/")
    (synopsis "Emacs function for setting multiple hooks")
    (description "This package provides a @code{add-hooks} function tidies up
duplicate hook and function names further into a single declarative call.")
    (license license:gpl3+)))

(define-public emacs-fancy-battery
  (package
    (name "emacs-fancy-battery")
    (version "0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/fancy-battery")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "05lwcwf412m717yhwpjrswqkm8c3i7391rmiwv2k8xc1vk6dpp4g"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacsorphanage/fancy-battery")
    (synopsis "Display battery status in Emacs mode line")
    (description "This package provides @code{fancy-battery-mode} which is
like the built-in @code{display-battery-mode}, but more fancy.  It just the
remaining time, uses colours to indicate the status of the battery, and is
more customizable.")
    (license license:gpl3)))

(define-public emacs-fancy-narrow
  (package
    (name "emacs-fancy-narrow")
    (version "0.9.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Malabarba/fancy-narrow")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0vcr1gnqawvc1yclqs23jvxm6bqix8kpflf1c7znb0wzxmz9kx7y"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Malabarba/fancy-narrow/releases")
    (synopsis "Imitate @code{narrow-to-region} with more eye candy")
    (description
     "Unlike @code{narrow-to-region}, which completely hides text outside
the narrowed region, this package simply de-emphasizes the text, makes it
read-only, and makes it unreachable.  This leads to a much more natural
feeling where the region stays static (instead of being brutally moved to a
blank slate) and is clearly highlighted with respect to the rest of the
buffer.")
    (license license:gpl2+)))

(define-public emacs-hideshowvis
  (let ((commit "614e856620445166a60c00a1c4653dbd59c871c9")
        (revision "1"))
    (package
      (name "emacs-hideshowvis")
      (version (git-version "0.7" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/sheijk/hideshowvis")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0ykj5jwcm03p5h7sd52qndmzihyan09lqg6rzgmyabvw7p56y90m"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/sheijk/hideshowvis")
      (synopsis "Add icons in the Emacs fringe which @code{hideshow} can hide")
      (description "Emacs package to add clickable icons in the fringe for
regions which @code{hideshow} can hide.")
      (license license:gpl2+))))

(define-public emacs-know-your-http-well
  (package
    (name "emacs-know-your-http-well")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/for-GET/know-your-http-well")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1lppggnii2r9fvlhh33gbdrwb50za8lnalavlq9s86ngndn4n94k"))))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'install-json-files
           (lambda* (#:key outputs #:allow-other-keys)
             (for-each (lambda (directory)
                         (copy-recursively directory
                                           (string-append
                                            (assoc-ref outputs "out")
                                            directory)))
                       '("js" "json"))))
         (add-after 'unpack 'chdir-elisp
           ;; Elisp directory is not in root of the source.
           (lambda _
             (chdir "emacs"))))))
    (build-system emacs-build-system)
    (home-page "https://github.com/for-GET/know-your-http-well")
    (synopsis "Meaning of HTTP headers codes")
    (description "Meaning of HTTP headers codes.")
    (license license:gpl3+)))

(define-public emacs-navi-mode
  (let ((commit "c1d38e8237f4e14af020a0b7d4f118ea198ab674"))
    (package
      (name "emacs-navi-mode")
      (version (git-version "2.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alphapapa/navi")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0jj5spk14hgb7zb1cd2n8whcw4k1kd5zb6llwj96v178yaws7l8k"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-outshine emacs-outorg))
      (home-page "https://github.com/alphapapa/navi")
      (synopsis "Emacs major-mode for easy buffer-navigation")
      (description
       "This package provides an Emacs major-mode for easy buffer-navigation")
      (license license:gpl3+))))

(define-public emacs-download-region
  (let ((commit "eb9e557529a73b4cfc8281c70dd0d95db333fffa")
        (revision "1"))
    (package
      (name "emacs-download-region")
      (version (string-append "0.0.1" "-" revision "."
                              (string-take commit 7)))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/zk-phi/download-region")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0v52djg39b6k2snizd9x0qc009ws5y0ywqsfwhqgcbs5ymzh7dsc"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/zk-phi/download-region")
      (synopsis "In buffer download manager for Emacs")
      (description "@code{download-region} provides in buffer
downloading manager for Emacs.")
      (license license:gpl3+))))

(define-public emacs-helpful
  (package
    (name "emacs-helpful")
    (version "0.19")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Wilfred/helpful")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0qwsifzsjw95l83m7z07fr9h1sqbhggwmcps1qgbddpan2a8ab8a"))
       ;; Cherry-picked from upstream, remove when bumping to 0.20.
       (patches (search-patches "emacs-helpful-fix-docstring-test.patch"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-elisp-refs emacs-dash emacs-s emacs-f emacs-shut-up))
    (native-inputs
     (list emacs-ert-runner emacs-undercover))
    (arguments
     `(#:tests? #t
       #:test-command '("ert-runner")))
    (home-page "https://github.com/Wilfred/helpful")
    (synopsis "More contextual information in Emacs help")
    (description "@code{helpful} is an alternative to the built-in Emacs help
that provides much more contextual information.

@itemize
@item Show the source code for interactively defined functions (unlike the
built-in Help).
@item Fall back to the raw sexp if no source is available.
@item Show where a function is being called.
@item Docstrings will Highlight the summary (the first sentence), include
cross-references, hide superfluous puncuation.
@item Show you the properties that have been applied to the current
symbol.  This provides visibility of features like edebug or byte-code
optimisation.
@item Provide a separate @code{helpful-command} function to view interactive
functions.
@item Display any keybindings that apply to interactive functions.
@item Trace, disassemble functions from inside Helpful.  This is discoverable
and doesn't require memorisation of commands.
@end itemize\n")
    (license license:gpl3+)))

(define-public emacs-logview
  (package
    (name "emacs-logview")
    (version "0.15.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/doublep/logview")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1khri5632pjirj191x3ps94s4pyrwapf1pbrkmqqp0d26b50d3s2"))))
    (propagated-inputs
     (list emacs-datetime emacs-extmap))
    (build-system emacs-build-system)
    (home-page "https://github.com/doublep/logview/")
    (synopsis "Emacs mode for viewing log files")
    (description "@code{logview} provides an Emacs mode to view log files.")
    (license license:gpl3+)))

(define-public emacs-suggest
  (package
    (name "emacs-suggest")
    (version "0.7")
    (home-page "https://github.com/Wilfred/suggest.el")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "01v8plska5d3g19sb1m4ph1i3ayprfzk8mi6mpabjy6zad397xjl"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-loop
           emacs-dash
           emacs-s
           emacs-f
           emacs-spinner
           emacs-shut-up))
    (native-inputs
     (list emacs-ert-runner emacs-undercover))
    (arguments
     `(#:tests? #t
       #:test-command '("ert-runner")))
    (synopsis "Suggest Elisp functions that give the output requested")
    (description "Suggest.el will find functions that give the output
requested.  It's a great way of exploring list, string and arithmetic
functions.")
    (license license:gpl3+)))

(define-public emacs-benchmark-init
  (let ((commit "02435560415bbadbcf5051fb7042880549170e7e")
        (revision "1"))
    (package
      (name "emacs-benchmark-init")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dholm/benchmark-init-el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19375vamhld4xm2qrdmhlp2nczfvalmz9x6ahl23zwkilr8n1nbw"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/dholm/benchmark-init-el")
      (synopsis "Benchmark Emacs @code{require} and @code{load} calls")
      (description "@code{benchmark-init} provides a way to keep track of where
time is being spent during Emacs startup in order to optimize startup time.")
      (license license:gpl3+))))

(define-public emacs-magit-gerrit
  (package
    (name "emacs-magit-gerrit")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/terranpro/magit-gerrit")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1q4kcr2ha2kir7pj0cshmgllgq51543syxkkk5jk3ksfiaba4crj"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-magit))
    (home-page "https://github.com/terranpro/magit-gerrit")
    (synopsis "Magit extension for Gerrit")
    (description "This Magit extension provides integration with Gerrit,
which makes it possible to conduct Gerrit code reviews directly from within
Emacs.")
    (license license:gpl3+)))

(define-public emacs-magit-org-todos-el
  (package
    (name "emacs-magit-org-todos-el")
    (version "0.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/danielma/magit-org-todos.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "07r5x256k1fjjxs1yfg41kc94nwvnjlk2vvknkra3j8v9p0j88m7"))))
    (propagated-inputs
     (list emacs-magit))
    (build-system emacs-build-system)
    (home-page "https://github.com/danielma/magit-org-todos.el")
    (synopsis "Get todo.org into Emacs Magit status")
    (description "This package allows you to get @file{todo.org} into your
magit status.

If you have a @file{todo.org} file with @code{TODO} items in the root of your
repository, @code{magit-org-todos} will create a section in your Magit status
buffer with each of your todos.")
    (license license:gpl3+)))

(define-public emacs-vcsh
  (package
    (name "emacs-vcsh")
    (version "0.4.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/stepnem/vcsh-el.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "183pffdiqb7qqmjq31wxl3fpv8qswqgg99gb716rddiyk15ysri7"))))
    (build-system emacs-build-system)
    (home-page "https://gitlab.com/stepnem/vcsh-el")
    (synopsis "Emacs VCSH integration")
    (description
     "This library provides basic ``enter'' functionality and a few
convenience commands to initialize a @acronym{VCSH, Version Control System for
$HOME} repository and add files to it.  It can be used in conjunction with
Magit.")
    (license license:public-domain)))

(define-public emacs-f3
  (package
    (name "emacs-f3")
    (version "0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cosmicexplorer/f3")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1qg48zbjdjqimw4516ymrsilz41zkib9321q0caf9474s9xyp2bi"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm))
    (home-page "https://github.com/cosmicexplorer/f3")
    (synopsis "Fantastic File Finder for Emacs")
    (description
     "The Fantastic File Finder for Emacs.  Find files fast, using helm.")
    (license license:gpl3+)))

(define-public emacs-lice-el
  (package
    (name "emacs-lice-el")
    (version "0.3")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/buzztaiki/lice-el")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "06plnrxj6kgnl9mjcbc48mgagpa60yyyyribwicmcgg9pgrs0wad"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons "^template/" %default-include)
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-template-directory
            (lambda _
              (emacs-substitute-variables "lice.el"
                ("lice:system-template-directory"
                 (string-append (elpa-directory #$output) "/template"))))))))
    (home-page "https://github.com/buzztaiki/lice-el")
    (synopsis "License and header template for Emacs")
    (description "@code{lice.el} provides following features:

@itemize
@item License template management.
@item File header insertion.
@end itemize\n")
    (license license:gpl3+)))

(define-public emacs-academic-phrases
  (let ((commit "0823ed8c24b26c32f909b896a469833ec4d7b656"))
    (package
      (name "emacs-academic-phrases")
      (version (git-version "0.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/nashamri/academic-phrases")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0qfzsq8jh05w4zkr0cvq3i1hdn97bq344vcqjg46sib26x3wpz6r"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash emacs-s emacs-ht))
      (home-page "https://github.com/nashamri/academic-phrases")
      (synopsis "Bypass that mental block when writing your papers")
      (description
       "When writing your academic paper, you might get stuck trying to find
the right phrase that captures your intention.  This package tries to
alleviate that problem by presenting you with a list of phrases organized by
the topic or by the paper section that you are writing.  This package has
around 600 phrases so far.

Using this package is easy, just call @code{academic-phrases} to get a list of
phrases organized by topic, or call @code{academic-phrases-by-section} to
browse the phrases by the paper section and fill-in the blanks if required.")
      (license license:gpl3+))))

(define-public emacs-auto-yasnippet
  (let ((commit "624b0d9711222073a2a3f2186e2605eb99fc83c9")
        (revision "2"))
    (package
      (name "emacs-auto-yasnippet")
      (version (git-version "0.3.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/abo-abo/auto-yasnippet")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "15g8wi067f345xhpi0c12w0h04p4f4lpccwmdjdfj8hzfl4gyxy9"))))
      (build-system emacs-build-system)
      (arguments
       '(#:tests? #t
         #:test-command '("make" "test")))
      (propagated-inputs
       (list emacs-yasnippet))
      (home-page "https://github.com/abo-abo/auto-yasnippet/")
      (synopsis "Quickly create disposable yasnippets")
      (description "This package provides a hybrid of keyboard macros and
yasnippet.  You create the snippet on the go, usually to be used just in the
one place.  It's fast, because you're not leaving the current buffer, and all
you do is enter the code you'd enter anyway, just placing ~ where you'd like
yasnippet fields and mirrors to be.")
      (license license:gpl3+))))

(define-public emacs-highlight-numbers
  (package
    (name "emacs-highlight-numbers")
    (version "0.2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Fanael/highlight-numbers")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1r07mpyr7rhd7bkg778hx6vbhb4n9ixgzkpszhgks7ri6ia38pj8"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-parent-mode))
    (home-page "https://github.com/Fanael/highlight-numbers")
    (synopsis "Highlight numbers in source code")
    (description "@code{highlight-numbers-mode} provides a minor mode for
syntax highlighting of numeric literals in source code.

It s customizable: it's easy to add or redefine what exactly constitutes a
\"number\" in given major mode.  See @code{highlight-numbers-modelist}.")
    (license license:gpl3+)))

(define-public emacs-darkroom
  (package
    (name "emacs-darkroom")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "darkroom-" version ".el"))
       (sha256
        (base32 "0l1xg5kqmjw22k78qnsln0ifx2dx74xxqj0qp8xxcpqvzzx0xh86"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/darkroom.html")
    (synopsis "Remove visual distractions and focus on writing")
    (description "@code{darkroom-mode} makes visual distractions disappear.
The mode-line is temporarily elided, text is enlarged and margins are adjusted
so that it's centered on the window.

@code{darkroom-tentative-mode} is similar, but it doesn't immediately turn-on
@code{darkroom-mode}, unless the current buffer lives in the sole window of
the Emacs frame (i.e. all other windows are deleted).  Whenever the frame is
split to display more windows and more buffers, the buffer exits
@code{darkroom-mode}.  Whenever they are deleted, the buffer re-enters
@code{darkroom-mode}.")
    (license license:gpl3+)))

(define-public emacs-rsw-elisp
  (package
    (name "emacs-rsw-elisp")
    (version "1.0.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                     (url "https://github.com/rswgnu/rsw-elisp")
                     (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0dfq8myg0r91900bk1s70amsmm4mjk2qsg12v5pk7lla5d2vnyaf"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rswgnu/rsw-elisp")
    (synopsis "Improved expressions that interactively evaluate Emacs Lisp")
    (description "This package improves and replaces the GNU Emacs commands
that interactively evaluate Emacs Lisp expressions.  The new commands replace
standard key bindings and are all prefixed with @code{rsw-elisp-}.  They work
the same way as the old commands when called non-interactively; only the
interactive behavior should be different.")
    (license license:gpl3+)))

(define-public emacs-default-text-scale
  (package
    (name "emacs-default-text-scale")
    (version "0.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/purcell/default-text-scale")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0h42jiwxrxjmk7ccwh3h25n7dy2rq61ncm5wx27jhkncc5jdm4h6"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/default-text-scale")
    (synopsis "Adjust the font size in all Emacs frames")
    (description "This package provides commands for increasing or
decreasing the default font size in all GUI Emacs frames.")
    (license license:gpl3+)))

(define-public emacs-fixed-pitch
  (package
    (name "emacs-fixed-pitch")
    (version "0.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cstby/fixed-pitch-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0qlavjvib0r71xdy6y6pan9dhr57lw7jhmqk60mwa8fq6km8kpkj"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/cstby/fixed-pitch-mode")
    (synopsis
     "Use a monospaced typeface for code and a proportional one elsewhere")
    (description
     "Fixed-pitch mode is an Emacs minor mode for setting a monospaced typeface.
This allows you to set a proportional typeface for UI elements while keeping
a monospaced typeface for code.")
    (license license:gpl3+)))

(define-public emacs-mixed-pitch
  (package
    (name "emacs-mixed-pitch")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/jabranham/mixed-pitch.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1dhljrh44dsnixd8hbb11k6dgap8r8n7jknhfy2afdzq889fih74"))))
    (build-system emacs-build-system)
    (home-page "https://gitlab.com/jabranham/mixed-pitch")
    (synopsis "Mix variable- and fixed-pitch fonts in the same Emacs buffer")
    (description
     "@code{mixed-pitch-mode} is a minor mode that enables mixing
variable-pitch and fixed-pitch fonts in the same buffer.  The list
@code{mixed-pitch-fixed-pitch-faces} defines the faces that are kept
fixed-pitch,everything else becomes variable-pitch.")
    (license license:gpl3+)))

(define-public emacs-visual-regexp
  (package
    (name "emacs-visual-regexp")
    (version "1.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/benma/visual-regexp.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "12p3rlhdphwmx1kxsjzcl2wj3i6qgpvw8iwhg1whs6yqgaxivixd"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/benma/visual-regexp.el/")
    (synopsis "Regexp command with interactive visual feedback")
    (description "This package provides an Emacs regexp command with
interactive visual feedback.")
    (license license:gpl3+)))

(define-public emacs-faceup
  (let ((commit "6c92dad56a133e14e7b27831e1bcf9b3a71ff154")
        (revision "1"))
    (package
      (name "emacs-faceup")
      (version (string-append "0.0.1" "-" revision "."
                              (string-take commit 7)))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Lindydancer/faceup")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1yzmy7flrhrh0i10bdszx8idx6r8h6czm4vm4q0z6fp5fw94zwrx"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/Lindydancer/faceup")
      (synopsis "Markup language for faces and font-lock regression testing")
      (description "Emacs is capable of highlighting buffers based on
language-specific @code{font-lock} rules.  This package makes it possible to
perform regression test for packages that provide font-lock rules.")
      (license license:gpl3+))))

(define-public emacs-racket-mode
  ;; XXX: Upstream does not tag releases, nor does it bump versions.  The
  ;; "0.0.2" version below does not exist.  It might change, tho.  See
  ;; <https://github.com/greghendershott/racket-mode/issues/389>.
  (let ((commit "cef5a55d2b766973db92f9d9ab2210c03fa8ba02")
        (revision "7"))
    (package
      (name "emacs-racket-mode")
      (version (git-version "0.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/greghendershott/racket-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0zzk0s4akx6ffsbhylgfflcypkkg36a3accxhmmdd11yn5rckv7f"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:include #~(list "\\.el$" "\\.rkt$")))
      (propagated-inputs
       (list emacs-faceup emacs-paredit emacs-pos-tip emacs-s))
      (home-page "https://www.racket-mode.com/")
      (synopsis "Major mode for the Racket language")
      (description "Racket mode provides thorough font-lock and indentation.
It follows DrRacket concepts where applicable.")
      (license license:gpl2+))))

(define-public emacs-grep-context
  (let ((commit "5a4e3efdf775755c1bbefcfe4b461c1166d81d7d")
        (revision "1"))
    (package
      (name "emacs-grep-context")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mkcms/grep-context")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "00q7l4a3c0ay6g5ff9bfa2qgkiswsyh4s6pqnpg0zpzhvv5710f5"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash))
      (home-page "https://github.com/mkcms/grep-context")
      (synopsis "Increase context in compilation and grep buffers")
      (description
       "This package provides an Emacs package for more context in
compilation/grep buffers.  Works with @code{wgrep}, @code{ack}, @code{ag},
@code{ivy}.")
      (license license:gpl3+))))

(define-public emacs-helm-firefox
  (package
    (name "emacs-helm-firefox")
    (version "1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-helm/helm-firefox")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "08mjsi2f9s29fkk35cj1rrparjnkm836qmbfdwdz7y51f9varjbs"))))
    (propagated-inputs
     (list emacs-helm))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacs-helm/helm-firefox")
    (synopsis "Display firefox bookmarks with Emacs Helm interface")
    (description "Display firefox bookmarks with Emacs Helm interface")
    (license license:gpl3+)))

(define-public emacs-interactive-align
  (package
    (name "emacs-interactive-align")
    (version "0.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mkcms/interactive-align")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0bh03w91i622hbar5dcq631ndxx1y8kd3h655pgw1g0lqkv1mlnc"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/mkcms/interactive-align/")
    (synopsis "Interactive align-regexp command in Emacs")
    (description "Interactive align-regexp command in Emacs")
    (license license:gpl3+)))

(define-public emacs-shift-number
  (package
    (name "emacs-shift-number")
    (version "0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/alezost/shift-number.el")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0zlwmzsxkv4mkggylxfx2fkrwgz7dz3zbg2gkn2rxcpy2k2gla64"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/alezost/shift-number.el")
    (synopsis "Increase or decrease the number at point")
    (description "@code{emacs-shift-number} provides commands
@code{shift-number-up} to increase and @code{shift-number-down} to
decrease the number at point.")
    (license license:gpl3+)))

(define-public emacs-highlight-defined
  (package
    (name "emacs-highlight-defined")
    (version "0.1.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Fanael/highlight-defined")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0a9nn1jnbgv93kz1iz5iay34d0p7lkpd8ic619ysk8qcksc0yn2i"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Fanael/highlight-defined")
    (synopsis "Syntax highlighting of known Elisp symbols")
    (description "Minor mode providing syntax highlighting of known Emacs Lisp
symbols.  Currently the code distinguishes Lisp functions, built-in functions,
macros, faces and variables.  To enable call @code{highlight-defined-mode}.")
    (license license:gpl3+)))

(define-public emacs-parinfer-mode
  (package
    (name "emacs-parinfer-mode")
    (version "0.4.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/DogLooksGood/parinfer-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0v97ncb0w1slb0x8861l3yr1kqz6fgw1fwl1z9lz6hh8p2ih34sk"))))
    (propagated-inputs
     (list emacs-dash emacs-rainbow-delimiters emacs-company))
    (build-system emacs-build-system)
    (home-page "https://github.com/DogLooksGood/parinfer-mode/")
    (synopsis "Lisp structure editing mode")
    (description "@code{parinfer-mode} is a proof-of-concept editor
mode for Lisp programming languages.  It will infer some changes to
keep Parens and Indentation inline with one another.")
    (license license:gpl3+)))

(define-public emacs-helm-eww
  (package
    (name "emacs-helm-eww")
    (version "1.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacs-helm/helm-eww")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0hpq1h0p69c9k6hkd2mjpprx213sc5475q7pr2zpmwrjdzgcv70z"))))
    (propagated-inputs
     (list emacs-helm))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacs-helm/helm-eww/")
    (synopsis "Helm interface to EWW")
    (description "This package provides a Helm interface for EWW buffers,
bookmarks and history.")
    (license license:gpl3+)))

(define-public emacs-stumpwm-mode
    (let ((commit "920f8fc1488f7953f205e1dda4c2ecbbbda56d6")
        (revision "3"))
    (package
      (name "emacs-stumpwm-mode")
      (version (git-version "0.0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/stumpwm/stumpwm-contrib")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0giac390bq95ag41xkxqp8jjrhfx1wpgglz7jg5rkm0wjhcwmyml"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'chdir-elisp
             ;; Elisp directory is not in root of the source.
             (lambda _
               (chdir "util/swm-emacs"))))))
      (home-page "https://github.com/stumpwm/stumpwm-contrib")
      (synopsis "Emacs minor-mode for Stumpwm")
      (description "Emacs minor-mode for Stumpwm")
      (license license:gpl3+))))

(define-public emacs-irfc
  (package
    (name "emacs-irfc")
    (version "20130824.507-1")
    (source
     (origin
       (method url-fetch)
       (uri "https://www.emacswiki.org/emacs/download/irfc.el")
       (file-name (string-append "irfc-" version ".el"))
       (sha256
        (base32
         "0rbfrza56kvspvgrwg0b5bj30d0qncqdsmfxn3y5caq4ifcj77hv"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/download/irfc.el")
    (synopsis "Interface for IETF RFC document")
    (description
     "This package provides an Emacs interface for IETF RFC document.")
    (license license:gpl3+)))

(define-public emacs-ido-at-point
  (package
    (name "emacs-ido-at-point")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/katspaugh/ido-at-point")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1bii7vj8pmmijcpvq3a1scky4ais7k6d7zympb3m9dmz355m9rpp"))))
    (build-system emacs-build-system)
    (synopsis "Ido-style completion at point")
    (description
     "This package is an alternative frontend for @code{completion-at-point}.
It replaces the standard completions buffer with Ido prompt.")
    (home-page "https://github.com/katspaugh/ido-at-point")
    (license license:gpl3+)))

(define-public emacs-ido-vertical-mode
  (package
    (name "emacs-ido-vertical-mode")
    (version "0.1.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/creichert/ido-vertical-mode.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1lv82q639xjnmvby56nwqn23ijh6f163bk675s33dkingm8csj8k"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/creichert/ido-vertical-mode.el")
    (synopsis "Makes ido-mode display vertically")
    (description "Makes ido-mode display prospects vertically.")
    (license license:gpl3+)))

(define-public emacs-wordgen
  (package
    (name "emacs-wordgen")
    (version "0.1.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Fanael/wordgen.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "06vbc9ycz1nbjwjkg99y3lj6jwb6lnwnmkqf09yr00jjrrfhfash"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Fanael/wordgen.el")
    (synopsis "Random word generator")
    (description "This package provides functions to generate random words
using user-provided rules.")
    (license license:gpl3+)))

(define-public emacs-on
  (let ((commit "83baed07a105c135190d49d7ec77f95e8f38fa54")
        (revision "0"))
    (package
      (name "emacs-on")
      (version (git-version "0.1.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/ajgrf/on.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "14ly3w89hf4jgd8wacirxgd8vrgj7vc0hpfn911w5wa4k2a6nzpp"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/ajgrf/on.el")
      (synopsis "Hooks for faster Emacs startup")
      (description
       "This package exposes a number of utility hooks and functions ported
from Doom Emacs.")
      (license license:expat))))

(define-public emacs-on-screen
  (package
    (name "emacs-on-screen")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://elpa.gnu.org/packages/on-screen-" version ".el"))
       (file-name (string-append name "-" version ".el"))
       (sha256
        (base32 "0ga4hw23ki583li2z2hr7l6hk1nc2kdg4afndg06cm9jn158wza7"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/michael-heerdegen/on-screen.el")
    (synopsis "Guide your eyes while scrolling")
    (description
     "Scrolling can be distracting because your eyes may lose
orientation.  This library implements a minor mode that highlights
the previously visible buffer part after each scroll.")
    (license license:gpl3+)))

(define-public emacs-highlight-escape-sequences
  ;; No release upstream.  Extract version from main file.
  (let ((commit "08d846a7aa748209d65fecead2b6a766c3e5cb41")
        (revision "0"))
    (package
      (name "emacs-highlight-escape-sequences")
      (version (git-version "0.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dgutov/highlight-escape-sequences")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "05mc3w1f8ykf80914a1yddw6j8cmh0h57llm07xh89s53821v2is"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/dgutov/highlight-escape-sequences")
      (synopsis "Highlight escape sequences in Emacs")
      (description "@code{highlight-escape-sequences} provides an
Emacs minor mode to escape sequences in code.")
      (license license:gpl3+))))

(define-public emacs-dashboard
  (package
    (name "emacs-dashboard")
    (version "1.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rakanalh/emacs-dashboard")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1qv4cqjy2s2d2bysbq10vq1axpbd8qc3jn1s1r81lxqkcja8zasa"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-page-break-lines))
    (arguments
     '(#:include '("\\.el$" "\\.txt$" "\\.png$")
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-dashboard-widgets
           ;; This phase fixes compilation error.
           (lambda _
             (chmod "dashboard-widgets.el" #o666)
             (emacs-substitute-variables "dashboard-widgets.el"
               ("dashboard-init-info"
                '(format "Loaded in %s" (emacs-init-time))))
             #t)))))
    (home-page "https://github.com/rakanalh/emacs-dashboard")
    (synopsis "Startup screen extracted from Spacemacs")
    (description "This package provides an extensible Emacs dashboard, with
sections for bookmarks, projectil projects, org-agenda and more.")
    (license license:gpl3+)))

(define-public emacs-slime-company
  (package
    (name "emacs-slime-company")
    (version "1.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/anwyn/slime-company")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "05dnnc4ms5c9yp9h65k2gbkg3pw9k38nx5wzlwdlfr4shqmw54w0"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-slime emacs-company))
    (home-page "https://company-mode.github.io")
    (synopsis "SLIME completion backend for @code{company-mode}")
    (description
     "This is a backend implementation for the completion package
@code{company-mode} which supports the normal and the fuzzy completion
modes of SLIME.")
    (license license:gpl3+)))

(define-public emacs-sml-mode
  (package
    (name "emacs-sml-mode")
    (version "6.10")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/sml-mode-"
                           version ".el"))
       (sha256
        (base32 "01yf0s474r9xhj6nbs14ljn9ccxb5yy758i17c8nmgmqvm8fx7sb"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/sml-mode.html")
    (synopsis "Major mode for editing (Standard) ML")
    (description "SML-MODE is a major Emacs mode for editing Standard ML.
It provides syntax highlighting and automatic indentation and
comes with sml-proc which allows interaction with an inferior SML
interactive loop.")
    (license license:gpl3+)))

(define-public emacs-eros
  (let ((commit "dd8910279226259e100dab798b073a52f9b4233a")
        (revision "2"))
    (package
      (name "emacs-eros")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/xiongtx/eros")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "08chj3a0lw4ygi2sv7wj0i6ihfbi8jhylr8p92inif8b88r6wg3k"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/xiongtx/eros")
      (synopsis "Evaluation result overlays")
      (description "@code{eros} provides evaluation result overlays.")
      (license license:gpl3+))))

(define-public emacs-stickyfunc-enhance
  (let ((commit "13bdba51fcd83ccbc3267959d23afc94d458dcb0")
        (revision "1"))
    (package
      (name "emacs-stickyfunc-enhance")
      (version "0.1")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tuhdo/semantic-stickyfunc-enhance")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "16dxjsr5nj20blww4xpd4jzgjprzzh1nwvb810ggdmp9paf4iy0g"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/tuhdo/semantic-stickyfunc-enhance")
      (synopsis "Enhancement to stock @code{semantic-stickyfunc-mode}")
      (description
       "@code{semantic-stickyfunc-mode} shows the function point is currently
in at the first line of the current buffer.  This is useful when you have a
very long function that spreads more than a screen, and you don't have to
scroll up to read the function name and then scroll down to original position.")
      (license license:gpl3+))))

(define-public emacs-git-auto-commit-mode
  (package
    (name "emacs-git-auto-commit-mode")
    (version "4.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ryuslash/git-auto-commit-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0gpib57f7xza04g3iyihw5v15hb7pncqsmvyggib902yvcxlkvqf"))))
    (build-system emacs-build-system)
    (native-inputs
     (list emacs-buttercup git))
    (arguments
     `(#:tests? #t
       #:test-command '("buttercup" "-L" ".")))
    (home-page "https://github.com/ryuslash/git-auto-commit-mode")
    (synopsis "Emacs Minor mode to automatically commit and push")
    (description "@code{git-auto-commit-mode} is an Emacs minor mode that
tries to commit changes to a file after every save.

When @code{gac-automatically-push-p} is non-nil, it also tries to push to the
current upstream.")
    (license license:gpl3+)))

(define-public emacs-scroll-on-drag
  (let ((commit "888abd04c34753b1fc4b2fe541bc004ebec5c996")
        (revision "1"))
    (package
      (name "emacs-scroll-on-drag")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/ideasman42/emacs-scroll-on-drag.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1si4hdqa3jw1inbyh3wb3i5i9grbms1nwky3vyk9zg7iznwm8a9p"))))
      (build-system emacs-build-system)
      (home-page "https://gitlab.com/ideasman42/emacs-scroll-on-drag")
      (synopsis "Interactive scrolling")
      (description "This package permits scrolling at increasing speeds based
on drag distance.")
      (license license:gpl3+))))

(define-public emacs-company-restclient
  (package
    (name "emacs-company-restclient")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/iquiw/company-restclient")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0yp0hlrgcr6yy1xkjvfckys2k24x9xg7y6336ma61bdwn5lpv0x0"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-company emacs-know-your-http-well emacs-restclient))
    (home-page "https://github.com/iquiw/company-restclient")
    (synopsis "Company-mode completion back-end for restclient-mode")
    (description "@code{company-mode} back-end for
@code{restclient-mode}.

It provides auto-completion for HTTP methods and headers in
@code{restclient-mode}.  Completion source is given by
@code{know-your-http-well}.")
    (license license:gpl3+)))

(define-public emacs-noflet
  (let ((version "20170629")
        (revision "1")
        (commit "7ae84dc3257637af7334101456dafe1759c6b68a"))
    (package
      (name "emacs-noflet")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/nicferrier/emacs-noflet")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0g70gnmfi8n24jzfci9nrj0n9bn1qig7b8f9f325rin8h7x32ypf"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'require-dash
             ;; noflet.el uses -map from dash, but (require 'dash) is
             ;; missing. So, add it.
             (lambda _
               (substitute* "noflet.el"
                 ((";;; Code:") ";;; Code:\n(require 'dash)"))
               #t)))))
      (propagated-inputs
       (list emacs-dash))
      (home-page "https://github.com/nicferrier/emacs-noflet")
      (synopsis "Locally override functions")
      (description "@code{emacs-noflet} lets you locally override functions,
in the manner of @command{flet}, but with access to the original function
through the symbol: @command{this-fn}.")
      (license license:gpl3+))))

(define-public emacs-dumb-jump
  (package
    (name "emacs-dumb-jump")
    (version "0.5.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jacktasia/dumb-jump")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "18d2ll5wlll6pm909hiw8w9ijdbrjvy86q6ljzx8yyrjphgn0y1y"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #f                      ; FIXME: Tests freeze when run.
       #:test-command '("ert-runner")
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-shell
           (lambda _
             ;; Setting the SHELL environment variable is required for the
             ;; tests to find sh.
             (setenv "SHELL" (which "sh")))))))
    (native-inputs
     (list emacs-el-mock emacs-ert-runner emacs-noflet emacs-undercover))
    (propagated-inputs
     (list emacs-f emacs-popup))
    (home-page "https://github.com/jacktasia/dumb-jump")
    (synopsis "Jump to definition for multiple languages without configuration")
    (description "Dumb Jump is an Emacs \"jump to definition\" package with
support for multiple programming languages that favors \"just working\" over
speed or accuracy.  This means minimal --- and ideally zero --- configuration
with absolutely no stored indexes (tags) or persistent background processes.
Dumb Jump performs best with The Silver Searcher @command{ag} or ripgrep
@command{rg} installed.")
    (license license:gpl3+)))

(define-public emacs-dts-mode
  (package
    (name "emacs-dts-mode")
    (version "1.0")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/dts-mode-"
                                  version ".tar"))
              (sha256
               (base32
                "0ihwqkv1ddysjgxh01vpayv3ia0vx55ny8ym0mi5b4iz95idj60s"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/dts-mode.html")
    (synopsis "Major mode for Device Tree source files")
    (description
     "This package provides an Emacs minor mode for highlighting
device tree files.")
    (license license:gpl3+)))

(define-public emacs-daemons
  (package
    (name "emacs-daemons")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cbowdon/daemons.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "00bkzfaw3bqykcks610vk9wlpa2z360xn32bpsrycacwfv29j7g4"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/cbowdon/daemons.el")
    (synopsis "Emacs UI for managing init system services")
    (description
     "This is an Emacs mode to give you a UI for managing init system
daemons (services) for those getting tired of typing out @code{sudo service
my_thing reload} all the time.  It offers a consistent UI over different init
systems.")
    (license license:gpl3+)))

(define-public emacs-isearch+
  (let ((commit "7c251b91a67bf914066e23e269ba52fda5b45f5f")
        (revision "2"))
    (package
      (name "emacs-isearch+")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsmirror/isearch-plus")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1w2799714jcdycjlxgs8lpmmz6dmzvcvqy8xwxhvmgpb60g4f2yr"))))
      (build-system emacs-build-system)
      (home-page "https://www.emacswiki.org/emacs/isearch+.el")
      (synopsis "Extensions to @code{isearch.el}")
      (description "This package extends @code{isearch} with advice, dynamic
filters, highlighting of regexp group levels, and more.")
      (license license:gpl2+))))

(define-public emacs-eshell-bookmark
  (package
    (name "emacs-eshell-bookmark")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Fuco1/eshell-bookmark")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "14dmsnixf9vqdhsixw693sml0fn80zcf0b37z049fb40cmppqxdw"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Fuco1/eshell-bookmark")
    (synopsis "Provide @file{bookmark.el} integration for @code{eshell}")
    (description
     "This package allows for bookmarking @code{eshell} buffers.  Upon
visiting the bookmark, a new @code{eshell} session will be opened in the
appropriate directory if no @code{eshell} session is active.")
    (license license:gpl3+)))

(define-public emacs-eshell-syntax-highlighting
  (package
    (name "emacs-eshell-syntax-highlighting")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/akreisher/eshell-syntax-highlighting")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fb9aa85a3hx1rcmv71j6sc3y278452p1y4dabpwy07avb6apd0p"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/akreisher/eshell-syntax-highlighting")
    (synopsis "Add syntax highlighting to Eshell")
    (description
     "This package highlights user commands at the Eshell interactive prompt
to provide feedback on the validity of commands and syntax.")
    (license license:gpl3+)))

(define-public emacs-eshell-z
  (package
    (name "emacs-eshell-z")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/xuchunyang/eshell-z")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "13dwaq8q23rwmrkpy3gvf7aswrkk6b9ak5221xl7n0bld4wdhq3j"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/xuchunyang/eshell-z")
    (synopsis "Quick navigation to frequently visited directories")
    (description
     "This package is a port of @code{z}, and keeps track of visited directories
and commands invoked within them in order to enable navigation via input of
matching regexps.")
    (license license:gpl3+)))

(define-public emacs-esh-autosuggest
  (package
    (name "emacs-esh-autosuggest")
    (version "2.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dieggsy/esh-autosuggest")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0l2nnlr3b6df1xn0qjf5d5ryy1wcs1jczyfy795vsasd5gm3g0xh"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-company))
    (home-page "https://github.com/dieggsy/esh-autosuggest")
    (synopsis "Fish-like autosuggestions in Eshell")
    (description
     "This package assumes you use something other than company for eshell
completion (e.g. @code{eshell-pcomplete}, @code{completion-at-point},
@code{helm-esh-pcomplete}).  @code{company-mode} is used solely as a mechanism
for history autosuggestions.

Unless you're using @code{use-package}'s hook keyword, you can enable the
autosuggestions with:
@code{(add-hook 'eshell-mode-hook #'esh-autosuggest-mode)}")
    (license license:gpl3+)))

(define-public emacs-desktop-environment
  (package
    (name "emacs-desktop-environment")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/DamienCassou/desktop-environment")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "03rl1z860jmirjrrg0xsjx0bqk73k043c8bz6049zhndh7pidri7"))))
    (build-system emacs-build-system)
    (home-page "https://gitlab.petton.fr/DamienCassou/desktop-environment")
    (synopsis "Control your GNU/Linux desktop environment from Emacs")
    (description
     "This package helps you control your GNU/Linux desktop from Emacs.
With @code{desktop-environment}, you can control the brightness and volume as
well as take screenshots and lock your screen.  The package depends on the
availability of shell commands to do the hard work for us.  These commands can
be changed by customizing the appropriate variables.")
    (license license:gpl3+)))

(define-public emacs-org-caldav
  (let ((commit "8569941a0a5a9393ba51afc8923fd7b77b73fa7a")
        (revision "2"))
    (package
      (name "emacs-org-caldav")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dengste/org-caldav")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "05lgxqaffnqaqnzl24frafdkskran88hl2ml05qvyjhs4jjbgw9g"))))
      (build-system emacs-build-system)
      (arguments
       ;; Tests require to have two specific calendars on a test server.
       `(#:exclude '("^org-caldav-testsuite\\.el")))
      (propagated-inputs
       (list emacs-org))
      (home-page "https://github.com/dengste/org-caldav")
      (synopsis "Sync Org files with external calendars via the CalDAV protocol")
      (description
       "Org CalDAV synchronizes events between Org files and a CalDAV
calendar.")
      (license license:gpl3+))))

(define-public emacs-zotxt
  (package
    (name "emacs-zotxt")
    (version "5.0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/egh/zotxt-emacs")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1zr67h0w49rsi84mgf6jdili28h8782q6vjl8za0iq1hcx9zqxyf"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-deferred emacs-request))
    (home-page "https://github.com/egh/zotxt-emacs")
    (synopsis "Integrate Emacs with Zotero")
    (description "This package provides two integration features between Emacs
and the Zotero research assistant: Insertion of links to Zotero items into an
Org-mode file, and citations of Zotero items in Pandoc Markdown files.")
    (license license:gpl3+)))

(define-public emacs-evil-multiedit
  (package
    (name "emacs-evil-multiedit")
    (version "1.4.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hlissner/evil-multiedit")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08ycwss58zh2zikk79jfj074q78yjcd7vbjgv5ssqvws09x5rgfq"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-evil emacs-iedit))
    (native-inputs
     (list emacs-ert-runner))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'fix-checks
           (lambda _
             (substitute* "Makefile"
               (("@cask exec ") ""))
             (substitute* "test/test-helper.el"
               (("'\\(evil iedit\\)") "nil")))))
       #:tests? #t
       #:test-command '("make" "test")))
    (home-page "https://github.com/hlissner/evil-multiedit")
    (synopsis "Multiple cursors for Evil mode")
    (description
     "This plugin was an answer to the lack of proper multiple cursor support
in Emacs+Evil.  It allows you to select and edit matches interactively,
integrating @code{iedit-mode} into Evil mode with an attempt at sensible
defaults.")
    (license license:gpl3+)))

(define-public emacs-evil-mc
  (let ((commit "1cabb869fe70cef49f7dc06f015c3ade1a969c8c")
        (revision "2"))
    (package
      (name "emacs-evil-mc")
      (version (git-version "0.0.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/gabesoft/evil-mc")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0p83p90faq1p02lmsfs7zrnky3cyzgy8z4m83a81r9kakjzhkrnb"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-evil))
      (native-inputs
       (list emacs-espuds))
      (home-page "https://github.com/gabesoft/evil-mc")
      (synopsis "Interactive search compatible with @code{multiple-cursors}")
      (description "This package can be used with @code{multiple-cursors} to
provide an incremental search that moves all fake cursors in sync.")
      (license license:expat))))

(define-public emacs-evil-org
  (let ((commit "0d10ff7bb9a3a93d25cd91018b17f0a052b335f3")
        (revision "2"))
    (package
      (name "emacs-evil-org")
      (version (git-version "1.0.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Somelauw/evil-org-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "15g47xgpswzc8lz7qdbbzfcq1n9m4474qa2jkg43l8d5ali8qa7z"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (home-page
       "https://github.com/Somelauw/evil-org-mode")
      (synopsis "Evil keybindings for Org mode")
      (description
       "This package adds supplemental Evil mode key-bindings to Emacs
Org-mode.  It features:
@itemize
@item normal, visual and insert mode bindings;
@item key bindings organised in key themes;
@item operators like > and < to work on headings;
@item text objects;
@item table support;
@item calendar (date selection) support;
@item agenda support.
@end itemize\n")
      (license license:gpl3+))))

(define-public emacs-debpaste
  (package
    (name "emacs-debpaste")
    (version "0.1.5")
    (home-page "https://github.com/alezost/debpaste.el")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference (url home-page)
                           (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1wi70r56pd5z0x4dp4m58p9asq03j74kdm4fi9vai83vsl2z9amq"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-xml-rpc))
    (synopsis "Manipulate pastes from the Debian Pastezone")
    (description "Debpaste is an Emacs interface for the Debian Pastezone,
allowing you to receive, post, and delete pastes.  It communicates with the
server using XML-RPC.")
    (license license:gpl3+)))

(define-public emacs-xml-rpc
  (package
    (name "emacs-xml-rpc")
    (version "1.6.15")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hexmode/xml-rpc-el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "07vgwnk96i1vpsv2glg6kbkamjcs72xiznsa6xk7nl0nranzr3hd"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/hexmode/xml-rpc-el")
    (synopsis "XML-RPC client for Emacs")
    (description "This package provides an XML-RPC client for Emacs capable
of both synchronous and asynchronous method calls using the @code{url}
package's async retrieval functionality.  @file{xml-rpc.el} represents XML-RPC
datatypes as Lisp values, automatically converting to and from the XML
datastructures as needed, both for method parameters and return values, making
using XML-RPC methods fairly transparent to the Lisp code.")
    (license license:gpl3+)))

(define-public emacs-xpm
  (package
    (name "emacs-xpm")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/xpm-"
                           version ".tar"))
       (sha256
        (base32 "13p6s6b2v7h4bnwdkkrd1qz84jd7g2s18w0czhpxv6hvj9sqf5hx"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/xpm.html")
    (synopsis "XPM image editing mode for Emacs")
    (description "This Emacs package makes editing XPM images easy (and maybe
fun).  Editing is done directly on the (textual) image format, for maximal
cohesion with the Emacs Way.")
    (license license:gpl3+)))

(define-public emacs-fish-completion
  (package
    (name "emacs-fish-completion")
    (version "1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/Ambrevar/emacs-fish-completion.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "17lqip1i1rrsvxzz4bx9rqf1fvwd3hriwg3sj6qxmfc8pylnp37q"))))
    (build-system emacs-build-system)
    (inputs (list fish))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let ((fish (assoc-ref inputs "fish")))
               ;; Specify the absolute file names of the various
               ;; programs so that everything works out-of-the-box.
               (make-file-writable "fish-completion.el")
               (emacs-substitute-variables
                   "fish-completion.el"
                 ("fish-completion-command"
                  (string-append fish "/bin/fish")))))))))
    (home-page
     "https://gitlab.com/Ambrevar/emacs-fish-completion")
    (synopsis "Fish completion for Emacs pcomplete")
    (description
     "This package provides completion for the Fish shell to pcomplete (used
by shell and Eshell).  You can set it up globally with:

@example
(when (and (executable-find \"fish\")
           (require 'fish-completion nil t))
  (global-fish-completion-mode))
@end example

Alternatively, you can call the @code{fish-completion-mode} manually or in
shell/Eshell mode hook.

The package @code{emacs-bash-completion} is an optional dependency: if available,
@code{fish-completion-complete} can be configured to fall back on bash to further
try completing.  See @code{fish-completion-fallback-on-bash-p}.")
    (license license:gpl3+)))

(define-public emacs-gif-screencast
  (package
    (name "emacs-gif-screencast")
    (version "1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/Ambrevar/emacs-gif-screencast.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1yf6yipvhhna29mzaan5vb3d5qvbrkp2awr5diyf381mvxgk8akh"))))
    (build-system emacs-build-system)
    (inputs
     (list scrot imagemagick gifsicle))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let ((scrot (assoc-ref inputs "scrot"))
                   (imagemagick (assoc-ref inputs "imagemagick"))
                   (gifsicle (assoc-ref inputs "gifsicle")))
               (make-file-writable "gif-screencast.el")
               ;; Specify the absolute file names of the various
               ;; programs so that everything works out-of-the-box.
               (emacs-substitute-variables
                   "gif-screencast.el"
                 ("gif-screencast-program"
                  (string-append scrot "/bin/scrot"))
                 ("gif-screencast-convert-program"
                  (string-append imagemagick "/bin/convert"))
                 ("gif-screencast-cropping-program"
                  (string-append imagemagick "/bin/mogrify"))
                 ("gif-screencast-optimize-program"
                  (string-append gifsicle "/bin/gifsicle")))))))))
    (home-page
     "https://gitlab.com/Ambrevar/emacs-gif-screencast")
    (synopsis "One-frame-per-action GIF recording")
    (description
     "Call @code{gif-screencast} to start a recording.
A screenshot is taken for every user action.  Call
@code{gif-screencast-stop} (<f9> by default) to finish recording and create
the GIF result.")
    (license license:gpl3+)))

(define-public emacs-google-translate
  (package
    (name "emacs-google-translate")
    (version "0.12.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/atykhonov/google-translate/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0rwpij2bm8d4jq2w5snkp88mfryplw8166dsrjm407n2p6xr48zx"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/atykhonov/google-translate")
    (synopsis "Emacs interface to Google Translate")
    (description
     "This package provides an Emacs interface to the Google Translate
on-line service.")
    (license license:gpl3+)))

(define-public emacs-helm-company
  (package
    (name "emacs-helm-company")
    (version "0.2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Sodel-the-Vociferous/helm-company")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1ci37w6ahnqrfpb284gjvxmimlf61sdxb9k192yy9q983cksv2hx"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm emacs-company))
    (native-inputs
     (list emacs-ert-runner))
    (arguments
     `(#:tests? #t
       #:test-command '("ert-runner")))
    (home-page "https://github.com/Sodel-the-Vociferous/helm-company")
    (synopsis "Helm interface for company-mode")
    (description
     "This is a Helm interface to company-mode, a text completion
framework.")
    (license license:gpl3+)))

(define-public emacs-helm-descbinds
  (let ((commit "033be73f21778633813264ce1634a6e1ad873d8e"))
    (package
      (name "emacs-helm-descbinds")
      (version (git-version "1.13" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-helm/helm-descbinds")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1n89p56qwa243w1c85i5awnaf7piwjsvfi7nmnsrwm33hix5dknk"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-helm))
      (home-page "https://github.com/emacs-helm/helm-descbinds")
      (synopsis "Convenient @code{describe-bindings} with Helm")
      (description
       "This package is a replacement of @code{describe-bindings} for Helm.
@code{describe-bindings} is replaced with @code{helm-descbinds}.  As usual,
type @code{C-h b}, or any incomplete key sequence plus @code{C-h}, to run
@code{helm-descbinds}.  The bindings are presented in a similar way as
@code{describe-bindings} does, but you can use completion to find the command
you searched for and execute it, or view its documentation.")
    (license license:gpl3+))))

(define-public emacs-helm-emms
  (let ((commit "37e5aa029abfa5a5c48636314de8157142944fa2"))
    (package
      (name "emacs-helm-emms")
      (version (git-version "1.3" "3" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-helm/helm-emms")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0r1ai6xhzayyik30w2sx9n62bxxwm12vfmjspv0daqif9az8y3vg"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-helm emacs-emms))
      (home-page
       "https://github.com/emacs-helm/helm-emms")
      (synopsis "Emms for Helm")
      (description "Helm interface for Emms to browse all tracks and all folders
from @code{emms-source-file-default-directory}.")
      (license license:gpl3+))))

(define-public emacs-helm-exwm
  (package
    (name "emacs-helm-exwm")
    (version "0.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-helm/helm-exwm")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0g4k01ps14bp2az8v6dcag9llg045k2b4kdis81xx4lvw76znr9v"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm emacs-exwm))
    (home-page
     "https://github.com/emacs-helm/helm-exwm")
    (synopsis "Helm for EXWM buffers")
    (description
     "@code{helm-exwm} runs a Helm session over the list of EXWM buffers.
@code{helm-exwm-switch} is a convenience X application launcher using Helm to
switch between the various windows of one or several specific applications.
See @code{helm-exwm-switch-browser} for an example.")
    (license license:gpl3+)))

(define-public emacs-helm-flycheck
  (let ((commit "3cf7d3bb194acacc6395f88360588013d92675d6"))
    (package
      (name "emacs-helm-flycheck")
      (version (git-version "0.4" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/yasuyk/helm-flycheck")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1a2yfxhz04klwhcandqvfzysxp6b7bxyxx1xk1x3kds5hif5fkl4"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash emacs-flycheck emacs-helm))
      (home-page "https://github.com/yasuyk/helm-flycheck")
      (synopsis "Show Flycheck errors with Helm")
      (description
       "This integrates Flycheck with Helm.")
      (license license:gpl3+))))

(define-public emacs-helm-ls-git
  (package
    (name "emacs-helm-ls-git")
    (version "1.9.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-helm/helm-ls-git")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "097zpwpn18dgazp19czrcn6iz965qgr45gq9lvjrkkp0w03pbdb6"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-helm))
    (home-page "https://github.com/emacs-helm/helm-ls-git")
    (synopsis "Helm interface for listing the files in a Git repository")
    (description
     "This package provides a Helm interface for Git files.
@itemize
@item Display the open buffers in project.
@item Display a status source showing state of project (modified files etc.).
@item Display a list of all files in project under git control.
@item Quickly look at diffs of modified files.
@item Allow switching to @code{git status} with your preferred frontend
(vc-dir, Magit,etc.).
@item Full integration of git-grep, also allow usage of @code{helm-grep} (you
can use ack-grep instead of grep).
@item Integrate usage of gid from id-utils.
@item Full integration with @code{helm-find-files}, allow you to browse
projects unrelated to current-buffer.
@item In addition, all actions of type files and buffers are provided.
@end itemize\n")
    (license license:gpl3+)))

(define-public emacs-helm-mu
  (let ((commit "77e6fea24e01481418738421dbcfe28ef1bd63cf"))
    (package
      (name "emacs-helm-mu")
      (version (git-version  "20180513" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-helm/helm-mu")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1lh0ahxdc5b2z18m9p30gwg8sbg33sjwkjr38p7h5xsm5fm7i0fz"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-helm mu))
      (home-page
       "https://github.com/emacs-helm/helm-mu")
      (synopsis
       "Helm sources for searching emails and contacts")
      (description
       "Helm sources for searching emails and contacts using @code{mu} and
@code{mu4e}.  Mu is an indexer for maildirs and mu4e is a mutt-like MUA for
Emacs build on top of mu.  Mu is highly efficient making it possible to get
instant results even for huge maildirs.  It also provides search operators,
e.g: @code{from:Peter to:Anne flag:attach search term}.")
      (license license:gpl3+))))

(define-public emacs-helm-pass
  (package
    (name "emacs-helm-pass")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-helm/helm-pass")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "19w24isddzamkikq17vbv3y7ha22i7wc09d2nqw1j0qwhrrfkng9"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm emacs-password-store))
    (home-page "https://github.com/emacs-helm/helm-pass")
    (synopsis "Helm interface to pass, the standard Unix password manager")
    (description
     "Users of @code{helm-pass} may also be interested in functionality
provided by other Emacs packages dealing with pass:
@itemize
@item @code{emacs-password-store}, which @code{helm-pass} relies on.
@item @code{emacs-pass}, a major mode for @code{pass}.
@item @code{auth-source-pass.el}: integration of Emacs' auth-source with
@code{pass}, included in Emacs 26+).
@end itemize\n")
    (license license:gpl3+)))

(define-public emacs-image+
  (let ((commit "6834d0c09bb4df9ecc0d7a559bd7827fed48fffc"))
    (package
      (name "emacs-image+")
      (version (git-version "0.6.2" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mhayashi1120/Emacs-imagex")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0v66wk9nh0raih4jhrzmmyi5lbysjnmbv791vm2230ffi2hmwxnd"))))
      (build-system emacs-build-system)
      (inputs (list imagemagick))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'configure
             (lambda* (#:key inputs outputs #:allow-other-keys)
               (let ((imagemagick (assoc-ref inputs "imagemagick")))
                 ;; Specify the absolute file names of the various
                 ;; programs so that everything works out-of-the-box.
                 (chmod "image+.el" #o666)
                 (emacs-substitute-variables
                     "image+.el"
                   ("imagex-convert-command"
                    (string-append imagemagick "/bin/convert"))
                   ("imagex-identify-command"
                    (string-append imagemagick "/bin/identify")))))))))
      (home-page "https://github.com/mhayashi1120/Emacs-imagex")
      (synopsis "Image manipulation extensions for Emacs")
      (description
       "Image+ provides keybindings allowing you to zoom in or zoom out of an
image, rotate it, save modified images, and more.")
      (license license:gpl3+))))

(define-public emacs-package-lint
  (package
    (name "emacs-package-lint")
    (version "0.16")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/package-lint")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0srqcrhbdmd39jdsvh8k3nbrkqrl4nlic59dp5bal5vj495j7126"))))
    (arguments
     '(#:include (cons "^data/" %default-include)))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/package-lint")
    (synopsis "Linting library for elisp package authors")
    (description
     "This provides a list of issues with the Emacs package metadata of a file,
e.g. the package dependencies it requires.  See function
@code{package-lint-buffer}.  Checks will currently be enabled only if a
\"Package-Requires:\" or \"Package-Version:\" header is present in the
file.")
    (license license:gpl3+)))

(define-public emacs-packed
  (package
    (name "emacs-packed")
    (version "3.0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacscollective/packed")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gpv2vaci0m48fzn0sy7iwl1mnkkqc30bf05jjrqlpn9kpbjyf1p"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacscollective/packed")
    (synopsis "Package manager agnostic Emacs Lisp package utilities")
    (description
     "Packed provides some package manager agnostic utilities to work
with Emacs Lisp packages.  As far as Packed is concerned packages
are collections of Emacs Lisp libraries that are stored in a
dedicated directory such as a Git repository.  And libraries are
Emacs Lisp files that provide the correct feature (matching the
filename).

Where a package manager might depend on metadata, Packed instead
uses some heuristics to get the same information---that is slower
and might also fail at times but makes it unnecessary to maintain
package recipes.")
    (license license:gpl3+)))

(define-public emacs-dpd
  (package
    (name "emacs-dpd")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/lilyp/emacs-dpd")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0wrqmpfcqp87dr5blpskf9kvm9slvffldqfxx77n15gcw516zzc8"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-packed))
    (home-page "https://gitlab.com/lilyp/emacs-dpd")
    (synopsis "Deliver packages to package.el")
    (description
     "This package provides tools for generating package-desc structures and
feeding them to package.el library.")
    (license license:gpl3+)))

(define-public emacs-picpocket
  (let ((version "41")
        (commit "fa3a49f011b5ae139728548fec7375743f61c7c7"))
    (package
      (name "emacs-picpocket")
      (version version)
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/johanclaesson/picpocket")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1vb358jyfs3px70ah60dmlz5azdfkva9xrw3mgrr4060vcy7w4q1"))))
      (build-system emacs-build-system)
      (arguments ; needed for running tests
       `(#:tests? #t
         #:emacs ,emacs
         #:test-command '("emacs" "--batch"
                          "-l" "picpocket-test.el"
                          "-f" "ert-run-tests-batch-and-exit")))
      (home-page "https://github.com/johanclaesson/picpocket")
      (synopsis "Image viewer for Emacs")
      (description
       "Picpocket is an image viewer for GNU Emacs.  It has commands for:
@itemize
@item File operations on the picture files (delete, move, copy, hardlink).
@item Scale and rotate the picture.
@item Associate pictures with tags which are saved to disk.
@item Filter pictures according to tags.
@item Customizing keystrokes for quick tagging and file operations.
@item Undo and browse history of undoable commands.
@end itemize")
      (license license:gpl3+))))

(define-public emacs-mu4e-conversation
  (let ((commit "98110bb9c300fc9866dee8e0023355f9f79c9b96")
        (revision "5"))
    (package
      (name "emacs-mu4e-conversation")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/Ambrevar/mu4e-conversation.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "080s96jkcw2p288sp1vgds91rgl693iz6hi2dv56p2ih0nnivwlg"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list mu))
      (home-page
       "https://gitlab.com/Ambrevar/mu4e-conversation")
      (synopsis
       "Show a complete thread in a single buffer")
      (description
       "This package offers an alternate view to mu4e's e-mail display.  It
shows all e-mails of a thread in a single view, where each correspondent has
their own face.  Threads can be displayed linearly (in which case e-mails are
displayed in chronological order) or as an Org document where the node tree
maps the thread tree.")
      (license license:gpl3+))))

(define-public emacs-pinentry
  (let ((commit "dcc9ba03252ee5d39e03bba31b420e0708c3ba0c")
        (revision "1"))
    (package
      (name "emacs-pinentry")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method url-fetch)
         (uri (string-append
               "http://git.savannah.gnu.org/cgit/emacs/elpa.git/plain"
               "/packages/pinentry/pinentry.el?id=" commit))
         (file-name (string-append "pinentry.el"))
         (sha256
          (base32
           "1lf30q6r8nz5cjzclbb9bbymsk2y75nskvb55hnjdv93gr3j0sik"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list gnupg))
      (home-page "https://elpa.gnu.org/packages/pinentry.html")
      (synopsis "GnuPG Pinentry server implementation")
      (description
       "This package allows GnuPG passphrase to be prompted through the
minibuffer instead of graphical dialog.

To use, add @code{allow-emacs-pinentry} to @code{~/.gnupg/gpg-agent.conf},
reload the configuration with @code{gpgconf --reload gpg-agent}, and start the
server with @code{M-x pinentry-start}.")
      (license license:gpl3+))))

(define-public emacs-so-long
  (package
    (name "emacs-so-long")
    (version "1.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.savannah.gnu.org/git/so-long")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "06a76ajfqgz48yqvvyhi5b9zss9c6h4xz6acg98ibg0v99v9k5pz"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/SoLong")
    (synopsis "Improve performance in files with long lines")
    (description "This package improves the performance of Emacs when
viewing files with long lines.  It is included as standard with Emacs 27 or
later.")
    (license license:gpl3+)))

(define-public emacs-srfi
  ;; SRFI data gets updated quite frequently; lastest tag is from
  ;; 2020; commit from 2021-08-12.
  (let ((commit "e31bf04a3be3aad1286b7fe919c2e4810aae751e")
        (revision "0"))
    (package
      (name "emacs-srfi")
      (version (git-version "0.3" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/srfi-explorations/emacs-srfi")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "01n3yrjrdl2gdhvgd56lpjqg9d82mmrnb0h6hxdx4h5hy8sbk2p4"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/srfi-explorations/emacs-srfi")
      (synopsis "Scheme Requests for Implementation browser in Emacs")
      (description
       "This package shows a list of all SRFIs and provides commands to visit
them in your web browser.")
      (license license:expat))))

(define-public emacs-github-review
  (let ((commit "a13a3b4f1b6114a32af843971a145ab880f51232")
        (revision "2"))
    (package
      (name "emacs-github-review")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/charignon/github-review")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0injfpxzgfhmqalba845j5l5cdcxxqz43knhxwinf36g52nfabl0"))))
      (build-system emacs-build-system)
      (inputs
       (list emacs-dash emacs-s emacs-ghub))
      (native-inputs
       (list emacs-buttercup emacs-undercover))
      (arguments
       `(#:tests? #t
         #:test-command '("buttercup" "-L" "test/github-review-test.el")))
      (home-page "https://github.com/charignon/github-review")
      (synopsis "Review GitHub pull requests within Emacs")
      (description "This package provides commands to pull in, comment on, and
accept and reject GitHub pull requests.")
      (license license:gpl3+))))

(define-public emacs-deadgrep
  (package
    (name "emacs-deadgrep")
    (version "0.12")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Wilfred/deadgrep")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0bwf8gsqw7hsmacqd34piwgv066ijfclmxaigkvhvpac0lpsmi79"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #t
      #:test-command #~(list "ert-runner")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'configure
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((ripgrep (search-input-file inputs "/bin/rg")))
                ;; Specify the absolute file name of rg so that everything
                ;; works out-of-the-box.
                (emacs-substitute-variables "deadgrep.el"
                  ("deadgrep-executable" ripgrep))))))))
    (native-inputs
     (list emacs-ert-runner emacs-undercover))
    (inputs
     (list ripgrep))
    (propagated-inputs
     (list emacs-dash emacs-s emacs-spinner))
    (home-page "https://github.com/Wilfred/deadgrep")
    (synopsis "Frontend for @code{ripgrep}")
    (description "This package provides an Emacs interface for performing
searches with @code{ripgrep}.")
    (license license:gpl3+)))

(define-public emacs-focus
  (package
    (name "emacs-focus")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/larstvei/Focus")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0qbzbs18isxyf5yiz64vyxvzjpfjdaafxnas2lhx3sjkgglb08i2"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/larstvei/Focus")
    (synopsis "Minor mode for focusing in on relevant text")
    (description "This package provides a minor mode that dims the color of
text in neighboring sections.")
    (license license:gpl3+)))

(define-public emacs-pandoc-mode
  (package
    (name "emacs-pandoc-mode")
    (version "2.32")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joostkremers/pandoc-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1yn9mdlxcv9d33nvgy3wp09qhynb2m50cyhsv1xf77wyzlwdlb2p"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-hydra))
    (home-page "https://github.com/joostkremers/pandoc-mode")
    (synopsis "Minor mode for interacting with Pandoc")
    (description "This package provides a Hydra menu for interacting with the
Pandoc, the document-conversion tool.")
    (license license:bsd-3)))

(define-public emacs-hlint-refactor-mode
  (let ((commit "c4307f86aad6d02e32e9b30cb6edc115584c791c")
        (revision "1"))
    (package
      (name "emacs-hlint-refactor-mode")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mpickering/hlint-refactor-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1c71w9s34n0i7mm4njchxn6s3ri1y6mh3akgbg4nq41d42h8iap3"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list apply-refact hlint))
      (home-page "https://github.com/mpickering/hlint-refactor-mode")
      (synopsis "Emacs bindings for @code{hlint}'s @code{--refactor} option")
      (description "This package applies refactoring suggestions from
@code{hlint}.")
      (license license:expat))))

(define-public emacs-ccls
  (let ((commit "675a5704c14a27931e835a431beea3631d92e8e6")
        (revision "5"))
    (package
      (name "emacs-ccls")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/MaskRay/emacs-ccls")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0l4bhyr9d8ljz1f0cfg1s2cjcmh6fiwbk5mdlvc7rrwz5hxc21is"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list ccls emacs-dash emacs-lsp-mode))
      (home-page "https://github.com/MaskRay/emacs-ccls")
      (synopsis "Emacs support for the @code{ccls} language server")
      (description "This package extends @code{lsp-mode} to work with @code{C}
and @code{C++} files through the @code{ccls} language server.")
      (license license:expat))))

(define-public emacs-cpreproc
  (package
   (name "emacs-cpreproc")
   (version "1.0.0")
   (source
    (origin
     (method git-fetch)
     (uri (git-reference
           (url "https://git.sr.ht/~plattfot/cpreproc")
           (commit version)))
     (sha256
      (base32
       "0n4lhj9bbnkbzvifrj9q6z3j7z6jqzkaa36y239cfxdcc7i86c1c"))
     (file-name (git-file-name name version))))
   (build-system emacs-build-system)
   (home-page "https://sr.ht/~plattfot/cpreproc")
   (synopsis "Wrap C/C++ code in preprocessor macros")
   (description
    "Aim for this project is to make it easier to generate preprocessor macros
from Emacs for C/C++ code that needs to be build against multiple incompatible
versions of third party libraries or @code{C++} standards.")
   (license license:gpl3+)))

(define-public emacs-cpreproc-openvdb
  (package
   (name "emacs-cpreproc-openvdb")
   (version "3.0.0")
   (source
    (origin
     (method git-fetch)
     (uri (git-reference
           (url "https://git.sr.ht/~plattfot/cpreproc-openvdb")
           (commit version)))
     (sha256
      (base32
       "0n1y8cxx6xipvip8y6nk9ig1dpjdksz77956wlql3lhqcrcn5hzg"))
     (file-name (git-file-name name version))))
   (build-system emacs-build-system)
   (propagated-inputs
    (list emacs-cpreproc))
   (home-page "https://sr.ht/~plattfot/cpreproc")
   (synopsis "Create preprocessor macros for C++ that uses OpenVDB")
   (description
    "This project makes it easier to generate preprocessor macros from Emacs
for C++ code that uses OpenVDB and needs to be build against multiple
incompatible versions of it.")
   (license license:gpl3+)))

(define-public emacs-org-brain
  (package
    (name "emacs-org-brain")
    (version "0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Kungsgeten/org-brain")
             (commit "3faf9303af3f2356e3444e69c22dc6c5774047d1")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1ad681zk6kckw2zbk0r4iaj4bw8cfqrbd1s3gdwgdjlzq81q9mmj"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Kungsgeten/org-brain")
    (synopsis "Org-mode wiki and concept-mapping for Emacs")
    (description "@code{emacs-org-brain} implements a variant of concept
mapping in Emacs, using @code{org-mode}.  An org-brain is a network of
org-mode entries, where each entry is a file or a headline, and you can get a
visual overview of the relationships between the entries: parents, children,
siblings and friends.  This visual overview can also be used to browse your
entries.  You can think of entries as nodes in a mind map, or pages in a
wiki.")
    (license license:expat)))

(define-public emacs-recent-addresses
  (let ((commit "afbbfdc43b81e620acf827ca20d297e0c517b6eb")
        (revision "1"))
    (package
      (name "emacs-recent-addresses")
      (home-page "https://nschum.de/src/emacs/recent-addresses/")
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      ;; Note: Use a branch that works with Helm.  Submitted
                      ;; at <https://github.com/nschum/recent-addresses.el/pull/1>.
                      (url "https://github.com/civodul/recent-addresses.el")
                      (commit commit)))
                (sha256
                 (base32
                  "0ajrq0galjmdyjdjyxazykjyax3gh6hvfk4s7l657pi11g0q5zax"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (synopsis "Record recently-used email addressed and auto-complete them")
      (description
       "@code{recent-addresses} is an Emacs package that allows you to quickly
look up previously used email addresses.  It can be used alongside the Gnus
email client.")
      (license license:gpl2+))))

(define-public emacs-fold-dwim
  (let ((commit "c46f4bb2ce91b4e307136320e72c28dd50b6cd8b")
        (revision "0"))
    (package
      (name "emacs-fold-dwim")
      (version (git-version "1.2" revision commit))
      (home-page "https://github.com/emacsattic/fold-dwim")
      (source (origin
                (method git-fetch)
                (uri (git-reference (url home-page) (commit commit)))
                (sha256
                 (base32
                  "1yz1wis31asw6xa5maliyd1ck2q02xnnh7dc6swgj9cb4wi7k6i1"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (synopsis "Unified user interface for Emacs folding modes")
      (description
       "DWIM stands for \"do what I mean\", as in the idea that one keystroke
can do different things depending on the context.  In this package, it means
that, if the cursor is in a currently hidden folded construction, we want to
show it; if it's not, we want to hide whatever fold the cursor is in.")
      (license license:gpl2+))))

(define-public emacs-markup-faces
  (package
    (name "emacs-markup-faces")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://stable.melpa.org/packages/markup-faces-"
                           version ".el"))
       (sha256
        (base32
         "124dxbaa25fwxnpwsygpz7pw6da6dnnw7y2lic3jf8rgz7lw4v32"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/sensorflo/markup-faces")
    (synopsis "Collection of Emacs faces for markup language modes")
    (description "emacs-markup-faces is like font-lock-faces, but tailored for
markup languages instead programming languages.  The sub group markup-faces-text
is also intended for 'text viewing modes' such as info or (wo)man.  This gives a
common look and feel, or let's say theme, across different markup language modes
and 'text viewing modes' respectively.")
    (license license:gpl3+)))

(define-public emacs-adoc-mode
  (package
    (name "emacs-adoc-mode")
    (version "0.6.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sensorflo/adoc-mode")
             (commit (string-append "V" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0kp2aafjhqxz3mjr9hkkss85r4n51chws5a2qj1xzb63dh36liwm"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; See: https://github.com/sensorflo/adoc-mode/issues/39.
         (add-after 'unpack 'disable-failing-tests
           (lambda _
             (let-syntax
                 ((disable-tests
                   (syntax-rules ()
                     ((_ file ())
                      (syntax-error "test names list must not be empty"))
                     ((_ file (test-name ...))
                      (substitute* file
                        (((string-append "^\\(ert-deftest " test-name ".*") all)
                         (string-append all "(skip-unless nil)\n")) ...)))))
               (disable-tests "adoc-mode-test.el"
                              ("adoctest-test-tempo-delimited-blocks"
                               "adoctest-test-tempo-macros"
                               "adoctest-test-tempo-paragraphs"
                               "adoctest-test-tempo-passthroug-macros"
                               "adoctest-test-tempo-quotes")))
             #t)))
       #:tests? #t
       #:test-command '("emacs" "-Q" "-batch"
                        "-l" "adoc-mode-test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs
     (list emacs-markup-faces))
    (home-page "https://github.com/sensorflo/adoc-mode/wiki")
    (synopsis "AsciiDoc mode for Emacs")
    (description "This package provides an Emacs major mode for editing AsciiDoc
files.  It focuses on highlighting the document to improve readability.")
    (license license:gpl2+)))

(define-public emacs-racer
  (let ((commit "1e63e98626737ea9b662d4a9b1ffd6842b1c648c")
        (revision "0"))
    (package
      (name "emacs-racer")
      (version (git-version "1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/racer-rust/emacs-racer")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "12a429lajk09qp1jxgig54p8z6wndfgr4jwdmgkc9s2df9sw02d3"))))
      (arguments
       `(#:tests? #t
         #:test-command '("ert-runner")))
      (native-inputs
       (list emacs-ert-runner emacs-undercover))
      (propagated-inputs
       (list emacs-dash emacs-f emacs-pos-tip emacs-rust-mode emacs-s))
      (build-system emacs-build-system)
      (home-page "https://github.com/racer-rust/emacs-racer")
      (synopsis "Racer support for Emacs")
      (description
       "This is the official Emacs package for Racer.  It supports code
completion of variables, functions and modules.  It can also jump to
definition of functions and types, and show a help buffer based on the
docstring of the thing at point.")
      (license license:expat))))

(define-public emacs-rust-mode
  (package
    (name "emacs-rust-mode")
    (version "1.0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rust-lang/rust-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0sjhssxaqdd9mayfcjaf6pb0z4sv0xm5wjaqmk6wdmh543m2v1s8"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #false                  ;FIXME: phase fail with status 127
       #:test-command '("make test")))
    (home-page "https://github.com/rust-lang/rust-mode")
    (synopsis "Major Emacs mode for editing Rust source code")
    (description "This package provides a major Emacs mode for editing Rust
source code.")
    (license (list license:expat
                   license:asl2.0))))

(define-public emacs-rustic
  (package
    (name "emacs-rustic")
    (version "3.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/brotzeit/rustic")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16vsv4fhj8zq9g4zrsmipdb1nydxgw3dhh5s3wawpvx2rcg6gx2l"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash
           emacs-f
           emacs-flycheck
           emacs-lsp-mode
           emacs-markdown-mode
           emacs-project
           emacs-rust-mode
           emacs-s
           emacs-spinner
           emacs-xterm-color))
    (arguments
     ;; Tests require rust, cargo, rustfmt, and various crates to be
     ;; vendored.
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (add-before 'check 'set-without-cask
           (lambda _
             (setenv "WITHOUT_CASK" "1"))))))
    (home-page "https://github.com/brotzeit/rustic")
    (synopsis "Rust development environment for Emacs")
    (description "Rustic is a fork of Rust mode.
In addition to its predecessor, it offers the following features:
@itemize
@item Flycheck integration,
@item Cargo popup,
@item multiline error parsing,
@item translation of ANSI control sequences through XTerm color,
@item asynchronous Org Babel,
@item custom compilation process,
@item @command{rustfmt} errors in a Rust compilation mode,
@item automatic LSP configuration with Eglot or LSP mode,
@item optional Rust inline documentation,
@item etc.
@end itemize")
    (license (list license:expat
                   license:asl2.0))))

(define-public emacs-ztree
  ;; Upstream provides no tag, but the commit below matches latest release.
  (let ((commit "c9ad9136d52ca5a81475693864e255d29448f43f"))
    (package
      (name "emacs-ztree")
      (version "1.0.6")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fourier/ztree")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "03i5pa3nfdz6g0yrdk7r2qcn679w0s85cc5kcmgrwlnhdzakgr80"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/fourier/ztree")
      (synopsis "Directory tree comparison mode for Emacs")
      (description "Ztree is a project dedicated to implementation of several
text-tree applications inside GNU Emacs.  It consists of 2 subprojects:
@command{ztree-diff} and @command{ztree-dir} (the basis of
@command{ztree-diff}).")
      (license license:gpl3))))

(define-public emacs-helm-org-contacts
  (let ((commit "741eca6239684950219c9a12802386a132491b8c")
        (revision "2"))
    (package
      (name "emacs-helm-org-contacts")
      (version (git-version "20201202" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tmalsburg/helm-org-contacts")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1xy51hc3az8bc9sj71sjzy03xpkfa4v3cdcv3gpq3cj2zhk9gr8h"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash emacs-helm emacs-s))
      (home-page "https://github.com/tmalsburg/helm-org-contacts")
      (synopsis "Helm source for org-contacts")
      (description "This Helm source can be used to search contacts stored in
org-contacts format.  There are actions for inserting postal addresses, email
addresses, and phone numbers in the buffer where @command{helm-org-contacts}
was called.")
      (license license:gpl3))))

(define-public emacs-dired-du
  (package
    (name "emacs-dired-du")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://elpa.gnu.org/packages/dired-du-" version ".tar"))
       (sha256
        (base32 "0vhph7vcicsiq28b10h3b4dvnhckcy4gccpdgsad5j7pwa5k26m1"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/dired-du.html")
    (synopsis "Dired with recursive directory sizes")
    (description
     "Display the recursive size of directories in Dired.
This file defines a minor mode @command{dired-du-mode} to show the recursive
size of directories in Dired buffers.  If @command{du} program is available,
then the directory sizes are obtained with it.  Otherwise, the directory sizes
are obtained with Lisp.  The former is faster and provide a more precise
value.  For directories where the user doesn't have read permission, the
recursive size is not obtained.  Once this mode is enabled, every new Dired
buffer displays recursive dir sizes.")
    (license license:gpl3+)))

(define-public emacs-dired-rsync
  (package
    (name "emacs-dired-rsync")
    (version "0.6")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/stsquad/dired-rsync")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "19za6i96xrmczdh928n5ixd7j7pvy175sz1msaiwvdjwysjr8k51"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-s emacs-dash))
    (home-page "https://github.com/stsquad/dired-rsync/")
    (synopsis "Support for rsync from Emacs dired buffers")
    (description "This package adds a single command @code{dired-rsync} which
allows the user to copy marked files in a dired buffer via @code{rsync}.  This
is useful, especially for large files, because the copy happens in the
background and doesn’t lock up Emacs.  It is also more efficient than using
tramps own encoding methods for moving data between systems.")
    (license license:gpl3+)))

(define-public emacs-pcre2el
  ;; Last release is very old so we get the latest commit.
  (let ((commit "0b5b2a2c173aab3fd14aac6cf5e90ad3bf58fa7d"))
    (package
      (name "emacs-pcre2el")
      (version (git-version "1.8" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/joddie/pcre2el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "14br6ad138qx1z822wqssswqiihxiynz1k69p6mcdisr2q8yyi1z"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/joddie/pcre2el")
      (synopsis "Convert between PCRE, Emacs and rx regexp syntax")
      (description "@code{pcre2el} or @code{rxt} (RegeXp Translator or RegeXp
Tools) is a utility for working with regular expressions in Emacs, based on a
recursive-descent parser for regexp syntax.  In addition to converting (a
subset of) PCRE syntax into its Emacs equivalent, it can do the following:

@itemize
@item convert Emacs syntax to PCRE
@item convert either syntax to @code{rx}, an S-expression based regexp syntax
@item untangle complex regexps by showing the parse tree in @code{rx} form and
highlighting the corresponding chunks of code
@item show the complete list of strings (productions) matching a regexp,
provided the list is finite
@item provide live font-locking of regexp syntax (so far only for Elisp
buffers – other modes on the TODO list).
@end itemize\n")
      (license license:gpl3))))

(define-public emacs-magit-todos
  (package
    (name "emacs-magit-todos")
    (version "1.5.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alphapapa/magit-todos")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "12ay02vk6bk77k33mhlqi41m03a77y80b15rj1dbh1n6jfrjwkfy"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-async
           emacs-dash
           emacs-f
           emacs-hl-todo
           emacs-magit
           emacs-pcre2el
           emacs-s))
    (home-page "https://github.com/alphapapa/magit-todos")
    (synopsis "Show source files' TODOs (and FIXMEs, etc) in Magit status buffer")
    (description "This package displays keyword entries from source code
comments and Org files in the Magit status buffer.  Activating an item jumps
to it in its file.  By default, it uses keywords from @code{hl-todo}, minus a
few (like NOTE).")
    (license license:gpl3)))

(define-public emacs-git-annex
  ;; Unreleased version has a fontification fix.
  (let ((commit "1324d3f23c534fe79391a2c256bb8803054e383b")
        (revision "2"))
    (package
      (name "emacs-git-annex")
      (version (git-version "1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jwiegley/git-annex-el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1lfky2nsrlndlbvk6vwbswnvbvkz1sxgg0n3r5q6xykdkjym0lrh"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/jwiegley/git-annex-el")
      (synopsis "Emacs integration for git-annex")
      (description "Enhances Dired and buffers visiting annex files with
git-annex functionality.  In Dired, the names of annex files are shortened by
hiding the symbolic links and fontified based on whether content is present.
Commands for performing some common operations (e.g., unlocking and adding
files) are provided.")
      (license license:gpl2+))))

(define-public emacs-hackernews
  (package
    (name "emacs-hackernews")
    (version "0.6.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clarete/hackernews.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "17lkjcka6ydd6khhz5jbjlybfpx05153z0d8s1rxaxcwl7z2y6cf"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/clarete/hackernews.el")
    (synopsis "Hacker News client for Emacs")
    (description "The @command{hackernews} package is able to fetch stories
from six different Hacker News feeds, namely top, new, best, ask, show and job
stories.  The default feed is top stories, which corresponds to the Hacker
News homepage.")
    (license license:gpl3)))

(define-public emacs-tokei
  (package
    (name "emacs-tokei")
    (version "0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nagy/tokei.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0gcjlcfxd4bg123gjf7d0vfvfd6zpd0da8svynglca1qhp77jkx1"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'configure
            (lambda* (#:key inputs #:allow-other-keys)
              ;; .el is read-only in git.
              (make-file-writable "tokei.el")
              ;; Specify the absolute file name of tokei so that everything
              ;; works out-of-the-box.
              (emacs-substitute-variables "tokei.el"
                ("tokei-program"
                 (search-input-file inputs "/bin/tokei"))))))))
    (inputs (list tokei))
    (propagated-inputs (list emacs-magit))
    (home-page "https://github.com/nagy/tokei.el")
    (synopsis "Display codebase statistics in Emacs")
    (description
     "@code{emacs-tokei} is a major-mode for Emacs, that displays codebase
statistics with the help of @code{tokei}.")
    (license license:gpl3+)))

(define-public emacs-youtube-dl
  (let ((commit "af877b5bc4f01c04fccfa7d47a2c328926f20ef4")
        (revision "2"))
    (package
      (name "emacs-youtube-dl")
      (version (git-version "1.0" "2" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/skeeto/youtube-dl-emacs/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0zkl9jkjbx0lmp9ylv4rqg1zwqibk053s4rp7s1h0i18nzk7vn8j"))))
      (build-system emacs-build-system)
      (inputs
       (list youtube-dl))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'configure
             (lambda* (#:key inputs #:allow-other-keys)
               (let ((youtube-dl (assoc-ref inputs "youtube-dl")))
                 ;; .el is read-only in git.
                 (chmod "youtube-dl.el" #o644)
                 ;; Specify the absolute file names of the various
                 ;; programs so that everything works out-of-the-box.
                 (emacs-substitute-variables
                     "youtube-dl.el"
                   ("youtube-dl-program"
                    (string-append youtube-dl "/bin/youtube-dl")))))))))
      (home-page "https://github.com/skeeto/youtube-dl-emacs/")
      (synopsis "Emacs youtube-dl download manager")
      (description "This package manages a video download queue for
@command{youtube-dl}, which serves as the back end.  It manages a single
@command{youtube-dl} subprocess, downloading one video at a time.  New videos
can be queued at any time.")
      (license license:unlicense))))

(define-public emacs-ytdl
  (package
    (name "emacs-ytdl")
    (version "1.3.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/tuedachu/ytdl")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "010arhvibyw50lqhsr8bm0vj3pzry1h1vgcvxnmyryirk3dv40jl"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure
           (lambda* (#:key inputs #:allow-other-keys)
             ;; .el is read-only in git.
             (make-file-writable "ytdl.el")
             ;; Specify the absolute file names of the various programs so
             ;; that everything works out-of-the-box.
             (emacs-substitute-variables "ytdl.el"
               ("ytdl-command"
                (search-input-file inputs "/bin/youtube-dl"))))))))
    (inputs
     (list youtube-dl))
    (propagated-inputs
     (list emacs-async emacs-dash))
    (home-page "https://gitlab.com/tuedachu/ytdl")
    (synopsis "Emacs interface for youtube-dl")
    (description
     "This package manages a video download queue for @command{youtube-dl},
which serves as the back end.  New videos can be queued at any time.  All
youtube-dl backends are supported.  It is possible to create download profiles
depending on the downloaded URL.")
    (license license:gpl3+)))

(define-public emacs-ytel
  ;; No tagged releases.  Using version from main file.
  (let ((commit "d40bc7ead8d4d7e4d16b03b66a93d63bef51cc5f")
        (revision "0"))
    (package
      (name "emacs-ytel")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/grastello/ytel")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0pxzfsxzrpv59dssrgx2mmwkm6rzk49ffjkgsa3wks7rdyfil3kf"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-exec-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (let ((curl (assoc-ref inputs "curl")))
                 (substitute* "ytel.el"
                   (("\"curl\"") (string-append "\"" curl "/bin/curl\"")))))))))
      (inputs
       (list curl))
      (home-page "https://github.com/grastello/ytel")
      (synopsis "Youtube front-end for Emacs")
      (description
       "This package provides a major mode to search YouTube videos via an
Elfeed-like buffer.  Information about videos displayed in this buffer can be
extracted and manipulated by user-defined functions to do various things such
as playing them in some video player, or downloading them.")
      (license license:gpl3+))))

(define-public emacs-ytel-show
  ;; No tagged releases.  Version extracted from main file.
  (let ((commit "8b999484eb447ecdb741b24cbef2b5a7260a53e6")
        (revision "0"))
    (package
      (name "emacs-ytel-show")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/xFA25E/ytel-show")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0nhgzfzq1bgpbdbljx5z2hzr8ia7ybsyvvr66yj4klz0zj97rghj"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ytel))
      (home-page "https://github.com/xFA25E/ytel-show")
      (synopsis "Browse YouTube in Emacs")
      (description
       "This package provides an Emacs interface for browsing YouTube videos
and comments.")
      (license license:gpl3+))))

(define-public emacs-org-web-tools
  (package
    (name "emacs-org-web-tools")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alphapapa/org-web-tools")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0v4qad54r0z7dr7kg5lpfdsazi44qvrbybx9aciyl4w9grfajphb"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-esxml emacs-request emacs-s))
    (inputs
     (list pandoc))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-exec-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((pandoc (assoc-ref inputs "pandoc")))
               (substitute* "org-web-tools.el"
                 (("\"pandoc\"") (string-append "\"" pandoc "/bin/pandoc\"")))
               #t))))))
    (home-page "https://github.com/alphapapa/org-web-tools")
    (synopsis "Display/Process web page as Org-mode content")
    (description "This package contains library functions and commands useful
for retrieving web page content and processing it into Org-mode content.

For example, you can copy a URL to the clipboard or kill-ring, then run a
command that downloads the page, isolates the “readable” content with
@command{eww-readable}, converts it to Org-mode content with Pandoc, and
displays it in an Org-mode buffer.  Another command does all of that but
inserts it as an Org entry instead of displaying it in a new buffer.")
    (license license:gpl3+)))

(define-public emacs-blimp
  (let ((commit "e420763d6d18b5d1be552cdbc47f91418343db03"))
    (package
      (name "emacs-blimp")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/walseb/blimp")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "09wmhpym516b81dfq8smdmysh1fn610dzlyvyl2rkx8600f0fizd"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-eimp))
      (home-page "https://github.com/walseb/blimp")
      (synopsis "Emacs wrapper around all Imagemagick commands")
      (description "Blimp (Bustling Image Manipulation Package) is a complete
wrapper around all Imagemagick commands with descriptions, autocompletion (for
some commands) and hints displayed in prompt using @command{eimp.el} to
execute its commands and resize images.")
      (license license:gpl3+))))

(define-public emacs-synosaurus
  (package
    (name "emacs-synosaurus")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hpdeifel/synosaurus")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "14dd6p89pmpf1w3nx4f9mzm4sn2b64nicws436ck7pmp223pwciv"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list wordnet))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let ((wn (assoc-ref inputs "wordnet")))
               ;; .el is read-only in git.
               (make-file-writable "synosaurus-wordnet.el")
               ;; Specify the absolute file names of the various
               ;; programs so that everything works out-of-the-box.
               (emacs-substitute-variables "synosaurus-wordnet.el"
                 ("synosaurus-wordnet--command"
                  (string-append wn "/bin/wn")))))))))
    (home-page "https://github.com/hpdeifel/synosaurus")
    (synopsis "Extensible thesaurus mode for Emacs")
    (description "Synosaurus is a thesaurus fontend for Emacs with pluggable
backends, including the @command{wordnet} offline backend.")
    (license license:gpl3+)))

(define-public emacs-editorconfig
  (package
    (name "emacs-editorconfig")
    (version "0.9.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/editorconfig/editorconfig-emacs")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1v8x649r9b0ihnhddkkfb8ck21z2hr3swgczwgzwdk0ys6pl89my"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/editorconfig/editorconfig-emacs")
    (synopsis "Define and maintain consistent coding styles between different
editors and IDEs")
    (description "The EditorConfig project consists of a file format for
defining coding styles and a collection of text editor plugins that enable
editors to read the file format and adhere to defined styles.  EditorConfig
files are easily readable and they work nicely with version control systems.")
    (license license:gpl3+)))

(define-public emacs-all-the-icons
  (package
    (name "emacs-all-the-icons")
    (version "5.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/domtronn/all-the-icons.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0lwgvgnqf7vihglm0c5bwsxbl4x7f641289cji5s7jwy2dbsqk7g"))))
    (build-system emacs-build-system)
    (arguments
     `(#:include '("\\.el$" "^data/")
       #:exclude '("^test/")
       #:phases
       (modify-phases %standard-phases
         (add-after 'install 'install-fonts
           (lambda* (#:key outputs #:allow-other-keys)
             (let ((fonts (string-append (assoc-ref outputs "out")
                                         "/share/fonts")))
               (mkdir-p fonts)
               (with-directory-excursion "fonts"
                 (install-file "all-the-icons.ttf" fonts)
                 ;; TODO: Unbundle.
                 (install-file "file-icons.ttf" fonts)
                 (install-file "octicons.ttf" fonts)
                 (install-file "weathericons.ttf" fonts)))))
         (replace 'check
           (lambda* (#:key outputs #:allow-other-keys)
             (apply invoke "ert-runner" "-l"
                    (append (find-files "data" "\\.el")
                            '("all-the-icons-faces.el"))))))))
    (native-inputs
     (list emacs-f emacs-ert-runner))
    (propagated-inputs
     (list emacs-f emacs-memoize font-awesome font-google-material-design-icons))
    (home-page "https://github.com/domtronn/all-the-icons.el")
    (synopsis "Collect icon fonts and propertize them within Emacs")
    (description
     "All-the-icons is a utility package to collect various icon fonts and
propertize them within Emacs.  Icon fonts allow you to propertize and format
icons the same way you would normal text.  This enables things such as better
scaling of and anti aliasing of the icons.")
    ;; Package is released under Expat license.  Elisp files are licensed
    ;; under GPL3+.  Fonts come with various licenses: Expat for
    ;; "all-the-icons.ttf" and "file-icons.ttf", Apache License 2.0 for
    ;; "material-design-icons.ttf", and SIL OFL 1.1 for "fontawesome.ttf",
    ;; "ocitcons.ttf" and "weathericons.ttf".
    (license
     (list license:expat license:gpl3+ license:silofl1.1 license:asl2.0))))

(define-public emacs-all-the-icons-completion
  ;; XXX: No tags. Extract version from keyword in main file.
  (let ((commit "9e7d456b0934ecb568b6f05a8445e3f4ce32261f")
        (revision "0"))
    (package
      (name "emacs-all-the-icons-completion")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/iyefrat/all-the-icons-completion")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "04bnmmd6lyx0p39sgymqvmcy7bk8mr7sikbpy49adxi7d2891ldg"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-all-the-icons))
      (home-page "https://github.com/iyefrat/all-the-icons-completion")
      (synopsis "Add icons to completion candidates")
      (description "This package adds icons to completion candidates using the
built-in completion metadata functions.  For example, with this package,
@code{find-file} can display a file icon for each candidate based on the file
type.")
      (license license:gpl3+))))

(define-public emacs-wttrin
  (let ((commit "df5427ce2a5ad4dab652dbb1c4a1834d7ddc2abc")
        (revision "1"))
    (package
      (name "emacs-wttrin")
      (version (git-version "0.2.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/bcbcarl/emacs-wttrin")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1ai655f10iayb4vw0ass2j3x83f4vsv90326mnywkzfl3sxd432z"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-xterm-color))
      (home-page "https://github.com/bcbcarl/emacs-wttrin")
      (synopsis "Frontend for weather web service @url{wttr.in}")
      (description "This package provides local weather information from
@url{wttr.in}.")
      (license license:expat))))

(define-public emacs-browse-kill-ring
  (let ((commit "1ef72cc6accd94cd7032c02b1b2c78ae7f1d1965")
        (revision "0"))
    (package
      (name "emacs-browse-kill-ring")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/browse-kill-ring/browse-kill-ring")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0mil32g7hcw376jibs5hdyv00xbaql3m4a27rwqaafg0x59avxdj"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/browse-kill-ring/browse-kill-ring")
      (synopsis "Interactively insert items from kill-ring")
      (description
       "Did you ever feel that @code{C-y M-y M-y M-y ...} is not a great way
of trying to find that piece of text you know you killed a while back?  Then
@code{browse-kill-ring.el} is for you.")
      (license license:gpl2+))))

(define-public emacs-powerline
  (package
    (name "emacs-powerline")
    (version "2.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/milkypostman/powerline")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1hp3xp18943n0rlggz55150020ivw8gvi1vyxkr4z8xhpwq4gaar"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/milkypostman/powerline/")
    (synopsis "Mode-line plugin for Emacs")
    (description "Powerline is a utility plugin which allows you to create
a better-looking, more functional Emacs mode-line.  A collection of predefined
themes comes with the package.")
    (license license:gpl3+)))

(define-public emacs-spaceline
  (package
    (name "emacs-spaceline")
    (version "2.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/TheBB/spaceline")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1q8r95zfrh0vxna5ml2pq9b9f66clfqcl4d2qy2aizkvzyxg6skl"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-powerline emacs-s))
    (home-page "https://github.com/TheBB/spaceline")
    (synopsis "Powerline theme from Spacemacs")
    (description "Spaceline provides Spacemacs' mode-line theme.
This package provides features for three kinds of users.

@itemize
@item You just want to use the Spacemacs mode-line theme and forget about it.
@item You want to use something similar to the Spacemacs mode-line theme, but
with a handful of easy tweaks.
@item You want an easy-to-use library for building your own mode-line from
scratch, and you think the Spacemacs theme looks good.
@end itemize")
    (license license:gpl3+)))

(define-public emacs-spaceline-next
  (let ((commit "1b26af2c1a701481ac5d90928fe0200e389756c3")
        (last-release-version "2.0.1")
        (revision "0"))
    (package
      (inherit emacs-spaceline)
      (name "emacs-spaceline-next")
      (version (git-version last-release-version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/TheBB/spaceline")
               (commit commit)))
         (sha256
          (base32 "11lwckqcgzsahrkkm5wk1ph4kc7d4yz05r7251g8c9f0q6vdj9dp"))
         (file-name (git-file-name name version)))))))

(define-public emacs-column-marker
  (package
    (name "emacs-column-marker")
    (version "9")
    (source
     (origin
       (method url-fetch)
       (uri "https://www.emacswiki.org/emacs/download/column-marker.el")
       (sha256 (base32 "05bv198zhqw5hqq6cr11mhz02dpca74hhp1ycwq369m0yb2naxy9"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/ColumnMarker")
    (synopsis "Emacs mode for highlighting columns")
    (description
     "With @code{column-marker.el} you can highlight any number of text columns.
Three such highlight column markers are provided by default.  This is
especially useful for languages like COBOL or Fortran where certain columns
have special meaning.  It is also handy for aligning text across long vertical
distances.  Multi-column characters, such as @kbd{TAB} are treated
correctly.")
    (license license:gpl2+)))

(define-public emacs-slime-repl-ansi-color
  (let ((commit "ad03263f5d4de473bc173b64a6fc3dc1106393d7"))
    (package
      (name "emacs-slime-repl-ansi-color")
      (version (git-version "0.0.0" "1" commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/deadtrickster/slime-repl-ansi-color")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0bpg7gxz310x7bnlg324c507sxc5gxwwz6h64h6kdq141r73vbi4"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/deadtrickster/slime-repl-ansi-color")
      (synopsis "Color ANSI codes in the REPL of SLIME")
      (description "Color ANSI codes in the REPL of SLIME")
      (license license:gpl2+))))

(define-public emacs-helm-slime
  (package
    (name "emacs-helm-slime")
    (version "0.4.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacs-helm/helm-slime")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0mrpjhpijdrq353fnfvdj9l9xfsz390qlcvifcair9732ma7i8l0"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm emacs-slime))
    (home-page "https://github.com/emacs-helm/helm-slime")
    (synopsis "Helm for SLIME, the Superior Lisp Interaction Mode for Emacs")
    (description "Helm-SLIME defines a few new commands:

@itemize
@item helm-slime-complete: Select a symbol from the SLIME completion systems.
@item helm-slime-list-connections: Yet another slime-list-connections with Helm.
@item: helm-slime-apropos: Yet another slime-apropos with Helm.
@item helm-slime-repl-history: Select an input from the SLIME REPL history and insert it.
@end itemize\n")
    (license license:gpl3+)))

(define-public emacs-helm-sly
  (package
    (name "emacs-helm-sly")
    (version "0.7.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacs-helm/helm-sly")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "06x8wyx1r0s7askkvlbklgz1cszv34qsvv3gryndw350smk1v8kx"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm emacs-sly))
    (home-page "https://github.com/emacs-helm/helm-sly")
    (synopsis "Helm for SLY, a Common Lisp interaction mode for Emacs")
    (description "Helm-SLY defines a few new commands:

@itemize
@item @code{helm-sly-list-connections}: Yet another Lisp connection list with
Helm.
@item @code{helm-sly-apropos}: Yet another @command{apropos} with Helm.
@item @code{helm-sly-mini}: Like @command{helm-sly-list-connections}, but
include an extra source of Lisp-related buffers, like the events buffer or the
scratch buffer.
@end itemize\n")
    (license license:gpl3+)))

(define-public emacs-gtk-look
  (package
    (name "emacs-gtk-look")
    (version "29")
    (source (origin
              (method url-fetch)
              (uri "https://download.tuxfamily.org/user42/gtk-look.el")
              (sha256
               (base32
                "14p2nwrd51cr1v06fxbjjn6jdrkf9d6vcxhmscm0kl677s25ypsp"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure
           (lambda _
             ;; File is read-only.
             (chmod "gtk-look.el" #o644)
             (emacs-substitute-variables "gtk-look.el"
               ("gtk-lookup-devhelp-indices"
                '(list (expand-file-name "~/.guix-profile/share/gtk-doc/html/*/*.devhelp*"))))
             #t)))))
    (home-page "http://user42.tuxfamily.org/gtk-look/index.html")
    (synopsis "Find and display HTML documentation for GTK, GNOME and Glib")
    (description "@command{gtk-look} finds and displays HTML documentation for
GTK, GNOME and Glib functions and variables in Emacs, similar to what
info-lookup-symbol does for info files (C-h S).  The documentation is expected
to be devhelp indexes with HTML files.  The location of the indexes can be
customized.  In addition to C code development @command{gtk-look} is good for

@itemize
@item @command{perl-gtk2}, recognising class funcs like
@command{Gtk2::Label->new} and bare method names like @command{set_text}.
@item @command{guile-gnome}, recognising methods like @command{set-text} and
classes like @command{<gtk-window>}.
@end itemize\n")
    (license license:gpl3+)))

(define-public emacs-ov
  (package
    (name "emacs-ov")
    (version "1.0.6")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ShingoFukuyama/ov.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0qxk2rf84j86syxi8xknsq252irwg7sz396v3bb4wqz4prpj0kzc"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ShingoFukuyama/ov.el")
    (synopsis "Overlay library for Emacs Lisp")
    (description "@code{ov.el} provides a simple way to manipulate overlays in
Emacs.")
    (license license:gpl3+)))

(define-public emacs-matrix-client
  (let ((commit "d2ac55293c96d4c95971ed8e2a3f6f354565c5ed"))
    (package
      (name "emacs-matrix-client")
      (version (git-version "0.0.0" "6" commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jgkamat/matrix-client-el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1scfv1502yg7x4bsl253cpr6plml1j4d437vci2ggs764sh3rcqq"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-a
             emacs-anaphora
             emacs-dash
             emacs-esxml
             emacs-f
             emacs-frame-purpose
             emacs-ht
             emacs-ov
             emacs-rainbow-identifiers
             emacs-request
             emacs-s
             emacs-tracking))
      (home-page "https://github.com/jgkamat/matrix-client-el")
      (synopsis "Matrix client for Emacs")
      (description "@code{matrix-client} is a simple chat UI to Matrix.org
rooms.  It also provides an API which allows Emacs to seamlessly create
RPC channels with users and other software.")
      (license license:gpl3+))))

(define-public emacs-sesman
  (package
    (name "emacs-sesman")
    (version "0.3.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/vspinu/sesman")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0z5jb4vpbjsi63w3wjy6d2lgz33qdfvrgfb3bszv4hcf6a96y7fc"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-shell
           ;; Setting the SHELL environment variable is required for the tests
           ;; to find sh.
           (lambda _
             (setenv "SHELL" (which "sh"))
             #t)))
       #:tests? #t
       #:test-command '("make" "test")))
    (home-page "https://github.com/vspinu/sesman")
    (synopsis "Session manager for Emacs based IDEs")
    (description "Sesman provides facilities for session management and
interactive session association with the current contexts (project, directory,
buffers).  While sesman can be used to manage arbitrary sessions, it primary
targets the Emacs based IDEs (CIDER, ESS, Geiser, Robe, SLIME etc.)")
    (license license:gpl3+)))

(define-public emacs-buttercup
  (package
    (name "emacs-buttercup")
    (version "1.28")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jorgenschaefer/emacs-buttercup")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1dc8m5w26gi698d31xvh1q8mwf4a3wa1xrnyhqqxrmfr8b71clpk"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #t
      #:test-command #~(list "make" "test")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'install-bin
            (lambda _
              (install-file "bin/buttercup"
                            (string-append #$output "/bin")))))))
    (home-page "https://github.com/jorgenschaefer/emacs-buttercup")
    (synopsis "Behavior driven emacs lisp testing framework")
    (description "Buttercup is a behavior-driven development framework for
testing Emacs Lisp code.  It groups related tests so they can share
common set-up and tear-down code, and allows the programmer to \"spy\" on
functions to ensure they are called with the right arguments during testing.")
    (license license:gpl3+)))

;;; Required by emacs-lua-mode
(define emacs-buttercup-1.25
  (package
    (inherit emacs-buttercup)
    (name "emacs-buttercup")
    (version "1.25")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jorgenschaefer/emacs-buttercup")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0fsysvsypda6b7azc15bpaprq3bwx4gb6rlq2mj6f8rgwdqc8153"))))))

(define-public emacs-cort
  (package
    (name "emacs-cort")
    (version "7.1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/conao3/cort.el")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "03c223nczpbdkjmq69panhbsq2a0zj20w329jgj4c0zsj8m1a32a"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-ansi))
    (arguments
     `(#:tests? #t
       #:test-command '("emacs" "--batch" "--quick"
                        "--directory=." "--load=cort-tests.el"
                        "--funcall=cort-test-run")))
    (home-page "https://github.com/conao3/cort.el")
    (synopsis "Unit test framework for the Emacs Lisp")
    (description "@code{cort} is a lightweight Emacs Lisp unit test library.")
    (license license:gpl3+)))

(define-public emacs-wordnut
  (let ((commit "feac531404041855312c1a046bde7ea18c674915")
        (revision "0"))
    (package
      (name "emacs-wordnut")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/gromnitsky/wordnut")
      (source (origin
                (method git-fetch)
                (uri (git-reference (url home-page) (commit commit)))
                (sha256
                 (base32
                  "1jl0b6g64a9w0q7bfvwha67vgws5xd15b7mkfyb5gkz3pymqhfxn"))
                (patches
                 (search-patches "emacs-wordnut-require-adaptive-wrap.patch"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list wordnet emacs-adaptive-wrap))
      (synopsis "Major mode for WordNet")
      (description "This Emacs package provides an interface for
@code{wordnet}.  Features include completion, if the query is not found
too ambiguous and navigation in the result buffer.")
      (license license:gpl3+))))

(define-public emacs-frame-local
  ;; There is no release yet.  Version is extracted from the main
  ;; file.
  (let ((version "0.0.1")
        (revision "0")
        (commit "7ee1106c3bcd4022f48421f8cb1ef4f995da816e"))
    (package
      (name "emacs-frame-local")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sebastiencs/frame-local")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0zfxsxdh3bd3fd566zl0byp13p5b8f4cgkwl637imvarvahczigp"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/sebastiencs/frame-local")
      (synopsis "Access variables local to an Emacs frame")
      (description
       "This package allows setting and accessing variables local to
an Emacs frame.  Note that the variables created with this package do
not have any relation with variables defined by @code{defvar},
@code{defconst}, etc.")
      (license license:gpl3+))))

(define-public emacs-frame-purpose
  (package
    (name "emacs-frame-purpose")
    (version "1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/alphapapa/frame-purpose.el")
                    (commit version)))
              (sha256
               (base32
                "0jq2aam1yvccw887ighd1wm2xkvk5bv53ffiz3crcl16a255aj4q"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (inputs
     (list emacs-dash))
    (synopsis "Purpose-specific frames for Emacs")
    (description "@code{frame-purpose} makes it easy to open purpose-specific
frames that only show certain buffers, e.g. by buffers’ major mode, their
filename or directory, etc, with custom frame/X-window titles, icons, and
other frame parameters.")
    (home-page "https://github.com/alphapapa/frame-purpose.el")
    (license license:gpl3+)))

(define-public emacs-arduino-mode
  (let ((commit "652c6a328fa8f2db06534d5f231c6b6933be3edc")
        (revision "0"))
    (package
      (name "emacs-arduino-mode")
      (version (git-version "1.3.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://repo.or.cz/arduino-mode")
               (commit commit)))
         (sha256
          (base32 "16izwrk1dfsa14kylfhsxdwkx76g0jdk0znl1z7cypxh5q9ijy1x"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (inputs
       (list emacs-flycheck emacs-spinner))
      (synopsis "Emacs major mode for editing Arduino sketches")
      (description "This package provides an Emacs major mode for editing
Arduino sketches and Org Babel support.")
      (home-page "https://repo.or.cz/arduino-mode")
      (license license:gpl3+))))

(define-public emacs-annalist
  (package
    (name "emacs-annalist")
    (version "1.0.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/noctuid/annalist.el")
                    (commit version)))
              (sha256
               (base32
                "1jlb5w4972l8m2aa18q2l6arfpm65g4nk21dn1yi8c9dbpk2g67c"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (native-inputs
     (list emacs-buttercup emacs-lispy emacs-evil))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'fix-makefile
           (lambda _
             (substitute* "Makefile"
               (("cask exec ") ""))
             #t)))
       #:tests? #t
       #:test-command '("make" "test")))
    (home-page "https://github.com/noctuid/annalist.el")
    (synopsis "Record and display information with Org headings and tables")
    (description "This package allows for keybindings, settings, hooks, and
advice to be recorded and displayed.")
    (license license:gpl3+)))

(define-public emacs-general
  (let ((commit "a0b17d207badf462311b2eef7c065b884462cb7c")
        (revision "4"))
    (package
      (name "emacs-general")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/noctuid/general.el")
               (commit commit)))
         (sha256
          (base32 "0wn5rk3gkimdklip392mnjrmkymgrb7q9skifi03cbpjam1anzvv"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (native-inputs
       (list emacs-buttercup emacs-evil emacs-which-key emacs-use-package))
      (arguments
       `(#:tests? #t
         #:test-command '("buttercup" "-L" "test/test-general.el")))
      (home-page "https://github.com/noctuid/general.el")
      (synopsis "More convenient key definitions in emacs")
      (description "@code{general.el} provides a more convenient method for
binding keys in emacs (for both evil and non-evil users).  Like
@code{use-package}, which provides a convenient, unified interface for
managing packages, @code{general.el} is intended to provide a convenient,
unified interface for key definitions.  While this package does implement some
completely new functionality (such as the ability to make vim-style
keybindings under non-prefix keys with an optional timeout), its primary
purpose is to build on existing functionality to make key definition more
clear and concise.  @code{general-define-key} is user-extensible and supports
defining multiple keys in multiple keymaps at once, implicitly wrapping key
strings with (@code{kbd ...}), using named prefix key sequences (like the
leader key in vim), and much more.")
      (license license:gpl3+))))

(define-public emacs-tldr
  (let ((commit "7203d1be3dcbf12131846ffe06601933fa874d74"))
    (package
      (name "emacs-tldr")
      (version (git-version "0" "1" commit))
      (home-page "https://github.com/kuanyui/tldr.el")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url (string-append home-page ".git"))
                      (commit commit)))
                (sha256
                 (base32
                  "1bw6la463l2yfm7rp76ga4makfy4kpxgwi7ni5gxk31w11g26ryk"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-request))
      (synopsis "Simplified and community-driven man pages for Emacs")
      (description "@code{emacs-tldr} allows the user to access tldr pages
from within emacs.  The @code{tldr} pages are a community effort to simplify
the man pages with practical examples.")
      (license license:wtfpl2