#!/usr/bin/perl

use strict;
use 5.6.0;
use warnings;

use IO::Dir;
use File::Spec;
use POSIX;

my $dirname = shift or die "No test directory supplied\n";

my $dir = new IO::Dir $dirname or die "Failed to open dir $dirname: $!\n";
my @tests;
push @tests, $_ while defined($_ = $dir->read);
undef $dir;

@tests = grep {-d $_} map {File::Spec->catdir($dirname, $_)} grep {!/^\./ and !/~$/} @tests;

foreach my $test (sort @tests)
  {
    print "Processing $test...\n";
    system('./make_test.pl', $test);
  }
