/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.impl.commands;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.DefaultMdacContextualCommand;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.ITransaction;
import com.modeliosoft.modelio.api.model.InvalidTransactionException;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateMachine;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.modelingwizard.impl.engine.StateUpdater;

public class UpdateStateFromStateMachine
extends DefaultMdacContextualCommand {
    public void actionPerformed(ObList<IElement> selectedElements, IMdac mdac) {
        IState selectedState = (IState)selectedElements.get(0);
        IModelingSession session = mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("UpdateStateFromStateMachine");
        try {
            try {
                StateUpdater updater = new StateUpdater();
                updater.createStateMachineFromState(session, selectedState);
                session.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    session.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    public boolean accept(ObList<IElement> selectedElements, IMdac mdac) {
        return selectedElements.size() > 0;
    }

    public boolean isActiveFor(ObList<IElement> selectedElements, IMdac mdac) {
        IState selectedState = (IState)selectedElements.get(0);
        IStateMachine stateMachine = selectedState.getSubMachine();
        return stateMachine != null;
    }
}

