/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.codeInsight.moveUpDown;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class MoveStatementTestGenerated extends AbstractMoveStatementTest {
    @TestMetadata("idea/testData/codeInsight/moveUpDown/classBodyDeclarations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ClassBodyDeclarations extends AbstractMoveStatementTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestClassBodyDeclaration, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInClassBodyDeclarations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/classBodyDeclarations"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/accessors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Accessors extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestClassBodyDeclaration, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("accessor1.kt")
            public void testAccessor1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/accessors/accessor1.kt");
            }

            @TestMetadata("accessor2.kt")
            public void testAccessor2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/accessors/accessor2.kt");
            }

            @TestMetadata("accessor3.kt")
            public void testAccessor3() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/accessors/accessor3.kt");
            }

            @TestMetadata("accessor4.kt")
            public void testAccessor4() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/accessors/accessor4.kt");
            }

            public void testAllFilesPresentInAccessors() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/accessors"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Class extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestClassBodyDeclaration, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classAtBrace1.kt")
            public void testClassAtBrace1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtBrace1.kt");
            }

            @TestMetadata("classAtBrace2.kt")
            public void testClassAtBrace2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtBrace2.kt");
            }

            @TestMetadata("classAtBrace3.kt")
            public void testClassAtBrace3() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtBrace3.kt");
            }

            @TestMetadata("classAtBrace4.kt")
            public void testClassAtBrace4() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtBrace4.kt");
            }

            @TestMetadata("classAtBrace5.kt")
            public void testClassAtBrace5() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtBrace5.kt");
            }

            @TestMetadata("classAtBrace6.kt")
            public void testClassAtBrace6() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtBrace6.kt");
            }

            @TestMetadata("classAtClass1.kt")
            public void testClassAtClass1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtClass1.kt");
            }

            @TestMetadata("classAtClass2.kt")
            public void testClassAtClass2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtClass2.kt");
            }

            @TestMetadata("classAtClassInitializer1.kt")
            public void testClassAtClassInitializer1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtClassInitializer1.kt");
            }

            @TestMetadata("classAtClassInitializer2.kt")
            public void testClassAtClassInitializer2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtClassInitializer2.kt");
            }

            @TestMetadata("classAtEmptyLine1.kt")
            public void testClassAtEmptyLine1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtEmptyLine1.kt");
            }

            @TestMetadata("classAtEmptyLine2.kt")
            public void testClassAtEmptyLine2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtEmptyLine2.kt");
            }

            @TestMetadata("classAtFunction1.kt")
            public void testClassAtFunction1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtFunction1.kt");
            }

            @TestMetadata("classAtFunction2.kt")
            public void testClassAtFunction2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtFunction2.kt");
            }

            @TestMetadata("classAtProperty1.kt")
            public void testClassAtProperty1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtProperty1.kt");
            }

            @TestMetadata("classAtProperty2.kt")
            public void testClassAtProperty2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classAtProperty2.kt");
            }

            @TestMetadata("classWithoutBody1.kt")
            public void testClassWithoutBody1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classWithoutBody1.kt");
            }

            @TestMetadata("classWithoutBody2.kt")
            public void testClassWithoutBody2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classWithoutBody2.kt");
            }

            @TestMetadata("classWithoutBody3.kt")
            public void testClassWithoutBody3() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classWithoutBody3.kt");
            }

            @TestMetadata("classWithoutBody4.kt")
            public void testClassWithoutBody4() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/class/classWithoutBody4.kt");
            }
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassInitializer extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestClassBodyDeclaration, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassInitializer() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classInitializerAtBrace1.kt")
            public void testClassInitializerAtBrace1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer/classInitializerAtBrace1.kt");
            }

            @TestMetadata("classInitializerAtBrace2.kt")
            public void testClassInitializerAtBrace2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer/classInitializerAtBrace2.kt");
            }

            @TestMetadata("classInitializerAtClass1.kt")
            public void testClassInitializerAtClass1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer/classInitializerAtClass1.kt");
            }

            @TestMetadata("classInitializerAtClass2.kt")
            public void testClassInitializerAtClass2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer/classInitializerAtClass2.kt");
            }

            @TestMetadata("classInitializerAtClassInitializer1.kt")
            public void testClassInitializerAtClassInitializer1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer/classInitializerAtClassInitializer1.kt");
            }

            @TestMetadata("classInitializerAtClassInitializer2.kt")
            public void testClassInitializerAtClassInitializer2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer/classInitializerAtClassInitializer2.kt");
            }

            @TestMetadata("classInitializerAtEmptyLine1.kt")
            public void testClassInitializerAtEmptyLine1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer/classInitializerAtEmptyLine1.kt");
            }

            @TestMetadata("classInitializerAtEmptyLine2.kt")
            public void testClassInitializerAtEmptyLine2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer/classInitializerAtEmptyLine2.kt");
            }

            @TestMetadata("classInitializerAtFunction1.kt")
            public void testClassInitializerAtFunction1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer/classInitializerAtFunction1.kt");
            }

            @TestMetadata("classInitializerAtFunction2.kt")
            public void testClassInitializerAtFunction2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer/classInitializerAtFunction2.kt");
            }

            @TestMetadata("classInitializerAtProperty1.kt")
            public void testClassInitializerAtProperty1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer/classInitializerAtProperty1.kt");
            }

            @TestMetadata("classInitializerAtProperty2.kt")
            public void testClassInitializerAtProperty2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/classInitializer/classInitializerAtProperty2.kt");
            }
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/enums")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Enums extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestClassBodyDeclaration, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInEnums() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/enums"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("enum1.kt")
            public void testEnum1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/enums/enum1.kt");
            }

            @TestMetadata("enum2.kt")
            public void testEnum2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/enums/enum2.kt");
            }

            @TestMetadata("enum3.kt")
            public void testEnum3() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/enums/enum3.kt");
            }

            @TestMetadata("enum4.kt")
            public void testEnum4() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/enums/enum4.kt");
            }

            @TestMetadata("enum5.kt")
            public void testEnum5() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/enums/enum5.kt");
            }

            @TestMetadata("enum6.kt")
            public void testEnum6() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/enums/enum6.kt");
            }

            @TestMetadata("enum7.kt")
            public void testEnum7() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/enums/enum7.kt");
            }

            @TestMetadata("enum8.kt")
            public void testEnum8() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/enums/enum8.kt");
            }
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestClassBodyDeclaration, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("functionAtBrace1.kt")
            public void testFunctionAtBrace1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtBrace1.kt");
            }

            @TestMetadata("functionAtBrace2.kt")
            public void testFunctionAtBrace2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtBrace2.kt");
            }

            @TestMetadata("functionAtBrace3.kt")
            public void testFunctionAtBrace3() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtBrace3.kt");
            }

            @TestMetadata("functionAtBrace4.kt")
            public void testFunctionAtBrace4() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtBrace4.kt");
            }

            @TestMetadata("functionAtBrace5.kt")
            public void testFunctionAtBrace5() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtBrace5.kt");
            }

            @TestMetadata("functionAtBrace6.kt")
            public void testFunctionAtBrace6() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtBrace6.kt");
            }

            @TestMetadata("functionAtClass1.kt")
            public void testFunctionAtClass1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtClass1.kt");
            }

            @TestMetadata("functionAtClass2.kt")
            public void testFunctionAtClass2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtClass2.kt");
            }

            @TestMetadata("functionAtClassInitializer1.kt")
            public void testFunctionAtClassInitializer1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtClassInitializer1.kt");
            }

            @TestMetadata("functionAtClassInitializer2.kt")
            public void testFunctionAtClassInitializer2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtClassInitializer2.kt");
            }

            @TestMetadata("functionAtEmptyLine1.kt")
            public void testFunctionAtEmptyLine1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtEmptyLine1.kt");
            }

            @TestMetadata("functionAtEmptyLine2.kt")
            public void testFunctionAtEmptyLine2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtEmptyLine2.kt");
            }

            @TestMetadata("functionAtFunction1.kt")
            public void testFunctionAtFunction1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtFunction1.kt");
            }

            @TestMetadata("functionAtFunction2.kt")
            public void testFunctionAtFunction2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtFunction2.kt");
            }

            @TestMetadata("functionAtProperty1.kt")
            public void testFunctionAtProperty1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtProperty1.kt");
            }

            @TestMetadata("functionAtProperty2.kt")
            public void testFunctionAtProperty2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtProperty2.kt");
            }

            @TestMetadata("functionAtTheScriptEnd.kts")
            public void testFunctionAtTheScriptEnd() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/function/functionAtTheScriptEnd.kts");
            }
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/functionAnchors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionAnchors extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestClassBodyDeclaration, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionAnchors() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/functionAnchors"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("keyword.kt")
            public void testKeyword() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/functionAnchors/keyword.kt");
            }

            @TestMetadata("name.kt")
            public void testName() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/functionAnchors/name.kt");
            }

            @TestMetadata("returnType.kt")
            public void testReturnType() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/functionAnchors/returnType.kt");
            }

            @TestMetadata("typeParams1.kt")
            public void testTypeParams1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/functionAnchors/typeParams1.kt");
            }

            @TestMetadata("typeParams2.kt")
            public void testTypeParams2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/functionAnchors/typeParams2.kt");
            }

            @TestMetadata("typeParams3.kt")
            public void testTypeParams3() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/functionAnchors/typeParams3.kt");
            }
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Property extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestClassBodyDeclaration, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("propertyAtBrace1.kt")
            public void testPropertyAtBrace1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtBrace1.kt");
            }

            @TestMetadata("propertyAtBrace2.kt")
            public void testPropertyAtBrace2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtBrace2.kt");
            }

            @TestMetadata("propertyAtBrace3.kt")
            public void testPropertyAtBrace3() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtBrace3.kt");
            }

            @TestMetadata("propertyAtBrace4.kt")
            public void testPropertyAtBrace4() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtBrace4.kt");
            }

            @TestMetadata("propertyAtBrace5.kt")
            public void testPropertyAtBrace5() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtBrace5.kt");
            }

            @TestMetadata("propertyAtBrace6.kt")
            public void testPropertyAtBrace6() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtBrace6.kt");
            }

            @TestMetadata("propertyAtClass1.kt")
            public void testPropertyAtClass1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtClass1.kt");
            }

            @TestMetadata("propertyAtClass2.kt")
            public void testPropertyAtClass2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtClass2.kt");
            }

            @TestMetadata("propertyAtClassInitializer1.kt")
            public void testPropertyAtClassInitializer1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtClassInitializer1.kt");
            }

            @TestMetadata("propertyAtClassInitializer2.kt")
            public void testPropertyAtClassInitializer2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtClassInitializer2.kt");
            }

            @TestMetadata("propertyAtEmptyLine1.kt")
            public void testPropertyAtEmptyLine1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtEmptyLine1.kt");
            }

            @TestMetadata("propertyAtEmptyLine2.kt")
            public void testPropertyAtEmptyLine2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtEmptyLine2.kt");
            }

            @TestMetadata("propertyAtFunction1.kt")
            public void testPropertyAtFunction1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtFunction1.kt");
            }

            @TestMetadata("propertyAtFunction2.kt")
            public void testPropertyAtFunction2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtFunction2.kt");
            }

            @TestMetadata("propertyAtProperty1.kt")
            public void testPropertyAtProperty1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtProperty1.kt");
            }

            @TestMetadata("propertyAtProperty2.kt")
            public void testPropertyAtProperty2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/property/propertyAtProperty2.kt");
            }
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/propertyAnchors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PropertyAnchors extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestClassBodyDeclaration, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInPropertyAnchors() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/propertyAnchors"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("keyword.kt")
            public void testKeyword() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/propertyAnchors/keyword.kt");
            }

            @TestMetadata("name.kt")
            public void testName() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/propertyAnchors/name.kt");
            }

            @TestMetadata("returnType.kt")
            public void testReturnType() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/classBodyDeclarations/propertyAnchors/returnType.kt");
            }
        }
    }

    @TestMetadata("idea/testData/codeInsight/moveUpDown/closingBraces")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ClosingBraces extends AbstractMoveStatementTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestExpression, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInClosingBraces() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/closingBraces"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/closingBraces/for")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class For extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestExpression, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFor() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/closingBraces/for"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("for1.kt")
            public void testFor1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/for/for1.kt");
            }

            @TestMetadata("for2.kt")
            public void testFor2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/for/for2.kt");
            }
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/closingBraces/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestExpression, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/closingBraces/function"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("function1.kt")
            public void testFunction1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/function/function1.kt");
            }

            @TestMetadata("function2.kt")
            public void testFunction2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/function/function2.kt");
            }

            @TestMetadata("function3.kt")
            public void testFunction3() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/function/function3.kt");
            }

            @TestMetadata("function4.kt")
            public void testFunction4() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/function/function4.kt");
            }
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/closingBraces/if")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class If extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestExpression, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInIf() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/closingBraces/if"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("if1.kt")
            public void testIf1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/if/if1.kt");
            }

            @TestMetadata("if2.kt")
            public void testIf2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/if/if2.kt");
            }

            @TestMetadata("if3.kt")
            public void testIf3() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/if/if3.kt");
            }

            @TestMetadata("if4.kt")
            public void testIf4() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/if/if4.kt");
            }
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/closingBraces/nested")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Nested extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestExpression, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInNested() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/closingBraces/nested"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("nested1.kt")
            public void testNested1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/nested/nested1.kt");
            }

            @TestMetadata("nested2.kt")
            public void testNested2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/nested/nested2.kt");
            }
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/closingBraces/when")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class When extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestExpression, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInWhen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/closingBraces/when"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("when1.kt")
            public void testWhen1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/when/when1.kt");
            }

            @TestMetadata("when2.kt")
            public void testWhen2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/when/when2.kt");
            }

            @TestMetadata("whenEntry1.kt")
            public void testWhenEntry1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/when/whenEntry1.kt");
            }

            @TestMetadata("whenEntry2.kt")
            public void testWhenEntry2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/when/whenEntry2.kt");
            }

            @TestMetadata("whenEntry3.kt")
            public void testWhenEntry3() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/when/whenEntry3.kt");
            }

            @TestMetadata("whenEntry4.kt")
            public void testWhenEntry4() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/when/whenEntry4.kt");
            }
        }

        @TestMetadata("idea/testData/codeInsight/moveUpDown/closingBraces/while")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class While extends AbstractMoveStatementTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestExpression, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInWhile() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/closingBraces/while"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("while1.kt")
            public void testWhile1() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/while/while1.kt");
            }

            @TestMetadata("while2.kt")
            public void testWhile2() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/while/while2.kt");
            }

            @TestMetadata("while3.kt")
            public void testWhile3() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/while/while3.kt");
            }

            @TestMetadata("while4.kt")
            public void testWhile4() throws Exception {
                runTest("idea/testData/codeInsight/moveUpDown/closingBraces/while/while4.kt");
            }
        }
    }

    @TestMetadata("idea/testData/codeInsight/moveUpDown/expressions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Expressions extends AbstractMoveStatementTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestExpression, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInExpressions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/expressions"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("binaryExpr1.kt")
        public void testBinaryExpr1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/binaryExpr1.kt");
        }

        @TestMetadata("binaryExpr2.kt")
        public void testBinaryExpr2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/binaryExpr2.kt");
        }

        @TestMetadata("closureBlockBoundary1.kt")
        public void testClosureBlockBoundary1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/closureBlockBoundary1.kt");
        }

        @TestMetadata("closureBlockBoundary2.kt")
        public void testClosureBlockBoundary2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/closureBlockBoundary2.kt");
        }

        @TestMetadata("closureInDoWhile1.kt")
        public void testClosureInDoWhile1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/closureInDoWhile1.kt");
        }

        @TestMetadata("closureInDoWhile2.kt")
        public void testClosureInDoWhile2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/closureInDoWhile2.kt");
        }

        @TestMetadata("closureInFor1.kt")
        public void testClosureInFor1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/closureInFor1.kt");
        }

        @TestMetadata("closureInFor2.kt")
        public void testClosureInFor2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/closureInFor2.kt");
        }

        @TestMetadata("closureInIf1.kt")
        public void testClosureInIf1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/closureInIf1.kt");
        }

        @TestMetadata("closureInIf2.kt")
        public void testClosureInIf2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/closureInIf2.kt");
        }

        @TestMetadata("closureInWhile1.kt")
        public void testClosureInWhile1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/closureInWhile1.kt");
        }

        @TestMetadata("closureInWhile2.kt")
        public void testClosureInWhile2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/closureInWhile2.kt");
        }

        @TestMetadata("closureWthoutSpaces1.kt")
        public void testClosureWthoutSpaces1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/closureWthoutSpaces1.kt");
        }

        @TestMetadata("closureWthoutSpaces2.kt")
        public void testClosureWthoutSpaces2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/closureWthoutSpaces2.kt");
        }

        @TestMetadata("declaration1.kt")
        public void testDeclaration1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/declaration1.kt");
        }

        @TestMetadata("declaration2.kt")
        public void testDeclaration2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/declaration2.kt");
        }

        @TestMetadata("If1.kt")
        public void testIf1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/If1.kt");
        }

        @TestMetadata("if2.kt")
        public void testIf2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/if2.kt");
        }

        @TestMetadata("if3.kt")
        public void testIf3() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/if3.kt");
        }

        @TestMetadata("if4.kt")
        public void testIf4() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/if4.kt");
        }

        @TestMetadata("ifExprToBlock1.kt")
        public void testIfExprToBlock1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/ifExprToBlock1.kt");
        }

        @TestMetadata("ifExprToBlock2.kt")
        public void testIfExprToBlock2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/ifExprToBlock2.kt");
        }

        @TestMetadata("ifToBlock1.kt")
        public void testIfToBlock1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/ifToBlock1.kt");
        }

        @TestMetadata("ifToBlock2.kt")
        public void testIfToBlock2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/ifToBlock2.kt");
        }

        @TestMetadata("insideExpression1.kt")
        public void testInsideExpression1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/insideExpression1.kt");
        }

        @TestMetadata("insideExpression2.kt")
        public void testInsideExpression2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/insideExpression2.kt");
        }

        @TestMetadata("insideExpression3.kt")
        public void testInsideExpression3() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/insideExpression3.kt");
        }

        @TestMetadata("insideExpression4.kt")
        public void testInsideExpression4() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/insideExpression4.kt");
        }

        @TestMetadata("intoCatch.kt")
        public void testIntoCatch() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoCatch.kt");
        }

        @TestMetadata("intoClosure1.kt")
        public void testIntoClosure1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoClosure1.kt");
        }

        @TestMetadata("intoClosure2.kt")
        public void testIntoClosure2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoClosure2.kt");
        }

        @TestMetadata("intoClosureWithParams1.kt")
        public void testIntoClosureWithParams1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoClosureWithParams1.kt");
        }

        @TestMetadata("intoElse1.kt")
        public void testIntoElse1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoElse1.kt");
        }

        @TestMetadata("intoElse2.kt")
        public void testIntoElse2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoElse2.kt");
        }

        @TestMetadata("intoElse3.kt")
        public void testIntoElse3() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoElse3.kt");
        }

        @TestMetadata("intoElse4.kt")
        public void testIntoElse4() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoElse4.kt");
        }

        @TestMetadata("intoElseIf.kt")
        public void testIntoElseIf() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoElseIf.kt");
        }

        @TestMetadata("intoFinally.kt")
        public void testIntoFinally() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoFinally.kt");
        }

        @TestMetadata("intoNestedClosure1.kt")
        public void testIntoNestedClosure1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoNestedClosure1.kt");
        }

        @TestMetadata("intoNestedClosure2.kt")
        public void testIntoNestedClosure2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoNestedClosure2.kt");
        }

        @TestMetadata("intoNestedClosureWithParams1.kt")
        public void testIntoNestedClosureWithParams1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoNestedClosureWithParams1.kt");
        }

        @TestMetadata("intoWhenElse.kt")
        public void testIntoWhenElse() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoWhenElse.kt");
        }

        @TestMetadata("intoWhenEntry.kt")
        public void testIntoWhenEntry() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/intoWhenEntry.kt");
        }

        @TestMetadata("lambda1.kt")
        public void testLambda1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/lambda1.kt");
        }

        @TestMetadata("lambda2.kt")
        public void testLambda2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/lambda2.kt");
        }

        @TestMetadata("lambda3.kt")
        public void testLambda3() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/lambda3.kt");
        }

        @TestMetadata("multilineComment1.kt")
        public void testMultilineComment1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/multilineComment1.kt");
        }

        @TestMetadata("multilineComment2.kt")
        public void testMultilineComment2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/multilineComment2.kt");
        }

        @TestMetadata("multilineComment3.kt")
        public void testMultilineComment3() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/multilineComment3.kt");
        }

        @TestMetadata("multilineComment4.kt")
        public void testMultilineComment4() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/multilineComment4.kt");
        }

        @TestMetadata("multilineComment5.kt")
        public void testMultilineComment5() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/multilineComment5.kt");
        }

        @TestMetadata("multilineComment6.kt")
        public void testMultilineComment6() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/multilineComment6.kt");
        }

        @TestMetadata("multilineExpressionWithClosure1.kt")
        public void testMultilineExpressionWithClosure1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/multilineExpressionWithClosure1.kt");
        }

        @TestMetadata("multilineExpressionWithClosure2.kt")
        public void testMultilineExpressionWithClosure2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/multilineExpressionWithClosure2.kt");
        }

        @TestMetadata("outOfClosure1.kt")
        public void testOutOfClosure1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/outOfClosure1.kt");
        }

        @TestMetadata("outOfClosure2.kt")
        public void testOutOfClosure2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/outOfClosure2.kt");
        }

        @TestMetadata("outOfClosureInScriptsDown.kts")
        public void testOutOfClosureInScriptsDown() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/outOfClosureInScriptsDown.kts");
        }

        @TestMetadata("outOfClosureInScriptsUp.kts")
        public void testOutOfClosureInScriptsUp() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/outOfClosureInScriptsUp.kts");
        }

        @TestMetadata("outOfClosureWithParams1.kt")
        public void testOutOfClosureWithParams1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/outOfClosureWithParams1.kt");
        }

        @TestMetadata("outOfElse1.kt")
        public void testOutOfElse1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/outOfElse1.kt");
        }

        @TestMetadata("outOfElse2.kt")
        public void testOutOfElse2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/outOfElse2.kt");
        }

        @TestMetadata("outOfNestedClosure1.kt")
        public void testOutOfNestedClosure1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/outOfNestedClosure1.kt");
        }

        @TestMetadata("outOfNestedClosure2.kt")
        public void testOutOfNestedClosure2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/outOfNestedClosure2.kt");
        }

        @TestMetadata("outOfNestedClosureWithParams1.kt")
        public void testOutOfNestedClosureWithParams1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/outOfNestedClosureWithParams1.kt");
        }

        @TestMetadata("qualifiedCall1.kt")
        public void testQualifiedCall1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/qualifiedCall1.kt");
        }

        @TestMetadata("qualifiedCall2.kt")
        public void testQualifiedCall2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/qualifiedCall2.kt");
        }

        @TestMetadata("when1.kt")
        public void testWhen1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/when1.kt");
        }

        @TestMetadata("when2.kt")
        public void testWhen2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/when2.kt");
        }

        @TestMetadata("whenEntry1.kt")
        public void testWhenEntry1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/whenEntry1.kt");
        }

        @TestMetadata("whenEntry2.kt")
        public void testWhenEntry2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/whenEntry2.kt");
        }

        @TestMetadata("whenEntry3.kt")
        public void testWhenEntry3() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/whenEntry3.kt");
        }

        @TestMetadata("whenEntry4.kt")
        public void testWhenEntry4() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/whenEntry4.kt");
        }

        @TestMetadata("whenEntry5.kt")
        public void testWhenEntry5() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/whenEntry5.kt");
        }

        @TestMetadata("whenEntry6.kt")
        public void testWhenEntry6() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/whenEntry6.kt");
        }

        @TestMetadata("while1.kt")
        public void testWhile1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/while1.kt");
        }

        @TestMetadata("while2.kt")
        public void testWhile2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/while2.kt");
        }

        @TestMetadata("whileToBlock1.kt")
        public void testWhileToBlock1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/whileToBlock1.kt");
        }

        @TestMetadata("whileToBlock2.kt")
        public void testWhileToBlock2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/expressions/whileToBlock2.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/moveUpDown/parametersAndArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ParametersAndArguments extends AbstractMoveStatementTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestExpression, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInParametersAndArguments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/moveUpDown/parametersAndArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callArgs1.kt")
        public void testCallArgs1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/callArgs1.kt");
        }

        @TestMetadata("callArgs2.kt")
        public void testCallArgs2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/callArgs2.kt");
        }

        @TestMetadata("callArgs3.kt")
        public void testCallArgs3() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/callArgs3.kt");
        }

        @TestMetadata("callArgs4.kt")
        public void testCallArgs4() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/callArgs4.kt");
        }

        @TestMetadata("callArgs5.kt")
        public void testCallArgs5() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/callArgs5.kt");
        }

        @TestMetadata("callArgs6.kt")
        public void testCallArgs6() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/callArgs6.kt");
        }

        @TestMetadata("classParams1.kt")
        public void testClassParams1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/classParams1.kt");
        }

        @TestMetadata("classParams2.kt")
        public void testClassParams2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/classParams2.kt");
        }

        @TestMetadata("classParams3.kt")
        public void testClassParams3() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/classParams3.kt");
        }

        @TestMetadata("classParams4.kt")
        public void testClassParams4() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/classParams4.kt");
        }

        @TestMetadata("classParams5.kt")
        public void testClassParams5() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/classParams5.kt");
        }

        @TestMetadata("classParams6.kt")
        public void testClassParams6() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/classParams6.kt");
        }

        @TestMetadata("funParams1.kt")
        public void testFunParams1() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/funParams1.kt");
        }

        @TestMetadata("funParams2.kt")
        public void testFunParams2() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/funParams2.kt");
        }

        @TestMetadata("funParams3.kt")
        public void testFunParams3() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/funParams3.kt");
        }

        @TestMetadata("funParams4.kt")
        public void testFunParams4() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/funParams4.kt");
        }

        @TestMetadata("funParams5.kt")
        public void testFunParams5() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/funParams5.kt");
        }

        @TestMetadata("funParams6.kt")
        public void testFunParams6() throws Exception {
            runTest("idea/testData/codeInsight/moveUpDown/parametersAndArguments/funParams6.kt");
        }
    }
}
