; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -mtriple=amdgcn-amd-amdhsa -passes=instcombine -S | FileCheck %s

; Simplify to +0.0.
define float @test_zero(float %x) {
; CHECK-LABEL: @test_zero(
; CHECK-NEXT:    ret float 0.000000e+00
;
  %call = call float @llvm.amdgcn.fmul.legacy(float %x, float 0.0)
  ret float %call
}

; Simplify to +0.0.
define float @test_negzero(float %y) {
; CHECK-LABEL: @test_negzero(
; CHECK-NEXT:    ret float 0.000000e+00
;
  %call = call float @llvm.amdgcn.fmul.legacy(float -0.0, float %y)
  ret float %call
}

; Combine to fmul because the constant is finite and non-zero.
define float @test_const(float %x) {
; CHECK-LABEL: @test_const(
; CHECK-NEXT:    [[CALL:%.*]] = fmul float [[X:%.*]], 9.950000e+01
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.amdgcn.fmul.legacy(float %x, float 99.5)
  ret float %call
}

; Combine to fmul because the constant is finite and non-zero, preserving fmf.
define float @test_const_fmf(float %x) {
; CHECK-LABEL: @test_const_fmf(
; CHECK-NEXT:    [[CALL:%.*]] = fmul contract float [[X:%.*]], 9.950000e+01
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call contract float @llvm.amdgcn.fmul.legacy(float %x, float 99.5)
  ret float %call
}

; Combine to fmul because neither argument can be infinity or NaN.
define float @test_finite(i32 %x, i32 %y) {
; CHECK-LABEL: @test_finite(
; CHECK-NEXT:    [[XF:%.*]] = sitofp i32 [[X:%.*]] to float
; CHECK-NEXT:    [[YF:%.*]] = sitofp i32 [[Y:%.*]] to float
; CHECK-NEXT:    [[CALL:%.*]] = fmul float [[XF]], [[YF]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %xf = sitofp i32 %x to float
  %yf = sitofp i32 %y to float
  %call = call float @llvm.amdgcn.fmul.legacy(float %xf, float %yf)
  ret float %call
}

; Combine to fmul because neither argument can be infinity or NaN based on assumptions
define float @test_finite_assumed(float %x, float %y) {
; CHECK-LABEL: @test_finite_assumed(
; CHECK-NEXT:    [[FABS_X:%.*]] = call float @llvm.fabs.f32(float [[X:%.*]])
; CHECK-NEXT:    [[IS_FINITE_X:%.*]] = fcmp one float [[FABS_X]], 0x7FF0000000000000
; CHECK-NEXT:    [[FABS_Y:%.*]] = call float @llvm.fabs.f32(float [[Y:%.*]])
; CHECK-NEXT:    [[IS_FINITE_Y:%.*]] = fcmp one float [[FABS_Y]], 0x7FF0000000000000
; CHECK-NEXT:    call void @llvm.assume(i1 [[IS_FINITE_X]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[IS_FINITE_Y]])
; CHECK-NEXT:    [[CALL:%.*]] = fmul float [[X]], [[Y]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %fabs.x = call float @llvm.fabs.f32(float %x)
  %is.finite.x = fcmp one float %fabs.x, 0x7FF0000000000000
  %fabs.y = call float @llvm.fabs.f32(float %y)
  %is.finite.y = fcmp one float %fabs.y, 0x7FF0000000000000
  call void @llvm.assume(i1 %is.finite.x)
  call void @llvm.assume(i1 %is.finite.y)
  %call = call float @llvm.amdgcn.fmul.legacy(float %x, float %y)
  ret float %call
}

declare float @llvm.amdgcn.fmul.legacy(float, float)
declare float @llvm.fabs.f32(float)
declare void @llvm.assume(i1 noundef)
