#include "networkproperties.h"

NetworkPropertiesModel::NetworkPropertiesModel(QObject *parent)
    : QObject(parent), m_ipAddress(QStringList()), m_netmask(""), m_gateway(""), m_password("")
{
}

NetworkPropertiesModel::~NetworkPropertiesModel()
{
}


const QStringList NetworkPropertiesModel::ipAddress() const
{
    return m_ipAddress;
}

void NetworkPropertiesModel::setIpAddress(const QStringList &ipAddress)
{
    if (m_ipAddress != ipAddress) {
        m_ipAddress = ipAddress;
        emit ipAddressChanged();
    }
}

const QString NetworkPropertiesModel::netmask() const
{
    return m_netmask;
}

void NetworkPropertiesModel::setNetmask(const QString &netmask)
{
    if (m_netmask != netmask) {
        m_netmask = netmask;
        emit netmaskChanged();
    }
}

const QString NetworkPropertiesModel::gateway() const
{
    return m_gateway;
}

void NetworkPropertiesModel::setGateway(const QString &gateway)
{
    if (m_gateway != gateway) {
        m_gateway = gateway;
        emit gatewayChanged();
    }
}

const QString NetworkPropertiesModel::password() const
{
    return m_password;
}

void NetworkPropertiesModel::setPassword(const QString &password)
{
    if (m_password != password) {
        m_password = password;
        emit passwordChanged();
    }
}
