/*!
 * \file
 * \brief Windowing functions test program
 * \author Tony Ottosson, Tobias Ringstrom, Pal Frenger, Adam Piatyszek
 *         and Kumar Appaiah
 *
 * -------------------------------------------------------------------------
 *
 * Copyright (C) 1995-2013  (see AUTHORS file for a list of contributors)
 *
 * This file is part of IT++ - a C++ library of mathematical, signal
 * processing, speech processing, and communications classes and functions.
 *
 * IT++ is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * IT++ is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with IT++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * -------------------------------------------------------------------------
 */

#include <itpp/itsignal.h>
#include "gtest/gtest.h"

using namespace itpp;

static
void assert_vec_p(const vec &ref, const vec &act, int line)
{
  static const double tol = 1e-4;
  ASSERT_EQ(ref.length(), act.length()) << line;
  for (int n = 0; n < ref.length(); ++n) {
    ASSERT_NEAR(ref(n), act(n), tol) << line;
  }
}
#define assert_vec(ref, act) assert_vec_p(ref, act, __LINE__)

TEST(Window, All)
{
  // Test of window functions
  vec ref = "0.08 0.0894162 0.117279 0.162449 0.223075 0.296677 0.38024 0.470343 0.563299 0.6553 0.742581 "
  "0.821569 0.889029 0.942199 0.978904 0.99764 0.99764 0.978904 0.942199 0.889029 0.821569 0.742581 "
  "0.6553 0.563299 0.470343 0.38024 0.296677 0.223075 0.162449 0.117279 0.0894162 0.08";
  assert_vec(ref, hamming(32));
  ref = "0.08 0.0805628 0.08225 0.0850574 0.0889781 0.0940025 0.100118 0.107311 0.115562 0.124852 0.135157 0.146454 0.158713 0.171906 0.185999 0.200959 0.216749 0.233329 0.25066 0.268699 0.287402 0.306723 0.326615 0.347029 0.367915 0.389223 0.410899 0.432892 0.455146 0.477608 0.500223 0.522935 0.545689 0.568429 0.5911 0.613645 0.63601 0.658141 0.679982 0.70148 0.722584 0.74324 0.763399 0.783012 0.80203 0.820406 0.838097 0.855058 0.871247 0.886627 0.901158 0.914805 0.927535 0.939317 0.950121 0.959922 0.968695 0.976419 0.983075 0.988647 0.993121 0.996486 0.998734 0.999859 0.999859 0.998734 0.996486 0.993121 0.988647 0.983075 0.976419 0.968695 0.959922 0.950121 0.939317 0.927535 0.914805 0.901158 0.886627 0.871247 0.855058 0.838097 0.820406 0.80203 0.783012 0.763399 0.74324 0.722584 0.70148 0.679982 0.658141 0.63601 0.613645 0.5911 0.568429 0.545689 0.522935 0.500223 0.477608 0.455146 0.432892 0.410899 0.389223 0.367915 0.347029 0.326615 0.306723 0.287402 0.268699 0.25066 0.233329 0.216749 0.200959 0.185999 0.171906 0.158713 0.146454 0.135157 0.124852 0.115562 0.107311 0.100118 0.0940025 0.0889781 0.0850574 0.08225 0.0805628 0.08";
  assert_vec(ref, hamming(128));

  ref = "0.00903565 0.035816 0.0793732 0.138133 0.209972 0.292292 0.382121 0.476209 0.571157 0.663534 0.75 0.82743 0.893027 0.944418 0.979746 0.997736 0.997736 0.979746 0.944418 0.893027 0.82743 0.75 0.663534 0.571157 0.476209 0.382121 0.292292 0.209972 0.138133 0.0793732 0.035816 0.00903565";
  assert_vec(ref, hanning(32));
  ref = "0.000592972 0.00237048 0.00532832 0.00945946 0.0147541 0.0211997 0.028781 0.0374799 0.0472759 0.0581457 0.0700635 0.0830011 0.0969278 0.11181 0.127614 0.144301 0.161831 0.180163 0.199255 0.219059 0.23953 0.260618 0.282275 0.304448 0.327084 0.350131 0.373533 0.397236 0.421181 0.445314 0.469577 0.493912 0.518261 0.542567 0.566772 0.590818 0.61465 0.638209 0.66144 0.684289 0.7067 0.728621 0.75 0.770786 0.790929 0.810383 0.8291 0.847037 0.864151 0.880401 0.895748 0.910157 0.923593 0.936025 0.947422 0.957758 0.967008 0.975151 0.982166 0.988038 0.992752 0.996298 0.998666 0.999852 0.999852 0.998666 0.996298 0.992752 0.988038 0.982166 0.975151 0.967008 0.957758 0.947422 0.936025 0.923593 0.910157 0.895748 0.880401 0.864151 0.847037 0.8291 0.810383 0.790929 0.770786 0.75 0.728621 0.7067 0.684289 0.66144 0.638209 0.61465 0.590818 0.566772 0.542567 0.518261 0.493912 0.469577 0.445314 0.421181 0.397236 0.373533 0.350131 0.327084 0.304448 0.282275 0.260618 0.23953 0.219059 0.199255 0.180163 0.161831 0.144301 0.127614 0.11181 0.0969278 0.0830011 0.0700635 0.0581457 0.0472759 0.0374799 0.028781 0.0211997 0.0147541 0.00945946 0.00532832 0.00237048 0.000592972";
  assert_vec(ref, hanning(128));

  ref = "0 0.010235 0.0405211 0.0896183 0.155517 0.235518 0.326347 0.424286 0.525325 0.625326 0.720197 0.806053 0.879379 0.937173 0.97707 0.997435 0.997435 0.97707 0.937173 0.879379 0.806053 0.720197 0.625326 0.525325 0.424286 0.326347 0.235518 0.155517 0.0896183 0.0405211 0.010235 0";
  assert_vec(ref, hann(32));
  ref = "0 0.000611792 0.00244567 0.00549715 0.00975876 0.0152201 0.0218677 0.0296854 0.0386541 0.0487517 0.0599537 0.0722325 0.0855581 0.0998979 0.115217 0.131477 0.14864 0.166662 0.1855 0.205108 0.225437 0.246438 0.26806 0.290249 0.312952 0.336112 0.359673 0.383578 0.407768 0.432183 0.456764 0.481452 0.506184 0.530901 0.555543 0.580049 0.604359 0.628414 0.652154 0.675522 0.69846 0.720913 0.742825 0.764143 0.784815 0.804789 0.824018 0.842454 0.860052 0.876768 0.892563 0.907397 0.921234 0.93404 0.945784 0.956437 0.965973 0.974369 0.981603 0.98766 0.992523 0.99618 0.998624 0.999847 0.999847 0.998624 0.99618 0.992523 0.98766 0.981603 0.974369 0.965973 0.956437 0.945784 0.93404 0.921234 0.907397 0.892563 0.876768 0.860052 0.842454 0.824018 0.804789 0.784815 0.764143 0.742825 0.720913 0.69846 0.675522 0.652154 0.628414 0.604359 0.580049 0.555543 0.530901 0.506184 0.481452 0.456764 0.432183 0.407768 0.383578 0.359673 0.336112 0.312952 0.290249 0.26806 0.246438 0.225437 0.205108 0.1855 0.166662 0.14864 0.131477 0.115217 0.0998979 0.0855581 0.0722325 0.0599537 0.0487517 0.0386541 0.0296854 0.0218677 0.0152201 0.00975876 0.00549715 0.00244567 0.000611792 0";
  assert_vec(ref, hann(128));

  ref = "-1.38778e-17 0.00375165 0.0156384 0.0374027 0.0714646 0.120286 0.185647 0.267955 0.365735 0.475379 0.591229 0.706001 0.811493 0.89949 0.962731 0.995797 0.995797 0.962731 0.89949 0.811493 0.706001 0.591229 0.475379 0.365735 0.267955 0.185647 0.120286 0.0714646 0.0374027 0.0156384 0.00375165 -1.38778e-17";
  assert_vec(ref, blackman(32));
  ref = "-1.38778e-17 0.000220485 0.000884269 0.00199831 0.0035741 0.00562748 0.00817842 0.0112507 0.0148717 0.0190717 0.0238838 0.0293429 0.0354858 0.0423502 0.049974 0.0583951 0.0676504 0.0777751 0.0888026 0.100763 0.113683 0.127586 0.142489 0.158406 0.175343 0.193302 0.212276 0.232253 0.253212 0.275127 0.297961 0.321672 0.346209 0.371513 0.397518 0.42415 0.451329 0.478967 0.506971 0.535239 0.563668 0.592147 0.620562 0.648797 0.676731 0.704243 0.73121 0.75751 0.783019 0.807619 0.83119 0.853619 0.874794 0.89461 0.912966 0.929771 0.944936 0.958385 0.970046 0.97986 0.987773 0.993745 0.997744 0.999749 0.999749 0.997744 0.993745 0.987773 0.97986 0.970046 0.958385 0.944936 0.929771 0.912966 0.89461 0.874794 0.853619 0.83119 0.807619 0.783019 0.75751 0.73121 0.704243 0.676731 0.648797 0.620562 0.592147 0.563668 0.535239 0.506971 0.478967 0.451329 0.42415 0.397518 0.371513 0.346209 0.321672 0.297961 0.275127 0.253212 0.232253 0.212276 0.193302 0.175343 0.158406 0.142489 0.127586 0.113683 0.100763 0.0888026 0.0777751 0.0676504 0.0583951 0.049974 0.0423502 0.0354858 0.0293429 0.0238838 0.0190717 0.0148717 0.0112507 0.00817842 0.00562748 0.0035741 0.00199831 0.000884269 0.000220485 -1.38778e-17";
  assert_vec(ref, blackman(128));

  ref = "0.03125 0.09375 0.15625 0.21875 0.28125 0.34375 0.40625 0.46875 0.53125 0.59375 0.65625 0.71875 0.78125 0.84375 0.90625 0.96875 0.96875 0.90625 0.84375 0.78125 0.71875 0.65625 0.59375 0.53125 0.46875 0.40625 0.34375 0.28125 0.21875 0.15625 0.09375 0.03125";
  assert_vec(ref, triang(32));
  ref = "0.0078125 0.0234375 0.0390625 0.0546875 0.0703125 0.0859375 0.101562 0.117188 0.132812 0.148438 0.164062 0.179688 0.195312 0.210938 0.226562 0.242188 0.257812 0.273438 0.289062 0.304688 0.320312 0.335938 0.351562 0.367188 0.382812 0.398438 0.414062 0.429688 0.445312 0.460938 0.476562 0.492188 0.507812 0.523438 0.539062 0.554688 0.570312 0.585938 0.601562 0.617188 0.632812 0.648438 0.664062 0.679688 0.695312 0.710938 0.726562 0.742188 0.757812 0.773438 0.789062 0.804688 0.820312 0.835938 0.851562 0.867188 0.882812 0.898438 0.914062 0.929688 0.945312 0.960938 0.976562 0.992188 0.992188 0.976562 0.960938 0.945312 0.929688 0.914062 0.898438 0.882812 0.867188 0.851562 0.835938 0.820312 0.804688 0.789062 0.773438 0.757812 0.742188 0.726562 0.710938 0.695312 0.679688 0.664062 0.648438 0.632812 0.617188 0.601562 0.585938 0.570312 0.554688 0.539062 0.523438 0.507812 0.492188 0.476562 0.460938 0.445312 0.429688 0.414062 0.398438 0.382812 0.367188 0.351562 0.335938 0.320312 0.304688 0.289062 0.273438 0.257812 0.242188 0.226562 0.210938 0.195312 0.179688 0.164062 0.148438 0.132812 0.117188 0.101562 0.0859375 0.0703125 0.0546875 0.0390625 0.0234375 0.0078125";
  assert_vec(ref, triang(128));

  ref = "0.0506644 0.0660694 0.10498 0.15479 0.215657 0.287019 0.367536 0.455085 0.546825 0.639332 0.728786 0.811205 0.882711 0.939797 0.979577 1 1 0.979577 0.939797 0.882711 0.811205 0.728786 0.639332 0.546825 0.455085 0.367536 0.287019 0.215657 0.15479 0.10498 0.0660694 0.0506644";
  assert_vec(ref, chebwin(32, 50));
  ref = "1.56678 0.436121 0.491129 0.546501 0.601556 0.655594 0.707906 0.757788 0.804557 0.847559 0.886183 0.919874 0.948143 0.970576 0.986841 0.996698 1 0.996698 0.986841 0.970576 0.948143 0.919874 0.886183 0.847559 0.804557 0.757788 0.707906 0.655594 0.601556 0.546501 0.491129 0.436121 1.56678";
  assert_vec(ref, chebwin(33, 20));
  ref = "2.80628 0.283796 0.297805 0.312035 0.326476 0.341115 0.35594 0.370939 0.386096 0.401399 0.416834 0.432385 0.448038 0.463778 0.479588 0.495453 0.511356 0.527281 0.543212 0.55913 0.57502 0.590863 0.606643 0.622342 0.637942 0.653425 0.668774 0.683972 0.699 0.713841 0.728478 0.742894 0.75707 0.770991 0.784639 0.797997 0.811051 0.823783 0.836177 0.84822 0.859895 0.871188 0.882084 0.892571 0.902636 0.912264 0.921444 0.930165 0.938415 0.946184 0.953461 0.960238 0.966505 0.972255 0.97748 0.982174 0.98633 0.989942 0.993007 0.99552 0.997478 0.998879 0.99972 1 0.99972 0.998879 0.997478 0.99552 0.993007 0.989942 0.98633 0.982174 0.97748 0.972255 0.966505 0.960238 0.953461 0.946184 0.938415 0.930165 0.921444 0.912264 0.902636 0.892571 0.882084 0.871188 0.859895 0.84822 0.836177 0.823783 0.811051 0.797997 0.784639 0.770991 0.75707 0.742894 0.728478 0.713841 0.699 0.683972 0.668774 0.653425 0.637942 0.622342 0.606643 0.590863 0.57502 0.55913 0.543212 0.527281 0.511356 0.495453 0.479588 0.463778 0.448038 0.432385 0.416834 0.401399 0.386096 0.370939 0.35594 0.341115 0.326476 0.312035 0.297805 0.283796 2.80628";
  assert_vec(ref, chebwin(127, 25));
  ref = "2.82761 0.283705 0.297601 0.311716 0.326039 0.340557 0.355259 0.370131 0.385162 0.400336 0.415641 0.431062 0.446584 0.462193 0.477873 0.493609 0.509385 0.525184 0.54099 0.556787 0.572558 0.588287 0.603955 0.619547 0.635045 0.650431 0.665689 0.6808 0.695749 0.710518 0.725089 0.739446 0.753573 0.767451 0.781066 0.7944 0.807438 0.820163 0.832562 0.844618 0.856317 0.867644 0.878586 0.889128 0.899259 0.908965 0.918235 0.927056 0.935417 0.943309 0.950721 0.957643 0.964068 0.969986 0.975391 0.980275 0.984632 0.988457 0.991744 0.99449 0.996691 0.998345 0.999448 1 1 0.999448 0.998345 0.996691 0.99449 0.991744 0.988457 0.984632 0.980275 0.975391 0.969986 0.964068 0.957643 0.950721 0.943309 0.935417 0.927056 0.918235 0.908965 0.899259 0.889128 0.878586 0.867644 0.856317 0.844618 0.832562 0.820163 0.807438 0.7944 0.781066 0.767451 0.753573 0.739446 0.725089 0.710518 0.695749 0.6808 0.665689 0.650431 0.635045 0.619547 0.603955 0.588287 0.572558 0.556787 0.54099 0.525184 0.509385 0.493609 0.477873 0.462193 0.446584 0.431062 0.415641 0.400336 0.385162 0.370131 0.355259 0.340557 0.326039 0.311716 0.297601 0.283705 2.82761";
  assert_vec(ref, chebwin(128, 25));
}
