..
    Warning: Do not edit this file. It is automatically generated from the
    software project's code and your changes will be overwritten.

    The tool to generate this file lives in openstack-doc-tools repository.

    Please make any changes needed in the code, then run the
    autogenerate-config-doc tool from the openstack-doc-tools repository, or
    ask for help on the documentation mailing list, IRC channel or meeting.

.. _manila-generic:

.. list-table:: Description of Generic share driver configuration options
   :header-rows: 1
   :class: config-ref-table

   * - Configuration option = Default value
     - Description
   * - **[DEFAULT]**
     -
   * - ``connect_share_server_to_tenant_network`` = ``False``
     - (Boolean) Attach share server directly to share network. Used only with Neutron and if driver_handles_share_servers=True.
   * - ``container_volume_group`` = ``manila_docker_volumes``
     - (String) LVM volume group to use for volumes. This volume group must be created by the cloud administrator independently from manila operations.
   * - ``driver_handles_share_servers`` = ``None``
     - (Boolean) There are two possible approaches for share drivers in Manila. First is when share driver is able to handle share-servers and second when not. Drivers can support either both or only one of these approaches. So, set this opt to True if share driver is able to handle share servers and it is desired mode else set False. It is set to None by default to make this choice intentional.
   * - ``goodness_function`` = ``None``
     - (String) String representation for an equation that will be used to determine the goodness of a host.
   * - ``interface_driver`` = ``manila.network.linux.interface.OVSInterfaceDriver``
     - (String) Vif driver. Used only with Neutron and if driver_handles_share_servers=True.
   * - ``manila_service_keypair_name`` = ``manila-service``
     - (String) Keypair name that will be created and used for service instances. Only used if driver_handles_share_servers=True.
   * - ``max_time_to_attach`` = ``120``
     - (Integer) Maximum time to wait for attaching cinder volume.
   * - ``max_time_to_build_instance`` = ``300``
     - (Integer) Maximum time in seconds to wait for creating service instance.
   * - ``max_time_to_create_volume`` = ``180``
     - (Integer) Maximum time to wait for creating cinder volume.
   * - ``max_time_to_extend_volume`` = ``180``
     - (Integer) Maximum time to wait for extending cinder volume.
   * - ``ovs_integration_bridge`` = ``br-int``
     - (String) Name of Open vSwitch bridge to use.
   * - ``path_to_private_key`` = ``None``
     - (String) Path to host's private key.
   * - ``path_to_public_key`` = ``~/.ssh/id_rsa.pub``
     - (String) Path to hosts public key. Only used if driver_handles_share_servers=True.
   * - ``protocol_access_mapping`` = ``{'ip': ['nfs'], 'user': ['cifs']}``
     - (Dict) Protocol access mapping for this backend. Should be a dictionary comprised of {'access_type1': ['share_proto1', 'share_proto2'], 'access_type2': ['share_proto2', 'share_proto3']}.
   * - ``service_image_name`` = ``manila-service-image``
     - (String) Name of image in Glance, that will be used for service instance creation. Only used if driver_handles_share_servers=True.
   * - ``service_instance_flavor_id`` = ``100``
     - (String) ID of flavor, that will be used for service instance creation. Only used if driver_handles_share_servers=True.
   * - ``service_instance_name_or_id`` = ``None``
     - (String) Name or ID of service instance in Nova to use for share exports. Used only when share servers handling is disabled.
   * - ``service_instance_name_template`` = ``manila_service_instance_%s``
     - (String) Name of service instance. Only used if driver_handles_share_servers=True.
   * - ``service_instance_network_helper_type`` = ``neutron``
     - (String) DEPRECATED: Used to select between neutron and nova helpers when driver_handles_share_servers=True. Obsolete. This option isn't used any longer because nova networking is no longer supported.
   * - ``service_instance_password`` = ``None``
     - (String) Password for service instance user.
   * - ``service_instance_security_group`` = ``manila-service``
     - (String) Security group name, that will be used for service instance creation. Only used if driver_handles_share_servers=True.
   * - ``service_instance_smb_config_path`` = ``$share_mount_path/smb.conf``
     - (String) Path to SMB config in service instance.
   * - ``service_instance_user`` = ``None``
     - (String) User in service instance that will be used for authentication.
   * - ``service_net_name_or_ip`` = ``None``
     - (String) Can be either name of network that is used by service instance within Nova to get IP address or IP address itself for managing shares there. Used only when share servers handling is disabled.
   * - ``service_network_cidr`` = ``10.254.0.0/16``
     - (String) CIDR of manila service network. Used only with Neutron and if driver_handles_share_servers=True.
   * - ``service_network_division_mask`` = ``28``
     - (Integer) This mask is used for dividing service network into subnets, IP capacity of subnet with this mask directly defines possible amount of created service VMs per tenant's subnet. Used only with Neutron and if driver_handles_share_servers=True.
   * - ``service_network_name`` = ``manila_service_network``
     - (String) Name of manila service network. Used only with Neutron. Only used if driver_handles_share_servers=True.
   * - ``share_helpers`` = ``CIFS=manila.share.drivers.helpers.CIFSHelperIPAccess, NFS=manila.share.drivers.helpers.NFSHelper``
     - (List) Specify list of share export helpers.
   * - ``share_mount_path`` = ``/shares``
     - (String) Parent path in service instance where shares will be mounted.
   * - ``share_mount_template`` = ``mount -vt %(proto)s %(options)s %(export)s %(path)s``
     - (String) The template for mounting shares for this backend. Must specify the executable with all necessary parameters for the protocol supported. 'proto' template element may not be required if included in the command. 'export' and 'path' template elements are required. It is advisable to separate different commands per backend.
   * - ``share_unmount_template`` = ``umount -v %(path)s``
     - (String) The template for unmounting shares for this backend. Must specify the executable with all necessary parameters for the protocol supported. 'path' template element is required. It is advisable to separate different commands per backend.
   * - ``share_volume_fstype`` = ``ext4``
     - (String) Filesystem type of the share volume.
   * - ``tenant_net_name_or_ip`` = ``None``
     - (String) Can be either name of network that is used by service instance within Nova to get IP address or IP address itself for exporting shares. Used only when share servers handling is disabled.
   * - ``volume_name_template`` = ``manila-share-%s``
     - (String) Volume name template.
   * - ``volume_snapshot_name_template`` = ``manila-snapshot-%s``
     - (String) Volume snapshot name template.
   * - **[cinder]**
     -
   * - ``auth_section`` = ``None``
     - (Unknown) Config Section from which to load plugin specific options
   * - ``auth_type`` = ``None``
     - (Unknown) Authentication type to load
   * - ``cafile`` = ``None``
     - (String) PEM encoded Certificate Authority to use when verifying HTTPs connections.
   * - ``certfile`` = ``None``
     - (String) PEM encoded client certificate cert file
   * - ``cross_az_attach`` = ``True``
     - (Boolean) Allow attaching between instances and volumes in different availability zones.
   * - ``endpoint_type`` = ``publicURL``
     - (String) Endpoint type to be used with cinder client calls.
   * - ``http_retries`` = ``3``
     - (Integer) Number of cinderclient retries on failed HTTP calls.
   * - ``insecure`` = ``False``
     - (Boolean) Verify HTTPS connections.
   * - ``keyfile`` = ``None``
     - (String) PEM encoded client certificate key file
   * - ``region_name`` = ``None``
     - (String) Region name for connecting to cinder.
   * - ``timeout`` = ``None``
     - (Integer) Timeout value for http requests
   * - **[neutron]**
     -
   * - ``cafile`` = ``None``
     - (String) PEM encoded Certificate Authority to use when verifying HTTPs connections.
   * - ``certfile`` = ``None``
     - (String) PEM encoded client certificate cert file
   * - ``insecure`` = ``False``
     - (Boolean) Verify HTTPS connections.
   * - ``keyfile`` = ``None``
     - (String) PEM encoded client certificate key file
   * - ``timeout`` = ``None``
     - (Integer) Timeout value for http requests
   * - **[nova]**
     -
   * - ``api_microversion`` = ``2.10``
     - (String) Version of Nova API to be used.
   * - ``auth_section`` = ``None``
     - (Unknown) Config Section from which to load plugin specific options
   * - ``auth_type`` = ``None``
     - (Unknown) Authentication type to load
   * - ``cafile`` = ``None``
     - (String) PEM encoded Certificate Authority to use when verifying HTTPs connections.
   * - ``certfile`` = ``None``
     - (String) PEM encoded client certificate cert file
   * - ``endpoint_type`` = ``publicURL``
     - (String) Endpoint type to be used with nova client calls.
   * - ``insecure`` = ``False``
     - (Boolean) Verify HTTPS connections.
   * - ``keyfile`` = ``None``
     - (String) PEM encoded client certificate key file
   * - ``region_name`` = ``None``
     - (String) Region name for connecting to nova.
   * - ``timeout`` = ``None``
     - (Integer) Timeout value for http requests
