/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.h2.api.Aggregate;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.engine.Session;
import org.h2.engine.UserAggregate;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class JavaAggregate
extends Expression {
    private final UserAggregate userAggregate;
    private final Select select;
    private final Expression[] args;
    private int[] argTypes;
    private Expression filterCondition;
    private int dataType;
    private Connection userConnection;
    private int lastGroupRowId;

    public JavaAggregate(UserAggregate userAggregate, Expression[] expressionArray, Select select, Expression expression) {
        this.userAggregate = userAggregate;
        this.args = expressionArray;
        this.select = select;
        this.filterCondition = expression;
    }

    @Override
    public int getCost() {
        int n = 5;
        for (Expression expression : this.args) {
            n += expression.getCost();
        }
        if (this.filterCondition != null) {
            n += this.filterCondition.getCost();
        }
        return n;
    }

    @Override
    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getScale() {
        return DataType.getDataType((int)this.dataType).defaultScale;
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder();
        statementBuilder.append(Parser.quoteIdentifier(this.userAggregate.getName())).append('(');
        for (Expression expression : this.args) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        statementBuilder.append(')');
        if (this.filterCondition != null) {
            statementBuilder.append(" FILTER (WHERE ").append(this.filterCondition.getSQL()).append(')');
        }
        return statementBuilder.toString();
    }

    @Override
    public int getType() {
        return this.dataType;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: 
            case 2: {
                return false;
            }
            case 7: {
                expressionVisitor.addDependency(this.userAggregate);
                break;
            }
        }
        for (Expression expression : this.args) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return this.filterCondition == null || this.filterCondition.isEverything(expressionVisitor);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        for (Expression expression : this.args) {
            expression.mapColumns(columnResolver, n);
        }
        if (this.filterCondition != null) {
            this.filterCondition.mapColumns(columnResolver, n);
        }
    }

    @Override
    public Expression optimize(Session session) {
        this.userConnection = session.createConnection(false);
        int n = this.args.length;
        this.argTypes = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            Expression expression = this.args[i];
            this.args[i] = expression.optimize(session);
            this.argTypes[i] = n2 = expression.getType();
        }
        try {
            Aggregate aggregate = this.getInstance();
            this.dataType = aggregate.getInternalType(this.argTypes);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        if (this.filterCondition != null) {
            this.filterCondition = this.filterCondition.optimize(session);
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.args) {
            expression.setEvaluatable(tableFilter, bl);
        }
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(tableFilter, bl);
        }
    }

    private Aggregate getInstance() throws SQLException {
        Aggregate aggregate = this.userAggregate.getInstance();
        aggregate.init(this.userConnection);
        return aggregate;
    }

    @Override
    public Value getValue(Session session) {
        HashMap<Expression, Object> hashMap = this.select.getCurrentGroup();
        if (hashMap == null) {
            throw DbException.get(90054, this.getSQL());
        }
        try {
            Object object;
            Aggregate aggregate = (Aggregate)hashMap.get(this);
            if (aggregate == null) {
                aggregate = this.getInstance();
            }
            if ((object = aggregate.getResult()) == null) {
                return ValueNull.INSTANCE;
            }
            return DataType.convertToValue(session, object, this.dataType);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    @Override
    public void updateAggregate(Session session) {
        HashMap<Expression, Object> hashMap = this.select.getCurrentGroup();
        if (hashMap == null) {
            return;
        }
        int n = this.select.getCurrentGroupRowId();
        if (this.lastGroupRowId == n) {
            return;
        }
        this.lastGroupRowId = n;
        if (this.filterCondition != null && !this.filterCondition.getBooleanValue(session)) {
            return;
        }
        Aggregate aggregate = (Aggregate)hashMap.get(this);
        try {
            if (aggregate == null) {
                aggregate = this.getInstance();
                hashMap.put(this, aggregate);
            }
            Object[] objectArray = new Object[this.args.length];
            Object object = null;
            int n2 = this.args.length;
            for (int i = 0; i < n2; ++i) {
                Value value = this.args[i].getValue(session);
                value = value.convertTo(this.argTypes[i]);
                objectArray[i] = object = value.getObject();
            }
            if (this.args.length == 1) {
                aggregate.add(object);
            } else {
                aggregate.add(objectArray);
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }
}

