/* -*- Mode: C; coding: utf-8 -*- */
#include "gtk_common.h"
#include "completion_info.h"
struct completion_info completion_info_func[] = {
{"abs", "abs()", "abs", N_("<b>abs</b>(<i>x</i>)\ncompute the absolute value of <i>x</i>"), NULL},
{"acos", "acos()", "acos", N_("<b>acos</b>(<i>x</i>)\narc cosine function"), NULL},
{"acosh", "acosh()", "acosh", N_("<b>acosh</b>(<i>x</i>)\ninverse hyperbolic cosine function"), NULL},
{"alpha", "alpha()", "alpha", N_("<b>alpha</b>(<i>x, i</i>)\nSet A (<i>i</i> == 1) or A2 (<i>i</i> == 2) values to <i>x</i> (0 &lt;= <i>x</i> &lt; 256)\nwhen <i>i</i> == 0, set A and A2 values to <i>x</i>"), NULL},
{"am", "am()", "am", N_("<b>am</b>(<i>a</i>)\ncopy the contents of the array <i>a</i> to the memory\n(return the number of copied elements)"), NULL},
{"and", "and()", "and", N_("<b>and</b>(<i>x, y</i>)\nTrue (= 1) when (<i>x</i> != 0) and (<i>y</i> != 0)"), NULL},
{"array", "array()", "array", N_("<b>array</b>(<i>a, v1, v2, ...</i>)\ninitialize an array <i>a</i> with the rest arguments\nreturn the number of elements of the array"), NULL},
{"array_average", "array_average()", "array_average", N_("<b>array_average</b>(<i>a</i>)\nreturn the average of the elements of array <i>a</i>"), NULL},
{"array_clear", "array_clear()", "array_clear", N_("<b>array_clear</b>(<i>a</i>)\nset the number of elements of the array <i>a</i> to 0"), NULL},
{"array_compact", "array_compact()", "array_compact", N_("<b>array_compact</b>(<i>a</i>)\nRemove non-numeric values from the elements of the array of array <i>a</i>\nand return the number of elements after removal"), NULL},
{"array_copy", "array_copy()", "array_copy", N_("<b>array_copy</b>(<i>dest, src</i>)\ncopy the contents of the array <i>src</i> to the array <i>dest</i>.\n(return the number of copied elements)"), NULL},
{"array_max", "array_max()", "array_max", N_("<b>array_max</b>(<i>a</i>)\nreturns the maximum value contained in array <i>a</i>"), NULL},
{"array_min", "array_min()", "array_min", N_("<b>array_min</b>(<i>a</i>)\nreturns the minimum value contained in array <i>a</i>"), NULL},
{"array_moving_average", "array_moving_average()", "array_moving_average", N_("<b>array_moving_average</b>(<i>dest, src, n, type</i>)\ncalculate moving average of (<i>n</i> * 2 + 1) sample of the array <i>src</i>\nand set them to the array <i>dest</i>.\nWeighted moving average is used when <i>type</i> is 1."), NULL},
{"array_stdev", "array_stdev()", "array_stdev", N_("<b>array_stdev</b>(<i>a</i>)\nreturn the corrected sample standard deviation of the elements of array <i>a</i>"), NULL},
{"array_stdevp", "array_stdevp()", "array_stdevp", N_("<b>array_stdevp</b>(<i>a</i>)\nreturn the standard deviation of the elements of array <i>a</i>"), NULL},
{"array_sum", "array_sum()", "array_sum", N_("<b>array_sum</b>(<i>a</i>)\nreturns the sum of the elements of array <i>a</i>"), NULL},
{"array_sumsq", "array_sumsq()", "array_sumsq", N_("<b>array_sumsq</b>(<i>a</i>)\nreturns the square sum of the elements of array <i>a</i>"), NULL},
{"asin", "asin()", "asin", N_("<b>asin</b>(<i>x</i>)\narc sine function"), NULL},
{"asinh", "asinh()", "asinh", N_("<b>asinh</b>(<i>x</i>)\ninverse hyperbolic sine function"), NULL},
{"atan", "atan()", "atan", N_("<b>atan</b>(<i>x</i>)\narc tangent function"), NULL},
{"atanh", "atanh()", "atanh", N_("<b>atanh</b>(<i>x</i>)\ninverse hyperbolic tangent function"), NULL},
{"beta", "beta()", "beta", N_("<b>beta</b>(<i>x, y</i>)\nbeta function"), NULL},
{"choose", "choose()", "choose", N_("<b>choose</b>(<i>n, m</i>)\nthe combinatorial factor <i>n</i> choose <i>m</i>: <i>n!/(m!(n-m)!)</i>"), NULL},
{"cm", "cm()", "cm", N_("<b>cm</b>(<i>x, n</i>)\ninitialize <i>n</i> memories from the beginning with <i>x</i>\ninitialize whole memory when <i>n</i> is 0\nand <i>n</i> memories from the end when <i>x</i> is negative\n(return <i>x</i>)"), NULL},
{"color", "color()", "color", N_("<b>color</b>(<i>i, x</i>)\n<i>i</i> = 0: Set the R value to <i>x</i> (0 &lt;= <i>x</i> &lt; 256)\n<i>i</i> = 1: Set the G value to <i>x</i> (0 &lt;= <i>x</i> &lt; 256)\n<i>i</i> = 2: Set the B value to <i>x</i> (0 &lt;= <i>x</i> &lt; 256)\n<i>i</i> = 3: Set the R, G and B values to <i>x</i> (0 &lt;= <i>x</i> &lt; 256)\n<i>i</i> = 4: Set the R2 value to <i>x</i> (0 &lt;= <i>x</i> &lt; 256)\n<i>i</i> = 5: Set the G2 value to <i>x</i> (0 &lt;= <i>x</i> &lt; 256)\n<i>i</i> = 6: Set the B2 value to <i>x</i> (0 &lt;= <i>x</i> &lt; 256)\n<i>i</i> = 7: Set the R2, G2 and B2 values to <i>x</i> (0 &lt;= <i>x</i> &lt; 256)\n<i>i</i> = 8: Set the R, G and B values to be hexadecimal color of <i>x</i>\n<i>i</i> = 9: Set the R2, G2 and B2 values to be hexadecimal color of <i>x</i>"), NULL},
{"cos", "cos()", "cos", N_("<b>cos</b>(<i>x</i>)\ncosine function"), NULL},
{"cosh", "cosh()", "cosh", N_("<b>cosh</b>(<i>x</i>)\nhyperbolic cosine function"), NULL},
{"delta", "delta()", "delta", N_("<b>delta</b>(<i>x</i>)\nKronecker delta (1 when <i>x</i> = 0, 0 otherwise)"), NULL},
{"dif", "dif()", "dif", N_("<b>dif</b>(<i>x</i>)\nDifference"), NULL},
{"draw_arc", "draw_arc()", "draw_arc", N_("<b>draw_arc</b>(<i>x, y, rx, ry, start, arc, pieslice, stroke, fill, close</i>)\ndraw an arc with the X direction radius <i>rx</i> and the Y direction radius <i>ry</i> centered on (<i>x, y</i>).\n<i>start</i> and <i>arc</i> specify start angle and arc angle respectively.\nWhen <i>stroke</i> and <i>fill</i> are 0, do not draw contours and fills respectively.\nIf <i>pieslice</i> is not 0, draw a sector.\nIf <i>close</i> is not 0, close the outline."), NULL},
{"draw_errorbar", "draw_errorbar()", "draw_errorbar", N_("<b>draw_errorbar</b>(<i>x, y, erx, ery, size</i>)\ndraw errorbars from (<i>x - erx, y</i>) to (<i>x + erx, y</i>) and\nfrom (<i>x, y - ery</i>) to (<i>x, y + ery</i>).\nThe length of ticks can be specified with <i>size</i>.\nWhen <i>size</i> is 0, specification of the file object is used."), NULL},
{"draw_errorbar2", "draw_errorbar2()", "draw_errorbar2", N_("<b>draw_errorbar2</b>(<i>x1, y1, x2, y2, size</i>)\ndraw an errorbar from (<i>x1, y1</i>) to (<i>x2, y2</i>).\nThe length of ticks can be specified with <i>size</i>.\nWhen <i>size</i> is 0, specification of the file object is used."), NULL},
{"draw_line", "draw_line()", "draw_line", N_("<b>draw_line</b>(<i>x1, y1, x2, y2, arrow, size</i>)\ndraw a line form (<i>x1, y1</i>) to (<i>x2, y2</i>).\nWhen <i>arrow</i> is 1, 2 or 3, draw arrow end, begin and both side of the line respectively.\nThe size of a arrow can be specified with <i>size</i>.\nWhen <i>size</i> is 0, specification of the file object is used."), NULL},
{"draw_mark", "draw_mark()", "draw_mark", N_("<b>draw_mark</b>(<i>x, y, size</i>)\ndraw a mark on (<i>x, y</i>). \nThe size of a mark can be specified with <i>size</i>.\nWhen <i>size</i> is 0, specification of the file object is used."), NULL},
{"draw_polygon", "draw_polygon()", "draw_polygon", N_("<b>draw_polygon</b>(<i>ax, ay, stroke, fill</i>)\ndraw polygon defined by coordinates (<i>ax</i>[0], <i>ay</i>[0]), (<i>ax</i>[1], <i>ay</i>[1]), ....\nwhen <i>stroke</i> is 0, do not draw contours.\n<i>fill</i> can be specified with one of\n<b>FILL_RULE_NONE</b>, <b>FILL_RULE_EVEN_ODD</b> or <b>FILL_RULE_WINDING</b>."), NULL},
{"draw_polyline", "draw_polyline()", "draw_polyline", N_("<b>draw_polyline</b>(<i>ax, ay</i>)\nconnect coordinates (<i>ax</i>[0], <i>ay</i>[0]), (<i>ax</i>[1], <i>ay</i>[1]), ... by polyline."), NULL},
{"draw_rect", "draw_rect()", "draw_rect", N_("<b>draw_rect</b>(<i>x, y, w, h, stroke, fill</i>)\ndraw a rectangle with (<i>x, y</i>) and (<i>x + w, y + h</i>) as diagonal vertices.\nWhen <i>stroke</i> and <i>fill</i> are 0, do not draw contours and fills respectively."), NULL},
{"draw_text", "draw_text()", "draw_text", N_("<b>draw_text</b>(<i>$str, x, y, dir</i>)\nDraw the string <i>$str</i> at (<i>x, y</i>).\nDirection is specified by <i>dir</i>."), NULL},
{"draw_text_raw", "draw_text_raw()", "draw_text_raw", N_("<b>draw_text_raw</b>(<i>$str, x, y, dir</i>)\nDraw the raw string <i>$str</i> at (<i>x, y</i>).\nDirection is specified by <i>dir</i>."), NULL},
{"each", "each()", "each", N_("<b>each</b>(<i>a, item, ex</i>)\nEvaluate <i>ex</i> for each element of the array <i>a</i>.\nThe element of the array can be referred by the variable <i>item</i>."), NULL},
{"each_with_index", "each_with_index()", "each_with_index", N_("<b>each_with_index</b>(<i>a, item, index, ex</i>)\nEvaluate <i>ex</i> for each element of the array <i>a</i>.\nThe element of the array and the loop count can be referred\nby the variable <i>item</i> and <i>index</i> respectively."), NULL},
{"ei", "ei()", "ei", N_("<b>ei</b>(<i>x</i>)\ncompute the exponential integral Ei(<i>x</i>)"), NULL},
{"eq", "eq()", "eq", N_("<b>eq</b>(<i>x, y, prec</i>)\nTrue (= 1) when <i>x</i> == <i>y</i>.\nThe number of digits of comparison can be specified with <i>prec</i>\n(<i>prec</i> == 0 is exact match)."), NULL},
{"erf", "erf()", "erf", N_("<b>erf</b>(<i>x</i>)\nerror function erf(<i>x</i>)"), NULL},
{"erfc", "erfc()", "erfc", N_("<b>erfc</b>(<i>x</i>)\ncomplementary error function erfc(<i>x</i>)"), NULL},
{"exp", "exp()", "exp", N_("<b>exp</b>(<i>x</i>)\nbase-e exponential function (<i>x</i> &lt;= 690)"), NULL},
{"expm1", "expm1()", "expm1", N_("<b>expm1</b>(<i>x</i>)\nexp(<i>x</i>)-1.\nThe result is computed in a way that is accurate\neven if the value of <i>x</i> is near zero."), NULL},
{"filter", "filter()", "filter", N_("<b>filter</b>(<i>dest, src, item, ex</i>)\nFind elements in the array <i>src</i>\nthat satisfies that the evaluated value of <i>ex</i> is true\nand set them to the array <i>dest</i>.\nAn element of the array <i>src</i> can be referred by the variable <i>item</i>."), NULL},
{"find", "find()", "find", N_("<b>find</b>(<i>a, item, ex</i>)\nReturns the value of the first element in the array <i>a</i>\nthat satisfies that the evaluated value of <i>ex</i> is true.\nAn element of the array can be referred by the variable <i>item</i>."), NULL},
{"fit_calc", "fit_calc()", "fit_calc", N_("<b>fit_calc</b>(<i>id, x</i>)\nWhen the plot type of the data object whose ID is <i>id</i> is fit,\nthe corresponding fit result f(<i>x</i>) is calculated."), NULL},
{"fit_prm", "fit_prm()", "fit_prm", N_("<b>fit_prm</b>(<i>id, x</i>)\nWhen the plot type of the data object whose ID is <i>id</i> is fit,\nthe value of the field \"%0<i>x</i>\" of the corresponding fit object."), NULL},
{"fmod", "fmod()", "fmod", N_("<b>fmod</b>(<i>x, y</i>)\ncompute the floating-point remainder of dividing <i>x</i> by <i>y</i>"), NULL},
{"for", "for()", "for", N_("<b>for</b>(<i>m, begin, end, step, ex</i>)\nSet the value in <i>step</i> from <i>begin</i> to <i>end</i> to the <i>m</i>-th memory and repeat <i>ex</i>.\nWhen <i>m</i> is negative, no setting to memory is done.\nReturns the value of <i>ex</i> evaluated last."), NULL},
{"frac", "frac()", "frac", N_("<b>frac</b>(<i>x</i>)\nremainder"), NULL},
{"gamma", "gamma()", "gamma", N_("<b>gamma</b>(<i>x</i>)\ngamma function"), NULL},
{"gauss", "gauss()", "gauss", N_("<b>gauss</b>(<i>x</i>)\nlargest integral value not greater than <i>x</i>"), NULL},
{"ge", "ge()", "ge", N_("<b>ge</b>(<i>x, y, prec</i>)\nTrue (= 1) when <i>x</i> &gt;= <i>y</i>.\nThe precision allows you to specify the number of digits for comparison\n(<i>prec</i> == 0 does not specify the number of digits)."), NULL},
{"getobj", "getobj()", "getobj", N_("<b>getobj</b>(<i>$obj, $field, id</i>)\nReturn the value of the <i>$field</i> of the <i>$obj</i> object which ID is <i>id</i>.\nThe field type must be int, bool, enum or double."), NULL},
{"getobj_array", "getobj_array()", "getobj_array", N_("<b>getobj_array</b>(<i>array, $obj, $field, id</i>)\nSet values of the <i>$field</i> of the <i>$obj</i> object which ID is <i>id</i> to the array <i>array</i>.\nThe field type must be char*[], double[] or int[].\nRetuern the number of elements saved to the array."), NULL},
{"getobj_string", "getobj_string()", "getobj_string", N_("<b>getobj_string</b>(<i>$str, $obj, $field, id</i>)\nSet the value of the <i>$field</i> of the <i>$obj</i> object which ID is <i>id</i> to the variable <i>$str</i>.\nThe field type must be char*.\nReturn the length of the string <i>$str</i> in characters."), NULL},
{"gt", "gt()", "gt", N_("<b>gt</b>(<i>x, y, prec</i>)\nTrue (= 1) when <i>x</i> &gt; <i>y</i>.\nThe precision allows you to specify the number of digits for comparison\n(<i>prec</i> == 0 does not specify the number of digits)."), NULL},
{"hn", "hn()", "hn", N_("<b>hn</b>(<i>n, x</i>)\nHermite polynomials"), NULL},
{"hsb", "hsb()", "hsb", N_("<b>hsb</b>(<i>h, s, b</i>)\nSet the R, G and B values of the color to <i>h, s, b</i> (0 &lt;= <i>h, s, b</i> &lt;=1) from the HSB value"), NULL},
{"hsb2", "hsb2()", "hsb2", N_("<b>hsb2</b>(<i>h, s, b</i>)\nSet the R2, G2 and B2 values of the color to <i>h, s, b</i> (0 &lt;= <i>h, s, b</i> &lt;=1) from the HSB value"), NULL},
{"icbeta", "icbeta()", "icbeta", N_("<b>icbeta</b>(<i>a, b, x</i>)\nincomplete beta function"), NULL},
{"icgam", "icgam()", "icgam", N_("<b>icgam</b>(<i>m, x</i>)\nincomplete gamma function"), NULL},
{"if", "if()", "if", N_("<b>if</b>(<i>x, ex1, ex2</i>)\nevaluate <i>ex1</i> when <i>x</i> != 0, evaluate <i>ex2</i> otherwise"), NULL},
{"in", "in()", "in", N_("<b>in</b>(<i>n, x</i>)\ncompute the regular modified cylindrical Bessel function of order |<i>n</i>|, I<sub><i>n</i></sub>(|<i>x</i>|)"), NULL},
{"index", "index()", "index", N_("<b>index</b>(<i>a, item, ex</i>)\nReturns the first index at which a given element in the array <i>a</i>\nthat satisfies that the evaluated value of <i>ex</i> is true.\nAn element of the array can be referred by the variable <i>item</i>."), NULL},
{"int", "int()", "int", N_("<b>int</b>(<i>x</i>)\nround to integer, toward zero"), NULL},
{"inu", "inu()", "inu", N_("<b>inu</b>(<i>nu, x</i>)\ncompute the regular modified Bessel function of fractional order |<i>nu</i>|, I<sub><i>nu</i></sub>(|<i>x</i>|)"), NULL},
{"isbreak", "isbreak()", "isbreak", N_("<b>isbreak</b>(<i>x</i>)\nTrue if <i>x</i> is <b>BREAK</b>"), NULL},
{"iscont", "iscont()", "iscont", N_("<b>iscont</b>(<i>x</i>)\nTrue if <i>x</i> is <b>CONT</b>"), NULL},
{"isnan", "isnan()", "isnan", N_("<b>isnan</b>(<i>x</i>)\nTrue if <i>x</i> is <b>NAN</b>"), NULL},
{"isnormal", "isnormal()", "isnormal", N_("<b>isnormal</b>(<i>x</i>)\nTrue if <i>x</i> is a normal number"), NULL},
{"isundef", "isundef()", "isundef", N_("<b>isundef</b>(<i>x</i>)\nTrue if <i>x</i> is <b>UNDEF</b>"), NULL},
{"jl", "jl()", "jl", N_("<b>jl</b>(<i>l, x</i>)\ncompute the regular spherical Bessel function of order |<i>l</i>|, j<sub><i>l</i></sub>(|<i>x</i>|)"), NULL},
{"jn", "jn()", "jn", N_("<b>jn</b>(<i>n, x</i>)\ncompute the regular cylindrical Bessel function of order <i>n</i>, J<sub><i>n</i></sub>(|<i>x</i>|)"), NULL},
{"jnu", "jnu()", "jnu", N_("<b>jnu</b>(<i>nu, x</i>)\ncompute the regular cylindrical Bessel function of fractional order |<i>nu</i>|, J<sub><i>nu</i></sub>(|<i>x</i>|)"), NULL},
{"kn", "kn()", "kn", N_("<b>kn</b>(<i>n, x</i>)\ncompute the irregular modified cylindrical Bessel function of order |<i>n</i>|, K<sub><i>n</i></sub>(|<i>x</i>|)"), NULL},
{"knu", "knu()", "knu", N_("<b>knu</b>(<i>nu, x</i>)\ncompute the irregular modified Bessel function of fractional order |<i>nu</i>|, K<sub><i>nu</i></sub>(|<i>x</i>|)"), NULL},
{"le", "le()", "le", N_("<b>le</b>(<i>x, y, prec</i>)\nTrue (= 1) when <i>x</i> &lt;= <i>y</i>.\nThe precision allows you to specify the number of digits for comparison\n(<i>prec</i> == 0 does not specify the number of digits)."), NULL},
{"lgn", "lgn()", "lgn", N_("<b>lgn</b>(<i>n, a, x</i>)\nevaluate the generalized Laguerre polynomials L<sup><i>a</i></sup><sub><i>n</i></sub>(<i>x</i>) for <i>a</i> &gt; -1, <i>n</i> &gt;= 0"), NULL},
{"line_number", "line_number()", "line_number", N_("<b>line_number</b>(<i></i>)\nFile line number being processed (1st line is 1)"), NULL},
{"ln", "ln()", "ln", N_("<b>ln</b>(<i>x</i>)\nnatural logarithmic function"), NULL},
{"ln1p", "ln1p()", "ln1p", N_("<b>ln1p</b>(<i>x</i>)\nln(1+<i>x</i>).\nThe result is computed in a way that is accurate\neven if the value of <i>x</i> is near zero."), NULL},
{"log", "log()", "log", N_("<b>log</b>(<i>x</i>)\nbase-10 logarithmic function"), NULL},
{"log1p", "log1p()", "log1p", N_("<b>log1p</b>(<i>x</i>)\nlog(1+<i>x</i>).\nThe result is computed in a way that is accurate\neven if the value of <i>x</i> is near zero."), NULL},
{"lt", "lt()", "lt", N_("<b>lt</b>(<i>x, y, prec</i>)\nTrue (= 1) when <i>x</i> &lt; <i>y</i>.\nThe precision allows you to specify the number of digits for comparison\n(<i>prec</i> == 0 does not specify the number of digits)."), NULL},
{"m", "m()", "m", N_("<b>m</b>(<i>i, x</i>)\nassigns <i>x</i> to the <i>i</i>-th memory (<i>i</i> = 0 to 65535)\nthe index from the tail when <i>i</i> is negative\n(return <i>x</i>)"), NULL},
{"map", "map()", "map", N_("<b>map</b>(<i>dest, src, item, ex</i>)\nEvaluate <i>ex</i> for each element of the array <i>src</i>\nand set them to the array <i>dest</i>.\nThe element of the array can be referred by the variable <i>item</i>."), NULL},
{"marksize", "marksize()", "marksize", N_("<b>marksize</b>(<i>x</i>)\nSet mark size to <i>x</i>"), NULL},
{"marktype", "marktype()", "marktype", N_("<b>marktype</b>(<i>x</i>)\nSet mark type to <i>x</i>"), NULL},
{"max", "max()", "max", N_("<b>max</b>(<i>a, b, c, ...</i>)\nThe largest value of arguments"), NULL},
{"min", "min()", "min", N_("<b>min</b>(<i>a, b, c, ...</i>)\nThe smallest value of arguments"), NULL},
{"mjd", "mjd()", "mjd", N_("<b>mjd</b>(<i>year, month, day, hour, min, sec</i>)\nModified Julian Date (date and time are given in UTC)"), NULL},
{"mjd2day", "mjd2day()", "mjd2day", N_("<b>mjd2day</b>(<i>mjd</i>)\nGregorian calendar day corresponding to Modified Julian Day <i>mjd</i>"), NULL},
{"mjd2month", "mjd2month()", "mjd2month", N_("<b>mjd2month</b>(<i>mjd</i>)\nmonth of Gregorian calendar corresponding to Modified Julian Day <i>mjd</i>"), NULL},
{"mjd2unix", "mjd2unix()", "mjd2unix", N_("<b>mjd2unix</b>(<i>mjd</i>)\ntime represents the number of seconds elapsed since the Epoch at <i>mjd</i>"), NULL},
{"mjd2wday", "mjd2wday()", "mjd2wday", N_("<b>mjd2wday</b>(<i>mjd</i>)\nThe day of the week as a decimal range 1 to 7, Monday being 1 corresponding to <i>mjd</i>"), NULL},
{"mjd2yday", "mjd2yday()", "mjd2yday", N_("<b>mjd2yday</b>(<i>mjd</i>)\nThe day of the year as a decimal number (range 001 to 366) corresponding to <i>mjd</i>"), NULL},
{"mjd2year", "mjd2year()", "mjd2year", N_("<b>mjd2year</b>(<i>mjd</i>)\nyear of Gregorian calendar corresponding to Modified Julian Day <i>mjd</i>"), NULL},
{"mtime", "mtime()", "mtime", N_("<b>mtime</b>(<i></i>)\nreturns last modification time of the file."), NULL},
{"neq", "neq()", "neq", N_("<b>neq</b>(<i>x, y, prec</i>)\nTrue (= 1) when <i>x</i> != <i>y</i>.\nThe number of digits of comparison can be specified with <i>prec</i>\n(<i>prec</i> == 0 is exact match)."), NULL},
{"not", "not()", "not", N_("<b>not</b>(<i>x</i>)\nTrue (= 1) when <i>x</i> == 0"), NULL},
{"obj_alpha", "obj_alpha()", "obj_alpha", N_("<b>obj_alpha</b>(<i>id, obj</i>)\nSet the A and A2 value to the same value as the instance of <i>obj</i> whose ID is <i>id</i>.\n<i>obj</i> is one of <b>DATA_OBJ</b>, <b>PATH_OBJ</b>, <b>ARC_OBJ</b>, <b>MARK_OBJ</b> or <b>TEXT_OBJ</b>."), NULL},
{"obj_color", "obj_color()", "obj_color", N_("<b>obj_color</b>(<i>id, obj</i>)\nSet the R, G, B, R2, G2 and B2 values to the same value as the instance of <i>obj</i> whose ID is <i>id</i>.\n<i>obj</i> is one of <b>DATA_OBJ</b>, <b>PATH_OBJ</b>, <b>ARC_OBJ</b>, <b>MARK_OBJ</b> or <b>TEXT_OBJ</b>."), NULL},
{"on_end", "on_end()", "on_end", N_("<b>on_end</b>(<i>proc</i>)\nEvaluate <i>proc</i> at the end of plottong the data object."), NULL},
{"or", "or()", "or", N_("<b>or</b>(<i>x, y</i>)\nTrue (= 1) when (<i>x</i> != 0) or (<i>y</i> != 0)"), NULL},
{"parameter", "parameter()", "parameter", N_("<b>parameter</b>(<i>id</i>)\nReturns the value of the prameter object which ID is <i>id</i>."), NULL},
{"pn", "pn()", "pn", N_("<b>pn</b>(<i>l, x</i>)\nevaluate the Legendre polynomial P<sub>l</sub>(<i>x</i>) for a specific value of <i>l, x</i> subject to <i>l</i> &gt;= 0, |<i>x</i>| &lt;= 1"), NULL},
{"pop", "pop()", "pop", N_("<b>pop</b>(<i>a ,n</i>)\nremove the last <i>n</n> elements of array <i>a</i> (<i>n</i> = 0 is as same as <i>n</i> = 1).\nReturns the new size of the array."), NULL},
{"printf", "printf()", "printf", N_("<b>printf</b>(<i>$format, v1, v2, ...</i>)\nConverts <i>v1, v2, ...</i> to a string according to <i>$format</i>\nand show in the information window.\nReturn the length of the string <i>$str</i> in characters."), NULL},
{"prog1", "prog1()", "prog1", N_("<b>prog1</b>(<i>arg1, arg2, ...</i>)\nEvaluate the arguments and return the evaluated value of the first argument"), NULL},
{"prog2", "prog2()", "prog2", N_("<b>prog2</b>(<i>arg1, arg2, ...</i>)\nEvaluate the arguments and return the evaluated value of the second argument"), NULL},
{"progn", "progn()", "progn", N_("<b>progn</b>(<i>arg1, arg2, ...</i>)\nEvaluate the arguments and return the evaluated value of the last argument"), NULL},
{"push", "push()", "push", N_("<b>push</b>(<i>a, x</i>)\nadds new element <i>x</i> to the end of an array <i>a</i>.\nReturns the new size of the array."), NULL},
{"puts", "puts()", "puts", N_("<b>puts</b>(<i>$str</i>)\nShow <i>$str</i> in the information window.\nReturn the length of the string <i>$str</i> in characters."), NULL},
{"qinv", "qinv()", "qinv", N_("<b>qinv</b>(<i>x</i>)\ninverse complementary error function"), NULL},
{"rand", "rand()", "rand", N_("<b>rand</b>(<i>x</i>)\nreturns a random value equally distributed over the range [0..<i>x</i>)"), NULL},
{"reduce", "reduce()", "reduce", N_("<b>reduce</b>(<i>a, item, result, ex</i>)\nEvaluate <i>ex</i> for each element of the array <i>a</i>\nand return last evaluated value of <i>ex</i>.\nThe element of the array and the result of previous evaluation\ncan be referred by the variable <i>item</i> and <i>result</i>."), NULL},
{"rgb", "rgb()", "rgb", N_("<b>rgb</b>(<i>r, g, b</i>)\nSet the R, G and B values of the color to <i>r, g, b</i> (0 &lt;= <i>r, g, b</i> &lt;= 1)"), NULL},
{"rgb2", "rgb2()", "rgb2", N_("<b>rgb2</b>(<i>r, g, b</i>)\nSet the R2, G2 and B2 values of the color to <i>r, g, b</i> (0 &lt;= <i>r, g, b</i> &lt;= 1)"), NULL},
{"rm", "rm()", "rm", N_("<b>rm</b>(<i>i</i>)\nthe value of the current <i>i</i>-th memory (<i>i</i> = 0 to 65535),\nthe index from the tail when <i>i</i> is negative"), NULL},
{"round", "round()", "round", N_("<b>round</b>(<i>x, digit</i>)\nround the number <i>x</i>, away from zero.\n<i>digit</i> is the number of digits to which you want to round <i>x</i>."), NULL},
{"rsort", "rsort()", "rsort", N_("<b>rsort</b>(<i>a, ignore_case</i>)\nreverse sort elements of array <i>a</i>\nfold lower case to upper case characters when <i>ignore_case</i> is not zero."), NULL},
{"shift", "shift()", "shift", N_("<b>shift</b>(<i>a, n</i>)\nremove the first <i>n</i> elements of array <i>a</i> (<i>n</i> = 0 is as same as <i>n</i> = 1).\nReturns the new size of the array."), NULL},
{"sign", "sign()", "sign", N_("<b>sign</b>(<i>x</i>)\npositive / negative sign (-1 with <i>x</i> &lt; 0, 1 with <i>x</i> &gt;= 0)"), NULL},
{"sin", "sin()", "sin", N_("<b>sin</b>(<i>x</i>)\nsine function"), NULL},
{"sinh", "sinh()", "sinh", N_("<b>sinh</b>(<i>x</i>)\nhyperbolic sine function"), NULL},
{"size", "size()", "size", N_("<b>size</b>(<i>a</i>)\nnumber of elements of array <i>a</i>"), NULL},
{"sort", "sort()", "sort", N_("<b>sort</b>(<i>a, ignore_case</i>)\nsort elements of array <i>a</i>\nfold lower case to upper case characters when <i>ignore_case</i> is not zero."), NULL},
{"sprintf", "sprintf()", "sprintf", N_("<b>sprintf</b>(<i>$str, $format, v1, v2, ...</i>)\nConverts <i>v1, v2, ...</i> to a string according to <i>$format</i>\nand set to <i>$str</i>.\nReturn the length of the string <i>$str</i> in characters."), NULL},
{"sqr", "sqr()", "sqr", N_("<b>sqr</b>(<i>x</i>)\nsquaring"), NULL},
{"sqrt", "sqrt()", "sqrt", N_("<b>sqrt</b>(<i>x</i>)\nsquare root"), NULL},
{"srand", "srand()", "srand", N_("<b>srand</b>(<i>x</i>)\nSets the seed for the random number generator which is used by the <b>rand</b>() function"), NULL},
{"strftime", "strftime()", "strftime", N_("<b>strftime</b>(<i>$str, $fmt, t, utc</i>)\nconvers <i>t</i> (the number of seconds elapsed since the Epoch)\naccording to the format specification <i>$fmt</i>\nand places the result in the string <i>$str</i>.\nWhen <i>utc</i> is true, <i>$str</i> is expressed in Coordinated Universal Time (UTC)."), NULL},
{"string", "string()", "string", N_("<b>string</b>(<i>$str, value</i>)\nConverts <i>value</i> to a string and set to <i>$str</i>.\nReturn the value."), NULL},
{"string_append", "string_append()", "string_append", N_("<b>string_append</b>(<i>$dest, $src</i>)\nAdds the string <i>$src</i> onto the end of the string <i>$dest</i>."), NULL},
{"string_column", "string_column()", "string_column", N_("<b>string_column</b>(<i>$dest, index</i>)\nSet <i>index</i>th column in the reading data-line to the string <i>$dest</i>."), NULL},
{"string_compare", "string_compare()", "string_compare", N_("<b>string_compare</b>(<i>$str1, $str2, ignore_case</i>)\nCompare two strings, ignoring the case of ASCII characters when <i>ignore_case</i> is not zero."), NULL},
{"string_down", "string_down()", "string_down", N_("<b>string_down</b>(<i>$dest, $src</i>)\nConverts all uppercase ASCII letters to lowercase ASCII letters in the string <i>$src</i> and set to the string <i>$dest</i>."), NULL},
{"string_erase", "string_erase()", "string_erase", N_("<b>string_erase</b>(<i>$str, pos, len</i>)\nRemoves <i>len</i> characters from the string <i>$str</i>, starting at position <i>pos</i>."), NULL},
{"string_float", "string_float()", "string_float", N_("<b>string_float</b>(<i>$str</i>)\nConverts the string <i>$str</i> to a floating-point value and return the value."), NULL},
{"string_float_array", "string_float_array()", "string_float_array", N_("<b>string_float_array</b>(<i>dest, $ary</i>)\nConverts the string element of the array <i>$ary</i>\nto a floating-point value\nand set them to the array <i>dest</i>."), NULL},
{"string_insert", "string_insert()", "string_insert", N_("<b>string_insert</b>(<i>$dest, $src, pos</i>)\nInserts the string <i>$src</i> into the string <i>$dest</i> at the position <i>pos</i>."), NULL},
{"string_join", "string_join()", "string_join", N_("<b>string_join</b>(<i>$dest, $sep, $array</i>)\nJoins a number of strings in the array <i>$array</i>\ntogether to form one long string <i>$dest</i>,\nwith the optional separator <i>$sep</i>inserted between each of them."), NULL},
{"string_length", "string_length()", "string_length", N_("<b>string_length</b>(<i>$str</i>)\nReturn the length of the string <i>$str</i> in characters."), NULL},
{"string_match", "string_match()", "string_match", N_("<b>string_match</b>(<i>$str, $regexp, ignore_case</i>)\nScans for a match in the string <i>$str</i> for the regular expression pattern <i>$regexp</i>.\nReturn non-zero value if the string matched, zero otherwise."), NULL},
{"string_prepend", "string_prepend()", "string_prepend", N_("<b>string_prepend</b>(<i>$dest, $src</i>)\nAdds the string <i>$src</i> onto the start of the string <i>$dest</i>."), NULL},
{"string_replace", "string_replace()", "string_replace", N_("<b>string_replace</b>(<i>$dest, $src, $regexp, $replacement, ignore_case</i>)\nReplaces all occurrences of the regular expression pattern in <i>$regex</i> with the <i>$replacement</i> text.\nBackreferences of the form '\\number' or '\\g&lt;number&gt;' in the replacement text are interpolated\nby the number-th captured subexpression of the match,\n'\\g&lt;name&gt;' refers to the captured subexpression with the given name.\n'\\0' refers to the complete match,\nbut '\\0' followed by a number is the octal representation of a character.\nLetters in <i>$regex</i> match both upper- and lowercase letters\nwhen <i>ignore_case</i> is not zero."), NULL},
{"string_reverse", "string_reverse()", "string_reverse", N_("<b>string_reverse</b>(<i>$dest, $src</i>)\nReverses the UTF-8 string <i>$src</i> and set to the string <i>$dest</i>."), NULL},
{"string_split", "string_split()", "string_split", N_("<b>string_split</b>(<i>$dest, $src, $separator, use_regexp</i>)\nSplits the string <i>$src</i> into pieces, using the given <i>$separator</i>.\nEach strings are saved in the array <i>$dest</i>\n<i>$separator</i> is treated as a regular expression\nwhen <i>use_regexp</i> is not 0.\nLetters in <i>$separator</i> match both upper- and lowercase letters\nwhen <i>use_regexp</i> is 2."), NULL},
{"string_split_float", "string_split_float()", "string_split_float", N_("<b>string_split_float</b>(<i>dest, $src, $separator, use_regexp</i>)\nSplits the string <i>$src</i> into pieces, using the given <i>$separator</i>.\nEach strings are converted to float value and saved in the array <i>dest</i>\n<i>$separator</i> is treated as a regular expression\nwhen <i>use_regexp</i> is not 0.\nLetters in <i>$separator</i> match both upper- and lowercase letters\nwhen <i>use_regexp</i> is 2."), NULL},
{"string_strip", "string_strip()", "string_strip", N_("<b>string_strip</b>(<i>$str</i>)\nRemoves leading and trailing whitespace from the string <i>$str</i>."), NULL},
{"string_substring", "string_substring()", "string_substring", N_("<b>string_substring</b>(<i>$dest, $src, start, end</i>)\nCopies a substring out of a UTF-8 encoded string <i>$src</i>.\nThe substring will contain <i>end</i> - <i>start</i> characters."), NULL},
{"string_truncate", "string_truncate()", "string_truncate", N_("<b>string_truncate</b>(<i>$str, len</i>)\nCuts off the end of the string <i>$str</i>, leaving the first <i>len</i> characters."), NULL},
{"string_up", "string_up()", "string_up", N_("<b>string_up</b>(<i>$dest, $src</i>)\nConverts all lowercase ASCII letters to uppercase ASCII letters in the string <i>$src</i> and set to the string <i>$dest</i>."), NULL},
{"sum", "sum()", "sum", N_("<b>sum</b>(<i>x</i>)\nIntegration"), NULL},
{"sumsq", "sumsq()", "sumsq", N_("<b>sumsq</b>(<i>a, b, c, ...</i>)\nsquare sum of arguments"), NULL},
{"tan", "tan()", "tan", N_("<b>tan</b>(<i>x</i>)\ntangent function"), NULL},
{"tanh", "tanh()", "tanh", N_("<b>tanh</b>(<i>x</i>)\nhyperbolic tangent function"), NULL},
{"text_align", "text_align()", "text_align", N_("<b>text_align</b>(<i>x, y</i>)\nSet alignment of a text drawing.\n<i>x</i> and <i>y</i> represent alignment of parallel and normal direction respectively.\n(0 &lt;= <i>x, y</i> &lt;= 1)"), NULL},
{"text_font", "text_font()", "text_font", N_("<b>text_font</b>(<i>font</i>)\nSet font setting of drawing texts.\nThe value <i>font</i> 0, 1 and 2 represent \"Sans-serif\", \"Serif\" and \"Monospace\" respectively."), NULL},
{"text_obj_get", "text_obj_get()", "text_obj_get", N_("<b>text_obj_get</b>(<i>id, $text</i>)\nassign text of the the text object which ID is <i>id</i> to the variable <i>$text</i>."), NULL},
{"text_obj_set", "text_obj_set()", "text_obj_set", N_("<b>text_obj_set</b>(<i>id, $text</i>)\nset text of the the text object which ID is <i>id</i> as the variable <i>$text</i>."), NULL},
{"text_size", "text_size()", "text_size", N_("<b>text_size</b>(<i>pt, space, script</i>)\nSet font size and other settings of drawing texts.\nFont size can be specified by <i>pt</i>.\nFont-spacing and script-size are specified by the following arguments."), NULL},
{"text_style", "text_style()", "text_style", N_("<b>text_style</b>(<i>style</i>)\nSet font style settings of drawing texts.\nThe value <i>style</i> 0, 1, 2 and 3 represent \"normal\", \"bold\", \"italic\" and \"bold-italic\" respectively."), NULL},
{"theta", "theta()", "theta", N_("<b>theta</b>(<i>x</i>)\nstaircase function (1 if <i>x</i> &gt;= 0, 0 otherwise)"), NULL},
{"time", "time()", "time", N_("<b>time</b>(<i></i>)\nreturns the time as the number of seconds since the Epoch,\n1970-01-01 00:00:00 +0000 (UTC)"), NULL},
{"times", "times()", "times", N_("<b>times</b>(<i>n, index, ex</i>)\nRepeat <i>ex</i> <i>n</i> times.\nThe loop count can be referred by the variable <i>index</i>."), NULL},
{"tn", "tn()", "tn", N_("<b>tn</b>(<i>n, x</i>)\nChebyshev polynomials"), NULL},
{"unix2mjd", "unix2mjd()", "unix2mjd", N_("<b>unix2mjd</b>(<i>time</i>)\nModified Julian Date\n<i>time</i> represents the number of seconds elapsed since the Epoch,\n1970-01-01 00:00:00 +0000 (UTC))"), NULL},
{"unless", "unless()", "unless", N_("<b>unless</b>(<i>x, ex1, ex2</i>)\nevaluate <i>ex2</i> when <i>x</i> != 0, evaluate <i>ex1</i> otherwise"), NULL},
{"unshift", "unshift()", "unshift", N_("<b>unshift</b>(<i>a, x</i>)\nadds new element <i>x</i> to the beginning of an array <i>a</i>.\nReturns the new size of the array."), NULL},
{"xor", "xor()", "xor", N_("<b>xor</b>(<i>x, y</i>)\nTrue (= 1) when (<i>x</i> != 0) xor (<i>y</i> != 0)"), NULL},
{"yl", "yl()", "yl", N_("<b>yl</b>(<i>l, x</i>)\ncompute the irregular spherical Bessel function of order |<i>l</i>|, y<sub><i>l</i></sub>(|<i>x</i>|)"), NULL},
{"yn", "yn()", "yn", N_("<b>yn</b>(<i>n, x</i>)\ncompute the irregular cylindrical Bessel function of order <i>n</i>, Y<sub><i>n</i></sub>(|<i>x</i>|)"), NULL},
{"ynu", "ynu()", "ynu", N_("<b>ynu</b>(<i>nu, x</i>)\ncompute the irregular cylindrical Bessel function of fractional order |<i>nu</i>|, Y<sub><i>nu</i></sub>(|<i>x</i>|)"), NULL},
{"zeta", "zeta()", "zeta", N_("<b>zeta</b>(<i>s</i>)\ncompute the Riemann zeta function zeta(s) for arbitrary <i>s</i>, <i>s</i> != 1"), NULL},
{"zeta_int", "zeta_int()", "zeta_int", N_("<b>zeta_int</b>(<i>n</i>)\ncompute the Riemann zeta function zeta(n) for integer <i>n</i>, <i>n</i> != 1"), NULL},
{"zetam1", "zetam1()", "zetam1", N_("<b>zetam1</b>(<i>s</i>)\ncompute zeta(<i>s</i>) - 1 for arbitrary <i>s</i>, <i>s</i> != 1"), NULL},
{"zetam1_int", "zetam1_int()", "zetam1_int", N_("<b>zetam1_int</b>(<i>n</i>)\ncompute zeta(<i>n</i>) - 1 for integer <i>n</i>, <i>n</i> != 1"), NULL},
{"zip", "zip()", "zip", N_("<b>zip</b>(<i>a1, a2, item1, item2, ex</i>)\nEvaluate <i>ex</i> for each element of two arrays <i>a1</i> and <i>a2</i>.\nThe elements of the arrays can be referred by the variable <i>item1</i> and <i>item2</i>."), NULL},
{"zip_map", "zip_map()", "zip_map", N_("<b>zip_map</b>(<i>dest, src1, src2, item1, item2, ex</i>)\nEvaluate <i>ex</i> for each element of two arrays <i>src1</i> and <i>sec2</i>\nand set them to the array <i>dest</i>..\nThe elements of the arrays can be referred by the variable <i>item1</i> and <i>item2</i>."), NULL},
{NULL, NULL, NULL, NULL, NULL}
};
struct completion_info completion_info_const[] = {
{"%d", "%D", NULL, N_("<b>%D</b>\nThe ID of the instance of the data object"), NULL},
{"%n", "%N", NULL, N_("<b>%N</b>\nThe number of instances of data object"), NULL},
{"arc_obj", "ARC_OBJ", NULL, N_("<b>ARC_OBJ</b>\nThe identification number of the arc object"), NULL},
{"avx", "AVX", NULL, N_("<b>AVX</b>\nThe average of X"), NULL},
{"avy", "AVY", NULL, N_("<b>AVY</b>\nThe average of X"), NULL},
{"axisx", "AXISX", NULL, N_("<b>AXISX</b>\nThe ID of the axis instance specified as X axis"), NULL},
{"axisx_len", "AXISX_LEN", NULL, N_("<b>AXISX_LEN</b>\nLength of the X axis"), NULL},
{"axisx_max", "AXISX_MAX", NULL, N_("<b>AXISX_MAX</b>\nThe maximum value of the X axis"), NULL},
{"axisx_min", "AXISX_MIN", NULL, N_("<b>AXISX_MIN</b>\nThe minimum value of the X axis"), NULL},
{"axisy", "AXISY", NULL, N_("<b>AXISY</b>\nThe ID of the axis instance specified as Y axis"), NULL},
{"axisy_len", "AXISY_LEN", NULL, N_("<b>AXISY_LEN</b>\nLength of the Y axis"), NULL},
{"axisy_max", "AXISY_MAX", NULL, N_("<b>AXISY_MAX</b>\nThe maximum value of the Y axis"), NULL},
{"axisy_min", "AXISY_MIN", NULL, N_("<b>AXISY_MIN</b>\nThe minimum value of the Y axis"), NULL},
{"break", "BREAK", NULL, N_("<b>BREAK</b>\nMissing data (data lines are not combined)"), NULL},
{"colx", "COLX", NULL, N_("<b>COLX</b>\nThe column number specified for X"), NULL},
{"coly", "COLY", NULL, N_("<b>COLY</b>\nThe column number specified for Y"), NULL},
{"cont", "CONT", NULL, N_("<b>CONT</b>\nMissing data (data lines are combined)"), NULL},
{"data_obj", "DATA_OBJ", NULL, N_("<b>DATA_OBJ</b>\nThe identification number of the data object"), NULL},
{"e", "E", NULL, N_("<b>E</b>\nThe base of natural logarithm (Napier's constant)"), NULL},
{"euler", "EULER", NULL, N_("<b>EULER</b>\nEuler's constant"), NULL},
{"false", "FALSE", NULL, N_("<b>FALSE</b>\nthe FALSE value (0)"), NULL},
{"file_obj", "FILE_OBJ", NULL, N_("<b>FILE_OBJ</b>\nThe identification number of the file object"), NULL},
{"fill_rule_even_odd", "FILL_RULE_EVEN_ODD", NULL, N_("<b>FILL_RULE_EVEN_ODD</b>\nDefined for the function <b>draw_polygon</b>().\nfill the polygon with evin-odd rule."), NULL},
{"fill_rule_none", "FILL_RULE_NONE", NULL, N_("<b>FILL_RULE_NONE</b>\nDefined for the function <b>draw_polygon</b>().\ndon't fill the polygon."), NULL},
{"fill_rule_winding", "FILL_RULE_WINDING", NULL, N_("<b>FILL_RULE_WINDING</b>\nDefined for the function <b>draw_polygon</b>().\nfill the polygon with winding rule."), NULL},
{"first", "FIRST", NULL, N_("<b>FIRST</b>\nWhen conversion is performed twice with one line of data such as diagonal or errorbar plot,\ntrue (1) in the first call, false (0) in the second call."), NULL},
{"fline", "FLINE", NULL, N_("<b>FLINE</b>\nNumber of lines specified as \"Final line\""), NULL},
{"hskip", "HSKIP", NULL, N_("<b>HSKIP</b>\nNumber of lines specified as \"Head skip\""), NULL},
{"mark_obj", "MARK_OBJ", NULL, N_("<b>MARK_OBJ</b>\nThe identification number of the mark object"), NULL},
{"mask", "MASK", NULL, N_("<b>MASK</b>\nNumber of lines set for mask"), NULL},
{"maxx", "MAXX", NULL, N_("<b>MAXX</b>\nThe maximum value of X"), NULL},
{"maxy", "MAXY", NULL, N_("<b>MAXY</b>\nThe maximum value of Y"), NULL},
{"minx", "MINX", NULL, N_("<b>MINX</b>\nThe minimum value of X"), NULL},
{"miny", "MINY", NULL, N_("<b>MINY</b>\nThe minimum value of Y"), NULL},
{"move", "MOVE", NULL, N_("<b>MOVE</b>\nNumber of lines set for move"), NULL},
{"nan", "NAN", NULL, N_("<b>NAN</b>\nMissing data with error indication"), NULL},
{"num", "NUM", NULL, N_("<b>NUM</b>\nThe number of the data"), NULL},
{"path_obj", "PATH_OBJ", NULL, N_("<b>PATH_OBJ</b>\nThe identification number of the path object"), NULL},
{"pi", "PI", NULL, N_("<b>PI</b>\nPi"), NULL},
{"rect_obj", "RECT_OBJ", NULL, N_("<b>RECT_OBJ</b>\nThe identification number of the rectangle object"), NULL},
{"rstep", "RSTEP", NULL, N_("<b>RSTEP</b>\nNumber of lines specified as \"Read step\""), NULL},
{"stdevpx", "STDEVPX", NULL, N_("<b>STDEVPX</b>\nThe standard deviation of X"), NULL},
{"stdevpy", "STDEVPY", NULL, N_("<b>STDEVPY</b>\nThe standard deviation of Y"), NULL},
{"stdevx", "STDEVX", NULL, N_("<b>STDEVX</b>\nThe corrected sample standard deviation of X"), NULL},
{"stdevy", "STDEVY", NULL, N_("<b>STDEVY</b>\nThe corrected sample standard deviation of Y"), NULL},
{"sumx", "SUMX", NULL, N_("<b>SUMX</b>\nSum of X"), NULL},
{"sumxx", "SUMXX", NULL, N_("<b>SUMXX</b>\nSquare sum of X"), NULL},
{"sumxy", "SUMXY", NULL, N_("<b>SUMXY</b>\nProduct sum of X and Y"), NULL},
{"sumy", "SUMY", NULL, N_("<b>SUMY</b>\nSum of Y"), NULL},
{"sumyy", "SUMYY", NULL, N_("<b>SUMYY</b>\nSquare sum of Y"), NULL},
{"text_obj", "TEXT_OBJ", NULL, N_("<b>TEXT_OBJ</b>\nThe identification number of the text object"), NULL},
{"true", "TRUE", NULL, N_("<b>TRUE</b>\nthe TRUE value (1)"), NULL},
{"undef", "UNDEF", NULL, N_("<b>UNDEF</b>\nMissing data without error indication"), NULL},
{NULL, NULL, NULL, NULL, NULL}
};
