/* OWLFunctionalSyntaxParser.java */
/* Generated By:JavaCC: Do not edit this line. OWLFunctionalSyntaxParser.java */
package org.semanticweb.owlapi.functional.parser;

import org.semanticweb.owlapi.model.*;
import org.semanticweb.owlapi.vocab.*;
import java.net.*;
import java.util.*;
import org.semanticweb.owlapi.util.*;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import java.io.IOException;
import org.semanticweb.owlapi.io.OWLParserException;

@SuppressWarnings("all")
public class OWLFunctionalSyntaxParser implements OWLFunctionalSyntaxParserConstants {
    private OWLOntologyManager man;
    private OWLOntologyLoaderConfiguration configuration;
    private OWLOntology ontology;
    private OWLDataFactory df;
    private Map<String, IRI> string2IRI;
    private Map<String, String> prefixMap;
    private IRI ontologyIRI;
    private boolean ignoreAnnotationsAndDeclarations = false;
    private Set<OWLAnnotation> currentAnnotations;
    protected RemappingIndividualProvider anonProvider;

    public void setUp(OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) {
        this.man = ontology.getOWLOntologyManager();
        this.ontology = ontology;
        this.configuration = configuration;
        this.df = man.getOWLDataFactory();
        anonProvider=new RemappingIndividualProvider(man.getOntologyConfigurator(), df);
        this.currentAnnotations = new HashSet<OWLAnnotation>();
        if(prefixMap == null) {
            prefixMap = new HashMap<String, String>();
            prefixMap.put("owl:", Namespaces.OWL.toString());
            prefixMap.put("rdf:", Namespaces.RDF.toString());
            prefixMap.put("rdfs:", Namespaces.RDFS.toString());
            prefixMap.put("xml:", Namespaces.XML.toString());
            prefixMap.put("xsd:", Namespaces.XSD.toString());
        }
        string2IRI = new HashMap<String, IRI>();
    }

    public IRI getIRI(String s) {
        IRI iri = string2IRI.get(s);
        if(iri == null) {
            if(s.charAt(0) == '<') {
                iri = IRI.create(s.substring(1, s.length() - 1));
            }
            else {
                int colonIndex = s.indexOf(':');
                String prefixName = s.substring(0, colonIndex + 1);
                String prefix = prefixMap.get(prefixName);
                if(prefix == null) {
                    throw new OWLRuntimeException("Undefined prefix name: " + prefixName);
                }
                String fullIRIString = prefix + s.substring(colonIndex + 1);
                iri = IRI.create(fullIRIString);
            }
            string2IRI.put(s, iri);
        }
        return iri;
    }

    public void setIgnoreAnnotationsAndDeclarations(boolean b) {
        ignoreAnnotationsAndDeclarations = b;
    }

    protected void applyChange(OWLOntologyChange chg) {
        man.applyChange(chg);
    }

    protected void addAxiom(OWLAxiom ax) {
        if (!(ax instanceof OWLAnnotationAxiom) || configuration.isLoadAnnotationAxioms()) {
            ontology.addAxiom(ax);
        }
    }

    public void setPrefixes(PrefixManager nsm) {
        if(prefixMap == null) {
            prefixMap = new HashMap<String, String>();
        }
        prefixMap.putAll(nsm.getPrefixName2PrefixMap());
    }

  final public FunctionalSyntaxDocumentFormat parse() throws ParseException, OWLParserException, UnloadableImportException {
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PREFIX:{
        ;
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      Prefix();
    }
    Ontology();
    jj_consume_token(0);
FunctionalSyntaxDocumentFormat format = new FunctionalSyntaxDocumentFormat();
        for(String pn : prefixMap.keySet()) {
            format.setPrefix(pn, prefixMap.get(pn));
        }
        return format;
}

  final public void Ontology() throws ParseException, OWLParserException, UnloadableImportException {OWLAnnotation anno;
    OWLAxiom ax;
    OWLImportsDeclaration decl;
    int count = 0;
    IRI versionIRI = null;
    jj_consume_token(ONTOLOGY);
    jj_consume_token(OPENPAR);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FULLIRI:
    case PNAME_LN:{
      ontologyIRI = IRI();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FULLIRI:
      case PNAME_LN:{
        versionIRI = IRI();
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      ;
    }
OWLOntologyID id = new OWLOntologyID(ontologyIRI, versionIRI);
        applyChange(new SetOntologyID(ontology, id));
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IMPORT:
      case ANNOTATION:{
        ;
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IMPORT:{
        decl = ImportsDeclaration();
applyChange(new AddImport(ontology, decl));
        man.makeLoadImportRequest(decl, configuration);
        break;
        }
      case ANNOTATION:{
        anno = Annotation();
applyChange(new AddOntologyAnnotation(ontology, anno));
        currentAnnotations.clear();
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SUBCLASSOF:
      case EQUIVALENTCLASSES:
      case DISJOINTCLASSES:
      case DISJOINTUNION:
      case ANNOTATIONASSERTION:
      case SUBANNOTATIONPROPERTYOF:
      case ANNOTATIONPROPERTYDOMAIN:
      case ANNOTATIONPROPERTYRANGE:
      case HASKEY:
      case DECLARATION:
      case INVERSEOBJECTPROPERTIES:
      case DATATYPEDEFINITION:
      case SUBOBJECTPROPERTYOF:
      case EQUIVALENTOBJECTPROPERTIES:
      case DISJOINTOBJECTPROPERTIES:
      case OBJECTPROPERTYDOMAIN:
      case OBJECTPROPERTYRANGE:
      case FUNCTIONALOBJECTPROPERTY:
      case INVERSEFUNCTIONALOBJECTPROPERTY:
      case REFLEXIVEOBJECTPROPERTY:
      case IRREFLEXIVEOBJECTPROPERTY:
      case SYMMETRICOBJECTPROPERTY:
      case ASYMMETRICOBJECTPROPERTY:
      case TRANSITIVEOBJECTPROPERTY:
      case SUBDATAPROPERTYOF:
      case EQUIVALENTDATAPROPERTIES:
      case DISJOINTDATAPROPERTIES:
      case DATAPROPERTYDOMAIN:
      case DATAPROPERTYRANGE:
      case FUNCTIONALDATAPROPERTY:
      case SAMEINDIVIDUAL:
      case DIFFERENTINDIVIDUALS:
      case CLASSASSERTION:
      case OBJECTPROPERTYASSERTION:
      case NEGATIVEOBJECTPROPERTYASSERTION:
      case DATAPROPERTYASSERTION:
      case NEGATIVEDATAPROPERTYASSERTION:
      case DLSAFERULE:{
        ;
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      ax = Axiom();
addAxiom(ax);
        currentAnnotations.clear();
    }
    jj_consume_token(CLOSEPAR);
}

  final public void Prefix() throws ParseException {String prefixName="";
    IRI iri;
    jj_consume_token(PREFIX);
    jj_consume_token(OPENPAR);
    prefixName = PrefixName();
    jj_consume_token(EQUALS);
    iri = FullIRI();
    jj_consume_token(CLOSEPAR);
prefixMap.put(prefixName, iri.toString());
}

  final public IRI IRI() throws ParseException {IRI iri;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FULLIRI:{
      iri = FullIRI();
      break;
      }
    case PNAME_LN:{
      iri = AbbreviatedIRI();
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return iri;
}

  final public IRI FullIRI() throws ParseException {Token t;
    t = jj_consume_token(FULLIRI);
return getIRI(t.image);
}

  final public IRI AbbreviatedIRI() throws ParseException {Token t;
    t = jj_consume_token(PNAME_LN);
return getIRI(t.image);
}

  final public String PrefixName() throws ParseException {Token t;
    t = jj_consume_token(PNAME_NS);
return t.image;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Class Descriptions
//
/////////////////////////////////////////////////////////////////////////////////////////////////////
  final public 
OWLClassExpression ClassExpression() throws ParseException {OWLClassExpression desc;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FULLIRI:
    case PNAME_LN:{
      desc = ClassIRI();
      break;
      }
    case OBJECTUNIONOF:{
      desc = ObjectUnionOf();
      break;
      }
    case OBJECTINTERSECTIONOF:{
      desc = ObjectIntersectionOf();
      break;
      }
    case OBJECTCOMPLEMENTOF:{
      desc = ObjectComplementOf();
      break;
      }
    case OBJECTONEOF:{
      desc = ObjectOneOf();
      break;
      }
    case OBJECTSOMEVALUESFROM:{
      desc = ObjectSomeValuesFrom();
      break;
      }
    case OBJECTALLVALUESFROM:{
      desc = ObjectAllValuesFrom();
      break;
      }
    case OBJECTHASVALUE:{
      desc = ObjectHasValue();
      break;
      }
    case OBJECTHASSELF:{
      desc = ObjectSelf();
      break;
      }
    case OBJECTMINCARDINALITY:{
      desc = ObjectMinCardinality();
      break;
      }
    case OBJECTEXACTCARDINALITY:{
      desc = ObjectExactCardinality();
      break;
      }
    case OBJECTMAXCARDINALITY:{
      desc = ObjectMaxCardinality();
      break;
      }
    case DATASOMEVALUESFROM:{
      desc = DataSomeValuesFrom();
      break;
      }
    case DATAALLVALUESFROM:{
      desc = DataAllValuesFrom();
      break;
      }
    case DATAHASVALUE:{
      desc = DataHasValue();
      break;
      }
    case DATAMINCARDINALITY:{
      desc = DataMinCardinality();
      break;
      }
    case DATAEXACTCARDINALITY:{
      desc = DataExactCardinality();
      break;
      }
    case DATAMAXCARDINALITY:{
      desc = DataMaxCardinality();
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return desc;
}

  final public OWLClass ClassIRI() throws ParseException {IRI iri;
    iri = IRI();
return df.getOWLClass(iri);
}

  final public Set<OWLClassExpression> ClassExpressionSet() throws ParseException {Set<OWLClassExpression> classExpressions = new HashSet<OWLClassExpression>();
    OWLClassExpression desc;
    desc = ClassExpression();
classExpressions.add(desc);
    desc = ClassExpression();
classExpressions.add(desc);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OBJECTONEOF:
      case OBJECTUNIONOF:
      case OBJECTHASVALUE:
      case OBJECTINTERSECTIONOF:
      case OBJECTCOMPLEMENTOF:
      case OBJECTALLVALUESFROM:
      case OBJECTSOMEVALUESFROM:
      case OBJECTHASSELF:
      case OBJECTMINCARDINALITY:
      case OBJECTMAXCARDINALITY:
      case OBJECTEXACTCARDINALITY:
      case DATAALLVALUESFROM:
      case DATASOMEVALUESFROM:
      case DATAHASVALUE:
      case DATAMINCARDINALITY:
      case DATAMAXCARDINALITY:
      case DATAEXACTCARDINALITY:
      case FULLIRI:
      case PNAME_LN:{
        ;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_4;
      }
      desc = ClassExpression();
classExpressions.add(desc);
    }
return classExpressions;
}

  final public Set<OWLIndividual> IndividualMinOneSet() throws ParseException {Set<OWLIndividual> individuals = new HashSet<OWLIndividual>();
    OWLIndividual ind;
    ind = Individual();
individuals.add(ind);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FULLIRI:
      case PNAME_LN:
      case NODEID:{
        ;
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        break label_5;
      }
      ind = Individual();
individuals.add(ind);
    }
return individuals;
}

  final public OWLClassExpression ObjectUnionOf() throws ParseException {Set<OWLClassExpression> classExpressions;
    jj_consume_token(OBJECTUNIONOF);
    jj_consume_token(OPENPAR);
    classExpressions = ClassExpressionSet();
    jj_consume_token(CLOSEPAR);
return df.getOWLObjectUnionOf(classExpressions);
}

  final public OWLClassExpression ObjectIntersectionOf() throws ParseException {Set<OWLClassExpression> classExpressions;
    jj_consume_token(OBJECTINTERSECTIONOF);
    jj_consume_token(OPENPAR);
    classExpressions = ClassExpressionSet();
    jj_consume_token(CLOSEPAR);
return df.getOWLObjectIntersectionOf(classExpressions);
}

  final public OWLClassExpression ObjectComplementOf() throws ParseException {OWLClassExpression operand;
    jj_consume_token(OBJECTCOMPLEMENTOF);
    jj_consume_token(OPENPAR);
    operand = ClassExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLObjectComplementOf(operand);
}

  final public OWLClassExpression ObjectOneOf() throws ParseException {Set<OWLIndividual> individuals;
    jj_consume_token(OBJECTONEOF);
    jj_consume_token(OPENPAR);
    individuals = IndividualMinOneSet();
    jj_consume_token(CLOSEPAR);
return df.getOWLObjectOneOf(individuals);
}

  final public OWLClassExpression ObjectAllValuesFrom() throws ParseException {OWLObjectPropertyExpression prop;
    OWLClassExpression filler;
    jj_consume_token(OBJECTALLVALUESFROM);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyExpression();
    filler = ClassExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLObjectAllValuesFrom(prop, filler);
}

  final public OWLClassExpression ObjectSomeValuesFrom() throws ParseException {OWLObjectPropertyExpression prop;
    OWLClassExpression filler;
    jj_consume_token(OBJECTSOMEVALUESFROM);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyExpression();
    filler = ClassExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLObjectSomeValuesFrom(prop, filler);
}

  final public OWLClassExpression ObjectHasValue() throws ParseException {OWLObjectPropertyExpression prop;
    OWLIndividual ind;
    jj_consume_token(OBJECTHASVALUE);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyExpression();
    ind = Individual();
    jj_consume_token(CLOSEPAR);
return df.getOWLObjectHasValue(prop, ind);
}

  final public OWLClassExpression ObjectSelf() throws ParseException {OWLObjectPropertyExpression prop;
    jj_consume_token(OBJECTHASSELF);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLObjectHasSelf(prop);
}

  final public OWLClassExpression ObjectMinCardinality() throws ParseException {int cardinality = 0;
    OWLObjectPropertyExpression prop = null;
    OWLClassExpression filler = null;
    jj_consume_token(OBJECTMINCARDINALITY);
    jj_consume_token(OPENPAR);
    cardinality = Cardinality();
    prop = ObjectPropertyExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OBJECTONEOF:
    case OBJECTUNIONOF:
    case OBJECTHASVALUE:
    case OBJECTINTERSECTIONOF:
    case OBJECTCOMPLEMENTOF:
    case OBJECTALLVALUESFROM:
    case OBJECTSOMEVALUESFROM:
    case OBJECTHASSELF:
    case OBJECTMINCARDINALITY:
    case OBJECTMAXCARDINALITY:
    case OBJECTEXACTCARDINALITY:
    case DATAALLVALUESFROM:
    case DATASOMEVALUESFROM:
    case DATAHASVALUE:
    case DATAMINCARDINALITY:
    case DATAMAXCARDINALITY:
    case DATAEXACTCARDINALITY:
    case FULLIRI:
    case PNAME_LN:{
      filler = ClassExpression();
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      ;
    }
    jj_consume_token(CLOSEPAR);
if(filler == null) {
            return df.getOWLObjectMinCardinality(cardinality, prop);
        }
        return df.getOWLObjectMinCardinality(cardinality, prop, filler);
}

  final public OWLClassExpression ObjectExactCardinality() throws ParseException {int cardinality = 0;
    OWLObjectPropertyExpression prop = null;
    OWLClassExpression filler = null;
    jj_consume_token(OBJECTEXACTCARDINALITY);
    jj_consume_token(OPENPAR);
    cardinality = Cardinality();
    prop = ObjectPropertyExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OBJECTONEOF:
    case OBJECTUNIONOF:
    case OBJECTHASVALUE:
    case OBJECTINTERSECTIONOF:
    case OBJECTCOMPLEMENTOF:
    case OBJECTALLVALUESFROM:
    case OBJECTSOMEVALUESFROM:
    case OBJECTHASSELF:
    case OBJECTMINCARDINALITY:
    case OBJECTMAXCARDINALITY:
    case OBJECTEXACTCARDINALITY:
    case DATAALLVALUESFROM:
    case DATASOMEVALUESFROM:
    case DATAHASVALUE:
    case DATAMINCARDINALITY:
    case DATAMAXCARDINALITY:
    case DATAEXACTCARDINALITY:
    case FULLIRI:
    case PNAME_LN:{
      filler = ClassExpression();
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    jj_consume_token(CLOSEPAR);
if(filler == null) {
            return df.getOWLObjectExactCardinality(cardinality, prop);
        }
        return df.getOWLObjectExactCardinality(cardinality, prop, filler);
}

  final public OWLClassExpression ObjectMaxCardinality() throws ParseException {int cardinality = 0;
    OWLObjectPropertyExpression prop = null;
    OWLClassExpression filler = null;
    jj_consume_token(OBJECTMAXCARDINALITY);
    jj_consume_token(OPENPAR);
    cardinality = Cardinality();
    prop = ObjectPropertyExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OBJECTONEOF:
    case OBJECTUNIONOF:
    case OBJECTHASVALUE:
    case OBJECTINTERSECTIONOF:
    case OBJECTCOMPLEMENTOF:
    case OBJECTALLVALUESFROM:
    case OBJECTSOMEVALUESFROM:
    case OBJECTHASSELF:
    case OBJECTMINCARDINALITY:
    case OBJECTMAXCARDINALITY:
    case OBJECTEXACTCARDINALITY:
    case DATAALLVALUESFROM:
    case DATASOMEVALUESFROM:
    case DATAHASVALUE:
    case DATAMINCARDINALITY:
    case DATAMAXCARDINALITY:
    case DATAEXACTCARDINALITY:
    case FULLIRI:
    case PNAME_LN:{
      filler = ClassExpression();
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    jj_consume_token(CLOSEPAR);
if(filler == null) {
            return df.getOWLObjectMaxCardinality(cardinality, prop);
        }
        return df.getOWLObjectMaxCardinality(cardinality, prop, filler);
}

  final public OWLClassExpression DataAllValuesFrom() throws ParseException {OWLDataPropertyExpression prop = null;
    OWLDataRange dataRange = null;
    jj_consume_token(DATAALLVALUESFROM);
    jj_consume_token(OPENPAR);
    prop = DataPropertyExpression();
    dataRange = DataRange();
    jj_consume_token(CLOSEPAR);
return df.getOWLDataAllValuesFrom(prop, dataRange);
}

  final public OWLClassExpression DataSomeValuesFrom() throws ParseException {OWLDataPropertyExpression prop = null;
    OWLDataRange dataRange = null;
    jj_consume_token(DATASOMEVALUESFROM);
    jj_consume_token(OPENPAR);
    prop = DataPropertyExpression();
    dataRange = DataRange();
    jj_consume_token(CLOSEPAR);
return df.getOWLDataSomeValuesFrom(prop, dataRange);
}

  final public OWLClassExpression DataHasValue() throws ParseException {OWLDataPropertyExpression prop = null;
    OWLLiteral literal = null;
    jj_consume_token(DATAHASVALUE);
    jj_consume_token(OPENPAR);
    prop = DataPropertyExpression();
    literal = Literal();
    jj_consume_token(CLOSEPAR);
return df.getOWLDataHasValue(prop, literal);
}

  final public OWLClassExpression DataMinCardinality() throws ParseException {int cardinality = 0;
    OWLDataPropertyExpression prop = null;
    OWLDataRange rng = null;
    jj_consume_token(DATAMINCARDINALITY);
    jj_consume_token(OPENPAR);
    cardinality = Cardinality();
    prop = DataPropertyExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DATAONEOF:
    case DATAUNIONOF:
    case DATAINTERSECTIONOF:
    case DATACOMPLEMENTOF:
    case DATATYPERESTRICTION:
    case FULLIRI:
    case PNAME_LN:{
      rng = DataRange();
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    jj_consume_token(CLOSEPAR);
if(rng == null) {
            return df.getOWLDataMinCardinality(cardinality, prop);
        }
        return df.getOWLDataMinCardinality(cardinality, prop, rng);
}

  final public OWLClassExpression DataExactCardinality() throws ParseException {int cardinality = 0;
    OWLDataPropertyExpression prop = null;
    OWLDataRange rng = null;
    jj_consume_token(DATAEXACTCARDINALITY);
    jj_consume_token(OPENPAR);
    cardinality = Cardinality();
    prop = DataPropertyExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DATAONEOF:
    case DATAUNIONOF:
    case DATAINTERSECTIONOF:
    case DATACOMPLEMENTOF:
    case DATATYPERESTRICTION:
    case FULLIRI:
    case PNAME_LN:{
      rng = DataRange();
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    jj_consume_token(CLOSEPAR);
if(rng == null) {
            return df.getOWLDataExactCardinality(cardinality, prop);
        }
        return df.getOWLDataExactCardinality(cardinality, prop, rng);
}

  final public OWLClassExpression DataMaxCardinality() throws ParseException {int cardinality = 0;
    OWLDataPropertyExpression prop = null;
    OWLDataRange rng = null;
    jj_consume_token(DATAMAXCARDINALITY);
    jj_consume_token(OPENPAR);
    cardinality = Cardinality();
    prop = DataPropertyExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DATAONEOF:
    case DATAUNIONOF:
    case DATAINTERSECTIONOF:
    case DATACOMPLEMENTOF:
    case DATATYPERESTRICTION:
    case FULLIRI:
    case PNAME_LN:{
      rng = DataRange();
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    jj_consume_token(CLOSEPAR);
if(rng == null) {
            return df.getOWLDataMaxCardinality(cardinality, prop);
        }
        return df.getOWLDataMaxCardinality(cardinality, prop, rng);
}

  final public OWLClass Class() throws ParseException {OWLClass cls;
    jj_consume_token(CLASS);
    jj_consume_token(OPENPAR);
    cls = ClassIRI();
    jj_consume_token(CLOSEPAR);
return cls;
}

  final public OWLObjectPropertyExpression ObjectPropertyExpression() throws ParseException {OWLObjectPropertyExpression prop;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OBJECTINVERSEOF:{
      prop = InverseObjectProperty();
      break;
      }
    case FULLIRI:
    case PNAME_LN:{
      prop = ObjectPropertyIRI();
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return prop;
}

  final public OWLObjectPropertyExpression InverseObjectProperty() throws ParseException {OWLObjectProperty prop;
    jj_consume_token(OBJECTINVERSEOF);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyIRI();
    jj_consume_token(CLOSEPAR);
return df.getOWLObjectInverseOf(prop);
}

  final public OWLObjectProperty ObjectProperty() throws ParseException {OWLObjectProperty prop;
    jj_consume_token(OBJECTPROP);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyIRI();
    jj_consume_token(CLOSEPAR);
return prop;
}

  final public OWLDataPropertyExpression DataPropertyExpression() throws ParseException {OWLDataPropertyExpression prop;
    prop = DataPropertyIRI();
return prop;
}

  final public OWLDataProperty DataPropertyIRI() throws ParseException {IRI iri;
    iri = IRI();
return df.getOWLDataProperty(iri);
}

  final public OWLDataProperty DataProperty() throws ParseException {OWLDataProperty prop;
    jj_consume_token(DATAPROP);
    jj_consume_token(OPENPAR);
    prop = DataPropertyIRI();
    jj_consume_token(CLOSEPAR);
return prop;
}

  final public OWLAnnotationProperty AnnotationProperty() throws ParseException {OWLAnnotationProperty prop;
    jj_consume_token(ANNOTATIONPROPERTY);
    jj_consume_token(OPENPAR);
    prop = AnnotationPropertyIRI();
    jj_consume_token(CLOSEPAR);
return prop;
}

  final public OWLAnnotationProperty AnnotationPropertyIRI() throws ParseException {IRI iri;
    iri = IRI();
return df.getOWLAnnotationProperty(iri);
}

  final public OWLNamedIndividual NamedIndividual() throws ParseException {OWLNamedIndividual ind;
    jj_consume_token(NAMEDINDIVIDUAL);
    jj_consume_token(OPENPAR);
    ind = IndividualIRI();
    jj_consume_token(CLOSEPAR);
return ind;
}

  final public OWLAnonymousIndividual AnonymousIndividual() throws ParseException {Token t;
    t = jj_consume_token(NODEID);
return anonProvider.getOWLAnonymousIndividual(t.image.substring(2, t.image.length()));
}

  final public OWLDatatype Datatype() throws ParseException {OWLDatatype dt;
    jj_consume_token(DATATYPE);
    jj_consume_token(OPENPAR);
    dt = DatatypeIRI();
    jj_consume_token(CLOSEPAR);
return dt;
}

  final public OWLDatatype DatatypeIRI() throws ParseException {IRI iri;
    iri = IRI();
return df.getOWLDatatype(iri);
}

  final public int Cardinality() throws ParseException {int card = 0;
    card = Integer();
return card;
}

  final public int Integer() throws ParseException {Token t;
    t = jj_consume_token(INT);
return Integer.parseInt(t.image);
}

  final public OWLDatatypeDefinitionAxiom DatatypeDefinitionAxiom() throws ParseException {OWLDatatype datatype;
    OWLDataRange dr;
    Set<OWLAnnotation> axAnnos;
    jj_consume_token(DATATYPEDEFINITION);
    jj_consume_token(OPENPAR);
    axAnnos = AxiomAnnotationSet();
    datatype = DatatypeIRI();
    dr = DataRange();
    jj_consume_token(CLOSEPAR);
return df.getOWLDatatypeDefinitionAxiom(datatype, dr, axAnnos);
}

  final public OWLDataRange DataRange() throws ParseException {OWLDataRange rng;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FULLIRI:
    case PNAME_LN:{
      rng = DatatypeIRI();
      break;
      }
    case DATAONEOF:{
      rng = DataOneOf();
      break;
      }
    case DATACOMPLEMENTOF:{
      rng = DataComplementOf();
      break;
      }
    case DATATYPERESTRICTION:{
      rng = DataRangeRestriction();
      break;
      }
    case DATAINTERSECTIONOF:{
      rng = DataIntersectionOf();
      break;
      }
    case DATAUNIONOF:{
      rng = DataUnionOf();
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return rng;
}

  final public OWLDataRange DataComplementOf() throws ParseException {OWLDataRange rng;
    jj_consume_token(DATACOMPLEMENTOF);
    jj_consume_token(OPENPAR);
    rng = DataRange();
    jj_consume_token(CLOSEPAR);
return df.getOWLDataComplementOf(rng);
}

  final public OWLDataRange DataOneOf() throws ParseException {Set<OWLLiteral> values = new HashSet<OWLLiteral>();
    OWLLiteral con = null;
    OWLDataRange rng = null;
    jj_consume_token(DATAONEOF);
    jj_consume_token(OPENPAR);
    label_6:
    while (true) {
      con = Literal();
values.add(con);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRINGLITERAL:{
        ;
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        break label_6;
      }
    }
    jj_consume_token(CLOSEPAR);
return df.getOWLDataOneOf(values);
}

  final public OWLDataRange DataUnionOf() throws ParseException {OWLDataRange dataRange;
    Set<OWLDataRange> ranges = new HashSet<OWLDataRange>();
    jj_consume_token(DATAUNIONOF);
    jj_consume_token(OPENPAR);
    label_7:
    while (true) {
      dataRange = DataRange();
ranges.add(dataRange);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DATAONEOF:
      case DATAUNIONOF:
      case DATAINTERSECTIONOF:
      case DATACOMPLEMENTOF:
      case DATATYPERESTRICTION:
      case FULLIRI:
      case PNAME_LN:{
        ;
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        break label_7;
      }
    }
    jj_consume_token(CLOSEPAR);
return df.getOWLDataUnionOf(ranges);
}

  final public OWLDataRange DataIntersectionOf() throws ParseException {OWLDataRange dataRange;
    Set<OWLDataRange> ranges = new HashSet<OWLDataRange>();
    jj_consume_token(DATAINTERSECTIONOF);
    jj_consume_token(OPENPAR);
    label_8:
    while (true) {
      dataRange = DataRange();
ranges.add(dataRange);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DATAONEOF:
      case DATAUNIONOF:
      case DATAINTERSECTIONOF:
      case DATACOMPLEMENTOF:
      case DATATYPERESTRICTION:
      case FULLIRI:
      case PNAME_LN:{
        ;
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        break label_8;
      }
    }
    jj_consume_token(CLOSEPAR);
return df.getOWLDataIntersectionOf(ranges);
}

  final public OWLDataRange DataRangeRestriction() throws ParseException {OWLFacet v;
    OWLDatatype rng;
    OWLFacetRestriction fr;
    Set<OWLFacetRestriction> frs = new HashSet<OWLFacetRestriction>();
    jj_consume_token(DATATYPERESTRICTION);
    jj_consume_token(OPENPAR);
    rng = DatatypeIRI();
    label_9:
    while (true) {
      fr = DataRangeFacetRestriction();
frs.add(fr);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FULLIRI:
      case PNAME_LN:{
        ;
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        break label_9;
      }
    }
    jj_consume_token(CLOSEPAR);
return df.getOWLDatatypeRestriction(rng, frs);
}

  final public OWLFacetRestriction DataRangeFacetRestriction() throws ParseException {IRI iri;
    OWLLiteral con;
    iri = IRI();
    con = Literal();
return df.getOWLFacetRestriction(OWLFacet.getFacetByShortName(iri.getFragment()), con);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Axioms
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public 
OWLAxiom Axiom() throws ParseException {OWLAxiom ax;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SUBCLASSOF:
    case EQUIVALENTCLASSES:
    case DISJOINTCLASSES:
    case DISJOINTUNION:{
      ax = ClassAxiom();
      break;
      }
    case INVERSEOBJECTPROPERTIES:
    case SUBOBJECTPROPERTYOF:
    case EQUIVALENTOBJECTPROPERTIES:
    case DISJOINTOBJECTPROPERTIES:
    case OBJECTPROPERTYDOMAIN:
    case OBJECTPROPERTYRANGE:
    case FUNCTIONALOBJECTPROPERTY:
    case INVERSEFUNCTIONALOBJECTPROPERTY:
    case REFLEXIVEOBJECTPROPERTY:
    case IRREFLEXIVEOBJECTPROPERTY:
    case SYMMETRICOBJECTPROPERTY:
    case ASYMMETRICOBJECTPROPERTY:
    case TRANSITIVEOBJECTPROPERTY:{
      ax = ObjectPropertyAxiom();
      break;
      }
    case SUBDATAPROPERTYOF:
    case EQUIVALENTDATAPROPERTIES:
    case DISJOINTDATAPROPERTIES:
    case DATAPROPERTYDOMAIN:
    case DATAPROPERTYRANGE:
    case FUNCTIONALDATAPROPERTY:{
      ax = DataPropertyAxiom();
      break;
      }
    case SAMEINDIVIDUAL:
    case DIFFERENTINDIVIDUALS:
    case CLASSASSERTION:
    case OBJECTPROPERTYASSERTION:
    case NEGATIVEOBJECTPROPERTYASSERTION:
    case DATAPROPERTYASSERTION:
    case NEGATIVEDATAPROPERTYASSERTION:{
      ax = IndividualAxiom();
      break;
      }
    case DECLARATION:{
      ax = Declaration();
      break;
      }
    case HASKEY:{
      ax = HasKey();
      break;
      }
    case DATATYPEDEFINITION:{
      ax = DatatypeDefinitionAxiom();
      break;
      }
    case ANNOTATIONASSERTION:
    case SUBANNOTATIONPROPERTYOF:
    case ANNOTATIONPROPERTYDOMAIN:
    case ANNOTATIONPROPERTYRANGE:{
      ax = AnnotationAxiom();
      break;
      }
    case DLSAFERULE:{
      ax = DLSafeRule();
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ax;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Class Axioms
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public 
OWLClassAxiom ClassAxiom() throws ParseException {OWLClassAxiom ax;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SUBCLASSOF:{
      ax = SubClassOf();
      break;
      }
    case EQUIVALENTCLASSES:{
      ax = EquivalentClasses();
      break;
      }
    case DISJOINTCLASSES:{
      ax = DisjointClasses();
      break;
      }
    case DISJOINTUNION:{
      ax = DisjointUnion();
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ax;
}

  final public OWLClassAxiom SubClassOf() throws ParseException {OWLClassExpression subClass;
    OWLClassExpression superClass;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(SUBCLASSOF);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    subClass = ClassExpression();
    superClass = ClassExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLSubClassOfAxiom(subClass, superClass, axiomAnnos);
}

  final public OWLClassAxiom EquivalentClasses() throws ParseException {Set<OWLClassExpression> classExpressions;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(EQUIVALENTCLASSES);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    classExpressions = ClassExpressionSet();
    jj_consume_token(CLOSEPAR);
return df.getOWLEquivalentClassesAxiom(classExpressions, axiomAnnos);
}

  final public OWLClassAxiom DisjointClasses() throws ParseException {Set<OWLClassExpression> classExpressions;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(DISJOINTCLASSES);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    classExpressions = ClassExpressionSet();
    jj_consume_token(CLOSEPAR);
return df.getOWLDisjointClassesAxiom(classExpressions, axiomAnnos);
}

  final public OWLClassAxiom DisjointUnion() throws ParseException {OWLClass cls;
    Set<OWLClassExpression> classExpressions;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(DISJOINTUNION);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    cls = ClassIRI();
    classExpressions = ClassExpressionSet();
    jj_consume_token(CLOSEPAR);
return df.getOWLDisjointUnionAxiom(cls, classExpressions, axiomAnnos);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Object Property Axioms
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public 
OWLPropertyAxiom ObjectPropertyAxiom() throws ParseException {OWLPropertyAxiom ax;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SUBOBJECTPROPERTYOF:{
      ax = SubObjectPropertyOf();
      break;
      }
    case EQUIVALENTOBJECTPROPERTIES:{
      ax = EquivalentObjectProperties();
      break;
      }
    case DISJOINTOBJECTPROPERTIES:{
      ax = DisjointObjectProperties();
      break;
      }
    case OBJECTPROPERTYRANGE:{
      ax = ObjectPropertyRange();
      break;
      }
    case OBJECTPROPERTYDOMAIN:{
      ax = ObjectPropertyDomain();
      break;
      }
    case FUNCTIONALOBJECTPROPERTY:{
      ax = FunctionalObjectProperty();
      break;
      }
    case INVERSEFUNCTIONALOBJECTPROPERTY:{
      ax = InverseFunctionalObjectProperty();
      break;
      }
    case SYMMETRICOBJECTPROPERTY:{
      ax = SymmetricObjectProperty();
      break;
      }
    case ASYMMETRICOBJECTPROPERTY:{
      ax = AsymmetricObjectProperty();
      break;
      }
    case REFLEXIVEOBJECTPROPERTY:{
      ax = ReflexiveObjectProperty();
      break;
      }
    case IRREFLEXIVEOBJECTPROPERTY:{
      ax = IrreflexiveObjectProperty();
      break;
      }
    case TRANSITIVEOBJECTPROPERTY:{
      ax = TransitiveObjectProperty();
      break;
      }
    case INVERSEOBJECTPROPERTIES:{
      ax = InverseObjectProperties();
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ax;
}

  final public List<OWLObjectPropertyExpression> SubObjectPropertyChain() throws ParseException {OWLObjectPropertyExpression prop;
    List<OWLObjectPropertyExpression> props = new ArrayList<OWLObjectPropertyExpression>();
    jj_consume_token(SUBOBJECTPROPERTYCHAIN);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyExpression();
props.add(prop);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OBJECTINVERSEOF:
      case FULLIRI:
      case PNAME_LN:{
        ;
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        break label_10;
      }
      prop = ObjectPropertyExpression();
props.add(prop);
    }
    jj_consume_token(CLOSEPAR);
return props;
}

  final public OWLPropertyAxiom SubObjectPropertyOf() throws ParseException {OWLObjectPropertyExpression subProperty = null;
    List<OWLObjectPropertyExpression> chain = null;
    OWLObjectPropertyExpression superProperty = null;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(SUBOBJECTPROPERTYOF);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OBJECTINVERSEOF:
    case FULLIRI:
    case PNAME_LN:{
      subProperty = ObjectPropertyExpression();
      break;
      }
    case SUBOBJECTPROPERTYCHAIN:{
      chain = SubObjectPropertyChain();
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    superProperty = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
if(subProperty != null) {
            return df.getOWLSubObjectPropertyOfAxiom(subProperty, superProperty, axiomAnnos);
        }
        if(chain != null) {
            return df.getOWLSubPropertyChainOfAxiom(chain, superProperty, axiomAnnos);
        }
        return null;
}

  final public OWLPropertyAxiom EquivalentObjectProperties() throws ParseException {Set<OWLObjectPropertyExpression> props;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(EQUIVALENTOBJECTPROPERTIES);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    props = ObjectPropertySet();
    jj_consume_token(CLOSEPAR);
return df.getOWLEquivalentObjectPropertiesAxiom(props, axiomAnnos);
}

  final public OWLPropertyAxiom DisjointObjectProperties() throws ParseException {Set<OWLObjectPropertyExpression> props;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(DISJOINTOBJECTPROPERTIES);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    props = ObjectPropertySet();
    jj_consume_token(CLOSEPAR);
return df.getOWLDisjointObjectPropertiesAxiom(props, axiomAnnos);
}

  final public Set<OWLObjectPropertyExpression> ObjectPropertySet() throws ParseException {OWLObjectPropertyExpression prop;
    Set<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
    prop = ObjectPropertyExpression();
props.add(prop);
    prop = ObjectPropertyExpression();
props.add(prop);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OBJECTINVERSEOF:
      case FULLIRI:
      case PNAME_LN:{
        ;
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        break label_11;
      }
      prop = ObjectPropertyExpression();
props.add(prop);
    }
return props;
}

  final public OWLPropertyAxiom ObjectPropertyRange() throws ParseException {OWLObjectPropertyExpression prop;
    OWLClassExpression range;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(OBJECTPROPERTYRANGE);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    range = ClassExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLObjectPropertyRangeAxiom(prop, range, axiomAnnos);
}

  final public OWLPropertyAxiom ObjectPropertyDomain() throws ParseException {OWLObjectPropertyExpression prop;
    OWLClassExpression desc;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(OBJECTPROPERTYDOMAIN);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    desc = ClassExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLObjectPropertyDomainAxiom(prop, desc, axiomAnnos);
}

  final public OWLPropertyAxiom FunctionalObjectProperty() throws ParseException {OWLObjectPropertyExpression prop;
    Set<OWLAnnotation> axiomAnnos = Collections.emptySet();
    jj_consume_token(FUNCTIONALOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLFunctionalObjectPropertyAxiom(prop, axiomAnnos);
}

  final public OWLPropertyAxiom InverseObjectProperties() throws ParseException {OWLObjectPropertyExpression propA;
    OWLObjectPropertyExpression propB;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(INVERSEOBJECTPROPERTIES);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    propA = ObjectPropertyExpression();
    propB = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLInverseObjectPropertiesAxiom(propA, propB, axiomAnnos);
}

  final public OWLPropertyAxiom InverseFunctionalObjectProperty() throws ParseException {OWLObjectPropertyExpression prop;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(INVERSEFUNCTIONALOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLInverseFunctionalObjectPropertyAxiom(prop, axiomAnnos);
}

  final public OWLPropertyAxiom SymmetricObjectProperty() throws ParseException {OWLObjectPropertyExpression prop;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(SYMMETRICOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLSymmetricObjectPropertyAxiom(prop, axiomAnnos);
}

  final public OWLPropertyAxiom AsymmetricObjectProperty() throws ParseException {OWLObjectPropertyExpression prop;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(ASYMMETRICOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLAsymmetricObjectPropertyAxiom(prop, axiomAnnos);
}

  final public OWLPropertyAxiom ReflexiveObjectProperty() throws ParseException {OWLObjectPropertyExpression prop;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(REFLEXIVEOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLReflexiveObjectPropertyAxiom(prop, axiomAnnos);
}

  final public OWLPropertyAxiom IrreflexiveObjectProperty() throws ParseException {OWLObjectPropertyExpression prop;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(IRREFLEXIVEOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLIrreflexiveObjectPropertyAxiom(prop, axiomAnnos);
}

  final public OWLPropertyAxiom TransitiveObjectProperty() throws ParseException {OWLObjectPropertyExpression prop;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(TRANSITIVEOBJECTPROPERTY);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLTransitiveObjectPropertyAxiom(prop, axiomAnnos);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Data Property Axioms
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public 
OWLPropertyAxiom DataPropertyAxiom() throws ParseException {OWLPropertyAxiom ax;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SUBDATAPROPERTYOF:{
      ax = SubDataPropertyOf();
      break;
      }
    case EQUIVALENTDATAPROPERTIES:{
      ax = EquivalentDataProperties();
      break;
      }
    case DISJOINTDATAPROPERTIES:{
      ax = DisjointDataProperties();
      break;
      }
    case DATAPROPERTYRANGE:{
      ax = DataPropertyRange();
      break;
      }
    case DATAPROPERTYDOMAIN:{
      ax = DataPropertyDomain();
      break;
      }
    case FUNCTIONALDATAPROPERTY:{
      ax = FunctionalDataProperty();
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ax;
}

  final public OWLPropertyAxiom SubDataPropertyOf() throws ParseException {OWLDataPropertyExpression subProperty;
    OWLDataPropertyExpression superProperty;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(SUBDATAPROPERTYOF);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    subProperty = DataPropertyExpression();
    superProperty = DataPropertyExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLSubDataPropertyOfAxiom(subProperty, superProperty, axiomAnnos);
}

  final public OWLPropertyAxiom EquivalentDataProperties() throws ParseException {Set<OWLDataPropertyExpression> props;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(EQUIVALENTDATAPROPERTIES);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    props = DataPropertySet();
    jj_consume_token(CLOSEPAR);
return df.getOWLEquivalentDataPropertiesAxiom(props, axiomAnnos);
}

  final public OWLPropertyAxiom DisjointDataProperties() throws ParseException {Set<OWLDataPropertyExpression> props;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(DISJOINTDATAPROPERTIES);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    props = DataPropertySet();
    jj_consume_token(CLOSEPAR);
return df.getOWLDisjointDataPropertiesAxiom(props, axiomAnnos);
}

  final public Set<OWLDataPropertyExpression> DataPropertySet() throws ParseException {OWLDataPropertyExpression prop;
    Set<OWLDataPropertyExpression> props = new HashSet<OWLDataPropertyExpression>();
    prop = DataPropertyExpression();
props.add(prop);
    prop = DataPropertyExpression();
props.add(prop);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FULLIRI:
      case PNAME_LN:{
        ;
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        break label_12;
      }
      prop = DataPropertyExpression();
props.add(prop);
    }
return props;
}

  final public OWLPropertyAxiom DataPropertyDomain() throws ParseException {OWLDataPropertyExpression prop;
    OWLClassExpression domain;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(DATAPROPERTYDOMAIN);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = DataPropertyExpression();
    domain = ClassExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLDataPropertyDomainAxiom(prop, domain, axiomAnnos);
}

  final public OWLPropertyAxiom DataPropertyRange() throws ParseException {OWLDataPropertyExpression prop;
    OWLDataRange rng;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(DATAPROPERTYRANGE);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = DataPropertyExpression();
    rng = DataRange();
    jj_consume_token(CLOSEPAR);
return df.getOWLDataPropertyRangeAxiom(prop, rng, axiomAnnos);
}

  final public OWLPropertyAxiom FunctionalDataProperty() throws ParseException {OWLDataPropertyExpression prop;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(FUNCTIONALDATAPROPERTY);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = DataPropertyExpression();
    jj_consume_token(CLOSEPAR);
return df.getOWLFunctionalDataPropertyAxiom(prop, axiomAnnos);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Individual Axioms
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public 
OWLIndividualAxiom IndividualAxiom() throws ParseException {OWLIndividualAxiom ax;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SAMEINDIVIDUAL:{
      ax = SameIndividuals();
      break;
      }
    case DIFFERENTINDIVIDUALS:{
      ax = DifferentIndividuals();
      break;
      }
    case CLASSASSERTION:{
      ax = ClassAssertion();
      break;
      }
    case OBJECTPROPERTYASSERTION:{
      ax = ObjectPropertyAssertion();
      break;
      }
    case DATAPROPERTYASSERTION:{
      ax = DataPropertyAssertion();
      break;
      }
    case NEGATIVEOBJECTPROPERTYASSERTION:{
      ax = NegativeObjectPropertyAssertion();
      break;
      }
    case NEGATIVEDATAPROPERTYASSERTION:{
      ax = NegativeDataPropertyAssertion();
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ax;
}

  final public Set<OWLIndividual> IndividualSet() throws ParseException {OWLIndividual ind;
    Set<OWLIndividual> individuals = new HashSet<OWLIndividual>();
    ind = Individual();
individuals.add(ind);
    ind = Individual();
individuals.add(ind);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FULLIRI:
      case PNAME_LN:
      case NODEID:{
        ;
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        break label_13;
      }
      ind = Individual();
individuals.add(ind);
    }
return individuals;
}

  final public OWLIndividualAxiom SameIndividuals() throws ParseException {Set<OWLIndividual> individuals;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(SAMEINDIVIDUAL);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    individuals = IndividualSet();
    jj_consume_token(CLOSEPAR);
return df.getOWLSameIndividualAxiom(individuals, axiomAnnos);
}

  final public OWLIndividualAxiom DifferentIndividuals() throws ParseException {Set<OWLIndividual> individuals;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(DIFFERENTINDIVIDUALS);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    individuals = IndividualSet();
    jj_consume_token(CLOSEPAR);
return df.getOWLDifferentIndividualsAxiom(individuals, axiomAnnos);
}

  final public OWLIndividualAxiom ClassAssertion() throws ParseException {OWLIndividual ind;
    OWLClassExpression desc;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(CLASSASSERTION);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    desc = ClassExpression();
    ind = Individual();
    jj_consume_token(CLOSEPAR);
return df.getOWLClassAssertionAxiom(desc, ind, axiomAnnos);
}

  final public OWLIndividualAxiom ObjectPropertyAssertion() throws ParseException {OWLIndividual subj;
    OWLObjectPropertyExpression prop;
    OWLIndividual obj;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(OBJECTPROPERTYASSERTION);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    subj = Individual();
    obj = Individual();
    jj_consume_token(CLOSEPAR);
return df.getOWLObjectPropertyAssertionAxiom(prop, subj, obj, axiomAnnos);
}

  final public OWLIndividualAxiom NegativeObjectPropertyAssertion() throws ParseException {OWLIndividual subj;
    OWLObjectPropertyExpression prop;
    OWLIndividual obj;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(NEGATIVEOBJECTPROPERTYASSERTION);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = ObjectPropertyExpression();
    subj = Individual();
    obj = Individual();
    jj_consume_token(CLOSEPAR);
return df.getOWLNegativeObjectPropertyAssertionAxiom(prop, subj, obj, axiomAnnos);
}

  final public OWLIndividualAxiom DataPropertyAssertion() throws ParseException {OWLIndividual subj;
    OWLDataPropertyExpression prop;
    OWLLiteral obj;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(DATAPROPERTYASSERTION);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = DataPropertyExpression();
    subj = Individual();
    obj = Literal();
    jj_consume_token(CLOSEPAR);
return df.getOWLDataPropertyAssertionAxiom(prop, subj, obj, axiomAnnos);
}

  final public OWLIndividualAxiom NegativeDataPropertyAssertion() throws ParseException {OWLIndividual subj;
    OWLDataPropertyExpression prop;
    OWLLiteral obj;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(NEGATIVEDATAPROPERTYASSERTION);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = DataPropertyExpression();
    subj = Individual();
    obj = Literal();
    jj_consume_token(CLOSEPAR);
return df.getOWLNegativeDataPropertyAssertionAxiom(prop, subj, obj, axiomAnnos);
}

  final public OWLNamedIndividual IndividualIRI() throws ParseException {IRI iri;
    iri = IRI();
return df.getOWLNamedIndividual(iri);
}

  final public OWLIndividual Individual() throws ParseException {OWLIndividual ind;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FULLIRI:
    case PNAME_LN:{
      ind = IndividualIRI();
      break;
      }
    case NODEID:{
      ind = AnonymousIndividual();
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ind;
}

  final public OWLObjectProperty ObjectPropertyIRI() throws ParseException {IRI iri;
    iri = IRI();
return df.getOWLObjectProperty(iri);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Annotation Stuff
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public 
OWLAxiom AnnotationAxiom() throws ParseException {OWLAxiom axiom;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ANNOTATIONASSERTION:{
      axiom = AnnotationAssertion();
      break;
      }
    case ANNOTATIONPROPERTYDOMAIN:{
      axiom = AnnotationPropertyDomain();
      break;
      }
    case ANNOTATIONPROPERTYRANGE:{
      axiom = AnnotationPropertyRange();
      break;
      }
    case SUBANNOTATIONPROPERTYOF:{
      axiom = SubAnnotationPropertyOf();
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return axiom;
}

  final public OWLAnnotation Annotation() throws ParseException {OWLAnnotationProperty prop;
    OWLAnnotationValue val;
    Set<OWLAnnotation> annos = new HashSet<OWLAnnotation>();
    OWLAnnotation anno = null;
    jj_consume_token(ANNOTATION);
    jj_consume_token(OPENPAR);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ANNOTATION:{
        ;
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        break label_14;
      }
      anno = Annotation();
annos.add(anno);
    }
    prop = AnnotationPropertyIRI();
    val = AnnotationValue();
    jj_consume_token(CLOSEPAR);
return df.getOWLAnnotation(prop, val, annos);
}

  final public OWLAnnotationSubject AnnotationSubject() throws ParseException {OWLAnnotationSubject subj;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FULLIRI:
    case PNAME_LN:{
      subj = IRI();
      break;
      }
    case NODEID:{
      subj = AnonymousIndividual();
      break;
      }
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return subj;
}

  final public OWLAnnotationValue AnnotationValue() throws ParseException {OWLAnnotationValue value;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FULLIRI:
    case PNAME_LN:{
      value = IRI();
      break;
      }
    case NODEID:{
      value = AnonymousIndividual();
      break;
      }
    case STRINGLITERAL:{
      value = Literal();
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return value;
}

  final public Set<OWLAnnotation> AxiomAnnotationSet() throws ParseException {Set<OWLAnnotation> annos = null;
    OWLAnnotation anno;
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ANNOTATION:{
        ;
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        break label_15;
      }
      anno = Annotation();
if(annos == null) { annos = new HashSet<OWLAnnotation>(); }
        annos.add(anno);
    }
return annos  == null ? Collections.emptySet() : annos;
}

  final public OWLImportsDeclaration ImportsDeclaration() throws ParseException {IRI iri;
    jj_consume_token(IMPORT);
    jj_consume_token(OPENPAR);
    iri = IRI();
    jj_consume_token(CLOSEPAR);
return df.getOWLImportsDeclaration(iri);
}

  final public OWLAnnotationAssertionAxiom AnnotationAssertion() throws ParseException {OWLAnnotationProperty prop;
    OWLAnnotationSubject subj;
    OWLAnnotationValue val;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(ANNOTATIONASSERTION);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = AnnotationPropertyIRI();
    subj = AnnotationSubject();
    val = AnnotationValue();
    jj_consume_token(CLOSEPAR);
return df.getOWLAnnotationAssertionAxiom(prop, subj, val, axiomAnnos);
}

  final public OWLSubAnnotationPropertyOfAxiom SubAnnotationPropertyOf() throws ParseException {OWLAnnotationProperty subProp;
    OWLAnnotationProperty superProperty;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(SUBANNOTATIONPROPERTYOF);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    subProp = AnnotationPropertyIRI();
    superProperty = AnnotationPropertyIRI();
    jj_consume_token(CLOSEPAR);
return df.getOWLSubAnnotationPropertyOfAxiom(subProp, superProperty, axiomAnnos);
}

  final public OWLAnnotationPropertyDomainAxiom AnnotationPropertyDomain() throws ParseException {IRI domain;
    OWLAnnotationProperty prop;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(ANNOTATIONPROPERTYDOMAIN);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = AnnotationPropertyIRI();
    domain = IRI();
    jj_consume_token(CLOSEPAR);
return df.getOWLAnnotationPropertyDomainAxiom(prop, domain, axiomAnnos);
}

  final public OWLAnnotationPropertyRangeAxiom AnnotationPropertyRange() throws ParseException {IRI range;
    OWLAnnotationProperty prop;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(ANNOTATIONPROPERTYRANGE);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    prop = AnnotationPropertyIRI();
    range = IRI();
    jj_consume_token(CLOSEPAR);
return df.getOWLAnnotationPropertyRangeAxiom(prop, range, axiomAnnos);
}

  final public OWLHasKeyAxiom HasKey() throws ParseException {OWLClassExpression ce;
    OWLPropertyExpression prop;
    Set<OWLPropertyExpression> props = new HashSet<OWLPropertyExpression>();
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(HASKEY);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    ce = ClassExpression();
    jj_consume_token(OPENPAR);
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OBJECTINVERSEOF:
      case FULLIRI:
      case PNAME_LN:{
        ;
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        break label_16;
      }
      prop = ObjectPropertyExpression();
props.add(prop);
    }
    jj_consume_token(CLOSEPAR);
    jj_consume_token(OPENPAR);
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FULLIRI:
      case PNAME_LN:{
        ;
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        break label_17;
      }
      prop = DataPropertyExpression();
props.add(prop);
    }
    jj_consume_token(CLOSEPAR);
    jj_consume_token(CLOSEPAR);
return df.getOWLHasKeyAxiom(ce, props, axiomAnnos);
}

  final public OWLAxiom Declaration() throws ParseException {OWLEntity entity = null;
    IRI iri = null;
    OWLLiteral con = null;
    Set<OWLAnnotation> axiomAnnos;
    jj_consume_token(DECLARATION);
    jj_consume_token(OPENPAR);
    axiomAnnos = AxiomAnnotationSet();
    entity = Entity();
    jj_consume_token(CLOSEPAR);
return ignoreAnnotationsAndDeclarations? null: df.getOWLDeclarationAxiom(entity, axiomAnnos);
}

  final public OWLEntity Entity() throws ParseException {OWLEntity entity;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CLASS:{
      entity = Class();
      break;
      }
    case OBJECTPROP:{
      entity = ObjectProperty();
      break;
      }
    case DATAPROP:{
      entity = DataProperty();
      break;
      }
    case NAMEDINDIVIDUAL:{
      entity = NamedIndividual();
      break;
      }
    case DATATYPE:{
      entity = Datatype();
      break;
      }
    case ANNOTATIONPROPERTY:{
      entity = AnnotationProperty();
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return entity;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Data Stuff
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public 
OWLLiteral Literal() throws ParseException {boolean plain = true;
    String literal;
    OWLDatatype datatype = null;
    String lang = "";
    literal = QuotedString();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LANGIDENTIFIER:
    case DATATYPEIDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DATATYPEIDENTIFIER:{
        jj_consume_token(DATATYPEIDENTIFIER);
plain=false;
        datatype = DatatypeIRI();
        break;
        }
      case LANGIDENTIFIER:{
        jj_consume_token(LANGIDENTIFIER);
        lang = LangTag();
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
if(plain) { return df.getOWLLiteral(literal, lang); }
        // a float value in this syntax has an extra 'f' or 'F' character that must be removed to make a valid OWL literal
        if(datatype.isFloat() && (literal.endsWith("f")||literal.endsWith("F")) && !(literal.endsWith("inf")||literal.endsWith("INF"))){
            literal=literal.substring(0, literal.length()-1);
        }
        return df.getOWLLiteral(literal, datatype);
}

  final public String QuotedString() throws ParseException {Token t;
    t = jj_consume_token(STRINGLITERAL);
return EscapeUtils.unescapeString(t.image.substring(1, t.image.length() - 1));
}

  final public String LangTag() throws ParseException {Token t;
    t = jj_consume_token(PN_LOCAL);
return t.image;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Rules
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public 
SWRLRule DLSafeRule() throws ParseException {Set<OWLAnnotation> annos;
    SWRLAtom atom;
    Set<SWRLAtom> body;
    Set<SWRLAtom> head;
    jj_consume_token(DLSAFERULE);
    jj_consume_token(OPENPAR);
    annos = AxiomAnnotationSet();
    jj_consume_token(BODY);
body=new LinkedHashSet<SWRLAtom>();
    jj_consume_token(OPENPAR);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CLASSATOM:
      case DATARANGEATOM:
      case OBJECTPROPERTYATOM:
      case DATAPROPERTYATOM:
      case BUILTINATOM:
      case SAMEINDIVIDUALATOM:
      case DIFFERENTINDIVIDUALSATOM:{
        ;
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        break label_18;
      }
      atom = Atom();
body.add(atom);
    }
    jj_consume_token(CLOSEPAR);
    jj_consume_token(HEAD);
head= new LinkedHashSet<SWRLAtom>();
    jj_consume_token(OPENPAR);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CLASSATOM:
      case DATARANGEATOM:
      case OBJECTPROPERTYATOM:
      case DATAPROPERTYATOM:
      case BUILTINATOM:
      case SAMEINDIVIDUALATOM:
      case DIFFERENTINDIVIDUALSATOM:{
        ;
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        break label_19;
      }
      atom = Atom();
head.add(atom);
    }
    jj_consume_token(CLOSEPAR);
    jj_consume_token(CLOSEPAR);
return df.getSWRLRule(body, head, annos);
}

  final public SWRLAtom Atom() throws ParseException {SWRLAtom a;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CLASSATOM:{
      a = ClassAtom();
      break;
      }
    case DATARANGEATOM:{
      a = DataRangeAtom();
      break;
      }
    case OBJECTPROPERTYATOM:{
      a = ObjectPropertyAtom();
      break;
      }
    case DATAPROPERTYATOM:{
      a = DataPropertyAtom();
      break;
      }
    case BUILTINATOM:{
      a = BuiltInAtom();
      break;
      }
    case SAMEINDIVIDUALATOM:{
      a = SameIndividualAtom();
      break;
      }
    case DIFFERENTINDIVIDUALSATOM:{
      a = DifferentIndividualsAtom();
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return a;
}

  final public SWRLClassAtom ClassAtom() throws ParseException {OWLClassExpression ce;
    SWRLIArgument arg0;
    jj_consume_token(CLASSATOM);
    jj_consume_token(OPENPAR);
    ce = ClassExpression();
    arg0 = IArg();
    jj_consume_token(CLOSEPAR);
return df.getSWRLClassAtom(ce, arg0);
}

  final public SWRLDataRangeAtom DataRangeAtom() throws ParseException {OWLDataRange rng;
    SWRLDArgument arg0;
    jj_consume_token(DATARANGEATOM);
    jj_consume_token(OPENPAR);
    rng = DataRange();
    arg0 = DArg();
    jj_consume_token(CLOSEPAR);
return df.getSWRLDataRangeAtom(rng, arg0);
}

  final public SWRLObjectPropertyAtom ObjectPropertyAtom() throws ParseException {OWLObjectPropertyExpression prop;
    SWRLIArgument arg0;
    SWRLIArgument arg1;
    jj_consume_token(OBJECTPROPERTYATOM);
    jj_consume_token(OPENPAR);
    prop = ObjectPropertyExpression();
    arg0 = IArg();
    arg1 = IArg();
    jj_consume_token(CLOSEPAR);
return df.getSWRLObjectPropertyAtom(prop, arg0, arg1);
}

  final public SWRLDataPropertyAtom DataPropertyAtom() throws ParseException {OWLDataProperty prop;
    SWRLIArgument arg0;
    SWRLDArgument arg1;
    jj_consume_token(DATAPROPERTYATOM);
    jj_consume_token(OPENPAR);
    prop = DataPropertyIRI();
    arg0 = IArg();
    arg1 = DArg();
    jj_consume_token(CLOSEPAR);
return df.getSWRLDataPropertyAtom(prop, arg0, arg1);
}

  final public SWRLBuiltInAtom BuiltInAtom() throws ParseException {IRI iri;
    List<SWRLDArgument> args;;
    SWRLDArgument arg;
    jj_consume_token(BUILTINATOM);
    jj_consume_token(OPENPAR);
args=new ArrayList<SWRLDArgument>();
    iri = IRI();
    arg = DArg();
args.add(arg);
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRINGLITERAL:
      case VARIABLE:{
        ;
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        break label_20;
      }
      arg = DArg();
args.add(arg);
    }
    jj_consume_token(CLOSEPAR);
return df.getSWRLBuiltInAtom(iri, args);
}

  final public SWRLSameIndividualAtom SameIndividualAtom() throws ParseException {SWRLIArgument arg0;
    SWRLIArgument arg1;
    jj_consume_token(SAMEINDIVIDUALATOM);
    jj_consume_token(OPENPAR);
    arg0 = IArg();
    arg1 = IArg();
    jj_consume_token(CLOSEPAR);
return df.getSWRLSameIndividualAtom(arg0, arg1);
}

  final public SWRLDifferentIndividualsAtom DifferentIndividualsAtom() throws ParseException {SWRLIArgument arg0;
    SWRLIArgument arg1;
    jj_consume_token(DIFFERENTINDIVIDUALSATOM);
    jj_consume_token(OPENPAR);
    arg0 = IArg();
    arg1 = IArg();
    jj_consume_token(CLOSEPAR);
return df.getSWRLDifferentIndividualsAtom(arg0, arg1);
}

  final public SWRLIArgument IArg() throws ParseException {OWLNamedIndividual ind;
    SWRLIArgument arg;
    IRI iri;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VARIABLE:{
      jj_consume_token(VARIABLE);
      jj_consume_token(OPENPAR);
      iri = IRI();
      jj_consume_token(CLOSEPAR);
arg = df.getSWRLVariable(iri);
      break;
      }
    case FULLIRI:
    case PNAME_LN:{
      ind = IndividualIRI();
arg = df.getSWRLIndividualArgument(ind);
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return arg;
}

  final public SWRLDArgument DArg() throws ParseException {SWRLDArgument arg;
    OWLLiteral literal;
    IRI iri;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VARIABLE:{
      jj_consume_token(VARIABLE);
      jj_consume_token(OPENPAR);
      iri = IRI();
      jj_consume_token(CLOSEPAR);
arg = df.getSWRLVariable(iri);
      break;
      }
    case STRINGLITERAL:{
      literal = Literal();
arg = df.getSWRLLiteralArgument(literal);
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return arg;
}

  /** User defined Token Manager. */
  public TokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[49];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x0,0x0,0x1010000,0x1010000,0xfce40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0xfce40000,0xe40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c000000,0x1000000,0x0,0x800,0x1000000,0x0,0x0,0x2000000,0x180000,0x180000,0x0,0x0,0x0,0x800,0x0,0x800,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x12000,0x0,0x7ffe0e00,0x7ffe0e00,0x0,0x7ffe0e00,0x7ffe0e00,0x7ffe0e00,0xc1c0,0xc1c0,0xc1c0,0x1000,0xc1c0,0x0,0xc1c0,0xc1c0,0x0,0x12000,0x0,0x2000,0x1000,0x80001000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x2000000,0x0,0x0,0x0,0x0,0x1ffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ffffff,0x0,0xfff,0x0,0x0,0x0,0x3f000,0x0,0x1fc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x9000000,0x9000000,0x0,0x0,0x10,0x9000000,0x9000000,0x9000000,0x9000000,0x9000000,0x9000000,0x9000000,0x9000000,0x9000000,0x9000000,0x9000000,0x9000000,0x0,0x9000000,0x9000000,0x9000000,0x10,0x0,0x0,0x9000000,0x9000000,0x9000000,0x0,0x9000000,0x0,0x9000000,0x9000000,0x0,0x0,0x9000000,0x9000000,0x0,0x9000000,0x9000000,0x0,0x0,0x0,0x3f80,0x3f80,0x3f80,0x4000,0x9004000,0x4000,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}


  /** Constructor with user supplied Token Manager. */
  public OWLFunctionalSyntaxParser(TokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 49; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(TokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 49; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[130];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 49; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		   if ((jj_la1_4[i] & (1<<j)) != 0) {
			 la1tokens[128+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 130; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private int trace_indent = 0;
  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
