/*  Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * do something like opendir(), readdir(), closedir()
 *
 * Author: Juergen Nickelsen (Juergen.Nickelsen@cs.tu-berlin.de)
 *
 * $Header: afind.c[3.0] Tue Jun 29 16:37:58 1993 andy@cs.tu-berlin.de frozen $
 */

#include "atfs.h"
#include "rcs2atfs.h"
#include "functions.h"

/*
 * initializes reading files from the specified directory. f_state keeps
 * the status information needed by afind_read() and afind_close().
 */
int afind_init(dir, f_state)
char *dir ;
struct AFIND_STATE *f_state ;
{
    Af_attrs attrs ;
    int found ;
    
    af_initattrs(&attrs) ;
    attrs.af_gen = attrs.af_rev = AF_BUSYVERS ;
    strcpy(attrs.af_syspath, dir) ;
    found = af_find(&attrs, &f_state->set) ;
    f_state->counter = 0 ;

    return found ;
}

/*
 * returns a filename from the directory with which f_state was initialized.
 * the returned string is freeable. If all names have been read, NULL is
 * returned
 */
char *afind_read(f_state)
struct AFIND_STATE *f_state ;
{
    Af_key key ;

    if (f_state->counter >= af_nrofkeys(&f_state->set)) {
	return NULL ;
    }

    af_setgkey(&f_state->set, f_state->counter++, &key) ;
    return check_strdup(af_retattr (&key, AF_ATTUNIXNAME)); 
}

/*
 * completes reading files with afind, frees memory
 */
void afind_close(f_state)
struct AFIND_STATE *f_state ;
{
    af_dropset(&f_state->set) ;
#ifdef DEBUG
    bzero(f_state, sizeof(struct AFIND_STATE)) ;
#endif
}

/*EOF*/
